        /*var game = new Phaser.Game(window.innerWidth, window.innerHeight, Phaser.AUTO, '', {
            preload: preload,
            create: create,
            update: update
        });*/

        var player;
        var ground;
        var cubeAsset;
        var groundAsset;
        var cubes;
        var emitter;
        var spaceKey;
        var levelText;

        var h = 0;
        var groundHeight;
        var pipeHeight;
        var actorHeight;
        var start = true;
        var gamesPlayed = 0;

        function preload() {
            /*
            game.load.image('sky', 'assets/background.jpg');
            groundAsset = game.load.image('ground', 'assets/platform2.png');
            //game.load.image('cube', 'assets/cube.png');
            game.load.image('cube', 'assets/pipe.png');
            game.load.image('actor', 'assets/color_wheel.png');
            //game.load.image('actor', 'assets/cube.png');
            //game.load.image('pixel', 'assets/pixel.png');
            game.load.image('pixel', 'assets/color_pixel.png');
            
            game.load.audio('hit', ['assets/hit.mp3', 'assets/hit.ogg']);
		        game.load.audio('jump', ['assets/jump.mp3', 'assets/jump.ogg']);
            game.load.audio('music', ['assets/music.ogg']);
            */
            
        }

        

        function create() {
            kills = 0;
            
            groundHeight = game.cache.getImage('ground').height;
            pipeHeight = game.cache.getImage('pipe').height;
            actorHeight = game.cache.getImage('actor').height;
            
            //game.physics.startSystem(Phaser.Physics.ARCADE);
            setBackground();
            
            // Display buttons
            retrybutton = game.add.button(game.world.width - game.cache.getImage('retryButton').width / 2, game.cache.getImage('retryButton').height / 2 + 10, 'retryButton', retryLevel);
            retrybutton.anchor.setTo(0.5, 0.5);
            retrybutton.scale.x = 0.7;
            retrybutton.scale.y = 0.7;
    
            menubutton = game.add.button(game.world.width - game.cache.getImage('menuButton').width / 2 * 3, game.cache.getImage('menuButton').height / 2 + 10, 'menuButton', menuClicked);
            menubutton.anchor.setTo(0.5, 0.5);
            menubutton.scale.x = 0.7;
            menubutton.scale.y = 0.7;
            
            

            ground = game.add.sprite(0, game.world.height - groundHeight, 'ground');
            ground.scale.setTo(2, 2);
            game.physics.arcade.enable(ground);
            ground.body.immovable = true;

            initPlayer();

            cubes = game.add.group();
            cubes.createMultiple(20, 'pipe');
            game.physics.arcade.enable(cubes);

            emitter = game.add.emitter(0, 0, 200);
            emitter.makeParticles('pixel');
            emitter.gravity = 0;
            emitter.minParticleSpeed.setTo(-200, -200);
            emitter.maxParticleSpeed.setTo(200, 200);

            spaceKey = game.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);

            //levelText = game.add.text(16, 16, 'Level: ', { fontSize: '32px', fill: '#fff'});
            levelText = game.add.text(16, 16, 'Level: ', {font: '24px Comic', fill: '#fff'});
            levelText.setShadow(2, 2, 'rgba(0,0,0,0.5)', 1);
            //player.events.onOutOfBounds.add(goodbye, this);
            
            // Score
            
            scoreText = game.add.text(16, 16 + levelText.height, "Score: " + calculateScore(), {font: '18px Comic', fill: '#fff'});
            scoreText.setShadow(2, 2, 'rgba(0,0,0,0.5)', 1);
            //scoreText.anchor.setTo(0.5, 0.5);
            
            
            if(!isCordovaApp) {
                soundHit = game.add.audio('hit');
                soundJump = game.add.audio('jump');
            }
            
            loadLevel();
            
            if(start) {
                start = false;
            }

        }

       
        function update() {
            game.physics.arcade.collide(player, ground);

            game.physics.arcade.overlap(player, cubes, playerHit);

            if (player.body.touching.down) {
                player.body.velocity.x = 150;
                 //player.body.velocity.x = 130;
            }

            if (player.alive && !player.inWorld) {
                goodbye();
            }
            
           

            if (game.input.pointer1.isDown && player.body.touching.down) {
                // Do not fire if buttons are pressed
                buttonsRect = new Phaser.Rectangle(menubutton.x - menubutton.width / 2,
                                                   menubutton.y - menubutton.height / 2,
                                                   retrybutton.x + retrybutton.width / 2,
                                                   retrybutton.y + retrybutton.height /2);
                
                if(!buttonsRect.contains(game.input.pointer1.x, game.input.pointer1.y)) {
                    playerJump();
                }
            }
            else if(spaceKey.isDown && player.body.touching.down) {
                playerJump();
            }

            player.angle += 5;

        }

        function playerJump() {
            if(isMusicOn) {
                if(!isCordovaApp) {
                    soundJump.play('', 0, 0.1);
                }
                else {
                    soundJump.play();
                }
            }    
                
            player.body.velocity.x = 70;
            player.body.velocity.y = -170;
            var rotation = game.add.tween(player).to({
                angle: player.angle + 360
            }, 700, Phaser.Easing.Linear.None);
            rotation.start();
        }

        function playerHit() {
            //console.log("Hit!");
            kills++;
            player.kill();
            
            if(isMusicOn) {
                if(!isCordovaApp) {
                    soundHit.play('', 0, 0.2);
                }
                else {
                    soundHit.play();
                }
            }

            emitter.x = player.x + player.width / 2;
            emitter.y = player.y + player.height / 2;
            emitter.start(true, 300, null, 8);
            
            initPlayer();
        }

        function goodbye(obj) {
            //console.log("bye bye");
            player.kill();
            //loadLevel();
            //initPlayer();
            
            gamesPlayed++;

            // Show inerstitital
            if (window.plugins && window.plugins.AdMob) {
                if(gamesPlayed % adAfterEveryGames == 0 || adAfterEveryGames == 1) {
                    window.plugins.AdMob.showInterstitialAd(true,function(){ adShowing = true; },function(e){});
                }
            }

            game.state.start('Complete');
        }
         // -------------------   
        function loadLevel() {
            if(level == map.length) {
                level = 0;
            }
            
            //if (map.length == level) 
            //game.state.start('End');
            //else {
            //console.log("Level: " + level);
            levelText.text = 'Level: ' + (level + 1);
            
            drawLevel(map[level]);
            //level++;
            //labelLevel.content = this.level + '/' + map.length;
            //this.initPlayer();
            //}
            //if (this.level == 2) this.labelTuto.content = '';
        }
        
        function initPlayer() {
            //player = game.add.sprite(ground.height / 2, game.world.height - window.innerHeight * 2 / 3, 'cube');
            player = game.add.sprite(game.cache.getImage('actor').width / 2 + 2, game.world.height - game.world.height / 2, 'actor');
            game.physics.arcade.enable(player);
            player.body.bounce.y = 0.00;
            player.body.gravity.y = 200;
            player.anchor.setTo(0.5, 0.5);
            
            
        }

        function drawLevel(maap) {
            cubes.forEachAlive(function (cube) {
                cube.kill();
            });

            var cube, height;
            for (var i = 0; i < maap.length; i++) {
                cube = cubes.getFirstExists(false);
                /*
                if (maap[i] == 1) {
                    cube.reset(100 + i * cube.width, h * 2 / 3);
                    height = 0.3;
                } else if (maap[i] == 2) {
                    cube.reset(100 + i * cube.width, h * 2 / 3);
                    height = 1;
                } else if (maap[i] == 3) {
                    cube.reset(100 + i * cube.width, h * 2 / 3);
                    height = 1.5;
                } else if (maap[i] == 4) {
                    cube.reset(100 + i * cube.width, h * 2 / 3);
                    height = 1.8;
                } else if (maap[i] == 5) {
                    cube.reset(100 + i * cube.width, h * 2 / 3 - 22);
                    height = 0.5;
                }
              */
                
                orgMapValue = maap[i];
                baseMapValue = Math.floor(Math.abs(orgMapValue));

                var h = game.world.height - groundHeight;
                if (baseMapValue == 1) {
                    cube.reset( game.world.width / cubes.length + i * cube.width, h);
                    height = 0.3;
                } else if (baseMapValue == 2) {
                    cube.reset(game.world.width / cubes.length + i * cube.width, h);
                    height = 1;
                } else if (baseMapValue == 3) {
                    cube.reset(game.world.width / cubes.length + i * cube.width, h);
                    height = 1.5;
                } else if (baseMapValue == 4) {
                    cube.reset(game.world.width / cubes.length + i * cube.width, h);
                    height = 1.8;
                } else if (baseMapValue == 5) {
                    cube.reset(game.world.width / cubes.length + i * cube.width, h);
                    height = 2.2;
                } else if (baseMapValue == 6) {
                    cube.reset(game.world.width / cubes.length + i * cube.width, h - actorHeight -1);
                    height = 0.5;
                }
                
                scaleValue = Math.abs(orgMapValue) - baseMapValue;
               
                if(scaleValue > 0) {
                    width = orgMapValue > 0 ? scaleValue + 1 : scaleValue;
                    cube.anchor.setTo(0.5, 1);
                }
                else {
                    width = 1;
                    cube.anchor.setTo(0, 1);
                }          
                
                /*
                game.physics.arcade.enable(cube);
                cube.body.gravity.y = 0;
                cube.body.gravity.x = -100;
                */
                cube.body.moves = false;


                if (maap[i] != 0) {
                    cube.scale.y = 0;
                    cube.scale.x = width;
                    //cube.anchor.setTo(0, 1);

                    game.add.tween(cube.scale).to({
                        y: height
                    }, 300 * height, Phaser.Easing.Linear.None).start();
                }

            }
        }

        function render() {
           
        }
       

       Game.Play = function (game) {};
       Game.Play.prototype.preload = preload;
       Game.Play.prototype.create = create;
       Game.Play.prototype.update = update;
Game.Play.prototype.render = render;
       
