﻿( function( lib, img, cjs )
{

    var p; // shortcut to reference prototypes

    // stage content:
    ( lib.Clock = function()
    {
        this.initialize();

        var maskGraphics = new createjs.Graphics();
        var maskShape = new createjs.Shape( maskGraphics );
        maskShape.setTransform( 176, 135 );
        // clockFill
        this.fill = new lib.ClockFill();
        this.fill.setTransform( 176, 135 );
        this.fill.mask = maskShape;

        // background
        this.background = new lib.ClockBackground();
        this.background.setTransform( 179, 164.5 );

        var txtShadow = new createjs.Shadow( "#000", 0, 0, 3 );

        this.txtTime = new createjs.Text( "60", "40px Maagkramp", "#fff" );
        this.txtTime.textAlign = "center";
        this.txtTime.lineHeight = 42;
        this.txtTime.lineWidth = 268;
        this.txtTime.setTransform( 176, 135 - 21 );
        this.txtTime.shadow = txtShadow;
        

        this.txtScore = new createjs.Text( "0", "28px Maagkramp", "#fff" );
        this.txtScore.textAlign = "center";
        this.txtScore.lineHeight = 42;
        this.txtScore.lineWidth = 268;
        this.txtScore.setTransform( 176, 205 );
        this.txtScore.shadow = txtShadow;
        

        this.addChild( this.background, this.fill, this.txtTime, this.txtScore );

        this.fill = function( val )
        {
            maskGraphics.clear();

            maskGraphics.beginFill( 0x000000 );
            maskGraphics.moveTo( 0, 0 );

            for ( var i = 0; i <= ( 360 - 360 * val ) ; i++ )
            {
                var ang = Math.PI / 180 * ( i - 90 + Math.ceil( 360 * val ) );
                maskGraphics.lineTo( Math.cos( ang ) * 42, Math.sin( ang ) * 42 );
            }
            maskGraphics.lineTo( 0, 0 );
            maskGraphics.endFill();
        }

        this.setTime = function( t )
        {
            
            this.txtTime.text = t + "";
        }

        this.setScore = function( s )
        {
            this.txtScore.text = s + "";
        }


    } ).prototype = p = new createjs.Container();
    p.nominalBounds = new createjs.Rectangle( 0, 0, 358, 329 );


    // symbols:
    ( lib.clock_bg = function()
    {
        this.initialize( Images.getImage( "clock_bg" ) );
    } ).prototype = new createjs.Bitmap();
    p.nominalBounds = new createjs.Rectangle( 0, 0, 358, 329 );


    ( lib.clockFill = function()
    {
        this.initialize( Images.getImage( "clockFill" ) );
    } ).prototype = new createjs.Bitmap();
    p.nominalBounds = new createjs.Rectangle( 0, 0, 84, 84 );


    ( lib.ClockFill = function()
    {
        this.initialize();

        // Camada 1
        this.instance = new lib.clockFill();
        this.instance.setTransform( -41.9, -41.9 );

        this.addChild( this.instance );
    } ).prototype = p = new createjs.Container();
    p.nominalBounds = new createjs.Rectangle( -41.9, -41.9, 84, 84 );


    ( lib.ClockDummy = function()
    {
        this.initialize();

    } ).prototype = p = new createjs.Container();
    p.nominalBounds = new createjs.Rectangle( 0, 0, 0, 0 );


    ( lib.ClockBackground = function()
    {
        this.initialize();

        // Camada 1
        this.instance_1 = new lib.clock_bg();
        this.instance_1.setTransform( -178.9, -164.4 );

        this.addChild( this.instance_1 );
    } ).prototype = p = new createjs.Container();
    p.nominalBounds = new createjs.Rectangle( -178.9, -164.4, 358, 329 );

} )( lib = lib || {}, images = images || {}, createjs = createjs || {} );
var lib, images, createjs;