﻿( function( lib, img, cjs )
{
    var p; // shortcut to reference prototypes

    // stage content:
    ( lib.GameAssets = function()
    {
        this.initialize();

        // AnimCountdown
        this.countdown = new lib.AnimCountdown();
        this.countdown.setTransform( 0, 0 );

        // AnimEndGame
        this.jogoFim = new lib.AnimEndGame();

        this.addChild( this.jogoFim, this.countdown );
    } ).prototype = p = new createjs.Container();
    p.nominalBounds = new createjs.Rectangle( 52.1, 3.3, 856.4, 285.8 );

    // symbols:

    ( lib.SnowFlake = function()
    {
        this.initialize( Images.getImage(( "BmpSnowFlake" + ( Math.floor( Math.random() * 6 + 1 ) ) ) ) );
        var t = 0;

        this.windyMode = false;
        this.wind = 0;
        this.sx = Math.random() * 1 - .5;
        this.sy = Math.random() + .1;
        this.sr = Math.random() * 3 - 1.5;
        this.scaleX = this.scaleY = Math.random();

        this.onTick = function()
        {
            //this.sx *= .95;
            this.sy *= .95;
            this.sx += this.wind;
            this.sy += Tools.gravity.y / 20;
            this.x += this.sx + ( Tools.gravity.x * 3 );
            this.y += this.sy + Tools.gravity.y;
            this.rotation += this.sr;

            this.scaleX *= .999;
            this.scaleY = this.scaleX;

            if ( this.x > Images.canvas.width + 30 )
            {
                if ( this.windyMode ) this.destroy();
                else this.x = -20;
            }
            if ( this.x < -30 )
            {
                if ( this.windyMode ) this.destroy();
                else this.x = Images.canvas.width + 20;
            }

            if ( this.scaleX < .05 || this.y > Images.canvas.height + 30 )
            {
                this.destroy();
            }
        }

        this.setWindyMode = function()
        {
            this.windyMode = true;
            //this.sx += -( Math.random() * 10 + 40 );
        }

        this.destroy = function()
        {
            var index = Tools.flakes.indexOf( this );
            if ( this.parent && index > -1 )
            {
                this.parent.removeChild( this );
                Tools.flakes.splice( index, 1 );
            }
        }


    } ).prototype = new createjs.Bitmap();


    ( lib.anim_countdown_text_go = function()
    {
        this.initialize( Images.getImage( "anim_countdown_text_go" ) );
    } ).prototype = new createjs.Bitmap();


    ( lib.anim_countdown_text_ready = function()
    {
        this.initialize( Images.getImage( "anim_countdown_text_ready" ) );
    } ).prototype = new createjs.Bitmap();


    ( lib.anim_end_game_star_green = function()
    {
        this.initialize( Images.getImage( "anim_end_game_star_green" ) );
    } ).prototype = new createjs.Bitmap();


    ( lib.anim_end_game_star_yellow = function()
    {
        this.initialize( Images.getImage( "anim_end_game_star_yellow" ) );
    } ).prototype = new createjs.Bitmap();

    ( lib.anim_end_game_text = function()
    {
        this.initialize( Images.getImage( "anim_end_game_text" ) );
    } ).prototype = new createjs.Bitmap();


    ( lib.anim_end_game_text_mc = function()
    {
        this.initialize();

        // Layer 2
        this.instance = new lib.anim_end_game_text();
        this.instance.setTransform( 0, 0 );

        this.addChild( this.instance );
    } ).prototype = p = new createjs.Container();


    ( lib.anim_end_game_star_yellow_mc = function()
    {
        this.initialize();

        // Layer 2
        this.instance_1 = new lib.anim_end_game_star_yellow();
        this.instance_1.setTransform( -21.2, -22.7 );

        this.addChild( this.instance_1 );
    } ).prototype = p = new createjs.Container();


    ( lib.anim_end_game_star_green_mc = function()
    {
        this.initialize();

        // Layer 1
        this.instance_2 = new lib.anim_end_game_star_green();
        this.instance_2.setTransform( 0, 0 );

        this.addChild( this.instance_2 );
    } ).prototype = p = new createjs.Container();


    ( lib.anim_countdown_text_ready_mc = function()
    {
        this.initialize();

        // Layer 1
        this.instance_3 = new lib.anim_countdown_text_ready();
        this.instance_3.setTransform( -5.9, -3.9 );

        this.addChild( this.instance_3 );
    } ).prototype = p = new createjs.Container();


    ( lib.anim_countdown_text_go_mc = function()
    {
        this.initialize();

        // Layer 1
        this.instance_4 = new lib.anim_countdown_text_go();
        this.instance_4.setTransform( 0, 0 );

        this.addChild( this.instance_4 );
    } ).prototype = p = new createjs.Container();


    ( lib.AnimEndGame = function( mode, startPosition, loop )
    {
        this.initialize( mode, startPosition, loop, {}, true );

        // timeline functions:
        this.frame_0 = function()
        {
            this.stop();
        }
        this.frame_30 = function()
        {
            this.gotoAndPlay( 24 );
        }

        // actions tween:
        this.timeline.addTween( 
        		createjs.Tween.get( this )
        		.call( this.frame_0 )
        		.wait( 30 )
        		.call( this.frame_30 ) 
        		);
        
        var winW = Images.canvas.getAttribute("width");
        var winH = Images.canvas.getAttribute("height");
        var scales = Images.calculateScale();

        // Layer 1
        this.instance_5 = new lib.anim_end_game_text_mc( "synched", 0 );
        
        var width = this.instance_5.children[0].image.width * scales.x;
        var height = this.instance_5.children[0].image.height * scales.y
        
        this.instance_5.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_5 )
        			.to( { scaleX: scales.x, scaleY: scales.y }, 10 )
        			.to( { startPosition: 0 }, 20 )
        			.wait( 1 ) 
        		);

        // Layer 3
        this.instance_6 = new lib.anim_end_game_star_green_mc();
        
        width = this.instance_6.children[0].image.width * scales.x;
        height = this.instance_6.children[0].image.height * scales.y
        
        this.instance_6.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_6._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_6 )
        			.wait( 6 ).to( { _off: false }, 0 )
//        			.to( { 
//	        				scaleX: scales.x - (scales.x /10 ), 
//	        				rotation: 0, 
//	        				x: this.instance_6.x - (this.instance_6.x / 10), 
//	        				y: this.instance_6.y - (this.instance_6.y / 10) 
//	        			}, 8 )
//        			.wait( 4 ).to( { rotation: 90 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { rotation: 180 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { rotation: 0 }, 4, createjs.Ease.get( 1 ) )
        			.wait( 1 ) 
        		);

        // Layer 3
        this.instance_7 = new lib.anim_end_game_star_green_mc();
        
        width = this.instance_7.children[0].image.width * scales.x;
        height = this.instance_7.children[0].image.height * scales.y
        
        this.instance_7.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_7._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_7 )
	        		.wait( 6 )
	        		.to( { _off: false }, 0 )
//	        		.to( 
//	        				{   scaleX: scales.x / 2, 
//	        					scaleY: scales.y / 2, 
//	        					rotation: 45, 
//	        					x: this.instance_7.x - (this.instance_7.x / 10),
//	        					y: this.instance_7.y - (this.instance_7.y / 10)
//	        				}, 8 )
//	        		.wait( 4 )
//	        		.to( { rotation: 135 }, 4, createjs.Ease.get( 1 ) )
//	        		.to( { rotation: 225.1 }, 4, createjs.Ease.get( 1 ) )
//	        		.to( { rotation: 405 }, 4, createjs.Ease.get( 1 ) )
//	        		.wait( 1 ) 
        		);

        // Layer 3
        this.instance_8 = new lib.anim_end_game_star_yellow_mc( "synched", 0 );
        
        width = this.instance_8.children[0].image.width * scales.x;
        height = this.instance_8.children[0].image.height * scales.y
        
        this.instance_8.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_8._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_8 )
        			.wait( 6 )
        			.to( { startPosition: 0, _off: false }, 0 )
//        			.to( { scaleX: scales.x / 2, scaleY: scales.y / 2, skewX: 15, skewY: 195.1}, 8 )
//        			.to( { startPosition: 0 }, 4 )
//        			.to( { skewX: -74.8, skewY: 105 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { skewX: -164.8, skewY: 15 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { skewX: 15, skewY: -164.8 }, 2, createjs.Ease.get( 1 ) )
//        			.to( { skewX: -164.8, skewY: 15 }, 2, createjs.Ease.get( 1 ) )
//        			.wait( 1 ) 
        		);

        // Layer 3
        this.instance_9 = new lib.anim_end_game_star_yellow_mc( "synched", 0 );
        
        width = this.instance_9.children[0].image.width * scales.x;
        height = this.instance_9.children[0].image.height * scales.y
        
        this.instance_9.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_9._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_9 )
        			.wait( 6 )
        			.to( { startPosition: 0, _off: false }, 0 )
//        			.to( { scaleX: scales.x * 1.2, scaleY: scales.y * 1.2, skewX: 15, skewY: 195.1 }, 8 )
        			.to( { startPosition: 0 }, 4 )
//        			.to( { skewX: -74.8, skewY: 105 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { skewX: -164.8, skewY: 15 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { skewX: 15, skewY: -164.8 }, 2, createjs.Ease.get( 1 ) )
//        			.to( { skewX: -164.8, skewY: 15 }, 2, createjs.Ease.get( 1 ) )
//        			.wait( 1 ) 
        		);

        // Layer 3
        this.instance_10 = new lib.anim_end_game_star_green_mc( "synched", 0 );
        
        width = this.instance_10.children[0].image.width * scales.x;
        height = this.instance_10.children[0].image.height * scales.y
        
        this.instance_10.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_10._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_10 )
	        		.wait( 6 )
	        		.to( { startPosition: 0, _off: false }, 0 )
//	        		.to( { scaleX: scales.x * 0.9, rotation: -179.9}, 8 )
//  	      		.to( { startPosition: 0 }, 4 )
//      	  		.to( { rotation: -89.8 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { rotation: 0 }, 4, createjs.Ease.get( 1 ) )
//        			.to( { rotation: 180 }, 4, createjs.Ease.get( 1 ) )
//	        		.wait( 1 ) 
        		);

    } ).prototype = p = new createjs.MovieClip();


    ( lib.AnimCountdown = function( mode, startPosition, loop )
    {
        this.initialize( mode, startPosition, loop, {}, true );

        // timeline functions:
        this.frame_0 = function()
        {
            this.stop();
        }
        this.frame_98 = function()
        {
            this.stop();
            this.parent.removeChild( this );
        }

        // Scale
        var winW = Images.canvas.getAttribute("width");
        var winH = Images.canvas.getAttribute("height");
        var scales = Images.calculateScale();
        
        // actions tween:
        this.timeline.addTween( createjs.Tween.get( this ).call( this.frame_0 ).wait( 98 ).call( this.frame_98 ) );

        // bug
        this.shape = new createjs.Shape();
        this.shape.graphics.f( "rgba(255,255,255,0)" ).s().p( "AAyAAQAAAUgPAPQgPAPgUAAQgUAAgOgPQgPgPAAgUQAAgUAPgOQAOgPAUAAQAUAAAPAPQAPAOAAAUIAAAA" ).cp();
        this.shape.setTransform( 5, 5 );

        this.timeline.addTween( createjs.Tween.get( {} ).to( { state: [{ t: this.shape }] } ).wait( 99 ) );

        // ready
        this.instance_11 = new lib.anim_countdown_text_ready_mc();
        
        var width = this.instance_11.children[0].image.width * scales.x;
        var height = this.instance_11.children[0].image.height * scales.y
        
        this.instance_11.setTransform( 
        			(winW - width) / 2, 
        			(winH - height) / 2, 
        			scales.x, 
        			scales.y);

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_11 )
        			.to( { scaleX: scales.x - (scales.x / 10), scaleY: scales.y - (scales.y / 10) }, 7 )
        			.to( { scaleX: scales.x + (scales.x / 10), scaleY: scales.y + (scales.y / 10) }, 3 )
        			.to( { scaleX: scales.x, scaleY: scales.y }, 3 ).to( { _off: true }, 55 )
        			.wait( 31 ) 
        		);

        // go
        this.instance_12 = new lib.anim_countdown_text_go_mc();
        
        width = this.instance_12.children[0].image.width * scales.x;
        height = this.instance_12.children[0].image.height * scales.y
        
        this.instance_12.setTransform( 
    			(winW - width) / 2, 
    			(winH - height) / 2, 
    			scales.x, 
    			scales.y);
        this.instance_12._off = true;

        this.timeline.addTween( 
        		createjs.Tween.get( this.instance_12 )
        		.wait( 68 )
        		.to( { _off: false }, 0 )
        		.to( { scaleX: scales.x, scaleY: scales.y }, 4 )
        		.wait( 27 ) );
    } ).prototype = p = new createjs.MovieClip();

} )( lib = lib || {}, images = images || {}, createjs = createjs || {} );
var lib, images, createjs;