﻿( function( lib, img, cjs )
{

    var p; // shortcut to reference prototypes
    var scales;
    
    var winW;
    var winH;

    // stage content:
    ( lib.GameScreen = function()
    {
        this.initialize();
        
        winW = arguments[0];
        winH = arguments[1];
        scales = Images.calculateScale();
        // tableBg

        this.flakesContainer = new createjs.Container();

        this.contentContainer = new createjs.Container();

        this.tableBg = new lib.GameScreenTableBackground();
        this.tableBg.setTransform(winW/4.3, winH/5);
//        this.tableBg.setTransform(winW/3.85, winH/5.5);

        // buttons
        this.btnReset = new lib.GameScreenBtnReset();

        this.btnExit = new lib.GameScreenBtnExit();
		
		this.btnShutdown = new lib.GameScreenBtnShutdown();

        this.btnPlay = new lib.GameScreenBtnPlay();
        
        //this.btnFacebook = new lib.GameScreenBtnFacebook();

        // scoreBoard
        this.scoreBoard = new lib.GameScreenScoreBoard();

        // background
        this.background = new lib.GameScreenBackgroundBorder();

        // bearContainer
        this.bearContainer = new lib.dummy();

        // clockContainer
        this.clockContainer = new lib.dummy();
        this.clockContainer.setTransform( -(winW / 25), winH/15 , scales.x * 1.25, scales.y * 1.25);

        // picture
        this.picture = new lib.GameScreenPicture();
        this.countdownContainer = new createjs.Container();
        this.animContainer = new createjs.Container();
        
        this.addChild( this.picture, this.flakesContainer, this.contentContainer, this.background, this.countdownContainer, this.animContainer);
    } ).prototype = p = new cjs.Container();
    


    // symbols:
    ( lib.bg_border_bottom = function()
    {
        this.initialize( Images.getImage( "bg_border_bottom" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.bg_border_logo = function()
    {
        this.initialize( Images.getImage( "bg_border_logo" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.bg_border_side = function()
    {
        this.initialize( Images.getImage( "bg_border_side" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.bg_border_top_center = function()
    {
        this.initialize( Images.getImage( "bg_border_top_center" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.bg_border_top_side = function()
    {
        this.initialize( Images.getImage( "bg_border_top_side" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.bg_picture = function()
    {
        this.initialize( Images.getImage( "bg_picture" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.btn_play = function()
    {
        this.initialize( Images.getImage( "btn_play" ) );
    } ).prototype = new cjs.Bitmap();
    
	 ( lib.btn_shutdown = function()
    {
        this.initialize( Images.getImage( "btn_exit" ) );
    } ).prototype = new cjs.Bitmap();
    
    //( lib.btn_facebook = function()
    //{
    //    this.initialize( Images.getImage( "btn_facebook" ) );
    //} ).prototype = new cjs.Bitmap();
    

    ( lib.btn_exit = function()
    {
        this.initialize( Images.getImage( "btn_exit" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.btn_restart = function()
    {
        this.initialize( Images.getImage( "btn_restart" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.score_box = function()
    {
        this.initialize( Images.getImage( "score_box" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.table_bg = function()
    {
        this.initialize( Images.getImage( "table_bg" ) );
    } ).prototype = new cjs.Bitmap();
    


    ( lib.Symbol_1 = function()
    {
        this.initialize();

        // Camada 1
        this.instance = new lib.bg_border_top_side();

        this.addChild( this.instance );
    } ).prototype = p = new cjs.Container();
    


    ( lib.GameScreenBtnReset = function()
    {
        this.initialize();

        // Camada 1
        this.instance_1 = new lib.btn_restart();

        var imageWidth = this.instance_1.image.width * scales.x;
        var imageHeight = this.instance_1.image.height * scales.y;
        
        this.instance_1.setTransform(15, (winH / 2), scales.x * 0.88, scales.y * 0.88);

        this.addChild( this.instance_1 );
    } ).prototype = p = new cjs.Container();


    ( lib.GameScreenBtnPlay = function()
    {
        this.initialize();

        // Camada 1
        this.instance_2 = new lib.btn_play();
        this.instance_2.setTransform(0, 0, scales.x, scales.y);

        this.addChild( this.instance_2 );
    } ).prototype = p = new cjs.Container();
	
	( lib.GameScreenBtnShutdown = function()
    {
        this.initialize();

        // Camada 1
        this.instance = new lib.btn_shutdown();
         this.instance.setTransform(0, 0, scales.x * 1.30, scales.y * 1.30);

        //this.addChild( this.instance);
    } ).prototype = p = new cjs.Container();
    
   // ( lib.GameScreenBtnFacebook = function()
    //{
    //   this.initialize();

        // Camada 1
  //      this.instance = new lib.btn_facebook();

  //      this.instance.setTransform(0, 0, scales.x, scales.y);
        
        //this.addChild( this.instance );
  //  } ).prototype = p = new cjs.Container();

    ( lib.GameScreenBtnExit = function()
    {
        this.initialize();

        // Camada 1
        this.instance_3 = new lib.btn_exit();
		
		var imageWidth = this.instance_3.image.width * scales.x;
        var imageHeight = this.instance_3.image.height * scales.y;
		
		if(winH <= 320)
		{
			this.instance_3.setTransform( 20, 200, scales.x * 0.80, scales.y * 0.80);
		}
		else
		{
			this.instance_3.setTransform( 20, (winH / 2 + 80), scales.x * 0.80, scales.y * 0.80);
		}

        this.addChild( this.instance_3 );
    } ).prototype = p = new cjs.Container();


    ( lib.GameScreenBorderSide = function()
    {
        this.initialize();

        // Camada 1
        this.instance_3 = new lib.bg_border_side();
        
        this.addChild( this.instance_3 );
    } ).prototype = p = new cjs.Container();
    


    ( lib.GameScreenBorderBottom = function()
    {
        this.initialize();

        // Camada 1
        this.instance_4 = new lib.bg_border_bottom();
        
        this.addChild( this.instance_4 );
    } ).prototype = p = new cjs.Container();
    


    ( lib.dummy = function()
    {
        this.initialize();

        // Camada 1
        this.shape = new cjs.Shape();
        this.shape.graphics.f( "rgba(255,255,255,0)" ).s().p( "AAyAyIhjAAIAAhjIBjAAIAABj" ).cp();
        this.shape.setTransform( 0, 0 , scales.x, scales.y);

        this.addChild( this.shape );
    } ).prototype = p = new cjs.Container();
    


    ( lib.GameScreenScoreBoard = function()
    {
        this.initialize();

        // texts
        this.txtP3Name = new cjs.Text( "JOÃO", "20px Cartoonist", "#D4F5FB" );
        this.txtP3Name.textAlign = "left";
        this.txtP3Name.lineHeight = 22;
        this.txtP3Name.lineWidth = 91;
        this.txtP3Name.setTransform( 65, 287 - 107, scales.x, scales.y);

        this.txtP3Score = new cjs.Text( "1.500.000", "18px Cartoonist", "#FFFFFF" );
        this.txtP3Score.textAlign = "right";
        this.txtP3Score.lineHeight = 22;
        this.txtP3Score.lineWidth = 107;
        this.txtP3Score.setTransform( 260, 287 - 107, scales.x, scales.y);

        this.txtP2Name = new cjs.Text( "SILVA", "18px Cartoonist", "#D4F5FB" );
        this.txtP2Name.textAlign = "left";
        this.txtP2Name.lineHeight = 22;
        this.txtP2Name.lineWidth = 91;
        this.txtP2Name.setTransform( 65, 242 - 107, scales.x, scales.y);

        this.txtP2Score = new cjs.Text( "1.800.000", "18px Cartoonist", "#FFFFFF" );
        this.txtP2Score.textAlign = "right";
        this.txtP2Score.lineHeight = 22;
        this.txtP2Score.lineWidth = 107;
        this.txtP2Score.setTransform( 260, 242 - 107, scales.x, scales.y);

        this.txtP1Name = new cjs.Text( "maria", "18px Cartoonist", "#D4F5FB" );
        this.txtP1Name.textAlign = "left";
        this.txtP1Name.lineHeight = 22;
        this.txtP1Name.lineWidth = 91;
        this.txtP1Name.setTransform( 65, 198 - 107, scales.x, scales.y);

        this.txtP1Score = new cjs.Text( "2.000.000", "18px Cartoonist", "#FFFFFF" );
        this.txtP1Score.textAlign = "right";
        this.txtP1Score.lineHeight = 22;
        this.txtP1Score.lineWidth = 107;
        this.txtP1Score.setTransform( 260, 198 - 107, scales.x, scales.y);

        //this.txtBestName = new cjs.Text( "maria", "20px Cartoonist", "#D4F5FB" );
        //this.txtBestName.textAlign = "left";
        //this.txtBestName.lineHeight = 22;
        //this.txtBestName.lineWidth = 83;
        //this.txtBestName.setTransform( 64.5, 64.2 );

        //this.txtBestScore = new cjs.Text( "2.000.000", "25px Cartoonist", "#FFFFFF" );
        //this.txtBestScore.textAlign = "right";
        //this.txtBestScore.lineHeight = 27;
        //this.txtBestScore.lineWidth = 143;
        //this.txtBestScore.setTransform( 179.6, 62.2 );

        // background
        this.instance_5 = new lib.score_box();

//        this.addChild( this.instance_5, /*this.txtBestScore, this.txtBestName,*/ this.txtP1Score, this.txtP1Name, this.txtP2Score, this.txtP2Name, this.txtP3Score, this.txtP3Name );
    } ).prototype = p = new cjs.Container();
    


    ( lib.GameScreenPicture = function()
    {
        this.initialize();

        // Camada 1
        this.instance_6 = new lib.bg_picture();
        
        // Calculating image width with the new scale
        var imageWidth = scales.x * this.instance_6.image.width;
        
        // Setting image to top left and scaled
        this.instance_6.setTransform(0, 0, scales.x, scales.y);
        
        this.addChild( this.instance_6 );
    } ).prototype = p = new cjs.Container();

    ( lib.GameScreenBackgroundBorderTop = function()
    {
        this.initialize();

        // logo
        this.instance_7 = new lib.bg_border_logo();
        var imageWidth = this.instance_7.image.width*scales.x;
        var imageHeight = this.instance_7.image.height*scales.y;
        this.instance_7.setTransform( (winW - imageWidth) / 2, imageHeight / 4, scales.x, scales.y);

        // bg
        this.instance_8 = new lib.bg_border_top_center();
        imageWidth = this.instance_8.image.width * scales.x;
        this.instance_8.setTransform( (winW / 2) + imageWidth, 0, scales.x, scales.y, 0, 0, 180);

        this.instance_9 = new lib.bg_border_top_center();
        this.instance_9.setTransform( (winW / 2) - imageWidth, 0 , scales.x, scales.y);
        
        this.addChild( this.instance_8, this.instance_9, this.instance_7 );
    } ).prototype = p = new cjs.Container();


    ( lib.GameScreenTableBackground = function()
    {
        this.initialize();

        // particlesContainer
        this.particlesContainer = new lib.dummy();
        this.particlesContainer.setTransform(0, 0, scales.x * 1.75, scales.y * 1.75);
//        this.particlesContainer.setTransform(winW/26, winH/18, scales.x, scales.y);

        // container
        this.container = new lib.dummy();
//        this.container.setTransform( winW/26, winH/18 , scales.x * 2, scales.y * 2);
        this.container.setTransform( 0, 0 , scales.x * 1.75, scales.y * 1.75);

        var g = new createjs.Graphics();
        g.beginFill( 0xFFFFFF );
        g.drawRect( 0, 0, 10 * 55, 8 * 55 );
        g.endFill();
        var tableMask = new createjs.Shape( g );
        tableMask.setTransform(0, 0, scales.x * 1.75, scales.y * 1.75);
        this.container.mask = tableMask;

        // image
        this.borderAnimation = new lib.BorderAnimation();
        this.borderAnimation.setTransform( 0, 0, scales.x, scales.y );

//        this.countdownContainer = new createjs.Container();
        this.addChild(  this.container, this.particlesContainer);
//        this.addChild( this.borderAnimation, this.container, this.particlesContainer, this.countdownContainer, this.animContainer );

    } ).prototype = p = new createjs.Container();


    ( lib.GameScreenBorderTopSide = function()
    {
        this.initialize();

        // Camada 1
        this.instance_11 = new lib.Symbol_1();
        this.instance_11.setTransform( 0, 0, scales.x, scales.y);

        this.addChild( this.instance_11 );
    } ).prototype = p = new cjs.Container();


    ( lib.GameScreenBackgroundBorderSide = function()
    {
        this.initialize();

        // Camada 2
        

        this.top_1 = new lib.GameScreenBorderTopSide();
        
        this.side = new lib.GameScreenBorderSide();
        
        var topHeight = this.top_1.children[0].children[0].image.height * scales.y;
        this.side.setTransform(0, topHeight, scales.x, scales.y);
        
        this.bottom = new lib.GameScreenBorderBottom();
        
        var sideHeight = this.side.children[0].image.height * scales.y;
        this.bottom.setTransform( 0, topHeight + sideHeight, scales.x, scales.y);

        this.addChild(this.bottom, this.side, this.top_1);
    } ).prototype = p = new cjs.Container();

    ( lib.GameScreenBackgroundBorder = function()
    {
        this.initialize();

        // top
        this.top = new lib.GameScreenBackgroundBorderTop();
        this.top.setTransform(0, 0);

        // right
        this.right = new lib.GameScreenBackgroundBorderSide();
        this.right.setTransform(winW, 0, 1, 1, 0, 0, 180 );

        // left
        this.left = new lib.GameScreenBackgroundBorderSide();
        
        this.addChild( this.left, this.right, this.top );
    } ).prototype = p = new cjs.Container();

} )( lib = lib || {}, images = images || {}, createjs = createjs || {} );
var lib, images, createjs;