﻿( StarParticles = function ()
{
    var arr = new Array();
    var container;

    this.init = function ( cont )
    {
        container = cont;
    }

    this.createParticle = function ( x, y, speed, angle, amount )
    {
        speed = speed || 0;
        angle = angle || 0;
        amount = amount || 1;
        for ( var i = 0; i < amount; i++ )
        {
            var sp = new createjs.Point( Math.cos( angle ) * speed, Math.sin( angle ) * speed );
            var c = new StarParticle( 1.5 + Math.random() * .3, x + ( Math.random() * 40 ) - 20, y + ( Math.random() * 40 ) - 20, sp );
            container.addChild( c );
            arr.push( c );
        }
    }

    this.getLength = function ()
    {
        return arr.length;
    }

    this.update = function ( context2d )
    {
        for ( var i = 0; i < arr.length; i++ )
        {
            var o = arr[i];
            o.rotation += o.rs;
            o.x += o.sX;
            o.y += o.sY;

            if ( o.size > 0.05 )
            {
                o.size *= .95;
            }
            else
            {
                if ( o.parent )
                {
                    o.parent.removeChild( o );
                }
                arr.splice( i, 1 );
                i--;
            }
            o.scaleX = o.scaleY = ( o.size  );
            o.alpha = o.a;
        }

    }

} );

( StarParticle = function ( _size, _x, _y, _sp )
{
    this.size = 1;
    this.sX = 0;
    this.sY = 0;
    this.a = 1;

    this.init = function ( size, x, y, sp )
    {
        this.size = size;
        this.x = x;
        this.y = y;
        this.sX = sp.x;
        this.sY = sp.y;
        this.rs = Math.random() * 4 - 2;
        this.image = Images.getImage( Images.PARTICLE_STAR );
        this.sourceRect = new createjs.Rectangle( 0, 0, this.image.naturalWidth, this.image.naturalHeight );
        this.regX = this.image.naturalWidth /2 ;
        this.regY = this.image.naturalHeight /2;
    }

    this.init( _size, _x, _y, _sp );
} ).prototype = new createjs.Bitmap();






( BubbleParticles = function ()
{
    var arr = new Array();
    var container;

    this.init = function ( cont )
    {
        container = cont;
    }

    this.createParticle = function ( _size, _x, _y, _sp, _color )
    {
        var c = new BubbleParticle( _size, _x, _y, _sp, _color );
        container.addChild( c );
        arr.push( c );
    }

    this.getLength = function ()
    {
        return arr.length;
    }

    this.update = function ()
    {
        for ( var i = 0; i < arr.length; i++ )
        {
            var o = arr[i];
            //o.sx *= .9;
            //o.sy *= .9;
            o.sy += .5;
            o.x += o.sx;
            o.y += o.sy;
            o.a -= .03;

            if ( o.size > 0.05 )
            {
                if ( o.size >= .3 && Math.random() > .8 )
                {
                    if ( o.parent )
                    {
                        o.parent.removeChild( o );
                    }
                    arr.splice( i, 1 );
                    i--;
                    this.createParticle( o.size * .8, o.x, o.y, new createjs.Point( o.sx + ( Math.random() * 4 - 2 ), o.sy + ( Math.random() * 4 - 2 ) ), o.color );
                    this.createParticle( o.size * .8, o.x, o.y, new createjs.Point( o.sx + ( Math.random() * 4 - 2 ), o.sy + ( Math.random() * 4 - 2 ) ), o.color );
                }
                else
                {
                    //Images.draw( Images.getImage( Images.PARTICLE_BUBBLE ), m, new createjs.Point( 15, 15 ) );
                    o.size *= .94;
                }
            }
            else
            {
                if ( o.parent )
                {
                    o.parent.removeChild( o );
                }
                arr.splice( i, 1 );
                i--;
            }
            o.scaleX = o.scaleY = (o.size*1.5);
            o.alpha = o.a;
        }
    }

} );

( BubbleParticle = function ( _size, _x, _y, _sp, _color )
{
    this.size = 1;
    this.sx = 0;
    this.sy = 0;
    this.a = 1;

    this.init = function ( size, x, y, sp, color )
    {
        var g = new createjs.Graphics();
        g.beginFill( color );
        g.drawCircle( 0, 0, 40 );
        g.endFill();
        this.initialize( g );
        this.size = size;
        this.x = x;
        this.y = y;
        this.sx = sp.x;
        this.sy = sp.y;
        this.color = color;
        //this.image = Images.getImage( Images.PARTICLE_BUBBLE );
        //this.sourceRect = new createjs.Rectangle( 0, 0, this.image.naturalWidth, this.image.naturalHeight );
    }

    this.init( _size, _x, _y, _sp, _color );

} ).prototype = new createjs.Shape();