﻿var PowerUP = new PowerUp();

( Jewel = function()
{
    this.size = 55;
    this.sSleeping = false;
    this.speed = new createjs.Point();
    this.icoFalling = false;
    this.isTimer = false;
    this.ground = new createjs.Point();
    this.gForce = .9;
    this.icoPos = new createjs.Point();
    this.icoSquash = 0;
    this.icoSpeed = new createjs.Point();
    this.shineFrame = 0;
    this._flash = 0;
    this.infected = false;
    this.type = 0;
    this.spriteRect = new createjs.Rectangle( 0, 0, this.size, this.size );;
    this.powerUp = null;
    this.superPower = 0;
    this.powerUpId = 0;
    this.desaturation = 0;

    this.bmpFlash = null;
    this.bmpJewel = null;

    this.init = function( $type, $powerUp )// = null )
    {
        this.spriteRect = new createjs.Rectangle( 0, 0, this.size, this.size );
        this.bmpJewel = new createjs.Bitmap();
        //this.addChild( this.bmpJewel );

        this.bmpFlash = new createjs.Bitmap( Images.getImage( Images.FLASH_JEWELS ) );

        this.type = $type;
        this.setPowerUp( $powerUp );
        //this.image = Images.getImage( Images.JEWELS_TABLE );
    }

    this.setSheet = function( spriteSheet )
    {
        this.image = spriteSheet;
        this.sourceRect = this.spriteRect;
    }

    this.calcRect = function()
    {
        var px = 0;
        var py = this.type - 1;

        if ( this.hasSuperPower() )
        {

            if ( this.superPower >= 1 && this.superPower <= 4 )
            {
                px = ( this.superPower - 1 ) + ( this.powerUp.level - 1 ) * 4;
                this.powerUpId = PowerUP.POWERUPUNIDIRECIONAL;
            }
            else if ( this.superPower >= 5 && this.superPower <= 6 )
            {
                px = ( this.superPower - 1 - 4 ) + ( this.powerUp.level - 1 ) * 2;
                this.powerUpId = PowerUP.POWERUPBIDIRECIONAL
            }
            else if ( this.superPower == 7 )
            {
                px = ( this.superPower - 1 - 6 ) + ( this.powerUp.level - 1 );
                this.powerUpId = PowerUP.POWERUPCROSS;
            }
            else if ( this.superPower >= 8 && this.superPower <= 11 )
            {
                px = ( this.superPower - 1 - 7 ) + ( this.powerUp.level - 1 ) * 4;
                this.powerUpId = PowerUP.POWERUPLWAVE;
            }
            else if ( this.superPower >= 12 && this.superPower <= 13 )
            {
                px = ( this.superPower - 1 - 11 ) + ( this.powerUp.level - 1 ) * 2;
                this.powerUpId = PowerUP.POWERUPESPIRAL;
            }
            else if ( this.superPower == 14 )
            {
                px = ( this.superPower - 1 - 13 ) + ( this.powerUp.level - 1 );
                this.powerUpId = PowerUP.POWERUPMAGNET;
            }

            //trace( "px :: " + px );
        }
        else
        {
            if ( this.isTimer && this.desaturation == 0 ) px = 9;
            else if ( this.desaturation >= .02 ) px = this.isTimer ? 10 : 7;
            else if ( this.desaturation > 0 ) px = this.isTimer ? 11 : 8;
            else if ( this.icoSquash >= .8 ) px = 6;
            else if ( this.icoSquash >= .5 ) px = 5;
            else if ( this.icoSquash >= .1 ) px = 4;
            else if ( this.icoPos.y <= -9 ) px = 3;
            else if ( this.icoPos.y <= -6 ) px = 2;
            else if ( this.icoPos.y <= -3 ) px = 1;
        }

        this.spriteRect.x = px * this.size;
        this.spriteRect.y = py * this.size;

    }

    this.setPowerUp = function( $val, $pos )// = null )
    {
        this.powerUp = $val;
        if ( this.powerUp == null )
        {
            this.superPower = 0;
        }
        else
        {
            this.superPower = this.powerUp.getRandomSuperPower( $pos )
        }
    }

    this.consumePowerUp = function()
    {
        this.setPowerUp( null );
        this.infected = true;
    }

    this.hasSuperPower = function()
    {
        var ret = ( this.superPower != 0 && this.superPower != undefined );
        return ret;
    }

    this.desaturate = function()
    {
        this.desaturation = 1;
    }

    this.flash = function()
    {
        this._flash = 1;
        if( this.parent ) this.parent.addChild( this.bmpFlash );

    }

    this.flashPower = function()
    {
        return this._flash;
    }

    this.info = function()
    {
        return { x: this.x, y: this.y, sx: this.speed.x, sy: this.speed.y, tmr: this.isTimer, t: this.type, sp: this.superPower, spl: this.hasSuperPower() ? this.powerUp.level : 0 };
    }

    this.update = function()
    {
        if ( this._flash > 0 )
        {
            this._flash *= .91;
            if ( this._flash < 0.01 )
            {
                this._flash = 0;
                if ( this.bmpFlash.parent )
                {
                    this.bmpFlash.parent.removeChild( this.bmpFlash )
                }
            }
            this.bmpFlash.alpha = this._flash;

        }

        if ( this.desaturation > 0 )
        {
            this.desaturation *= .9;
            if ( this.desaturation < 0.01 ) this.desaturation = 0;
        }

        if ( this.icoSquash > 0 )
        {
            this.icoSquash *= .6;
            if ( this.icoSquash < 0.01 ) this.icoSquash = 0;
        }

        if ( this.shineFrame > 0 ) this.shineFrame++;
        if ( this.shineFrame >= 16 ) this.shineFrame = 0;

        this.icoFalling = this.icoSpeed.y > 0;

        this.icoSpeed.y += this.gForce - this.speed.y / 2;

        this.speed.y += this.gForce;

        this.y += this.speed.y;
        this.icoPos.y += this.icoSpeed.y;


        if ( this.icoPos.y < -10 )
        {
            this.icoSpeed.y = 0;
            this.icoFalling = false;
            this.icoPos.y = -10;
        }

        if ( this.icoPos.y > 0 )
        {
            this.icoPos.y = 0;
            if ( this.icoFalling )
            {
                this.icoFalling = false;
                this.icoSquash = 1;
            }
            this.icoSpeed.y = 0;
        }

        if ( this.y > this.ground.y )
        {
            if ( this.speed.y > 7 ) GameSounds.playDrop();
            this.speed.y *= -.15;
            this.y = this.ground.y;
        }

        if ( Math.abs( this.speed.y ) < .5 && this.y == this.ground.y )
        {
            this.speed.y = 0;
            this.isSleeping = true;
        }
        else
        {
            this.isSleeping = false;
        }

        this.bmpFlash.x = this.x;
        this.bmpFlash.y = this.y;
        this.calcRect();

    }

    this.destroy = function()
    {
        if ( this.parent )
        {
            this.parent.removeChild( this );
        }
        if ( this.bmpFlash.parent )
        {
            this.bmpFlash.parent.removeChild( this.bmpFlash );
        }
    }

} ).prototype = new createjs.Bitmap();