﻿
( Tools = new function()
{
    this.gravity = new createjs.Point();
    this.flakes = new Array();

    this.rankingFile = null;

    this.ranking = new function()
    {
        var myThis = this;

        this.lastScore = 0;

        this.firstName = "ANA";
        this.firstScore = 100000;

        this.secondName = "PAULO";
        this.secondScore = 50000;

        this.thirdName = "VALDSON";
        this.thirdScore = 10000;

        this.checkPostion = function( score )
        {
            if ( score > this.firstScore ) return 1;
            else if ( score > this.secondScore ) return 2;
            else if ( score > this.thirdScore ) return 3;
            else return 0;
        }

        this.writeScore = function( score, name )
        {
            if ( score > this.firstScore )
            {
                onGetFirst();
                this.firstName = name;
                this.firstScore = score;
            }
            else if ( score > this.secondScore )
            {
                onGetSecond();
                this.secondName = name;
                this.secondScore = score;
            }
            else if ( score > this.thirdScore )
            {
                this.thirdName = name;
                this.thirdScore = score;
            }
        }

        function onGetFirst()
        {
            onGetSecond();
            myThis.secondName = myThis.firstName;
            myThis.secondScore = myThis.firstScore;
        }

        function onGetSecond()
        {
            myThis.thirdName = myThis.secondName;
            myThis.thirdScore = myThis.secondScore;
        }
        

        this.getData = function()
        {
            return JSON.stringify( { firstName: this.firstName,
                                     firstScore: this.firstScore,
                                     secondName: this.secondName,
                                     secondScore: this.secondScore,
                                     thirdName: this.thirdName,
                                     thirdScore: this.thirdScore
                                   } );
        }

        this.setData = function( strData )
        {
            var dt = JSON.parse( strData );

            this.firstName = dt.firstName;
            this.firstScore = dt.firstScore;
            this.secondName = dt.secondName;
            this.secondScore = dt.secondScore;
            this.thirdName = dt.thirdName;
            this.thirdScore = dt.thirdScore;
        }

    }

    this.jewels = new Object();

    this.formatVal = function( val )
    {
        var str = val.toString();
        var ret = "";
        var count = 0;

        for ( var i = str.length - 1; i >= 0; i-- )
        {
            ret = str.charAt( i ) + ret;
            count++;
            count %= 3;
            if ( i > 0 && count == 0 ) ret = "." + ret;

        }
        return ret;
    }

    this.formatTime = function( secs )
    {
        var s = secs / 60;
        return this.lPad( Math.floor( secs / 60 ), 2 ) + ":" + this.lPad( secs % 60, 2 );
    }

    this.objDateTime = function( secs )
    {
        var ret = {};
        ret.d = this.lPad(( secs / 86400 ), 2 );
        ret.h = this.lPad(( secs % 86400 ) / 3600, 2 );
        ret.m = this.lPad(( secs % 3600 ) / 60, 2 );
        ret.s = this.lPad( secs % 60, 2 );
        return ret;
    }

    this.lPad = function( val, minSize )
    {
        var ret = val + "";
        while ( ret.length < minSize )
        {
            ret = "0" + ret;
        }
        return ret;
    }

    this.getNow = function()
    {
        return ( new Date().getTime() );
    }

    this.getDistance = function( $p1, $p2 )
    {
        var c1 = $p1.x - $p2.x;
        var c2 = $p1.y - $p2.y;
        return Math.sqrt( c1 * c1 + c2 * c2 );
    }

    this.clickFeedback = function( btn )
    {
        TweenLite.to( btn, .5, { scaleX: btn.scaleX, scaleY: btn.scaleY, ease: Elastic.easeOut } );
        btn.scaleX *= .7;
        btn.scaleY *= .7;
    }

    this.offsetColor = function( c, offset, offsetAlpha )
    {
        var oc = extractColor( c );

        if ( offsetAlpha ) oc.a = Math.max( 0, Math.min( 255, oc.a + offset ) );
        oc.r = Math.max( 0, Math.min( 255, oc.r + offset ) );
        oc.g = Math.max( 0, Math.min( 255, oc.g + offset ) );
        oc.b = Math.max( 0, Math.min( 255, oc.b + offset ) );

        return colorToHEX( ( oc.a << 24 ) | ( oc.r << 16 ) | ( oc.g << 8 ) | oc.b );
    }

    function extractColor( c )
    {
        var oc = {};
        oc.a = ( ( c >> 24 ) & 0xFF );
        oc.r = ( ( c >> 16 ) & 0xFF );
        oc.g = ( ( c >> 8 ) & 0xFF );
        oc.b = ( c & 0xFF );
        return oc;
    }

    function colorToHEX( c )
    {
        var oc = extractColor( c );
        return "#" + Tools.lPad( oc.r.toString( 16 ), 2 ) + Tools.lPad( oc.g.toString( 16 ), 2 ) + Tools.lPad( oc.b.toString( 16 ), 2 );
    }

    this.getSnowFlake = function()
    {
        var ret = new lib.SnowFlake();
        ret.regX = ret.image.naturalWidth / 2;
        ret.regY = ret.image.naturalHeight / 2;
        return ret;
    }
} );

( Color32 = function( _color )
{
    this._color;
    this._A;
    this._R;
    this._G;
    this._B;

    this.init = function( color )
    {
        this.color = color;
    }

    this.setColor = function( val )
    {

        _color = val;

        var _tc = _color;

        _A = _tc >> 24 & 0xFF;
        _R = _tc >> 16 & 0xFF;
        _G = _tc >> 8 & 0xFF;
        _B = _tc & 0xFF;

    }

    this.getColor = function()
    {
        return _color;
    }

    this.setA = function( val )
    {
        this._A = val;
        this.recalc();
    }
    this.getA = function()
    {
        return this._A;
    }

    this.setR = function( val )
    {
        _R = val;
        this.recalc();
    }
    this.getR = function()
    {
        return this._R;
    }

    this.setG = function( val )
    {
        _G = val;
        this.recalc();
    }
    this.getG = function()
    {
        return this._G;
    }

    this.setB = function( val )
    {
        _B = val;
        this.recalc();
    }
    this.getB = function()
    {
        return this._B;
    }

    this.getGrayTone = function()
    {
        return int(( _R + _G + _B ) / 3 );
    }

    this.brighter = function( offset )
    {
        var ret = this.clone();

        ret.A = Math.min( 255, A + offset );
        ret.R = Math.min( 255, R + offset );
        ret.G = Math.min( 255, G + offset );
        ret.B = Math.min( 255, B + offset );

        return ret;
    }

    this.darker = function( offset )
    {
        var ret = this.clone();

        ret.A = Math.max( 0, A - offset );
        ret.R = Math.max( 0, R - offset );
        ret.G = Math.max( 0, G - offset );
        ret.B = Math.max( 0, B - offset );

        return ret;
    }

    this.recalc = function()
    {
        this.color = _A << 24 | _R << 16 | _G << 8 | _B;
    }

    this.merge = function( c )
    {
        this.color = ( ( _A + c.A ) / 2 ) << 24 | ( ( _R + c.R ) / 2 ) << 16 | ( ( _G + c.G ) / 2 ) << 8 | ( ( _B + c.B ) / 2 );
    }

    this.compare = function( c )
    {
        return ( Math.abs( c.A - _A ) + Math.abs( c.R - _R ) + Math.abs( c.G - _G ) + Math.abs( c.B - _B ) ) / 4;
    }

    this.clone = function()
    {
        return new Color32( this.color );
    }

    this.toString = function()
    {
        return this.color.toString( 16 );
    }

    this.init( _color );
} );

( Images = new function()
{
    this.canvas = null;
    this.context = null;
    
    this.scaleX = null;
    this.scaleY = null;

    this.FROZEN_JEWELS = "BmpFrozenJewel";
    this.FLASH_JEWELS = "BmpJewelFlash";
    this.JEWELS_TABLE = "JEWELS_TABLE";
    this.JEWELS_UNIDIRETIONAL = "JEWELS_UNIDIRETIONAL";
    this.JEWELS_BIDIRETIONAL = "JEWELS_BIDIRETIONAL";
    this.JEWELS_SPIRAL = "JEWELS_SPIRAL";
    this.JEWELS_L = "JEWELS_L";
    this.JEWELS_MAGNET = "JEWELS_MAGNET";
    this.JEWELS_CROSS = "JEWELS_CROSS";
    this.PARTICLE_STAR = "PARTICLE_STAR";
    this.PARTICLE_BUBBLE = "PARTICLE_BUBBLE";
    this.HOME_LOGO = "HOME_LOGO";

    var _repository = new Object();

    this.getImage = function( imgId )
    {
        return _repository[imgId];
    }

    this.setImage = function( img, id )
    {
        _repository[id] = img;
    }

    this.draw = function( src, matrix, pivot )
    {
        pivot = pivot || new createjs.Point();
        this.context.save();
        this.context.transform( matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx, matrix.ty );
        this.context.drawImage( src, -pivot.x, -pivot.y );
        this.context.restore();
    }
    
    this.calculateScale = function() {
    	if (!this.scaleX || !this.scaleY) {
    		
    		var winW = Images.canvas.getAttribute("width");
        	var winH = Images.canvas.getAttribute("height");
        	var maxW = Images.canvas.getAttribute("maxWidth");
        	var maxH = Images.canvas.getAttribute("maxHeight");
        	
        	this.scaleX = winW/maxW;
        	this.scaleY = winH/maxH;
    	}
    	return {x: this.scaleX, y: this.scaleY};
    }
    
} );

( GameSounds = new function()
{
    var isPlayingBGM = false;
    var lastDrop = Tools.getNow();

    this.playBgMusic = function()
    {
        if ( !isPlayingBGM )
        {
            isPlayingBGM = true;
            createjs.SoundJS.setVolume( 1, "SndBGMMain" );
            createjs.SoundJS.play( "SndBGMMain", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, -1 );
        }
    }

    this.fadeOutBGM = function()
    {
        obj = { vol: 1, id: "SndBGMMain" };
        TweenLite.to( obj, 1, {
            vol: 0,
            onUpdate: this.updateVolume, onUpdateParams: [obj], onUpdateScope: this,
            onComplete: this.stopBgMusic, onCompleteScope: this
        } );

    }

    this.updateVolume = function( obj )
    {
        createjs.SoundJS.setVolume( obj.vol, obj.id );
    }

    this.stopBgMusic = function()
    {
        isPlayingBGM = false;
        createjs.SoundJS.stop( "SndBGMMain" );
    }

    this.playReady = function()
    {
        //window.Debug.writeln( "SND READY: " + Tools.getNow() );
        createjs.SoundJS.play( "SndReady", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playGo = function()
    {
        //window.Debug.writeln( "SND GO: " + Tools.getNow() );
        createjs.SoundJS.play( "SndGo", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playGameOver = function()
    {
        createjs.SoundJS.play( "SndEndGame", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playCandypotHit = function()
    {
        createjs.SoundJS.setVolume( 1, "SndCandypotHit" );
        createjs.SoundJS.play( "SndCandypotHit", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playFreeze = function()
    {
        createjs.SoundJS.play( "SndFreeze", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playPowerUpCreated = function()
    {
        createjs.SoundJS.play( "SndPowerUpCreated", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playClockCreated = function()
    {
        createjs.SoundJS.play( "SndClockCreated", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playPowerUp = function()
    {
        //createjs.SoundJS.play( "", SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playComboLost = function()
    {
        createjs.SoundJS.play( "SndComboLost", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playHitCombo = function( hitCount )
    {
        createjs.SoundJS.play( "SndHitCombo" + Tools.lPad( hitCount, 2 ), createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playCombination = function( comboMult )
    {
        createjs.SoundJS.play( "SndHit" + Tools.lPad( comboMult, 2 ), createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playTimeOver3 = function()
    {
        createjs.SoundJS.play( "SndTimeOver3", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playTimeOver10 = function()
    {
        createjs.SoundJS.play( "SndTimeOver10", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playFireworks = function()
    {
        createjs.SoundJS.setVolume( .5, "SndCandypotHit" );
        createjs.SoundJS.play( "SndCandypotHit", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.stopFireworks = function()
    {
        createjs.SoundJS.stop( "SndCandypotHit" );
    }
    
    this.playHighScore = function()
    {
        createjs.SoundJS.play( "SndHighscore", createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
    }

    this.playDrop = function()
    {
        if ( ( Tools.getNow() - lastDrop ) < 100 ) return;
        var rnd = Math.floor( Math.random() * 3 ) + 1
        createjs.SoundJS.play( "SndDrop0" + rnd, createjs.SoundJS.INTERRUPT_EARLY, 0, 0, 0 );
        lastDrop = Tools.getNow();
    }

} );

( Utils = new function()
{
    this.mainfest = [

                    //SCORE SCREENS
                    { src: "images/RankingScoreTextsBmp.png", id: "RankingScoreTextsBmp" },
		            { src: "images/RankinScore_btn_close.png", id: "RankinScore_btn_close" },
		            { src: "images/RankinScore_btn_ok.png", id: "RankinScore_btn_ok" },
		            { src: "images/Record_bg.png", id: "Record_bg" },
		            { src: "images/Record_btn_ok.png", id: "Record_btn_ok" },
		            { src: "images/Record_txt_title.png", id: "Record_txt_title" },
		            { src: "images/RecordScoreBg.png", id: "RecordScoreBg" },
		            { src: "images/ScoreNormalBackground.png", id: "ScoreNormalBackground" },
		            { src: "images/ScoreNormalBanner.png", id: "ScoreNormalBanner" },
		            { src: "images/ScoreNormalScoreShadow.png", id: "ScoreNormalScoreShadow" },
		            { src: "images/ScoreNormalTexts.png", id: "ScoreNormalTexts" },
		            { src: "images/vcficou.png", id: "vcficou" },

                    //START-END ANIMATIONS
                    { src: "images/anim_countdown_text_go.png", id: "anim_countdown_text_go" },
		            { src: "images/anim_countdown_text_ready.png", id: "anim_countdown_text_ready" },
		            { src: "images/anim_end_game_star_green.png", id: "anim_end_game_star_green" },
		            { src: "images/anim_end_game_star_yellow.png", id: "anim_end_game_star_yellow" },
		            { src: "images/anim_end_game_text.png", id: "anim_end_game_text" },

                    //BORDER
                    { src: "images/BorderBlueElements.png", id: "BorderBlueElements" },
		            { src: "images/BorderIce.png", id: "BorderIce" },
		            { src: "images/BorderPart_1.png", id: "BorderPart_1" },
		            { src: "images/BorderPart_10.png", id: "BorderPart_10" },
		            { src: "images/BorderPart_11.png", id: "BorderPart_11" },
		            { src: "images/BorderPart_2.png", id: "BorderPart_2" },
		            { src: "images/BorderPart_3.png", id: "BorderPart_3" },
		            { src: "images/BorderPart_4.png", id: "BorderPart_4" },
		            { src: "images/BorderPart_5.png", id: "BorderPart_5" },
		            { src: "images/BorderPart_6.png", id: "BorderPart_6" },
		            { src: "images/BorderPart_7.png", id: "BorderPart_7" },
		            { src: "images/BorderPart_8.png", id: "BorderPart_8" },
		            { src: "images/BorderPart_9.png", id: "BorderPart_9" },
		            { src: "images/BorderWhiteElements.png", id: "BorderWhiteElements" },
                    { src: "images/BorderBg.png", id: "BorderBg" },

                    //SMALL SCREEN
                    { src: "images/dock_small_bear.png", id: "dock_small_bear" },
		            { src: "images/dock_small_bg.jpg", id: "dock_small_bg" },
		            { src: "images/dock_small_title.png", id: "dock_small_title" },
                    { src: "images/jewels.png", id: "jewels" },
                    { src: "images/bear.png", id: "bear" },

                    //GAME SCREEN
                    { src: "images/bg_border_bottom.png", id: "bg_border_bottom" },
                    { src: "images/bg_border_logo.png", id: "bg_border_logo" },
                    { src: "images/bg_border_side.png", id: "bg_border_side" },
                    { src: "images/bg_border_top_center.png", id: "bg_border_top_center" },
                    { src: "images/bg_border_top_side.png", id: "bg_border_top_side" },
                    { src: "images/bg_picture.jpg", id: "bg_picture" },
                    { src: "images/btn_play.png", id: "btn_play" },
                    { src: "images/btn_facebook.png", id: "btn_facebook" },
                    { src: "images/btn_exit.png", id: "btn_exit" },
                    { src: "images/btn_restart.png", id: "btn_restart" },
                    { src: "images/score_box.png", id: "score_box" },
                    { src: "images/table_bg.png", id: "table_bg" },
                    { src: "images/clock_bg.png", id: "clock_bg" },
                    { src: "images/home_logo.png", id: Images.HOME_LOGO },

                    //JEWELS
		            { src: "images/table_bg.png", id: "table_bg" },
                    { src: "images/table_0.png", id: Images.JEWELS_TABLE },
                    { src: "images/table_1.png", id: Images.JEWELS_UNIDIRETIONAL },
                    { src: "images/table_2.png", id: Images.JEWELS_L },
                    { src: "images/table_3.png", id: Images.JEWELS_SPIRAL },
                    { src: "images/table_4.png", id: Images.JEWELS_MAGNET },
                    { src: "images/BmpFrozenJewel.png", id: Images.FROZEN_JEWELS },
		            { src: "images/BmpJewelFlash.png", id: Images.FLASH_JEWELS },
                    { src: "images/BmpParticleStar.png", id: Images.PARTICLE_STAR },
                    { src: "images/BmpBubble.png", id: Images.PARTICLE_BUBBLE },

                    //SNOWFLAKES
                    { src: "images/BmpSnowFlake1.png", id: "BmpSnowFlake1" },
		            { src: "images/BmpSnowFlake2.png", id: "BmpSnowFlake2" },
		            { src: "images/BmpSnowFlake3.png", id: "BmpSnowFlake3" },
		            { src: "images/BmpSnowFlake4.png", id: "BmpSnowFlake4" },
		            { src: "images/BmpSnowFlake5.png", id: "BmpSnowFlake5" },
		            { src: "images/BmpSnowFlake6.png", id: "BmpSnowFlake6" },

                    //SOUNDS
                    { src: "sounds/SndBGMMain.ogg", id: "SndBGMMain" },
                    { src: "sounds/SndCandypotHit.mp3", id: "SndCandypotHit" },
                    { src: "sounds/SndClockCreated.mp3", id: "SndClockCreated" },
                    { src: "sounds/SndComboLost.mp3", id: "SndComboLost" },
                    { src: "sounds/SndEndGame.mp3", id: "SndEndGame" },
                    { src: "sounds/SndFreeze.mp3", id: "SndFreeze" },
                    { src: "sounds/SndPowerUpCreated.mp3", id: "SndPowerUpCreated" },
                    { src: "sounds/SndReady.mp3", id: "SndReady" },
                    { src: "sounds/SndGo.mp3", id: "SndGo" },
                    { src: "sounds/SndHighscore.mp3", id: "SndHighscore" },
                    { src: "sounds/SndFireworks.mp3", id: "SndFireworks" },


                    { src: "sounds/SndDrop01.mp3", id: "SndDrop01" },
                    { src: "sounds/SndDrop02.mp3", id: "SndDrop02" },
                    { src: "sounds/SndDrop03.mp3", id: "SndDrop03" },
                    { src: "sounds/SndHit01.mp3", id: "SndHit01" },
                    { src: "sounds/SndHit02.mp3", id: "SndHit02" },
                    { src: "sounds/SndHit03.mp3", id: "SndHit03" },
                    { src: "sounds/SndHit04.mp3", id: "SndHit04" },
                    { src: "sounds/SndHit05.mp3", id: "SndHit05" },
                    { src: "sounds/SndHit06.mp3", id: "SndHit06" },
                    { src: "sounds/SndHit07.mp3", id: "SndHit07" },
                    { src: "sounds/SndHit08.mp3", id: "SndHit08" },
                    { src: "sounds/SndHit09.mp3", id: "SndHit09" },
                    { src: "sounds/SndHit10.mp3", id: "SndHit10" },
                    { src: "sounds/SndHitCombo01.mp3", id: "SndHitCombo01" },
                    { src: "sounds/SndHitCombo02.mp3", id: "SndHitCombo02" },
                    { src: "sounds/SndHitCombo03.mp3", id: "SndHitCombo03" },
                    { src: "sounds/SndHitCombo04.mp3", id: "SndHitCombo04" },
                    { src: "sounds/SndHitCombo05.mp3", id: "SndHitCombo05" },
                    { src: "sounds/SndHitCombo06.mp3", id: "SndHitCombo06" },
                    { src: "sounds/SndHitCombo07.mp3", id: "SndHitCombo07" },
                    { src: "sounds/SndHitCombo08.mp3", id: "SndHitCombo08" },
                    { src: "sounds/SndHitCombo09.mp3", id: "SndHitCombo09" },
                    { src: "sounds/SndHitCombo10.mp3", id: "SndHitCombo10" },
                    { src: "sounds/SndTimeOver10.mp3", id: "SndTimeOver10" },
                    { src: "sounds/SndTimeOver3.mp3", id: "SndTimeOver3" },
    ];
} );

( ScoreData = function( score )
{
    this.score = score;
    this.position;
} )
