var currentCandy = currentLocation = "";
var currentCandyPrice = 0;
var refreshTable = true;
var showLsOffer = true;
var totalCash = 25;
var totalDebt = 32;
var howMany = 0;
var lsHowMuch = 0;
var totalAfford = 0;
var totalHave = 0;
var backpackCapacity = 20;
var minsLeft = 30;
var licoriceInBp = gummybearsInBp = gumballsInBp = jellybeansInBp = caramelsInBp = chocolatesInBp = 0;
var licoricePrice = gummybearsPrice = gumballsPrice = jellybeansPrice = caramelsPrice = chocolatesPrice = 0;
var locationsList, individualLocation, buy, sell, loanShark;
var totalInBackpack = jellybeansInBp + gummybearsInBp + gumballsInBp + licoriceInBp + caramelsInBp + chocolatesInBp;

$(document).ready(function() {
	locationsList = $('#locationslist');
	individualLocation = $('#individuallocation');
	buy = $('#buy');
	sell = $('#sell');
	loanShark = $('#loanshark');
	
	$('#totalcash').text(totalCash);
	$('#totaldebt').text(totalDebt);
	$('#totalinbackpack').text(totalInBackpack);
	$('#backpackcapacity').text(backpackCapacity);
	$('#minsleft').text(minsLeft);
	
	$('#locationslist li').click(openLocation);
	$('#olsok').click(function() {
		$('#offerloanshark').hide();
		totalCash -= totalDebt;
		totalDebt = 0;
		$('#totalcash').text(totalCash);
		$('#totaldebt').text(totalDebt);
	});
	$('#olsno').click(function() {
		$('#offerloanshark').hide();
	});
	$('#caughtok').click(function() {
		$('#caught').hide();
	});
	$('#yesbuybackpack').click(buyBiggerBackpack);
	$('#nobuybackpack').click(function(){
		$('#buybackpack').hide();
	});
	
	$('#individuallocation').remove();
	$('#buy').remove();
	$('#sell').remove();
	$('#loanshark').remove();

});

function openLocationsList() {
	currentLocation = "";
	refreshTable = true;
	showLsOffer = true;
	minsLeft -= 1;
	totalDebt = parseInt(totalDebt * 1.15);
	
	if (minsLeft == 5) timeWarning();
	if (minsLeft == 0) endGame();
	
	$('#minsleft').text(minsLeft);
	$('#totaldebt').text(totalDebt);

	$('body').append(locationsList);
	$('#locationslist li').click(openLocation);
	
	goToPanel('locationslist');
}

function openLocation(e) {
	if (currentLocation == "") {
		currentLocation = e.target.firstChild.nodeValue;
	}
	currentCandy = "";
	
	$('body').append(individualLocation);
	$('#individuallocation h1').text(currentLocation);
	if (refreshTable == true) populateCandyPrices();
	populateAmountsInBackpack();
	$('#totalcash').text(totalCash);
	$('#totalinbackpack').text(totalInBackpack);
	$('.selected').each(function() {
			$(this).removeClass('selected');
	});
	
	$('#travelbutton').click(openLocationsList);
	$('#individuallocation td.candyname').click(assignCurrentCandy);
		
	goToPanel('individuallocation');
	
	if ( (refreshTable == true) && (currentLocation != 'Swings') ) randomEncounter();
	
	if ( (currentLocation == 'Swings') && (showLsOffer == true) && (totalDebt > 0) && (totalCash >= totalDebt) ) offerLoanShark();
}

function openBuy() {
	if ( (currentCandy != "") && (currentCandy != 'undefined') && (currentCandy != null) ) {
		howMany = 0;
		refreshTable = false;
		var totalValue = 0;
		
		$('body').append(buy);
		$('#buy .candyname').text(currentCandy);
		$('#totalafford').text(totalAfford);
		$('#buy .howmany').text(howMany);
		$('#buy .total').text(totalValue);

		$('#buynvm').click(openLocation);
		$('#buyok').click(buyCandy);
		$('#buy .less').click(function() {
			if (howMany > 0) {
				howMany -= 1;
				totalValue = howMany * currentCandyPrice;
				if (howMany > 0) $('#buyok').addClass('selected');
				if (howMany < 1) $('#buyok').removeClass('selected');
			}
			$('#buy .howmany').text(howMany);
			$('#buy .total').text(totalValue);
		});
		$('#buy .more').click(function() {
			if ( (howMany < (backpackCapacity - totalInBackpack) ) && (howMany < totalAfford) ) {
				howMany += 1;
				totalValue = howMany * currentCandyPrice;
				$('#buyok').addClass('selected');
			}
			$('#buy .howmany').text(howMany);
			$('#buy .total').text(totalValue);
		});
		$('#buy .max').click(function() {
			if ( totalAfford > (backpackCapacity - totalInBackpack) ) {
				howMany = (backpackCapacity - totalInBackpack);
			} else {
				howMany = totalAfford;
			}
			totalValue = howMany * currentCandyPrice;
			$('#buy .howmany').text(howMany);
			$('#buy .total').text(totalValue);
			$('#buyok').addClass('selected');
		});
		
		goToPanel('buy');
	}
}

function openSell() {
	if ( (currentCandy != "") && (currentCandy != 'undefined') && (currentCandy != null) ) {
		howMany = 0;
		refreshTable = false;
		var totalValue = 0;
		
		$('body').append(sell);
		$('#sell .candyname').text(currentCandy);
		$('#sell .howmany').text(howMany);
		$('#totalindividualcandyinbp').text(totalHave);
		$('#sell .total').text(totalValue);
		
		$('#sellnvm').click(openLocation);
		$('#sellok').click(sellCandy);
		$('#sell .less').click(function() {
			if (howMany > 0) {
				howMany -= 1;
				totalValue = howMany * currentCandyPrice;
			}
			$('#sell .howmany').text(howMany);
			$('#sell .total').text(totalValue);
			if (howMany > 0) $('#sellok').addClass('selected');
			if (howMany < 1) $('#sellok').removeClass('selected');
		});
		$('#sell .more').click(function() {
			if (howMany < totalHave) {
				howMany += 1;
				totalValue = howMany * currentCandyPrice;
				$('#sellok').addClass('selected');
			}
			$('#sell .howmany').text(howMany);
			$('#sell .total').text(totalValue);
		});
		$('#sell .max').click(function() {
			howMany = totalHave;
			totalValue = howMany * currentCandyPrice;
			$('#sell .howmany').text(howMany);
			$('#sell .total').text(totalValue);
			$('#sellok').addClass('selected');
		});
		
		goToPanel('sell');
	}
}

function goToPanel(panelId) {

	window.location.hash = panelId;
	$('div').each(function() {
		if ( $(this).attr('id') != panelId) {
			$(this).remove();
		}
	});	

/*

	$('html, body').animate({scrollTop: $('#' + panelId).offset().top}, 1000, function() {
		$('div').each(function() {
			if ( $(this).attr('id') != panelId) {
				$(this).remove();
			}
		});
	});

*/

}


function assignCurrentCandy(e) {
	var currentCandyId = "";
	
	currentCandy = e.target.firstChild.nodeValue;
	console.log('currentCandy: ' + currentCandy);
	
	if (currentCandy == 'Jelly Beans') currentCandyId = 'jellybeans';
	if (currentCandy == 'Gummy Bears') currentCandyId = 'gummybears';
	if (currentCandy == 'Gumballs') currentCandyId = 'gumballs';
	if (currentCandy == 'Licorice') currentCandyId = 'licorice';
	if (currentCandy == 'Caramels') currentCandyId = 'caramels';
	if (currentCandy == 'Chocolates') currentCandyId = 'chocolates';
	
	currentCandyPrice = $('#' + currentCandyId + ' .candyprice').text();
	currentCandyPrice = parseInt( currentCandyPrice.substring(0, (currentCandyPrice.length - 1) ) );
	console.log('currentCandyPrice: ' + currentCandyPrice);
	
	totalAfford = Math.floor(totalCash / currentCandyPrice);
	console.log('totalAfford: ' + totalAfford);
	
	if (currentCandy == 'Jelly Beans') totalHave = jellybeansInBp;
	if (currentCandy == 'Gummy Bears') totalHave = gummybearsInBp;
	if (currentCandy == 'Gumballs') totalHave = gumballsInBp;
	if (currentCandy == 'Licorice') totalHave = licoriceInBp;
	if (currentCandy == 'Caramels') totalHave = caramelsInBp;
	if (currentCandy == 'Chocolates') totalHave = chocolatesInBp;
	
	console.log('totalHave: ' + totalHave);
	
	$('.selected').each(function() {
			$(this).removeClass('selected');
	});
	$('#' + currentCandyId).addClass('selected');
	
	if (currentCandyPrice <= totalCash) {
		$('#buybutton').addClass('selected');
		$('#buybutton').click(openBuy);
	}
	
	if (totalHave > 0) {
		$('#sellbutton').addClass('selected');
		$('#sellbutton').click(openSell);
	}
	
}

function populateCandyPrices() {
	$('#candytable .candyprice').each(function() {
		$(this).empty();
		$(this).append('&cent;');
	});
	
	jellybeansPrice = 1 + Math.floor(Math.random() * 10);
	gummybearsPrice = 3 + Math.floor(Math.random() * 15);
	gumballsPrice = 10 + Math.floor(Math.random() * 25);
	licoricePrice = 15 + Math.floor(Math.random() * 30);
	caramelsPrice = 25 + Math.floor(Math.random() * 75);
	chocolatesPrice = 50 + Math.floor(Math.random() * 105);
	
	if ( (currentLocation == 'Slide') && ( 25 >= Math.floor(Math.random() * 100) ) ) {
		caramelsPrice = Math.floor(caramelsPrice * 1.5);
		licoricePrice = Math.floor(licoricePrice * 1.5);
		gumballsPrice = Math.floor(gumballsPrice * 2);
	}
	
	if ( (currentLocation == 'Sandbox') && ( 35 >= Math.floor(Math.random() * 100) ) ) {
		jellybeansPrice = Math.floor(jellybeansPrice / 2);
		if (jellybeansPrice == 0) jellybeansPrice = 1;
	}
	
	$('#jellybeans .candyprice').prepend(jellybeansPrice);
	$('#gummybears .candyprice').prepend(gummybearsPrice);
	$('#gumballs .candyprice').prepend(gumballsPrice);
	$('#licorice .candyprice').prepend(licoricePrice);
	$('#caramels .candyprice').prepend(caramelsPrice);
	$('#chocolates .candyprice').prepend(chocolatesPrice);

}

function populateAmountsInBackpack() {
	$('#jellybeans .inbackpack').text(jellybeansInBp);
	$('#gummybears .inbackpack').text(gummybearsInBp);
	$('#gumballs .inbackpack').text(gumballsInBp);
	$('#licorice .inbackpack').text(licoriceInBp);
	$('#caramels .inbackpack').text(caramelsInBp);
	$('#chocolates .inbackpack').text(chocolatesInBp);
}

function buyCandy() {
	if (howMany > 0) {
		if (currentCandy == 'Jelly Beans') jellybeansInBp += howMany;
		if (currentCandy == 'Gummy Bears') gummybearsInBp += howMany;
		if (currentCandy == 'Gumballs') gumballsInBp += howMany;
		if (currentCandy == 'Licorice') licoriceInBp += howMany;
		if (currentCandy == 'Caramels') caramelsInBp += howMany;
		if (currentCandy == 'Chocolates') chocolatesInBp += howMany;
		
		totalCash -= (howMany * currentCandyPrice);
		totalInBackpack += howMany;
		
		openLocation();
	}
}

function sellCandy() {
	if (howMany > 0) {
		if (currentCandy == 'Jelly Beans') jellybeansInBp -= howMany;
		if (currentCandy == 'Gummy Bears') gummybearsInBp -= howMany;
		if (currentCandy == 'Gumballs') gumballsInBp -= howMany;
		if (currentCandy == 'Licorice') licoriceInBp -= howMany;
		if (currentCandy == 'Caramels') caramelsInBp -= howMany;
		if (currentCandy == 'Chocolates') chocolatesInBp -= howMany;
		
		totalCash += (howMany * currentCandyPrice);
		totalInBackpack -= howMany;
		
		openLocation();
	}
}

function offerLoanShark() {
	showLsOffer = false;
	$('#offerloanshark').show();
}

function randomEncounter() {
	var caughtProbability = 9;
	if (currentLocation == 'Slide') var caughtProbability = 15;
	
	if ( caughtProbability >= Math.floor(Math.random() * 100) ) {
		$('#caught').show()
		
		gumballsInBp = Math.floor(gumballsInBp * .5);
		licoriceInBp = Math.floor(licoriceInBp * .5);
		caramelsInBp = Math.floor(caramelsInBp * .5);
		
		totalInBackpack = jellybeansInBp + gummybearsInBp + gumballsInBp + licoriceInBp + caramelsInBp + chocolatesInBp;
		
		populateAmountsInBackpack();
		$('#totalinbackpack').text(totalInBackpack);
	}
	
	var backpackProbability = 10;
	if (currentLocation == 'Monkey Bars') var backpackProbability = 18;
	
	if ( backpackProbability >= Math.floor(Math.random() * 100) ) {
		$('#buybackpack').show();
		if (totalCash >= 20) $('#yesbuybackpack').addClass('selected');
	}
}

function buyBiggerBackpack() {
	if (totalCash >= 20) {
		totalCash -= 20;
		backpackCapacity += 20;
		$('#backpackcapacity').text(backpackCapacity);
		$('#totalcash').text(totalCash);
		$('#buybackpack').hide();
		$('#yesbuybackpack').removeClass('selected');
	}
}

function timeWarning() {
	alert('Only ' + minsLeft + ' minutes left!');
}

function endGame() {
	totalCash = totalCash - totalDebt;
	alert('Game over! You ended recess with ' + totalCash + ' cents!');
	currentCandy = currentLocation = "";
	currentCandyPrice = 0;
	refreshTable = true;
	showLsOffer = true;
	totalCash = 25;
	totalDebt = 27;
	howMany = 0;
	totalAfford = 0;
	totalHave = 0;
	totalInBackpack = 0;
	backpackCapacity = 20;
	minsLeft = 30;
	licoriceInBp = gummybearsInBp = gumballsInBp = jellybeansInBp = caramelsInBp = chocolatesInBp = 0;
	licoricePrice = gummybearsPrice = gumballsPrice = jellybeansPrice = caramelsPrice = chocolatesPrice = 0;
	$('#totalcash').text(totalCash);
	$('#totaldebt').text(totalDebt);
	$('#totalinbackpack').text(totalInBackpack);
	$('#backpackcapacity').text(backpackCapacity);
	$('#minsleft').text(minsLeft);
}