"use strict";

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var canvas = document.querySelector("#myCanvas");
var ctx = canvas.getContext("2d");

var x = canvas.width / 2;
var y = canvas.height - 30;

//speed of ball
var dx = 2;
var dy = -2;

var ballRadius = 10;

var paddleHeight = 10;
var paddleWidth = 75;
var paddleX = (canvas.width - paddleWidth) / 2;
var paddleColor = "#1B8410";

var rightPressed = false;
var leftPressed = false;

var brickRowCount = 4;
var brickColumnCount = 5;
var brickWidth = 50;
var brickHeight = 15;
var brickPadding = 9;
var brickOffsetTop = 30;
var brickOffsetLeft = 10;

var score = 0;

var bricks = [];
for (var c = 0; c < brickColumnCount; c++) {
	bricks[c] = [];
	for (var r = 0; r < brickRowCount; r++) {
		bricks[c][r] = { x: 0, y: 0, status: 1 };
	}
}

var mainWorker = new Worker("worker.js");

var Main = (function () {
	function Main() {
		_classCallCheck(this, Main);
	}

	_createClass(Main, [{
		key: "workerHandler",
		value: function workerHandler() {
			mainWorker.postMessage("Game started");
		}
	}, {
		key: "collisionDetection",
		value: function collisionDetection() {
			for (var c = 0; c < brickColumnCount; c++) {
				for (var r = 0; r < brickRowCount; r++) {
					var b = bricks[c][r];
					if (b.status === 1) {
						if (x > b.x && x < b.x + brickWidth && y > b.y && y < b.y + brickHeight) {
							dy = -dy;
							b.status = 0;
							score++;

							if (score === brickRowCount * brickColumnCount) {
								ctx.font = "16px Arial";
								ctx.fillStyle = "blue";
								ctx.fillText("You Win", 130, 300);
								setTimeout(function () {
									location.reload();
								}, 3000);
							}
						}
					}
				}
			}
		}
	}, {
		key: "drawScore",
		value: function drawScore() {
			ctx.font = "16px Arial";
			ctx.fillStyle = "#1B8410";
			ctx.fillText("Score " + score, 8, 20);
		}
	}, {
		key: "drawBricks",
		value: function drawBricks() {
			for (var c = 0; c < brickColumnCount; c++) {
				for (var r = 0; r < brickRowCount; r++) {
					if (bricks[c][r].status === 1) {
						var brickX = c * (brickWidth + brickPadding) + brickOffsetLeft;
						var brickY = r * (brickHeight + brickPadding) + brickOffsetTop;
						bricks[c][r].x = brickX;
						bricks[c][r].y = brickY;

						ctx.beginPath();
						ctx.rect(brickX, brickY, brickWidth, brickHeight);
						ctx.fillStyle = "#1B8410";
						ctx.fill();
						ctx.closePath();
					}
				}
			}
		}
	}, {
		key: "drawBall",
		value: function drawBall() {
			ctx.beginPath();
			ctx.arc(x, y, ballRadius, 0, Math.PI * 2);
			ctx.fillStyle = "#1B8410";
			ctx.fill();
			ctx.closePath();
		}
	}, {
		key: "drawPaddle",
		value: function drawPaddle() {
			ctx.beginPath();
			ctx.rect(paddleX, canvas.height - paddleHeight, paddleWidth, paddleHeight);
			ctx.fillStyle = paddleColor;
			ctx.fill();
			ctx.closePath();
		}
	}]);

	return Main;
})();

;

var game = new Main();

var work = game.workerHandler();

function draw() {

	ctx.clearRect(0, 0, canvas.width, canvas.height);
	game.drawPaddle();
	game.drawBall();
	game.drawBricks();
	game.collisionDetection();
	game.drawScore();
	x += dx;
	y += dy;

	mainWorker.onmessage = function (e) {
		if (e.data === "change") {
			ballRadius = 15;
		} else if (e.data === "noChange") {
			ballRadius = 10;
		}
	};

	//wall collision
	if (x + dx < ballRadius) {
		dx = -dx;
	} else if (x + dx > canvas.width - ballRadius) {
		dx = -dx;
	}

	if (y + dy < ballRadius) {
		dy = -dy;
	}

	//collided with paddle
	else if (y + dy > canvas.height - ballRadius) {
			if (x > paddleX && x < paddleX + paddleWidth) {
				dy = -dy;
			} else {
				ctx.font = "16px Arial";
				ctx.fillStyle = "red";
				ctx.fillText("Game Over", 130, 300);
				setTimeout(function () {
					location.reload();
				}, 2000);
			}
		}

	if (rightPressed && paddleX < canvas.width - paddleWidth) {
		paddleX += 7;
	} else if (leftPressed && paddleX > 0) {
		paddleX -= 7;
	};

	requestAnimationFrame(draw);
}

draw();

//controls
document.addEventListener("keydown", keyDownHandler, false);
document.addEventListener("keyup", keyUpHandler, false);

function keyDownHandler(e) {
	if (e.keyCode === 39) {
		rightPressed = true;
	} else if (e.keyCode === 37) {
		leftPressed = true;
	}
};

function keyUpHandler(e) {
	if (e.keyCode === 39) {
		rightPressed = false;
	} else if (e.keyCode === 37) {
		leftPressed = false;
	}
};

function leftUpTouchHandler() {
	leftPressed = false;
}

function LeftDownTouchHandler() {
	leftPressed = true;
}

function rightUpTouchHandler() {
	rightPressed = false;
}

function rightDownTouchHandler() {
	rightPressed = true;
}

//touch controls
document.querySelector("#left").addEventListener("touchstart", LeftDownTouchHandler, false);
document.querySelector("#left").addEventListener("touchend", leftUpTouchHandler, false);

document.querySelector("#right").addEventListener("touchstart", rightDownTouchHandler, false);
document.querySelector("#right").addEventListener("touchend", rightUpTouchHandler, false);
