reqPodcast = new XMLHttpRequest({ mozSystem: true });

var Podcast = {

	cargar: function(element){
		
		$.mobile.loading('show');
		
		console && console.log("Cargando Podcast - Entro a cargar Podcast");
		
		this.not = element;
		
		try {
			
			var url = (this.not).ruta;
			console && console.log("Cargando Podcast - la url es: "+url);
			
			reqPodcast.open('GET',url, true);
			console && console.log("Cargando Podcast - abrio la conexion");
			reqPodcast.setRequestHeader("Cache-Control", "no-store");
			reqPodcast.setRequestHeader("Cache-Control", "no-cache");
			reqPodcast.responseType = "text/xml";
			if (reqPodcast.overrideMimeType) {	
				reqPodcast.overrideMimeType('text/xml; charset=utf-8'); //Para Google Chrome y Firefox
			} else {
				reqPodcast.setRequestHeader('Content-type', 'text/html; charset=utf-8'); //Para IE8
			}
			reqPodcast.onreadystatechange = handleResponsePodcast;
			console && console.log("Cargando Podcast - onReadyStateChange");
			reqPodcast.send(null);		

		}
		catch(e) {
			
			alert("Esta aplicaci\xf3n requiere de conexi\xf3n a internet");
			$.mobile.loading('hide');
			console && console.log("Cargando Podcast - falla la conexion: el error es: " + e);
		}
	},
	
	parse: function(ret){

		console && console.log("Cargando Podcast - entro al parse");
		
		var arrayPodcast = [];
		
		$(ret).find("item").each(function(){
			
			entry = { 
				Nombre: $(this).find("title").text(), 
				Link: $(this).find("enclosure").attr("url"),
				Fecha: $(this).find("pubDate").text()
			};
			
			//console && console.log("Cargando Podcast - buscando los item");
			arrayPodcast.push(entry);
			
		});
		
		this.mostrar(arrayPodcast);
	},
	
	mostrar: function(arrayPodcast){

		$.mobile.loading('hide');
		
		$("#listpodcast").children().remove('li');
		var s = "";
		
		for (i = 0; i < arrayPodcast.length ; i++){
			
			s += '<li><a class="itemPodcast" data-nombre="'+arrayPodcast[i].Nombre+'" data-fecha="'+arrayPodcast[i].Fecha+'" data-link="'+arrayPodcast[i].Link+'"><div>'+'<div class="imagenLomas" width="100%"><img width="100%"  src="img/audios_tab.png"/></div>'+
			'<div class="infoLomas" width="100%" ><div class="titulo2">'+arrayPodcast[i].Nombre+'</div>' +	
			'</div></div></a></li>';
		
		//console && console.log("Cargando Podcast - la url del podcast es: " + arrayPodcast[i].Link);
		}
		
		if(arrayPodcast.length > 0){
			
			$("#listpodcast").html(s);
			$("#listpodcast").listview('refresh');
			$("#listpodcast").show();
			
		}else{
			
			$("#listpodcast").hide();
		}
		
		if(arrayPodcast.length==0){
				
			$("#secSinNoticias").show();
			$("#recargar").show();
		}
		
		$("#nav-panel").panel("close");
	}

};

function handleResponsePodcast(){
	
	if (reqPodcast.readyState === 4) {
		console && console.log("Cargando Podcast - handleResponse - readyState 4");
		//FOR PLAYBOOK, NEED TO CHECK FOR STATUS=0 WHEN XHR REQUESTS ARE MADE TO LOCAL RESOURCES
		//	(NOT NECESSARY FOR SMARTPHONE, WHERE STATUS=200 WILL SUFFICE.
		if (reqPodcast.status === 200 || reqPodcast.status == 304 || reqPodcast.status == 0)  {
			console && console.log("Cargando Podcast - handleResponse - status: "+ reqPodcast.status);
			
			console && console.log("Cargando Podcast - handleResponse - respuesta: " + reqPodcast.responseText);
						
			Podcast.parse(reqPodcast.responseXML);

		}
		else {
			console && console.log("Cargando Podcast - handleResponse - error");
			alert("Error en la conexi\xf3n");
			$.mobile.loading('hide');
		}
	}
}
