// Global variables
Gcardobject = {};

var codemap ={};
codemap["CODE-39"]="code39";
codemap["CODE-128"]="code128";
codemap["EAN-13"]="ean13";
codemap["EAN-8"]="ean8";
codemap["UPC-A"]="upca";
codemap["UPC-E"]="upce";
codemap["QR-Code"]="qrcode";
codemap["I2/5"]="interleaved2of5";



// bind buttons 
$(document).on('pagecreate', "#index", function (event) {
	$( "#indexscanbutton" ).click(function() {
		$.mobile.changePage('scan.html');
	});
});
//Populate cardlist on index.html
$(document).on('pagebeforeshow', "#index", function (event, data) {
	var cardList = document.getElementById("cardList");
	while (cardList.hasChildNodes()) {
		cardList.removeChild(cardList.firstChild);
	}
	for (i=0; i<localStorage.length;i++){
		var key = localStorage.key(i);
		var cardobject = JSON.parse(localStorage.getItem(key));
		var cardname = cardobject.cardname;	

		$('#cardList').append($('<li/>', {    //here appending `<li>`
			'data-filter-text': ''+cardname
			}).append($('<a/>', {    			//here appending `<a>` into `<li>`
				'href': 'showBarcode.html?cardname='+cardname,
				'text': cardname,
				'class': 'ui-btn' 
		})));
	}
});

// bind buttons
$(document).on('pagecreate', "#showbarcode", function (event) {
	$( "#showhomebutton" ).click(function() {
		$.mobile.changePage('index.html');
	});
	$( "#deleteBarcode" ).click(function() {
		delFromStorage();
	});
});
// before showing the page set up all the parameters
$(document).on('pagebeforeshow', "#showbarcode", function (event, data) {
	var index = $(this).data("url").indexOf("?");
	var parameters = $(this).data("url").substr(index+1);
	// set global var cardname
	var parametercardname = parameters.replace("cardname=","");
	Gcardobject = JSON.parse(localStorage.getItem(parametercardname));

	document.getElementById("cardname").innerHTML = Gcardobject.cardname;
	document.getElementById("number").innerHTML = Gcardobject.barcode;
	document.getElementById("type").innerHTML = Gcardobject.type;
});

//bind buttons
$(document).on('pagecreate', "#scan", function (event) {
	$( "#scanhomebutton" ).click(function() {
		$.mobile.changePage('index.html');
	});

	$( "#scanscanbutton" ).click(function() {
		//$.mobile.changePage('scan.html');
	    document.getElementById("type").innerHTML = "No barcode found";
	    document.getElementById("barcode").innerHTML = "No barcode found";
	    document.getElementById("cardname").setAttribute("value", "");
	    //location.reload();
		takePicture();
		$.blockUI({ message: '<h3><img src="images/ajax-loader.gif" /> Scanning for barcode</h3>' }); 
	});

	$( "#scanaddButton" ).click(function() {
		addToStorageFromScan();
	});
});

// 'pagebeforeshow'
$(document).on('pagebeforeshow', "#scan", function (event, data) {
	takePicture();
	$.blockUI({ message: '<h3><img src="images/ajax-loader.gif" /> Scanning for barcode</h3>' }); 
});


//Add barcode to storage
function addToStorageFromScan () {
	var cardobject = {};
	cardobject.type = document.getElementById("type").innerHTML;
	cardobject.barcode = document.getElementById("barcode").innerHTML;
	cardobject.cardname = document.getElementById("cardname").value;

	if (cardobject.cardname == "" || cardobject.barcode == "" || cardobject.type == "No barcode found") {
		alert ("cardname or barcode or type not set.")
		return;
	}
	if ( localStorage.getItem(cardobject.cardname) != undefined ) {
		alert ("A card with that name already exists.")
		return;
	};
	localStorage.setItem(cardobject.cardname, JSON.stringify(cardobject));
	// clear input fields
    document.getElementById("type").innerHTML = "No barcode found";
    document.getElementById("barcode").innerHTML = "No barcode found";
    document.getElementById("cardname").value = "";
};

function delFromStorage () {
	if ( confirm("Delete "+Gcardobject.cardname) )
		{
		localStorage.removeItem(Gcardobject.cardname);
		$.mobile.changePage('index.html');
		}
};

function drawBc (BC,type) {
	var bw = new BWIPJS;

	// Create the bitmap interface and pass to the emulator
	bw.bitmap(new Bitmap);

	// Set the scaling factor
	bw.scale(2, 2);

	// Create a dictionary object and set the options
	var opts = {};
	opts.parsefnc    = bw.value(true);
	opts.includetext = bw.value(false);

	bw.push(BC);
	bw.push(opts);
	
	if (codemap[type] == undefined ) {
		alert("Can't display this type of barcode.");
		return;
	}

	// Invoke the encoder and render the barcode
	bw.call(codemap[type]);
	bw.bitmap().show('barcode','N');
};

// Draw the Barcode when the page is ready
$(document).on('pagecontainershow', function (event, data) {
	var page = $.mobile.pageContainer.pagecontainer("getActivePage").attr("id");
	if (page == "showbarcode") {
		drawBc(Gcardobject.barcode,Gcardobject.type);
	};
});

// Stuff to scan barcode used in scan.html
function takePicture() {
	if (!MozActivity ){return};
	  var pick = new MozActivity({
	    name: "pick",
	    data: { type: ["image/png", "image/jpg", "image/jpeg"] }
	  });
	  pick.onsuccess = function () {
	    scanBarcode(URL.createObjectURL(this.result.blob));
	  };
	  pick.onerror = function () {
		$.unblockUI();
	    document.getElementById("type").innerHTML = "No barcode found";
	    document.getElementById("barcode").innerHTML = "No barcode found";
	  };
	}

function scanBarcode (url) {
	var img = new Image();
	  img.onload = function () {
	    var canvas = document.createElement('canvas');
	    // Scale down if needed to speed up processing
	    var scalefacor = (320) / (img.width);
	    canvas.width = Math.ceil(img.width * scalefacor);
	    scalefacor = (240) / (img.height);
	    canvas.height = Math.ceil(img.height * scalefacor);
	    var ctx = canvas.getContext('2d');
	    ctx.drawImage(img, 0, 0, img.width, img.height,
	                  0, 0, canvas.width, canvas.height);

	    var data = ctx.getImageData(0, 0, canvas.width, canvas.height);
	    var codes = zbarProcessImageData(data);
		$.unblockUI();
	    if (codes.length === 0) {
			    document.getElementById("type").innerHTML = "No barcode found";
			    document.getElementById("barcode").innerHTML = "No barcode found";
	    	return;
	    }    
	    var barcodeType = codes[0][0];
	    var barcodeDate = codes[0][2];
	    // publishing data
		    document.getElementById("type").innerHTML = barcodeType;
		    document.getElementById("barcode").innerHTML = barcodeDate;
	    }	    
	img.src = url;

}

