/*  Function loader */

function GiroqueLoader(o){
	
	var queue = [],
		blocked = false,
		current = {}, options = {version : 1};
		
	$.extend(options,options,o)

	function callBack(data){
        /* Get  data */
        var results2 = data; //{ result : data};
                    
        /* Remove current set of data */
        $( current.container ).empty();//.html("<span data-theme=\"d\"></span>");
            
        /* Render the template  */
        $( current.template ).tmpl( results2 )
            .appendTo( current.container );

        $(current.container).trigger("create");
		current.cb && current.cb(data);
		if(queue.length>0){
			_get();
		} else {
			blocked = false; 
		}
	}
	
	function _get(){
		current = queue.pop();
		//alert(current.url);
		jQuery.getJSON(current.url, callBack);
	}
	
	function get(url,container,template,cb){
		var temp =  { url : url, container : container, template : template, cb : cb };
		
		queue.push(temp);
		if(!blocked){
			blocked = true;
			_get();
		}
	}
	
	return { get : get };
}	



JSONcache = function(){

    /* globals for JSON callback, check for cache support */
    var cacheid,cb,
        cancache = (('localStorage' in window) &&
                    window['localStorage'] !== null);

    /* get the data - expects a transaction object */
    function get(transaction){
      if(!transaction.id || !transaction.callback ||
         !transaction.url || !transaction.cacheage){ return }

      var current,data;
      cb = transaction.callback;
      cacheid = transaction.id;

      /* if caching is not supported, just call YQL */
      if(!cancache){
        loadJSON(transaction.url);
      }

      /* if caching is supported */
      if(cancache){

        /* retrieve the cache and see if it has data */
		if(localStorage[cacheid]){
        	current = JSON.parse(localStorage[cacheid]);
			if(current !== null){
	
			  /* if the cache time is less than the cacheage return it*/
			  if((new Date().getTime() - current.time) < transaction.cacheage){
				cb({type:'cached',data:current.data});
	
			  /* if the cache is older than the max age, prime the cache */
			  } else {
				loadJSON(transaction.url);
			  }
	
			/* if the cache has no data, load from YQL again */
			} else {
			  loadJSON(transaction.url);
			}
		} else {
			loadJSON(transaction.url);
		}
      }
    }

    /* bog standard JSON-P call function to get data from YQL */
    function loadJSON(url){
	  $.getJSON(url, cache);
    }
    
    /* Caching function */
    function cache(data){
      var out;

      /* if YQL was successful, get the data */
      //if(data.query && data.query.results)
	  {
        var out = data;

        /* if caching is supported, get a timestamp, prime the cache 
           and call the callback */

        if(cancache){
          var timestamp = new Date().getTime();
          localStorage[cacheid] = JSON.stringify({time:timestamp,data:out});
          cb({type:'freshcache',data:out});

        /* otherwise just call the callback */ 
        } else {
          cb({type:'live',data:out});
        }
      } 
    }
    return{cache:cache,get:get};
  }();