// Sets the require.js configuration for your application.
require.config( {

      urlArgs: "bust=" +  5,

      // 3rd party script alias names (Easier to type "jquery" than "libs/jquery-1.8.2.min")
      paths: {

            // Core Libraries
            "jquery": "jquery-1.8.1.min",
            "jquerymobile": "jquery.mobile-1.3.0.min",
            "underscore": "underscore-min",
            "backbone": "backbone",
            "jquerytmpl": "jquery.tmpl",
            "jqueryajaxlocals": "jquery-ajax-localstorage-cache",
            "backbonecachingsync" : "backbone.cachingsync",
            "backbonefetchcache":"backbone.fetch-cache"

      },

      // Sets the configuration for your third party scripts that are not AMD compatible
      shim: {

            "backbone": {
                  "deps": [ "underscore", "jquery", /*"jqueryajaxlocals" */  ],
                  "exports": "Backbone"  //attaches "Backbone" to the window object
            },

            underscore: {
                  exports: '_'
            },

      } // end Shim Configuration

} );

// Includes File Dependencies
require([ "jquery",   "backbone", "routers/mobileRouter", "backbonefetchcache" ], function( $,  Backbone, Mobile ) {

	$( document ).on( "mobileinit",
		// Set up the "mobileinit" handler before requiring jQuery Mobile's module
		function() {
			// Prevents all anchor click handling including the addition of active button state and alternate link bluring.
			$.mobile.linkBindingEnabled = false;

			// Disabling this will prevent jQuery Mobile from handling hash changes
			$.mobile.hashListeningEnabled = false;
                  $("div.portada").addClass("portada2");
		}
	)

      require( [ "jquerymobile" ], function() {
		// Instantiates a new Backbone.js Mobile Router
		this.router = new Mobile();
	});
} );