// Mobile Router
// =============

// Includes file dependencies
define([ "jquery","backbone", 
        "../models/FilmsModel", "../collections/FilmsCollection", "../views/FilmsView",
        "../models/CinemesModel", "../collections/CinemesCollection", "../views/CinemesView",
        "../models/CiutatsModel", "../collections/CiutatsCollection", "../views/CiutatsView",
        "../models/FilmSessionModel", "../collections/FilmSessionCollection", "../views/FilmView",
        "../views/CinemaView", "../views/CiutatView",
        ], function( $, Backbone, 
                     FilmsModel, FilmsCollection, FilmsView, 
                     CinemesModel, CinemesCollection, CinemesView, 
                     CiutatsModel,  CiutatsCollection, CiutatsView,
                     FilmsSessionModel, FilmSessionCollection, FilmView, 
                     CinemaView, CiutatView  ) {

    // Extends Backbone.Router
    var CategoryRouter = Backbone.Router.extend( {

        // The Router constructor
        initialize: function() {

            
            this.FilmsView = new FilmsView({ el: "#portada", collection: new FilmsCollection( [], { } ) } );
            this.CinemesView = new CinemesView( { el: "#cinemes", collection: new CinemesCollection( [] , {  } ) } );
            this.CiutatsView = new CiutatsView( { el: "#ciutats", collection: new CiutatsCollection( [] , {  } ) } );

            this.FilmView = new FilmView( { el: "#page-film", collection: new FilmSessionCollection( [] , {  } ) } );
            this.CinemaView = new CinemaView( { el: "#page-cinema", collection: new FilmSessionCollection( [] , {  } ) } );
            this.CiutatView = new CiutatView( { el: "#page-poblacio", collection: new FilmSessionCollection( [] , {  } ) } );


            // Tells Backbone to start watching for hashchange events
            Backbone.history.start();

        },

        // Backbone.js Routes
        routes: {

            // When there is no hash bang on the url, the home method is called
            "": "home",
            "portada": "home",

            // When #category? is on the url, the category method is called
            "cinemes": "cinemes",
            "ciutats" :"ciutats",
            "page-film=:id" : "film",
            "page-cinema=:id" : "cinema",
            "page-poblacio=:id" : "ciutat",           
            "*actions" : "defaultRoute"

        },

        defaultRoute :  function(r){
            $.mobile.changePage( "#"+r , { reverse: false, changeHash: false } );
        },

        // Home method
        home : function(){
            this.changePage("FilmsView");
        },

        ciutats : function(){
            this.changePage("CiutatsView");
        },
 
        cinemes : function(){
            this.changePage("CinemesView");
        },

        film : function(id){
            var currentView = this.FilmsView, self = this, current;
            if(currentView.collection && currentView.collection.length) {
                viewFilm(self, id);    
            } else {
                currentView.collection.fetch().done( function() {
                    viewFilm(self, id);
                });
            }

            function viewFilm(self, id){
                //current = currentView.collection.models[0].get("result")[id];
                current = _.findWhere(currentView.collection.models[0].get("result"), {codi: id});
                codi = current.codi;
                self.FilmView.options.film = current;
                self.changePage("FilmView", {data: "pelicula="+ codi + "&callback=?"}, true);
            }
        },

        cinema : function(id){
            this.changePage("CinemaView", {data: "cinema="+ id + "&callback=?"}, true);
        },

        ciutat : function(id){
            this.changePage("CiutatView", {data: "poblacio="+ id + "&callback=?"}, true);
        },

        // Category method that passes in the type that is appended to the url hash
        changePage: function(view, params, reload) {
            params = $.extend({},params,{cache : true,  processData:true});

            // Stores the current Category View  inside of the currentView variable
            var currentView = this[ view ];

            if(!currentView.collection.length || reload) {
                $.mobile.loading( "show" );
                currentView.collection.fetch(params).done( function() {
                    $.mobile.changePage( currentView.$el, { reverse: false, changeHash: false } );
                } );
            }
            else {
                $.mobile.changePage( currentView.$el , { reverse: false, changeHash: false } );
            }
        }

    } );

    // Returns the Router class
    return CategoryRouter;

} );