// Category View
// =============

// Includes file dependencies
define([ "jquery", "backbone", "models/FilmsModel", "jquerytmpl" ], function( $, Backbone, CinemaModel ) {

    // Extends Backbone.View
    var CinemaView = Backbone.View.extend( {

        firstTime :  true,

        // The View Constructor
        initialize: function() {

            // The render method is called when Category Models are added to the Collection
            //this.collection.on( "added", this.render, this );
            //this.collection.listenTo(CinemaModel,"change", this.render)
            this.collection.bind("reset", this.render, this);
            this.collection.bind("change", this.render, this);
            this.collection.bind("update", this.render, this);

        },

        // Renders all of the Category models on the UI
        render: function() {
            var data = this.collection.toJSON()[0];
            // Sets the view's template property
            //this.template = _.template( $( "script#categoryItems" ).html(), { "collection": this.collection } );
            this.template = $( "#sessions" ).tmpl( data );

            // Renders the view's template inside of the current listview element
            this.$el.find("#cinema-content").html(this.template);

            if(this.firstTime){
                this.firstTime = false;
            } else {
                this.$el.trigger("create");
            }
            //this.$el.trigger("create");
            // $.mobile.loading( "hide" );

            // Maintains chainability
            return this;

        }

    } );

    // Returns the View class
    return CinemaView;

} );