// Category View
// =============

// Includes file dependencies
define([ "jquery", "backbone","models/CiutatsModel" ], function( $, Backbone, CiutatsModel ) {

    // Extends Backbone.View
    var CiutatsView = Backbone.View.extend( {

        // The View Constructor
        initialize: function() {

            // The render method is called when Category Models are added to the Collection
            this.collection.bind("reset", this.render, this);
            this.collection.bind("change", this.render, this);

        },

        // Renders all of the Category models on the UI
        render: function() {

            // Sets the view's template property
            //this.template = _.template( $( "script#categoryItems" ).html(), { "collection": this.collection } );
            this.template = $( "#tmpl_ciutats" ).tmpl( this.collection.toJSON()[0] );

            // Renders the view's template inside of the current listview element
            this.$el.find("ul.poblacions").html(this.template);

            // Maintains chainability
            return this;

        }

    } );

    // Returns the View class
    return CiutatsView;

} );