/************
Cat BugSquash
(c) lulu
June, 2015
http://luludev.neocities.org/
************/
var app = {   
    /* global variables */ 
    debug : false, //debug mode, some error messages
    gameOff : true, //not in game mode, stop clicks and timer
    maxLevel : 20, //game last level
    maxHighScores : 10, //number of high scores to keep track of
    level : 1, //start level
    totalClicks : 0, //clicks in game
    totalTime : 0, //total time accumulated
    timeCounterElapse : 1000, //game time counter wait
    pressDelayTime : 200, //ms, delay between when user presses counted as clicks to 
     // differentiate between press events (mousedown/touchstart/etc)... 
     // tested events delay ~100ms-170ms, fastest user clicks ~150ms-200ms  
    pressEnable : true, //press event delay flag
    dotStop : true, //do not move dot
    dotNewPoint : true, //previous points for dot movement
    dotDir : 0, //dot movement direction: 0=t, 1=tl, 2=l, 3=bl, 4=b, 5=br, 6=r, 7=tr
    dotHopCount : 0, //dot hop moves until next change
    dotHopStop : false, //dot hop at a stop=true, moving=false
    dotAccel : 0, //count moves since stop/hit wall
    dotAnimationFastSpeed : "50ms", //wing speed fast
    dotAnimationSlowSpeed : "400ms", //wing speed slow
    dotAnimationStartSpeed : "100ms", //wing speed start game
    pullTabMax : 60, //pull_tab_top height px, set in ondeviceready
    pullTabStartY : -1, //save starting y coord of tab pull
    pullStarted : false, //avoid multiple pulls from different mouse and touch events firing for one touch (only if spaced interleaving)
    
    /** INIT **/
    /* Application Constructor */
    initialize: function() {
        this.bindEvents();
    },
    /* Bind Event Listeners - any events that are required on startup. */
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
        document.addEventListener('pause', app.navTo, false); //navigate to home -> pause game
        document.addEventListener('menubutton', app.navTo, false); //Amazon Fire OS, Android, BlackBerry 10
    },
    /* deviceready Event Handler, attach event listeners */
    onDeviceReady: function() {
        var load = document.getElementById("loading");
        if (load){ load.style.display = "block"; }
        app.navTo("home");
        //home
        var e = document.getElementById("button_play");
        if (e){ e.addEventListener("click",function(){ app.navTo("newgame");}); }
        var e = document.getElementById("button_continue");
        if (e){ e.addEventListener("click",function(){app.navTo("continuegame");}); }
        var e = document.getElementById("button_newgame");
        if (e){ e.addEventListener("click",function(){ app.navTo("newgame");}); }
        //game
        var tab = document.getElementById("pull_tab");
        if (tab){ 
        	tab.addEventListener("mousedown",app.startTabPull); //all the touch events
        	tab.addEventListener("touchstart",app.startTabPull);  
        	tab.addEventListener("pointerdown",app.startTabPull); 
        	tab.addEventListener("MSPointerDown",app.startTabPull); 
        	var tabtop = Math.abs(parseInt(getComputedStyle(tab).top));
        	if (!isNaN(tabtop)){ app.pullTabMax = tabtop; }
        }
        var tabstop = document.getElementById("pull_tab_top");
        if (tabstop){ tabstop.addEventListener("click",app.navTo); }
        var e = document.getElementById("game");
        if (e){        
	    	e.addEventListener("mousedown",app.gameUpdatePress); 
	    	e.addEventListener("touchstart",app.gameUpdatePress); 
	    	e.addEventListener("pointerdown",app.gameUpdatePress); 
	        e.addEventListener("MSPointerDown",app.gameUpdatePress);         
        }  
        setInterval(app.gameUpdateTime,app.timeCounterElapse);
        //close loading //after a second
        //setTimeout(function(){ if (load){ load.style.display = "none"; }},1000);
        if (load){ load.style.display = "none"; }
    },
    
    /** all **/
    //navigation
    navTo: function(navto) {
        var load = document.getElementById("loading");
        if (load){ load.style.display = "block"; }
        if (navto!="home" && navto!="newgame" && navto!="continuegame"){ navto = "home"; }
        var home = document.getElementById("home");
        var game = document.getElementById("game");
        if (!home || !game){ if(app.debug){ console.log("ERROR: missing element home or game",home,game); } return; } //bad
        app.gameOff = true;
        if (navto=="home"){
            game.style.display = "none";
            app.dotStop = true; //stop dot
            var game_background_audio = document.getElementById("game_audio_background");
            if (game_background_audio){ game_background_audio.pause(); }
            app.endTabPull();
            home.style.display = "block";
            app.initHome();
        }
        else { //game
            home.style.display = "none";
            if(navto=="newgame"){
                app.gameSaveNewHighScore();
            }
            game.style.display = "block";
            app.initGame();
        }
        if (load){ load.style.display = "none"; }
    },
    //return boolean on whether local storage is available
    lsAvail : function(){
        var test = 'test';
        try {
            localStorage.setItem(test, test);
            localStorage.removeItem(test);
            return true;
        } catch(e) {
            return false;
        }
    },
    //convert int ms time to string with "minutes:seconds" format
    convertMStoString : function (time){
        var t = Math.round(time/1000);
        var s = t % 60;
        var m = (t-s)/60;
        if (s == 0){ s = "0";}
        if (m == 0){ m = "0";}
        if (s < 10){ s = "0"+s; }
        return m+":"+s;
    },
    //calculate hit rate from level and total clicks
    calcHR : function(level,clicks){
        var hr = 0;
        if (clicks > 0){ hr = Math.round(((level - 1)/clicks)*100);}
        if (hr > 100){ hr = 100; }
        return hr; 
    },
    //print level, say something special when beat all levels instead of "21"
    calcLevel: function(level){
        return level > app.maxLevel ? "9001" : level;
    },
    
    /** HOME **/
    //set up home page
    initHome : function() {
        var home = document.getElementById("home"); 
        if (home){
        	if (home.clientHeight < document.documentElement.clientHeight){ //check height for older browsers
        		home.style.height = document.documentElement.clientHeight+"px";
        	}
        }
        var bp = document.getElementById("button_play");
        var bc = document.getElementById("button_continue");
        var bn = document.getElementById("button_newgame");
        var csdiv = document.getElementById("continue_score");
        var csl = document.getElementById("continue_level");
        var csr = document.getElementById("continue_hr");
        var cst = document.getElementById("continue_time");
        var hsdiv = document.getElementById("highscores_section");
        var hsth = document.getElementById("highscores_thr");
        var ah = document.getElementById("about_header");
        var hs = [];
        var cs = [];
        if (!bp || !bc || !bn || !csdiv || !csl || !csr || !cst || !hsdiv || !hsth || !ah){ 
        	if(app.debug){ console.log("ERROR: missing element initHome"); } 
        	return; } //bad
        if (app.lsAvail()){
            if (localStorage.highscores){
                hs = JSON.parse(localStorage.highscores);
            }
            if (localStorage.continuegame){
                cs = JSON.parse(localStorage.continuegame);
            }
        }
        if (cs.length == 0 && app.level > 1 && app.totalTime > 0 && app.totalClicks > 0){
            cs[0] = app.level;
            cs[1] = app.totalTime;
            cs[2] = app.totalClicks;
        }
        //edit buttons - play vs. continue and new game
        if (cs.length > 0){ //continue and new game
            bp.parentNode.style.display = "none";
            bc.parentNode.style.display = "block";
            bn.parentNode.style.display = "block";
            csdiv.style.display = "block";
            csl.innerHTML = cs[0];
            csr.innerHTML = app.calcHR(cs[0],cs[2]);
            cst.innerHTML = app.convertMStoString(cs[1]);
        } else { //play
            bp.parentNode.style.display = "block";
            bc.parentNode.style.display = "none";
            bn.parentNode.style.display = "none";
            csdiv.style.display = "none";
            
        }
        //edit high scores table
        if (hs.length > 0){ //high scores exist
            hsdiv.style.display = "block";
            ah.style.display = "block";
            //prune table
            var i=0; 
            var ptr = hsth.nextElementSibling;
            while(ptr){ 
                if (i<hs.length){ //substitute row
                    var tr = document.createElement("tr");
                    if (i==0){ tr.className = "top_row"; }
                    var td = document.createElement("td");
                    td.innerHTML = app.calcLevel(hs[i][0]);
                    tr.appendChild(td);
                    td = document.createElement("td");
                    td.innerHTML = app.convertMStoString(hs[i][1]);
                    tr.appendChild(td);   
                    td = document.createElement("td");
                    td.innerHTML = app.calcHR(hs[i][0],hs[i][2])+"%";
                    tr.appendChild(td);
                    ptr.parentNode.replaceChild(tr,ptr);
                    ptr = tr;
                    i++;
                } else { //remove table row
                    var temp = ptr;
                    ptr = ptr.previousElementSibling;
                    temp.parentNode.removeChild(temp);
                }
                if (!ptr){
                    ptr = hsth.nextElementSibling;
                } else {
                    ptr = ptr.nextElementSibling;
                }
            }
            //add to table
            while(i<hs.length){ 
                var tr = document.createElement("tr");
                if (i==0){ tr.className = "top_row"; } 
                var td = document.createElement("td");
                td.innerHTML = app.calcLevel(hs[i][0]);
                tr.appendChild(td);
                td = document.createElement("td");
                td.innerHTML = app.convertMStoString(hs[i][1]);
                tr.appendChild(td);   
                td = document.createElement("td");
                td.innerHTML = app.calcHR(hs[i][0],hs[i][2])+"%";
                tr.appendChild(td);
                hsth.parentNode.appendChild(tr);
                i++;              
            }            
        } else { //no high scores
            hsdiv.style.display = "none";
            ah.style.display = "none";    
        }
    },
    
    /** GAME **/
    //initialize game, get screen ready
    initGame : function(){
        //load continue game from memory
        var cs = [];
        if (app.lsAvail()){
            if (localStorage.continuegame){
                cs = JSON.parse(localStorage.continuegame);
            }
        }
        if (cs.length > 0){
            app.level = cs[0];
            app.totalTime = cs[1];
            app.totalClicks = cs[2];
        }
        //prepare screen 
        var game = document.getElementById("game"); 
        if (game){
        	if (!game.clientHeight){ //check height for older browsers
        		game.style.height = document.documentElement.clientHeight+"px";
        	}
        }
        var dot = document.getElementById("game_dot");
		if (dot){ //set size of bug
			if (dot.clientHeight != dot.clientWidth)
			var dh = Math.floor(document.documentElement.clientWidth/10)+"px";
			dot.style.width = dh;
			dot.style.height = dh;
		}
        var game_background_audio = document.getElementById("game_audio_background");
        if (game_background_audio){
            if(game_background_audio.readyState == 4){ //problems with setting currentTime on invalidState  
                game_background_audio.currentTime = 0;
            }
            game_background_audio.play();
        } 
        //start game
        app.gameOff = false;
        app.updateGameScore();
        app.initDot();
    },
    //launch moveDot
    launchMoveDots : function(){
    	app.moveDot();
    },
    //initialize dot
    initDot : function(){
        var dot = document.getElementById("game_dot");
        var dotclick = document.getElementById("game_dot_expansion");
        if (!dot && !dotclick){ if(app.debug){ console.log("ERROR: missing element initDot: game_dot or game_dot_expansion",dot,dotclick); } return; } //bad
        if (!app.level){ app.level = 1;}
        //set wing animation
        var lwing = document.getElementById("dot_lwing");
        var rwing = document.getElementById("dot_rwing");
        if (lwing){ 
    		lwing.style.webkitAnimationName = "lwingmove";
            lwing.style.msAnimationName = "lwingmove"; 
    		lwing.style.webkitAnimationDuration = app.dotAnimationStartSpeed;
        	lwing.style.mozAnimationDuration = app.dotAnimationStartSpeed;
        	lwing.style.OAnimationDuration = app.dotAnimationStartSpeed;
        	lwing.style.animationDuration = app.dotAnimationStartSpeed; 
    	} 
        if (rwing){ 
    		rwing.style.webkitAnimationName = "rwingmove";
            rwing.style.msAnimationName = "rwingmove";
        	rwing.style.webkitAnimationDuration = app.dotAnimationStartSpeed;
        	rwing.style.mozAnimationDuration = app.dotAnimationStartSpeed;
        	rwing.style.OAnimationDuration = app.dotAnimationStartSpeed;
        	rwing.style.animationDuration = app.dotAnimationStartSpeed; 
        }
        //start movement
        dot.style.opacity = 1;
        app.dotStop = false;
        app.dotNewPoint = true;
        app.launchMoveDots();        
        dotclick.addEventListener('mousedown',app.dotPressed);
        dotclick.addEventListener('touchstart',app.dotPressed);
        dotclick.addEventListener("MSPointerDown",app.dotPressed);
        dotclick.addEventListener("pointerdown",app.dotPressed);
    },
    //rotate based on app.dotDir
    rotateElem : function(elem){
        //0=t, 1=tl, 2=l, 3=bl, 4=b, 5=br, 6=r, 7=tr
        var deg = 180; //4
        if (app.dotDir == 3){
            deg = 225; //45;
        } else if(app.dotDir == 2){
            deg = 270; //90;
        } else if(app.dotDir == 1){
            deg = 315; //135;
        } else if(app.dotDir == 0){
            deg = 0; //180;
        } else if(app.dotDir == 7){
            deg = 45; //225;
        } else if(app.dotDir == 6){
            deg = 90; //270;
        } else if(app.dotDir == 5){
            deg = 135; //315;
        }  else {
            deg = 180;
        }
        elem.style.webkitTransform = 'rotate('+deg+'deg)'; 
        elem.style.mozTransform    = 'rotate('+deg+'deg)'; 
        elem.style.msTransform     = 'rotate('+deg+'deg)'; 
        elem.style.oTransform      = 'rotate('+deg+'deg)'; 
        elem.style.transform       = 'rotate('+deg+'deg)'; 
    },
    //calulate amount to move dot based on size of dot (which is based on screen size)
    dotSizeCompensation : function(){
        var dot = document.getElementById("game_dot");
        if (!dot){ if(app.debug){ console.log("ERROR: missing element dotSizeCompensation: game_dot",dot); } return 1; } //bad
        var minheight = parseInt(getComputedStyle(dot).minHeight); //in case change this
        if (isNaN(minheight)){ minheight = 50; } //backup
        var amt = Math.round((dot.offsetHeight - minheight + 10) / 10); //tinker
        if (amt<=0 || !amt) { if(app.debug){ console.log("ERROR: dotSizeCompensation: amt<=0",amt); } return 1; } //bad
        return amt;
    },
    //calculate time for next dot hop change
    moveDotHopCalcTime : function(){
        if (app.dotHopStop){ //tinker
            app.dotHopCount = 10 + Math.round(Math.random()*350/app.level); //time to stay stopped
        } else {
            app.dotHopCount = 10 + Math.round(Math.random()*300); //time to stay moving
        }
    },
    //calculate probability of starting slow
    moveDotSlowProb : function(){
    	return 0.8 + (app.level/app.maxLevel)*0.17; //tinker
    },
    //play squeak sound
    moveDotSqueak : function(){
        var sound = document.getElementById("game_audio_squeak");
        if (sound){
            if(sound.readyState == 4){
            	try{ if(sound.paused==true && sound.currentTime>=sound.seekable.end(0)){ //restart sound  
	                sound.currentTime = 0;
	            }} 
	            finally{if(sound.paused==true && sound.currentTime==0){ //only play if not already playing
	        		sound.play(); 
	        	}}
           } else {
           		sound.play();
           }
        } 
    },
    //check dot move bounds collision
    //if there is a collision, move dot to wall & calc new direction
    //else move dot to new spot
    moveDotandBoundsCollision : function(game,dot){
        var game = document.getElementById("game");
        var dot = document.getElementById("game_dot");
        if (!game || !dot){ if(app.debug){ console.log("ERROR: missing element moveDotandBoundsCollision: game or game_dot",game,dot); } return; } //bad
        var r = parseInt(dot.style.right);
        var b = parseInt(dot.style.bottom);
        var h = game.offsetHeight;
        var w = game.offsetWidth;
        var dh = dot.offsetWidth;
        var dw = dot.offsetHeight;
        //new point or unknown r & b
        if (app.dotNewPoint || isNaN(r) || isNaN(b)){
            app.dotNewPoint = false; 
            //move dot to new completely random location
            r = Math.round(Math.random()*(w-dw));
            b = Math.round(Math.random()*(h-dh));
            //choose random direction
        	app.dotDir = Math.round(Math.random()*8-0.5); //any random direction
            app.dotHopStop = false; 
            app.moveDotHopCalcTime();
        } else {
            //calc new r+l: 0=t, 1=tl, 2=l, 3=bl, 4=b, 5=br, 6=r, 7=tr
        	var max_accel_amt = 7; //magic number, when accelerating, don't jump more than 7 pixels
            var amt = Math.ceil(app.level * 3) + app.dotSizeCompensation();  
            if (app.dotAccel < 20 && amt > max_accel_amt){
            	amt = max_accel_amt;
            }
            if (app.dotDir < 2 || app.dotDir > 6){ //up 7,0,1 
                b += amt; 
            } else if (app.dotDir > 2 && app.dotDir < 6) { //down 3,4,5
                b -= amt;
            } if (app.dotDir > 0 && app.dotDir < 4){ //left 1,2,3 
                r += amt;
            } else if (app.dotDir > 4){ //right 5,6,7
                r -= amt;
            }
            //check bounds
            var random_bounce_dir = Math.round(Math.random()*2);
            if (r < 0){
                if (Math.random()>app.moveDotSlowProb()){ app.dotAccel = 1; app.moveDotSqueak(); }
                r = 0;
                if (b < 0){ //br -> {l,tl,t}={0,1,2} / tl = 1 / mirror
                    b = 0;
                    app.dotDir = random_bounce_dir;
                } else if (b>h-dh){ //tr -> {b,bl,l}={2,3,4} / bl = 3 / mirror
                    b = h-dh;
                    app.dotDir = random_bounce_dir+2;
                } else { //r -> {tl,l,bl}={1,2,3} / l = 2 / mirror
                    app.dotDir = random_bounce_dir+1;
                } 
            } else if (b < 0){
                if (Math.random()>app.moveDotSlowProb()){ app.dotAccel = 1; app.moveDotSqueak(); }
                b = 0;
                if (r>w-dw){ //bl -> {r,tr,t}={0,6,7} / tr = 7 / mirror
                    r = w-dw;  
                    app.dotDir = (random_bounce_dir+6)%8;                
                } else { //b -> {t,tl,tr}={0,1,7} / t = 0 / mirror
                    app.dotDir = (random_bounce_dir+7)%8;        
                }
            } else if (r>w-dw){
                if (Math.random()>app.moveDotSlowProb()){ app.dotAccel = 1; app.moveDotSqueak(); }
                r = w-dw;
                if (b>h-dh){ //tl -> {br,b,r}={4,5,6} / br = 5 / mirror
                    b = h-dh; 
                    app.dotDir = random_bounce_dir+4;
                } else { //l -> {r,tr,br}={5,6,7} / r = 6 / mirror
                    app.dotDir = random_bounce_dir+5;
                }
            } else if (b>h-dh){ //t -> {b,br,bl}={3,4,5} / b = 4 / mirror
                if (Math.random()>app.moveDotSlowProb()){ app.dotAccel = 1; app.moveDotSqueak(); }
                b = h-dh;        
                app.dotDir = random_bounce_dir+3;
            } else {
                app.dotAccel++;
            }
        }
        //move dot
        app.rotateElem(dot);
        dot.style.right = r+"px";
        dot.style.bottom = b+"px";
    },
    //move dot
    moveDot : function(){
        //all levels : random bounce + hopstop&start random dir
        if (app.dotStop){ return; }
        //move dot
        if (!app.dotNewPoint){
            app.dotHopCount--;
            if (app.dotHopCount<=0){
		        var lwing = document.getElementById("dot_lwing");
		        var rwing = document.getElementById("dot_rwing");
	            if (app.dotHopStop){ 
	                if (Math.random()>app.moveDotSlowProb()){ app.dotAccel = 1; app.moveDotSqueak(); }
			        if (lwing){
			        	lwing.style.webkitAnimationDuration = app.dotAnimationFastSpeed; 
			        	lwing.style.mozAnimationDuration = app.dotAnimationFastSpeed; 
			        	lwing.style.OAnimationDuration = app.dotAnimationFastSpeed;			        	 
			        	lwing.style.animationDuration = app.dotAnimationFastSpeed;
			        	if (lwing.style.webkitAnimationName == "lwingmove"){ //hack for old webkit to force animation change
			        		lwing.style.webkitAnimationName = "lwingmove_2";
			        	} else if (lwing.style.webkitAnimationName == "lwingmove_2"){
			        		lwing.style.webkitAnimationName = "lwingmove";		        		
			        	} if (lwing.style.msAnimationName == "lwingmove"){ //IE
                            lwing.style.msAnimationName = "lwingmove_2";
                        } else if (lwing.style.msAnimationName == "lwingmove_2"){
                            lwing.style.msAnimationName = "lwingmove";                      
                        }
			        } 
			        if (rwing){ 
			        	rwing.style.webkitAnimationDuration = app.dotAnimationFastSpeed; 
			        	rwing.style.mozAnimationDuration = app.dotAnimationFastSpeed; 
			        	rwing.style.OAnimationDuration = app.dotAnimationFastSpeed;	
			        	rwing.style.animationDuration = app.dotAnimationFastSpeed; 
			        	if (rwing.style.webkitAnimationName == "rwingmove"){  //hack for old webkit to force animation change
			        		rwing.style.webkitAnimationName = "rwingmove_2";
			        	} else if (rwing.style.webkitAnimationName == "rwingmove_2"){
			        		rwing.style.webkitAnimationName = "rwingmove";		        		
			        	} if (rwing.style.msAnimationName == "rwingmove"){ //IE
                            rwing.style.msAnimationName = "rwingmove_2";
                        } else if (rwing.style.msAnimationName == "rwingmove_2"){
                            rwing.style.msAnimationName = "rwingmove";                      
                        }
			        }
	            } else {
			        if (lwing){
			        	lwing.style.webkitAnimationDuration = app.dotAnimationSlowSpeed;
			        	lwing.style.mozAnimationDuration = app.dotAnimationSlowSpeed; 
			        	lwing.style.OAnimationDuration = app.dotAnimationSlowSpeed;
			        	lwing.style.animationDuration = app.dotAnimationSlowSpeed;
			        	if (lwing.style.webkitAnimationName == "lwingmove"){  //hack for old webkit to force animation change
			        		lwing.style.webkitAnimationName = "lwingmove_2";
			        	} else if (lwing.style.webkitAnimationName == "lwingmove_2"){
			        		lwing.style.webkitAnimationName = "lwingmove";		        		
			        	} if (lwing.style.msAnimationName == "lwingmove"){ //IE
                            lwing.style.msAnimationName = "lwingmove_2";
                        } else if (lwing.style.msAnimationName == "lwingmove_2"){
                            lwing.style.msAnimationName = "lwingmove";                      
                        }
			        }
			        if (rwing){ 
			        	rwing.style.webkitAnimationDuration = app.dotAnimationSlowSpeed;
			        	rwing.style.mozAnimationDuration = app.dotAnimationSlowSpeed; 
			        	rwing.style.OAnimationDuration = app.dotAnimationSlowSpeed;  
			        	rwing.style.animationDuration = app.dotAnimationSlowSpeed; 
			        	if (rwing.style.webkitAnimationName == "rwingmove"){  //hack for old webkit to force animation change
			        		rwing.style.webkitAnimationName = "rwingmove_2";
			        	} else if (rwing.style.webkitAnimationName == "rwingmove_2"){
			        		rwing.style.webkitAnimationName = "rwingmove";		        		
			        	} if (rwing.style.msAnimationName == "rwingmove"){ //IE
                            rwing.style.msAnimationName = "rwingmove_2";
                        } else if (rwing.style.msAnimationName == "rwingmove_2"){
                            rwing.style.msAnimationName = "rwingmove";                      
                        }
			        }
	            }
                app.dotHopStop = !app.dotHopStop;
                app.moveDotHopCalcTime();
                app.dotDir = Math.round(Math.random()*8-0.5); //any random direction
            }
        }
        if (!app.dotHopStop || app.dotNewPoint){ app.moveDotandBoundsCollision(); }
        //calculate time to move dot depending on level
        var base_time = 25; //tinker (40fps = 25) (30fps = 33) (25fps = 40) 
        var level_time = (app.level) / app.dotSizeCompensation();//* 3; //* 0.5;//* 3;
        var accel_time = Math.round(Math.pow(app.dotAccel,-1)*200);
        var time = (base_time + level_time + accel_time);
        setTimeout(app.moveDot,time);
    },
    //level up!
    dotPressed : function(e){
        if (e.preventManipulation){ e.preventManipulation(); } //some versions IE...
        if (app.dotStop){ return; } //stopped and not ready to be pressed
        app.dotStop = true;
        var dotclick = this;
        dotclick.removeEventListener('mousedown',app.dotPressed);
        dotclick.removeEventListener('touchstart',app.dotPressed);
        dotclick.removeEventListener("MSPointerDown",app.dotPressed);
        dotclick.removeEventListener("pointerdown",app.dotPressed); 
        app.level += 1;
        //stop bug wings
        var lwing = document.getElementById("dot_lwing");
        if (lwing){
        	lwing.style.webkitAnimationDuration = "0s";
        	lwing.style.mozAnimationDuration = "0s"; 
        	lwing.style.OAnimationDuration = "0s";
        	lwing.style.animationDuration = "0s"; /* */
        	if (lwing.style.webkitAnimationName == "lwingmove"){ //hack for old webkit to force animation change
        		lwing.style.webkitAnimationName = "lwingmove_2";
        	} else if (lwing.style.webkitAnimationName == "lwingmove_2"){
        		lwing.style.webkitAnimationName = "lwingmove";		        		
        	} if (lwing.style.msAnimationName == "lwingmove"){ //IE
                lwing.style.msAnimationName = "lwingmove_2";
            } else if (lwing.style.msAnimationName == "lwingmove_2"){
                lwing.style.msAnimationName = "lwingmove";                      
            }
        }
        var rwing = document.getElementById("dot_rwing");
        if (rwing){ 
        	rwing.style.webkitAnimationDuration = "0s";
        	rwing.style.mozAnimationDuration = "0s"; 
        	rwing.style.OAnimationDuration = "0s";
        	rwing.style.animationDuration = "0s";  
        	if (rwing.style.webkitAnimationName == "rwingmove"){  //hack for old webkit to force animation change
        		rwing.style.webkitAnimationName = "rwingmove_2";
        	} else if (rwing.style.webkitAnimationName == "rwingmove_2"){
        		rwing.style.webkitAnimationName = "rwingmove";		        		
        	} if (rwing.style.msAnimationName == "rwingmove"){ //IE
                rwing.style.msAnimationName = "rwingmove_2";
            } else if (rwing.style.msAnimationName == "rwingmove_2"){
                rwing.style.msAnimationName = "rwingmove";                      
            }
        }
        //play sound
        var successSound = document.getElementById("game_audio_success");
        if (successSound){
            if(successSound.readyState == 4){ //problems with setting currentTime on invalidState  
                successSound.currentTime = 0;
            }
            successSound.play();
        } 
        //animate out and restart dot movement afterwards
        var splat = document.getElementById("splat"+app.level%5);
        splat.style.visibility = "visible";
        var dot = document.getElementById("game_dot");
        var op = 1;  // initial opacity
        if (!dot){ if(app.debug){ console.log("ERROR: missing element dotPressed: game_dot",dot); } op=0; } //bad
        var timer = setInterval(function () {
            if (op <= 0.1){ //done animation
                clearInterval(timer);
        		splat.style.visibility = "hidden";
                //update level
                if (app.level > app.maxLevel){
                    app.gameWin();
                    return;
                }
                app.gameUpdateLevel();
                app.gameUpdateHR();
        		app.dotAccel = 100;
                //relaunch moveDot (assume was stopped after animation)
                app.dotStop = false;
                app.dotNewPoint = true;
                app.launchMoveDots();
		        if (lwing){
		        	lwing.style.webkitAnimationDuration = app.dotAnimationFastSpeed;
		        	lwing.style.mozAnimationDuration = app.dotAnimationFastSpeed;
		        	lwing.style.OAnimationDuration = app.dotAnimationFastSpeed;
		        	lwing.style.animationDuration = app.dotAnimationFastSpeed;
		        	if (lwing.style.webkitAnimationName == "lwingmove"){ //hack for old webkit to force animation change
		        		lwing.style.webkitAnimationName = "lwingmove_2";
		        	} else if (lwing.style.webkitAnimationName == "lwingmove_2"){
		        		lwing.style.webkitAnimationName = "lwingmove";		        		
		        	} if (lwing.style.msAnimationName == "lwingmove"){ //IE
                        lwing.style.msAnimationName = "lwingmove_2";
                    } else if (lwing.style.msAnimationName == "lwingmove_2"){
                        lwing.style.msAnimationName = "lwingmove";                      
                    }
	        	}
		        if (rwing){ 
		        	rwing.style.webkitAnimationDuration = app.dotAnimationFastSpeed;
		        	rwing.style.mozAnimationDuration = app.dotAnimationFastSpeed;
		        	rwing.style.OAnimationDuration = app.dotAnimationFastSpeed;
		        	rwing.style.animationDuration = app.dotAnimationFastSpeed;   
		        	if (rwing.style.webkitAnimationName == "rwingmove"){  //hack for old webkit to force animation change
		        		rwing.style.webkitAnimationName = "rwingmove_2";
		        	} else if (rwing.style.webkitAnimationName == "rwingmove_2"){
		        		rwing.style.webkitAnimationName = "rwingmove";		        		
		        	} if (rwing.style.msAnimationName == "rwingmove"){ //IE
                        rwing.style.msAnimationName = "rwingmove_2";
                    } else if (rwing.style.msAnimationName == "rwingmove_2"){
                        rwing.style.msAnimationName = "rwingmove";                      
                    }
		        }
                dotclick.addEventListener('mousedown',app.dotPressed);
                dotclick.addEventListener('touchstart',app.dotPressed);
                dotclick.addEventListener("MSPointerDown",app.dotPressed);
        		dotclick.addEventListener("pointerdown",app.dotPressed);
                dot.style.opacity = 1;
                dot.style.filter = 'alpha(opacity=' + 100 + ")";
            } else {
                dot.style.opacity = op;
                dot.style.filter = 'alpha(opacity=' + op * 100 + ")";
                op -= op * 0.1;
            }
        }, 50);
    },
    //game update level on screen
    gameUpdateLevel : function(){
        var dot = document.getElementById("game_dot");
        var slevel = document.getElementById("game_level");
        if (slevel){ slevel.innerHTML = app.level; } 
        app.gameSaveState();
    },
    //finish game
    gameWin : function(){        
        var numcats = 10;
        app.gameOff = true;        
        var winSound = document.getElementById("game_audio_win");
        if (winSound){
            if(winSound.readyState == 4){ //problems with setting currentTime on invalidState  
                winSound.currentTime = 0;
            } 
            winSound.play();
        } 
        var winscreen = document.getElementById("game_win");
        if (winscreen){ 
            var wintext = document.getElementById("game_win_text");
            if (wintext){
	            var newhighscore = false;
            	var hs = []; 
		        if (app.lsAvail()){
		            if (localStorage.highscores){
		                hs = JSON.parse(localStorage.highscores);
		            }
		            if (hs.length > 0){ 	 //       var currScore = [app.level, app.totalTime, app.totalClicks];	            	
			            if(app.level > hs[0][0] || 
			                (app.level==hs[0][0] && app.totalTime<hs[0][1]) || 
			                (app.level==hs[0][0] && app.totalTime==hs[0][1] && app.totalClicks<hs[0][2])){ 
			                	newhighscore = true; }
		            }
		        }
		        if (newhighscore) {
		        	wintext.innerHTML = "NEW RECORD!!!";
		        } else {
		        	wintext.innerHTML = "YOU WIN!";
		        }
            }
            winscreen.style.display = "block";
        }
        //animate until nav to home screen....
        setTimeout(function(winscreen,winSound){
                app.gameSaveNewHighScore(); //save score!
                app.navTo("home");
                winscreen.style.display = "none";
                if (winSound){
                    winSound.pause(); 
                } 
            }.bind(undefined,winscreen,winSound),6000);
    },
    //game click, increment total clicks and update hit rate
    gameUpdatePress : function(e){
        if (app.gameOff){ return; }
        if (app.pullStarted && !app.dotStop){ return; } //pull tab & bug not squashing
        if (!app.pressEnable){ return; } //press event delay
        app.pressEnable = false; 
        setTimeout(function(){ app.pressEnable = true; },app.pressDelayTime);
        app.totalClicks += 1;
        app.gameUpdateHR();
    },
    //update hit rate
    gameUpdateHR : function(){
        var shr = document.getElementById("game_hr");
        if (shr){
            shr.innerHTML = app.calcHR(app.level,app.totalClicks); 
        }        
        app.gameSaveState();
    },
    //update game timer
    gameUpdateTime : function(){ 
        if (app.gameOff) { return; }
        var gt = document.getElementById("game_time");
        if (gt){ gt.innerHTML = app.convertMStoString(app.totalTime); } 
        app.gameSaveState();  
        app.totalTime += app.timeCounterElapse; //start at 0
    },
    //call all functions that refresh the game score information
    updateGameScore : function(){
        app.gameUpdateTime();
        app.gameUpdateHR();
        app.gameUpdateLevel();
    },
    //update current game storage
    gameSaveState : function(){
        if (app.lsAvail() && app.level > 1 && app.totalTime > 0 && app.totalClicks > 0){
            localStorage.continuegame = JSON.stringify([app.level,app.totalTime,app.totalClicks]);
        }
    },
    //save new potential high score
    //reset current score and localStorage.continuegame
    gameSaveNewHighScore : function(){
        if (!app.lsAvail()){ //can't use ls
            app.level = 1;
            app.totalTime = 0;
            app.totalClicks = 0;
            return; 
        } 
        var currScore = [app.level, app.totalTime, app.totalClicks];
        if (app.level <= 1 || app.totalTime < 1 || app.totalClicks < 1){ 
            if (!localStorage.continuegame){
                app.level = 1;
                app.totalTime = 0;
                app.totalClicks = 0;
                app.updateGameScore();
                return; //nothing to save
            } else {
                currScore = JSON.parse(localStorage.continuegame);
            }
        }
        app.level = 1; //reset current score for new game
        app.totalTime = 0;
        app.totalClicks = 0;
        localStorage.removeItem("continuegame");
        app.updateGameScore();
        hs = []; //save high scores
        if (localStorage.highscores){ hs = JSON.parse(localStorage.highscores); }
        for (var i=0; i<app.maxHighScores; i++){
            if (!hs[i]){
                hs[i] = currScore;
                break;
            } //[level, time, clicks]
            if (currScore[0] > hs[i][0] || 
                (currScore[0]==hs[i][0] && currScore[1]<hs[i][1]) || 
                (currScore[0]==hs[i][0] && currScore[1]==hs[i][1] && currScore[2]<hs[i][2])){
                hs.splice(i,0,currScore);
                break;
            }
        }
        if (hs.length > app.maxHighScores){ hs.pop(); }
        localStorage.highscores = JSON.stringify(hs);
    },
   
    //pull down the tab to show the game pause button, return to home page
    //initiate tab pull down listening
    startTabPull : function(e){ 
        if (app.pullStarted){ return; } //already started
        app.pullStarted = true;
    	var game = document.getElementById("game");
    	var tabtriangle = document.getElementById("pull_tab_triangle");
		var tab = document.getElementById("pull_tab");
    	if (!game || !tab){ if(app.debug){ console.log("ERROR: missing element startTabPull: game or pull_tab",game,tab); } return; } //bad
    	game.addEventListener("mousemove",app.moveTab); //all the touch events
    	game.addEventListener("touchmove",app.moveTab); 
    	game.addEventListener("pointermove",app.moveTab); 
        game.addEventListener("MSPointerMove",app.moveTab);
    	game.addEventListener("mouseup",app.endTabPull); 
    	game.addEventListener("touchend",app.endTabPull); 
    	game.addEventListener("pointerup",app.endTabPull); 
        game.addEventListener("MSPointerUp",app.endTabPull);
    	tab.removeEventListener("mousedown",app.startTabPull); 
    	tab.removeEventListener("touchstart",app.startTabPull); 
    	tab.removeEventListener("pointerdown",app.startTabPull); 
        tab.removeEventListener("MSPointerDown",app.startTabPull);
    	if (tabtriangle){ tabtriangle.style.borderTopColor = "#E8DE00"; }
    	var decamt = 0; //calculate start click Y pullTabStartY, take into account how far out the tab is already pulled
    	var tabtop = parseInt(tab.style.top);
    	if (!isNaN(tabtop)){
    		decamt = -app.pullTabMax-tabtop;
    	}
    	app.pullTabStartY = app.getYCoord(e)+decamt; 
    },
    //move tab back up, only revert if there has been no more pulls on the tab and pullTabStartY has not changed
    revertTab : function(yval){
    	if (app.pullTabStartY == yval){
    		var tabtriangle = document.getElementById("pull_tab_triangle");
    		if (tabtriangle){ tabtriangle.style.borderTopColor = "#0e1d18"; }
    		var tab = document.getElementById("pull_tab");
    		if (!tab){ if(app.debug){ console.log("ERROR: missing element revertTab: pull_tab",tab); } return; } //bad
			tab.style.top = "-"+app.pullTabMax+"px";
    	}
    },
    //touch/click drag done, end tab pull
    endTabPull : function(e){
    	var game = document.getElementById("game");
		var tab = document.getElementById("pull_tab");
    	if (!game || !tab){ if(app.debug){ console.log("ERROR: missing element endTabPull: game or pull_tab",game,tab); } return; } //bad
    	game.removeEventListener("mousemove",app.moveTab); //all the touch events
    	game.removeEventListener("touchmove",app.moveTab); 
    	game.removeEventListener("pointermove",app.moveTab); 
        game.removeEventListener("MSPointerMove",app.moveTab);
    	game.removeEventListener("mouseup",app.endTabPull); 
    	game.removeEventListener("touchend",app.endTabPull); 
    	game.removeEventListener("pointerup",app.endTabPull); 
        game.removeEventListener("MSPointerUp",app.endTabPull);
    	tab.addEventListener("mousedown",app.startTabPull); 
    	tab.addEventListener("touchstart",app.startTabPull); 
    	tab.addEventListener("pointerdown",app.startTabPull); 
        tab.addEventListener("MSPointerDown",app.startTabPull);
    	var ymatch = Math.random(); 
    	app.pullTabStartY = ymatch; //decipher between later pulls
    	if (app.gameOff){
    		app.revertTab(ymatch);
    	} else {
    		setTimeout(function(){ app.revertTab(ymatch); },1000);
    	}
        app.pullStarted = false;
    },
    //move tab during pull
    moveTab : function(e){ 
		var tab = document.getElementById("pull_tab");
		if (!tab){ if(app.debug){ console.log("ERROR: missing element moveTab: pull_tab",tab); } return; } //bad
		var mvmt = -app.pullTabMax+app.getYCoord(e)-app.pullTabStartY;
		if (mvmt <-app.pullTabMax){ mvmt = -app.pullTabMax; }
		if (mvmt >0){ mvmt = 0; }
		tab.style.top = mvmt+"px";	    	
    },
    //get yClient or touch coordinates, if cannot access, will return 0
    getYCoord : function(e){
        var y = parseInt(e.clientY);
        if (isNaN(y)){
            if (e.touches){
                if (e.touches.length){
                    y = parseInt(e.touches[0].pageY);
                }
            }
        }
        if (isNaN(y)){ y=0; }
        return y;
    }
};

app.initialize();