$(document).ready(function(){
  var canvas = $("#hoge").get(0);
  var ctx = canvas.getContext("2d");
  
  var width = 0, height = 0;
  var x = 0, y = 0;
  var dest = -1;
  var v0 = 100;
  var g = 15.7;
  var degree = 90;
  var startFrame = 0;
  var frame = 0;
  var timer = 0;
  var rate = 20;
  var clicky = 0;
  var goal = 650;
  var diff = 0;
  var stop = 0;
  var speed = 0;
  var inited = false;
  
  var bgimg = new Image();
  bgimg.src = "img/icon/icon128.png";
  bgimg.onload = function() {
    function init(){
      width = $(window).width();
      height = $(window).height() - 10;
      canvas.style.width = width+"px";
      canvas.style.height = height+"px";
      canvas.width = width;
      canvas.height = height;
      draw();
    }
    
    function draw(){
      ++frame;
      ctx.fillStyle = "rgb(255, 255, 255)";
      ctx.fillRect(0, 0, width, height);
      ctx.fillStyle = "rgb(0, 0, 255)";
      ctx.fillRect(0, goal-50, width, 100);
      ctx.fillStyle = "rgb(255, 255, 255)";
      ctx.fillStroke = 10;
      ctx.font = "30pt Arial";
      ctx.fillText("HERE", width/2-55, goal);
      ctx.fillStyle = "rgb(2, 2, 2)";
      ctx.font = "10pt Arial";
      ctx.fillText("speed:"+speed, 10, 10);
      ctx.drawImage(bgimg, x, y, 128, 128);
      if (stop == 0) {
        if (stop == 0) {
          showTap();
        }
        if (!inited) {
          initPos();
        }
        inited = true;
      } else if (stop == 1 && inited) {
        if (frame > startFrame) {
          ++timer;
          getPos(timer, rate);
        }
        ctx.fillStyle = "rgb(200,200, 200)";
        ctx.fillStroke = 10;
        ctx.font = "30pt Arial";
        ctx.fillText("CATCH ME", width/2-110, height/2);
      } else if (stop == 2) {
        showResult();
      }
      mozRequestAnimationFrame(draw);
    }
    //Gravity
    //y=1/2gt2
    function getPos(tt, rate) {
      t = tt / rate;
      rad = degree * Math.PI / 180;
      //x = (dest*v0) * Math.cos(rad) * t;
      y += ((dest*v0) * Math.sin(rad) * t) + 0.5 * g * (t * t);
      speed = Math.round(9.8*t);
    }
    
    function initPos(){
      x = width / 2 - 64;
      //y = -1 * (Math.random() * 100) * (Math.random() * 100);
      y = -14;
      v0 = -1 * (Math.random() * 10) * (Math.random() * 10);
      goal = height - 64;
      startFrame = Math.round(Math.random() * 300) + 10;
      
      inited = true;
    }
    
    function showTap() {
      ctx.fillStyle = "rgb(0, 0, 200)";
      ctx.fillStroke = 10;
      ctx.font = "30pt Arial";
      ctx.fillText("TAP", width/2-38, height/2);
    }
    
    function showResult() {
      if ((y+114) < (goal-50) || (y+14) > (goal+50)) {
        diff = 20;
      } else if ((y+14) == (goal-50) || (y+114) == (goal+50)) {
        diff = 0;
      } else {
        diff = 10;
      }
      ctx.fillStyle = "rgb(255, 0, 0)";
      ctx.fillStroke = 4;
      ctx.font = "20pt Arial";
      if (diff <= 5)
        ctx.fillText("GREAT!!!", width/2-60, height/2);
      if (diff > 5 && diff <= 15)
        ctx.fillText("GOOD!!", width/2-50, height/2);
      if (diff > 15)
        ctx.fillText("BAD!", width/2-24, height/2);
      
      speed = 0;
    }

    init();
  }
  canvas.addEventListener('click', function(e){
    clicky = y;
    frame = 0;
    timer = 0;
    if (stop < 2) stop++;
    else {
      stop = 0;
      inited = false;
      g = g * (Math.random() * 1.5);
    }
  });
});