import org.jbox2d.util.nonconvex.*;
import org.jbox2d.dynamics.contacts.*;
import org.jbox2d.testbed.*;
import org.jbox2d.collision.*;
import org.jbox2d.common.*;
import org.jbox2d.dynamics.joints.*;
import org.jbox2d.p5.*;
import org.jbox2d.dynamics.*;

Physics physics;
Body droid;
Body [] crates;
Body [] badcrates;
Vec2 startPoint;
CollisionDetector detector; 

int crateSize = 35;
int ballSize = 40;

PImage crateImage, badcrateImage, ballImage, gstar, sstar, bstar, laun, scor, tip;

int score, launches, level;
float scolaun;
int [] star;

int i,j;
boolean dragging = false;
boolean gameover = false;

void setup() {
  size(screenWidth, screenHeight);
  
  score = 0;
  launches = 0;
  level = 0;

  tip = loadImage("table.jpg");
  scor = loadImage("score.png");
  laun = loadImage("launches.png");
  gstar = loadImage("gstar.png");
  sstar = loadImage("sstar.png");
  bstar = loadImage("bstar.png");
  crateImage = loadImage("ball.png");
  badcrateImage = loadImage("badball.png");
  ballImage = loadImage("wball.png");
  imageMode(CENTER);
  
  star = new int[20];
   
  physics = new Physics(this, width, height, 0, 0, width*2, height*2, width, height, 100);
  physics.setCustomRenderingMethod(this, "myCustomRenderer");
  physics.setDensity(10.0);
  
  crates = new Body[15];
  for (i = 0; i < crates.length; i++)  crates[i] = physics.createCircle(random(30, width-30), random(30, height-30), crateSize/2);
  
  badcrates = new Body[5];
  for (j = 0; j < badcrates.length; j++)  badcrates[j] = physics.createCircle(random(30, width-30), random(30, height-30), crateSize/2);

  startPoint = new Vec2(width/2, height/2);
  startPoint = physics.screenToWorld(startPoint);

  droid = physics.createCircle(width/2, height/2, ballSize/2);

  detector = new CollisionDetector (physics, this);
}

void draw() {image(tip, width/2, height/2, width, height);}

void mousePressed()
{
  if (gameover == false)
  {
  dragging = true;
  startPoint = new Vec2(mouseX, mouseY);
  startPoint = physics.screenToWorld(startPoint);
  }
}

void mouseDragged() {}

void mouseReleased()
{
  if (gameover)
  {
  gameover = false;
  score = 0;
  launches = 0;
  level = 0;
  }
  else
  {
  dragging = false;
  Vec2 impulse = new Vec2();
  impulse.set(startPoint);
  impulse = impulse.sub(droid.getWorldCenter());
  impulse = impulse.mul(50);
  droid.applyImpulse(impulse, droid.getWorldCenter());
  ++launches;
  if (launches >= 999) gameover = true;
  scolaun = score/launches;
  }
}

void myCustomRenderer(World world) {
  if (gameover)
  {
  fill(0,150);
  rect(width/2-150, height/2-100, 300, 200);
  fill(255);
  textSize(50);
  text("Game over", width/2-125, height/2+22);
  for (i = 0; i < level; i++)
  {
    if (star[i] == 1) image(gstar, 20+(i*20), 20, 30, 30);
    if (star[i] == 2) image(sstar, 20+(i*20), 20, 30, 30);
    if (star[i] == 3) image(bstar, 20+(i*20), 20, 30, 30);
  }
  }  
  else
  {
  Vec2 screenStartPoint = physics.worldToScreen(startPoint);

  Vec2 screenDroidPos = physics.worldToScreen(droid.getWorldCenter());
  float droidAngle = physics.getAngle(droid);
  if (dragging)
  {
    droid.setPosition(physics.screenToWorld(new Vec2(mouseX, mouseY)));
    stroke(255);
    strokeWeight(3);
    point(screenStartPoint.x, screenStartPoint.y);
    strokeWeight(1);
    line(screenDroidPos.x, screenDroidPos.y, screenStartPoint.x, screenStartPoint.y);
  }
  pushMatrix();
  translate(screenDroidPos.x, screenDroidPos.y);
  rotate(-radians(droidAngle));
  image(ballImage, 0, 0, ballSize, ballSize);
  popMatrix();

  for (i = 0; i < crates.length; i++)
  {
    Vec2 worldCenter = crates[i].getWorldCenter();
    Vec2 cratePos = physics.worldToScreen(worldCenter);
    float crateAngle = physics.getAngle(crates[i]);
    pushMatrix();
    translate(cratePos.x, cratePos.y);
    rotate(-crateAngle);
    image(crateImage, 0, 0, crateSize, crateSize);
    popMatrix();
  }
  for (j = 0; j < badcrates.length; j++)
  {
    Vec2 worldCenter = badcrates[j].getWorldCenter();
    Vec2 badcratePos = physics.worldToScreen(worldCenter);
    float badcrateAngle = physics.getAngle(badcrates[j]);
    pushMatrix();
    translate(badcratePos.x, badcratePos.y);
    rotate(-badcrateAngle);
    image(badcrateImage, 0, 0, crateSize, crateSize);
    popMatrix();
  }
  
  noStroke();  
  fill(0,150);
  rect(width-85, 5, 80, 20);
  
  fill(205,127,50,150);
  rect(width-85, 5, 16, 20);
  fill(192,192,192,150);
  rect(width-69, 5, 16, 20);
  fill(255,215,0,150);
  rect(width-53, 5, 16, 20);
  fill(192,192,192,150);
  rect(width-37, 5, 16, 20);
  fill(205,127,50,150);
  rect(width-21, 5, 16, 20);
  
  stroke(255,150);
  if (scolaun-10 < -5)
  line(width-85, 5, width-85, 2);
  if (abs(scolaun-10) <= 5)
  line(int(width+8*scolaun-125), 5, int(width+8*scolaun-125), 25);
  if (scolaun-10 > 5)
  line(width-5, 5, width-5, 25);
  
  noStroke();
  fill(0,150);
  rect(5, height-30, 70, 26);
  image(scor, 18, height-18, 16, 16);  
  rect(width-75, height-30, 70, 25);
  image(laun, width-62, height-18, 16, 16);
  
  fill(255);
  textSize(16);
  text(score, 31, height-11);
  text(launches, width-49, height-11);
  
  for (i = 0; i < level; i++)
  {
    if (star[i] == 1) image(gstar, 15+(i*14), 15, 20, 20);
    if (star[i] == 2) image(sstar, 15+(i*14), 15, 20, 20);
    if (star[i] == 3) image(bstar, 15+(i*14), 15, 20, 20);
  }
  }
}

void collision(Body b1, Body b2, float impulse)
{
  if ((dragging == false) && ((b1 == droid) || (b2 == droid)))
  {
    for (i = 0; i < crates.length; i++)
    if ((b1 == crates[i]) || (b2 == crates[i])) ++score;
    for (j = 0; j < badcrates.length; j++)
    if ((b1 == badcrates[j]) || (b2 == badcrates[j])) --score;
    scolaun = score/launches;
    if (score%100 == 0)
    {
      if (abs(scolaun-10) <= 1) star[level] = 1;
      if (abs(scolaun-10) > 1 && abs(scolaun-10) <= 3) star[level] = 2;
      if (abs(scolaun-10) > 3) star[level] = 3;
      level = score/100;
      if (level >= 15) gameover = true;
    }
  }
}
