/**
 * @author: Karthik VJ
 */

;(function() {
    "use strict";

    var Event = {
        "LOAD" : "load",
        "RESIZE" : "resize",
        "ORIENTATION_CHANGE" : "orientationchange"
    };

    var KeyboardEvent = {
      "KEY_PRESS" : "keypress",
      "KEY_UP" : "keyup"
    };

    var Key = {
        "BACKSPACE"     : 8,
        "TAB"           : 9,
        "DOT"           : 46,
        "UP_ARROW"      : 38,
        "DOWN_ARROW"    : 40,
        "LEFT_ARROW"    : 37,
        "RIGHT_ARROW"   : 39,
        "HOME"          : 36,
        "END"           : 35
    };

    var ElementID = {
        "Celsius_TF" : "celsius_tf",
        "Fahrenheit_TF" : "fah_tf",
        "MAIN" : "main"
    };


    var Util = function() { throw new Error("Static class!"); };
    Util.convertCelsiusToFahrenheit = function(value)
    {
        value = parseFloat(value);

        if(isNaN(value))
        {
            return "";
        }

        return parseFloat(((value * 1.8) + 32).toFixed(4)).toString();
    };

    Util.convertFahrenheitToCelsius = function(value)
    {

        value = parseFloat(value);

        if(isNaN(value))
        {
            return "";
        }

        return parseFloat(((value - 32) / 1.8).toFixed(4));
    };


    var Main = (function()
    {
        var celsiusTextField;
        var fahrenheitTextfield;
        var mainHolder;

        function Main()
        {
            console.log("main");
            window.addEventListener(Event.LOAD, init);
        }

        var init = function()
        {
            console.log("window load complete");
            mainHolder = document.getElementById(ElementID.MAIN);

            celsiusTextField = document.getElementById(ElementID.Celsius_TF);
            celsiusTextField.focus();
            fahrenheitTextfield = document.getElementById(ElementID.Fahrenheit_TF);

            celsiusTextField.addEventListener(KeyboardEvent.KEY_PRESS, onKeyPress);
            celsiusTextField.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);

            fahrenheitTextfield.addEventListener(KeyboardEvent.KEY_PRESS, onKeyPress);
            fahrenheitTextfield.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);

            window.addEventListener(Event.RESIZE, onResizeHandler, false);
            window.addEventListener(Event.ORIENTATION_CHANGE, onResizeHandler, false);
            onResizeHandler(null);
        };

        var onResizeHandler = function(event)
        {
            //alert(mainHolder.style.height);
            var posY = (window.innerHeight >> 1) - 130;
            mainHolder.style.top = posY + "px";
        };

        var onKeyPress = function(event)
        {
            var keyCode = event.keyCode || event.charCode;
            var currentValue = event.target.value;
            //console.log(keyCode);

            if(keyCode === Key.BACKSPACE || keyCode === Key.RIGHT_ARROW || keyCode === Key.LEFT_ARROW || keyCode === Key.HOME || keyCode === Key.END || keyCode === Key.TAB)
            {
                return;
            }

            if(keyCode === Key.DOT)
            {
                if(currentValue.indexOf(".") !== -1)
                {
                    event.preventDefault();
                }

            }
            var regex = new RegExp("[0-9.]");
            var char = String.fromCharCode(keyCode);
            //console.log(char);
            var result = regex.test(char);
            //console.log(result);

            if(result === false)
            {
                event.preventDefault();
            }

        };

        var onKeyUp = function(event)
        {
            var targetId = event.target.id;

            if(targetId === ElementID.Celsius_TF)
            {
                fahrenheitTextfield.value = Util.convertCelsiusToFahrenheit(celsiusTextField.value);
            }
            else if(targetId === ElementID.Fahrenheit_TF)
            {
                celsiusTextField.value = Util.convertFahrenheitToCelsius(fahrenheitTextfield.value);
            }
        };


        return Main;
    }());

    var main = new Main();

}());