 /*
 
 Fichier : Centeuro.js
 
 Rôle : JavaScript lié au fichier index.html
  
 Version : <2.0>
 
 Copyright (C) 2014 Patrice Fouquet. Tous droits réservés.
 
 */ 

//---------------------------------------------------------------------------
const stVersion = '2.0';
//---------------------------------------------------------------------------
const monnaies = 15;
const dimensions = 6;
const directions = 4;
const t0 = 320;
//---------------------------------------------------------------------------
const dx = [0, 0, 1, 0, -1];
const dy = [0, -1, 0, 1, 0];
//---------------------------------------------------------------------------
const svt = [0,3,3,0,6,6,0,9,9,0,12,12,0,15,15,0];
const ter = [0,1,1,0, 1, 1, 0,  1,  1,  0,   1,   1,   0,    1,    1,    0];
const bis = [0,1,0,1, 1, 0, 1,  1,  0,  1,   1,   0,   1,    1,    0,    0];
const val = [0,1,2,5,10,20,50,100,200,500,1000,2000,5000,10000,20000,50000];
const bgc = ['#EFEFEF', // Case vide = gris
             '#FFEFDF','#FFE7CF','#FFDFBF', //Pièces rouges
             '#FFFFDF','#FFF7BF','#FFEF9F', //Pièces jaunes
             '#DFEFFF','#CFE7FF', //Pièces blanches/jaunes
             '#EFEFEF','#EFEFEF','#EFEFEF','#EFEFEF','#EFEFEF','#EFEFEF','#EFEFEF']; //Billets
//---------------------------------------------------------------------------
const chmPng = 'png/';
const extPng = '.png';
const vide = '';
const rien = '0';
const noir = 'n';
const rouge = 'r';
const fond = 'b';
const raz = 'raz';
const ok = 'ok';
const go = 'go';
const tuto = 'tuto';
const choix = 'chx';
const info = 'info';
const euro = 'euro';
const idDir = ' hdbg';
const idMvt = ' neso';
const imgCoul = 'nr';
const idMonnaieTop = 'mt';
const idTopMonnaieTop = 'tmt';
const idScore = 's';
const idTop = 't';
const idEuro = 'e';
const stScore = 'score';
const stTop = 'top'
const tc = [[[0,0,0,2,-1,-1],
             [0,0,2,-1,1,-1],
             [0,0,0,0,3,-1],
             [0,2,-1,7,-1,-1],
             [0,0,0,4,6,-1],
             [0,0,0,3,2,-1]],
            [[0,0,0,0,0,2],
             [0,0,0,0,2,1],
             [0,0,0,0,0,3],
             [0,0,0,0,2,7],
             [0,0,0,0,4,6],
             [0,0,0,0,3,2]],
            [[0,3,-1,3,-1,-1],
             [2,2,2,2,2,-1],
             [0,2,1,-1,2,-1],
             [0,0,1,2,2,-1],
             [0,2,-1,2,1,-1],
             [0,0,1,-1,1,-1]],
            [[0,0,0,0,0,4],
             [0,0,0,0,0,4],
             [0,0,0,0,0,3],
             [0,0,0,0,0,3],
             [0,0,0,0,0,3],
             [0,0,0,0,0,2]]];
//---------------------------------------------------------------------------
const haut = 1;
const droite = 2;
const bas = 3;
const gauche = 4;
//---------------------------------------------------------------------------
var imgRAZ = null;    	// Ne pas sauvegarder
var taille = 32;        // Ne pas sauvegarder
var score = 0;
var monnaieTop = 0;  
var topScore = 0;       // Sauvegardé hors partie 
var topMonnaieTop = 0; 	// Sauvegardé hors partie
var fin = false;      	// Ne pas sauvegarder
var alerte = false;   	// Ne pas sauvegarder
var posTuto = 0; 		// Ne pas sauvegarder
var touchable = false;	// Ne pas sauvegarder
var c = [[0,0,0,0,0,0],
         [0,0,0,0,0,0],
         [0,0,0,0,0,0],
         [0,0,0,0,0,0],
         [0,0,0,0,0,0],
         [0,0,0,0,0,0]];
//---------------------------------------------------------------------------
function afficheCase(x, y)
{
  localStorage.setItem('c'+(x)+(y), c[x][y]);
  var k = taille/t0;
  var img = document.getElementById(vide + x + vide + y + vide);
  img.height = Math.round(k*t0);
  img.width = Math.round(k*t0);
  if (c[x][y]<0) {
    img.src = chmPng + idMvt[-c[x][y]] + extPng;
    document.getElementById(fond + x + vide + y).bgColor = bgc[0];
  }
  else {
    img.src = chmPng + val[c[x][y]] + extPng;
    document.getElementById(fond + x + vide + y).bgColor = bgc[c[x][y]];
  }
}
//---------------------------------------------------------------------------
function afficheScore()
{
  localStorage.s = score;
  if (score>topScore) {
    topScore = score;
    localStorage.ts = topScore;
    afficheTops(); // v1.1 : à la place du code de la fonction moins l'affiche MonnaieTop en bas de cette fonction
  }
  var zerosSignificatifs = false;
  var chfScore = [score%10,
                  (Math.floor(score/10)%10),
                  (Math.floor(score/100)%10),
                  (Math.floor(score/1000)%10),
                  (Math.floor(score/10000)%10),
                  (Math.floor(score/100000)%10),
                  (Math.floor(score/1000000)%10)];
  document.getElementById('smm').src = chmPng + (chfScore[6]?chfScore[6]+noir:rien) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfScore[6]>0);
  document.getElementById('scm').src = chmPng + (chfScore[5]?chfScore[5]+noir:(zerosSignificatifs?chfScore[5]+noir:rien)) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfScore[5]>0);
  document.getElementById('sdm').src = chmPng + (chfScore[4]?chfScore[4]+noir:(zerosSignificatifs?chfScore[4]+noir:rien)) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfScore[4]>0);
  document.getElementById('sm').src = chmPng + (chfScore[3]?chfScore[3]+noir:(zerosSignificatifs?chfScore[3]+noir:rien)) + extPng;
  document.getElementById('sc').src = chmPng + chfScore[2] + noir + extPng;
  document.getElementById('sd').src = chmPng + chfScore[1] + noir + extPng;
  document.getElementById('su').src = chmPng + chfScore[0] + noir + extPng;
}
//---------------------------------------------------------------------------
function afficheMonnaieTop()
{
  document.getElementById(idMonnaieTop).src = chmPng + val[monnaieTop] + extPng;
  document.getElementById(fond + idMonnaieTop).bgColor = bgc[monnaieTop];

  document.getElementById(idTopMonnaieTop).src = chmPng + val[topMonnaieTop] + extPng;
  document.getElementById(fond + idTopMonnaieTop).bgColor = bgc[topMonnaieTop];
}
//---------------------------------------------------------------------------
function afficheTops()
{
  var zerosSignificatifs = false;
  var chfTop = [topScore%10,
                (Math.floor(topScore/10)%10),
                (Math.floor(topScore/100)%10),
                (Math.floor(topScore/1000)%10),
                (Math.floor(topScore/10000)%10),
                (Math.floor(topScore/100000)%10),
                (Math.floor(topScore/1000000)%10)];
  document.getElementById('tmm').src = chmPng + (chfTop[6]?chfTop[6]+rouge:rien) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfTop[6]>0);
  document.getElementById('tcm').src = chmPng + (chfTop[5]?chfTop[5]+rouge:(zerosSignificatifs?chfTop[5]+rouge:rien)) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfTop[5]>0);
  document.getElementById('tdm').src = chmPng + (chfTop[4]?chfTop[4]+rouge:(zerosSignificatifs?chfTop[4]+rouge:rien)) + extPng;
  zerosSignificatifs = zerosSignificatifs || (chfTop[4]>0);
  document.getElementById('tm').src = chmPng + (chfTop[3]?chfTop[3]+rouge:(zerosSignificatifs?chfTop[3]+rouge:rien)) + extPng;
  document.getElementById('tc').src = chmPng + chfTop[2] + rouge + extPng;
  document.getElementById('td').src = chmPng + chfTop[1] + rouge + extPng;
  document.getElementById('tu').src = chmPng + chfTop[0] + rouge + extPng;
  document.getElementById(idTopMonnaieTop).src = chmPng + val[topMonnaieTop] + extPng;
}
//---------------------------------------------------------------------------
function regroupe(d)
{
  var regroupement = false;
  switch(d) {
    case haut:	
      for(var x=0; x<dimensions; x++)
        for(var y=0; y<dimensions; y++)
          if (!c[x][y])
            for(var yy=y+1; yy<dimensions; yy++)
              if (c[x][yy]) {
                 c[x][y] = c[x][yy];
                 afficheCase(x, y);
                 c[x][yy] = 0;
                 afficheCase(x, yy);
                 regroupement = true;
                 break;
              }
      break;
    case bas:	
      for(var x=0; x<dimensions; x++)
        for(var y=dimensions-1; y>=0; y--)
          if (!c[x][y])
            for(var yy=y-1; yy>=0; yy--)
              if (c[x][yy]) {
                 c[x][y] = c[x][yy];
                 afficheCase(x, y);
                 c[x][yy] = 0;
                 afficheCase(x, yy);
                 regroupement = true;
                 break;
              }
      break;
    case gauche:	
      for(var y=0; y<dimensions; y++)
        for(var x=0; x<dimensions; x++)
          if (!c[x][y])
            for(var xx=x+1; xx<dimensions; xx++)
              if (c[xx][y]) {
                 c[x][y] = c[xx][y];
                 afficheCase(x, y);
                 c[xx][y] = 0;
                 afficheCase(xx, y);
                 regroupement = true;
                 break;
              }
      break;
    case droite:	
      for(var y=0; y<dimensions; y++)
        for(var x=dimensions-1; x>=0; x--)
          if (!c[x][y])
            for(var xx=x-1; xx>=0; xx--)
              if (c[xx][y]) {
                 c[x][y] = c[xx][y];
                 afficheCase(x, y);
                 c[xx][y] = 0;
                 afficheCase(xx, y);
                 regroupement = true;
                 break;
              }
      break;
  }
  return regroupement;
}
//---------------------------------------------------------------------------
function testeMonnaieTop(x, y)
{
  if (c[x][y] > monnaieTop) {
    monnaieTop = c[x][y];
    localStorage.mt = monnaieTop;
    if (monnaieTop > topMonnaieTop) {
      topMonnaieTop = monnaieTop;  
      localStorage.tmt = topMonnaieTop;
    }
    afficheMonnaieTop();
  }
}
//---------------------------------------------------------------------------
function incrementeCase(d, x, y)
{
  c[x][y]++;
  testeMonnaieTop(x, y);
  score += val[c[x][y]];
  afficheScore();
  afficheCase(x, y);
  c[x+dx[d]][y+dy[d]] = 0;
  afficheCase(x+dx[d], y+dy[d]);
}
//---------------------------------------------------------------------------
function detripleCase(d, x, y, p0)
{
  c[x][y] = svt[p0];
  testeMonnaieTop(x, y);
  score += val[c[x][y]];
  afficheScore();
  afficheCase(x, y);
  for(var k=1; k<3; k++) {
    c[x+k*dx[d]][y+k*dy[d]] = 0;
    afficheCase(x+k*dx[d], y+k*dy[d]);
  }
}
//---------------------------------------------------------------------------
function dequintupleCase(d, x, y, p0)
{
  c[x][y] = svt[p0]+1;
  testeMonnaieTop(x, y);
  afficheCase(x, y);
  score += val[c[x][y]];
  afficheScore();
  for(var k=1; k<5; k++) {
    c[x+k*dx[d]][y+k*dy[d]] = 0;
    afficheCase(x+k*dx[d], y+k*dy[d]);
  }
}
//---------------------------------------------------------------------------
function joueCoup(d)
{
  var score0=score;
  // 1. regroupe
  var regroupement = regroupe(d);
  // 2. simplifie
  switch(d) {
    case haut:	
      for(var x=0; x<dimensions; x++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var y=0; y<dimensions; y++)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              incrementeCase(d, x, y);
              n = 0;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              detripleCase(d, x, y, p[2]);
              n = 0;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              dequintupleCase(d, x, y, p[4]);
              n = 0;
            }
          }
        }
      break;
    case bas:	
      for(var x=0; x<dimensions; x++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var y=dimensions-1; y>=0; y--)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              incrementeCase(d, x, y);
              n = 0;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              detripleCase(d, x, y, p[2]);
              n = 0;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              dequintupleCase(d, x, y, p[4]);
              n = 0;
            }
          }
        }
      break;
    case gauche:	
      for(var y=0; y<dimensions; y++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var x=0; x<dimensions; x++)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              incrementeCase(d, x, y);
              n = 0;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              detripleCase(d, x, y, p[2]);
              n = 0;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              dequintupleCase(d, x, y, p[4]);
              n = 0;
            }
          }
        }
      break;
    case droite:	
      for(var y=0; y<dimensions; y++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var x=dimensions-1; x>=0; x--)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              incrementeCase(d, x, y);
              n = 0;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              detripleCase(d, x, y, p[2]);
              n = 0;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              dequintupleCase(d, x, y, p[4]);
              n = 0;
            }
          }
        }
      break;
  }
  // 3. regroupe
  regroupe(d);
  // 4. tire
  if (regroupement||(score>score0))
    tirePiece();
}
//---------------------------------------------------------------------------
function tirePiece()
{
  var n=0;
  for(var i=0; i<dimensions; i++)
    for(var j=0; j<dimensions; j++)
      if (!c[i][j]) n++;
  n=Math.floor(n*Math.random());
  for(var i=0; (n>=0)&&(i<dimensions); i++)
    for(var j=0; (n>=0)&&(j<dimensions); j++) 
      if (!c[i][j]) {
        n--;
        if (n<0) {
          c[i][j]=1+Math.floor(2*Math.random());
          afficheCase(i, j);
        }
      }
}
//---------------------------------------------------------------------------
function sauvePartie()
{
  localStorage.centeuro = true;
  localStorage.s = score;
  localStorage.mt = monnaieTop;
  for(var i=0; i<dimensions; i++)
    for(var j=0; j<dimensions; j++)
      localStorage.setItem('c'+(i)+(j), c[i][j]);
}
//---------------------------------------------------------------------------
function initialiseGrille()
{
  for(var i=0; i<dimensions; i++)
    for(var j=0; j<dimensions; j++) {
      c[i][j]=0;
      afficheCase(i, j);
    }
}
//---------------------------------------------------------------------------
function initialisePartie()
{
  score = 0;
  monnaieTop = 0;
  afficheScore();
  afficheTops(); // v1.1 : afficheScore() n'affiche plus systématiquement les tops
  afficheMonnaieTop();
  initialiseGrille();
  tirePiece(); 
  tirePiece(); 
  sauvePartie();
}
//---------------------------------------------------------------------------
function adapteDimensions()
{
	var largeurEcran = document.getElementById('container').offsetWidth; 
	var n=document.images.length;
	var coef=largeurEcran/216;
	taille=32*coef;
	var hauteur=0;
	var largeur=0;
	for(var i=0; i<n; i++) {
		hauteur=parseInt(document.images[i].height);
		largeur=parseInt(document.images[i].width);
		document.images[i].height=Math.round(coef*hauteur);
		document.images[i].width=Math.round(coef*largeur);
	}
}
//---------------------------------------------------------------------------
function chargeTops()
{
  if (localStorage.getItem('ts'))
    topScore = parseInt(localStorage.ts);
  if (localStorage.getItem(idTopMonnaieTop))
    topMonnaieTop = parseInt(localStorage.tmt);
  afficheTops();
}
//---------------------------------------------------------------------------
function testePossibiliteCoup()
{ 
  var possible = false; // Pessimiste
  for(var d=1; d<=directions; d++)
   switch(d) {
    case haut:	
      for(var x=0; (!possible)&&(x<dimensions); x++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var y=0; (!possible)&&(y<dimensions); y++)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              possible = true;
              break;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              possible = true;
              break;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              possible = true;
              break;
            }
          }
        }
      break;
    case bas:	
      for(var x=0; (!possible)&&(x<dimensions); x++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var y=dimensions-1; (!possible)&&(y>=0); y--)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              possible = true;
              break;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              possible = true;
              break;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              possible = true;
              break;
            }
          }
        }
      break;
    case gauche:	
      for(var y=0; (!possible)&&(y<dimensions); y++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var x=0; (!possible)&&(x<dimensions); x++)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              possible = true;
              break;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              possible = true;
              break;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              possible = true;
              break;
            }
          }
        }
      break;
    case droite:	
      for(var y=0; (!possible)&&(y<dimensions); y++) {
        var p = [0, 0, 0, 0, 0];
        var n = 0;
        for(var x=dimensions-1; (!possible)&&(x>=0); x--)
          if (c[x][y]) {
            for(var k=4; k>0; k--)
              p[k] = p[k-1];
            p[0]=c[x][y];
            n++;
            if ((n>1)&&(bis[p[0]])&&(p[0]==p[1])) {
              possible = true;
              break;
            }
            if ((n>2)&&(ter[p[0]])&&(val[p[0]]+val[p[1]]+val[p[2]]==val[svt[p[2]]])) {
              possible = true;
              break;
            }
            if ((n>4)&&(ter[p[0]])&&(!bis[p[0]])&&(p[0]==p[1])&&(p[1]==p[2])&&(p[2]==p[3])&&(p[3]==p[4])) {
              possible = true;
              break;
            }
          }
        }
      break;
   }
  return possible;
}
//---------------------------------------------------------------------------
function reste()
 {
   casesVides = 0;
   for(var x=0; x<dimensions; x++)
     for(var y=0; y<dimensions; y++)
       if (!c[x][y])
         casesVides++;
  return casesVides;
 }
//---------------------------------------------------------------------------
function chargePartie()
{
  score = parseInt(localStorage.s);
  monnaieTop = parseInt(localStorage.mt);
  for(var i=0; i<dimensions; i++)
    for(var j=0; j<dimensions; j++) {
      c[i][j] = parseInt(localStorage.getItem('c'+(i)+(j)));
      afficheCase(i, j);
    }
   afficheScore(); 
   afficheTops(); // v1.1 : afficheScore() n'affiche plus systématiquement les tops
   afficheMonnaieTop();
   touchable = true;
   if ((!reste())&&(!testePossibiliteCoup()))
     finDeJeu();
}
//---------------------------------------------------------------------------
function alerteRAZ()
{
  if (fin&&(!alerte)) {
    alerte = true;
    var couleurRAZ = imgRAZ.src[imgRAZ.src.length-5];
    if (couleurRAZ == rouge)
      imgRAZ.src = chmPng + rien + extPng;
    else
      imgRAZ.src = chmPng + raz + rouge + extPng;
    setTimeout( function() { alerte = false; alerteRAZ(); }, 500);
  }
}
//---------------------------------------------------------------------------
function finDeJeu()
{
 fin = true;
 alerteRAZ();
}
//---------------------------------------------------------------------------
function debute()
{
    initialiseGrille();
    document.getElementById(idDir[gauche]).src = chmPng + idDir[gauche] + noir + extPng;
    document.getElementById(idDir[droite]).src = chmPng + idDir[droite] + noir + extPng;
    document.getElementById(idDir[haut]).src = chmPng + idDir[haut] + noir + extPng;
    document.getElementById(idDir[bas]).src = chmPng + idDir[bas] + noir + extPng;
    document.getElementById(raz).src = chmPng + go + extPng;
    setTimeout( function() {
    				document.getElementById(raz).src = chmPng + raz + noir + extPng;
    				initialisePartie();
    				posTuto = 0;
    				touchable = true;
    			}, 1000);
}
//---------------------------------------------------------------------------
function touche(action)
{
  if (!touchable) {
    if (posTuto==80)
      switch(action) {
        case gauche: posTuto = 0; tutoriel(); return; break;
        case droite: debute(); return; break;
        default: return; break;
      }
    else 
      if (!action) {
        posTuto=80;
        debute();
        return;
      }
  } 
  else {
    var couleurRAZ = imgRAZ.src[imgRAZ.src.length-5];
    if (!action) {
      if ((!fin)&&(couleurRAZ==noir)) {
        imgRAZ.src = chmPng + raz + rouge + extPng;
      }
      else {
        fin = false;
        alerte = false;
        initialisePartie();
        imgRAZ.src = chmPng + raz + noir + extPng;
      }
    }
    else {
      if (couleurRAZ != noir)
        imgRAZ.src = chmPng + raz + noir + extPng;
      joueCoup(action);
    }
    if ((!reste())&&(!testePossibiliteCoup()))
      finDeJeu();
  }
}
//---------------------------------------------------------------------------
function tutoriel()
{
  if (posTuto==80) return;
  document.getElementById(idDir[gauche]).src = chmPng + idDir[gauche] + noir + extPng;
  document.getElementById(idDir[droite]).src = chmPng + idDir[droite] + noir + extPng;
  document.getElementById(idDir[haut]).src = chmPng + idDir[haut] + noir + extPng;
  document.getElementById(idDir[bas]).src = chmPng + idDir[bas] + noir + extPng;
  document.getElementById(raz).src = chmPng + ok + extPng;
  if ((posTuto>=0)&&(posTuto<80)) {
  	initialiseGrille();
  	if ((posTuto>0)&&!(posTuto%10)) {
  	  var dd = 1 + Math.floor((posTuto-1)/10)%directions;
  	  document.getElementById(idDir[dd]).src = chmPng + idDir[dd] + noir + extPng;
  	}
  	var d = (posTuto<40)?(1+Math.floor(posTuto/10)%directions):droite;
  	var t = 2*Math.floor(posTuto/40) + posTuto%2;
  	document.getElementById(idDir[d]).src = chmPng + idDir[d] + imgCoul[posTuto%2] + extPng;
  	for(var i=0; i<dimensions; i++)
  	  for(var j=0; j<dimensions; j++) {
  	    switch(d) {
  	      case haut:	c[i][j]=tc[t][i][dimensions-j-1];
  		               	break;
  		  case bas: 	c[i][j]=tc[t][i][j];
  		              	break;
  		  case gauche: 	c[i][j]=tc[t][j][dimensions-i-1];
  	                	break;
  		  case droite: 	c[i][j]=tc[t][dimensions-j-1][i];
  		             	break;
  		}
	    if (c[i][j]<0) 
	      c[i][j] = d*c[i][j]; // On oriente les flèches dans la bonne direction
	    else
	      if ((posTuto>=40)&&(c[i][j]>0)) 
  	        c[i][j] = (c[i][j]+3*Math.floor((posTuto%40)/10))%(monnaies+1); // On montre les différentes hauteurs de monnaies jusqu'à 500 euros
  		afficheCase(i, j);             	
      }
  }
  posTuto++;
  if (posTuto<80) {
    setTimeout( function() {
    				tutoriel();
    			}, 1000);
  }
  else {
    document.getElementById(idDir[gauche]).src = chmPng + tuto + extPng;
    document.getElementById(idDir[droite]).src = chmPng + ok + extPng;
    document.getElementById(idDir[haut]).src = chmPng + rien + extPng;
    document.getElementById(idDir[bas]).src = chmPng + rien + extPng;
    document.getElementById(raz).src = chmPng + choix + extPng;
    initialiseGrille();
    
  }
}
//---------------------------------------------------------------------------
function masqueVersion()
{
  imgRAZ.src = chmPng + raz + noir + extPng;
  for(var d=1; d<=directions; d++)
    document.getElementById(idDir[d]).src = chmPng + idDir[d] + noir + extPng;
  document.getElementById(idScore + idEuro).src = chmPng + euro + noir + extPng;
  document.getElementById(idTop + idEuro).src = chmPng + euro + rouge + extPng;
  if (localStorage.getItem('centeuro')) {
    document.getElementById(idScore).src = chmPng + stScore + extPng;
    document.getElementById(idTop).src = chmPng + stTop + extPng;
    chargeTops();
    chargePartie();
  }
  else {
    afficheScore();
    afficheTops(); // v1.1 : afficheScore() n'affiche plus systématiquement les tops
    document.getElementById(idScore).src = chmPng + stScore + extPng;
    document.getElementById(idTop).src = chmPng + stTop + extPng;
    tutoriel();
  }
}
//---------------------------------------------------------------------------
function afficheVersion()
{
  document.getElementById('tcm').src = chmPng + stVersion[0] + noir + extPng;
  document.getElementById('tm').src = chmPng + stVersion[2] + noir + extPng;
}
//---------------------------------------------------------------------------
function bienvenue()
{
  imgRAZ = document.getElementById(raz);
  afficheVersion();
  setTimeout( function() {
  				masqueVersion();
  			  }, 2000);
}
//---------------------------------------------------------------------------
