function format_date(d) {
	var s = (d.getDate() < 10) ? "0" + d.getDate() : d.getDate()
	s += "."
	var m = d.getMonth() +1
	s += (m < 10) ? "0" + m : m
	s += "." + d.getFullYear()
	return s
}

var today = format_date(new Date())

function show_message(msg) {
	dhx.notice({
		message: msg,
		delay:2000
	})
}

function click_edit() {
	var i = $$("members_list").getSelected()
	if (i > 0) {
		var ml = $$("members_list").item(i)
		$$("member_form").setValues({
			m_mode: "Editar associado número " + ml.id,
			m_number: ml.id,
			m_name: ml.name,
			m_start: ml.start,
			m_lastpay: ml.last_pay,
			m_tel: ml.tel,
			m_mail: ml.mail
		})
		$$("m_remove").show()
		$$("member_form").show()
	} else {
		show_message("Selecione um associado primeiro")
	}
}

function click_new() {
	$$("member_form").setValues({
		m_mode: "Novo associado",
		m_number: "",
		m_name: "",
		m_start: today,
		m_lastpay: "",
		m_tel: "",
		m_mail: ""
	})
	$$("m_remove").hide()
	$$("member_form").show()
}
function click_remove() {
	var i = $$("members_list").getSelected()
	var ml = $$("members_list").item(i)
	dhx.confirm({
		title: "Remover?",
		message: "Excluir permanentemente " + ml.name + " (" + ml.id + ")?",
		callback: do_remove
	})
}
function do_remove() {
	var i = $$("members_list").getSelected()
	var ml = $$("members_list").item(i)
	var na = ml.name
	var nu = ml.id
	$$("members_list").remove(i)
	chair_memory.members = $$("members_list").serialize()
	local_save("Removido associado " + na + " (" + nu + ")")
	$$("member_list").show()
}
function click_receive() {
	var i = $$("members_list").getSelected()
	if (i > 0) {
		var ml = $$("members_list").item(i)
		if (date2months(ml.last_pay) < date2months(today)) {
			$$("payment_form").setValues({
				p_member: ml.name,
				p_lastpay: ml.last_pay,
				p_total: "0"
			})
			$$("p_new_payments").define("min", 1)
			$$("p_new_payments").define("max", ml.months+12)
			$$("p_new_payments").define("step", 1)
			$$("p_new_payments").define("value", 1)
			$$("payment_form").show();
			refresh_payment()
		} else {
			show_message("Associado já está em dia")
		}
	} else {
		show_message("Selecione um associado primeiro")
	}
}
function click_taxes() {
	$$("taxes_panel").show();
}

function member_repeted(mid) {
	var repeated = false
	for (var i = 0; i < chair_memory.members.length; i++) {
		if (mid == chair_memory.members[i]["id"]) {
			repeated = true
		}
	}
	return repeated
}
function click_save() {
	var mod = $$("m_mode").getValue()
	var num = parseInt($$("m_number").getValue())
	var nam = $$("m_name").getValue()
	var sta = $$("m_start").getValue()
	var tel = $$("m_tel").getValue()
	var mai = $$("m_mail").getValue()
	if (num <= 0) {
		show_message("Número deve ser maior que zero")
		return
	}
	if (nam == "") {
		show_message("Nome não pode ser vazio")
		return
	}
	if (sta == "") {
		show_message("Escolha uma data de ingresso")
		return
	}
	var star = format_date(sta)
	var msg = ""
	if (mod == "Novo associado") {
		msg = "criado associado "
		$$("m_lastpay").setValue(star)
		las = star
		if (member_repeted(num)) {
			show_message("Já existe associado com este número")
			return
		}	
		$$("members_list").add({
			id: num,
			name: nam,
			start: star,
			last_pay: las,
			tel: tel,
			mail: mai,
			months: date2months(today) - date2months(las)
		})
	} else {
		msg = "Alterado associado "
		var las = $$("m_lastpay").getValue()
		var aux = mod.split(" ")
		previous_id = aux[aux.length-1]
		var internal_id = $$("members_list").getSelected()
		var ml = $$("members_list").item(internal_id)
		if (previous_id != num) {
			if (member_repeted(num)) {
				show_message("Novo número já está em uso")
				return
			}
		}
		$$("members_list").update(internal_id, {
			id: num,
			name: nam,
			start: star,
			last_pay: las,
			tel: tel,
			mail: mai,
			months: ml.months
		})
	}
	$$("members_list").sort("#id#","asc","int")
	chair_memory.members = $$("members_list").serialize()
	local_save(msg + nam + "(" + num + "). " + star + ", " + las + ", " + tel + ", " + mai)
	$$("member_list").show()
}
function click_save_payment() {
	var member = $$("p_member").getValue()
	var months = $$("p_new_payments").getValue()
	var money = $$("p_total").getValue()
	var last = $$("p_lastpay").getValue()
	var newi = months2date(date2months(last)+1)
	var newf = $$("p_newpay").getValue()
	var msg = member + " (" + months + " meses = " +
		newi + " a " + newf + ")?"
	dhx.confirm({
		title: "Receber " + money + "?",
		message: msg,
		callback: do_save_payment
	})
}
function do_save_payment() {
	var member = $$("p_member").getValue()
	var months = $$("p_new_payments").getValue()
	var money = $$("p_total").getValue()
	var last = $$("p_lastpay").getValue()
	var newi = months2date(date2months(last)+1)
	var newf = $$("p_newpay").getValue()
	var internal_id = $$("members_list").getSelected()
	var ml = $$("members_list").item(internal_id)
	$$("members_list").update(internal_id, {
			id: ml.id,
			name: member,
			start: ml.start,
			last_pay: newf,
			tel: ml.tel,
			mail: ml.mail,
			months: ml.months - months
	})
	chair_memory.members = $$("members_list").serialize()
	local_save("Pagamento recebido. " + member + "(" + ml.id + ") pagou " + months + " meses: " + money)
	$$("member_list").show()
}
function click_remove_tax() {
	var i = $$("taxes_list").getSelected()
	if (i > 0) {
		var tl = $$("taxes_list").item(i)
		var d = tl.updated
		var m = tl.money
		$$("taxes_list").remove(i)
		chair_memory.taxes = $$("taxes_list").serialize()
		local_save("Removido reajuste de " + d + " para R$ " + m)
	} else {
		show_message("Selecione uma mensalidade para poder removê-la")
	}
}
function click_new_tax() {
	var t_value = $$("tax_new_value").getValue() || 0
	var t_date = $$("tax_new_date").getValue() || ""
	if (parseInt(t_value) <= 0) {
		show_message("Novo valor não é válido")
	} else if (t_date == "") {
		show_message("Por favor, defina uma nova data")
	} else {
		var repeated = false
		t_date = format_date(t_date)
		var t_months = date2months(t_date)
		for (var i = 0; i < chair_memory.taxes.length; i++) {
			if (t_months == chair_memory.taxes[i]["months"]) {
				repeated = true
			}
		}
		if (repeated) {
			show_message("Já houve reajuste nesse mês.")
		} else {
			$$("taxes_list").add({updated: t_date, money: t_value, months: t_months})
			$$("taxes_list").sort("#months#","asc","int")
			chair_memory.taxes = $$("taxes_list").serialize()
			local_save("Novo reajuste a partir de " + t_date + ": R$ " + t_value)
		}
	}
}
function save_settings() {
	alert("save")
	main_chair.chairs[0].title = $$("c_name").getValue()
	main_chair.chairs[0].site = $$("c_website").getValue()
	alert(main_chair.chairs[0].site)
	local_save("Configurações foram salvas: " + main_chair.chairs[0].title + ", " + main_chair.chairs[0].site)
}
function click_cancel() {
	history.back()
}
function date2months(d) {
	// d in format dd.mm.yyyy
	var aux = d.split('.')
	return parseInt(aux[1]) + parseInt(aux[2])*12
}
function months2date(m) {
	var r = m % 12 || 12
	var sr = (r>9) ? r : "0" + r
	return "01." + sr + "." + (m-r)/12
}
function convert_tax(months, m) {
	var t = 0
	for (var i = 0; i < chair_memory.taxes.length; i++) {
		if ((months + m)>chair_memory.taxes[i]["months"]) {
			t = parseInt(chair_memory.taxes[i]["money"])
		}
	}
	return t
}
function refresh_settings() {
	if (chair_memory.taxes.length > 0) {
		var last_tax = chair_memory.taxes[chair_memory.taxes.length -1]
		$$("c_last_tax").setValue("R$ " + last_tax["money"] + ",00 (em " + last_tax["updated"] + ")")
	} else {
		$$("c_last_tax").setValue("Nenhuma mensalidade definida")
	}
}
function refresh_payment() {
	var pays = $$("p_new_payments").getValue()
	var last = date2months($$("p_lastpay").getValue())
	var total = 0
	for (var i = 0; i < pays; i++) {
		total += convert_tax(last, i)
	}
	$$("p_newpay").setValue(months2date(last+pays))
	$$("p_total").setValue("R$ " + total)
}
function local_save(msg) {
	dhx.storage.local.put("main chair", main_chair)
	$$("chair_history").add({date: today, msg: msg})
	chair_memory.history = $$("chair_history").serialize()
	dhx.storage.local.put("chair 1", chair_memory)
}
function local_load() {
	var mc = dhx.storage.local.get("main chair")
	if (mc) {
		main_chair = mc
	}
	var cm = dhx.storage.local.get("chair 1")
	if (cm) {
		for (var i = 0; i < cm.members.length; i++) {
			cm.members[i].months = date2months(today) - date2months(cm.members[i].last_pay)
		}
		chair_memory = cm
	}
}

function click_import() {
	$$("imex_zone").define("placeholder", "Digite aqui o código JSON.")
	$$("imex_transf").setValue("Colar")
	$$("imex_transf").hide()
	$$("imex_go").show()
	$$("imex_form").show()
}
function click_export() {
	var c_format = $$("export_format").getValue()
	var str = ""
	if (c_format == 1) {
		str += "<h1>Relatório Chair37 em " + today + "</h1>"
		str += "<h2>Membros</h2>"
		str += "<table><tr><th>Número</th><th>Nome</th><th>Ingresso</th><th>Último mês pago</th><th>Total de meses atrasados</th></tr>"
		for (var i = 0; i < chair_memory.members.length; i++) {
			var cm = chair_memory.members[i]
			str += "<tr><td>" + cm.id + "</td><td>" + cm.name + "</td><td>" + cm.start + "</td><td>" + cm.last_pay + "</td><td>" + cm.months + "</td></tr>"
		}
		str += "</table>"
		str += "<h2>Mensalidades</h2>"
		str += "<table><tr><th>Reajuste</th><th>Valor</th></tr>"
		for (var i = 0; i < chair_memory.taxes.length; i++) {
			var cm = chair_memory.taxes[i]
			str += "<tr><td>" + cm.updated + "</td><td>R$ " + cm.money + "</td></tr>"
		}
		str += "</table>"
	} else if (c_format == 3) {
		str = JSON.stringify(chair_memory)
	} else {
		str += "Relatório gerado em " + today + " pelo Chair37\n\n"
		str += "\n\nMEMBROS\n=======\n"
		for (var i = 0; i < chair_memory.members.length; i++) {
			var cm = chair_memory.members[i]
			str += cm.id + " - " + cm.name + ": " + cm.months + " (" + cm.last_pay + ")\n"
		}
		str += "\n\nMENSALIDADES\n============\n"
		for (var i = 0; i < chair_memory.taxes.length; i++) {
			var cm = chair_memory.taxes[i]
			str += cm.updated + " - R$ " + cm.money + "\n"
		}
	}
	$$("imex_zone").setValue(str)
	$$("imex_transf").setValue("Copiar")
	$$("imex_transf").hide()
	$$("imex_go").hide()
	$$("imex_form").show()	
}         

function click_imex_transf() {
	if ($$("imex_transf").getValue() =="Copiar") {
	} else {
	}
}
function click_imex_go() {
	dhx.confirm({
		title: "Ação irreversível!",
		message: "Substituir a base atual por esse conteúdo?",
		callback: do_imex_go
	})
}
function do_imex_go() {
	var iz = $$("imex_zone").getValue()
	chair_memory = eval('(' + iz + ')')
	local_save("Importados os dados. Todo o banco foi substituído")
	window.location = window.location
}
