// PLUGINS

function utf8_decode(e) { var t = [], n = 0, r = 0, i = 0, s = 0, o = 0, u = 0; e += ""; while (n < e.length) { i = e.charCodeAt(n); if (i <= 191) { t[r++] = String.fromCharCode(i); n++ } else if (i <= 223) { s = e.charCodeAt(n + 1); t[r++] = String.fromCharCode((i & 31) << 6 | s & 63); n += 2 } else if (i <= 239) { s = e.charCodeAt(n + 1); o = e.charCodeAt(n + 2); t[r++] = String.fromCharCode((i & 15) << 12 | (s & 63) << 6 | o & 63); n += 3 } else { s = e.charCodeAt(n + 1); o = e.charCodeAt(n + 2); u = e.charCodeAt(n + 3); i = (i & 7) << 18 | (s & 63) << 12 | (o & 63) << 6 | u & 63; i -= 65536; t[r++] = String.fromCharCode(55296 | i >> 10 & 1023); t[r++] = String.fromCharCode(56320 | i & 1023); n += 4 } } return t.join("") }



// Config
var CONFIG = {
    WS_DATA: {
        'idAplicacion': 4,
        WS_URLS: {
            autoLogin: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.ExternalAuthentication.svc/LoginAutomatico',
            externalLogin: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.ExternalAuthentication.svc/ValidarCodigoActivacion',
            getCodigoActivacion: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.ExternalAuthentication.svc/GetCodigoActivacion',
            obtenerDatosRecargaFacil: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/obtenerDatosRecargaFacil',
            hacerRecargaFacil: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/hacerRecargaFacil',
            getConsultaSaldo: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Common.svc/getConsultaSaldo',
            obtenerDatoExtensionCredito: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/obtenerDatoExtensionCredito',
            solicitarPaquete: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/solicitarPaquete',
            consultarTransaccion: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/consultarTransaccion',
            solicitarPaqueteATercero: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Recargas.svc/solicitarPaqueteATercero',
            getCategoriasFaq: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Common.svc/getCategoriasFaq',
            getFaqByCategoriaId: 'http://mobileapps.movistar.com.uy/MobileappsServicesTesting/Movistar.MobileApps.Services.Common.svc/getFaqByCategoriaId',
        }
    },
    CHAT: {
        CHAT_MOBILE_URL: 'http://chat.movistar.com.uy/WebAPI812/SimpleSamples812/ChatMobileFFNativa/HtmlChatFrameSet.jsp?nombre=<nombreIngresado>&apellido=<apellidoIngresado>&numero=<numeroDeLinea>',
    },
    CONNECTION: {
        INTENTS: 3,
        INTERVAL: 300,
    }
};


// Lang
var LANG = {
    'checkAccountSuccess': 'Recibirás un SMS con tu saldo actual.',
    'checkAccountFail': 'Ocurrió un error, vuelva a intentar.',
    'codeSent': 'Hemos enviado el código. Revise sus mensajes.',
    'loading': 'Cargando',
    'phoneInputError': 'Debes ingresar un celular Movistar válido.',
    'codeInputError': 'Debes ingresar un código de activación.',
    'chatInitInputError': 'Debes ingresar nombre y apellido',
};


// Loading UI
(function (ns) {
    ns.show = function () {
        document.querySelector('#loading').classList.add('active');
    };
    ns.hide = function () {
        document.querySelector('#loading').classList.remove('active');
    };
}(window.LOADING = window.LOADING || {}));


// NAVIGATOR
(function (ns) {
    ns.changePage = function (newPageId) {
        var activePage = document.querySelector('section.page.active');
        if (activePage != null) {
            activePage.classList.remove('active');
        }
        document.querySelector('#' + newPageId).classList.add('active');
    };
    ns.backPageView = function () { };
    ns.userHomeView = function () { };
    ns.defaultClosedActions = function () { };
    ns.pageClosedActions = ns.defaultClosedActions;
    var backBtn = document.querySelector('#back_btn');
    backBtn.onclick = function () {
        ns.pageClosedActions();
        ns.pageClosedActions = ns.defaultClosedActions;
        ns.backPageView();
    };

    ns.moreInfoPageView = function () { };
    var moreInfoBtn = document.querySelector('#more_info_btn');
    moreInfoBtn.onclick = function () {
        ns.pageClosedActions();
        ns.pageClosedActions = ns.defaultClosedActions;
        ns.moreInfoPageView();
    };
    ns.showBackBtn = function () {
        backBtn.classList.add('active');
    };
    ns.hideBackBtn = function () {
        backBtn.classList.remove('active');
    };
    ns.showMoreInfoBtn = function () {
        moreInfoBtn.classList.add('active');
    };
    ns.hideMoreInfoBtn = function () {
        moreInfoBtn.classList.remove('active');
    };
}(window.NAVIGATOR = window.NAVIGATOR || {}));


// CONNECTION
(function (ns) {
    var checkOnlineIntent = 0;
    var checkOnlineTimeout;
    ns.checkOnlineCallback = function () { };
    ns.checkOnlineCallbackParams = {};
    ns.checkOnline = function () {
        if (!navigator.onLine) {
            /*
			if(checkOnlineIntent<=CONFIG.CONNECTION.INTENTS){
				LOADING.show();
				clearTimeout(checkOnlineTimeout);
				checkOnlineIntent++;
				checkOnlineTimeout = setTimeout(ns.checkOnline, CONFIG.CONNECTION.INTERVAL);
			}else{
				LOADING.hide();
				checkOnlineIntent = 0;
				NAVIGATOR.changePage('offline');
			}
			*/
            LOADING.hide();
            checkOnlineIntent = 0;
            NAVIGATOR.changePage('offline');
        } else {
            LOADING.hide();
            checkOnlineIntent = 0;
            ns.checkOnlineCallback(ns.checkOnlineCallbackParams);
        }
    };
    var checkOnlineIntentAlert = 0;
    var checkOnlineTimeoutAlert;
    ns.checkOnlineCallback = function () { };
    ns.checkOnlineCallbackParams = {};
    ns.checkOnlineAlert = function () {
        if (!navigator.onLine) {
            /*
			if(checkOnlineIntent<=CONFIG.CONNECTION.INTENTS){
				LOADING.show();
				clearTimeout(checkOnlineTimeout);
				checkOnlineIntent++;
				checkOnlineTimeout = setTimeout(ns.checkOnline, CONFIG.CONNECTION.INTERVAL);
			}else{
				LOADING.hide();
				checkOnlineIntent = 0;
				NAVIGATOR.changePage('offline');
			}
			*/
            LOADING.hide();
            checkOnlineIntentAlert = 0;
            //NAVIGATOR.changePage('offline');
            alert("No fue posible conectarse a internet, por favor verifica tu conexión.");
        } else {
            LOADING.hide();
            checkOnlineIntentAlert = 0;
            ns.checkOnlineCallback(ns.checkOnlineCallbackParams);
        }
    };
}(window.CONNECTION = window.CONNECTION || {}, LOADING, NAVIGATOR, CONFIG));


// WebServiceCaller
(function (ns, CONFIG, LOADING, CONNECTION) {
    var xhr;
    var requestCallback = function (response) { };
    var requestHandler = function () {
        if (xhr.readyState == 4) {
            var jsonResponse = false;
            try {
                jsonResponse = JSON.parse(xhr.responseText);
            } catch (e) { }
            var response = {
                'responseText': xhr.responseText || false,
                'jsonResponse': jsonResponse,
                'errorDescription': xhr.getResponseHeader('CustomStatusDescription') || false,
            };
            LOADING.hide();
            requestCallback(response);
        }
    };
    var doSendRequest = function (params) {
        var url = params['url'] || null;
        var data = params['data'] || null;
        var callback = params['callback'] || null;
        var userdata = params['userdata'] || null;
        requestCallback = callback || function () { };
        userdata = userdata || null;
        xhr = new XMLHttpRequest({ mozSystem: true });
        xhr.open('POST', url, true);
        xhr.setRequestHeader('X-MovApplicationId', CONFIG.WS_DATA.idAplicacion);
        if (userdata && userdata.token) {
            xhr.setRequestHeader('X-MovToken', userdata.token);
        }
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.onreadystatechange = requestHandler;
        xhr.send(JSON.stringify(data));
        LOADING.show();
    };
    ns.sendRequest = function (url, data, callback, userdata) {
        CONNECTION.checkOnlineCallbackParams = {
            url: url,
            data: data,
            callback: callback,
            userdata: userdata,
        }
        CONNECTION.checkOnlineCallback = doSendRequest;
        //CONNECTION.checkOnline();
        CONNECTION.checkOnlineAlert();
    };
}(window.WSCaller = window.WSCaller || {}, CONFIG, LOADING, CONNECTION));


// MovistarAPI
(function (ns, WSCaller, CONFIG) {
    var WS_URLS = CONFIG.WS_DATA.WS_URLS;
    var SESSION_USERDATA = null;

    var intentAutoLoginCallback;
    var intentAutoLoginHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false || !response.jsonResponse.LoginAutomaticoResult) {
            result = false;
        } else {
            SESSION_USERDATA = response.jsonResponse.LoginAutomaticoResult;
        }
        intentAutoLoginCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.intentAutoLogin = function (data, callback) {
        SESSION_USERDATA = null;
        intentAutoLoginCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.autoLogin, data, intentAutoLoginHandler);
    };

    var externalLoginCallback;
    var intentExternalLoginHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false || !response.jsonResponse.ValidarCodigoActivacionResult) {
            result = false;
        } else {
            //#1.1
            SESSION_USERDATA = response.jsonResponse.ValidarCodigoActivacionResult;
            localStorage.setItem('usuario', JSON.stringify(response.jsonResponse.ValidarCodigoActivacionResult));
            var currentdate = new Date();
            var date = Date.now();
            var d = new Date(date);
            localStorage['fecha'] = d;



        }
        externalLoginCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.intentExternalLogin = function (data, callback) {
        SESSION_USERDATA = null;
        externalLoginCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.externalLogin, data, intentExternalLoginHandler);
    };

    var sendActivationCodeCallback;
    var sendActivationCodeHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        sendActivationCodeCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.sendActivationCode = function (data, callback) {
        SESSION_USERDATA = null;
        sendActivationCodeCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.getCodigoActivacion, data, sendActivationCodeHandler);
    };

    var sendPrePaidOrderCallback;
    var sendPrePaidOrderHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        response.jsonResponse.hacerRecargaFacilResult.status = true;
        sendPrePaidOrderCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.sendPrePaidOrder = function (data, callback) {
        sendPrePaidOrderCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.hacerRecargaFacil, data, sendPrePaidOrderHandler, SESSION_USERDATA);
    };

    var checkTransactionStatusCallback;
    var checkTransactionStatusHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        checkTransactionStatusCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.checkTransactionStatus = function (data, callback) {
        checkTransactionStatusCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.consultarTransaccion, data, checkTransactionStatusHandler, SESSION_USERDATA);
    };

    var sendAnotherPhoneOrderCallback;
    var sendAnotherPhoneOrderHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        sendAnotherPhoneOrderCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.sendAnotherPhoneOrder = function (data, callback) {
        sendAnotherPhoneOrderCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.solicitarPaqueteATercero, data, sendAnotherPhoneOrderHandler, SESSION_USERDATA);
    };

    var sendControlledAccountOrderCallback;
    var sendControlledAccountOrderHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        sendControlledAccountOrderCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.sendControlledAccountOrder = function (data, callback) {
        sendControlledAccountOrderCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.solicitarPaquete, data, sendControlledAccountOrderHandler, SESSION_USERDATA);
    };

    var controlledAccountOptionsCallback;
    var controlledAccountOptionsHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        controlledAccountOptionsCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.getControlledAccountOptions = function (data, callback) {
        controlledAccountOptionsCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.obtenerDatoExtensionCredito, data, controlledAccountOptionsHandler, SESSION_USERDATA);
    };

    var prePaidAmountsCallback;
    var prePaidAmountsHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        prePaidAmountsCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.getPrePaidAmounts = function (data, callback) {
        prePaidAmountsCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.obtenerDatosRecargaFacil, data, prePaidAmountsHandler, SESSION_USERDATA);
    };

    var checkAccountCallback;
    var checkAccountHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        checkAccountCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.checkAccount = function (data, callback) {
        checkAccountCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.getConsultaSaldo, data, checkAccountHandler, SESSION_USERDATA);
    };

    var getFaqsCategoryCallback;
    var getFaqsCategoryHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        getFaqsCategoryCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.getFaqsCategory = function (data, callback) {
        getFaqsCategoryCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.getFaqByCategoriaId, data, getFaqsCategoryHandler, SESSION_USERDATA);
    };

    var getFaqsCallback;
    var getFaqsHandler = function (response) {
        var result = true;
        if (response.responseText === false || response.jsonResponse === false || response.errorDescription !== false) {
            result = false;
        }
        NAVIGATOR.changePage('faqs');
        getFaqsCallback({
            'response': response.jsonResponse,
            'responseText': response.responseText,
            'result': result,
            'errorDescription': response.errorDescription,
        });
    };
    ns.getFaqs = function (data, callback) {
        getFaqsCallback = callback || function () { };
        WSCaller.sendRequest(WS_URLS.getCategoriasFaq, data, getFaqsHandler, SESSION_USERDATA);
    };

    ns.getSessionUserdata = function () {

        return SESSION_USERDATA;
    };

    ns.setSessionUserdata = function (data) {

        SESSION_USERDATA = data;
    };

    ns.validatePhone = function (phone) {
        var re = new RegExp("(093|094|095)+[0-9]{6}");
        return re.test(phone);
    };
}(window.MovistarAPI = window.MovistarAPI || {}, WSCaller, CONFIG));


// MainApp
(function (ns, MovistarAPI, CONFIG, LANG, NAVIGATOR, LOADING, CONNECTION) {
    var authFailViewInitialized = false;
    var authFailView = function () {


        //#1.1

        if (localStorage['usuario'] == 'undefined') {
            NAVIGATOR.changePage('auth_fail');
            NAVIGATOR.hideMoreInfoBtn();
            if (!authFailViewInitialized) {
                var sendCodeBtn = document.querySelector('#send_code');
                sendCodeBtn.onclick = ns.sendCode;
                var validateCodeBtn = document.querySelector('#code_validation');
                validateCodeBtn.onclick = ns.validateCode;
                authFailViewInitialized = true;
            }
        } else {
            if (localStorage['usuario'] != undefined) {

                var date = new Date(Date.now() - (30 * 24 * 3600 * 1000));
                if (Date.parse(localStorage['fecha']) >= date) {

                    var datObj = JSON.parse(localStorage['usuario']);
                    MovistarAPI.setSessionUserdata(datObj);
                    gotoHomeView();
                }
                else {

                    MovistarAPI.setSessionUserdata(null);
                    localStorage.removeItem("usuario");
                    localStorage.removeItem("fecha");

                    NAVIGATOR.changePage('auth_fail');
                    NAVIGATOR.hideMoreInfoBtn();
                    if (!authFailViewInitialized) {
                        var sendCodeBtn = document.querySelector('#send_code');
                        sendCodeBtn.onclick = ns.sendCode;
                        var validateCodeBtn = document.querySelector('#code_validation');
                        validateCodeBtn.onclick = ns.validateCode;
                        authFailViewInitialized = true;
                    }
                }


            }
            else {
                NAVIGATOR.changePage('auth_fail');
                NAVIGATOR.hideMoreInfoBtn();
                if (!authFailViewInitialized) {
                    var sendCodeBtn = document.querySelector('#send_code');
                    sendCodeBtn.onclick = ns.sendCode;
                    var validateCodeBtn = document.querySelector('#code_validation');
                    validateCodeBtn.onclick = ns.validateCode;
                    authFailViewInitialized = true;
                }
            }
        }
    };

    var confirmPrePaidOrderHandler = function (data) {
        if (data.result) {
            var resultData = data.response.hacerRecargaFacilResult;
            NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
            NAVIGATOR.showBackBtn();
            if (resultData.status) {
                NAVIGATOR.changePage('pre_paid_success');
                document.querySelector('#pre_paid_success_check_account').onclick = checkAccountView;
            } else {
                document.querySelector('#pre_paid_error_description').innerHTML = resultData.descripcion;
                NAVIGATOR.changePage('pre_paid_error');
            }
        }
    };
    ns.confirmPrePaidOrder = function () {
        MovistarAPI.sendPrePaidOrder({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
            monto: document.querySelector('#pre_paid_amount').value,
        }, confirmPrePaidOrderHandler)
    };

    var checkAccountHandler = function (data) {
        var feedbackElement = document.querySelector('#check_account_feedback');
        if (data.result) {
            feedbackElement.innerHTML = LANG['checkAccountSuccess'];
        } else {
            feedbackElement.innerHTML = LANG['checkAccountFail'];
        }
    };
    var checkAccountView = function () {
        NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
        NAVIGATOR.showBackBtn();
        NAVIGATOR.changePage('check_account');
        var feedbackElement = document.querySelector('#check_account_feedback');
        feedbackElement.innerHTML = LANG['loading'];
        MovistarAPI.checkAccount({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
        }, checkAccountHandler);
    };

    var TransactionId;
    var transactionStatusTimeout;
    var transactionStatusHandler = function (data) {
        var status = data.response.consultarTransaccionResult;
        if (status == 'Success') {
            NAVIGATOR.changePage('transaction_success');
            document.querySelector('#transaction_success_check_account').onclick = checkAccountView
        } else if (status == 'Failed') {
            NAVIGATOR.changePage('transaction_error');
        } else {
            clearTimeout(transactionStatusTimeout);
            transactionStatusTimeout = setTimeout(transactionStatus, 2000);
            LOADING.show();
        }
    };
    var transactionStatus = function () {
        MovistarAPI.checkTransactionStatus({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
            idTransaction: TransactionId,
        }, transactionStatusHandler);
    };

    var anotherPhoneOrderHandler = function (data) {
        if (data.result) {
            var transactionId = data.response.solicitarPaqueteATerceroResult;
            if (transactionId != null) {
                TransactionId = transactionId;
                transactionStatus();
            } else {
                document.querySelector('#another_phone_error_description').innerHTML = utf8_decode(data.errorDescription);
                NAVIGATOR.changePage('another_phone_error');
            }
        }
    };
    var anotherPhoneOrder = function () {
        var optionId = this.dataset['optionId'];
        var orderPhone = document.querySelector('#another_phone_phone').value;

        MovistarAPI.sendAnotherPhoneOrder({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
            idPaquete: optionId,
            destPhoneNumber: orderPhone,
        }, anotherPhoneOrderHandler);
    };
    var anotherPhoneOrderConfirmation = function () {
        var optionId = this.dataset['optionId'];
        var amount = this.dataset['amount'];
        var phone = document.querySelector('#another_phone_phone').value;
        if (MovistarAPI.validatePhone(phone)) {
            var btn = document.querySelector('#another_phone_confirm_order_btn');
            btn.dataset['optionId'] = optionId;
            btn.onclick = controlledAccountOrder;
            document.querySelector('#another_phone_confirm_order_amount').innerHTML = amount;
            document.querySelector('#another_phone_confirm_order_phone').innerHTML = phone;
            NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
            NAVIGATOR.showBackBtn();
            NAVIGATOR.changePage('another_phone_confirm_order');
        } else {
            alert(LANG['phoneInputError']);
        }
    };

    var controlledAccountOrderHandler = function (data) {
        if (data.result) {
            var transactionId = data.response.solicitarPaqueteResult;
            if (transactionId != null) {
                TransactionId = transactionId;
                transactionStatus();
            } else {
                document.querySelector('#controlled_account_error_description').innerHTML = utf8_decode(data.errorDescription);
                NAVIGATOR.changePage('controlled_account_error');
            }
        }
    };
    var controlledAccountOrder = function () {
        var optionId = this.dataset['optionId'];
        MovistarAPI.sendControlledAccountOrder({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
            idPaquete: optionId,
        }, controlledAccountOrderHandler);
    };

    var controlledAccountOrderConfirmation = function () {
        var optionId = this.dataset['optionId'];
        var amount = this.dataset['amount'];
        var btn = document.querySelector('#controlled_account_confirm_order_btn');
        btn.dataset['optionId'] = optionId;
        btn.onclick = controlledAccountOrder;
        document.querySelector('#controlled_account_confirm_order_amount').innerHTML = amount;
        NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
        NAVIGATOR.showBackBtn();
        NAVIGATOR.changePage('controlled_account_confirm_order');
    };

    var setControlledAccountOptions = function (optionsContainer, data, action) {
        optionsContainer.innerHTML = '';
        var options = data.response.obtenerDatoExtensionCreditoResult;
        for (var x in options) {
            var opt = document.createElement('a');
            opt.dataset['optionId'] = options[x].id;
            opt.dataset['amount'] = options[x].monto;
            opt.classList.add('controlled_account_option');
            opt.href = 'javascript:;';
            opt.innerHTML = '<div class="content-btn"><span class="text">RECARGA -</span><span class="number">$ ' + options[x].monto + '</span></div>';
            optionsContainer.appendChild(opt);
        }
        var optionLinks = document.querySelectorAll('.controlled_account_option');
        for (var x in optionLinks) {
            optionLinks[x].onclick = action;
        }
    };
    var anotherPhoneOptionsHandler = function (data) {
        var optionsContainer = document.querySelector('#another_phone_options_container');
        setControlledAccountOptions(optionsContainer, data, anotherPhoneOrderConfirmation);
    };
    var anotherPhoneView = function () {
        var optionsContainer = document.querySelector('#another_phone_options_container');
        optionsContainer.innerHTML = '';
        if (NAVIGATOR.userHomeView === anotherPhoneView) {
            NAVIGATOR.hideBackBtn();
        } else {
            NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
            NAVIGATOR.showBackBtn();
        }
        NAVIGATOR.changePage('another_phone');
        MovistarAPI.getControlledAccountOptions({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
        }, anotherPhoneOptionsHandler);
    };

    var controlledAccountHandler = function (data) {
        var optionsContainer = document.querySelector('#controlled_account_options_container');
        setControlledAccountOptions(optionsContainer, data, controlledAccountOrderConfirmation);
    };
    var controlledAccountInitialized = false;
    var controlledAccountView = function () {
        NAVIGATOR.showMoreInfoBtn();
        var optionsContainer = document.querySelector('#controlled_account_options_container');
        optionsContainer.innerHTML = '';
        NAVIGATOR.hideBackBtn();
        NAVIGATOR.changePage('controlled_account');
        MovistarAPI.getControlledAccountOptions({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
        }, controlledAccountHandler);
        if (!controlledAccountInitialized) {
            controlledAccountInitialized = true;
            document.querySelector('#controlled_account_check_account').onclick = checkAccountView;
            document.querySelector('#controlled_account_another_phone').onclick = anotherPhoneView;
            //document.querySelector('#map_btn').onclick = ns.mapView;
        }
    };

    var prePaidAmountsHandler = function (data) {
        var amountsCmb = document.querySelector('#pre_paid_amount');
        amountsCmb.innerHTML = '';
        var minAmount = parseInt(data.response.obtenerDatosRecargaFacilResult.montoMinimo);
        var maxAmount = parseInt(data.response.obtenerDatosRecargaFacilResult.montoMaximo);
        var stepAmount = parseInt(data.response.obtenerDatosRecargaFacilResult.Step);
        var firstAmount = true; // TODO: esto es un parche por error en servicios min>max, dejo pasar el primero
        for (var amount = minAmount; firstAmount || amount <= maxAmount; amount += stepAmount) {
            firstAmount = false;
            var opt = document.createElement('option');
            opt.value = amount;
            opt.appendChild(document.createTextNode(amount));
            amountsCmb.appendChild(opt);
        }
    };
    var prePaidViewInitialized = false;
    var prePaidView = function () {
        NAVIGATOR.hideBackBtn();
        NAVIGATOR.showMoreInfoBtn();
        NAVIGATOR.changePage('pre_paid');
        MovistarAPI.getPrePaidAmounts({
            idAplicacion: CONFIG.WS_DATA.idAplicacion,
        }, prePaidAmountsHandler);
        if (!prePaidViewInitialized) {
            prePaidViewInitialized = true;
            document.querySelector('#confirm_pre_paid_order').onclick = ns.confirmPrePaidOrder;
            document.querySelector('#pre_paid_check_account').onclick = checkAccountView;
        }
    };

    var autoLoginCallback = function (data) {
        if (data.result) {
            gotoHomeView();
            //#1.1
            var userdata = MovistarAPI.getSessionUserdata();
            var datObj = JSON.parse(localStorage['usuario']);
            if (datObj.PhoneNumber != userdata.PhoneNumber) {
               // MovistarAPI.setSessionUserdata(null);
                localStorage.removeItem("usuario");
                localStorage.removeItem("fecha");
            }
            //#1.1
        } else {
            authFailView();
        }
    };
    ns.autoLogin = function () {
        MovistarAPI.intentAutoLogin({}, autoLoginCallback);
    };

    var sendCodeCallback = function (data) {
        if (data.result) {
            document.querySelector('#code').classList.remove('hidden');
            document.querySelector('#code_validation').classList.remove('hidden');
            alert(LANG['codeSent']);
        } else {

            var errorText = utf8_decode(data.errorDescription);
            alert(errorText);
        }
    };
    ns.sendCode = function () {
        document.querySelector('#code').classList.add('hidden');
        document.querySelector('#code_validation').classList.add('hidden');

        var codeValue = document.querySelector('#code').value;
        var phoneValue = document.querySelector('#phone').value;
        if (MovistarAPI.validatePhone(phoneValue)) {
            MovistarAPI.sendActivationCode({
                idAplicacion: CONFIG.WS_DATA.idAplicacion,
                numeroTelefono: phoneValue,
            }, sendCodeCallback);
        } else {
            alert(LANG['phoneInputError']);
        }
    };

    var getChatMobileURL = function (name, lastname) {
        var url = CONFIG.CHAT.CHAT_MOBILE_URL;
        url = url.replace('<nombreIngresado>', name);
        url = url.replace('<apellidoIngresado>', lastname);
        var userdata = MovistarAPI.getSessionUserdata();
        url = url.replace('<numeroDeLinea>', userdata.PhoneNumber);
        return url;
    };

    ns.chatPost = function (action, value) {
        var value = value || '';
        var postMsg = action + value;
        var iframe = document.querySelector('#chat_view_iframe');
        iframe.contentWindow.postMessage(postMsg, 'http://chat.movistar.com.uy/');
    };

    ns.sendChatMessage = function () {
        var chatTextInput = document.querySelector('#chat_view_text');
        ns.chatPost('#message#', chatTextInput.value);
        chatTextInput.value = '';
    };

    var chatClosedActions = function () {
        ns.chatPost('#closesession#');
        var container = document.querySelector('#chat_view_container');
        container.innerHTML = '';
    };

    ns.chatView = function (url) {
        var url = url || false;
        if (!url) {
            chatHomeView();
        } else {
            NAVIGATOR.changePage('chat_view');
            NAVIGATOR.pageClosedActions = chatClosedActions;
            NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
            NAVIGATOR.showBackBtn();
            var container = document.querySelector('#chat_view_container');
            container.innerHTML = '';
            var iframe = document.createElement('iframe');
            iframe.src = url;
            iframe.id = 'chat_view_iframe';
            iframe.setAttribute('sandbox', 'allow-same-origin allow-top-navigation allow-forms allow-scripts');
            iframe.style.overflowX = 'hidden';
            iframe.frameBorder = 0;
            container.appendChild(iframe);

            var sendBtn = document.querySelector('#chat_view_send');
            sendBtn.onclick = ns.sendChatMessage;
        }
    }

    ns.launchChat = function () {
        var nameInput = document.querySelector('#chat_home_name');
        var lastnameInput = document.querySelector('#chat_home_lastname');
        var name = nameInput.value;
        var lastname = lastnameInput.value;
        if (name == '' || lastname == '') {
            alert(LANG['chatInitInputError']);
        } else {
            var url = getChatMobileURL(name, lastname);
            ns.chatView(url);
        }
    };

    var chatHomeInitialized = false;
    var chatHomeView = function () {
        NAVIGATOR.changePage('chat_home');
        NAVIGATOR.showMoreInfoBtn();
        NAVIGATOR.hideBackBtn();
        var nameInput = document.querySelector('#chat_home_name');
        var lastnameInput = document.querySelector('#chat_home_lastname');
        nameInput.value = '';
        lastnameInput.value = '';
        if (!chatHomeInitialized) {
            var initBtn = document.querySelector('#chat_home_init');
            initBtn.onclick = ns.launchChat;
            chatHomeInitialized = true;
        }
    };

    var gotoHomeView = function () {
        NAVIGATOR.userHomeView = chatHomeView;
        chatHomeView();
    };

    var validateCodeCallback = function (data) {

        

        if (data.result) {
            gotoHomeView();
        }
    };
    ns.validateCode = function () {
        var codeValue = document.querySelector('#code').value;

        if (codeValue != '') {
            MovistarAPI.intentExternalLogin({
                idAplicacion: CONFIG.WS_DATA.idAplicacion,
                numeroTelefono: document.querySelector('#phone').value,
                codigoActivacion: codeValue,
            }, validateCodeCallback);
        } else {
            alert(LANG['codeInputError']);
        }
    };

    var offlineViewInitialized = false;
    ns.offlineView = function () {
        NAVIGATOR.hideMoreInfoBtn();
        if (!offlineViewInitialized) {
            document.querySelector('#offline_reintent').onclick = function () {
                NAVIGATOR.changePage('splash');
                CONNECTION.checkOnlineCallback = ns.autoLogin;
                CONNECTION.checkOnline();
            };
            document.querySelector('#offline_exit').onclick = function () {
                window.close();
            };
            offlineViewInitialized = true;
        }
    };

    var hideFooter = function () {
        document.querySelector('footer').style.display = 'none';
    };
    var showFooter = function () {
        document.querySelector('footer').style.display = 'block';
    };

    ns.init = function () {
        NAVIGATOR.changePage('splash');
        CONNECTION.checkOnlineCallback = ns.autoLogin;
        CONNECTION.checkOnline();
        MainApp.offlineView();
        NAVIGATOR.moreInfoPageView = ns.moreInfoView;

        var textInputs = document.querySelectorAll('.input_text');
        for (var x in textInputs) {
            textInputs[x].onfocus = hideFooter;
            textInputs[x].onblur = showFooter;
        }
    };

    var faqsCategoryHandler = function (data) {
        NAVIGATOR.changePage('faqs_category');
        var optionsContainer = document.querySelector('#faqs_category_container');
        var options = data.response.getFaqByCategoriaIdResult;
        for (var x in options) {
            var opt = document.createElement('a');
            opt.href = 'javascript:;';
            opt.classList.add('faqs_category_question');
            opt.innerHTML = '<div class="faq-title"><span>' + options[x].pregunta + '</span><img src="img/ic-arrow-right-blue.png" /></div>';
            optionsContainer.appendChild(opt);

            var optText = document.createElement('div');
            optText.classList.add('faq-text');
            optText.innerHTML = options[x].respuesta;
            optionsContainer.appendChild(optText);
        }

        var optionLinks = document.querySelectorAll('.faqs_category_question');
        for (var x in optionLinks) {
            optionLinks[x].onclick = function () {
                var answer = this.nextElementSibling;
                if (answer.style.display == 'block') {
                    this.classList.remove('active');
                    answer.style.display = 'none';
                } else {
                    this.classList.add('active');
                    answer.style.display = 'block';
                }
            };
        }
    };
    var faqsCategoryView = function (categoryId) {
        NAVIGATOR.backPageView = ns.faqsView;
        //	NAVIGATOR.changePage('faqs_category');
        document.querySelector('#faqs_category_container').innerHTML = '';
        MovistarAPI.getFaqsCategory({
            idCategory: categoryId
        }, faqsCategoryHandler);
    };

    var faqsHandler = function (data) {
        var optionsContainer = document.querySelector('#faqs_container');
        var options = data.response.getCategoriasFaqResult;
        for (var x in options) {
            var opt = document.createElement('a');
            opt.dataset['optionId'] = options[x].id;
            opt.classList.add('faq_category');
            opt.href = 'javascript:;';
            opt.innerHTML = '<div class="faq-title-category"><span>' + options[x].descripcion + '</span><img src="img/ic-arrow-right-blue.png" /></div>';
            optionsContainer.appendChild(opt);
        }
        var optionLinks = document.querySelectorAll('.faq_category');
        for (var x in optionLinks) {
            optionLinks[x].onclick = function () {
                faqsCategoryView(this.dataset['optionId']);
            };
        }
    };
    ns.faqsView = function () {
        NAVIGATOR.backPageView = ns.moreInfoView;
        NAVIGATOR.showBackBtn();
        //NAVIGATOR.changePage('faqs');
        document.querySelector('#faqs_container').innerHTML = '';
        MovistarAPI.getFaqs({}, faqsHandler);
    };

    //#1.1
    ns.ChangeLine = function () {
      
        var datObj = MovistarAPI.getSessionUserdata();
        
        var r = confirm("¿Esta seguro que desea cambiar el número de la línea actual (" + datObj.PhoneNumber + ")?");
        if (r == true) {
            MovistarAPI.intentAutoLogin({}, autoLoginCallback);
            MovistarAPI.setSessionUserdata(null);
            localStorage.removeItem("usuario");
            localStorage.removeItem("fecha");
            var codeInput = document.querySelector('#code');
            codeInput.value = '';
            var phoneInput = document.querySelector('#phone');
            phoneInput.value = '';             
        }


    };


    var moreInfoInitialized = false;
    ns.moreInfoView = function () {
        NAVIGATOR.backPageView = NAVIGATOR.userHomeView;
        NAVIGATOR.showBackBtn();
        NAVIGATOR.hideMoreInfoBtn();
        NAVIGATOR.changePage('more_info');
        if (!moreInfoInitialized) {
            moreInfoInitialized = true;
            document.querySelector('#more_info_faqs').onclick = ns.faqsView;
            document.querySelector('#more_info_cambiarLinea').onclick = ns.ChangeLine;

            document.querySelector('#more_info_facebook').onclick = function () {
                var openURL = new MozActivity({
                    name: "view",
                    data: {
                        type: "url",
                        url: 'http://www.facebook.com/MovistarUruguay?v=wall'
                    }
                });
            };
            document.querySelector('#more_info_twitter').onclick = function () {
                var openURL = new MozActivity({
                    name: "view",
                    data: {
                        type: "url",
                        url: 'https://twitter.com/Movistar_UY'
                    }
                });
            };
        }
    };

    /*ns.mapView = function(){
		NAVIGATOR.changePage('map');
		NAVIGATOR.backPageView = ns.moreInfoView;
		window.getMap();
	};*/
}(window.MainApp = window.MainApp || {}, MovistarAPI, CONFIG, LANG, NAVIGATOR, LOADING, CONNECTION));


// Init
var init = function (MainApp) {
    MainApp.init();
};
init(MainApp);
