var app = angular.module('myApp', ['firebase', 'ngCookies','ngMaterial', 'ngTouch','luegg.directives']);

app.controller('mainCtrl', function($scope, $firebaseArray, $firebaseObject, $cookies, $mdSidenav, $mdUtil, $anchorScroll, $timeout,$window){
  
  
  $scope.toggleLeft = buildToggler('left');
  function buildToggler(navID) {
      var debounceFn =  $mdUtil.debounce(function(){
            $mdSidenav(navID)
              .toggle()
              .then(function () {});
          },300);

      return debounceFn;
    }
  
  $scope.close = function () {
      $mdSidenav('left').close()
        .then(function () {});

    };
  
  
  $scope.active=0;
  var ref = new Firebase("https://davchat.firebaseio.com/rooms");
  if(typeof $cookies.username != 'undefined'){
    $scope.username = $cookies.username;
  }
  $scope.loaded=false  
  // create a synchronized array
  // click on `index.html` above to see it used in the DOM!
  $scope.rooms = $firebaseArray(ref);
  $scope.rooms.$loaded().then(function() {
    $scope.loaded=true;
    $scope.joinRoom = function(room){
      angular.forEach($scope.rooms,function(val){
        if(val.$id==room.$id) $scope.selectedRoom=val;
      })   
      $scope.active=3;      
    }

    $scope.createRoom = function(){
      if($scope.tempRoom.name=='')return 0
      $scope.tempRoom.createdAt  = Firebase.ServerValue.TIMESTAMP;      

      $scope.rooms.$add($scope.tempRoom).then(function(){
        $scope.tempRoom = {}
        $scope.active=0;
      });
      
    }
    
    $scope.submitMsg = function(){
      if($scope.a=='') return 0
      var ref = new Firebase("https://davchat.firebaseio.com/rooms/"+$scope.selectedRoom.$id+"/messages");
      $scope.messages = $firebaseArray(ref);
      $scope.messages.$loaded().then(function() {      
      var date = Firebase.ServerValue.TIMESTAMP;      
      $scope.messages.$add({
        timestamp : date,
        username: $scope.username,
        text: $scope.a
      })      
        $scope.a = ''
      })
    } 
    
    $scope.changeUser = function(){
      $scope.username = null;
      $scope.active=2;
    }
    
    $scope.saveUser = function(){
      if($scope.tempUsername==null || $scope.tempUsername=='') return 0
      $scope.username = $scope.tempUsername;
      $scope.active=0;
    }  

    $scope.messageClass = function(index){
        console.log(index)
        var myarray = [];
        angular.forEach($scope.selectedRoom.messages,function(val){
          myarray.push(val)
        })
        if(index>0){
          var thisObj = myarray[index];
          var prevObj = myarray[index-1];
          
          if(thisObj.name == prevObj.name) return 'midMessage';
          else return 'endMessage'
        }else{
          return 'startMessage'
        }
    }


    //end of loaded  
  });
  
    
  
  $scope.$watch('username', function(newval, oldval){
    if(typeof newval != 'undefined')
      $cookies.username = newval;
  })
  $scope.$watch('active',function(newval){
    $scope.close();
    if($scope.username==null) $scope.active=2
    if(newval==3){
      $timeout(function() {       
       $("html, body").animate({ scrollTop: $(document).height() }, 1000);
      },3)
    }
      
  })
  $scope.$watch('messages', function(newval,oldval){
    $timeout(function() {       
       $("html, body").animate({ scrollTop: $(document).height() }, 1000);
    })
  },true)

  $scope.$watch('rooms', function(newval,oldval){
    var notifyMe = false
    angular.forEach(oldval, function(oldRoom){
      angular.forEach(newval, function(newRoom){
        if(oldRoom.$id==newRoom.$id && newRoom.$id!=$scope.selectedRoom.$id){
          if(countMsg(newRoom)!=countMsg(oldRoom)){
            console.log('changed ' + newRoom.name)
            var i= 0
            IamIn(newRoom,function(result){
              if(result){
                if(i==0){
                  i++
                  $scope.notifyMe('A new message in: '+ newRoom.name)
                }
              }
            })
          }
        }
      })
    })    
  },true)

  function countMsg(room){
    if(!room.messages) return 0
    var k = Object.keys(room.messages).map(function(k) { return room[k] });    
    return k.length
  }

  function IamIn(room,next){
    angular.forEach(room.messages,function(msg){      
      if(msg.username==$scope.username) {
        return next(true)
      }
    })      
  }

$scope.notifyMe = function(msg) {
  
    var notification = new Notification(msg);
  
}

});



app.directive('ngEnter', function() {
  return function(scope, element, attrs) {
    element.bind("keydown keypress", function(event) {
      if(event.which === 13) {
        scope.$apply(function(){
          scope.$eval(attrs.ngEnter);
        });

        event.preventDefault();
      }
    });
  };
});


