// canvas
	if ( document.getElementById('grapicEstatus') ) {
		var canvas = document.getElementById('grapicEstatus');
		var ctx = canvas.getContext('2d');
	}



function showNotification( title, optionsBody, optionIcon ) {
	var options;
	if ( !navigator.onLine ) {
		options = { body: optionsBody };
	} else {
		options = { body: optionsBody, icon: optionIcon };
	}

	if ( "Notification" in window ) {
		var n = new Notification( title, options );
	} else if ( "mozNotification" in navigator ) { // Firefox OS < 1.3
		var notification = navigator.mozNotification.createNotification(title,options);
		notification.show();
	} else { // Otros navegadores
		alert( title + ": " + options.body );
	}
}





function checkBatteryStatus() {
	if ( navigator.battery ) {
		var battery = navigator.battery;
		var batteryLevel = Math.round(battery.level * 100);
		var dischargingTime = parseInt(battery.dischargingTime / 60, 10);
		var batteryInfo;

		if ( batteryLevel <= 99 ) {
			batteryInfo = 'Alerta: Batería al ' + batteryLevel + '% ';
//			controllAudio( 'b100', 'play' );
			if ( !isNaN(dischargingTime) ) {
				batteryInfo+='Quedan ' + dischargingTime + ' minutos de batería';
			}
		} else {
			batteryInfo = 'La batería esta en un nivel aceptable';
//			controllAudio( 'b100', 'play' );
		}

		if ( battery.charging ) {
			// Cargando...
			guardarHistorialCarga('1',batteryLevel);
			document.getElementById('batteryText').innerHTML='<span style="color: green;">La batería se está cargando...</span>';
			//Dibujar Barra
			dibujaBarra(batteryLevel,'1');
		} else {
			document.getElementById('batteryText').innerHTML='<span style="color: red;">Cargador desconectado... </span>';
			// Cargador desconectado
			guardarHistorialCarga('2',batteryLevel);
			//Dibujar Barra
			dibujaBarra(batteryLevel,'2');
		}
	}
	mostrarHistorico();
	return batteryInfo;
}






function dibujaBarra(batteryLevel,estado) {
	var retraso = 2000;
	if ( sessionStorage.getItem('x1') ) {
		var valor = parseInt( sessionStorage.getItem('x1') );
		if ( valor < 300 ) {
			if ( valor == 0 ) {
				var x1 = 5;
			} else {
				var x1 = parseInt( valor ) + parseInt( 25 );
			}
			sessionStorage.setItem('x1',x1);
		} else {
			var x1 = sessionStorage.setItem('x1',0);
		}
	} else {
		var x1 = sessionStorage.setItem('x1',0);
	}

	if ( sessionStorage.getItem('notification') ) {
		var itemNotificado = sessionStorage.getItem('notification');
	} else {
		var itemNotificado = 'n/A';
	}

	var ptj = ((batteryLevel*150) / 100 );
	var y1 = 150-ptj;
	ctx.save();
	ctx.clearRect(0,0,300,150);
	ctx.restore();
	if ( batteryLevel < 10 ) {
		ctx.fillStyle = '#a40000';
	}
	if ( batteryLevel >= 10 && batteryLevel < 20 ) {
		ctx.fillStyle = '#ef2929';
		if ( estado == '2' && itemNotificado != 10 && batteryLevel== 10 ) {
			showNotification( 'Estado de batería', 'La batería esta al 10%', '' );
			setTimeout(function(){ controllAudio( 'b10', 'play' ); }, retraso);
			sessionStorage.setItem('notification','10');
		}
	}
	if ( batteryLevel >= 20 && batteryLevel < 40 ) {
		ctx.fillStyle = '#f57900';
		if ( itemNotificado != 20 && batteryLevel== 20 ) {
			showNotification( 'Estado de batería', 'La batería esta al 20%', '' );
			setTimeout(function(){ controllAudio( 'b20', 'play' ); }, retraso);
			sessionStorage.setItem('notification','20');
		}
	}
	if ( batteryLevel >= 40 && batteryLevel < 60 ) {
		ctx.fillStyle = '#edd400';
		if ( itemNotificado != 40 && batteryLevel== 40 ) {
			showNotification( 'Estado de batería', 'La batería esta al 40%', '' );
			setTimeout(function(){ controllAudio( 'b40', 'play' ); }, retraso);
			sessionStorage.setItem('notification','40');
		}
	}
	if ( batteryLevel >= 60 && batteryLevel < 80 ) {
		ctx.fillStyle = '#8ae234';
		if ( itemNotificado != 60 && batteryLevel== 60 ) {
			showNotification( 'Estado de batería', 'La batería esta al 60%', '' );
			setTimeout(function(){ controllAudio( 'b60', 'play' ); }, retraso);
			sessionStorage.setItem('notification','60');
		}
	}
	if ( batteryLevel >= 80 ) {
		ctx.fillStyle = '#4e9a06';
		if ( itemNotificado != 80 && batteryLevel== 80 ) {
			showNotification( 'Estado de batería', 'La batería esta al 80%', '' );
			setTimeout(function(){ controllAudio( 'b80', 'play' ); }, retraso);
			sessionStorage.setItem('notification','80');
		}
		if ( itemNotificado != 100 && batteryLevel== 100 ) {
			showNotification( 'Estado de batería', 'La batería se ha cargado completamente...', '' );
			setTimeout(function(){ controllAudio( 'b100', 'play' ); }, retraso);
			sessionStorage.setItem('notification','100');
		}
	}

	ctx.fillRect(x1,y1,23,150);
	ctx.fillStyle = 'white';
}





function guardarHistorialCarga(estado,batteryLevel) {
	var tiempo = new Date();
	var tUnix = tiempo.getTime();

	// Día
	if ( tiempo.getDate()<10 ) {
		var dia = '0'+tiempo.getDate();
	} else {
		var dia = tiempo.getDate();
	}
	// Mes
	if ( parseInt( tiempo.getMonth() + 1)<10 ) {
		var mes = '0'+parseInt( tiempo.getMonth() + 1);
	} else {
		var mes = parseInt( tiempo.getMonth() + 1);
	}
	//Año
	var anio = tiempo.getFullYear();

	// Hora
	if ( tiempo.getHours()<10 ) {
		var hora = '0'+tiempo.getHours();
	} else {
		var hora = tiempo.getHours();
	}
	// Minutos
	if ( tiempo.getMinutes()<10 ) {
		var minutos = '0'+tiempo.getMinutes();
	} else {
		var minutos = tiempo.getMinutes();
	}
	// Segundos
	if ( tiempo.getSeconds()<10 ) {
		var segundos = '0'+tiempo.getSeconds();
	} else {
		var segundos = tiempo.getSeconds();
	}
	var fecha = dia+'/'+mes+'/'+anio;
	var hms = hora+':'+minutos+':'+segundos;

	if ( sessionStorage.getItem('cargaDescarga') ) {
		var sessState = sessionStorage.getItem('cargaDescarga');
	} else {
		var sessState = sessionStorage.setItem('cargaDescarga',estado);
	}

	if ( sessState!=estado ) {
		if ( estado==2 ) {
			var dataStatus = '<span style="color: #a40000; ">Descarga desde: <br> &nbsp;&nbsp;&nbsp; '+fecha+' '+hms+' Nivel Batería: '+batteryLevel+'% </span><br><br>';
		} else if( estado==1 ) {
			var dataStatus = '<span style="color: #006600; ">Carga desde: <br> &nbsp;&nbsp;&nbsp; '+fecha+' '+hms+' Nivel Batería: '+batteryLevel+'%</span><br><br>';
		}

		// LocalStorage
		if ( localStorage.getItem('historialCD') ) {
			var dataH = localStorage.getItem('historialCD');
			var endId = parseInt(dataH.length - 1);
			var ultimoDato = dataH[endId];
			var dataUltimo = ultimoDato.split(' ');
			var cargaActual = dataStatus.split(' ');

			if ( dataUltimo[2] != cargaActual[2] ) {
				var newData = dataH+','+dataStatus;
			localStorage.setItem('historialCD',newData);
			}
		} else {
			var newData = dataStatus;
			localStorage.setItem('historialCD',newData);
		}
		sessionStorage.setItem('cargaDescarga',estado);
	}
}






function mostrarHistorico() {
	if ( localStorage.getItem('historialCD') ) {
		var dataH = localStorage.getItem('historialCD');
		var historial = dataH.split(',');
			historial = historial.reverse();
		var dataPrint='';
		var hG = parseInt(historial.length*12)+'px';
		for ( var i = 0; i < historial.length; i++){
			dataPrint+='<div class="dataH">'+historial[i]+'</div>';
		}

		document.getElementById('cargaDescarga').innerHTML=dataPrint;
	}
}






function mostrarEstadoBateria() {
	var estado = checkBatteryStatus();
	document.getElementById('textAlert').innerHTML=estado;
}





function LoopEstatus() {
	var estado = checkBatteryStatus();
	mostrarEstadoBateria();
}




function limpiarHistorico() {
	localStorage.removeItem('historialCD');
	sessionStorage.setItem('notification','0');
	document.getElementById('cargaDescarga').style.height='100px';
	document.getElementById('historialCD').style.height='100px';
	document.location.href = document.location.href;
}


if ( document.getElementById('limpiarH') ) {
	document.querySelector('#limpiarH').addEventListener ('click', function () { limpiarHistorico(); } );
}




window.onload = function(){
	mostrarEstadoBateria();
	var estado = checkBatteryStatus();
	showNotification( 'Estado Bateria', estado, '' );
	LoopEstatus();
	setInterval(LoopEstatus,300);
}


/**
* AUIDIO CONTROLS
**/
function controllAudio( id, orden ) {
	var obAd = document.getElementById(id);
	switch ( orden ) {
		case 'play':
			obAd.play();
		break;

		case 'pause':
			obAd.pause();
		break;

		case 'load':
			obAd.load();
		break;
	}
}

//Play
//document.querySelector('#play').addEventListener ('click', function () { controllAudio( 'b100', 'play' ); } );
//document.querySelector('#pause').addEventListener ('click', function () { controllAudio( 'b100', 'pause' ); } );
//document.querySelector('#load').addEventListener ('click', function () { controllAudio( 'b100', 'load' ); } );
