

var time1, time2;
var timer;
var whiteMove = true;
var finish = false;
var paused = false;

function clearActivation(){
		document.getElementById("blackButton").className = document.getElementById("blackButton").className.replace("active", "");
		document.getElementById("whiteButton").className = document.getElementById("whiteButton").className.replace("active", "");
}


function activateWhite(){
		clearActivation();
		document.getElementById("whiteButton").className += " active";
}

function activateBlack(){
		clearActivation();
		document.getElementById("blackButton").className += " active";
}


function togglenav(){
	var nav = document.getElementById("nav");
	if(nav.style.height=="auto"){
		nav.style.height="0";
	} else {
		nav.style.height="auto";
	}
	return false;
}

function start(){
	finish = false;
	whiteMove = true;
	paused = false;
	activateWhite();
	document.getElementById("pauseResume").innerHTML = "Pause";
	time1 = time2 = parseInt(document.getElementById("time").value);
	document.getElementById("whiteClock").innerHTML = formatTime(time1);
	document.getElementById("blackClock").innerHTML = formatTime(time2);
	document.getElementById("setup").style.display="none";
	document.getElementById("game").style.display="block";
	timer = window.setInterval(decrementTimeForWhite, 1000);
}

function pauseGame(){
	var label = document.getElementById("pauseResume").innerHTML;
	if(label=="Pause") {
		clearInterval(timer); 
		clearActivation();
		document.getElementById("pauseResume").innerHTML = "Resume";
		paused = true;
	} else {
		if(whiteMove) {
			timer = window.setInterval(decrementTimeForWhite, 1000);
			activateWhite();
		} else {
			timer = window.setInterval(decrementTimeForBlack, 1000);
			activateBlack();
		}
		document.getElementById("pauseResume").innerHTML = "Pause";
		paused = false;
	}
	togglenav();
}

function resetGame(){
	finish = false;
	whiteMove = true;
	paused = false;
	activateWhite();
	document.getElementById("pauseResume").innerHTML = "Pause";
	clearInterval(timer);
	timer = window.setInterval(decrementTimeForWhite, 1000);
	time1 = time2 = parseInt(document.getElementById("time").value);
	document.getElementById("whiteClock").innerHTML = formatTime(time1);
	document.getElementById("blackClock").innerHTML = formatTime(time2);
	togglenav();
}

function newGame(){
	finish = false;
	whiteMove = true;
	paused = false;
	activateWhite();
	document.getElementById("pauseResume").innerHTML = "Pause";
	clearInterval(timer);
	document.getElementById("setup").style.display="block";
	document.getElementById("game").style.display="none";
	togglenav();
}

function change(startBlack){

	if(paused)
		return;

	if(finish)
		return;
		
	if(whiteMove && !startBlack)
		return;
	
	if(!whiteMove && startBlack)
		return;
	
	clearInterval(timer);
	if(whiteMove){
		timer = window.setInterval(decrementTimeForBlack, 1000);
		activateBlack();
	} else {
		timer = window.setInterval(decrementTimeForWhite, 1000);
		activateWhite();
	}
	whiteMove=!whiteMove;
}

function startBlack(){
	change(true);
}

function startWhite(){
	change(false);
}

function decrementTimeForWhite(){
	time1--;
	if(time1 < 0){
		alert("Time expired for white!");
		clearInterval(timer);
		finish = true;
	} else 
		document.getElementById("whiteClock").innerHTML = formatTime(time1);

}
function decrementTimeForBlack(){
	time2--;
	if(time2 <= 0){
		alert("Time expired for black!");
		clearInterval(timer);
		finish = true;
	} else
		document.getElementById("blackClock").innerHTML = formatTime(time2);

}
function formatTime (secs) {
	var min = Math.floor(secs/60);
	var secs = secs - (min*60);
	return (min < 10? '0' : '') + min + (secs < 10 ? ':0' : ':') + secs;
}	