define(["require", "exports", 'domain/service/utils', 'domain/entity/hiyoko'], function(require, exports, __utils__, __hiyoko__) {
    var utils = __utils__;
    var hiyoko = __hiyoko__;

    var Ground = (function () {
        function Ground(begin, end, height) {
            this.begin = begin;
            this.end = end;
            this.height = height;
        }
        return Ground;
    })();
    exports.Ground = Ground;

    var GroundFactory = (function () {
        function GroundFactory() {
        }
        GroundFactory.prototype.constructor = function () {
        };

        GroundFactory.create = function (start, count) {
            var prev = null;
            return Enumerable.range(start, count).select(function (x) {
                var next;
                if (prev == null) {
                    next = new Ground(-100 * 1000, 320 * 1000, 0);
                } else {
                    var begin = prev.end + (32 + utils.randomRange(0, x * 2)) * 1000;
                    var end = begin + utils.randomRange(64 * 1000, 200 * 1000);
                    var low = Math.max(-100, -x) * 1000;
                    var high = Math.min(x, 200) * 1000;
                    var height = utils.randomRange(low, high);
                    next = new Ground(begin, end, height);
                }
                prev = next;
                return next;
            }).toArray();
        };
        return GroundFactory;
    })();
    exports.GroundFactory = GroundFactory;

    var World = (function () {
        function World(_hiyokos) {
            this._hiyokos = _hiyokos;
            this.grounds = GroundFactory.create(0, 1000);
        }
        Object.defineProperty(World.prototype, "hiyokos", {
            get: function () {
                return this._hiyokos;
            },
            enumerable: true,
            configurable: true
        });

        World.prototype.update = function () {
            var _this = this;
            Enumerable.from(this.hiyokos).where(function (x) {
                return x.status.state !== hiyoko.State.DEAD;
            }).forEach(function (hiyoko) {
                return hiyoko.update(_this.grounds);
            });
        };

        World.prototype.isEnd = function () {
            return this.hiyokos.every(function (x) {
                return x.status.state === hiyoko.State.DEAD;
            });
        };
        return World;
    })();
    exports.World = World;

    var WorldFactory = (function () {
        function WorldFactory() {
        }
        WorldFactory.createNew = function () {
            return new World(hiyoko.HiyokoFactory.createNew());
        };

        WorldFactory.createNext = function (world) {
            return new World(hiyoko.HiyokoFactory.createNext(world.hiyokos));
        };
        return WorldFactory;
    })();
    exports.WorldFactory = WorldFactory;
});
//@ sourceMappingURL=file:///E:/Developments/node/hiyokorun/public/js/domain/entity/entity.js.map
