define(["require", "exports", 'userinterface/presenter'], function(require, exports, __presenter__) {
    var presenter = __presenter__;

    (function (main) {
        var WIDTH = 320 * 1000;
        var HEIGHT = WIDTH;
        var canvas;
        var stage;
        var presenterObj;

        window.onload = function () {
            canvas = document.getElementById('canvas');
            stage = new createjs.Stage(canvas);
            resize();
            window.addEventListener('resize', resize);
            presenterObj = new presenter.Presenter(stage);
            createjs.Ticker.setFPS(60);
            createjs.Ticker.addListener(function () {
                update();
                stage.update();
            });
        };

        function resize() {
            var size = Math.min(window.innerWidth, window.innerHeight);
            canvas.width = size;
            canvas.height = size;
            stage.scaleX = size / WIDTH;
            stage.scaleY = size / HEIGHT;
        }

        function update() {
            presenterObj.update();
        }
    })(exports.main || (exports.main = {}));
    var main = exports.main;
});
//@ sourceMappingURL=file:///E:/Developments/node/hiyokorun/public/js/main.js.map
