define(["require", "exports", 'domain/entity/entity', 'domain/entity/hiyoko'], function(require, exports, __entity__, __hiyoko__) {
    var entity = __entity__;
    var hiyoko = __hiyoko__;

    
    var Game = (function () {
        function Game() {
            this.container = new createjs.Container();
            this.worldView = new WorldView();
            this.meterText = new createjs.Text('1000m', '20px sans-serif', '#888');
            this.container.addChild(whiteWall());
            this.container.addChild(this.worldView.container);
            this.container.addChild(this.meterText);
            this.createWorld();
            this.meterText.y = 300 * 1000;
            this.meterText.scaleX = 1000;
            this.meterText.scaleY = 1000;
        }
        Game.prototype.createWorld = function () {
            if (this.world == null)
                this.world = entity.WorldFactory.createNew(); else {
                this.world = entity.WorldFactory.createNext(this.world);
            }
            this.worldView.init(this.world);
        };

        Game.prototype.update = function () {
            if (this.world.isEnd()) {
                this.createWorld();
            }
            this.world.update();
            this.worldView.update();
            this.meterText.text = (this.worldView.center / 10000 | 0) + ' cm';
        };
        return Game;
    })();

    var WorldView = (function () {
        function WorldView() {
            this.container = new createjs.Container();
            this.center = 0;
            this.hiyokos = [];
            this.grounds = [];
            this.container.y = 200 * 1000;
        }
        WorldView.prototype.init = function (model) {
            var _this = this;
            this.container.removeAllChildren();
            this.center = 0;
            this.model = model;
            this.grounds = model.grounds.map(function (x) {
                return new GroundView(x);
            });
            this.hiyokos = model.hiyokos.map(function (x) {
                return new HiyokoView(x);
            });
            this.hiyokos.forEach(function (x) {
                return _this.container.addChild(x.animation);
            });
        };

        WorldView.prototype.update = function () {
            Enumerable.from(this.hiyokos).where(function (x) {
                return x.model.status.state !== hiyoko.State.DEAD;
            }).forEach(function (hiyoko) {
                return hiyoko.update();
            });
            this.pan();
        };

        WorldView.prototype.getFastest = function () {
            return Enumerable.from(this.hiyokos).where(function (x) {
                return x.model.status.state !== hiyoko.State.DEAD;
            }).orderBy(function (x) {
                return -x.model.status.x;
            }).firstOrDefault();
        };

        WorldView.prototype.pan = function () {
            var _this = this;
            var firstestHiyoko = this.getFastest();
            if (firstestHiyoko == null)
                return;
            var firstest = firstestHiyoko.model.status.x;
            if (firstest < this.center)
                this.center -= (this.center - firstest) / 2; else if (firstest > this.center)
                this.center += (firstest - this.center) / 2;
            this.container.x = this.center + 160 * 1000;

            this.grounds.forEach(function (x) {
                if (_this.isVisible(x.model.begin, x.model.end))
                    _this.container.addChild(x.shape); else
                    _this.container.removeChild(x.shape);
            });
        };

        WorldView.prototype.isVisible = function (begin, end) {
            var screenBegin = this.center - 160 * 1000;
            var screenEnd = this.center + 160 * 1000;
            return screenEnd >= begin && begin >= screenBegin || screenEnd >= end && end >= screenBegin || end >= screenEnd && screenBegin >= begin;
        };
        return WorldView;
    })();

    function whiteWall() {
        var bg = new createjs.Shape();
        bg.graphics.beginFill('#fff').drawRect(0, 0, 320000, 320000);
        return bg;
    }

    var HiyokoView = (function () {
        function HiyokoView(model) {
            var _this = this;
            this.model = model;
            this.currentState = hiyoko.State.WALK;
            var spriteSheet = {
                images: ['/img/hiyoco_nomal_full.png'],
                frames: { width: 32, height: 32 },
                animations: {
                    'walk': [2, 3, null, 8],
                    'charge': 1,
                    'air': 3,
                    'fall': 4
                }
            };
            var ss = new createjs.SpriteSheet(spriteSheet);
            this.animation = new createjs.BitmapAnimation(ss);
            this.animation.scaleX = 1000;
            this.animation.scaleY = 1000;
            this.animation.gotoAndPlay('walk');
            this.animation.addEventListener('click', function (e) {
                _this.model.status.state = hiyoko.State.DEAD;
            });
        }
        HiyokoView.prototype.update = function () {
            if (this.currentState !== this.model.status.state) {
                this.currentState = this.model.status.state;
                this.animation.gotoAndPlay(toAnimationName(this.currentState));
            }
            this.animation.x = -this.model.status.x - 16 * 1000;
            this.animation.y = -this.model.status.y - 31 * 1000;
        };
        return HiyokoView;
    })();

    var GroundView = (function () {
        function GroundView(model) {
            this.model = model;
            this.shape = new createjs.Shape();
            var width = this.model.end - this.model.begin;
            this.shape.graphics.beginFill('#000').drawRect(-this.model.end, -this.model.height, width, 320000);
        }
        return GroundView;
    })();

    function toAnimationName(state) {
        switch (state) {
            case hiyoko.State.WALK:
                return 'walk';
            case hiyoko.State.CHARGE:
                return 'charge';
            case hiyoko.State.AIR:
                return 'air';
            case hiyoko.State.FALL:
                return 'fall';
            default:
                return '';
        }
    }
    return Game;
});
//@ sourceMappingURL=file:///E:/Developments/node/hiyokorun/public/js/userinterface/game.js.map
