define(["require", "exports", 'userinterface/game'], function(require, exports, __Game__) {
    var Game = __Game__;

    var Presenter = (function () {
        function Presenter(stage) {
            this.stage = stage;
            this.frame = -1;
            this.sceneType = null;
            this.game = new Game();
        }
        Presenter.prototype.update = function () {
            if (this.frame === -1) {
                this.changeScene(SceneType.GAME);
            }
            if (this.sceneType === SceneType.GAME) {
                this.game.update();
            }
        };

        Presenter.prototype.changeScene = function (sceneType) {
            if (this.scene !== null) {
                this.stage.removeChild(this.scene);
            }
            switch (sceneType) {
                case SceneType.BRAND:
                    this.scene = getBrandScene(this);
                    break;
                case SceneType.TITLE:
                    this.scene = getTitleScene(this);
                    break;
                case SceneType.GAME:
                    this.scene = this.game.container;
                    break;
            }
            this.frame = 0;
            this.sceneType = sceneType;
            this.stage.addChild(this.scene);
        };
        return Presenter;
    })();
    exports.Presenter = Presenter;

    (function (SceneType) {
        SceneType[SceneType["BRAND"] = 0] = "BRAND";
        SceneType[SceneType["TITLE"] = 1] = "TITLE";
        SceneType[SceneType["GAME"] = 2] = "GAME";
    })(exports.SceneType || (exports.SceneType = {}));
    var SceneType = exports.SceneType;

    function getBrandScene(presenter) {
        var brand = new createjs.Bitmap('img/brand.png');
        brand.scaleX = 1000;
        brand.scaleY = 1000;
        brand.alpha = 0.0;
        createjs.Tween.get(brand).to({ alpha: 1.0 }, 1000).wait(2000).to({ alpha: 0.0 }, 1000).call(function (tweenObject) {
            presenter.changeScene(SceneType.TITLE);
        });
        return brand;
    }

    function getTitleScene(presenter) {
        var title = new createjs.Bitmap('img/title.png');
        title.scaleX = 1000;
        title.scaleY = 1000;
        title.alpha = 0.0;
        createjs.Tween.get(title).to({ alpha: 1.0 }, 250).call(function (tweenObject) {
            presenter.changeScene(SceneType.GAME);
        });
        return title;
    }
});
//@ sourceMappingURL=file:///E:/Developments/node/hiyokorun/public/js/userinterface/presenter.js.map
