/*
 * Try put all calls to external libraries here
 */

var gaPlugin, gaqOk = false;

function playSound(val, vol) {
    var s;
    
    //Try phonegap Media plugin
    try {

        //Some times, do not play more than one sound in Nexus 10. Mp3 decoder speed? Android bug?
        s = new Media('/android_asset/www/sounds/' + val,
            // success callback
            function() {
                this.release();
            },
            // error callback
            function(err) {
                this.release();
        });

        s.setVolume(vol);
        s.play();
        
    
    } catch (err) {
        //Try javascript Audio class
        try {

            s = new Audio('sounds/' + val);
            s.volume = vol; 
            s.play();

        } catch (err) {
            
        }
    }
}

var music = null, musicName = "";

function playMusic(val, vol) {
    var s;

    //Try phonegap Media plugin
    //inPhoneGap() returns true for iOS and Firefox OS but both dont have the Media class
    try {

        

        if (music != null) {
            if (val != null && val === musicName) {
                //Keeps the current music
                return;
            } else {
                music.stop();
                music.release();
                music = null;
                musicName = "";
            }
        }


        if (val != null) {
            s = new Media('/android_asset/www/sounds/' + val,
            // success callback
                    function() {
                        this.release();
                    },
                    // error callback
                    function(err) {
                        this.release();
            });
                            
            s.setVolume(vol);//s.setVolume(.2 + .8 * Math.random());
            //s.currentTime = 0;
            s.play();

            music = s;
            musicName = val;
        }

                

    } catch (err) {
        
        //Try javascript Audio class
        try {

            if (music != null) {

                if (val != null && val === musicName) {
                    //Keeps the current music
                    return;
                } else {
                    music.pause();
                    music = null;
                    musicName = "";
                }
            }
            if (val != null) {
                s = new Audio('sounds/' + val);
                s.volume = vol; //s.volume = .2 + .8 * Math.random();
                //s.currentTime = 0;
                s.play();

                music = s;
                musicName = val;
            }
        
        }  catch (err) {
            console.log('error playSound:' + err);
        }

    }
}

function trackStartPhoneGap(id) {
    analytics.startTrackerWithId(id);
}


function trackEventPhoneGap(Category, Action, Label, Value) {
    analytics.trackEvent(Category, Action, Label, Value);
}

function trackEventPush(Category, Action, Label, Value) {
    if(gaqOk == false) {
        _gaq.push(['_setAccount', 'UA-49234831-1']);
        _gaq.push(['_trackPageview']);
        gaqOk = true;
    }

    _gaq.push(['_trackEvent', Category, Action, Label, Value]);
}

function trackViewPhoneGap(screenTitle) {
    analytics.trackView(screenTitle);
}

function trackViewPush(screenTitle) {
    if(gaqOk == false) {
        _gaq.push(['_setAccount', 'UA-49234831-1']);
        _gaq.push(['_trackPageview']);
        gaqOk = true;
    }

    _gaq.push(['_trackPageview',screenTitle]);
}
