/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */



var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
        document.addEventListener('pause', this.onPause, false);
        document.addEventListener('resume', this.onResume, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicity call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        
        initEngine();
        
        app.receivedEvent('deviceready');
    },
    onPause: function() {
               
        gamePaused();
        
        app.receivedEvent('pause');
    },
    onResume: function() {
        
        gameRunning();
        
        app.receivedEvent('resume');
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
        var parentElement = document.getElementById(id), listeningElement = parentElement.querySelector('.listening'), receivedElement = parentElement.querySelector('.received');

        listeningElement.setAttribute('style', 'display:none;');
        receivedElement.setAttribute('style', 'display:block;');

        console.log('Received Event: ' + id);
    }
};


/*
 * Initialization code (do not use jquery ready function) (same code in index.html)
 */
window.onload = function ()
{
    if (inPhoneGap()) {
        app.initialize();
    } else {
        initEngine();

        /*(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
        (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
        })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

        ga('create', 'UA-49234831-1', 'Chocolate Jewels');/**/

        /*var _gaq = _gaq || [];
        _gaq.push(['_setAccount', 'UA-49234831-1']);
        _gaq.push(['_trackPageview']);

        (function() {
            var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
            ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
            var ss = document.getElementsByTagName('script');
            var s = ss[ss.length - 1]; s.parentNode.insertBefore(ga, s);
        })();/**/
        
                 

        
            var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
            //ga.src = 'js/ga_debug.js';
            ga.src = 'js/ga.js';
            var ss = document.getElementsByTagName('script');
            var s = ss[ss.length - 1]; s.parentNode.insertBefore(ga, s);
            
            
        
    }
    
     
};


