
// lib\layout\version.js
enyo && enyo.version && (enyo.version.layout = "2.4.0");

// lib\layout\contextual\source\ContextualLayout.js
enyo.kind({
    name: "enyo.ContextualLayout",
    kind: "Layout",
    adjustPosition: function() {
        if (this.container.showing && this.container.hasNode()) {
            this.resetPositioning();
            var t = this.getViewWidth(), i = this.getViewHeight(), o = this.container.vertFlushMargin, s = i - this.container.vertFlushMargin, e = this.container.horizFlushMargin, n = t - this.container.horizFlushMargin;
            if (o > this.offset.top + this.offset.height || this.offset.top > s) {
                if (this.applyVerticalFlushPositioning(e, n)) return;
                if (this.applyHorizontalFlushPositioning(e, n)) return;
                if (this.applyVerticalPositioning()) return;
            } else if ((e > this.offset.left + this.offset.width || this.offset.left > n) && this.applyHorizontalPositioning()) return;
            var h = this.getBoundingRect(this.container.node);
            if (h.width > this.container.widePopup) {
                if (this.applyVerticalPositioning()) return;
            } else if (h.height > this.container.longPopup && this.applyHorizontalPositioning()) return;
            if (this.applyVerticalPositioning()) return;
            if (this.applyHorizontalPositioning()) return;
        }
    },
    initVerticalPositioning: function() {
        this.resetPositioning(), this.container.addClass("vertical");
        var t = this.getBoundingRect(this.container.node), i = this.getViewHeight();
        return this.container.floating ? i / 2 > this.offset.top ? (this.applyPosition({
            top: this.offset.top + this.offset.height,
            bottom: "auto"
        }), this.container.addClass("below")) : (this.applyPosition({
            top: this.offset.top - t.height,
            bottom: "auto"
        }), this.container.addClass("above")) : t.top + t.height > i && i - t.bottom < t.top - t.height ? this.container.addClass("above") : this.container.addClass("below"), 
        t = this.getBoundingRect(this.container.node), t.top + t.height > i || 0 > t.top ? !1 : !0;
    },
    applyVerticalPositioning: function() {
        if (!this.initVerticalPositioning()) return !1;
        var t = this.getBoundingRect(this.container.node), i = this.getViewWidth();
        if (this.container.floating) {
            var o = this.offset.left + this.offset.width / 2 - t.width / 2;
            o + t.width > i ? (this.applyPosition({
                left: this.offset.left + this.offset.width - t.width
            }), this.container.addClass("left")) : 0 > o ? (this.applyPosition({
                left: this.offset.left
            }), this.container.addClass("right")) : this.applyPosition({
                left: o
            });
        } else {
            var s = this.offset.left + this.offset.width / 2 - t.left - t.width / 2;
            t.right + s > i ? (this.applyPosition({
                left: this.offset.left + this.offset.width - t.right
            }), this.container.addRemoveClass("left", !0)) : 0 > t.left + s ? this.container.addRemoveClass("right", !0) : this.applyPosition({
                left: s
            });
        }
        return !0;
    },
    applyVerticalFlushPositioning: function(t, i) {
        if (!this.initVerticalPositioning()) return !1;
        var o = this.getBoundingRect(this.container.node), s = this.getViewWidth();
        return t > this.offset.left + this.offset.width / 2 ? (this.offset.left + this.offset.width / 2 < this.container.horizBuffer ? this.applyPosition({
            left: this.container.horizBuffer + (this.container.floating ? 0 : -o.left)
        }) : this.applyPosition({
            left: this.offset.width / 2 + (this.container.floating ? this.offset.left : 0)
        }), this.container.addClass("right"), this.container.addClass("corner"), !0) : this.offset.left + this.offset.width / 2 > i ? (this.offset.left + this.offset.width / 2 > s - this.container.horizBuffer ? this.applyPosition({
            left: s - this.container.horizBuffer - o.right
        }) : this.applyPosition({
            left: this.offset.left + this.offset.width / 2 - o.right
        }), this.container.addClass("left"), this.container.addClass("corner"), !0) : !1;
    },
    initHorizontalPositioning: function() {
        this.resetPositioning();
        var t = this.getBoundingRect(this.container.node), i = this.getViewWidth();
        return this.container.floating ? i / 2 > this.offset.left + this.offset.width ? (this.applyPosition({
            left: this.offset.left + this.offset.width
        }), this.container.addRemoveClass("left", !0)) : (this.applyPosition({
            left: this.offset.left - t.width
        }), this.container.addRemoveClass("right", !0)) : this.offset.left - t.width > 0 ? (this.applyPosition({
            left: this.offset.left - t.left - t.width
        }), this.container.addRemoveClass("right", !0)) : (this.applyPosition({
            left: this.offset.width
        }), this.container.addRemoveClass("left", !0)), this.container.addRemoveClass("horizontal", !0), 
        t = this.getBoundingRect(this.container.node), 0 > t.left || t.left + t.width > i ? !1 : !0;
    },
    applyHorizontalPositioning: function() {
        if (!this.initHorizontalPositioning()) return !1;
        var t = this.getBoundingRect(this.container.node), i = this.getViewHeight(), o = this.offset.top + this.offset.height / 2;
        return this.container.floating ? o >= i / 2 - .05 * i && i / 2 + .05 * i >= o ? this.applyPosition({
            top: this.offset.top + this.offset.height / 2 - t.height / 2,
            bottom: "auto"
        }) : i / 2 > this.offset.top + this.offset.height ? (this.applyPosition({
            top: this.offset.top,
            bottom: "auto"
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.offset.top - t.height + 2 * this.offset.height,
            bottom: "auto"
        }), this.container.addRemoveClass("low", !0)) : o >= i / 2 - .05 * i && i / 2 + .05 * i >= o ? this.applyPosition({
            top: (this.offset.height - t.height) / 2
        }) : i / 2 > this.offset.top + this.offset.height ? (this.applyPosition({
            top: -this.offset.height
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: t.top - t.height - this.offset.top + this.offset.height
        }), this.container.addRemoveClass("low", !0)), !0;
    },
    applyHorizontalFlushPositioning: function(t, i) {
        if (!this.initHorizontalPositioning()) return !1;
        var o = this.getBoundingRect(this.container.node), s = this.getViewHeight();
        return this.container.floating ? s / 2 > this.offset.top ? (this.applyPosition({
            top: this.offset.top + this.offset.height / 2
        }), this.container.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.offset.top + this.offset.height / 2 - o.height
        }), this.container.addRemoveClass("low", !0)) : o.top + o.height > s && s - o.bottom < o.top - o.height ? (this.applyPosition({
            top: o.top - o.height - this.offset.top - this.offset.height / 2
        }), this.container.addRemoveClass("low", !0)) : (this.applyPosition({
            top: this.offset.height / 2
        }), this.container.addRemoveClass("high", !0)), t > this.offset.left + this.offset.width ? (this.container.addClass("left"), 
        this.container.addClass("corner"), !0) : this.offset.left > i ? (this.container.addClass("right"), 
        this.container.addClass("corner"), !0) : !1;
    },
    getBoundingRect: function(t) {
        var i = t.getBoundingClientRect();
        return i.width && i.height ? i : {
            left: i.left,
            right: i.right,
            top: i.top,
            bottom: i.bottom,
            width: i.right - i.left,
            height: i.bottom - i.top
        };
    },
    getViewHeight: function() {
        return void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight;
    },
    getViewWidth: function() {
        return void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
    },
    applyPosition: function(t) {
        var i = "";
        for (var o in t) i += o + ":" + t[o] + (isNaN(t[o]) ? "; " : "px; ");
        this.container.addStyles(i);
    },
    resetPositioning: function() {
        this.container.removeClass("right"), this.container.removeClass("left"), this.container.removeClass("high"), 
        this.container.removeClass("low"), this.container.removeClass("corner"), this.container.removeClass("below"), 
        this.container.removeClass("above"), this.container.removeClass("vertical"), this.container.removeClass("horizontal"), 
        this.applyPosition({
            left: "auto"
        }), this.applyPosition({
            top: "auto"
        });
    },
    reflow: function() {
        this.offset = this.container.activatorOffset, this.adjustPosition();
    }
});

// lib\layout\fittable\source\FittableLayout.js
enyo.kind({
    name: "enyo.FittableLayout",
    kind: "Layout",
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.container.addRemoveClass("force-left-to-right", enyo.Control.prototype.rtl && !this.container.get("rtl"));
        };
    }),
    calcFitIndex: function() {
        var t, i, o = this.container.children;
        for (i = 0; o.length > i; i++) if (t = o[i], t.fit && t.showing) return i;
    },
    getFitControl: function() {
        var t = this.container.children, i = t[this.fitIndex];
        return i && i.fit && i.showing || (this.fitIndex = this.calcFitIndex(), i = t[this.fitIndex]), 
        i;
    },
    shouldReverse: function() {
        return this.container.rtl && "h" === this.orient;
    },
    getFirstChild: function() {
        var t = this.getShowingChildren();
        return this.shouldReverse() ? t[t.length - 1] : t[0];
    },
    getLastChild: function() {
        var t = this.getShowingChildren();
        return this.shouldReverse() ? t[0] : t[t.length - 1];
    },
    getShowingChildren: function() {
        for (var t = [], i = 0, o = this.container.children, e = o.length; e > i; i++) o[i].showing && t.push(o[i]);
        return t;
    },
    _reflow: function(t, i, o, e) {
        this.container.addRemoveClass("enyo-stretch", !this.container.noStretch);
        var s, n, h, a, r, f = this.getFitControl(), l = this.container.hasNode(), d = 0, g = 0, c = 0;
        if (f && l) {
            if (s = enyo.dom.calcPaddingExtents(l), n = f.getBounds(), d = l[i] - (s[o] + s[e]), 
            this.shouldReverse()) {
                a = this.getFirstChild(), c = d - (n[o] + n[t]);
                var p = enyo.dom.getComputedBoxValue(a.hasNode(), "margin", o) || 0;
                if (a == f) g = p; else {
                    var u = a.getBounds(), y = u[o];
                    g = n[o] + p - y;
                }
            } else {
                h = this.getLastChild(), g = n[o] - (s[o] || 0);
                var w = enyo.dom.getComputedBoxValue(h.hasNode(), "margin", e) || 0;
                if (h == f) c = w; else {
                    var v = h.getBounds(), C = n[o] + n[t], m = v[o] + v[t] + w;
                    c = m - C;
                }
            }
            r = d - (g + c), f.applyStyle(t, r + "px");
        }
    },
    reflow: function() {
        "h" == this.orient ? this._reflow("width", "clientWidth", "left", "right") : this._reflow("height", "clientHeight", "top", "bottom");
    }
}), enyo.kind({
    name: "enyo.FittableColumnsLayout",
    kind: "FittableLayout",
    orient: "h",
    layoutClass: "enyo-fittable-columns-layout"
}), enyo.kind({
    name: "enyo.FittableRowsLayout",
    kind: "FittableLayout",
    layoutClass: "enyo-fittable-rows-layout",
    orient: "v"
});

// lib\layout\fittable\source\FittableRows.js
enyo.kind({
    name: "enyo.FittableRows",
    layoutKind: "FittableRowsLayout",
    noStretch: !1
});

// lib\layout\fittable\source\FittableColumns.js
enyo.kind({
    name: "enyo.FittableColumns",
    layoutKind: "FittableColumnsLayout",
    noStretch: !1
});

// lib\layout\fittable\source\FittableHeaderLayout.js
enyo.kind({
    name: "enyo.FittableHeaderLayout",
    kind: "FittableColumnsLayout",
    applyFitSize: enyo.inherit(function(t) {
        return function(i, e, o, n) {
            var s = o - n, h = this.getFitControl();
            0 > s ? (h.applyStyle("padding-left", Math.abs(s) + "px"), h.applyStyle("padding-right", null)) : s > 0 ? (h.applyStyle("padding-left", null), 
            h.applyStyle("padding-right", Math.abs(s) + "px")) : (h.applyStyle("padding-left", null), 
            h.applyStyle("padding-right", null)), t.apply(this, arguments);
        };
    })
});

// lib\layout\list\source\FlyweightRepeater.js
enyo.kind({
    name: "enyo.FlyweightRepeater",
    published: {
        count: 0,
        noSelect: !1,
        multiSelect: !1,
        toggleSelected: !1,
        clientClasses: "",
        clientStyle: "",
        rowOffset: 0,
        orient: "v"
    },
    events: {
        onSetupItem: "",
        onRenderRow: ""
    },
    bottomUp: !1,
    components: [ {
        kind: "Selection",
        onSelect: "selectDeselect",
        onDeselect: "selectDeselect"
    }, {
        name: "client"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.noSelectChanged(), this.multiSelectChanged(), this.clientClassesChanged(), 
            this.clientStyleChanged();
        };
    }),
    noSelectChanged: function() {
        this.noSelect && this.$.selection.clear();
    },
    multiSelectChanged: function() {
        this.$.selection.setMulti(this.multiSelect);
    },
    clientClassesChanged: function() {
        this.$.client.setClasses(this.clientClasses);
    },
    clientStyleChanged: function() {
        this.$.client.setStyle(this.clientStyle);
    },
    setupItem: function(t) {
        this.doSetupItem({
            index: t,
            selected: this.isSelected(t)
        });
    },
    generateChildHtml: enyo.inherit(function(t) {
        return function() {
            var i = "";
            this.index = null;
            for (var e = 0, o = 0; this.count > e; e++) o = this.rowOffset + (this.bottomUp ? this.count - e - 1 : e), 
            this.setupItem(o), this.$.client.setAttribute("data-enyo-index", o), "h" == this.orient && this.$.client.setStyle("display:inline-block;"), 
            i += t.apply(this, arguments), this.$.client.teardownRender();
            return i;
        };
    }),
    previewDomEvent: function(t) {
        var i = this.index = this.rowForEvent(t);
        t.rowIndex = t.index = i, t.flyweight = this;
    },
    decorateEvent: enyo.inherit(function(t) {
        return function(i, e) {
            var o = e && null != e.index ? e.index : this.index;
            e && null != o && (e.index = o, e.flyweight = this), t.apply(this, arguments);
        };
    }),
    tap: function(t, i) {
        this.noSelect || -1 === i.index || (this.toggleSelected ? this.$.selection.toggle(i.index) : this.$.selection.select(i.index));
    },
    selectDeselect: function(t, i) {
        this.renderRow(i.key);
    },
    getSelection: function() {
        return this.$.selection;
    },
    isSelected: function(t) {
        return this.getSelection().isSelected(t);
    },
    renderRow: function(t) {
        if (!(this.rowOffset > t || t >= this.count + this.rowOffset)) {
            this.setupItem(t);
            var i = this.fetchRowNode(t);
            i && (enyo.dom.setInnerHtml(i, this.$.client.generateChildHtml()), this.$.client.teardownChildren(), 
            this.doRenderRow({
                rowIndex: t
            }));
        }
    },
    fetchRowNode: function(t) {
        return this.hasNode() ? this.node.querySelector('[data-enyo-index="' + t + '"]') : void 0;
    },
    rowForEvent: function(t) {
        if (!this.hasNode()) return -1;
        for (var i = t.target; i && i !== this.node; ) {
            var e = i.getAttribute && i.getAttribute("data-enyo-index");
            if (null !== e) return Number(e);
            i = i.parentNode;
        }
        return -1;
    },
    prepareRow: function(t) {
        if (!(this.rowOffset > t || t >= this.count + this.rowOffset)) {
            this.setupItem(t);
            var i = this.fetchRowNode(t);
            enyo.FlyweightRepeater.claimNode(this.$.client, i);
        }
    },
    lockRow: function() {
        this.$.client.teardownChildren();
    },
    performOnRow: function(t, i, e) {
        this.rowOffset > t || t >= this.count + this.rowOffset || i && (this.prepareRow(t), 
        enyo.call(e || null, i), this.lockRow());
    },
    statics: {
        claimNode: function(t, i) {
            var e;
            i && (e = i.id !== t.id ? i.querySelector("#" + t.id) : i), t.generated = Boolean(e || !t.tag), 
            t.node = e, t.node && t.rendered();
            for (var o, n = 0, s = t.children; o = s[n]; n++) this.claimNode(o, i);
        }
    }
});

// lib\layout\list\source\List.js
enyo.kind({
    name: "enyo.List",
    kind: "Scroller",
    classes: "enyo-list",
    published: {
        count: 0,
        rowsPerPage: 50,
        orient: "v",
        bottomUp: !1,
        noSelect: !1,
        multiSelect: !1,
        toggleSelected: !1,
        fixedSize: !1,
        reorderable: !1,
        centerReorderContainer: !0,
        reorderComponents: [],
        pinnedReorderComponents: [],
        swipeableComponents: [],
        enableSwipe: !1,
        persistSwipeableItem: !1
    },
    events: {
        onSetupItem: "",
        onSetupReorderComponents: "",
        onSetupPinnedReorderComponents: "",
        onReorder: "",
        onSetupSwipeItem: "",
        onSwipeDrag: "",
        onSwipe: "",
        onSwipeComplete: ""
    },
    handlers: {
        onAnimateFinish: "animateFinish",
        onRenderRow: "rowRendered",
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        onup: "up",
        onholdpulse: "holdpulse",
        onflick: "flick"
    },
    rowSize: 0,
    listTools: [ {
        name: "port",
        classes: "enyo-list-port enyo-border-box",
        components: [ {
            name: "generator",
            kind: "FlyweightRepeater",
            canGenerate: !1,
            components: [ {
                tag: null,
                name: "client"
            } ]
        }, {
            name: "holdingarea",
            allowHtml: !0,
            classes: "enyo-list-holdingarea"
        }, {
            name: "page0",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "page1",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "placeholder",
            classes: "enyo-list-placeholder"
        }, {
            name: "swipeableComponents",
            style: "position:absolute; display:block; top:-1000px; left:0;"
        } ]
    } ],
    reorderHoldTimeMS: 600,
    draggingRowIndex: -1,
    initHoldCounter: 3,
    holdCounter: 3,
    holding: !1,
    draggingRowNode: null,
    placeholderRowIndex: -1,
    dragToScrollThreshold: .1,
    prevScrollTop: 0,
    autoScrollTimeoutMS: 20,
    autoScrollTimeout: null,
    autoscrollPageY: 0,
    pinnedReorderMode: !1,
    initialPinPosition: -1,
    itemMoved: !1,
    currentPageNumber: -1,
    completeReorderTimeout: null,
    swipeIndex: null,
    swipeDirection: null,
    persistentItemVisible: !1,
    persistentItemOrigin: null,
    swipeComplete: !1,
    completeSwipeTimeout: null,
    completeSwipeDelayMS: 500,
    normalSwipeSpeedMS: 200,
    fastSwipeSpeedMS: 100,
    percentageDraggedThreshold: .2,
    importProps: enyo.inherit(function(t) {
        return function(e) {
            e && e.reorderable && (this.touch = !0), t.apply(this, arguments);
        };
    }),
    create: enyo.inherit(function(t) {
        return function() {
            this.pageSizes = [], this.orientV = "v" == this.orient, this.vertical = this.orientV ? "default" : "hidden", 
            t.apply(this, arguments), this.$.generator.orient = this.orient, this.getStrategy().translateOptimized = !0, 
            this.$.port.addRemoveClass("horizontal", !this.orientV), this.$.port.addRemoveClass("vertical", this.orientV), 
            this.$.page0.addRemoveClass("vertical", this.orientV), this.$.page1.addRemoveClass("vertical", this.orientV), 
            this.bottomUpChanged(), this.noSelectChanged(), this.multiSelectChanged(), this.toggleSelectedChanged(), 
            this.$.generator.setRowOffset(0), this.$.generator.setCount(this.count);
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createReorderTools(), t.apply(this, arguments), this.createSwipeableComponents();
        };
    }),
    createReorderTools: function() {
        this.createComponent({
            name: "reorderContainer",
            classes: "enyo-list-reorder-container",
            ondown: "sendToStrategy",
            ondrag: "sendToStrategy",
            ondragstart: "sendToStrategy",
            ondragfinish: "sendToStrategy",
            onflick: "sendToStrategy"
        });
    },
    createStrategy: enyo.inherit(function(t) {
        return function() {
            this.controlParentName = "strategy", t.apply(this, arguments), this.createChrome(this.listTools), 
            this.controlParentName = "client", this.discoverControlParent();
        };
    }),
    createSwipeableComponents: function() {
        for (var t = 0; this.swipeableComponents.length > t; t++) this.$.swipeableComponents.createComponent(this.swipeableComponents[t], {
            owner: this.owner
        });
    },
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.$.generator.node = this.$.port.hasNode(), this.$.generator.generated = !0, 
            this.reset();
        };
    }),
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.refresh();
        };
    }),
    bottomUpChanged: function() {
        this.$.generator.bottomUp = this.bottomUp, this.$.page0.applyStyle(this.pageBound, null), 
        this.$.page1.applyStyle(this.pageBound, null), this.pageBound = this.orientV ? this.bottomUp ? "bottom" : "top" : this.rtl ? this.bottomUp ? "left" : "right" : this.bottomUp ? "right" : "left", 
        !this.orientV && this.bottomUp && (this.$.page0.applyStyle("left", "auto"), this.$.page1.applyStyle("left", "auto")), 
        this.hasNode() && this.reset();
    },
    noSelectChanged: function() {
        this.$.generator.setNoSelect(this.noSelect);
    },
    multiSelectChanged: function() {
        this.$.generator.setMultiSelect(this.multiSelect);
    },
    toggleSelectedChanged: function() {
        this.$.generator.setToggleSelected(this.toggleSelected);
    },
    countChanged: function() {
        this.hasNode() && this.updateMetrics();
    },
    sendToStrategy: function(t, e) {
        this.$.strategy.dispatchEvent("on" + e.type, e, t);
    },
    updateMetrics: function() {
        this.defaultPageSize = this.rowsPerPage * (this.rowSize || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), 
        this.portSize = 0;
        for (var t = 0; this.pageCount > t; t++) this.portSize += this.getPageSize(t);
        this.adjustPortSize();
    },
    holdpulse: function(t, e) {
        return this.getReorderable() && !this.isReordering() ? e.holdTime >= this.reorderHoldTimeMS && this.shouldStartReordering(t, e) ? (this.startReordering(e), 
        !1) : void 0 : void 0;
    },
    dragstart: function(t, e) {
        return this.isReordering() ? !0 : this.isSwipeable() ? this.swipeDragStart(t, e) : void 0;
    },
    drag: function(t, e) {
        return this.shouldDoReorderDrag(e) ? (e.preventDefault(), this.reorderDrag(e), !0) : this.isSwipeable() ? (e.preventDefault(), 
        this.swipeDrag(t, e), !0) : void 0;
    },
    dragfinish: function(t, e) {
        this.isReordering() ? this.finishReordering(t, e) : this.isSwipeable() && this.swipeDragFinish(t, e);
    },
    up: function(t, e) {
        this.isReordering() && this.finishReordering(t, e);
    },
    generatePage: function(t, e) {
        this.page = t;
        var i = this.rowsPerPage * this.page;
        this.$.generator.setRowOffset(i);
        var o = Math.min(this.count - i, this.rowsPerPage);
        this.$.generator.setCount(o);
        var n = this.$.generator.generateChildHtml();
        e.setContent(n), this.getReorderable() && this.draggingRowIndex > -1 && this.hideReorderingRow();
        var s = e.getBounds(), r = this.orientV ? s.height : s.width;
        if (!this.rowSize && r > 0 && (this.rowSize = Math.floor(r / o), this.updateMetrics()), 
        !this.fixedSize) {
            var h = this.getPageSize(t);
            h != r && r > 0 && (this.pageSizes[t] = r, this.portSize += r - h);
        }
    },
    pageForRow: function(t) {
        return Math.floor(t / this.rowsPerPage);
    },
    preserveDraggingRowNode: function(t) {
        this.draggingRowNode && this.pageForRow(this.draggingRowIndex) === t && (this.$.holdingarea.hasNode().appendChild(this.draggingRowNode), 
        this.draggingRowNode = null, this.removedInitialPage = !0);
    },
    update: function(t) {
        var e = !1, i = this.positionToPageInfo(t), o = i.pos + this.scrollerSize / 2, n = Math.floor(o / Math.max(i.size, this.scrollerSize) + .5) + i.no, s = 0 === n % 2 ? n : n - 1;
        this.p0 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p0), 
        this.generatePage(s, this.$.page0), this.positionPage(s, this.$.page0), this.p0 = s, 
        e = !0, this.p0RowBounds = this.getPageRowSizes(this.$.page0)), s = 0 === n % 2 ? Math.max(1, n - 1) : n, 
        this.p1 != s && this.isPageInRange(s) && (this.preserveDraggingRowNode(this.p1), 
        this.generatePage(s, this.$.page1), this.positionPage(s, this.$.page1), this.p1 = s, 
        e = !0, this.p1RowBounds = this.getPageRowSizes(this.$.page1)), e && (this.$.generator.setRowOffset(0), 
        this.$.generator.setCount(this.count), this.fixedSize || (this.adjustBottomPage(), 
        this.adjustPortSize()));
    },
    getPageRowSizes: function(t) {
        for (var e, i, o = {}, n = t.hasNode().querySelectorAll("div[data-enyo-index]"), s = 0; n.length > s; s++) e = n[s].getAttribute("data-enyo-index"), 
        null !== e && (i = enyo.dom.getBounds(n[s]), o[parseInt(e, 10)] = {
            height: i.height,
            width: i.width
        });
        return o;
    },
    updateRowBounds: function(t) {
        this.p0RowBounds[t] ? this.updateRowBoundsAtIndex(t, this.p0RowBounds, this.$.page0) : this.p1RowBounds[t] && this.updateRowBoundsAtIndex(t, this.p1RowBounds, this.$.page1);
    },
    updateRowBoundsAtIndex: function(t, e, i) {
        var o = i.hasNode().querySelector('div[data-enyo-index="' + t + '"]'), n = enyo.dom.getBounds(o);
        e[t].height = n.height, e[t].width = n.width;
    },
    updateForPosition: function(t) {
        this.update(this.calcPos(t));
    },
    calcPos: function(t) {
        return this.bottomUp ? this.portSize - this.scrollerSize - t : t;
    },
    adjustBottomPage: function() {
        var t = this.p0 >= this.p1 ? this.$.page0 : this.$.page1;
        this.positionPage(t.pageNo, t);
    },
    adjustPortSize: function() {
        this.scrollerSize = this.orientV ? this.getBounds().height : this.getBounds().width;
        var t = Math.max(this.scrollerSize, this.portSize);
        this.$.port.applyStyle(this.orientV ? "height" : "width", t + "px"), this.orientV || this.$.port.applyStyle("height", this.getBounds().height + "px");
    },
    positionPage: function(t, e) {
        e.pageNo = t;
        var i = this.pageToPosition(t);
        e.applyStyle(this.pageBound, i + "px");
    },
    pageToPosition: function(t) {
        for (var e = 0, i = t; i > 0; ) i--, e += this.getPageSize(i);
        return e;
    },
    positionToPageInfo: function(t) {
        for (var e = -1, i = this.calcPos(t), o = this.defaultPageSize; i >= 0; ) e++, o = this.getPageSize(e), 
        i -= o;
        return e = Math.max(e, 0), {
            no: e,
            size: o,
            pos: i + o,
            startRow: e * this.rowsPerPage,
            endRow: Math.min((e + 1) * this.rowsPerPage - 1, this.count - 1)
        };
    },
    isPageInRange: function(t) {
        return t == Math.max(0, Math.min(this.pageCount - 1, t));
    },
    getPageSize: function(t) {
        var e = this.pageSizes[t];
        if (!e) {
            var i = this.rowsPerPage * t, o = Math.min(this.count - i, this.rowsPerPage);
            e = this.defaultPageSize * (o / this.rowsPerPage);
        }
        return Math.max(1, e);
    },
    invalidatePages: function() {
        this.p0 = this.p1 = null, this.p0RowBounds = {}, this.p1RowBounds = {}, this.$.page0.setContent(""), 
        this.$.page1.setContent("");
    },
    invalidateMetrics: function() {
        this.pageSizes = [], this.rowSize = 0, this.updateMetrics();
    },
    scroll: enyo.inherit(function(t) {
        return function(e, i) {
            var o = t.apply(this, arguments), n = this.orientV ? this.getScrollTop() : this.getScrollLeft();
            return this.lastPos === n ? o : (this.lastPos = n, this.update(n), this.pinnedReorderMode && this.reorderScroll(e, i), 
            o);
        };
    }),
    setScrollTop: enyo.inherit(function(t) {
        return function(e) {
            this.update(e), t.apply(this, arguments), this.twiddle();
        };
    }),
    getScrollPosition: function() {
        return this.calcPos(this[this.orientV ? "getScrollTop" : "getScrollLeft"]());
    },
    setScrollPosition: function(t) {
        this[this.orientV ? "setScrollTop" : "setScrollLeft"](this.calcPos(t));
    },
    scrollToBottom: enyo.inherit(function(t) {
        return function() {
            this.update(this.getScrollBounds().maxTop), t.apply(this, arguments);
        };
    }),
    scrollToRow: function(t) {
        var e = this.pageForRow(t), i = this.pageToPosition(e);
        if (this.updateForPosition(i), i = this.pageToPosition(e), this.setScrollPosition(i), 
        e == this.p0 || e == this.p1) {
            var o = this.$.generator.fetchRowNode(t);
            if (o) {
                var n = this.orientV ? o.offsetTop : o.offsetLeft;
                this.bottomUp && (n = this.getPageSize(e) - (this.orientV ? o.offsetHeight : o.offsetWidth) - n);
                var s = this.getScrollPosition() + n;
                this.setScrollPosition(s);
            }
        }
    },
    scrollToStart: function() {
        this[this.bottomUp ? this.orientV ? "scrollToBottom" : "scrollToRight" : "scrollToTop"]();
    },
    scrollToEnd: function() {
        this[this.bottomUp ? this.orientV ? "scrollToTop" : "scrollToLeft" : this.orientV ? "scrollToBottom" : "scrollToRight"]();
    },
    refresh: function() {
        this.invalidatePages(), this.update(this[this.orientV ? "getScrollTop" : "getScrollLeft"]()), 
        this.stabilize(), 4 === enyo.platform.android && this.twiddle();
    },
    reset: function() {
        this.getSelection().clear(), this.invalidateMetrics(), this.invalidatePages(), this.stabilize(), 
        this.scrollToStart();
    },
    getSelection: function() {
        return this.$.generator.getSelection();
    },
    select: function(t, e) {
        return this.getSelection().select(t, e);
    },
    deselect: function(t) {
        return this.getSelection().deselect(t);
    },
    isSelected: function(t) {
        return this.$.generator.isSelected(t);
    },
    renderRow: function(t) {
        this.$.generator.renderRow(t);
    },
    rowRendered: function(t, e) {
        this.updateRowBounds(e.rowIndex);
    },
    prepareRow: function(t) {
        this.$.generator.prepareRow(t);
    },
    lockRow: function() {
        this.$.generator.lockRow();
    },
    performOnRow: function(t, e, i) {
        this.$.generator.performOnRow(t, e, i);
    },
    animateFinish: function() {
        return this.twiddle(), !0;
    },
    twiddle: function() {
        var t = this.getStrategy();
        enyo.call(t, "twiddle");
    },
    pageForPageNumber: function(t, e) {
        return 0 === t % 2 ? e && t !== this.p0 ? null : this.$.page0 : e && t !== this.p1 ? null : this.$.page1;
    },
    shouldStartReordering: function(t, e) {
        return !this.getReorderable() || null == e.rowIndex || 0 > e.rowIndex || this.pinnedReorderMode || t !== this.$.strategy || null == e.index || 0 > e.index ? !1 : !0;
    },
    startReordering: function(t) {
        this.$.strategy.listReordering = !0, this.buildReorderContainer(), this.doSetupReorderComponents(t), 
        this.styleReorderContainer(t), this.draggingRowIndex = this.placeholderRowIndex = t.rowIndex, 
        this.draggingRowNode = t.target, this.removedInitialPage = !1, this.itemMoved = !1, 
        this.initialPageNumber = this.currentPageNumber = this.pageForRow(t.rowIndex), this.prevScrollTop = this.getScrollTop(), 
        this.replaceNodeWithPlaceholder(t.rowIndex);
    },
    buildReorderContainer: function() {
        this.$.reorderContainer.destroyClientControls();
        for (var t = 0; this.reorderComponents.length > t; t++) this.$.reorderContainer.createComponent(this.reorderComponents[t], {
            owner: this.owner
        });
        this.$.reorderContainer.render();
    },
    styleReorderContainer: function(t) {
        this.setItemPosition(this.$.reorderContainer, t.rowIndex), this.setItemBounds(this.$.reorderContainer, t.rowIndex), 
        this.$.reorderContainer.setShowing(!0), this.centerReorderContainer && this.centerReorderContainerOnPointer(t);
    },
    appendNodeToReorderContainer: function(t) {
        this.$.reorderContainer.createComponent({
            allowHtml: !0,
            content: t.innerHTML
        }).render();
    },
    centerReorderContainerOnPointer: function(t) {
        var e = enyo.dom.calcNodePosition(this.hasNode()), i = t.pageX - e.left - parseInt(this.$.reorderContainer.domStyles.width, 10) / 2, o = t.pageY - e.top + this.getScrollTop() - parseInt(this.$.reorderContainer.domStyles.height, 10) / 2;
        "ScrollStrategy" != this.getStrategyKind() && (i -= this.getScrollLeft(), o -= this.getScrollTop()), 
        this.positionReorderContainer(i, o);
    },
    positionReorderContainer: function(t, e) {
        this.$.reorderContainer.addClass("enyo-animatedTopAndLeft"), this.$.reorderContainer.addStyles("left:" + t + "px;top:" + e + "px;"), 
        this.setPositionReorderContainerTimeout();
    },
    setPositionReorderContainerTimeout: function() {
        this.clearPositionReorderContainerTimeout(), this.positionReorderContainerTimeout = setTimeout(this.bindSafely(function() {
            this.$.reorderContainer.removeClass("enyo-animatedTopAndLeft"), this.clearPositionReorderContainerTimeout();
        }), 100);
    },
    clearPositionReorderContainerTimeout: function() {
        this.positionReorderContainerTimeout && (clearTimeout(this.positionReorderContainerTimeout), 
        this.positionReorderContainerTimeout = null);
    },
    shouldDoReorderDrag: function() {
        return !this.getReorderable() || 0 > this.draggingRowIndex || this.pinnedReorderMode ? !1 : !0;
    },
    reorderDrag: function(t) {
        this.positionReorderNode(t), this.checkForAutoScroll(t), this.updatePlaceholderPosition(t.pageY);
    },
    updatePlaceholderPosition: function(t) {
        var e = this.getRowIndexFromCoordinate(t);
        -1 !== e && (e >= this.placeholderRowIndex ? this.movePlaceholderToIndex(Math.min(this.count, e + 1)) : this.movePlaceholderToIndex(e));
    },
    positionReorderNode: function(t) {
        var e = this.$.reorderContainer.getBounds(), i = e.left + t.ddx, o = e.top + t.ddy;
        o = "ScrollStrategy" == this.getStrategyKind() ? o + (this.getScrollTop() - this.prevScrollTop) : o, 
        this.$.reorderContainer.addStyles("top: " + o + "px ; left: " + i + "px"), this.prevScrollTop = this.getScrollTop();
    },
    checkForAutoScroll: function(t) {
        var e, i = enyo.dom.calcNodePosition(this.hasNode()), o = this.getBounds();
        this.autoscrollPageY = t.pageY, t.pageY - i.top < o.height * this.dragToScrollThreshold ? (e = 100 * (1 - (t.pageY - i.top) / (o.height * this.dragToScrollThreshold)), 
        this.scrollDistance = -1 * e) : t.pageY - i.top > o.height * (1 - this.dragToScrollThreshold) ? (e = 100 * ((t.pageY - i.top - o.height * (1 - this.dragToScrollThreshold)) / (o.height - o.height * (1 - this.dragToScrollThreshold))), 
        this.scrollDistance = 1 * e) : this.scrollDistance = 0, 0 === this.scrollDistance ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling();
    },
    stopAutoScrolling: function() {
        this.autoScrollTimeout && (clearTimeout(this.autoScrollTimeout), this.autoScrollTimeout = null);
    },
    startAutoScrolling: function() {
        this.autoScrollTimeout = setInterval(this.bindSafely(this.autoScroll), this.autoScrollTimeoutMS);
    },
    autoScroll: function() {
        0 === this.scrollDistance ? this.stopAutoScrolling() : this.autoScrollTimeout || this.startAutoScrolling(), 
        this.setScrollPosition(this.getScrollPosition() + this.scrollDistance), this.positionReorderNode({
            ddx: 0,
            ddy: 0
        }), this.updatePlaceholderPosition(this.autoscrollPageY);
    },
    movePlaceholderToIndex: function(t) {
        var e, i;
        if (!(0 > t)) {
            t >= this.count ? (e = null, i = this.pageForPageNumber(this.pageForRow(this.count - 1)).hasNode()) : (e = this.$.generator.fetchRowNode(t), 
            i = e.parentNode);
            var o = this.pageForRow(t);
            o >= this.pageCount && (o = this.currentPageNumber), i.insertBefore(this.placeholderNode, e), 
            this.currentPageNumber !== o && (this.updatePageSize(this.currentPageNumber), this.updatePageSize(o), 
            this.updatePagePositions(o)), this.placeholderRowIndex = t, this.currentPageNumber = o, 
            this.itemMoved = !0;
        }
    },
    finishReordering: function(t, e) {
        return !this.isReordering() || this.pinnedReorderMode || this.completeReorderTimeout ? void 0 : (this.stopAutoScrolling(), 
        this.$.strategy.listReordering = !1, this.moveReorderedContainerToDroppedPosition(e), 
        this.completeReorderTimeout = setTimeout(this.bindSafely(this.completeFinishReordering, e), 100), 
        e.preventDefault(), !0);
    },
    moveReorderedContainerToDroppedPosition: function() {
        var t = this.getRelativeOffset(this.placeholderNode, this.hasNode()), e = "ScrollStrategy" == this.getStrategyKind() ? t.top : t.top - this.getScrollTop(), i = t.left - this.getScrollLeft();
        this.positionReorderContainer(i, e);
    },
    completeFinishReordering: function(t) {
        return this.completeReorderTimeout = null, this.placeholderRowIndex > this.draggingRowIndex && (this.placeholderRowIndex = Math.max(0, this.placeholderRowIndex - 1)), 
        this.draggingRowIndex != this.placeholderRowIndex || !this.pinnedReorderComponents.length || this.pinnedReorderMode || this.itemMoved ? (this.removeDraggingRowNode(), 
        this.removePlaceholderNode(), this.emptyAndHideReorderContainer(), this.pinnedReorderMode = !1, 
        this.reorderRows(t), this.draggingRowIndex = this.placeholderRowIndex = -1, this.refresh(), 
        void 0) : (this.beginPinnedReorder(t), void 0);
    },
    beginPinnedReorder: function(t) {
        this.buildPinnedReorderContainer(), this.doSetupPinnedReorderComponents(enyo.mixin(t, {
            index: this.draggingRowIndex
        })), this.pinnedReorderMode = !0, this.initialPinPosition = t.pageY;
    },
    emptyAndHideReorderContainer: function() {
        this.$.reorderContainer.destroyComponents(), this.$.reorderContainer.setShowing(!1);
    },
    buildPinnedReorderContainer: function() {
        this.$.reorderContainer.destroyClientControls();
        for (var t = 0; this.pinnedReorderComponents.length > t; t++) this.$.reorderContainer.createComponent(this.pinnedReorderComponents[t], {
            owner: this.owner
        });
        this.$.reorderContainer.render();
    },
    reorderRows: function(t) {
        this.doReorder(this.makeReorderEvent(t)), this.positionReorderedNode(), this.updateListIndices();
    },
    makeReorderEvent: function(t) {
        return t.reorderFrom = this.draggingRowIndex, t.reorderTo = this.placeholderRowIndex, 
        t;
    },
    positionReorderedNode: function() {
        if (!this.removedInitialPage) {
            var t = this.$.generator.fetchRowNode(this.placeholderRowIndex);
            if (t && (t.parentNode.insertBefore(this.hiddenNode, t), this.showNode(this.hiddenNode)), 
            this.hiddenNode = null, this.currentPageNumber != this.initialPageNumber) {
                var e, i, o = this.pageForPageNumber(this.currentPageNumber), n = this.pageForPageNumber(this.currentPageNumber + 1);
                this.initialPageNumber < this.currentPageNumber ? (e = o.hasNode().firstChild, n.hasNode().appendChild(e)) : (e = o.hasNode().lastChild, 
                i = n.hasNode().firstChild, n.hasNode().insertBefore(e, i)), this.correctPageSizes(), 
                this.updatePagePositions(this.initialPageNumber);
            }
        }
    },
    updateListIndices: function() {
        if (this.shouldDoRefresh()) return this.refresh(), this.correctPageSizes(), void 0;
        var t, e, i, o, n = Math.min(this.draggingRowIndex, this.placeholderRowIndex), s = Math.max(this.draggingRowIndex, this.placeholderRowIndex), r = this.draggingRowIndex - this.placeholderRowIndex > 0 ? 1 : -1;
        if (1 === r) {
            for (t = this.$.generator.fetchRowNode(this.draggingRowIndex), t && t.setAttribute("data-enyo-index", "reordered"), 
            e = s - 1, i = s; e >= n; e--) t = this.$.generator.fetchRowNode(e), t && (o = parseInt(t.getAttribute("data-enyo-index"), 10), 
            i = o + 1, t.setAttribute("data-enyo-index", i));
            t = this.hasNode().querySelector('[data-enyo-index="reordered"]'), t.setAttribute("data-enyo-index", this.placeholderRowIndex);
        } else for (t = this.$.generator.fetchRowNode(this.draggingRowIndex), t && t.setAttribute("data-enyo-index", this.placeholderRowIndex), 
        e = n + 1, i = n; s >= e; e++) t = this.$.generator.fetchRowNode(e), t && (o = parseInt(t.getAttribute("data-enyo-index"), 10), 
        i = o - 1, t.setAttribute("data-enyo-index", i));
    },
    shouldDoRefresh: function() {
        return Math.abs(this.initialPageNumber - this.currentPageNumber) > 1;
    },
    getNodeStyle: function(t) {
        var e = this.$.generator.fetchRowNode(t);
        if (e) {
            var i = this.getRelativeOffset(e, this.hasNode()), o = enyo.dom.getBounds(e);
            return {
                h: o.height,
                w: o.width,
                left: i.left,
                top: i.top
            };
        }
    },
    getRelativeOffset: function(t, e) {
        var i = {
            top: 0,
            left: 0
        };
        if (t !== e && t.parentNode) do i.top += t.offsetTop || 0, i.left += t.offsetLeft || 0, 
        t = t.offsetParent; while (t && t !== e);
        return i;
    },
    replaceNodeWithPlaceholder: function(t) {
        var e = this.$.generator.fetchRowNode(t);
        if (!e) return enyo.log("No node - " + t), void 0;
        this.placeholderNode = this.createPlaceholderNode(e), this.hiddenNode = this.hideNode(e);
        var i = this.pageForPageNumber(this.currentPageNumber);
        i.hasNode().insertBefore(this.placeholderNode, this.hiddenNode);
    },
    createPlaceholderNode: function(t) {
        var e = this.$.placeholder.hasNode().cloneNode(!0), i = enyo.dom.getBounds(t);
        return e.style.height = i.height + "px", e.style.width = i.width + "px", e;
    },
    removePlaceholderNode: function() {
        this.removeNode(this.placeholderNode), this.placeholderNode = null;
    },
    removeDraggingRowNode: function() {
        this.draggingRowNode = null;
        var t = this.$.holdingarea.hasNode();
        t.innerHTML = "";
    },
    removeNode: function(t) {
        t && t.parentNode && t.parentNode.removeChild(t);
    },
    updatePageSize: function(t) {
        if (!(0 > t)) {
            var e = this.pageForPageNumber(t, !0);
            if (e) {
                var i = this.pageSizes[t], o = Math.max(1, e.getBounds().height);
                this.pageSizes[t] = o, this.portSize += o - i;
            }
        }
    },
    updatePagePositions: function(t) {
        this.positionPage(this.currentPageNumber, this.pageForPageNumber(this.currentPageNumber)), 
        this.positionPage(t, this.pageForPageNumber(t));
    },
    correctPageSizes: function() {
        var t = this.initialPageNumber % 2;
        this.updatePageSize(this.currentPageNumber, this.$["page" + this.currentPage]), 
        t != this.currentPageNumber && this.updatePageSize(this.initialPageNumber, this.$["page" + t]);
    },
    hideNode: function(t) {
        return t.style.display = "none", t;
    },
    showNode: function(t) {
        return t.style.display = "block", t;
    },
    dropPinnedRow: function(t) {
        this.moveReorderedContainerToDroppedPosition(t), this.completeReorderTimeout = setTimeout(this.bindSafely(this.completeFinishReordering, t), 100);
    },
    cancelPinnedMode: function(t) {
        this.placeholderRowIndex = this.draggingRowIndex, this.dropPinnedRow(t);
    },
    getRowIndexFromCoordinate: function(t) {
        var e = this.getScrollTop() + t - enyo.dom.calcNodePosition(this.hasNode()).top;
        if (0 > e) return -1;
        var i = this.positionToPageInfo(e), o = i.no == this.p0 ? this.p0RowBounds : this.p1RowBounds;
        if (!o) return this.count;
        for (var n = i.pos, s = this.placeholderNode ? enyo.dom.getBounds(this.placeholderNode).height : 0, r = 0, h = i.startRow; i.endRow >= h; ++h) {
            if (h === this.placeholderRowIndex && (r += s, r >= n)) return -1;
            if (h !== this.draggingRowIndex && (r += o[h].height, r >= n)) return h;
        }
        return h;
    },
    getIndexPosition: function(t) {
        return enyo.dom.calcNodePosition(this.$.generator.fetchRowNode(t));
    },
    setItemPosition: function(t, e) {
        var i = this.getNodeStyle(e), o = "ScrollStrategy" == this.getStrategyKind() ? i.top : i.top - this.getScrollTop(), n = "top:" + o + "px; left:" + i.left + "px;";
        t.addStyles(n);
    },
    setItemBounds: function(t, e) {
        var i = this.getNodeStyle(e), o = "width:" + i.w + "px; height:" + i.h + "px;";
        t.addStyles(o);
    },
    reorderScroll: function() {
        "ScrollStrategy" == this.getStrategyKind() && this.$.reorderContainer.addStyles("top:" + (this.initialPinPosition + this.getScrollTop() - this.rowSize) + "px;"), 
        this.updatePlaceholderPosition(this.initialPinPosition);
    },
    hideReorderingRow: function() {
        var t = this.hasNode().querySelector('[data-enyo-index="' + this.draggingRowIndex + '"]');
        t && (this.hiddenNode = this.hideNode(t));
    },
    isReordering: function() {
        return this.draggingRowIndex > -1;
    },
    isSwiping: function() {
        return null != this.swipeIndex && !this.swipeComplete && null != this.swipeDirection;
    },
    swipeDragStart: function(t, e) {
        return null == e.index || e.vertical ? !0 : (this.completeSwipeTimeout && this.completeSwipe(e), 
        this.swipeComplete = !1, this.swipeIndex != e.index && (this.clearSwipeables(), 
        this.swipeIndex = e.index), this.swipeDirection = e.xDirection, this.persistentItemVisible || this.startSwipe(e), 
        this.draggedXDistance = 0, this.draggedYDistance = 0, !0);
    },
    swipeDrag: function(t, e) {
        return this.persistentItemVisible ? (this.dragPersistentItem(e), this.preventDragPropagation) : this.isSwiping() ? (this.dragSwipeableComponents(this.calcNewDragPosition(e.ddx)), 
        this.draggedXDistance = e.dx, this.draggedYDistance = e.dy, !0) : !1;
    },
    swipeDragFinish: function(t, e) {
        if (this.persistentItemVisible) this.dragFinishPersistentItem(e); else {
            if (!this.isSwiping()) return !1;
            var i = this.calcPercentageDragged(this.draggedXDistance);
            i > this.percentageDraggedThreshold && e.xDirection === this.swipeDirection ? this.swipe(this.fastSwipeSpeedMS) : this.backOutSwipe(e);
        }
        return this.preventDragPropagation;
    },
    isSwipeable: function() {
        return this.enableSwipe && 0 !== this.$.swipeableComponents.controls.length && !this.isReordering() && !this.pinnedReorderMode;
    },
    positionSwipeableContainer: function(t, e) {
        var i = this.$.generator.fetchRowNode(t);
        if (i) {
            var o = this.getRelativeOffset(i, this.hasNode()), n = enyo.dom.getBounds(i), s = 1 == e ? -1 * n.width : n.width;
            this.$.swipeableComponents.addStyles("top: " + o.top + "px; left: " + s + "px; height: " + n.height + "px; width: " + n.width + "px;");
        }
    },
    calcNewDragPosition: function(t) {
        var e = this.$.swipeableComponents.getBounds(), i = e.left, o = this.$.swipeableComponents.getBounds(), n = 1 == this.swipeDirection ? 0 : -1 * o.width, s = 1 == this.swipeDirection ? i + t > n ? n : i + t : n > i + t ? n : i + t;
        return s;
    },
    dragSwipeableComponents: function(t) {
        this.$.swipeableComponents.applyStyle("left", t + "px");
    },
    startSwipe: function(t) {
        t.index = this.swipeIndex, this.positionSwipeableContainer(this.swipeIndex, t.xDirection), 
        this.$.swipeableComponents.setShowing(!0), this.setPersistentItemOrigin(t.xDirection), 
        this.doSetupSwipeItem(t);
    },
    dragPersistentItem: function(t) {
        var e = 0, i = "right" == this.persistentItemOrigin ? Math.max(e, e + t.dx) : Math.min(e, e + t.dx);
        this.$.swipeableComponents.applyStyle("left", i + "px");
    },
    dragFinishPersistentItem: function(t) {
        var e = this.calcPercentageDragged(t.dx) > .2, i = t.dx > 0 ? "right" : 0 > t.dx ? "left" : null;
        this.persistentItemOrigin == i ? e ? this.slideAwayItem() : this.bounceItem(t) : this.bounceItem(t);
    },
    setPersistentItemOrigin: function(t) {
        this.persistentItemOrigin = 1 == t ? "left" : "right";
    },
    calcPercentageDragged: function(t) {
        return Math.abs(t / this.$.swipeableComponents.getBounds().width);
    },
    swipe: function(t) {
        this.swipeComplete = !0, this.animateSwipe(0, t);
    },
    backOutSwipe: function() {
        var t = this.$.swipeableComponents.getBounds(), e = 1 == this.swipeDirection ? -1 * t.width : t.width;
        this.animateSwipe(e, this.fastSwipeSpeedMS), this.swipeDirection = null;
    },
    bounceItem: function() {
        var t = this.$.swipeableComponents.getBounds();
        t.left != t.width && this.animateSwipe(0, this.normalSwipeSpeedMS);
    },
    slideAwayItem: function() {
        var t = this.$.swipeableComponents, e = t.getBounds().width, i = "left" == this.persistentItemOrigin ? -1 * e : e;
        this.animateSwipe(i, this.normalSwipeSpeedMS), this.persistentItemVisible = !1, 
        this.setPersistSwipeableItem(!1);
    },
    clearSwipeables: function() {
        this.$.swipeableComponents.setShowing(!1), this.persistentItemVisible = !1, this.setPersistSwipeableItem(!1);
    },
    completeSwipe: function() {
        this.completeSwipeTimeout && (clearTimeout(this.completeSwipeTimeout), this.completeSwipeTimeout = null), 
        this.getPersistSwipeableItem() ? this.swipeComplete && (this.persistentItemVisible = !0) : (this.$.swipeableComponents.setShowing(!1), 
        this.swipeComplete && this.doSwipeComplete({
            index: this.swipeIndex,
            xDirection: this.swipeDirection
        })), this.swipeIndex = null, this.swipeDirection = null;
    },
    animateSwipe: function(t, e) {
        var i = enyo.now(), o = this.$.swipeableComponents, n = parseInt(o.domStyles.left, 10), s = t - n;
        this.stopAnimateSwipe();
        var r = this.bindSafely(function() {
            var t = enyo.now() - i, h = t / e, a = n + s * Math.min(h, 1);
            o.applyStyle("left", a + "px"), this.job = enyo.requestAnimationFrame(r), t / e >= 1 && (this.stopAnimateSwipe(), 
            this.completeSwipeTimeout = setTimeout(this.bindSafely(function() {
                this.completeSwipe();
            }), this.completeSwipeDelayMS));
        });
        this.job = enyo.requestAnimationFrame(r);
    },
    stopAnimateSwipe: function() {
        this.job && (this.job = enyo.cancelRequestAnimationFrame(this.job));
    }
});

// lib\layout\list\source\PulldownList.js
enyo.kind({
    name: "enyo.PulldownList",
    kind: "List",
    touch: !0,
    pully: null,
    pulldownTools: [ {
        name: "pulldown",
        classes: "enyo-list-pulldown",
        components: [ {
            name: "puller",
            kind: "Puller"
        } ]
    } ],
    events: {
        onPullStart: "",
        onPullCancel: "",
        onPull: "",
        onPullRelease: "",
        onPullComplete: ""
    },
    handlers: {
        onScrollStart: "scrollStartHandler",
        onScrollStop: "scrollStopHandler",
        ondragfinish: "dragfinish"
    },
    pullingMessage: "Pull down to refresh...",
    pulledMessage: "Release to refresh...",
    loadingMessage: "Loading...",
    pullingIconClass: "enyo-puller-arrow enyo-puller-arrow-down",
    pulledIconClass: "enyo-puller-arrow enyo-puller-arrow-up",
    loadingIconClass: "",
    create: enyo.inherit(function(t) {
        return function() {
            var e = {
                kind: "Puller",
                showing: !1,
                text: this.loadingMessage,
                iconClass: this.loadingIconClass,
                onCreate: "setPully"
            };
            this.listTools.splice(0, 0, e), t.apply(this, arguments), this.setPulling();
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createChrome(this.pulldownTools), this.accel = enyo.dom.canAccelerate(), this.translation = this.accel ? "translate3d" : "translate", 
            this.strategyKind = this.resetStrategyKind(), t.apply(this, arguments);
        };
    }),
    resetStrategyKind: function() {
        return enyo.platform.android >= 3 ? "TranslateScrollStrategy" : "TouchScrollStrategy";
    },
    setPully: function(t, e) {
        this.pully = e.originator;
    },
    scrollStartHandler: function() {
        this.firedPullStart = !1, this.firedPull = !1, this.firedPullCancel = !1;
    },
    scroll: enyo.inherit(function(t) {
        return function() {
            var e = t.apply(this, arguments);
            this.completingPull && this.pully.setShowing(!1);
            var i = this.getStrategy().$.scrollMath || this.getStrategy(), o = -1 * this.getScrollTop();
            return i.isInOverScroll() && o > 0 && (enyo.dom.transformValue(this.$.pulldown, this.translation, "0," + o + "px" + (this.accel ? ",0" : "")), 
            this.firedPullStart || (this.firedPullStart = !0, this.pullStart(), this.pullHeight = this.$.pulldown.getBounds().height), 
            o > this.pullHeight && !this.firedPull && (this.firedPull = !0, this.firedPullCancel = !1, 
            this.pull()), this.firedPull && !this.firedPullCancel && this.pullHeight > o && (this.firedPullCancel = !0, 
            this.firedPull = !1, this.pullCancel())), e;
        };
    }),
    scrollStopHandler: function() {
        this.completingPull && (this.completingPull = !1, this.doPullComplete());
    },
    dragfinish: function() {
        if (this.firedPull) {
            var t = this.getStrategy().$.scrollMath || this.getStrategy();
            t.setScrollY(-1 * this.getScrollTop() - this.pullHeight), this.pullRelease();
        }
    },
    completePull: function() {
        this.completingPull = !0;
        var t = this.getStrategy().$.scrollMath || this.getStrategy();
        t.setScrollY(this.pullHeight), t.start();
    },
    pullStart: function() {
        this.setPulling(), this.pully.setShowing(!1), this.$.puller.setShowing(!0), this.doPullStart();
    },
    pull: function() {
        this.setPulled(), this.doPull();
    },
    pullCancel: function() {
        this.setPulling(), this.doPullCancel();
    },
    pullRelease: function() {
        this.$.puller.setShowing(!1), this.pully.setShowing(!0), this.doPullRelease();
    },
    setPulling: function() {
        this.$.puller.setText(this.pullingMessage), this.$.puller.setIconClass(this.pullingIconClass);
    },
    setPulled: function() {
        this.$.puller.setText(this.pulledMessage), this.$.puller.setIconClass(this.pulledIconClass);
    }
}), enyo.kind({
    name: "enyo.Puller",
    classes: "enyo-puller",
    published: {
        text: "",
        iconClass: ""
    },
    events: {
        onCreate: ""
    },
    components: [ {
        name: "icon"
    }, {
        name: "text",
        tag: "span",
        classes: "enyo-puller-text"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.doCreate(), this.textChanged(), this.iconClassChanged();
        };
    }),
    textChanged: function() {
        this.$.text.setContent(this.text);
    },
    iconClassChanged: function() {
        this.$.icon.setClasses(this.iconClass);
    }
});

// lib\layout\list\source\AroundList.js
enyo.kind({
    name: "enyo.AroundList",
    kind: "enyo.List",
    listTools: [ {
        name: "port",
        classes: "enyo-list-port enyo-border-box",
        components: [ {
            name: "aboveClient"
        }, {
            name: "generator",
            kind: "FlyweightRepeater",
            canGenerate: !1,
            components: [ {
                tag: null,
                name: "client"
            } ]
        }, {
            name: "holdingarea",
            allowHtml: !0,
            classes: "enyo-list-holdingarea"
        }, {
            name: "page0",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "page1",
            allowHtml: !0,
            classes: "enyo-list-page"
        }, {
            name: "belowClient"
        }, {
            name: "placeholder"
        }, {
            name: "swipeableComponents",
            style: "position:absolute; display:block; top:-1000px; left:0px;"
        } ]
    } ],
    aboveComponents: null,
    initComponents: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.aboveComponents && this.$.aboveClient.createComponents(this.aboveComponents, {
                owner: this.owner
            }), this.belowComponents && this.$.belowClient.createComponents(this.belowComponents, {
                owner: this.owner
            });
        };
    }),
    updateMetrics: function() {
        this.defaultPageSize = this.rowsPerPage * (this.rowSize || 100), this.pageCount = Math.ceil(this.count / this.rowsPerPage), 
        this.aboveHeight = this.$.aboveClient.getBounds().height, this.belowHeight = this.$.belowClient.getBounds().height, 
        this.portSize = this.aboveHeight + this.belowHeight;
        for (var t = 0; this.pageCount > t; t++) this.portSize += this.getPageSize(t);
        this.adjustPortSize();
    },
    positionPage: function(t, e) {
        e.pageNo = t;
        var i = this.pageToPosition(t), o = this.bottomUp ? this.belowHeight : this.aboveHeight;
        i += o, e.applyStyle(this.pageBound, i + "px");
    },
    scrollToContentStart: function() {
        var t = this.bottomUp ? this.belowHeight : this.aboveHeight;
        this.setScrollPosition(t);
    }
});

// lib\layout\list\source\GridListImageItem.js
enyo.kind({
    name: "enyo.GridListImageItem",
    classes: "enyo-gridlist-imageitem",
    components: [ {
        name: "image",
        kind: "enyo.Image",
        classes: "image"
    }, {
        name: "caption",
        classes: "caption"
    }, {
        name: "subCaption",
        classes: "sub-caption"
    } ],
    published: {
        source: "",
        caption: "",
        subCaption: "",
        selected: !1,
        centered: !0,
        imageSizing: "",
        useCaption: !0,
        useSubCaption: !0
    },
    bindings: [ {
        from: ".source",
        to: ".$.image.src"
    }, {
        from: ".caption",
        to: ".$.caption.content"
    }, {
        from: ".caption",
        to: ".$.caption.showing",
        kind: "enyo.EmptyBinding"
    }, {
        from: ".subCaption",
        to: ".$.subCaption.content"
    }, {
        from: ".subCaption",
        to: ".$.subCaption.showing",
        kind: "enyo.EmptyBinding"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.selectedChanged(), this.imageSizingChanged(), this.centeredChanged();
        };
    }),
    selectedChanged: function() {
        this.addRemoveClass("selected", this.selected);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    imageSizingChanged: function() {
        this.$.image.setSizing(this.imageSizing), this.addRemoveClass("sized-image", !!this.imageSizing), 
        this.imageSizing && (this.useCaptionChanged(), this.useSubCaptionChanged());
    },
    useCaptionChanged: function() {
        this.addRemoveClass("use-caption", this.useCaption);
    },
    useSubCaptionChanged: function() {
        this.addRemoveClass("use-subcaption", this.useSubCaption);
    },
    centeredChanged: function() {
        this.addRemoveClass("centered", this.centered);
    }
});

// lib\layout\slideable\source\Slideable.js
enyo.kind({
    name: "enyo.Slideable",
    kind: "Control",
    published: {
        axis: "h",
        value: 0,
        unit: "px",
        min: 0,
        max: 0,
        accelerated: "auto",
        overMoving: !0,
        draggable: !0
    },
    events: {
        onAnimateFinish: "",
        onChange: ""
    },
    preventDragPropagation: !1,
    tools: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    } ],
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    kDragScalar: 1,
    dragEventProp: "dx",
    unitModifier: !1,
    canTransform: !1,
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.acceleratedChanged(), this.transformChanged(), this.axisChanged(), 
            this.valueChanged(), this.addClass("enyo-slideable");
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createComponents(this.tools), t.apply(this, arguments);
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.canModifyUnit(), this.updateDragScalar();
        };
    }),
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.updateDragScalar();
        };
    }),
    canModifyUnit: function() {
        if (!this.canTransform) {
            var t = this.getInitialStyleValue(this.hasNode(), this.boundary);
            t.match(/px/i) && "%" === this.unit && (this.unitModifier = this.getBounds()[this.dimension]);
        }
    },
    getInitialStyleValue: function(t, e) {
        var i = enyo.dom.getComputedStyle(t);
        return i ? i.getPropertyValue(e) : t && t.currentStyle ? t.currentStyle[e] : "0";
    },
    updateBounds: function(t, e) {
        var i = {};
        i[this.boundary] = t, this.setBounds(i, this.unit), this.setInlineStyles(t, e);
    },
    updateDragScalar: function() {
        if ("%" == this.unit) {
            var t = this.getBounds()[this.dimension];
            this.kDragScalar = t ? 100 / t : 1, this.canTransform || this.updateBounds(this.value, 100);
        }
    },
    transformChanged: function() {
        this.canTransform = enyo.dom.canTransform();
    },
    acceleratedChanged: function() {
        (!enyo.platform.android || 2 >= enyo.platform.android) && enyo.dom.accelerate(this, this.accelerated);
    },
    axisChanged: function() {
        var t = "h" == this.axis;
        this.dragMoveProp = t ? "dx" : "dy", this.shouldDragProp = t ? "horizontal" : "vertical", 
        this.transform = t ? "translateX" : "translateY", this.dimension = t ? "width" : "height", 
        this.boundary = t ? "left" : "top";
    },
    setInlineStyles: function(t, e) {
        var i = {};
        this.unitModifier ? (i[this.boundary] = this.percentToPixels(t, this.unitModifier), 
        i[this.dimension] = this.unitModifier, this.setBounds(i)) : (e ? i[this.dimension] = e : i[this.boundary] = t, 
        this.setBounds(i, this.unit));
    },
    valueChanged: function(t) {
        var e = this.value;
        this.isOob(e) && !this.isAnimating() && (this.value = this.overMoving ? this.dampValue(e) : this.clampValue(e)), 
        enyo.platform.android > 2 && (this.value ? (0 === t || void 0 === t) && enyo.dom.accelerate(this, this.accelerated) : enyo.dom.accelerate(this, !1)), 
        this.canTransform ? enyo.dom.transformValue(this, this.transform, this.value + this.unit) : this.setInlineStyles(this.value, !1), 
        this.doChange();
    },
    getAnimator: function() {
        return this.$.animator;
    },
    isAtMin: function() {
        return this.value <= this.calcMin();
    },
    isAtMax: function() {
        return this.value >= this.calcMax();
    },
    calcMin: function() {
        return this.min;
    },
    calcMax: function() {
        return this.max;
    },
    clampValue: function(t) {
        var e = this.calcMin(), i = this.calcMax();
        return Math.max(e, Math.min(t, i));
    },
    dampValue: function(t) {
        return this.dampBound(this.dampBound(t, this.min, 1), this.max, -1);
    },
    dampBound: function(t, e, i) {
        var o = t;
        return e * i > o * i && (o = e + (o - e) / 4), o;
    },
    percentToPixels: function(t, e) {
        return Math.floor(e / 100 * t);
    },
    pixelsToPercent: function(t) {
        var e = this.unitModifier ? this.getBounds()[this.dimension] : this.container.getBounds()[this.dimension];
        return 100 * (t / e);
    },
    shouldDrag: function(t) {
        return this.draggable && t[this.shouldDragProp];
    },
    isOob: function(t) {
        return t > this.calcMax() || this.calcMin() > t;
    },
    dragstart: function(t, e) {
        return this.shouldDrag(e) ? (e.preventDefault(), this.$.animator.stop(), e.dragInfo = {}, 
        this.dragging = !0, this.drag0 = this.value, this.dragd0 = 0, this.preventDragPropagation) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            e.preventDefault();
            var i = this.canTransform ? e[this.dragMoveProp] * this.kDragScalar : this.pixelsToPercent(e[this.dragMoveProp]), o = this.drag0 + i, n = i - this.dragd0;
            return this.dragd0 = i, n && (e.dragInfo.minimizing = 0 > n), this.setValue(o), 
            this.preventDragPropagation;
        }
    },
    dragfinish: function(t, e) {
        return this.dragging ? (this.dragging = !1, this.completeDrag(e), e.preventTap(), 
        this.preventDragPropagation) : void 0;
    },
    completeDrag: function(t) {
        this.value !== this.calcMax() && this.value != this.calcMin() && this.animateToMinMax(t.dragInfo.minimizing);
    },
    isAnimating: function() {
        return this.$.animator.isAnimating();
    },
    play: function(t, e) {
        this.$.animator.play({
            startValue: t,
            endValue: e,
            node: this.hasNode()
        });
    },
    animateTo: function(t) {
        this.play(this.value, t);
    },
    animateToMin: function() {
        this.animateTo(this.calcMin());
    },
    animateToMax: function() {
        this.animateTo(this.calcMax());
    },
    animateToMinMax: function(t) {
        t ? this.animateToMin() : this.animateToMax();
    },
    animatorStep: function(t) {
        return this.setValue(t.value), !0;
    },
    animatorComplete: function(t) {
        return this.doAnimateFinish(t), !0;
    },
    toggleMinMax: function() {
        this.animateToMinMax(!this.isAtMin());
    }
});

// lib\layout\panels\source\arrangers\Arranger.js
enyo.kind({
    name: "enyo.Arranger",
    kind: "Layout",
    layoutClass: "enyo-arranger",
    accelerated: "auto",
    dragProp: "ddx",
    dragDirectionProp: "xDirection",
    canDragProp: "horizontal",
    incrementalPoints: !1,
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), o = 0; e = i[o]; o++) e._arranger = null;
            t.apply(this, arguments);
        };
    }),
    arrange: function() {},
    size: function() {},
    start: function() {
        var t = this.container.fromIndex, e = this.container.toIndex, i = this.container.transitionPoints = [ t ];
        if (this.incrementalPoints) for (var o = Math.abs(e - t) - 2, n = t; o >= 0; ) n += t > e ? -1 : 1, 
        i.push(n), o--;
        i.push(this.container.toIndex);
    },
    finish: function() {},
    calcArrangementDifference: function() {},
    canDragEvent: function(t) {
        return t[this.canDragProp];
    },
    calcDragDirection: function(t) {
        return t[this.dragDirectionProp];
    },
    calcDrag: function(t) {
        return t[this.dragProp];
    },
    drag: function(t, e, i, o, n) {
        var s = this.measureArrangementDelta(-t, e, i, o, n);
        return s;
    },
    measureArrangementDelta: function(t, e, i, o, n) {
        var s = this.calcArrangementDifference(e, i, o, n), r = s ? t / Math.abs(s) : 0;
        return r *= this.container.fromIndex > this.container.toIndex ? -1 : 1;
    },
    _arrange: function(t) {
        this.containerBounds || this.reflow();
        var e = this.getOrderedControls(t);
        this.arrange(e, t);
    },
    arrangeControl: function(t, e) {
        t._arranger = enyo.mixin(t._arranger || {}, e);
    },
    flow: function() {
        this.c$ = [].concat(this.container.getPanels()), this.controlsIndex = 0;
        for (var t, e = 0, i = this.container.getPanels(); t = i[e]; e++) if (enyo.dom.accelerate(t, !t.preventAccelerate && this.accelerated), 
        enyo.platform.safari) for (var o, n = t.children, s = 0; o = n[s]; s++) enyo.dom.accelerate(o, this.accelerated);
    },
    reflow: function() {
        var t = this.container.hasNode();
        this.containerBounds = t ? {
            width: t.clientWidth,
            height: t.clientHeight
        } : {}, this.size();
    },
    flowArrangement: function() {
        var t = this.container.arrangement;
        if (t) for (var e, i = 0, o = this.container.getPanels(); (e = o[i]) && t[i]; i++) this.flowControl(e, t[i]);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.opacity;
        null != i && enyo.Arranger.opacifyControl(t, i);
    },
    getOrderedControls: function(t) {
        for (var e = Math.floor(t), i = e - this.controlsIndex, o = i > 0, n = this.c$ || [], s = 0; Math.abs(i) > s; s++) o ? n.push(n.shift()) : n.unshift(n.pop());
        return this.controlsIndex = e, n;
    },
    statics: {
        positionControl: function(t, e, i) {
            var o = i || "px";
            if (!this.updating) if (!enyo.dom.canTransform() || t.preventTransform || enyo.platform.android || 10 === enyo.platform.ie) enyo.dom.canTransform() && t.preventTransform && enyo.dom.transform(t, {
                translateX: null,
                translateY: null
            }), t.setBounds(e, i); else {
                var n = e.left, s = e.top;
                n = enyo.isString(n) ? n : n && n + o, s = enyo.isString(s) ? s : s && s + o, enyo.dom.transform(t, {
                    translateX: n || null,
                    translateY: s || null
                });
            }
        },
        opacifyControl: function(t, e) {
            var i = e;
            i = i > .99 ? 1 : .01 > i ? 0 : i, 9 > enyo.platform.ie ? t.applyStyle("filter", "progid:DXImageTransform.Microsoft.Alpha(Opacity=" + 100 * i + ")") : t.applyStyle("opacity", i);
        }
    }
});

// lib\layout\panels\source\arrangers\CardArranger.js
enyo.kind({
    name: "enyo.CardArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    arrange: function(t) {
        for (var e, i, n = 0; e = t[n]; n++) i = 0 === n ? 1 : 0, this.arrangeControl(e, {
            opacity: i
        });
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) {
                var o = e.showing;
                e.setShowing(n == this.container.fromIndex || n == this.container.toIndex), e.showing && !o && e.resized();
            }
        };
    }),
    finish: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.setShowing(n == this.container.toIndex);
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.opacifyControl(e, 1), 
            e.showing || e.setShowing(!0);
            t.apply(this, arguments);
        };
    })
});

// lib\layout\panels\source\arrangers\CardSlideInArranger.js
enyo.kind({
    name: "enyo.CardSlideInArranger",
    kind: "CardArranger",
    start: function() {
        for (var t, e = this.container.getPanels(), i = 0; t = e[i]; i++) {
            var n = t.showing;
            t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), t.showing && !n && t.resized();
        }
        var o = this.container.fromIndex;
        i = this.container.toIndex, this.container.transitionPoints = [ i + "." + o + ".s", i + "." + o + ".f" ];
    },
    finish: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.setShowing(n == this.container.toIndex);
        };
    }),
    arrange: function(t, e) {
        for (var i, n, o = e.split("."), s = o[0], r = o[1], a = "s" == o[2], h = this.containerBounds.width, l = 0, d = this.container.getPanels(); i = d[l]; l++) n = h, 
        r == l && (n = a ? 0 : -h), s == l && (n = a ? h : 0), r == l && r == s && (n = 0), 
        this.arrangeControl(i, {
            left: n
        });
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null
            });
            t.apply(this, arguments);
        };
    })
});

// lib\layout\panels\source\arrangers\CarouselArranger.js
enyo.kind({
    name: "enyo.CarouselArranger",
    kind: "Arranger",
    size: function() {
        var t, e, i, n, o, s = this.container.getPanels(), r = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, a = this.containerBounds;
        a.height -= r.top + r.bottom, a.width -= r.left + r.right;
        var h;
        for (t = 0, i = 0; o = s[t]; t++) n = enyo.dom.calcMarginExtents(o.hasNode()), o.width = o.getBounds().width, 
        o.marginWidth = n.right + n.left, i += (o.fit ? 0 : o.width) + o.marginWidth, o.fit && (h = o);
        if (h) {
            var l = a.width - i;
            h.width = l >= 0 ? l : h.width;
        }
        for (t = 0, e = r.left; o = s[t]; t++) o.setBounds({
            top: r.top,
            bottom: r.bottom,
            width: o.fit ? o.width : null
        });
    },
    arrange: function(t, e) {
        this.container.wrap ? this.arrangeWrap(t, e) : this.arrangeNoWrap(t, e);
    },
    arrangeNoWrap: function(t, e) {
        var i, n, o, s, r = this.container.getPanels(), a = this.container.clamp(e), h = this.containerBounds.width;
        for (i = a, o = 0; (s = r[i]) && (o += s.width + s.marginWidth, !(o > h)); i++) ;
        var l = h - o, d = 0;
        if (l > 0) for (i = a - 1, n = 0; s = r[i]; i--) if (n += s.width + s.marginWidth, 
        0 >= l - n) {
            d = l - n, a = i;
            break;
        }
        var c, u;
        for (i = 0, u = this.containerPadding.left + d; s = r[i]; i++) c = s.width + s.marginWidth, 
        a > i ? this.arrangeControl(s, {
            left: -c
        }) : (this.arrangeControl(s, {
            left: Math.floor(u)
        }), u += c);
    },
    arrangeWrap: function(t) {
        for (var e, i = 0, n = this.containerPadding.left; e = t[i]; i++) this.arrangeControl(e, {
            left: n
        }), n += e.width + e.marginWidth;
    },
    calcArrangementDifference: function(t, e, i, n) {
        var o = Math.abs(t % this.c$.length);
        return e[o].left - n[o].left;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("top", null), e.applyStyle("bottom", null), e.applyStyle("left", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib\layout\panels\source\arrangers\CollapsingArranger.js
enyo.kind({
    name: "enyo.CollapsingArranger",
    kind: "CarouselArranger",
    peekWidth: 0,
    size: enyo.inherit(function(t) {
        return function() {
            this.clearLastSize(), t.apply(this, arguments);
        };
    }),
    clearLastSize: function() {
        for (var t, e = 0, i = this.container.getPanels(); t = i[e]; e++) t._fit && e != i.length - 1 && (t.applyStyle("width", null), 
        t._fit = null);
    },
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.peekWidth = null != this.container.peekWidth ? this.container.peekWidth : this.peekWidth;
        };
    }),
    arrange: function(t, e) {
        for (var i, n = this.container.getPanels(), o = 0, s = this.containerPadding.left, r = 0; i = n[o]; o++) i.getShowing() ? (this.arrangeControl(i, {
            left: s + r * this.peekWidth
        }), o >= e && (s += i.width + i.marginWidth - this.peekWidth), r++) : (this.arrangeControl(i, {
            left: s
        }), o >= e && (s += i.width + i.marginWidth)), o == n.length - 1 && 0 > e && this.arrangeControl(i, {
            left: s - e
        });
    },
    calcArrangementDifference: function(t, e, i, n) {
        var o = this.container.getPanels().length - 1;
        return Math.abs(n[o].left - e[o].left);
    },
    flowControl: enyo.inherit(function(t) {
        return function(e, i) {
            if (t.apply(this, arguments), this.container.realtimeFit) {
                var n = this.container.getPanels(), o = n.length - 1, s = n[o];
                e == s && this.fitControl(e, i.left);
            }
        };
    }),
    finish: enyo.inherit(function(t) {
        return function() {
            if (t.apply(this, arguments), !this.container.realtimeFit && this.containerBounds) {
                var e = this.container.getPanels(), i = this.container.arrangement, n = e.length - 1, o = e[n];
                this.fitControl(o, i[n].left);
            }
        };
    }),
    fitControl: function(t, e) {
        t._fit = !0, t.applyStyle("width", this.containerBounds.width - e + "px"), t.resized();
    }
});

// lib\layout\panels\source\arrangers\DockRightArranger.js
enyo.kind({
    name: "enyo.DockRightArranger",
    kind: "Arranger",
    basePanel: !1,
    overlap: 0,
    layoutWidth: 0,
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.overlap = null != this.container.overlap ? this.container.overlap : this.overlap, 
            this.layoutWidth = null != this.container.layoutWidth ? this.container.layoutWidth : this.layoutWidth;
        };
    }),
    size: function() {
        var t, e, i, n = this.container.getPanels(), o = this.containerPadding = this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {}, s = this.containerBounds;
        s.width -= o.left + o.right;
        var r, a = s.width, h = n.length;
        for (this.container.transitionPositions = {}, t = 0; i = n[t]; t++) i.width = 0 === t && this.container.basePanel ? a : i.getBounds().width;
        for (t = 0; i = n[t]; t++) {
            0 === t && this.container.basePanel && i.setBounds({
                width: a
            }), i.setBounds({
                top: o.top,
                bottom: o.bottom
            });
            for (var l = 0; i = n[l]; l++) {
                var d;
                if (0 === t && this.container.basePanel) d = 0; else if (t > l) d = a; else {
                    if (t !== l) break;
                    r = a > this.layoutWidth ? this.overlap : 0, d = a - n[t].width + r;
                }
                this.container.transitionPositions[t + "." + l] = d;
            }
            if (h > l) for (var c = !1, u = t + 1; h > u; u++) {
                if (r = 0, c) r = 0; else if (n[t].width + n[u].width - this.overlap > a) r = 0, 
                c = !0; else {
                    for (r = n[t].width - this.overlap, e = t; u > e; e++) {
                        var g = r + n[e + 1].width - this.overlap;
                        if (!(a > g)) {
                            r = a;
                            break;
                        }
                        r = g;
                    }
                    r = a - r;
                }
                this.container.transitionPositions[t + "." + u] = r;
            }
        }
    },
    arrange: function(t, e) {
        var i, n, o = this.container.getPanels(), s = this.container.clamp(e);
        for (i = 0; n = o[i]; i++) {
            var r = this.container.transitionPositions[i + "." + s];
            this.arrangeControl(n, {
                left: r
            });
        }
    },
    calcArrangementDifference: function(t, e, i) {
        var n = this.container.getPanels(), o = i > t ? n[i].width : n[t].width;
        return o;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("top", null), e.applyStyle("bottom", null), e.applyStyle("left", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib\layout\panels\source\arrangers\OtherArrangers.js
enyo.kind({
    name: "enyo.LeftRightArranger",
    kind: "Arranger",
    margin: 40,
    axisSize: "width",
    offAxisSize: "height",
    axisPosition: "left",
    constructor: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.margin = null != this.container.margin ? this.container.margin : this.margin;
        };
    }),
    size: function() {
        for (var t, e, i = this.container.getPanels(), n = this.containerBounds[this.axisSize], o = n - this.margin - this.margin, s = 0; e = i[s]; s++) t = {}, 
        t[this.axisSize] = o, t[this.offAxisSize] = "100%", e.setBounds(t);
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.container.fromIndex, n = this.container.toIndex, o = this.getOrderedControls(n), s = Math.floor(o.length / 2), r = 0; e = o[r]; r++) i > n ? r == o.length - s ? e.applyStyle("z-index", 0) : e.applyStyle("z-index", 1) : r == o.length - 1 - s ? e.applyStyle("z-index", 0) : e.applyStyle("z-index", 1);
        };
    }),
    arrange: function(t, e) {
        var i, n, o;
        if (1 == this.container.getPanels().length) return o = {}, o[this.axisPosition] = this.margin, 
        this.arrangeControl(this.container.getPanels()[0], o), void 0;
        var s = Math.floor(this.container.getPanels().length / 2), r = this.getOrderedControls(Math.floor(e) - s), a = this.containerBounds[this.axisSize] - this.margin - this.margin, h = this.margin - a * s;
        for (i = 0; n = r[i]; i++) o = {}, o[this.axisPosition] = h, this.arrangeControl(n, o), 
        h += a;
    },
    calcArrangementDifference: function(t, e, i, n) {
        if (1 == this.container.getPanels().length) return 0;
        var o = Math.abs(t % this.c$.length);
        return e[o][this.axisPosition] - n[o][this.axisPosition];
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), enyo.Arranger.opacifyControl(e, 1), e.applyStyle("left", null), e.applyStyle("top", null), 
            e.applyStyle("height", null), e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
}), enyo.kind({
    name: "enyo.TopBottomArranger",
    kind: "LeftRightArranger",
    dragProp: "ddy",
    dragDirectionProp: "yDirection",
    canDragProp: "vertical",
    axisSize: "height",
    offAxisSize: "width",
    axisPosition: "top"
}), enyo.kind({
    name: "enyo.SpiralArranger",
    kind: "Arranger",
    incrementalPoints: !0,
    inc: 20,
    size: function() {
        for (var t, e = this.container.getPanels(), i = this.containerBounds, n = this.controlWidth = i.width / 3, o = this.controlHeight = i.height / 3, s = 0; t = e[s]; s++) t.setBounds({
            width: n,
            height: o
        });
    },
    arrange: function(t) {
        for (var e, i = this.inc, n = 0, o = t.length; e = t[n]; n++) {
            var s = Math.cos(2 * (n / o) * Math.PI) * n * i + this.controlWidth, r = Math.sin(2 * (n / o) * Math.PI) * n * i + this.controlHeight;
            this.arrangeControl(e, {
                left: s,
                top: r
            });
        }
    },
    start: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments);
            for (var e, i = this.getOrderedControls(this.container.toIndex), n = 0; e = i[n]; n++) e.applyStyle("z-index", i.length - n);
        };
    }),
    calcArrangementDifference: function() {
        return this.controlWidth;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) e.applyStyle("z-index", null), 
            enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("left", null), e.applyStyle("top", null), e.applyStyle("height", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
}), enyo.kind({
    name: "enyo.GridArranger",
    kind: "Arranger",
    incrementalPoints: !0,
    colWidth: 100,
    colHeight: 100,
    size: function() {
        for (var t, e = this.container.getPanels(), i = this.colWidth, n = this.colHeight, o = 0; t = e[o]; o++) t.setBounds({
            width: i,
            height: n
        });
    },
    arrange: function(t) {
        for (var e, i = this.colWidth, n = this.colHeight, o = Math.max(1, Math.floor(this.containerBounds.width / i)), s = 0, r = 0; t.length > r; s++) for (var a = 0; o > a && (e = t[r]); a++, 
        r++) this.arrangeControl(e, {
            left: i * a,
            top: n * s
        });
    },
    flowControl: enyo.inherit(function(t) {
        return function(e, i) {
            t.apply(this, arguments), enyo.Arranger.opacifyControl(e, 0 !== i.top % this.colHeight ? .25 : 1);
        };
    }),
    calcArrangementDifference: function() {
        return this.colWidth;
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            for (var e, i = this.container.getPanels(), n = 0; e = i[n]; n++) enyo.Arranger.positionControl(e, {
                left: null,
                top: null
            }), e.applyStyle("left", null), e.applyStyle("top", null), e.applyStyle("height", null), 
            e.applyStyle("width", null);
            t.apply(this, arguments);
        };
    })
});

// lib\layout\panels\source\Panels.js
enyo.kind({
    name: "enyo.Panels",
    classes: "enyo-panels",
    published: {
        index: 0,
        draggable: !0,
        animate: !0,
        wrap: !1,
        arrangerKind: "CardArranger",
        narrowFit: !0
    },
    events: {
        onTransitionStart: "",
        onTransitionFinish: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        onscroll: "domScroll"
    },
    tools: [ {
        kind: "Animator",
        onStep: "step",
        onEnd: "completed"
    } ],
    fraction: 0,
    create: enyo.inherit(function(t) {
        return function() {
            this.transitionPoints = [], t.apply(this, arguments), this.arrangerKindChanged(), 
            this.narrowFitChanged(), this.indexChanged();
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), enyo.makeBubble(this, "scroll");
        };
    }),
    domScroll: function() {
        this.hasNode() && this.node.scrollLeft > 0 && (this.node.scrollLeft = 0);
    },
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.createChrome(this.tools), t.apply(this, arguments);
        };
    }),
    arrangerKindChanged: function() {
        this.setLayoutKind(this.arrangerKind);
    },
    narrowFitChanged: function() {
        this.addRemoveClass("enyo-panels-fit-narrow", this.narrowFit && enyo.Panels.isScreenNarrow());
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            this.destroying = !0, t.apply(this, arguments);
        };
    }),
    removeControl: enyo.inherit(function(t) {
        return function(e) {
            if (this.destroying) return t.apply(this, arguments);
            var i = -1, n = enyo.indexOf(e, this.controls);
            n === this.index && (i = Math.max(n - 1, 0)), t.apply(this, arguments), -1 !== i && this.controls.length > 0 && (this.setIndex(i), 
            this.flow(), this.reflow());
        };
    }),
    isPanel: function() {
        return !0;
    },
    flow: enyo.inherit(function(t) {
        return function() {
            this.arrangements = [], t.apply(this, arguments);
        };
    }),
    reflow: enyo.inherit(function(t) {
        return function() {
            this.arrangements = [], t.apply(this, arguments), this.refresh();
        };
    }),
    getPanels: function() {
        var t = this.controlParent || this;
        return t.children;
    },
    getActive: function() {
        var t = this.getPanels(), e = this.index % t.length;
        return 0 > e && (e += t.length), t[e];
    },
    getAnimator: function() {
        return this.$.animator;
    },
    setIndex: function(t) {
        var e = this.get("index"), i = this.clamp(t);
        this.index = i, this.notifyObservers("index", e, i);
    },
    setIndexDirect: function(t) {
        this.setIndex(t), this.completed();
    },
    selectPanelByName: function(t) {
        if (t) for (var e = 0, i = this.getPanels(), n = i.length; n > e; ++e) if (t === i[e].name) return this.setIndex(e), 
        e;
    },
    previous: function() {
        var t = this.index - 1;
        this.wrap && 0 > t && (t = this.getPanels().length - 1), this.setIndex(t);
    },
    next: function() {
        var t = this.index + 1;
        this.wrap && t >= this.getPanels().length && (t = 0), this.setIndex(t);
    },
    clamp: function(t) {
        var e = this.getPanels().length;
        return this.wrap ? (t %= e, 0 > t ? t + e : t) : Math.max(0, Math.min(t, e - 1));
    },
    indexChanged: function(t) {
        this.lastIndex = t, !this.dragging && this.$.animator && (this.$.animator.isAnimating() && (this.finishTransitionInfo && (this.finishTransitionInfo.animating = !0), 
        this.completed()), this.$.animator.stop(), this.hasNode() && (this.animate ? (this.startTransition(!0), 
        this.$.animator.play({
            startValue: this.fraction
        })) : this.refresh()));
    },
    step: function(t) {
        return this.fraction = t.value, this.stepTransition(), !0;
    },
    completed: function() {
        return this.$.animator.isAnimating() && this.$.animator.stop(), this.fraction = 1, 
        this.stepTransition(), this.finishTransition(!0), !0;
    },
    dragstart: function(t, e) {
        return this.draggable && this.layout && this.layout.canDragEvent(e) ? (e.preventDefault(), 
        this.dragstartTransition(e), this.dragging = !0, this.$.animator.stop(), !0) : void 0;
    },
    drag: function(t, e) {
        this.dragging && (e.preventDefault(), this.dragTransition(e));
    },
    dragfinish: function(t, e) {
        this.dragging && (this.dragging = !1, e.preventTap(), this.dragfinishTransition(e));
    },
    dragstartTransition: function(t) {
        if (this.$.animator.isAnimating()) this.verifyDragTransition(t); else {
            var e = this.fromIndex = this.index;
            this.toIndex = e - (this.layout ? this.layout.calcDragDirection(t) : 0);
        }
        this.fromIndex = this.clamp(this.fromIndex), this.toIndex = this.clamp(this.toIndex), 
        this.fireTransitionStart(), this.layout && this.layout.start();
    },
    dragTransition: function(t) {
        var e = this.layout ? this.layout.calcDrag(t) : 0, i = this.transitionPoints, n = i[0], o = i[i.length - 1], s = this.fetchArrangement(n), r = this.fetchArrangement(o), a = this.layout ? this.layout.drag(e, n, s, o, r) : 0, h = e && !a;
        this.fraction += a;
        var l = this.fraction;
        (l > 1 || 0 > l || h) && ((l > 0 || h) && this.dragfinishTransition(t), this.dragstartTransition(t), 
        this.fraction = 0), this.stepTransition();
    },
    dragfinishTransition: function(t) {
        this.verifyDragTransition(t), this.setIndex(this.toIndex), this.dragging && this.fireTransitionFinish();
    },
    verifyDragTransition: function(t) {
        var e = this.layout ? this.layout.calcDragDirection(t) : 0, i = Math.min(this.fromIndex, this.toIndex), n = Math.max(this.fromIndex, this.toIndex);
        if (e > 0) {
            var o = i;
            i = n, n = o;
        }
        i != this.fromIndex && (this.fraction = 1 - this.fraction), this.fromIndex = i, 
        this.toIndex = n;
    },
    refresh: function() {
        this.$.animator && this.$.animator.isAnimating() && this.$.animator.stop(), this.startTransition(!1), 
        this.fraction = 1, this.stepTransition(), this.finishTransition(!1);
    },
    startTransition: function(t) {
        this.fromIndex = null != this.fromIndex ? this.fromIndex : this.lastIndex || 0, 
        this.toIndex = null != this.toIndex ? this.toIndex : this.index, this.layout && this.layout.start(), 
        t && this.fireTransitionStart();
    },
    finishTransition: function(t) {
        this.layout && this.layout.finish(), this.transitionPoints = [], this.fraction = 0, 
        this.fromIndex = this.toIndex = null, t && this.fireTransitionFinish();
    },
    fireTransitionStart: function() {
        var t = this.startTransitionInfo;
        !this.hasNode() || t && t.fromIndex == this.fromIndex && t.toIndex == this.toIndex || (this.startTransitionInfo = {
            fromIndex: this.fromIndex,
            toIndex: this.toIndex
        }, this.doTransitionStart(enyo.clone(this.startTransitionInfo)));
    },
    fireTransitionFinish: function() {
        var t = this.finishTransitionInfo;
        !this.hasNode() || t && t.fromIndex == this.lastIndex && t.toIndex == this.index || (this.finishTransitionInfo = t && t.animating ? {
            fromIndex: t.toIndex,
            toIndex: this.lastIndex
        } : {
            fromIndex: this.lastIndex,
            toIndex: this.index
        }, this.doTransitionFinish(enyo.clone(this.finishTransitionInfo)));
    },
    stepTransition: function() {
        if (this.hasNode()) {
            var t = this.transitionPoints, e = (this.fraction || 0) * (t.length - 1), i = Math.floor(e);
            e -= i;
            var n = t[i], o = t[i + 1], s = this.fetchArrangement(n), r = this.fetchArrangement(o);
            this.arrangement = s && r ? enyo.Panels.lerp(s, r, e) : s || r, this.arrangement && this.layout && this.layout.flowArrangement();
        }
    },
    fetchArrangement: function(t) {
        return null != t && !this.arrangements[t] && this.layout && (this.layout._arrange(t), 
        this.arrangements[t] = this.readArrangement(this.getPanels())), this.arrangements[t];
    },
    readArrangement: function(t) {
        for (var e, i = [], n = 0, o = t; e = o[n]; n++) i.push(enyo.clone(e._arranger));
        return i;
    },
    statics: {
        isScreenNarrow: function() {
            var t = navigator.userAgent, e = enyo.dom.getWindowWidth();
            switch (enyo.platform.platformName) {
              case "ios":
                return /iP(?:hone|od;(?: U;)? CPU) OS (\d+)/.test(t);

              case "android":
                return /Mobile/.test(t) && (enyo.platform.android > 2 ? !0 : 800 >= e);

              case "androidChrome":
                return /Mobile/.test(t);
            }
            return 800 >= e;
        },
        lerp: function(t, e, i) {
            for (var n, o = [], s = 0, r = enyo.keys(t); n = r[s]; s++) o.push(this.lerpObject(t[n], e[n], i));
            return o;
        },
        lerpObject: function(t, e, i) {
            var n, o, s = enyo.clone(t);
            if (e) for (var r in t) n = t[r], o = e[r], n != o && (s[r] = n - (n - o) * i);
            return s;
        }
    }
});

// lib\layout\tree\source\Node.js
enyo.kind({
    name: "enyo.Node",
    published: {
        expandable: !1,
        expanded: !1,
        icon: "",
        onlyIconExpands: !1,
        selected: !1
    },
    style: "padding: 0 0 0 16px;",
    content: "Node",
    defaultKind: "Node",
    classes: "enyo-node",
    components: [ {
        name: "icon",
        kind: "Image",
        showing: !1
    }, {
        kind: "Control",
        name: "caption",
        Xtag: "span",
        style: "display: inline-block; padding: 4px;",
        allowHtml: !0
    }, {
        kind: "Control",
        name: "extra",
        tag: "span",
        allowHtml: !0
    } ],
    childClient: [ {
        kind: "Control",
        name: "box",
        classes: "enyo-node-box",
        Xstyle: "border: 1px solid orange;",
        components: [ {
            kind: "Control",
            name: "client",
            classes: "enyo-node-client",
            Xstyle: "border: 1px solid lightblue;"
        } ]
    } ],
    handlers: {
        ondblclick: "dblclick"
    },
    events: {
        onNodeTap: "nodeTap",
        onNodeDblClick: "nodeDblClick",
        onExpand: "nodeExpand",
        onDestroyed: "nodeDestroyed"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.selectedChanged(), this.iconChanged();
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            this.doDestroyed(), t.apply(this, arguments);
        };
    }),
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.expandable && (this.kindComponents = this.kindComponents.concat(this.childClient)), 
            t.apply(this, arguments);
        };
    }),
    contentChanged: function() {
        this.$.caption.setContent(this.content);
    },
    iconChanged: function() {
        this.$.icon.setSrc(this.icon), this.$.icon.setShowing(Boolean(this.icon));
    },
    selectedChanged: function() {
        this.addRemoveClass("enyo-selected", this.selected);
    },
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.expandable && !this.expanded && this.quickCollapse();
        };
    }),
    addNodes: function(t) {
        this.destroyClientControls();
        for (var e, i = 0; e = t[i]; i++) this.createComponent(e);
        this.$.client.render();
    },
    addTextNodes: function(t) {
        this.destroyClientControls();
        for (var e, i = 0; e = t[i]; i++) this.createComponent({
            content: e
        });
        this.$.client.render();
    },
    tap: function(t, e) {
        return this.onlyIconExpands ? e.target == this.$.icon.hasNode() ? this.toggleExpanded() : this.doNodeTap() : (this.toggleExpanded(), 
        this.doNodeTap()), !0;
    },
    dblclick: function() {
        return this.doNodeDblClick(), !0;
    },
    toggleExpanded: function() {
        this.setExpanded(!this.expanded);
    },
    quickCollapse: function() {
        this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "0");
        var t = this.$.client.getBounds().height;
        this.$.client.setBounds({
            top: -t
        });
    },
    _expand: function() {
        this.addClass("enyo-animate");
        var t = this.$.client.getBounds().height;
        this.$.box.setBounds({
            height: t
        }), this.$.client.setBounds({
            top: 0
        }), setTimeout(this.bindSafely(function() {
            this.expanded && (this.removeClass("enyo-animate"), this.$.box.applyStyle("height", "auto"));
        }), 225);
    },
    _collapse: function() {
        this.removeClass("enyo-animate");
        var t = this.$.client.getBounds().height;
        this.$.box.setBounds({
            height: t
        }), setTimeout(this.bindSafely(function() {
            this.addClass("enyo-animate"), this.$.box.applyStyle("height", "0"), this.$.client.setBounds({
                top: -t
            });
        }), 25);
    },
    expandedChanged: function() {
        if (this.expandable) {
            var t = {
                expanded: this.expanded
            };
            this.doExpand(t), t.wait || this.effectExpanded();
        } else this.expanded = !1;
    },
    effectExpanded: function() {
        this.$.client && (this.expanded ? this._expand() : this._collapse());
    }
});

// lib\layout\imageview\source\PanZoomView.js
enyo.kind({
    name: "enyo.PanZoomView",
    kind: enyo.Scroller,
    touchOverscroll: !1,
    thumb: !1,
    animate: !0,
    verticalDragPropagation: !0,
    horizontalDragPropagation: !0,
    published: {
        scale: "auto",
        disableZoom: !1
    },
    events: {
        onZoom: ""
    },
    touch: !0,
    preventDragPropagation: !1,
    handlers: {
        ondragstart: "dragPropagation",
        onSetDimensions: "setDimensions"
    },
    components: [ {
        name: "animator",
        kind: "Animator",
        onStep: "zoomAnimationStep",
        onEnd: "zoomAnimationEnd"
    }, {
        name: "viewport",
        style: "overflow:hidden;min-height:100%;min-width:100%;",
        classes: "enyo-fit",
        ongesturechange: "gestureTransform",
        ongestureend: "saveState",
        ontap: "singleTap",
        ondblclick: "doubleClick",
        onmousewheel: "mousewheel",
        components: [ {
            name: "content"
        } ]
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            this.scaleKeyword = this.scale;
            var e = this.components;
            if (this.components = [], t.apply(this, arguments), this.$.content.applyStyle("width", this.contentWidth + "px"), 
            this.$.content.applyStyle("height", this.contentHeight + "px"), this.unscaledComponents) {
                var i = this.hasOwnProperty("unscaledComponents") ? this.getInstanceOwner() : this;
                this.createComponents(this.unscaledComponents, {
                    owner: i
                });
            }
            this.controlParentName = "content", this.discoverControlParent(), this.createComponents(e), 
            this.canTransform = enyo.dom.canTransform(), this.canTransform || this.$.content.applyStyle("position", "relative"), 
            this.canAccelerate = enyo.dom.canAccelerate(), this.getStrategy().setDragDuringGesture(!1);
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.getOriginalScale();
        };
    }),
    dragPropagation: function(t, e) {
        var i = this.getStrategy().getScrollBounds(), n = 0 === i.top && e.dy > 0 || i.top >= i.maxTop - 2 && 0 > e.dy, o = 0 === i.left && e.dx > 0 || i.left >= i.maxLeft - 2 && 0 > e.dx;
        return !(n && this.verticalDragPropagation || o && this.horizontalDragPropagation);
    },
    mousewheel: function(t, e) {
        e.pageX |= e.clientX + e.target.scrollLeft, e.pageY |= e.clientY + e.target.scrollTop;
        var i = (this.maxScale - this.minScale) / 10, n = this.scale;
        return e.wheelDelta > 0 || 0 > e.detail ? this.scale = this.limitScale(this.scale + i) : (0 > e.wheelDelta || e.detail > 0) && (this.scale = this.limitScale(this.scale - i)), 
        this.eventPt = this.calcEventLocation(e), this.transform(this.scale), n != this.scale && this.doZoom({
            scale: this.scale
        }), this.ratioX = this.ratioY = null, e.preventDefault(), !0;
    },
    resizeHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.scaleChanged();
        };
    }),
    setDimensions: function(t, e) {
        return this.$.content.applyStyle("width", e.width + "px"), this.$.content.applyStyle("height", e.height + "px"), 
        this.originalWidth = e.width, this.originalHeight = e.height, this.scale = this.scaleKeyword, 
        this.scaleChanged(), !0;
    },
    getOriginalScale: function() {
        this.$.content.hasNode() && (this.originalWidth = this.$.content.node.clientWidth, 
        this.originalHeight = this.$.content.node.clientHeight, this.scale = this.scaleKeyword, 
        this.scaleChanged());
    },
    scaleChanged: function() {
        var t = this.hasNode();
        if (t) {
            this.containerWidth = t.clientWidth, this.containerHeight = t.clientHeight;
            var e = this.containerWidth / this.originalWidth, i = this.containerHeight / this.originalHeight;
            this.minScale = Math.min(e, i), this.maxScale = 1 > 3 * this.minScale ? 1 : 3 * this.minScale, 
            "auto" == this.scale ? this.scale = this.minScale : "width" == this.scale ? this.scale = e : "height" == this.scale ? this.scale = i : "fit" == this.scale ? (this.fitAlignment = "center", 
            this.scale = Math.max(e, i)) : (this.maxScale = Math.max(this.maxScale, this.scale), 
            this.scale = this.limitScale(this.scale));
        }
        this.eventPt = this.calcEventLocation(), this.transform(this.scale), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start(), 
        this.align();
    },
    align: function() {
        if (this.fitAlignment && "center" === this.fitAlignment) {
            var t = this.getScrollBounds();
            this.setScrollLeft(t.maxLeft / 2), this.setScrollTop(t.maxTop / 2);
        }
    },
    gestureTransform: function(t, e) {
        this.eventPt = this.calcEventLocation(e), this.transform(this.limitScale(this.scale * e.scale));
    },
    calcEventLocation: function(t) {
        var e = {
            x: 0,
            y: 0
        };
        if (t && this.hasNode()) {
            var i = this.node.getBoundingClientRect();
            e.x = Math.round(t.pageX - i.left - this.bounds.x), e.x = Math.max(0, Math.min(this.bounds.width, e.x)), 
            e.y = Math.round(t.pageY - i.top - this.bounds.y), e.y = Math.max(0, Math.min(this.bounds.height, e.y));
        }
        return e;
    },
    transform: function(t) {
        this.tapped = !1;
        var e = this.bounds || this.innerBounds(t);
        this.bounds = this.innerBounds(t), this.scale > this.minScale ? this.$.viewport.applyStyle("cursor", "move") : this.$.viewport.applyStyle("cursor", null), 
        this.$.viewport.setBounds({
            width: this.bounds.width + "px",
            height: this.bounds.height + "px"
        }), this.ratioX = this.ratioX || (this.eventPt.x + this.getScrollLeft()) / e.width, 
        this.ratioY = this.ratioY || (this.eventPt.y + this.getScrollTop()) / e.height;
        var i, n;
        if (this.$.animator.ratioLock ? (i = this.$.animator.ratioLock.x * this.bounds.width - this.containerWidth / 2, 
        n = this.$.animator.ratioLock.y * this.bounds.height - this.containerHeight / 2) : (i = this.ratioX * this.bounds.width - this.eventPt.x, 
        n = this.ratioY * this.bounds.height - this.eventPt.y), i = Math.max(0, Math.min(this.bounds.width - this.containerWidth, i)), 
        n = Math.max(0, Math.min(this.bounds.height - this.containerHeight, n)), this.canTransform) {
            var o = {
                scale: t
            };
            o = this.canAccelerate ? enyo.mixin({
                translate3d: Math.round(this.bounds.left) + "px, " + Math.round(this.bounds.top) + "px, 0px"
            }, o) : enyo.mixin({
                translate: this.bounds.left + "px, " + this.bounds.top + "px"
            }, o), enyo.dom.transform(this.$.content, o);
        } else if (enyo.platform.ie) {
            var s = '"progid:DXImageTransform.Microsoft.Matrix(M11=' + t + ", M12=0, M21=0, M22=" + t + ", SizingMethod='auto expand')\"";
            this.$.content.applyStyle("-ms-filter", s), this.$.content.setBounds({
                width: this.bounds.width * t + "px",
                height: this.bounds.height * t + "px",
                left: this.bounds.left + "px",
                top: this.bounds.top + "px"
            }), this.$.content.applyStyle("width", t * this.bounds.width), this.$.content.applyStyle("height", t * this.bounds.height);
        }
        this.setScrollLeft(i), this.setScrollTop(n), this.positionClientControls(t);
    },
    limitScale: function(t) {
        return this.disableZoom ? t = this.scale : t > this.maxScale ? t = this.maxScale : this.minScale > t && (t = this.minScale), 
        t;
    },
    innerBounds: function(t) {
        var e = this.originalWidth * t, i = this.originalHeight * t, n = {
            x: 0,
            y: 0,
            transX: 0,
            transY: 0
        };
        return this.containerWidth > e && (n.x += (this.containerWidth - e) / 2), this.containerHeight > i && (n.y += (this.containerHeight - i) / 2), 
        this.canTransform && (n.transX -= (this.originalWidth - e) / 2, n.transY -= (this.originalHeight - i) / 2), 
        {
            left: n.x + n.transX,
            top: n.y + n.transY,
            width: e,
            height: i,
            x: n.x,
            y: n.y
        };
    },
    saveState: function(t, e) {
        var i = this.scale;
        this.scale *= e.scale, this.scale = this.limitScale(this.scale), i != this.scale && this.doZoom({
            scale: this.scale
        }), this.ratioX = this.ratioY = null;
    },
    doubleClick: function(t, e) {
        8 == enyo.platform.ie && (this.tapped = !0, e.pageX = e.clientX + e.target.scrollLeft, 
        e.pageY = e.clientY + e.target.scrollTop, this.singleTap(t, e), e.preventDefault());
    },
    singleTap: function(t, e) {
        setTimeout(this.bindSafely(function() {
            this.tapped = !1;
        }), 300), this.tapped ? (this.tapped = !1, this.smartZoom(t, e)) : this.tapped = !0;
    },
    smartZoom: function(t, e) {
        var i = this.hasNode(), n = this.$.content.hasNode();
        if (i && n && this.hasNode() && !this.disableZoom) {
            var o = this.scale;
            if (this.scale = this.scale != this.minScale ? this.minScale : this.maxScale, this.eventPt = this.calcEventLocation(e), 
            this.animate) {
                var s = {
                    x: (this.eventPt.x + this.getScrollLeft()) / this.bounds.width,
                    y: (this.eventPt.y + this.getScrollTop()) / this.bounds.height
                };
                this.$.animator.play({
                    duration: 350,
                    ratioLock: s,
                    baseScale: o,
                    deltaScale: this.scale - o
                });
            } else this.transform(this.scale), this.doZoom({
                scale: this.scale
            });
        }
    },
    zoomAnimationStep: function() {
        var t = this.$.animator.baseScale + this.$.animator.deltaScale * this.$.animator.value;
        return this.transform(t), !0;
    },
    zoomAnimationEnd: function() {
        return this.stabilize(), this.doZoom({
            scale: this.scale
        }), this.$.animator.ratioLock = void 0, !0;
    },
    positionClientControls: function(t) {
        this.waterfallDown("onPositionPin", {
            scale: t,
            bounds: this.bounds
        });
    }
});

// lib\layout\imageview\source\ImageViewPin.js
enyo.kind({
    name: "enyo.ImageViewPin",
    kind: "enyo.Control",
    published: {
        highlightAnchorPoint: !1,
        anchor: {
            top: 0,
            left: 0
        },
        position: {
            top: 0,
            left: 0
        }
    },
    style: "position:absolute;z-index:1000;width:0px;height:0px;",
    handlers: {
        onPositionPin: "reAnchor"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.styleClientControls(), this.positionClientControls(), 
            this.highlightAnchorPointChanged(), this.anchorChanged();
        };
    }),
    styleClientControls: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) t[e].applyStyle("position", "absolute");
    },
    positionClientControls: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) for (var i in this.position) t[e].applyStyle(i, this.position[i] + "px");
    },
    highlightAnchorPointChanged: function() {
        this.addRemoveClass("pinDebug", this.highlightAnchorPoint);
    },
    anchorChanged: function() {
        var t = null, e = null;
        for (e in this.anchor) t = ("" + this.anchor[e]).match(/^(\d+(?:\.\d+)?)(.*)$/), 
        t && (this.anchor[e + "Coords"] = {
            value: t[1],
            units: t[2] || "px"
        });
    },
    reAnchor: function(t, e) {
        var i = e.scale, n = e.bounds, o = this.anchor.right ? "px" == this.anchor.rightCoords.units ? n.width + n.x - this.anchor.rightCoords.value * i : n.width * (100 - this.anchor.rightCoords.value) / 100 + n.x : "px" == this.anchor.leftCoords.units ? this.anchor.leftCoords.value * i + n.x : n.width * this.anchor.leftCoords.value / 100 + n.x, s = this.anchor.bottom ? "px" == this.anchor.bottomCoords.units ? n.height + n.y - this.anchor.bottomCoords.value * i : n.height * (100 - this.anchor.bottomCoords.value) / 100 + n.y : "px" == this.anchor.topCoords.units ? this.anchor.topCoords.value * i + n.y : n.height * this.anchor.topCoords.value / 100 + n.y;
        this.applyStyle("left", o + "px"), this.applyStyle("top", s + "px");
    }
});

// lib\layout\imageview\source\ImageView.js
enyo.kind({
    name: "enyo.ImageView",
    kind: "enyo.PanZoomView",
    subKindComponents: [ {
        kind: "Image",
        ondown: "down",
        style: "vertical-align: text-top;"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            this.unscaledComponents = this.components, this.components = [], this.kindComponents[1].components[0].components = this.subKindComponents, 
            t.apply(this, arguments), this.$.content.applyStyle("display", "inline-block"), 
            this.bufferImage = new Image(), this.bufferImage.onload = enyo.bind(this, "imageLoaded"), 
            this.bufferImage.onerror = enyo.bind(this, "imageError"), this.srcChanged(), this.getStrategy().$.scrollMath && this.getStrategy().$.scrollMath.start();
        };
    }),
    destroy: enyo.inherit(function(t) {
        return function() {
            this.bufferImage && (this.bufferImage.onerror = void 0, this.bufferImage.onerror = void 0, 
            delete this.bufferImage), t.apply(this, arguments);
        };
    }),
    down: function(t, e) {
        e.preventDefault();
    },
    srcChanged: function() {
        this.src && this.src.length > 0 && this.bufferImage && this.src != this.bufferImage.src && (this.bufferImage.src = this.src);
    },
    imageLoaded: function() {
        if (this.scale = this.scaleKeyword, this.originalWidth = this.contentWidth = this.bufferImage.width, 
        this.originalHeight = this.contentHeight = this.bufferImage.height, this.scaleChanged(), 
        this.$.image.setSrc(this.bufferImage.src), enyo.platform.safari) {
            var t = this.$.image.hasNode(), e = this.bufferImage.src;
            t && setTimeout(function() {
                t.src = e;
            }, 100);
        }
        enyo.dom.transformValue(this.getStrategy().$.client, "translate3d", "0px, 0px, 0"), 
        this.positionClientControls(this.scale), this.align();
    },
    imageError: function(t) {
        enyo.error("Error loading image: " + this.src), this.bubble("onerror", t);
    }
});

// lib\layout\imageview\source\ImageCarousel.js
enyo.kind({
    name: "enyo.ImageCarousel",
    kind: enyo.Panels,
    arrangerKind: "enyo.CarouselArranger",
    defaultScale: "auto",
    disableZoom: !1,
    lowMemory: !1,
    published: {
        images: []
    },
    handlers: {
        onTransitionStart: "transitionStart",
        onTransitionFinish: "transitionFinish"
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.imageCount = this.images.length, this.images.length > 0 && (this.initContainers(), 
            this.loadNearby());
        };
    }),
    initContainers: function() {
        for (var t = 0; this.images.length > t; t++) this.$["container" + t] || (this.createComponent({
            name: "container" + t,
            style: "height:100%; width:100%;"
        }), this.$["container" + t].render());
        for (t = this.images.length; this.imageCount > t; t++) this.$["image" + t] && this.$["image" + t].destroy(), 
        this.$["container" + t].destroy();
        this.imageCount = this.images.length;
    },
    loadNearby: function() {
        var t = this.getBufferRange();
        for (var e in t) this.loadImageView(t[e]);
    },
    getBufferRange: function() {
        var t = [];
        if (this.layout.containerBounds) {
            var e, i, n, o, s = 1, r = this.layout.containerBounds;
            for (i = this.index - 1, n = 0, o = r.width * s; i >= 0 && o >= n; ) e = this.$["container" + i], 
            n += e.width + e.marginWidth, t.unshift(i), i--;
            for (i = this.index, n = 0, o = r.width * (s + 1); this.images.length > i && o >= n; ) e = this.$["container" + i], 
            n += e.width + e.marginWidth, t.push(i), i++;
        }
        return t;
    },
    reflow: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.loadNearby();
        };
    }),
    loadImageView: function(t) {
        return this.wrap && (t = (t % this.images.length + this.images.length) % this.images.length), 
        t >= 0 && this.images.length - 1 >= t && (this.$["image" + t] ? this.$["image" + t].src != this.images[t] && (this.$["image" + t].setSrc(this.images[t]), 
        this.$["image" + t].setScale(this.defaultScale), this.$["image" + t].setDisableZoom(this.disableZoom)) : (this.$["container" + t].createComponent({
            name: "image" + t,
            kind: "ImageView",
            scale: this.defaultScale,
            disableZoom: this.disableZoom,
            src: this.images[t],
            verticalDragPropagation: !1,
            style: "height:100%; width:100%;"
        }, {
            owner: this
        }), this.$["image" + t].render())), this.$["image" + t];
    },
    setImages: function(t) {
        this.set("images", t);
    },
    imagesChanged: function() {
        this.initContainers(), this.loadNearby();
    },
    indexChanged: enyo.inherit(function(t) {
        return function() {
            this.loadNearby(), this.lowMemory && this.cleanupMemory(), t.apply(this, arguments);
        };
    }),
    transitionStart: function(t, e) {
        return e.fromIndex == e.toIndex ? !0 : void 0;
    },
    transitionFinish: function() {
        this.loadNearby(), this.lowMemory && this.cleanupMemory();
    },
    getActiveImage: function() {
        return this.getImageByIndex(this.index);
    },
    getImageByIndex: function(t) {
        return this.$["image" + t] || this.loadImageView(t);
    },
    cleanupMemory: function() {
        for (var t = this.getBufferRange(), e = 0; this.images.length > e; e++) -1 === enyo.indexOf(e, t) && this.$["image" + e] && this.$["image" + e].destroy();
    }
});

// lib\onyx\version.js
enyo && enyo.version && (enyo.version.onyx = "2.4.0");

// lib\onyx\source\Icon.js
enyo.kind({
    name: "onyx.Icon",
    published: {
        src: "",
        disabled: !1
    },
    classes: "onyx-icon",
    create: function() {
        this.inherited(arguments), this.src && this.srcChanged(), this.disabledChanged();
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    srcChanged: function() {
        this.applyStyle("background-image", "url(" + enyo.path.rewrite(this.src) + ")");
    }
});

// lib\onyx\source\Button.js
enyo.kind({
    name: "onyx.Button",
    kind: "enyo.Button",
    classes: "onyx-button enyo-unselectable",
    handlers: {
        ondown: "down",
        onenter: "enter",
        ondragfinish: "dragfinish",
        onleave: "leave",
        onup: "up"
    },
    down: function() {
        return this.disabled ? !0 : (this.addClass("pressed"), this._isPressed = !0, void 0);
    },
    enter: function() {
        return this.disabled ? !0 : (this._isPressed && this.addClass("pressed"), void 0);
    },
    dragfinish: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isPressed = !1, 
        void 0);
    },
    leave: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), void 0);
    },
    up: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isPressed = !1, 
        void 0);
    }
});

// lib\onyx\source\IconButton.js
enyo.kind({
    name: "onyx.IconButton",
    kind: "onyx.Icon",
    published: {
        active: !1
    },
    classes: "onyx-icon-button",
    handlers: {
        ondown: "down",
        onenter: "enter",
        ondragfinish: "dragfinish",
        onleave: "leave",
        onup: "up"
    },
    rendered: function() {
        this.inherited(arguments), this.activeChanged();
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!0), void 0);
    },
    down: function() {
        return this.disabled ? !0 : (this.addClass("pressed"), this._isPressed = !0, void 0);
    },
    enter: function() {
        return this.disabled ? !0 : (this._isPressed && this.addClass("pressed"), void 0);
    },
    dragfinish: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isPressed = !1, 
        void 0);
    },
    leave: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), void 0);
    },
    up: function() {
        return this.disabled ? !0 : (this.removeClass("pressed"), this._isPressed = !1, 
        void 0);
    },
    activeChanged: function() {
        this.bubble("onActivate");
    }
});

// lib\onyx\source\Checkbox.js
enyo.kind({
    name: "onyx.Checkbox",
    classes: "onyx-checkbox",
    kind: enyo.Checkbox,
    tag: "div",
    handlers: {
        onclick: ""
    },
    tap: function() {
        return this.disabled || (this.setChecked(!this.getChecked()), this.bubble("onchange")), 
        !this.disabled;
    },
    dragstart: function() {}
});

// lib\onyx\source\Drawer.js
enyo.kind({
    name: "onyx.Drawer",
    kind: "enyo.Drawer"
});

// lib\onyx\source\Grabber.js
enyo.kind({
    name: "onyx.Grabber",
    classes: "onyx-grabber"
});

// lib\onyx\source\Groupbox.js
enyo.kind({
    name: "onyx.Groupbox",
    classes: "onyx-groupbox"
}), enyo.kind({
    name: "onyx.GroupboxHeader",
    classes: "onyx-groupbox-header"
});

// lib\onyx\source\Input.js
enyo.kind({
    name: "onyx.Input",
    kind: "enyo.Input",
    classes: "onyx-input"
});

// lib\onyx\source\Popup.js
enyo.kind({
    name: "onyx.Popup",
    kind: "enyo.Popup",
    classes: "onyx-popup",
    published: {
        scrimWhenModal: !0,
        scrim: !1,
        scrimClassName: "",
        defaultZ: 120
    },
    protectedStatics: {
        count: 0,
        highestZ: 120
    },
    showingChanged: function() {
        this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, 
        this.showHideScrim(this.showing), this.inherited(arguments);
    },
    showHideScrim: function(t) {
        if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
            var e = this.getScrim();
            if (t) {
                var i = this.getScrimZIndex();
                this._scrimZ = i, e.showAtZIndex(i);
            } else e.hideAtZIndex(this._scrimZ);
            enyo.call(e, "addRemoveClass", [ this.scrimClassName, e.showing ]);
        }
    },
    getScrimZIndex: function() {
        return onyx.Popup.highestZ >= this._zIndex ? this._zIndex - 1 : onyx.Popup.highestZ;
    },
    getScrim: function() {
        return this.modal && this.scrimWhenModal && !this.scrim ? onyx.scrimTransparent.make() : onyx.scrim.make();
    },
    applyZIndex: function() {
        this._zIndex = 2 * onyx.Popup.count + this.findZIndex() + 1, this._zIndex <= onyx.Popup.highestZ && (this._zIndex = onyx.Popup.highestZ + 1), 
        this._zIndex > onyx.Popup.highestZ && (onyx.Popup.highestZ = this._zIndex), this.applyStyle("z-index", this._zIndex);
    },
    findZIndex: function() {
        var t = this.defaultZ;
        return this._zIndex ? t = this._zIndex : this.hasNode() && (t = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || t), 
        this.defaultZ > t && (t = this.defaultZ), this._zIndex = t, this._zIndex;
    }
});

// lib\onyx\source\TextArea.js
enyo.kind({
    name: "onyx.TextArea",
    kind: "enyo.TextArea",
    classes: "onyx-textarea"
});

// lib\onyx\source\RichText.js
enyo.kind({
    name: "onyx.RichText",
    kind: "enyo.RichText",
    classes: "onyx-richtext"
});

// lib\onyx\source\InputDecorator.js
enyo.kind({
    name: "onyx.InputDecorator",
    kind: "enyo.ToolDecorator",
    tag: "label",
    classes: "onyx-input-decorator",
    published: {
        alwaysLooksFocused: !0
    },
    handlers: {
        onDisabledChange: "disabledChange",
        onfocus: "receiveFocus",
        onblur: "receiveBlur"
    },
    create: function() {
        this.inherited(arguments), this.updateFocus(!1);
    },
    alwaysLooksFocusedChanged: function() {
        this.updateFocus(this.focus);
    },
    updateFocus: function(t) {
        this.focused = t, this.addRemoveClass("onyx-focused", this.alwaysLooksFocused || this.focused);
    },
    receiveFocus: function() {
        this.updateFocus(!0);
    },
    receiveBlur: function() {
        this.updateFocus(!1);
    },
    disabledChange: function(t, e) {
        this.addRemoveClass("onyx-disabled", e.originator.disabled);
    }
});

// lib\onyx\source\Tooltip.js
enyo.kind({
    name: "onyx.Tooltip",
    kind: "onyx.Popup",
    classes: "onyx-tooltip below left-arrow",
    autoDismiss: !1,
    showDelay: 500,
    defaultLeft: -6,
    handlers: {
        onRequestShowTooltip: "requestShow",
        onRequestHideTooltip: "requestHide"
    },
    requestShow: function() {
        return this.showJob = setTimeout(this.bindSafely("show"), this.showDelay), !0;
    },
    cancelShow: function() {
        clearTimeout(this.showJob);
    },
    requestHide: function() {
        return this.cancelShow(), this.inherited(arguments);
    },
    showingChanged: function() {
        this.cancelShow(), this.adjustPosition(!0), this.inherited(arguments);
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            var t = this.node.getBoundingClientRect();
            t.top + t.height > window.innerHeight ? (this.addRemoveClass("below", !1), this.addRemoveClass("above", !0)) : (this.addRemoveClass("above", !1), 
            this.addRemoveClass("below", !0)), t.left + t.width > window.innerWidth && (this.applyPosition({
                "margin-left": -t.width,
                bottom: "auto"
            }), this.addRemoveClass("left-arrow", !1), this.addRemoveClass("right-arrow", !0));
        }
    },
    resizeHandler: function() {
        this.applyPosition({
            "margin-left": this.defaultLeft,
            bottom: "auto"
        }), this.addRemoveClass("left-arrow", !0), this.addRemoveClass("right-arrow", !1), 
        this.adjustPosition(!0), this.inherited(arguments);
    }
});

// lib\onyx\source\TooltipDecorator.js
enyo.kind({
    name: "onyx.TooltipDecorator",
    defaultKind: "onyx.Button",
    classes: "onyx-popup-decorator",
    handlers: {
        onenter: "enter",
        onleave: "leave"
    },
    enter: function() {
        this.requestShowTooltip();
    },
    leave: function() {
        this.requestHideTooltip();
    },
    tap: function() {
        this.requestHideTooltip();
    },
    requestShowTooltip: function() {
        this.waterfallDown("onRequestShowTooltip");
    },
    requestHideTooltip: function() {
        this.waterfallDown("onRequestHideTooltip");
    }
});

// lib\onyx\source\MenuDecorator.js
enyo.kind({
    name: "onyx.MenuDecorator",
    kind: "onyx.TooltipDecorator",
    defaultKind: "onyx.Button",
    classes: "onyx-popup-decorator enyo-unselectable",
    handlers: {
        onActivate: "activated",
        onHide: "menuHidden"
    },
    activated: function(t, e) {
        this.requestHideTooltip(), e.originator.active && (this.menuActive = !0, this.activator = e.originator, 
        this.activator.addClass("active"), this.requestShowMenu());
    },
    requestShowMenu: function() {
        this.waterfallDown("onRequestShowMenu", {
            activator: this.activator
        });
    },
    requestHideMenu: function() {
        this.waterfallDown("onRequestHideMenu");
    },
    menuHidden: function() {
        this.menuActive = !1, this.activator && (this.activator.setActive(!1), this.activator.removeClass("active"));
    },
    enter: function() {
        this.menuActive || this.inherited(arguments);
    },
    leave: function() {
        this.menuActive || this.inherited(arguments);
    }
});

// lib\onyx\source\Menu.js
enyo.kind({
    name: "onyx.Menu",
    kind: "onyx.Popup",
    modal: !0,
    defaultKind: "onyx.MenuItem",
    classes: "onyx-menu",
    published: {
        maxHeight: 200,
        scrolling: !0,
        scrollStrategyKind: "TouchScrollStrategy"
    },
    handlers: {
        onActivate: "itemActivated",
        onRequestShowMenu: "requestMenuShow",
        onRequestHideMenu: "requestHide"
    },
    childComponents: [ {
        name: "client",
        kind: "enyo.Scroller"
    } ],
    showOnTop: !1,
    scrollerName: "client",
    create: function() {
        this.inherited(arguments), this.maxHeightChanged();
    },
    initComponents: function() {
        this.scrolling && this.createComponents(this.childComponents, {
            isChrome: !0,
            strategyKind: this.scrollStrategyKind
        }), this.inherited(arguments);
    },
    getScroller: function() {
        return this.$[this.scrollerName];
    },
    maxHeightChanged: function() {
        this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
    },
    itemActivated: function(t, e) {
        return e.originator.setActive(!1), !0;
    },
    showingChanged: function() {
        this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), 
        this.adjustPosition(!0);
    },
    requestMenuShow: function(t, e) {
        if (this.floating) {
            var i = e.activator.hasNode();
            if (i) {
                var n = this.activatorOffset = this.getPageOffset(i);
                this.applyPosition({
                    top: n.top + (this.showOnTop ? 0 : n.height),
                    left: n.left,
                    width: n.width
                });
            }
        }
        return this.show(), !0;
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    getPageOffset: function(t) {
        var e = t.getBoundingClientRect(), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            this.scrolling && !this.showOnTop && this.getScroller().setMaxHeight(this.maxHeight + "px"), 
            this.removeClass("onyx-menu-up"), this.floating || this.applyPosition({
                left: "auto"
            });
            var t = this.node.getBoundingClientRect(), e = void 0 === t.height ? t.bottom - t.top : t.height, i = void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight, n = void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
            if (this.menuUp = t.top + e > i && i - t.bottom < t.top - e, this.addRemoveClass("onyx-menu-up", this.menuUp), 
            this.floating) {
                var o = this.activatorOffset;
                this.menuUp ? this.applyPosition({
                    top: o.top - e + (this.showOnTop ? o.height : 0),
                    bottom: "auto"
                }) : t.top < o.top && i > o.top + (this.showOnTop ? 0 : o.height) + e && this.applyPosition({
                    top: o.top + (this.showOnTop ? 0 : o.height),
                    bottom: "auto"
                });
            }
            if (t.right > n && (this.floating ? this.applyPosition({
                left: n - t.width
            }) : this.applyPosition({
                left: -(t.right - n)
            })), 0 > t.left && (this.floating ? this.applyPosition({
                left: 0,
                right: "auto"
            }) : "auto" == this.getComputedStyleValue("right") ? this.applyPosition({
                left: -t.left
            }) : this.applyPosition({
                right: t.left
            })), this.scrolling && !this.showOnTop) {
                t = this.node.getBoundingClientRect();
                var s;
                s = this.menuUp ? this.maxHeight < t.bottom ? this.maxHeight : t.bottom : i > t.top + this.maxHeight ? this.maxHeight : i - t.top, 
                this.getScroller().setMaxHeight(s + "px");
            }
        }
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    },
    requestHide: function() {
        this.setShowing(!1);
    }
});

// lib\onyx\source\MenuItem.js
enyo.kind({
    name: "onyx.MenuItem",
    kind: "enyo.Button",
    events: {
        onSelect: "",
        onItemContentChange: ""
    },
    classes: "onyx-menu-item",
    tag: "div",
    create: function() {
        this.silence(), this.inherited(arguments), this.unsilence(), this.active && this.bubble("onActivate");
    },
    tap: function() {
        this.inherited(arguments), this.bubble("onRequestHideMenu"), this.doSelect({
            selected: this,
            content: this.content
        });
    },
    contentChanged: function() {
        this.inherited(arguments), this.doItemContentChange({
            content: this.content
        });
    }
});

// lib\onyx\source\Submenu.js
enyo.kind({
    name: "onyx.Submenu",
    defaultKind: "onyx.MenuItem",
    initComponents: function() {
        this.createChrome([ {
            name: "label",
            kind: "enyo.Control",
            classes: "onyx-menu-item",
            content: this.content || this.name,
            isChrome: !0,
            ontap: "toggleOpen"
        }, {
            kind: "onyx.Drawer",
            name: "client",
            classes: "client onyx-submenu",
            isChrome: !0,
            open: !1
        } ]), this.inherited(arguments);
    },
    toggleOpen: function() {
        this.setOpen(!this.getOpen());
    },
    setOpen: function(t) {
        this.$.client.setOpen(t);
    },
    getOpen: function() {
        return this.$.client.getOpen();
    }
});

// lib\onyx\source\PickerDecorator.js
enyo.kind({
    name: "onyx.PickerDecorator",
    kind: "onyx.MenuDecorator",
    classes: "onyx-picker-decorator",
    defaultKind: "onyx.PickerButton",
    handlers: {
        onChange: "change"
    },
    change: function(t, e) {
        this.waterfallDown("onChange", e);
    }
});

// lib\onyx\source\PickerButton.js
enyo.kind({
    name: "onyx.PickerButton",
    kind: "onyx.Button",
    handlers: {
        onChange: "change"
    },
    change: function(t, e) {
        void 0 !== e.content && this.setContent(e.content);
    }
});

// lib\onyx\source\Picker.js
enyo.kind({
    name: "onyx.Picker",
    kind: "onyx.Menu",
    classes: "onyx-picker enyo-unselectable",
    published: {
        selected: null
    },
    events: {
        onChange: ""
    },
    handlers: {
        onItemContentChange: "itemContentChange"
    },
    floating: !0,
    showOnTop: !0,
    initComponents: function() {
        this.setScrolling(!0), this.inherited(arguments);
    },
    showingChanged: function() {
        this.getScroller().setShowing(this.showing), this.inherited(arguments), this.showing && this.selected && this.scrollToSelected();
    },
    scrollToSelected: function() {
        this.getScroller().scrollToControl(this.selected, !this.menuUp);
    },
    itemActivated: function(t, e) {
        return this.processActivatedItem(e.originator), this.inherited(arguments);
    },
    processActivatedItem: function(t) {
        t.active && this.setSelected(t);
    },
    selectedChanged: function(t) {
        t && t.removeClass("selected"), this.selected && (this.selected.addClass("selected"), 
        this.doChange({
            selected: this.selected,
            content: this.selected.content
        }));
    },
    itemContentChange: function(t, e) {
        e.originator == this.selected && this.doChange({
            selected: this.selected,
            content: this.selected.content
        });
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    }
});

// lib\onyx\source\FlyweightPicker.js
enyo.kind({
    name: "onyx.FlyweightPicker",
    kind: "onyx.Picker",
    classes: "onyx-flyweight-picker",
    published: {
        count: 0
    },
    events: {
        onSetupItem: "",
        onSelect: ""
    },
    handlers: {
        onSelect: "itemSelect"
    },
    components: [ {
        name: "scroller",
        kind: "enyo.Scroller",
        strategyKind: "TouchScrollStrategy",
        components: [ {
            name: "flyweight",
            kind: "FlyweightRepeater",
            noSelect: !0,
            ontap: "itemTap"
        } ]
    } ],
    scrollerName: "scroller",
    initComponents: function() {
        this.controlParentName = "flyweight", this.inherited(arguments), this.$.flyweight.$.client.children[0].setActive(!0);
    },
    create: function() {
        this.inherited(arguments), this.countChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.selectedChanged();
    },
    scrollToSelected: function() {
        var t = this.$.flyweight.fetchRowNode(this.selected);
        this.getScroller().scrollToNode(t, !this.menuUp);
    },
    countChanged: function() {
        this.$.flyweight.count = this.count;
    },
    processActivatedItem: function(t) {
        this.item = t;
    },
    selectedChanged: function(t) {
        if (this.item) {
            null != t && (this.item.removeClass("selected"), this.$.flyweight.renderRow(t));
            var e;
            null != this.selected && (this.item.addClass("selected"), this.$.flyweight.renderRow(this.selected), 
            this.item.removeClass("selected"), e = this.$.flyweight.fetchRowNode(this.selected)), 
            this.doChange({
                selected: this.selected,
                content: e && e.textContent || this.item.content
            });
        }
    },
    itemTap: function(t, e) {
        this.setSelected(e.rowIndex), this.doSelect({
            selected: this.item,
            content: this.item.content
        });
    },
    itemSelect: function(t, e) {
        return e.originator != this ? !0 : void 0;
    }
});

// lib\onyx\source\DatePicker.js
enyo.kind({
    name: "onyx.DatePicker",
    classes: "onyx-toolbar-inline",
    published: {
        disabled: !1,
        locale: "en-US",
        dayHidden: !1,
        monthHidden: !1,
        yearHidden: !1,
        minYear: 1900,
        maxYear: 2099,
        value: null
    },
    events: {
        onSelect: ""
    },
    create: function() {
        this.inherited(arguments), ilib && (this.locale = ilib.getLocale()), this.initDefaults();
    },
    initDefaults: function() {
        var t;
        ilib ? (t = [], this._tf = new ilib.DateFmt({
            locale: this.locale,
            timezone: "local"
        }), t = this._tf.getMonthsOfYear({
            length: "long"
        })) : (t = [ void 0, "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" ], 
        this.localeInfo.getMonthsOfYear = function() {
            return t;
        }), this.setupPickers(this._tf ? this._tf.getTemplate() : "mdy"), this.dayHiddenChanged(), 
        this.monthHiddenChanged(), this.yearHiddenChanged();
        for (var e, i = this.value = this.value || new Date(), n = 0; e = t[n + 1]; n++) this.$.monthPicker.createComponent({
            content: e,
            value: n,
            active: n == i.getMonth()
        });
        var o = i.getFullYear();
        for (this.$.yearPicker.setSelected(o - this.minYear), n = 1; this.monthLength(i.getYear(), i.getMonth()) >= n; n++) this.$.dayPicker.createComponent({
            content: n,
            value: n,
            active: n == i.getDate()
        });
    },
    monthLength: function(t, e) {
        return 32 - new Date(t, e, 32).getDate();
    },
    setupYear: function(t, e) {
        return this.$.year.setContent(this.minYear + e.index), !0;
    },
    setupPickers: function(t) {
        var e, i, n, o = t.split(""), s = !1, r = !1, a = !1;
        for (i = 0, n = o.length; n > i; i++) switch (e = o[i], e.toLowerCase()) {
          case "d":
            a || (this.createDay(), a = !0);
            break;

          case "m":
            r || (this.createMonth(), r = !0);
            break;

          case "y":
            s || (this.createYear(), s = !0);
            break;

          default:        }
    },
    createYear: function() {
        var t = this.maxYear - this.minYear;
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateYear",
            components: [ {
                classes: "onyx-datepicker-year",
                name: "yearPickerButton",
                disabled: this.disabled
            }, {
                name: "yearPicker",
                kind: "onyx.FlyweightPicker",
                count: ++t,
                onSetupItem: "setupYear",
                components: [ {
                    name: "year"
                } ]
            } ]
        });
    },
    createMonth: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateMonth",
            components: [ {
                classes: "onyx-datepicker-month",
                name: "monthPickerButton",
                disabled: this.disabled
            }, {
                name: "monthPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createDay: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateDay",
            components: [ {
                classes: "onyx-datepicker-day",
                name: "dayPickerButton",
                disabled: this.disabled
            }, {
                name: "dayPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    localeChanged: function() {
        this.refresh();
    },
    dayHiddenChanged: function() {
        this.$.dayPicker.getParent().setShowing(this.dayHidden ? !1 : !0);
    },
    monthHiddenChanged: function() {
        this.$.monthPicker.getParent().setShowing(this.monthHidden ? !1 : !0);
    },
    yearHiddenChanged: function() {
        this.$.yearPicker.getParent().setShowing(this.yearHidden ? !1 : !0);
    },
    minYearChanged: function() {
        this.refresh();
    },
    maxYearChanged: function() {
        this.refresh();
    },
    valueChanged: function() {
        this.refresh();
    },
    disabledChanged: function() {
        this.$.yearPickerButton.setDisabled(this.disabled), this.$.monthPickerButton.setDisabled(this.disabled), 
        this.$.dayPickerButton.setDisabled(this.disabled);
    },
    updateDay: function(t, e) {
        var i = this.calcDate(this.value.getFullYear(), this.value.getMonth(), e.selected.value);
        return this.doSelect({
            name: this.name,
            value: i
        }), this.setValue(i), !0;
    },
    updateMonth: function(t, e) {
        var i = this.calcDate(this.value.getFullYear(), e.selected.value, this.value.getDate());
        return this.doSelect({
            name: this.name,
            value: i
        }), this.setValue(i), !0;
    },
    updateYear: function(t, e) {
        if (-1 != e.originator.selected) {
            var i = this.calcDate(this.minYear + e.originator.selected, this.value.getMonth(), this.value.getDate());
            this.doSelect({
                name: this.name,
                value: i
            }), this.setValue(i);
        }
        return !0;
    },
    calcDate: function(t, e, i) {
        return new Date(t, e, i, this.value.getHours(), this.value.getMinutes(), this.value.getSeconds(), this.value.getMilliseconds());
    },
    refresh: function() {
        this.destroyClientControls(), this.initDefaults(), this.render();
    }
});

// lib\onyx\source\TimePicker.js
enyo.kind({
    name: "onyx.TimePicker",
    classes: "onyx-toolbar-inline",
    published: {
        disabled: !1,
        locale: "en-US",
        is24HrMode: null,
        value: null
    },
    events: {
        onSelect: ""
    },
    create: function() {
        this.inherited(arguments), ilib && (this.locale = ilib.getLocale()), this.initDefaults();
    },
    initDefaults: function() {
        if (this._strAm = "AM", this._strPm = "PM", ilib) {
            this._tf = new ilib.DateFmt({
                locale: this.locale
            });
            var t = new ilib.DateFmt({
                locale: this.locale,
                type: "time",
                template: "a"
            }), e = ilib.Date.newInstance({
                locale: this.locale,
                hour: 1
            });
            this._strAm = t.format(e), e.hour = 13, this._strPm = t.format(e), null == this.is24HrMode && (this.is24HrMode = "24" == this._tf.getClock());
        } else null == this.is24HrMode && (this.is24HrMode = !1);
        this.setupPickers(this._tf ? this._tf.getTimeComponents() : "hma");
        var i, n = this.value = this.value || new Date();
        if (this.is24HrMode) for (i = 0; 24 > i; i++) this.$.hourPicker.createComponent({
            content: i,
            value: i,
            active: i == n.getHours()
        }); else {
            var o = n.getHours();
            for (o = 0 === o ? 12 : o, i = 1; 12 >= i; i++) this.$.hourPicker.createComponent({
                content: i,
                value: i,
                active: i == (o > 12 ? o % 12 : o)
            });
        }
        for (i = 0; 59 >= i; i++) this.$.minutePicker.createComponent({
            content: 10 > i ? "0" + i : i,
            value: i,
            active: i == n.getMinutes()
        });
        n.getHours() >= 12 ? this.$.ampmPicker.createComponents([ {
            content: this._strAm
        }, {
            content: this._strPm,
            active: !0
        } ]) : this.$.ampmPicker.createComponents([ {
            content: this._strAm,
            active: !0
        }, {
            content: this._strPm
        } ]), this.$.ampmPicker.getParent().setShowing(!this.is24HrMode);
    },
    setupPickers: function(t) {
        -1 !== t.indexOf("h") && this.createHour(), -1 !== t.indexOf("m") && this.createMinute(), 
        -1 !== t.indexOf("a") && this.createAmPm();
    },
    createHour: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateHour",
            components: [ {
                classes: "onyx-timepicker-hour",
                name: "hourPickerButton",
                disabled: this.disabled
            }, {
                name: "hourPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createMinute: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateMinute",
            components: [ {
                classes: "onyx-timepicker-minute",
                name: "minutePickerButton",
                disabled: this.disabled
            }, {
                name: "minutePicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    createAmPm: function() {
        this.createComponent({
            kind: "onyx.PickerDecorator",
            onSelect: "updateAmPm",
            components: [ {
                classes: "onyx-timepicker-ampm",
                name: "ampmPickerButton",
                disabled: this.disabled
            }, {
                name: "ampmPicker",
                kind: "onyx.Picker"
            } ]
        });
    },
    disabledChanged: function() {
        this.$.hourPickerButton.setDisabled(this.disabled), this.$.minutePickerButton.setDisabled(this.disabled), 
        this.$.ampmPickerButton.setDisabled(this.disabled);
    },
    localeChanged: function() {
        this.is24HrMode = null, this.refresh();
    },
    is24HrModeChanged: function() {
        this.refresh();
    },
    valueChanged: function() {
        this.refresh();
    },
    updateHour: function(t, e) {
        var i = e.selected.value;
        if (!this.is24HrMode) {
            var n = this.$.ampmPicker.getParent().controlAtIndex(0).content;
            i = i + (12 == i ? -12 : 0) + (this.isAm(n) ? 0 : 12);
        }
        return this.setValue(this.calcTime(i, this.value.getMinutes())), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    updateMinute: function(t, e) {
        return this.setValue(this.calcTime(this.value.getHours(), e.selected.value)), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    updateAmPm: function(t, e) {
        var i = this.value.getHours();
        return this.is24HrMode || (i += i > 11 ? this.isAm(e.content) ? -12 : 0 : this.isAm(e.content) ? 0 : 12), 
        this.setValue(this.calcTime(i, this.value.getMinutes())), this.doSelect({
            name: this.name,
            value: this.value
        }), !0;
    },
    calcTime: function(t, e) {
        return new Date(this.value.getFullYear(), this.value.getMonth(), this.value.getDate(), t, e, this.value.getSeconds(), this.value.getMilliseconds());
    },
    isAm: function(t) {
        return t == this._strAm ? !0 : !1;
    },
    refresh: function() {
        this.destroyClientControls(), this.initDefaults(), this.render();
    }
});

// lib\onyx\source\RadioButton.js
enyo.kind({
    name: "onyx.RadioButton",
    kind: "enyo.Button",
    classes: "onyx-radiobutton"
});

// lib\onyx\source\RadioGroup.js
enyo.kind({
    name: "onyx.RadioGroup",
    kind: "enyo.Group",
    defaultKind: "onyx.RadioButton",
    highlander: !0
});

// lib\onyx\source\ToggleButton.js
enyo.kind({
    name: "onyx.ToggleButton",
    classes: "onyx-toggle-button",
    published: {
        active: !1,
        value: !1,
        onContent: "On",
        offContent: "Off",
        disabled: !1
    },
    events: {
        onChange: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    components: [ {
        name: "contentOn",
        classes: "onyx-toggle-content on"
    }, {
        name: "contentOff",
        classes: "onyx-toggle-content off"
    }, {
        classes: "onyx-toggle-button-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.value = Boolean(this.value || this.active), this.onContentChanged(), 
        this.offContentChanged(), this.disabledChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.updateVisualState();
    },
    updateVisualState: function() {
        this.addRemoveClass("off", !this.value), this.$.contentOn.setShowing(this.value), 
        this.$.contentOff.setShowing(!this.value), this.setActive(this.value);
    },
    valueChanged: function() {
        this.updateVisualState(), this.doChange({
            value: this.value
        });
    },
    activeChanged: function() {
        this.setValue(this.active), this.bubble("onActivate");
    },
    onContentChanged: function() {
        this.$.contentOn.setContent(this.onContent || ""), this.$.contentOn.addRemoveClass("empty", !this.onContent);
    },
    offContentChanged: function() {
        this.$.contentOff.setContent(this.offContent || ""), this.$.contentOff.addRemoveClass("empty", !this.onContent);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    updateValue: function(t) {
        this.disabled || this.setValue(t);
    },
    tap: function() {
        this.updateValue(!this.value);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, this.dragged = !1, 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = e.dx;
            return Math.abs(i) > 10 && (this.updateValue(i > 0), this.dragged = !0), !0;
        }
    },
    dragfinish: function(t, e) {
        this.dragging = !1, this.dragged && e.preventTap();
    }
});

// lib\onyx\source\ToggleIconButton.js
enyo.kind({
    name: "onyx.ToggleIconButton",
    kind: "onyx.Icon",
    published: {
        active: !1,
        value: !1
    },
    events: {
        onChange: ""
    },
    classes: "onyx-icon-button onyx-icon-toggle",
    activeChanged: function() {
        this.addRemoveClass("active", this.value), this.bubble("onActivate");
    },
    updateValue: function(t) {
        this.disabled || (this.setValue(t), this.doChange({
            value: this.value
        }));
    },
    tap: function() {
        this.updateValue(!this.value);
    },
    valueChanged: function() {
        this.setActive(this.value);
    },
    create: function() {
        this.inherited(arguments), this.value = Boolean(this.value || this.active);
    },
    rendered: function() {
        this.inherited(arguments), this.valueChanged(), this.removeClass("onyx-icon");
    }
});

// lib\onyx\source\Toolbar.js
enyo.kind({
    name: "onyx.Toolbar",
    classes: "onyx onyx-toolbar onyx-toolbar-inline",
    create: function() {
        this.inherited(arguments), this.hasClass("onyx-menu-toolbar") && enyo.platform.android >= 4 && this.applyStyle("position", "static");
    }
});

// lib\onyx\source\ProgressBar.js
enyo.kind({
    name: "onyx.ProgressBar",
    classes: "onyx-progress-bar",
    published: {
        progress: 0,
        min: 0,
        max: 100,
        barClasses: "",
        showStripes: !0,
        animateStripes: !0,
        increment: 0
    },
    events: {
        onAnimateProgressFinish: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "enyo.Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bar",
        classes: "onyx-progress-bar-bar"
    } ],
    create: function() {
        this.inherited(arguments), this.progressChanged(), this.barClassesChanged(), this.showStripesChanged(), 
        this.animateStripesChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    showStripesChanged: function() {
        this.$.bar.addRemoveClass("striped", this.showStripes);
    },
    animateStripesChanged: function() {
        this.$.bar.addRemoveClass("animated", this.animateStripes);
    },
    progressChanged: function() {
        this.progress = this.clampValue(this.min, this.max, this.progress);
        var t = this.calcPercent(this.progress);
        this.updateBarPosition(t);
    },
    calcIncrement: function(t) {
        return Math.round(t / this.increment) * this.increment;
    },
    clampValue: function(t, e, i) {
        return Math.max(t, Math.min(i, e));
    },
    calcRatio: function(t) {
        return (t - this.min) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return 100 * this.calcRatio(t);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t + "%");
    },
    animateProgressTo: function(t) {
        this.$.progressAnimator.play({
            startValue: this.progress,
            endValue: t,
            node: this.hasNode()
        });
    },
    progressAnimatorStep: function(t) {
        return this.setProgress(t.value), !0;
    },
    progressAnimatorComplete: function(t) {
        return this.doAnimateProgressFinish(t), !0;
    }
});

// lib\onyx\source\ProgressButton.js
enyo.kind({
    name: "onyx.ProgressButton",
    kind: "onyx.ProgressBar",
    classes: "onyx-progress-button",
    events: {
        onCancel: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "enyo.Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bar",
        classes: "onyx-progress-bar-bar onyx-progress-button-bar"
    }, {
        name: "client",
        classes: "onyx-progress-button-client"
    }, {
        kind: "onyx.Icon",
        src: "$lib/onyx/images/progress-button-cancel.png",
        classes: "onyx-progress-button-icon",
        ontap: "cancelTap"
    } ],
    cancelTap: function() {
        this.doCancel();
    }
});

// lib\onyx\source\Scrim.js
enyo.kind({
    name: "onyx.Scrim",
    showing: !1,
    classes: "onyx-scrim enyo-fit",
    floating: !1,
    create: function() {
        this.inherited(arguments), this.zStack = [], this.floating && this.setParent(enyo.floatingLayer);
    },
    showingChanged: function() {
        this.floating && this.showing && !this.hasNode() && this.render(), this.inherited(arguments);
    },
    addZIndex: function(t) {
        0 > enyo.indexOf(t, this.zStack) && this.zStack.push(t);
    },
    removeZIndex: function(t) {
        enyo.remove(t, this.zStack);
    },
    showAtZIndex: function(t) {
        this.addZIndex(t), void 0 !== t && this.setZIndex(t), this.show();
    },
    hideAtZIndex: function(t) {
        if (this.removeZIndex(t), this.zStack.length) {
            var e = this.zStack[this.zStack.length - 1];
            this.setZIndex(e);
        } else this.hide();
    },
    setZIndex: function(t) {
        this.zIndex = t, this.applyStyle("z-index", t);
    },
    make: function() {
        return this;
    }
}), enyo.kind({
    name: "onyx.scrimSingleton",
    kind: null,
    constructor: function(t, e) {
        this.instanceName = t, enyo.setPath(this.instanceName, this), this.props = e || {};
    },
    make: function() {
        var t = new onyx.Scrim(this.props);
        return enyo.setPath(this.instanceName, t), t;
    },
    showAtZIndex: function(t) {
        var e = this.make();
        e.showAtZIndex(t);
    },
    hideAtZIndex: enyo.nop,
    show: function() {
        var t = this.make();
        t.show();
    }
}), new onyx.scrimSingleton("onyx.scrim", {
    floating: !0,
    classes: "onyx-scrim-translucent"
}), new onyx.scrimSingleton("onyx.scrimTransparent", {
    floating: !0,
    classes: "onyx-scrim-transparent"
});

// lib\onyx\source\Slider.js
enyo.kind({
    name: "onyx.Slider",
    kind: "onyx.ProgressBar",
    classes: "onyx-slider",
    published: {
        value: 0,
        lockBar: !0,
        tappable: !0
    },
    events: {
        onChange: "",
        onChanging: "",
        onAnimateFinish: ""
    },
    showStripes: !1,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    moreComponents: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    }, {
        classes: "onyx-slider-taparea"
    }, {
        name: "knob",
        classes: "onyx-slider-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.moreComponents[2].ondown = "knobDown", this.moreComponents[2].onup = "knobUp", 
        this.createComponents(this.moreComponents), this.valueChanged();
    },
    valueChanged: function() {
        this.value = this.clampValue(this.min, this.max, this.value);
        var t = this.calcPercent(this.value);
        this.updateKnobPosition(t), this.lockBar && this.setProgress(this.value);
    },
    updateKnobPosition: function(t) {
        this.$.knob.applyStyle("left", t + "%");
    },
    calcKnobPosition: function(t) {
        var e = t.clientX - this.hasNode().getBoundingClientRect().left;
        return e / this.getBounds().width * (this.max - this.min) + this.min;
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, t.addClass("pressed"), 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = this.calcKnobPosition(e);
            return i = this.increment ? this.calcIncrement(i) : i, this.setValue(i), this.doChanging({
                value: this.value
            }), !0;
        }
    },
    dragfinish: function(t, e) {
        return this.dragging = !1, e.preventTap(), this.doChange({
            value: this.value
        }), t.removeClass("pressed"), !0;
    },
    tap: function(t, e) {
        if (this.tappable) {
            var i = this.calcKnobPosition(e);
            return i = this.increment ? this.calcIncrement(i) : i, this.tapped = !0, this.animateTo(i), 
            !0;
        }
    },
    knobDown: function() {
        this.$.knob.addClass("pressed");
    },
    knobUp: function() {
        this.$.knob.removeClass("pressed");
    },
    animateTo: function(t) {
        this.$.animator.play({
            startValue: this.value,
            endValue: t,
            node: this.hasNode()
        });
    },
    animatorStep: function(t) {
        return this.setValue(t.value), !0;
    },
    animatorComplete: function(t) {
        return this.tapped && (this.tapped = !1, this.doChange({
            value: this.value
        })), this.doAnimateFinish(t), !0;
    }
});

// lib\onyx\source\RangeSlider.js
enyo.kind({
    name: "onyx.RangeSlider",
    kind: "onyx.ProgressBar",
    classes: "onyx-slider",
    published: {
        rangeMin: 0,
        rangeMax: 100,
        rangeStart: 0,
        rangeEnd: 100,
        beginValue: 0,
        endValue: 0
    },
    events: {
        onChange: "",
        onChanging: ""
    },
    showStripes: !1,
    showLabels: !1,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        ondown: "down"
    },
    moreComponents: [ {
        name: "startKnob",
        classes: "onyx-slider-knob"
    }, {
        name: "endKnob",
        classes: "onyx-slider-knob onyx-range-slider-knob"
    } ],
    create: function() {
        this.inherited(arguments), this.createComponents(this.moreComponents), this.initControls();
    },
    rendered: function() {
        this.inherited(arguments);
        var t = this.calcPercent(this.beginValue);
        this.updateBarPosition(t);
    },
    initControls: function() {
        this.$.bar.applyStyle("position", "relative"), this.refreshRangeSlider(), this.showLabels && (this.$.startKnob.createComponent({
            name: "startLabel",
            kind: "onyx.RangeSliderKnobLabel"
        }), this.$.endKnob.createComponent({
            name: "endLabel",
            kind: "onyx.RangeSliderKnobLabel"
        })), this.$.startKnob.ondown = "knobDown", this.$.startKnob.onup = "knobUp", this.$.endKnob.ondown = "knobDown", 
        this.$.endKnob.onup = "knobUp";
    },
    refreshRangeSlider: function() {
        this.beginValue = this.calcKnobPercent(this.rangeStart), this.endValue = this.calcKnobPercent(this.rangeEnd), 
        this.beginValueChanged(), this.endValueChanged();
    },
    calcKnobRatio: function(t) {
        return (t - this.rangeMin) / (this.rangeMax - this.rangeMin);
    },
    calcKnobPercent: function(t) {
        return 100 * this.calcKnobRatio(t);
    },
    beginValueChanged: function(t) {
        if (void 0 === t) {
            var e = this.calcPercent(this.beginValue);
            this.updateKnobPosition(e, this.$.startKnob);
        }
    },
    endValueChanged: function(t) {
        if (void 0 === t) {
            var e = this.calcPercent(this.endValue);
            this.updateKnobPosition(e, this.$.endKnob);
        }
    },
    calcKnobPosition: function(t) {
        var e = t.clientX - this.hasNode().getBoundingClientRect().left;
        return e / this.getBounds().width * (this.max - this.min) + this.min;
    },
    updateKnobPosition: function(t, e) {
        e.applyStyle("left", t + "%"), this.updateBarPosition();
    },
    updateBarPosition: function() {
        if (void 0 !== this.$.startKnob && void 0 !== this.$.endKnob) {
            var t = this.calcKnobPercent(this.rangeStart), e = this.calcKnobPercent(this.rangeEnd) - t;
            this.$.bar.applyStyle("left", t + "%"), this.$.bar.applyStyle("width", e + "%");
        }
    },
    calcRangeRatio: function(t) {
        return t / 100 * (this.rangeMax - this.rangeMin) + this.rangeMin - this.increment / 2;
    },
    swapZIndex: function(t) {
        "startKnob" === t ? (this.$.startKnob.applyStyle("z-index", 1), this.$.endKnob.applyStyle("z-index", 0)) : "endKnob" === t && (this.$.startKnob.applyStyle("z-index", 0), 
        this.$.endKnob.applyStyle("z-index", 1));
    },
    down: function(t) {
        this.swapZIndex(t.name);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, t.addClass("pressed"), 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i, n, o, s = this.calcKnobPosition(e);
            if ("startKnob" === t.name && s >= 0) {
                if (!(this.endValue >= s && -1 === e.xDirection || this.endValue >= s)) return this.drag(this.$.endKnob, e);
                this.setBeginValue(s), i = this.calcRangeRatio(this.beginValue), n = this.increment ? this.calcIncrement(i + .5 * this.increment) : i, 
                o = this.calcKnobPercent(n), this.updateKnobPosition(o, this.$.startKnob), this.setRangeStart(n), 
                this.doChanging({
                    value: n
                });
            } else if ("endKnob" === t.name && 100 >= s) {
                if (!(s >= this.beginValue && 1 === e.xDirection || s >= this.beginValue)) return this.drag(this.$.startKnob, e);
                this.setEndValue(s), i = this.calcRangeRatio(this.endValue), n = this.increment ? this.calcIncrement(i + .5 * this.increment) : i, 
                o = this.calcKnobPercent(n), this.updateKnobPosition(o, this.$.endKnob), this.setRangeEnd(n), 
                this.doChanging({
                    value: n
                });
            }
            return !0;
        }
    },
    dragfinish: function(t, e) {
        this.dragging = !1, e.preventTap();
        var i;
        return "startKnob" === t.name ? (i = this.calcRangeRatio(this.beginValue), this.doChange({
            value: i,
            startChanged: !0
        })) : "endKnob" === t.name && (i = this.calcRangeRatio(this.endValue), this.doChange({
            value: i,
            startChanged: !1
        })), t.removeClass("pressed"), !0;
    },
    knobDown: function(t) {
        t.addClass("pressed");
    },
    knobUp: function(t) {
        t.removeClass("pressed");
    },
    rangeMinChanged: function() {
        this.refreshRangeSlider();
    },
    rangeMaxChanged: function() {
        this.refreshRangeSlider();
    },
    rangeStartChanged: function() {
        this.refreshRangeSlider();
    },
    rangeEndChanged: function() {
        this.refreshRangeSlider();
    },
    setStartLabel: function(t) {
        this.$.startKnob.waterfallDown("onSetLabel", t);
    },
    setEndLabel: function(t) {
        this.$.endKnob.waterfallDown("onSetLabel", t);
    }
}), enyo.kind({
    name: "onyx.RangeSliderKnobLabel",
    classes: "onyx-range-slider-label",
    handlers: {
        onSetLabel: "setLabel"
    },
    setLabel: function(t, e) {
        this.setContent(e);
    }
});

// lib\onyx\source\Item.js
enyo.kind({
    name: "onyx.Item",
    classes: "onyx-item",
    tapHighlight: !0,
    handlers: {
        onhold: "hold",
        onrelease: "release"
    },
    hold: function(t, e) {
        this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !0, e);
    },
    release: function(t, e) {
        this.tapHighlight && onyx.Item.addRemoveFlyweightClass(this.controlParent || this, "onyx-highlight", !1, e);
    },
    statics: {
        addRemoveFlyweightClass: function(t, e, i, n, o) {
            var s = n.flyweight;
            if (s) {
                var a = void 0 !== o ? o : n.index;
                s.performOnRow(a, function() {
                    t.addRemoveClass(e, i);
                });
            }
        }
    }
});

// lib\onyx\source\Spinner.js
enyo.kind({
    name: "onyx.Spinner",
    classes: "onyx-spinner",
    stop: function() {
        this.setShowing(!1);
    },
    start: function() {
        this.setShowing(!0);
    },
    toggle: function() {
        this.setShowing(!this.getShowing());
    }
});

// lib\onyx\source\MoreToolbar.js
enyo.kind({
    name: "onyx.MoreToolbar",
    classes: "onyx-toolbar onyx-more-toolbar",
    menuClass: "",
    movedClass: "",
    layoutKind: "FittableColumnsLayout",
    noStretch: !0,
    handlers: {
        onHide: "reflow"
    },
    published: {
        clientLayoutKind: "FittableColumnsLayout"
    },
    tools: [ {
        name: "client",
        noStretch: !0,
        fit: !0,
        classes: "onyx-toolbar-inline"
    }, {
        name: "nard",
        kind: "onyx.MenuDecorator",
        showing: !1,
        onActivate: "activated",
        components: [ {
            kind: "onyx.IconButton",
            classes: "onyx-more-button"
        }, {
            name: "menu",
            kind: "onyx.Menu",
            scrolling: !1,
            classes: "onyx-more-menu"
        } ]
    } ],
    initComponents: function() {
        this.menuClass && this.menuClass.length > 0 && !this.$.menu.hasClass(this.menuClass) && this.$.menu.addClass(this.menuClass), 
        this.createChrome(this.tools), this.inherited(arguments), this.$.client.setLayoutKind(this.clientLayoutKind);
    },
    clientLayoutKindChanged: function() {
        this.$.client.setLayoutKind(this.clientLayoutKind);
    },
    reflow: function() {
        this.inherited(arguments), this.isContentOverflowing() ? (this.$.nard.show(), this.popItem() && this.reflow()) : this.tryPushItem() ? this.reflow() : this.$.menu.children.length || (this.$.nard.hide(), 
        this.$.menu.hide());
    },
    activated: function(t, e) {
        this.addRemoveClass("active", e.originator.active);
    },
    popItem: function() {
        var t = this.findCollapsibleItem();
        if (t) {
            this.movedClass && this.movedClass.length > 0 && !t.hasClass(this.movedClass) && t.addClass(this.movedClass), 
            this.$.menu.addChild(t, null);
            var e = this.$.menu.hasNode();
            return e && t.hasNode() && t.insertNodeInParent(e), !0;
        }
    },
    pushItem: function() {
        var t = this.$.menu.children, e = t[0];
        if (e) {
            this.movedClass && this.movedClass.length > 0 && e.hasClass(this.movedClass) && e.removeClass(this.movedClass), 
            this.$.client.addChild(e);
            var i = this.$.client.hasNode();
            if (i && e.hasNode()) {
                for (var n, o, s = 0; this.$.client.children.length > s; s++) {
                    var a = this.$.client.children[s];
                    if (void 0 !== a.toolbarIndex && a.toolbarIndex != s) {
                        n = a, o = s;
                        break;
                    }
                }
                if (n && n.hasNode()) {
                    e.insertNodeInParent(i, n.node);
                    var r = this.$.client.children.pop();
                    this.$.client.children.splice(o, 0, r);
                } else e.appendNodeToParent(i);
            }
            return !0;
        }
    },
    tryPushItem: function() {
        if (this.pushItem()) {
            if (!this.isContentOverflowing()) return !0;
            this.popItem();
        }
    },
    isContentOverflowing: function() {
        if (this.$.client.hasNode()) {
            var t = this.$.client.children, e = t.length && t[t.length - 1].hasNode();
            if (e) return this.$.client.reflow(), e.offsetLeft + e.offsetWidth > this.$.client.node.clientWidth;
        }
    },
    findCollapsibleItem: function() {
        for (var t, e = this.$.client.children, i = e.length - 1; t = e[i]; i--) {
            if (!t.unmoveable) return t;
            void 0 === t.toolbarIndex && (t.toolbarIndex = i);
        }
    }
});

// lib\onyx\source\IntegerPicker.js
enyo.kind({
    name: "onyx.IntegerPicker",
    kind: "onyx.Picker",
    published: {
        value: 0,
        min: 0,
        max: 9
    },
    create: function() {
        this.inherited(arguments), this.rangeChanged();
    },
    minChanged: function() {
        this.destroyClientControls(), this.rangeChanged(), this.render();
    },
    maxChanged: function() {
        this.destroyClientControls(), this.rangeChanged(), this.render();
    },
    rangeChanged: function() {
        for (var t = this.min; this.max >= t; t++) this.createComponent({
            content: t,
            active: t === this.value ? !0 : !1
        });
    },
    valueChanged: function() {
        var t = this.getClientControls(), e = t.length;
        this.value = Math.min(this.max, Math.max(this.value, this.min));
        for (var i = 0; e > i; i++) if (this.value === parseInt(t[i].content, 10)) {
            this.setSelected(t[i]);
            break;
        }
    },
    selectedChanged: function(t) {
        t && t.removeClass("selected"), this.selected && (this.selected.addClass("selected"), 
        this.doChange({
            selected: this.selected,
            content: this.selected.content
        })), this.setValue(parseInt(this.selected.content, 10));
    }
});

// lib\onyx\source\ContextualPopup.js
enyo.kind({
    name: "onyx.ContextualPopup",
    kind: "enyo.Popup",
    modal: !0,
    autoDismiss: !0,
    floating: !1,
    classes: "onyx-contextual-popup enyo-unselectable",
    published: {
        maxHeight: 100,
        scrolling: !0,
        title: void 0,
        actionButtons: []
    },
    statics: {
        subclass: function(t, e) {
            var i = t.prototype;
            e.actionButtons && (i.kindActionButtons = e.actionButtons, delete i.actionButtons);
        }
    },
    vertFlushMargin: 60,
    horizFlushMargin: 50,
    widePopup: 200,
    longPopup: 200,
    horizBuffer: 16,
    events: {
        onTap: ""
    },
    handlers: {
        onActivate: "childControlActivated",
        onRequestShowMenu: "requestShow",
        onRequestHideMenu: "requestHide"
    },
    components: [ {
        name: "title",
        classes: "onyx-contextual-popup-title"
    }, {
        classes: "onyx-contextual-popup-scroller",
        components: [ {
            name: "client",
            kind: "enyo.Scroller",
            vertical: "auto",
            classes: "enyo-unselectable",
            thumb: !1,
            strategyKind: "TouchScrollStrategy"
        } ]
    }, {
        name: "actionButtons",
        classes: "onyx-contextual-popup-action-buttons"
    } ],
    scrollerName: "client",
    create: function() {
        this.inherited(arguments), this.maxHeightChanged(), this.titleChanged(), this.actionButtonsChanged();
    },
    getScroller: function() {
        return this.$[this.scrollerName];
    },
    titleChanged: function() {
        this.$.title.setContent(this.title);
    },
    actionButtonsChanged: function() {
        this.actionButtons ? enyo.forEach(this.actionButtons, function(t) {
            t.kind = "onyx.Button", t.classes = t.classes + " onyx-contextual-popup-action-button", 
            t.popup = this, t.actionButton = !0, this.$.actionButtons.createComponent(t, {
                owner: this.getInstanceOwner()
            });
        }, this) : this.kindActionButtons && enyo.forEach(this.kindActionButtons, function(t) {
            t.kind = "onyx.Button", t.classes = t.classes + " onyx-contextual-popup-action-button", 
            t.popup = this, t.actionButton = !0, this.$.actionButtons.createComponent(t, {
                owner: this
            });
        }, this), this.hasNode() && this.$.actionButtons.render();
    },
    maxHeightChanged: function() {
        this.scrolling && this.getScroller().setMaxHeight(this.maxHeight + "px");
    },
    showingChanged: function() {
        this.inherited(arguments), this.scrolling && this.getScroller().setShowing(this.showing), 
        this.adjustPosition();
    },
    childControlActivated: function() {
        return !0;
    },
    requestShow: function(t, e) {
        var i = e.activator.hasNode();
        return i && (this.activatorOffset = this.getPageOffset(i)), this.show(), !0;
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    getPageOffset: function(t) {
        var e = this.getBoundingRect(t), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            this.resetPositioning();
            var t = this.getViewWidth(), e = this.getViewHeight(), i = this.vertFlushMargin, n = e - this.vertFlushMargin, o = this.horizFlushMargin, s = t - this.horizFlushMargin;
            if (i > this.activatorOffset.top + this.activatorOffset.height || this.activatorOffset.top > n) {
                if (this.applyVerticalFlushPositioning(o, s)) return;
                if (this.applyHorizontalFlushPositioning(o, s)) return;
                if (this.applyVerticalPositioning()) return;
            } else if ((o > this.activatorOffset.left + this.activatorOffset.width || this.activatorOffset.left > s) && this.applyHorizontalPositioning()) return;
            var a = this.getBoundingRect(this.node);
            if (a.width > this.widePopup) {
                if (this.applyVerticalPositioning()) return;
            } else if (a.height > this.longPopup && this.applyHorizontalPositioning()) return;
            if (this.applyVerticalPositioning()) return;
            if (this.applyHorizontalPositioning()) return;
        }
    },
    initVerticalPositioning: function() {
        this.resetPositioning(), this.addClass("vertical");
        var t = this.getBoundingRect(this.node), e = this.getViewHeight();
        return this.floating ? e / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height,
            bottom: "auto"
        }), this.addClass("below")) : (this.applyPosition({
            top: this.activatorOffset.top - t.height,
            bottom: "auto"
        }), this.addClass("above")) : t.top + t.height > e && e - t.bottom < t.top - t.height ? this.addClass("above") : this.addClass("below"), 
        t = this.getBoundingRect(this.node), t.top + t.height > e || 0 > t.top ? !1 : !0;
    },
    applyVerticalPositioning: function() {
        if (!this.initVerticalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        if (this.floating) {
            var i = this.activatorOffset.left + this.activatorOffset.width / 2 - t.width / 2;
            i + t.width > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.width
            }), this.addClass("left")) : 0 > i ? (this.applyPosition({
                left: this.activatorOffset.left
            }), this.addClass("right")) : this.applyPosition({
                left: i
            });
        } else {
            var n = this.activatorOffset.left + this.activatorOffset.width / 2 - t.left - t.width / 2;
            t.right + n > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.right
            }), this.addRemoveClass("left", !0)) : 0 > t.left + n ? this.addRemoveClass("right", !0) : this.applyPosition({
                left: n
            });
        }
        return !0;
    },
    applyVerticalFlushPositioning: function(t, e) {
        if (!this.initVerticalPositioning()) return !1;
        var i = this.getBoundingRect(this.node), n = this.getViewWidth();
        return t > this.activatorOffset.left + this.activatorOffset.width / 2 ? (this.activatorOffset.left + this.activatorOffset.width / 2 < this.horizBuffer ? this.applyPosition({
            left: this.horizBuffer + (this.floating ? 0 : -i.left)
        }) : this.applyPosition({
            left: this.activatorOffset.width / 2 + (this.floating ? this.activatorOffset.left : 0)
        }), this.addClass("right"), this.addClass("corner"), !0) : this.activatorOffset.left + this.activatorOffset.width / 2 > e ? (this.activatorOffset.left + this.activatorOffset.width / 2 > n - this.horizBuffer ? this.applyPosition({
            left: n - this.horizBuffer - i.right
        }) : this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width / 2 - i.right
        }), this.addClass("left"), this.addClass("corner"), !0) : !1;
    },
    initHorizontalPositioning: function() {
        this.resetPositioning();
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        return this.floating ? e / 2 > this.activatorOffset.left + this.activatorOffset.width ? (this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width
        }), this.addRemoveClass("left", !0)) : (this.applyPosition({
            left: this.activatorOffset.left - t.width
        }), this.addRemoveClass("right", !0)) : this.activatorOffset.left - t.width > 0 ? (this.applyPosition({
            left: this.activatorOffset.left - t.left - t.width
        }), this.addRemoveClass("right", !0)) : (this.applyPosition({
            left: this.activatorOffset.width
        }), this.addRemoveClass("left", !0)), this.addRemoveClass("horizontal", !0), t = this.getBoundingRect(this.node), 
        0 > t.left || t.left + t.width > e ? !1 : !0;
    },
    applyHorizontalPositioning: function() {
        if (!this.initHorizontalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewHeight(), i = this.activatorOffset.top + this.activatorOffset.height / 2;
        return this.floating ? i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - t.height / 2,
            bottom: "auto"
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: this.activatorOffset.top - this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top - t.height + 2 * this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("low", !0)) : i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: (this.activatorOffset.height - t.height) / 2
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: -this.activatorOffset.height
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: t.top - t.height - this.activatorOffset.top + this.activatorOffset.height
        }), this.addRemoveClass("low", !0)), !0;
    },
    applyHorizontalFlushPositioning: function(t, e) {
        if (!this.initHorizontalPositioning()) return !1;
        var i = this.getBoundingRect(this.node), n = this.getViewHeight();
        return this.floating ? n / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - i.height
        }), this.addRemoveClass("low", !0)) : i.top + i.height > n && n - i.bottom < i.top - i.height ? (this.applyPosition({
            top: i.top - i.height - this.activatorOffset.top - this.activatorOffset.height / 2
        }), this.addRemoveClass("low", !0)) : (this.applyPosition({
            top: this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)), t > this.activatorOffset.left + this.activatorOffset.width ? (this.addClass("left"), 
        this.addClass("corner"), !0) : this.activatorOffset.left > e ? (this.addClass("right"), 
        this.addClass("corner"), !0) : !1;
    },
    getBoundingRect: function(t) {
        var e = t.getBoundingClientRect();
        return e.width && e.height ? e : {
            left: e.left,
            right: e.right,
            top: e.top,
            bottom: e.bottom,
            width: e.right - e.left,
            height: e.bottom - e.top
        };
    },
    getViewHeight: function() {
        return void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight;
    },
    getViewWidth: function() {
        return void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
    },
    resetPositioning: function() {
        this.removeClass("right"), this.removeClass("left"), this.removeClass("high"), this.removeClass("low"), 
        this.removeClass("corner"), this.removeClass("below"), this.removeClass("above"), 
        this.removeClass("vertical"), this.removeClass("horizontal"), this.applyPosition({
            left: "auto"
        }), this.applyPosition({
            top: "auto"
        });
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    },
    requestHide: function() {
        this.setShowing(!1);
    }
});

// lib\mochi\source\Badge.js
enyo.kind({
    name: "mochi.Badge",
    classes: "enyo-tool-decorator mochi-badge",
    published: {
        background: "#69cdff",
        color: "#ffffff"
    },
    components: [ {
        name: "inner",
        classes: "mochi-badge-inner"
    } ],
    create: function() {
        this._origBackground = this.background, this.inherited(arguments);
    },
    rendered: function() {
        this.inherited(arguments), this.contentChanged(), this.backgroundChanged(), this.colorChanged();
    },
    contentChanged: function() {
        return "" == this.content ? (this.setBackground("transparent"), this.$.inner.setContent(""), 
        void 0) : (this.setShowing(!0), this.setBackground(this._origBackground), this.$.inner.setContent(this.content), 
        ("" + this.content).length > 2 ? (this.$.inner.removeClass("round"), this.$.inner.addClass("oval")) : (this.$.inner.removeClass("oval"), 
        this.$.inner.addClass("round")), void 0);
    },
    backgroundChanged: function() {
        this.$.inner.addStyles("background: " + this.background + ";");
    },
    colorChanged: function() {
        this.$.inner.addStyles("color: " + this.color + ";");
    }
});

// lib\mochi\source\ButtonDecorator.js
enyo.kind({
    name: "mochi.ButtonDecorator",
    classes: "enyo-unselectable mochi-button-decorator",
    components: [ {
        name: "endCap",
        classes: "mochi-button-decorator-bookened"
    } ]
}), enyo.kind({
    name: "mochi.ButtonDecoratorLeft",
    kind: "mochi.ButtonDecorator",
    classes: "mochi-button-decorator-left",
    published: {
        content: "("
    },
    create: function() {
        this.inherited(arguments), this.$.endCap.setContent(this.content);
    },
    contentChanged: function() {
        this.$.endCap.setContent(this.content);
    }
}), enyo.kind({
    name: "mochi.ButtonDecoratorRight",
    kind: "mochi.ButtonDecorator",
    classes: "mochi-button-decorator-right",
    published: {
        content: ")"
    },
    create: function() {
        this.inherited(arguments), this.$.endCap.setContent(this.content);
    },
    contentChanged: function() {
        this.$.endCap.setContent(this.content);
    }
});

// lib\mochi\source\Button.js
enyo.kind({
    name: "mochi.Button",
    kind: "enyo.GroupItem",
    tag: "button",
    classes: "enyo-tool-decorator mochi-button",
    published: {
        disabled: !1,
        content: "",
        barClasses: "",
        decoratorLeft: "(",
        decoratorRight: ")"
    },
    tools: [ {
        kind: "mochi.ButtonDecoratorLeft"
    }, {
        name: "button",
        classes: "mochi-button-base"
    }, {
        name: "client"
    }, {
        kind: "mochi.ButtonDecoratorRight"
    }, {
        name: "bar",
        classes: "mochi-button-bar"
    } ],
    initComponents: function() {
        this.createChrome(this.tools), this.inherited(arguments);
    },
    create: function() {
        this.inherited(arguments), this.disabledChanged(), this.decoratorLeftChanged(), 
        this.decoratorRightChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.activeChanged(), this.calcBarValue(), this.barClassesChanged();
    },
    decoratorLeftChanged: function() {
        this.$.buttonDecoratorLeft.setContent(this.decoratorLeft);
    },
    decoratorRightChanged: function() {
        this.$.buttonDecoratorRight.setContent(this.decoratorRight);
    },
    disabledChanged: function() {
        this.setAttribute("disabled", this.disabled), this.addRemoveClass("disabled", this.disabled);
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t.width + "px"), this.$.bar.applyStyle("left", t.left + "px");
    },
    calcBarValue: function() {
        var t = this.$.button.getBounds();
        this.updateBarPosition(t);
    },
    contentChanged: function() {
        this.$.button.setContent(this.content), this.calcBarValue();
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!0), void 0);
    }
});

// lib\mochi\source\RadioButton.js
enyo.kind({
    name: "mochi.RadioButton",
    kind: enyo.Checkbox,
    tag: "div",
    handlers: {
        ondown: "downHandler",
        onclick: ""
    },
    published: {
        colorActive: "#ffb80d",
        colorInactive: "#fff",
        colorActiveDisabled: "#ffdb86",
        colorInactiveDisabled: "#ccc",
        canAnimate: !0,
        type: "radio",
        buttonClasses: "mochi-radio-button"
    },
    animateClass: "mochi-radio-button-animate",
    create: function() {
        this.inherited(arguments), this.addClass(this.buttonClasses);
    },
    rendered: function() {
        this.inherited(arguments), this.canAnimateChanged(), this.disabledChanged();
    },
    checkedChanged: function() {
        this.setNodeProperty("checked", this.checked), this.checked ? (this.setAttribute("checked", "checked"), 
        this.applyStyle("background-color", this.colorActive)) : (this.setAttribute("checked", ""), 
        this.applyStyle("background-color", this.colorInactive)), this.setActive(this.checked);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled), this.disabled && this.applyStyle("background-color", this.checked ? this.colorActiveDisabled : this.colorInactiveDisabled);
    },
    canAnimateChanged: function() {
        var t = this.canAnimate ? this.animateClass : "mochi-no-animate";
        this.addClass(t);
    },
    downHandler: function() {
        return this.disabled || (this.setChecked(!this.getChecked()), this.bubble("onchange")), 
        !0;
    },
    tap: function() {
        return !this.disabled;
    }
});

// lib\mochi\source\Checkbox.js
enyo.kind({
    name: "mochi.Checkbox",
    kind: "mochi.RadioButton",
    published: {
        colorActive: "#ffb80d",
        colorInactive: "#fff",
        colorActiveDisabled: "#ffb80d",
        colorInactiveDisabled: "#fff",
        canAnimate: !0,
        type: "checkbox",
        buttonClasses: "mochi-checkbox"
    },
    animateClass: "mochi-checkbox-animate"
});

// lib\mochi\source\Icon.js
enyo.kind({
    name: "mochi.Icon",
    published: {
        src: ""
    },
    classes: "mochi-icon",
    create: function() {
        this.inherited(arguments), this.src && this.srcChanged();
    },
    srcChanged: function() {
        this.applyStyle("background-image", "url(" + enyo.path.rewrite(this.src) + ")");
    }
});

// lib\mochi\source\IconButton.js
enyo.kind({
    name: "mochi.IconButton",
    tag: "button",
    classes: "enyo-tool-decorator mochi-icon-button",
    published: {
        active: !1,
        disabled: !1,
        src: "",
        active: !1,
        disabled: !1,
        barClasses: ""
    },
    handlers: {
        ontap: "tapHandler"
    },
    components: [ {
        kind: "mochi.Icon"
    }, {
        name: "bar",
        classes: "mochi-button-bar mochi-icon-button-bar"
    } ],
    create: function() {
        this.inherited(arguments), this.disabledChanged(), this.srcChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.calcBarValue(), this.activeChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t.width - 2 + "px"), this.$.bar.applyStyle("left", t.left + 1 + "px");
    },
    calcBarValue: function() {
        var t = this.$.icon.getBounds();
        this.updateBarPosition(t);
    },
    srcChanged: function() {
        this.$.icon.setSrc(this.src);
    },
    disabledChanged: function() {
        this.setAttribute("disabled", this.disabled), this.addRemoveClass("disabled", this.disabled);
    },
    activeChanged: function() {
        this.addRemoveClass("active", this.active);
    },
    tapHandler: function() {
        return this.disabled ? !0 : void 0;
    }
}), enyo.kind({
    name: "mochi.IconButtonItem",
    kind: "enyo.Button",
    published: {
        active: !1,
        disabled: !1,
        src: ""
    },
    handlers: {
        onActivate: "activate"
    },
    classes: "mochi-icon-button-item",
    components: [ {
        kind: "mochi.Icon"
    } ],
    create: function() {
        this.inherited(arguments), this.disabledChanged(), this.$.icon.setSrc(this.src);
    },
    rendered: function() {
        this.inherited(arguments), this.activeChanged();
    },
    activeChanged: function() {
        this.disabled || (this.bubble("onActivate"), this.addRemoveClass("active", this.active));
    },
    disabledChanged: function() {
        this.setAttribute("disabled", this.disabled), this.addRemoveClass("disabled", this.disabled);
    }
});

// lib\mochi\source\Input.js
enyo.kind({
    name: "mochi.Input",
    kind: "enyo.Input",
    classes: "mochi-input"
});

// lib\mochi\source\InputDecorator.js
enyo.kind({
    name: "mochi.InputDecorator",
    kind: "enyo.ToolDecorator",
    tag: "label",
    classes: "mochi-input-decorator",
    handlers: {
        onDisabledChange: "disabledChange",
        onfocus: "receiveFocus",
        onblur: "receiveBlur"
    },
    published: {
        canAnimate: !0
    },
    rendered: function() {
        this.inherited(arguments), this.canAnimateChanged();
    },
    canAnimateChanged: function() {
        var t = this.canAnimate ? "mochi-input-animate" : "mochi-no-animate";
        this.addClass(t);
    },
    receiveFocus: function() {
        this.addClass("mochi-focused");
    },
    receiveBlur: function() {
        this.removeClass("mochi-focused");
    },
    disabledChange: function(t, e) {
        this.addRemoveClass("mochi-disabled", e.originator.disabled);
    }
});

// lib\mochi\source\Popup.js
enyo.kind({
    name: "mochi.Popup",
    kind: "Popup",
    classes: "mochi-popup",
    published: {
        scrimWhenModal: !0,
        scrim: !1,
        scrimClassName: "",
        defaultZ: 120
    },
    protectedStatics: {
        count: 0,
        highestZ: 120
    },
    showingChanged: function() {
        this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, 
        this.showHideScrim(this.showing), this.inherited(arguments);
    },
    showHideScrim: function(t) {
        if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
            var e = this.getScrim();
            if (t) {
                var i = this.getScrimZIndex();
                this._scrimZ = i, e.showAtZIndex(i);
            } else e.hideAtZIndex(this._scrimZ);
            enyo.call(e, "addRemoveClass", [ this.scrimClassName, e.showing ]);
        }
    },
    getScrimZIndex: function() {
        return onyx.Popup.highestZ >= this._zIndex ? this._zIndex - 1 : onyx.Popup.highestZ;
    },
    getScrim: function() {
        return this.modal && this.scrimWhenModal && !this.scrim ? onyx.scrimTransparent.make() : onyx.scrim.make();
    },
    applyZIndex: function() {
        this._zIndex = 2 * onyx.Popup.count + this.findZIndex() + 1, this._zIndex <= onyx.Popup.highestZ && (this._zIndex = onyx.Popup.highestZ + 1), 
        this._zIndex > onyx.Popup.highestZ && (onyx.Popup.highestZ = this._zIndex), this.applyStyle("z-index", this._zIndex);
    },
    findZIndex: function() {
        var t = this.defaultZ;
        return this._zIndex ? t = this._zIndex : this.hasNode() && (t = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || t), 
        this.defaultZ > t && (t = this.defaultZ), this._zIndex = t, this._zIndex;
    }
});

// lib\mochi\source\ProgressBar.js
enyo.kind({
    name: "mochi.ProgressBar",
    classes: "mochi-progress-bar",
    published: {
        progress: 0,
        min: 0,
        max: 100,
        barClasses: ""
    },
    events: {
        onAnimateProgressFinish: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bar",
        classes: "mochi-progress-bar-bar"
    } ],
    create: function() {
        this.inherited(arguments), this.progressChanged(), this.barClassesChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    progressChanged: function() {
        this.progress = this.clampValue(this.min, this.max, this.progress);
        var t = this.calcPercent(this.progress);
        this.updateBarPosition(t);
    },
    clampValue: function(t, e, i) {
        return Math.max(t, Math.min(i, e));
    },
    calcRatio: function(t) {
        return (t - this.min) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return 100 * this.calcRatio(t);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t + "%");
    },
    animateProgressTo: function(t) {
        this.$.progressAnimator.play({
            startValue: this.progress,
            endValue: t,
            node: this.hasNode()
        });
    },
    progressAnimatorStep: function(t) {
        return this.setProgress(t.value), !0;
    },
    progressAnimatorComplete: function(t) {
        return this.doAnimateProgressFinish(t), !0;
    }
});

// lib\mochi\source\ProgressText.js
enyo.kind({
    name: "mochi.ProgressText",
    classes: "mochi-progress-text",
    published: {
        progress: 0,
        min: 0,
        max: 100,
        barClasses: "",
        decimalPlaces: 0
    },
    events: {
        onAnimateProgressFinish: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "barContainer",
        classes: "mochi-progress-text-box",
        components: [ {
            name: "barBackground",
            classes: "mochi-progress-text-underwear",
            content: "100% Downloaded"
        }, {
            name: "bar",
            classes: "mochi-progress-text-outerwear",
            content: "100% Downloaded"
        } ]
    } ],
    create: function() {
        this.inherited(arguments), this.barClassesChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.progressChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    progressChanged: function() {
        this.progress = this.clampValue(this.min, this.max, this.progress);
        var t = this.calcPercent(this.progress);
        this.updateBarPosition(t);
    },
    clampValue: function(t, e, i) {
        return Math.max(t, Math.min(i, e));
    },
    calcRatio: function(t) {
        return (t - this.min) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return (100 * this.calcRatio(t)).toFixed(this.decimalPlaces);
    },
    updateBarPosition: function(t) {
        var e = t + "% Downloaded";
        this.$.barBackground.setContent(e), this.$.bar.setContent(e);
        var i = this.$.barBackground.getBounds().width / 100 * t;
        this.$.bar.applyStyle("width", i + "px");
    },
    animateProgressTo: function(t) {
        this.$.progressAnimator.play({
            startValue: this.progress,
            endValue: t,
            node: this.hasNode()
        });
    },
    progressAnimatorStep: function(t) {
        return this.setProgress(t.value), !0;
    },
    progressAnimatorComplete: function(t) {
        return this.doAnimateProgressFinish(t), !0;
    }
});

// lib\mochi\source\RichText.js
enyo.kind({
    name: "mochi.RichText",
    kind: "enyo.RichText",
    classes: "mochi-richtext"
});

// lib\mochi\source\Slider.js
enyo.kind({
    name: "mochi.Slider",
    kind: "mochi.ProgressBar",
    classes: "mochi-slider",
    published: {
        value: 0,
        lockBar: !0,
        tappable: !0,
        customClasses: ""
    },
    events: {
        onChange: "",
        onChanging: "",
        onAnimateFinish: ""
    },
    showStripes: !1,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    moreComponents: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    }, {
        classes: "mochi-slider-taparea"
    }, {
        name: "knob",
        ondown: "showKnobStatus",
        onup: "hideKnobStatus",
        classes: "mochi-slider-knob"
    }, {
        kind: "mochi.Popup",
        name: "popup",
        classes: "mochi-slider-popup above",
        components: [ {
            tag: "canvas",
            name: "drawing",
            attributes: {
                width: 62,
                height: 36
            }
        }, {
            name: "popupLabel",
            classes: "mochi-slider-popup-label"
        } ]
    } ],
    create: function() {
        this.inherited(arguments), this.createComponents(this.moreComponents), this.valueChanged(), 
        this.customClassesChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.drawToCanvas(this.controlColor), this.adjustPopupPosition(!1);
    },
    valueChanged: function() {
        this.value = this.clampValue(this.min, this.max, this.value);
        var t = this.calcPercent(this.value);
        this.updateKnobPosition(t), this.lockBar && this.setProgress(this.value);
    },
    customClassesChanged: function(t) {
        this.$.knob.removeClass(t), this.$.knob.addClass(this.customClasses), this.barClasses = this.customClasses, 
        this.barClassesChanged();
    },
    updateKnobPosition: function(t) {
        this.$.knob.applyStyle("left", t + "%"), this.$.popup.applyStyle("left", t + "%"), 
        this.$.popupLabel.setContent(Math.round(t) + "%");
    },
    calcKnobPosition: function(t) {
        var e = t.clientX - this.hasNode().getBoundingClientRect().left;
        return e / this.getBounds().width * (this.max - this.min) + this.min;
    },
    adjustPopupPosition: function() {
        var t = this.$.popup, e = t.hasNode().getBoundingClientRect(), i = this.container.hasNode().getBoundingClientRect(), n = this.$.knob.hasNode().getBoundingClientRect();
        e.width + e.left > i.right && t.applyStyle("left", n.left - i.left - e.width + "px");
    },
    showKnobStatus: function() {
        this.$.popup.setShowing(!0);
    },
    hideKnobStatus: function() {
        this.$.popup.setShowing(!1);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, this.$.knob.addClass("active"), 
        this.showKnobStatus(), !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = this.calcKnobPosition(e);
            return this.setValue(i), this.doChanging({
                value: this.value
            }), this.adjustPopupPosition(e), !0;
        }
    },
    dragfinish: function(t, e) {
        return this.dragging = !1, e.preventTap(), this.doChange({
            value: this.value
        }), this.$.knob.removeClass("active"), this.$.popup.setShowing(!1), !0;
    },
    tap: function(t, e) {
        if (this.tappable) {
            var i = this.calcKnobPosition(e);
            return this.tapped = !0, this.animateTo(i), !0;
        }
    },
    animateTo: function(t) {
        this.$.animator.play({
            startValue: this.value,
            endValue: t,
            node: this.hasNode()
        });
    },
    animatorStep: function(t) {
        return this.setValue(t.value), !0;
    },
    animatorComplete: function(t) {
        return this.tapped && (this.tapped = !1, this.doChange({
            value: this.value
        })), this.doAnimateFinish(t), !0;
    },
    drawToCanvas: function() {
        var t = this.$.drawing.hasNode().getContext("2d");
        t.fillStyle = enyo.dom.getComputedStyleValue(this.$.knob.hasNode(), "background-color"), 
        t.moveTo(1, 37), t.arcTo(1, 33, 12, 33, 4), t.lineTo(46, 33), t.arcTo(61, 33, 61, 17, 16), 
        t.moveTo(61, 17), t.arcTo(61, 1, 46, 1, 16), t.lineTo(16, 1), t.arcTo(1, 1, 1, 17, 16), 
        t.lineTo(1, 37), t.fill();
    }
});

// lib\mochi\source\Spinner.js
enyo.kind({
    name: "mochi.Spinner",
    classes: "mochi-spinner",
    stop: function() {
        this.setShowing(!1);
    },
    start: function() {
        this.setShowing(!0);
    },
    toggle: function() {
        this.setShowing(!this.getShowing());
    }
});

// lib\mochi\source\TextArea.js
enyo.kind({
    name: "mochi.TextArea",
    kind: "enyo.TextArea",
    classes: "mochi-textarea"
});

// lib\mochi\source\ToggleButton.js
enyo.kind({
    name: "mochi.ToggleButton",
    classes: "mochi-toggle-button",
    published: {
        active: !1,
        value: !1,
        disabled: !1,
        canAnimate: !0,
        colorActive: "#ffb80d",
        colorInactive: "#646464"
    },
    events: {
        onChange: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish"
    },
    lastKnobPos: 0,
    onXPos: 0,
    _canAnimate: !1,
    components: [ {
        name: "toggleKnob",
        classes: "mochi-toggle-button-knob"
    }, {
        kind: "enyo.Animator",
        onStep: "animatorStep",
        onEnd: "animatorEnd"
    } ],
    create: function() {
        this.inherited(arguments), this.value = Boolean(this.value || this.active), this.disabledChanged(), 
        this.supressAnimation();
    },
    rendered: function() {
        this.inherited(arguments), this.calcKnob(), this.valueChanged(), this.init();
    },
    supressAnimation: function() {
        this._canAnimate = this.canAnimate, this.canAnimate = !1;
    },
    init: function() {
        this.setCanAnimate(this._canAnimate);
    },
    animatorStep: function(t) {
        this.updateKnobPosition(t.value);
    },
    updateKnobPosition: function(t) {
        var e = t + "px", i = this.$.toggleKnob;
        enyo.dom.canTransform() ? enyo.dom.transform(i, {
            translateX: e
        }) : i.applyStyle("left", e);
    },
    calcKnob: function() {
        this.onXPos = this.getBounds().width - this.$.toggleKnob.getBounds().width - 2 * parseInt(enyo.dom.getComputedStyleValue(this.$.toggleKnob.hasNode(), "margin-left"));
    },
    valueChanged: function() {
        this.applyStyle("background-color", this.value ? this.colorActive : this.colorInactive), 
        this.setActive(this.value), this.doChange({
            value: this.value
        });
        var t = this.value ? this.onXPos : 0;
        this.canAnimate ? this.$.animator.play({
            startValue: this.lastKnobPos,
            endValue: t,
            node: this.$.toggleKnob.hasNode()
        }) : this.updateKnobPosition(t), this.lastKnobPos = t;
    },
    activeChanged: function() {
        this.setValue(this.active), this.bubble("onActivate");
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    updateValue: function(t) {
        this.disabled || this.setValue(t);
    },
    tap: function() {
        this.updateValue(!this.value);
    },
    dragstart: function(t, e) {
        return e.horizontal ? (e.preventDefault(), this.dragging = !0, this.dragged = !1, 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = e.dx;
            return Math.abs(i) > 10 && (this.updateValue(i > 0), this.dragged = !0), !0;
        }
    },
    dragfinish: function(t, e) {
        this.dragging = !1, this.dragged && e.preventTap();
    },
    resizeHandler: function() {
        this.inherited(arguments), this.calcKnob();
    }
});

// lib\mochi\source\ViewSelectButton.js
enyo.kind({
    name: "mochi.ViewSelectButtonItem",
    kind: "enyo.Button",
    classes: "mochi-button-base",
    contentWidth: 0,
    rendered: function() {
        this.inherited(arguments), this.contentWidth = this.getBounds().width, this.applyStyle("width", this.contentWidth + 2 * (this.content.length + 2) + "px");
    }
}), enyo.kind({
    name: "mochi.ViewSelectButton",
    kind: "enyo.Group",
    defaultKind: "mochi.ViewSelectButtonItem",
    classes: "enyo-tool-decorator mochi-view-select-button",
    published: {
        barClasses: ""
    },
    handlers: {
        onActivate: "activate"
    },
    moreComponents: [ {
        kind: "mochi.ButtonDecoratorLeft",
        addBefore: null
    }, {
        kind: "mochi.ButtonDecoratorRight"
    }, {
        kind: "enyo.Control",
        name: "bar",
        classes: "mochi-button-bar"
    }, {
        kind: "enyo.Animator",
        onStep: "animatorStep",
        onEnd: "animatorEnd"
    } ],
    componentsRendered: !1,
    lastBarPos: 0,
    create: function() {
        this.inherited(arguments), this.createComponents(this.moreComponents);
    },
    rendered: function() {
        this.inherited(arguments), this.barClassesChanged(), this.init();
    },
    init: function() {
        this.componentsRendered = !0, this.calcBarValue(this.active);
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    animatorStep: function(t) {
        this.updateBarPosition(this.$.bar, t.value);
    },
    updateBarPosition: function(t, e) {
        var i = e + "px";
        enyo.dom.canTransform() ? enyo.dom.transform(t, {
            translateX: i
        }) : t.applyStyle("left", i);
    },
    calcBarValue: function(t) {
        if (this.active && this.componentsRendered) {
            if ("mochi.ViewSelectButtonItem" === this.active.kind) {
                this.$.bar.applyStyle("width", t.getBounds().width + "px");
                var e = t.hasNode().getBoundingClientRect().right - t.hasNode().getBoundingClientRect().left - t.getBounds().width, i = this.getCSSProperty(t, "offsetLeft", !1) + e / 2;
            } else if ("mochi.IconButtonItem" === this.active.kind) {
                this.$.bar.applyStyle("width", "25px");
                var i = this.getCSSProperty(t, "offsetLeft", !1) + 5;
            }
            this.$.animator.play({
                startValue: this.lastBarPos,
                endValue: i,
                node: this.$.bar.hasNode()
            }), this.lastBarPos = i;
        }
    },
    activate: function(t, e) {
        this.highlander && (e.originator.active ? (this.setActive(e.originator), this.calcBarValue(e.originator)) : e.originator === this.active && this.active.setActive(!0));
    },
    getCSSProperty: function(t, e, i) {
        return t.hasNode() ? i ? t.node.style[e] : t.node[e] : void 0;
    }
});

// lib\mochi\source\ContextualPopupDecorator.js
enyo.kind({
    name: "mochi.ContextualPopupDecorator",
    defaultKind: "mochi.Button",
    classes: "mochi-contextual-popup-decorator enyo-unselectable",
    handlers: {
        onActivate: "activated",
        onHide: "popupHidden"
    },
    activated: function(t, e) {
        this.requestHidePopup(), e.originator.active && (this.popupActive = !0, this.activator = e.originator, 
        this.activator.addClass("active"), this.requestShowPopup());
    },
    popupHidden: function() {
        this.popupActive = !1, this.activator && (this.activator.setActive(!1), this.activator.removeClass("active"));
    },
    requestShowPopup: function() {
        this.waterfallDown("onRequestShowPopup", {
            activator: this.activator
        });
    },
    requestHidePopup: function() {
        this.waterfallDown("onRequestHidePopup");
    }
});

// lib\mochi\source\ContextualPopup.js
enyo.kind({
    name: "mochi.ContextualPopup",
    kind: "enyo.Popup",
    modal: !0,
    autoDismiss: !0,
    floating: !1,
    classes: "mochi-contextual-popup enyo-unselectable",
    published: {
        maxHeight: 100,
        scrolling: !0,
        title: void 0,
        actionButtons: []
    },
    vertFlushMargin: 100,
    horizFlushMargin: 100,
    widePopup: 200,
    longPopup: 200,
    horizBuffer: 16,
    events: {
        onTap: ""
    },
    handlers: {
        onRequestShowPopup: "requestShow",
        onRequestHidePopup: "requestHide"
    },
    components: [ {
        name: "title",
        classes: "mochi-contextual-popup-title"
    }, {
        classes: "mochi-contextual-popup-scroller",
        components: [ {
            name: "client",
            kind: "enyo.Scroller",
            vertical: "auto",
            classes: "enyo-unselectable",
            thumb: !1,
            strategyKind: "TouchScrollStrategy"
        } ]
    }, {
        name: "actionButtons",
        classes: "mochi-contextual-popup-action-buttons"
    } ],
    scrollerName: "client",
    create: function() {
        this.inherited(arguments), this.maxHeightChanged(), this.titleChanged(), this.actionButtonsChanged();
    },
    getScroller: function() {
        return this.$[this.scrollerName];
    },
    titleChanged: function() {
        this.$.title.setContent(this.title);
    },
    actionButtonsChanged: function() {
        for (var t = 0; this.actionButtons.length > t; t++) this.$.actionButtons.createComponent({
            kind: "mochi.Button",
            content: this.actionButtons[t].content,
            classes: this.actionButtons[t].classes,
            name: this.actionButtons[t].name ? this.actionButtons[t].name : "ActionButton" + t,
            index: t,
            tap: enyo.bind(this, this.tapHandler)
        });
    },
    tapHandler: function(t, e) {
        return e.originator = e.originator.owner, e.actionButton = !0, e.popup = this, this.bubble("ontap", e), 
        !0;
    },
    maxHeightChanged: function() {
        this.scrolling ? this.getScroller().setMaxHeight(this.maxHeight + "px") : enyo.nop;
    },
    showingChanged: function() {
        this.inherited(arguments), this.scrolling ? this.getScroller().setShowing(this.showing) : enyo.nop, 
        this.adjustPosition();
    },
    requestShow: function(t, e) {
        var i;
        return i = e.activator && "mochi.Button" == e.activator.parent.kind ? e.activator.parent.parent.hasNode() : e.activator.hasNode(), 
        i && (this.activatorOffset = this.getPageOffset(i)), this.show(), !0;
    },
    applyPosition: function(t) {
        var e = "";
        for (n in t) e += n + ":" + t[n] + (isNaN(t[n]) ? "; " : "px; ");
        this.addStyles(e);
    },
    getPageOffset: function(t) {
        var e = this.getBoundingRect(t), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            this.resetPositioning();
            var t = this.getViewWidth(), e = this.getViewHeight(), i = this.vertFlushMargin, n = e - this.vertFlushMargin, o = this.horizFlushMargin, s = t - this.horizFlushMargin;
            if (i > this.activatorOffset.top + this.activatorOffset.height || this.activatorOffset.top > n) {
                if (this.applyVerticalFlushPositioning(o, s)) return;
                if (this.applyHorizontalFlushPositioning(o, s)) return;
                if (this.applyVerticalPositioning()) return;
            } else if ((o > this.activatorOffset.left + this.activatorOffset.width || this.activatorOffset.left > s) && this.applyHorizontalPositioning()) return;
            var a = this.getBoundingRect(this.node);
            if (a.width > this.widePopup) {
                if (this.applyVerticalPositioning()) return;
            } else if (a.height > this.longPopup && this.applyHorizontalPositioning()) return;
            if (this.applyVerticalPositioning()) return;
            if (this.applyHorizontalPositioning()) return;
        }
    },
    initVerticalPositioning: function() {
        this.resetPositioning(), this.addClass("vertical");
        var t = this.getBoundingRect(this.node), e = this.getViewHeight();
        return this.floating ? e / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height,
            bottom: "auto"
        }), this.addClass("below")) : (this.applyPosition({
            top: this.activatorOffset.top - t.height,
            bottom: "auto"
        }), this.addClass("above")) : t.top + t.height > e && e - t.bottom < t.top - t.height ? this.addClass("above") : this.addClass("below"), 
        t = this.getBoundingRect(this.node), t.top + t.height > e || 0 > t.top ? !1 : !0;
    },
    applyVerticalPositioning: function() {
        if (!this.initVerticalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        if (this.floating) {
            var i = this.activatorOffset.left + this.activatorOffset.width / 2 - t.width / 2;
            i + t.width > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.width
            }), this.addClass("left")) : 0 > i ? (this.applyPosition({
                left: this.activatorOffset.left
            }), this.addClass("right")) : this.applyPosition({
                left: i
            });
        } else {
            var n = this.activatorOffset.left + this.activatorOffset.width / 2 - t.left - t.width / 2;
            t.right + n > e ? (this.applyPosition({
                left: this.activatorOffset.left + this.activatorOffset.width - t.right
            }), this.addRemoveClass("left", !0)) : 0 > t.left + n ? this.addRemoveClass("right", !0) : this.applyPosition({
                left: n
            });
        }
        return !0;
    },
    applyVerticalFlushPositioning: function(t, e) {
        if (!this.initVerticalPositioning()) return !1;
        var i = this.getBoundingRect(this.node), n = this.getViewWidth();
        return t > this.activatorOffset.left + this.activatorOffset.width / 2 ? (this.activatorOffset.left + this.activatorOffset.width / 2 < this.horizBuffer ? this.applyPosition({
            left: this.horizBuffer + (this.floating ? 0 : -i.left)
        }) : this.applyPosition({
            left: this.activatorOffset.width / 2 + (this.floating ? this.activatorOffset.left : 0)
        }), this.addClass("right"), this.addClass("corner"), !0) : this.activatorOffset.left + this.activatorOffset.width / 2 > e ? (this.activatorOffset.left + this.activatorOffset.width / 2 > n - this.horizBuffer ? this.applyPosition({
            left: n - this.horizBuffer - i.right
        }) : this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width / 2 - i.right
        }), this.addClass("left"), this.addClass("corner"), !0) : !1;
    },
    initHorizontalPositioning: function() {
        this.resetPositioning();
        var t = this.getBoundingRect(this.node), e = this.getViewWidth();
        return this.floating ? e / 2 > this.activatorOffset.left + this.activatorOffset.width ? (this.applyPosition({
            left: this.activatorOffset.left + this.activatorOffset.width
        }), this.addRemoveClass("left", !0)) : (this.applyPosition({
            left: this.activatorOffset.left - t.width
        }), this.addRemoveClass("right", !0)) : this.activatorOffset.left - t.width > 0 ? (this.applyPosition({
            left: this.activatorOffset.left - t.left - t.width
        }), this.addRemoveClass("right", !0)) : (this.applyPosition({
            left: this.activatorOffset.width
        }), this.addRemoveClass("left", !0)), this.addRemoveClass("horizontal", !0), t = this.getBoundingRect(this.node), 
        0 > t.left || t.left + t.width > e ? !1 : !0;
    },
    applyHorizontalPositioning: function() {
        if (!this.initHorizontalPositioning()) return !1;
        var t = this.getBoundingRect(this.node), e = this.getViewHeight(), i = this.activatorOffset.top + this.activatorOffset.height / 2;
        return this.floating ? i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - t.height / 2,
            bottom: "auto"
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: this.activatorOffset.top - this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top - t.height + 2 * this.activatorOffset.height,
            bottom: "auto"
        }), this.addRemoveClass("low", !0)) : i >= e / 2 - .05 * e && e / 2 + .05 * e >= i ? this.applyPosition({
            top: (this.activatorOffset.height - t.height) / 2
        }) : e / 2 > this.activatorOffset.top + this.activatorOffset.height ? (this.applyPosition({
            top: -this.activatorOffset.height
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: t.top - t.height - this.activatorOffset.top + this.activatorOffset.height
        }), this.addRemoveClass("low", !0)), !0;
    },
    applyHorizontalFlushPositioning: function(t, e) {
        if (!this.initHorizontalPositioning()) return !1;
        var i = this.getBoundingRect(this.node);
        return this.getViewWidth(), this.floating ? innerHeight / 2 > this.activatorOffset.top ? (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)) : (this.applyPosition({
            top: this.activatorOffset.top + this.activatorOffset.height / 2 - i.height
        }), this.addRemoveClass("low", !0)) : i.top + i.height > innerHeight && innerHeight - i.bottom < i.top - i.height ? (this.applyPosition({
            top: i.top - i.height - this.activatorOffset.top - this.activatorOffset.height / 2
        }), this.addRemoveClass("low", !0)) : (this.applyPosition({
            top: this.activatorOffset.height / 2
        }), this.addRemoveClass("high", !0)), t > this.activatorOffset.left + this.activatorOffset.width ? (this.addClass("left"), 
        this.addClass("corner"), !0) : this.activatorOffset.left > e ? (this.addClass("right"), 
        this.addClass("corner"), !0) : !1;
    },
    getBoundingRect: function(t) {
        var e = t.getBoundingClientRect();
        return e.width && e.height ? e : {
            left: e.left,
            right: e.right,
            top: e.top,
            bottom: e.bottom,
            width: e.right - e.left,
            height: e.bottom - e.top
        };
    },
    getViewHeight: function() {
        return void 0 === window.innerHeight ? document.documentElement.clientHeight : window.innerHeight;
    },
    getViewWidth: function() {
        return void 0 === window.innerWidth ? document.documentElement.clientWidth : window.innerWidth;
    },
    resetPositioning: function() {
        this.removeClass("right"), this.removeClass("left"), this.removeClass("high"), this.removeClass("low"), 
        this.removeClass("corner"), this.removeClass("below"), this.removeClass("above"), 
        this.removeClass("vertical"), this.removeClass("horizontal"), this.applyPosition({
            left: "auto"
        }), this.applyPosition({
            top: "auto"
        });
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustPosition();
    },
    requestHide: function() {
        this.setShowing(!1);
    }
});

// lib\mochi\source\List.js
enyo.kind({
    name: "mochi.List",
    kind: "enyo.List",
    scrollFade: [ {
        name: "scrollFade",
        kind: "mochi.ScrollFade"
    } ],
    handlers: {
        ondrag: "dragHandler",
        onScrollStart: "scrollStartHandler",
        onScrollStop: "scrollStopHandler"
    },
    touch: !0,
    horizontal: "hidden",
    thumb: !1,
    yVals: [],
    scrollEventsReq: 10,
    yDirection: void 0,
    initComponents: function() {
        this.createChrome(this.scrollFade), this.inherited(arguments);
    },
    dragHandler: function(t, e) {
        this.updateScrollFade(e.yDirection), enyo.job.stop("hideFade");
    },
    scrollStartHandler: function(t, e) {
        enyo.platform.ios || (this.yVals.length == this.scrollEventsReq ? (this.updateScrollFade(this.yVals[this.scrollEventsReq - 1] - this.yVals[0]), 
        this.yVals = []) : this.yVals.push(e.originator.y), enyo.job.stop("hideFade"));
    },
    scrollStopHandler: function() {
        enyo.job("hideFade", enyo.bind(this.$.scrollFade, this.$.scrollFade.hideFade), 100);
    },
    updateScrollFade: function(t) {
        0 > t ? (this.yDirection > 0 && this.$.scrollFade.hideFade(), this.$.scrollFade.fade("top"), 
        this.yDirection = -1) : (0 > this.yDirection && this.$.scrollFade.hideFade(), this.$.scrollFade.fade("bottom"), 
        this.yDirection = 1);
    }
}), enyo.kind({
    name: "mochi.ScrollFade",
    classes: "mochi-list-scroll-fade",
    components: [ {
        name: "top",
        showing: !1,
        components: [ {
            classes: "mochi-list-scroll-fade-row row-1"
        }, {
            classes: "mochi-list-scroll-fade-row row-2"
        }, {
            classes: "mochi-list-scroll-fade-row row-3"
        }, {
            classes: "mochi-list-scroll-fade-row row-4"
        } ]
    }, {
        name: "bottom",
        showing: !1,
        components: [ {
            classes: "mochi-list-scroll-fade-row row-4"
        }, {
            classes: "mochi-list-scroll-fade-row row-3"
        }, {
            classes: "mochi-list-scroll-fade-row row-2"
        }, {
            classes: "mochi-list-scroll-fade-row row-1"
        } ]
    } ],
    fade: function(t) {
        this.fadeLocked || (this.fadeLocked = !0, this.addClass(t), this.$[t].show(), this.show());
    },
    hideFade: function() {
        this.$.top.hide(), this.$.bottom.hide(), this.removeClass("top"), this.removeClass("bottom"), 
        this.hide(), this.fadeLocked = !1;
    }
});

// lib\mochi\source\ListItem.js
enyo.kind({
    name: "mochi.ListItem",
    classes: "mochi-list-item",
    tapHighlight: !0,
    handlers: {
        onhold: "hold",
        onrelease: "release"
    },
    topBorder: [ {
        name: "topBorder",
        kind: "mochi.ListItemBorder",
        top: !0,
        showing: !1
    } ],
    initComponents: function() {
        this.createChrome(this.topBorder), this.inherited(arguments);
    },
    create: function() {
        this.inherited(arguments), this.createComponent({
            name: "bottomBorder",
            kind: "mochi.ListItemBorder",
            top: !1,
            showing: !1
        });
    },
    hold: function(t, e) {
        this.tapHighlight && mochi.ListItem.addFlyweightClass(this.controlParent || this, "mochi-highlight", e);
    },
    release: function(t, e) {
        this.tapHighlight && mochi.ListItem.removeFlyweightClass(this.controlParent || this, "mochi-highlight", e);
    },
    statics: {
        addFlyweightClass: function(t, e, i, n) {
            var o = i.flyweight;
            if (o) {
                var s = void 0 !== n ? n : i.index;
                o.performOnRow(s, function() {
                    var i = t.node.getBoundingClientRect().width;
                    t.$.topBorder.showBorder(i, 0), t.$.bottomBorder.showBorder(i, t.getComputedStyleValue("padding-bottom")), 
                    t.hasClass(e) ? t.setClassAttribute(t.getClassAttribute()) : t.addClass(e);
                }), t.removeClass(e);
            }
        },
        removeFlyweightClass: function(t, e, i, n) {
            var o = i.flyweight;
            if (o) {
                var s = void 0 !== n ? n : i.index;
                o.performOnRow(s, function() {
                    t.$.topBorder.hide(), t.$.bottomBorder.hide(), t.hasClass(e) ? t.removeClass(e) : t.setClassAttribute(t.getClassAttribute());
                });
            }
        }
    }
}), enyo.kind({
    name: "mochi.ListItemBorder",
    classes: "mochi-highlight-border",
    published: {
        top: !0,
        width: 0,
        marginTop: 0
    },
    edgeWidths: 224,
    largeEdgeWidths: 640,
    create: function() {
        this.inherited(arguments), this.topChanged();
    },
    showBorder: function(t, e) {
        this.setMarginTop(e), this.width = t, this.widthChanged(), this.show();
    },
    topChanged: function() {
        this.addClass(this.top ? "top" : "bottom");
    },
    widthChanged: function() {
        this.width < this.largeEdgeWidths ? this.removeClass("large") : this.addClass("large"), 
        this.setStyle("width:" + (this.width - (this.width < this.largeEdgeWidths ? this.edgeWidths : this.largeEdgeWidths)) + "px;margin-top:" + this.marginTop), 
        this.render();
    }
});

// lib\mochi\source\ListHeader.js
enyo.kind({
    name: "mochi.ListHeader",
    classes: "mochi-list-header"
});

// lib\mochi\source\Collapsable.js
enyo.kind({
    name: "mochi.CollapsableHeader",
    classes: "mochi-collapsable-header"
}), enyo.kind({
    name: "mochi.CollapsableItem",
    classes: "mochi-collapsable-item"
}), enyo.kind({
    name: "mochi.CollapsableFooter",
    classes: "mochi-collapsable-footer"
});

// lib\mochi\source\Header.js
enyo.kind({
    name: "mochi.Header",
    classes: "mochi-header",
    published: {
        customClasses: ""
    },
    tools: [ {
        name: "headerContent",
        classes: "mochi-header-content"
    }, {
        name: "client",
        classes: "mochi-header-controls"
    } ],
    initComponents: function() {
        this.createChrome(this.tools), this.inherited(arguments);
    },
    minContentWidth: 80,
    customClassesChanged: function(t) {
        this.$.headerContent.removeClass(t), this.$.headerContent.addClass(this.customClasses);
    },
    contentChanged: function() {
        this.$.headerContent.setContent(this.content);
    },
    rendered: function() {
        this.inherited(arguments), this.customClassesChanged(), this.adjustControls(), this.adjustContent();
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustContent();
    },
    adjustControls: function() {
        var t = this.getClientControls(), e = t.length;
        e > 0 && this.$.client.addClass("mochi-header-controls-first");
    },
    adjustContent: function() {
        var t = this.hasNode() ? enyo.dom.calcPaddingExtents(this.node) : {}, e = t.left + t.right, i = this.getClientControls(), n = i.length;
        if (0 === n) var o = this.getBounds().width - e; else {
            var s = this.$.client.getBounds().width, o = Math.max(this.minContentWidth, this.getBounds().width - s - e);
            this.$.headerContent.applyStyle("max-width", o + "px");
        }
        this.$.headerContent.applyStyle("width", o + "px");
    }
});

// lib\mochi\source\Subheader.js
enyo.kind({
    name: "mochi.Subheader",
    classes: "mochi-subheader",
    components: [ {
        name: "subheaderContent",
        classes: "mochi-subheader-content"
    } ],
    contentChanged: function() {
        this.$.subheaderContent.setContent(this.content);
    },
    resizeHandler: function() {
        this.inherited(arguments), this.adjustContent();
    },
    adjustContent: function() {
        var t = this.hasNode() ? enyo.dom.calcPaddingExtents(this.node) : {}, e = t.left + t.right, i = this.getBounds().width - e;
        this.$.subheaderContent.applyStyle("max-width", i + "px");
    }
});

// lib\mochi\source\Panels.js
enyo.kind({
    name: "mochi.Panels",
    kind: "enyo.Panels",
    classes: "mochi-panels mochi-base-panel",
    arrangerKind: "DockRightArranger",
    basePanel: !0,
    overlap: 45,
    layoutWidth: 800
});

// lib\mochi\source\GridList.js


// lib\moonstone\version.js
enyo && enyo.version && (enyo.version.moonstone = "2.5.0-pre.1");

// lib\moonstone\source\moon-ilib.js
(function() {
    window.moon = window.moon || {}, moon.$L = window.ilib ? function() {
        var t = function(t) {
            if (!moon.$L.rb) return t;
            var e = moon.$L.rb.getString(t);
            return "" + e;
        };
        return t.rb = new ilib.ResBundle({
            loadParams: {
                root: "$lib/moonstone/resources"
            }
        }), t;
    }() : $L || function(t) {
        return t;
    };
})();

// lib\moonstone\source\moon-fonts.js
(function() {
    if (window.ilib) {
        var t = enyo.updateLocale, e = null;
        e = function() {
            var t = new ilib.Locale(), e = t.getLanguage(), i = t.getRegion(), n = "enyo-localization-font-override", o = document.getElementById(n), s = "", a = {
                NonLatin: {
                    regular: "LG Display-Light",
                    bold: "LG Display-Regular"
                },
                ja: {
                    regular: "LG Display_JP",
                    unicodeRanges: "U+0000-U+00FF, U+2E80-U+2EFF,U+2F00-U+2FDF,U+3000-U+303F,U+3040-U+309F,U+30A0-U+30FF,U+3200-U+33FF,U+3400-U+4DBF,U+4E00-U+9FFF,U+E000-U+FAFF,U+FF00-U+FFEF"
                },
                ur: {
                    regular: "LG Display_Urdu",
                    unicodeRanges: "U+0600-U+06FF, U+FE70-U+FEFE, U+FB50-U+FDFF"
                },
                "zh-HK": {
                    regular: "LG Display GP4_HK-Light",
                    bold: "LG Display GP4_HK-Regular",
                    unicodeRanges: "U+0000-U+00FF,U+2E80-U+2EFF,U+3000-U+303F,U+3200-U+33FF,U+3400-U+4DBF,U+4E00-U+9FFF,U+E000-U+FAFF,U+FF00-U+FFEF"
                }
            };
            a["zh-TW"] = a["zh-HK"], this.buildFont = function(t) {
                if (!t && !t.name) return "";
                var e = '@font-face { \n  font-family: "' + t.name + '";\n' + "  font-weight: " + (t.weight || "normal") + ";\n";
                return t.localName && (e += '  src: local("' + t.localName + '");\n'), t.unicodeRanges && (e += "  unicode-range: " + t.unicodeRanges + ";\n"), 
                e += "} \n";
            }, this.buildFontSet = function(t, e) {
                var i = "", n = e ? "" : " " + t;
                return a[t].regular && (i += this.buildFont({
                    name: "Moonstone LG Display" + n,
                    localName: a[t].regular,
                    unicodeRanges: a[t].unicodeRanges
                }), i += this.buildFont({
                    name: "Moonstone LG Display" + n + " Bold",
                    localName: a[t].bold || a[t].regular,
                    unicodeRanges: a[t].unicodeRanges
                }), i += this.buildFont({
                    name: "Moonstone LG Display" + n + " Light",
                    localName: a[t].light || a[t].regular,
                    unicodeRanges: a[t].unicodeRanges
                })), i;
            }, o || (o = document.createElement("style"), o.setAttribute("id", n), 8 === enyo.platform.ie ? document.getElementsByTagName("head")[0].appendChild(o) : document.head.appendChild(o));
            for (var r in a) s += this.buildFontSet(r);
            "ja" === e ? s += this.buildFontSet("ja", !0) : "ur" === e ? s += this.buildFontSet("ur", !0) : "zh" === e && "HK" === i ? s += this.buildFontSet("zh-HK", !0) : "zh" === e && "TW" === i && (s += this.buildFontSet("zh-TW", !0)), 
            8 !== enyo.platform.ie && (o.innerHTML = s);
        }, enyo.updateLocale = function() {
            t.apply(this, arguments), e();
        }, e();
    }
})();

// lib\moonstone\source\BodyText.js
enyo.kind({
    name: "moon.BodyText",
    classes: "moon-body-text moon-body-text-spacing moon-body-text-control",
    allowHtml: !0,
    published: {
        centered: !1
    },
    create: function() {
        this.inherited(arguments), this.centeredChanged();
    },
    contentChanged: function() {
        this.inherited(arguments), this.detectTextDirectionality(), this.bubble("onRequestSetupBounds");
    },
    centeredChanged: function() {
        this.applyStyle("text-align", this.centered ? "center" : null);
    }
});

// lib\moonstone\source\Marquee.js
moon.MarqueeSupport = {
    name: "MarqueeSupport",
    _marquee_Handlers: {
        onRequestStartMarquee: "_marquee_requestStartMarquee",
        onSpotlightFocus: "_marquee_spotlightFocus",
        onSpotlightBlur: "_marquee_spotlightBlur",
        onenter: "_marquee_enter",
        onleave: "_marquee_leave",
        onMarqueeEnded: "_marquee_marqueeEnded",
        onresize: "_marquee_resize",
        onRequestMarquee: "_marquee_stopPropagation",
        onRequestMarqueeStart: "_marquee_stopPropagation",
        onRequestMarqueeStop: "_marquee_stopPropagation"
    },
    _marquee_active: !1,
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.marqueeOnSpotlight = void 0 === this.marqueeOnSpotlight ? !0 : this.marqueeOnSpotlight, 
            this.marqueeOnHover = void 0 === this.marqueeOnHover ? !1 : this.marqueeOnHover, 
            this.marqueeSpeed = void 0 === this.marqueeSpeed ? 60 : this.marqueeSpeed, this.marqueeDelay = void 0 === this.marqueeDelay ? 1e3 : this.marqueeDelay, 
            this.marqueePause = void 0 === this.marqueePause ? 1e3 : this.marqueePause, this.marqueeHold = void 0 === this.marqueeHold ? 2e3 : this.marqueeHold, 
            this.marqueeOnRender = void 0 === this.marqueeOnRender ? !1 : this.marqueeOnRender, 
            this.marqueeOnRenderDelay = void 0 === this.marqueeOnRenderDelay ? this.marqueeDelay : this.marqueeOnRenderDelay;
        };
    }),
    rendered: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.marqueeOnRender && this.startMarqueeCustomDelay(this.marqueeOnRenderDelay);
        };
    }),
    dispatchEvent: enyo.inherit(function(t) {
        return function(e, i, n) {
            if (this.strictlyInternalEvents[e] && this.isInternalEvent(i)) return !0;
            if (i && !i.delegate) {
                var o = this._marquee_Handlers[e];
                if (o && this[o](n, i)) return !0;
            }
            return t.apply(this, arguments);
        };
    }),
    _marquee_requestStartMarquee: function() {
        return this.marqueeOnRender ? (this.stopMarquee(), this.startMarquee(), !0) : void 0;
    },
    _marquee_spotlightFocus: function() {
        this._marquee_isFocused = !0, this.marqueeOnSpotlight && this.startMarquee();
    },
    _marquee_spotlightBlur: function() {
        this._marquee_isFocused = !1, this.marqueeOnSpotlight && this.stopMarquee();
    },
    _marquee_enter: function() {
        this._marquee_isHovered = !0, this.marqueeOnHover && !this.marqueeOnSpotlight && this.startMarquee();
    },
    _marquee_leave: function() {
        this._marquee_isHovered = !1, this.marqueeOnHover && !this.marqueeOnSpotlight && this.stopMarquee();
    },
    _marquee_stopPropagation: function(t, e) {
        return e.originator != this ? !0 : void 0;
    },
    _marquee_marqueeEnded: function(t, e) {
        return this._marquee_active && (enyo.remove(e.originator, this.marqueeWaitList), 
        0 === this.marqueeWaitList.length && (this._marquee_startHold(), this._marquee_active = !1)), 
        !0;
    },
    _marquee_resize: function() {
        this.marqueeOnSpotlight && this._marquee_active && (this._marquee_active = !1, this._marquee_startHold());
    },
    startMarquee: function() {
        this.startMarqueeCustomDelay(this.marqueeDelay);
    },
    stopMarquee: function() {
        this.stopJob("marqueeSupportJob"), this.stopJob("resetMarquee"), this._marquee_active = !1, 
        this._marquee_stopChildMarquees();
    },
    enableMarquee: function() {
        this._marquee_enableChildMarquees();
    },
    disableMarquee: function() {
        this.stopMarquee(), this._marquee_disableChildMarquees();
    },
    addMarqueeItem: function(t) {
        this.marqueeWaitList.push(t);
    },
    resetMarquee: function() {
        (this.marqueeOnSpotlight && this._marquee_isFocused || this.marqueeOnHover && this._marquee_isHovered || this.marqueeOnRender) && this.startJob("resetMarquee", "_resetMarquee", 10);
    },
    startMarqueeCustomDelay: function(t) {
        this._marquee_buildWaitList(), 0 !== this.marqueeWaitList.length && (this._marquee_active = !0, 
        this.startJob("marqueeSupportJob", "_marquee_startChildMarquees", t));
    },
    _resetMarquee: function() {
        this.stopMarquee(), this.marqueeOnRender ? this.startMarqueeCustomDelay(this.marqueeOnRenderDelay) : this.startMarquee();
    },
    _marquee_buildWaitList: function() {
        this.marqueeWaitList = [], this.waterfall("onRequestMarquee", {
            originator: this,
            marqueePause: this.marqueePause,
            marqueeSpeed: this.marqueeSpeed
        });
    },
    _marquee_startChildMarquees: function() {
        this.waterfall("onRequestMarqueeStart", {
            originator: this
        });
    },
    _marquee_stopChildMarquees: function() {
        this.waterfall("onRequestMarqueeStop", {
            originator: this
        });
    },
    _marquee_enableChildMarquees: function() {
        this.waterfall("onRequestMarqueeEnable");
    },
    _marquee_disableChildMarquees: function() {
        this.waterfall("onRequestMarqueeDisable");
    },
    _marquee_startHold: function() {
        this.startJob("marqueeSupportJob", "startMarquee", this.marqueeHold);
    }
}, moon.MarqueeItem = {
    events: {
        onMarqueeEnded: ""
    },
    _marqueeItem_Handlers: {
        onRequestMarquee: "_marquee_requestMarquee",
        onRequestMarqueeStart: "_marquee_startAnimation",
        onRequestMarqueeStop: "_marquee_stopAnimation",
        onRequestMarqueeEnable: "_marquee_enable",
        onRequestMarqueeDisable: "_marquee_disable",
        ontransitionend: "_marquee_animationEnded"
    },
    observers: {
        _marquee_contentChanged: [ "content" ],
        _marquee_centeredChanged: [ "centered" ]
    },
    bindings: [ {
        from: ".allowHtml",
        to: ".$.marqueeText.allowHtml"
    } ],
    classes: "moon-marquee",
    dispatchEvent: enyo.inherit(function(t) {
        return function(e, i, n) {
            if (t.apply(this, arguments)) return !0;
            if (i && !i.delegate) {
                var o = this._marqueeItem_Handlers[e];
                if (o && this[o](n, i)) return !0;
            }
        };
    }),
    _marquee_enabled: !0,
    _marquee_distance: null,
    _marquee_fits: null,
    _marquee_puppetMaster: null,
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.detectTextDirectionality(), this._marquee_centeredChanged();
        };
    }),
    reflow: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this._marquee_invalidateMetrics();
        };
    }),
    showingChangedHandler: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this._marquee_reset();
        };
    }),
    _marquee_invalidateMetrics: function() {
        this._marquee_distance = null, this._marquee_fits = null;
    },
    _marquee_contentChanged: function() {
        this.detectTextDirectionality(), this.$.marqueeText && this.$.marqueeText.setContent(this.content), 
        this._marquee_reset();
    },
    _marquee_requestMarquee: function(t, e) {
        e && !this.disabled && this.showing && this._marquee_enabled && !this._marquee_fits && (this._marquee_puppetMaster = e.originator, 
        e.originator.addMarqueeItem(this), this.marqueePause = e.marqueePause || 1e3, this.marqueeSpeed = e.marqueeSpeed || 60);
    },
    _marquee_startAnimation: function() {
        var t = this._marquee_calcDistance();
        return this._marquee_shouldAnimate(t) ? (this.$.marqueeText || this._marquee_createMarquee(), 
        this._marquee_addAnimationStyles(t), !0) : (this._marquee_fits = !0, this.doMarqueeEnded(), 
        void 0);
    },
    _marquee_enable: function() {
        this.set("_marquee_enabled", !0);
    },
    _marquee_disable: function() {
        this.set("_marquee_enabled", !1), this._marquee_stopAnimation();
    },
    _marquee_stopAnimation: function() {
        this.stopJob("stopMarquee"), this._marquee_removeAnimationStyles(), this.doMarqueeEnded();
    },
    _marquee_animationEnded: function(t, e) {
        return e.originator === this.$.marqueeText ? (this.startJob("stopMarquee", "_marquee_stopAnimation", this.marqueePause), 
        !0) : void 0;
    },
    _marquee_shouldAnimate: function(t) {
        return t = t && t >= 0 ? t : this._marquee_calcDistance(), t > 0;
    },
    _marquee_calcDistance: function() {
        if (null !== this._marquee_distance) return this._marquee_distance;
        var t = this.$.marqueeText ? this.$.marqueeText.hasNode() : this.hasNode();
        return this._marquee_distance = Math.abs(t.scrollWidth - t.clientWidth), this._marquee_distance;
    },
    _marquee_calcDuration: function(t) {
        return t / this.marqueeSpeed;
    },
    _marquee_createMarquee: function() {
        return this.createComponent({
            name: "marqueeTextWrapper",
            classes: "moon-marquee-text-wrapper",
            components: [ {
                name: "marqueeText",
                classes: "moon-marquee-text",
                allowHtml: this.allowHtml,
                content: this.content
            } ]
        }), this.render(), !0;
    },
    _marquee_addAnimationStyles: function(t) {
        var e = this._marquee_calcDuration(t);
        this.$.marqueeText.addClass("animate-marquee"), this.$.marqueeText.applyStyle("transition-duration", e + "s"), 
        this.$.marqueeText.applyStyle("-webkit-transition-duration", e + "s"), enyo.dom.transform(this.$.marqueeText, {
            translateZ: 0
        }), setTimeout(this.bindSafely(function() {
            enyo.dom.transform(this.$.marqueeText, {
                translateX: this._marquee_adjustDistanceForRTL(t) + "px"
            });
        }), enyo.platform.firefox ? 100 : 0);
    },
    _marquee_removeAnimationStyles: function() {
        this.$.marqueeText && (this.$.marqueeText.applyStyle("transition-duration", "0s"), 
        this.$.marqueeText.applyStyle("-webkit-transition-duration", "0s"), setTimeout(this.bindSafely(function() {
            this.$.marqueeText.removeClass("animate-marquee"), enyo.dom.transform(this.$.marqueeText, {
                translateX: null
            }), enyo.dom.transform(this.$.marqueeText, {
                translateZ: null
            });
        }), enyo.platform.firefox ? 100 : 0));
    },
    _marquee_adjustDistanceForRTL: function(t) {
        return this.rtl ? t : -1 * t;
    },
    _marquee_reset: function() {
        this._marquee_invalidateMetrics(), this._marquee_puppetMaster && this._marquee_puppetMaster.resetMarquee();
    },
    _marquee_centeredChanged: function() {
        this.applyStyle("text-align", this.centered ? "center" : null);
    }
}, enyo.kind({
    name: "moon.MarqueeText",
    mixins: [ "moon.MarqueeItem" ],
    published: {
        marqueeSpeed: 60,
        marqueePause: 1e3,
        disabled: !1,
        centered: !1
    }
}), enyo.kind({
    name: "moon.MarqueeDecorator",
    mixins: [ "moon.MarqueeSupport" ],
    style: "overflow: hidden;"
});

// lib\moonstone\source\Button.js
enyo.kind({
    name: "moon.Button",
    kind: "enyo.Button",
    mixins: [ "moon.MarqueeSupport" ],
    published: {
        small: !1,
        minWidth: !0,
        contentUpperCase: !0
    },
    classes: "moon-large-button-text moon-button enyo-unselectable",
    spotlight: !0,
    handlers: {
        onSpotlightSelect: "depress",
        onSpotlightKeyUp: "undepress",
        onSpotlightBlur: "undepress",
        onSpotlightFocused: "spotFocused"
    },
    initComponents: function() {
        this.components && this.components.length > 0 || this.createComponent({
            name: "client",
            kind: "moon.MarqueeText",
            isChrome: !0
        }), this.smallChanged(), this.minWidthChanged(), this.inherited(arguments);
    },
    depress: function() {
        this.addClass("pressed");
    },
    spotFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    },
    undepress: function() {
        this.removeClass("pressed");
    },
    smallChanged: function() {
        if (this.$.tapArea && this.$.tapArea.destroy(), this.small) {
            this.addClass("small"), this.addClass("moon-small-button-text");
            var t = this.createComponent({
                name: "tapArea",
                classes: "small-button-tap-area",
                isChrome: !0
            });
            this.generated && t.render();
        } else this.removeClass("small"), this.removeClass("moon-small-button-text");
        this.contentChanged();
    },
    contentChanged: function() {
        var t = this.getContent();
        this.$.client ? this.$.client.setContent(this.getContentUpperCase() ? enyo.toUpperCase(t) : t) : this.inherited(arguments);
    },
    contentUpperCaseChanged: function() {
        this.contentChanged();
    },
    minWidthChanged: function() {
        this.minWidth ? this.addClass("min-width") : this.removeClass("min-width");
    },
    showingChanged: function() {
        this.inherited(arguments), !this.showing && this.hasClass("pressed") && this.undepress();
    }
});

// lib\moonstone\source\Calendar.js
enyo.kind({
    name: "moon.CalendarDate",
    kind: "moon.Button",
    published: {
        value: null,
        color: 0
    },
    events: {
        onDateSelected: ""
    },
    small: !0,
    marquee: !1,
    minWidth: !1,
    classes: "moon-calendar-picker-date enyo-unselectable",
    create: function() {
        this.inherited(arguments), "undefined" != typeof ilib && (this._tf = new ilib.DateFmt({
            type: "date",
            date: "d",
            useNative: !1,
            length: "short"
        }));
    },
    colorChanged: function() {
        this.addRemoveClass("moon-calendar-picker-date-shadow", this.color);
    },
    valueChanged: function() {
        if ("undefined" != typeof ilib) {
            var t = ilib.Date.newInstance({
                unixtime: this.value.getTime(),
                timezone: "local"
            });
            this.setContent(this._tf.format(t));
        } else this.setContent(this.value.getDate());
    },
    tap: function() {
        this.doDateSelected();
    }
}), enyo.kind({
    name: "moon.Calendar",
    published: {
        locale: "",
        value: null,
        firstDayOfWeek: 0,
        maxWeeks: 6,
        startYear: 1900,
        endYear: 2200,
        dayOfWeekClasses: "",
        dayOfWeekLength: "short"
    },
    events: {
        onChange: ""
    },
    months: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ],
    days: [ "S", "M", "T", "W", "T", "F", "S" ],
    classes: "moon-calendar-picker",
    components: [ {
        name: "monthPicker",
        kind: "moon.SimplePicker",
        classes: "moon-calendar-picker-month",
        onChange: "selectMonthPicker"
    }, {
        name: "yearPicker",
        kind: "moon.SimplePicker",
        classes: "moon-calendar-picker-year",
        onChange: "selectYearPicker"
    }, {
        name: "days",
        classes: "moon-calendar-picker-days moon-neutral",
        kind: "enyo.Group"
    }, {
        name: "dates",
        kind: "enyo.Group"
    } ],
    create: function() {
        this.inherited(arguments), this.initCalendar(), this.set("value", this.value || new Date(), !0), 
        "undefined" != typeof ilib && (this._tf = new ilib.DateFmt({
            type: "date",
            date: "w",
            useNative: !1,
            length: this.dayOfWeekLength
        }), this.setLocale(new ilib.LocaleInfo().locale));
    },
    initCalendar: function() {
        var t, e = this.getStartYear(), i = this.getEndYear();
        for (t = e; i >= t; t++) this.$.yearPicker.createComponent({
            content: t,
            classes: "picker-content"
        });
        var n = this.months;
        for (t = 0; 12 > t; t++) this.$.monthPicker.createComponent({
            content: n[t],
            classes: "picker-content"
        });
        for (t = 0; 7 > t; t++) this.$.days.createComponent({
            content: this.days[t],
            classes: "moon-calendar-picker-day-base " + (this.dayOfWeekClasses || "moon-calendar-picker-day"),
            disabled: !0
        });
        if (!this.$.dates.controls.length) for (t = 1; 7 * this.maxWeeks >= t; t++) this.$.dates.createComponent({
            kind: "moon.CalendarDate",
            onDateSelected: "selectDate"
        }, {
            owner: this
        });
    },
    localeChanged: function() {
        if ("undefined" != typeof ilib) {
            var t = this._tf.getCalendar();
            this._tf = new ilib.DateFmt({
                locale: this.locale,
                type: "date",
                date: "w",
                useNative: !1,
                length: this.dayOfWeekLength
            }), t !== this._tf.getCalendar() && this.calendarChanged(), this.firstDayOfWeek = -1, 
            this.setFirstDayOfWeek(new ilib.LocaleInfo(this.locale).getFirstDayOfWeek());
        }
        this.updateMonthPicker(), this.doChange({
            value: this.value
        });
    },
    firstDayOfWeekChanged: function() {
        this.updateDays(), this.updateDates();
    },
    setValue: function(t) {
        this.set("value", t);
    },
    set: enyo.inherit(function(t) {
        return function(e, i) {
            "value" == e && (isNaN(i) || null === i) && (i = new Date()), t.apply(this, arguments);
        };
    }),
    valueChanged: function() {
        this.generated && this.$.monthPicker.getSelectedIndex() == this.value.getMonth() || this.$.monthPicker.setSelectedIndex(this.value.getMonth()), 
        this.generated && this.$.yearPicker.getSelected().getContent() == this.value.getFullYear() || this.$.yearPicker.setSelectedIndex(this.value.getFullYear() - this.startYear), 
        this.updateDates(), this.value && this.doChange({
            value: this.value
        });
    },
    updateYearPicker: function(t) {
        var e = t - this.value.getFullYear();
        this.setStartYear(this.getStartYear() + e), this.setEndYear(this.getEndYear() + e);
        for (var i = this.$.yearPicker.getClientControls(), n = this.getStartYear(), s = this.getEndYear(), o = 0; s - n > o; o++) i[o].setContent(o + n);
        this.setYear(t);
    },
    updateMonthPicker: function() {
        if ("undefined" != typeof ilib) for (var t = new ilib.DateFmt({
            locale: this.locale,
            type: "date",
            date: "m",
            useNative: !1,
            length: "long"
        }), e = this.$.monthPicker.getClientControls(), i = 0; 12 > i; i++) {
            var n = ilib.Date.newInstance({
                type: t.getCalendar(),
                month: i + 1,
                day: 15
            });
            e[i].setContent(t.format(n));
        }
    },
    updateDays: function() {
        for (var t = this.$.days.getClientControls(), e = 0; 7 > e; e++) if ("undefined" != typeof ilib) {
            var i = ilib.Date.newInstance({
                type: this._tf.getCalendar(),
                day: 2 + e + this.getFirstDayOfWeek()
            }), n = this._tf.format(i);
            t[e].setContent(enyo.toUpperCase(n));
        } else t[e].setContent(this.days[(this.firstDayOfWeek + e) % 7]);
    },
    updatePrevMonth: function() {
        var t = this.value, e = new Date(t.getFullYear(), t.getMonth(), t.getDate());
        e.setDate(0);
        var i = e.getFullYear(), n = e.getDate(), s = e.getDay() - this.firstDayOfWeek, o = e.getMonth();
        if (0 > s && (s += 7), 6 !== s) {
            for (var a = this.$.dates.getControls(), r = 0; s >= r; r++) a[r].setValue(new Date(i, o, n - s + r)), 
            a[r].setColor(1);
            return r;
        }
        return 0;
    },
    updateNextMonth: function(t) {
        var e = this.value, i = new Date(e.getFullYear(), e.getMonth(), e.getDate());
        i.setMonth(i.getMonth() + 1);
        for (var n = i.getFullYear(), s = i.getMonth(), o = this.$.dates.getControls(), a = 0; this.$.dates.controls.length - t > a; a++) o[t + a].setValue(new Date(n, s, a + 1)), 
        o[t + a].setColor(1);
    },
    updateDates: function() {
        for (var t = this.updatePrevMonth(), e = this.value.getFullYear(), i = this.value.getMonth(), n = this.getMonthLength(e, i), s = this.$.dates.getControls(), o = 0; n > o; o++) s[t + o].setValue(new Date(e, i, o + 1)), 
        s[t + o].setColor(0);
        this.$.dates.setActive(s[t - 1 + this.value.getDate()]), this.updateNextMonth(t + n);
    },
    setYear: function(t) {
        if (this.value.getYear() != t) {
            var e, i = this.value, n = this.getMonthLength(t, i.getMonth());
            e = i.getDate() > n ? new Date(t, i.getMonth(), n) : new Date(t, i.getMonth(), i.getDate()), 
            this.setValue(e);
        }
    },
    setMonth: function(t) {
        if (this.value.getMonth() != t) {
            var e, i = this.value, n = this.getMonthLength(i.getFullYear(), t);
            e = i.getDate() > n ? new Date(i.getFullYear(), t, n) : new Date(i.getFullYear(), t, i.getDate()), 
            this.setValue(e);
        }
    },
    setDate: function(t) {
        var e, i = this.value, n = this.getMonthLength(i.getFullYear(), i.getMonth());
        e = t > n ? new Date(i.getFullYear(), i.getMonth(), n) : new Date(i.getFullYear(), i.getMonth(), t), 
        this.setValue(e);
    },
    selectDate: function(t, e) {
        var i = e.originator.value;
        return this.setValue(i), !0;
    },
    selectYearPicker: function() {
        var t = this.$.yearPicker.getSelected().getContent();
        this.setYear(t);
    },
    selectMonthPicker: function() {
        var t = this.$.monthPicker.getSelectedIndex();
        this.setMonth(t);
    },
    getMonthLength: function(t, e) {
        if ("undefined" != typeof ilib) {
            var i = ilib.Cal.newInstance();
            return i.getMonLength(e + 1, t);
        }
        return 32 - new Date(t, e, 32).getDate();
    },
    calendarChanged: function() {
        var t = new ilib.DateFmt({
            locale: this.locale,
            type: "date",
            date: "y",
            useNative: !1,
            length: "long"
        }), e = ilib.Date.newInstance({
            type: t.getCalendar()
        }), i = parseInt(t.format(e), 10);
        i !== this.value.getFullYear() && this.updateYearPicker(i);
    },
    dayOfWeekClassesChanged: function(t) {
        for (var e = this.$.days.getClientControls(), i = 0; e.length > i; i++) e[i].removeClass(t || "moon-calendar-picker-day"), 
        e[i].addClass(this.dayOfWeekClasses || "moon-calendar-picker-day");
    },
    dayOfWeekLengthChanged: function() {
        "undefined" != typeof ilib && (this._tf = new ilib.DateFmt({
            locale: this.locale,
            type: "date",
            date: "w",
            useNative: !1,
            length: this.dayOfWeekLength
        }), this.updateDays());
    }
});

// lib\moonstone\source\CaptionDecorator.js
enyo.kind({
    name: "moon.CaptionDecorator",
    handlers: {
        onSpotlightFocus: "spotFocus",
        onSpotlightBlur: "spotBlur"
    },
    published: {
        side: "top",
        showOnFocus: !1
    },
    captionPositioned: !1,
    clientBounds: null,
    captionBounds: null,
    decoratorBounds: null,
    classes: "moon-button-caption-decorator",
    components: [ {
        kind: "enyo.Control",
        name: "leftCaption",
        classes: "moon-divider-text moon-caption left",
        canGenerate: !1
    }, {
        kind: "enyo.Control",
        name: "topCaption",
        classes: "moon-divider-text moon-caption top",
        canGenerate: !1
    }, {
        kind: "enyo.Control",
        name: "client",
        classes: "moon-divider-text moon-caption-client"
    }, {
        kind: "enyo.Control",
        name: "rightCaption",
        classes: "moon-divider-text moon-caption right",
        canGenerate: !1
    }, {
        kind: "enyo.Control",
        name: "bottomCaption",
        classes: "moon-divider-text moon-caption bottom",
        canGenerate: !1
    } ],
    create: function() {
        this.inherited(arguments), this.sideChanged(), this.showOnFocusChanged();
    },
    reflow: function() {
        this.inherited(arguments), this.getShowOnFocus() && this.resetCaptionPosition();
    },
    getSide: function() {
        return this.side || "top";
    },
    sideChanged: function() {
        var t = this.getSide();
        this.$.topCaption.canGenerate = "top" === t, this.$.rightCaption.canGenerate = "right" === t, 
        this.$.bottomCaption.canGenerate = "bottom" === t, this.$.leftCaption.canGenerate = "left" === t, 
        this.contentChanged(), this.hasNode() && this.render();
    },
    showOnFocusChanged: function() {
        this.addRemoveClass("showOnFocus", this.getShowOnFocus()), this.hasNode() && this.getShowOnFocus() && this.resetCaptionPosition();
    },
    contentChanged: function() {
        this.$[this.getSide() + "Caption"].setContent(this.getContent()), this.hasNode() && this.getShowOnFocus() && this.resetCaptionPosition();
    },
    spotFocus: function() {
        this.addClass("spotlight"), this.hasNode() && this.getShowOnFocus() && this.positionCaption();
    },
    spotBlur: function() {
        this.removeClass("spotlight");
    },
    getCaptionControl: function() {
        return this.$[this.getSide() + "Caption"];
    },
    resetCaptionPosition: function() {
        this.resetCachedBounds(), this.captionPositioned = !1, this.hasNode() && this.hasClass("spotlight") && this.positionCaption();
    },
    positionCaption: function() {
        if (!this.captionPositioned) {
            var t = this.getDecoratorBounds(), e = this.getClientBounds(), i = this.getCaptionBounds();
            switch (this.getSide()) {
              case "left":
                this.centerCaptionVertically(t, i), this.positionCaptionAtLeftEdge(t, e, i);
                break;

              case "right":
                this.centerCaptionVertically(t, i), this.positionCaptionAtRightEdge(t, e, i);
                break;

              case "top":
                this.centerCaptionHorizontally(t, i), this.positionCaptionAtTopEdge(t, e, i);
                break;

              case "bottom":
                this.centerCaptionHorizontally(t, i), this.positionCaptionAtBottomEdge(t, e, i);
            }
            this.captionPositioned = !0;
        }
    },
    centerCaptionVertically: function(t, e) {
        this.getCaptionControl().applyStyle("top", (t.height - e.height) / 2 + "px");
    },
    centerCaptionHorizontally: function(t, e) {
        this.getCaptionControl().applyStyle("left", (t.width - e.width) / 2 + "px");
    },
    positionCaptionAtLeftEdge: function(t, e, i) {
        var n = -1 * i.width + (t.width - e.width) / 2 - i.marginRight;
        this.getCaptionControl().applyStyle("left", n + "px");
    },
    positionCaptionAtRightEdge: function(t, e) {
        var i = t.width - (t.width - e.width) / 2;
        this.getCaptionControl().applyStyle("left", i + "px");
    },
    positionCaptionAtTopEdge: function(t, e, i) {
        var n = -1 * this.getCaptionBounds().height + (t.height - e.height) / 2 - i.marginBottom;
        this.getCaptionControl().applyStyle("top", n + "px");
    },
    positionCaptionAtBottomEdge: function(t, e) {
        var i = t.height - (t.height - e.height) / 2;
        this.getCaptionControl().applyStyle("top", i + "px");
    },
    getDecoratorBounds: function() {
        return this.decoratorBounds = this.decoratorBounds || this.getBounds(), this.decoratorBounds;
    },
    getCaptionBounds: function() {
        return this.captionBounds = this.captionBounds || enyo.mixin(this.getCaptionControl().getBounds(), this.getCaptionMarginBounds()), 
        this.captionBounds;
    },
    getClientBounds: function() {
        return this.clientBounds = this.clientBounds || this.$.client.getBounds(), this.clientBounds;
    },
    resetCachedBounds: function() {
        this.clientBounds = null, this.captionBounds = null, this.decoratorBounds = null;
    },
    getCaptionMarginBounds: function() {
        var t = enyo.dom.calcMarginExtents(this.getCaptionControl().hasNode());
        return {
            marginTop: t.top,
            marginRight: t.right,
            marginBottom: t.bottom,
            marginLeft: t.left
        };
    }
});

// lib\moonstone\source\Item.js
enyo.kind({
    name: "moon.Item",
    classes: "moon-item",
    mixins: [ "moon.MarqueeSupport", "moon.MarqueeItem" ],
    spotlight: !0,
    handlers: {
        onSpotlightFocused: "spotlightFocused"
    },
    published: {
        disabled: !1
    },
    create: function() {
        this.inherited(arguments), this.disabledChanged(), this.children.length && this.addClass("allow-wrap");
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    spotlightFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    }
});

// lib\moonstone\source\SelectableItem.js
enyo.kind({
    name: "moon.SelectableItem",
    kind: "moon.Item",
    classes: "moon-selectable-item",
    events: {
        onActivate: ""
    },
    handlers: {
        onclick: ""
    },
    published: {
        selected: !1,
        active: !1
    },
    components: [ {
        name: "indicator",
        classes: "moon-selectable-item-indicator"
    }, {
        name: "client",
        kind: "moon.MarqueeText",
        classes: "moon-selectable-item-client"
    } ],
    bindings: [ {
        from: ".allowHtml",
        to: ".$.client.allowHtml"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.contentChanged(), this.updateSelectedValue();
        };
    }),
    rendered: function() {
        this.inherited(arguments), this.updateActiveValue();
    },
    shouldDoTransition: function(t) {
        return t === !0;
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!this.getActive()), this.bubble("onchange"), 
        void 0);
    },
    updateSelectedValue: function() {
        var t = this.getSelected();
        this.addRemoveClass("selected", t), this.setNodeProperty("selected", t), this.setAttribute("selected", t ? "selected" : "");
    },
    updateActiveValue: function() {
        this.setActive(this.getSelected()), this.resetMarquee();
    },
    selectedChanged: function() {
        this.updateSelectedValue(), this.updateActiveValue();
    },
    activeChanged: function() {
        this.active = enyo.isTrue(this.active), this.setSelected(this.active), this.bubble("onActivate");
    },
    contentChanged: function() {
        this.$.client.setContent(this.content);
    }
});

// lib\moonstone\source\Panels.js
enyo.kind({
    name: "moon.Panels",
    kind: "enyo.Panels",
    classes: "moon-panels",
    spotlightDecorate: !1,
    published: {
        pattern: "none",
        autoHideTimeout: 4e3,
        useHandle: "auto",
        handleShowing: !0,
        popOnBack: !1,
        brandingSrc: ""
    },
    narrowFit: !1,
    handlers: {
        ontap: "onTap",
        onSpotlightRight: "spotlightRight",
        onSpotlightLeft: "spotlightLeft",
        onSpotlightUp: "spotlightUp",
        onSpotlightDown: "spotlightDown",
        onSpotlightFocused: "spotlightFocused",
        onSpotlightContainerLeave: "onSpotlightPanelLeave",
        onSpotlightContainerEnter: "onSpotlightPanelEnter",
        onPreTransitionComplete: "preTransitionComplete",
        onPostTransitionComplete: "postTransitionComplete"
    },
    handleTools: [ {
        name: "backgroundScrim",
        kind: "enyo.Control",
        classes: "moon-panels-background-scrim"
    }, {
        name: "clientWrapper",
        kind: "enyo.Control",
        classes: "enyo-fill enyo-arranger moon-panels-client",
        components: [ {
            name: "scrim",
            classes: "moon-panels-panel-scrim"
        }, {
            name: "client",
            tag: null
        } ]
    }, {
        name: "handleWrapper",
        kind: "enyo.Control",
        classes: "moon-panels-handle-wrapper hidden",
        canGenerate: !1,
        ontap: "handleTap",
        onSpotlightLeft: "handleSpotLeft",
        onSpotlightRight: "handleSpotRight",
        onSpotlightFocused: "handleFocused",
        onSpotlightBlur: "handleBlur",
        components: [ {
            name: "showHideHandle",
            kind: "enyo.Control",
            classes: "moon-panels-handle"
        } ]
    }, {
        name: "showHideAnimator",
        kind: "enyo.StyleAnimator",
        onComplete: "animationComplete"
    } ],
    defaultKind: "moon.Panel",
    draggable: !1,
    panelCoverRatio: 1,
    showFirstBreadcrumb: !1,
    arrangerKind: "moon.BreadcrumbArranger",
    queuedIndex: null,
    _initialTransition: !0,
    transitionInProgress: !1,
    isModifyingPanels: !1,
    inTransition: function() {
        return this.transitionInProgress;
    },
    pushPanel: function(t, e) {
        if (this.transitionInProgress || this.isModifyingPanels) return null;
        this.isModifyingPanels = !0;
        var i = this.getPanels().length - 1, n = this.createComponent(t, e);
        return n.render(), this.reflow(), n.resized(), this.setIndex(i + 1), this.isModifyingPanels = !1, 
        n;
    },
    pushPanels: function(t, e) {
        if (this.transitionInProgress || this.isModifyingPanels) return null;
        this.isModifyingPanels = !0;
        var i, n = this.getPanels().length - 1, s = this.createComponents(t, e);
        for (i = 0; s.length > i; ++i) s[i].render();
        for (this.reflow(), i = 0; s.length > i; ++i) s[i].resized();
        return this.setIndex(n + 1), this.isModifyingPanels = !1, s;
    },
    popPanels: function(t) {
        if (!this.transitionInProgress && !this.isModifyingPanels) {
            this.isModifyingPanels = !0;
            var e = this.getPanels();
            for (t = t || e.length - 1; e.length > t && t >= 0; ) e[e.length - 1].destroy();
            this.isModifyingPanels = !1;
        }
    },
    replacePanel: function(t, e, i) {
        if (!this.transitionInProgress && !this.isModifyingPanels) {
            this.isModifyingPanels = !0;
            var n = null;
            this.getPanels().length > t && (this.getPanels()[t].destroy(), this.getPanels().length > t && (i = enyo.mixin({
                addBefore: this.getPanels()[t]
            }, i))), n = this.createComponent(e, i), n.render(), this.resized(), this.isModifyingPanels = !1;
        }
    },
    getPanelIndex: function(t) {
        for (var e = null; t && t.parent; ) {
            if (t.parent === this.$.client || t.parent === this) {
                e = t;
                break;
            }
            t = t.parent;
        }
        if (e) for (var i = 0; this.getPanels().length > i; i++) if (this.getPanels()[i] == e) return i;
        return -1;
    },
    isPanel: function(t) {
        for (var e = 0; this.getPanels().length > e; e++) if (this.getPanels()[e] == t) return !0;
    },
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.showingChanged();
        };
    }),
    initComponents: function() {
        this.applyPattern(), this.inherited(arguments), this.initializeShowHideHandle(), 
        this.handleShowingChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.useHandle === !0 && (this.showing ? this._directShow() : this._directHide());
    },
    onTap: function(t, e) {
        if (e.originator !== this.$.showHideHandle && "none" !== this.pattern && this.transitionInProgress !== !0 && this.isModifyingPanels !== !0) if (this.shouldHide(e)) this.showing && this.useHandle === !0 && this.handleShowing && this.hide(); else {
            var i = e.breadcrumbTap ? this.getPanelIndex(e.originator) : -1;
            i >= 0 && i !== this.getIndex() && this.setIndex(i);
        }
    },
    shouldHide: function(t) {
        return t.originator === this.$.clientWrapper || t.originator instanceof moon.Panel && this.isPanel(t.originator);
    },
    spotlightLeft: function(t, e) {
        var i, n = e.originator;
        if ("breadcrumbBackground" === n.name) return !0;
        if (n instanceof moon.Panel) {
            if (i = this.getPanelIndex(n), 0 !== i) return this.previous(), !0;
            if (this.showing && this.useHandle === !0 && this.handleShowing) return this.hide(), 
            !0;
        }
    },
    spotlightRight: function(t, e) {
        var i = e.originator, n = this.getPanelIndex(i), s = this.getPanels()[n + 1];
        return "breadcrumbBackground" === i.name ? (enyo.Spotlight.spot(s), !0) : s && i instanceof moon.Panel ? (this.useHandle === !0 && this.handleShowing && s.isOffscreen ? enyo.Spotlight.spot(this.$.handleWrapper) : this.next(), 
        !0) : void 0;
    },
    spotlightDown: function(t, e) {
        return "breadcrumbBackground" === e.originator.name ? !0 : void 0;
    },
    spotlightFocused: function(t, e) {
        this.index = this.getPanelIndex(e.originator);
    },
    handleTap: function() {
        this.setShowing(!this.showing);
    },
    handleSpotLeft: function() {
        return this.showing ? enyo.Spotlight.spot(this.getActive()) : enyo.Spotlight.unspot(), 
        !0;
    },
    handleSpotRight: function() {
        return this.showing ? !0 : void 0;
    },
    handleBlur: function() {
        this.isHandleFocused && (this.isHandleFocused = !1, enyo.Spotlight.getPointerMode() || this.showing || enyo.asyncMethod(this, "panelsHiddenAsync")), 
        this.resetHandleAutoHide(), this.showing || enyo.Signals.send("onPanelsHandleBlurred");
    },
    panelsHiddenAsync: function() {
        enyo.Signals.send("onPanelsHidden");
    },
    resetHandleAutoHide: function() {
        this.startJob("autoHide", "stashHandle", this.getAutoHideTimeout());
    },
    stopHandleAutoHide: function() {
        this.stopJob("autoHide");
    },
    stashHandle: function() {
        this.$.showHideHandle.addRemoveClass("stashed", !this.showing);
    },
    unstashHandle: function() {
        this.stopHandleAutoHide(), this.$.showHideHandle.removeClass("stashed");
    },
    handleFocused: function() {
        this.unstashHandle(), this.startJob("autoHide", "handleSpotLeft", this.getAutoHideTimeout()), 
        this.isHandleFocused = !0, enyo.Signals.send("onPanelsHandleFocused");
    },
    handleShowingChanged: function() {
        this.useHandle === !0 && (this.$.handleWrapper.addRemoveClass("hidden", !this.handleShowing), 
        this.$.handleWrapper.spotlight = this.handleShowing);
    },
    onSpotlightPanelEnter: function() {
        return !this.showing && this.useHandle === !0 && this.handleShowing ? (enyo.Spotlight.spot(this.$.handleWrapper), 
        !0) : void 0;
    },
    setIndex: function(t) {
        if ((null === this.toIndex || this.useHandle === !1) && (t = this.clamp(t)), t !== this.index) {
            if (null !== this.toIndex) return this.queuedIndex = t, void 0;
            this.fromIndex = this.index, this.toIndex = t, this.queuedIndex = null, this.blurActiveElementIfHiding(t), 
            this.shouldArrange() ? this.animate ? (this.transitionInProgress = !0, enyo.Spotlight.mute(this), 
            this.triggerPreTransitions()) : this._setIndex(this.toIndex) : this.skipArrangerAnimation();
        }
    },
    blurActiveElementIfHiding: function(t) {
        var e, i, n = document.activeElement, s = n ? enyo.$[n.id] : null, o = this.getPanels();
        if (s) for (var a = 0; o.length > a; a++) if (e = o[a], s.isDescendantOf(e)) {
            i = this.getPanelInfo(a, t), i.offscreen && document.activeElement.blur();
            break;
        }
    },
    shouldArrange: function() {
        return this.layout.shouldArrange ? this.layout.shouldArrange(this.fromIndex, this.toIndex) : !0;
    },
    skipArrangerAnimation: function() {
        this._setIndex(this.toIndex), this.completed();
    },
    _setIndex: function(t) {
        var e = this.get("index");
        this.index = this.clamp(t), this.notifyObservers("index", e, t);
    },
    completed: function() {
        return this.$.animator.isAnimating() && this.$.animator.stop(), this.fraction = 1, 
        this.stepTransition(), this.animate ? this.triggerPostTransitions() : this.finishTransition(!0), 
        !0;
    },
    getPanelInfo: function(t, e) {
        return this.layout.getPanelInfo && this.layout.getPanelInfo(t, e) || {};
    },
    getTransitionInfo: function(t) {
        var e = this.getPanelInfo(t, this.toIndex);
        return e.from = this.fromIndex, e.to = this.toIndex, e.index = t, e.animate = this.animate, 
        e;
    },
    triggerPreTransitions: function() {
        var t, e = this.getPanels();
        this.preTransitionWaitlist = [];
        for (var i, n = 0; i = e[n]; n++) t = this.getTransitionInfo(n), i.preTransition && i.preTransition(t) && this.preTransitionWaitlist.push(n);
        0 === this.preTransitionWaitlist.length && this._setIndex(this.toIndex);
    },
    preTransitionComplete: function(t, e) {
        for (var i = this.getPanels().indexOf(e.originator), n = 0; this.preTransitionWaitlist.length > n; n++) if (this.preTransitionWaitlist[n] === i) {
            this.preTransitionWaitlist.splice(n, 1);
            break;
        }
        return 0 === this.preTransitionWaitlist.length && this._setIndex(this.toIndex), 
        !0;
    },
    triggerPostTransitions: function() {
        var t, e = this.getPanels();
        this.postTransitionWaitlist = [];
        for (var i, n = 0; i = e[n]; n++) t = this.getTransitionInfo(n), i.postTransition && i.postTransition(t) && this.postTransitionWaitlist.push(n);
        0 === this.postTransitionWaitlist.length && this.finishTransition(!0);
    },
    postTransitionComplete: function(t, e) {
        for (var i = this.getPanels().indexOf(e.originator), n = 0; this.postTransitionWaitlist.length > n; n++) if (this.postTransitionWaitlist[n] === i) {
            this.postTransitionWaitlist.splice(n, 1);
            break;
        }
        return 0 === this.postTransitionWaitlist.length && this.finishTransition(!0), !0;
    },
    indexChanged: function() {
        var t = this.getActive();
        t && t.isBreadcrumb && t.removeSpottableBreadcrumbProps(), this.inherited(arguments), 
        this.getPanelInfo(0, this.index).breadcrumb !== this.getPanelInfo(0, this.inPrevious).breadcrumb && this.brandingSrcChanged();
    },
    finishTransition: function(t) {
        var e, i, n, s, o = this.getPanels(), a = this.lastIndex !== void 0, r = a ? t ? "transitionFinished" : "updatePanel" : "initPanel", h = this.toIndex, l = this.fromIndex;
        for (s = h + 1, e = 0; i = o[e]; e++) n = this.getTransitionInfo(e), i[r] && i[r](n), 
        e > h && !n.offscreen && s++;
        this.inherited(arguments), this.transitionInProgress = !1, t && this.popOnBack && l > h && this.popPanels(s), 
        -1 === this.queuedIndex ? this.hide() : null !== this.queuedIndex && this.setIndex(this.queuedIndex), 
        enyo.Spotlight.unmute(this), enyo.Spotlight.spot(this.getActive());
    },
    getShowing: function() {
        return this.showing;
    },
    getAbsoluteShowing: function() {
        var t = this.getBounds();
        return 0 === t.height && 0 === t.width ? !1 : this.parent && this.parent.getAbsoluteShowing ? this.parent.getAbsoluteShowing() : !0;
    },
    showingChanged: function(t) {
        this.$.backgroundScrim && this.$.backgroundScrim.addRemoveClass("visible", this.showing), 
        this.useHandle === !0 ? (this.showing ? (this.unstashHandle(), this._show(), enyo.Spotlight.spot(this.getActive())) : (this.applyStyle("display", null), 
        this.resetHandleAutoHide(), this._hide()), this.sendShowingChangedEvent(t)) : this.inherited(arguments);
    },
    applyPattern: function() {
        switch (this.pattern) {
          case "alwaysviewing":
            this.applyAlwaysViewingPattern();
            break;

          case "activity":
            this.applyActivityPattern();
            break;

          default:
            this.useHandle = !1;
        }
    },
    applyAlwaysViewingPattern: function() {
        this.setArrangerKind("moon.BreadcrumbArranger"), this.addClass("always-viewing"), 
        this.panelCoverRatio = .5, this.useHandle = "auto" === this.useHandle ? !0 : this.useHandle, 
        this.createChrome(this.handleTools), this.breadcrumbGap = 20;
    },
    applyActivityPattern: function() {
        this.setArrangerKind("moon.BreadcrumbArranger"), this.addClass("activity"), this.showFirstBreadcrumb = !0, 
        this.useHandle = "auto" === this.useHandle ? !1 : this.useHandle, this.createChrome(this.handleTools), 
        this.breadcrumbGap = 0;
    },
    initializeShowHideHandle: function() {
        this.useHandle === !0 && (this.$.handleWrapper.canGenerate = !0, this.$.handleWrapper.spotlight = !0);
    },
    _show: function() {
        var t = !1;
        this.hasNode() ? (this.$.showHideHandle.addClass("right"), this.applyShowAnimation()) : t = !0, 
        enyo.Signals.send("onPanelsShown", {
            initialization: t
        });
    },
    _hide: function() {
        this.hasNode() && (this.$.showHideHandle.removeClass("right"), this.applyHideAnimation(), 
        enyo.Signals.send("onPanelsHidden"));
    },
    _directShow: function() {
        this.$.showHideHandle.addClass("right"), this.handleShowing && this.$.handleWrapper.removeClass("hidden"), 
        this.applyShowAnimation(!0);
    },
    _directHide: function() {
        this.$.handleWrapper.addClass("hidden"), this.$.showHideHandle.removeClass("right"), 
        this.applyHideAnimation(!0), this.hideAnimationComplete();
    },
    applyShowAnimation: function(t) {
        this.$.clientWrapper.applyStyle("-webkit-transition", t ? null : "-webkit-transform 0.5s cubic-bezier(0.25, 0.1, 0.25, 1)"), 
        this.$.clientWrapper.applyStyle("-webkit-transform", "translateX(0)");
    },
    applyHideAnimation: function(t) {
        this.$.clientWrapper.applyStyle("-webkit-transition", t ? null : "-webkit-transform 0.5s cubic-bezier(0.25, 0.1, 0.25, 1)"), 
        this.$.clientWrapper.applyStyle("-webkit-transform", "translateX(100%)");
    },
    getOffscreenXPosition: function() {
        return this.$.clientWrapper.getBounds().width;
    },
    animationComplete: function(t, e) {
        switch (e.animation.name) {
          case "show":
            return this.showAnimationComplete(), !0;

          case "hide":
            return this.hideAnimationComplete(), !0;
        }
    },
    showAnimationComplete: function() {
        this.handleShowing && this.$.handleWrapper.removeClass("hidden");
    },
    hideAnimationComplete: function() {
        this.handleShowing && this.$.handleWrapper.removeClass("hidden");
    },
    brandingSrcChanged: function() {
        "activity" === this.pattern && this.$.scrim.applyStyle("background-image", this.brandingSrc && this.getPanelInfo(0, this.index).breadcrumb ? "url(" + this.brandingSrc + ")" : "none");
    }
});

// lib\moonstone\source\SimplePicker.js
enyo.kind({
    name: "moon.SimplePicker",
    classes: "moon-simple-picker",
    mixins: [ "moon.MarqueeSupport" ],
    events: {
        onChange: ""
    },
    published: {
        selected: "",
        selectedIndex: 0,
        animate: !0,
        disabled: !1,
        wrap: !1,
        block: !1
    },
    defaultKind: "moon.MarqueeText",
    handlers: {
        onSpotlightFocused: "scrollIntoView"
    },
    components: [ {
        name: "buttonLeft",
        kind: "moon.IconButton",
        noBackground: !0,
        classes: "moon-simple-picker-button left",
        icon: "arrowlargeleft",
        onSpotlightSelect: "left",
        ondown: "downLeft",
        onholdpulse: "left",
        defaultSpotlightDisappear: "buttonRight"
    }, {
        kind: "enyo.Control",
        name: "clientWrapper",
        classes: "moon-simple-picker-client-wrapper",
        components: [ {
            kind: "enyo.Control",
            name: "client",
            classes: "moon-simple-picker-client"
        } ]
    }, {
        name: "buttonRight",
        kind: "moon.IconButton",
        noBackground: !0,
        classes: "moon-simple-picker-button right",
        icon: "arrowlargeright",
        onSpotlightSelect: "right",
        ondown: "downRight",
        onholdpulse: "right",
        defaultSpotlightDisappear: "buttonLeft"
    } ],
    create: function() {
        this.inherited(arguments), this.animateChanged(), this.initializeActiveItem(), this.disabledChanged(), 
        this.selectedIndexChanged(), this.updateMarqueeDisable(), this.blockChanged(), this.showHideNavButtons();
    },
    scrollIntoView: function() {
        this.bubble("onRequestScrollIntoView");
    },
    fireChangedEvent: function() {
        this.generated && this.doChange({
            selected: this.selected,
            content: this.selected && this.selected.content,
            index: this.selected && this.selectedIndex
        });
    },
    blockChanged: function() {
        this.addRemoveClass("block", this.block);
    },
    showHideNavButtons: function() {
        var t = this.getSelectedIndex(), e = this.getClientControls().length - 1, i = this.rtl ? this.$.buttonRight : this.$.buttonLeft, n = this.rtl ? this.$.buttonLeft : this.$.buttonRight;
        this.disabled ? (this.hideNavButton(i), this.hideNavButton(n)) : this.wrap ? (this.showNavButton(i), 
        this.showNavButton(n)) : 0 >= e ? (this.hideNavButton(i), this.hideNavButton(n)) : 0 >= t ? (this.showNavButton(n), 
        this.hideNavButton(i)) : t >= e ? (this.showNavButton(i), this.hideNavButton(n)) : (this.showNavButton(i), 
        this.showNavButton(n));
    },
    destroy: function() {
        this.destroying = !0, this.inherited(arguments);
    },
    addControl: function(t) {
        this.inherited(arguments);
        var e = this.getClientControls().indexOf(t), i = this.selectedIndex;
        this.generated && (0 > i || i > e ? this.setSelectedIndex(i + 1) : i == e && this.selectedIndexChanged(), 
        this.showHideNavButtons());
    },
    removeControl: function(t) {
        if (this.destroying) this.inherited(arguments); else {
            var e = this.getClientControls().indexOf(t), i = this.selectedIndex, n = e == this.getClientControls().length - 1;
            this.inherited(arguments), -1 !== e && (i > e || i == e && n ? this.setSelectedIndex(i - 1) : i == e && this.selectedIndexChanged(), 
            this.showHideNavButtons());
        }
    },
    hideNavButton: function(t) {
        t.setDisabled(!0);
    },
    showNavButton: function(t) {
        t.setDisabled(!1);
    },
    disabledChanged: function() {
        this.$.client.addRemoveClass("disabled", this.disabled), this.generated && this.showHideNavButtons();
    },
    animateChanged: function() {
        this.$.client.addRemoveClass("animated", this.animate);
    },
    selectedChanged: function() {
        var t = this.getClientControls().indexOf(this.selected);
        t >= 0 && this.setSelectedIndex(t);
    },
    initializeActiveItem: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) if (t[e].active) return this.selectedIndex = e, 
        this.selected = t[e], void 0;
    },
    selectedIndexChanged: function() {
        enyo.dom.transform(this.$.client, {
            translateX: 100 * this.selectedIndex * (this.rtl ? 1 : -1) + "%"
        }), this.updateMarqueeDisable(), this.setSelected(this.getClientControls()[this.selectedIndex]), 
        this.fireChangedEvent(), this.showHideNavButtons(), this.startMarquee();
    },
    updateMarqueeDisable: function() {
        this.stopMarquee();
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) t[e].disabled = e == this.selectedIndex ? !1 : !0;
    },
    left: function() {
        this.rtl ? this.next() : this.previous();
    },
    right: function() {
        this.rtl ? this.previous() : this.next();
    },
    downLeft: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.left();
    },
    downRight: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.right();
    },
    previous: function() {
        if (!this.disabled) {
            var t = this.selectedIndex - 1;
            0 > t && (t = this.wrap ? this.getClientControls().length - 1 : 0), this.setSelectedIndex(t);
        }
    },
    next: function() {
        if (!this.disabled) {
            var t = this.selectedIndex + 1;
            t > this.getClientControls().length - 1 && (t = this.wrap ? 0 : this.getClientControls().length - 1), 
            this.setSelectedIndex(t);
        }
    }
});

// lib\moonstone\source\SimpleIntegerPicker.js
enyo.kind({
    name: "moon.SimpleIntegerPicker",
    classes: "moon-simple-integer-picker",
    spotlight: !0,
    events: {
        onChange: "",
        onSelect: "",
        onRebuilt: ""
    },
    handlers: {
        onSpotlightSelect: "fireSelectEvent",
        onSpotlightRight: "next",
        onSpotlightLeft: "previous",
        onSpotlightScrollUp: "next",
        onSpotlightScrollDown: "previous",
        onSpotlightBlur: "spotlightBlur",
        onSpotlightFocus: "spotlightFocus",
        onSpotlightFocused: "spotlightFocus",
        onmousewheel: "mousewheel"
    },
    published: {
        animate: !0,
        disabled: !1,
        value: -1,
        min: 1,
        max: 9,
        step: 1,
        unit: "sec"
    },
    deferInitialization: !1,
    indices: null,
    values: null,
    components: [ {
        classes: "moon-scroll-picker-overlay-container-left",
        components: [ {
            name: "leftOverlay",
            showing: !1,
            components: [ {
                classes: "moon-scroll-picker-overlay-left"
            }, {
                classes: "moon-scroll-picker-overlay-left-border"
            } ]
        }, {
            name: "buttonLeft",
            kind: "enyo.Button",
            classes: "moon-simple-integer-picker-button left small moon-icon moon-icon-arrowsmallleft",
            ondown: "downPrevious",
            onholdpulse: "previous"
        } ]
    }, {
        name: "client",
        kind: "enyo.Panels",
        classes: "moon-simple-integer-picker-client",
        controlClasses: "moon-simple-integer-picker-item",
        draggable: !1,
        arrangerKind: "CarouselArranger",
        onTransitionStart: "transitionStart",
        onTransitionFinish: "transitionFinished"
    }, {
        classes: "moon-scroll-picker-overlay-container-right",
        components: [ {
            name: "rightOverlay",
            showing: !1,
            components: [ {
                classes: "moon-scroll-picker-overlay-right"
            }, {
                classes: "moon-scroll-picker-overlay-right-border"
            } ]
        }, {
            name: "buttonRight",
            kind: "enyo.Button",
            classes: "moon-simple-integer-picker-button right small moon-icon moon-icon-arrowsmallright",
            ondown: "downNext",
            onholdpulse: "next"
        } ]
    } ],
    observers: {
        triggerRebuild: [ "step", "min", "max", "unit" ],
        handleValueChange: [ "value" ]
    },
    bindings: [ {
        from: ".animate",
        to: ".$.client.animate"
    }, {
        from: ".disabled",
        to: ".$.buttonLeft.disabled"
    }, {
        from: ".disabled",
        to: ".$.buttonRight.disabled"
    }, {
        from: ".value",
        to: ".$.client.index",
        oneWay: !1,
        transform: "sync"
    } ],
    sync: function(t, e) {
        return this.values ? "source" === e ? this.indices[t] : this.values[t] : void 0;
    },
    previous: function() {
        return this.$.client.previous(), !0;
    },
    next: function() {
        return this.$.client.next(), !0;
    },
    downPrevious: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.previous();
    },
    downNext: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.next();
    },
    getContent: function() {
        return this.$.client && this.$.client.hasNode() && this.$.client.getActive() ? this.$.client.getActive().getContent() : "";
    },
    create: function() {
        this.inherited(arguments), this.deferInitialization || (this.build(), this.validate()), 
        this.disabledChanged();
    },
    build: function() {
        for (var t, e = this.indices = {}, i = this.values = [], n = "undefined" != typeof ilib ? new ilib.NumFmt({
            locale: new ilib.LocaleInfo().locale,
            useNative: !1
        }) : null, s = 0, o = this.min; this.max >= o && (t = n ? n.format(o) : o, this.createComponent({
            content: t + " " + this.unit,
            value: o
        }), i[s] = o, e[o] = s, !(0 >= this.step)); s++, o += this.step) ;
    },
    validate: function() {
        var t = this.indices[this.value];
        void 0 !== t ? (this.$.client.set("index", t), this.setButtonVisibility(null, this.value)) : this.set("value", this.min);
    },
    rebuild: function() {
        this.destroyClientControls(), this.build(), this.$.client.render(), this.reflow(), 
        this.validate(), this.doRebuilt();
    },
    triggerRebuild: function() {
        this.startJob("rebuild", this.rebuild, 10);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.getDisabled());
    },
    reflow: function() {
        if (this.inherited(arguments), this.getAbsoluteShowing()) {
            for (var t = 0, e = this.$.client.getPanels(), i = 0; e.length > i; i++) t = Math.max(t, e[i].getBounds().width);
            for (this.$.client.setBounds({
                width: t
            }), e = this.$.client.getPanels(), i = 0; e.length > i; i++) e[i].setBounds({
                width: t
            });
            this.$.client.reflow();
        }
    },
    transitionStart: function(t, e) {
        return e.fromIndex > e.toIndex ? (this.$.leftOverlay.show(), this.$.buttonLeft.addClass("pressed")) : e.fromIndex < e.toIndex && (this.$.rightOverlay.show(), 
        this.$.buttonRight.addClass("pressed")), !0;
    },
    transitionFinished: function() {
        return this.hideOverlays(), !0;
    },
    spotlightBlur: function() {
        this.hideOverlays();
    },
    hideOverlays: function() {
        this.$.leftOverlay.hide(), this.$.rightOverlay.hide(), this.$.buttonLeft.removeClass("pressed"), 
        this.$.buttonRight.removeClass("pressed");
    },
    setButtonVisibility: function(t, e) {
        if (this.values) {
            var i = this.values[0], n = this.values[this.values.length - 1];
            e === i ? this.$.buttonLeft.applyStyle("visibility", "hidden") : t === i && this.$.buttonLeft.applyStyle("visibility", "visible"), 
            e === n ? this.$.buttonRight.applyStyle("visibility", "hidden") : t === n && this.$.buttonRight.applyStyle("visibility", "visible");
        }
    },
    fireSelectEvent: function() {
        this.hasNode() && this.doSelect({
            content: this.getContent(),
            value: this.value
        });
    },
    fireChangeEvent: function() {
        this.hasNode() && this.doChange({
            content: this.getContent(),
            value: this.value
        });
    },
    handleValueChange: function(t, e) {
        this.setButtonVisibility(t, e), this.fireChangeEvent();
    },
    mousewheel: function(t, e) {
        return e.preventDefault(), !0;
    }
});

// lib\moonstone\source\GridListImageItem.js
enyo.kind({
    name: "moon.GridListImageItem",
    kind: "enyo.GridListImageItem",
    mixins: [ "moon.MarqueeSupport" ],
    spotlight: !0,
    centered: !0,
    classes: "moon-gridlist-item moon-gridlist-imageitem",
    componentOverrides: {
        caption: {
            kind: "moon.MarqueeText"
        },
        subCaption: {
            kind: "moon.MarqueeText"
        }
    },
    bindings: [ {
        from: ".allowHtml",
        to: ".$.caption.allowHtml"
    }, {
        from: ".allowHtml",
        to: ".$.subCaption.allowHtml"
    } ],
    handlers: {
        onSpotlightFocus: "focused"
    },
    focused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    }
});

// lib\moonstone\source\MoonGridFlyweightRepeater.js
enyo.kind({
    name: "moon.GridFlyWeightRepeater",
    kind: "enyo.GridFlyWeightRepeater",
    _generateChildHtmlEqualSizedItems: function() {
        var t = this.owner.getScrollBounds().clientWidth, e = this.$.client, i = "", n = 0, s = this.itemWidth, o = this.itemHeight;
        if (this.itemFluidWidth) {
            n = 100 / this.itemsPerRow;
            var a = 0;
            this.itemSpacing >= 0 && (a = (this.itemsPerRow + 1) * this.itemSpacing, n = 100 / this.itemsPerRow - 100 * a / (this.itemsPerRow * t)), 
            s = n / 100 * t, o = s * (this.itemHeight / this.itemWidth);
        }
        for (var r = this.rowOffset; this.rowOffset + this.count > r; r++) e.setAttribute("data-enyo-index", r), 
        this.doSetupItem({
            index: r,
            selected: this.isSelected(r)
        }), this.itemFluidWidth ? e.addStyles("width:" + n + "%;height:" + o + "px;") : e.addStyles("width:" + this.itemWidth + "px;height:" + this.itemHeight + "px;"), 
        this.itemSpacing >= 0 && (e.addStyles("margin-top:" + this.itemSpacing + "px; margin-left:" + this.itemSpacing + "px;"), 
        e.addStyles("margin-right: 0px;")), i += e.generateHtml(), e.teardownRender();
        return i;
    }
});

// lib\moonstone\source\Checkbox.js
enyo.kind({
    name: "moon.Checkbox",
    classes: "moon-checkbox",
    kind: enyo.Checkbox,
    tag: "div",
    spotlight: !0,
    handlers: {
        onclick: ""
    },
    tap: function() {
        return this.disabled ? !0 : (this.setChecked(!this.getChecked()), this.bubble("onchange"), 
        void 0);
    },
    dragstart: function() {}
});

// lib\moonstone\source\CheckboxItem.js
enyo.kind({
    name: "moon.CheckboxItem",
    mixins: [ "moon.MarqueeSupport" ],
    published: {
        checked: !1,
        checkboxOnRight: !1,
        disabled: !1
    },
    events: {
        onActivate: ""
    },
    classes: "moon-item moon-checkbox-item",
    spotlight: !0,
    handlers: {
        ontap: "tap",
        onActivate: "decorateActivateEvent",
        onSpotlightFocused: "spotlightFocused"
    },
    components: [ {
        name: "client",
        mixins: [ "moon.MarqueeItem" ],
        classes: "moon-checkbox-item-label-wrapper"
    }, {
        name: "input",
        kind: "moon.Checkbox",
        spotlight: !1
    } ],
    bindings: [ {
        from: ".allowHtml",
        to: ".$.client.allowHtml"
    } ],
    create: function() {
        this.inherited(arguments), this.disabledChanged(), this.checkboxOnRightChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.checkedChanged();
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled), this.$.input.setDisabled(this.disabled);
    },
    checkedChanged: function() {
        this.$.input.setChecked(this.getChecked());
    },
    checkboxOnRightChanged: function() {
        this.addRemoveClass("left-handed", !this.getCheckboxOnRight());
    },
    tap: function(t, e) {
        t != this.$.input && this.waterfallDown("ontap", e, t);
    },
    decorateActivateEvent: function(t, e) {
        e.toggledControl = this, this.setChecked(this.$.input.getChecked()), e.checked = this.checked;
    },
    spotlightFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    },
    contentChanged: function() {
        this.$.client.setContent(this.getContent());
    }
});

// lib\moonstone\source\ToggleSwitch.js
enyo.kind({
    name: "moon.ToggleSwitch",
    kind: "moon.Checkbox",
    classes: "moon-toggle-switch",
    rendered: function() {
        this.inherited(arguments), enyo.asyncMethod(this, function() {
            this.addClass("animated");
        });
    }
});

// lib\moonstone\source\ToggleItem.js
enyo.kind({
    name: "moon.ToggleItem",
    kind: "moon.CheckboxItem",
    classes: "moon-toggle-item",
    checkboxOnRight: !0,
    componentOverrides: {
        client: {
            classes: "moon-toggle-item-label-wrapper"
        },
        input: {
            kind: "moon.ToggleSwitch",
            spotlight: !1
        }
    }
});

// lib\moonstone\source\ToggleButton.js
enyo.kind({
    name: "moon.ToggleButton",
    kind: "moon.Button",
    published: {
        value: !1,
        toggleOnLabel: "",
        toggleOffLabel: ""
    },
    events: {
        onChange: ""
    },
    _rendered: !1,
    classes: "moon-toggle-button",
    create: function() {
        this.inherited(arguments), this.updateContent(), this.updateVisualState();
    },
    rendered: function() {
        this.inherited(arguments), this.setActive(this.value), this.fireChangeEvent(), this._rendered = !0;
    },
    updateVisualState: function() {
        this.addRemoveClass("moon-toggle-button-on", this.value && !this.disabled);
    },
    disabledChanged: function() {
        this.inherited(arguments), this.updateVisualState();
    },
    valueChanged: function() {
        this.updateContent(), this.updateVisualState(), this.setActive(this.value), this.fireChangeEvent();
    },
    toggleOnLabelChanged: function() {
        this.updateContent();
    },
    toggleOffLabelChanged: function() {
        this.updateContent();
    },
    activeChanged: function() {
        this._rendered && (this.active = enyo.isTrue(this.active), this.setValue(this.active)), 
        this.bubble("onActivate");
    },
    tap: function() {
        return this.disabled ? !0 : (this.setValue(!this.value), void 0);
    },
    updateContent: function() {
        this.toggleOnLabel && this.toggleOffLabel ? this.setContent(this.value ? this.toggleOnLabel : this.toggleOffLabel) : this.setContent(this.content);
    },
    fireChangeEvent: function() {
        this.doChange({
            value: this.value
        });
    }
});

// lib\moonstone\source\RadioItem.js
enyo.kind({
    name: "moon.RadioItem",
    kind: "moon.SelectableItem",
    classes: "moon-radio-item",
    componentOverrides: {
        indicator: {
            kind: "moon.RadioItemIndicator"
        }
    }
}), enyo.kind({
    name: "moon.RadioItemIndicator",
    kind: "enyo.Control",
    classes: "moon-radio-item-indicator",
    components: [ {
        classes: "moon-radio-item-indicator-center-dot"
    } ]
});

// lib\moonstone\source\RadioItemGroup.js
enyo.kind({
    name: "moon.RadioItemGroup",
    kind: "enyo.Group",
    classes: "moon-radio-item-group",
    defaultKind: "moon.RadioItem"
});

// lib\moonstone\source\ExpandableListItem.js
enyo.kind({
    name: "moon.ExpandableListItem",
    published: {
        autoCollapse: !1,
        open: !1,
        active: !1,
        lockBottom: !1,
        disabled: !1
    },
    classes: "moon-expandable-list-item",
    spotlight: !1,
    defaultKind: "moon.Item",
    handlers: {
        onSpotlightDown: "spotlightDown",
        onDrawerAnimationEnd: "drawerAnimationEnd"
    },
    components: [ {
        name: "headerContainer",
        classes: "moon-expandable-list-item-header moon-expandable-picker-header moon-expandable-list-header",
        onSpotlightFocus: "headerFocus",
        ontap: "expandContract",
        components: [ {
            name: "header",
            kind: "moon.MarqueeText"
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client",
        components: [ {
            name: "client",
            kind: "Group",
            tag: null
        } ]
    } ],
    bindings: [ {
        from: ".allowHtml",
        to: ".$.header.allowHtml"
    }, {
        from: ".disabled",
        to: ".$.headerContainer.disabled"
    } ],
    create: function() {
        this.inherited(arguments), this.openChanged(), this.setActive(this.open), this.disabledChanged();
    },
    contentChanged: function() {
        this.$.header.setContent(this.getContent());
    },
    openChanged: function() {
        var t = this.getOpen();
        this.addRemoveClass("open", t), this.$.drawer.setOpen(t), this.$.drawer.spotlightDisabled = !t, 
        this.setActive(t);
    },
    disabledChanged: function() {
        var t = this.getDisabled();
        this.addRemoveClass("disabled", t), t && this.setActive(!1);
    },
    activeChanged: function() {
        this.bubble("onActivate", {
            allowHighlanderDeactivate: !0
        }), this.setOpen(this.active);
    },
    expandContract: function() {
        return this.disabled ? !0 : (this.toggleActive(), this.getActive() && !enyo.Spotlight.getPointerMode() && enyo.Spotlight.spot(enyo.Spotlight.getFirstChild(this.$.drawer)), 
        void 0);
    },
    toggleActive: function() {
        this.getOpen() ? this.setActive(!1) : this.setActive(!0);
    },
    headerFocus: function(t, e) {
        var i = e && e.dir;
        this.getOpen() && this.getAutoCollapse() && "UP" === i && this.setActive(!1), e.originator === this.$.header && this.bubble("onRequestScrollIntoView");
    },
    spotlightDown: function(t, e) {
        var i = enyo.Spotlight.getChildren(this.$.client);
        return this.getLockBottom() && this.getOpen() && i.length && e.originator == i[i.length - 1] ? !0 : void 0;
    },
    drawerAnimationEnd: function() {
        return this.bubble("onRequestScrollIntoView", {
            scrollInPointerMode: !0
        }), !0;
    }
});

// lib\moonstone\source\ExpandablePicker.js
enyo.kind({
    name: "moon.ExpandablePicker",
    kind: "moon.ExpandableListItem",
    classes: "moon-expandable-picker",
    events: {
        onChange: ""
    },
    published: {
        selected: null,
        selectedIndex: -1,
        noneText: "",
        helpText: null,
        autoCollapseOnSelect: !0,
        multipleSelection: !1
    },
    autoCollapse: !0,
    lockBottom: !0,
    defaultKind: "moon.CheckboxItem",
    selectAndCloseDelayMS: 600,
    components: [ {
        name: "headerWrapper",
        kind: "moon.Item",
        classes: "moon-expandable-picker-header-wrapper",
        onSpotlightFocus: "headerFocus",
        ontap: "expandContract",
        components: [ {
            name: "headerContainer",
            classes: "moon-expandable-list-item-header moon-expandable-picker-header",
            components: [ {
                name: "header",
                kind: "moon.MarqueeText"
            } ]
        }, {
            name: "currentValue",
            kind: "moon.MarqueeText",
            classes: "moon-expandable-picker-current-value"
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client",
        components: [ {
            name: "client",
            tag: null,
            kind: "Group",
            onActivate: "activated",
            highlander: !0
        }, {
            name: "helpText",
            kind: "moon.BodyText",
            canGenerate: !1,
            classes: "moon-expandable-picker-help-text"
        } ]
    } ],
    bindings: [ {
        from: ".allowHtml",
        to: ".$.header.allowHtml"
    }, {
        from: ".allowHtml",
        to: ".$.currentValue.allowHtml"
    }, {
        from: ".disabled",
        to: ".$.headerWrapper.disabled"
    } ],
    create: function() {
        this.inherited(arguments), this.multipleSelection && (this.selected = this.selected ? this.selected : [], 
        this.selectedIndex = -1 != this.selectedIndex ? this.selectedIndex : [], this.$.client.setHighlander(!1)), 
        this.initializeActiveItem(), this.selectedIndexChanged(), this.noneTextChanged(), 
        this.helpTextChanged(), this.openChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.isRendered = !0;
    },
    multiSelectCurrentValue: function() {
        if (this.multipleSelection) {
            var t = this.getClientControls(), e = "";
            this.selectedIndex.sort();
            for (var i = 0; this.selectedIndex.length > i; i++) e = e ? e + ", " + t[this.selectedIndex[i]].getContent() : t[this.selectedIndex[i]].getContent();
            return e || (e = this.getNoneText()), e;
        }
    },
    selectedChanged: function(t) {
        var e, i = this.getSelected(), n = this.getClientControls(), s = -1;
        if (this.multipleSelection) {
            for (s = this.selectedIndex = [], e = 0; n.length > e; e++) {
                n[e].silence();
                var o = s.indexOf(e);
                i.indexOf(n[e]) >= 0 ? (n[e].setChecked(!0), -1 == o && s.push(e)) : (n[e].setChecked(!1), 
                o >= 0 && s.splice(o, 1)), n[e].unsilence();
            }
            this.$.currentValue.setContent(this.multiSelectCurrentValue()), this.hasNode() && this.fireChangeEvent();
        } else {
            for (e = 0; n.length > e; e++) n[e].silence(), n[e] === i ? (n[e].setChecked(!0), 
            s = e) : n[e].setChecked(!1), n[e].unsilence();
            s > -1 && i !== t && (this.setSelectedIndex(s), this.$.currentValue.setContent(i.getContent()), 
            this.hasNode() && this.fireChangeEvent());
        }
    },
    selectedIndexChanged: function() {
        var t = this.getSelected(), e = this.getClientControls(), i = this.getSelectedIndex();
        if (this.multipleSelection) {
            for (var n = 0; e.length > n; n++) {
                e[n].silence();
                var s = t.indexOf(e[n]);
                i.indexOf(n) >= 0 ? (e[n].setChecked(!0), -1 == s && t.push(e[n])) : (e[n].setChecked(!1), 
                s >= 0 && t.splice(s, 1)), e[n].unsilence();
            }
            this.$.currentValue.setContent(this.multiSelectCurrentValue()), this.hasNode() && this.fireChangeEvent();
        } else e[i] && e[i] !== t && this.setSelected(e[i]);
    },
    noneTextChanged: function() {
        this.multipleSelection ? this.getSelected().length || this.getSelectedIndex().length || this.$.currentValue.setContent(this.getNoneText()) : this.getSelected() || -1 != this.getSelectedIndex() || this.$.currentValue.setContent(this.getNoneText());
    },
    openChanged: function() {
        this.inherited(arguments), this.$.currentValue.setShowing(!this.open), this.setActive(this.getOpen());
    },
    helpTextChanged: function() {
        null === this.helpText || this.$.helpText.canGenerate || this.generateHelpText(), 
        this.$.helpText.setContent(this.helpText), this.$.helpText.setShowing(!!this.helpText);
    },
    destroy: enyo.inherit(function(t) {
        return function() {
            this.destroying = !0, t.apply(this, arguments);
        };
    }),
    removeControl: enyo.inherit(function(t) {
        return function(e) {
            if (!this.destroying) if (this.multipleSelection) {
                for (var i = 0; this.selected > i; i++) if (this.selected[i] === e) {
                    this.selected.splice(i, 1);
                    break;
                }
                this.selectedChanged();
            } else this.selected === e && (this.setSelected(null), this.setSelectedIndex(-1), 
            this.$.currentValue.setContent(this.getNoneText()));
            t.apply(this, arguments);
        };
    }),
    generateHelpText: function() {
        this.$.helpText.canGenerate = !0, this.$.helpText.render();
    },
    initializeActiveItem: function() {
        for (var t = this.getClientControls(), e = 0; t.length > e; e++) if (t[e].active) {
            if (!this.multipleSelection) return this.selectedIndex = e, this.selected = t[e], 
            this.$.currentValue.setContent(t[e].getContent()), t[e].setChecked(!0), void 0;
            this.selectedIndex.push(e), this.selected.push(t[e]), t[e].setChecked(!0);
        }
        this.multipleSelection && this.$.currentValue.setContent(this.multiSelectCurrentValue());
    },
    activated: function(t, e) {
        var i, n = e && e.toggledControl;
        if (n) return i = this.getClientControls().indexOf(n), this.multipleSelection ? i >= 0 && (e.checked && -1 == this.selected.indexOf(n) && (this.selected.push(n), 
        this.selectedChanged()), !e.checked && this.selected.indexOf(n) >= 0 && (this.selected.splice(this.selected.indexOf(n), 1), 
        this.selectedChanged())) : e.checked && i >= 0 && this.setSelected(n), this.getAutoCollapseOnSelect() && this.isRendered && this.getOpen() && this.startJob("selectAndClose", "selectAndClose", this.selectAndCloseDelayMS), 
        !0;
    },
    selectAndClose: function() {
        this.setActive(!1), !enyo.Spotlight.getPointerMode() && enyo.Spotlight.getCurrent() && enyo.Spotlight.getCurrent().isDescendantOf(this) && enyo.Spotlight.spot(this.$.headerWrapper);
    },
    fireChangeEvent: function() {
        var t = this.multipleSelection ? this.multiSelectCurrentValue() : this.getSelected().getContent();
        this.doChange({
            selected: this.getSelected(),
            content: t,
            index: this.getSelectedIndex()
        });
    },
    multipleSelectionChanged: function() {
        this.multipleSelection ? (this.selected = this.selected ? [ this.selected ] : [], 
        this.selectedIndex = []) : (this.selected = this.selected.length ? this.selected[0] : null, 
        this.selectedIndex = -1), this.$.client.setHighlander(!this.multipleSelection), 
        this.selectedChanged();
    }
});

// lib\moonstone\source\ExpandableIntegerPicker.js
enyo.kind({
    name: "moon.ExpandableIntegerPicker",
    kind: "moon.ExpandableListItem",
    classes: "moon-expandable-integer-picker",
    events: {
        onChange: ""
    },
    published: {
        noneText: "",
        value: -1,
        min: 0,
        max: 9,
        step: 1,
        unit: "sec"
    },
    lockBottom: !0,
    autoCollapse: !0,
    handlers: {
        requestScrollIntoView: "requestScrollIntoView",
        onRebuilt: "requestPickerReflow"
    },
    components: [ {
        name: "headerWrapper",
        kind: "moon.Item",
        classes: "moon-expandable-picker-header-wrapper",
        onSpotlightFocus: "headerFocus",
        ontap: "expandContract",
        components: [ {
            name: "headerContainer",
            classes: "moon-expandable-list-item-header moon-expandable-picker-header",
            components: [ {
                name: "header",
                kind: "moon.MarqueeText"
            } ]
        }, {
            name: "currentValue",
            kind: "moon.MarqueeText",
            classes: "moon-expandable-picker-current-value"
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client indented",
        components: [ {
            name: "picker",
            kind: "moon.SimpleIntegerPicker",
            deferInitialization: !0,
            onSelect: "toggleActive",
            onActivate: "activated"
        } ]
    } ],
    bindings: [ {
        from: ".min",
        to: ".$.picker.min"
    }, {
        from: ".max",
        to: ".$.picker.max"
    }, {
        from: ".step",
        to: ".$.picker.step"
    }, {
        from: ".unit",
        to: ".$.picker.unit"
    }, {
        from: ".value",
        to: ".$.picker.value",
        oneWay: !1
    }, {
        from: ".showCurrentValue",
        to: ".$.currentValue.showing"
    }, {
        from: ".currentValueText",
        to: ".$.currentValue.content"
    }, {
        from: ".disabled",
        to: ".$.headerWrapper.disabled"
    } ],
    computed: {
        showCurrentValue: [ "open" ],
        currentValueText: [ "value", "unit", "noneText" ]
    },
    create: function() {
        this.inherited(arguments), this.requestPickerReflow();
    },
    requestPickerReflow: function() {
        this._needsPickerReflow = !0;
    },
    valueChanged: function(t) {
        (this.value < this.min || this.value > this.max) && (this.value = t), this.fireChangeEvent();
    },
    openChanged: function() {
        this.inherited(arguments), this.setActive(this.getOpen()), this.open && this._needsPickerReflow && (this.$.picker.reflow(), 
        this._needsPickerReflow = !1);
    },
    showCurrentValue: function() {
        return !this.open;
    },
    currentValueText: function() {
        return "" === this.value ? this.noneText : this.value + " " + this.unit;
    },
    updateValue: function() {
        this.setValue(this.$.picker.getValue());
    },
    toggleActive: function() {
        this.getOpen() ? (this.setActive(!1), enyo.Spotlight.getPointerMode() || enyo.Spotlight.spot(this.$.headerWrapper)) : this.setActive(!0);
    },
    activated: function() {
        return !0;
    },
    fireChangeEvent: function() {
        this.doChange({
            value: this.value,
            content: this.content
        });
    },
    spotlightDown: function(t, e) {
        return this.getLockBottom() && e.originator === this.$.picker && this.getOpen() ? !0 : void 0;
    }
});

// lib\moonstone\source\Header.js
enyo.kind({
    name: "moon.Header",
    classes: "moon-header",
    published: {
        title: "",
        titleAbove: "",
        titleBelow: "",
        subTitleBelow: "",
        type: "large",
        small: !1,
        backgroundSrc: null,
        backgroundPosition: "top right",
        fullBleedBackground: !1,
        inputMode: !1,
        dismissOnEnter: !1,
        placeholder: "",
        value: "",
        titleUpperCase: !0
    },
    mixins: [ "moon.MarqueeSupport" ],
    marqueeOnSpotlight: !1,
    marqueeOnHover: !0,
    marqueeOnRender: !0,
    marqueeOnRenderDelay: 1e4,
    standardHeight: 360,
    handlers: {
        oninput: "handleInput",
        onchange: "handleChange",
        onRequestCreateListActions: "handleRequestCreateComponents",
        onListActionOpenChanged: "handleListActionOpenChanged"
    },
    events: {
        onInputHeaderInput: "",
        onInputHeaderChange: ""
    },
    components: [ {
        name: "texts",
        components: [ {
            name: "titleAbove",
            classes: "moon-super-header-text moon-header-title-above"
        }, {
            name: "titleWrapper",
            classes: "moon-header-title-wrapper",
            components: [ {
                name: "title",
                kind: "moon.MarqueeText",
                classes: "moon-header-font moon-header-title",
                canGenerate: !1
            }, {
                name: "inputDecorator",
                kind: "moon.InputDecorator",
                classes: "moon-input-header-input-decorator",
                canGenerate: !1,
                components: [ {
                    name: "titleInput",
                    kind: "moon.Input",
                    classes: "moon-header-text moon-header-title"
                } ]
            } ]
        }, {
            name: "titleBelow",
            kind: "moon.MarqueeText",
            classes: "moon-header-title-below"
        }, {
            name: "subTitleBelow",
            kind: "moon.MarqueeText",
            classes: "moon-header-sub-title-below"
        } ]
    }, {
        name: "client",
        classes: "moon-hspacing moon-header-client"
    }, {
        name: "animator",
        kind: "enyo.StyleAnimator",
        onComplete: "animationComplete"
    } ],
    bindings: [ {
        from: ".value",
        to: ".$.titleInput.value",
        oneWay: !1
    }, {
        from: ".dismissOnEnter",
        to: ".$.titleInput.dismissOnEnter"
    } ],
    create: function() {
        this.inherited(arguments), this.smallChanged(), this.typeChanged(), this.titleChanged(), 
        this.titleAboveChanged(), this.titleBelowChanged(), this.subTitleBelowChanged(), 
        this.allowHtmlChanged(), this.backgroundSrcChanged(), this.backgroundPositionChanged(), 
        this.inputModeChanged(), this.placeholderChanged(), this.fullBleedBackgroundChanged();
    },
    allowHtmlChanged: function() {
        this.$.title.setAllowHtml(this.allowHtml), this.$.titleBelow.setAllowHtml(this.allowHtml), 
        this.$.subTitleBelow.setAllowHtml(this.allowHtml);
    },
    backgroundSrcChanged: function() {
        var t = enyo.isArray(this.backgroundSrc) ? this.backgroundSrc : [ this.backgroundSrc ];
        t = enyo.map(t, function(t) {
            return t ? "url(" + t + ")" : null;
        }), this.applyStyle("background-image", t.length ? t.join(", ") : null);
    },
    backgroundPositionChanged: function() {
        var t = this.backgroundPosition;
        if (enyo.isArray(t) && (t = t.length ? t.join(", ") : null), "inherit" === t || "initial" === t) return this.applyStyle("background-position", t), 
        void 0;
        var e = t && t.split(" ") || [], i = 0 === e.length ? "top right" : 1 === e.length ? e[0] + " right" : t;
        this.applyStyle("background-position", i);
    },
    fullBleedBackgroundChanged: function() {
        this.addRemoveClass("full-bleed", this.fullBleedBackground);
    },
    handleRequestCreateComponents: function(t, e) {
        this.controlParent = null, this.createComponents(e.components, {
            owner: e.originator
        }), this.discoverControlParent();
    },
    collapseToSmall: function() {
        if (!this.collapsed) {
            var t = enyo.dom.getComputedStyle(this.hasNode()), e = enyo.dom.getComputedStyle(this.$.titleWrapper.hasNode()), i = enyo.dom.getComputedStyle(this.$.titleBelow.hasNode()), n = enyo.dom.getComputedStyle(this.$.subTitleBelow.hasNode()), s = enyo.dom.getComputedStyle(this.$.titleAbove.hasNode());
            this.smallAnimProps = {
                height: t.height
            }, this.$.titleWrapper.smallAnimProps = {
                "padding-left": e["padding-left"],
                top: e.top
            }, this.$.title.smallAnimProps = {}, this.$.titleAbove.smallAnimProps = {
                height: s.height,
                opacity: s.opacity
            }, this.$.titleBelow.smallAnimProps = {
                top: i.top
            }, this.$.subTitleBelow.smallAnimProps = {
                top: n.top
            }, this.$.animator.newAnimation({
                name: "collapseToSmall",
                duration: 200,
                timingFunction: "linear",
                keyframes: {
                    0: [ {
                        control: this,
                        properties: {
                            height: "current"
                        }
                    }, {
                        control: this.$.titleWrapper,
                        properties: {
                            "padding-left": "current",
                            top: "current"
                        }
                    }, {
                        control: this.$.titleAbove,
                        properties: {
                            height: "current",
                            opacity: "current",
                            "margin-top": "current"
                        }
                    }, {
                        control: this.$.title,
                        properties: {}
                    }, {
                        control: this.$.titleBelow,
                        properties: {
                            top: "current"
                        }
                    }, {
                        control: this.$.subTitleBelow,
                        properties: {
                            top: "current"
                        }
                    } ],
                    70: [],
                    100: [ {
                        control: this,
                        properties: {
                            height: "260px"
                        }
                    }, {
                        control: this.$.titleWrapper,
                        properties: {}
                    }, {
                        control: this.$.titleAbove,
                        properties: {
                            height: 0,
                            opacity: 0,
                            "margin-top": 0
                        }
                    }, {
                        control: this.$.title,
                        properties: {}
                    }, {
                        control: this.$.titleBelow,
                        properties: {}
                    }, {
                        control: this.$.subTitleBelow,
                        properties: {}
                    } ]
                }
            }), this.$.animator.play("collapseToSmall"), this.collapsed = !0;
        }
    },
    expandToLarge: function() {
        this.collapsed && (this.$.animator.newAnimation({
            name: "expandToLarge",
            duration: 200,
            timingFunction: "linear",
            keyframes: {
                0: [ {
                    control: this,
                    properties: {
                        height: "current"
                    }
                }, {
                    control: this.$.titleWrapper,
                    properties: {
                        "padding-left": "current",
                        top: "current"
                    }
                }, {
                    control: this.$.titleAbove,
                    properties: {
                        height: "current",
                        opacity: "current",
                        "margin-top": "current"
                    }
                }, {
                    control: this.$.title,
                    properties: {}
                }, {
                    control: this.$.titleBelow,
                    properties: {
                        top: "current"
                    }
                }, {
                    control: this.$.subTitleBelow,
                    properties: {
                        top: "current"
                    }
                } ],
                30: [],
                100: [ {
                    control: this,
                    properties: {
                        height: this.smallAnimProps.height
                    }
                }, {
                    control: this.$.titleWrapper,
                    properties: {
                        "padding-left": this.$.titleWrapper.smallAnimProps["padding-left"],
                        top: this.$.titleWrapper.smallAnimProps.top
                    }
                }, {
                    control: this.$.titleAbove,
                    properties: {
                        height: this.$.titleAbove.smallAnimProps.height,
                        opacity: this.$.titleAbove.smallAnimProps.opacity,
                        "margin-top": this.$.titleAbove.smallAnimProps["margin-top"]
                    }
                }, {
                    control: this.$.title,
                    properties: {}
                }, {
                    control: this.$.titleBelow,
                    properties: {
                        top: this.$.titleBelow.smallAnimProps.top
                    }
                }, {
                    control: this.$.subTitleBelow,
                    properties: {
                        top: this.$.subTitleBelow.smallAnimProps.top
                    }
                } ]
            }
        }), this.$.animator.play("expandToLarge"), this.collapsed = !1);
    },
    typeChanged: function(t) {
        switch (t) {
          case "medium":
            this.removeClass("moon-medium-header");
            break;

          case "small":
            this.removeClass("moon-small-header");
        }
        switch (this.getType()) {
          case "medium":
            this.addClass("moon-medium-header");
            break;

          case "small":
            this.addClass("moon-small-header");
        }
    },
    smallChanged: function() {
        this.addRemoveClass("moon-medium-header", this.getSmall());
    },
    contentChanged: function() {
        this.$.title.setContent(this.getTitleUpperCase() ? enyo.toUpperCase(this.title || this.content) : this.title || this.content), 
        this.placeholderChanged();
    },
    titleChanged: function() {
        this.contentChanged(), this.placeholderChanged();
    },
    placeholderChanged: function() {
        this.$.titleInput.set("placeholder", this.getTitleUpperCase() ? enyo.toUpperCase(this.placeholder || this.title || this.content) : this.placeholder || this.title || this.content);
    },
    titleUpperCaseChanged: function() {
        this.titleChanged();
    },
    titleAboveChanged: function() {
        this.$.titleAbove.addRemoveClass("no-border", "" === this.titleAbove), this.$.titleAbove.setContent(this.titleAbove);
    },
    titleBelowChanged: function() {
        this.$.titleBelow.setContent(this.titleBelow || "");
    },
    subTitleBelowChanged: function() {
        this.$.subTitleBelow.setContent(this.subTitleBelow || "");
    },
    animationComplete: function() {},
    inputModeChanged: function() {
        this.$.title.canGenerate = !this.inputMode, this.$.title.setShowing(!this.inputMode), 
        this.$.inputDecorator.canGenerate = this.inputMode, this.$.inputDecorator.setShowing(this.inputMode), 
        this.inputMode || (this.$.title.hasNode() || this.$.title.render(), this.generated && (this.stopMarquee(), 
        this.startMarquee())), this.inputMode && !this.$.inputDecorator.hasNode() && this.$.inputDecorator.render(), 
        this.addRemoveClass("moon-input-header", this.inputMode);
    },
    handleInput: function(t, e) {
        this.doInputHeaderInput(e);
    },
    handleChange: function(t, e) {
        this.doInputHeaderChange(e);
    },
    handleListActionOpenChanged: function(t, e) {
        e.open && e.originator.beforeOpenDrawer(this.standardHeight, this.getType());
    }
});

// lib\moonstone\source\Icon.js
enyo.kind({
    name: "moon.Icon",
    published: {
        icon: "",
        src: "",
        disabled: !1,
        small: !0
    },
    getSrc: function() {
        return this.src;
    },
    classes: "moon-icon",
    create: function() {
        this.inherited(arguments), this.src && this.srcChanged(), this.icon && this.iconChanged(), 
        this.smallChanged(), this.disabledChanged();
    },
    getIconClass: function(t) {
        return "moon-icon-" + (t || this.icon);
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled);
    },
    srcChanged: function() {
        var t = this.src || null;
        t && "none" != t && "inherit" != t && "initial" != t && (t = "url(" + enyo.path.rewrite(this.src) + ")"), 
        this.applyStyle("background-image", t);
    },
    iconChanged: function(t) {
        t && this.removeClass(this.getIconClass(t)), this.get("icon") && this.addClass(this.getIconClass());
    },
    smallChanged: function() {
        if (this.$.tapArea && this.$.tapArea.destroy(), this.small) {
            var t = this.createComponent({
                name: "tapArea",
                classes: "small-icon-tap-area",
                isChrome: !0
            });
            this.generated && t.render();
        }
        this.addRemoveClass("small", this.small);
    }
});

// lib\moonstone\source\IconButton.js
enyo.kind({
    name: "moon.IconButton",
    kind: "moon.Icon",
    published: {
        active: !1,
        small: !0,
        noBackground: !1
    },
    classes: "moon-icon-button",
    spotlight: !0,
    handlers: {
        onSpotlightSelect: "depress",
        onSpotlightKeyUp: "undepress",
        onSpotlightFocused: "spotlightFocused",
        onSpotlightBlur: "undepress"
    },
    create: function() {
        this.inherited(arguments), this.noBackgroundChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.activeChanged();
    },
    noBackgroundChanged: function() {
        this.addRemoveClass("no-background", this.noBackground);
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!0), void 0);
    },
    activeChanged: function() {
        this.bubble("onActivate");
    },
    depress: function() {
        this.addClass("pressed");
    },
    undepress: function() {
        this.removeClass("pressed");
    },
    spotlightFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    }
});

// lib\moonstone\source\Scroller.js
enyo.kind({
    name: "moon.Scroller",
    kind: "enyo.Scroller",
    published: {
        scrollFullPage: !1,
        spotlightPagingControls: !1,
        scrollInterval: 75,
        scrollWheelMultiplier: 2,
        scrollWheelPageMultiplier: .2,
        paginationPageMultiplier: .8,
        paginationScrollMultiplier: 8,
        scrollWheelMovesFocus: !0
    },
    handlers: {
        onSpotlightScrollUp: "spotlightWheel",
        onSpotlightScrollDown: "spotlightWheel",
        onSpotlightContainerEnter: "spotlightHello",
        onSpotlightFocus: "spotlightHello",
        onSpotlightContainerLeave: "spotlightGoodbye"
    },
    preventScrollPropagation: !1,
    strategyKind: "moon.ScrollStrategy",
    scrollToControl: function(t, e, i, n) {
        n && this.$.strategy.setLastFocusedChild(t), this.$.strategy.animateToControl(t, e, i);
    },
    scrollTo: function(t, e, i) {
        this.$.strategy.scrollTo(t, e, i);
    },
    bindings: [ {
        from: ".scrollInterval",
        to: ".$.strategy.interval"
    }, {
        from: ".scrollWheelMultiplier",
        to: ".$.strategy.scrollWheelMultiplier"
    }, {
        from: ".scrollWheelPageMultiplier",
        to: ".$.strategy.scrollWheelPageMultiplier"
    }, {
        from: ".paginationPageMultiplier",
        to: ".$.strategy.paginationPageMultiplier"
    }, {
        from: ".paginationScrollMultiplier",
        to: ".$.strategy.paginationScrollMultiplier"
    } ],
    create: function() {
        this.inherited(arguments), this.spotlightPagingControlsChanged(), this.scrollWheelMovesFocusChanged();
    },
    spotlightPagingControlsChanged: function() {
        this.$.strategy.set("spotlightPagingControls", this.spotlightPagingControls);
    },
    scrollWheelMovesFocusChanged: function() {
        this.scrollWheelMovesFocus || this.setUseMouseWheel(!0);
    },
    spotlightWheel: function(t, e) {
        if (this.scrollWheelMovesFocus && !enyo.Spotlight.getPointerMode()) {
            var i = enyo.Spotlight.getCurrent();
            if (i && i.isDescendantOf(this)) {
                var n = "onSpotlightScrollUp" == e.type ? "onSpotlightUp" : "onSpotlightDown";
                return this._spotlightModal = this.spotlightModal, this.spotlightModal = !0, enyo.Spotlight.Util.dispatchEvent(n, {
                    type: n
                }, i), this.spotlightModal = this._spotlightModal, !0;
            }
        }
    },
    spotlightHello: function() {
        this.$.strategy.showHideScrollColumns && this.$.strategy.showHideScrollColumns(!0);
    },
    spotlightGoodbye: function(t, e) {
        e.originator.owner === this.$.strategy && this.$.strategy.showHideScrollColumns && this.$.strategy.showHideScrollColumns(!1);
    },
    previewDomEvent: function(t) {
        this.scrollWheelMovesFocus && "mousewheel" == t.type && this.setUseMouseWheel(enyo.Spotlight.getPointerMode());
    }
}), enyo.platform.touch && (moon.Scroller = enyo.Scroller);

// lib\moonstone\source\DataList.js
moon.DataListSpotlightSupport = {
    published: {
        initialFocusIndex: -1
    },
    handlers: {
        onSpotlightUp: "selectPrev",
        onSpotlightLeft: "selectPrev",
        onSpotlightDown: "selectNext",
        onSpotlightRight: "selectNext"
    },
    focusOnIndex: function(t, e) {
        var i, n, o = this.collection;
        o && o.length && this.hasRendered ? (t = 0 > t ? 0 : t >= o.length ? o.length - 1 : t, 
        i = this.childForIndex(t), i || (this.scrollToIndex(t), i = this.childForIndex(t)), 
        n = e ? enyo.Spotlight.getChildren(i)[e] : i, enyo.Spotlight.spot(n)) : (this._indexToFocus = t, 
        this._subChildToFocus = e);
    },
    getFocusedIndex: function() {
        var t = this.getFocusedChild();
        return t ? this.getIndexFromChild(t) : -1;
    },
    getFocusedChild: function() {
        var t = enyo.Spotlight.getCurrent();
        return t && t.isDescendantOf(this.$.active) ? t : null;
    },
    _indexToFocus: -1,
    _subChildToFocus: null,
    didRender: function() {
        this.spotlight = !1;
        var t = this._indexToFocus > -1 ? this._indexToFocus : this.initialFocusIndex;
        t > -1 ? (this.focusOnIndex(t), this._indexToFocus = -1) : enyo.Spotlight.getCurrent() == this && enyo.Spotlight.spot(this);
    },
    didScroll: enyo.inherit(function(t) {
        return function() {
            var e;
            return enyo.Spotlight.getPointerMode() && (e = enyo.Spotlight.getCurrent()) && (e === this || e.isDescendantOf(this.$.active)) && (enyo.Spotlight.unspot(), 
            this._unspotSinceSpot = !0), t.apply(this, arguments);
        };
    }),
    selectNext: function(t, e) {
        return this.selectItem(e, 1);
    },
    selectPrev: function(t, e) {
        return this.selectItem(e, -1);
    },
    selectItem: function(t, e) {
        var i, n = this.delegate.pagesByPosition(this);
        return !this.getNextSpottableChild(e) && (1 === e ? i = this.findSpottableControl(e, n.firstPage, n.lastPage.index + 1) : -1 === e && (i = this.findSpottableControl(e, n.lastPage, n.firstPage.index - 1)), 
        i) ? (enyo.Spotlight.spot(i), !0) : void 0;
    },
    findSpottableControl: function(t, e, i) {
        if (i > this.delegate.pageCount(this) - 1 || 0 > i) return null;
        this.delegate.generatePage(this, e, i), this.delegate.adjustPagePositions(this), 
        this.delegate.adjustBuffer(this);
        var n = this.delegate.pagesByPosition(this), o = this.getNextSpottableChild(t);
        if (!o) {
            if (1 === t) return this.findSpottableControl(t, e === n.firstPage ? n.lastPage : n.firstPage, i + 1);
            if (-1 === t) return this.findSpottableControl(t, e === n.firstPage ? n.lastPage : n.firstPage, i - 1);
        }
        return o;
    },
    previewDomEvent: function(t) {
        if ("onSpotlightFocus" == t.type && this._unspotSinceSpot) if (enyo.Spotlight.getPointerMode()) this._unspotSinceSpot = !1; else {
            var e = t.originator;
            if (e != this) {
                var i = e.getBounds(), n = e.isDescendantOf(this.$.page1) ? this.$.page1 : this.$.page2, o = n.getBounds();
                i.top += o.top, i.left += o.left;
                var s = this.$.scroller.getScrollBounds();
                if (i.top < s.top || i.left < s.left || i.top + i.height > s.top + s.clientHeight || i.left + i.width > s.left + s.clientWidth) {
                    var a = this.getFirstVisibleChild(s);
                    return a && (this._unspotSinceSpot = !1, enyo.Spotlight.spot(a)), !0;
                }
                this._unspotSinceSpot = !1;
            }
        }
    },
    getFirstVisibleChild: function(t) {
        var e = this.$.page1.index < this.$.page2.index ? [ this.$.page1, this.$.page2 ] : [ this.$.page2, this.$.page1 ];
        for (var i in e) for (var n = e[i], o = n.getBounds(), s = 0; n.children.length > s; s++) {
            var a = n.children[s], r = a.getBounds();
            if (r.top += o.top, r.left += o.left, r.top >= t.top && (this.rtl ? t.width - (r.left + r.width) : r.left) >= t.left) {
                if (enyo.Spotlight.isSpottable(a)) return a;
                if (a = enyo.Spotlight.getFirstChild(a)) return a;
            }
        }
        return null;
    },
    getNextSpottableChild: function(t) {
        var e, i, n, o, s, a = this.getFocusedIndex(), r = 1 === t && this.$.page1.index < this.$.page2.index || -1 === t && this.$.page1.index > this.$.page2.index ? [ this.$.page1, this.$.page2 ] : [ this.$.page2, this.$.page1 ];
        for (n = 0; r.length > n; n++) if (i = r[n], 1 === t) {
            for (e = 0; i.children.length > e; e++) if (o = i.children[e], s = this.getIndexFromChild(o), 
            s > a || 0 > a) {
                if (enyo.Spotlight.isSpottable(o, !1)) return o;
                if (o = enyo.Spotlight.getFirstChild(o)) return o;
            }
        } else if (-1 === t) for (e = i.children.length - 1; e >= 0; e--) if (o = i.children[e], 
        s = this.getIndexFromChild(o), a > s || 0 > a) {
            if (enyo.Spotlight.isSpottable(o, !1)) return o;
            if (o = enyo.Spotlight.getFirstChild(o)) return o;
        }
        return null;
    },
    getItemFromChild: function(t) {
        for (;t; ) {
            if (void 0 !== t.index) return t;
            t = t.parent;
        }
        return null;
    },
    getIndexFromChild: function(t) {
        var e = this.getItemFromChild(t);
        return e ? e.index : -1;
    },
    unspotAndRememberFocus: function() {
        var t, e = this.getFocusedChild();
        e && (t = this.getItemFromChild(e), this._indexToFocus = t.index, this._subChildToFocus = t === e ? null : enyo.Spotlight.getChildren(t).indexOf(e), 
        enyo.Spotlight.unspot());
    },
    restoreFocus: function() {
        var t = this._indexToFocus, e = this._subChildToFocus, i = this.collection;
        i && i.length && t > -1 && (this.focusOnIndex(t, e), this._indexToFocus = -1, this._subChildToFocus = null);
    },
    didResize: enyo.inherit(function(t) {
        return function() {
            this.unspotAndRememberFocus(), t.apply(this, arguments), this.restoreFocus();
        };
    }),
    modelsAdded: enyo.inherit(function(t) {
        return function() {
            this.unspotAndRememberFocus(), t.apply(this, arguments), this.restoreFocus();
        };
    }),
    modelsRemoved: enyo.inherit(function(t) {
        return function() {
            this.unspotAndRememberFocus(), t.apply(this, arguments), this.restoreFocus();
        };
    })
}, enyo.kind({
    name: "moon.DataList",
    kind: "enyo.DataList",
    mixins: [ "moon.DataListSpotlightSupport" ],
    noDefer: !0,
    allowTransitions: !1,
    spotlight: !0,
    scrollerOptions: {
        kind: "moon.Scroller",
        horizontal: "hidden"
    }
}), function(t, e) {
    e.DataList.delegates.vertical = t.clone(e.DataList.delegates.vertical), e.DataList.delegates.horizontal = t.clone(e.DataList.delegates.horizontal);
    var i = {
        refresh: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments), e.$.scroller.resized();
            };
        }),
        scrollToIndex: function(t, e) {
            if (!(0 > e || e >= t.collection.length)) {
                var i = this.childForIndex(t, e), n = this.pageForIndex(t, e);
                if (!(0 > n || n > this.pageCount(t))) if (i) t.$.scroller.scrollToControl(i, !1, !1, !0); else {
                    var o = t.$.page1.index;
                    n > o ? (t.$.page1.index = n - 1, t.$.page2.index = n) : (t.$.page1.index = n, t.$.page2.index = n + 1), 
                    t.refresh(), this.scrollToIndex(t, e);
                }
            }
        }
    };
    t.kind.extendMethods(e.DataList.delegates.vertical, i, !0), t.kind.extendMethods(e.DataList.delegates.vertical, {
        reset: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments), "scroll" != e.$.scroller.getVertical() && (this.updateBounds(e), 
                e.refresh()), e.$.scroller.scrollTo(0, 0, !1);
            };
        }),
        updateBounds: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments);
                var i = e.boundsCache.width, n = e.$.scroller.getScrollBounds(), o = e.$.scroller.$.strategy.$.vColumn;
                o && ("scroll" == e.$.scroller.getVertical() || n.height > n.clientHeight) && (e.boundsCache.width = i - o.hasNode().offsetWidth);
            };
        })
    }, !0), t.kind.extendMethods(e.DataList.delegates.horizontal, i, !0), t.kind.extendMethods(e.DataList.delegates.horizontal, {
        reset: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments), "scroll" != e.$.scroller.getHorizontal() && (this.updateBounds(e), 
                e.refresh()), e.$.scroller.scrollTo(0, 0, !1);
            };
        }),
        updateBounds: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments);
                var i = e.boundsCache.height, n = e.$.scroller.getScrollBounds(), o = e.$.scroller.$.strategy.$.hColumn.hasNode();
                ("scroll" == e.$.scroller.getVertical() || n.width > n.clientWidth) && (e.boundsCache.height = i - o.offsetHeight);
            };
        })
    }, !0);
}(enyo, moon);

// lib\moonstone\source\PagingControl.js
enyo.kind({
    name: "moon.PagingControl",
    kind: "moon.IconButton",
    classes: "moon-paging-button no-background",
    spotlight: !0,
    published: {
        side: null
    },
    noBackground: !0,
    handlers: {
        onSpotlightFocused: "noop",
        onSpotlightSelect: "depress",
        onSpotlightKeyUp: "undepress",
        ondown: "down",
        onup: "endHold",
        onleave: "endHold",
        onhold: "hold",
        onActivate: "noop"
    },
    events: {
        onPaginate: "",
        onPaginateScroll: ""
    },
    downTime: 0,
    initialDelta: 2.5,
    delta: 0,
    maxDelta: 100,
    tapDelta: 15,
    bumpDeltaMultiplier: 3,
    create: function() {
        this.inherited(arguments), this.sideChanged();
    },
    hitBoundary: function() {
        this.stopHoldJob(), this.downTime = null, this.doPaginate({
            scrollDelta: this.delta * this.bumpDeltaMultiplier
        }), enyo.Spotlight.Accelerator.cancel();
    },
    _iconMappings: {
        top: "arrowlargeup",
        bottom: "arrowlargedown",
        left: "arrowlargeleft",
        right: "arrowlargeright"
    },
    sideChanged: function(t) {
        var e = this.getSide();
        this.removeClass(t), this.addClass(e), this.setIcon(this._iconMappings[e]);
    },
    down: function() {
        this.disabled || (this.downTime = enyo.bench(), this.delta = this.initialDelta);
    },
    hold: function() {
        this.disabled || this.startHoldJob();
    },
    depress: function() {
        this.inherited(arguments), this.downCount ? this.downCount++ : (this.down(), this.downCount = 1), 
        2 == this.downCount && this.hold();
    },
    undepress: function(t, e) {
        this.inherited(arguments), this.downCount = 0, this.endHold(t, e);
    },
    endHold: function() {
        this.downTime && (this.stopHoldJob(), this.sendPaginateEvent(), this.downTime = null);
    },
    startHoldJob: function() {
        this.stopHoldJob();
        var t = enyo.bench(), e = 0, i = this.bindSafely(function() {
            this.job = enyo.requestAnimationFrame(i), e = (enyo.bench() - t) / 1e3, this.delta = Math.min(this.maxDelta, this.delta + .1 * Math.pow(e, 1.1)), 
            this.doPaginateScroll({
                scrollDelta: this.delta
            });
        });
        this.job = enyo.requestAnimationFrame(i);
    },
    stopHoldJob: function() {
        this.job = enyo.cancelRequestAnimationFrame(this.job);
    },
    sendPaginateEvent: function() {
        var t = 200, e = enyo.bench() - this.downTime, i = t >= e ? this.tapDelta : this.delta;
        this.doPaginate({
            scrollDelta: i
        });
    },
    noop: function() {
        return !0;
    }
});

// lib\moonstone\source\IntegerPicker.js
enyo.kind({
    name: "moon.IntegerPicker",
    classes: "moon-scroll-picker-container",
    published: {
        value: null,
        min: 0,
        max: 9,
        digits: null,
        wrap: !1
    },
    handlers: {
        onSpotlightUp: "next",
        onSpotlightDown: "previous",
        onSpotlightBlur: "spotlightBlur",
        onSpotlightScrollUp: "next",
        onSpotlightScrollDown: "previous",
        onmousewheel: "mousewheel"
    },
    events: {
        onChange: ""
    },
    spotlight: !0,
    scrollBounds: {},
    components: [ {
        name: "topOverlay",
        ondown: "downNext",
        onholdpulse: "next",
        classes: "moon-scroll-picker-overlay-container top top-image",
        components: [ {
            classes: "moon-scroll-picker-overlay top"
        }, {
            classes: "moon-scroll-picker-taparea"
        } ]
    }, {
        kind: "enyo.Scroller",
        thumb: !1,
        touch: !0,
        useMouseWheel: !1,
        classes: "moon-scroll-picker",
        components: [ {
            name: "repeater",
            kind: "enyo.FlyweightRepeater",
            ondragstart: "dragstart",
            onSetupItem: "setupItem",
            components: [ {
                name: "item",
                classes: "moon-scroll-picker-item"
            } ]
        } ]
    }, {
        name: "bottomOverlay",
        ondown: "downPrevious",
        onholdpulse: "previous",
        classes: "moon-scroll-picker-overlay-container bottom bottom-image",
        components: [ {
            classes: "moon-scroll-picker-overlay bottom"
        }, {
            classes: "moon-scroll-picker-taparea"
        } ]
    } ],
    scrollFrame: 3,
    create: function() {
        this.inherited(arguments), this.verifyValue(), this.updateOverlays();
    },
    rendered: function() {
        this.inherited(arguments), this.rangeChanged(), this.refreshScrollState(), this.$.scroller.getStrategy().setFixedTime(!1), 
        this.$.scroller.getStrategy().setFrame(this.scrollFrame);
    },
    getVerifiedValue: function() {
        return this.value >= this.min && this.value <= this.max ? this.value : this.min;
    },
    verifyValue: function() {
        this.value = this.getVerifiedValue();
    },
    refreshScrollState: function() {
        this.updateScrollBounds();
        var t = this.$.repeater.fetchRowNode(this.value - this.min);
        t && this.$.scroller.scrollToNode(t);
    },
    setupItem: function(t, e) {
        var i = e.index, n = i + this.min;
        this.digits && (n = ("00000000000000000000" + n).slice(-this.digits)), this.$.item.setContent(n);
    },
    rangeChanged: function() {
        this.verifyValue(), this.$.repeater.setCount(this.max - this.min + 1), this.$.repeater.render(), 
        enyo.asyncMethod(this.bindSafely(function() {
            var t = this.$.repeater.fetchRowNode(this.value - this.min);
            t && this.$.scroller.scrollToNode(t);
        }));
    },
    valueChanged: function() {
        this.value < this.min ? this.setMin(this.value) : this.value > this.max && this.setMax(this.value);
        var t = this.$.repeater.fetchRowNode(this.value - this.min);
        t && this.$.scroller.scrollTo(t.offsetLeft, t.offsetTop), this.updateOverlays();
    },
    dragstart: function() {
        return !0;
    },
    minChanged: function() {
        this.rangeChanged();
    },
    maxChanged: function() {
        this.rangeChanged();
    },
    previous: function(t, e) {
        if (this.value > this.min) this.setValue(this.value - 1); else {
            if (!this.wrap) return;
            this.setValue(this.max);
        }
        return this.$.bottomOverlay.addClass("selected"), e.originator != this.$.upArrow && this.startJob("hideBottomOverlay", "hideBottomOverlay", 350), 
        this.fireChangeEvent(), !0;
    },
    next: function(t, e) {
        if (this.value < this.max) this.setValue(this.value + 1); else {
            if (!this.wrap) return;
            this.setValue(this.min);
        }
        return this.$.topOverlay.addClass("selected"), e.originator != this.$.downArrow && this.startJob("hideTopOverlay", "hideTopOverlay", 350), 
        this.fireChangeEvent(), !0;
    },
    downPrevious: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.previous(t, e);
    },
    downNext: function(t, e) {
        e.configureHoldPulse({
            endHold: "onLeave",
            delay: 300
        }), this.next(t, e);
    },
    updateOverlays: function() {
        this.$.bottomOverlay.addRemoveClass("bottom-image", this.wrap || this.value !== this.min), 
        this.$.topOverlay.addRemoveClass("top-image", this.wrap || this.value !== this.max);
    },
    hideTopOverlay: function() {
        this.$.topOverlay.removeClass("selected");
    },
    hideBottomOverlay: function() {
        this.$.bottomOverlay.removeClass("selected");
    },
    fireChangeEvent: function() {
        this.doChange({
            name: this.name,
            value: this.value
        });
    },
    resetOverlay: function() {
        this.hideTopOverlay(), this.hideBottomOverlay();
    },
    spotlightFocus: function() {
        this.bubble("onRequestScrollIntoView");
    },
    spotlightBlur: function() {
        this.hideTopOverlay(), this.hideBottomOverlay();
    },
    updateScrollBounds: function() {
        this.scrollBounds = this.$.scroller.getStrategy()._getScrollBounds();
    },
    setScrollTop: function(t) {
        this.$.scroller.setScrollTop(t);
    },
    stabilize: function() {
        this.$.scroller.stabilize();
    },
    mousewheel: function(t, e) {
        return e.preventDefault(), !0;
    }
}), moon.IntegerScrollPicker = moon.IntegerPicker;

// lib\moonstone\source\DateTimePickerBase.js
enyo.kind({
    name: "moon.DateTimePickerBase",
    kind: "moon.ExpandableListItem",
    defaultKind: "enyo.Control",
    classes: "moon-expandable-picker moon-date-picker",
    events: {
        onChange: ""
    },
    handlers: {
        onChange: "handleChangeEvent"
    },
    published: {
        noneText: "",
        locale: null,
        value: null,
        meridiemEnable: !1
    },
    iLibFormatType: null,
    defaultOrdering: null,
    components: [ {
        name: "headerWrapper",
        kind: "moon.Item",
        classes: "moon-date-picker-header-wrapper",
        onSpotlightFocus: "headerFocus",
        ontap: "expandContract",
        components: [ {
            name: "headerContainer",
            classes: "moon-expandable-list-item-header moon-expandable-picker-header moon-expandable-datetime-header",
            components: [ {
                name: "header",
                kind: "moon.MarqueeText"
            } ]
        }, {
            name: "currentValue",
            kind: "moon.MarqueeText",
            classes: "moon-expandable-picker-current-value"
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client indented",
        components: [ {
            name: "client",
            kind: "enyo.Control",
            classes: "enyo-tool-decorator moon-date-picker-client",
            onSpotlightLeft: "closePicker",
            onSpotlightSelect: "closePicker"
        } ]
    } ],
    bindings: [ {
        from: ".disabled",
        to: ".$.headerWrapper.disabled"
    } ],
    create: function() {
        this.inherited(arguments), this.createComponent({
            kind: "enyo.Signals",
            onlocalechange: "handleLocaleChangeEvent"
        }), this.initDefaults();
    },
    initILib: function() {
        var t = {
            type: this.iLibFormatType,
            useNative: !1,
            timezone: "local",
            length: "full"
        };
        this.locale ? (t.locale = this.locale, this.iLibLocale = null) : this.iLibLocale = ilib.getLocale(), 
        this._tf = new ilib.DateFmt(t);
    },
    initDefaults: function() {
        var t;
        "undefined" != typeof ilib ? (this.initILib(), t = this._tf.getTemplate()) : t = this.defaultOrdering, 
        this.setupPickers(t), this.noneTextChanged();
    },
    setupPickers: function() {
        this.pickers = this.getClientControls();
    },
    formatValue: function() {},
    handleChangeEvent: function(t, e) {
        return e && e.originator === this ? void 0 : (this.updateValue(t, e), !0);
    },
    updateValue: function() {},
    valueChanged: function(t) {
        this.setChildPickers(t), this.value ? this.doChange({
            name: this.name,
            value: this.value
        }) : this.noneTextChanged();
    },
    setChildPickers: function() {},
    noneTextChanged: function() {
        this.value ? this.$.currentValue.setContent(this.formatValue()) : this.$.currentValue.setContent(this.getNoneText());
    },
    openChanged: function() {
        this.inherited(arguments);
        var t, e, i = this.$.drawer.get("open"), n = this.pickers;
        if (this.$.currentValue.setShowing(!i), n) for (t = 0; n.length > t; t++) e = n[t], 
        e.getClientControls().length > 0 && (e = e.getClientControls()[0]), i ? e.refreshScrollState() : e.stabilize();
    },
    toggleActive: function() {
        this.getOpen() ? (this.setActive(!1), enyo.Spotlight.getPointerMode() || enyo.Spotlight.spot(this.$.headerWrapper)) : (this.value || this.setValue(new Date()), 
        this.setActive(!0));
    },
    closePicker: function(t, e) {
        return "onSpotlightSelect" == e.type || this.$.client.children[0].id == e.originator.id ? (this.expandContract(), 
        this.noneTextChanged(), !0) : void 0;
    },
    localeChanged: function() {
        this.refresh();
    },
    handleLocaleChangeEvent: function() {
        ilib && ilib.getLocale() !== this.iLibLocale ? this.refresh() : this.setChildPickers();
    },
    refresh: function() {
        this.destroyClientControls(), this.pickers = null, this._tf && delete this._tf, 
        this.initDefaults(), this.render();
    }
});

// lib\moonstone\source\DatePicker.js
enyo.kind({
    name: "moon.DatePicker",
    kind: "moon.DateTimePickerBase",
    published: {
        minYear: 1900,
        maxYear: 2099,
        dayText: moon.$L("day"),
        monthText: moon.$L("month"),
        yearText: moon.$L("year")
    },
    iLibFormatType: "date",
    defaultOrdering: "Mdy",
    yearOffset: 0,
    initILib: function() {
        this.inherited(arguments);
        var t = this.value ? this.value.getTime() : 0, e = new ilib.Date.newInstance({
            type: "gregorian",
            unixtime: t,
            timezone: "UTC"
        }).getYears(), i = new ilib.Date.newInstance({
            type: this._tf.getCalendar(),
            unixtime: t,
            timezone: "UTC"
        }).getYears();
        this.yearOffset = e - i;
    },
    setupPickers: function(t) {
        var e, i, n, o, s = t.split(""), a = [];
        for (i = 0, n = s.length; n > i; i++) e = s[i], 0 > a.indexOf(e) && a.push(e);
        for (i = 0, n = a.length; n > i; i++) {
            e = a[i];
            var r = this.value ? this.value.getFullYear() : 0, h = this.value ? this.value.getMonth() : 0, l = this.value ? this.value.getDate() : 0;
            switch (e) {
              case "d":
                o = t.indexOf("dd") > -1 ? 2 : null, this.createComponent({
                    classes: "moon-date-picker-wrap",
                    components: [ {
                        kind: "moon.IntegerPicker",
                        name: "day",
                        classes: "moon-date-picker-field",
                        wrap: !0,
                        digits: o,
                        min: 1,
                        max: this.monthLength(r, h),
                        value: l
                    }, {
                        name: "dayLabel",
                        content: this.dayText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              case "M":
                o = t.indexOf("MM") > -1 ? 2 : null, this.createComponent({
                    classes: "moon-date-picker-wrap",
                    components: [ {
                        kind: "moon.IntegerPicker",
                        name: "month",
                        classes: "moon-date-picker-field",
                        wrap: !0,
                        min: 1,
                        max: 12,
                        value: h + 1
                    }, {
                        name: "monthLabel",
                        content: this.monthText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              case "y":
                this.createComponent({
                    classes: "moon-date-picker-wrap year",
                    components: [ {
                        kind: "moon.IntegerPicker",
                        name: "year",
                        classes: "moon-date-picker-field year",
                        value: r - this.yearOffset,
                        min: this.minYear - this.yearOffset,
                        max: this.maxYear - this.yearOffset
                    }, {
                        name: "yearLabel",
                        content: this.yearText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              default:            }
        }
        this.inherited(arguments);
    },
    formatValue: function() {
        if (!this.value) return this.noneText;
        if (!this._tf) return this.getMonthName()[this.value.getMonth()] + " " + this.value.getDate() + ", " + this.value.getFullYear();
        switch (this._tf.getCalendar()) {
          case "gregorian":
            return this._tf.format(new ilib.Date.GregDate({
                unixtime: this.value.getTime(),
                timezone: "UTC"
            }));

          case "thaisolar":
            return this._tf.format(new ilib.Date.ThaiSolarDate({
                unixtime: this.value.getTime(),
                timezone: "UTC"
            }));
        }
    },
    updateValue: function() {
        var t = this.value ? this.value.getHours() : 0, e = this.value ? this.value.getMinutes() : 0, i = this.value ? this.value.getSeconds() : 0, n = this.value ? this.value.getMilliseconds() : 0, o = this.$.day.getValue(), s = this.$.month.getValue() - 1, a = this.$.year.getValue() + this.yearOffset, r = this.monthLength(a, s);
        this.setValue(new Date(a, s, r >= o ? o : r, t, e, i, n));
    },
    setChildPickers: function(t) {
        if (this.value) {
            var e = t && (t.getFullYear() != this.value.getFullYear() || t.getMonth() != this.value.getMonth());
            this.$.year.setValue(this.value.getFullYear() - this.yearOffset), this.$.month.setValue(this.value.getMonth() + 1), 
            e && (this.$.day.setMax(this.monthLength(this.value.getFullYear(), this.value.getMonth())), 
            this.$.day.updateScrollBounds()), this.$.day.setValue(this.value.getDate()), e && this.$.day.updateOverlays();
        }
        this.$.currentValue.setContent(this.formatValue());
    },
    getMonthName: function() {
        return [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
    },
    monthLength: function(t, e) {
        return 32 - new Date(t, e, 32).getDate();
    },
    yearTextChanged: function(t, e) {
        this.$.yearLabel.setContent(e);
    },
    monthTextChanged: function(t, e) {
        this.$.monthLabel.setContent(e);
    },
    dayTextChanged: function(t, e) {
        this.$.dayLabel.setContent(e);
    }
});

// lib\moonstone\source\TimePicker.js
enyo.kind({
    name: "moon.MeridiemPicker",
    kind: "moon.IntegerPicker",
    classes: "moon-date-picker-month",
    min: 0,
    max: 1,
    value: null,
    published: {
        meridiems: [ "AM", "PM" ]
    },
    valueChanged: function() {
        this.inherited(arguments), this.updateOverlays();
    },
    setupItem: function(t, e) {
        var i = e.index;
        this.$.item.setContent(this.meridiems[i]);
    }
}), enyo.kind({
    name: "moon.HourPicker",
    kind: "moon.IntegerPicker",
    classes: "moon-date-picker-field",
    min: 0,
    max: 23,
    value: null,
    formatter: null,
    wrap: !0,
    create: function() {
        this.inherited(arguments), "undefined" != typeof ilib && (this.date = ilib.Date.newInstance());
    },
    setupItem: function(t, e) {
        var i = e.index;
        this.date ? (this.date.hour = i, i = this.formatter.format(this.date)) : i = this.formatter.formatHour(i), 
        this.$.item.setContent(i);
    }
}), enyo.kind({
    name: "moon.TimePicker",
    kind: "moon.DateTimePickerBase",
    published: {
        meridiemEnable: !1,
        hourText: moon.$L("hour"),
        minuteText: moon.$L("minute"),
        meridiemText: moon.$L("meridiem"),
        hoursStartAtZero: !1,
        hoursZeroPadded: !1
    },
    observers: {
        refresh: [ "hoursStartAtZero", "meridiemEnable", "hoursZeroPadded" ]
    },
    iLibFormatType: "time",
    defaultOrdering: "hma",
    initILib: function() {
        this.inherited(arguments);
        var t = new ilib.LocaleInfo(this.locale || void 0), e = t.getClock();
        this.meridiemEnable = "12" == e;
        var i = {
            type: "time",
            time: "h",
            clock: "locale" !== e ? e : void 0,
            useNative: !1,
            timezone: "local"
        };
        if (this.locale && (i.locale = this.locale), this.hourFormatter = new ilib.DateFmt(i), 
        this.meridiemEnable) {
            i = {
                template: "a",
                clock: "locale" !== e ? e : void 0,
                useNative: !1,
                timezone: "local"
            }, this.locale && (i.locale = this.locale);
            var n = new ilib.DateFmt(i), o = ilib.Date.newInstance({
                hour: 10
            }), s = ilib.Date.newInstance({
                hour: 14
            });
            this.meridiems = [ n.format(o), n.format(s) ];
        }
    },
    setupPickers: function(t) {
        var e, i, n, o = t.toLowerCase().split(""), s = [];
        for (i = 0, n = o.length; n > i; i++) e = o[i], 0 > s.indexOf(e) && s.push(e);
        for (i = 0, n = s.length; n > i; i++) {
            e = s[i];
            var a = this.value ? this.value.getHours() : 0, r = this.value ? this.value.getMinutes() : 0;
            switch (e) {
              case "h":
              case "k":
                this.createComponent({
                    classes: "moon-date-picker-wrap",
                    components: [ {
                        kind: "moon.HourPicker",
                        name: "hour",
                        formatter: this.hourFormatter || this,
                        value: a
                    }, {
                        name: "hourLabel",
                        content: this.hourText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              case "m":
                this.createComponent({
                    classes: "moon-date-picker-wrap",
                    components: [ {
                        kind: "moon.IntegerPicker",
                        name: "minute",
                        classes: "moon-date-picker-field",
                        min: 0,
                        max: 59,
                        wrap: !0,
                        digits: 2,
                        value: r
                    }, {
                        name: "minuteLabel",
                        content: this.minuteText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              case "a":
                this.meridiemEnable === !0 && this.createComponent({
                    classes: "moon-date-picker-wrap",
                    components: [ {
                        kind: "moon.MeridiemPicker",
                        name: "meridiem",
                        classes: "moon-date-picker-field",
                        value: a > 12 ? 1 : 0,
                        meridiems: this.meridiems || [ "am", "pm" ]
                    }, {
                        name: "meridiemLabel",
                        content: this.meridiemText,
                        classes: "moon-date-picker-label moon-divider-text"
                    } ]
                });
                break;

              default:            }
        }
        this.inherited(arguments);
    },
    formatValue: function() {
        if (!this.value) return this.noneText;
        var t = "";
        return this._tf ? t = this._tf.format(ilib.Date.newInstance({
            unixtime: this.value.getTime(),
            timezone: "Etc/UTC"
        })) : (t += this.formatHour(this.value.getHours()), t += ":" + ("00" + this.value.getMinutes()).slice(-2) + " ", 
        t += this.meridiemEnable ? this.$.meridiem.getMeridiems()[this.$.meridiem.getValue()] : ""), 
        t;
    },
    formatHour: function(t) {
        return this.meridiemEnable ? (t > 12 && (t -= 12), this.hoursStartAtZero ? 12 == t && (t = 0) : t = t || 12) : this.hoursStartAtZero || (t = t || 24), 
        this.hoursZeroPadded && (t = ("0" + t).slice(-2)), t;
    },
    updateValue: function(t, e) {
        var i = this.$.hour.getValue(), n = this.$.minute.getValue();
        if ("moon.MeridiemPicker" == e.originator.kind && (12 > i && 1 == e.originator.value ? i += 12 : i > 12 && 24 != i && 0 === e.originator.value ? i -= 12 : 24 == i && 1 === e.originator.value ? i -= 12 : 12 == i && 0 === e.originator.value && (i += 12), 
        this.$.hour.setScrollTop(e.originator.scrollBounds.clientHeight * (i - 1)), this.$.hour.setValue(i)), 
        "moon.HourPicker" == e.originator.kind) {
            var o = this.value ? this.value.getTime() : 0, s = this.value ? this.value.getHours() : 0;
            this.setValue(new Date(o + 1e3 * 60 * 60 * (i - s)));
        } else {
            var a = this.value ? this.value.getFullYear() : 0, r = this.value ? this.value.getMonth() : 0, h = this.value ? this.value.getDate() : 0, l = this.value ? this.value.getSeconds() : 0, d = this.value ? this.value.getMilliseconds() : 0;
            this.setValue(new Date(a, r, h, i, n, l, d));
        }
    },
    setChildPickers: function() {
        if (this.value) {
            var t = this.value.getHours();
            this.meridiemEnable === !0 && this.$.meridiem.setValue(t > 11 ? 1 : 0), this.$.hour.setValue(this.value.getHours()), 
            this.$.minute.setValue(this.value.getMinutes());
        }
        this.$.currentValue.setContent(this.formatValue());
    },
    hourTextChanged: function(t, e) {
        this.$.hourLabel.setContent(e);
    },
    minuteTextChanged: function(t, e) {
        this.$.minuteLabel.setContent(e);
    },
    meridiemTextChanged: function(t, e) {
        this.$.meridiemLabel.setContent(e);
    }
});

// lib\moonstone\source\Input.js
enyo.kind({
    name: "moon.Input",
    kind: "enyo.Input",
    classes: "moon-input",
    spotlightIgnoredKeys: [ 13, 16777221 ],
    published: {
        dismissOnEnter: !1
    },
    handlers: {
        onkeypress: "onKeyUp",
        onblur: "onBlur",
        onfocus: "onFocus"
    },
    _bFocused: !1,
    onFocus: function() {
        if (this.dismissOnEnter) {
            var t = this;
            enyo.asyncMethod(this, function() {
                t._bFocused = !0;
            });
        }
    },
    onBlur: function() {
        this.dismissOnEnter && (this._bFocused = !1);
    },
    onKeyUp: function(t, e) {
        this.dismissOnEnter && 13 == e.keyCode && this._bFocused && this.blur();
    },
    blur: function() {
        this.hasNode() && this.node.blur();
    },
    left: function() {
        return this.hasNode() && 0 !== this.node.selectionStart ? !0 : !1;
    },
    right: function() {
        return this.hasNode() && this.node.selectionStart != this.node.value.length ? !0 : !1;
    },
    up: function() {
        return !1;
    },
    down: function() {
        return !1;
    }
});

// lib\moonstone\source\InputDecorator.js
enyo.kind({
    name: "moon.InputDecorator",
    kind: "enyo.ToolDecorator",
    tag: "label",
    spotlight: !0,
    spotlightDecorate: !1,
    handlers: {
        onDisabledChange: "disabledChangeHandler",
        onfocus: "focusHandler",
        onblur: "blurHandler",
        onSpotlightFocus: "spotlightFocusHandler",
        onSpotlightSelect: "spotlightSelectHandler",
        onSpotlightBlur: "spotlightBlurHandler",
        onSpotlightLeft: "spotlightLeftHandler",
        onSpotlightRight: "spotlightRightHandler",
        onSpotlightUp: "spotlightUpHandler",
        onSpotlightDown: "spotlightDownHandler"
    },
    _oInputControl: null,
    _isInput: function(t) {
        return t instanceof moon.Input || t instanceof moon.RichText || t instanceof moon.TextArea;
    },
    _findInputControl: function(t) {
        t = t || this;
        for (var e = null, i = 0; t.children.length > i; i++) {
            if (this._isInput(t.children[i])) return t.children[i];
            if (e = this._findInputControl(t.children[i])) return e;
        }
    },
    create: function() {
        this.inherited(arguments), this.updateFocus(!1), this._oInputControl = this._findInputControl(), 
        this._oInputControl instanceof moon.Input && this.addClass("moon-input-decorator"), 
        (this._oInputControl instanceof moon.TextArea || this._oInputControl instanceof moon.RichText) && this.addClass("moon-textarea-decorator");
    },
    createComponent: function() {
        this.inherited(arguments), this._oInputControl = this._findInputControl();
    },
    createComponents: function() {
        this.inherited(arguments), this._oInputControl = this._findInputControl();
    },
    updateFocus: function(t) {
        this.focused = t, this.addRemoveClass("moon-focused", this.alwaysLooksFocused || this.focused);
    },
    getInputControl: function() {
        return this._oInputControl;
    },
    focusHandler: function() {
        enyo.Spotlight.getCurrent() != this && enyo.Spotlight.spot(this, null, !0), enyo.Spotlight.freeze(), 
        this.updateFocus(!0);
    },
    blurHandler: function() {
        enyo.Spotlight.unfreeze(), this.updateFocus(!1);
    },
    disabledChangeHandler: function(t, e) {
        this.addRemoveClass("moon-disabled", e.originator.disabled);
    },
    spotlightFocusHandler: function() {
        this.bubble("onRequestScrollIntoView");
    },
    spotlightSelectHandler: function(t, e) {
        var i = this.getInputControl();
        return i ? i.hasFocus() && e ? !0 : (i.focus(), !1) : void 0;
    },
    spotlightBlurHandler: function() {
        this.blur();
    },
    spotlightLeftHandler: function(t, e) {
        var i = this.getInputControl();
        if (i && i.hasFocus() && i.left) {
            if (i.left()) return e.allowDomDefault(), !0;
            this.blur(), i.blur();
        }
    },
    spotlightRightHandler: function(t, e) {
        var i = this.getInputControl();
        if (i && i.hasFocus() && i.right) {
            if (i.right()) return e.allowDomDefault(), !0;
            this.blur(), i.blur();
        }
    },
    spotlightUpHandler: function(t, e) {
        var i = this.getInputControl();
        if (i && i.hasFocus() && i.up) {
            if (i.up()) return e.allowDomDefault(), !0;
            this.blur(), i.blur();
        }
    },
    spotlightDownHandler: function(t, e) {
        var i = this.getInputControl();
        if (i && i.hasFocus() && i.down) {
            if (i.down()) return e.allowDomDefault(), !0;
            this.blur(), i.blur();
        }
    }
});

// lib\moonstone\source\ProgressBar.js
enyo.kind({
    name: "moon.ProgressBar",
    classes: "moon-progress-bar",
    published: {
        progress: 0,
        min: 0,
        max: 100,
        barClasses: "moon-progress-bar-bar",
        bgBarClasses: "moon-progress-bg-bar",
        bgProgress: 0
    },
    events: {
        onAnimateProgressFinish: ""
    },
    components: [ {
        name: "progressAnimator",
        kind: "Animator",
        onStep: "progressAnimatorStep",
        onEnd: "progressAnimatorComplete"
    }, {
        name: "bgbar"
    }, {
        name: "bar"
    } ],
    create: function() {
        this.inherited(arguments), this.addRemoveClass("moon-progress-bar-rtl", this.rtl), 
        this.progressChanged(), this.barClassesChanged(), this.bgBarClassesChanged(), this.bgProgressChanged();
    },
    barClassesChanged: function(t) {
        this.$.bar.removeClass(t), this.$.bar.addClass(this.barClasses);
    },
    bgBarClassesChanged: function(t) {
        this.$.bgbar.removeClass(t), this.$.bgbar.addClass(this.bgBarClasses);
    },
    bgProgressChanged: function() {
        this.bgProgress = this.clampValue(this.min, this.max, this.bgProgress);
        var t = this.calcPercent(this.bgProgress);
        this.updateBgBarPosition(t);
    },
    progressChanged: function() {
        this.progress = this.clampValue(this.min, this.max, this.progress);
        var t = this.calcPercent(this.progress);
        this.updateBarPosition(t);
    },
    clampValue: function(t, e, i) {
        return Math.max(t, Math.min(i, e));
    },
    calcRatio: function(t) {
        return (t - this.min) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return 100 * this.calcRatio(t);
    },
    updateBarPosition: function(t) {
        this.$.bar.applyStyle("width", t + "%");
    },
    updateBgBarPosition: function(t) {
        this.$.bgbar.applyStyle("width", t + "%");
    },
    animateProgressTo: function(t) {
        this.$.progressAnimator.play({
            startValue: this.progress,
            endValue: t,
            node: this.hasNode()
        });
    },
    progressAnimatorStep: function(t) {
        return this.setProgress(t.value), !0;
    },
    progressAnimatorComplete: function(t) {
        return this.doAnimateProgressFinish(t), !0;
    }
});

// lib\moonstone\source\Slider.js
enyo.kind({
    name: "moon.Slider",
    kind: "moon.ProgressBar",
    classes: "moon-slider",
    spotlight: !0,
    published: {
        value: 0,
        increment: 0,
        lockBar: !0,
        tappable: !0,
        knobClasses: "moon-slider-knob",
        popupLabelClasses: "moon-slider-popup-label",
        tapAreaClasses: "moon-slider-taparea",
        popupColor: "#4d4d4d",
        disabled: !1,
        animate: !0,
        noPopup: !1,
        showPercentage: !0,
        popupWidth: "auto",
        popupHeight: 67,
        popupOffset: 8,
        constrainToBgProgress: !1,
        elasticEffect: !1,
        popupContent: null,
        popupContentUpperCase: !0
    },
    events: {
        onChange: "",
        onChanging: "",
        onAnimateFinish: ""
    },
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        onSpotlightFocused: "spotFocused",
        onSpotlightSelect: "spotSelect",
        onSpotlightBlur: "spotBlur",
        onSpotlightLeft: "spotLeft",
        onSpotlightRight: "spotRight"
    },
    moreComponents: [ {
        kind: "Animator",
        onStep: "animatorStep",
        onEnd: "animatorComplete"
    }, {
        name: "tapArea"
    }, {
        name: "knob",
        ondown: "showKnobStatus",
        onup: "hideKnobStatus",
        components: [ {
            name: "popup",
            kind: "enyo.Popup",
            classes: "moon-slider-popup above",
            components: [ {
                tag: "canvas",
                name: "drawingLeft",
                classes: "moon-slider-popup-left"
            }, {
                name: "popupLabel",
                classes: "moon-slider-popup-center"
            }, {
                tag: "canvas",
                name: "drawingRight",
                classes: "moon-slider-popup-right"
            } ]
        } ]
    } ],
    animatingTo: null,
    popupLeftCanvasWidth: 26,
    popupRightCanvasWidth: 26,
    selected: !1,
    animateTo: function(t, e) {
        e = this.clampValue(this.min, this.max, e), this.animatingTo = e, this.$.animator.play({
            startValue: t,
            endValue: e,
            node: this.hasNode()
        });
    },
    isDragging: function() {
        return this.dragging;
    },
    create: function() {
        this.inherited(arguments), "undefined" != typeof ilib && (this._nf = new ilib.NumFmt({
            type: "percentage"
        })), this.createComponents(this.moreComponents), this.initValue(), this.disabledChanged(), 
        this.knobClassesChanged(), this.popupLabelClassesChanged(), this.tapAreaClassesChanged(), 
        this.initSliderStyles(), this.addRemoveClass("moon-slider-rtl", this.rtl);
    },
    destroy: function() {
        this._nf && delete this._nf, this.inherited(arguments);
    },
    rendered: function() {
        this.inherited(arguments), this.drawToCanvas(this.popupColor), this._setValue(this.value);
    },
    initSliderStyles: function() {
        this.updatePopupLabelColor(), this.updatePopupHeight(), this.updatePopupOffset(), 
        this.popupWidthChanged();
    },
    disabledChanged: function() {
        this.addRemoveClass("disabled", this.disabled), this.$.knob.addRemoveClass("disabled", this.disabled), 
        this.setTappable(!this.disabled), this.disabled && this.hideKnobStatus();
    },
    knobClassesChanged: function(t) {
        this.$.knob.removeClass(t), this.$.knob.addClass(this.knobClasses);
    },
    popupLabelClassesChanged: function(t) {
        this.$.popupLabel.removeClass(t), this.$.popupLabel.addClass(this.popupLabelClasses);
    },
    tapAreaClassesChanged: function(t) {
        this.$.tapArea.removeClass(t), this.$.tapArea.addClass(this.tapAreaClasses);
    },
    updatePopupOffset: function() {
        this.$.popup.applyStyle("top", -(this.getPopupHeight() + this.getPopupOffset()) + "px");
    },
    popupOffsetChanged: function() {
        this.updatePopupOffset(), this.drawToCanvas(this.popupColor);
    },
    popupWidthChanged: function() {
        "auto" != this.popupWidth && this.$.popupLabel.applyStyle("width", this.getPopupWidth() - (this.popupLeftCanvasWidth + this.popupRightCanvasWidth) + "px");
    },
    updatePopupHeight: function() {
        var t = this.getPopupHeight();
        this.$.drawingLeft.setAttribute("height", t), this.$.drawingRight.setAttribute("height", t), 
        this.$.popupLabel.applyStyle("height", t - 7 + "px"), this.$.popup.applyStyle("height", t + "px"), 
        this.$.popup.applyStyle("line-height", t - 6 + "px");
    },
    popupHeightChanged: function() {
        this.getPopupHeight() >= 72 && enyo.warn("This popupHeight API is designed for under 72 pixels."), 
        this.updatePopupHeight(), this.popupOffsetChanged();
    },
    updatePopupLabelColor: function() {
        this.$.popupLabel.applyStyle("background-color", this.popupColor);
    },
    popupColorChanged: function() {
        this.drawToCanvas(this.popupColor), this.updatePopupLabelColor();
    },
    popupContentChanged: function() {
        var t = this.getPopupContent();
        this._popupContent = this.getPopupContentUpperCase() ? enyo.toUpperCase(t) : t, 
        null !== this._popupContent && this.$.popupLabel.setContent(this._popupContent);
    },
    popupContentUpperCaseChanged: function() {
        this.popupContentChanged();
    },
    calcIncrement: function(t) {
        return Math.round(t / this.increment) * this.increment;
    },
    calcConstrainedIncrement: function(t) {
        return Math.floor(t / this.increment) * this.increment;
    },
    initValue: function() {
        this.constrainToBgProgress && (this.value = this.clampValue(this.min, this.bgProgress, this.value), 
        this.value = this.increment ? this.calcConstrainedIncrement(this.value) : this.value), 
        this.updateKnobPosition(this.getValue()), this.lockBar && this.setProgress(this.getValue());
    },
    valueChanged: function(t, e) {
        if (!this.dragging) {
            var i = this.constrainToBgProgress && this.bgProgress >= e || !this.constrainToBgProgress;
            this.constrainToBgProgress && (e = this.clampValue(this.min, this.bgProgress, e), 
            e = this.increment ? this.calcConstrainedIncrement(e) : e), this.animate && i ? this.animateTo(t, e) : this._setValue(e);
        }
    },
    minChanged: function() {
        this.initValue(), this.progressChanged(), this.bgProgressChanged();
    },
    maxChanged: function() {
        this.initValue(), this.progressChanged(), this.bgProgressChanged();
    },
    _setValue: function(t) {
        var e = this.clampValue(this.min, this.max, t);
        this.value = e, this.updateKnobPosition(e), this.lockBar && this.setProgress(this.value), 
        this.sendChangeEvent({
            value: this.getValue()
        });
    },
    getValue: function() {
        return null !== this.animatingTo ? this.animatingTo : this.value;
    },
    updateKnobPosition: function(t) {
        var e = this.calcPercent(t), i = this.showPercentage && null === this.popupContent ? e : t;
        this.rtl && (e = 100 - e), this.$.knob.applyStyle("left", e + "%"), this.$.popup.addRemoveClass("moon-slider-popup-flip-h", e > 50), 
        this.$.popupLabel.addRemoveClass("moon-slider-popup-flip-h", e > 50), this.updatePopupLabel(i);
    },
    updatePopupLabel: function(t) {
        var e = this._popupContent || this.calcPopupLabel(t);
        this.$.popupLabel.setContent(e);
    },
    calcPopupLabel: function(t) {
        return this.showPercentage && (t = "undefined" != typeof ilib ? this._nf.format(Math.round(t)) : Math.round(t) + "%"), 
        t;
    },
    calcKnobPosition: function(t) {
        var e;
        e = this.rtl ? this.hasNode().getBoundingClientRect().right - t.clientX : t.clientX - this.hasNode().getBoundingClientRect().left;
        var i = e / this.getBounds().width * (this.max - this.min) + this.min;
        return i;
    },
    dragstart: function(t, e) {
        return this.disabled ? void 0 : e.horizontal ? (e.preventDefault(), this.dragging = !0, 
        enyo.Spotlight.freeze(), this.$.knob.addClass("active"), this.showKnobStatus(), 
        !0) : void 0;
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i, n = this.calcKnobPosition(e);
            return this.constrainToBgProgress === !0 ? (n = this.increment ? this.calcConstrainedIncrement(n) : n, 
            i = this.bgProgress + .4 * (n - this.bgProgress), n = this.clampValue(this.min, this.bgProgress, n), 
            this.elasticFrom = this.elasticEffect === !1 || this.bgProgress > n ? n : i, this.elasticTo = n) : (n = this.increment ? this.calcIncrement(n) : n, 
            n = this.clampValue(this.min, this.max, n), this.elasticFrom = this.elasticTo = n), 
            this.updateKnobPosition(this.elasticFrom), this.set("value", this.elasticFrom), 
            this.lockBar && this.setProgress(n), this.sendChangingEvent({
                value: n
            }), !0;
        }
    },
    dragfinish: function(t, e) {
        if (!this.disabled) {
            var i = this.elasticTo;
            return this.constrainToBgProgress === !0 ? i = this.increment ? this.calcConstrainedIncrement(i) : i : (i = this.calcKnobPosition(e), 
            i = this.increment ? this.calcIncrement(i) : i, i = this.clampValue(this.min, this.max, i)), 
            this.dragging = !1, enyo.Spotlight.unfreeze(), this.set("value", i), this.sendChangeEvent({
                value: this.getValue()
            }), e.preventTap(), this.$.knob.removeClass("active"), this.hideKnobStatus(), !0;
        }
    },
    tap: function(t, e) {
        if (this.tappable && !this.disabled) {
            var i = this.calcKnobPosition(e);
            return i = this.increment ? this.calcIncrement(i) : i, i = this.constrainToBgProgress && i > this.bgProgress ? this.bgProgress : i, 
            this.set("value", i), !0;
        }
    },
    animatorStep: function(t) {
        var e = t.value;
        return this.updateKnobPosition(e), this.lockBar && this.setProgress(e), this.sendChangingEvent({
            value: e
        }), !0;
    },
    animatorComplete: function(t) {
        return this._setValue(t.value), this.animatingTo = null, this.doAnimateFinish(t), 
        !0;
    },
    spotFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    },
    spotSelect: function() {
        return this.selected = !this.selected, this.noPopup || (this.$.popup.setShowing(this.selected), 
        this.updateKnobPosition(this.getValue())), this.$.knob.addRemoveClass("spotselect", this.selected), 
        !0;
    },
    spotBlur: function() {
        this.dragging || (this.$.knob && this.$.knob.removeClass("spotselect"), this.$.popup && this.$.popup.hide(), 
        this.selected = !1);
    },
    spotLeft: function() {
        if (this.selected) {
            var t = this.rtl ? this.getValue() + (this.increment || 1) : this.getValue() - (this.increment || 1);
            return this.set("value", t), !0;
        }
    },
    spotRight: function() {
        if (this.selected) {
            var t = this.rtl ? this.getValue() - (this.increment || 1) : this.getValue() + (this.increment || 1);
            return this.set("value", t), !0;
        }
    },
    showKnobStatus: function() {
        this.disabled || this.noPopup || (this.$.popup.show(), this.updateKnobPosition(this.getValue()));
    },
    hideKnobStatus: function() {
        this.noPopup || this.$.popup.hide();
    },
    drawToCanvas: function(t) {
        var e = this.getPopupHeight() + 1, i = e - 8, n = i / 2, s = 26, o = n, a = 50, r = i + a, h = this.$.drawingLeft.hasNode().getContext("2d"), l = this.$.drawingRight.hasNode().getContext("2d");
        this.$.drawingLeft.setAttribute("width", this.popupLeftCanvasWidth), this.$.drawingRight.setAttribute("width", this.popupRightCanvasWidth), 
        h.fillStyle = t || enyo.dom.getComputedStyleValue(this.$.knob.hasNode(), "background-color"), 
        h.moveTo(0, e), h.arc(s, r, a, 1.35 * Math.PI, 1.485 * Math.PI, !1), h.lineTo(s, i), 
        h.lineTo(s, 0), h.arcTo(0, 0, 0, n, o), h.lineTo(0, e), h.fill(), l.fillStyle = t || enyo.dom.getComputedStyleValue(this.$.knob.hasNode(), "background-color"), 
        l.moveTo(0, i), l.arcTo(s, i, s, n, o), l.arcTo(s, 0, 0, 0, o), l.lineTo(0, 0), 
        l.fill();
    },
    changeDelayMS: 50,
    sendChangeEvent: function(t) {
        this.throttleJob("sliderChange", function() {
            this.doChange(t);
        }, this.changeDelayMS);
    },
    sendChangingEvent: function(t) {
        this.throttleJob("sliderChanging", function() {
            this.doChanging(t);
        }, this.changeDelayMS);
    }
});

// lib\moonstone\source\RichText.js
enyo.kind({
    name: "moon.RichText",
    kind: "enyo.RichText",
    classes: "moon-richtext",
    handlers: {
        onblur: "blurred"
    },
    create: function() {
        this.inherited(arguments), this.disabledChanged();
    },
    focus: function() {
        this.inherited(arguments);
        var t = this.hasNode();
        this.moveCursorToEnd(), t.scrollTop = t.scrollHeight;
    },
    blur: function() {
        this.hasNode() && this.node.blur();
    },
    blurred: function() {
        this.hasNode().scrollTop = 0;
    },
    disabledChanged: function() {
        this.inherited(arguments), this.disabled && (this.attributes.contenteditable = !1);
    },
    left: function() {
        var t = this.getSelection();
        if (t.rangeCount) {
            var e = t.getRangeAt(0), i = e.cloneRange();
            if (i.selectNodeContents(this.node), i.setEnd(e.startContainer, e.startOffset), 
            "" == "" + i) return !1;
        }
        return !0;
    },
    right: function() {
        var t = this.getSelection();
        if (t.rangeCount) {
            var e = t.getRangeAt(0), i = e.cloneRange();
            if (i.selectNodeContents(this.node), i.setStart(e.endContainer, e.endOffset), "" == "" + i) return !1;
        }
        return !0;
    },
    up: function() {
        return this.left();
    },
    down: function() {
        return this.right();
    }
});

// lib\moonstone\source\ContextualPopupButton.js
enyo.kind({
    name: "moon.ContextualPopupButton",
    kind: "moon.Button",
    classes: "contextual-popup-button"
});

// lib\moonstone\source\ContextualPopupDecorator.js
enyo.kind({
    name: "moon.ContextualPopupDecorator",
    defaultKind: "moon.ContextualPopupButton",
    classes: "moon-contextual-popup-decorator",
    handlers: {
        onActivate: "activated",
        onShow: "popupShown",
        onHide: "popupHidden"
    },
    activated: function(t, e) {
        e.sentFromPopup && e.sentFromPopup.isDescendantOf(this) || (this.requestHidePopup(), 
        e.originator.active && (this.activator = e.originator, this.popupActived ? (e.originator.active = !1, 
        this.popupActived = !1) : (this.activator.addClass("active"), this.requestShowPopup())));
    },
    popupShown: function(t, e) {
        void 0 === this.popup && (this.popup = e.originator);
    },
    popupHidden: function() {
        this.activator && (this.popupActived = this.popup.popupActived, this.activator.active = !1, 
        this.activator.removeClass("active"), this.activator.removeClass("pressed"));
    },
    requestShowPopup: function() {
        this.waterfallDown("onRequestShowPopup", {
            activator: this.activator
        });
    },
    requestHidePopup: function() {
        this.waterfallDown("onRequestHidePopup");
    }
});

// lib\moonstone\source\ContextualPopup.js
enyo.kind({
    name: "moon.ContextualPopup",
    kind: "enyo.Popup",
    layoutKind: "ContextualLayout",
    classes: "moon-body-text moon-contextual-popup",
    handlers: {
        onRequestShowPopup: "requestShow",
        onRequestHidePopup: "requestHide",
        onActivate: "decorateActivateEvent",
        onRequestScrollIntoView: "_preventEventBubble",
        onSpotlightContainerLeave: "onLeave"
    },
    eventsToCapture: {
        onSpotlightKeyDown: "capturedKeyDown"
    },
    published: {
        spotlightModal: !1,
        showCloseButton: "auto"
    },
    spotlight: "container",
    floating: !0,
    scrimWhenModal: !0,
    vertFlushMargin: 0,
    horizFlushMargin: 0,
    widePopup: 200,
    longPopup: 200,
    horizBuffer: 16,
    activator: null,
    tools: [ {
        name: "client",
        classes: "moon-neutral moon-contextual-popup-client"
    }, {
        name: "closeButton",
        kind: "moon.IconButton",
        icon: "closex",
        classes: "moon-popup-close",
        ontap: "closePopup",
        spotlight: !1
    } ],
    initComponents: function() {
        this.createChrome(this.tools), this.inherited(arguments);
    },
    render: function() {
        this.allowHtmlChanged(), this.contentChanged(), this.inherited(arguments);
    },
    requestShow: function(t, e) {
        var i = e.activator.hasNode();
        return this.activator = e.activator, i && (this.activatorOffset = this.getPageOffset(i)), 
        this.show(), this.configCloseButton(), enyo.Spotlight.isSpottable(this) && enyo.Spotlight.spot(this), 
        !0;
    },
    decorateActivateEvent: function(t, e) {
        e.sentFromPopup = this;
    },
    getPageOffset: function(t) {
        var e = t.getBoundingClientRect(), i = void 0 === window.pageYOffset ? document.documentElement.scrollTop : window.pageYOffset, n = void 0 === window.pageXOffset ? document.documentElement.scrollLeft : window.pageXOffset, o = void 0 === e.height ? e.bottom - e.top : e.height, s = void 0 === e.width ? e.right - e.left : e.width;
        return {
            top: e.top + i,
            left: e.left + n,
            height: o,
            width: s
        };
    },
    keydown: function(t, e) {
        this.showing && this.autoDismiss && 27 == e.keyCode && (enyo.Spotlight.spot(this.activator), 
        this.hide());
    },
    closePopup: function() {
        enyo.Spotlight.spot(this.activator), this.$.closeButton.removeClass("pressed"), 
        this.hide();
    },
    configCloseButton: function() {
        this.showCloseButton === !0 || this.spotlightModal && this.showCloseButton !== !1 ? (this.$.closeButton.show(), 
        this.$.closeButton.spotlight = !0, this.addClass("reserve-close")) : (this.$.closeButton.hide(), 
        this.$.closeButton.spotlight = !1, this.removeClass("reserve-close"));
    },
    contentChanged: function() {
        this.$.client.setContent(this.content);
    },
    allowHtmlChanged: function() {
        this.$.client.setAllowHtml(this.allowHtml);
    },
    spotlightModalChanged: function() {
        this.configCloseButton();
    },
    showCloseButtonChanged: function() {
        this.configCloseButton();
    },
    capturedKeyDown: function(t, e) {
        return 13 == e.keyCode && (this.downEvent = e), this.modal;
    },
    capturedTap: function(t, e) {
        this.popupActived = e.dispatchTarget.isDescendantOf(this.activator) ? !0 : !1, this.inherited(arguments);
    },
    onLeave: function(t, e) {
        e.originator == this && (enyo.Spotlight.spot(this.activator), this.hide());
    },
    _preventEventBubble: function() {
        return !0;
    },
    showHideScrim: function(t) {
        if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
            var e = this.getScrim();
            if (t && this.modal && this.scrimWhenModal) {
                var i = this.getScrimZIndex();
                this._scrimZ = i, e.showAtZIndex(i);
            } else e.hideAtZIndex(this._scrimZ);
            enyo.call(e, "addRemoveClass", [ this.scrimClassName, e.showing ]);
        }
    },
    getScrimZIndex: function() {
        return this.findZIndex() - 1;
    },
    getScrim: function() {
        return this.modal && this.scrimWhenModal ? moon.scrimTransparent.make() : moon.scrim.make();
    },
    findZIndex: function() {
        var t = this.defaultZ;
        return this._zIndex ? t = this._zIndex : this.hasNode() && (t = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || t), 
        this._zIndex = t, this._zIndex;
    },
    showingChanged: function() {
        this.inherited(arguments), this.showHideScrim(this.showing);
    }
});

// lib\moonstone\source\BreadcrumbArranger.js
enyo.kind({
    name: "moon.BreadcrumbArranger",
    kind: "enyo.DockRightArranger",
    getPanelInfo: function(t, e) {
        return {
            breadcrumb: this.isBreadcrumb(t, e),
            offscreen: this.isOffscreen(t, e)
        };
    },
    breadcrumbWidth: 230,
    debug: !1,
    size: function() {
        var t, e = this.getContainerWidth(), i = this.container.getPanels();
        for (t = 0; i.length > t; t++) i[t].actualWidth && i[t].applyStyle("width", i[t].width + "px"), 
        i[t].actualWidth = null, i[t].width = i[t].getBounds().width;
        this.joinedPanels = this.calculateJoinedPanels(e), this.applyVerticalFit(), this.container.transitionPositions = this.calculateTransitionPositions(e, this.joinedPanels), 
        this.adjustTransitionPositionsForJoinedPanels(this.joinedPanels), this.updateWidths(e, this.joinedPanels), 
        this.applyUpdatedWidths(), this.calcBreadcrumbPositions(this.joinedPanels), this.debug && (enyo.log("transitionPositions:", this.container.transitionPositions), 
        enyo.log("breadcrumbPositions:", this.breadcrumbPositions));
    },
    calculateJoinedPanels: function(t) {
        t = t || this.getContainerWidth();
        for (var e = this.container.getPanels(), i = {}, n = 0; e.length > n; n++) for (var o = 0; e.length > o; o++) n > o && (i[n + "." + o] = this.isPanelJoined(n, o, t));
        return this.formatJoinedPanels(i);
    },
    isPanelJoined: function(t, e, i) {
        i = i || this.getContainerWidth();
        for (var n = this.container.getPanels(), o = this.getBreadcrumbEdge(e), s = t; s > e; ) {
            if (!n[s].joinToPrev) return !1;
            o += n[s].width, s--;
        }
        return o + n[e].width > i ? !1 : !0;
    },
    formatJoinedPanels: function(t) {
        var e, i, n = this.container.getPanels(), o = [];
        for (e = 0; n.length > e; e++) for (i = 0; n.length > i; i++) t[e + "." + i] && (o[e] = o[e] || [], 
        o[e].push(i));
        return o;
    },
    calculateTransitionPositions: function(t, e) {
        for (var i = this.container.getPanels(), n = {}, o = 0; i.length > o; o++) for (var s = 0; i.length > s; s++) n[o + "." + s] = this.calculateXPos(o, s, t, e);
        return n;
    },
    calculateXPos: function(t, e, i, n) {
        var o, s, a = this.getBreadcrumbEdge(e), r = this.container.getPanels(), h = 0;
        if ("activity" == this.container.pattern && (h = 0 === e ? a : a - this.breadcrumbWidth, 
        h /= 2), e === t) return a + this.getBreadcrumbGap() / 2 - h;
        if (e > t) return a - (e - t) * this.breadcrumbWidth - this.getBreadcrumbGap() / 2 - h;
        if (!n[t] || -1 === n[t].indexOf(e)) return i;
        for (o = a, s = t; s > e; ) r[s - 1] && (o += r[s - 1].width - h), s--;
        return o;
    },
    recalculatePanelTransitionPositions: function(t, e, i) {
        for (var n = this.container.getPanels(), o = 0; n.length > o; o++) this.container.transitionPositions[t + "." + o] = this.calculateXPos(t, o, e, i);
    },
    adjustTransitionPositionsForJoinedPanels: function(t) {
        for (var e = this.container.transitionPositions, i = this.container.getPanels(), n = i.length; n >= 0; n--) if (t[n]) for (var o = t[n].length - 1; o >= 0; o--) for (var s = 0; i.length > s; s++) e[s + "." + n] = e[s + "." + t[n][o]];
    },
    updateWidths: function(t, e) {
        var i, n, o, s = this.container.getPanels();
        for (n = 0; e.length > n; n++) if (e[n]) {
            var a = s[n].width + this.getBreadcrumbEdge(e[n][0]) + this.getBreadcrumbGap();
            for (o = 0; e[n].length > o; o++) a += s[e[n][o]].actualWidth ? s[e[n][o]].actualWidth : s[e[n][o]].width;
            i = t - a, s[n].actualWidth = s[n].width + i, this.debug && enyo.log(n, s[n].width, "-->", s[n].actualWidth);
        }
        for (n = 0; s.length > n; n++) if (!s[n].actualWidth) {
            var r = !1;
            for (o = 0; e.length > o; o++) e[o] && e[o].indexOf(n) >= 0 && (r = !0);
            s[n].actualWidth = r ? s[n].width : t - this.getBreadcrumbEdge(n) - this.getBreadcrumbGap();
        }
    },
    applyUpdatedWidths: function() {
        for (var t = this.container.getPanels(), e = 0; t.length > e; e++) t[e].applyStyle("width", t[e].actualWidth + "px");
    },
    calcBreadcrumbPositions: function(t) {
        var e, i, n, o = this.container.getPanels();
        for (this.breadcrumbPositions = {}, n = 0; o.length > n; n++) for (i = 0; o.length > i; i++) e = !1, 
        i > n && (e = !(t[i] && t[i].indexOf(n) > -1)), this.breadcrumbPositions[n + "." + i] = e;
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.transitionPositions, i = this.container.getPanels(), n = [], o = 0; t = i[o]; o++) if (0 === e[o + "." + this.container.toIndex]) {
            var s = t.getBounds().width, a = e[o + 1 + "." + this.container.toIndex];
            s > a && n.push(o);
        }
        this.container.hiddenPanels = n;
    },
    arrange: function(t, e) {
        var i, n, o, s = this.container.getPanels(), a = this.container.clamp(e);
        for (i = 0; n = s[i]; i++) {
            if (o = this.container.transitionPositions[i + "." + a], 0 > o) {
                var r = this.getContainerPadding();
                -1 * (this.breadcrumbWidth - r.left) >= o && (o -= r.right);
            }
            this.arrangeControl(n, {
                left: o
            });
        }
    },
    isOffscreen: function(t, e) {
        if (this.container.transitionPositions) {
            var i = this.container.transitionPositions[t + "." + e], n = 1 == this.container.panelCoverRatio ? this.getBreadcrumbEdge(t) : 0;
            return 0 > i ? n >= i + this.breadcrumbWidth : i >= this.containerBounds.width;
        }
    },
    isBreadcrumb: function(t, e) {
        return this.breadcrumbPositions && this.breadcrumbPositions[t + "." + e];
    },
    calcBreadcrumbEdges: function() {
        this.breadcrumbEdges = [];
        for (var t, e = 0; t = this.container.getPanels()[e]; e++) this.breadcrumbEdges[e] = 0 === e ? 0 : this.breadcrumbWidth;
    },
    getContainerWidth: function() {
        return this.containerBounds.width;
    },
    getBreadcrumbGap: function() {
        return this.container.breadcrumbGap || 0;
    },
    getBreadcrumbEdge: function(t) {
        var e = this.getContainerWidth() * (1 - this.container.panelCoverRatio);
        if (1 == this.container.panelCoverRatio) {
            var i = this.getContainerPadding();
            e += i.left + i.right;
        }
        return this.container.showFirstBreadcrumb && 0 !== t && (e += this.breadcrumbWidth), 
        e;
    },
    applyVerticalFit: function() {
        for (var t, e = this.container.getPanels(), i = this.getContainerPadding(), n = 0; t = e[n]; n++) t.setBounds({
            top: i.top,
            bottom: i.bottom
        });
    },
    getContainerPadding: function() {
        return this.container.hasNode() ? enyo.dom.calcPaddingExtents(this.container.node) : {};
    },
    shouldArrange: function(t, e) {
        if (t >= 0 && e >= 0) {
            var i, n, o, s = this.container.transitionPositions, a = this.container.getPanels().length;
            for (i = 0; a > i; i++) if (n = s[i + "." + t], o = s[i + "." + e], n !== o) return !0;
            return !1;
        }
    }
});

// lib\moonstone\source\TextArea.js
enyo.kind({
    name: "moon.TextArea",
    kind: "enyo.TextArea",
    classes: "moon-textarea",
    spotlightIgnoredKeys: [ 13, 16777221 ],
    handlers: {
        onblur: "blurred"
    },
    focus: function() {
        this.inherited(arguments);
        var t = this.hasNode();
        t.selectionStart = this.value.length, t.scrollTop = t.scrollHeight;
    },
    blur: function() {
        this.hasNode() && this.node.blur();
    },
    blurred: function() {
        this.hasNode().scrollTop = 0;
    },
    left: function() {
        return this.hasNode() && 0 !== this.node.selectionStart ? !0 : !1;
    },
    right: function() {
        return this.hasNode() && this.node.selectionStart != this.node.value.length ? !0 : !1;
    },
    up: function(t) {
        return this.left(t);
    },
    down: function(t) {
        return this.right(t);
    }
});

// lib\moonstone\source\ListActions.js
enyo.kind({
    name: "moon.ListActions",
    classes: "moon-list-actions",
    kind: "enyo.GroupItem",
    published: {
        open: !1,
        autoCollapse: !1,
        listActions: null,
        iconSrc: "",
        icon: "",
        proportionalWidth: !1
    },
    events: {
        onRequestCreateListActions: "",
        onListActionOpenChanged: ""
    },
    components: [ {
        name: "activator",
        kind: "moon.IconButton",
        classes: "moon-list-actions-activator",
        ontap: "expandContract"
    } ],
    drawerComponents: [ {
        name: "drawer",
        kind: "moon.ListActionsDrawer",
        classes: "list-actions-drawer",
        onComplete: "drawerAnimationEnd",
        open: !1,
        spotlight: "container",
        spotlightModal: !0,
        components: [ {
            name: "closeButton",
            kind: "moon.IconButton",
            icon: "closex",
            classes: "moon-popup-close moon-list-actions-close moon-neutral",
            ontap: "expandContract",
            defaultSpotlightDown: "listActions"
        }, {
            name: "listActionsClientContainer",
            classes: "enyo-fit moon-list-actions-client-container moon-neutral",
            components: [ {
                name: "listActions",
                kind: "moon.Scroller",
                classes: "enyo-fit moon-list-actions-scroller",
                horizontal: "hidden",
                vertical: "hidden",
                onActivate: "optionSelected",
                defaultSpotlightUp: "closeButton"
            } ]
        } ]
    } ],
    bindings: [ {
        from: ".open",
        to: ".$.drawer.open"
    }, {
        from: ".iconSrc",
        to: ".$.activator.src"
    }, {
        from: ".icon",
        to: ".$.activator.icon"
    } ],
    create: function() {
        if (this.inherited(arguments), this.doRequestCreateListActions({
            components: this.drawerComponents
        }), !this.$.drawer) throw "moon.ListActions must be created as a child of moon.Header";
        this.listActionsChanged(), this.drawerNeedsResize = !0;
    },
    rendered: function() {
        this.inherited(arguments), this.open && (this.drawerAnimationEnd(), this.resizeDrawer());
    },
    destroy: function() {
        enyo.dispatcher.release(this.$.drawer), this.inherited(arguments);
    },
    listActionsChanged: function() {
        var t = this.hasOwnProperty("listActions") ? this.getInstanceOwner() : this;
        this.listActions = this.listActions || [], this.renderListActionComponents(t);
    },
    renderListActionComponents: function(t) {
        this.noAutoCollapse = !0, this.createListActionComponents(t), this.noAutoCollapse = !1;
    },
    createListActionComponents: function(t) {
        var e, i;
        for (this.listActionComponents = [], i = 0; e = this.listActions[i]; i++) this.listActionComponents.push(this.createListActionComponent(e, t));
        if (this.proportionalWidth) {
            this.$.drawer.addClass("proportional-width");
            var n = 100 / this.listActionComponents.length;
            for (i = 0; this.listActionComponents.length > i; i++) this.listActionComponents[i].applyStyle("width", n + "%");
        }
        this.hasNode() && this.$.listActions.render();
    },
    createListActionComponent: function(t, e) {
        var i;
        return t.mixins = this.addListActionMixin(t), i = this.$.listActions.createComponent(t, {
            owner: e,
            layoutKind: "FittableRowsLayout"
        }), i.addClass("moon-list-actions-menu"), i;
    },
    addListActionMixin: function(t) {
        var e = t.mixins || [];
        return -1 === e.indexOf("moon.ListActionActivationSupport") && e.push("moon.ListActionActivationSupport"), 
        e;
    },
    expandContract: function() {
        return this.disabled ? !0 : (this.setOpen(!this.getOpen()), void 0);
    },
    beforeOpenDrawer: function(t, e) {
        this.standardHeight = t, "large" !== e && this.set(this.stacked, "false");
    },
    openChanged: function() {
        this.setActive(!this.getOpen()), this.doListActionOpenChanged({
            open: this.open
        }), this.open ? (this.drawerNeedsResize && (this.resizeDrawer(), this.drawerNeedsResize = !1), 
        enyo.dispatcher.capture(this.$.drawer, {
            onSpotlightFocus: "capturedSpotlightFocus"
        }, this)) : enyo.dispatcher.release(this.$.drawer);
    },
    drawerAnimationEnd: function() {
        return this.getOpen() ? (this.resetScroller && (this.$.listActions.scrollTo(0, 0), 
        this.resetScroller = !1), this.generated && enyo.Spotlight.spot(this.$.closeButton), 
        this.bubble("onRequestMuteTooltip")) : (this.generated && enyo.Spotlight.spot(this.$.activator), 
        this.bubble("onRequestUnmuteTooltip")), !0;
    },
    updateStacking: function() {
        this.$.drawer.hasNode() && this.set("stacked", this.shouldStack());
    },
    shouldStack: function() {
        return this.$.listActions.getBounds().width < 300 * this.listActionComponents.length;
    },
    stackedChanged: function() {
        this.stacked ? (this.$.drawer.addClass("stacked"), this.stackMeUp(), this.$.listActions.setVertical("scroll")) : (this.$.drawer.removeClass("stacked"), 
        this.unStackMeUp(), this.$.listActions.setVertical("hidden")), this.resetScroller = !0, 
        this.$.listActions.resized();
    },
    stackMeUp: function() {
        var t, e;
        for (e = 0; t = this.listActionComponents[e]; e++) t.applyStyle("display", "block"), 
        t.applyStyle("height", "none");
    },
    unStackMeUp: function() {
        var t, e, i;
        for (this.standardHeight && this.$.drawer.applyStyle("height", this.standardHeight + "px"), 
        t = this.getContainerBounds().height, i = 0; e = this.listActionComponents[i]; i++) e.applyStyle("display", "inline-block"), 
        e.applyStyle("height", t + "px");
    },
    resizeHandler: function() {
        this.resetCachedValues(), this.getOpen() ? this.resizeDrawer() : this.drawerNeedsResize = !0;
    },
    resizeDrawer: function() {
        this.updateStacking();
    },
    optionSelected: function() {
        this.getOpen() && this.autoCollapse && !this.noAutoCollapse && this.startJob("expandContract", "expandContract", 300);
    },
    getContainerBounds: function() {
        return this.containerBounds = this.containerBounds || this.$.listActions.getBounds(), 
        this.containerBounds;
    },
    resetCachedValues: function() {
        this.headerBounds = null, this.clientBounds = null, this.containerBounds = null;
    },
    capturedSpotlightFocus: function(t, e) {
        return e.originator.isDescendantOf(this.$.drawer.parent) && !e.originator.isDescendantOf(this.$.drawer) ? (enyo.Spotlight.spot(this.$.drawer), 
        !0) : void 0;
    }
}), enyo.kind({
    name: "moon.ListActionsDrawer",
    published: {
        open: !1
    },
    classes: "moon-list-actions-drawer",
    components: [ {
        name: "client",
        classes: "moon-list-actions-drawer-client moon-neutral",
        ontransitionend: "handleTransitionEnd"
    } ],
    events: {
        onComplete: ""
    },
    rendered: function() {
        this.inherited(arguments), this.applyAnimatedMode(!1), this.openChanged(), this.applyAnimatedMode(!0), 
        this.doComplete();
    },
    handleTransitionEnd: function(t, e) {
        return e.originator === this.$.client ? (this.doComplete(), !0) : void 0;
    },
    getBubbleTarget: function() {
        return this.owner;
    },
    openChanged: function() {
        this.$.client.hasNode() && this.$.client.addRemoveClass("open", this.open);
    },
    applyAnimatedMode: function(t) {
        this.$.client.addRemoveClass("animated", t);
    }
}), moon.ListActionActivationSupport = {
    name: "ListActionActivationSupport",
    handlers: {
        onActivate: "activate"
    },
    activate: function(t, e) {
        e.action = this.action;
    }
};

// lib\moonstone\source\Divider.js
enyo.kind({
    name: "moon.Divider",
    classes: "moon-divider moon-divider-text",
    mixins: [ "moon.MarqueeSupport", "moon.MarqueeItem" ],
    marqueeOnSpotlight: !1,
    marqueeOnRender: !0
});

// lib\moonstone\source\LabeledTextItem.js
enyo.kind({
    name: "moon.LabeledTextItem",
    kind: "moon.Item",
    classes: "moon-labeledtextitem",
    components: [ {
        name: "label",
        classes: "label"
    }, {
        name: "text",
        classes: "text"
    } ],
    create: function() {
        this.inherited(arguments), this.labelChanged(), this.textChanged();
    },
    published: {
        label: "",
        text: ""
    },
    bindings: [ {
        from: ".allowHtml",
        to: ".$.label.allowHtml"
    }, {
        from: ".allowHtml",
        to: ".$.text.allowHtml"
    } ],
    labelChanged: function() {
        this.$.label.setContent(this.label);
    },
    textChanged: function() {
        this.$.text.setContent(this.text);
    }
});

// lib\moonstone\source\ImageItem.js
enyo.kind({
    name: "moon.ImageItem",
    classes: "moon-imageitem",
    kind: "moon.Item",
    components: [ {
        name: "image",
        kind: "enyo.Image"
    }, {
        name: "textItem",
        kind: "moon.LabeledTextItem",
        spotlight: !1
    } ],
    published: {
        source: "",
        label: "",
        text: "",
        imageAlignRight: !1
    },
    bindings: [ {
        from: ".allowHtml",
        to: ".$.textItem.allowHtml"
    } ],
    create: function() {
        this.inherited(arguments), this.sourceChanged(), this.labelChanged(), this.textChanged(), 
        this.imageAlignRightChanged();
    },
    sourceChanged: function() {
        this.source && "" !== this.source && this.$.image.setAttribute("src", this.source);
    },
    labelChanged: function() {
        this.$.textItem.setLabel(this.label);
    },
    textChanged: function() {
        this.$.textItem.setText(this.text);
    },
    imageAlignRightChanged: function() {
        this.addRemoveClass("align-right", this.imageAlignRight);
    }
});

// lib\moonstone\source\Spinner.js
enyo.kind({
    name: "moon.Spinner",
    classes: "moon-spinner",
    published: {
        transparent: !1
    },
    components: [ {
        name: "decorator",
        classes: "moon-spinner-ball-decorator spin-ball-animation",
        components: [ {
            classes: "moon-spinner-ball moon-spinner-ball1"
        }, {
            classes: "moon-spinner-ball moon-spinner-ball2"
        }, {
            classes: "moon-spinner-ball moon-spinner-ball3"
        } ]
    } ],
    spinnerTools: [ {
        name: "client",
        classes: "moon-spinner-client"
    } ],
    initComponents: function() {
        this.inherited(arguments), this.createTools();
    },
    createTools: function() {
        var t = enyo.clone(this.spinnerTools);
        this.components && this.components.length > 0 || enyo.mixin(t[0], {
            kind: "moon.MarqueeText",
            mixins: [ "moon.MarqueeSupport" ],
            marqueeOnSpotlight: !1,
            marqueeOnHover: !0,
            marqueeOnRender: !0,
            marqueeOnRenderDelay: 1e3
        }), this.createChrome(t);
    },
    create: function() {
        this.inherited(arguments), this.contentChanged(), this.transparentChanged(), this.addClass("running");
    },
    stop: function() {
        this.set("showing", !1);
    },
    start: function() {
        this.set("showing", !0);
    },
    toggle: function() {
        this.set("showing", !this.get("showing"));
    },
    hasContent: function() {
        return !!this.content || this.components && this.components.length > 0;
    },
    contentChanged: function(t) {
        this.inherited(arguments), (this.content || t) && this.$.client.set("content", this.content), 
        this.$.client.set("showing", !!this.content), this.addRemoveClass("content", this.hasContent());
    },
    transparentChanged: function() {
        this.addRemoveClass("moon-spinner-transparent-background", !!this.get("transparent"));
    }
});

// lib\moonstone\source\Panel.js
enyo.kind({
    name: "moon.Panel",
    published: {
        title: "",
        titleAbove: "",
        titleBelow: "",
        subTitleBelow: "",
        autoNumber: !0,
        headerType: "large",
        smallHeader: !1,
        collapsingHeader: !1,
        allowHtmlHeader: !1,
        headerBackgroundSrc: null,
        headerBackgroundPosition: "top right",
        headerOptions: null,
        titleUpperCase: !0
    },
    events: {
        onPreTransitionComplete: "",
        onPostTransitionComplete: ""
    },
    handlers: {
        onScroll: "scroll"
    },
    spotlight: "container",
    classes: "moon-panel",
    layoutKind: "FittableRowsLayout",
    headerOption: null,
    panelTools: [ {
        name: "breadcrumb",
        ontap: "handleBreadcrumbTap",
        classes: "moon-panel-breadcrumb",
        components: [ {
            name: "breadcrumbViewport",
            classes: "moon-panel-breadcrumb-viewport",
            components: [ {
                name: "breadcrumbBackground",
                classes: "moon-panel-small-header-wrapper",
                components: [ {
                    name: "breadcrumbTitleAbove",
                    classes: "moon-super-header-text moon-panel-small-header-title-above"
                }, {
                    name: "breadcrumbText",
                    mixins: [ "moon.MarqueeSupport", "moon.MarqueeItem" ],
                    classes: "moon-sub-header-text moon-panel-small-header"
                } ]
            } ]
        } ]
    }, {
        name: "viewport",
        classes: "moon-panel-viewport",
        onwebkitAnimationEnd: "animationComplete",
        components: [ {
            name: "contentWrapper",
            kind: "FittableRows",
            classes: "moon-panel-content-wrapper",
            components: [ {
                name: "panelBody",
                kind: "FittableRows",
                fit: !0,
                classes: "moon-panel-body"
            } ]
        } ]
    }, {
        name: "animator",
        kind: "enyo.StyleAnimator",
        onComplete: "animationComplete"
    } ],
    headerConfig: {
        name: "header",
        kind: "moon.Header",
        onComplete: "headerAnimationComplete",
        isChrome: !0
    },
    bindings: [ {
        from: ".title",
        to: ".$.header.title"
    }, {
        from: ".title",
        to: ".$.breadcrumbText.content"
    }, {
        from: ".titleAbove",
        to: ".$.header.titleAbove"
    }, {
        from: ".titleAbove",
        to: ".$.breadcrumbTitleAbove.content"
    }, {
        from: ".titleBelow",
        to: ".$.header.titleBelow"
    }, {
        from: ".subTitleBelow",
        to: ".$.header.subTitleBelow"
    }, {
        from: ".allowHtmlHeader",
        to: ".$.header.allowHtml"
    }, {
        from: ".allowHtmlHeader",
        to: ".$.breadcrumbText.allowHtml"
    }, {
        from: ".headerBackgroundSrc",
        to: ".$.header.backgroundSrc"
    }, {
        from: ".headerBackgroundPosition",
        to: ".$.header.backgroundPosition"
    }, {
        from: ".titleUpperCase",
        to: ".$.header.titleUpperCase"
    }, {
        from: ".headerType",
        to: ".$.header.type",
        oneWay: !1
    } ],
    headerComponents: [],
    isBreadcrumb: !1,
    isOffscreen: !1,
    isHeaderCollapsed: !1,
    shrinking: !1,
    growing: !1,
    create: function() {
        if (this.inherited(arguments), this.headerComponents) {
            var t = this.hasOwnProperty("headerComponents") ? this.getInstanceOwner() : this;
            this.$.header.createComponents(this.headerComponents, {
                owner: t
            });
        }
        this.autoNumberChanged(), this.smallHeaderChanged(), this.headerTypeChanged();
    },
    initComponents: function() {
        this.createTools(), this.controlParentName = "panelBody", this.discoverControlParent(), 
        this.inherited(arguments);
    },
    createTools: function() {
        this.createChrome(this.panelTools);
        var t = enyo.clone(this.headerConfig || {});
        t.addBefore = this.$.panelBody, enyo.mixin(t, this.headerOptions || this.headerOption), 
        this.$.contentWrapper.createComponent(t, {
            owner: this
        });
    },
    reflow: function() {
        this.inherited(arguments), this.getInitAnimationValues(), this.updateViewportSize(), 
        this.shrinkAsNeeded();
    },
    updateViewportSize: function() {
        var t = this.hasNode();
        t && !this.isBreadcrumb && (this.$.viewport.applyStyle("height", this.initialHeight + "px"), 
        this.$.viewport.applyStyle("width", this.initialWidth + "px"), this.$.contentWrapper.applyStyle("height", this.initialHeight + "px"), 
        this.$.contentWrapper.applyStyle("width", this.initialWidth + "px"));
    },
    layoutKindChanged: function() {
        this.$.panelBody.setLayoutKind(this.getLayoutKind());
    },
    updatesSpottability: function() {
        this.isOffscreen ? (this.spotlightDisabled = !0, this.removeSpottableProps(), this.removeSpottableBreadcrumbProps()) : this.isBreadcrumb ? (this.spotlightDisabled = !0, 
        this.addSpottableBreadcrumbProps()) : this.spotlightDisabled = !1;
    },
    handleBreadcrumbTap: function(t, e) {
        e.breadcrumbTap = !0;
    },
    scroll: function(t, e) {
        !this.collapsingHeader || "large" !== this.headerType && this.smallHeader || (0 > e.originator.y ? this.collapseHeader() : this.expandHeader());
    },
    smallHeaderChanged: function() {
        this.$.header.setSmall(this.smallHeader), this.generated && this.$.contentWrapper.resized();
    },
    headerTypeChanged: function() {
        this.$.header.setType(this.headerType), this.generated && this.$.contentWrapper.resized();
    },
    collapseHeader: function() {
        this.isHeaderCollapsed || (this.$.header.collapseToSmall(), this.isHeaderCollapsed = !0);
    },
    expandHeader: function() {
        this.isHeaderCollapsed && (this.$.header.expandToLarge(), this.isHeaderCollapsed = !1);
    },
    autoNumberChanged: function() {
        if (this.getAutoNumber() === !0 && this.container) {
            var t = this.parent.indexOfChild(this) + 1;
            t = (10 > t ? "0" : "") + t, this.setTitleAbove(t);
        }
    },
    generateAutoNumber: function() {
        var t = this.indexInContainer() + 1;
        return 10 > t ? "0" + t : t;
    },
    addSpottableBreadcrumbProps: function() {
        this.$.breadcrumbBackground.set("spotlight", !0);
    },
    removeSpottableBreadcrumbProps: function() {
        this.$.breadcrumbBackground.set("spotlight", !1), this.$.breadcrumbBackground.removeClass("spotlight");
    },
    removeSpottableProps: function() {
        this.$.breadcrumbBackground.set("spotlight", !1);
    },
    shrinkAsNeeded: function() {
        this.needsToShrink && (this.shrink(), this.needsToShrink = !1);
    },
    enableMarquees: function() {
        this.$.breadcrumbText.enableMarquee(), this.$.header.enableMarquee();
    },
    disableMarquees: function() {
        this.$.breadcrumbText.disableMarquee(), this.$.header.disableMarquee();
    },
    startMarqueeAsNeeded: function(t) {
        var e = !t.offscreen;
        e && (this.isBreadcrumb ? (this.$.breadcrumbText.enableMarquee(), this.$.breadcrumbText.startMarquee()) : (this.$.header.enableMarquee(), 
        this.$.header.startMarquee()));
    },
    getHeader: function() {
        return this.$.header;
    },
    initPanel: function(t) {
        this.set("isBreadcrumb", t.breadcrumb), this.set("isOffscreen", t.offscreen), this.updatesSpottability(), 
        this.isBreadcrumb && (this.needsToShrink = !0), this.disableMarquees(), this.startMarqueeAsNeeded(t);
    },
    preTransition: function(t) {
        return this.disableMarquees(), this.shrinking || !t.breadcrumb || this.isBreadcrumb && !this.growing ? !1 : (this.shrinkAnimation(), 
        !0);
    },
    postTransition: function(t) {
        return this.growing || t.breadcrumb || !this.isBreadcrumb && !this.shrinking ? !1 : (this.growAnimation(), 
        !0);
    },
    updatePanel: function(t) {
        t.animate || (this.disableMarquees(), this.isBreadcrumb === !0 && t.breadcrumb === !1 && this.grow(), 
        this.isBreadcrumb === !1 && t.breadcrumb === !0 && this.shrink()), this.set("isBreadcrumb", t.breadcrumb), 
        this.set("isOffscreen", t.offscreen), this.updatesSpottability(), this.startMarqueeAsNeeded(t);
    },
    transitionFinished: function(t) {
        this.updatePanel(t);
    },
    shrinkAnimation: function() {
        this.growing = !1, this.shrinking = !0, this.addClass("shrunken"), this.addClass("shrinking");
    },
    shrink: function() {
        this.addClass("shrunken");
    },
    growAnimation: function() {
        this.growing = !0, this.shrinking = !1, this.addClass("growing"), this.removeClass("shrunken");
    },
    grow: function() {
        this.removeClass("shrunken");
    },
    getInitAnimationValues: function() {
        var t = this.hasNode(), e = parseInt(enyo.dom.getComputedStyleValue(t, "padding-top"), 10), i = parseInt(enyo.dom.getComputedStyleValue(t, "padding-right"), 10), n = parseInt(enyo.dom.getComputedStyleValue(t, "padding-bottom"), 10), o = parseInt(enyo.dom.getComputedStyleValue(t, "padding-left"), 10);
        this.initialHeight = t.offsetHeight - e - n, this.initialWidth = t.offsetWidth - i - o;
    },
    haltAnimations: function() {
        this.removeClass("growing"), this.removeClass("shrinking");
    },
    preTransitionComplete: function() {
        this.shrinking = !1, this.doPreTransitionComplete();
    },
    postTransitionComplete: function() {
        this.growing = !1, this.doPostTransitionComplete();
    },
    animationComplete: function() {
        return this.shrinking ? (this.removeClass("shrinking"), this.preTransitionComplete(), 
        !0) : this.growing ? (this.removeClass("growing"), this.postTransitionComplete(), 
        !0) : void 0;
    },
    headerAnimationComplete: function(t, e) {
        switch (e.animation.name) {
          case "collapseToSmall":
          case "expandToLarge":
            this.resized();
        }
    }
});

// lib\moonstone\source\StyleAnimator.js
enyo.kind({
    name: "enyo.StyleAnimator",
    kind: "Component",
    events: {
        onStep: "",
        onComplete: ""
    },
    published: {
        defaultDuration: 1e3,
        defaultTimingFunction: "linear",
        defaultDirection: "forward"
    },
    transitionProperty: enyo.dom.transition,
    instructions: null,
    stepInterval: null,
    stepIntervalMS: 50,
    startTime: null,
    animations: null,
    create: function() {
        this.inherited(arguments), this.animations = [];
    },
    newAnimation: function(t) {
        this.animations && t.name && this.getAnimation(t.name) && this.deleteAnimation(t.name), 
        t.keyframes = this.formatKeyframes(t.keyframes), t.instructions = this.generateInstructions(t.keyframes);
        var e = {
            name: t.name || this.generateAnimationName(),
            duration: t.duration || this.getDefaultDuration,
            timingFunction: this.updateTimingFunction(t.timingFunction) || this.updateTimingFunction(this.getDefaultTimingFunction()),
            direction: t.direction || this.getDefaultDirection(),
            timeElapsed: 0,
            keyframes: t.keyframes,
            instructions: t.instructions,
            state: "paused"
        };
        return this.animations.push(e), e;
    },
    reset: function(t) {
        this.getAnimation(t), this._reset(t);
    },
    play: function(t) {
        var e = this.getAnimation(t);
        e && (this.findStartAndEndValues(e), this.applyValues(e.startValues), this.cacheStartValues(e.startValues), 
        enyo.asyncMethod(this.bindSafely(function() {
            this._play(t);
        })));
    },
    jumpToEnd: function(t) {
        var e = this.getAnimation(t);
        e && (this.findStartAndEndValues(e), this.applyValues(e.endValues));
    },
    pause: function(t) {
        var e = this.getAnimation(t);
        "playing" === e.state && this._pause(t);
    },
    getAnimation: function(t) {
        for (var e = null, i = 0; this.animations.length > i; i++) if (this.animations[i].name === t) {
            e = this.animations[i];
            break;
        }
        return e;
    },
    deleteAnimation: function(t) {
        var e = this.getAnimation(t);
        return e ? (this._pause(t), this.animations.splice(this.animations.indexOf(e), 1), 
        void 0) : !1;
    },
    start: function() {
        this.beginStepping();
    },
    stop: function() {
        this.stopStepping();
    },
    generateAnimationName: function() {
        for (var t = this.animations.length, e = this.getName() + "_animation_" + t; this.getAnimation(e); ) e = this.getName() + "_animation_" + t;
        return e;
    },
    formatKeyframes: function(t) {
        var e = [];
        for (var i in t) e.push({
            index: i,
            controls: t[i]
        });
        return e;
    },
    updateTimingFunction: function(t) {
        return t.match(/\bcubic-bezier/i) ? t : this.convertTimingFunctionToBezier(t);
    },
    convertTimingFunctionToBezier: function(t) {
        switch (t) {
          case "linear":
            return "cubic-bezier(0, 0, 1, 1)";

          case "ease":
            return "cubic-bezier(0.25, 0.1, 0.25, 1.0)";

          case "ease-in":
            return "cubic-bezier(.42, 0, 1, 1)";

          case "ease-out":
            return "cubic-bezier(0, 0, .58, 1)";

          case "ease-in-out":
            return "cubic-bezier(.42, 0, .58, 1)";
        }
        return enyo.warn("Unknown timing function: ", t), t;
    },
    generateInstructions: function(t) {
        for (var e, i, n = t, o = [], s = 0; n.length - 1 > s; s++) for (var a, r = 0; a = n[s].controls[r]; r++) for (var h in a.properties) e = {
            control: a.control,
            property: h,
            startValue: a.properties[h],
            startTime: n[s].index
        }, i = this.findInstructionEndValues(e, s + 1, n), i && o.push(enyo.mixin(e, i));
        return o;
    },
    findStartAndEndValues: function(t) {
        for (var e, i, n = t.keyframes, o = {}, s = {}, a = 0; n.length > a; a++) for (var r, h = 0; r = n[a].controls[h]; h++) {
            e = r.control, i = e.id, o[i] || (o[i] = {
                control: e,
                properties: {}
            }), s[i] || (s[i] = {
                control: e,
                properties: {}
            });
            for (var l in r.properties) "current" === r.properties[l] && (r.properties[l] = enyo.dom.getComputedStyle(e.hasNode())[l]), 
            (0 === a || o[i].properties[l] === void 0) && (o[i].properties[l] = r.properties[l]), 
            s[i].properties[l] = r.properties[l];
        }
        t.startValues = o, t.endValues = s;
    },
    findInstructionEndValues: function(t, e, i) {
        for (var n = e; i.length > n; n++) for (var o, s = 0; o = i[n].controls[s]; s++) if (o.control === t.control) for (var a in o.properties) if (a === t.property) return {
            endValue: o.properties[a],
            endTime: i[n].index
        };
    },
    _play: function(t) {
        this.startAnimation(t), this.beginStepping();
    },
    startAnimation: function(t) {
        var e = this.getAnimation(t);
        this.applyTransitions(t, 0), e.state = "playing", e.timeElapsed = 0, e.startTime = enyo.perfNow();
    },
    applyValues: function(t) {
        var e, i, n;
        for (e in t) {
            n = t[e].control;
            for (i in t[e].properties) n.applyStyle(i, t[e].properties[i]);
        }
    },
    cacheStartValues: function(t) {
        var e, i;
        this.startValues = t;
        for (e in t) i = t[e].control, t[e].properties[this.transitionProperty] = i[this.transitionProperty];
    },
    applyTransitions: function(t, e) {
        for (var i = this.getAnimation(t), n = i.instructions, o = 0; n.length > o; o++) e >= n[o].startTime && !n[o].started && (this.applyTransition(t, n[o]), 
        n[o].started = !0);
    },
    applyTransition: function(t, e) {
        var i = this.getAnimation(t), n = e.control[this.transitionProperty], o = (e.endTime - e.startTime) * i.duration / 1e5, s = n ? n + ", " : "", a = this.transitionProperty;
        s += e.property + " " + o + "s " + i.timingFunction + " 0s", e.control.applyStyle(a, s), 
        e.control[a] = s, e.control.applyStyle(e.property, e.endValue);
    },
    beginStepping: function() {
        this.stepInterval || (this.stepInterval = setInterval(this.bindSafely("_step"), this.stepIntervalMS));
    },
    stopStepping: function() {
        this.stepInterval && (clearInterval(this.stepInterval), this.stepInterval = null);
    },
    _step: function() {
        var t, e, i, n = !1, o = enyo.perfNow();
        for (i = 0; t = this.animations[i]; i++) if ("paused" !== t.state) {
            if (e = o - t.startTime, e > t.duration) return 100 != t.percentElapsed && this.applyTransitions(t.name, 100), 
            t.percentElapsed = 100, this.doStep({
                animation: t
            }), this.completeAnimation(t.name), void 0;
            t.timeElapsed = e, t.percentElapsed = Math.round(100 * e / t.duration), this.applyTransitions(t.name, t.percentElapsed), 
            n = !0, this.doStep({
                animation: t
            });
        }
        n || this.stop();
    },
    completeAnimation: function(t) {
        var e = this.getAnimation(t);
        this._pause(t), this._reset(t), this.doComplete({
            animation: e
        });
    },
    _reset: function(t) {
        var e = this.getAnimation(t);
        for (var i in e.startValues) e.startValues[i].control.applyStyle(this.transitionProperty, e.startValues[i].properties[this.transitionProperty]);
    },
    _pause: function(t) {
        var e = this.getAnimation(t);
        e.state = "paused";
    }
});

// lib\moonstone\source\Accordion.js
enyo.kind({
    name: "moon.Accordion",
    kind: "moon.ExpandableListItem",
    classes: "moon-accordion",
    components: [ {
        name: "headerWrapper",
        kind: "moon.Item",
        classes: "moon-accordion-header-wrapper",
        onSpotlightFocus: "headerFocus",
        ontap: "expandContract",
        components: [ {
            name: "headerContainer",
            classes: "moon-expandable-list-item-header moon-expandable-picker-header moon-accordion-header",
            components: [ {
                name: "header",
                kind: "moon.MarqueeText"
            } ]
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client",
        components: [ {
            name: "client",
            kind: "Group",
            tag: null
        } ]
    } ],
    bindings: [ {
        from: ".disabled",
        to: ".$.headerWrapper.disabled"
    } ]
});

// lib\moonstone\source\Table.js
enyo.kind({
    name: "moon.Table",
    kind: "enyo.Table",
    classes: "moon-table",
    defaultKind: "moon.TableRow"
}), enyo.kind({
    name: "moon.TableRow",
    kind: "enyo.TableRow",
    classes: "moon-table-row",
    defaultKind: "moon.TableCell"
}), enyo.kind({
    name: "moon.TableCell",
    kind: "enyo.TableCell",
    classes: "moon-table-cell"
});

// lib\moonstone\source\DataTable.js
enyo.kind({
    name: "moon.DataTable",
    kind: "enyo.DataTable",
    defaultKind: "moon.TableRow",
    reset: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.container.resized();
        };
    })
});

// lib\moonstone\source\MoonScrollStrategy.js
enyo.kind({
    name: "moon.ScrollStrategy",
    kind: "enyo.TouchScrollStrategy",
    published: {
        scrollWheelMultiplier: 2,
        scrollWheelPageMultiplier: .2,
        paginationPageMultiplier: .8,
        paginationScrollMultiplier: 8
    },
    handlers: {
        onRequestScrollIntoView: "requestScrollIntoView",
        onRequestSetupBounds: "requestSetupBounds",
        onenter: "enter",
        onleave: "leave"
    },
    tools: [ {
        kind: "ScrollMath",
        onScrollStart: "scrollMathStart",
        onScroll: "scrollMathScroll",
        onScrollStop: "scrollMathStop"
    } ],
    components: [ {
        name: "clientContainer",
        classes: "moon-scroller-client-wrapper",
        components: [ {
            name: "viewport",
            classes: "moon-scroller-viewport",
            spotlight: "container",
            components: [ {
                name: "client",
                classes: "enyo-touch-scroller matrix-scroll-client matrix3dsurface"
            } ]
        } ]
    }, {
        name: "vColumn",
        classes: "moon-scroller-v-column",
        components: [ {
            name: "pageUpControl",
            kind: "moon.PagingControl",
            defaultSpotlightDisappear: "pageDownControl",
            defaultSpotlightDown: "pageDownControl",
            side: "top",
            onPaginateScroll: "paginateScroll",
            onPaginate: "paginate"
        }, {
            name: "vthumbContainer",
            classes: "moon-scroller-thumb-container moon-scroller-vthumb-container",
            components: [ {
                name: "vthumb",
                kind: "moon.ScrollThumb",
                classes: "moon-scroller-vthumb hidden",
                axis: "v"
            } ]
        }, {
            name: "pageDownControl",
            kind: "moon.PagingControl",
            defaultSpotlightDisappear: "pageUpControl",
            defaultSpotlightUp: "pageUpControl",
            side: "bottom",
            onPaginateScroll: "paginateScroll",
            onPaginate: "paginate"
        } ]
    }, {
        name: "hColumn",
        classes: "moon-scroller-h-column",
        components: [ {
            name: "pageLeftControl",
            kind: "moon.PagingControl",
            defaultSpotlightDisappear: "pageRightControl",
            defaultSpotlightRight: "pageRightControl",
            side: "left",
            onPaginateScroll: "paginateScroll",
            onPaginate: "paginate"
        }, {
            name: "hthumbContainer",
            classes: "moon-scroller-thumb-container moon-scroller-hthumb-container",
            components: [ {
                name: "hthumb",
                kind: "moon.ScrollThumb",
                classes: "moon-scroller-hthumb hidden",
                axis: "h"
            } ]
        }, {
            name: "pageRightControl",
            kind: "moon.PagingControl",
            defaultSpotlightDisappear: "pageLeftControl",
            defaultSpotlightLeft: "pageLeftControl",
            side: "right",
            onPaginateScroll: "paginateScroll",
            onPaginate: "paginate"
        } ]
    }, {
        kind: "Signals",
        onSpotlightModeChanged: "spotlightModeChanged",
        isChrome: !0
    } ],
    create: function() {
        this.inherited(arguments), this.transform = enyo.dom.canTransform(), this.accel = enyo.dom.canAccelerate(), 
        this.container.addClass("enyo-touch-strategy-container"), this.translation = this.accel ? "matrix3d" : "matrix", 
        this.showHideScrollColumns(this.spotlightPagingControls);
    },
    rendered: function() {
        enyo.TouchScrollStrategy.prototype.rendered._inherited.apply(this, arguments), this.setupBounds(), 
        this.spotlightPagingControlsChanged();
    },
    resizeHandler: function() {
        this.resizing = !0, this.resetCachedValues(), this.setupBounds(), this.resizing = !1;
    },
    setupBounds: function() {
        this.calcBoundaries(), this.syncScrollMath(), this.enableDisableScrollColumns(), 
        this.setThumbSizeRatio(), this.clampScrollPosition();
    },
    setLastFocusedChild: function(t) {
        enyo.Spotlight.Container.setLastFocusedChild(this.$.viewport, t);
    },
    getScrollLeft: function() {
        return this.scrollLeft;
    },
    getScrollTop: function() {
        return this.scrollTop;
    },
    setScrollLeft: function(t) {
        var e = this.$.scrollMath;
        e.setScrollX(-t), e.stabilize();
    },
    setScrollTop: function(t) {
        var e = this.$.scrollMath;
        e.setScrollY(-t), e.stabilize();
    },
    scrollTo: function(t, e, i) {
        if (this.stop(), this.resizing || i === !1) {
            var n = this.getScrollBounds();
            t = Math.max(Math.min(t, n.maxLeft), 0), e = Math.max(Math.min(e, n.maxTop), 0), 
            this.effectScroll(t, e), this.bubble("onScroll");
        } else this._scrollTo(t, e);
    },
    maxHeightChanged: function() {
        this.$.client.applyStyle("min-height", this.maxHeight ? null : "100%"), this.$.client.applyStyle("max-height", this.maxHeight), 
        this.$.clientContainer.addRemoveClass("enyo-scrollee-fit", !this.maxHeight);
    },
    shouldDrag: function() {
        return !0;
    },
    hold: function(t, e) {
        this.isPageControl(e.originator) || this.inherited(arguments);
    },
    down: function(t, e) {
        this.isPageControl(e.originator) || !this.isScrolling() || this.isOverscrolling() || this.stop();
    },
    mousewheel: function(t, e) {
        if (this.useMouseWheel) {
            var i = this.isScrolling();
            this.scrollBounds = this._getScrollBounds(), this.setupBounds();
            var n = null, o = null, s = this.showVertical(), a = this.showHorizontal(), r = null, h = null, l = null, d = null;
            if (!s && !a) return this.scrollBounds = null, !1;
            if (s && (r = e.wheelDeltaY >= 0 ? 1 : -1, h = Math.abs(e.wheelDeltaY * this.scrollWheelMultiplier), 
            l = this.scrollBounds.clientHeight * this.scrollWheelPageMultiplier, d = Math.min(h, l), 
            o = (i ? this.lastScrollToY : this.scrollTop) + -r * d), a) {
                var c = 1;
                this.$.pageLeftControl.rtl && (c = -1), e.wheelDeltaX ? (r = (e.wheelDeltaX >= 0 ? 1 : -1) * c, 
                h = Math.abs(e.wheelDeltaX * this.scrollWheelMultiplier), l = this.scrollBounds.clientWidth * this.scrollWheelPageMultiplier, 
                d = Math.min(h, l), n = (i ? this.lastScrollToX : this.scrollLeft) + -r * d) : s || (r = (e.wheelDeltaY >= 0 ? 1 : -1) * c, 
                h = Math.abs(e.wheelDeltaY * this.scrollWheelMultiplier), l = this.scrollBounds.clientWidth * this.scrollWheelPageMultiplier, 
                d = Math.min(h, l), n = (i ? this.lastScrollToX : this.scrollLeft) + -r * d);
            }
            return this.scrollTo(n, o), e.preventDefault(), this.scrollBounds = null, !0;
        }
    },
    enter: function() {
        this.hovering = !0, this.setupBounds(), this.showHideScrollColumns(!0), this.updateHoverOnPagingControls(!0);
    },
    leave: function() {
        this.hovering = !1, this.showHideScrollColumns(!1);
    },
    paginate: function(t, e) {
        var i = this.getScrollBounds(), n = i.clientHeight * this.paginationPageMultiplier, o = i.clientWidth * this.paginationPageMultiplier, s = e.originator.side, a = this.getScrollLeft(), r = this.getScrollTop();
        switch (s) {
          case "left":
            a -= o;
            break;

          case "top":
            r -= n;
            break;

          case "right":
            a += o;
            break;

          case "bottom":
            r += n;
        }
        return a = Math.max(0, Math.min(a, i.maxLeft)), r = Math.max(0, Math.min(r, i.maxTop)), 
        this._scrollTo(a, r), !0;
    },
    paginateScroll: function(t, e) {
        if (e && e.scrollDelta) {
            var i, n = e.scrollDelta * this.paginationScrollMultiplier, o = e.originator.side;
            switch (o) {
              case "left":
                i = this.scrollLeft - n, -this.$.scrollMath.leftBoundary >= i ? (this.setScrollLeft(-this.$.scrollMath.leftBoundary), 
                this.$.pageLeftControl.hitBoundary()) : this.setScrollLeft(i);
                break;

              case "top":
                i = this.scrollTop - n, -this.$.scrollMath.topBoundary >= i ? (this.setScrollTop(-this.$.scrollMath.topBoundary), 
                this.$.pageUpControl.hitBoundary()) : this.setScrollTop(i);
                break;

              case "right":
                i = this.scrollLeft + n, i >= -this.$.scrollMath.rightBoundary ? (this.setScrollLeft(-this.$.scrollMath.rightBoundary), 
                this.$.pageRightControl.hitBoundary()) : this.setScrollLeft(i);
                break;

              case "bottom":
                i = this.scrollTop + n, i >= -this.$.scrollMath.bottomBoundary ? (this.setScrollTop(-this.$.scrollMath.bottomBoundary), 
                this.$.pageDownControl.hitBoundary()) : this.setScrollTop(i);
            }
            return !0;
        }
    },
    _scrollTo: function(t, e) {
        this.lastScrollToX = t, this.lastScrollToY = e, this.$.scrollMath.scrollTo(t, e);
    },
    isPageControl: function(t) {
        return t === this.$.pageUpControl || t === this.$.pageDownControl || t === this.$.pageLeftControl || t === this.$.pageRightControl;
    },
    calcBoundaries: function() {
        var t = this.$.scrollMath || this, e = this._getScrollBounds();
        t.bottomBoundary = -1 * e.maxTop, t.rightBoundary = -1 * e.maxLeft;
    },
    effectScroll: function(t, e) {
        this.scrollLeft = null === t || isNaN(t) ? this.scrollLeft || 0 : t, this.scrollTop = null === e || isNaN(e) ? this.scrollTop || 0 : e, 
        enyo.dom.transformValue(this.$.client, this.translation, this.generateMatrix());
    },
    generateMatrix: function() {
        var t = -1 * this.scrollLeft, e = -1 * this.scrollTop;
        return this.$.pageLeftControl.rtl && (t *= -1), this.accel ? "1,         0,     0,  0, 0,         1,     0,  0, 0,         0,     1,  0, " + t + ", " + e + ", 1,  1" : "1, 0, 0, 1, " + t + ", " + e;
    },
    effectScrollStop: function() {},
    effectOverscroll: function() {},
    spotlightPagingControlsChanged: function() {
        this.updateHoverOnPagingControls(!this.spotlightPagingControls), this.showHideScrollColumns(this.spotlightPagingControls), 
        this.generated && this.setupBounds();
    },
    updateHoverOnPagingControls: function(t) {
        enyo.forEach([ this.$.pageLeftControl, this.$.pageRightControl, this.$.pageUpControl, this.$.pageDownControl ], function(e) {
            e.addRemoveClass("hover", t);
        }, this);
    },
    setThumbSizeRatio: function() {
        var t = this.getScrollBounds();
        this.$.vthumb.setSizeRatio(this.getVerticalThumbBounds().height / t.clientHeight), 
        this.$.hthumb.setSizeRatio(this.getHorizontalThumbBounds().width / t.clientWidth);
    },
    requestScrollIntoView: function(t, e) {
        var i, n, o = !1;
        return enyo.Spotlight.getPointerMode() && e.scrollInPointerMode !== !0 || (i = this.showVertical(), 
        n = this.showHorizontal(), this.scrollBounds = this._getScrollBounds(), this.setupBounds(), 
        this.scrollBounds = null, i || n ? (this.animateToControl(e.originator, e.scrollFullPage, e.scrollInPointerMode || !1), 
        (i && this.$.scrollMath.bottomBoundary || n && this.$.scrollMath.rightBoundary) && this.alertThumbs()) : o = !0), 
        !o;
    },
    requestSetupBounds: function() {
        return this.scrollBounds = this._getScrollBounds(), this.setupBounds(), this.scrollBounds = null, 
        (this.showVertical() && this.$.scrollMath.bottomBoundary || this.showHorizontal() && this.$.scrollMath.rightBoundary) && this.alertThumbs(), 
        !0;
    },
    spotlightModeChanged: function() {
        var t = this.shouldShowPageControls();
        this.showHideScrollColumns(t), this.updateHoverOnPagingControls(t);
    },
    enableDisableScrollColumns: function() {
        this.enableDisableVerticalScrollControls(this.showVertical()), this.enableDisableHorizontalScrollControls(this.showHorizontal());
    },
    enableDisableVerticalScrollControls: function(t) {
        this.$.clientContainer.addRemoveClass("v-scroll-enabled", t), this.$.vColumn.addRemoveClass("v-scroll-enabled", t), 
        this.$.hColumn.addRemoveClass("v-scroll-enabled", t), this.$.pageUpControl.spotlight = t && this.spotlightPagingControls, 
        this.$.pageDownControl.spotlight = t && this.spotlightPagingControls;
    },
    enableDisableHorizontalScrollControls: function(t) {
        this.$.clientContainer.addRemoveClass("h-scroll-enabled", t), this.$.vColumn.addRemoveClass("h-scroll-enabled", t), 
        this.$.hColumn.addRemoveClass("h-scroll-enabled", t), this.$.pageLeftControl.spotlight = t && this.spotlightPagingControls, 
        this.$.pageRightControl.spotlight = t && this.spotlightPagingControls;
    },
    showHideScrollColumns: function(t) {
        this.showHideVerticalScrollColumns(t), this.showHideHorizontalScrollColumns(t);
    },
    showHideVerticalScrollColumns: function(t) {
        this.$.vColumn.addRemoveClass("visible", t || this.spotlightPagingControls);
    },
    showHideHorizontalScrollColumns: function(t) {
        this.$.hColumn.addRemoveClass("visible", t || this.spotlightPagingControls);
    },
    shouldShowPageControls: function() {
        return enyo.Spotlight.getPointerMode() && this.hovering;
    },
    showVertical: function() {
        return "scroll" == this.getVertical() || "hidden" !== this.getVertical() && (-1 * this.$.scrollMath.bottomBoundary > 0 || this.spotlightPagingControls);
    },
    showHorizontal: function() {
        return "scroll" == this.getHorizontal() || "hidden" !== this.getHorizontal() && (-1 * this.$.scrollMath.rightBoundary > 0 || this.spotlightPagingControls);
    },
    _getScrollBounds: function() {
        if (this.scrollBounds) return this.scrollBounds;
        var t = this.getContainerBounds(), e = this.getScrollSize(), i = {
            top: this.getScrollTop(),
            left: this.getScrollLeft(),
            clientHeight: t.height,
            clientWidth: t.width,
            height: e.height,
            width: e.width
        };
        i.maxLeft = Math.max(0, i.width - i.clientWidth), i.maxTop = Math.max(0, i.height - i.clientHeight);
        var n = this.$.scrollMath, o = i.height > i.clientHeight, s = i.width > i.clientWidth;
        return this.$.pageUpControl.setDisabled(0 >= i.top || !o), this.$.pageDownControl.setDisabled(i.top >= -1 * n.bottomBoundary || !o), 
        this.$.pageLeftControl.setDisabled(0 >= i.left || !s), this.$.pageRightControl.setDisabled(i.left >= -1 * n.rightBoundary || !s), 
        enyo.mixin(i, this.getOverScrollBounds()), i;
    },
    getContainerBounds: function() {
        var t = this.$.clientContainer.getBounds();
        if (t) {
            var e = enyo.dom.calcPaddingExtents(this.$.clientContainer.hasNode());
            t.width -= e.left + e.right, t.height -= e.top + e.bottom;
        }
        return t;
    },
    getVerticalThumbBounds: function() {
        return this.vBounds ? this.vBounds : this.$.vthumbContainer.getBounds();
    },
    getHorizontalThumbBounds: function() {
        return this.hBounds ? this.hBounds : this.$.hthumbContainer.getBounds();
    },
    resetCachedValues: function() {
        this.vBounds = null, this.hBounds = null, this.scrollBounds = null;
    },
    animateToControl: function(t, e, i) {
        var n, o, s, a, r, h, l, d, c = t.getAbsoluteBounds(), u = this.$.viewport.getAbsoluteBounds(), p = this._getScrollBounds();
        switch (c.top += p.top, this.rtl ? c.right += p.left : c.left += p.left, n = c.top - u.top, 
        o = (this.rtl ? c.right : c.left) - (this.rtl ? u.right : u.left), s = c.height, 
        a = c.width, e = e === void 0 ? this.container.getScrollFullPage() : e, r = o >= p.left && p.left + p.clientWidth >= o + a ? 0 : o - p.left > 0 ? 1 : 0 > o - p.left ? -1 : 0, 
        h = n >= p.top && p.top + p.clientHeight >= n + s ? 0 : n - p.top > 0 ? 1 : 0 > n - p.top ? -1 : 0, 
        p.xDir = r, p.yDir = h, r) {
          case 0:
            l = this.getScrollLeft();
            break;

          case 1:
            e || a > p.clientWidth ? l = o : (l = o - p.clientWidth + a, l += enyo.dom.getComputedBoxValue(t.hasNode(), "margin", "right"));
            break;

          case -1:
            e || a > p.clientWidth ? l = o - p.clientWidth + a : (l = o, l -= enyo.dom.getComputedBoxValue(t.hasNode(), "margin", "left"));
        }
        switch (h) {
          case 0:
            d = this.getScrollTop();
            break;

          case 1:
            e || s > p.clientHeight ? (d = n, d -= enyo.dom.getComputedBoxValue(t.hasNode(), "margin", "top")) : (d = n - p.clientHeight + s, 
            d += enyo.dom.getComputedBoxValue(t.hasNode(), "margin", "bottom"));
            break;

          case -1:
            e || s > p.clientHeight ? d = n - p.clientHeight + s : (d = n, d -= enyo.dom.getComputedBoxValue(t.hasNode(), "margin", "bottom"));
        }
        (l !== this.getScrollLeft() || d !== this.getScrollTop()) && this.scrollTo(l, d, i);
    },
    clampScrollPosition: function() {
        var t = this.clampX(), e = this.clampY();
        (t !== this.getScrollLeft() || e !== this.getScrollTop()) && this.scrollTo(t, e);
    },
    clampX: function() {
        var t = this.$.scrollMath;
        return Math.min(Math.max(this.getScrollLeft(), -1 * t.leftBoundary), -1 * t.rightBoundary);
    },
    clampY: function() {
        var t = this.$.scrollMath;
        return Math.min(Math.max(this.getScrollTop(), -1 * t.topBoundary), -1 * t.bottomBoundary);
    }
}), enyo.dispatcher.features.push(function(t) {
    "keydown" == t.type && enyo.platform.webos && 9 == t.keyCode && t.preventDefault();
});

// lib\moonstone\source\Thumb.js
enyo.kind({
    name: "moon.ScrollThumb",
    kind: "enyo.ScrollThumb",
    published: {
        sizeRatio: 1
    },
    classes: "moon-thumb matrix3dsurface",
    minSize: 20,
    create: function() {
        this.inherited(arguments);
        var t = "v" == this.axis;
        this.offset = t ? "top" : "left", this.transform = enyo.dom.canTransform(), this.accel = enyo.dom.canAccelerate(), 
        this.translation = this.accel ? "matrix3d" : "matrix", this.positionMethod = t ? "getScrollTop" : "getScrollLeft", 
        this.sizeDimension = t ? "clientHeight" : "clientWidth", this.addClass("enyo-" + this.axis + "thumb");
    },
    update: function(t) {
        if (this.showing && this.scrollBounds) {
            var e = this.dimension, i = this.scrollBounds[this.sizeDimension], n = this.scrollBounds[e], o = 0, s = 0, a = 0, r = this.getSizeRatio();
            if (i >= n) return this.hide(), void 0;
            t.isOverscrolling() && (a = t.getOverScrollBounds()["over" + this.offset], o = Math.abs(a), 
            s = Math.max(a, 0));
            var h = t[this.positionMethod]() - a, l = i - this.cornerSize, d = Math.floor(i * i / n - o);
            d = Math.max(this.minSize, d);
            var c = Math.floor(l * h / n + s);
            c = Math.max(0, Math.min(l - this.minSize, c)), c *= r, d *= r, this.needed = i > d, 
            this.needed && this.hasNode() ? enyo.dom.transformValue(this, this.translation, this.generateMatrix(c, d)) : this.hide();
        }
    },
    generateMatrix: function(t, e) {
        var i, n, o, s, a = this.hasNode();
        return a ? "v" === this.axis ? (i = 0, n = t, o = 1, s = e / a.offsetHeight) : (i = t, 
        n = 0, o = e / a.offsetWidth, s = 1) : (i = 0, n = 0, o = 1, s = 1), this.accel ? this.assemble3dMatrix(i, n, o, s) : this.assemle2dMatrix(i, n, o, s);
    },
    assemle2dMatrix: function(t, e, i, n) {
        return i + ", 0, 0, " + n + ", " + t + ", " + e;
    },
    assemble3dMatrix: function(t, e, i, n) {
        return i + ", 0, 0, 0, 0, " + n + ", 0, 0, 0, 0, 1, 0, " + t + ", " + e + ", 1, 1";
    },
    show: function() {
        this.cancelDelayHide(), this.removeClass("hidden");
    },
    hide: function() {
        this.addClass("hidden");
    }
});

// lib\moonstone\source\InputHeader.js
enyo.kind({
    name: "moon.InputHeader",
    kind: "moon.Header",
    classes: "moon-input-header",
    inputMode: !0
});

// lib\moonstone\source\Scrim.js
enyo.kind({
    name: "moon.Scrim",
    showing: !1,
    classes: "moon-scrim enyo-fit",
    floating: !1,
    create: function() {
        this.inherited(arguments), this.zStack = [], this.floating && this.setParent(enyo.floatingLayer);
    },
    showingChanged: function() {
        this.floating && this.showing && !this.hasNode() && this.render(), this.inherited(arguments);
    },
    addZIndex: function(t) {
        0 > enyo.indexOf(t, this.zStack) && this.zStack.push(t);
    },
    removeZIndex: function(t) {
        enyo.remove(t, this.zStack);
    },
    showAtZIndex: function(t) {
        this.addZIndex(t), void 0 !== t && this.setZIndex(t), this.show();
    },
    hideAtZIndex: function(t) {
        if (this.removeZIndex(t), this.zStack.length) {
            var e = this.zStack[this.zStack.length - 1];
            this.setZIndex(e);
        } else this.hide();
    },
    setZIndex: function(t) {
        this.zIndex = t, this.applyStyle("z-index", t);
    },
    make: function() {
        return this;
    }
}), enyo.kind({
    name: "moon.scrimSingleton",
    kind: null,
    constructor: function(t, e) {
        this.instanceName = t, enyo.setPath(this.instanceName, this), this.props = e || {};
    },
    make: function() {
        var t = new moon.Scrim(this.props);
        return enyo.setPath(this.instanceName, t), t;
    },
    showAtZIndex: function(t) {
        var e = this.make();
        e.showAtZIndex(t);
    },
    hideAtZIndex: enyo.nop,
    show: function() {
        var t = this.make();
        t.show();
    }
}), new moon.scrimSingleton("moon.scrim", {
    floating: !0,
    classes: "moon-scrim-translucent"
}), new moon.scrimSingleton("moon.scrimTransparent", {
    floating: !0,
    classes: "moon-scrim-transparent"
});

// lib\moonstone\source\Popup.js
enyo.kind({
    name: "moon.Popup",
    kind: enyo.Popup,
    modal: !0,
    classes: "moon moon-neutral enyo-unselectable moon-popup",
    floating: !0,
    _bounds: null,
    spotlight: "container",
    allowDefault: !0,
    handlers: {
        onRequestScrollIntoView: "_preventEventBubble",
        ontransitionend: "animationEnd",
        onSpotlightSelect: "handleSpotlightSelect"
    },
    eventsToCapture: {
        onSpotlightFocus: "capturedFocus"
    },
    published: {
        scrimWhenModal: !0,
        scrim: !0,
        scrimClassName: "",
        spotlightModal: !1,
        showCloseButton: "auto",
        animate: !0
    },
    tools: [ {
        name: "client",
        classes: "enyo-fill"
    }, {
        name: "closeButton",
        kind: "moon.IconButton",
        icon: "closex",
        classes: "moon-popup-close",
        ontap: "closePopup",
        showing: !1
    } ],
    statics: {
        count: 0
    },
    defaultZ: 120,
    activator: null,
    initComponents: function() {
        this.createComponents(this.tools, {
            owner: this
        }), this.inherited(arguments);
    },
    create: function() {
        this.inherited(arguments), this.animateChanged();
    },
    animateChanged: function() {
        this.animate && this.animateShow(), this.addRemoveClass("animate", this.animate), 
        this.animate || (this.applyStyle("bottom", null), enyo.dom.transform(this, {
            translateY: null
        }));
    },
    render: function() {
        this.allowHtmlChanged(), this.contentChanged(), this.inherited(arguments);
    },
    contentChanged: function() {
        this.$.client.setContent(this.content);
    },
    allowHtmlChanged: function() {
        this.$.client.setAllowHtml(this.allowHtml);
    },
    handleSpotlightSelect: function(t, e) {
        this.downEvent = e;
    },
    capturedTap: function() {
        return this.downEvent && "onSpotlightSelect" === this.downEvent.type ? void 0 : this.inherited(arguments);
    },
    capturedFocus: function() {
        var t = enyo.Spotlight.getLastControl(), e = enyo.Spotlight.getCurrent();
        return t === this && e === this.activator || t.isDescendantOf(this) && e !== this ? enyo.Spotlight.spot(this) : this.hide(), 
        !0;
    },
    configCloseButton: function() {
        if (this.$.closeButton) {
            var t = this.showCloseButton === !0 || this.spotlightModal === !0 && this.showCloseButton !== !1;
            t != this.$.closeButton.getShowing() && (this.$.closeButton.setShowing(t), this.addRemoveClass("reserve-close", t), 
            this.generated && this.resized());
        }
    },
    spotlightModalChanged: function() {
        this.configCloseButton();
    },
    showCloseButtonChanged: function() {
        this.configCloseButton();
    },
    showingChanged: function() {
        if (this.showing ? (this.animate && (this.animationEnd = enyo.nop, this.isAnimatingHide && (this.captureEvents && this.release(), 
        this.isAnimatingHide = !1)), this.activator = enyo.Spotlight.getCurrent(), moon.Popup.count++, 
        this.applyZIndex()) : (moon.Popup.count > 0 && moon.Popup.count--, this.generated && this.respotActivator()), 
        this.animate) if (this.showing) this.inherited(arguments), this.animateShow(); else {
            this.animateHide();
            var t = arguments;
            this.animationEnd = this.bindSafely(function(e, i) {
                i.originator === this && (this.inherited(t), this.isAnimatingHide = !1);
            });
        } else this.inherited(arguments);
        if (this.showHideScrim(this.showing), this.showing) {
            this.configCloseButton();
            var e = enyo.Spotlight.getCurrent();
            e && e.isDescendantOf(this) || (enyo.Spotlight.isSpottable(this) ? enyo.Spotlight.spot(this) : enyo.Spotlight.unspot());
        }
    },
    getShowing: function() {
        return this.animate ? this.showing : this.inherited(arguments);
    },
    showHideScrim: function(t) {
        if (this.floating && (this.scrim || this.modal && this.scrimWhenModal)) {
            var e = this.getScrim();
            if (t && this.modal && this.scrimWhenModal) {
                var i = this.getScrimZIndex();
                this._scrimZ = i, e.showAtZIndex(i);
            } else e.hideAtZIndex(this._scrimZ);
            enyo.call(e, "addRemoveClass", [ this.scrimClassName, e.showing ]);
        }
    },
    getScrimZIndex: function() {
        return this.findZIndex() - 1;
    },
    getScrim: function() {
        return this.modal && this.scrimWhenModal && !this.scrim ? moon.scrimTransparent.make() : moon.scrim.make();
    },
    applyZIndex: function() {
        this._zIndex = 2 * moon.Popup.count + this.findZIndex() + 1, this.applyStyle("z-index", this._zIndex);
    },
    findZIndex: function() {
        var t = this.defaultZ;
        return this._zIndex ? t = this._zIndex : this.hasNode() && (t = Number(enyo.dom.getComputedStyleValue(this.node, "z-index")) || t), 
        this._zIndex = t, this._zIndex;
    },
    closePopup: function() {
        this.$.closeButton && this.$.closeButton.removeClass("pressed"), this.hide();
    },
    respotActivator: function() {
        var t = this.activator;
        this.release(), t && !t.destroyed ? (enyo.Spotlight.spot(t), t instanceof moon.Button && t.removeClass("pressed")) : enyo.Spotlight.spot(enyo.Spotlight.getFirstChild(this.container)), 
        this.activator = null;
    },
    _preventEventBubble: function() {
        return !0;
    },
    animateShow: function() {
        this._bounds = this.getBounds(), this.applyStyle("bottom", -this._bounds.height + "px"), 
        enyo.dom.transform(this, {
            translateY: -this._bounds.height + "px"
        });
    },
    animateHide: function() {
        if (this._bounds) {
            this.isAnimatingHide = !0;
            var t = this._bounds.height;
            this._bounds = this.getBounds(), enyo.dom.transform(this, {
                translateY: this._bounds.height - t + "px"
            });
        }
    },
    destroy: function() {
        this.showHideScrim(!1), this.inherited(arguments);
    }
});

// lib\moonstone\source\Dialog.js
enyo.kind({
    name: "moon.Dialog",
    kind: moon.Popup,
    classes: "moon-dialog",
    published: {
        title: "",
        subTitle: "",
        message: "",
        titleUpperCase: !0
    },
    mixins: [ "moon.MarqueeSupport" ],
    marqueeOnSpotlight: !1,
    marqueeOnHover: !0,
    marqueeOnRender: !0,
    marqueeOnRenderDelay: 5e3,
    tools: [ {
        layoutKind: "FittableColumnsLayout",
        components: [ {
            fit: !0,
            components: [ {
                name: "title",
                kind: "moon.MarqueeText",
                classes: "moon-header-font moon-popup-header-text moon-dialog-title"
            }, {
                name: "subTitle",
                classes: "moon-dialog-sub-title"
            } ]
        }, {
            name: "client",
            classes: "moon-dialog-client"
        } ]
    }, {
        kind: "moon.Divider",
        classes: "moon-dialog-divider"
    }, {
        name: "message",
        kind: "moon.BodyText",
        classes: "moon-dialog-content"
    }, {
        name: "spotlightDummy",
        spotlight: !1
    } ],
    create: function() {
        this.inherited(arguments), this.titleChanged(), this.subTitleChanged(), this.messageChanged();
    },
    titleChanged: function() {
        var t = this.getTitle();
        this.$.title.setContent(this.getTitleUpperCase() ? enyo.toUpperCase(t) : t);
    },
    titleUpperCaseChanged: function() {
        this.titleChanged();
    },
    subTitleChanged: function() {
        this.$.subTitle.setContent(this.subTitle);
    },
    messageChanged: function() {
        this.$.message.setContent(this.message);
    }
});

// lib\moonstone\source\TooltipDecorator.js
enyo.kind({
    name: "moon.TooltipDecorator",
    defaultKind: "moon.Button",
    classes: "moon-contextual-popup-decorator",
    handlers: {
        onenter: "enter",
        onleave: "leave",
        onSpotlightFocused: "spotFocused",
        onSpotlightBlur: "spotBlur",
        onRequestMuteTooltip: "mute",
        onRequestUnmuteTooltip: "unmute"
    },
    published: {
        autoShow: !0
    },
    mute: function() {
        this.setAutoShow(!1);
    },
    unmute: function() {
        this.setAutoShow(!0);
    },
    autoShowChanged: function() {
        this.autoShow || this.requestHideTooltip();
    },
    enter: function() {
        this.requestShowTooltip();
    },
    leave: function() {
        this.requestHideTooltip();
    },
    spotFocused: function() {
        this.requestShowTooltip();
    },
    spotBlur: function() {
        this.requestHideTooltip();
    },
    tap: function() {
        this.requestHideTooltip();
    },
    requestShowTooltip: function() {
        this.autoShow && !enyo.Spotlight.isFrozen() && this.waterfallDown("onRequestShowTooltip");
    },
    requestHideTooltip: function() {
        this.waterfallDown("onRequestHideTooltip");
    }
});

// lib\moonstone\source\Tooltip.js
enyo.kind({
    name: "moon.Tooltip",
    kind: "enyo.Popup",
    classes: "moon-tooltip below left-arrow",
    published: {
        autoDismiss: !1,
        showDelay: 500,
        position: "auto",
        defaultLeft: 0,
        contentUpperCase: !0
    },
    captureEvents: !1,
    handlers: {
        onRequestShowTooltip: "requestShow",
        onRequestHideTooltip: "requestHide"
    },
    tools: [ {
        name: "client",
        classes: "moon-tooltip-label moon-header-font"
    } ],
    initComponents: function() {
        this.createChrome(this.tools), this.inherited(arguments);
    },
    create: function() {
        this.inherited(arguments), this.contentChanged();
    },
    contentChanged: function() {
        this.detectTextDirectionality();
        var t = this.getContent();
        this.$.client.setContent(this.getContentUpperCase() ? enyo.toUpperCase(t) : t);
    },
    contentUpperCaseChanged: function() {
        this.contentChanged();
    },
    positionChanged: function() {
        this.inherited(arguments), this.adjustPosition(!0);
    },
    requestShow: function() {
        return this.startJob("showJob", "show", this.showDelay), !0;
    },
    cancelShow: function() {
        this.stopJob("showJob");
    },
    requestHide: function() {
        return this.cancelShow(), this.inherited(arguments);
    },
    showingChanged: function() {
        this.cancelShow(), this.inherited(arguments), this.adjustPosition(!0);
    },
    applyPosition: function(t) {
        var e = "";
        for (var i in t) e += i + ":" + t[i] + (isNaN(t[i]) ? "; " : "px; ");
        this.addStyles(e);
    },
    adjustPosition: function() {
        if (this.showing && this.hasNode()) {
            var t = this.node.getBoundingClientRect(), e = 20, i = this.parent.getAbsoluteBounds(), n = null;
            this.activator = enyo.Spotlight.getCurrent(), n = this.activator.getAbsoluteBounds();
            var o = i.top - n.top, s = n.left - i.left, a = i.left + i.width - n.left - n.width, r = window.innerWidth - e - n.left - n.width;
            (window.innerHeight - e - (i.top + i.height) < t.height + 5 || "above" == this.position) && (this.removeClass("below"), 
            this.addClass("above"), this.get("floating") ? this.applyPosition({
                top: n.top - t.height - 5 + "px",
                left: n.left + n.width / 2 + "px",
                right: "auto"
            }) : this.applyPosition({
                top: -(t.height + 5 + o) + "px",
                left: n.width / 2 + s + "px",
                right: "auto"
            })), (i.top < t.height + 5 || "below" == this.position || this.hasClass("below")) && (this.removeClass("above"), 
            this.addClass("below"), this.get("floating") ? this.applyPosition({
                top: n.top + n.height + 5 + "px",
                left: n.left + n.width / 2 + "px",
                right: "auto"
            }) : this.applyPosition({
                top: i.height + 5 + o + "px",
                left: n.width / 2 + s + "px",
                right: "auto"
            })), window.innerWidth - e - i.left - i.width / 2 < t.width && (this.removeClass("left-arrow"), 
            this.addClass("right-arrow"), this.applyPosition({
                "margin-left": -t.width + "px",
                left: "auto"
            }), this.floating ? this.applyStyle("right", n.width / 2 + r + e + "px") : this.applyStyle("right", n.width / 2 + a + "px"));
        }
    },
    resizeHandler: function() {
        this.applyPosition({
            "margin-left": this.defaultLeft,
            bottom: "auto"
        }), this.adjustPosition(!0), this.inherited(arguments);
    }
});

// lib\moonstone\source\ExpandableInput.js
enyo.kind({
    name: "moon.ExpandableInput",
    kind: "moon.ExpandableListItem",
    classes: "moon-expandable-input",
    events: {
        onChange: ""
    },
    published: {
        noneText: "",
        placeholder: "",
        value: ""
    },
    autoCollapse: !0,
    lockBottom: !1,
    components: [ {
        name: "headerWrapper",
        kind: "moon.Item",
        classes: "moon-expandable-picker-header-wrapper",
        onSpotlightFocus: "headerFocus",
        ondown: "headerDown",
        ontap: "expandContract",
        components: [ {
            name: "headerContainer",
            classes: "moon-expandable-list-item-header moon-expandable-picker-header moon-expandable-input-header",
            components: [ {
                name: "header",
                kind: "moon.MarqueeText"
            } ]
        }, {
            name: "currentValue",
            kind: "moon.MarqueeText",
            classes: "moon-expandable-picker-current-value"
        } ]
    }, {
        name: "drawer",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        classes: "moon-expandable-list-item-client indented",
        components: [ {
            name: "inputDecorator",
            kind: "moon.InputDecorator",
            onSpotlightBlur: "inputBlur",
            onSpotlightFocus: "inputFocus",
            onSpotlightDown: "inputDown",
            components: [ {
                name: "clientInput",
                kind: "moon.Input",
                onchange: "doChange",
                onkeydown: "inputKeyDown"
            } ]
        } ]
    } ],
    bindings: [ {
        from: ".value",
        to: ".$.clientInput.value",
        oneWay: !1
    }, {
        from: ".placeholder",
        to: ".$.clientInput.placeholder"
    }, {
        from: ".showCurrentValue",
        to: ".$.currentValue.showing"
    }, {
        from: ".currentValueText",
        to: ".$.currentValue.content"
    }, {
        from: ".disabled",
        to: ".$.headerWrapper.disabled"
    } ],
    computed: {
        showCurrentValue: [ "open", "value", "noneText" ],
        currentValueText: [ "value", "noneText" ]
    },
    showCurrentValue: function() {
        return !this.open && "" !== this.currentValueText();
    },
    currentValueText: function() {
        return "" === this.value ? this.noneText : this.value;
    },
    expandContract: function() {
        return this.disabled ? !0 : (this.getOpen() ? this.closeDrawerAndHighlightHeader() : this.toggleActive(), 
        void 0);
    },
    toggleActive: function() {
        this.getOpen() ? (this.setActive(!1), this.$.clientInput.blur()) : (this.setActive(!0), 
        enyo.Spotlight.unspot(), enyo.Spotlight.freeze());
    },
    inputFocus: function(t, e) {
        var i = e && e.dir;
        this.getOpen() && i && this.focusInput();
    },
    inputBlur: function() {
        this.$.clientInput.hasFocus() && enyo.Spotlight.getPointerMode() && "down" === enyo.Spotlight.getLastEvent().type && this.toggleActive();
    },
    inputKeyDown: function(t, e) {
        13 === e.keyCode && this.closeDrawerAndHighlightHeader();
    },
    headerDown: function() {
        enyo.Spotlight.unfreeze();
    },
    spotlightDown: function(t, e) {
        e.originator === this.$.headerWrapper && this.getOpen() && this.focusInput();
    },
    focusInput: function() {
        this.$.clientInput.focus(), this.$.clientInput.hasNode().selectionStart = this.value.length;
    },
    inputDown: function() {
        return this.getLockBottom() ? this.focusInput() : this.closeDrawerAndHighlightHeader(), 
        !0;
    },
    drawerAnimationEnd: function() {
        enyo.Spotlight.unfreeze(), this.getOpen() && this.focusInput(), this.inherited(arguments);
    },
    closeDrawerAndHighlightHeader: function() {
        enyo.Spotlight.setPointerMode(!1), enyo.Spotlight.unfreeze(), enyo.Spotlight.spot(this.$.headerWrapper), 
        this.toggleActive();
    }
});

// lib\moonstone\source\VideoPlayer.js
enyo.kind({
    name: "moon.VideoPlayer",
    kind: "enyo.Control",
    spotlight: !0,
    classes: "moon-video-player enyo-unselectable",
    events: {
        onPlaybackControlsTapped: ""
    },
    published: {
        src: "",
        sources: null,
        autoResize: !1,
        aspectRatio: "16:9",
        fixedHeight: !1,
        autoCloseTimeout: 7e3,
        duration: 0,
        autoplay: !1,
        autoShowOverlay: !0,
        shakeAndWake: !1,
        autoShowInfo: !0,
        autoShowControls: !0,
        showInfo: !1,
        inline: !1,
        jumpSec: 30,
        jumpStartEnd: !1,
        autoHidePopups: !0,
        showProgressBar: !0,
        showPlaybackControls: !0,
        hideButtonsOnSlider: !0,
        disableSlider: !1,
        showJumpControls: !0,
        showFFRewindControls: !1,
        disablePlaybackControls: !1,
        disablePlaybackControlsOnUnload: !0,
        showPlayPauseControl: !0,
        showVideo: !0,
        autoShowSpinner: !0,
        iconPath: "$lib/moonstone/images/video-player/",
        jumpBackIcon: "skipbackward",
        rewindIcon: "backward",
        playIcon: "play",
        pauseIcon: "pause",
        fastForwardIcon: "forward",
        jumpForwardIcon: "skipforward",
        moreControlsIcon: "arrowextend",
        lessControlsIcon: "arrowshrink",
        inlinePlayIcon: "play",
        inlinePauseIcon: "pause",
        inlineFullscreenIcon: "fullscreen",
        playbackRateHash: {
            fastForward: [ "2", "4", "8", "16" ],
            rewind: [ "-2", "-4", "-8", "-16" ],
            slowForward: [ "1/4", "1/2", "1" ],
            slowRewind: [ "-1/2", "-1" ]
        },
        poster: "",
        handleRemoteControlKey: !0
    },
    handlers: {
        onRequestTimeChange: "timeChange",
        onRequestToggleFullscreen: "toggleFullscreen",
        onSpotlightUp: "spotlightUpHandler",
        onSpotlightKeyUp: "resetAutoTimeout",
        onSpotlightDown: "spotlightDownHandler",
        onSpotlightKeyDown: "spotlightKeyDownHandler",
        onresize: "resizeHandler"
    },
    bindings: [ {
        from: ".sourceComponents",
        to: ".$.video.sourceComponents"
    }, {
        from: ".playbackRateHash",
        to: ".$.video.playbackRateHash"
    }, {
        from: ".poster",
        to: ".$.video.poster"
    }, {
        from: ".constrainToBgProgress",
        to: ".$.slider.constrainToBgProgress"
    }, {
        from: ".elasticEffect",
        to: ".$.slider.elasticEffect"
    }, {
        from: ".showJumpControls",
        to: ".$.jumpForward.showing"
    }, {
        from: ".showJumpControls",
        to: ".$.jumpBack.showing"
    }, {
        from: ".showFFRewindControls",
        to: ".$.fastForward.showing"
    }, {
        from: ".showFFRewindControls",
        to: ".$.rewind.showing"
    }, {
        from: ".showPlayPauseControl",
        to: ".$.fsPlayPause.showing"
    }, {
        from: ".showVideo",
        to: ".$.videoContainer.showing"
    } ],
    _isPlaying: !1,
    _canPlay: !1,
    _autoCloseTimer: null,
    _currentTime: 0,
    _panelsShowing: !1,
    components: [ {
        kind: "enyo.Signals",
        onPanelsShown: "panelsShown",
        onPanelsHidden: "panelsHidden",
        onPanelsHandleFocused: "panelsHandleFocused",
        onPanelsHandleBlurred: "panelsHandleBlurred",
        onFullscreenChange: "fullscreenChanged",
        onkeyup: "remoteKeyHandler"
    }, {
        name: "videoContainer",
        classes: "moon-video-player-container",
        components: [ {
            name: "video",
            kind: "enyo.Video",
            classes: "moon-video-player-video",
            ontimeupdate: "timeUpdate",
            onloadedmetadata: "metadataLoaded",
            durationchange: "durationUpdate",
            onloadeddata: "dataloaded",
            onprogress: "_progress",
            onPlay: "_play",
            onpause: "_pause",
            onStart: "_start",
            onended: "_stop",
            onFastforward: "_fastforward",
            onSlowforward: "_slowforward",
            onRewind: "_rewind",
            onSlowrewind: "_slowrewind",
            onJumpForward: "_jumpForward",
            onJumpBackward: "_jumpBackward",
            onratechange: "playbackRateChange",
            ontap: "videoTapped",
            oncanplay: "_setCanPlay",
            onwaiting: "_waiting",
            onerror: "_error"
        }, {
            name: "spinner",
            kind: "moon.Spinner",
            classes: "moon-video-player-spinner"
        } ]
    }, {
        name: "fullscreenControl",
        classes: "moon-video-fullscreen-control enyo-fit scrim",
        onmousemove: "mousemove",
        components: [ {
            name: "videoInfoHeaderClient",
            showing: !1,
            classes: "moon-video-player-header"
        }, {
            name: "playerControl",
            classes: "moon-video-player-bottom",
            showing: !1,
            components: [ {
                name: "controls",
                kind: "FittableColumns",
                rtl: !1,
                classes: "moon-video-player-controls",
                ontap: "resetAutoTimeout",
                components: [ {
                    name: "leftPremiumPlaceHolder",
                    classes: "moon-video-player-premium-placeholder-left"
                }, {
                    name: "controlsContainer",
                    kind: "Panels",
                    arrangerKind: "CarouselArranger",
                    fit: !0,
                    draggable: !1,
                    classes: "moon-video-player-controls-container",
                    components: [ {
                        name: "trickPlay",
                        ontap: "playbackControlsTapped",
                        components: [ {
                            name: "playbackControls",
                            classes: "moon-video-player-control-buttons",
                            components: [ {
                                name: "jumpBack",
                                kind: "moon.IconButton",
                                small: !1,
                                onholdpulse: "onHoldPulseBackHandler",
                                ontap: "onjumpBackward"
                            }, {
                                name: "rewind",
                                kind: "moon.IconButton",
                                small: !1,
                                ontap: "rewind"
                            }, {
                                name: "fsPlayPause",
                                kind: "moon.IconButton",
                                small: !1,
                                ontap: "playPause"
                            }, {
                                name: "fastForward",
                                kind: "moon.IconButton",
                                small: !1,
                                ontap: "fastForward"
                            }, {
                                name: "jumpForward",
                                kind: "moon.IconButton",
                                small: !1,
                                onholdpulse: "onHoldPulseForwardHandler",
                                ontap: "onjumpForward"
                            } ]
                        } ]
                    }, {
                        name: "client",
                        classes: "moon-video-player-more-controls"
                    } ]
                }, {
                    name: "rightPremiumPlaceHolder",
                    classes: "moon-video-player-premium-placeholder-right",
                    components: [ {
                        name: "moreButton",
                        kind: "moon.IconButton",
                        small: !1,
                        ontap: "moreButtonTapped"
                    } ]
                } ]
            }, {
                name: "sliderContainer",
                classes: "moon-video-player-slider-container",
                components: [ {
                    name: "slider",
                    kind: "moon.VideoTransportSlider",
                    rtl: !1,
                    disabled: !0,
                    onSeekStart: "sliderSeekStart",
                    onSeek: "sliderSeek",
                    onSeekFinish: "sliderSeekFinish",
                    onEnterTapArea: "onEnterSlider",
                    onLeaveTapArea: "onLeaveSlider",
                    ontap: "playbackControlsTapped"
                } ]
            } ]
        } ]
    }, {
        name: "inlineControl",
        classes: "moon-video-inline-control",
        components: [ {
            name: "currPosAnimator",
            kind: "Animator",
            onStep: "currPosAnimatorStep",
            onEnd: "currPosAnimatorComplete"
        }, {
            name: "bgProgressStatus",
            classes: "moon-video-inline-control-bgprogress"
        }, {
            name: "progressStatus",
            classes: "moon-video-inline-control-progress"
        }, {
            classes: "moon-video-inline-control-text",
            components: [ {
                name: "currTime",
                content: "00:00 / 00:00"
            } ]
        }, {
            name: "ilPlayPause",
            kind: "moon.IconButton",
            ontap: "playPause"
        }, {
            name: "ilFullscreen",
            kind: "moon.VideoFullscreenToggleButton"
        } ]
    } ],
    create: function() {
        this.inherited(arguments), this.srcChanged(), this.createInfoControls(), this.inlineChanged(), 
        this.showInfoChanged(), this.autoShowInfoChanged(), this.autoShowControlsChanged(), 
        this.autoplayChanged(), this.updateMoreButton(), this.showPlaybackControlsChanged(), 
        this.showProgressBarChanged(), this.jumpSecChanged(), this.updatePlaybackControlState(), 
        this.retrieveIconsSrcOrFont(this.$.jumpBack, this.jumpBackIcon, "moon-icon-video-main-control-font-style"), 
        this.retrieveIconsSrcOrFont(this.$.rewind, this.rewindIcon, "moon-icon-video-main-control-font-style"), 
        this.retrieveIconsSrcOrFont(this.$.fastForward, this.fastForwardIcon, "moon-icon-video-main-control-font-style"), 
        this.retrieveIconsSrcOrFont(this.$.jumpForward, this.jumpForwardIcon, "moon-icon-video-main-control-font-style"), 
        this.retrieveIconsSrcOrFont(this.$.ilFullscreen, this.inlineFullscreenIcon, "moon-video-inline-control-fullscreen"), 
        this.$.ilFullscreen.removeClass("moon-icon-video-round-controls-style moon-icon-exitfullscreen-font-style"), 
        window.ilib && (this.durfmt = new ilib.DurFmt({
            length: "medium",
            style: "clock",
            useNative: !1
        }));
    },
    checkIconType: function(t) {
        var e = /\.(jpg|jpeg|png|gif)$/i, i = e.test(t) ? "image" : "iconfont";
        return i;
    },
    transformIconSrc: function(t) {
        var e = Boolean("image" == this.checkIconType(t)) ? this.iconPath + t : t;
        return e;
    },
    disablePlaybackControlsChanged: function() {
        this.updatePlaybackControlState();
    },
    disablePlaybackControlsOnUnloadChanged: function() {
        this.updatePlaybackControlState();
    },
    updatePlaybackControlState: function() {
        var t = this.disablePlaybackControls || this._panelsShowing || this.disablePlaybackControlsOnUnload && (this._errorCode || !this.getSrc());
        this.updateSliderState(), this.$.playbackControls.addRemoveClass("disabled", t), 
        this.$.jumpBack.setDisabled(t), this.$.rewind.setDisabled(t), this.$.fsPlayPause.setDisabled(t), 
        this.$.fastForward.setDisabled(t), this.$.jumpForward.setDisabled(t), this.$.ilPlayPause.setDisabled(t);
        var e = enyo.Spotlight.getCurrent();
        e && e.disabled && (this.isFullscreen() || !this.getInline() ? this.spotFSBottomControls() : enyo.Spotlight.spot(this.$.ilFullscreen));
    },
    playbackControlsTapped: function() {
        this.disablePlaybackControls && this.bubble("onPlaybackControlsTapped");
    },
    rendered: function() {
        this.inherited(arguments), this.aspectRatioChanged();
    },
    showPlaybackControlsChanged: function() {
        this.$.trickPlay.set("showing", this.showPlaybackControls), this.$.moreButton.set("showing", this.showPlaybackControls && this.clientComponentsCount > 2), 
        this.toggleSpotlightForMoreControls(!this.showPlaybackControls), this.$.client.addRemoveClass("moon-video-player-more-controls", this.showPlaybackControls);
    },
    showProgressBarChanged: function() {
        this.$.sliderContainer.setShowing(this.showProgressBar);
    },
    getSrc: function() {
        return this.src;
    },
    srcChanged: function() {
        this._canPlay = !1, this._isPlaying = this.autoplay, this._errorCode = null, this.updatePlayPauseButtons(), 
        this.updateSpinner(), this.updatePlaybackControlState(), this._resetTime(), this.$.video.setSrc(this.getSrc());
    },
    getVideo: function() {
        return this.$.video;
    },
    createInfoControls: function() {
        var t = this.hasOwnProperty("infoComponents") ? this.getInstanceOwner() : this;
        this.$.videoInfoHeaderClient.createComponents(this.infoComponents, {
            owner: t
        });
    },
    createClientComponents: function(t) {
        t = t ? enyo.clone(t) : [], this.clientComponentsCount = t.length, this._buttonsSetup ? this.inherited(arguments) : (this._buttonsSetup = !0, 
        t && 0 !== t.length ? 2 >= t.length ? (this.$.leftPremiumPlaceHolder.createComponent(t.shift(), {
            owner: this.getInstanceOwner()
        }), 1 === t.length && this.$.rightPremiumPlaceHolder.createComponent(t.shift(), {
            owner: this.getInstanceOwner()
        })) : this.$.leftPremiumPlaceHolder.createComponent(t.shift(), {
            owner: this.getInstanceOwner()
        }) : (this.$.leftPremiumPlaceHolder.hide(), this.$.rightPremiumPlaceHolder.hide()), 
        this.createComponents(t, {
            owner: this.getInstanceOwner()
        }));
    },
    playIconChanged: function() {
        this.updatePlayPauseButtons();
    },
    pauseIconChanged: function() {
        this.updatePlayPauseButtons();
    },
    inlinePlayIconChanged: function() {
        this.updatePlayPauseButtons();
    },
    inlinePauseIconChanged: function() {
        this.updatePlayPauseButtons();
    },
    moreControlsIconChanged: function() {
        this.updateMoreButton();
    },
    lessControlsIconChanged: function() {
        this.updateMoreButton();
    },
    autoplayChanged: function() {
        this.$.video.setAutoplay(this.autoplay), this._isPlaying = this.autoplay, this.updatePlayPauseButtons(), 
        this.updateSpinner();
    },
    jumpSecChanged: function() {
        this.$.video.setJumpSec(this.jumpSec);
    },
    disableSliderChanged: function() {
        this.updateSliderState();
    },
    updateSliderState: function() {
        var t = this.disableSlider || this.disablePlaybackControls || !this._loaded || this.disablePlaybackControlsOnUnload && (this._errorCode || !this.getSrc());
        this.$.slider.setDisabled(t);
    },
    autoShowOverlayChanged: function() {
        this.autoShowInfoChanged(), this.autoShowControlsChanged(), this.autoShowOverlay && this.resetAutoTimeout();
    },
    autoShowInfoChanged: function() {
        !this.$.videoInfoHeaderClient.getShowing() || this.autoShowInfo || this.showInfo || this.$.videoInfoHeaderClient.hide(), 
        this.autoShowInfo && this.resetAutoTimeout();
    },
    autoShowControlsChanged: function() {
        this.$.playerControl.getShowing() && !this.autoShowControls && this.$.playerControl.hide(), 
        this.autoShowControls && this.resetAutoTimeout();
    },
    showInfoChanged: function() {
        this.$.videoInfoHeaderClient.setShowing(this.showInfo), this.showInfo && this.$.videoInfoHeaderClient.waterfallDown("onRequestStartMarquee");
    },
    inlineChanged: function() {
        this.addRemoveClass("enyo-fullscreen enyo-fit", !this.inline), this.$.inlineControl.setShowing(this.inline), 
        this.$.fullscreenControl.setShowing(!this.inline), this.inline || (this.$.inlineControl.canGenerate = !1), 
        this.spotlight = !this.inline;
    },
    unload: function() {
        this.$.video.unload(), this._resetTime(), this._loaded = !1, this._isPlaying = !1, 
        this._canPlay = !1, this._errorCode = null, this.src = null, this.updatePlaybackControlState(), 
        this.updateSpinner();
    },
    showScrim: function(t) {
        this.$.fullscreenControl.addRemoveClass("scrim", !t);
    },
    updateSpotability: function() {
        this.updatePlaybackControlState(), this.set("spotlight", !this._panelsShowing), 
        this.$.leftPremiumPlaceHolder.spotlightDisabled = this._panelsShowing, this.$.rightPremiumPlaceHolder.spotlightDisabled = this._panelsShowing;
    },
    panelsShown: function(t, e) {
        this._panelsShowing = !0, this.updateSpotability(), e.initialization || !this.isFullscreen() && this.getInline() || !this.isOverlayShowing() || (this.hideFSControls(), 
        enyo.Spotlight.unspot());
    },
    panelsHidden: function() {
        this._panelsShowing = !1, this.updateSpotability(), enyo.Spotlight.spot(this);
    },
    panelsHandleFocused: function() {
        this._infoShowing = this.$.videoInfoHeaderClient.getShowing(), this._controlsShowing = this.$.playerControl.getShowing(), 
        this.hideFSControls();
    },
    panelsHandleBlurred: function() {
        this.isLarge() && !this.isOverlayShowing() && (this._infoShowing && this.showFSInfo(), 
        this._controlsShowing && this.showFSBottomControls());
    },
    isLarge: function() {
        return this.isFullscreen() || !this.get("inline");
    },
    spotlightUpHandler: function(t, e) {
        return this.isLarge() && !e.spotSentFromContainer ? (e.originator !== this.$.slider && (this.$.videoInfoHeaderClient.getShowing() ? this.hideFSInfo() : this.showFSInfo()), 
        !0) : void 0;
    },
    spotlightDownHandler: function(t, e) {
        return this.isLarge() && !e.spotSentFromContainer ? (this.$.playerControl.getShowing() ? this.hideFSBottomControls() : this.showFSBottomControls(), 
        !0) : void 0;
    },
    spotlightKeyDownHandler: function(t, e) {
        !e.spotSentFromContainer || enyo.Spotlight.getParent(e.originator) !== this && e.originator !== this || (e.spotSentFromContainer = !1);
    },
    _holdPulseThreadhold: 400,
    _holding: !1,
    _sentHold: !1,
    isOverlayShowing: function() {
        return this.$.videoInfoHeaderClient.getShowing() || this.$.playerControl.getShowing();
    },
    mousemove: function() {
        this.isOverlayShowing() ? this.resetAutoTimeout() : this.shakeAndWake && this.showFSControls();
    },
    showFSControls: function() {
        this.showFSInfo(), this.showFSBottomControls();
    },
    hideFSControls: function() {
        this.isOverlayShowing() && (this.hideFSInfo(), this.hideFSBottomControls()), this.stopJob("autoHide");
    },
    showFSBottomControls: function() {
        this.autoShowOverlay && this.autoShowControls && (this.resetAutoTimeout(), this.showScrim(!0), 
        this.$.playerControl.setShowing(!0), this.$.playerControl.resized(), this.showPlaybackControls || this.$.controlsContainer.setIndex(1), 
        this.spotFSBottomControls(), this.$.slider.showKnobStatus(), this.$.video.isPaused() && this.updateFullscreenPosition(), 
        this.set("spotlight", "container"));
    },
    spotFSBottomControls: function() {
        if (this.showPlaybackControls) 0 === this.$.controlsContainer.getIndex() ? enyo.Spotlight.spot(this.$.fsPlayPause) === !1 && enyo.Spotlight.spot(this.$.fastForward) === !1 && enyo.Spotlight.spot(this.$.jumpForward) === !1 && enyo.Spotlight.spot(enyo.Spotlight.getFirstChild(this.$.controls)) : enyo.Spotlight.spot(enyo.Spotlight.getFirstChild(this.$.controlsContainer.getActive())); else {
            var t = enyo.Spotlight.getFirstChild(this.$.leftPremiumPlaceHolder);
            enyo.Spotlight.spot(t);
        }
    },
    hideFSBottomControls: function() {
        this.set("spotlight", !0), enyo.Spotlight.hasCurrent() && enyo.Spotlight.getParent(enyo.Spotlight.getCurrent()) === this && enyo.Spotlight.spot(this), 
        this.autoHidePopups && (this.$.playerControl.waterfall("onRequestHide"), this.$.playerControl.waterfall("onRequestHidePopup")), 
        this.showScrim(!1), this.$.playerControl.setShowing(!1);
    },
    showFSInfo: function() {
        this.autoShowOverlay && this.autoShowInfo && (this.resetAutoTimeout(), this.$.videoInfoHeaderClient.setShowing(!0), 
        this.$.videoInfoHeaderClient.resized(), this.$.videoInfoHeaderClient.waterfallDown("onRequestStartMarquee"));
    },
    hideFSInfo: function() {
        this.showInfo || this.$.videoInfoHeaderClient.setShowing(!1);
    },
    resetAutoTimeout: function() {
        (this.isFullscreen() || !this.getInline()) && this.startJob("autoHide", this.bindSafely("hideFSControls"), this.getAutoCloseTimeout());
    },
    playPause: function(t, e) {
        return this._isPlaying ? this.pause(t, e) : this.play(t, e), !0;
    },
    onHoldPulseBackHandler: function(t, e) {
        if (!this.jumpStartEnd) if (e.holdTime > this._holdPulseThreadhold) {
            if (t._sentHold !== !0) return this.jumpToStart(t, e), t._sentHold = !0, !0;
        } else t._holding = !0, t._sentHold = !1;
    },
    onHoldPulseForwardHandler: function(t, e) {
        if (!this.jumpStartEnd) if (e.holdTime > this._holdPulseThreadhold) {
            if (t._sentHold !== !0) return this.jumpToEnd(t, e), t._sentHold = !0, !0;
        } else t._holding = !0, t._sentHold = !1;
    },
    onEnterSlider: function() {
        this.hideButtonsOnSlider && this.$.controls.setShowing(!1);
    },
    onLeaveSlider: function() {
        this.hideButtonsOnSlider && !this.$.slider.isDragging() && this.$.controls.setShowing(!0);
    },
    onjumpBackward: function(t, e) {
        this.jumpStartEnd ? this.jumpToStart(t, e) : ((!t._holding || t._holding && t._sentHold !== !0) && this.jumpBackward(t, e), 
        t._holding = !1);
    },
    onjumpForward: function(t, e) {
        this.jumpStartEnd ? this.jumpToEnd(t, e) : ((!t._holding || t._holding && t._sentHold !== !0) && this.jumpForward(t, e), 
        t._holding = !1);
    },
    sendFeedback: function(t, e, i, n, o) {
        e = e || {}, this.$.slider.feedback(t, e, i, n, o);
    },
    sliderSeekStart: function() {
        return this._isPausedBeforeDrag = this.$.video.isPaused(), this.pause(), !0;
    },
    sliderSeekFinish: function(t, e) {
        return e.value < this._duration - 1 && (this._isPausedBeforeDrag ? this.pause() : this.play(), 
        this._isPausedBeforeDrag = this.$.video.isPaused()), this.$.slider.isInPreview() || this.$.controls.show(), 
        this.setCurrentTime(e.value), !0;
    },
    sliderSeek: function(t, e) {
        return this.setCurrentTime(e.value), !0;
    },
    updateFullscreenPosition: function() {
        this.$.slider.isDragging() || this.$.slider.setValue(this._currentTime);
    },
    updateInlinePosition: function() {
        var t = this._duration ? Math.round(1e3 * this._currentTime / this._duration) / 10 : 0;
        this.$.progressStatus.applyStyle("width", t + "%"), this.$.currTime.setContent(this.formatTime(this._currentTime) + " / " + this.formatTime(this._duration));
    },
    videoTapped: function() {
        this.getInline() && !this.isFullscreen() && this.playPause();
    },
    toggleFullscreen: function() {
        this.isFullscreen() ? this.cancelFullscreen() : this.requestFullscreen();
    },
    fullscreenChanged: function() {
        enyo.Spotlight.unspot(), this.isFullscreen() ? (this.$.ilFullscreen.undepress(), 
        this.$.ilFullscreen.removeClass("moon-icon-video-round-controls-style moon-icon-exitfullscreen-font-style"), 
        this.spotlight = !0, this.spotlightModal = !0, this.removeClass("inline"), this.$.inlineControl.setShowing(!1), 
        this.$.fullscreenControl.setShowing(!0), this.showFSControls(), this.$.controlsContainer.resized()) : (this.stopJob("autoHide"), 
        this.addClass("inline"), this.$.inlineControl.setShowing(!0), this.$.fullscreenControl.setShowing(!1), 
        enyo.Spotlight.spot(this.$.ilFullscreen), this.spotlight = !1, this.spotlightModal = !1);
    },
    play: function() {
        this.currTimeSync = !0, this._isPlaying = !0, this.$.video.play(), this.updatePlayPauseButtons(), 
        this.updateSpinner();
    },
    pause: function() {
        this._isPlaying = !1, this.$.video.pause(), this.updatePlayPauseButtons(), this.updateSpinner();
    },
    rewind: function() {
        this._isPlaying = !1, this.$.video.rewind(), this.updatePlayPauseButtons(), this.updateSpinner();
    },
    jumpToStart: function() {
        this._isPlaying = !1, this.$.video.jumpToStart(), this.updatePlayPauseButtons(), 
        this.updateSpinner();
    },
    jumpBackward: function() {
        this.$.video.jumpBackward(), this.updatePlayPauseButtons(), this.updateSpinner();
    },
    fastForward: function() {
        this._isPlaying = !1, this.$.video.fastForward(), this.updatePlayPauseButtons(), 
        this.updateSpinner();
    },
    jumpToEnd: function() {
        this._isPlaying = !1, this.$.video.isPaused() && this.$.video.play(), this.$.video.jumpToEnd(), 
        this.updatePlayPauseButtons(), this.updateSpinner();
    },
    jumpForward: function() {
        this.$.video.jumpForward(), this.updatePlayPauseButtons(), this.updateSpinner();
    },
    setCurrentTime: function(t) {
        this.$.video.setCurrentTime(t);
    },
    timeChange: function(t, e) {
        this.setCurrentTime(e.value);
    },
    resizeHandler: function() {
        this.aspectRatioChanged();
    },
    aspectRatioChanged: function() {
        if (this.inline && "none" != this.aspectRatio && this.aspectRatio) {
            var t = null, e = this.getComputedStyleValue("width"), i = this.getComputedStyleValue("height"), n = 1;
            t = this.aspectRatio.split(":"), this.fixedHeight ? (n = t[0] / t[1], this.applyStyle("width", parseInt(i, 10) * n + "px")) : this.fixedHeight || (n = t[1] / t[0], 
            this.applyStyle("height", parseInt(e, 10) * n + "px"));
        }
    },
    updatePosition: function() {
        this.updateFullscreenPosition(), this.updateInlinePosition();
    },
    formatTime: function(t) {
        var e = Math.floor(t / 3600), i = Math.floor(t / 60 % 60), n = Math.floor(t % 60);
        if (this.durfmt) {
            var o = {
                minute: i,
                second: n
            };
            return e && (o.hour = e), this.durfmt.format(o);
        }
        return (e ? this.padDigit(e) + ":" : "") + this.padDigit(i) + ":" + this.padDigit(n);
    },
    padDigit: function(t) {
        return t ? 2 > (t + "").length ? "0" + t : t : "00";
    },
    updatePlayPauseButtons: function() {
        this._isPlaying ? this.retrieveIconsSrcOrFont(this.$.fsPlayPause, this.pauseIcon, "moon-icon-playpause-font-style") : this.retrieveIconsSrcOrFont(this.$.fsPlayPause, this.playIcon, "moon-icon-playpause-font-style"), 
        this._isPlaying ? this.retrieveIconsSrcOrFont(this.$.ilPlayPause, this.inlinePauseIcon, "moon-video-inline-control-play-pause") : this.retrieveIconsSrcOrFont(this.$.ilPlayPause, this.inlinePlayIcon, "moon-video-inline-control-play-pause");
    },
    retrieveIconsSrcOrFont: function(t, e, i) {
        var n = this.bindSafely("transformIconSrc");
        "image" == this.checkIconType(e) && (t.setIcon(""), t.setSrc(n(e)), t !== this.$.ilPlayPause && t.addRemoveClass(i, Boolean("iconfont" == this.checkIconType(e))), 
        t.addRemoveClass("moon-icon-", Boolean("iconfont" == this.checkIconType(e))), t.addRemoveClass('"moon-icon-' + e + '"', Boolean("iconfont" == this.checkIconType(e)))), 
        "iconfont" == this.checkIconType(e) && (t.setSrc(""), t.setIcon(n(e)), t.addRemoveClass(i, Boolean("iconfont" == this.checkIconType(e))), 
        t.applyStyle("background-image", t.src));
    },
    updateSpinner: function() {
        var t = this.$.spinner;
        this.autoShowSpinner && this._isPlaying && !this._canPlay && !this._errorCode ? t.start() : t.getShowing() && t.stop();
    },
    autoShowSpinnerChanged: function() {
        this.updateSpinner();
    },
    moreButtonTapped: function() {
        var t = this.$.controlsContainer.getIndex();
        0 === t ? (this.retrieveIconsSrcOrFont(this.$.moreButton, this.lessControlsIcon, "moon-icon-video-round-controls-style moon-icon-video-more-controls-font-style"), 
        this.toggleSpotlightForMoreControls(!0), this.$.controlsContainer.next()) : (this.retrieveIconsSrcOrFont(this.$.moreButton, this.moreControlsIcon, "moon-icon-video-round-controls-style moon-icon-video-more-controls-font-style"), 
        this.toggleSpotlightForMoreControls(!1), this.$.controlsContainer.previous());
    },
    updateMoreButton: function() {
        var t = this.$.controlsContainer.getIndex();
        0 === t ? this.retrieveIconsSrcOrFont(this.$.moreButton, this.moreControlsIcon, "moon-icon-video-round-controls-style moon-icon-video-more-controls-font-style") : this.retrieveIconsSrcOrFont(this.$.moreButton, this.lessControlsIcon, "moon-icon-video-round-controls-style moon-icon-video-more-controls-font-style");
    },
    toggleSpotlightForMoreControls: function(t) {
        this.$.playbackControls.spotlightDisabled = t, this.$.client.spotlightDisabled = !t;
    },
    timeUpdate: function(t, e) {
        (e || !e.srcElement) && (this._duration = e.duration, this._currentTime = e.currentTime, 
        this.updatePosition(), delete e.delegate, this.waterfall("onTimeupdate", e));
    },
    metadataLoaded: function(t, e) {
        this.autoResize && this.$.video && this.setAspectRatio(this.$.video.getAspectRatio()), 
        this.durationUpdate(t, e);
    },
    durationUpdate: function(t, e) {
        this._duration = this.$.video.getDuration(), this._currentTime = this.$.video.getCurrentTime(), 
        this.$.slider.setMin(0), this.$.slider.setMax(this._duration), this.updatePosition(), 
        this.waterfall("onTimeupdate", e);
    },
    _loaded: !1,
    dataloaded: function(t, e) {
        this._loaded = !0, this.updateSliderState(), this.durationUpdate(t, e);
    },
    _getBufferedProgress: function(t) {
        var e, i = t.buffered, n = i.length, o = 0, s = t.duration || 0, a = 0;
        if (0 === s || isNaN(s)) return {
            value: 0,
            percent: 0
        };
        for (e = 0; n > e; e++) a = i.end(e), o = a > o ? a : o;
        return {
            value: o,
            percent: 100 * (o / s)
        };
    },
    _progress: function(t, e) {
        var i = this._getBufferedProgress(e.srcElement);
        this.isFullscreen() || !this.getInline() ? this.$.slider.setBgProgress(i.value) : this.$.bgProgressStatus.applyStyle("width", i.percent + "%");
    },
    _resetTime: function() {
        this._currentTime = 0, this._duration = 0, this.updatePosition(), this.$.slider.setBgProgress(0), 
        this.$.bgProgressStatus.applyStyle("width", 0);
    },
    _play: function() {
        this.sendFeedback("Play");
    },
    _pause: function(t, e) {
        return 0 > e.srcElement.playbackRate ? void 0 : 0 === e.srcElement.currentTime ? (this.sendFeedback("Stop", {}, !0), 
        void 0) : (this.sendFeedback("Pause", {}, !0), void 0);
    },
    _stop: function() {
        this.pause(), this.updatePlayPauseButtons(), this.updateSpinner(), this.sendFeedback("Stop");
    },
    _fastforward: function(t, e) {
        this.sendFeedback("Fastforward", {
            playbackRate: e.playbackRate
        }, !0);
    },
    _slowforward: function(t, e) {
        this.sendFeedback("Slowforward", {
            playbackRate: e.playbackRate
        }, !0);
    },
    _rewind: function(t, e) {
        this.sendFeedback("Rewind", {
            playbackRate: e.playbackRate
        }, !0);
    },
    _slowrewind: function(t, e) {
        this.sendFeedback("Slowrewind", {
            playbackRate: e.playbackRate
        }, !0);
    },
    _jumpForward: function(t, e) {
        this.sendFeedback("JumpForward", {
            jumpSize: e.jumpSize
        }, !1);
    },
    _jumpBackward: function(t, e) {
        this.sendFeedback("JumpBackward", {
            jumpSize: e.jumpSize
        }, !1);
    },
    _waiting: function() {
        this._canPlay = !1, this.updateSpinner();
    },
    _setCanPlay: function() {
        this._canPlay = !0, this.updateSpinner();
    },
    _error: function(t, e) {
        this._errorCode = e.currentTarget.error.code, this._loaded = !1, this._isPlaying = !1, 
        this._canPlay = !1, this.$.currTime.setContent($L("Error")), this._stop(), this.updateSpinner(), 
        this.updatePlaybackControlState();
    },
    remoteKeyHandler: function(t, e) {
        if (this.handleRemoteControlKey && !this.disablePlaybackControls) {
            var i = !1;
            switch (e.keySymbol) {
              case "play":
                this.play(t, e), i = !0;
                break;

              case "pause":
                this.pause(t, e), i = !0;
                break;

              case "rewind":
                this.showFFRewindControls && (this.rewind(t, e), i = !0);
                break;

              case "fastforward":
                this.showFFRewindControls && (this.fastForward(t, e), i = !0);
                break;

              case "stop":
                this.jumpToStart(), i = !0;
            }
            i && (this.$.playerControl.getShowing() ? this.resetAutoTimeout() : this.showFSBottomControls());
        }
        return !0;
    }
});

// lib\moonstone\source\VideoInfoHeader.js
enyo.kind({
    name: "moon.VideoInfoHeader",
    kind: "enyo.Control",
    classes: "moon-video-info-header",
    mixins: [ "moon.MarqueeSupport" ],
    marqueeOnSpotlight: !1,
    marqueeOnRender: !0,
    published: {
        title: "",
        subTitle: "",
        subSubTitle: "",
        description: "",
        titleUpperCase: !0
    },
    components: [ {
        kind: "moon.MarqueeText",
        name: "title",
        classes: "moon-header-font moon-video-player-info-title"
    }, {
        name: "subTitle",
        classes: "moon-video-player-info-subtitle"
    }, {
        name: "subSubTitle",
        classes: "moon-video-player-info-subsubtitle"
    }, {
        name: "client",
        classes: "moon-video-player-info-client"
    }, {
        components: [ {
            name: "description",
            classes: "moon-video-player-info-description"
        } ]
    } ],
    bindings: [ {
        from: ".subTitle",
        to: ".$.subTitle.content"
    }, {
        from: ".subSubTitle",
        to: ".$.subSubTitle.content"
    }, {
        from: ".description",
        to: ".$.description.content"
    } ],
    create: function() {
        this.inherited(arguments), this.titleChanged();
    },
    titleChanged: function() {
        this.$.title.set("content", this.get("titleUpperCase") ? enyo.toUpperCase(this.get("title")) : this.get("title"));
    },
    titleUpperCaseChanged: function() {
        this.titleChanged();
    }
});

// lib\moonstone\source\VideoTransportSlider.js
enyo.kind({
    name: "moon.VideoTransportSlider",
    kind: "moon.Slider",
    spotlight: !1,
    classes: "moon-video-transport-slider",
    published: {
        rangeStart: 0,
        rangeEnd: 100,
        beginPosition: .0625,
        endPosition: .9375,
        syncTick: !0,
        showDummyArea: !0,
        showTickText: !0,
        showTickBar: !0,
        liveMode: !1,
        bgBarClasses: "moon-video-transport-slider-bg-bar",
        barClasses: "moon-video-transport-slider-bar-bar",
        popupLabelClasses: "moon-video-transport-slider-popup-label",
        knobClasses: "moon-video-transport-slider-knob",
        tapAreaClasses: "moon-video-transport-slider-taparea",
        popupColor: "#fff",
        popupOffset: 25,
        smallVariation: 1,
        popupHeight: 67
    },
    handlers: {
        onTimeupdate: "timeUpdate",
        onresize: "resizeHandler"
    },
    events: {
        onSeekStart: "",
        onSeek: "",
        onSeekFinish: "",
        onEnterTapArea: "",
        onLeaveTapArea: ""
    },
    tickComponents: [ {
        name: "startWrapper",
        classes: "moon-video-transport-slider-indicator-wrapper start",
        components: [ {
            name: "beginTickBar",
            classes: "moon-video-transport-slider-indicator-bar-left"
        }, {
            name: "beginTickText",
            classes: "moon-video-transport-slider-indicator-text",
            content: "00:00"
        } ]
    }, {
        name: "endWrapper",
        classes: "moon-video-transport-slider-indicator-wrapper end",
        components: [ {
            name: "endTickBar",
            classes: "moon-video-transport-slider-indicator-bar-right"
        }, {
            name: "endTickText",
            classes: "moon-video-transport-slider-indicator-text",
            content: "00:00"
        } ]
    } ],
    popupLabelComponents: [ {
        name: "feedback",
        kind: "moon.VideoFeedback"
    }, {
        name: "popupLabelText"
    } ],
    _previewMode: !1,
    create: function() {
        if (this.inherited(arguments), this.$.popup.setAutoDismiss(!1), this.$.popup.captureEvents = !1, 
        this.$.tapArea.onmove = "preview", this.$.tapArea.onenter = "enterTapArea", this.$.tapArea.onleave = "leaveTapArea", 
        this.createTickComponents(), this.createPopupLabelComponents(), this.showTickTextChanged(), 
        this.showTickBarChanged(), window.ilib) {
            this.durfmt = new ilib.DurFmt({
                length: "medium",
                style: "clock",
                useNative: !1
            }), this.$.beginTickText.setContent(this.formatTime(0));
            var t = new ilib.Locale(), e = t.getLanguage(), i = {
                ja: .05,
                pt: .05
            };
            i[e] && (this.set("beginPosition", this.get("beginPosition") + i[e]), this.set("endPosition", this.get("endPosition") - i[e]));
        }
        this.beginPositionChanged(), this.endPositionChanged();
    },
    createTickComponents: function() {
        this.createComponents(this.tickComponents, {
            owner: this,
            addBefore: this.$.tapArea
        });
    },
    createPopupLabelComponents: function() {
        this.$.popupLabel.createComponents(this.popupLabelComponents, {
            owner: this
        }), this.currentTime = 0;
    },
    enterTapArea: function(t, e) {
        this.disabled || (this.addClass("visible"), this.startPreview(), this.doEnterTapArea(e));
    },
    leaveTapArea: function(t, e) {
        this.removeClass("visible"), this.endPreview(), this.doLeaveTapArea(e);
    },
    preview: function(t, e) {
        if (!this.disabled && !this.dragging) {
            var i = this.calcKnobPosition(e);
            this.currentTime = this.transformToVideo(i), this._updateKnobPosition(this.currentTime);
        }
    },
    startPreview: function() {
        this._previewMode = !0, this.$.feedback.setShowing(!1);
    },
    endPreview: function() {
        this._previewMode = !1, this.currentTime = this._currentTime, this._updateKnobPosition(this.currentTime), 
        this.$.feedback.isPersistShowing() && this.$.feedback.setShowing(!0);
    },
    isInPreview: function() {
        return this._previewMode;
    },
    resizeHandler: function() {
        this.inherited(arguments), this.updateSliderRange();
    },
    updateSliderRange: function() {
        this.beginTickPos = (this.max - this.min) * this.get("beginPosition"), this.endTickPos = (this.max - this.min) * this.get("endPosition"), 
        this.showDummyArea ? (this.setRangeStart(this.beginTickPos), this.setRangeEnd(this.endTickPos)) : (this.setRangeStart(this.min), 
        this.setRangeEnd(this.max)), this.updateKnobPosition(this.value);
    },
    setMin: function() {
        this.inherited(arguments), this.updateSliderRange();
    },
    setMax: function() {
        this.inherited(arguments), this.updateSliderRange();
    },
    setRangeStart: function(t) {
        this.rangeStart = this.clampValue(this.getMin(), this.getMax(), t), this.rangeStartChanged();
    },
    setRangeEnd: function(t) {
        this.rangeEnd = this.clampValue(this.getMin(), this.getMax(), t), this.rangeEndChanged();
    },
    beginPositionChanged: function() {
        this.$.startWrapper.applyStyle("width", 200 * this.get("beginPosition") + "%"), 
        this.updateSliderRange();
    },
    endPositionChanged: function() {
        this.$.endWrapper.applyStyle("width", -200 * (this.get("endPosition") - 1) + "%"), 
        this.updateSliderRange();
    },
    showTickTextChanged: function() {
        this.$.beginTickText.setShowing(this.getShowTickText()), this.$.endTickText.setShowing(this.getShowTickText());
    },
    showTickBarChanged: function() {
        this.showDummyArea && (this.showTickBar = !0), this.$.beginTickBar.setShowing(this.getShowTickBar()), 
        this.$.endTickBar.setShowing(this.getShowTickBar());
    },
    rangeStartChanged: function() {
        this.updateInternalProperty();
        var t = this._calcPercent(this.rangeStart), e = "margin-left";
        this.liveMode && (e = "padding-left"), this.$.bar.applyStyle(e, t + "%"), this.$.bgbar.applyStyle(e, t + "%");
    },
    rangeEndChanged: function() {
        this.updateInternalProperty();
    },
    updateInternalProperty: function() {
        this.updateScale(), this.progressChanged(), this.bgProgressChanged();
    },
    updateScale: function() {
        this.scaleFactor = (this.rangeEnd - this.rangeStart) / (this.max - this.min);
    },
    calcPercent: function(t) {
        return 100 * this.calcRatio(t) * this.scaleFactor;
    },
    _calcPercent: function(t) {
        return 100 * this.calcRatio(t);
    },
    calcVariationRatio: function(t) {
        return (t - this.value) / (this.max - this.min);
    },
    calcVariationPercent: function(t) {
        return 100 * this.calcVariationRatio(t);
    },
    updateKnobPosition: function(t) {
        (this.dragging || !this.isInPreview()) && this._updateKnobPosition(t);
    },
    _updateKnobPosition: function(t) {
        var e = this.clampValue(this.min, this.max, t);
        e = this._calcPercent(e);
        var i = this.inverseToSlider(e);
        this.$.knob.applyStyle("left", i + "%"), this.$.popup.addRemoveClass("moon-slider-popup-flip-h", i > 50), 
        this.$.popupLabel.addRemoveClass("moon-slider-popup-flip-h", i > 50), void 0 !== this.currentTime && this.$.popupLabelText.setContent(this.formatTime(this.currentTime));
    },
    inverseToSlider: function(t) {
        var e = this.scaleFactor * t + this._calcPercent(this.rangeStart);
        return e;
    },
    transformToVideo: function(t) {
        return this.showDummyArea && this.beginTickPos > t && (t = this.rangeStart), this.showDummyArea && t > this.endTickPos && (t = this.rangeEnd), 
        (t - this.rangeStart) / this.scaleFactor;
    },
    tap: function(t, e) {
        if (this.tappable && !this.disabled) {
            var i = this.calcKnobPosition(e);
            return i = this.transformToVideo(i), this.sendSeekEvent(i), this.isInPreview() && (this._currentTime = i), 
            !0;
        }
    },
    setValue: function(t) {
        Math.abs(this.calcVariationPercent(t)) > this.smallVariation ? this.inherited(arguments) : this._setValue(t);
    },
    dragstart: function(t, e) {
        if (!this.disabled) {
            if (e.horizontal) {
                var i = this.calcKnobPosition(e);
                if (this.showDummyArea && (this.beginTickPos > i || i > this.endTickPos)) this.dummyAction = !0; else {
                    var n = this.inherited(arguments);
                    n && this.doSeekStart(), this.dummyAction = !1;
                }
                return !0;
            }
            return !0;
        }
    },
    drag: function(t, e) {
        if (this.dragging) {
            var i = this.calcKnobPosition(e);
            if (i = this.transformToVideo(i), this.constrainToBgProgress === !0) {
                i = this.increment ? this.calcConstrainedIncrement(i) : i;
                var n = this.bgProgress + .4 * (i - this.bgProgress);
                i = this.clampValue(this.min, this.bgProgress, i), this.elasticFrom = this.elasticEffect === !1 || this.bgProgress > i ? i : n, 
                this.elasticTo = i;
            } else i = this.increment ? this.calcIncrement(i) : i, i = this.clampValue(this.min, this.max, i), 
            this.elasticFrom = this.elasticTo = i;
            return this.currentTime = i, this.updateKnobPosition(this.elasticFrom), this.lockBar && (this.setProgress(this.elasticFrom), 
            this.sendChangingEvent({
                value: this.elasticFrom
            }), this.sendSeekEvent(this.elasticFrom)), !0;
        }
    },
    dragfinish: function(t, e) {
        if (!this.disabled) {
            if (!this.dummyAction) {
                var i = this.calcKnobPosition(e);
                i = this.transformToVideo(i);
                var n = this.elasticTo;
                this.constrainToBgProgress === !0 ? (n = this.increment ? this.calcConstrainedIncrement(n) : n, 
                this.animateTo(this.elasticFrom, n), i = n) : (i = this.increment ? this.calcIncrement(i) : i, 
                this._setValue(i)), e.preventTap(), this.doSeekFinish({
                    value: i
                });
            }
            return this.$.knob.removeClass("active"), this.dummyAction = !1, this.dragging = !1, 
            !0;
        }
    },
    sendSeekEvent: function(t) {
        this.doSeek({
            value: t
        });
    },
    timeUpdate: function(t) {
        this._currentTime = t._currentTime, (this.dragging || !this.isInPreview()) && (this._duration = t._duration, 
        this.currentTime = this._currentTime, this.duration = this._duration, this.$.endTickText.setContent(this.formatTime(this.duration)));
    },
    formatTime: function(t) {
        var e = Math.floor(t / 3600), i = Math.floor(t / 60 % 60), n = Math.floor(t % 60);
        if (this.durfmt) {
            var o = {
                minute: i,
                second: n
            };
            return e && (o.hour = e), this.durfmt.format(o);
        }
        return (e ? this.padDigit(e) + ":" : "") + this.padDigit(i) + ":" + this.padDigit(n);
    },
    padDigit: function(t) {
        return t ? 2 > (t + "").length ? "0" + t : t : "00";
    },
    feedback: function(t, e, i, n, o) {
        this.showKnobStatus(), this.$.feedback.feedback(t, e, i, n, o, this.isInPreview());
    }
});

// lib\moonstone\source\VideoFeedback.js
enyo.kind({
    name: "moon.VideoFeedback",
    kind: "enyo.Control",
    classes: "moon-video-player-feedback",
    published: {
        autoTimeoutMS: 2e3
    },
    _showingFeedback: !1,
    _imagePath: "$lib/moonstone/images/video-player/",
    _jumpBackImg: "jumpbackward",
    _rewindImg: "backward",
    _playImg: "play",
    _pauseImg: "pause",
    _fastForwardImg: "forward",
    _jumpForwardImg: "jumpforward",
    _pauseBackImg: "pausebackward",
    _pauseForwardImg: "pauseforward",
    _pauseJumpBackImg: "pausejumpbackward",
    _pauseJumpForwardImg: "pausejumpforward",
    _autoTimer: null,
    components: [ {
        name: "leftIcon",
        kind: "moon.Icon",
        classes: "moon-video-feedback-icon-left",
        allowHtml: !0,
        showing: !1
    }, {
        name: "feedText",
        classes: "moon-video-feedback-text",
        allowHtml: !0,
        showing: !1
    }, {
        name: "rightIcon",
        kind: "moon.Icon",
        classes: "moon-video-feedback-icon-right",
        allowHtml: !0,
        showing: !1
    } ],
    create: function() {
        this.inherited(arguments), window.ilib && (this.df = new ilib.DurFmt({
            length: "medium",
            useNative: !1
        }));
    },
    checkIconType: function(t) {
        var e = /\.(jpg|jpeg|png|gif)$/i;
        return e.test(t) ? "image" : "iconfont";
    },
    retriveImgOrIconPath: function(t) {
        return "image" == this.checkIconType(t) ? enyo.path.rewrite(this._imagePath + t) : enyo.path.rewrite(t);
    },
    feedback: function(t, e, i, n, o, s) {
        var a = !1;
        switch (t = t || "", e = e || {}, "" !== t && this.$.feedText.show(), t) {
          case "Play":
            t = moon.$L("PLAY"), o = this.retriveImgOrIconPath(this._playImg);
            break;

          case "Pause":
            t = moon.$L("PAUSE"), o = this.retriveImgOrIconPath(this._pauseImg);
            break;

          case "Rewind":
            t = Math.abs(e.playbackRate) + "x", n = this.retriveImgOrIconPath(this._rewindImg);
            break;

          case "Slowrewind":
            t = e.playbackRate + "x", n = this.retriveImgOrIconPath(this._pauseBackImg);
            break;

          case "Fastforward":
            t = Math.abs(e.playbackRate) + "x", o = this.retriveImgOrIconPath(this._fastForwardImg);
            break;

          case "Slowforward":
            t = e.playbackRate + "x", o = this.retriveImgOrIconPath(this._pauseForwardImg);
            break;

          case "JumpBackward":
            t = this.df ? enyo.toUpperCase(this.df.format({
                second: e.jumpSize
            })) : e.jumpSize + " SEC", n = this.retriveImgOrIconPath(this._pauseJumpBackImg);
            break;

          case "JumpForward":
            t = this.df ? enyo.toUpperCase(this.df.format({
                second: e.jumpSize
            })) : e.jumpSize + " SEC", o = this.retriveImgOrIconPath(this._pauseJumpForwardImg);
            break;

          case "JumpToStart":
            t = "", n = this.retriveImgOrIconPath(this._pauseJumpBackImg);
            break;

          case "JumpToEnd":
            t = "", o = this.retriveImgOrIconPath(this._pauseJumpForwardImg);
            break;

          case "Stop":
            t = moon.$L("STOP"), o = "";
            break;

          default:
            a = !0, this._showingFeedback = !0;
        }
        (a || !this._showingFeedback) && (this.$.feedText.setContent(enyo.toUpperCase(t)), 
        s || this.showFeedback(), this.updateIcons(n, o), i ? this.resetAutoTimer() : this.setAutoTimer(), 
        this.inPersistShowing = i);
    },
    isPersistShowing: function() {
        return this.inPersistShowing;
    },
    showFeedback: function() {
        this.setShowing(!0);
    },
    hideFeedback: function() {
        this.setShowing(!1), this._showingFeedback = !1;
    },
    setAutoTimer: function() {
        this.hideJob = enyo.job(this.id + "hide", this.bindSafely("hideFeedback"), this.getAutoTimeoutMS());
    },
    resetAutoTimer: function() {
        enyo.job.stop(this.id + "hide");
    },
    updateIcons: function(t, e) {
        t ? (this.$.leftIcon.show(), this.displayIconSrcOrFont(this.$.leftIcon, t)) : this.$.leftIcon.hide(), 
        e ? (this.$.rightIcon.show(), this.displayIconSrcOrFont(this.$.rightIcon, e)) : this.$.rightIcon.hide();
    },
    displayIconSrcOrFont: function(t, e) {
        "image" == this.checkIconType(e) ? (t.set("icon", ""), t.set("src", e)) : (t.set("src", ""), 
        t.set("icon", e));
    }
});

// lib\moonstone\source\VideoFullscreenToggleButton.js
enyo.kind({
    name: "moon.VideoFullscreenToggleButton",
    kind: "moon.IconButton",
    icon: "exitfullscreen",
    classes: "moon-icon-video-round-controls-style moon-icon-exitfullscreen-font-style",
    events: {
        onRequestToggleFullscreen: ""
    },
    handlers: {
        ontap: "doRequestToggleFullscreen"
    }
});

// lib\moonstone\source\ChannelInfo.js
enyo.kind({
    name: "moon.ChannelInfo",
    kind: "enyo.Control",
    classes: "moon-channelinfo",
    mixins: [ "moon.MarqueeSupport" ],
    marqueeOnSpotlight: !1,
    marqueeOnHover: !0,
    published: {
        channelNo: "",
        channelName: "",
        channelNoUpperCase: !0
    },
    defaultKind: "moon.ChannelInfoBadge",
    components: [ {
        kind: "moon.MarqueeText",
        name: "channelNo",
        classes: "moon-header-font moon-video-player-channel-info-no"
    }, {
        kind: "moon.MarqueeText",
        name: "channelName",
        classes: "moon-video-player-channel-info-name"
    }, {
        kind: "enyo.Control",
        name: "client",
        classes: "moon-video-player-channel-info-badges"
    } ],
    bindings: [ {
        from: ".channelName",
        to: ".$.channelName.content"
    } ],
    create: function() {
        this.inherited(arguments), this.channelNoChanged();
    },
    channelNoChanged: function() {
        var t = this.getChannelNo();
        this.$.channelNo.setContent(this.getChannelNoUpperCase() ? enyo.toUpperCase(t) : t);
    },
    channelNoUpperCaseChanged: function() {
        this.channelNoChanged();
    }
}), enyo.kind({
    name: "moon.ChannelInfoBadge",
    kind: "enyo.Control",
    classes: "moon-video-badge-text moon-video-player-info-icon"
});

// lib\moonstone\source\Clock.js
enyo.kind({
    name: "moon.Clock",
    kind: "enyo.Control",
    classes: "moon-clock moon-header-font",
    published: {
        refresh: 1e3,
        date: void 0,
        locale: ""
    },
    observers: {
        modeChanged: [ "mode" ]
    },
    components: [ {
        kind: "enyo.Control",
        name: "hour",
        classes: "moon-header-text moon-clock-hour"
    }, {
        name: "right",
        classes: "moon-clock-right",
        components: [ {
            kind: "enyo.Control",
            name: "top",
            classes: "moon-header-font moon-clock-top"
        }, {
            name: "meridiem",
            classes: "moon-bold-text moon-clock-meridiem"
        }, {
            name: "divider",
            classes: "moon-clock-divider"
        }, {
            kind: "enyo.Control",
            name: "bottom",
            classes: "moon-body-text moon-clock-bottom"
        } ]
    }, {
        kind: "enyo.Signals",
        onlocalechange: "handleLocaleChangeEvent"
    } ],
    months: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
    _timeDiff: 0,
    ilibLocaleInfo: null,
    mode: "normal",
    create: function() {
        this.inherited(arguments), this.initDefaults(), this.refreshJob();
    },
    initILib: function() {
        this.ilibLocaleInfo = new ilib.LocaleInfo(this.locale || void 0);
        var t, e, i = this.ilibLocaleInfo.getClock(), n = "locale" !== i ? i : void 0;
        "en-US" === this.ilibLocaleInfo.locale.spec ? (t = "long", e = "m", this.$.right.addRemoveClass("mini", !1), 
        this.$.hour.show(), this.$.meridiem.show()) : (t = "full", e = "hma", this.$.right.addRemoveClass("mini", !0), 
        this.$.hour.hide(), this.$.meridiem.hide());
        var o = {
            locale: this.locale,
            type: "time",
            time: "h",
            clock: n,
            timezone: "normal" === this.mode ? "local" : "Etc/UTC"
        }, s = {
            locale: this.locale,
            type: "time",
            time: e,
            clock: n,
            timezone: "normal" === this.mode ? "local" : "Etc/UTC"
        }, a = {
            locale: this.locale,
            type: "date",
            date: "md",
            length: t,
            timezone: "normal" === this.mode ? "local" : "Etc/UTC"
        };
        this._hf = new ilib.DateFmt(o), this._mf = new ilib.DateFmt(s), this._mdf = new ilib.DateFmt(a);
    },
    initDefaults: function() {
        "undefined" != typeof ilib && this.initILib();
    },
    refreshChanged: function() {
        this.startJob("refresh", this.bindSafely("refreshJob"), this.getRefresh());
    },
    dateChanged: function() {
        !this.date || this.date instanceof Date ? this.date && this.date instanceof Date ? (this.set("mode", "normal"), 
        this._timeDiff = this.date.getTime() - Date.now() || 0) : (this.set("mode", "normal"), 
        this._timeDiff = 0) : this.set("mode", "static"), this.refreshJob();
    },
    refreshJob: function() {
        this.updateDate(), "normal" === this.mode && this.startJob("refresh", this.bindSafely("refreshJob"), this.getRefresh());
    },
    _formatNumber: function(t) {
        return t ? 2 > (t + "").length ? "0" + t : t : "00";
    },
    localeChanged: function() {
        this._refresh(), this.updateDate();
    },
    modeChanged: function() {
        this._refresh();
    },
    _refresh: function() {
        this._hf && delete this._hf, this._mf && delete this._mf, this._mdf && delete this._mdf, 
        this.initDefaults();
    },
    parseStaticDate: function(t) {
        return {
            year: void 0 !== t.year ? t.year : 0,
            month: void 0 !== t.month ? t.month : 1,
            day: void 0 !== t.day ? t.day : 0,
            hour: void 0 !== t.hour ? t.hour : 0,
            minute: void 0 !== t.min ? t.min : 0,
            second: void 0 !== t.sec ? t.sec : 0,
            timezone: "Etc/UTC"
        };
    },
    updateDate: function() {
        var t, e;
        "normal" === this.mode ? (t = new Date(Date.now() + this._timeDiff), e = t.getHours()) : (t = this.date, 
        e = this.date.hour ? this.date.hour : 0), this.updateHour(t, e), this.updateMinute(t, e), 
        this.updateMonthDay(t);
    },
    updateHour: function(t, e) {
        e = (e > 12 ? e - 12 : e) || 12;
        var i = this._hf ? this._hf.format("normal" === this.mode ? ilib.Date.newInstance({
            unixtime: t.getTime(),
            timezone: "Etc/UTC"
        }) : ilib.Date.newInstance(this.parseStaticDate(t))) : e;
        this.$.hour.setContent(i);
    },
    updateMinute: function(t, e) {
        var i = this._mf ? this._mf.format("normal" === this.mode ? ilib.Date.newInstance({
            unixtime: t.getTime(),
            timezone: "Etc/UTC"
        }) : ilib.Date.newInstance(this.parseStaticDate(t))) : "normal" === this.mode ? this._formatNumber(t.getMinutes()) : this._formatNumber(t.min), n = "";
        this.ilibLocaleInfo && "en-US" !== this.ilibLocaleInfo.locale.spec || (n = e > 11 ? "pm" : "am"), 
        this.$.top.setContent(i), this.$.meridiem.setContent(n);
    },
    updateMonthDay: function(t) {
        var e = this._mdf ? this._mdf.format("normal" === this.mode ? ilib.Date.newInstance({
            unixtime: t.getTime(),
            timezone: "Etc/UTC"
        }) : ilib.Date.newInstance(this.parseStaticDate(t))) : "normal" === this.mode ? this.months[t.getMonth()] + " " + this._formatNumber(t.getUTCDate()) : (void 0 !== t.month ? this.months[t.month - 1] : 0) + " " + this._formatNumber(t.day);
        this.$.bottom.setContent(e);
    },
    handleLocaleChangeEvent: function() {
        this._refresh(), this.updateDate();
    }
});

// lib\moonstone\source\VideoInfoBackground.js
enyo.kind({
    name: "moon.VideoInfoBackground",
    kind: "enyo.Control",
    classes: "moon-background-wrapper",
    published: {
        orient: "left",
        background: !0
    },
    components: [ {
        name: "client",
        classes: "moon-background-wrapper-client-content"
    } ],
    initComponents: function() {
        this.inherited(arguments), this.orientChanged(), this.backgroundChanged();
    },
    orientChanged: function() {
        this.$.client.addRemoveClass("right", "left" != this.orient), this.$.client.addRemoveClass("left", "left" == this.orient);
    },
    backgroundChanged: function() {
        this.$.client.addRemoveClass("bg", this.background);
    }
});

// lib\moonstone\source\DrawerHandle.js
enyo.kind({
    name: "moon.DrawerHandle",
    kind: "moon.Item",
    classes: "moon-drawer-handle"
});

// lib\moonstone\source\Drawer.js
enyo.kind({
    name: "moon.Drawer",
    kind: "enyo.Control",
    classes: "moon-drawer moon-neutral",
    published: {
        controlDrawerComponents: null,
        handle: null,
        open: !1,
        controlsOpen: !1
    },
    events: {
        onActivate: "",
        onDeactivate: ""
    },
    handlers: {
        onDrawersRendered: "drawersRendered",
        onDrawersResized: "drawersResized"
    },
    components: [ {
        name: "client",
        kind: "moon.FullScreenDrawer",
        spotlightDisabled: !0,
        resizeContainer: !1
    }, {
        name: "controlDrawer",
        kind: "enyo.Drawer",
        spotlightDisabled: !0,
        resizeContainer: !1
    } ],
    create: function() {
        this.inherited(arguments), this.$.controlDrawer.createComponents(this.controlDrawerComponents, {
            owner: this.owner
        }), this.$.client.$.client.addClass("moon-drawer-client"), this.$.controlDrawer.$.client.addClass("moon-drawer-partial-client");
    },
    drawersRendered: function(t, e) {
        this.$.client.setDrawerProps({
            height: this.calcDrawerHeight(e.drawersHeight)
        }), this.openChanged(), this.controlsOpen ? this.controlsOpenChanged() : (this.$.controlDrawer.setAnimated(!1), 
        this.$.controlDrawer.setOpen(this.controlsOpen), this.$.controlDrawer.setAnimated(!0));
    },
    calcDrawerHeight: function(t) {
        var e = t;
        return null == this.controlDrawerComponents ? e : (this.controlDrawerHeight = this.controlDrawerHeight ? this.controlDrawerHeight : this.$.controlDrawer.hasNode().getBoundingClientRect().height, 
        e - this.controlDrawerHeight);
    },
    toggleDrawer: function() {
        return null == this.controlDrawerComponents ? this.setOpen(!this.open) : this.setControlsOpen(!this.controlsOpen), 
        !0;
    },
    openChanged: function() {
        this.$.client.setOpen(this.open), this.open ? (this.doActivate(), this.$.client.spotlightDisabled = !1, 
        enyo.Spotlight.spot(this.$.client)) : (this.$.client.spotlightDisabled = !0, this.doDeactivate());
    },
    controlsOpenChanged: function() {
        this.$.controlDrawer.setOpen(this.controlsOpen), this.controlsOpen ? (this.doActivate(), 
        this.$.controlDrawer.spotlightDisabled = !1, enyo.Spotlight.spot(this.$.controlDrawer)) : (this.$.client.getOpen() && this.$.client.setOpen(!1), 
        this.$.controlDrawer.spotlightDisabled = !0, this.doDeactivate());
    },
    drawersResized: function(t, e) {
        this.$.client.setDrawerProps({
            height: this.calcDrawerHeight(e.drawersHeight)
        }), this.setOpen(!1), this.setControlsOpen(!1);
    }
}), enyo.kind({
    name: "moon.FullScreenDrawer",
    kind: "enyo.Drawer",
    handlers: {
        onResizeDrawer: "resizeDrawer"
    },
    open: !1,
    published: {
        drawerProps: null
    },
    initComponents: function() {
        this.inherited(arguments), this.$.client.setShowing(!0);
    },
    openChanged: function() {
        if (this.$.client.show(), this.hasNode()) if (this.$.animator.isAnimating()) this.$.animator.reverse(); else {
            var t = "v" == this.orient, e = t ? "height" : "width", i = t ? "top" : "left", n = this.drawerProps.height;
            this.applyStyle(e, null), this.animated ? this.$.animator.play({
                startValue: this.open ? 0 : n,
                endValue: this.open ? n : 0,
                dimension: e,
                position: i
            }) : this.animatorEnd();
        }
    },
    animatorEnd: function() {
        this.open || this.$.client.hide(), this.container && this.container.resized();
    },
    resizeDrawer: function(t, e) {
        return this.drawerProps = e, this.open && !this.$.animator.isAnimating() && this.applyStyle("height", e.height + "px"), 
        !0;
    },
    drawerPropsChanged: function() {
        this.$.client.applyStyle("height", this.drawerProps.height + "px"), this.$.client.resized(), 
        this.$.client.setShowing(this.open);
    }
});

// lib\moonstone\source\Drawers.js
enyo.kind({
    name: "moon.Drawers",
    kind: "enyo.Control",
    classes: "moon-drawers enyo-fit",
    published: {
        drawers: null
    },
    handlers: {
        onActivate: "drawerActivated",
        onDeactivate: "drawerDeactivated",
        onSpotlightDown: "spotDown",
        onSpotlightUp: "spotUp"
    },
    components: [ {
        name: "activatorWrapper",
        classes: "moon-drawers-activator-wrapper",
        spotlight: !0,
        ontap: "activatorHandler",
        components: [ {
            name: "activator",
            classes: "moon-drawers-activator"
        } ]
    }, {
        name: "handleContainer",
        classes: "moon-drawers-handle-container",
        kind: "enyo.Drawer",
        resizeContainer: !1,
        open: !1,
        spotlightDisabled: !0,
        onpostresize: "resizeHandleContainer",
        components: [ {
            name: "handles",
            classes: "moon-neutral moon-drawers-handles"
        } ]
    }, {
        name: "drawers",
        classes: "moon-drawers-drawer-container"
    }, {
        name: "client",
        classes: "moon-drawers-client"
    } ],
    eventsToCapture: {
        ontap: "captureTapSelect",
        onSpotlightFocus: "captureSpotFocus",
        onSpotlightSelect: "captureTapSelect"
    },
    create: function() {
        this.inherited(arguments), this.$.drawers.createComponents(this.drawers, {
            kind: "moon.Drawer",
            owner: this.owner
        }), this.setupHandles();
    },
    rendered: function() {
        this.inherited(arguments);
        var t = document.body.getBoundingClientRect().height;
        this.waterfall("onDrawersRendered", {
            drawersHeight: t
        });
    },
    setupHandles: function() {
        var t, e, i = [];
        for (e = 0; this.drawers.length > e; ++e) i.push(this.drawers[e].handle || {});
        this.$.handles.createComponents(i, {
            kind: "moon.DrawerHandle",
            owner: this
        }), t = this.$.handles.getControls(), enyo.forEach(i, function(e, i) {
            t[i].addClass("moon-drawers-handle"), t[i].tap = this.bindSafely(this.handleTapped);
        }, this);
    },
    activatorHandler: function() {
        this.drawerOpen() ? this.closeDrawers() : 1 == this.$.handles.getControls().length ? this.openDrawer(this.$.handles.getControls()[0]) : this.$.handleContainer.getOpen() ? this.closeHandleContainer() : this.openHandleContainer();
    },
    openHandleContainer: function() {
        this.$.handleContainer.spotlightDisabled = !1, this.$.handleContainer.setOpen(!0), 
        enyo.Spotlight.spot(this.$.handleContainer), this.updateActivator(!0), enyo.dispatcher.capture(this.$.handleContainer, this.eventsToCapture, this);
    },
    closeHandleContainer: function() {
        enyo.dispatcher.release(this.$.handleContainer), this.$.handleContainer.spotlightDisabled = !0, 
        this.$.handleContainer.setOpen(!1), this.updateActivator(!1);
    },
    handleTapped: function(t, e) {
        return this.openDrawer(e.originator), !0;
    },
    openDrawer: function(t) {
        for (var e = this.$.handles.getControls(), i = 0; e.length > i; ++i) if (e[i] == t || enyo.Spotlight.Util.isChild(e[i], t)) return t = this.$.drawers.getControls()[i], 
        t.toggleDrawer(), this.closeHandleContainer(), enyo.dispatcher.capture(t, this.eventsToCapture, this), 
        void 0;
    },
    drawerOpen: function() {
        for (var t = this.$.drawers.getControls(), e = 0; t.length > e; ++e) if (t[e].getOpen() || t[e].getControlsOpen()) return !0;
        return !1;
    },
    closeDrawers: function() {
        for (var t = this.$.drawers.getControls(), e = 0; t.length > e; ++e) {
            var i = t[e];
            (i.getOpen() || i.getControlsOpen()) && (enyo.dispatcher.release(i), i.setOpen(!1), 
            i.setControlsOpen(!1));
        }
        this.updateActivator(!1);
    },
    captureSpotFocus: function(t, e) {
        e.dir && e.dispatchTarget.isDescendantOf(this.$.client) && (this.closeDrawers(), 
        this.closeHandleContainer());
    },
    captureTapSelect: function(t, e) {
        e.dispatchTarget.isDescendantOf(this.$.client) && (this.closeDrawers(), this.closeHandleContainer());
    },
    drawerActivated: function(t, e) {
        e.originator instanceof moon.Drawer && (this.updateActivator(!0), e.originator.getOpen() && this.$.client.hide());
    },
    drawerDeactivated: function(t, e) {
        e.originator instanceof moon.Drawer && (e.originator.getOpen() || e.originator.getControlsOpen() || this.updateActivator(!1), 
        e.originator.getOpen() || this.$.client.show());
    },
    updateActivator: function(t) {
        this.$.activator.addRemoveClass("open", t);
    },
    resizeHandler: function() {
        this.inherited(arguments);
        var t = document.body.getBoundingClientRect().height;
        this.waterfall("onDrawersResized", {
            drawersHeight: t
        }), this.updateActivator(!1);
    },
    resizeHandleContainer: function(t, e) {
        enyo.asyncMethod(e.delegate.bindSafely(function() {
            this.$.animator.isAnimating() || this.parent.$.activator.addRemoveClass("drawer-open", this.parent.drawerOpen() ? !0 : !1);
        }));
    },
    handleAtIndex: function(t) {
        return this.$.handles.getControls()[t];
    },
    destroy: function() {
        enyo.dispatcher.release(this.$.handleContainer);
        for (var t = 0, e = this.$.drawers.getControls(); e.length > t; t++) enyo.dispatcher.release(e[t]);
        this.inherited(arguments);
    }
});

// lib\moonstone\source\HighlightText.js


// lib\moonstone\source\ObjectActionDecorator.js
enyo.kind({
    name: "moon.ObjectActionDecorator",
    classes: "moon-objaction",
    handlers: {
        onSpotlightFocused: "spotFocused",
        onSpotlightBlur: "spotBlur",
        onenter: "enter",
        onleave: "leave"
    },
    published: {
        orientation: "vertical",
        noStretch: !1
    },
    components: [ {
        name: "client",
        classes: "moon-objaction-client"
    }, {
        name: "actions",
        classes: "moon-objaction-actions"
    } ],
    orientationChanged: function() {
        var t = "vertical" == this.getOrientation();
        this.addRemoveClass("vertical", t), this.addRemoveClass("horizontal", !t), this.$.actions.addRemoveClass("moon-vspacing", t), 
        this.$.actions.addRemoveClass("moon-hspacing", !t);
    },
    noStretchChanged: function() {
        this.$.actions.addRemoveClass("stretch", !this.noStretch);
    },
    initComponents: function() {
        if (this.inherited(arguments), this.actionComponents) {
            var t = this.hasOwnProperty("actionComponents") ? this.getInstanceOwner() : this;
            this.$.actions.createComponents(this.actionComponents, {
                owner: t
            });
        }
        this.orientationChanged(), this.noStretchChanged();
    },
    spotFocused: function() {
        this.focused = !0, this.updateActionsVisibility();
    },
    spotBlur: function() {
        this.focused = !1, this.entered = !1, this.updateActionsVisibility();
    },
    enter: function() {
        this.entered = !0, this.updateActionsVisibility();
    },
    leave: function() {
        this.entered = !1, this.updateActionsVisibility();
    },
    updateActionsVisibility: function() {
        this.$.actions.applyStyle("opacity", this.focused || this.entered ? 1 : 0);
    }
});

// lib\moonstone\source\FormCheckbox.js
enyo.kind({
    name: "moon.FormCheckbox",
    kind: "moon.CheckboxItem",
    classes: "moon-formcheckbox-item"
});

// lib\moonstone\source\DataGridList.js
enyo.kind({
    name: "moon.DataGridList",
    kind: "enyo.DataGridList",
    mixins: [ "moon.DataListSpotlightSupport" ],
    noDefer: !0,
    allowTransitions: !1,
    spotlight: !0,
    scrollerOptions: {
        kind: "moon.Scroller",
        vertical: "scroll",
        horizontal: "hidden"
    },
    handlers: {
        onSpotlightFocus: "handleSpotlightFocus",
        onSpotlightBlur: "handleSpotlightBlur",
        onSpotlightFocused: "handleSpotlightFocused"
    },
    handleSpotlightFocus: function(t, e) {
        var i = parseInt(enyo.dom.getComputedStyleValue(e.originator.hasNode(), "z-index"), 10) || 0;
        e.originator.applyStyle("z-index", i + 1);
    },
    handleSpotlightBlur: function(t, e) {
        setTimeout(this.bindSafely(function() {
            e.originator.applyStyle("z-index", null);
        }), 0);
    },
    handleSpotlightFocused: function(t, e) {
        enyo.Spotlight.getPointerMode() || (e.index < this.indexBoundFirstRow ? this.$.scroller.scrollToTop() : e.index > this.indexBoundLastRow && this.$.scroller.scrollToBottom());
    }
}), function(t, e) {
    var i = e.DataGridList.delegates.verticalGrid = t.clone(t.DataGridList.delegates.verticalGrid);
    t.kind.extendMethods(i, {
        refresh: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments), e.$.scroller.resized();
            };
        }),
        scrollToIndex: function(t, e) {
            if (!(0 > e || e >= t.collection.length)) {
                var i = this.childForIndex(t, e), n = this.pageForIndex(t, e);
                if (!(0 > n || n > this.pageCount(t))) if (i) t.$.scroller.scrollToControl(i, !1, !1); else {
                    var o = t.$.page1.index;
                    n > o ? (t.$.page1.index = n - 1, t.$.page2.index = n) : (t.$.page1.index = n, t.$.page2.index = n + 1), 
                    t.refresh(), this.scrollToIndex(t, e);
                }
            }
        },
        reset: t.inherit(function(t) {
            return function(e) {
                t.apply(this, arguments), this.updateMetrics(e), e.refresh(), e.$.scroller.scrollTo(0, 0, !1);
            };
        }),
        updateBounds: t.inherit(function(e) {
            return function(i) {
                e.apply(this, arguments);
                var n = i.boundsCache.width, o = i.$.scroller.getScrollBounds(), s = i.$.scroller.$.strategy.$.vColumn, a = i.$.scroller.$.strategy.$.clientContainer;
                if (s && ("scroll" == i.$.scroller.getVertical() || o.height > o.clientHeight)) {
                    var r = t.dom.getComputedStyle(a.hasNode());
                    i.boundsCache.width = n - (parseInt(r["padding-right"], 10) + parseInt(r["padding-left"], 10));
                }
            };
        })
    }, !0);
}(enyo, moon);

// lib\moonstone\source\SelectionOverlaySupport.js
moon.SelectionOverlaySupport = {
    name: "moon.SelectionOverlaySupport",
    classes: "moon-selection-overlay-support",
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.createChrome(this._selectionScrim), this.selectionOverlayHorizontalOffset = void 0 === this.selectionOverlayHorizontalOffset ? 50 : this.selectionOverlayHorizontalOffset, 
            this.selectionOverlayVerticalOffset = void 0 === this.selectionOverlayVerticalOffset ? 50 : this.selectionOverlayVerticalOffset, 
            this.selectionOverlayHorizontalOffsetChanged(), this.selectionOverlayVerticalOffsetChanged(), 
            this.selectionScrimIcon = this.selectionScrimIcon || "$lib/moonstone/images/icon-selection.png";
        };
    }),
    bindings: [ {
        from: ".selectionScrimIcon",
        to: ".$.selectionScrimIcon.src"
    } ],
    _selectionScrim: [ {
        classes: "enyo-fit moon-selection-overlay-support-scrim",
        components: [ {
            name: "selectionScrimIcon",
            kind: "moon.IconButton",
            classes: "moon-selection-overlay-support-checkbox",
            spotlight: !1
        } ]
    } ],
    selectionOverlayVerticalOffsetChanged: function() {
        this.$.selectionScrimIcon.applyStyle("top", this.selectionOverlayVerticalOffset + "%");
    },
    selectionOverlayHorizontalOffsetChanged: function() {
        this.$.selectionScrimIcon.applyStyle(this.rtl ? "right" : "left", this.selectionOverlayHorizontalOffset + "%");
    }
};

// lib\moonstone\source\Image.js
enyo.kind({
    name: "moon.Image",
    kind: "enyo.Control",
    classes: "moon-image",
    published: {
        src: "",
        alt: "",
        showBadgesOnSpotlight: !1,
        sizing: "",
        position: ""
    },
    defaultKind: "moon.ImageBadge",
    components: [ {
        name: "image",
        kind: "enyo.Image"
    }, {
        name: "client",
        kind: "enyo.Control",
        canGenerate: !1,
        classes: "moon-image-client"
    } ],
    bindings: [ {
        from: ".src",
        to: ".$.image.src"
    }, {
        from: ".alt",
        to: ".$.image.alt"
    }, {
        from: ".sizing",
        to: ".$.image.sizing"
    }, {
        from: ".position",
        to: ".$.image.position"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.getClientControls().length > 0 && (this.$.client.canGenerate = !0, 
            this.addClass("has-children")), this.showBadgesOnSpotlightChanged();
        };
    }),
    showBadgesOnSpotlightChanged: function() {
        this.addRemoveClass("show-on-spotlight", this.getShowBadgesOnSpotlight());
    }
});

// lib\moonstone\source\ImageBadge.js
enyo.kind({
    name: "moon.ImageBadge",
    kind: "moon.Icon",
    classes: "moon-image-badge"
});

// lib\moonstone\source\ExpandableText.js
enyo.kind({
    name: "moon.ExpandableText",
    classes: "moon-expandable-text",
    published: {
        collapsed: !0,
        maxLines: 3,
        moreContent: moon.$L("more"),
        lessContent: moon.$L("less")
    },
    events: {
        onExpandCollapse: ""
    },
    components: [ {
        name: "client",
        classes: "moon-body-text moon-expandable-text-content"
    }, {
        name: "button",
        kind: "moon.ExpandableTextButton",
        ontap: "expandContract"
    } ],
    lineHeight: 32,
    maxHeight: 96,
    contentHeight: -1,
    canCollapse: !0,
    create: function() {
        this.inherited(arguments), this.moreContentChanged(), this.lessContentChanged(), 
        this.collapsedChanged();
    },
    rendered: function() {
        this.inherited(arguments), this.calcLineHeight();
    },
    resizeHandler: function() {
        this.reflow();
    },
    reflow: function() {
        this.calcContentHeight();
    },
    expandContract: function() {
        this.set("collapsed", !this.collapsed);
    },
    contentChanged: function() {
        this.$.client.setContent(this.content), this.hasNode() && this.reflow();
    },
    moreContentChanged: function() {
        this.$.button.setMoreContent(this.moreContent);
    },
    lessContentChanged: function() {
        this.$.button.setLessContent(this.lessContent);
    },
    lineHeightChanged: function() {
        this.calcMaxHeight();
    },
    maxLinesChanged: function() {
        this.calcMaxHeight();
    },
    collapsedChanged: function() {
        this.addRemoveLineClamp(this.collapsed), this.$.button.setCollapsed(this.collapsed), 
        this.hasNode() && this.doExpandCollapse({
            collapsed: this.collapsed
        }), this.bubble("onRequestScrollIntoView", {
            scrollInPointerMode: !0
        });
    },
    maxHeightChanged: function() {
        this.calcCanCollapse(), this.addRemoveLineClamp(this.collapsed);
    },
    contentHeightChanged: function() {
        this.calcCanCollapse();
    },
    canCollapseChanged: function() {
        this.$.button.setShowing(this.canCollapse);
    },
    calcMaxHeight: function() {
        this.set("maxHeight", this.maxLines * this.lineHeight);
    },
    calcLineHeight: function() {
        var t = parseInt(enyo.dom.getComputedStyleValue(this.$.client.hasNode(), "line-height"), 10);
        this.set("lineHeight", t > 0 ? t : null);
    },
    calcContentHeight: function() {
        var t;
        this.addRemoveLineClamp(!1), t = this.$.client.hasNode() ? this.$.client.hasNode().getBoundingClientRect().height : 0, 
        this.addRemoveLineClamp(this.collapsed), this.set("contentHeight", t);
    },
    calcCanCollapse: function() {
        this.set("canCollapse", this.contentHeight > this.maxHeight);
    },
    addRemoveLineClamp: function(t) {
        this.$.client.applyStyle("-webkit-line-clamp", t ? this.maxLines : null);
    }
}), enyo.kind({
    name: "moon.ExpandableTextButton",
    kind: "enyo.Control",
    published: {
        moreContent: moon.$L("more"),
        lessContent: moon.$L("less"),
        collapsed: !0
    },
    handlers: {
        onSpotlightFocused: "spotFocused"
    },
    classes: "moon-item moon-expandable-text-button",
    spotlight: !0,
    create: function() {
        this.inherited(arguments), this.updateContent();
    },
    spotFocused: function(t, e) {
        e.originator === this && this.bubble("onRequestScrollIntoView");
    },
    moreContentChanged: function() {
        this.updateContent();
    },
    lessContentChanged: function() {
        this.updateContent();
    },
    collapsedChanged: function() {
        this.updateContent();
    },
    updateContent: function() {
        this.collapsed ? (this.setContent(this.moreContent), this.addClass("collapsed")) : (this.setContent(this.lessContent), 
        this.removeClass("collapsed"));
    }
});

// lib\moonstone\source\keymap.js
enyo.platform.webos >= 4 && enyo.dispatcher.registerKeyMap({
    415: "play",
    413: "stop",
    19: "pause",
    412: "rewind",
    417: "fastforward"
});

// lib\enyo-ilib\version.js
enyo && enyo.version && (enyo.version["enyo-ilib"] = "2.4.0-pre.2");

// lib\enyo-ilib\ilib\js\ilib-dyn-standard.js
var ilib = ilib || {};

ilib.getVersion = function() {
    return "5.0";
}, ilib.data = {
    norm: {
        nfc: {},
        nfd: {},
        nfkd: {},
        ccc: {}
    }
}, "undefined" != typeof window && (window.ilib = ilib), "undefined" != typeof exports && (exports.ilib = ilib), 
ilib._getPlatform = function() {
    return ilib._platform || (ilib._platform = "undefined" != typeof environment ? "rhino" : "undefined" != typeof process || "undefined" != typeof require ? "nodejs" : "undefined" != typeof window ? "undefined" != typeof PalmSystem ? "webos" : "browser" : "unknown"), 
    ilib._platform;
}, ilib._isGlobal = function(t) {
    switch (ilib._getPlatform()) {
      case "rhino":
        var e = function() {
            return "object" == typeof global ? global : this;
        }();
        return void 0 !== typeof e[t];

      case "nodejs":
        var i = "undefined" != typeof global ? global : this;
        return i && void 0 !== typeof i[t];

      default:
        return void 0 !== typeof window[t];
    }
}, ilib.setLocale = function(t) {
    "string" == typeof t && (ilib.locale = t);
}, ilib.getLocale = function() {
    if ("string" != typeof ilib.locale) {
        if ("undefined" != typeof navigator && navigator.language !== void 0) {
            if (ilib.locale = navigator.language, !ilib.locale) {
                var t = navigator.browserLanguage !== void 0 ? navigator.browserLanguage : navigator.userLanguage !== void 0 ? navigator.userLanguage : navigator.systemLanguage !== void 0 ? navigator.systemLanguage : void 0;
                t !== void 0 && t && (ilib.locale = t.substring(0, 3) + t.substring(3, 5).toUpperCase());
            }
        } else if ("undefined" != typeof PalmSystem && PalmSystem.locales !== void 0) PalmSystem.locales.UI !== void 0 && PalmSystem.locales.UI.length > 0 && (ilib.locale = PalmSystem.locales.UI); else if ("undefined" != typeof environment && environment.user !== void 0) "string" == typeof environment.user.language && environment.user.language.length > 0 && (ilib.locale = environment.user.language, 
        "string" == typeof environment.user.country && environment.user.country.length > 0 && (ilib.locale += "-" + environment.user.country)); else if ("undefined" != typeof process && process.env !== void 0) {
            var t = process.env.LANG || process.env.LC_ALL;
            t && "undefined" !== t && (ilib.locale = t.substring(0, 2).toLowerCase() + "-" + t.substring(3, 5).toUpperCase());
        }
        ilib.locale = "string" == typeof ilib.locale ? ilib.locale : "en-US";
    }
    return ilib.locale;
}, ilib.setTimeZone = function(t) {
    ilib.tz = t || ilib.tz;
}, ilib.getTimeZone = function() {
    return ilib.tz === void 0 && ("undefined" != typeof navigator && navigator.timezone !== void 0 ? navigator.timezone.length > 0 && (ilib.tz = navigator.timezone) : "undefined" != typeof PalmSystem && PalmSystem.timezone !== void 0 ? PalmSystem.timezone.length > 0 && (ilib.tz = PalmSystem.timezone) : "undefined" != typeof environment && environment.user !== void 0 ? environment.user.timezone !== void 0 && environment.user.timezone.length > 0 && (ilib.tz = environment.user.timezone) : "undefined" != typeof process && process.env !== void 0 && process.env.TZ && "undefined" !== process.env.TZ && (ilib.tz = process.env.TZ), 
    ilib.tz = ilib.tz || "local"), ilib.tz;
}, ilib.setLoaderCallback = function(t) {
    return "function" == typeof t || t === void 0 ? (ilib._load = t, !0) : !1;
}, ilib.Locale = function(t, e, i, n) {
    if (e === void 0) {
        var o = t || ilib.getLocale();
        if ("string" == typeof o) {
            for (var s = o.split("-"), a = 0; s.length > a; a++) ilib.Locale._isLanguageCode(s[a]) ? this.language = s[a] : ilib.Locale._isRegionCode(s[a]) ? this.region = s[a] : ilib.Locale._isScriptCode(s[a]) ? this.script = s[a] : this.variant = s[a];
            this.language = this.language || void 0, this.region = this.region || void 0, this.script = this.script || void 0, 
            this.variant = this.variant || void 0;
        } else "object" == typeof o && (this.language = o.language || void 0, this.region = o.region || void 0, 
        this.script = o.script || void 0, this.variant = o.variant || void 0);
    } else t ? (t = t.trim(), this.language = t.length > 0 ? t.toLowerCase() : void 0) : this.language = void 0, 
    e ? (e = e.trim(), this.region = e.length > 0 ? e.toUpperCase() : void 0) : this.region = void 0, 
    i ? (i = i.trim(), this.variant = i.length > 0 ? i : void 0) : this.variant = void 0, 
    n ? (n = n.trim(), this.script = n.length > 0 ? n : void 0) : this.script = void 0;
    this.spec = this.language || "", this.script && (this.spec.length > 0 && (this.spec += "-"), 
    this.spec += this.script), this.region && (this.spec.length > 0 && (this.spec += "-"), 
    this.spec += this.region), this.variant && (this.spec.length > 0 && (this.spec += "-"), 
    this.spec += this.variant);
}, ilib.Locale.a2toa3regmap = {
    AF: "AFG",
    AX: "ALA",
    AL: "ALB",
    DZ: "DZA",
    AS: "ASM",
    AD: "AND",
    AO: "AGO",
    AI: "AIA",
    AQ: "ATA",
    AG: "ATG",
    AR: "ARG",
    AM: "ARM",
    AW: "ABW",
    AU: "AUS",
    AT: "AUT",
    AZ: "AZE",
    BS: "BHS",
    BH: "BHR",
    BD: "BGD",
    BB: "BRB",
    BY: "BLR",
    BE: "BEL",
    BZ: "BLZ",
    BJ: "BEN",
    BM: "BMU",
    BT: "BTN",
    BO: "BOL",
    BQ: "BES",
    BA: "BIH",
    BW: "BWA",
    BV: "BVT",
    BR: "BRA",
    IO: "IOT",
    BN: "BRN",
    BG: "BGR",
    BF: "BFA",
    BI: "BDI",
    KH: "KHM",
    CM: "CMR",
    CA: "CAN",
    CV: "CPV",
    KY: "CYM",
    CF: "CAF",
    TD: "TCD",
    CL: "CHL",
    CN: "CHN",
    CX: "CXR",
    CC: "CCK",
    CO: "COL",
    KM: "COM",
    CG: "COG",
    CD: "COD",
    CK: "COK",
    CR: "CRI",
    CI: "CIV",
    HR: "HRV",
    CU: "CUB",
    CW: "CUW",
    CY: "CYP",
    CZ: "CZE",
    DK: "DNK",
    DJ: "DJI",
    DM: "DMA",
    DO: "DOM",
    EC: "ECU",
    EG: "EGY",
    SV: "SLV",
    GQ: "GNQ",
    ER: "ERI",
    EE: "EST",
    ET: "ETH",
    FK: "FLK",
    FO: "FRO",
    FJ: "FJI",
    FI: "FIN",
    FR: "FRA",
    GF: "GUF",
    PF: "PYF",
    TF: "ATF",
    GA: "GAB",
    GM: "GMB",
    GE: "GEO",
    DE: "DEU",
    GH: "GHA",
    GI: "GIB",
    GR: "GRC",
    GL: "GRL",
    GD: "GRD",
    GP: "GLP",
    GU: "GUM",
    GT: "GTM",
    GG: "GGY",
    GN: "GIN",
    GW: "GNB",
    GY: "GUY",
    HT: "HTI",
    HM: "HMD",
    VA: "VAT",
    HN: "HND",
    HK: "HKG",
    HU: "HUN",
    IS: "ISL",
    IN: "IND",
    ID: "IDN",
    IR: "IRN",
    IQ: "IRQ",
    IE: "IRL",
    IM: "IMN",
    IL: "ISR",
    IT: "ITA",
    JM: "JAM",
    JP: "JPN",
    JE: "JEY",
    JO: "JOR",
    KZ: "KAZ",
    KE: "KEN",
    KI: "KIR",
    KP: "PRK",
    KR: "KOR",
    KW: "KWT",
    KG: "KGZ",
    LA: "LAO",
    LV: "LVA",
    LB: "LBN",
    LS: "LSO",
    LR: "LBR",
    LY: "LBY",
    LI: "LIE",
    LT: "LTU",
    LU: "LUX",
    MO: "MAC",
    MK: "MKD",
    MG: "MDG",
    MW: "MWI",
    MY: "MYS",
    MV: "MDV",
    ML: "MLI",
    MT: "MLT",
    MH: "MHL",
    MQ: "MTQ",
    MR: "MRT",
    MU: "MUS",
    YT: "MYT",
    MX: "MEX",
    FM: "FSM",
    MD: "MDA",
    MC: "MCO",
    MN: "MNG",
    ME: "MNE",
    MS: "MSR",
    MA: "MAR",
    MZ: "MOZ",
    MM: "MMR",
    NA: "NAM",
    NR: "NRU",
    NP: "NPL",
    NL: "NLD",
    NC: "NCL",
    NZ: "NZL",
    NI: "NIC",
    NE: "NER",
    NG: "NGA",
    NU: "NIU",
    NF: "NFK",
    MP: "MNP",
    NO: "NOR",
    OM: "OMN",
    PK: "PAK",
    PW: "PLW",
    PS: "PSE",
    PA: "PAN",
    PG: "PNG",
    PY: "PRY",
    PE: "PER",
    PH: "PHL",
    PN: "PCN",
    PL: "POL",
    PT: "PRT",
    PR: "PRI",
    QA: "QAT",
    RE: "REU",
    RO: "ROU",
    RU: "RUS",
    RW: "RWA",
    BL: "BLM",
    SH: "SHN",
    KN: "KNA",
    LC: "LCA",
    MF: "MAF",
    PM: "SPM",
    VC: "VCT",
    WS: "WSM",
    SM: "SMR",
    ST: "STP",
    SA: "SAU",
    SN: "SEN",
    RS: "SRB",
    SC: "SYC",
    SL: "SLE",
    SG: "SGP",
    SX: "SXM",
    SK: "SVK",
    SI: "SVN",
    SB: "SLB",
    SO: "SOM",
    ZA: "ZAF",
    GS: "SGS",
    SS: "SSD",
    ES: "ESP",
    LK: "LKA",
    SD: "SDN",
    SR: "SUR",
    SJ: "SJM",
    SZ: "SWZ",
    SE: "SWE",
    CH: "CHE",
    SY: "SYR",
    TW: "TWN",
    TJ: "TJK",
    TZ: "TZA",
    TH: "THA",
    TL: "TLS",
    TG: "TGO",
    TK: "TKL",
    TO: "TON",
    TT: "TTO",
    TN: "TUN",
    TR: "TUR",
    TM: "TKM",
    TC: "TCA",
    TV: "TUV",
    UG: "UGA",
    UA: "UKR",
    AE: "ARE",
    GB: "GBR",
    US: "USA",
    UM: "UMI",
    UY: "URY",
    UZ: "UZB",
    VU: "VUT",
    VE: "VEN",
    VN: "VNM",
    VG: "VGB",
    VI: "VIR",
    WF: "WLF",
    EH: "ESH",
    YE: "YEM",
    ZM: "ZMB",
    ZW: "ZWE"
}, ilib.Locale.a1toa3langmap = {
    ab: "abk",
    aa: "aar",
    af: "afr",
    ak: "aka",
    sq: "sqi",
    am: "amh",
    ar: "ara",
    an: "arg",
    hy: "hye",
    as: "asm",
    av: "ava",
    ae: "ave",
    ay: "aym",
    az: "aze",
    bm: "bam",
    ba: "bak",
    eu: "eus",
    be: "bel",
    bn: "ben",
    bh: "bih",
    bi: "bis",
    bs: "bos",
    br: "bre",
    bg: "bul",
    my: "mya",
    ca: "cat",
    ch: "cha",
    ce: "che",
    ny: "nya",
    zh: "zho",
    cv: "chv",
    kw: "cor",
    co: "cos",
    cr: "cre",
    hr: "hrv",
    cs: "ces",
    da: "dan",
    dv: "div",
    nl: "nld",
    dz: "dzo",
    en: "eng",
    eo: "epo",
    et: "est",
    ee: "ewe",
    fo: "fao",
    fj: "fij",
    fi: "fin",
    fr: "fra",
    ff: "ful",
    gl: "glg",
    ka: "kat",
    de: "deu",
    el: "ell",
    gn: "grn",
    gu: "guj",
    ht: "hat",
    ha: "hau",
    he: "heb",
    hz: "her",
    hi: "hin",
    ho: "hmo",
    hu: "hun",
    ia: "ina",
    id: "ind",
    ie: "ile",
    ga: "gle",
    ig: "ibo",
    ik: "ipk",
    io: "ido",
    is: "isl",
    it: "ita",
    iu: "iku",
    ja: "jpn",
    jv: "jav",
    kl: "kal",
    kn: "kan",
    kr: "kau",
    ks: "kas",
    kk: "kaz",
    km: "khm",
    ki: "kik",
    rw: "kin",
    ky: "kir",
    kv: "kom",
    kg: "kon",
    ko: "kor",
    ku: "kur",
    kj: "kua",
    la: "lat",
    lb: "ltz",
    lg: "lug",
    li: "lim",
    ln: "lin",
    lo: "lao",
    lt: "lit",
    lu: "lub",
    lv: "lav",
    gv: "glv",
    mk: "mkd",
    mg: "mlg",
    ms: "msa",
    ml: "mal",
    mt: "mlt",
    mi: "mri",
    mr: "mar",
    mh: "mah",
    mn: "mon",
    na: "nau",
    nv: "nav",
    nb: "nob",
    nd: "nde",
    ne: "nep",
    ng: "ndo",
    nn: "nno",
    no: "nor",
    ii: "iii",
    nr: "nbl",
    oc: "oci",
    oj: "oji",
    cu: "chu",
    om: "orm",
    or: "ori",
    os: "oss",
    pa: "pan",
    pi: "pli",
    fa: "fas",
    pl: "pol",
    ps: "pus",
    pt: "por",
    qu: "que",
    rm: "roh",
    rn: "run",
    ro: "ron",
    ru: "rus",
    sa: "san",
    sc: "srd",
    sd: "snd",
    se: "sme",
    sm: "smo",
    sg: "sag",
    sr: "srp",
    gd: "gla",
    sn: "sna",
    si: "sin",
    sk: "slk",
    sl: "slv",
    so: "som",
    st: "sot",
    az: "azb",
    es: "spa",
    su: "sun",
    sw: "swa",
    ss: "ssw",
    sv: "swe",
    ta: "tam",
    te: "tel",
    tg: "tgk",
    th: "tha",
    ti: "tir",
    bo: "bod",
    tk: "tuk",
    tl: "tgl",
    tn: "tsn",
    to: "ton",
    tr: "tur",
    ts: "tso",
    tt: "tat",
    tw: "twi",
    ty: "tah",
    ug: "uig",
    uk: "ukr",
    ur: "urd",
    uz: "uzb",
    ve: "ven",
    vi: "vie",
    vo: "vol",
    wa: "wln",
    cy: "cym",
    wo: "wol",
    fy: "fry",
    xh: "xho",
    yi: "yid",
    yo: "yor",
    za: "zha",
    zu: "zul"
}, ilib.Locale._notLower = function(t) {
    var e = t.charCodeAt(0);
    return 97 > e || e > 122;
}, ilib.Locale._notUpper = function(t) {
    var e = t.charCodeAt(0);
    return 65 > e || e > 90;
}, ilib.Locale._notDigit = function(t) {
    var e = t.charCodeAt(0);
    return 48 > e || e > 57;
}, ilib.Locale._isLanguageCode = function(t) {
    if (t === void 0 || 2 > t.length || t.length > 3) return !1;
    for (var e = 0; t.length > e; e++) if (ilib.Locale._notLower(t.charAt(e))) return !1;
    return !0;
}, ilib.Locale._isRegionCode = function(t) {
    if (t === void 0 || 2 > t.length || t.length > 3) return !1;
    if (2 === t.length) {
        for (var e = 0; t.length > e; e++) if (ilib.Locale._notUpper(t.charAt(e))) return !1;
    } else for (var e = 0; t.length > e; e++) if (ilib.Locale._notDigit(t.charAt(e))) return !1;
    return !0;
}, ilib.Locale._isScriptCode = function(t) {
    if (t === void 0 || 4 !== t.length || ilib.Locale._notUpper(t.charAt(0))) return !1;
    for (var e = 1; 4 > e; e++) if (ilib.Locale._notLower(t.charAt(e))) return !1;
    return !0;
}, ilib.Locale.regionAlpha2ToAlpha3 = function(t) {
    return ilib.Locale.a2toa3regmap[t] || t;
}, ilib.Locale.languageAlpha1ToAlpha3 = function(t) {
    return ilib.Locale.a1toa3langmap[t] || t;
}, ilib.Locale.prototype = {
    getLanguage: function() {
        return this.language;
    },
    getLanguageAlpha3: function() {
        return ilib.Locale.languageAlpha1ToAlpha3(this.language);
    },
    getRegion: function() {
        return this.region;
    },
    getRegionAlpha3: function() {
        return ilib.Locale.regionAlpha2ToAlpha3(this.region);
    },
    getScript: function() {
        return this.script;
    },
    getVariant: function() {
        return this.variant;
    },
    getSpec: function() {
        return this.spec;
    },
    toString: function() {
        return this.getSpec();
    },
    equals: function(t) {
        return this.language === t.language && this.region === t.region && this.script === t.script && this.variant === t.variant;
    },
    isPseudo: function() {
        return "zxx" === this.language && "XX" === this.region;
    }
}, ilib.Locale.locales = [], ilib.Locale.getAvailableLocales = function() {
    return ilib.Locale.locales;
}, ilib.LocaleInfo = function(t, e) {
    var i = !0, n = void 0;
    switch (this.info = ilib.LocaleInfo.defaultInfo, typeof t) {
      case "string":
        this.locale = new ilib.Locale(t);
        break;

      default:
      case "undefined":
        this.locale = new ilib.Locale();
        break;

      case "object":
        this.locale = t;
    }
    e && (e.sync !== void 0 && (i = 1 == e.sync), e.loadParams !== void 0 && (n = e.loadParams)), 
    ilib.LocaleInfo.cache || (ilib.LocaleInfo.cache = {}), ilib.loadData({
        object: ilib.LocaleInfo,
        locale: this.locale,
        name: "localeinfo.json",
        sync: i,
        loadParams: n,
        callback: ilib.bind(this, function(t) {
            if (!t) {
                t = ilib.LocaleInfo.defaultInfo;
                var i = this.locale.getSpec().replace(/-/g, "_");
                ilib.LocaleInfo.cache[i] = t;
            }
            this.info = t, e && "function" == typeof e.onLoad && e.onLoad(this);
        })
    });
}, ilib.LocaleInfo.defaultInfo = ilib.data.localeinfo, ilib.LocaleInfo.defaultInfo = ilib.LocaleInfo.defaultInfo || {
    scripts: [ "Latn" ],
    timezone: "Etc/UTC",
    units: "metric",
    calendar: "gregorian",
    clock: "24",
    currency: "USD",
    firstDayOfWeek: 1,
    numfmt: {
        currencyFormats: {
            common: "{s}{n}",
            commonNegative: "{s}-{n}",
            iso: "{s}{n}",
            isoNegative: "{s}-{n}"
        },
        script: "Latn",
        decimalChar: ",",
        groupChar: ".",
        prigroupSize: 3,
        secgroupSize: 0,
        pctFmt: "{n}%",
        negativepctFmt: "-{n}%",
        pctChar: "%",
        roundingMode: "halfdown",
        exponential: "e",
        digits: ""
    }
}, ilib.LocaleInfo.prototype = {
    getLanguageName: function() {
        return this.info["language.name"];
    },
    getRegionName: function() {
        return this.info["region.name"];
    },
    getClock: function() {
        return this.info.clock;
    },
    getLocale: function() {
        return this.locale;
    },
    getUnits: function() {
        return this.info.units;
    },
    getCalendar: function() {
        return this.info.calendar;
    },
    getFirstDayOfWeek: function() {
        return this.info.firstDayOfWeek;
    },
    getTimeZone: function() {
        return this.info.timezone;
    },
    getDecimalSeparator: function() {
        return this.info.numfmt.decimalChar;
    },
    getNativeDecimalSeparator: function() {
        return this.info.native_numfmt && this.info.native_numfmt.decimalChar || this.info.numfmt.decimalChar;
    },
    getGroupingSeparator: function() {
        return this.info.numfmt.groupChar;
    },
    getNativeGroupingSeparator: function() {
        return this.info.native_numfmt && this.info.native_numfmt.groupChar || this.info.numfmt.groupChar;
    },
    getPrimaryGroupingDigits: function() {
        return this.info.numfmt.prigroupSize !== void 0 && this.info.numfmt.prigroupSize || 0;
    },
    getSecondaryGroupingDigits: function() {
        return this.info.numfmt.secgroupSize || 0;
    },
    getPercentageFormat: function() {
        return this.info.numfmt.pctFmt;
    },
    getNegativePercentageFormat: function() {
        return this.info.numfmt.negativepctFmt;
    },
    getPercentageSymbol: function() {
        return this.info.numfmt.pctChar || "%";
    },
    getExponential: function() {
        return this.info.numfmt.exponential;
    },
    getNativeExponential: function() {
        return this.info.native_numfmt && this.info.native_numfmt.exponential || this.info.numfmt.exponential;
    },
    getNativePercentageSymbol: function() {
        return this.info.native_numfmt && this.info.native_numfmt.pctChar || this.info.numfmt.pctChar || "%";
    },
    getNegativeNumberFormat: function() {
        return this.info.numfmt.negativenumFmt;
    },
    getCurrencyFormats: function() {
        return this.info.numfmt.currencyFormats;
    },
    getCurrency: function() {
        return this.info.currency;
    },
    getDigitsStyle: function() {
        return this.info.numfmt.useNative ? "native" : this.info.native_numfmt !== void 0 ? "optional" : "western";
    },
    getDigits: function() {
        return this.info.numfmt.digits;
    },
    getNativeDigits: function() {
        return this.info.numfmt.useNative && this.info.numfmt.digits || this.info.native_numfmt && this.info.native_numfmt.digits;
    },
    getRoundingMode: function() {
        return this.info.numfmt.roundingMode;
    },
    getDefaultScript: function() {
        return this.info.scripts ? this.info.scripts[0] : "Latn";
    },
    getScript: function() {
        return this.locale.getScript() || this.getDefaultScript();
    },
    getAllScripts: function() {
        return this.info.scripts || [ "Latn" ];
    }
}, ilib.Date = function(t) {
    this.year = t && t.year || 0, this.month = t && t.month || 1, this.day = t && t.day || 1, 
    this.hour = t && t.hour || 0, this.minute = t && t.minute || 0, this.second = t && t.second || 0, 
    this.millisecond = t && t.millisecond || 0;
}, ilib.Date.newInstance = function(t) {
    var e, i = t && t.locale, n = t && t.type;
    if (i || (i = new ilib.Locale()), !n) {
        var o = new ilib.LocaleInfo(i);
        n = o.getCalendar();
    }
    return e = ilib.Date._constructors[n], e && new e(t);
}, ilib.Date._dateToIlib = function(t) {
    return t === void 0 || null === t ? t : t instanceof ilib.Date ? t : t instanceof Date ? ilib.Date.newInstance({
        unixtime: t.getTime()
    }) : t instanceof ilib.JulianDay ? ilib.Date.newInstance({
        jd: t
    }) : "number" == typeof t ? ilib.Date.newInstance({
        unixtime: t
    }) : "object" == typeof t ? ilib.Date.newInstance(t) : ("string" == typeof t && (t = new Date(t)), 
    ilib.Date.newInstance({
        unixtime: t.getTime()
    }));
}, ilib.Date._constructors = {}, ilib.Date.prototype = {
    getType: function() {
        return "ilib.Date";
    },
    getDays: function() {
        return this.day;
    },
    getMonths: function() {
        return this.month;
    },
    getYears: function() {
        return this.year;
    },
    getHours: function() {
        return this.hour;
    },
    getMinutes: function() {
        return this.minute;
    },
    getSeconds: function() {
        return this.second;
    },
    getMilliseconds: function() {
        return this.millisecond;
    },
    setDays: function(t) {
        this.day = t;
    },
    setMonths: function(t) {
        this.month = t;
    },
    setYears: function(t) {
        this.year = t;
    },
    setHours: function(t) {
        this.hour = t;
    },
    setMinutes: function(t) {
        this.minute = t;
    },
    setSeconds: function(t) {
        this.second = t;
    },
    setMilliseconds: function(t) {
        this.millisecond = t;
    }
}, ilib.bind = function(t, e) {
    function i(t, e) {
        for (var i = [], n = e || 0, o = t.length; o > n; n++) i.push(t[n]);
        return i;
    }
    if (!t || !e) return void 0;
    if ("function" == typeof e) {
        var n, o = i(arguments, 2);
        return n = "function" == typeof e.bind ? e.bind.apply(e, [ t ].concat(o)) : function() {
            var n = i(arguments);
            return e.apply(t, o.concat(n));
        };
    }
    return void 0;
}, ilib.mod = function(t, e) {
    if (0 == e) return 0;
    var i = t % e;
    return 0 > i ? i + e : i;
}, ilib.merge = function(t, e, i, n) {
    var o = void 0, s = {};
    for (o in t) o && t[o] !== void 0 && (s[o] = t[o]);
    for (o in e) o && e[o] !== void 0 && (t[o] instanceof Array && e[o] instanceof Array ? (s[o] = [], 
    s[o] = s[o].concat(t[o]), s[o] = s[o].concat(e[o])) : "object" == typeof t[o] && "object" == typeof e[o] ? s[o] = ilib.merge(t[o], e[o]) : (i && n && s[o] == e[o] && console.log("Property " + o + " in " + i + " is being overridden by the same value in " + n), 
    s[o] = e[o]));
    return s;
}, ilib.mergeLocData = function(t, e) {
    var i = void 0, n = e || new ilib.Locale(), o = !1, s = t;
    return i = ilib.data[t] || {}, n.getLanguage() && (s = t + "_" + n.getLanguage(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), n.getRegion() && (s = t + "_" + n.getRegion(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), n.getLanguage() && (s = t + "_" + n.getLanguage(), 
    n.getScript() && (s = t + "_" + n.getLanguage() + "_" + n.getScript(), ilib.data[s] && (o = !0, 
    i = ilib.merge(i, ilib.data[s]))), n.getRegion() && (s = t + "_" + n.getLanguage() + "_" + n.getRegion(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s])))), n.getRegion() && n.getVariant() && (s = t + "_" + n.getLanguage() + "_" + n.getVariant(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), n.getLanguage() && n.getScript() && n.getRegion() && (s = t + "_" + n.getLanguage() + "_" + n.getScript() + "_" + n.getRegion(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), n.getLanguage() && n.getRegion() && n.getVariant() && (s = t + "_" + n.getLanguage() + "_" + n.getRegion() + "_" + n.getVariant(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), n.getLanguage() && n.getScript() && n.getRegion() && n.getVariant() && (s = t + "_" + n.getLanguage() + "_" + n.getScript() + "_" + n.getRegion() + "_" + n.getVariant(), 
    ilib.data[s] && (o = !0, i = ilib.merge(i, ilib.data[s]))), o ? i : void 0;
}, ilib.getLocFiles = function(t, e) {
    var i = "", n = [], o = e || "resources.json", s = t || new ilib.Locale(), a = s.getLanguage(), r = s.getRegion(), h = s.getScript(), l = s.getVariant();
    return n.push(o), a && (i = a + "/", n.push(i + o)), r && (i = "und/" + r + "/", 
    n.push(i + o)), a && (h && (i = a + "/" + h + "/", n.push(i + o)), r && (i = a + "/" + r + "/", 
    n.push(i + o))), r && l && (i = "und/" + r + "/" + l + "/", n.push(i + o)), a && h && r && (i = a + "/" + h + "/" + r + "/", 
    n.push(i + o)), a && r && l && (i = a + "/" + r + "/" + l + "/", n.push(i + o)), 
    a && h && r && l && (i = a + "/" + h + "/" + r + "/" + l + "/", n.push(i + o)), 
    n;
}, ilib.isEmpty = function(t) {
    var e = void 0;
    if (!t) return !0;
    for (e in t) if (e && t[e] !== void 0) return !1;
    return !0;
}, ilib.hashCode = function(t) {
    function e(t, e) {
        return t *= 65543, t += e, t %= 2147483647;
    }
    function i(t) {
        for (var i = 0, n = 0; t.length > n; n++) i = e(i, t.charCodeAt(n));
        return i;
    }
    var n = 0;
    switch (typeof t) {
      case "undefined":
        n = 0;
        break;

      case "string":
        n = i(t);
        break;

      case "function":
      case "number":
      case "xml":
        n = i(t + "");
        break;

      case "boolean":
        n = t ? 1 : 0;
        break;

      case "object":
        var o = [];
        for (var s in t) t.hasOwnProperty(s) && o.push(s);
        o.sort();
        for (var a = 0; o.length > a; a++) n = e(n, i(o[a])), n = e(n, ilib.hashCode(t[o[a]]));
    }
    return n;
}, ilib.loadData = function(t) {
    var e, i = "resources.json", n = void 0, o = new ilib.Locale(ilib.getLocale()), s = !1, a = {}, r = void 0;
    if (t && "function" == typeof t.callback) {
        if (t.name && (i = t.name), t.object && (n = t.object), t.locale && (o = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
        t.type && (e = t.type), t.loadParams && (a = t.loadParams), t.sync && (s = t.sync), 
        r = t.callback, n && !n.cache && (n.cache = {}), !e) {
            var h = i.lastIndexOf(".");
            e = -1 !== h ? i.substring(h + 1) : "text";
        }
        var l = (o.getSpec().replace(/-/g, "_") || "root") + "," + i + "," + (ilib.hashCode(a) + "");
        if (n && n.cache[l] !== void 0) r(n.cache[l]); else {
            var c;
            if ("json" === e) {
                var d = i.substring(0, i.lastIndexOf("."));
                if (c = ilib.mergeLocData(d, o)) return n && (n.cache[l] = c), r(c), void 0;
            }
            if ("function" == typeof ilib._load) {
                var u = ilib.getLocFiles(o, i);
                "json" !== e && (a.returnOne = !0), ilib._load(u, s, a, ilib.bind(this, function(t) {
                    if ("json" === e) {
                        c = ilib.data[d] || {};
                        for (var i = 0; t.length > i; i++) t[i] !== void 0 && (c = ilib.merge(c, t[i]));
                        n && (n.cache[l] = c), r(c);
                    } else {
                        for (var i = t.length - 1; i > -1 && !t[i]; ) i--;
                        i > -1 ? (n && (n.cache[l] = t[i]), r(t[i])) : r(void 0);
                    }
                }));
            } else n && c && (n.cache[l] = c), r(c);
        }
    }
}, ilib.String = function(t) {
    this.str = "object" == typeof t ? t.str : "string" == typeof t ? new String(t) : "", 
    this.length = this.str.length, this.cpLength = -1, this.localeSpec = ilib.getLocale();
}, ilib.String._isSurrogate = function(t) {
    var e = t.charCodeAt(0);
    return e >= 56320 && 57343 >= e || e >= 55296 && 56319 >= e;
}, ilib.String.fromCodePoint = function(t) {
    if (65536 > t) return String.fromCharCode(t);
    var e = Math.floor(t / 65536) - 1, i = 65535 & t;
    return String.fromCharCode(55296 | (15 & e) << 6 | (64512 & i) >> 10) + String.fromCharCode(56320 | 1023 & i);
}, ilib.String.loadPlurals = function(t, e, i, n) {
    var o;
    o = e ? "string" == typeof e ? new ilib.Locale(e) : e : new ilib.Locale(ilib.getLocale());
    var s = o.getLanguage();
    ilib.data["plurals_" + s] ? n && "function" == typeof n && n(ilib.data["plurals_" + s]) : ilib.loadData({
        name: "plurals.json",
        object: ilib.String,
        locale: o,
        sync: t,
        loadParams: i,
        callback: ilib.bind(this, function(t) {
            t || (ilib.String.cache[s] = {}), ilib.data["plurals_" + s] = t || {}, n && "function" == typeof n && n(ilib.data["plurals_" + s]);
        })
    });
}, ilib.String._fncs = {
    firstProp: function(t) {
        for (var e in t) if (e && t[e]) return e;
        return void 0;
    },
    getValue: function(t, e) {
        if ("object" == typeof t) {
            var i = ilib.String._fncs.firstProp(t);
            return ilib.String._fncs[i](t[i], e);
        }
        return "string" == typeof t ? e : t;
    },
    matchRangeContinuous: function(t, e) {
        for (var i in e) if (i !== void 0 && e[i] !== void 0) {
            var n = e[i];
            if ("number" == typeof n) {
                if (t === e[i]) return !0;
            } else if ("[object Array]" === Object.prototype.toString.call(n) && t >= n[0] && n[1] >= t) return !0;
        }
        return !1;
    },
    matchRange: function(t, e) {
        return Math.floor(t) !== t ? !1 : ilib.String._fncs.matchRangeContinuous(t, e);
    },
    is: function(t, e) {
        var i = ilib.String._fncs.getValue(t[0], e), n = ilib.String._fncs.getValue(t[1], e);
        return i == n;
    },
    isnot: function(t, e) {
        return ilib.String._fncs.getValue(t[0], e) != ilib.String._fncs.getValue(t[1], e);
    },
    inrange: function(t, e) {
        return ilib.String._fncs.matchRange(ilib.String._fncs.getValue(t[0], e), t[1]);
    },
    notin: function(t, e) {
        return !ilib.String._fncs.matchRange(ilib.String._fncs.getValue(t[0], e), t[1]);
    },
    within: function(t, e) {
        return ilib.String._fncs.matchRangeContinuous(ilib.String._fncs.getValue(t[0], e), t[1]);
    },
    mod: function(t, e) {
        return ilib.mod(ilib.String._fncs.getValue(t[0], e), ilib.String._fncs.getValue(t[1], e));
    },
    n: function(t, e) {
        return e;
    },
    or: function(t, e) {
        return ilib.String._fncs.getValue(t[0], e) || ilib.String._fncs.getValue(t[1], e);
    },
    and: function(t, e) {
        return ilib.String._fncs.getValue(t[0], e) && ilib.String._fncs.getValue(t[1], e);
    }
}, ilib.String.prototype = {
    _length: function() {
        return this.str.length;
    },
    format: function(t) {
        var e = this.str;
        if (t) {
            var i;
            for (var n in t) t[n] !== void 0 && (i = RegExp("{" + n + "}", "g"), e = e.replace(i, t[n]));
        }
        return "" + e;
    },
    formatChoice: function(t, e) {
        var i, n, o, s, a = this.str.split("|"), r = typeof t, h = [], l = [], c = void 0, d = "";
        if (0 === this.str.length) return "";
        for (i = 0; a.length > i; i++) if (n = a[i].split("#"), n.length > 2) h[i] = n[0], 
        n = n.shift(), l[i] = n.join("#"); else {
            if (2 !== n.length) throw "syntax error in choice format pattern: " + a[i];
            h[i] = n[0], l[i] = n[1];
        }
        for (i = 0; h.length > i; i++) if (0 === h[i].length) d = new ilib.String(l[i]); else switch (r) {
          case "number":
            if (s = parseInt(t, 10), "<=" === h[i].substring(0, 2)) o = parseFloat(h[i].substring(2)), 
            o >= s && (c = new ilib.String(l[i]), i = h.length); else if (">=" === h[i].substring(0, 2)) o = parseFloat(h[i].substring(2)), 
            s >= o && (c = new ilib.String(l[i]), i = h.length); else if ("<" === h[i].charAt(0)) o = parseFloat(h[i].substring(1)), 
            o > s && (c = new ilib.String(l[i]), i = h.length); else if (">" === h[i].charAt(0)) o = parseFloat(h[i].substring(1)), 
            s > o && (c = new ilib.String(l[i]), i = h.length); else switch (this.locale = this.locale || new ilib.Locale(this.localeSpec), 
            h[i]) {
              case "zero":
              case "one":
              case "two":
              case "few":
              case "many":
                var u = ilib.data["plurals_" + this.locale.getLanguage()];
                if (u) {
                    var p = u[h[i]];
                    ilib.String._fncs.getValue(p, s) && (c = new ilib.String(l[i]), i = h.length);
                }
                break;

              default:
                var g = h[i].indexOf("-");
                if (-1 !== g) {
                    var m = h[i].substring(0, g), f = h[i].substring(g + 1);
                    s >= parseInt(m, 10) && parseInt(f, 10) >= s && (c = new ilib.String(l[i]), i = h.length);
                } else s === parseInt(h[i], 10) && (c = new ilib.String(l[i]), i = h.length);
            }
            break;

          case "boolean":
            "true" === h[i] && t === !0 ? (c = new ilib.String(l[i]), i = h.length) : "false" === h[i] && t === !1 && (c = new ilib.String(l[i]), 
            i = h.length);
            break;

          case "string":
            var y = RegExp(h[i], "i");
            y.test(t) && (c = new ilib.String(l[i]), i = h.length);
            break;

          case "object":
            throw "syntax error: fmtChoice parameter for the argument index cannot be an object";
        }
        return c || (c = d || new ilib.String("")), c = c.format(e), "" + c;
    },
    toString: function() {
        return "" + this.str;
    },
    valueOf: function() {
        return this.str.valueOf();
    },
    charAt: function(t) {
        return new ilib.String(this.str.charAt(t));
    },
    charCodeAt: function(t) {
        return this.str.charCodeAt(t);
    },
    concat: function(t) {
        return new ilib.String(this.str.concat(t));
    },
    indexOf: function(t, e) {
        return this.str.indexOf(t, e);
    },
    lastIndexOf: function(t, e) {
        return this.str.lastIndexOf(t, e);
    },
    match: function(t) {
        return this.str.match(t);
    },
    replace: function(t, e) {
        return new ilib.String(this.str.replace(t, e));
    },
    search: function(t) {
        return this.str.search(t);
    },
    slice: function(t, e) {
        return new ilib.String(this.str.slice(t, e));
    },
    split: function(t, e) {
        return this.str.split(t, e);
    },
    substr: function(t, e) {
        return new ilib.String(this.str.substr(t, e));
    },
    substring: function(t, e) {
        return this.str.substring(t, e);
    },
    toLowerCase: function() {
        return this.str.toLowerCase();
    },
    toUpperCase: function() {
        return this.str.toUpperCase();
    },
    _toCodePoint: function(t) {
        if (0 === this.str.length) return -1;
        var e = -1, i = this.str.charCodeAt(t);
        if (i >= 55296 && 56319 >= i) {
            if (this.str.length > t + 1) {
                var n = this.str.charCodeAt(t + 1);
                n >= 56320 && 57343 >= n && (e = ((960 & i) >> 6) + 1 << 16 | ((63 & i) << 10 | 1023 & n));
            }
        } else e = i;
        return e;
    },
    iterator: function() {
        function t(t) {
            this.index = 0, this.hasNext = function() {
                return this.index < t.str.length;
            }, this.next = function() {
                if (this.index < t.str.length) {
                    var e = t._toCodePoint(this.index);
                    this.index += e > 65535 ? 2 : 1;
                } else e = -1;
                return e;
            };
        }
        return new t(this);
    },
    charIterator: function() {
        function t(t) {
            this.index = 0, this.hasNext = function() {
                return this.index < t.str.length;
            }, this.next = function() {
                var e;
                return this.index < t.str.length && (e = t.str.charAt(this.index), ilib.String._isSurrogate(e) && this.index + 1 < t.str.length && ilib.String._isSurrogate(t.str.charAt(this.index + 1)) && (this.index++, 
                e += t.str.charAt(this.index)), this.index++), e;
            };
        }
        return new t(this);
    },
    codePointAt: function(t) {
        if (0 > t) return -1;
        var e, i, n = this.iterator();
        for (e = t; e >= 0 && n.hasNext(); e--) i = n.next();
        return 0 > e ? i : -1;
    },
    setLocale: function(t, e, i, n) {
        "object" == typeof t ? this.locale = t : (this.localeSpec = t, this.locale = new ilib.Locale(t)), 
        ilib.String.loadPlurals(e !== void 0 ? e : !0, this.locale, i, n);
    },
    getLocale: function() {
        return (this.locale ? this.locale.getSpec() : this.localeSpec) || ilib.getLocale();
    },
    codePointLength: function() {
        if (-1 === this.cpLength) {
            var t = this.iterator();
            for (this.cpLength = 0; t.hasNext(); ) this.cpLength++, t.next();
        }
        return this.cpLength;
    }
}, ilib.Cal = function() {}, ilib.Cal.newInstance = function(t) {
    var e, i = t && t.locale, n = t && t.type;
    if (i || (i = new ilib.Locale()), !n) {
        var o = new ilib.LocaleInfo(i);
        n = o.getCalendar();
    }
    return e = ilib.Cal._constructors[n], e && new e(t);
}, ilib.Cal._constructors = {}, ilib.Cal.getCalendars = function() {
    var t, e = [];
    for (t in ilib.Cal._constructors) t && ilib.Cal._constructors[t] && e.push(t);
    return e;
}, ilib.Cal.prototype = {
    getType: function() {
        throw "Cannot call methods of abstract class ilib.Cal";
    },
    getNumMonths: function() {
        throw "Cannot call methods of abstract class ilib.Cal";
    },
    getMonLength: function() {
        throw "Cannot call methods of abstract class ilib.Cal";
    },
    isLeapYear: function() {
        throw "Cannot call methods of abstract class ilib.Cal";
    }
}, ilib.signum = function(t) {
    var e = t;
    if ("string" == typeof t) e = parseInt(t, 10); else if ("number" != typeof t) return 1;
    return 0 > e ? -1 : 1;
}, ilib._roundFnc = {
    floor: function(t) {
        return Math.floor(t);
    },
    ceiling: function(t) {
        return Math.ceil(t);
    },
    down: function(t) {
        return 0 > t ? Math.ceil(t) : Math.floor(t);
    },
    up: function(t) {
        return 0 > t ? Math.floor(t) : Math.ceil(t);
    },
    halfup: function(t) {
        return 0 > t ? Math.ceil(t - .5) : Math.floor(t + .5);
    },
    halfdown: function(t) {
        return 0 > t ? Math.floor(t + .5) : Math.ceil(t - .5);
    },
    halfeven: function(t) {
        return 0 === Math.floor(t) % 2 ? Math.ceil(t - .5) : Math.floor(t + .5);
    },
    halfodd: function(t) {
        return 0 !== Math.floor(t) % 2 ? Math.ceil(t - .5) : Math.floor(t + .5);
    }
}, ilib.JulianDay = function(t) {
    this.jd = t, this.days = Math.floor(this.jd), this.frac = t - this.days;
}, ilib.JulianDay.prototype = {
    getDays: function() {
        return this.days;
    },
    setDays: function(t) {
        this.days = Math.floor(t), this.jd = this.days + this.frac;
    },
    getDayFraction: function() {
        return this.frac;
    },
    setDayFraction: function(t) {
        var e = Math.floor(t);
        this.frac = t - e, this.jd = this.days + this.frac;
    },
    getDate: function() {
        return this.jd;
    },
    setDate: function(t) {
        this.jd = t;
    },
    addDate: function(t) {
        "number" == typeof t && (this.jd += t, this.days = Math.floor(this.jd), this.frac = this.jd - this.days);
    }
}, ilib.Cal.Gregorian = function() {
    this.type = "gregorian";
}, ilib.Cal.Gregorian.monthLengths = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ], 
ilib.Cal.Gregorian.prototype.getNumMonths = function() {
    return 12;
}, ilib.Cal.Gregorian.prototype.getMonLength = function(t, e) {
    return 2 === t && this.isLeapYear(e) ? 29 : ilib.Cal.Gregorian.monthLengths[t - 1];
}, ilib.Cal.Gregorian.prototype.isLeapYear = function(t) {
    var e = "number" == typeof t ? t : t.getYears(), i = ilib.mod(e, 400);
    return 0 === ilib.mod(e, 4) && 100 !== i && 200 !== i && 300 !== i;
}, ilib.Cal.Gregorian.prototype.getType = function() {
    return this.type;
}, ilib.Cal.Gregorian.prototype.newDateInstance = function(t) {
    return new ilib.Date.GregDate(t);
}, ilib.Cal._constructors.gregorian = ilib.Cal.Gregorian, ilib.bsearch = function(t, e, i) {
    if (e === void 0 || !e || t === void 0) return -1;
    for (var n, o = e.length - 1, s = 0, a = 0, r = i || ilib.bsearch.numbers; o >= s; ) if (a = Math.floor((o + s) / 2), 
    n = r(e[a], t), n > 0) o = a - 1; else {
        if (!(0 > n)) return a;
        s = a + 1;
    }
    return s;
}, ilib.bsearch.numbers = function(t, e) {
    return t - e;
}, ilib.Date.GregDate = function(t) {
    if (this.cal = new ilib.Cal.Gregorian(), t) {
        if (t.timezone && (this.timezone = t.timezone), t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale, 
        !this.timezone)) {
            var e = new ilib.LocaleInfo(this.locale);
            this.timezone = e.getTimeZone();
        }
        if (t.date !== void 0) {
            var i = t.date;
            i instanceof Date || (i = new Date(i)), this.timezone = "Etc/UTC", this.setTime(i.getTime());
        } else if (t.unixtime !== void 0) this.setTime(parseInt(t.unixtime, 10)); else if (t.julianday !== void 0) this.timezone = "Etc/UTC", 
        this.setJulianDay(parseFloat(t.julianday)); else if (t.year || t.month || t.day || t.hour || t.minute || t.second || t.millisecond) this.year = parseInt(t.year, 10) || 0, 
        this.month = parseInt(t.month, 10) || 1, this.day = parseInt(t.day, 10) || 1, this.hour = parseInt(t.hour, 10) || 0, 
        this.minute = parseInt(t.minute, 10) || 0, this.second = parseInt(t.second, 10) || 0, 
        this.millisecond = parseInt(t.millisecond, 10) || 0; else if (t.rd !== void 0) this.setRd(t.rd); else {
            var n = new Date();
            this.setTime(n.getTime());
        }
    } else {
        var n = new Date();
        this.setTime(n.getTime());
    }
}, ilib.Date.GregDate.prototype = new ilib.Date(), ilib.Date.GregDate.prototype.parent = ilib.Date, 
ilib.Date.GregDate.prototype.constructor = ilib.Date.GregDate, ilib.Date.GregDate.cumMonthLengths = [ 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 ], 
ilib.Date.GregDate.cumMonthLengthsLeap = [ 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366 ], 
ilib.Date.GregDate.epoch = 1721424.5, ilib.Date.GregDate.prototype.calcRataDie = function(t) {
    var e = 365 * (t.year - 1) + Math.floor((t.year - 1) / 4) - Math.floor((t.year - 1) / 100) + Math.floor((t.year - 1) / 400), i = (t.month > 1 ? ilib.Date.GregDate.cumMonthLengths[t.month - 1] : 0) + t.day + (ilib.Cal.Gregorian.prototype.isLeapYear.call(this.cal, t.year) && t.month > 2 ? 1 : 0), n = (36e5 * t.hour + 6e4 * t.minute + 1e3 * t.second + t.millisecond) / 864e5;
    return e + i + n;
}, ilib.Date.GregDate.prototype.getRataDie = function() {
    return this.calcRataDie(this);
}, ilib.Date.GregDate.prototype.calcComponents = function(t) {
    var e, i, n, o, s, a, r, h, l, c, d = {};
    return s = Math.floor((t - 1) / 146097), e = ilib.mod(t - 1, 146097), a = Math.floor(e / 36524), 
    i = ilib.mod(e, 36524), r = Math.floor(i / 1461), n = ilib.mod(i, 1461), h = Math.floor(n / 365), 
    o = ilib.mod(n, 365) + 1, d.year = 400 * s + 100 * a + 4 * r + h, 4 !== a && 4 !== h && d.year++, 
    d.month = 1, d.day = 1, d.hour = 0, d.minute = 0, d.second = 0, d.millisecond = 0, 
    l = t - ilib.Date.GregDate.prototype.calcRataDie.call(this, d) + 1, c = ilib.Cal.Gregorian.prototype.isLeapYear.call(this.cal, d.year) ? ilib.Date.GregDate.cumMonthLengthsLeap : ilib.Date.GregDate.cumMonthLengths, 
    d.month = ilib.bsearch(Math.floor(l), c), l -= c[d.month - 1], d.day = Math.floor(l), 
    l -= d.day, l = Math.round(864e5 * l), d.hour = Math.floor(l / 36e5), l -= 36e5 * d.hour, 
    d.minute = Math.floor(l / 6e4), l -= 6e4 * d.minute, d.second = Math.floor(l / 1e3), 
    l -= 1e3 * d.second, d.millisecond = l, d;
}, ilib.Date.GregDate.prototype.setRd = function(t) {
    var e = this.calcComponents(t);
    this.year = e.year, this.month = e.month, this.day = e.day, this.hour = e.hour, 
    this.minute = e.minute, this.second = e.second, this.millisecond = e.millisecond;
}, ilib.Date.GregDate.prototype.setJulianDay = function(t) {
    var e, i = "number" == typeof t ? new ilib.JulianDay(t) : t;
    e = i.getDate() - ilib.Date.GregDate.epoch, this.setRd(e);
}, ilib.Date.GregDate.prototype.getDayOfWeek = function() {
    var t = Math.floor(this.getRataDie());
    return ilib.mod(t, 7);
}, ilib.Date.GregDate.prototype.onOrBeforeRd = function(t, e) {
    return t - ilib.mod(Math.floor(t) - e, 7);
}, ilib.Date.GregDate.prototype.onOrAfterRd = function(t, e) {
    return this.onOrBeforeRd(t + 6, e);
}, ilib.Date.GregDate.prototype.beforeRd = function(t, e) {
    return this.onOrBeforeRd(t - 1, e);
}, ilib.Date.GregDate.prototype.afterRd = function(t, e) {
    return this.onOrBeforeRd(t + 7, e);
}, ilib.Date.GregDate.prototype.firstSunday = function(t) {
    var e = this.calcRataDie({
        year: t,
        month: 1,
        day: 1,
        hour: 0,
        minute: 0,
        second: 0,
        millisecond: 0
    }), i = this.onOrAfterRd(e, 4);
    return this.beforeRd(i, 0);
}, ilib.Date.GregDate.prototype.before = function(t) {
    return this.cal.newDateInstance({
        rd: this.beforeRd(this.getRataDie(), t)
    });
}, ilib.Date.GregDate.prototype.after = function(t) {
    return this.cal.newDateInstance({
        rd: this.afterRd(this.getRataDie(), t)
    });
}, ilib.Date.GregDate.prototype.onOrBefore = function(t) {
    return this.cal.newDateInstance({
        rd: this.onOrBeforeRd(this.getRataDie(), t)
    });
}, ilib.Date.GregDate.prototype.onOrAfter = function(t) {
    return this.cal.newDateInstance({
        rd: this.onOrAfterRd(this.getRataDie(), t)
    });
}, ilib.Date.GregDate.prototype.getWeekOfYear = function() {
    var t, e = Math.floor(this.getRataDie()), i = this.firstSunday(this.year);
    return i > e ? i = this.firstSunday(this.year - 1) : 12 == this.month && this.day > 25 && (t = this.firstSunday(this.year + 1), 
    e >= t && (i = t)), Math.floor((e - i) / 7) + 1;
}, ilib.Date.GregDate.prototype.getDayOfYear = function() {
    var t = this.cal.isLeapYear(this.year) ? ilib.Date.GregDate.cumMonthLengthsLeap : ilib.Date.GregDate.cumMonthLengths;
    return t[this.month - 1] + this.day;
}, ilib.Date.GregDate.prototype.getWeekOfMonth = function(t) {
    var e = new ilib.LocaleInfo(t), i = this.calcRataDie({
        year: this.year,
        month: this.month,
        day: 1,
        hour: 0,
        minute: 0,
        second: 0,
        millisecond: 0
    }), n = this.getRataDie(), o = this.onOrAfterRd(i, e.getFirstDayOfWeek());
    return o - i > 3 && (o -= 7), Math.floor((n - o) / 7) + 1;
}, ilib.Date.GregDate.prototype.getEra = function() {
    return 1 > this.year ? -1 : 1;
}, ilib.Date.GregDate.prototype.getTime = function() {
    var t = this.calcRataDie({
        year: this.year,
        month: this.month,
        day: this.day,
        hour: this.hour,
        minute: this.minute,
        second: this.second,
        millisecond: 0
    });
    if (719163 > t || t > 744018.134803241) return -1;
    var e = 86400 * Math.floor(t - 719163) + 3600 * this.hour + 60 * this.minute + this.second, i = 1e3 * e + this.millisecond;
    return i;
}, ilib.Date.GregDate.prototype.setTime = function(t) {
    var e = 719163 + t / 864e5;
    this.setRd(e);
}, ilib.Date.GregDate.prototype.getJSDate = function() {
    var t = this.getTime();
    return -1 === t ? void 0 : new Date(t);
}, ilib.Date.GregDate.prototype.getJulianDay = function() {
    return this.getRataDie() + ilib.Date.GregDate.epoch;
}, ilib.Date.GregDate.prototype.getCalendar = function() {
    return "gregorian";
}, ilib.Date.GregDate.prototype.getTimeZone = function() {
    return this.timezone || "local";
}, ilib.Date.GregDate.prototype.setTimeZone = function(t) {
    t && "" !== t ? "string" == typeof t && (this.timezone = t) : this.timezone = void 0;
}, ilib.Date._constructors.gregorian = ilib.Date.GregDate, ilib.TimeZone = function(t) {
    if (this.sync = !0, this.locale = new ilib.Locale(), this.isLocal = !1, t) {
        if (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
        t.id) {
            if ("local" === t.id) {
                this.isLocal = !0;
                var e = new Date(), i = new Date(e.getFullYear(), 0, 1), n = new Date(e.getFullYear(), 5, 1);
                this.offsetJan1 = -i.getTimezoneOffset(), this.offsetJun1 = -n.getTimezoneOffset(), 
                this.offset = Math.max(this.offsetJan1, this.offsetJun1);
            }
            this.id = t.id;
        } else t.offset && (this.offset = "string" == typeof t.offset ? parseInt(t.offset, 10) : t.offset, 
        this.id = this.getDisplayName(void 0, void 0));
        t.sync !== void 0 && (this.sync = t.sync), this.loadParams = t.loadParams, this.onLoad = t.onLoad;
    }
    this.id ? this._loadtzdata() : new ilib.LocaleInfo(this.locale, {
        sync: this.sync,
        onLoad: ilib.bind(this, function(t) {
            this.id = t.getTimeZone() || "Etc/UTC", this._loadtzdata();
        })
    });
}, ilib.data.defaultZones = {
    "Etc/UTC": {
        o: "0:0",
        f: "UTC"
    }
}, ilib.TimeZone.prototype._loadtzdata = function() {
    ilib.data.timezones ? this._initZone() : ilib.loadData({
        object: ilib.TimeZone,
        locale: "-",
        name: "timezones.json",
        sync: this.sync,
        loadParams: this.loadParams,
        callback: ilib.bind(this, function(t) {
            ilib.data.timezones = t || ilib.data.defaultZones, this._initZone();
        })
    });
}, ilib.TimeZone.prototype._initZone = function() {
    this.zone = ilib.data.timezones[this.id], this.zone || void 0 !== this.offset || (this.id = "Etc/UTC", 
    this.zone = ilib.data.timezones[this.id]), this.onLoad && "function" == typeof this.onLoad && this.onLoad(this);
}, ilib.TimeZone.getAvailableIds = function(t) {
    var e, i = [];
    t || i.push("local");
    for (e in ilib.data.timezones) !e || t && ilib.data.timezones[e].c !== t || i.push(e);
    return i;
}, ilib.TimeZone.prototype.getId = function() {
    return this.id;
}, ilib.TimeZone.prototype.getDisplayName = function(t, e) {
    switch (e = this.isLocal || this.zone === void 0 ? "rfc822" : e || "standard") {
      default:
      case "standard":
        if (this.zone.f && "zzz" !== this.zone.f) {
            if (-1 !== this.zone.f.indexOf("{c}")) {
                var i = "";
                i = this.inDaylightTime(t) ? this.zone.s.c : this.zone.e.c;
                var n = new ilib.String(this.zone.f);
                return n.format({
                    c: i || ""
                });
            }
            return this.zone.f;
        }
        var n = "GMT" + this.zone.o;
        return this.inDaylightTime(t) && (n += "+" + this.zone.s.v), n;

      case "rfc822":
        var o = this.getOffset(t), s = "UTC", a = o.h || 0, r = o.m || 0;
        return 0 !== a && (s += a > 0 ? "+" : "-", 10 > Math.abs(a) && (s += "0"), s += 0 > a ? -a : a, 
        10 > r && (s += "0"), s += r), s;

      case "long":
        if (this.zone.n) {
            if (-1 !== this.zone.n.indexOf("{c}")) {
                var h = this.inDaylightTime(t) ? "Daylight" : "Standard", n = new ilib.String(this.zone.n);
                return n.format({
                    c: h || ""
                });
            }
            return this.zone.n;
        }
        var n = "GMT" + this.zone.o;
        return this.inDaylightTime(t) && (n += "+" + this.zone.s.v), n;
    }
}, ilib.TimeZone.prototype._offsetStringToObj = function(t) {
    var e, i = "string" == typeof t ? t.split(":") : [], n = {
        h: 0
    };
    return i.length > 0 && (n.h = parseInt(i[0], 10), i.length > 1 && (e = parseInt(i[1], 10), 
    e && (n.m = e), i.length > 2 && (e = parseInt(i[2], 10), e && (n.s = e)))), n;
}, ilib.TimeZone.prototype.getOffset = function(t) {
    var e = this.getOffsetMillis(t) / 6e4, i = ilib._roundFnc.down(e / 60), n = Math.abs(e) - 60 * Math.abs(i), o = {
        h: i
    };
    return 0 != n && (o.m = n), o;
}, ilib.TimeZone.prototype.getOffsetMillis = function(t) {
    var e;
    if (this.isLocal) {
        var i = t ? new Date(t.getTime()) : new Date();
        return 1e3 * 60 * -i.getTimezoneOffset();
    }
    return this.dstSavings === void 0 && this._calcDSTSavings(), this.offset === void 0 && this._calcOffset(), 
    e = this.offset, t && this.inDaylightTime(t) && (e += this.dstSavings), 1e3 * 60 * e;
}, ilib.TimeZone.prototype.getOffsetStr = function(t) {
    var e, i = this.getOffset(t);
    return e = i.h, i.m !== void 0 ? (e += ":" + i.m, i.s !== void 0 && (e += ":" + i.s)) : e += ":0", 
    e;
}, ilib.TimeZone.prototype.getRawOffset = function() {
    var t = this.getRawOffsetMillis() / 6e4, e = ilib._roundFnc.down(t / 60), i = Math.abs(t) - 60 * Math.abs(e), n = {
        h: e
    };
    return 0 != i && (n.m = i), n;
}, ilib.TimeZone.prototype.getRawOffsetMillis = function() {
    return this.offset === void 0 && this._calcOffset(), 1e3 * 60 * this.offset;
}, ilib.TimeZone.prototype.getRawOffsetStr = function() {
    if (this.isLocal) {
        var t = this.getRawOffset();
        return t.h + ":" + t.m;
    }
    return this.offset !== void 0 ? this.getOffsetStr(void 0) : this.zone && this.zone.o || "0:0";
}, ilib.TimeZone.prototype.getDSTSavings = function() {
    if (this.isLocal) {
        var t = Math.abs(this.offsetJan1 - this.offsetJun1), e = ilib._roundFnc.down(t / 60), i = t - 60 * e;
        return {
            h: e,
            m: i
        };
    }
    return this.zone && this.zone.s ? this._offsetStringToObj(this.zone.s.v) : {
        h: 0
    };
}, ilib.TimeZone.prototype.getDSTSavingsStr = function() {
    if (this.isLocal) {
        var t = this.getDSTSavings();
        return t.h + ":" + t.m;
    }
    return this.offset === void 0 && this.zone && this.zone.s ? this.zone.s.v : "0:0";
}, ilib.TimeZone.prototype._calcRuleStart = function(t, e) {
    var i, n, o, s, a, r, h, l = 0, c = 0, d = 0, u = 0;
    switch ("l" == t.r.charAt(0) || "f" == t.r.charAt(0) ? (s = ilib.Cal.newInstance({
        type: "gregorian"
    }), i = t.r.charAt(0), l = parseInt(t.r.substring(1), 10), n = "l" === i ? s.getMonLength(t.m, e) : 1) : (i = "=", 
    h = t.r.indexOf("<"), -1 == h && (h = t.r.indexOf(">")), -1 != h ? (i = t.r.charAt(h), 
    l = parseInt(t.r.substring(0, h), 10), n = parseInt(t.r.substring(h + 1), 10)) : n = parseInt(t.r, 10)), 
    t.t && (r = t.t.split(":"), c = parseInt(r[0], 10), r.length > 1 && (d = parseInt(r[1], 10), 
    r.length > 2 && (u = parseInt(r[2], 10)))), o = new ilib.Date.GregDate({
        year: e,
        month: t.m,
        day: n,
        hour: c,
        minute: d,
        second: u
    }), a = o.getRataDie(), i) {
      case "l":
      case "<":
        return o.onOrBeforeRd(a, l);

      case "f":
      case ">":
        return o.onOrAfterRd(a, l);

      default:
        return a;
    }
}, ilib.TimeZone.prototype._calcDSTSavings = function() {
    var t = this.getDSTSavings();
    this.dstSavings = (60 * Math.abs(t.h || 0) + (t.m || 0)) * ilib.signum(t.h || 0);
}, ilib.TimeZone.prototype._calcOffset = function() {
    if (this.zone.o) {
        var t = this._offsetStringToObj(this.zone.o);
        this.offset = (60 * Math.abs(t.h || 0) + (t.m || 0)) * ilib.signum(t.h || 0);
    }
}, ilib.TimeZone.prototype.inDaylightTime = function(t) {
    var e, i, n;
    if (!this.useDaylightTime()) return !1;
    if (this.isLocal) {
        var o = new Date(t ? t.getTime() : void 0), s = Math.min(this.offsetJan1, this.offsetJun1);
        return -o.getTimezoneOffset() === s;
    }
    return t || (t = ilib.Date.newInstance()), e = t.getRataDie(), i = this._calcRuleStart(this.zone.s, t.year), 
    n = this._calcRuleStart(this.zone.e, t.year), n > i ? e >= i && n > e ? !0 : !1 : e >= i || n > e ? !0 : !1;
}, ilib.TimeZone.prototype.useDaylightTime = function() {
    return this.isLocal && this.offsetJan1 !== this.offsetJun1 || this.zone !== void 0 && this.zone.s !== void 0 && this.zone.e !== void 0;
}, ilib.TimeZone.prototype.getCountry = function() {
    return this.zone.c;
}, ilib.ResBundle = function(t) {
    var e, i;
    this.locale = new ilib.Locale(), this.baseName = "strings", this.type = "text", 
    this.loadParams = {}, this.missing = "source", this.sync = !0, t && (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    t.name && (this.baseName = t.name), t.type && (this.type = t.type), this.lengthen = t.lengthen || !1, 
    t.sync !== void 0 && (this.sync = 1 == t.sync), t.loadParams !== void 0 && (this.loadParams = t.loadParams), 
    t.missing !== void 0 && ("pseudo" === t.missing || "empty" === t.missing) && (this.missing = t.missing)), 
    this.map = {}, ilib.ResBundle[this.baseName] || (ilib.ResBundle[this.baseName] = {}), 
    e = this.locale.isPseudo() ? new ilib.Locale("en-US") : this.locale, ilib.loadData({
        object: ilib.ResBundle[this.baseName],
        locale: e,
        name: this.baseName + ".json",
        sync: this.sync,
        loadParams: this.loadParams,
        callback: ilib.bind(this, function(n) {
            n || (n = ilib.data[this.baseName] || {}, i = e.getSpec().replace(/-/g, "_"), ilib.ResBundle[this.baseName].cache[i] = n), 
            this.map = n, this.locale.isPseudo() ? (ilib.ResBundle.pseudomap || (ilib.ResBundle.pseudomap = {}), 
            this._loadPseudo(this.locale, t.onLoad)) : "pseudo" === this.missing ? (ilib.ResBundle.pseudomap || (ilib.ResBundle.pseudomap = {}), 
            new ilib.LocaleInfo(this.locale, {
                sync: this.sync,
                loadParams: this.loadParams,
                onLoad: ilib.bind(this, function(e) {
                    var i = new ilib.Locale("zxx", "XX", void 0, e.getDefaultScript());
                    this._loadPseudo(i, t.onLoad);
                })
            })) : t && "function" == typeof t.onLoad && t.onLoad(this);
        })
    });
}, ilib.ResBundle.defaultPseudo = ilib.data.pseudomap || {
    a: "\u00e0",
    e: "\u00eb",
    i: "\u00ed",
    o: "\u00f5",
    u: "\u00fc",
    y: "\u00ff",
    A: "\u00c3",
    E: "\u00cb",
    I: "\u00cf",
    O: "\u00d8",
    U: "\u00da",
    Y: "\u0176"
}, ilib.ResBundle.prototype = {
    _loadPseudo: function(t, e) {
        ilib.loadData({
            object: ilib.ResBundle.pseudomap,
            locale: t,
            name: "pseudomap.json",
            sync: this.sync,
            loadParams: this.loadParams,
            callback: ilib.bind(this, function(i) {
                if (!i || ilib.isEmpty(i)) {
                    i = ilib.ResBundle.defaultPseudo;
                    var n = t.getSpec().replace(/-/g, "_");
                    ilib.ResBundle.pseudomap.cache[n] = i;
                }
                this.pseudomap = i, "function" == typeof e && e(this);
            })
        });
    },
    getLocale: function() {
        return this.locale;
    },
    getName: function() {
        return this.baseName;
    },
    getType: function() {
        return this.type;
    },
    pseudo: function(t) {
        if (!t) return void 0;
        var e, i = "";
        for (e = 0; t.length > e; e++) if ("raw" !== this.type) {
            if ("html" === this.type || "xml" === this.type) if ("<" === t.charAt(e)) {
                for (i += t.charAt(e++); t.length > e && ">" !== t.charAt(e); ) i += t.charAt(e++);
                t.length > e && (i += t.charAt(e++));
            } else if ("&" === t.charAt(e)) {
                for (i += t.charAt(e++); t.length > e && ";" !== t.charAt(e) && " " !== t.charAt(e); ) i += t.charAt(e++);
                t.length > e && (i += t.charAt(e++));
            }
            if (t.length > e) if ("{" === t.charAt(e)) {
                for (i += t.charAt(e++); t.length > e && "}" !== t.charAt(e); ) i += t.charAt(e++);
                t.length > e && (i += t.charAt(e));
            } else i += this.pseudomap[t.charAt(e)] || t.charAt(e);
        } else i += this.pseudomap[t.charAt(e)] || t.charAt(e);
        if (this.lengthen) {
            var n;
            for (n = 20 >= i.length ? Math.round(i.length / 2) : i.length > 20 && 40 >= i.length ? Math.round(i.length / 3) : Math.round(i.length / 5), 
            e = n - 1; e >= 0; e--) i += e % 10;
        }
        return ("Hans" === this.locale.getScript() || "Hant" === this.locale.getScript() || "Hani" === this.locale.getScript() || "Hrkt" === this.locale.getScript() || "Jpan" === this.locale.getScript() || "Hira" === this.locale.getScript() || "Kana" === this.locale.getScript()) && (i = i.replace(/ /g, "")), 
        i;
    },
    escapeXml: function(t) {
        return t = t.replace(/&/g, "&amp;"), t = t.replace(/</g, "&lt;"), t = t.replace(/>/g, "&gt;");
    },
    unescapeXml: function(t) {
        return t = t.replace(/&amp;/g, "&"), t = t.replace(/&lt;/g, "<"), t = t.replace(/&gt;/g, ">");
    },
    makeKey: function(t) {
        var e = t.replace(/\s+/gm, " ");
        return "xml" === this.type || "html" === this.type ? this.unescapeXml(e) : e;
    },
    getString: function(t, e, i) {
        if (!t && !e) return new ilib.String("");
        var n;
        if (this.locale.isPseudo()) {
            var o = t ? t : this.map[e];
            n = this.pseudo(o || e);
        } else {
            var s = e || this.makeKey(t);
            n = this.map[s] !== void 0 ? this.map[s] : "pseudo" === this.missing ? this.pseudo(t || e) : "empty" === this.missing ? "" : t;
        }
        if (i && "none" !== i && ("default" == i && (i = this.type), "xml" === i || "html" === i ? n = this.escapeXml(n) : ("js" == i || "attribute" === i) && (n = n.replace(/'/g, "\\'").replace(/"/g, '\\"'))), 
        void 0 === n) return void 0;
        var a = new ilib.String(n);
        return a.setLocale(this.locale.getSpec(), !0, this.loadParams), a;
    },
    containsKey: function(t, e) {
        if (t === void 0 && e === void 0) return !1;
        var i = e || this.makeKey(t);
        return this.map[i] !== void 0;
    },
    getResObj: function() {
        return this.map;
    }
}, ilib.shallowCopy = function(t, e) {
    var i = void 0;
    if (t && e) for (i in t) void 0 !== i && t[i] && (e[i] = t[i]);
}, ilib.mapString = function(t, e) {
    var i = "";
    if (e && t) for (var n = 0; t.length > n; n++) {
        var o = t.charAt(n);
        i += e[o] || o;
    } else i = t;
    return i;
}, ilib.indexOf = function(t, e) {
    if (!t || !e) return -1;
    if ("function" == typeof t.indexOf) return t.indexOf(e);
    for (var i = 0; t.length > i; i++) if (t[i] === e) return i;
    return -1;
}, ilib.DateFmt = function(t) {
    var e, i, n, o = !0, s = void 0;
    if (this.locale = new ilib.Locale(), this.type = "date", this.length = "s", this.dateComponents = "dmy", 
    this.timeComponents = "ahm", t) {
        if (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
        t.type && ("date" === t.type || "time" === t.type || "datetime" === t.type) && (this.type = t.type), 
        t.calendar && (this.calName = t.calendar), t.length && ("short" === t.length || "medium" === t.length || "long" === t.length || "full" === t.length) && (this.length = t.length.charAt(0)), 
        t.date) {
            for (e = t.date.split(""), e.sort(function(t, e) {
                return e > t ? -1 : t > e ? 1 : 0;
            }), n = !1, i = 0; e.length > i; i++) if ("d" !== e[i] && "m" !== e[i] && "y" !== e[i] && "w" !== e[i] && "n" !== e[i]) {
                n = !0;
                break;
            }
            n || (this.dateComponents = e.join(""));
        }
        if (t.time) {
            for (e = t.time.split(""), e.sort(function(t, e) {
                return e > t ? -1 : t > e ? 1 : 0;
            }), this.badTime = !1, i = 0; e.length > i; i++) if ("h" !== e[i] && "m" !== e[i] && "s" !== e[i] && "a" !== e[i] && "z" !== e[i]) {
                this.badTime = !0;
                break;
            }
            this.badTime || (this.timeComponents = e.join(""));
        }
        !t.clock || "12" !== t.clock && "24" !== t.clock || (this.clock = t.clock), t.template && (this.type = "", 
        this.length = "", this.dateComponents = "", this.timeComponents = "", this.template = t.template), 
        t.timezone ? this.tz = t.timezone instanceof ilib.TimeZone ? t.timezone : new ilib.TimeZone({
            locale: this.locale,
            id: t.timezone
        }) : t.locale && (this.tz = new ilib.TimeZone({
            locale: this.locale
        })), "boolean" == typeof t.useNative && (this.useNative = t.useNative), t.sync !== void 0 && (o = t.sync === !0), 
        s = t.loadParams;
    }
    ilib.DateFmt.cache || (ilib.DateFmt.cache = {}), new ilib.LocaleInfo(this.locale, {
        sync: o,
        onLoad: ilib.bind(this, function(e) {
            this.locinfo = e, this.calName = this.calName || this.locinfo.getCalendar() || "gregorian", 
            this.cal = ilib.Cal.newInstance({
                type: this.calName
            }), this.cal || (this.cal = new ilib.Cal.Gregorian()), new ilib.ResBundle({
                locale: this.locale,
                name: "sysres",
                sync: o,
                onLoad: ilib.bind(this, function(e) {
                    this.sysres = e, this.template ? (this._massageTemplate(), t && "function" == typeof t.onLoad && t.onLoad(this)) : ilib.loadData({
                        object: ilib.DateFmt,
                        locale: this.locale,
                        name: "dateformats.json",
                        sync: o,
                        loadParams: s,
                        callback: ilib.bind(this, function(e) {
                            if (!e) {
                                e = ilib.DateFmt.defaultFmt;
                                var i = this.locale.getSpec().replace(/-/g, "_");
                                ilib.DateFmt.cache[i] = e;
                            }
                            this.clock === void 0 && (this.clock = this.locinfo.getClock()), this._initTemplate(e), 
                            this._massageTemplate(), t && "function" == typeof t.onLoad && t.onLoad(this);
                        })
                    });
                })
            });
        })
    });
}, ilib.DateFmt.lenmap = {
    s: "short",
    m: "medium",
    l: "long",
    f: "full"
}, ilib.DateFmt.zeros = "0000", ilib.DateFmt.defaultFmt = ilib.data.dateformats || {
    gregorian: {
        order: "{date} {time}",
        date: {
            dmwy: "EEE d/MM/yyyy",
            dmy: "d/MM/yyyy",
            dmw: "EEE d/MM",
            dm: "d/MM",
            my: "MM/yyyy",
            dw: "EEE d",
            d: "dd",
            m: "MM",
            y: "yyyy",
            n: "NN",
            w: "EEE"
        },
        time: {
            "12": "h:mm:ssa",
            "24": "H:mm:ss"
        },
        range: {
            c00: "{st} - {et}, {sd}/{sm}/{sy}",
            c01: "{sd}/{sm} {st} - {ed}/{em} {et}, {sy}",
            c02: "{sd}/{sm} {st} - {ed}/{em} {et}, {sy}",
            c03: "{sd}/{sm}/{sy} {st} - {ed}/{em}/{ey} {et}",
            c10: "{sd}-{ed}/{sm}/{sy}",
            c11: "{sd}/{sm} - {ed}/{em} {sy}",
            c12: "{sd}/{sm}/{sy} - {ed}/{em}/{ey}",
            c20: "{sm}/{sy} - {em}/{ey}",
            c30: "{sy} - {ey}"
        }
    },
    islamic: "gregorian",
    hebrew: "gregorian",
    julian: "gregorian",
    buddhist: "gregorian"
}, ilib.DateFmt.monthNameLenMap = {
    "short": "N",
    medium: "NN",
    "long": "MMM",
    full: "MMMM"
}, ilib.DateFmt.weekDayLenMap = {
    "short": "E",
    medium: "EE",
    "long": "EEE",
    full: "EEEE"
}, ilib.DateFmt.prototype = {
    _initTemplate: function(t) {
        if (!t[this.calName]) throw "No formats available for calendar " + this.calName + " in locale " + ("" + this.locale);
        switch (this.formats = t[this.calName], "string" == typeof this.formats && (this.formats = t[this.formats]), 
        this.template = "", this.type) {
          case "datetime":
            this.template = this.formats && this._getLengthFormat(this.formats.order, this.length) || "{date} {time}", 
            this.template = this.template.replace("{date}", this._getFormat(this.formats.date, this.dateComponents, this.length) || ""), 
            this.template = this.template.replace("{time}", this._getFormat(this.formats.time[this.clock], this.timeComponents, this.length) || "");
            break;

          case "date":
            this.template = this._getFormat(this.formats.date, this.dateComponents, this.length);
            break;

          case "time":
            this.template = this._getFormat(this.formats.time[this.clock], this.timeComponents, this.length);
        }
    },
    _massageTemplate: function() {
        var t;
        if (this.clock && this.template) {
            var e = "";
            switch (this.clock) {
              case "24":
                for (t = 0; this.template.length > t; t++) if ("'" == this.template.charAt(t)) {
                    for (e += this.template.charAt(t++); this.template.length > t && "'" !== this.template.charAt(t); ) e += this.template.charAt(t++);
                    this.template.length > t && (e += this.template.charAt(t));
                } else e += "K" == this.template.charAt(t) ? "k" : "h" == this.template.charAt(t) ? "H" : this.template.charAt(t);
                this.template = e;
                break;

              case "12":
                for (t = 0; this.template.length > t; t++) if ("'" == this.template.charAt(t)) {
                    for (e += this.template.charAt(t++); this.template.length > t && "'" !== this.template.charAt(t); ) e += this.template.charAt(t++);
                    this.template.length > t && (e += this.template.charAt(t));
                } else e += "k" == this.template.charAt(t) ? "K" : "H" == this.template.charAt(t) ? "h" : this.template.charAt(t);
                this.template = e;
            }
        }
        this.templateArr = this._tokenize(this.template);
        var i;
        "boolean" == typeof this.useNative ? this.useNative && (i = this.locinfo.getNativeDigits(), 
        i && (this.digits = i)) : "native" === this.locinfo.getDigitsStyle() && (i = this.locinfo.getNativeDigits(), 
        i && (this.useNative = !0, this.digits = i));
    },
    _tokenize: function(t) {
        var e, i, n, o = 0, s = [];
        if (t) for (;t.length > o; ) {
            if (i = t.charAt(o), e = o, "'" === i) {
                for (o++; t.length > o && "'" !== t.charAt(o); ) o++;
                t.length > o && o++;
            } else if (i >= "a" && "z" >= i || i >= "A" && "Z" >= i) for (n = t.charAt(o); t.length > o && i === n; ) i = t.charAt(++o); else for (;t.length > o && "'" !== i && ("a" > i || i > "z") && ("A" > i || i > "Z"); ) i = t.charAt(++o);
            s.push(t.substring(e, o));
        }
        return s;
    },
    _getFormat: function(t, e, i) {
        return e !== void 0 && t[e] ? this._getLengthFormat(t[e], i) : void 0;
    },
    _getLengthFormat: function(t, e) {
        return "string" == typeof t ? t : t[e] ? t[e] : void 0;
    },
    getLocale: function() {
        return this.locale;
    },
    getTemplate: function() {
        return this.template;
    },
    getType: function() {
        return this.type;
    },
    getCalendar: function() {
        return this.cal.getType();
    },
    getLength: function() {
        return ilib.DateFmt.lenmap[this.length] || "";
    },
    getDateComponents: function() {
        return this.dateComponents || "";
    },
    getTimeComponents: function() {
        return this.timeComponents || "";
    },
    getTimeZone: function() {
        return this.tz || (this.tz = new ilib.TimeZone({
            id: ilib.getTimeZone()
        })), this.tz;
    },
    getClock: function() {
        return this.clock || this.locinfo.getClock();
    },
    _getTemplate: function(t, e) {
        return "gregorian" !== e ? t + "-" + e : t;
    },
    getMonthsOfYear: function(t) {
        var e, i, n = t && t.length || this.getLength(), o = ilib.DateFmt.monthNameLenMap[n], s = [ void 0 ];
        t && (t.date && (e = ilib.Date._dateToIlib(t.date)), t.year && (e = ilib.Date.newInstance({
            year: t.year,
            month: 1,
            day: 1,
            type: this.cal.getType()
        }))), e || (e = ilib.Date.newInstance({
            type: this.cal.getType()
        })), i = this.cal.getNumMonths(e.getYears());
        for (var a = 1; i >= a; a++) s[a] = "" + this.sysres.getString(this._getTemplate(o + a, this.cal.getType()));
        return s;
    },
    getDaysOfWeek: function(t) {
        for (var e = t && t.length || this.getLength(), i = ilib.DateFmt.weekDayLenMap[e], n = [], o = 0; 7 > o; o++) n[o] = "" + this.sysres.getString(this._getTemplate(i + o, this.cal.getType()));
        return n;
    },
    toString: function() {
        return this.getTemplate();
    },
    _pad: function(t, e) {
        "string" != typeof t && (t = "" + t);
        var i = 0;
        return "-" === t.charAt(0) && i++, t.length >= e + i ? t : t.substring(0, i) + ilib.DateFmt.zeros.substring(0, e - t.length + i) + t.substring(i);
    },
    _formatTemplate: function(t, e) {
        var i, n, o, s, a = "";
        for (i = 0; e.length > i; i++) switch (e[i]) {
          case "d":
            a += t.day || 1;
            break;

          case "dd":
            a += this._pad(t.day || "1", 2);
            break;

          case "yy":
            o = "" + (t.year || 0) % 100, a += this._pad(o, 2);
            break;

          case "yyyy":
            a += this._pad(t.year || "0", 4);
            break;

          case "M":
            a += t.month || 1;
            break;

          case "MM":
            a += this._pad(t.month || "1", 2);
            break;

          case "h":
            o = (t.hour || 0) % 12, 0 == o && (o = "12"), a += o;
            break;

          case "hh":
            o = (t.hour || 0) % 12, 0 == o && (o = "12"), a += this._pad(o, 2);
            break;

          case "K":
            o = (t.hour || 0) % 12, a += o;
            break;

          case "KK":
            o = (t.hour || 0) % 12, a += this._pad(o, 2);
            break;

          case "H":
            a += t.hour || "0";
            break;

          case "HH":
            a += this._pad(t.hour || "0", 2);
            break;

          case "k":
            a += 0 == t.hour ? "24" : t.hour;
            break;

          case "kk":
            o = 0 == t.hour ? "24" : t.hour, a += this._pad(o, 2);
            break;

          case "m":
            a += t.minute || "0";
            break;

          case "mm":
            a += this._pad(t.minute || "0", 2);
            break;

          case "s":
            a += t.minute || "0";
            break;

          case "ss":
            a += this._pad(t.second || "0", 2);
            break;

          case "S":
            a += t.millisecond || "0";
            break;

          case "SSS":
            a += this._pad(t.millisecond || "0", 3);
            break;

          case "N":
          case "NN":
          case "MMM":
          case "MMMM":
            n = e[i] + (t.month || 1), a += this.sysres.getString(void 0, n + "-" + this.calName) || this.sysres.getString(void 0, n);
            break;

          case "E":
          case "EE":
          case "EEE":
          case "EEEE":
            n = e[i] + t.getDayOfWeek(), a += this.sysres.getString(void 0, n + "-" + this.calName) || this.sysres.getString(void 0, n);
            break;

          case "a":
            n = "zh" === this.locale.getLanguage() ? 6 > t.hour ? "azh0" : 9 > t.hour ? "azh1" : 12 > t.hour ? "azh2" : 13 > t.hour ? "azh3" : 18 > t.hour ? "azh4" : 21 > t.hour ? "azh5" : "azh6" : 12 > t.hour ? "a0" : "a1", 
            a += this.sysres.getString(void 0, n + "-" + this.calName) || this.sysres.getString(void 0, n);
            break;

          case "w":
            a += t.getWeekOfYear();
            break;

          case "ww":
            a += this._pad(t.getWeekOfYear(), 2);
            break;

          case "D":
            a += t.getDayOfYear();
            break;

          case "DD":
            a += this._pad(t.getDayOfYear(), 2);
            break;

          case "DDD":
            a += this._pad(t.getDayOfYear(), 3);
            break;

          case "W":
            a += t.getWeekOfMonth(this.locale);
            break;

          case "G":
            n = "G" + t.getEra(), a += this.sysres.getString(void 0, n + "-" + this.calName) || this.sysres.getString(void 0, n);
            break;

          case "O":
            o = this.sysres.getString("1#1st|2#2nd|3#3rd|21#21st|22#22nd|23#23rd|31#31st|#{num}th", "ordinalChoice"), 
            a += o.formatChoice(t.day, {
                num: t.day
            });
            break;

          case "z":
            s = this.getTimeZone(), a += s.getDisplayName(t, "standard");
            break;

          case "Z":
            s = this.getTimeZone(), a += s.getDisplayName(t, "rfc822");
            break;

          default:
            a += e[i].replace(/'/g, "");
        }
        return this.digits && (a = ilib.mapString(a, this.digits)), a;
    },
    format: function(t) {
        var e = ilib.Date._dateToIlib(t);
        if (!e.getCalendar || e.getCalendar() !== this.calName) throw "Wrong date type passed to ilib.DateFmt.format()";
        var i = this.tz && this.tz.getId() || "local", n = e.timezone || "local";
        if (n !== i) {
            var o = new ilib.TimeZone({
                locale: e.locale,
                id: n
            }), s = this.tz || new ilib.TimeZone({
                locale: e.locale,
                id: i
            }), a = o.getOffset(e), r = s.getOffset(e), h = 60 * 60 * (a.h || 0) + 60 * (a.m || 0) + (a.s || 0) - (60 * 60 * (r.h || 0) + 60 * (r.m || 0) + (r.s || 0)), l = ilib.Date.newInstance({
                type: this.calName,
                rd: e.getRataDie() - h / 86400
            });
            e = l;
        }
        return this._formatTemplate(e, this.templateArr);
    },
    formatRelative: function(t, e) {
        t = ilib.Date._dateToIlib(t), e = ilib.Date._dateToIlib(e);
        var i, n, o, s, a, r;
        if ("object" != typeof t || !t.getCalendar || t.getCalendar() !== this.calName || "object" != typeof e || !e.getCalendar || e.getCalendar() !== this.calName) throw "Wrong calendar type";
        if (i = t.getRataDie(), n = e.getRataDie(), i > n ? (a = i - n, o = this.sysres.getString("{duration} ago")) : (a = n - i, 
        o = this.sysres.getString("in {duration}")), 694444e-9 > a) switch (r = Math.round(86400 * a), 
        this.length) {
          case "s":
            s = this.sysres.getString("#{num}s");
            break;

          case "m":
            s = this.sysres.getString("1#1 se|#{num} sec");
            break;

          case "l":
            s = this.sysres.getString("1#1 sec|#{num} sec");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 second|#{num} seconds");
        } else if (.041666667 > a) switch (r = Math.round(1440 * a), this.length) {
          case "s":
            s = this.sysres.getString("#{num}m", "durationShortMinutes");
            break;

          case "m":
            s = this.sysres.getString("1#1 mi|#{num} min");
            break;

          case "l":
            s = this.sysres.getString("1#1 min|#{num} min");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 minute|#{num} minutes");
        } else if (1 > a) switch (r = Math.round(24 * a), this.length) {
          case "s":
            s = this.sysres.getString("#{num}h");
            break;

          case "m":
            s = this.sysres.getString("1#1 hr|#{num} hrs", "durationMediumHours");
            break;

          case "l":
            s = this.sysres.getString("1#1 hr|#{num} hrs");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 hour|#{num} hours");
        } else if (14 > a) switch (r = Math.round(a), this.length) {
          case "s":
            s = this.sysres.getString("#{num}d");
            break;

          case "m":
            s = this.sysres.getString("1#1 dy|#{num} dys");
            break;

          case "l":
            s = this.sysres.getString("1#1 day|#{num} days", "durationLongDays");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 day|#{num} days");
        } else if (84 > a) switch (r = Math.round(a / 7), this.length) {
          case "s":
            s = this.sysres.getString("#{num}w");
            break;

          case "m":
            s = this.sysres.getString("1#1 wk|#{num} wks", "durationMediumWeeks");
            break;

          case "l":
            s = this.sysres.getString("1#1 wk|#{num} wks");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 week|#{num} weeks");
        } else if (730 > a) switch (r = Math.round(a / 30.4), this.length) {
          case "s":
            s = this.sysres.getString("#{num}m", "durationShortMonths");
            break;

          case "m":
            s = this.sysres.getString("1#1 mo|#{num} mos");
            break;

          case "l":
            s = this.sysres.getString("1#1 mon|#{num} mons");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 month|#{num} months");
        } else switch (r = Math.round(a / 365), this.length) {
          case "s":
            s = this.sysres.getString("#{num}y");
            break;

          case "m":
            s = this.sysres.getString("1#1 yr|#{num} yrs", "durationMediumYears");
            break;

          case "l":
            s = this.sysres.getString("1#1 yr|#{num} yrs");
            break;

          default:
          case "f":
            s = this.sysres.getString("1#1 year|#{num} years");
        }
        return o.format({
            duration: s.formatChoice(r, {
                num: r
            })
        });
    }
}, ilib.DateRngFmt = function(t) {
    var e = !0, i = void 0;
    this.locale = new ilib.Locale(), this.length = "s", t && (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    t.length && ("short" === t.length || "medium" === t.length || "long" === t.length || "full" === t.length) && (this.length = t.length.charAt(0)), 
    t.sync !== void 0 && (e = 1 == t.sync), i = t.loadParams);
    var n = {};
    ilib.shallowCopy(t, n), n.sync = e, n.loadParams = i, n.onLoad = ilib.bind(this, function(e) {
        this.dateFmt = e, e && (this.locinfo = this.dateFmt.locinfo, this.calName = this.calName || this.locinfo.getCalendar() || "gregorian", 
        this.cal = ilib.Cal.newInstance({
            type: this.calName
        }), this.cal || (this.cal = new ilib.Cal.Gregorian()), this.timeTemplate = this.dateFmt._getFormat(this.dateFmt.formats.time[this.dateFmt.clock], this.dateFmt.timeComponents, this.length) || "hh:mm", 
        this.timeTemplateArr = this.dateFmt._tokenize(this.timeTemplate), t && "function" == typeof t.onLoad && t.onLoad(this));
    }), new ilib.DateFmt(n);
}, ilib.DateRngFmt.prototype = {
    getLocale: function() {
        return this.locale;
    },
    getCalendar: function() {
        return this.dateFmt.getCalendar();
    },
    getLength: function() {
        return ilib.DateFmt.lenmap[this.length] || "";
    },
    getTimeZone: function() {
        return this.dateFmt.getTimeZone();
    },
    getClock: function() {
        return this.dateFmt.getClock();
    },
    format: function(t, e) {
        var i, n, o, s, a, r = "";
        if ("object" != typeof t || !t.getCalendar || t.getCalendar() !== this.calName || "object" != typeof e || !e.getCalendar || e.getCalendar() !== this.calName) throw "Wrong calendar type";
        return i = t.getRataDie(), n = e.getRataDie(), r = 3 > n - i ? t.year === e.year ? t.month === e.month ? t.day === e.day ? new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c00", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c01", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c02", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c03", this.length)) : 730 > n - i ? t.year === e.year ? t.month === e.month ? new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c10", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c11", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c12", this.length)) : 3650 > n - i ? new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c20", this.length)) : new ilib.String(this.dateFmt._getFormat(this.dateFmt.formats.range, "c30", this.length)), 
        o = this.dateFmt._tokenize(this.dateFmt._getFormat(this.dateFmt.formats.date, "y", this.length) || "yyyy"), 
        s = this.dateFmt._tokenize(this.dateFmt._getFormat(this.dateFmt.formats.date, "m", this.length) || "MM"), 
        a = this.dateFmt._tokenize(this.dateFmt._getFormat(this.dateFmt.formats.date, "d", this.length) || "dd"), 
        r.format({
            sy: this.dateFmt._formatTemplate(t, o),
            sm: this.dateFmt._formatTemplate(t, s),
            sd: this.dateFmt._formatTemplate(t, a),
            st: this.dateFmt._formatTemplate(t, this.timeTemplateArr),
            ey: this.dateFmt._formatTemplate(e, o),
            em: this.dateFmt._formatTemplate(e, s),
            ed: this.dateFmt._formatTemplate(e, a),
            et: this.dateFmt._formatTemplate(e, this.timeTemplateArr)
        });
    }
}, ilib.Cal.ThaiSolar = function() {
    this.type = "thaisolar";
}, ilib.Cal.ThaiSolar.prototype = new ilib.Cal.Gregorian(), ilib.Cal.ThaiSolar.prototype.parent = ilib.Cal.Gregorian, 
ilib.Cal.ThaiSolar.prototype.constructor = ilib.Cal.ThaiSolar, ilib.Cal.ThaiSolar.prototype.isLeapYear = function(t) {
    var e = "number" == typeof t ? t : t.getYears();
    e -= 543;
    var i = ilib.mod(e, 400);
    return 0 === ilib.mod(e, 4) && 100 !== i && 200 !== i && 300 !== i;
}, ilib.Cal.ThaiSolar.prototype.newDateInstance = function(t) {
    return new ilib.Date.ThaiSolarDate(t);
}, ilib.Cal._constructors.thaisolar = ilib.Cal.ThaiSolar, ilib.Date.ThaiSolarDate = function(t) {
    ilib.Date.GregDate.call(this, t), this.cal = new ilib.Cal.ThaiSolar();
}, ilib.Date.ThaiSolarDate.prototype = new ilib.Date.GregDate(), ilib.Date.ThaiSolarDate.prototype.parent = ilib.Date.GregDate.prototype, 
ilib.Date.ThaiSolarDate.prototype.constructor = ilib.Date.ThaiSolarDate, ilib.Date.ThaiSolarDate.epoch = 1523097.5, 
ilib.Date.ThaiSolarDate.prototype.calcRataDie = function(t) {
    var e = this.parent.calcRataDie.call(this, {
        year: t.year - 543,
        month: t.month,
        day: t.day,
        hour: t.hour,
        minute: t.minute,
        second: t.second,
        millisecond: t.millisecond
    });
    return e + 198327;
}, ilib.Date.ThaiSolarDate.prototype.calcComponents = function(t) {
    var e = this.parent.calcComponents.call(this, t - 198327);
    return e.year += 543, e;
}, ilib.Date.ThaiSolarDate.prototype.setJulianDay = function(t) {
    var e, i = "number" == typeof t ? new ilib.JulianDay(t) : t;
    e = i.getDate() - ilib.Date.ThaiSolarDate.epoch, this.setRd(e);
}, ilib.Date.ThaiSolarDate.prototype.getDayOfWeek = function() {
    var t = Math.floor(this.getRataDie() - 198327);
    return ilib.mod(t, 7);
}, ilib.Date.ThaiSolarDate.prototype.onOrBeforeRd = function(t, e) {
    return t - ilib.mod(Math.floor(t - 198327) - e, 7);
}, ilib.Date.ThaiSolarDate.prototype.getTime = function() {
    var t = this.calcRataDie({
        year: this.year,
        month: this.month,
        day: this.day,
        hour: this.hour,
        minute: this.minute,
        second: this.second,
        millisecond: 0
    });
    if (917490 > t || t > 942345.134803241) return -1;
    var e = 86400 * Math.floor(t - 917490) + 3600 * this.hour + 60 * this.minute + this.second, i = 1e3 * e + this.millisecond;
    return i;
}, ilib.Date.ThaiSolarDate.prototype.setTime = function(t) {
    var e = 917490 + t / 864e5;
    this.setRd(e);
}, ilib.Date.ThaiSolarDate.prototype.getJulianDay = function() {
    return this.getRataDie() + ilib.Date.ThaiSolarDate.epoch;
}, ilib.Date.ThaiSolarDate.prototype.getCalendar = function() {
    return "thaisolar";
}, ilib.Date._constructors.thaisolar = ilib.Date.ThaiSolarDate, ilib.CType = {
    _inRange: function(t, e, i) {
        var n, o, s;
        if (!t || 0 === t.length || !e || i === void 0) return !1;
        if (s = new ilib.String(t).codePointAt(0), n = i[e], !n) return !1;
        for (o = 0; n.length > o; o++) if (1 === n[o].length) {
            if (s === n[o][0]) return !0;
        } else if (s >= n[o][0] && n[o][1] >= s) return !0;
        return !1;
    },
    withinRange: function(t, e) {
        return e ? ilib.CType._inRange(t, e.toLowerCase(), ilib.data.ctype) : !1;
    },
    _init: function(t, e, i) {
        ilib.CType._load("ctype", t, e, i);
    },
    _load: function(t, e, i, n) {
        if (ilib.data[t]) n && "function" == typeof n && n(ilib.data[t]); else {
            var o = t ? t + ".json" : "ctype.json";
            ilib.loadData({
                name: o,
                locale: "-",
                sync: e,
                loadParams: i,
                callback: ilib.bind(this, function(e) {
                    ilib.data[t] = e, n && "function" == typeof n && n(ilib.data[t]);
                })
            });
        }
    }
}, ilib.CType.isDigit = function(t) {
    return ilib.CType._inRange(t, "digit", ilib.data.ctype);
}, ilib.CType.isDigit._init = function(t, e, i) {
    ilib.CType._init(t, e, i);
}, ilib.CType.isSpace = function(t) {
    return ilib.CType._inRange(t, "space", ilib.data.ctype) || ilib.CType._inRange(t, "Zs", ilib.data.ctype_z) || ilib.CType._inRange(t, "Zl", ilib.data.ctype_z) || ilib.CType._inRange(t, "Zp", ilib.data.ctype_z);
}, ilib.CType.isSpace._init = function(t, e, i) {
    ilib.CType._load("ctype_z", t, e, function() {
        ilib.CType._init(t, e, i);
    });
}, ilib.Number = function(t, e) {
    var i, n, o, s = "", a = !0;
    if (this.locale = new ilib.Locale(), this.type = "number", e) {
        if (e.locale && (this.locale = "string" == typeof e.locale ? new ilib.Locale(e.locale) : e.locale), 
        e.type) switch (e.type) {
          case "number":
          case "currency":
          case "percentage":
            this.type = e.type;
            break;

          default:        }
        e.sync !== void 0 && (a = 1 == e.sync), n = e.loadParams, o = e.onLoad;
    }
    ilib.CType.isDigit._init(a, n, ilib.bind(this, function() {
        ilib.CType.isSpace._init(a, n, ilib.bind(this, function() {
            new ilib.LocaleInfo(this.locale, {
                sync: a,
                onLoad: ilib.bind(this, function(n) {
                    switch (this.decimal = n.getDecimalSeparator(), typeof t) {
                      case "string":
                        var o = !0;
                        for (this.str = t || "0", i = 0, i = 0; this.str.length > i; i++) o && "-" === this.str.charAt(i) ? (o = !1, 
                        s += this.str.charAt(i)) : ilib.CType.isDigit(this.str.charAt(i)) ? (s += this.str.charAt(i), 
                        o = !1) : this.str.charAt(i) === this.decimal && (s += ".", o = !1);
                        this.value = parseFloat(s);
                        break;

                      case "number":
                        this.str = "" + t, this.value = t;
                        break;

                      case "object":
                        this.value = t.valueOf(), this.str = "" + this.value;
                        break;

                      case "undefined":
                        this.value = 0, this.str = "0";
                    }
                    switch (this.type) {
                      default:
                        break;

                      case "percentage":
                        -1 !== this.str.indexOf(n.getPercentageSymbol()) && (this.value /= 100);
                        break;

                      case "currency":
                        for (s = "", i = 0; this.str.length > i && !ilib.CType.isDigit(this.str.charAt(i)) && !ilib.CType.isSpace(this.str.charAt(i)); ) s += this.str.charAt(i++);
                        if (0 === s.length) {
                            for (;this.str.length > i && ilib.CType.isDigit(this.str.charAt(i)) || ilib.CType.isSpace(this.str.charAt(i)) || "." === this.str.charAt(i) || "," === this.str.charAt(i); ) i++;
                            for (;this.str.length > i && !ilib.CType.isDigit(this.str.charAt(i)) && !ilib.CType.isSpace(this.str.charAt(i)); ) s += this.str.charAt(i++);
                        }
                        return new ilib.Currency({
                            locale: this.locale,
                            sign: s,
                            sync: a,
                            onLoad: ilib.bind(this, function(t) {
                                this.currency = t, e && "function" == typeof e.onLoad && e.onLoad(this);
                            })
                        }), void 0;
                    }
                    e && "function" == typeof e.onLoad && e.onLoad(this);
                })
            });
        }));
    }));
}, ilib.Number.prototype = {
    getLocale: function() {
        return this.locale;
    },
    toString: function() {
        return this.str;
    },
    getCurrency: function() {
        return this.currency;
    },
    valueOf: function() {
        return this.value;
    }
}, ilib.Currency = function(t) {
    this.sync = !0, t && (t.code && (this.code = t.code), t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    t.sign && (this.sign = t.sign), t.sync !== void 0 && (this.sync = t.sync), t.loadParams && (this.loadParams = t.loadParams)), 
    this.locale = this.locale || new ilib.Locale(), ilib.data.currency === void 0 ? ilib.loadData({
        name: "currency.json",
        object: ilib.Currency,
        locale: "-",
        sync: this.sync,
        loadParams: this.loadParams,
        callback: ilib.bind(this, function(e) {
            ilib.data.currency = e, this._loadLocinfo(t && t.onLoad);
        })
    }) : this._loadLocinfo(t && t.onLoad);
}, ilib.Currency.getAvailableCurrencies = function() {
    var t, e = [], i = new ilib.ResBundle({
        name: "currency"
    }).getResObj();
    for (t in i) t && i[t] && e.push(t);
    return e;
}, ilib.Currency.prototype = {
    _loadLocinfo: function(t) {
        new ilib.LocaleInfo(this.locale, {
            onLoad: ilib.bind(this, function(e) {
                var i;
                if (this.locinfo = e, this.code) {
                    if (i = ilib.data.currency[this.code], !i) throw "currency " + this.code + " is unknown";
                } else if (this.sign) if (i = ilib.data.currency[this.sign], i !== void 0) this.code = this.sign; else if (this.code = this.locinfo.getCurrency(), 
                i = ilib.data.currency[this.code], i.sign !== this.sign) for (var n in ilib.data.currency) if (n && ilib.data.currency[n] && (i = ilib.data.currency[n], 
                i.sign === this.sign)) {
                    this.code = n;
                    break;
                }
                i && this.code || (this.code = this.locinfo.getCurrency(), i = ilib.data.currency[this.code]), 
                this.name = i.name, this.fractionDigits = i.decimals, this.sign = i.sign, "function" == typeof t && t(this);
            })
        });
    },
    getCode: function() {
        return this.code;
    },
    getFractionDigits: function() {
        return this.fractionDigits;
    },
    getSign: function() {
        return this.sign;
    },
    getName: function() {
        return this.name;
    },
    getLocale: function() {
        return this.locale;
    }
}, ilib.NumFmt = function(t) {
    var e = !0;
    this.locale = new ilib.Locale(), this.type = "number", t && (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    t.type && ("number" === t.type || "currency" === t.type || "percentage" === t.type) && (this.type = t.type), 
    t.currency && (this.currency = t.currency), "number" == typeof t.maxFractionDigits && (this.maxFractionDigits = this._toPrimitive(t.maxFractionDigits)), 
    "number" == typeof t.minFractionDigits && (this.minFractionDigits = this._toPrimitive(t.minFractionDigits)), 
    t.style && (this.style = t.style), "boolean" == typeof t.useNative && (this.useNative = t.useNative), 
    this.roundingMode = t.roundingMode, t.sync !== void 0 && (e = 1 == t.sync)), this.localeInfo = void 0, 
    new ilib.LocaleInfo(this.locale, {
        sync: e,
        onLoad: ilib.bind(this, function(i) {
            if (this.localeInfo = i, "number" === this.type) this.templateNegative = new ilib.String(this.localeInfo.getNegativeNumberFormat() || "-{n}"); else {
                if ("currency" === this.type) {
                    var n;
                    if (!this.currency || "string" != typeof this.currency) throw "A currency property is required in the options to the number formatter constructor when the type property is set to currency.";
                    return new ilib.Currency({
                        locale: this.locale,
                        code: this.currency,
                        sync: e,
                        onLoad: ilib.bind(this, function(e) {
                            this.currencyInfo = e, "common" !== this.style && "iso" !== this.style && (this.style = "common"), 
                            "number" != typeof this.maxFractionDigits && "number" != typeof this.minFractionDigits && (this.minFractionDigits = this.maxFractionDigits = this.currencyInfo.getFractionDigits()), 
                            n = this.localeInfo.getCurrencyFormats(), this.template = new ilib.String(n[this.style] || n.common), 
                            this.templateNegative = new ilib.String(n[this.style + "Negative"] || n.commonNegative), 
                            this.sign = "iso" === this.style ? this.currencyInfo.getCode() : this.currencyInfo.getSign(), 
                            this.roundingMode || (this.roundingMode = this.currencyInfo && this.currencyInfo.roundingMode), 
                            this._init(), t && "function" == typeof t.onLoad && t.onLoad(this);
                        })
                    }), void 0;
                }
                "percentage" === this.type && (this.template = new ilib.String(this.localeInfo.getPercentageFormat() || "{n}%"), 
                this.templateNegative = new ilib.String(this.localeInfo.getNegativePercentageFormat() || this.localeInfo.getNegativeNumberFormat() + "%"));
            }
            this._init(), t && "function" == typeof t.onLoad && t.onLoad(this);
        })
    });
}, ilib.NumFmt.getAvailableLocales = function() {
    return void 0;
}, ilib.NumFmt.zeros = "0000000000000000000000000000000000000000000000000000000000000000000000", 
ilib.NumFmt.prototype = {
    getUseNative: function() {
        return "boolean" == typeof this.useNative ? this.useNative : "native" === this.localeInfo.getDigitsStyle();
    },
    _init: function() {
        if (this.maxFractionDigits < this.minFractionDigits && (this.minFractionDigits = this.maxFractionDigits), 
        this.roundingMode || (this.roundingMode = this.localeInfo.getRoundingMode()), this.roundingMode || (this.roundingMode = "halfdown"), 
        this.round = ilib._roundFnc[this.roundingMode], this.round || (this.roundingMode = "halfdown", 
        this.round = ilib._roundFnc[this.roundingMode]), this.prigroupSize = this.localeInfo.getPrimaryGroupingDigits(), 
        this.secgroupSize = this.localeInfo.getSecondaryGroupingDigits(), this.groupingSeparator = this.getUseNative() ? this.localeInfo.getNativeGroupingSeparator() : this.localeInfo.getGroupingSeparator(), 
        this.decimalSeparator = this.getUseNative() ? this.localeInfo.getNativeDecimalSeparator() : this.localeInfo.getDecimalSeparator(), 
        this.getUseNative()) {
            var t = this.localeInfo.getNativeDigits() || this.localeInfo.getDigits();
            t && (this.digits = t.split(""));
        }
        this.exponentSymbol = this.localeInfo.getExponential() || "e";
    },
    _pad: function(t, e, i) {
        return t.length >= e ? t : i ? ilib.NumFmt.zeros.substring(0, e - t.length) + t : t + ilib.NumFmt.zeros.substring(0, e - t.length);
    },
    _toPrimitive: function(t) {
        var e = 0;
        switch (typeof t) {
          case "number":
            e = t;
            break;

          case "string":
            e = parseFloat(t);
            break;

          case "object":
            e = t.valueOf();
        }
        return e;
    },
    _formatScientific: function(t) {
        var e, i = new Number(t);
        if (this.maxFractionDigits !== void 0) {
            var n, o, s = i.toExponential(), a = s.split("e"), r = a[0];
            n = a[1], o = Math.pow(10, this.maxFractionDigits), r = this.round(r * o) / o, e = "" + r + this.exponentSymbol + n;
        } else e = i.toExponential(this.minFractionDigits), "e" !== this.exponentSymbol && (e = e.replace(/e/, this.exponentSymbol));
        return e;
    },
    _formatStandard: function(t) {
        var e, i;
        if (this.maxFractionDigits !== void 0 && this.maxFractionDigits > -1) {
            var n = Math.pow(10, this.maxFractionDigits);
            t = this.round(t * n) / n;
        }
        t = Math.abs(t);
        var o, s, a = ("" + t).split("."), r = a[0], h = a[1];
        if (r = "" + r, this.minFractionDigits > 0 && (h = this._pad(h || "", this.minFractionDigits, !1)), 
        this.secgroupSize > 0) {
            if (r.length > this.prigroupSize) {
                var l = this.prigroupSize, c = r.length, d = c - l;
                r = r.slice(0, d) + this.groupingSeparator + r.slice(d);
                var u = r.substring(0, r.indexOf(this.groupingSeparator));
                for (i = u.length; i > this.secgroupSize; ) {
                    var p = this.secgroupSize, g = u.length, m = g - p;
                    r = r.slice(0, m) + this.groupingSeparator + r.slice(m), u = r.substring(0, r.indexOf(this.groupingSeparator)), 
                    i = u.length;
                }
            }
            s = r;
        } else if (0 !== this.prigroupSize) {
            for (o = ilib.mod(r.length - 1, this.prigroupSize), s = "", e = 0; r.length - 1 > e; e++) s += r.charAt(e), 
            0 === o && (s += this.groupingSeparator), o = ilib.mod(o - 1, this.prigroupSize);
            s += r.charAt(r.length - 1);
        } else s = r;
        return h && (this.maxFractionDigits === void 0 || this.maxFractionDigits > 0) && (s += this.decimalSeparator, 
        s += h), this.digits && (s = ilib.mapString(s, this.digits)), s;
    },
    format: function(t) {
        var e, i;
        if (t === void 0) return "";
        if (i = this._toPrimitive(t), "number" === this.type) e = "scientific" === this.style ? this._formatScientific(i) : this._formatStandard(i), 
        0 > t && (e = this.templateNegative.format({
            n: e
        })); else {
            e = this._formatStandard(i);
            var n = 0 > i ? this.templateNegative : this.template;
            e = n.format({
                n: e,
                s: this.sign
            });
        }
        return e;
    },
    getType: function() {
        return this.type;
    },
    getLocale: function() {
        return this.locale;
    },
    isGroupingUsed: function() {
        return "undefined" !== this.groupingSeparator && this.groupingSeparator.length > 0;
    },
    getMaxFractionDigits: function() {
        return this.maxFractionDigits !== void 0 ? this.maxFractionDigits : -1;
    },
    getMinFractionDigits: function() {
        return this.minFractionDigits !== void 0 ? this.minFractionDigits : -1;
    },
    getCurrency: function() {
        return this.currencyInfo && this.currencyInfo.getCode();
    },
    getRoundingMode: function() {
        return this.roundingMode;
    },
    getStyle: function() {
        return this.style;
    }
}, ilib.DurFmt = function(t) {
    var e = !0, i = void 0;
    this.locale = new ilib.Locale(), this.length = "short", this.style = "text", t && (t.locale && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    t.length && ("short" === t.length || "medium" === t.length || "long" === t.length || "full" === t.length) && (this.length = t.length), 
    t.style && ("text" === t.style || "clock" === t.style) && (this.style = t.style), 
    t.sync !== void 0 && (e = 1 == t.sync), "boolean" == typeof t.useNative && (this.useNative = t.useNative), 
    i = t.loadParams), new ilib.ResBundle({
        locale: this.locale,
        name: "sysres",
        sync: e,
        loadParams: i,
        onLoad: ilib.bind(this, function(n) {
            switch (this.length) {
              case "short":
                this.components = {
                    year: n.getString("#{num}y"),
                    month: n.getString("#{num}m", "durationShortMonths"),
                    week: n.getString("#{num}w"),
                    day: n.getString("#{num}d"),
                    hour: n.getString("#{num}h"),
                    minute: n.getString("#{num}m", "durationShortMinutes"),
                    second: n.getString("#{num}s"),
                    millisecond: n.getString("#{num}m", "durationShortMillis"),
                    separator: n.getString(" ", "separatorShort"),
                    finalSeparator: ""
                };
                break;

              case "medium":
                this.components = {
                    year: n.getString("1#1 yr|#{num} yrs", "durationMediumYears"),
                    month: n.getString("1#1 mo|#{num} mos"),
                    week: n.getString("1#1 wk|#{num} wks", "durationMediumWeeks"),
                    day: n.getString("1#1 dy|#{num} dys"),
                    hour: n.getString("1#1 hr|#{num} hrs", "durationMediumHours"),
                    minute: n.getString("1#1 mi|#{num} min"),
                    second: n.getString("1#1 se|#{num} sec"),
                    millisecond: n.getString("#{num} ms"),
                    separator: n.getString(" ", "separatorMedium"),
                    finalSeparator: ""
                };
                break;

              case "long":
                this.components = {
                    year: n.getString("1#1 yr|#{num} yrs"),
                    month: n.getString("1#1 mon|#{num} mons"),
                    week: n.getString("1#1 wk|#{num} wks"),
                    day: n.getString("1#1 day|#{num} days", "durationLongDays"),
                    hour: n.getString("1#1 hr|#{num} hrs"),
                    minute: n.getString("1#1 min|#{num} min"),
                    second: n.getString("1#1 sec|#{num} sec"),
                    millisecond: n.getString("#{num} ms"),
                    separator: n.getString(", ", "separatorLong"),
                    finalSeparator: ""
                };
                break;

              case "full":
                this.components = {
                    year: n.getString("1#1 year|#{num} years"),
                    month: n.getString("1#1 month|#{num} months"),
                    week: n.getString("1#1 week|#{num} weeks"),
                    day: n.getString("1#1 day|#{num} days"),
                    hour: n.getString("1#1 hour|#{num} hours"),
                    minute: n.getString("1#1 minute|#{num} minutes"),
                    second: n.getString("1#1 second|#{num} seconds"),
                    millisecond: n.getString("1#1 millisecond|#{num} milliseconds"),
                    separator: n.getString(", ", "separatorFull"),
                    finalSeparator: n.getString(" and ", "finalSeparatorFull")
                };
            }
            return "clock" === this.style ? (new ilib.DateFmt({
                locale: this.locale,
                type: "time",
                time: "ms",
                sync: e,
                loadParams: i,
                useNative: this.useNative,
                onLoad: ilib.bind(this, function(n) {
                    this.timeFmtMS = n, new ilib.DateFmt({
                        locale: this.locale,
                        type: "time",
                        time: "hm",
                        sync: e,
                        loadParams: i,
                        useNative: this.useNative,
                        onLoad: ilib.bind(this, function(n) {
                            this.timeFmtHM = n, new ilib.DateFmt({
                                locale: this.locale,
                                type: "time",
                                time: "hms",
                                sync: e,
                                loadParams: i,
                                useNative: this.useNative,
                                onLoad: ilib.bind(this, function(e) {
                                    this.timeFmtHMS = e, this.timeFmtHM.template = this.timeFmtHM.template.replace(/hh?/, "H"), 
                                    this.timeFmtHM.templateArr = this.timeFmtHM._tokenize(this.timeFmtHM.template), 
                                    this.timeFmtHMS.template = this.timeFmtHMS.template.replace(/hh?/, "H"), this.timeFmtHMS.templateArr = this.timeFmtHMS._tokenize(this.timeFmtHMS.template), 
                                    this._init(this.timeFmtHM.locinfo, t && t.onLoad);
                                })
                            });
                        })
                    });
                })
            }), void 0) : (new ilib.LocaleInfo(this.locale, {
                sync: e,
                loadParams: i,
                onLoad: ilib.bind(this, function(e) {
                    this._init(e, t && t.onLoad);
                })
            }), void 0);
        })
    });
}, ilib.DurFmt.complist = {
    text: [ "year", "month", "week", "day", "hour", "minute", "second", "millisecond" ],
    clock: [ "year", "month", "week", "day" ]
}, ilib.DurFmt.prototype._mapDigits = function(t) {
    return this.useNative && this.digits ? ilib.mapString("" + t, this.digits) : t;
}, ilib.DurFmt.prototype._init = function(t, e) {
    var i;
    "boolean" == typeof this.useNative ? this.useNative && (i = t.getNativeDigits(), 
    i && (this.digits = i)) : "native" === t.getDigitsStyle() && (i = t.getNativeDigits(), 
    i && (this.useNative = !0, this.digits = i)), "function" == typeof e && e(this);
}, ilib.DurFmt.prototype.format = function(t) {
    var e, i, n, o = !0, s = "";
    for (i = ilib.DurFmt.complist[this.style], e = i.length - 1; e >= 0; e--) t[i[e]] !== void 0 && 0 != t[i[e]] && (s.length > 0 && (s = ("full" === this.length && o ? this.components.finalSeparator : this.components.separator) + s, 
    o = !1), s = this.components[i[e]].formatChoice(t[i[e]], {
        num: this._mapDigits(t[i[e]])
    }) + s);
    return "clock" === this.style && (n = t.hour !== void 0 ? t.second !== void 0 ? this.timeFmtHMS : this.timeFmtHM : this.timeFmtMS, 
    s.length > 0 && (s += this.components.separator), s += n._formatTemplate(t, n.templateArr)), 
    new ilib.String(s);
}, ilib.DurFmt.prototype.getLocale = function() {
    return this.locale;
}, ilib.DurFmt.prototype.getLength = function() {
    return this.length;
}, ilib.DurFmt.prototype.getStyle = function() {
    return this.style;
}, ilib.ScriptInfo = function(t, e) {
    var i = !0, n = void 0;
    this.script = t, e && (e.sync !== void 0 && (i = 1 == e.sync), e.loadParams !== void 0 && (n = e.loadParams)), 
    ilib.ScriptInfo.cache || (ilib.ScriptInfo.cache = {}), ilib.data.scripts ? this.info = ilib.data.scripts[t] : ilib.loadData({
        object: ilib.ScriptInfo,
        locale: "-",
        name: "scripts.json",
        sync: i,
        loadParams: n,
        callback: ilib.bind(this, function(i) {
            if (!i) {
                i = {
                    Latn: {
                        nb: 215,
                        nm: "Latin",
                        lid: "Latin",
                        rtl: !1,
                        ime: !1,
                        casing: !0
                    }
                };
                var n = this.locale.getSpec().replace(/-/g, "_");
                ilib.ScriptInfo.cache[n] = i;
            }
            ilib.data.scripts = i, this.info = t && ilib.data.scripts[t], e && "function" == typeof e.onLoad && e.onLoad(this);
        })
    });
}, ilib.ScriptInfo.getAllScripts = function() {
    var t = [], e = void 0, i = ilib.data.scripts;
    for (e in i) e && i[e] && t.push(e);
    return t;
}, ilib.ScriptInfo.prototype = {
    getCode: function() {
        return this.info && this.script;
    },
    getCodeNumber: function() {
        return this.info && this.info.nb || 0;
    },
    getName: function() {
        return this.info && this.info.nm;
    },
    getLongCode: function() {
        return this.info && this.info.lid;
    },
    getScriptDirection: function() {
        return this.info && this.info.rtl !== void 0 && this.info.rtl ? "rtl" : "ltr";
    },
    getNeedsIME: function() {
        return this.info && this.info.ime ? !0 : !1;
    },
    getCasing: function() {
        return this.info && this.info.casing ? !0 : !1;
    }
}, ilib.CaseMapper = function(t) {
    switch (this.up = !0, this.locale = new ilib.Locale(), t && (t.locale !== void 0 && (this.locale = "string" == typeof t.locale ? new ilib.Locale(t.locale) : t.locale), 
    this.up = !t.direction || "toupper" === t.direction), this.charMapper = function(t) {
        var e;
        if (!t) return t;
        e = "string" == typeof t ? new ilib.String(t) : "" + t;
        for (var i, n = "", o = e.charIterator(); o.hasNext(); ) i = o.next(), n += this.mapData[i] ? this.mapData[i] : this.up ? i.toUpperCase() : i.toLowerCase();
        return n;
    }, this.locale.getLanguage()) {
      case "az":
      case "tr":
      case "crh":
      case "kk":
      case "krc":
      case "tt":
        this.mapData = this.up ? {
            i: "\u0130",
            "\u0131": "I"
        } : {
            "\u0130": "i",
            I: "\u0131"
        }, this.mapper = this.charMapper;
        break;

      case "fr":
        this.up && "CA" !== this.locale.getRegion() && (this.mapData = {
            "\u00e0": "A",
            "\u00e1": "A",
            "\u00e2": "A",
            "\u00e3": "A",
            "\u00e4": "A",
            "\u00e7": "C",
            "\u00e8": "E",
            "\u00e9": "E",
            "\u00ea": "E",
            "\u00eb": "E",
            "\u00ec": "I",
            "\u00ed": "I",
            "\u00ee": "I",
            "\u00ef": "I",
            "\u00f1": "N",
            "\u00f2": "O",
            "\u00f3": "O",
            "\u00f4": "O",
            "\u00f6": "O",
            "\u00f9": "U",
            "\u00fa": "U",
            "\u00fb": "U",
            "\u00fc": "U"
        }, this.mapper = this.charMapper);
        break;

      case "el":
        this.up && (this.mapData = {
            "\u0390": "\u0399",
            "\u03ac": "\u0391",
            "\u03ad": "\u0395",
            "\u03ae": "\u0397",
            "\u03af": "\u0399",
            "\u03b0": "\u03a5",
            "\u03ca": "\u0399",
            "\u03cb": "\u03a5",
            "\u03cc": "\u039f",
            "\u03cd": "\u03a5",
            "\u03ce": "\u03a9"
        }, this.mapper = this.charMapper);
        break;

      case "abq":
      case "ady":
      case "av":
      case "ce":
      case "dar":
      case "inh":
      case "kbd":
      case "lbe":
      case "lez":
      case "tab":
      case "ru":
        this.up || (this.mapData = {
            "\u04c0": "\u04c0"
        }, this.mapper = this.charMapper);
        break;

      case "lt":
        this.mapper = this.charMapper;
    }
    this.mapper || (this.mapper = function(t) {
        return this.up ? t.toUpperCase() : t.toLowerCase();
    });
}, ilib.CaseMapper.prototype = {
    getLocale: function() {
        return this.locale;
    },
    map: function(t) {
        return this.mapper(t);
    }
};

// lib\enyo-ilib\glue.js
(function() {
    function t(e, i, n, o, s) {
        var a = "resources/";
        if (o && o.root !== void 0 && (a = o.root + "/"), i.length > 0) {
            var r = i.shift(), h = new enyo.Ajax({
                url: enyo.path.rewrite("$lib/enyo-ilib/ilib/locale/" + r),
                cacheBust: !1
            }), l = function(a, r) {
                n.push(a.failed || "object" != typeof r ? void 0 : r), i.length > 0 ? t(e, i, n, o, s) : s.call(e, n);
            };
            h.response(this, l), h.error(this, function() {
                var t = a + r, e = new enyo.Ajax({
                    url: t,
                    cacheBust: !1
                });
                e.response(this, l), e.error(this, l), e.go();
            }), h.go();
        }
    }
    ilib.setLoaderCallback(enyo.bind(this, function(e, i, n, o) {
        if (i) {
            var s = [], a = "resources/";
            return n && n.root !== void 0 && (a = n.root + "/"), e.forEach(function(t) {
                var e = new enyo.Ajax({
                    url: enyo.path.rewrite("$lib/enyo-ilib/ilib/locale/" + t),
                    sync: !0,
                    cacheBust: !1
                }), i = function(t, e) {
                    s.push(t.failed || "object" != typeof e ? void 0 : e);
                };
                e.response(this, i), e.error(this, function() {
                    var e = new enyo.Ajax({
                        url: a + t,
                        sync: !0,
                        cacheBust: !1
                    });
                    e.response(this, i), e.error(this, i), e.go();
                }), e.go();
            }), "function" == typeof o && o.call(this, s), s;
        }
        var r = [];
        t(this, e, r, n, o);
    })), window.UILocale !== void 0 && ilib.setLocale(window.UILocale), enyo.updateI18NClasses = function() {
        var t = new ilib.LocaleInfo(), e = t.getLocale(), i = "enyo-locale-";
        document && document.body && document.body.className && document.body.className && (document.body.className = document.body.className.replace(RegExp("(^|\\s)" + i + "[^\\s]*", "g"), ""));
        var n = [ "bs", "cs", "hr", "hu", "lv", "lt", "pl", "ro", "sr", "sl", "tr", "vi" ], o = [ "ko" ], s = t.getScript();
        ("Latn" !== s || -1 !== enyo.indexOf(e.getLanguage(), n)) && 0 > enyo.indexOf(e.getLanguage(), o) && enyo.dom.addBodyClass(i + "non-latin"), 
        "Latn" !== s && "Cyrl" !== s && "Grek" !== s && enyo.dom.addBodyClass(i + "non-italic");
        var a = new ilib.ScriptInfo(s);
        "rtl" === a.getScriptDirection() && (enyo.dom.addBodyClass(i + "right-to-left"), 
        enyo.Control && (enyo.Control.prototype.rtl = !0)), e.getLanguage() && (enyo.dom.addBodyClass(i + e.getLanguage()), 
        e.getScript() ? (enyo.dom.addBodyClass(i + e.getLanguage() + "-" + e.getScript()), 
        e.getRegion() && enyo.dom.addBodyClass(i + e.getLanguage() + "-" + e.getScript() + "-" + e.getRegion())) : e.getRegion() && enyo.dom.addBodyClass(i + e.getLanguage() + "-" + e.getRegion())), 
        e.getScript() && enyo.dom.addBodyClass(i + e.getScript()), e.getRegion() && enyo.dom.addBodyClass(i + e.getRegion()), 
        enyo.setCaseMappers();
    };
})(), $L = function(t) {
    var e;
    if ($L.rb || $L.setLocale(), "string" == typeof t) {
        if (!$L.rb) return t;
        e = $L.rb.getString(t);
    } else if ("object" == typeof t) if (t.key !== void 0 && t.value !== void 0) {
        if (!$L.rb) return t.value;
        e = $L.rb.getString(t.value, t.key);
    } else e = ""; else e = t;
    return "" + e;
}, $L.setLocale = function(t) {
    var e = new ilib.Locale(t);
    $L.rb && t === $L.rb.getLocale().getSpec() || ($L.rb = new ilib.ResBundle({
        locale: e,
        type: "html",
        name: "strings",
        sync: !0,
        lengthen: !0
    }));
}, enyo.setCaseMappers = function() {
    enyo.toLowerCase.mapper = new ilib.CaseMapper({
        direction: "tolower"
    }), enyo.toUpperCase.mapper = new ilib.CaseMapper({
        direction: "toupper"
    });
}, enyo.toLowerCase = function(t) {
    return null != t ? enyo.toLowerCase.mapper.map(t) : t;
}, enyo.toUpperCase = function(t) {
    return null != t ? enyo.toUpperCase.mapper.map(t) : t;
}, function(t) {
    enyo.updateLocale = function(e) {
        ilib.setLocale(e || navigator.language), $L.setLocale(e || navigator.language), 
        enyo.updateI18NClasses(), t();
    };
}(enyo.updateLocale), enyo.updateLocale(null, !0);

// lib\spotlight\version.js
enyo && enyo.version && (enyo.version.spotlight = "2.4.0-pre.2");

// lib\spotlight\enyo.Spotlight.js
enyo.Spotlight = new function() {
    var t = this, e = null, i = null, n = !0, o = !1, s = null, a = null, r = null, h = null, l = !0, c = null, d = !1, u = !1, p = null, g = !1, m = 0, f = null, y = null, b = null, v = 0, C = 300, w = 1536, S = 1537, P = function() {
        t.rootDispatchFunction = enyo.master.dispatchEvent, enyo.master.dispatchEvent = function(e, i, n) {
            return t.rootDispatchFunction.apply(enyo.master, [ e, i, n ]) ? !0 : i.delegate ? void 0 : t.onSpotlightEvent(i);
        };
    }, x = function(t) {
        t._spotlight === void 0 && (t._spotlight = {});
    }, k = function() {
        p = enyo.Spotlight.Util.getDefaultDirectionControl("disappear", s);
    }, T = function() {
        if (!T.isOff && !t.isSpottable(s)) {
            T.isOff = !0;
            var i = p;
            return i && t.isSpottable(i) || (i = t.getFirstChild(e)) ? (t.spot(i), void 0) : (H(h), 
            h = null, s = null, void 0);
        }
    }, $ = function(t, e, i) {
        if (e) {
            var n = t ? "addObserver" : "removeObserver";
            i || (t && (T.isOff = !1, k()), e[n]("disabled", T), e[n]("destroyed", T), e[n]("spotlight", T), 
            e[n]("generated", T)), e[n]("showing", T), $(t, e.parent, !0);
        }
    }, I = function(e) {
        if (x(e), !t.isSpottable(e)) throw "Attempting to spot not-spottable control: " + ("" + e);
        t.unspot(), L(e);
        var i = s;
        return s = e, setTimeout(function() {
            $(!1, i), $(!0, s);
        }, 1), V("CURRENT =", "" + s), enyo.Signals.send("onSpotlightCurrentChanged", {
            current: e
        }), e.spotlight === !0 && (h = e), D("onSpotlightFocused"), enyo.Spotlight.TestMode.highlight(), 
        !0;
    }, D = function(e, i, n) {
        return n = n || t.getCurrent(), enyo.Spotlight.Util.dispatchEvent(e, i, n);
    }, M = function(e) {
        var i = e.type.replace("onSpotlight", "").toUpperCase(), n = enyo.Spotlight.NearestNeighbor.getNearestNeighbor(i);
        if (A(e), r = e, n) t.spot(n, i); else {
            var o = t.getParent();
            !o || o.spotlightModal ? t.spot(h) : t.spot(o, i);
        }
    }, R = function(t) {
        return enyo.indexOf(t.keyCode, [ 37, 38, 39, 40, 13, 16777221 ]) > -1;
    }, B = function(t) {
        var e = enyo.$[t.target.id];
        if (e && e.spotlightIgnoredKeys) {
            var i = e.spotlightIgnoredKeys;
            if (enyo.isArray(i) || (i = [ i ]), enyo.indexOf(t.keyCode, i) > -1) return !0;
        }
        return !1;
    }, A = function(t) {
        R(t) && t.domEvent.preventDefault();
    }, F = function(e) {
        return e.type && 0 === e.type.indexOf("onSpotlight") && t.isContainer(e.originator) && "function" == typeof enyo.Spotlight.Container[e.type] ? enyo.Spotlight.Container[e.type](e.originator, e) : !1;
    }, _ = function(e) {
        var i = enyo.$[e];
        return i !== void 0 ? t.isSpottable(i) ? i : t.getParent(i) : void 0;
    }, L = function(e) {
        t.isMuted() || t.isContainer(e) || t.isInitialized() && (e.addClass("spotlight"), 
        g = !0);
    }, H = function(t) {
        t.removeClass("spotlight"), g = !1;
    }, O = function() {
        return t.getPointerMode() && !b;
    }, N = function() {
        return enyo.perfNow() >= v + C;
    }, z = function() {
        v = enyo.perfNow();
    }, V = function() {
        d && enyo.log("SPOTLIGHT: " + Array.prototype.slice.call(arguments, 0).join(" "));
    }, q = function() {
        enyo.warn("SPOTLIGHT: " + Array.prototype.slice.call(arguments, 0).join(" "));
    }, E = function() {
        t.isSpottable(h) ? t.spot(h) : t.spot(t.getFirstChild(e));
    }, W = function(i) {
        var n = enyo.Spotlight.NearestNeighbor.getNearestPointerNeighbor(e, U(i), f, y);
        n ? t.spot(n) : E();
    }, U = function(t) {
        switch (t.keyCode) {
          case 37:
            return "LEFT";

          case 38:
            return "UP";

          case 39:
            return "RIGHT";

          case 40:
            return "DOWN";
        }
    };
    this.onEvent = function(t) {
        if (this.isInitialized()) switch (t.type) {
          case "move":
            if (this.clientXYChanged(t) && m++ > 1) return this.onMouseMove(t);
            break;

          case "mousedown":
            return this.onMouseDown(t);

          case "mouseup":
            return this.onMouseUp(t);

          case "click":
          case "tap":
          case "ontap":
            return this.onClick(t);

          case "mousewheel":
            return O() ? !1 : enyo.Spotlight.Scrolling.processMouseWheel(t, this.onScroll, this);

          case "keydown":
            return this.onKeyDown(t);

          case "keyup":
            return this.onKeyUp(t);
        }
        return !1;
    }, this.onAcceleratedKey = function(t) {
        switch (t.domEvent = t, t.allowDomDefault = function() {
            t.preventDefault = function() {};
        }, t.type) {
          case "keydown":
            return D("onSpotlightKeyDown", t);

          case "keyup":
            return D("onSpotlightKeyUp", t);
        }
        return !0;
    }, this.onSpotlightEvent = function(t) {
        if (a = t, !F(t)) switch (t.type) {
          case "onSpotlightKeyUp":
            return this.onSpotlightKeyUp(t);

          case "onSpotlightKeyDown":
            return this.onSpotlightKeyDown(t);

          case "onSpotlightFocus":
            return this.onSpotlightFocus(t);

          case "onSpotlightFocused":
            return this.onSpotlightFocused(t);

          case "onSpotlightBlur":
            return this.onSpotlightBlur(t);

          case "onSpotlightLeft":
            return this.onSpotlightLeft(t);

          case "onSpotlightRight":
            return this.onSpotlightRight(t);

          case "onSpotlightUp":
            return this.onSpotlightUp(t);

          case "onSpotlightDown":
            return this.onSpotlightDown(t);

          case "onSpotlightSelect":
            return this.onSpotlightSelect(t);
        }
    }, this.onScroll = function(t, e) {
        var i = "onSpotlightScroll" + (e ? "Up" : "Down");
        return D(i, {
            domEvent: t
        });
    }, this.onMouseMove = function(t) {
        if (l && (this.setPointerMode(!0), this.getPointerMode())) {
            var e = _(t.target.id);
            if (e && !this.isContainer(e)) {
                if (e === b && (void 0 === t.index || t.index === b._nCurrentSpotlightItem)) return;
                this.spot(e, null, !0), b = e;
            } else b = null, this.unspot();
        }
    }, this.onMouseDown = function(t) {
        if (this.onMouseMove(t), this.isFrozen()) {
            var e = _(t.target.id);
            if (e != s && !t.defaultPrevented) return this.unfreeze(), this.unspot(), e && this.spot(e, null, !0), 
            !0;
        }
        if (this.getPointerMode()) return !1;
        t.preventDefault();
        var i = enyo.clone(t);
        return i.keyCode = 13, i.domEvent = t, i.allowDomDefault = enyo.nop, c = this.getCurrent(), 
        D("onSpotlightKeyDown", i, c), !0;
    }, this.onMouseUp = function(t) {
        if (this.getPointerMode()) return !1;
        t.preventDefault();
        var e = enyo.clone(t);
        return e.keyCode = 13, e.domEvent = t, D("onSpotlightKeyUp", e, c), !0;
    }, this.onClick = function(t) {
        return enyo.Spotlight.Util.isSimulatedClick(t) ? !0 : this.getPointerMode() ? !1 : (t.preventDefault(), 
        !t.fromSpotlight);
    }, this.onKeyDown = function(t) {
        if (B(t)) return !1;
        switch (t.keyCode) {
          case w:
            return this.setPointerMode(!0), !1;

          case S:
            return this.setPointerMode(!1), b || enyo.asyncMethod(this, function() {
                E();
            }), z(), !1;
        }
        if (R(t)) {
            var e = this.getPointerMode();
            if (this.setPointerMode(!1), !this.isSpottable(this.getCurrent())) return W(t), 
            !1;
            if (!N() && !b) return W(t), !1;
            if (e && !b && !this.isFrozen()) return W(t), !1;
        }
        return O() ? !1 : (enyo.Spotlight.Accelerator.processKey(t, this.onAcceleratedKey, this), 
        !1);
    }, this.onKeyUp = function(t) {
        return B(t) ? !0 : (enyo.Spotlight.Accelerator.processKey(t, this.onAcceleratedKey, this), 
        !1);
    }, this.onSpotlightRight = function(t) {
        M(t);
    }, this.onSpotlightLeft = function(t) {
        M(t);
    }, this.onSpotlightDown = function(t) {
        M(t);
    }, this.onSpotlightUp = function(t) {
        M(t);
    }, this.onSpotlightKeyUp = function() {}, this.onSpotlightKeyDown = function(t) {
        switch (t.keyCode) {
          case 13:
            return D("onSpotlightSelect", t);

          case 37:
            return D("onSpotlightLeft", t);

          case 38:
            return D("onSpotlightUp", t);

          case 39:
            return D("onSpotlightRight", t);

          case 40:
            return D("onSpotlightDown", t);
        }
        return !0;
    }, this.onSpotlightSelect = function(t) {
        A(t);
        var e, i = enyo.Spotlight.Util.getDefaultDirectionControl("SELECT", this.getCurrent());
        return r = null, i ? this.spot(i) : (e = this.getChildren(t.originator), 0 === e.length ? D("tap", {
            customEvent: !1,
            preventDefault: enyo.nop,
            fromSpotlight: !0
        }, t.originator) : this.spot(e[0]));
    }, this.onSpotlightFocus = function(t) {
        I(t.originator);
    }, this.onSpotlightFocused = function() {}, this.onSpotlightBlur = function(t) {
        this.hasCurrent() && (H(t.originator), b = null);
    }, this.initialize = function(t) {
        return this.isInitialized() ? !1 : (e = t, P(), o = !0, i && this.spot(i) ? !0 : this.spot(this.getFirstChild(e)) ? !0 : void 0);
    }, this.isInitialized = function() {
        return o;
    }, this.setPointerMode = function(t) {
        n == t || enyo.platform.touch || (n = t, V("Pointer mode", n), m = 0, enyo.Signals.send("onSpotlightModeChanged", {
            pointerMode: t
        }));
    }, this.getPointerMode = function() {
        return n;
    }, this.getCurrent = function() {
        return s;
    }, this.setCurrent = function(t) {
        return I(t);
    }, this.hasCurrent = function() {
        return null !== s;
    }, this.getLastEvent = function() {
        return a;
    }, this.getLastControl = function() {
        return h;
    }, this.getLast5WayEvent = function() {
        return r;
    }, this.setLast5WayControl = function(t) {
        h = t;
    }, this.isSpottable = function(t, e) {
        if (t = t || this.getCurrent(), !t) return !1;
        var i = !1;
        return this.isContainer(t) ? e || (i = this.hasChildren(t)) : i = !t.destroyed && t.spotlight !== void 0 && t.spotlight && t.getAbsoluteShowing(!0) && !t.disabled && t.generated && !t.spotlightDisabled, 
        i;
    }, this.isContainer = function(t) {
        return t ? "container" == t.spotlight : !1;
    }, this.hasChildren = function(t) {
        if (!t || t.spotlightDisabled) return !1;
        if (!this.isContainer(t) && this.isSpottable(t)) return !0;
        var e, i = t.children;
        for (e = 0; i.length > e; e++) if (this.hasChildren(i[e])) return !0;
        return !1;
    }, this.getSiblings = function(t) {
        if (t = t || this.getCurrent()) {
            var i, n = {}, o = this.getParent(t) || e;
            for (n.siblings = this.getChildren(o), i = 0; n.siblings.length > i; i++) t === n.siblings[i] && (n.selfPosition = i);
            return n;
        }
    }, this.getChildren = function(t, e) {
        if (t = t || this.getCurrent()) {
            var i, n, o = [];
            if (!t.spotlightDisabled) for (i = 0; t.children.length > i; i++) n = t.children[i], 
            this.isSpottable(n, e) ? o.push(n) : o = o.concat(this.getChildren(n, e));
            return o;
        }
    }, this.getParent = function(t) {
        if (t = t || this.getCurrent()) {
            for (var e = null; t.parent; ) if (t = t.parent, this.isSpottable(t)) {
                e = t;
                break;
            }
            return e;
        }
    }, this.spot = function(t, e, n) {
        if (!this.isInitialized()) return i = t, !0;
        if (!t) return !1;
        if (!(t instanceof enyo.Control)) return q("argument is not enyo.Control"), !1;
        if (this.isFrozen()) return q("can't spot in frozen mode"), !1;
        var o = t;
        return this.isSpottable(t) || (t = this.getFirstChild(t)), t ? (this.getPointerMode() && !n ? (this.unspot(), 
        h = t, b = null, V("Spot called in pointer mode; 5-way will resume from: " + t.id)) : D("onSpotlightFocus", {
            dir: e
        }, t), !0) : (q("can't spot: " + ("" + o) + " is not spottable and has no spottable descendants"), 
        !1);
    }, this.unspot = function() {
        return this.isFrozen() ? !1 : this.hasCurrent() && g ? (D("onSpotlightBlur", null, s), 
        !0) : !1;
    }, this.getFirstChild = function(t) {
        return t = t || this.getCurrent(), t ? this.getChildren(t)[0] : null;
    }, this.clientXYChanged = function(t) {
        var e = f !== t.clientX || y !== t.clientY;
        return this.getPointerMode() && (f = t.clientX, y = t.clientY), e;
    }, this.disablePointerMode = function() {
        l = !1;
    }, this.enablePointerMode = function() {
        l = !0;
    }, this.mute = function(t) {
        enyo.Spotlight.Muter.addMuteReason(t);
    }, this.unmute = function(t) {
        enyo.Spotlight.Muter.removeMuteReason(t);
    }, this.isMuted = function() {
        return enyo.Spotlight.Muter.isMuted();
    }, this.verbose = function(t) {
        return d = t === void 0 ? !d : t, "SPOTLIGHT: Verbose mode set to " + d;
    }, this.freeze = function() {
        if (!this.hasCurrent()) throw "Can not enter frozen mode until something is spotted";
        return u = !0, "SPOTLIGHT: Frozen on " + ("" + s);
    }, this.unfreeze = function() {
        return u = !1, "SPOTLIGHT: Exit frozen mode";
    }, this.isFrozen = function() {
        return u;
    };
}(), enyo.dispatcher.features.push(function(t) {
    return enyo.Spotlight.onEvent(t);
}), enyo.rendered(function(t) {
    enyo.Spotlight.initialize(t);
});

// lib\spotlight\enyo.Spotlight.Container.js
enyo.Spotlight.Container = new function() {
    var t = this, e = function(e) {
        var o;
        if (!i(e)) {
            if (e.defaultSpotlightControl) if (e.$[e.defaultSpotlightControl]) o = e.$[e.defaultSpotlightControl]; else {
                if (!e.owner.$[e.defaultSpotlightControl]) throw "Invalid default spotlight control specified in " + e.name;
                o = e.owner.$[e.defaultSpotlightControl];
            } else o = enyo.Spotlight.getFirstChild(e);
            o && o.isDescendantOf(e) && t.setLastFocusedChild(e, o), enyo.Spotlight.Util.interceptEvents(e, n);
        }
    }, i = function(t) {
        return t._spotlight.lastFocusedChild !== void 0;
    }, n = function(e, i) {
        switch (i.type) {
          case "onSpotlightFocus":
            i.originator !== e && t.setLastFocusedChild(e, i.originator);
            break;

          case "onSpotlightKeyDown":
            i.spotSentFromContainer = !0;
        }
    }, o = function(t) {
        var e = enyo.Spotlight.getLastControl();
        return t._spotlight.bEnorceOutsideIn ? !1 : enyo.Spotlight.isSpottable(e) ? enyo.Spotlight.Util.isChild(t, e) : !1;
    }, s = function(t, e) {
        if (t._spotlight.lastFocusedChild !== enyo.Spotlight.getLastControl()) {
            var i = e.replace("onSpotlight", "").toUpperCase();
            enyo.Spotlight.Util.dispatchEvent("onSpotlightContainerLeave", {
                direction: i
            }, t);
        }
    }, a = function(t, e) {
        var i = e.replace("onSpotlight", "").toUpperCase();
        enyo.Spotlight.Util.dispatchEvent("onSpotlightContainerEnter", {
            direction: i
        }, t);
    };
    this.onSpotlightFocus = function(t, e) {
        t._spotlight = t._spotlight || {}, t._spotlight.bEnorceOutsideIn = !e.dir;
    }, this.onSpotlightFocused = function(t) {
        if (enyo.Spotlight.isInitialized() && enyo.Spotlight.getPointerMode()) return !0;
        e(t);
        var i = enyo.Spotlight.getLast5WayEvent() ? enyo.Spotlight.getLast5WayEvent().type : "";
        if (o(t)) i && enyo.Spotlight.Util.dispatchEvent(i, {
            spotSentFromContainer: !0
        }, t), s(t, i); else {
            var n = this.getLastFocusedChild(t);
            if (n) enyo.Spotlight.spot(n); else if (i) return enyo.Spotlight.Util.dispatchEvent(i, {
                spotSentFromContainer: !0
            }, t), !0;
            a(t, i);
        }
        return !0;
    }, this.getLastFocusedChild = function(t) {
        return t._spotlight = t._spotlight || {}, t._spotlight.lastFocusedChild && enyo.Spotlight.isSpottable(t._spotlight.lastFocusedChild) || (t._spotlight.lastFocusedChild = enyo.Spotlight.getChildren(t)[0]), 
        t._spotlight.lastFocusedChild;
    }, this.setLastFocusedChild = function(t, e) {
        enyo.Spotlight.isSpottable(e) || (e = this.getFirstChild(e)), e ? (t._spotlight = t._spotlight || {}, 
        t._spotlight.lastFocusedChild = e) : enyo.warn("Spotlight Container" + t.name + " has not spottable lastFocusedChild " + e.name);
    };
}();

// lib\spotlight\enyo.Spotlight.Util.js
enyo.Spotlight.Util = new function() {
    this.dispatchEvent = function(t, e, i) {
        var n;
        if (i && !i.destroyed) {
            if (enyo.Spotlight.isFrozen()) {
                if ("onSpotlightBlur" == t) return;
                i = enyo.Spotlight.getCurrent();
            }
            return n = e ? enyo.clone(e) : {}, n.type = t, n.originator = i, n.originator.timestamp = n.timeStamp, 
            n.target = i.hasNode(), n.customEvent = void 0 === n.customEvent ? !0 : n.customEvent, 
            n.target ? enyo.dispatcher.dispatch(n) : enyo.dispatcher.dispatchBubble(n, i);
        }
    }, this.interceptEvents = function(t, e) {
        var i = t.dispatchEvent;
        t.dispatchEvent = function(n, o, s) {
            return !o.delegate && e(t, o) ? (o.type = null, !0) : i.apply(t, [ n, o, s ]);
        };
    }, this.isChild = function(t, e) {
        if (!t) return !1;
        if (!e) return !1;
        for (;e.parent; ) if (e = e.parent, e === t) return !0;
        return !1;
    }, this.getAbsoluteBounds = function(t) {
        var e = t instanceof enyo.Control ? t.hasNode() : t;
        return enyo.dom.getAbsoluteBounds(e);
    }, this.hasClass = function(t, e) {
        return t && t.className ? (" " + t.className + " ").indexOf(" " + e + " ") >= 0 : void 0;
    }, this.addClass = function(t, e) {
        if (t && !this.hasClass(t, e)) {
            var i = t.className;
            t.className = i + (i ? " " : "") + e;
        }
    }, this.removeClass = function(t, e) {
        if (t && this.hasClass(t, e)) {
            var i = t.className;
            t.className = (" " + i + " ").replace(" " + e + " ", " ").slice(1, -1);
        }
    }, this.stringEndsWith = function(t, e) {
        return -1 !== t.indexOf(e, t.length - e.length);
    }, this.directionToEvent = function(t) {
        return "onSpotlight" + t.charAt(0).toUpperCase() + t.substr(1).toLowerCase();
    }, this.getDefaultDirectionControl = function(t, e) {
        var i, n = "defaultSpotlight" + t.charAt(0).toUpperCase() + t.substr(1).toLowerCase();
        return "string" == typeof e[n] && (i = e.owner.$[e[n]], i !== void 0) ? i : null;
    }, this.isSimulatedClick = function(t) {
        return 0 === t.clientX && 0 === t.clientY && ("click" == t.type || "tap" == t.type);
    };
}(), document.createElement("div").classList && (enyo.Spotlight.Util.hasClass = function(t, e) {
    return t ? t.classList.contains(e) : void 0;
}, enyo.Spotlight.Util.addClass = function(t, e) {
    return t ? t.classList.add(e) : void 0;
}, enyo.Spotlight.Util.removeClass = function(t, e) {
    return t ? t.classList.remove(e) : void 0;
});

// lib\spotlight\enyo.Spotlight.Accelerator.js
enyo.Spotlight.Accelerator = new function() {
    var t = 0, e = 0, i = 0;
    this.frequency = [ 3, 3, 3, 2, 2, 2, 1 ], this.processKey = function(n, o, s) {
        switch (n.type) {
          case "keydown":
          case "pagehold":
          case "pageholdpulse":
            if (n.keyCode != i) return this.reset(), e = new Date().getTime(), i = n.keyCode, 
            o.apply(s, [ n ]);
            var a = new Date().getTime() - e, r = Math.floor(a / 1e3), h = 0;
            return r = r > this.frequency.length - 1 ? this.frequency.length - 1 : r, h = this.frequency[r] - 1, 
            0 > h && (h = 0), t >= h ? (t = 0, o.apply(s, [ n ])) : (t++, n.preventDefault(), 
            !0);

          case "keyup":
          case "pagerelease":
            return this.reset(), o.apply(s, [ n ]);
        }
    }, this.reset = function() {
        t = 0, e = 0, i = 0;
    };
}();

// lib\spotlight\enyo.Spotlight.Scrolling.js
enyo.Spotlight.Scrolling = new function() {
    var t = 0;
    this.frequency = 40, this.processMouseWheel = function(e, i, n) {
        return t += e.wheelDeltaY, t >= this.frequency ? (t = 0, i.apply(n, [ e, !0 ])) : -this.frequency >= t ? (t = 0, 
        i.apply(n, [ e, !1 ])) : void 0;
    };
}();

// lib\spotlight\enyo.Spotlight.NearestNeighbor.js
enyo.Spotlight.NearestNeighbor = new function() {
    var t = function(t, e, i, n) {
        if (n) switch (t) {
          case "UP":
            return e.top + e.height / 2 > i.top + i.height / 2;

          case "DOWN":
            return e.top + e.height / 2 < i.top + i.height / 2;

          case "LEFT":
            return e.left + e.width / 2 > i.left + i.width / 2;

          case "RIGHT":
            return e.left + e.width / 2 < i.left + i.width / 2;
        } else switch (t) {
          case "UP":
            return e.top >= i.top + i.height - 1;

          case "DOWN":
            return e.top + e.height - 1 <= i.top;

          case "LEFT":
            return e.left >= i.left + i.width - 1;

          case "RIGHT":
            return e.left + e.width - 1 <= i.left;
        }
    }, e = function(t, e, n) {
        var o = i(t, e, n);
        return s(o, t);
    }, i = function(t, e, i) {
        switch (t) {
          case "UP":
          case "DOWN":
            return n(t, e, i);

          case "LEFT":
          case "RIGHT":
            return o(t, e, i);
        }
    }, n = function(t, e, i) {
        var n, o, s, a;
        return s = "UP" === t ? e.top : e.top + e.height, a = "UP" === t ? i.top + i.height : i.top, 
        e.left < i.left ? e.left + e.width <= i.left ? (n = e.left + e.width + 1, o = i.left) : (n = i.left, 
        o = i.left) : e.left >= i.left + i.width ? (n = e.left, o = i.left + i.width + 1) : (n = e.left, 
        o = e.left), [ {
            x: n,
            y: s
        }, {
            x: o,
            y: a
        } ];
    }, o = function(t, e, i) {
        var n, o, s, a;
        return n = "LEFT" === t ? e.left : e.left + e.width, o = "LEFT" === t ? i.left + i.width : i.left, 
        e.top < i.top ? e.top + e.height <= i.top ? (s = e.top + e.height + 1, a = i.top) : (s = i.top, 
        a = i.top) : e.top >= i.top + i.height ? (s = e.top, a = i.top + i.height + 1) : (s = e.top, 
        a = e.top), [ {
            x: n,
            y: s
        }, {
            x: o,
            y: a
        } ];
    }, s = function(t, e) {
        var i = a(t[0], t[1]), n = h(i, e), o = c(n), s = l(i);
        return o > 89 ? 0 : 1 / (o * Math.pow(s, 4));
    }, a = function(t, e) {
        return {
            dx: Math.abs(e.x - t.x),
            dy: Math.abs(e.y - t.y)
        };
    }, r = function(t, e) {
        var i = {
            x: t.left + t.width / 2,
            y: t.top + t.height / 2
        }, n = {
            x: e.left + e.width / 2,
            y: e.top + e.height / 2
        }, o = a(i, n), s = l(o);
        return s;
    }, h = function(t, e) {
        switch (e) {
          case "UP":
          case "DOWN":
            return t.dx / t.dy;

          case "LEFT":
          case "RIGHT":
            return t.dy / t.dx;
        }
    }, l = function(t) {
        return Math.pow(t.dx * t.dx + t.dy * t.dy, .5) || .1;
    }, c = function(t) {
        return 180 * Math.atan(t) / Math.PI || .1;
    }, d = function(i, n, o, s) {
        var a, h, l, c, d = null, u = null, p = 0, g = 0, m = i.length;
        for (a = 0; m > a; a++) d = i[a], s && d === s || (h = d.getAbsoluteBounds(), t(n, o, h) && (l = e(n, o, h), 
        l > p ? (p = l, u = d, g = r(o, h)) : l == p && (c = r(o, h), g > c && (p = l, u = d, 
        g = c))));
        return u;
    };
    this.getNearestPointerNeighbor = function(t, e, i, n) {
        var o = {
            left: i,
            top: n,
            width: 1,
            height: 1
        }, s = enyo.Spotlight.getChildren(t, !0);
        return d(s, e, o);
    }, this.getNearestNeighbor = function(t, e) {
        t = t.toUpperCase(), e = e || enyo.Spotlight.getCurrent();
        var i = enyo.Spotlight.Util.getDefaultDirectionControl(t, e);
        if (i && enyo.Spotlight.isSpottable(i)) return i;
        var n = e.getAbsoluteBounds(), o = enyo.Spotlight.getSiblings(e);
        return d(o.siblings, t, n, e);
    };
}();

// lib\spotlight\enyo.Spotlight.Muter.js
enyo.Spotlight.Muter = new function() {
    var t = {}, e = 0;
    this.addMuteReason = function(i) {
        if (void 0 === t[i.id]) {
            if (0 === e) {
                var n = enyo.Spotlight.getCurrent();
                n && n.removeClass("spotlight");
            }
            t[i.id] = 1, e++;
        }
    }, this.removeMuteReason = function(i) {
        if (void 0 !== t[i.id] && (delete t[i.id], e--, 0 === e)) {
            var n = enyo.Spotlight.getCurrent();
            n && n.addClass("spotlight");
        }
    }, this.isMuted = function() {
        return e > 0;
    };
}();

// lib\spotlight\enyo.Spotlight.States.js
enyo.Spotlight.States = new function() {
    var t = {}, e = !1, i = function(t) {
        return t && t.id ? t.id : enyo.Spotlight.getCurrent().id;
    }, n = function(e) {
        return t[e] !== void 0;
    }, o = function() {
        e && enyo.log("SPOTLIGHT STATES: " + Array.prototype.slice.call(arguments, 0).join(" "));
    };
    this.push = function(e, s) {
        var a = i(s);
        n(e) || (t[e] = []), t[e].push(a), o("Pushed", a, "onto stack", e + "[" + t[e].length + "]");
    }, this.pop = function(e) {
        var i;
        if (!n(e)) throw 'Error in enyo.Spotlight.States: stack "' + e + "' dose not exist, call push to create it";
        t[e].length > 0 ? (i = t[e].pop(), i && (enyo.Spotlight.spot(enyo.$[i]), o("Popped", i, "off stack", e + "[" + t[e].length + "]"))) : enyo.warn('enyo.Spotlight.States.pop() has failed: Stack "' + e + '" is empty');
    }, this.verbose = function(t) {
        return e = t === void 0 ? !e : t, "SPOTLIGHT.STATES: verbose mode is " + (e ? "ON" : "OFF");
    };
}();

// lib\spotlight\enyo.Spotlight.TestMode.js
enyo.Spotlight.TestMode = new function() {
    var t = [], e = !1, i = function() {
        var e;
        for (e = 0; t.length > e; e++) t[e] && t[e].destroy();
        t = [];
    }, n = function() {
        t.push(a({
            control: enyo.Spotlight.getCurrent(),
            str: "C"
        }));
    }, o = function() {
        if (enyo.Spotlight.getCurrent()) for (var e = s([ {
            control: enyo.Spotlight.NearestNeighbor.getNearestNeighbor("UP"),
            str: "U"
        }, {
            control: enyo.Spotlight.NearestNeighbor.getNearestNeighbor("DOWN"),
            str: "D"
        }, {
            control: enyo.Spotlight.NearestNeighbor.getNearestNeighbor("LEFT"),
            str: "L"
        }, {
            control: enyo.Spotlight.NearestNeighbor.getNearestNeighbor("RIGHT"),
            str: "R"
        } ]), i = 0; e.length > i; i++) e[i] && t.push(a(e[i]));
    }, s = function(t) {
        for (var e = [], i = -1, n = 0; t.length > n; n++) {
            i = -1;
            for (var o = 0; t.length > o; o++) if (t[n].control === t[o].control && t[n].str !== t[o].str) {
                i = o;
                break;
            }
            i > -1 && (t[n].str += "," + t[i].str, t.splice(i, 1)), e.push(t[n]);
        }
        return e;
    }, a = function(t) {
        if (!t || !t.control || !t.control.hasNode()) return null;
        var e = enyo.Spotlight.Util.getAbsoluteBounds(t.control), i = "C" === t.str ? "spotlight-current-item" : "spotlight-adjacent-item", n = enyo.roots[0].createComponent({
            classes: "spotlight-highlight " + i,
            style: "height:" + e.height + "px;width:" + e.width + "px;top:" + e.top + "px;left:" + e.left + "px;line-height:" + e.height + "px;",
            content: t.str
        });
        return n.render(), n;
    };
    this.enable = function() {
        e = !0, this.highlight();
    }, this.disable = function() {
        e = !1, i();
    }, this.highlight = function() {
        e && (i(), n(), o());
    }, this.isEnabled = function() {
        return e;
    };
}();

// lib\arrangers\BoxTurnArranger.js
enyo.kind({
    name: "enyo.BoxTurnArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit more-arrangers-perspective more-arrangers-bfhidden",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.boxTurnControl(t, 0, 0, 1, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i, n, o, s, a = 0; e = t[a]; a++) if (s = 0 == a ? 1 : 0, enyo.dom.canAccelerate) {
            switch (a) {
              case 0:
                i = 0;
                break;

              case 1:
                i = 90;
                break;

              case t.length - 1:
                i = -90;
            }
            this.arrangeControl(e, {
                angle: i,
                opacity: s
            });
        } else {
            switch (a) {
              case 0:
                n = 0, o = 1;
                break;

              case 1:
                n = 50, o = 0;
                break;

              case t.length - 1:
                n = -50, o = 0;
            }
            this.arrangeControl(e, {
                transform: n,
                scale: o,
                opacity: s
            });
        }
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.showing && t.resized();
        this.vendor || (this.vendor = this.getVendor());
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.angle, n = e.transform, o = e.scale, s = e.opacity;
        null != s && this.boxTurnControl(t, i, n, o, s);
    },
    boxTurnControl: function(t, e, i, n, o) {
        if (enyo.dom.canAccelerate) {
            var s = e;
            t.applyStyle(this.vendor + "transform-origin", "50% 50% -" + this.containerBounds.width / 2 + "px"), 
            t.applyStyle(this.vendor + "transform", "translateZ(-" + this.containerBounds.width / 2 + "px) rotateY(" + s + "deg)");
        } else {
            var a = i, r = n;
            t.applyStyle(this.vendor + "transform", "translateX(" + a + "%) scale(" + r + ", 1)");
        }
        enyo.Arranger.opacifyControl(t, o);
    },
    getVendor: function() {
        var t = "", e = [ "transform", "WebkitTransform", "MozTransform", "OTransform", "msTransform" ], n = document.createElement("div");
        for (i = 0; e.length > i; i++) {
            if (n.style[e[i]] !== void 0) {
                t = e[i];
                break;
            }
            t = null;
        }
        switch (t) {
          case "transform":
            t = "";
            break;

          case "WebkitTransform":
            t = "-webkit-";
            break;

          case "MozTransform":
            t = "-moz-";
            break;

          case "OTransform":
            t = "-o-";
            break;

          case "msTransform":
            t = "-ms-";
        }
        return t;
    }
});

// lib\arrangers\HFlipArranger.js
enyo.kind({
    name: "enyo.HFlipArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit more-arrangers-perspective more-arrangers-bfhidden",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.flipControl(t, 0, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i, n, o = 0; e = t[o]; o++) n = 0 == o ? 1 : 0, enyo.dom.canAccelerate ? (0 == o && (i = 0), 
        1 == o && o != t.length && (i = 180), o == t.length - 1 && (i = -180), this.arrangeControl(e, {
            angle: i,
            opacity: n
        })) : (i = 0 == o ? 1 : -1, this.arrangeControl(e, {
            angle: i,
            opacity: n
        }));
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.showing && t.resized();
        this.vendor || (this.vendor = this.getVendor());
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.angle, n = e.opacity;
        null != i && null != n && this.flipControl(t, i, n);
    },
    flipControl: function(t, e, i) {
        var n = e;
        enyo.dom.canAccelerate ? t.applyStyle(this.vendor + "transform", "rotateY(" + n + "deg)") : (0 >= n ? t.applyStyle("display", "none") : t.applyStyle("display", "block"), 
        t.applyStyle(this.vendor + "transform", "scale(" + n + ",1)")), enyo.Arranger.opacifyControl(t, i);
    },
    getVendor: function() {
        var t = "", e = [ "transform", "WebkitTransform", "MozTransform", "OTransform", "msTransform" ], n = document.createElement("div");
        for (i = 0; e.length > i; i++) {
            if (n.style[e[i]] !== void 0) {
                t = e[i];
                break;
            }
            t = null;
        }
        switch (t) {
          case "transform":
            t = "";
            break;

          case "WebkitTransform":
            t = "-webkit-";
            break;

          case "MozTransform":
            t = "-moz-";
            break;

          case "OTransform":
            t = "-o-";
            break;

          case "msTransform":
            t = "-ms-";
        }
        return t;
    }
});

// lib\arrangers\PageSpinArranger.js
enyo.kind({
    name: "enyo.PageSpinArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit more-arrangers-perspective",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.pageSpinControl(t, 0, 1, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i, n, o, s = 0; e = t[s]; s++) if (o = 0 == s ? 1 : 0, enyo.dom.canAccelerate) {
            switch (s) {
              case 0:
                i = 0;
                break;

              case 1:
                i = 90;
                break;

              case t.length - 1:
                i = -90;
            }
            this.arrangeControl(e, {
                angle: i,
                opacity: o
            });
        } else n = 0 == s ? 1 : 0, this.arrangeControl(e, {
            scale: n,
            opacity: o
        });
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.showing && t.resized();
        this.vendor || (this.vendor = this.getVendor());
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.angle, n = e.scale, o = e.opacity;
        null != o && this.pageSpinControl(t, i, n, o);
    },
    pageSpinControl: function(t, e, i, n) {
        if (enyo.dom.canAccelerate) {
            var o = e;
            t.applyStyle(this.vendor + "transform-origin", "0 50% 0"), t.applyStyle(this.vendor + "transform", "rotateY(" + o + "deg)");
        } else {
            var s = i;
            enyo.log(this.vendor), t.applyStyle(this.vendor + "transform-origin", "0 50%"), 
            t.applyStyle(this.vendor + "transform", "scale(" + s + ", 1)");
        }
        enyo.Arranger.opacifyControl(t, n);
    },
    getVendor: function() {
        var t = "", e = [ "transform", "WebkitTransform", "MozTransform", "OTransform", "msTransform" ], n = document.createElement("div");
        for (i = 0; e.length > i; i++) {
            if (n.style[e[i]] !== void 0) {
                t = e[i];
                break;
            }
            t = null;
        }
        switch (t) {
          case "transform":
            t = "";
            break;

          case "WebkitTransform":
            t = "-webkit-";
            break;

          case "MozTransform":
            t = "-moz-";
            break;

          case "OTransform":
            t = "-o-";
            break;

          case "msTransform":
            t = "-ms-";
        }
        return t;
    }
});

// lib\arrangers\PageTurnArranger.js
enyo.kind({
    name: "enyo.PageTurnArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit more-arrangers-perspective",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.pageTurnControl(t, 0, 0, 0, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i = 0; e = t[i]; i++) {
            var n = i == t.length - 1 ? 0 : 1;
            if (enyo.dom.canAccelerate) {
                var o = i == t.length - 1 ? -90 : 0;
                this.arrangeControl(e, {
                    angle: o,
                    opacity: n
                });
            } else {
                var s = i == t.length - 1 ? -.2 : 1;
                this.arrangeControl(e, {
                    scale: s,
                    opacity: n
                });
            }
        }
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.applyStyle("z-index", -i), t.showing && t.resized();
        this.vendor || (this.vendor = this.getVendor());
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.angle, n = e.scale, o = e.opacity;
        null != o && this.pageTurnControl(t, i, n, o);
    },
    pageTurnControl: function(t, e, i, n) {
        if (enyo.dom.canAccelerate) {
            var o = e;
            t.applyStyle(this.vendor + "transform-origin", "0 50% 0"), t.applyStyle(this.vendor + "transform", "rotateY(" + o + "deg)");
        } else {
            var s = i;
            t.applyStyle(this.vendor + "transform-origin", "0 50%"), t.applyStyle(this.vendor + "transform", "scale(" + s + ", 1)");
        }
        enyo.Arranger.opacifyControl(t, n);
    },
    getVendor: function() {
        var t = "", e = [ "transform", "WebkitTransform", "MozTransform", "OTransform", "msTransform" ], n = document.createElement("div");
        for (i = 0; e.length > i; i++) {
            if (n.style[e[i]] !== void 0) {
                t = e[i];
                break;
            }
            t = null;
        }
        switch (t) {
          case "transform":
            t = "";
            break;

          case "WebkitTransform":
            t = "-webkit-";
            break;

          case "MozTransform":
            t = "-moz-";
            break;

          case "OTransform":
            t = "-o-";
            break;

          case "msTransform":
            t = "-ms-";
        }
        return t;
    }
});

// lib\arrangers\PushPopArranger.js
enyo.kind({
    name: "enyo.PushPopArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.pushPopControl(t, 0, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i, n, o = 0; e = t[o]; o++) {
            switch (n = 0 == o ? 1 : 0, o) {
              case 0:
                i = 1;
                break;

              case 1:
                i = .66;
                break;

              case t.length - 1:
                i = 1.33;
            }
            this.arrangeControl(e, {
                scale: i,
                opacity: n
            });
        }
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.showing && t.resized();
        this.vendor || (this.vendor = this.getVendor());
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.scale, n = e.opacity;
        null != i && null != n && this.pushPopControl(t, i, n);
    },
    pushPopControl: function(t, e, i) {
        var n = e;
        enyo.dom.canAccelerate ? t.applyStyle(this.vendor + "transform", "scale3d(" + n + "," + n + ",1)") : t.applyStyle(this.vendor + "transform", "scale(" + n + "," + n + ")"), 
        enyo.Arranger.opacifyControl(t, i);
    },
    getVendor: function() {
        var t = "", e = [ "transform", "WebkitTransform", "MozTransform", "OTransform", "msTransform" ], n = document.createElement("div");
        for (i = 0; e.length > i; i++) {
            if (n.style[e[i]] !== void 0) {
                t = e[i];
                break;
            }
            t = null;
        }
        switch (t) {
          case "transform":
            t = "";
            break;

          case "WebkitTransform":
            t = "-webkit-";
            break;

          case "MozTransform":
            t = "-moz-";
            break;

          case "OTransform":
            t = "-o-";
            break;

          case "msTransform":
            t = "-ms-";
        }
        return t;
    }
});

// lib\arrangers\SladeArranger.js
enyo.kind({
    name: "enyo.SladeArranger",
    kind: "Arranger",
    layoutClass: "enyo-arranger enyo-arranger-fit",
    calcArrangementDifference: function() {
        return this.containerBounds.width;
    },
    destroy: function() {
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) this.sladeControl(t, 0, 1), 
        t.setShowing(!0), t.resized();
        this.inherited(arguments);
    },
    arrange: function(t) {
        for (var e, i, n, o = 0; e = t[o]; o++) {
            switch (n = 0 == o ? 1 : 0, o) {
              case 0:
                i = 0;
                break;

              case 1:
                i = 50;
                break;

              case t.length - 1:
                i = -50;
            }
            this.arrangeControl(e, {
                translate: i,
                opacity: n
            });
        }
    },
    start: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.fromIndex || i == this.container.toIndex), 
        t.showing && t.resized();
    },
    finish: function() {
        this.inherited(arguments);
        for (var t, e = this.container.children, i = 0; t = e[i]; i++) t.setShowing(i == this.container.toIndex);
    },
    flowControl: function(t, e) {
        enyo.Arranger.positionControl(t, e);
        var i = e.translate, n = e.opacity;
        null != i && null != n && this.sladeControl(t, i, n);
    },
    sladeControl: function(t, e, i) {
        var n = e;
        enyo.dom.canAccelerate ? (t.applyStyle("-webkit-transform", "translate3d(" + n + "%,0,0)"), 
        t.applyStyle("-moz-transform", "translate3d(" + n + "%,0,0)"), t.applyStyle("-o-transform", "translate3d(" + n + "%,0,0)"), 
        t.applyStyle("-ms-transform", "translate3d(" + n + "%,0,0)")) : (t.applyStyle("-webkit-transform", "translate(" + n + "%,0)"), 
        t.applyStyle("-moz-transform", "translate(" + n + "%,0)"), t.applyStyle("-o-transform", "translate(" + n + "%,0)"), 
        t.applyStyle("-ms-transform", "translate(" + n + "%,0)")), enyo.Arranger.opacifyControl(t, i);
    }
});

// lib\flotr\flotr2.min.js
!function(t, e, i) {
    "undefined" != typeof module ? module.exports = i(t, e) : "function" == typeof define && "object" == typeof define.amd ? define(i) : e[t] = i(t, e);
}("bean", this, function(t, e) {
    var i = window, n = e[t], o = /over|out/, s = /[^\.]*(?=\..*)\.|.*/, a = /\..*/, r = "addEventListener", l = "attachEvent", h = "removeEventListener", c = "detachEvent", d = document || {}, u = d.documentElement || {}, p = u[r], g = p ? r : l, f = Array.prototype.slice, m = /click|mouse|menu|drag|drop/i, y = /^touch|^gesture/i, v = {
        one: 1
    }, b = function(t, e, i) {
        for (i = 0; e.length > i; i++) t[e[i]] = 1;
        return t;
    }({}, ("click dblclick mouseup mousedown contextmenu mousewheel DOMMouseScroll mouseover mouseout mousemove selectstart selectend keydown keypress keyup orientationchange focus blur change reset select submit load unload beforeunload resize move DOMContentLoaded readystatechange error abort scroll " + (p ? "show input invalid touchstart touchmove touchend touchcancel gesturestart gesturechange gestureend message readystatechange pageshow pagehide popstate hashchange offline online afterprint beforeprint dragstart dragenter dragover dragleave drag drop dragend loadstart progress suspend emptied stalled loadmetadata loadeddata canplay canplaythrough playing waiting seeking seeked ended durationchange timeupdate play pause ratechange volumechange cuechange checking noupdate downloading cached updateready obsolete " : "")).split(" ")), C = function() {
        function t(t, e) {
            for (;null !== (e = e.parentNode); ) if (e === t) return !0;
            return !1;
        }
        function e(e) {
            var i = e.relatedTarget;
            return i ? i !== this && "xul" !== i.prefix && !/document/.test("" + this) && !t(this, i) : null === i;
        }
        return {
            mouseenter: {
                base: "mouseover",
                condition: e
            },
            mouseleave: {
                base: "mouseout",
                condition: e
            },
            mousewheel: {
                base: /Firefox/.test(navigator.userAgent) ? "DOMMouseScroll" : "mousewheel"
            }
        };
    }(), w = function() {
        var t = "altKey attrChange attrName bubbles cancelable ctrlKey currentTarget detail eventPhase getModifierState isTrusted metaKey relatedNode relatedTarget shiftKey srcElement target timeStamp type view which".split(" "), e = t.concat("button buttons clientX clientY dataTransfer fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" ")), i = t.concat("char charCode key keyCode".split(" ")), n = t.concat("touches targetTouches changedTouches scale rotation".split(" ")), s = "preventDefault", a = function(t) {
            return function() {
                t[s] ? t[s]() : t.returnValue = !1;
            };
        }, r = "stopPropagation", l = function(t) {
            return function() {
                t[r] ? t[r]() : t.cancelBubble = !0;
            };
        }, h = function(t) {
            return function() {
                t[s](), t[r](), t.stopped = !0;
            };
        }, c = function(t, e, i) {
            var n, o;
            for (n = i.length; n--; ) o = i[n], !(o in e) && o in t && (e[o] = t[o]);
        };
        return function(p, g) {
            var f = {
                originalEvent: p,
                isNative: g
            };
            if (!p) return f;
            var v, b = p.type, C = p.target || p.srcElement;
            return f[s] = a(p), f[r] = l(p), f.stop = h(f), f.target = C && 3 === C.nodeType ? C.parentNode : C, 
            g && (-1 !== b.indexOf("key") ? (v = i, f.keyCode = p.which || p.keyCode) : m.test(b) ? (v = e, 
            f.rightClick = 3 === p.which || 2 === p.button, f.pos = {
                x: 0,
                y: 0
            }, p.pageX || p.pageY ? (f.clientX = p.pageX, f.clientY = p.pageY) : (p.clientX || p.clientY) && (f.clientX = p.clientX + d.body.scrollLeft + u.scrollLeft, 
            f.clientY = p.clientY + d.body.scrollTop + u.scrollTop), o.test(b) && (f.relatedTarget = p.relatedTarget || p[("mouseover" === b ? "from" : "to") + "Element"])) : y.test(b) && (v = n), 
            c(p, f, v || t)), f;
        };
    }(), S = function(t, e) {
        return p || e || t !== d && t !== i ? t : u;
    }, x = function() {
        function t(t, e, i, n, o) {
            this.element = t, this.type = e, this.handler = i, this.original = n, this.namespaces = o, 
            this.custom = C[e], this.isNative = b[e] && t[g], this.eventType = p || this.isNative ? e : "propertychange", 
            this.customType = !p && !this.isNative && e, this.target = S(t, this.isNative), 
            this.eventSupport = this.target[g];
        }
        return t.prototype = {
            inNamespaces: function(t) {
                var e, i;
                if (!t) return !0;
                if (!this.namespaces) return !1;
                for (e = t.length; e--; ) for (i = this.namespaces.length; i--; ) if (t[e] === this.namespaces[i]) return !0;
                return !1;
            },
            matches: function(t, e, i) {
                return !(this.element !== t || e && this.original !== e || i && this.handler !== i);
            }
        }, t;
    }(), k = function() {
        var t = {}, e = function(i, n, o, s, a) {
            if (n && "*" !== n) {
                var r, l = 0, h = t["$" + n], c = "*" === i;
                if (!h) return;
                for (r = h.length; r > l; l++) if ((c || h[l].matches(i, o, s)) && !a(h[l], h, l, n)) return;
            } else for (var d in t) "$" === d.charAt(0) && e(i, d.substr(1), o, s, a);
        }, i = function(e, i, n) {
            var o, s = t["$" + i];
            if (s) for (o = s.length; o--; ) if (s[o].matches(e, n, null)) return !0;
            return !1;
        }, n = function(t, i, n) {
            var o = [];
            return e(t, i, n, null, function(t) {
                return o.push(t);
            }), o;
        }, o = function(e) {
            return (t["$" + e.type] || (t["$" + e.type] = [])).push(e), e;
        }, s = function(i) {
            e(i.element, i.type, null, i.handler, function(e, i, n) {
                return i.splice(n, 1), 0 === i.length && delete t["$" + e.type], !1;
            });
        }, a = function() {
            var e, i = [];
            for (e in t) "$" === e.charAt(0) && (i = i.concat(t[e]));
            return i;
        };
        return {
            has: i,
            get: n,
            put: o,
            del: s,
            entries: a
        };
    }(), P = p ? function(t, e, i, n) {
        t[n ? r : h](e, i, !1);
    } : function(t, e, i, n, o) {
        o && n && null === t["_on" + o] && (t["_on" + o] = 0), t[n ? l : c]("on" + e, i);
    }, T = function(t, e, n) {
        return function(o) {
            return o = w(o || ((this.ownerDocument || this.document || this).parentWindow || i).event, !0), 
            e.apply(t, [ o ].concat(n));
        };
    }, M = function(t, e, n, o, s, a) {
        return function(r) {
            (o ? o.apply(this, arguments) : p ? !0 : r && r.propertyName === "_on" + n || !r) && (r && (r = w(r || ((this.ownerDocument || this.document || this).parentWindow || i).event, a)), 
            e.apply(t, !r || s && 0 !== s.length ? f.call(arguments, r ? 0 : 1).concat(s) : arguments));
        };
    }, I = function(t, e, i, n, o) {
        return function() {
            t(e, i, o), n.apply(this, arguments);
        };
    }, D = function(t, e, i, n) {
        var o, s, r, l = e && e.replace(a, ""), h = k.get(t, l, i);
        for (o = 0, s = h.length; s > o; o++) h[o].inNamespaces(n) && ((r = h[o]).eventSupport && P(r.target, r.eventType, r.handler, !1, r.type), 
        k.del(r));
    }, $ = function(t, e, i, n, o) {
        var r, l = e.replace(a, ""), h = e.replace(s, "").split(".");
        return k.has(t, l, i) ? t : ("unload" === l && (i = I(D, t, l, i, n)), C[l] && (C[l].condition && (i = M(t, i, l, C[l].condition, !0)), 
        l = C[l].base || l), r = k.put(new x(t, l, i, n, h[0] && h)), r.handler = r.isNative ? T(t, r.handler, o) : M(t, r.handler, l, !1, o, !1), 
        r.eventSupport && P(r.target, r.eventType, r.handler, !0, r.customType), void 0);
    }, A = function(t, e, i) {
        return function(n) {
            var o, s, a = "string" == typeof t ? i(t, this) : t;
            for (o = n.target; o && o !== this; o = o.parentNode) for (s = a.length; s--; ) if (a[s] === o) return e.apply(o, arguments);
        };
    }, F = function(t, e, i) {
        var n, o, r, l, h = D, c = e && "string" == typeof e;
        if (c && e.indexOf(" ") > 0) {
            for (e = e.split(" "), l = e.length; l--; ) F(t, e[l], i);
            return t;
        }
        if (o = c && e.replace(a, ""), o && C[o] && (o = C[o].type), !e || c) (r = c && e.replace(s, "")) && (r = r.split(".")), 
        h(t, o, i, r); else if ("function" == typeof e) h(t, null, e); else for (n in e) e.hasOwnProperty(n) && F(t, n, e[n]);
        return t;
    }, R = function(t, e, i, n, o) {
        var s, a, r, l, h = i, c = i && "string" == typeof i;
        if (e && !i && "object" == typeof e) for (s in e) e.hasOwnProperty(s) && R.apply(this, [ t, s, e[s] ]); else for (l = arguments.length > 3 ? f.call(arguments, 3) : [], 
        a = (c ? i : e).split(" "), c && (i = A(e, h = n, o)) && (l = f.call(l, 1)), this === v && (i = I(F, t, e, i, h)), 
        r = a.length; r--; ) $(t, a[r], i, h, l);
        return t;
    }, B = function() {
        return R.apply(v, arguments);
    }, _ = p ? function(t, e, n) {
        var o = d.createEvent(t ? "HTMLEvents" : "UIEvents");
        o[t ? "initEvent" : "initUIEvent"](e, !0, !0, i, 1), n.dispatchEvent(o);
    } : function(t, e, i) {
        i = S(i, t), t ? i.fireEvent("on" + e, d.createEventObject()) : i["_on" + e]++;
    }, H = function(t, e, i) {
        var n, o, r, l, h, c = e.split(" ");
        for (n = c.length; n--; ) if (e = c[n].replace(a, ""), (l = c[n].replace(s, "")) && (l = l.split(".")), 
        l || i || !t[g]) for (h = k.get(t, e), i = [ !1 ].concat(i), o = 0, r = h.length; r > o; o++) h[o].inNamespaces(l) && h[o].handler.apply(t, i); else _(b[e], e, t);
        return t;
    }, O = function(t, e, i) {
        for (var n = 0, o = k.get(e, i), s = o.length; s > n; n++) o[n].original && R(t, o[n].type, o[n].original);
        return t;
    }, L = {
        add: R,
        one: B,
        remove: F,
        clone: O,
        fire: H,
        noConflict: function() {
            return e[t] = n, this;
        }
    };
    if (i[l]) {
        var N = function() {
            var t, e = k.entries();
            for (t in e) e[t].type && "unload" !== e[t].type && F(e[t].element, e[t].type);
            i[c]("onunload", N), i.CollectGarbage && i.CollectGarbage();
        };
        i[l]("onunload", N);
    }
    return L;
}), function() {
    var t = this, e = t._, i = {}, n = Array.prototype, o = Object.prototype, s = Function.prototype, a = n.slice, r = n.unshift, l = o.toString, h = o.hasOwnProperty, c = n.forEach, d = n.map, u = n.reduce, p = n.reduceRight, g = n.filter, f = n.every, m = n.some, y = n.indexOf, v = n.lastIndexOf, b = Array.isArray, C = Object.keys, w = s.bind, S = function(t) {
        return new M(t);
    };
    "undefined" != typeof module && module.exports ? (module.exports = S, S._ = S) : t._ = S, 
    S.VERSION = "1.1.7";
    var x = S.each = S.forEach = function(t, e, n) {
        if (null != t) if (c && t.forEach === c) t.forEach(e, n); else if (t.length === +t.length) {
            for (var o = 0, s = t.length; s > o; o++) if (o in t && e.call(n, t[o], o, t) === i) return;
        } else for (var a in t) if (h.call(t, a) && e.call(n, t[a], a, t) === i) return;
    };
    S.map = function(t, e, i) {
        var n = [];
        return null == t ? n : d && t.map === d ? t.map(e, i) : (x(t, function(t, o, s) {
            n[n.length] = e.call(i, t, o, s);
        }), n);
    }, S.reduce = S.foldl = S.inject = function(t, e, i, n) {
        var o = void 0 !== i;
        if (null == t && (t = []), u && t.reduce === u) return n && (e = S.bind(e, n)), 
        o ? t.reduce(e, i) : t.reduce(e);
        if (x(t, function(t, s, a) {
            o ? i = e.call(n, i, t, s, a) : (i = t, o = !0);
        }), !o) throw new TypeError("Reduce of empty array with no initial value");
        return i;
    }, S.reduceRight = S.foldr = function(t, e, i, n) {
        if (null == t && (t = []), p && t.reduceRight === p) return n && (e = S.bind(e, n)), 
        void 0 !== i ? t.reduceRight(e, i) : t.reduceRight(e);
        var o = (S.isArray(t) ? t.slice() : S.toArray(t)).reverse();
        return S.reduce(o, e, i, n);
    }, S.find = S.detect = function(t, e, i) {
        var n;
        return k(t, function(t, o, s) {
            return e.call(i, t, o, s) ? (n = t, !0) : void 0;
        }), n;
    }, S.filter = S.select = function(t, e, i) {
        var n = [];
        return null == t ? n : g && t.filter === g ? t.filter(e, i) : (x(t, function(t, o, s) {
            e.call(i, t, o, s) && (n[n.length] = t);
        }), n);
    }, S.reject = function(t, e, i) {
        var n = [];
        return null == t ? n : (x(t, function(t, o, s) {
            e.call(i, t, o, s) || (n[n.length] = t);
        }), n);
    }, S.every = S.all = function(t, e, n) {
        var o = !0;
        return null == t ? o : f && t.every === f ? t.every(e, n) : (x(t, function(t, s, a) {
            return (o = o && e.call(n, t, s, a)) ? void 0 : i;
        }), o);
    };
    var k = S.some = S.any = function(t, e, n) {
        e = e || S.identity;
        var o = !1;
        return null == t ? o : m && t.some === m ? t.some(e, n) : (x(t, function(t, s, a) {
            return (o |= e.call(n, t, s, a)) ? i : void 0;
        }), !!o);
    };
    S.include = S.contains = function(t, e) {
        var i = !1;
        return null == t ? i : y && t.indexOf === y ? -1 != t.indexOf(e) : (k(t, function(t) {
            return (i = t === e) ? !0 : void 0;
        }), i);
    }, S.invoke = function(t, e) {
        var i = a.call(arguments, 2);
        return S.map(t, function(t) {
            return (e.call ? e || t : t[e]).apply(t, i);
        });
    }, S.pluck = function(t, e) {
        return S.map(t, function(t) {
            return t[e];
        });
    }, S.max = function(t, e, i) {
        if (!e && S.isArray(t)) return Math.max.apply(Math, t);
        var n = {
            computed: -1/0
        };
        return x(t, function(t, o, s) {
            var a = e ? e.call(i, t, o, s) : t;
            a >= n.computed && (n = {
                value: t,
                computed: a
            });
        }), n.value;
    }, S.min = function(t, e, i) {
        if (!e && S.isArray(t)) return Math.min.apply(Math, t);
        var n = {
            computed: 1/0
        };
        return x(t, function(t, o, s) {
            var a = e ? e.call(i, t, o, s) : t;
            n.computed > a && (n = {
                value: t,
                computed: a
            });
        }), n.value;
    }, S.sortBy = function(t, e, i) {
        return S.pluck(S.map(t, function(t, n, o) {
            return {
                value: t,
                criteria: e.call(i, t, n, o)
            };
        }).sort(function(t, e) {
            var i = t.criteria, n = e.criteria;
            return n > i ? -1 : i > n ? 1 : 0;
        }), "value");
    }, S.groupBy = function(t, e) {
        var i = {};
        return x(t, function(t, n) {
            var o = e(t, n);
            (i[o] || (i[o] = [])).push(t);
        }), i;
    }, S.sortedIndex = function(t, e, i) {
        i || (i = S.identity);
        for (var n = 0, o = t.length; o > n; ) {
            var s = n + o >> 1;
            i(t[s]) < i(e) ? n = s + 1 : o = s;
        }
        return n;
    }, S.toArray = function(t) {
        return t ? t.toArray ? t.toArray() : S.isArray(t) ? a.call(t) : S.isArguments(t) ? a.call(t) : S.values(t) : [];
    }, S.size = function(t) {
        return S.toArray(t).length;
    }, S.first = S.head = function(t, e, i) {
        return null == e || i ? t[0] : a.call(t, 0, e);
    }, S.rest = S.tail = function(t, e, i) {
        return a.call(t, null == e || i ? 1 : e);
    }, S.last = function(t) {
        return t[t.length - 1];
    }, S.compact = function(t) {
        return S.filter(t, function(t) {
            return !!t;
        });
    }, S.flatten = function(t) {
        return S.reduce(t, function(t, e) {
            return S.isArray(e) ? t.concat(S.flatten(e)) : (t[t.length] = e, t);
        }, []);
    }, S.without = function(t) {
        return S.difference(t, a.call(arguments, 1));
    }, S.uniq = S.unique = function(t, e) {
        return S.reduce(t, function(t, i, n) {
            return 0 != n && (e === !0 ? S.last(t) == i : S.include(t, i)) || (t[t.length] = i), 
            t;
        }, []);
    }, S.union = function() {
        return S.uniq(S.flatten(arguments));
    }, S.intersection = S.intersect = function(t) {
        var e = a.call(arguments, 1);
        return S.filter(S.uniq(t), function(t) {
            return S.every(e, function(e) {
                return S.indexOf(e, t) >= 0;
            });
        });
    }, S.difference = function(t, e) {
        return S.filter(t, function(t) {
            return !S.include(e, t);
        });
    }, S.zip = function() {
        for (var t = a.call(arguments), e = S.max(S.pluck(t, "length")), i = Array(e), n = 0; e > n; n++) i[n] = S.pluck(t, "" + n);
        return i;
    }, S.indexOf = function(t, e, i) {
        if (null == t) return -1;
        var n, o;
        if (i) return n = S.sortedIndex(t, e), t[n] === e ? n : -1;
        if (y && t.indexOf === y) return t.indexOf(e);
        for (n = 0, o = t.length; o > n; n++) if (t[n] === e) return n;
        return -1;
    }, S.lastIndexOf = function(t, e) {
        if (null == t) return -1;
        if (v && t.lastIndexOf === v) return t.lastIndexOf(e);
        for (var i = t.length; i--; ) if (t[i] === e) return i;
        return -1;
    }, S.range = function(t, e, i) {
        1 >= arguments.length && (e = t || 0, t = 0), i = arguments[2] || 1;
        for (var n = Math.max(Math.ceil((e - t) / i), 0), o = 0, s = Array(n); n > o; ) s[o++] = t, 
        t += i;
        return s;
    }, S.bind = function(t, e) {
        if (t.bind === w && w) return w.apply(t, a.call(arguments, 1));
        var i = a.call(arguments, 2);
        return function() {
            return t.apply(e, i.concat(a.call(arguments)));
        };
    }, S.bindAll = function(t) {
        var e = a.call(arguments, 1);
        return 0 == e.length && (e = S.functions(t)), x(e, function(e) {
            t[e] = S.bind(t[e], t);
        }), t;
    }, S.memoize = function(t, e) {
        var i = {};
        return e || (e = S.identity), function() {
            var n = e.apply(this, arguments);
            return h.call(i, n) ? i[n] : i[n] = t.apply(this, arguments);
        };
    }, S.delay = function(t, e) {
        var i = a.call(arguments, 2);
        return setTimeout(function() {
            return t.apply(t, i);
        }, e);
    }, S.defer = function(t) {
        return S.delay.apply(S, [ t, 1 ].concat(a.call(arguments, 1)));
    };
    var P = function(t, e, i) {
        var n;
        return function() {
            var o = this, s = arguments, a = function() {
                n = null, t.apply(o, s);
            };
            i && clearTimeout(n), (i || !n) && (n = setTimeout(a, e));
        };
    };
    S.throttle = function(t, e) {
        return P(t, e, !1);
    }, S.debounce = function(t, e) {
        return P(t, e, !0);
    }, S.once = function(t) {
        var e, i = !1;
        return function() {
            return i ? e : (i = !0, e = t.apply(this, arguments));
        };
    }, S.wrap = function(t, e) {
        return function() {
            var i = [ t ].concat(a.call(arguments));
            return e.apply(this, i);
        };
    }, S.compose = function() {
        var t = a.call(arguments);
        return function() {
            for (var e = a.call(arguments), i = t.length - 1; i >= 0; i--) e = [ t[i].apply(this, e) ];
            return e[0];
        };
    }, S.after = function(t, e) {
        return function() {
            return 1 > --t ? e.apply(this, arguments) : void 0;
        };
    }, S.keys = C || function(t) {
        if (t !== Object(t)) throw new TypeError("Invalid object");
        var e = [];
        for (var i in t) h.call(t, i) && (e[e.length] = i);
        return e;
    }, S.values = function(t) {
        return S.map(t, S.identity);
    }, S.functions = S.methods = function(t) {
        var e = [];
        for (var i in t) S.isFunction(t[i]) && e.push(i);
        return e.sort();
    }, S.extend = function(t) {
        return x(a.call(arguments, 1), function(e) {
            for (var i in e) void 0 !== e[i] && (t[i] = e[i]);
        }), t;
    }, S.defaults = function(t) {
        return x(a.call(arguments, 1), function(e) {
            for (var i in e) null == t[i] && (t[i] = e[i]);
        }), t;
    }, S.clone = function(t) {
        return S.isArray(t) ? t.slice() : S.extend({}, t);
    }, S.tap = function(t, e) {
        return e(t), t;
    }, S.isEqual = function(t, e) {
        if (t === e) return !0;
        var i = typeof t, n = typeof e;
        if (i != n) return !1;
        if (t == e) return !0;
        if (!t && e || t && !e) return !1;
        if (t._chain && (t = t._wrapped), e._chain && (e = e._wrapped), t.isEqual) return t.isEqual(e);
        if (e.isEqual) return e.isEqual(t);
        if (S.isDate(t) && S.isDate(e)) return t.getTime() === e.getTime();
        if (S.isNaN(t) && S.isNaN(e)) return !1;
        if (S.isRegExp(t) && S.isRegExp(e)) return t.source === e.source && t.global === e.global && t.ignoreCase === e.ignoreCase && t.multiline === e.multiline;
        if ("object" !== i) return !1;
        if (t.length && t.length !== e.length) return !1;
        var o = S.keys(t), s = S.keys(e);
        if (o.length != s.length) return !1;
        for (var a in t) if (!(a in e && S.isEqual(t[a], e[a]))) return !1;
        return !0;
    }, S.isEmpty = function(t) {
        if (S.isArray(t) || S.isString(t)) return 0 === t.length;
        for (var e in t) if (h.call(t, e)) return !1;
        return !0;
    }, S.isElement = function(t) {
        return !!t && 1 == t.nodeType;
    }, S.isArray = b || function(t) {
        return "[object Array]" === l.call(t);
    }, S.isObject = function(t) {
        return t === Object(t);
    }, S.isArguments = function(t) {
        return !!t && !!h.call(t, "callee");
    }, S.isFunction = function(t) {
        return !!(t && t.constructor && t.call && t.apply);
    }, S.isString = function(t) {
        return !!("" === t || t && t.charCodeAt && t.substr);
    }, S.isNumber = function(t) {
        return !!(0 === t || t && t.toExponential && t.toFixed);
    }, S.isNaN = function(t) {
        return t !== t;
    }, S.isBoolean = function(t) {
        return t === !0 || t === !1;
    }, S.isDate = function(t) {
        return !!(t && t.getTimezoneOffset && t.setUTCFullYear);
    }, S.isRegExp = function(t) {
        return !(!(t && t.test && t.exec) || !t.ignoreCase && t.ignoreCase !== !1);
    }, S.isNull = function(t) {
        return null === t;
    }, S.isUndefined = function(t) {
        return void 0 === t;
    }, S.noConflict = function() {
        return t._ = e, this;
    }, S.identity = function(t) {
        return t;
    }, S.times = function(t, e, i) {
        for (var n = 0; t > n; n++) e.call(i, n);
    }, S.mixin = function(t) {
        x(S.functions(t), function(e) {
            D(e, S[e] = t[e]);
        });
    };
    var T = 0;
    S.uniqueId = function(t) {
        var e = T++;
        return t ? t + e : e;
    }, S.templateSettings = {
        evaluate: /<%([\s\S]+?)%>/g,
        interpolate: /<%=([\s\S]+?)%>/g
    }, S.template = function(t, e) {
        var i = S.templateSettings, n = "var __p=[],print=function(){__p.push.apply(__p,arguments);};with(obj||{}){__p.push('" + t.replace(/\\/g, "\\\\").replace(/'/g, "\\'").replace(i.interpolate, function(t, e) {
            return "'," + e.replace(/\\'/g, "'") + ",'";
        }).replace(i.evaluate || null, function(t, e) {
            return "');" + e.replace(/\\'/g, "'").replace(/[\r\n\t]/g, " ") + "__p.push('";
        }).replace(/\r/g, "\\r").replace(/\n/g, "\\n").replace(/\t/g, "\\t") + "');}return __p.join('');", o = Function("obj", n);
        return e ? o(e) : o;
    };
    var M = function(t) {
        this._wrapped = t;
    };
    S.prototype = M.prototype;
    var I = function(t, e) {
        return e ? S(t).chain() : t;
    }, D = function(t, e) {
        M.prototype[t] = function() {
            var t = a.call(arguments);
            return r.call(t, this._wrapped), I(e.apply(S, t), this._chain);
        };
    };
    S.mixin(S), x([ "pop", "push", "reverse", "shift", "sort", "splice", "unshift" ], function(t) {
        var e = n[t];
        M.prototype[t] = function() {
            return e.apply(this._wrapped, arguments), I(this._wrapped, this._chain);
        };
    }), x([ "concat", "join", "slice" ], function(t) {
        var e = n[t];
        M.prototype[t] = function() {
            return I(e.apply(this._wrapped, arguments), this._chain);
        };
    }), M.prototype.chain = function() {
        return this._chain = !0, this;
    }, M.prototype.value = function() {
        return this._wrapped;
    };
}(), function() {
    var t, e = this, i = this.Flotr;
    t = {
        _: _,
        bean: bean,
        isIphone: /iphone/i.test(navigator.userAgent),
        isIE: -1 != navigator.appVersion.indexOf("MSIE") ? parseFloat(navigator.appVersion.split("MSIE")[1]) : !1,
        graphTypes: {},
        plugins: {},
        addType: function(e, i) {
            t.graphTypes[e] = i, t.defaultOptions[e] = i.options || {}, t.defaultOptions.defaultType = t.defaultOptions.defaultType || e;
        },
        addPlugin: function(e, i) {
            t.plugins[e] = i, t.defaultOptions[e] = i.options || {};
        },
        draw: function(e, i, n, o) {
            return o = o || t.Graph, new o(e, i, n);
        },
        merge: function(e, i) {
            var n, o, s = i || {};
            for (n in e) o = e[n], s[n] = o && "object" == typeof o ? o.constructor === Array ? this._.clone(o) : o.constructor === RegExp || this._.isElement(o) || o.jquery ? o : t.merge(o, i ? i[n] : void 0) : o;
            return s;
        },
        clone: function(e) {
            return t.merge(e, {});
        },
        getTickSize: function(e, i, n, o) {
            var s = (n - i) / e, a = t.getMagnitude(s), r = 10, l = s / a;
            return 1.5 > l ? r = 1 : 2.25 > l ? r = 2 : 3 > l ? r = 0 === o ? 2 : 2.5 : 7.5 > l && (r = 5), 
            r * a;
        },
        defaultTickFormatter: function(t) {
            return t + "";
        },
        defaultTrackFormatter: function(t) {
            return "(" + t.x + ", " + t.y + ")";
        },
        engineeringNotation: function(t, e, i) {
            var n = [ "Y", "Z", "E", "P", "T", "G", "M", "k", "" ], o = [ "y", "z", "a", "f", "p", "n", "\u00b5", "m", "" ], s = n.length;
            if (i = i || 1e3, e = Math.pow(10, e || 2), 0 === t) return 0;
            if (t > 1) for (;s-- && t >= i; ) t /= i; else for (n = o, s = n.length; s-- && 1 > t; ) t *= i;
            return Math.round(t * e) / e + n[s];
        },
        getMagnitude: function(t) {
            return Math.pow(10, Math.floor(Math.log(t) / Math.LN10));
        },
        toPixel: function(t) {
            return Math.floor(t) + .5;
        },
        toRad: function(t) {
            return -t * (Math.PI / 180);
        },
        floorInBase: function(t, e) {
            return e * Math.floor(t / e);
        },
        drawText: function(e, i, n, o, s) {
            return e.fillText ? (s = this._.extend({
                size: t.defaultOptions.fontSize,
                color: "#000000",
                textAlign: "left",
                textBaseline: "bottom",
                weight: 1,
                angle: 0
            }, s), e.save(), e.translate(n, o), e.rotate(s.angle), e.fillStyle = s.color, e.font = (s.weight > 1 ? "bold " : "") + 1.3 * s.size + "px sans-serif", 
            e.textAlign = s.textAlign, e.textBaseline = s.textBaseline, e.fillText(i, 0, 0), 
            e.restore(), void 0) : (e.drawText(i, n, o, s), void 0);
        },
        getBestTextAlign: function(e, i) {
            return i = i || {
                textAlign: "center",
                textBaseline: "middle"
            }, e += t.getTextAngleFromAlign(i), Math.abs(Math.cos(e)) > .01 && (i.textAlign = Math.cos(e) > 0 ? "right" : "left"), 
            Math.abs(Math.sin(e)) > .01 && (i.textBaseline = Math.sin(e) > 0 ? "top" : "bottom"), 
            i;
        },
        alignTable: {
            "right middle": 0,
            "right top": Math.PI / 4,
            "center top": Math.PI / 2,
            "left top": 3 * (Math.PI / 4),
            "left middle": Math.PI,
            "left bottom": -3 * (Math.PI / 4),
            "center bottom": -Math.PI / 2,
            "right bottom": -Math.PI / 4,
            "center middle": 0
        },
        getTextAngleFromAlign: function(e) {
            return t.alignTable[e.textAlign + " " + e.textBaseline] || 0;
        },
        noConflict: function() {
            return e.Flotr = i, this;
        }
    }, e.Flotr = t;
}(), Flotr.defaultOptions = {
    colors: [ "#00A8F0", "#C0D800", "#CB4B4B", "#4DA74D", "#9440ED" ],
    ieBackgroundColor: "#FFFFFF",
    title: null,
    subtitle: null,
    shadowSize: 4,
    defaultType: null,
    HtmlText: !0,
    fontColor: "#545454",
    fontSize: 7.5,
    resolution: 1,
    parseFloat: !0,
    preventDefault: !0,
    xaxis: {
        ticks: null,
        minorTicks: null,
        showLabels: !0,
        showMinorLabels: !1,
        labelsAngle: 0,
        title: null,
        titleAngle: 0,
        noTicks: 5,
        minorTickFreq: null,
        tickFormatter: Flotr.defaultTickFormatter,
        tickDecimals: null,
        min: null,
        max: null,
        autoscale: !1,
        autoscaleMargin: 0,
        color: null,
        mode: "normal",
        timeFormat: null,
        timeMode: "UTC",
        timeUnit: "millisecond",
        scaling: "linear",
        base: Math.E,
        titleAlign: "center",
        margin: !0
    },
    x2axis: {},
    yaxis: {
        ticks: null,
        minorTicks: null,
        showLabels: !0,
        showMinorLabels: !1,
        labelsAngle: 0,
        title: null,
        titleAngle: 90,
        noTicks: 5,
        minorTickFreq: null,
        tickFormatter: Flotr.defaultTickFormatter,
        tickDecimals: null,
        min: null,
        max: null,
        autoscale: !1,
        autoscaleMargin: 0,
        color: null,
        scaling: "linear",
        base: Math.E,
        titleAlign: "center",
        margin: !0
    },
    y2axis: {
        titleAngle: 270
    },
    grid: {
        color: "#545454",
        backgroundColor: null,
        backgroundImage: null,
        watermarkAlpha: .4,
        tickColor: "#DDDDDD",
        labelMargin: 3,
        verticalLines: !0,
        minorVerticalLines: null,
        horizontalLines: !0,
        minorHorizontalLines: null,
        outlineWidth: 1,
        outline: "nsew",
        circular: !1
    },
    mouse: {
        track: !1,
        trackAll: !1,
        position: "se",
        relative: !1,
        trackFormatter: Flotr.defaultTrackFormatter,
        margin: 5,
        lineColor: "#FF3F19",
        trackDecimals: 1,
        sensibility: 2,
        trackY: !0,
        radius: 3,
        fillColor: null,
        fillOpacity: .4
    }
}, function() {
    function t() {
        this.rgba = [ "r", "g", "b", "a" ];
        for (var t = 4; --t > -1; ) this[this.rgba[t]] = arguments[t] || (3 == t ? 1 : 0);
        this.normalize();
    }
    var e = Flotr._, i = {
        aqua: [ 0, 255, 255 ],
        azure: [ 240, 255, 255 ],
        beige: [ 245, 245, 220 ],
        black: [ 0, 0, 0 ],
        blue: [ 0, 0, 255 ],
        brown: [ 165, 42, 42 ],
        cyan: [ 0, 255, 255 ],
        darkblue: [ 0, 0, 139 ],
        darkcyan: [ 0, 139, 139 ],
        darkgrey: [ 169, 169, 169 ],
        darkgreen: [ 0, 100, 0 ],
        darkkhaki: [ 189, 183, 107 ],
        darkmagenta: [ 139, 0, 139 ],
        darkolivegreen: [ 85, 107, 47 ],
        darkorange: [ 255, 140, 0 ],
        darkorchid: [ 153, 50, 204 ],
        darkred: [ 139, 0, 0 ],
        darksalmon: [ 233, 150, 122 ],
        darkviolet: [ 148, 0, 211 ],
        fuchsia: [ 255, 0, 255 ],
        gold: [ 255, 215, 0 ],
        green: [ 0, 128, 0 ],
        indigo: [ 75, 0, 130 ],
        khaki: [ 240, 230, 140 ],
        lightblue: [ 173, 216, 230 ],
        lightcyan: [ 224, 255, 255 ],
        lightgreen: [ 144, 238, 144 ],
        lightgrey: [ 211, 211, 211 ],
        lightpink: [ 255, 182, 193 ],
        lightyellow: [ 255, 255, 224 ],
        lime: [ 0, 255, 0 ],
        magenta: [ 255, 0, 255 ],
        maroon: [ 128, 0, 0 ],
        navy: [ 0, 0, 128 ],
        olive: [ 128, 128, 0 ],
        orange: [ 255, 165, 0 ],
        pink: [ 255, 192, 203 ],
        purple: [ 128, 0, 128 ],
        violet: [ 128, 0, 128 ],
        red: [ 255, 0, 0 ],
        silver: [ 192, 192, 192 ],
        white: [ 255, 255, 255 ],
        yellow: [ 255, 255, 0 ]
    };
    t.prototype = {
        scale: function() {
            for (var t = 4; --t > -1; ) e.isUndefined(arguments[t]) || (this[this.rgba[t]] *= arguments[t]);
            return this.normalize();
        },
        alpha: function(t) {
            return !e.isUndefined(t) && !e.isNull(t) && (this.a = t), this.normalize();
        },
        clone: function() {
            return new t(this.r, this.b, this.g, this.a);
        },
        limit: function(t, e, i) {
            return Math.max(Math.min(t, i), e);
        },
        normalize: function() {
            var t = this.limit;
            return this.r = t(parseInt(this.r, 10), 0, 255), this.g = t(parseInt(this.g, 10), 0, 255), 
            this.b = t(parseInt(this.b, 10), 0, 255), this.a = t(this.a, 0, 1), this;
        },
        distance: function(e) {
            if (e) {
                e = new t.parse(e);
                for (var i = 0, n = 3; --n > -1; ) i += Math.abs(this[this.rgba[n]] - e[this.rgba[n]]);
                return i;
            }
        },
        toString: function() {
            return this.a >= 1 ? "rgb(" + [ this.r, this.g, this.b ].join(",") + ")" : "rgba(" + [ this.r, this.g, this.b, this.a ].join(",") + ")";
        },
        contrast: function() {
            var t = 1 - (.299 * this.r + .587 * this.g + .114 * this.b) / 255;
            return .5 > t ? "#000000" : "#ffffff";
        }
    }, e.extend(t, {
        parse: function(e) {
            if (e instanceof t) return e;
            var n;
            if (n = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(e)) return new t(parseInt(n[1], 16), parseInt(n[2], 16), parseInt(n[3], 16));
            if (n = /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(e)) return new t(parseInt(n[1], 10), parseInt(n[2], 10), parseInt(n[3], 10));
            if (n = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(e)) return new t(parseInt(n[1] + n[1], 16), parseInt(n[2] + n[2], 16), parseInt(n[3] + n[3], 16));
            if (n = /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(e)) return new t(parseInt(n[1], 10), parseInt(n[2], 10), parseInt(n[3], 10), parseFloat(n[4]));
            if (n = /rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(e)) return new t(2.55 * parseFloat(n[1]), 2.55 * parseFloat(n[2]), 2.55 * parseFloat(n[3]));
            if (n = /rgba\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(e)) return new t(2.55 * parseFloat(n[1]), 2.55 * parseFloat(n[2]), 2.55 * parseFloat(n[3]), parseFloat(n[4]));
            var o = (e + "").replace(/^\s*([\S\s]*?)\s*$/, "$1").toLowerCase();
            return "transparent" == o ? new t(255, 255, 255, 0) : (n = i[o]) ? new t(n[0], n[1], n[2]) : new t(0, 0, 0, 0);
        },
        processColor: function(i, n) {
            var o = n.opacity;
            if (!i) return "rgba(0, 0, 0, 0)";
            if (i instanceof t) return "" + i.alpha(o);
            if (e.isString(i)) return "" + t.parse(i).alpha(o);
            var s = i.colors ? i : {
                colors: i
            };
            if (!n.ctx) return e.isArray(s.colors) ? "" + t.parse(e.isArray(s.colors[0]) ? s.colors[0][1] : s.colors[0]).alpha(o) : "rgba(0, 0, 0, 0)";
            s = e.extend({
                start: "top",
                end: "bottom"
            }, s), /top/i.test(s.start) && (n.x1 = 0), /left/i.test(s.start) && (n.y1 = 0), 
            /bottom/i.test(s.end) && (n.x2 = 0), /right/i.test(s.end) && (n.y2 = 0);
            var a, r, l, h = n.ctx.createLinearGradient(n.x1, n.y1, n.x2, n.y2);
            for (a = 0; s.colors.length > a; a++) r = s.colors[a], e.isArray(r) ? (l = r[0], 
            r = r[1]) : l = a / (s.colors.length - 1), h.addColorStop(l, t.parse(r).alpha(o));
            return h;
        }
    }), Flotr.Color = t;
}(), Flotr.Date = {
    set: function(t, e, i, n) {
        i = i || "UTC", e = "set" + ("UTC" === i ? "UTC" : "") + e, t[e](n);
    },
    get: function(t, e, i) {
        return i = i || "UTC", e = "get" + ("UTC" === i ? "UTC" : "") + e, t[e]();
    },
    format: function(t, e, i) {
        function n(t) {
            return t += "", 1 == t.length ? "0" + t : t;
        }
        if (t) {
            for (var o, s = this.get, a = {
                h: "" + s(t, "Hours", i),
                H: n(s(t, "Hours", i)),
                M: n(s(t, "Minutes", i)),
                S: n(s(t, "Seconds", i)),
                s: s(t, "Milliseconds", i),
                d: "" + s(t, "Date", i),
                m: "" + (s(t, "Month", i) + 1),
                y: "" + s(t, "FullYear", i),
                b: Flotr.Date.monthNames[s(t, "Month", i)]
            }, r = [], l = !1, h = 0; e.length > h; ++h) o = e.charAt(h), l ? (r.push(a[o] || o), 
            l = !1) : "%" == o ? l = !0 : r.push(o);
            return r.join("");
        }
    },
    getFormat: function(t, e) {
        var i = Flotr.Date.timeUnits;
        return i.second > t ? "%h:%M:%S.%s" : i.minute > t ? "%h:%M:%S" : i.day > t ? 2 * i.day > e ? "%h:%M" : "%b %d %h:%M" : i.month > t ? "%b %d" : i.year > t ? i.year > e ? "%b" : "%b %y" : "%y";
    },
    formatter: function(t, e) {
        var i = e.options, n = Flotr.Date.timeUnits[i.timeUnit], o = new Date(t * n);
        if (e.options.timeFormat) return Flotr.Date.format(o, i.timeFormat, i.timeMode);
        var s = (e.max - e.min) * n, a = e.tickSize * Flotr.Date.timeUnits[e.tickUnit];
        return Flotr.Date.format(o, Flotr.Date.getFormat(a, s), i.timeMode);
    },
    generator: function(t) {
        function e(t) {
            s(y, t, c, Flotr.floorInBase(a(y, t, c), m));
        }
        var i, n, o, s = this.set, a = this.get, r = this.timeUnits, l = this.spec, h = t.options, c = h.timeMode, d = r[h.timeUnit], u = t.min * d, p = t.max * d, g = (p - u) / h.noTicks, f = [], m = t.tickSize;
        for (n = h.tickFormatter === Flotr.defaultTickFormatter ? this.formatter : h.tickFormatter, 
        o = 0; l.length - 1 > o; ++o) {
            var y = l[o][0] * r[l[o][1]];
            if ((y + l[o + 1][0] * r[l[o + 1][1]]) / 2 > g && y >= m) break;
        }
        m = l[o][0], i = l[o][1], "year" == i && (m = Flotr.getTickSize(h.noTicks * r.year, u, p, 0), 
        .5 == m && (i = "month", m = 6)), t.tickUnit = i, t.tickSize = m;
        var v = m * r[i];
        switch (y = new Date(u), i) {
          case "millisecond":
            e("Milliseconds");
            break;

          case "second":
            e("Seconds");
            break;

          case "minute":
            e("Minutes");
            break;

          case "hour":
            e("Hours");
            break;

          case "month":
            e("Month");
            break;

          case "year":
            e("FullYear");
        }
        v >= r.second && s(y, "Milliseconds", c, 0), v >= r.minute && s(y, "Seconds", c, 0), 
        v >= r.hour && s(y, "Minutes", c, 0), v >= r.day && s(y, "Hours", c, 0), v >= 4 * r.day && s(y, "Date", c, 1), 
        v >= r.year && s(y, "Month", c, 0);
        var b, C = 0, w = 0/0;
        do if (b = w, w = y.getTime(), f.push({
            v: w / d,
            label: n(w / d, t)
        }), "month" == i) if (1 > m) {
            s(y, "Date", c, 1);
            var S = y.getTime();
            s(y, "Month", c, a(y, "Month", c) + 1);
            var x = y.getTime();
            y.setTime(w + C * r.hour + (x - S) * m), C = a(y, "Hours", c), s(y, "Hours", c, 0);
        } else s(y, "Month", c, a(y, "Month", c) + m); else "year" == i ? s(y, "FullYear", c, a(y, "FullYear", c) + m) : y.setTime(w + v); while (p > w && w != b);
        return f;
    },
    timeUnits: {
        millisecond: 1,
        second: 1e3,
        minute: 6e4,
        hour: 36e5,
        day: 864e5,
        month: 2592e6,
        year: 31556952e3
    },
    spec: [ [ 1, "millisecond" ], [ 20, "millisecond" ], [ 50, "millisecond" ], [ 100, "millisecond" ], [ 200, "millisecond" ], [ 500, "millisecond" ], [ 1, "second" ], [ 2, "second" ], [ 5, "second" ], [ 10, "second" ], [ 30, "second" ], [ 1, "minute" ], [ 2, "minute" ], [ 5, "minute" ], [ 10, "minute" ], [ 30, "minute" ], [ 1, "hour" ], [ 2, "hour" ], [ 4, "hour" ], [ 8, "hour" ], [ 12, "hour" ], [ 1, "day" ], [ 2, "day" ], [ 3, "day" ], [ .25, "month" ], [ .5, "month" ], [ 1, "month" ], [ 2, "month" ], [ 3, "month" ], [ 6, "month" ], [ 1, "year" ] ],
    monthNames: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]
}, function() {
    function t(t) {
        return t && t.jquery ? t[0] : t;
    }
    var e = Flotr._;
    Flotr.DOM = {
        addClass: function(i, n) {
            i = t(i);
            var o = i.className ? i.className : "";
            e.include(o.split(/\s+/g), n) || (i.className = (o ? o + " " : "") + n);
        },
        create: function(t) {
            return document.createElement(t);
        },
        node: function(t) {
            var e, i = Flotr.DOM.create("div");
            return i.innerHTML = t, e = i.children[0], i.innerHTML = "", e;
        },
        empty: function(e) {
            e = t(e), e.innerHTML = "";
        },
        remove: function(e) {
            e = t(e), e.parentNode.removeChild(e);
        },
        hide: function(e) {
            e = t(e), Flotr.DOM.setStyles(e, {
                display: "none"
            });
        },
        insert: function(i, n) {
            i = t(i), e.isString(n) ? i.innerHTML += n : e.isElement(n) && i.appendChild(n);
        },
        opacity: function(e, i) {
            e = t(e), e.style.opacity = i;
        },
        position: function(e, i) {
            return e = t(e), e.offsetParent ? (i = this.position(e.offsetParent), i.left += e.offsetLeft, 
            i.top += e.offsetTop, i) : {
                left: e.offsetLeft || 0,
                top: e.offsetTop || 0
            };
        },
        removeClass: function(i, n) {
            var o = i.className ? i.className : "";
            i = t(i), i.className = e.filter(o.split(/\s+/g), function(t) {
                return t != n ? !0 : void 0;
            }).join(" ");
        },
        setStyles: function(i, n) {
            i = t(i), e.each(n, function(t, e) {
                i.style[e] = t;
            });
        },
        show: function(e) {
            e = t(e), Flotr.DOM.setStyles(e, {
                display: ""
            });
        },
        size: function(e) {
            return e = t(e), {
                height: e.offsetHeight,
                width: e.offsetWidth
            };
        }
    };
}(), function() {
    var t = Flotr, e = t.bean;
    t.EventAdapter = {
        observe: function(t, i, n) {
            return e.add(t, i, n), this;
        },
        fire: function(t, i, n) {
            return e.fire(t, i, n), "undefined" != typeof Prototype && Event.fire(t, i, n), 
            this;
        },
        stopObserving: function(t, i, n) {
            return e.remove(t, i, n), this;
        },
        eventPointer: function(e) {
            if (!t._.isUndefined(e.touches) && e.touches.length > 0) return {
                x: e.touches[0].pageX,
                y: e.touches[0].pageY
            };
            if (!t._.isUndefined(e.changedTouches) && e.changedTouches.length > 0) return {
                x: e.changedTouches[0].pageX,
                y: e.changedTouches[0].pageY
            };
            if (e.pageX || e.pageY) return {
                x: e.pageX,
                y: e.pageY
            };
            if (e.clientX || e.clientY) {
                var i = document, n = i.body, o = i.documentElement;
                return {
                    x: e.clientX + n.scrollLeft + o.scrollLeft,
                    y: e.clientY + n.scrollTop + o.scrollTop
                };
            }
        }
    };
}(), function() {
    var t = Flotr, e = t.DOM, i = t._, n = function(t) {
        this.o = t;
    };
    n.prototype = {
        dimensions: function(t, e, i, n) {
            return t ? this.o.html ? this.html(t, this.o.element, i, n) : this.canvas(t, e) : {
                width: 0,
                height: 0
            };
        },
        canvas: function(e, i) {
            if (this.o.textEnabled) {
                i = i || {};
                var n, o = this.measureText(e, i), s = o.width, a = i.size || t.defaultOptions.fontSize, r = i.angle || 0, l = Math.cos(r), h = Math.sin(r), c = 2, d = 6;
                return n = {
                    width: Math.abs(l * s) + Math.abs(h * a) + c,
                    height: Math.abs(h * s) + Math.abs(l * a) + d
                };
            }
        },
        html: function(t, i, n, o) {
            var s = e.create("div");
            return e.setStyles(s, {
                position: "absolute",
                top: "-10000px"
            }), e.insert(s, '<div style="' + n + '" class="' + o + ' flotr-dummy-div">' + t + "</div>"), 
            e.insert(this.o.element, s), e.size(s);
        },
        measureText: function(e, n) {
            var o, s = this.o.ctx;
            return !s.fillText || t.isIphone && s.measure ? {
                width: s.measure(e, n)
            } : (n = i.extend({
                size: t.defaultOptions.fontSize,
                weight: 1,
                angle: 0
            }, n), s.save(), s.font = (n.weight > 1 ? "bold " : "") + 1.3 * n.size + "px sans-serif", 
            o = s.measureText(e), s.restore(), o);
        }
    }, Flotr.Text = n;
}(), function() {
    function t() {
        return i.observe.apply(this, arguments), this._handles.push(arguments), this;
    }
    var e = Flotr.DOM, i = Flotr.EventAdapter, n = Flotr._, o = Flotr;
    Graph = function(t, e, s) {
        this._setEl(t), this._initMembers(), this._initPlugins(), i.fire(this.el, "flotr:beforeinit", [ this ]), 
        this.data = e, this.series = o.Series.getSeries(e), this._initOptions(s), this._initGraphTypes(), 
        this._initCanvas(), this._text = new o.Text({
            element: this.el,
            ctx: this.ctx,
            html: this.options.HtmlText,
            textEnabled: this.textEnabled
        }), i.fire(this.el, "flotr:afterconstruct", [ this ]), this._initEvents(), this.findDataRanges(), 
        this.calculateSpacing(), this.draw(n.bind(function() {
            i.fire(this.el, "flotr:afterinit", [ this ]);
        }, this));
    }, Graph.prototype = {
        destroy: function() {
            i.fire(this.el, "flotr:destroy"), n.each(this._handles, function(t) {
                i.stopObserving.apply(this, t);
            }), this._handles = [], this.el.graph = null;
        },
        observe: t,
        _observe: t,
        processColor: function(t, e) {
            var i = {
                x1: 0,
                y1: 0,
                x2: this.plotWidth,
                y2: this.plotHeight,
                opacity: 1,
                ctx: this.ctx
            };
            return n.extend(i, e), o.Color.processColor(t, i);
        },
        findDataRanges: function() {
            var t, e, i, s = this.axes;
            n.each(this.series, function(n) {
                i = n.getRange(), i && (t = n.xaxis, e = n.yaxis, t.datamin = Math.min(i.xmin, t.datamin), 
                t.datamax = Math.max(i.xmax, t.datamax), e.datamin = Math.min(i.ymin, e.datamin), 
                e.datamax = Math.max(i.ymax, e.datamax), t.used = t.used || i.xused, e.used = e.used || i.yused);
            }, this), !s.x.used && !s.x2.used && (s.x.used = !0), !s.y.used && !s.y2.used && (s.y.used = !0), 
            n.each(s, function(t) {
                t.calculateRange();
            });
            var a = n.keys(o.graphTypes), r = !1;
            n.each(this.series, function(t) {
                t.hide || (n.each(a, function(e) {
                    t[e] && t[e].show && (this.extendRange(e, t), r = !0);
                }, this), r || this.extendRange(this.options.defaultType, t));
            }, this);
        },
        extendRange: function(t, e) {
            this[t].extendRange && this[t].extendRange(e, e.data, e[t], this[t]), this[t].extendYRange && this[t].extendYRange(e.yaxis, e.data, e[t], this[t]), 
            this[t].extendXRange && this[t].extendXRange(e.xaxis, e.data, e[t], this[t]);
        },
        calculateSpacing: function() {
            var t, e, i = this.axes, o = this.options, s = this.series, a = o.grid.labelMargin, r = this._text, l = i.x, h = i.x2, c = i.y, d = i.y2, u = o.grid.outlineWidth;
            for (n.each(i, function(t) {
                t.calculateTicks(), t.calculateTextDimensions(r, o);
            }), e = r.dimensions(o.title, {
                size: 1.5 * o.fontSize
            }, "font-size:1em;font-weight:bold;", "flotr-title"), this.titleHeight = e.height, 
            e = r.dimensions(o.subtitle, {
                size: o.fontSize
            }, "font-size:smaller;", "flotr-subtitle"), this.subtitleHeight = e.height, t = 0; o.length > t; ++t) s[t].points.show && (u = Math.max(u, s[t].points.radius + s[t].points.lineWidth / 2));
            var p = this.plotOffset;
            l.options.margin === !1 ? (p.bottom = 0, p.top = 0) : l.options.margin === !0 ? (p.bottom += (o.grid.circular ? 0 : l.used && l.options.showLabels ? l.maxLabel.height + a : 0) + (l.used && l.options.title ? l.titleSize.height + a : 0) + u, 
            p.top += (o.grid.circular ? 0 : h.used && h.options.showLabels ? h.maxLabel.height + a : 0) + (h.used && h.options.title ? h.titleSize.height + a : 0) + this.subtitleHeight + this.titleHeight + u) : (p.bottom = l.options.margin, 
            p.top = l.options.margin), c.options.margin === !1 ? (p.left = 0, p.right = 0) : c.options.margin === !0 ? (p.left += (o.grid.circular ? 0 : c.used && c.options.showLabels ? c.maxLabel.width + a : 0) + (c.used && c.options.title ? c.titleSize.width + a : 0) + u, 
            p.right += (o.grid.circular ? 0 : d.used && d.options.showLabels ? d.maxLabel.width + a : 0) + (d.used && d.options.title ? d.titleSize.width + a : 0) + u) : (p.left = c.options.margin, 
            p.right = c.options.margin), p.top = Math.floor(p.top), this.plotWidth = this.canvasWidth - p.left - p.right, 
            this.plotHeight = this.canvasHeight - p.bottom - p.top, l.length = h.length = this.plotWidth, 
            c.length = d.length = this.plotHeight, c.offset = d.offset = this.plotHeight, l.setScale(), 
            h.setScale(), c.setScale(), d.setScale();
        },
        draw: function(t) {
            var e, n = this.ctx;
            if (i.fire(this.el, "flotr:beforedraw", [ this.series, this ]), this.series.length) {
                for (n.save(), n.translate(this.plotOffset.left, this.plotOffset.top), e = 0; this.series.length > e; e++) this.series[e].hide || this.drawSeries(this.series[e]);
                n.restore(), this.clip();
            }
            i.fire(this.el, "flotr:afterdraw", [ this.series, this ]), t && t();
        },
        drawSeries: function(t) {
            function e(t, e) {
                var i = this.getOptions(t, e);
                this[e].draw(i);
            }
            var i = !1;
            t = t || this.series, n.each(o.graphTypes, function(n, o) {
                t[o] && t[o].show && this[o] && (i = !0, e.call(this, t, o));
            }, this), i || e.call(this, t, this.options.defaultType);
        },
        getOptions: function(t, e) {
            var i = t[e], n = (this[e], t.xaxis), s = t.yaxis, a = {
                context: this.ctx,
                width: this.plotWidth,
                height: this.plotHeight,
                fontSize: this.options.fontSize,
                fontColor: this.options.fontColor,
                textEnabled: this.textEnabled,
                htmlText: this.options.HtmlText,
                text: this._text,
                element: this.el,
                data: t.data,
                color: t.color,
                shadowSize: t.shadowSize,
                xScale: n.d2p,
                yScale: s.d2p,
                xInverse: n.p2d,
                yInverse: s.p2d
            };
            return a = o.merge(i, a), a.fillStyle = this.processColor(i.fillColor || t.color, {
                opacity: i.fillOpacity
            }), a;
        },
        getEventPosition: function(t) {
            var n, o, s, a = document, r = a.body, l = a.documentElement, h = this.axes, c = this.plotOffset, d = this.lastMousePos, u = i.eventPointer(t), p = u.x - d.pageX, g = u.y - d.pageY;
            return "ontouchstart" in this.el ? (n = e.position(this.overlay), o = u.x - n.left - c.left, 
            s = u.y - n.top - c.top) : (n = this.overlay.getBoundingClientRect(), o = t.clientX - n.left - c.left - r.scrollLeft - l.scrollLeft, 
            s = t.clientY - n.top - c.top - r.scrollTop - l.scrollTop), {
                x: h.x.p2d(o),
                x2: h.x2.p2d(o),
                y: h.y.p2d(s),
                y2: h.y2.p2d(s),
                relX: o,
                relY: s,
                dX: p,
                dY: g,
                absX: u.x,
                absY: u.y,
                pageX: u.x,
                pageY: u.y
            };
        },
        clickHandler: function(t) {
            return this.ignoreClick ? (this.ignoreClick = !1, this.ignoreClick) : (i.fire(this.el, "flotr:click", [ this.getEventPosition(t), this ]), 
            void 0);
        },
        mouseMoveHandler: function(t) {
            if (!this.mouseDownMoveHandler) {
                var e = this.getEventPosition(t);
                i.fire(this.el, "flotr:mousemove", [ t, e, this ]), this.lastMousePos = e;
            }
        },
        mouseDownHandler: function(t) {
            this.mouseUpHandler || (this.mouseUpHandler = n.bind(function(t) {
                i.stopObserving(document, "mouseup", this.mouseUpHandler), i.stopObserving(document, "mousemove", this.mouseDownMoveHandler), 
                this.mouseDownMoveHandler = null, this.mouseUpHandler = null, i.fire(this.el, "flotr:mouseup", [ t, this ]);
            }, this), this.mouseDownMoveHandler = n.bind(function(e) {
                var n = this.getEventPosition(e);
                i.fire(this.el, "flotr:mousemove", [ t, n, this ]), this.lastMousePos = n;
            }, this), i.observe(document, "mouseup", this.mouseUpHandler), i.observe(document, "mousemove", this.mouseDownMoveHandler), 
            i.fire(this.el, "flotr:mousedown", [ t, this ]), this.ignoreClick = !1);
        },
        drawTooltip: function(t, i, n, o) {
            var s = this.getMouseTrack(), a = "opacity:0.7;background-color:#000;color:#fff;display:none;position:absolute;padding:2px 8px;-moz-border-radius:4px;border-radius:4px;white-space:nowrap;", r = o.position, l = o.margin, h = this.plotOffset;
            null !== i && null !== n ? (o.relative ? ("n" == r.charAt(0) ? a += "bottom:" + (l - h.top - n + this.canvasHeight) + "px;top:auto;" : "s" == r.charAt(0) && (a += "top:" + (l + h.top + n) + "px;bottom:auto;"), 
            "e" == r.charAt(1) ? a += "left:" + (l + h.left + i) + "px;right:auto;" : "w" == r.charAt(1) && (a += "right:" + (l - h.left - i + this.canvasWidth) + "px;left:auto;")) : ("n" == r.charAt(0) ? a += "top:" + (l + h.top) + "px;bottom:auto;" : "s" == r.charAt(0) && (a += "bottom:" + (l + h.bottom) + "px;top:auto;"), 
            "e" == r.charAt(1) ? a += "right:" + (l + h.right) + "px;left:auto;" : "w" == r.charAt(1) && (a += "left:" + (l + h.left) + "px;right:auto;")), 
            s.style.cssText = a, e.empty(s), e.insert(s, t), e.show(s)) : e.hide(s);
        },
        clip: function(t) {
            var e = this.plotOffset, i = this.canvasWidth, n = this.canvasHeight;
            if (t = t || this.ctx, o.isIE && 9 > o.isIE && !o.isFlashCanvas) {
                if (t === this.octx) return;
                t.save(), t.fillStyle = this.processColor(this.options.ieBackgroundColor), t.fillRect(0, 0, i, e.top), 
                t.fillRect(0, 0, e.left, n), t.fillRect(0, n - e.bottom, i, e.bottom), t.fillRect(i - e.right, 0, e.right, n), 
                t.restore();
            } else t.clearRect(0, 0, i, e.top), t.clearRect(0, 0, e.left, n), t.clearRect(0, n - e.bottom, i, e.bottom), 
            t.clearRect(i - e.right, 0, e.right, n);
        },
        _initMembers: function() {
            this._handles = [], this.lastMousePos = {
                pageX: null,
                pageY: null
            }, this.plotOffset = {
                left: 0,
                right: 0,
                top: 0,
                bottom: 0
            }, this.ignoreClick = !0, this.prevHit = null;
        },
        _initGraphTypes: function() {
            n.each(o.graphTypes, function(t, e) {
                this[e] = o.clone(t);
            }, this);
        },
        _initEvents: function() {
            var t, e, o, s = this.el;
            "ontouchstart" in s ? (t = n.bind(function(n) {
                o = !0, i.stopObserving(document, "touchend", t), i.fire(s, "flotr:mouseup", [ event, this ]), 
                this.multitouches = null, e || this.clickHandler(n);
            }, this), this.observe(this.overlay, "touchstart", n.bind(function(n) {
                e = !1, o = !1, this.ignoreClick = !1, n.touches && n.touches.length > 1 && (this.multitouches = n.touches), 
                i.fire(s, "flotr:mousedown", [ event, this ]), this.observe(document, "touchend", t);
            }, this)), this.observe(this.overlay, "touchmove", n.bind(function(t) {
                var n = this.getEventPosition(t);
                this.options.preventDefault && t.preventDefault(), e = !0, this.multitouches || t.touches && t.touches.length > 1 ? this.multitouches = t.touches : o || i.fire(s, "flotr:mousemove", [ event, n, this ]), 
                this.lastMousePos = n;
            }, this))) : this.observe(this.overlay, "mousedown", n.bind(this.mouseDownHandler, this)).observe(s, "mousemove", n.bind(this.mouseMoveHandler, this)).observe(this.overlay, "click", n.bind(this.clickHandler, this)).observe(s, "mouseout", function(t) {
                i.fire(s, "flotr:mouseout", t);
            });
        },
        _initCanvas: function() {
            function t(t, i) {
                return t || (t = e.create("canvas"), "undefined" != typeof FlashCanvas && "function" == typeof t.getContext && (FlashCanvas.initElement(t), 
                this.isFlashCanvas = !0), t.className = "flotr-" + i, t.style.cssText = "position:absolute;left:0px;top:0px;", 
                e.insert(r, t)), n.each(a, function(n, o) {
                    e.show(t), ("canvas" != i || t.getAttribute(o) !== n) && (t.setAttribute(o, n * l.resolution), 
                    t.style[o] = n + "px");
                }), t.context_ = null, t;
            }
            function i(t) {
                window.G_vmlCanvasManager && window.G_vmlCanvasManager.initElement(t);
                var e = t.getContext("2d");
                return window.G_vmlCanvasManager || e.scale(l.resolution, l.resolution), e;
            }
            var o, s, a, r = this.el, l = this.options, h = r.children, c = [];
            for (s = h.length; s--; ) o = h[s], this.canvas || "flotr-canvas" !== o.className ? this.overlay || "flotr-overlay" !== o.className ? c.push(o) : this.overlay = o : this.canvas = o;
            for (s = c.length; s--; ) r.removeChild(c[s]);
            if (e.setStyles(r, {
                position: "relative"
            }), a = {}, a.width = r.clientWidth, a.height = r.clientHeight, 0 >= a.width || 0 >= a.height || 0 >= l.resolution) throw "Invalid dimensions for plot, width = " + a.width + ", height = " + a.height + ", resolution = " + l.resolution;
            this.canvas = t(this.canvas, "canvas"), this.overlay = t(this.overlay, "overlay"), 
            this.ctx = i(this.canvas), this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height), 
            this.octx = i(this.overlay), this.octx.clearRect(0, 0, this.overlay.width, this.overlay.height), 
            this.canvasHeight = a.height, this.canvasWidth = a.width, this.textEnabled = !!this.ctx.drawText || !!this.ctx.fillText;
        },
        _initPlugins: function() {
            n.each(o.plugins, function(t, e) {
                n.each(t.callbacks, function(t, e) {
                    this.observe(this.el, e, n.bind(t, this));
                }, this), this[e] = o.clone(t), n.each(this[e], function(t, i) {
                    n.isFunction(t) && (this[e][i] = n.bind(t, this));
                }, this);
            }, this);
        },
        _initOptions: function(t) {
            var e = o.clone(o.defaultOptions);
            e.x2axis = n.extend(n.clone(e.xaxis), e.x2axis), e.y2axis = n.extend(n.clone(e.yaxis), e.y2axis), 
            this.options = o.merge(t || {}, e), null === this.options.grid.minorVerticalLines && "logarithmic" === this.options.xaxis.scaling && (this.options.grid.minorVerticalLines = !0), 
            null === this.options.grid.minorHorizontalLines && "logarithmic" === this.options.yaxis.scaling && (this.options.grid.minorHorizontalLines = !0), 
            i.fire(this.el, "flotr:afterinitoptions", [ this ]), this.axes = o.Axis.getAxes(this.options);
            var s, a, r, l, h = [], c = [], d = this.series.length, u = this.series.length, p = this.options.colors, g = [], f = 0;
            for (a = u - 1; a > -1; --a) s = this.series[a].color, s && (--u, n.isNumber(s) ? h.push(s) : g.push(o.Color.parse(s)));
            for (a = h.length - 1; a > -1; --a) u = Math.max(u, h[a] + 1);
            for (a = 0; u > c.length; ) {
                s = p.length == a ? new o.Color(100, 100, 100) : o.Color.parse(p[a]);
                var m = 1 == f % 2 ? -1 : 1, y = 1 + .2 * m * Math.ceil(f / 2);
                s.scale(y, y, y), c.push(s), ++a >= p.length && (a = 0, ++f);
            }
            for (a = 0, r = 0; d > a; ++a) {
                l = this.series[a], l.color ? n.isNumber(l.color) && (l.color = "" + c[l.color]) : l.color = "" + c[r++], 
                l.xaxis || (l.xaxis = this.axes.x), 1 == l.xaxis ? l.xaxis = this.axes.x : 2 == l.xaxis && (l.xaxis = this.axes.x2), 
                l.yaxis || (l.yaxis = this.axes.y), 1 == l.yaxis ? l.yaxis = this.axes.y : 2 == l.yaxis && (l.yaxis = this.axes.y2);
                for (var v in o.graphTypes) l[v] = n.extend(n.clone(this.options[v]), l[v]);
                l.mouse = n.extend(n.clone(this.options.mouse), l.mouse), n.isUndefined(l.shadowSize) && (l.shadowSize = this.options.shadowSize);
            }
        },
        _setEl: function(t) {
            if (!t) throw "The target container doesn't exist";
            if (t.graph instanceof Graph) t.graph.destroy(); else if (!t.clientWidth) throw "The target container must be visible";
            t.graph = this, this.el = t;
        }
    }, Flotr.Graph = Graph;
}(), function() {
    function t(t) {
        this.orientation = 1, this.offset = 0, this.datamin = Number.MAX_VALUE, this.datamax = -Number.MAX_VALUE, 
        o.extend(this, t);
    }
    function e(t, e) {
        return t = Math.log(Math.max(t, Number.MIN_VALUE)), e !== Math.E && (t /= Math.log(e)), 
        t;
    }
    function n(t, e) {
        return e === Math.E ? Math.exp(t) : Math.pow(e, t);
    }
    var o = Flotr._, s = "logarithmic";
    t.prototype = {
        setScale: function() {
            var t, i = this.length, o = this.max, a = this.min, r = this.offset, l = this.orientation, h = this.options, c = h.scaling === s;
            t = c ? i / (e(o, h.base) - e(a, h.base)) : i / (o - a), this.scale = t, c ? (this.d2p = function(i) {
                return r + l * (e(i, h.base) - e(a, h.base)) * t;
            }, this.p2d = function(i) {
                return n((r + l * i) / t + e(a, h.base), h.base);
            }) : (this.d2p = function(e) {
                return r + l * (e - a) * t;
            }, this.p2d = function(e) {
                return (r + l * e) / t + a;
            });
        },
        calculateTicks: function() {
            var t = this.options;
            this.ticks = [], this.minorTicks = [], t.ticks ? (this._cleanUserTicks(t.ticks, this.ticks), 
            this._cleanUserTicks(t.minorTicks || [], this.minorTicks)) : "time" == t.mode ? this._calculateTimeTicks() : "logarithmic" === t.scaling ? this._calculateLogTicks() : this._calculateTicks(), 
            o.each(this.ticks, function(t) {
                t.label += "";
            }), o.each(this.minorTicks, function(t) {
                t.label += "";
            });
        },
        calculateRange: function() {
            if (this.used) {
                var t = this, e = t.options, i = null !== e.min ? e.min : t.datamin, n = null !== e.max ? e.max : t.datamax, o = e.autoscaleMargin;
                if ("logarithmic" == e.scaling && (0 >= i && (i = t.datamin), 0 >= n && (n = i)), 
                n == i) {
                    var s = n ? .01 : 1;
                    null === e.min && (i -= s), null === e.max && (n += s);
                }
                if ("logarithmic" === e.scaling) {
                    0 > i && (i = n / e.base);
                    var a = Math.log(n);
                    e.base != Math.E && (a /= Math.log(e.base)), a = Math.ceil(a);
                    var r = Math.log(i);
                    e.base != Math.E && (r /= Math.log(e.base)), r = Math.ceil(r), t.tickSize = Flotr.getTickSize(e.noTicks, r, a, null === e.tickDecimals ? 0 : e.tickDecimals), 
                    null === e.minorTickFreq && (e.minorTickFreq = a - r > 10 ? 0 : a - r > 5 ? 2 : 5);
                } else t.tickSize = Flotr.getTickSize(e.noTicks, i, n, e.tickDecimals);
                t.min = i, t.max = n, null === e.min && e.autoscale && (t.min -= t.tickSize * o, 
                0 > t.min && t.datamin >= 0 && (t.min = 0), t.min = t.tickSize * Math.floor(t.min / t.tickSize)), 
                null === e.max && e.autoscale && (t.max += t.tickSize * o, t.max > 0 && 0 >= t.datamax && t.datamax != t.datamin && (t.max = 0), 
                t.max = t.tickSize * Math.ceil(t.max / t.tickSize)), t.min == t.max && (t.max = t.min + 1);
            }
        },
        calculateTextDimensions: function(t, e) {
            var i, n, o = "";
            if (this.options.showLabels) for (n = 0; this.ticks.length > n; ++n) i = this.ticks[n].label.length, 
            i > o.length && (o = this.ticks[n].label);
            this.maxLabel = t.dimensions(o, {
                size: e.fontSize,
                angle: Flotr.toRad(this.options.labelsAngle)
            }, "font-size:smaller;", "flotr-grid-label"), this.titleSize = t.dimensions(this.options.title, {
                size: 1.2 * e.fontSize,
                angle: Flotr.toRad(this.options.titleAngle)
            }, "font-weight:bold;", "flotr-axis-title");
        },
        _cleanUserTicks: function(t, e) {
            var i, n, s, a, r = this, l = this.options;
            for (o.isFunction(t) && (t = t({
                min: r.min,
                max: r.max
            })), n = 0; t.length > n; ++n) a = t[n], "object" == typeof a ? (i = a[0], s = a.length > 1 ? a[1] : l.tickFormatter(i, {
                min: r.min,
                max: r.max
            })) : (i = a, s = l.tickFormatter(i, {
                min: this.min,
                max: this.max
            })), e[n] = {
                v: i,
                label: s
            };
        },
        _calculateTimeTicks: function() {
            this.ticks = Flotr.Date.generator(this);
        },
        _calculateLogTicks: function() {
            var t, e, n = this, o = n.options, s = Math.log(n.max);
            o.base != Math.E && (s /= Math.log(o.base)), s = Math.ceil(s);
            var a = Math.log(n.min);
            for (o.base != Math.E && (a /= Math.log(o.base)), a = Math.ceil(a), i = a; s > i; i += n.tickSize) {
                e = o.base == Math.E ? Math.exp(i) : Math.pow(o.base, i);
                var r = e * (o.base == Math.E ? Math.exp(n.tickSize) : Math.pow(o.base, n.tickSize)), l = (r - e) / o.minorTickFreq;
                for (n.ticks.push({
                    v: e,
                    label: o.tickFormatter(e, {
                        min: n.min,
                        max: n.max
                    })
                }), t = e + l; r > t; t += l) n.minorTicks.push({
                    v: t,
                    label: o.tickFormatter(t, {
                        min: n.min,
                        max: n.max
                    })
                });
            }
            e = o.base == Math.E ? Math.exp(i) : Math.pow(o.base, i), n.ticks.push({
                v: e,
                label: o.tickFormatter(e, {
                    min: n.min,
                    max: n.max
                })
            });
        },
        _calculateTicks: function() {
            var t, e, i, n, o, s, a = this, r = a.options, l = a.tickSize, h = a.min, c = a.max, d = l * Math.ceil(h / l);
            for (r.minorTickFreq && (e = l / r.minorTickFreq), o = 0; c >= (i = n = d + o * l); ++o) if (t = r.tickDecimals, 
            null === t && (t = 1 - Math.floor(Math.log(l) / Math.LN10)), 0 > t && (t = 0), i = i.toFixed(t), 
            a.ticks.push({
                v: i,
                label: r.tickFormatter(i, {
                    min: a.min,
                    max: a.max
                })
            }), r.minorTickFreq) for (s = 0; r.minorTickFreq > s && c > o * l + s * e; ++s) i = n + s * e, 
            a.minorTicks.push({
                v: i,
                label: r.tickFormatter(i, {
                    min: a.min,
                    max: a.max
                })
            });
        }
    }, o.extend(t, {
        getAxes: function(e) {
            return {
                x: new t({
                    options: e.xaxis,
                    n: 1,
                    length: this.plotWidth
                }),
                x2: new t({
                    options: e.x2axis,
                    n: 2,
                    length: this.plotWidth
                }),
                y: new t({
                    options: e.yaxis,
                    n: 1,
                    length: this.plotHeight,
                    offset: this.plotHeight,
                    orientation: -1
                }),
                y2: new t({
                    options: e.y2axis,
                    n: 2,
                    length: this.plotHeight,
                    offset: this.plotHeight,
                    orientation: -1
                })
            };
        }
    }), Flotr.Axis = t;
}(), function() {
    function t(t) {
        e.extend(this, t);
    }
    var e = Flotr._;
    t.prototype = {
        getRange: function() {
            var t, e, i, n = this.data, o = n.length, s = Number.MAX_VALUE, a = Number.MAX_VALUE, r = -Number.MAX_VALUE, l = -Number.MAX_VALUE, h = !1, c = !1;
            if (0 > o || this.hide) return !1;
            for (i = 0; o > i; i++) t = n[i][0], e = n[i][1], null !== t && (s > t && (s = t, 
            h = !0), t > r && (r = t, h = !0)), null !== e && (a > e && (a = e, c = !0), e > l && (l = e, 
            c = !0));
            return {
                xmin: s,
                xmax: r,
                ymin: a,
                ymax: l,
                xused: h,
                yused: c
            };
        }
    }, e.extend(t, {
        getSeries: function(i) {
            return e.map(i, function(i) {
                var n;
                return i.data ? (n = new t(), e.extend(n, i)) : n = new t({
                    data: i
                }), n;
            });
        }
    }), Flotr.Series = t;
}(), Flotr.addType("lines", {
    options: {
        show: !1,
        lineWidth: 2,
        fill: !1,
        fillBorder: !1,
        fillColor: null,
        fillOpacity: .4,
        steps: !1,
        stacked: !1
    },
    stack: {
        values: []
    },
    draw: function(t) {
        var e, i = t.context, n = t.lineWidth, o = t.shadowSize;
        i.save(), i.lineJoin = "round", o && (i.lineWidth = o / 2, e = n / 2 + i.lineWidth / 2, 
        i.strokeStyle = "rgba(0,0,0,0.1)", this.plot(t, e + o / 2, !1), i.strokeStyle = "rgba(0,0,0,0.2)", 
        this.plot(t, e, !1)), i.lineWidth = n, i.strokeStyle = t.color, this.plot(t, 0, !0), 
        i.restore();
    },
    plot: function(t, e, i) {
        function n() {
            !e && t.fill && S && (o = g(S[0]), d.fillStyle = t.fillStyle, d.lineTo(s, w), d.lineTo(o, w), 
            d.lineTo(o, f(S[1])), d.fill(), t.fillBorder && d.stroke());
        }
        var o, s, a, r, l, h, c, d = t.context, u = t.width, p = t.height, g = t.xScale, f = t.yScale, m = t.data, y = t.stacked ? this.stack : !1, v = m.length - 1, b = null, C = null, w = f(0), S = null;
        if (!(1 > v)) {
            for (d.beginPath(), c = 0; v > c; ++c) null !== m[c][1] && null !== m[c + 1][1] ? (o = g(m[c][0]), 
            s = g(m[c + 1][0]), null === S && (S = m[c]), y ? (l = y.values[m[c][0]] || 0, h = y.values[m[c + 1][0]] || y.values[m[c][0]] || 0, 
            a = f(m[c][1] + l), r = f(m[c + 1][1] + h), i && (y.values[m[c][0]] = m[c][1] + l, 
            c == v - 1 && (y.values[m[c + 1][0]] = m[c + 1][1] + h))) : (a = f(m[c][1]), r = f(m[c + 1][1])), 
            a > p && r > p || 0 > a && 0 > r || 0 > o && 0 > s || o > u && s > u || ((b != o || C != a + e) && d.moveTo(o, a + e), 
            b = s, C = r + e, t.steps ? (d.lineTo(b + e / 2, a + e), d.lineTo(b + e / 2, C)) : d.lineTo(b, C))) : t.fill && c > 0 && m[c][1] && (d.stroke(), 
            n(), S = null, d.closePath(), d.beginPath());
            (!t.fill || t.fill && !t.fillBorder) && d.stroke(), n(), d.closePath();
        }
    },
    extendYRange: function(t, e, i, n) {
        var o = t.options;
        if (i.stacked && (!o.max && 0 !== o.max || !o.min && 0 !== o.min)) {
            var s, a, r = t.max, l = t.min, h = n.positiveSums || {}, c = n.negativeSums || {};
            for (a = 0; e.length > a; a++) s = e[a][0] + "", e[a][1] > 0 ? (h[s] = (h[s] || 0) + e[a][1], 
            r = Math.max(r, h[s])) : (c[s] = (c[s] || 0) + e[a][1], l = Math.min(l, c[s]));
            n.negativeSums = c, n.positiveSums = h, t.max = r, t.min = l;
        }
        i.steps && (this.hit = function(t) {
            var e, i = t.data, n = t.args, o = t.yScale, s = n[0], a = i.length, r = n[1], l = t.xInverse(s.relX), h = s.relY;
            for (e = 0; a - 1 > e; e++) if (l >= i[e][0] && i[e + 1][0] >= l) {
                8 > Math.abs(o(i[e][1]) - h) && (r.x = i[e][0], r.y = i[e][1], r.index = e, r.seriesIndex = t.index);
                break;
            }
        }, this.drawHit = function(t) {
            var e, i = t.context, n = t.args, o = t.data, s = t.xScale, a = n.index, r = s(n.x), l = t.yScale(n.y);
            o.length - 1 > a && (e = t.xScale(o[a + 1][0]), i.save(), i.strokeStyle = t.color, 
            i.lineWidth = t.lineWidth, i.beginPath(), i.moveTo(r, l), i.lineTo(e, l), i.stroke(), 
            i.closePath(), i.restore());
        }, this.clearHit = function(t) {
            var e, i = t.context, n = t.args, o = t.data, s = t.xScale, a = t.lineWidth, r = n.index, l = s(n.x), h = t.yScale(n.y);
            o.length - 1 > r && (e = t.xScale(o[r + 1][0]), i.clearRect(l - a, h - a, e - l + 2 * a, 2 * a));
        });
    }
}), Flotr.addType("bars", {
    options: {
        show: !1,
        lineWidth: 2,
        barWidth: 1,
        fill: !0,
        fillColor: null,
        fillOpacity: .4,
        horizontal: !1,
        stacked: !1,
        centered: !0,
        topPadding: .1,
        grouped: !1
    },
    stack: {
        positive: [],
        negative: [],
        _positive: [],
        _negative: []
    },
    draw: function(t) {
        var e = t.context;
        this.current += 1, e.save(), e.lineJoin = "miter", e.lineWidth = t.lineWidth, e.strokeStyle = t.color, 
        t.fill && (e.fillStyle = t.fillStyle), this.plot(t), e.restore();
    },
    plot: function(t) {
        var e, i, n, o, s, a, r = t.data, l = t.context, h = t.shadowSize;
        if (!(1 > r.length)) for (this.translate(l, t.horizontal), e = 0; r.length > e; e++) i = this.getBarGeometry(r[e][0], r[e][1], t), 
        null !== i && (n = i.left, o = i.top, s = i.width, a = i.height, t.fill && l.fillRect(n, o, s, a), 
        h && (l.save(), l.fillStyle = "rgba(0,0,0,0.05)", l.fillRect(n + h, o + h, s, a), 
        l.restore()), t.lineWidth && l.strokeRect(n, o, s, a));
    },
    translate: function(t, e) {
        e && (t.rotate(-Math.PI / 2), t.scale(-1, 1));
    },
    getBarGeometry: function(t, e, i) {
        var n, o, s, a, r, l = i.horizontal, h = i.barWidth, c = i.centered, d = i.stacked ? this.stack : !1, u = i.lineWidth, p = c ? h / 2 : 0, g = l ? i.yScale : i.xScale, f = l ? i.xScale : i.yScale, m = l ? e : t, y = l ? t : e, v = 0;
        return i.grouped && (this.current / this.groups, m -= p, h /= this.groups, p = h / 2, 
        m = m + h * this.current - p), d && (n = y > 0 ? d.positive : d.negative, v = n[m] || v, 
        n[m] = v + y), o = g(m - p), s = g(m + h - p), a = f(y + v), r = f(v), 0 > r && (r = 0), 
        null === t || null === e ? null : {
            x: m,
            y: y,
            xScale: g,
            yScale: f,
            top: a,
            left: Math.min(o, s) - u / 2,
            width: Math.abs(s - o) - u,
            height: r - a
        };
    },
    hit: function(t) {
        var e, i, n = t.data, o = t.args, s = o[0], a = o[1], r = t.xInverse(s.relX), l = t.yInverse(s.relY), h = this.getBarGeometry(r, l, t), c = h.width / 2, d = h.left, u = h.y;
        for (i = n.length; i--; ) e = this.getBarGeometry(n[i][0], n[i][1], t), (u > 0 && e.y > u || 0 > u && u > e.y) && c > Math.abs(d - e.left) && (a.x = n[i][0], 
        a.y = n[i][1], a.index = i, a.seriesIndex = t.index);
    },
    drawHit: function(t) {
        var e = t.context, i = t.args, n = this.getBarGeometry(i.x, i.y, t), o = n.left, s = n.top, a = n.width, r = n.height;
        e.save(), e.strokeStyle = t.color, e.lineWidth = t.lineWidth, this.translate(e, t.horizontal), 
        e.beginPath(), e.moveTo(o, s + r), e.lineTo(o, s), e.lineTo(o + a, s), e.lineTo(o + a, s + r), 
        t.fill && (e.fillStyle = t.fillStyle, e.fill()), e.stroke(), e.closePath(), e.restore();
    },
    clearHit: function(t) {
        var e = t.context, i = t.args, n = this.getBarGeometry(i.x, i.y, t), o = n.left, s = n.width, a = n.top, r = n.height, l = 2 * t.lineWidth;
        e.save(), this.translate(e, t.horizontal), e.clearRect(o - l, Math.min(a, a + r) - l, s + 2 * l, Math.abs(r) + 2 * l), 
        e.restore();
    },
    extendXRange: function(t, e, i, n) {
        this._extendRange(t, e, i, n), this.groups = this.groups + 1 || 1, this.current = 0;
    },
    extendYRange: function(t, e, i, n) {
        this._extendRange(t, e, i, n);
    },
    _extendRange: function(t, e, i) {
        var n = t.options.max;
        if (!_.isNumber(n) && !_.isString(n)) {
            var o, s, a, r = t.min, l = t.max, h = i.horizontal, c = t.orientation, d = this.positiveSums || {}, u = this.negativeSums || {};
            if ((1 == c && !h || -1 == c && h) && i.centered && (l = Math.max(t.datamax + i.barWidth, l), 
            r = Math.min(t.datamin - i.barWidth, r)), i.stacked && (1 == c && h || -1 == c && !h)) for (a = e.length; a--; ) o = e[a][1 == c ? 1 : 0] + "", 
            s = e[a][1 == c ? 0 : 1], s > 0 ? (d[o] = (d[o] || 0) + s, l = Math.max(l, d[o])) : (u[o] = (u[o] || 0) + s, 
            r = Math.min(r, u[o]));
            (1 == c && h || -1 == c && !h) && i.topPadding && (t.max === t.datamax || i.stacked && this.stackMax !== l) && (l += i.topPadding * (l - r)), 
            this.stackMin = r, this.stackMax = l, this.negativeSums = u, this.positiveSums = d, 
            t.max = l, t.min = r;
        }
    }
}), Flotr.addType("bubbles", {
    options: {
        show: !1,
        lineWidth: 2,
        fill: !0,
        fillOpacity: .4,
        baseRadius: 2
    },
    draw: function(t) {
        var e = t.context, i = t.shadowSize;
        e.save(), e.lineWidth = t.lineWidth, e.fillStyle = "rgba(0,0,0,0.05)", e.strokeStyle = "rgba(0,0,0,0.05)", 
        this.plot(t, i / 2), e.strokeStyle = "rgba(0,0,0,0.1)", this.plot(t, i / 4), e.strokeStyle = t.color, 
        e.fillStyle = t.fillStyle, this.plot(t), e.restore();
    },
    plot: function(t, e) {
        var i, n, o = t.data, s = t.context;
        for (e = e || 0, n = 0; o.length > n; ++n) i = this.getGeometry(o[n], t), s.beginPath(), 
        s.arc(i.x + e, i.y + e, i.z, 0, 2 * Math.PI, !0), s.stroke(), t.fill && s.fill(), 
        s.closePath();
    },
    getGeometry: function(t, e) {
        return {
            x: e.xScale(t[0]),
            y: e.yScale(t[1]),
            z: t[2] * e.baseRadius
        };
    },
    hit: function(t) {
        var e, n, o, s, a = t.data, r = t.args, l = r[0], h = r[1], c = l.relX, d = l.relY;
        for (h.best = h.best || Number.MAX_VALUE, i = a.length; i--; ) n = this.getGeometry(a[i], t), 
        o = n.x - c, s = n.y - d, e = Math.sqrt(o * o + s * s), n.z > e && n.z < h.best && (h.x = a[i][0], 
        h.y = a[i][1], h.index = i, h.seriesIndex = t.index, h.best = n.z);
    },
    drawHit: function(t) {
        var e = t.context, i = this.getGeometry(t.data[t.args.index], t);
        e.save(), e.lineWidth = t.lineWidth, e.fillStyle = t.fillStyle, e.strokeStyle = t.color, 
        e.beginPath(), e.arc(i.x, i.y, i.z, 0, 2 * Math.PI, !0), e.fill(), e.stroke(), e.closePath(), 
        e.restore();
    },
    clearHit: function(t) {
        var e = t.context, i = this.getGeometry(t.data[t.args.index], t), n = i.z + t.lineWidth;
        e.save(), e.clearRect(i.x - n, i.y - n, 2 * n, 2 * n), e.restore();
    }
}), Flotr.addType("candles", {
    options: {
        show: !1,
        lineWidth: 1,
        wickLineWidth: 1,
        candleWidth: .6,
        fill: !0,
        upFillColor: "#00A8F0",
        downFillColor: "#CB4B4B",
        fillOpacity: .5,
        barcharts: !1
    },
    draw: function(t) {
        var e = t.context;
        e.save(), e.lineJoin = "miter", e.lineCap = "butt", e.lineWidth = t.wickLineWidth || t.lineWidth, 
        this.plot(t), e.restore();
    },
    plot: function(t) {
        var e, i, n, o, s, a, r, l, h, c, d, u, p, g, f, m = t.data, y = t.context, v = t.xScale, b = t.yScale, C = t.candleWidth / 2, w = t.shadowSize, S = t.lineWidth, x = t.wickLineWidth, k = x % 2 / 2;
        if (!(1 > m.length)) for (f = 0; m.length > f; f++) i = m[f], n = i[0], s = i[1], 
        a = i[2], r = i[3], l = i[4], h = v(n - C), c = v(n + C), d = b(r), u = b(a), p = b(Math.min(s, l)), 
        g = b(Math.max(s, l)), e = t[s > l ? "downFillColor" : "upFillColor"], t.fill && !t.barcharts && (y.fillStyle = "rgba(0,0,0,0.05)", 
        y.fillRect(h + w, g + w, c - h, p - g), y.save(), y.globalAlpha = t.fillOpacity, 
        y.fillStyle = e, y.fillRect(h, g + S, c - h, p - g), y.restore()), (S || x) && (n = Math.floor((h + c) / 2) + k, 
        y.strokeStyle = e, y.beginPath(), t.barcharts ? (y.moveTo(n, Math.floor(u + C)), 
        y.lineTo(n, Math.floor(d + C)), o = Math.floor(s + C) + .5, y.moveTo(Math.floor(h) + k, o), 
        y.lineTo(n, o), o = Math.floor(l + C) + .5, y.moveTo(Math.floor(c) + k, o), y.lineTo(n, o)) : (y.strokeRect(h, g + S, c - h, p - g), 
        y.moveTo(n, Math.floor(g + S)), y.lineTo(n, Math.floor(u + S)), y.moveTo(n, Math.floor(p + S)), 
        y.lineTo(n, Math.floor(d + S))), y.closePath(), y.stroke());
    },
    hit: function(t) {
        var e, i, n, o, s, a, r, l, h = t.xScale, c = t.yScale, d = t.data, u = t.args, p = u[0], g = t.candleWidth / 2, f = u[1], m = p.relX, y = p.relY, v = d.length;
        for (e = 0; v > e; e++) if (i = d[e], n = i[2], o = i[3], s = h(i[0] - g), a = h(i[0] + g), 
        l = c(o), r = c(n), m > s && a > m && y > r && l > y) return f.x = i[0], f.index = e, 
        f.seriesIndex = t.index, void 0;
    },
    drawHit: function(t) {
        var e = t.context;
        e.save(), this.plot(_.defaults({
            fill: !!t.fillColor,
            upFillColor: t.color,
            downFillColor: t.color,
            data: [ t.data[t.args.index] ]
        }, t)), e.restore();
    },
    clearHit: function(t) {
        var e = t.args, i = t.context, n = t.xScale, o = t.yScale, s = t.lineWidth, a = t.candleWidth / 2, r = t.data[e.index], l = n(r[0] - a) - s, h = n(r[0] + a) + s, c = o(r[2]), d = o(r[3]) + s;
        i.clearRect(l, c, h - l, d - c);
    },
    extendXRange: function(t) {
        null === t.options.max && (t.max = Math.max(t.datamax + .5, t.max), t.min = Math.min(t.datamin - .5, t.min));
    }
}), Flotr.addType("gantt", {
    options: {
        show: !1,
        lineWidth: 2,
        barWidth: 1,
        fill: !0,
        fillColor: null,
        fillOpacity: .4,
        centered: !0
    },
    draw: function(t) {
        var e = this.ctx, i = t.gantt.barWidth, n = Math.min(t.gantt.lineWidth, i);
        if (e.save(), e.translate(this.plotOffset.left, this.plotOffset.top), e.lineJoin = "miter", 
        e.lineWidth = n, e.strokeStyle = t.color, e.save(), this.gantt.plotShadows(t, i, 0, t.gantt.fill), 
        e.restore(), t.gantt.fill) {
            var o = t.gantt.fillColor || t.color;
            e.fillStyle = this.processColor(o, {
                opacity: t.gantt.fillOpacity
            });
        }
        this.gantt.plot(t, i, 0, t.gantt.fill), e.restore();
    },
    plot: function(t, e, i, n) {
        var o = t.data;
        if (!(1 > o.length)) {
            var s, a = t.xaxis, r = t.yaxis, l = this.ctx;
            for (s = 0; o.length > s; s++) {
                var h = o[s][0], c = o[s][1], d = o[s][2], u = !0, p = !0, g = !0;
                if (null !== c && null !== d) {
                    var f = c, m = c + d, y = h - (t.gantt.centered ? e / 2 : 0), v = h + e - (t.gantt.centered ? e / 2 : 0);
                    a.min > m || f > a.max || r.min > v || y > r.max || (a.min > f && (f = a.min, u = !1), 
                    m > a.max && (m = a.max, a.lastSerie != t && (p = !1)), r.min > y && (y = r.min), 
                    v > r.max && (v = r.max, r.lastSerie != t && (p = !1)), n && (l.beginPath(), l.moveTo(a.d2p(f), r.d2p(y) + i), 
                    l.lineTo(a.d2p(f), r.d2p(v) + i), l.lineTo(a.d2p(m), r.d2p(v) + i), l.lineTo(a.d2p(m), r.d2p(y) + i), 
                    l.fill(), l.closePath()), t.gantt.lineWidth && (u || g || p) && (l.beginPath(), 
                    l.moveTo(a.d2p(f), r.d2p(y) + i), l[u ? "lineTo" : "moveTo"](a.d2p(f), r.d2p(v) + i), 
                    l[p ? "lineTo" : "moveTo"](a.d2p(m), r.d2p(v) + i), l[g ? "lineTo" : "moveTo"](a.d2p(m), r.d2p(y) + i), 
                    l.stroke(), l.closePath()));
                }
            }
        }
    },
    plotShadows: function(t, e) {
        var i = t.data;
        if (!(1 > i.length)) {
            var n, o, s, a, r = t.xaxis, l = t.yaxis, h = this.ctx, c = this.options.shadowSize;
            for (n = 0; i.length > n; n++) if (o = i[n][0], s = i[n][1], a = i[n][2], null !== s && null !== a) {
                var d = s, u = s + a, p = o - (t.gantt.centered ? e / 2 : 0), g = o + e - (t.gantt.centered ? e / 2 : 0);
                if (!(r.min > u || d > r.max || l.min > g || p > l.max)) {
                    r.min > d && (d = r.min), u > r.max && (u = r.max), l.min > p && (p = l.min), g > l.max && (g = l.max);
                    var f = r.d2p(u) - r.d2p(d) - (r.d2p(u) + c <= this.plotWidth ? 0 : c), m = l.d2p(p) - l.d2p(g) - (l.d2p(p) + c <= this.plotHeight ? 0 : c);
                    h.fillStyle = "rgba(0,0,0,0.05)", h.fillRect(Math.min(r.d2p(d) + c, this.plotWidth), Math.min(l.d2p(g) + c, this.plotHeight), f, m);
                }
            }
        }
    },
    extendXRange: function(t) {
        if (null === t.options.max) {
            var e, i, n, o, s = t.min, a = t.max, r = {}, l = null;
            for (e = 0; this.series.length > e; ++e) if (n = this.series[e], o = n.gantt, o.show && n.xaxis == t) {
                for (i = 0; n.data.length > i; i++) o.show && (y = n.data[i][0] + "", r[y] = Math.max(r[y] || 0, n.data[i][1] + n.data[i][2]), 
                l = n);
                for (i in r) a = Math.max(r[i], a);
            }
            t.lastSerie = l, t.max = a, t.min = s;
        }
    },
    extendYRange: function(t) {
        if (null === t.options.max) {
            var e, i, n, o, s = Number.MIN_VALUE, a = Number.MAX_VALUE, r = null;
            for (e = 0; this.series.length > e; ++e) if (n = this.series[e], o = n.gantt, o.show && !n.hide && n.yaxis == t) {
                var l = Number.MIN_VALUE, h = Number.MAX_VALUE;
                for (i = 0; n.data.length > i; i++) l = Math.max(l, n.data[i][0]), h = Math.min(h, n.data[i][0]);
                o.centered ? (s = Math.max(l + .5, s), a = Math.min(h - .5, a)) : (s = Math.max(l + 1, s), 
                a = Math.min(h, a)), o.barWidth + l > s && (s = t.max + o.barWidth);
            }
            t.lastSerie = r, t.max = s, t.min = a, t.tickSize = Flotr.getTickSize(t.options.noTicks, a, s, t.options.tickDecimals);
        }
    }
}), function() {
    function t(t) {
        return "object" == typeof t && t.constructor && (Image ? !0 : t.constructor === Image);
    }
    Flotr.defaultMarkerFormatter = function(t) {
        return Math.round(100 * t.y) / 100 + "";
    }, Flotr.addType("markers", {
        options: {
            show: !1,
            lineWidth: 1,
            color: "#000000",
            fill: !1,
            fillColor: "#FFFFFF",
            fillOpacity: .4,
            stroke: !1,
            position: "ct",
            verticalMargin: 0,
            labelFormatter: Flotr.defaultMarkerFormatter,
            fontSize: Flotr.defaultOptions.fontSize,
            stacked: !1,
            stackingType: "b",
            horizontal: !1
        },
        stack: {
            positive: [],
            negative: [],
            values: []
        },
        draw: function(t) {
            function e(t, e) {
                return n = d.negative[t] || 0, i = d.positive[t] || 0, e > 0 ? (d.positive[t] = n + e, 
                n + e) : (d.negative[t] = i + e, i + e);
            }
            var i, n, o, s, a, r, l, h = t.data, c = t.context, d = t.stacked ? t.stack : !1, u = t.stackingType;
            for (c.save(), c.lineJoin = "round", c.lineWidth = t.lineWidth, c.strokeStyle = "rgba(0,0,0,0.5)", 
            c.fillStyle = t.fillStyle, s = 0; h.length > s; ++s) a = h[s][0], r = h[s][1], d && ("b" == u ? t.horizontal ? r = e(r, a) : a = e(a, r) : "a" == u && (o = d.values[a] || 0, 
            d.values[a] = o + r, r = o + r)), l = t.labelFormatter({
                x: a,
                y: r,
                index: s,
                data: h
            }), this.plot(t.xScale(a), t.yScale(r), l, t);
            c.restore();
        },
        plot: function(e, i, n, o) {
            if (o.context, t(n) && !n.complete) throw "Marker image not loaded.";
            this._plot(e, i, n, o);
        },
        _plot: function(e, i, n, o) {
            var s, a = o.context, r = 2, l = e, h = i;
            s = t(n) ? {
                height: n.height,
                width: n.width
            } : o.text.canvas(n), s.width = Math.floor(s.width + 2 * r), s.height = Math.floor(s.height + 2 * r), 
            -1 != o.position.indexOf("c") ? l -= s.width / 2 + r : -1 != o.position.indexOf("l") && (l -= s.width), 
            -1 != o.position.indexOf("m") ? h -= s.height / 2 + r : -1 != o.position.indexOf("t") ? h -= s.height + o.verticalMargin : h += o.verticalMargin, 
            l = Math.floor(l) + .5, h = Math.floor(h) + .5, o.fill && a.fillRect(l, h, s.width, s.height), 
            o.stroke && a.strokeRect(l, h, s.width, s.height), t(n) ? a.drawImage(n, l + r, h + r) : Flotr.drawText(a, n, l + r, h + r, {
                textBaseline: "top",
                textAlign: "left",
                size: o.fontSize,
                color: o.color
            });
        }
    });
}(), function() {
    Flotr._, Flotr.defaultPieLabelFormatter = function(t, e) {
        return (100 * e / t).toFixed(2) + "%";
    }, Flotr.addType("pie", {
        options: {
            show: !1,
            lineWidth: 1,
            fill: !0,
            fillColor: null,
            fillOpacity: .6,
            explode: 6,
            sizeRatio: .6,
            startAngle: Math.PI / 4,
            labelFormatter: Flotr.defaultPieLabelFormatter,
            pie3D: !1,
            pie3DviewAngle: .8 * (Math.PI / 2),
            pie3DspliceThickness: 20,
            epsilon: .1
        },
        draw: function(t) {
            var e, i, n, o = t.data, s = t.context, a = s.canvas, r = t.lineWidth, l = t.shadowSize, h = t.sizeRatio, c = t.height, d = t.width, u = t.explode, p = t.color, g = t.fill, f = t.fillStyle, m = Math.min(a.width, a.height) * h / 2, y = o[0][1], v = [], b = 1, C = 2 * Math.PI * y / this.total, w = this.startAngle || 2 * Math.PI * t.startAngle, S = w + C, x = w + C / 2, k = t.labelFormatter(this.total, y), P = u + m + 4, T = Math.cos(x) * P, M = Math.sin(x) * P, I = 0 > T ? "right" : "left", D = M > 0 ? "top" : "bottom";
            if (s.save(), s.translate(d / 2, c / 2), s.scale(1, b), i = Math.cos(x) * u, n = Math.sin(x) * u, 
            l > 0 && (this.plotSlice(i + l, n + l, m, w, S, s), g && (s.fillStyle = "rgba(0,0,0,0.1)", 
            s.fill())), this.plotSlice(i, n, m, w, S, s), g && (s.fillStyle = f, s.fill()), 
            s.lineWidth = r, s.strokeStyle = p, s.stroke(), e = {
                size: 1.2 * t.fontSize,
                color: t.fontColor,
                weight: 1.5
            }, k && (t.htmlText || !t.textEnabled ? (divStyle = "position:absolute;" + D + ":" + (c / 2 + ("top" === D ? M : -M)) + "px;", 
            divStyle += I + ":" + (d / 2 + ("right" === I ? -T : T)) + "px;", v.push('<div style="', divStyle, '" class="flotr-grid-label">', k, "</div>")) : (e.textAlign = I, 
            e.textBaseline = D, Flotr.drawText(s, k, T, M, e))), t.htmlText || !t.textEnabled) {
                var $ = Flotr.DOM.node('<div style="color:' + t.fontColor + '" class="flotr-labels"></div>');
                Flotr.DOM.insert($, v.join("")), Flotr.DOM.insert(t.element, $);
            }
            s.restore(), this.startAngle = S, this.slices = this.slices || [], this.slices.push({
                radius: Math.min(a.width, a.height) * h / 2,
                x: i,
                y: n,
                explode: u,
                start: w,
                end: S
            });
        },
        plotSlice: function(t, e, i, n, o, s) {
            s.beginPath(), s.moveTo(t, e), s.arc(t, e, i, n, o, !1), s.lineTo(t, e), s.closePath();
        },
        hit: function(t) {
            var e = t.data[0], i = t.args, n = t.index, o = i[0], s = i[1], a = this.slices[n], r = o.relX - t.width / 2, l = o.relY - t.height / 2, h = Math.sqrt(r * r + l * l), c = Math.atan(l / r), d = 2 * Math.PI, u = a.explode || t.explode, p = a.start % d, g = a.end % d, f = t.epsilon;
            0 > r ? c += Math.PI : r > 0 && 0 > l && (c += d), a.radius + u > h && h > u && (c > p && g > c || p > g && (g > c || c > p) || p === g && (a.start === a.end && f > Math.abs(c - p) || a.start !== a.end && Math.abs(c - p) > f)) && (s.x = e[0], 
            s.y = e[1], s.sAngle = p, s.eAngle = g, s.index = 0, s.seriesIndex = n, s.fraction = e[1] / this.total);
        },
        drawHit: function(t) {
            var e = t.context, i = this.slices[t.args.seriesIndex];
            e.save(), e.translate(t.width / 2, t.height / 2), this.plotSlice(i.x, i.y, i.radius, i.start, i.end, e), 
            e.stroke(), e.restore();
        },
        clearHit: function(t) {
            var e = t.context, i = this.slices[t.args.seriesIndex], n = 2 * t.lineWidth, o = i.radius + n;
            e.save(), e.translate(t.width / 2, t.height / 2), e.clearRect(i.x - o, i.y - o, 2 * o + n, 2 * o + n), 
            e.restore();
        },
        extendYRange: function(t, e) {
            this.total = (this.total || 0) + e[0][1];
        }
    });
}(), Flotr.addType("points", {
    options: {
        show: !1,
        radius: 3,
        lineWidth: 2,
        fill: !0,
        fillColor: "#FFFFFF",
        fillOpacity: 1,
        hitRadius: null
    },
    draw: function(t) {
        var e = t.context, i = (t.lineWidth, t.shadowSize);
        e.save(), i > 0 && (e.lineWidth = i / 2, e.strokeStyle = "rgba(0,0,0,0.1)", this.plot(t, i / 2 + e.lineWidth / 2), 
        e.strokeStyle = "rgba(0,0,0,0.2)", this.plot(t, e.lineWidth / 2)), e.lineWidth = t.lineWidth, 
        e.strokeStyle = t.color, t.fill && (e.fillStyle = t.fillStyle), this.plot(t), e.restore();
    },
    plot: function(t, e) {
        var i, n, o, s = t.data, a = t.context, r = t.xScale, l = t.yScale;
        for (i = s.length - 1; i > -1; --i) o = s[i][1], null !== o && (n = r(s[i][0]), 
        o = l(o), 0 > n || n > t.width || 0 > o || o > t.height || (a.beginPath(), e ? a.arc(n, o + e, t.radius, 0, Math.PI, !1) : (a.arc(n, o, t.radius, 0, 2 * Math.PI, !0), 
        t.fill && a.fill()), a.stroke(), a.closePath()));
    }
}), Flotr.addType("radar", {
    options: {
        show: !1,
        lineWidth: 2,
        fill: !0,
        fillOpacity: .4,
        radiusRatio: .9,
        sensibility: 2
    },
    draw: function(t) {
        var e = t.context, i = t.shadowSize;
        e.save(), e.translate(t.width / 2, t.height / 2), e.lineWidth = t.lineWidth, e.fillStyle = "rgba(0,0,0,0.05)", 
        e.strokeStyle = "rgba(0,0,0,0.05)", this.plot(t, i / 2), e.strokeStyle = "rgba(0,0,0,0.1)", 
        this.plot(t, i / 4), e.strokeStyle = t.color, e.fillStyle = t.fillStyle, this.plot(t), 
        e.restore();
    },
    plot: function(t, e) {
        var i, n, o = t.data, s = t.context, a = Math.min(t.height, t.width) * t.radiusRatio / 2, r = 2 * Math.PI / o.length, l = -Math.PI / 2;
        for (e = e || 0, s.beginPath(), i = 0; o.length > i; ++i) n = o[i][1] / this.max, 
        s[0 === i ? "moveTo" : "lineTo"](Math.cos(i * r + l) * a * n + e, Math.sin(i * r + l) * a * n + e);
        s.closePath(), t.fill && s.fill(), s.stroke();
    },
    getGeometry: function(t, e) {
        var i = Math.min(e.height, e.width) * e.radiusRatio / 2, n = 2 * Math.PI / e.data.length, o = -Math.PI / 2, s = t[1] / this.max;
        return {
            x: Math.cos(t[0] * n + o) * i * s + e.width / 2,
            y: Math.sin(t[0] * n + o) * i * s + e.height / 2
        };
    },
    hit: function(t) {
        for (var e, i, n, o, s = t.args, a = s[0], r = s[1], l = a.relX, h = a.relY, c = 0; r.series.length > c; c++) for (var d = r.series[c], u = d.data, p = u.length; p--; ) if (i = this.getGeometry(u[p], t), 
        n = i.x - l, o = i.y - h, e = Math.sqrt(n * n + o * o), 2 * t.sensibility > e) return r.x = u[p][0], 
        r.y = u[p][1], r.index = p, r.seriesIndex = c, r;
    },
    drawHit: function(t) {
        var e = 2 * Math.PI / t.data.length, i = -Math.PI / 2, n = Math.min(t.height, t.width) * t.radiusRatio / 2, o = t.args.series, s = o.points.hitRadius || o.points.radius || o.mouse.radius, a = t.context;
        a.translate(t.width / 2, t.height / 2);
        var r = t.args.index, l = t.data[r][1] / this.max, h = Math.cos(r * e + i) * n * l, c = Math.sin(r * e + i) * n * l;
        a.beginPath(), a.arc(h, c, s, 0, 2 * Math.PI, !0), a.closePath(), a.stroke();
    },
    clearHit: function(t) {
        var e = 2 * Math.PI / t.data.length, i = -Math.PI / 2, n = Math.min(t.height, t.width) * t.radiusRatio / 2, o = t.context, s = t.args.series, a = s.points ? s.points.lineWidth : 1;
        offset = (s.points.hitRadius || s.points.radius || s.mouse.radius) + a, o.translate(t.width / 2, t.height / 2);
        var r = t.args.index, l = t.data[r][1] / this.max, h = Math.cos(r * e + i) * n * l, c = Math.sin(r * e + i) * n * l;
        o.clearRect(h - offset, c - offset, 2 * offset, 2 * offset);
    },
    extendYRange: function(t) {
        this.max = Math.max(t.max, this.max || -Number.MAX_VALUE);
    }
}), Flotr.addType("timeline", {
    options: {
        show: !1,
        lineWidth: 1,
        barWidth: .2,
        fill: !0,
        fillColor: null,
        fillOpacity: .4,
        centered: !0
    },
    draw: function(t) {
        var e = t.context;
        e.save(), e.lineJoin = "miter", e.lineWidth = t.lineWidth, e.strokeStyle = t.color, 
        e.fillStyle = t.fillStyle, this.plot(t), e.restore();
    },
    plot: function(t) {
        var e = t.data, i = t.context, n = t.xScale, o = t.yScale, s = t.barWidth, a = t.lineWidth;
        Flotr._.each(e, function(t) {
            var e = t[0], r = t[1], l = t[2], h = s, c = Math.ceil(n(e)), d = Math.ceil(n(e + l)) - c, u = Math.round(o(r)), p = Math.round(o(r - h)) - u, g = c - a / 2, f = Math.round(u - p / 2) - a / 2;
            i.strokeRect(g, f, d, p), i.fillRect(g, f, d, p);
        });
    },
    extendRange: function(t) {
        var e = t.data, i = t.xaxis, n = t.yaxis, o = t.timeline.barWidth;
        if (null === i.options.min && (i.min = i.datamin - o / 2), null === i.options.max) {
            var s = i.max;
            Flotr._.each(e, function(t) {
                s = Math.max(s, t[0] + t[2]);
            }, this), i.max = s + o / 2;
        }
        null === n.options.min && (n.min = n.datamin - o), null === n.options.min && (n.max = n.datamax + o);
    }
}), function() {
    var t = Flotr.DOM;
    Flotr.addPlugin("crosshair", {
        options: {
            mode: null,
            color: "#FF0000",
            hideCursor: !0
        },
        callbacks: {
            "flotr:mousemove": function(t, e) {
                this.options.crosshair.mode && (this.crosshair.clearCrosshair(), this.crosshair.drawCrosshair(e));
            }
        },
        drawCrosshair: function(e) {
            var i = this.octx, n = this.options.crosshair, o = this.plotOffset, s = o.left + Math.round(e.relX) + .5, a = o.top + Math.round(e.relY) + .5;
            return 0 > e.relX || 0 > e.relY || e.relX > this.plotWidth || e.relY > this.plotHeight ? (this.el.style.cursor = null, 
            t.removeClass(this.el, "flotr-crosshair"), void 0) : (n.hideCursor && (this.el.style.cursor = "none", 
            t.addClass(this.el, "flotr-crosshair")), i.save(), i.strokeStyle = n.color, i.lineWidth = 1, 
            i.beginPath(), -1 != n.mode.indexOf("x") && (i.moveTo(s, o.top), i.lineTo(s, o.top + this.plotHeight)), 
            -1 != n.mode.indexOf("y") && (i.moveTo(o.left, a), i.lineTo(o.left + this.plotWidth, a)), 
            i.stroke(), i.restore(), void 0);
        },
        clearCrosshair: function() {
            var t = this.plotOffset, e = this.lastMousePos, i = this.octx;
            e && (i.clearRect(Math.round(e.relX) + t.left, t.top, 1, this.plotHeight + 1), i.clearRect(t.left, Math.round(e.relY) + t.top, this.plotWidth + 1, 1));
        }
    });
}(), function() {
    function t(t, e, i, n, o, s) {
        var a = "image/" + t, r = i.getImageData(0, 0, n, o), l = new Image();
        return i.save(), i.globalCompositeOperation = "destination-over", i.fillStyle = s, 
        i.fillRect(0, 0, n, o), l.src = e.toDataURL(a), i.restore(), i.clearRect(0, 0, n, o), 
        i.putImageData(r, 0, 0), l;
    }
    var e = Flotr.DOM, i = Flotr._;
    Flotr.addPlugin("download", {
        saveImage: function(n, o, s, a) {
            var r, l = this.options.grid;
            if (Flotr.isIE && 9 > Flotr.isIE) return r = "<html><body>" + this.canvas.firstChild.innerHTML + "</body></html>", 
            window.open().document.write(r);
            if ("jpeg" === n || "png" === n) return r = t(n, this.canvas, this.ctx, this.canvasWidth, this.canvasHeight, l && l.backgroundColor || "#ffffff"), 
            i.isElement(r) && a ? (this.download.restoreCanvas(), e.hide(this.canvas), e.hide(this.overlay), 
            e.setStyles({
                position: "absolute"
            }), e.insert(this.el, r), this.saveImageElement = r, void 0) : window.open(r.src);
        },
        restoreCanvas: function() {
            e.show(this.canvas), e.show(this.overlay), this.saveImageElement && this.el.removeChild(this.saveImageElement), 
            this.saveImageElement = null;
        }
    });
}(), function() {
    var t = Flotr.EventAdapter, e = Flotr._;
    Flotr.addPlugin("graphGrid", {
        callbacks: {
            "flotr:beforedraw": function() {
                this.graphGrid.drawGrid();
            },
            "flotr:afterdraw": function() {
                this.graphGrid.drawOutline();
            }
        },
        drawGrid: function() {
            function i(t) {
                for (r = 0; t.length > r; ++r) {
                    var e = t[r].v / a.max;
                    for (l = 0; b >= l; ++l) h[0 === l ? "moveTo" : "lineTo"](Math.cos(l * C + w) * v * e, Math.sin(l * C + w) * v * e);
                }
            }
            function n(t, i) {
                e.each(e.pluck(t, "v"), function(t) {
                    a.min >= t || t >= a.max || (t == a.min || t == a.max) && d.outlineWidth || i(Math.floor(a.d2p(t)) + h.lineWidth / 2);
                });
            }
            function o(t) {
                h.moveTo(t, 0), h.lineTo(t, m);
            }
            function s(t) {
                h.moveTo(0, t), h.lineTo(y, t);
            }
            var a, r, l, h = this.ctx, c = this.options, d = c.grid, u = d.verticalLines, p = d.horizontalLines, g = d.minorVerticalLines, f = d.minorHorizontalLines, m = this.plotHeight, y = this.plotWidth;
            if ((u || g || p || f) && t.fire(this.el, "flotr:beforegrid", [ this.axes.x, this.axes.y, c, this ]), 
            h.save(), h.lineWidth = 1, h.strokeStyle = d.tickColor, d.circular) {
                h.translate(this.plotOffset.left + y / 2, this.plotOffset.top + m / 2);
                var v = Math.min(m, y) * c.radar.radiusRatio / 2, b = this.axes.x.ticks.length, C = 2 * (Math.PI / b), w = -Math.PI / 2;
                h.beginPath(), a = this.axes.y, p && i(a.ticks), f && i(a.minorTicks), u && e.times(b, function(t) {
                    h.moveTo(0, 0), h.lineTo(Math.cos(t * C + w) * v, Math.sin(t * C + w) * v);
                }), h.stroke();
            } else h.translate(this.plotOffset.left, this.plotOffset.top), d.backgroundColor && (h.fillStyle = this.processColor(d.backgroundColor, {
                x1: 0,
                y1: 0,
                x2: y,
                y2: m
            }), h.fillRect(0, 0, y, m)), h.beginPath(), a = this.axes.x, u && n(a.ticks, o), 
            g && n(a.minorTicks, o), a = this.axes.y, p && n(a.ticks, s), f && n(a.minorTicks, s), 
            h.stroke();
            h.restore(), (u || g || p || f) && t.fire(this.el, "flotr:aftergrid", [ this.axes.x, this.axes.y, c, this ]);
        },
        drawOutline: function() {
            var t, e, n, o, s = this, a = s.options, r = a.grid, l = r.outline, h = s.ctx, c = r.backgroundImage, d = s.plotOffset, u = d.left, p = d.top, g = s.plotWidth, f = s.plotHeight;
            if (r.outlineWidth) {
                if (h.save(), r.circular) {
                    h.translate(u + g / 2, p + f / 2);
                    var m = Math.min(f, g) * a.radar.radiusRatio / 2, y = this.axes.x.ticks.length, v = 2 * (Math.PI / y), b = -Math.PI / 2;
                    for (h.beginPath(), h.lineWidth = r.outlineWidth, h.strokeStyle = r.color, h.lineJoin = "round", 
                    i = 0; y >= i; ++i) h[0 === i ? "moveTo" : "lineTo"](Math.cos(i * v + b) * m, Math.sin(i * v + b) * m);
                    h.stroke();
                } else {
                    h.translate(u, p);
                    var C = r.outlineWidth, w = .5 - C + (C + 1) % 2 / 2, S = "lineTo", x = "moveTo";
                    h.lineWidth = C, h.strokeStyle = r.color, h.lineJoin = "miter", h.beginPath(), h.moveTo(w, w), 
                    g -= C / 2 % 1, f += C / 2, h[-1 !== l.indexOf("n") ? S : x](g, w), h[-1 !== l.indexOf("e") ? S : x](g, f), 
                    h[-1 !== l.indexOf("s") ? S : x](w, f), h[-1 !== l.indexOf("w") ? S : x](w, w), 
                    h.stroke(), h.closePath();
                }
                h.restore(), c && (e = c.src || c, n = (parseInt(c.left, 10) || 0) + d.left, o = (parseInt(c.top, 10) || 0) + d.top, 
                t = new Image(), t.onload = function() {
                    h.save(), c.alpha && (h.globalAlpha = c.alpha), h.globalCompositeOperation = "destination-over", 
                    h.drawImage(t, 0, 0, t.width, t.height, n, o, g, f), h.restore();
                }, t.src = e);
            }
        }
    });
}(), function() {
    var t = Flotr.DOM, e = Flotr._, i = Flotr, n = "opacity:0.7;background-color:#000;color:#fff;position:absolute;padding:2px 8px;-moz-border-radius:4px;border-radius:4px;white-space:nowrap;";
    Flotr.addPlugin("hit", {
        callbacks: {
            "flotr:mousemove": function(t, e) {
                this.hit.track(e);
            },
            "flotr:click": function(t) {
                var i = this.hit.track(t);
                i && !e.isUndefined(i.index) && (t.hit = i);
            },
            "flotr:mouseout": function(t) {
                t.relatedTarget !== this.mouseTrack && this.hit.clearHit();
            },
            "flotr:destroy": function() {
                this.options.mouse.container && t.remove(this.mouseTrack), this.mouseTrack = null;
            }
        },
        track: function(t) {
            return this.options.mouse.track || e.any(this.series, function(t) {
                return t.mouse && t.mouse.track;
            }) ? this.hit.hit(t) : void 0;
        },
        executeOnType: function(t, n, o) {
            function s(t, s) {
                e.each(e.keys(i.graphTypes), function(e) {
                    t[e] && t[e].show && this[e][n] && (a = this.getOptions(t, e), a.fill = !!t.mouse.fillColor, 
                    a.fillStyle = this.processColor(t.mouse.fillColor || "#ffffff", {
                        opacity: t.mouse.fillOpacity
                    }), a.color = t.mouse.lineColor, a.context = this.octx, a.index = s, o && (a.args = o), 
                    this[e][n].call(this[e], a), r = !0);
                }, this);
            }
            var a, r = !1;
            return e.isArray(t) || (t = [ t ]), e.each(t, s, this), r;
        },
        drawHit: function(t) {
            var e = this.octx, i = t.series;
            if (i.mouse.lineColor) {
                if (e.save(), e.lineWidth = i.points ? i.points.lineWidth : 1, e.strokeStyle = i.mouse.lineColor, 
                e.fillStyle = this.processColor(i.mouse.fillColor || "#ffffff", {
                    opacity: i.mouse.fillOpacity
                }), e.translate(this.plotOffset.left, this.plotOffset.top), !this.hit.executeOnType(i, "drawHit", t)) {
                    var n = t.xaxis, o = t.yaxis;
                    e.beginPath(), e.arc(n.d2p(t.x), o.d2p(t.y), i.points.hitRadius || i.points.radius || i.mouse.radius, 0, 2 * Math.PI, !0), 
                    e.fill(), e.stroke(), e.closePath();
                }
                e.restore(), this.clip(e);
            }
            this.prevHit = t;
        },
        clearHit: function() {
            var e = this.prevHit, i = this.octx, n = this.plotOffset;
            if (i.save(), i.translate(n.left, n.top), e) {
                if (!this.hit.executeOnType(e.series, "clearHit", this.prevHit)) {
                    var o = e.series, s = o.points ? o.points.lineWidth : 1;
                    offset = (o.points.hitRadius || o.points.radius || o.mouse.radius) + s, i.clearRect(e.xaxis.d2p(e.x) - offset, e.yaxis.d2p(e.y) - offset, 2 * offset, 2 * offset);
                }
                t.hide(this.mouseTrack), this.prevHit = null;
            }
            i.restore();
        },
        hit: function(t) {
            var i, n, o, s, a, r, l, h = this.options, c = this.prevHit;
            if (0 !== this.series.length) return l = {
                relX: t.relX,
                relY: t.relY,
                absX: t.absX,
                absY: t.absY,
                series: this.series
            }, h.mouse.trackY && !h.mouse.trackAll && this.hit.executeOnType(this.series, "hit", [ t, l ]) && !e.isUndefined(l.seriesIndex) ? (s = this.series[l.seriesIndex], 
            l.series = s, l.mouse = s.mouse, l.xaxis = s.xaxis, l.yaxis = s.yaxis) : (i = this.hit.closest(t), 
            i && (i = h.mouse.trackY ? i.point : i.x, o = i.seriesIndex, s = this.series[o], 
            a = s.xaxis, r = s.yaxis, n = 2 * s.mouse.sensibility, (h.mouse.trackAll || i.distanceX < n / a.scale && (!h.mouse.trackY || i.distanceY < n / r.scale)) && (l.series = s, 
            l.xaxis = s.xaxis, l.yaxis = s.yaxis, l.mouse = s.mouse, l.x = i.x, l.y = i.y, l.dist = i.distance, 
            l.index = i.dataIndex, l.seriesIndex = o))), c && c.index === l.index && c.seriesIndex === l.seriesIndex || (this.hit.clearHit(), 
            l.series && l.mouse && l.mouse.track && (this.hit.drawMouseTrack(l), this.hit.drawHit(l), 
            Flotr.EventAdapter.fire(this.el, "flotr:hit", [ l, this ]))), l;
        },
        closest: function(t) {
            function e(t) {
                t.distance = o, t.distanceX = s, t.distanceY = a, t.seriesIndex = d, t.dataIndex = u, 
                t.x = h, t.y = c, C = !0;
            }
            var i, n, o, s, a, r, l, h, c, d, u, p = this.series, g = (this.options, t.relX), f = t.relY, m = Number.MAX_VALUE, y = Number.MAX_VALUE, v = {}, b = {}, C = !1;
            for (d = 0; p.length > d; d++) for (i = p[d], n = i.data, r = i.xaxis.p2d(g), l = i.yaxis.p2d(f), 
            u = n.length; u--; ) h = n[u][0], c = n[u][1], null !== h && null !== c && (i.xaxis.min > h || h > i.xaxis.max || (s = Math.abs(h - r), 
            a = Math.abs(c - l), o = s * s + a * a, m > o && (m = o, e(v)), y > s && (y = s, 
            e(b))));
            return C ? {
                point: v,
                x: b
            } : !1;
        },
        drawMouseTrack: function(e) {
            var i, o, s = "", a = e.series, r = e.mouse.position, l = e.mouse.margin, h = e.x, c = e.y, d = n, u = this.mouseTrack, p = this.plotOffset, g = p.left, f = (p.right, 
            p.bottom, p.top), m = e.mouse.trackDecimals, y = this.options, v = y.mouse.container, b = 0, C = 0;
            if (u || (u = t.node('<div class="flotr-mouse-value" style="' + d + '"></div>'), 
            this.mouseTrack = u, t.insert(v || this.el, u)), (!m || 0 > m) && (m = 0), h && h.toFixed && (h = h.toFixed(m)), 
            c && c.toFixed && (c = c.toFixed(m)), u.innerHTML = e.mouse.trackFormatter({
                x: h,
                y: c,
                series: e.series,
                index: e.index,
                nearest: e,
                fraction: e.fraction
            }), t.show(u), o = t.size(u), v && (i = t.position(this.el), b = i.top, C = i.left), 
            e.mouse.relative) if (a.pie && a.pie.show) {
                var w = {
                    x: this.plotWidth / 2,
                    y: this.plotHeight / 2
                }, S = Math.min(this.canvasWidth, this.canvasHeight) * a.pie.sizeRatio / 2, x = e.sAngle < e.eAngle ? (e.sAngle + e.eAngle) / 2 : (e.sAngle + e.eAngle + 2 * Math.PI) / 2;
                s += "bottom:" + (l - f - w.y - Math.sin(x) * S / 2 + this.canvasHeight) + "px;top:auto;", 
                s += "left:" + (l + g + w.x + Math.cos(x) * S / 2) + "px;right:auto;";
            } else s += "top:", s += /n/.test(r) ? b - l + f + e.yaxis.d2p(e.y) - o.height : b + l + f + e.yaxis.d2p(e.y), 
            s += "px;bottom:auto;left:", s += /w/.test(r) ? C - l + g + e.xaxis.d2p(e.x) - o.width : C + l + g + e.xaxis.d2p(e.x), 
            s += "px;right:auto;"; else s += "top:", "n" == r.charAt(0) ? s += b + l + f : "s" == r.charAt(0) && (s += b - l + f + this.plotHeight - o.height), 
            s += "px;bottom:auto;left:", "e" == r.charAt(1) ? s += C - l + g + this.plotWidth - o.width : "w" == r.charAt(1) && (s += C + l + g), 
            s += "px;right:auto;";
            u.style.cssText = d + s, e.mouse.relative && (/[ew]/.test(r) ? /[ns]/.test(r) || (u.style.top = b + f + e.yaxis.d2p(e.y) - t.size(u).height / 2 + "px") : u.style.left = C + g + e.xaxis.d2p(e.x) - t.size(u).width / 2 + "px");
        }
    });
}(), function() {
    function t(t) {
        return t.which ? 1 === t.which : 0 === t.button || 1 === t.button;
    }
    function e(t, e) {
        return Math.min(Math.max(0, t), e.plotWidth - 1);
    }
    function i(t, e) {
        return Math.min(Math.max(0, t), e.plotHeight);
    }
    var n = (Flotr.DOM, Flotr.EventAdapter), o = Flotr._;
    Flotr.addPlugin("selection", {
        options: {
            pinchOnly: null,
            mode: null,
            color: "#B6D9FF",
            fps: 20
        },
        callbacks: {
            "flotr:mouseup": function(t) {
                var e = this.options.selection, i = this.selection, n = this.getEventPosition(t);
                e && e.mode && (i.interval && clearInterval(i.interval), this.multitouches ? i.updateSelection() : e.pinchOnly || i.setSelectionPos(i.selection.second, n), 
                i.clearSelection(), i.selecting && i.selectionIsSane() && (i.drawSelection(), i.fireSelectEvent(), 
                this.ignoreClick = !0));
            },
            "flotr:mousedown": function(e) {
                var i = this.options.selection, n = this.selection, s = this.getEventPosition(e);
                i && i.mode && (!i.mode || !t(e) && o.isUndefined(e.touches) || (i.pinchOnly || n.setSelectionPos(n.selection.first, s), 
                n.interval && clearInterval(n.interval), this.lastMousePos.pageX = null, n.selecting = !1, 
                n.interval = setInterval(o.bind(n.updateSelection, this), 1e3 / i.fps)));
            },
            "flotr:destroy": function() {
                clearInterval(this.selection.interval);
            }
        },
        getArea: function() {
            var t, e, i, n, o = this.selection.selection, s = this.axes;
            return o.first, o.second, t = s.x.p2d(o.first.x), e = s.x.p2d(o.second.x), i = s.y.p2d(o.first.y), 
            n = s.y.p2d(o.second.y), {
                x1: Math.min(t, e),
                y1: Math.min(i, n),
                x2: Math.max(t, e),
                y2: Math.max(i, n),
                xfirst: t,
                xsecond: e,
                yfirst: i,
                ysecond: n
            };
        },
        selection: {
            first: {
                x: -1,
                y: -1
            },
            second: {
                x: -1,
                y: -1
            }
        },
        prevSelection: null,
        interval: null,
        fireSelectEvent: function(t) {
            var e = this.selection.getArea();
            t = t || "select", e.selection = this.selection.selection, n.fire(this.el, "flotr:" + t, [ e, this ]);
        },
        setSelection: function(t, n) {
            var o = this.options, s = this.axes.x, a = this.axes.y, r = a.scale, l = s.scale, h = -1 != o.selection.mode.indexOf("x"), c = -1 != o.selection.mode.indexOf("y"), d = this.selection.selection;
            this.selection.clearSelection(), d.first.y = i(h && !c ? 0 : (a.max - t.y1) * r, this), 
            d.second.y = i(h && !c ? this.plotHeight - 1 : (a.max - t.y2) * r, this), d.first.x = e(c && !h ? 0 : (t.x1 - s.min) * l, this), 
            d.second.x = e(c && !h ? this.plotWidth : (t.x2 - s.min) * l, this), this.selection.drawSelection(), 
            n || this.selection.fireSelectEvent();
        },
        setSelectionPos: function(t, n) {
            var o = this.options.selection.mode, s = this.selection.selection;
            t.x = -1 == o.indexOf("x") ? t == s.first ? 0 : this.plotWidth : e(n.relX, this), 
            t.y = -1 == o.indexOf("y") ? t == s.first ? 0 : this.plotHeight - 1 : i(n.relY, this);
        },
        drawSelection: function() {
            this.selection.fireSelectEvent("selecting");
            var t = this.selection.selection, e = this.octx, i = this.options, n = this.plotOffset, o = this.selection.prevSelection;
            if (!o || t.first.x != o.first.x || t.first.y != o.first.y || t.second.x != o.second.x || t.second.y != o.second.y) {
                e.save(), e.strokeStyle = this.processColor(i.selection.color, {
                    opacity: .8
                }), e.lineWidth = 1, e.lineJoin = "miter", e.fillStyle = this.processColor(i.selection.color, {
                    opacity: .4
                }), this.selection.prevSelection = {
                    first: {
                        x: t.first.x,
                        y: t.first.y
                    },
                    second: {
                        x: t.second.x,
                        y: t.second.y
                    }
                };
                var s = Math.min(t.first.x, t.second.x), a = Math.min(t.first.y, t.second.y), r = Math.abs(t.second.x - t.first.x), l = Math.abs(t.second.y - t.first.y);
                e.fillRect(s + n.left + .5, a + n.top + .5, r, l), e.strokeRect(s + n.left + .5, a + n.top + .5, r, l), 
                e.restore();
            }
        },
        updateSelection: function() {
            if (this.lastMousePos.pageX) {
                if (this.selection.selecting = !0, this.multitouches) this.selection.setSelectionPos(this.selection.selection.first, this.getEventPosition(this.multitouches[0])), 
                this.selection.setSelectionPos(this.selection.selection.second, this.getEventPosition(this.multitouches[1])); else {
                    if (this.options.selection.pinchOnly) return;
                    this.selection.setSelectionPos(this.selection.selection.second, this.lastMousePos);
                }
                this.selection.clearSelection(), this.selection.selectionIsSane() && this.selection.drawSelection();
            }
        },
        clearSelection: function() {
            if (this.selection.prevSelection) {
                var t = this.selection.prevSelection, e = 1, i = this.plotOffset, n = Math.min(t.first.x, t.second.x), o = Math.min(t.first.y, t.second.y), s = Math.abs(t.second.x - t.first.x), a = Math.abs(t.second.y - t.first.y);
                this.octx.clearRect(n + i.left - e + .5, o + i.top - e, s + 2 * e + .5, a + 2 * e + .5), 
                this.selection.prevSelection = null;
            }
        },
        selectionIsSane: function() {
            var t = this.selection.selection;
            return Math.abs(t.second.x - t.first.x) >= 5 || Math.abs(t.second.y - t.first.y) >= 5;
        }
    });
}(), function() {
    var t = Flotr.DOM;
    Flotr.addPlugin("labels", {
        callbacks: {
            "flotr:afterdraw": function() {
                this.labels.draw();
            }
        },
        draw: function() {
            function e(t, e, i) {
                var n, s = i ? e.minorTicks : e.ticks, r = 1 === e.orientation;
                for (1 === e.n, n = {
                    color: e.options.color || g.grid.color,
                    angle: Flotr.toRad(e.options.labelsAngle),
                    textBaseline: "middle"
                }, d = 0; s.length > d && (i ? e.options.showMinorLabels : e.options.showLabels); ++d) o = s[d], 
                o.label += "", o.label && o.label.length && (x = Math.cos(d * l + h) * a, y = Math.sin(d * l + h) * a, 
                n.textAlign = r ? .1 > Math.abs(x) ? "center" : 0 > x ? "right" : "left" : "left", 
                Flotr.drawText(f, o.label, r ? x : 3, r ? y : -(e.ticks[d].v / e.max) * (a - g.fontSize), n));
            }
            function i(t, e, i, n) {
                function s(t) {
                    return t.options.showLabels && t.used;
                }
                function a(t, e, i, n) {
                    return t.plotOffset.left + (e ? n : i ? -g.grid.labelMargin : g.grid.labelMargin + t.plotWidth);
                }
                function r(t, e, i, n) {
                    return t.plotOffset.top + (e ? g.grid.labelMargin : n) + (e && i ? t.plotHeight : 0);
                }
                var l, h, c = 1 === e.orientation, u = 1 === e.n;
                for (l = {
                    color: e.options.color || g.grid.color,
                    textAlign: i,
                    textBaseline: n,
                    angle: Flotr.toRad(e.options.labelsAngle)
                }, l = Flotr.getBestTextAlign(l.angle, l), d = 0; e.ticks.length > d && s(e); ++d) o = e.ticks[d], 
                o.label && o.label.length && (h = e.d2p(o.v), 0 > h || h > (c ? t.plotWidth : t.plotHeight) || (Flotr.drawText(f, o.label, a(t, c, u, h), r(t, c, u, h), l), 
                !c && !u && (f.save(), f.strokeStyle = l.color, f.beginPath(), f.moveTo(t.plotOffset.left + t.plotWidth - 8, t.plotOffset.top + e.d2p(o.v)), 
                f.lineTo(t.plotOffset.left + t.plotWidth, t.plotOffset.top + e.d2p(o.v)), f.stroke(), 
                f.restore())));
            }
            function n(t, e) {
                var i, n, a = 1 === e.orientation, r = 1 === e.n, l = "", h = t.plotOffset;
                if (!a && !r && (f.save(), f.strokeStyle = e.options.color || g.grid.color, f.beginPath()), 
                e.options.showLabels && (r ? !0 : e.used)) for (d = 0; e.ticks.length > d; ++d) o = e.ticks[d], 
                !o.label || !o.label.length || 0 > (a ? h.left : h.top) + e.d2p(o.v) || (a ? h.left : h.top) + e.d2p(o.v) > (a ? t.canvasWidth : t.canvasHeight) || (n = h.top + (a ? (r ? 1 : -1) * (t.plotHeight + g.grid.labelMargin) : e.d2p(o.v) - e.maxLabel.height / 2), 
                i = a ? h.left + e.d2p(o.v) - s / 2 : 0, l = "", 0 === d ? l = " first" : d === e.ticks.length - 1 && (l = " last"), 
                l += a ? " flotr-grid-label-x" : " flotr-grid-label-y", u += [ '<div style="position:absolute; text-align:' + (a ? "center" : "right") + "; ", "top:" + n + "px; ", (a || r ? "left:" : "right:") + i + "px; ", "width:" + (a ? s : (r ? h.left : h.right) - g.grid.labelMargin) + "px; ", e.options.color ? "color:" + e.options.color + "; " : " ", '" class="flotr-grid-label' + l + '">' + o.label + "</div>" ].join(" "), 
                !a && !r && (f.moveTo(h.left + t.plotWidth - 8, h.top + e.d2p(o.v)), f.lineTo(h.left + t.plotWidth, h.top + e.d2p(o.v))));
            }
            var o, s, a, r, l, h, c, d, u = "", p = 0, g = this.options, f = this.ctx, m = this.axes;
            for ({
                size: g.fontSize
            }, d = 0; m.x.ticks.length > d; ++d) m.x.ticks[d].label && ++p;
            s = this.plotWidth / p, g.grid.circular && (f.save(), f.translate(this.plotOffset.left + this.plotWidth / 2, this.plotOffset.top + this.plotHeight / 2), 
            a = this.plotHeight * g.radar.radiusRatio / 2 + g.fontSize, r = this.axes.x.ticks.length, 
            l = 2 * (Math.PI / r), h = -Math.PI / 2, e(this, m.x, !1), e(this, m.x, !0), e(this, m.y, !1), 
            e(this, m.y, !0), f.restore()), !g.HtmlText && this.textEnabled ? (i(this, m.x, "center", "top"), 
            i(this, m.x2, "center", "bottom"), i(this, m.y, "right", "middle"), i(this, m.y2, "left", "middle")) : (m.x.options.showLabels || m.x2.options.showLabels || m.y.options.showLabels || m.y2.options.showLabels) && !g.grid.circular && (u = "", 
            n(this, m.x), n(this, m.x2), n(this, m.y), n(this, m.y2), f.stroke(), f.restore(), 
            c = t.create("div"), t.setStyles(c, {
                fontSize: "smaller",
                color: g.grid.color
            }), c.className = "flotr-labels", t.insert(this.el, c), t.insert(c, u));
        }
    });
}(), function() {
    var t = Flotr.DOM, e = Flotr._;
    Flotr.addPlugin("legend", {
        options: {
            show: !0,
            noColumns: 1,
            labelFormatter: function(t) {
                return t;
            },
            labelBoxBorderColor: "#CCCCCC",
            labelBoxWidth: 14,
            labelBoxHeight: 10,
            labelBoxMargin: 5,
            container: null,
            position: "nw",
            margin: 5,
            backgroundColor: "#F0F0F0",
            backgroundOpacity: .85
        },
        callbacks: {
            "flotr:afterinit": function() {
                this.legend.insertLegend();
            },
            "flotr:destroy": function() {
                var e = this.legend.markup;
                e && (this.legend.markup = null, t.remove(e));
            }
        },
        insertLegend: function() {
            if (this.options.legend.show) {
                var i, n, o, s = this.series, a = this.plotOffset, r = this.options, l = r.legend, h = [], c = !1, d = this.ctx, u = e.filter(s, function(t) {
                    return t.label && !t.hide;
                }).length, p = l.position, g = l.margin, f = l.backgroundOpacity;
                if (u) {
                    var m = l.labelBoxWidth, y = l.labelBoxHeight, v = l.labelBoxMargin, b = a.left + g, C = a.top + g, w = 0, S = {
                        size: 1.1 * r.fontSize,
                        color: r.grid.color
                    };
                    for (i = s.length - 1; i > -1; --i) s[i].label && !s[i].hide && (n = l.labelFormatter(s[i].label), 
                    w = Math.max(w, this._text.measureText(n, S).width));
                    var x = Math.round(m + 3 * v + w), k = Math.round(u * (v + y) + v);
                    if (!f && 0 !== f && (f = .1), r.HtmlText || !this.textEnabled || l.container) {
                        for (i = 0; s.length > i; ++i) if (s[i].label && !s[i].hide) {
                            0 === i % l.noColumns && (h.push(c ? "</tr><tr>" : "<tr>"), c = !0);
                            var P = s[i], T = l.labelBoxWidth, M = l.labelBoxHeight;
                            n = l.labelFormatter(P.label), o = "background-color:" + (P.bars && P.bars.show && P.bars.fillColor && P.bars.fill ? P.bars.fillColor : P.color) + ";", 
                            h.push('<td class="flotr-legend-color-box">', '<div style="border:1px solid ', l.labelBoxBorderColor, ';padding:1px">', '<div style="width:', T - 1, "px;height:", M - 1, "px;border:1px solid ", s[i].color, '">', '<div style="width:', T, "px;height:", M, "px;", o, '"></div>', "</div>", "</div>", "</td>", '<td class="flotr-legend-label">', n, "</td>");
                        }
                        if (c && h.push("</tr>"), h.length > 0) {
                            var I = '<table style="font-size:smaller;color:' + r.grid.color + '">' + h.join("") + "</table>";
                            if (l.container) I = t.node(I), this.legend.markup = I, t.insert(l.container, I); else {
                                var D = {
                                    position: "absolute",
                                    zIndex: "2",
                                    border: "1px solid " + l.labelBoxBorderColor
                                };
                                "n" == p.charAt(0) ? (D.top = g + a.top + "px", D.bottom = "auto") : "c" == p.charAt(0) ? (D.top = g + (this.plotHeight - k) / 2 + "px", 
                                D.bottom = "auto") : "s" == p.charAt(0) && (D.bottom = g + a.bottom + "px", D.top = "auto"), 
                                "e" == p.charAt(1) ? (D.right = g + a.right + "px", D.left = "auto") : "w" == p.charAt(1) && (D.left = g + a.left + "px", 
                                D.right = "auto");
                                var $ = t.create("div");
                                if ($.className = "flotr-legend", t.setStyles($, D), t.insert($, I), t.insert(this.el, $), 
                                !f) return;
                                var A = l.backgroundColor || r.grid.backgroundColor || "#ffffff";
                                e.extend(D, t.size($), {
                                    backgroundColor: A,
                                    zIndex: "",
                                    border: ""
                                }), D.width += "px", D.height += "px", $ = t.create("div"), $.className = "flotr-legend-bg", 
                                t.setStyles($, D), t.opacity($, f), t.insert($, " "), t.insert(this.el, $);
                            }
                        }
                    } else {
                        "s" == p.charAt(0) && (C = a.top + this.plotHeight - (g + k)), "c" == p.charAt(0) && (C = a.top + this.plotHeight / 2 - (g + k / 2)), 
                        "e" == p.charAt(1) && (b = a.left + this.plotWidth - (g + x)), o = this.processColor(l.backgroundColor, {
                            opacity: f
                        }), d.fillStyle = o, d.fillRect(b, C, x, k), d.strokeStyle = l.labelBoxBorderColor, 
                        d.strokeRect(Flotr.toPixel(b), Flotr.toPixel(C), x, k);
                        var F = b + v, R = C + v;
                        for (i = 0; s.length > i; i++) s[i].label && !s[i].hide && (n = l.labelFormatter(s[i].label), 
                        d.fillStyle = s[i].color, d.fillRect(F, R, m - 1, y - 1), d.strokeStyle = l.labelBoxBorderColor, 
                        d.lineWidth = 1, d.strokeRect(Math.ceil(F) - 1.5, Math.ceil(R) - 1.5, m + 2, y + 2), 
                        Flotr.drawText(d, n, F + m + v, R + y, S), R += y + v);
                    }
                }
            }
        }
    });
}(), function() {
    function t(t) {
        if (this.options.spreadsheet.tickFormatter) return this.options.spreadsheet.tickFormatter(t);
        var e = i.find(this.axes.x.ticks, function(e) {
            return e.v == t;
        });
        return e ? e.label : t;
    }
    var e = Flotr.DOM, i = Flotr._;
    Flotr.addPlugin("spreadsheet", {
        options: {
            show: !1,
            tabGraphLabel: "Graph",
            tabDataLabel: "Data",
            toolbarDownload: "Download CSV",
            toolbarSelectAll: "Select all",
            csvFileSeparator: ",",
            decimalSeparator: ".",
            tickFormatter: null,
            initialTab: "graph"
        },
        callbacks: {
            "flotr:afterconstruct": function() {
                if (this.options.spreadsheet.show) {
                    var t, i = this.spreadsheet, n = e.node('<div class="flotr-tabs-group" style="position:absolute;left:0px;width:' + this.canvasWidth + 'px"></div>'), o = e.node('<div style="float:left" class="flotr-tab selected">' + this.options.spreadsheet.tabGraphLabel + "</div>"), s = e.node('<div style="float:left" class="flotr-tab">' + this.options.spreadsheet.tabDataLabel + "</div>");
                    i.tabsContainer = n, i.tabs = {
                        graph: o,
                        data: s
                    }, e.insert(n, o), e.insert(n, s), e.insert(this.el, n), t = e.size(s).height + 2, 
                    this.plotOffset.bottom += t, e.setStyles(n, {
                        top: this.canvasHeight - t + "px"
                    }), this.observe(o, "click", function() {
                        i.showTab("graph");
                    }).observe(s, "click", function() {
                        i.showTab("data");
                    }), "graph" !== this.options.spreadsheet.initialTab && i.showTab(this.options.spreadsheet.initialTab);
                }
            }
        },
        loadDataGrid: function() {
            if (this.seriesData) return this.seriesData;
            var t = this.series, e = {};
            return i.each(t, function(t, n) {
                i.each(t.data, function(t) {
                    var i = t[0], o = t[1], s = e[i];
                    if (s) s[n + 1] = o; else {
                        var a = [];
                        a[0] = i, a[n + 1] = o, e[i] = a;
                    }
                });
            }), this.seriesData = i.sortBy(e, function(t, e) {
                return parseInt(e, 10);
            }), this.seriesData;
        },
        constructDataGrid: function() {
            if (this.spreadsheet.datagrid) return this.spreadsheet.datagrid;
            var n, o, s, a = this.series, r = this.spreadsheet.loadDataGrid(), l = [ "<colgroup><col />" ], h = [ '<table class="flotr-datagrid"><tr class="first-row">' ];
            h.push("<th>&nbsp;</th>"), i.each(a, function(t, e) {
                h.push('<th scope="col">' + (t.label || String.fromCharCode(65 + e)) + "</th>"), 
                l.push("<col />");
            }), h.push("</tr>"), i.each(r, function(e) {
                h.push("<tr>"), i.times(a.length + 1, function(n) {
                    var o = "td", s = e[n], a = i.isUndefined(s) ? "" : Math.round(1e5 * s) / 1e5;
                    if (0 === n) {
                        o = "th";
                        var r = t.call(this, a);
                        r && (a = r);
                    }
                    h.push("<" + o + ("th" == o ? ' scope="row"' : "") + ">" + a + "</" + o + ">");
                }, this), h.push("</tr>");
            }, this), l.push("</colgroup>"), s = e.node(h.join("")), n = e.node('<button type="button" class="flotr-datagrid-toolbar-button">' + this.options.spreadsheet.toolbarDownload + "</button>"), 
            o = e.node('<button type="button" class="flotr-datagrid-toolbar-button">' + this.options.spreadsheet.toolbarSelectAll + "</button>"), 
            this.observe(n, "click", i.bind(this.spreadsheet.downloadCSV, this)).observe(o, "click", i.bind(this.spreadsheet.selectAllData, this));
            var c = e.node('<div class="flotr-datagrid-toolbar"></div>');
            e.insert(c, n), e.insert(c, o);
            var d = this.canvasHeight - e.size(this.spreadsheet.tabsContainer).height - 2, u = e.node('<div class="flotr-datagrid-container" style="position:absolute;left:0px;top:0px;width:' + this.canvasWidth + "px;height:" + d + 'px;overflow:auto;z-index:10"></div>');
            return e.insert(u, c), e.insert(u, s), e.insert(this.el, u), this.spreadsheet.datagrid = s, 
            this.spreadsheet.container = u, s;
        },
        showTab: function(t) {
            if (this.spreadsheet.activeTab !== t) {
                switch (t) {
                  case "graph":
                    e.hide(this.spreadsheet.container), e.removeClass(this.spreadsheet.tabs.data, "selected"), 
                    e.addClass(this.spreadsheet.tabs.graph, "selected");
                    break;

                  case "data":
                    this.spreadsheet.datagrid || this.spreadsheet.constructDataGrid(), e.show(this.spreadsheet.container), 
                    e.addClass(this.spreadsheet.tabs.data, "selected"), e.removeClass(this.spreadsheet.tabs.graph, "selected");
                    break;

                  default:
                    throw "Illegal tab name: " + t;
                }
                this.spreadsheet.activeTab = t;
            }
        },
        selectAllData: function() {
            if (this.spreadsheet.tabs) {
                var t, e, i, n, o = this.spreadsheet.constructDataGrid();
                return this.spreadsheet.showTab("data"), setTimeout(function() {
                    (i = o.ownerDocument) && (n = i.defaultView) && n.getSelection && i.createRange && (t = window.getSelection()) && t.removeAllRanges ? (e = i.createRange(), 
                    e.selectNode(o), t.removeAllRanges(), t.addRange(e)) : document.body && document.body.createTextRange && (e = document.body.createTextRange()) && (e.moveToElementText(o), 
                    e.select());
                }, 0), !0;
            }
            return !1;
        },
        downloadCSV: function() {
            var e = "", n = this.series, o = this.options, s = this.spreadsheet.loadDataGrid(), a = encodeURIComponent(o.spreadsheet.csvFileSeparator);
            if (o.spreadsheet.decimalSeparator === o.spreadsheet.csvFileSeparator) throw "The decimal separator is the same as the column separator (" + o.spreadsheet.decimalSeparator + ")";
            i.each(n, function(t, i) {
                e += a + '"' + (t.label || String.fromCharCode(65 + i)).replace(/\"/g, '\\"') + '"';
            }), e += "%0D%0A", e += i.reduce(s, function(e, i) {
                var n = t.call(this, i[0]) || "";
                n = '"' + (n + "").replace(/\"/g, '\\"') + '"';
                var s = i.slice(1).join(a);
                return "." !== o.spreadsheet.decimalSeparator && (s = s.replace(/\./g, o.spreadsheet.decimalSeparator)), 
                e + n + a + s + "%0D%0A";
            }, "", this), Flotr.isIE && 9 > Flotr.isIE ? (e = e.replace(RegExp(a, "g"), decodeURIComponent(a)).replace(/%0A/g, "\n").replace(/%0D/g, "\r"), 
            window.open().document.write(e)) : window.open("data:text/csv," + e);
        }
    });
}(), function() {
    var t = Flotr.DOM;
    Flotr.addPlugin("titles", {
        callbacks: {
            "flotr:afterdraw": function() {
                this.titles.drawTitles();
            }
        },
        drawTitles: function() {
            var e, i = this.options, n = i.grid.labelMargin, o = this.ctx, s = this.axes;
            if (!i.HtmlText && this.textEnabled) {
                var a = {
                    size: i.fontSize,
                    color: i.grid.color,
                    textAlign: "center"
                };
                i.subtitle && Flotr.drawText(o, i.subtitle, this.plotOffset.left + this.plotWidth / 2, this.titleHeight + this.subtitleHeight - 2, a), 
                a.weight = 1.5, a.size *= 1.5, i.title && Flotr.drawText(o, i.title, this.plotOffset.left + this.plotWidth / 2, this.titleHeight - 2, a), 
                a.weight = 1.8, a.size *= .8, s.x.options.title && s.x.used && (a.textAlign = s.x.options.titleAlign || "center", 
                a.textBaseline = "top", a.angle = Flotr.toRad(s.x.options.titleAngle), a = Flotr.getBestTextAlign(a.angle, a), 
                Flotr.drawText(o, s.x.options.title, this.plotOffset.left + this.plotWidth / 2, this.plotOffset.top + s.x.maxLabel.height + this.plotHeight + 2 * n, a)), 
                s.x2.options.title && s.x2.used && (a.textAlign = s.x2.options.titleAlign || "center", 
                a.textBaseline = "bottom", a.angle = Flotr.toRad(s.x2.options.titleAngle), a = Flotr.getBestTextAlign(a.angle, a), 
                Flotr.drawText(o, s.x2.options.title, this.plotOffset.left + this.plotWidth / 2, this.plotOffset.top - s.x2.maxLabel.height - 2 * n, a)), 
                s.y.options.title && s.y.used && (a.textAlign = s.y.options.titleAlign || "right", 
                a.textBaseline = "middle", a.angle = Flotr.toRad(s.y.options.titleAngle), a = Flotr.getBestTextAlign(a.angle, a), 
                Flotr.drawText(o, s.y.options.title, this.plotOffset.left - s.y.maxLabel.width - 2 * n, this.plotOffset.top + this.plotHeight / 2, a)), 
                s.y2.options.title && s.y2.used && (a.textAlign = s.y2.options.titleAlign || "left", 
                a.textBaseline = "middle", a.angle = Flotr.toRad(s.y2.options.titleAngle), a = Flotr.getBestTextAlign(a.angle, a), 
                Flotr.drawText(o, s.y2.options.title, this.plotOffset.left + this.plotWidth + s.y2.maxLabel.width + 2 * n, this.plotOffset.top + this.plotHeight / 2, a));
            } else {
                e = [], i.title && e.push('<div style="position:absolute;top:0;left:', this.plotOffset.left, "px;font-size:1em;font-weight:bold;text-align:center;width:", this.plotWidth, 'px;" class="flotr-title">', i.title, "</div>"), 
                i.subtitle && e.push('<div style="position:absolute;top:', this.titleHeight, "px;left:", this.plotOffset.left, "px;font-size:smaller;text-align:center;width:", this.plotWidth, 'px;" class="flotr-subtitle">', i.subtitle, "</div>"), 
                e.push("</div>"), e.push('<div class="flotr-axis-title" style="font-weight:bold;">'), 
                s.x.options.title && s.x.used && e.push('<div style="position:absolute;top:', this.plotOffset.top + this.plotHeight + i.grid.labelMargin + s.x.titleSize.height, "px;left:", this.plotOffset.left, "px;width:", this.plotWidth, "px;text-align:", s.x.options.titleAlign, ';" class="flotr-axis-title flotr-axis-title-x1">', s.x.options.title, "</div>"), 
                s.x2.options.title && s.x2.used && e.push('<div style="position:absolute;top:0;left:', this.plotOffset.left, "px;width:", this.plotWidth, "px;text-align:", s.x2.options.titleAlign, ';" class="flotr-axis-title flotr-axis-title-x2">', s.x2.options.title, "</div>"), 
                s.y.options.title && s.y.used && e.push('<div style="position:absolute;top:', this.plotOffset.top + this.plotHeight / 2 - s.y.titleSize.height / 2, "px;left:0;text-align:", s.y.options.titleAlign, ';" class="flotr-axis-title flotr-axis-title-y1">', s.y.options.title, "</div>"), 
                s.y2.options.title && s.y2.used && e.push('<div style="position:absolute;top:', this.plotOffset.top + this.plotHeight / 2 - s.y.titleSize.height / 2, "px;right:0;text-align:", s.y2.options.titleAlign, ';" class="flotr-axis-title flotr-axis-title-y2">', s.y2.options.title, "</div>"), 
                e = e.join("");
                var r = t.create("div");
                t.setStyles({
                    color: i.grid.color
                }), r.className = "flotr-titles", t.insert(this.el, r), t.insert(r, e);
            }
        }
    });
}();

// lib\jsonh\jsonh.js
var JSONH, jsonh = JSONH = function(t, e) {
    "use strict";
    function i(e) {
        for (var i, n, o = e.length, s = u(o ? e[0] : {}), a = s.length, r = t(o * a), l = 0, h = 0; o > l; ++l) for (n = e[l], 
        i = 0; a > i; r[h++] = n[s[i++]]) ;
        return d.call([ a ], s, r);
    }
    function n(e) {
        for (var i, n, o = e.length, s = e[0], a = t((o - s - 1) / s || 0), r = 1 + s, l = 0; o > r; ) for (a[l++] = n = {}, 
        i = 0; s > i; n[e[++i]] = e[r++]) ;
        return a;
    }
    function o(t) {
        return function(e) {
            for (var i, n, o, s = this, a = e, r = 0, l = s.length; l > r; ++r) p(o = a[n = s[r]]) && (i = r + 1, 
            a[n] = l > i ? g.call(o, t, s.slice(i)) : t(o)), a = a[n];
            return e;
        };
    }
    function s(t) {
        return function(e, i) {
            for (var n = p(e), o = d.call(c, e), s = d.call(c, i), a = 0, r = s.length; r > a; ++a) o = g.call(o, t, s[a].split("."));
            return n ? o : o[0];
        };
    }
    function a(t, e) {
        return e ? f(t, e) : i(t);
    }
    function r(t, e) {
        return e ? m(t, e) : n(t);
    }
    function l(t, e, i, n) {
        return y(a(t, n), e, i);
    }
    function h(t, e, i) {
        return r(v(t, e), i);
    }
    var c = [], d = c.concat, u = Object.keys || function(t) {
        var e, i = [];
        for (e in t) t.hasOwnProperty(e) && i.push(e);
        return i;
    }, p = t.isArray || function(t, e) {
        return e = t.call(c), function(i) {
            return t.call(i) == e;
        };
    }({}.toString), g = c.map || function(e, i) {
        for (var n = this, o = n.length, s = t(o); o--; s[o] = e.call(i, n[o], o, n)) ;
        return s;
    }, f = s(o(i)), m = s(o(n)), y = e.stringify, v = e.parse;
    return {
        pack: a,
        parse: h,
        stringify: l,
        unpack: r
    };
}(Array, JSON), LZString = {
    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    _f: String.fromCharCode,
    compressToBase64: function(t) {
        if (null == t) return "";
        var e, i, n, o, s, a, r, l = "", h = 0;
        for (t = LZString.compress(t); 2 * t.length > h; ) 0 == h % 2 ? (e = t.charCodeAt(h / 2) >> 8, 
        i = 255 & t.charCodeAt(h / 2), n = t.length > h / 2 + 1 ? t.charCodeAt(h / 2 + 1) >> 8 : 0/0) : (e = 255 & t.charCodeAt((h - 1) / 2), 
        t.length > (h + 1) / 2 ? (i = t.charCodeAt((h + 1) / 2) >> 8, n = 255 & t.charCodeAt((h + 1) / 2)) : i = n = 0/0), 
        h += 3, o = e >> 2, s = (3 & e) << 4 | i >> 4, a = (15 & i) << 2 | n >> 6, r = 63 & n, 
        isNaN(i) ? a = r = 64 : isNaN(n) && (r = 64), l = l + LZString._keyStr.charAt(o) + LZString._keyStr.charAt(s) + LZString._keyStr.charAt(a) + LZString._keyStr.charAt(r);
        return l;
    },
    decompressFromBase64: function(t) {
        if (null == t) return "";
        var e, i, n, o, s, a, r, l, h = "", c = 0, d = 0, u = LZString._f;
        for (t = t.replace(/[^A-Za-z0-9\+\/\=]/g, ""); t.length > d; ) s = LZString._keyStr.indexOf(t.charAt(d++)), 
        a = LZString._keyStr.indexOf(t.charAt(d++)), r = LZString._keyStr.indexOf(t.charAt(d++)), 
        l = LZString._keyStr.indexOf(t.charAt(d++)), i = s << 2 | a >> 4, n = (15 & a) << 4 | r >> 2, 
        o = (3 & r) << 6 | l, 0 == c % 2 ? (e = i << 8, 64 != r && (h += u(e | n)), 64 != l && (e = o << 8)) : (h += u(e | i), 
        64 != r && (e = n << 8), 64 != l && (h += u(e | o))), c += 3;
        return LZString.decompress(h);
    },
    compressToUTF16: function(t) {
        if (null == t) return "";
        var e, i, n, o = "", s = 0, a = LZString._f;
        for (t = LZString.compress(t), e = 0; t.length > e; e++) switch (i = t.charCodeAt(e), 
        s++) {
          case 0:
            o += a((i >> 1) + 32), n = (1 & i) << 14;
            break;

          case 1:
            o += a(n + (i >> 2) + 32), n = (3 & i) << 13;
            break;

          case 2:
            o += a(n + (i >> 3) + 32), n = (7 & i) << 12;
            break;

          case 3:
            o += a(n + (i >> 4) + 32), n = (15 & i) << 11;
            break;

          case 4:
            o += a(n + (i >> 5) + 32), n = (31 & i) << 10;
            break;

          case 5:
            o += a(n + (i >> 6) + 32), n = (63 & i) << 9;
            break;

          case 6:
            o += a(n + (i >> 7) + 32), n = (127 & i) << 8;
            break;

          case 7:
            o += a(n + (i >> 8) + 32), n = (255 & i) << 7;
            break;

          case 8:
            o += a(n + (i >> 9) + 32), n = (511 & i) << 6;
            break;

          case 9:
            o += a(n + (i >> 10) + 32), n = (1023 & i) << 5;
            break;

          case 10:
            o += a(n + (i >> 11) + 32), n = (2047 & i) << 4;
            break;

          case 11:
            o += a(n + (i >> 12) + 32), n = (4095 & i) << 3;
            break;

          case 12:
            o += a(n + (i >> 13) + 32), n = (8191 & i) << 2;
            break;

          case 13:
            o += a(n + (i >> 14) + 32), n = (16383 & i) << 1;
            break;

          case 14:
            o += a(n + (i >> 15) + 32, (32767 & i) + 32), s = 0;
        }
        return o + a(n + 32);
    },
    decompressFromUTF16: function(t) {
        if (null == t) return "";
        for (var e, i, n = "", o = 0, s = 0, a = LZString._f; t.length > s; ) {
            switch (i = t.charCodeAt(s) - 32, o++) {
              case 0:
                e = i << 1;
                break;

              case 1:
                n += a(e | i >> 14), e = (16383 & i) << 2;
                break;

              case 2:
                n += a(e | i >> 13), e = (8191 & i) << 3;
                break;

              case 3:
                n += a(e | i >> 12), e = (4095 & i) << 4;
                break;

              case 4:
                n += a(e | i >> 11), e = (2047 & i) << 5;
                break;

              case 5:
                n += a(e | i >> 10), e = (1023 & i) << 6;
                break;

              case 6:
                n += a(e | i >> 9), e = (511 & i) << 7;
                break;

              case 7:
                n += a(e | i >> 8), e = (255 & i) << 8;
                break;

              case 8:
                n += a(e | i >> 7), e = (127 & i) << 9;
                break;

              case 9:
                n += a(e | i >> 6), e = (63 & i) << 10;
                break;

              case 10:
                n += a(e | i >> 5), e = (31 & i) << 11;
                break;

              case 11:
                n += a(e | i >> 4), e = (15 & i) << 12;
                break;

              case 12:
                n += a(e | i >> 3), e = (7 & i) << 13;
                break;

              case 13:
                n += a(e | i >> 2), e = (3 & i) << 14;
                break;

              case 14:
                n += a(e | i >> 1), e = (1 & i) << 15;
                break;

              case 15:
                n += a(e | i), o = 0;
            }
            s++;
        }
        return LZString.decompress(n);
    },
    compress: function(t) {
        if (null == t) return "";
        var e, i, n, o = {}, s = {}, a = "", r = "", l = "", h = 2, c = 3, d = 2, u = "", p = 0, g = 0, f = LZString._f;
        for (n = 0; t.length > n; n += 1) if (a = t.charAt(n), Object.prototype.hasOwnProperty.call(o, a) || (o[a] = c++, 
        s[a] = !0), r = l + a, Object.prototype.hasOwnProperty.call(o, r)) l = r; else {
            if (Object.prototype.hasOwnProperty.call(s, l)) {
                if (256 > l.charCodeAt(0)) {
                    for (e = 0; d > e; e++) p <<= 1, 15 == g ? (g = 0, u += f(p), p = 0) : g++;
                    for (i = l.charCodeAt(0), e = 0; 8 > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, 
                    u += f(p), p = 0) : g++, i >>= 1;
                } else {
                    for (i = 1, e = 0; d > e; e++) p = p << 1 | i, 15 == g ? (g = 0, u += f(p), p = 0) : g++, 
                    i = 0;
                    for (i = l.charCodeAt(0), e = 0; 16 > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, 
                    u += f(p), p = 0) : g++, i >>= 1;
                }
                h--, 0 == h && (h = Math.pow(2, d), d++), delete s[l];
            } else for (i = o[l], e = 0; d > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, u += f(p), 
            p = 0) : g++, i >>= 1;
            h--, 0 == h && (h = Math.pow(2, d), d++), o[r] = c++, l = a + "";
        }
        if ("" !== l) {
            if (Object.prototype.hasOwnProperty.call(s, l)) {
                if (256 > l.charCodeAt(0)) {
                    for (e = 0; d > e; e++) p <<= 1, 15 == g ? (g = 0, u += f(p), p = 0) : g++;
                    for (i = l.charCodeAt(0), e = 0; 8 > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, 
                    u += f(p), p = 0) : g++, i >>= 1;
                } else {
                    for (i = 1, e = 0; d > e; e++) p = p << 1 | i, 15 == g ? (g = 0, u += f(p), p = 0) : g++, 
                    i = 0;
                    for (i = l.charCodeAt(0), e = 0; 16 > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, 
                    u += f(p), p = 0) : g++, i >>= 1;
                }
                h--, 0 == h && (h = Math.pow(2, d), d++), delete s[l];
            } else for (i = o[l], e = 0; d > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, u += f(p), 
            p = 0) : g++, i >>= 1;
            h--, 0 == h && (h = Math.pow(2, d), d++);
        }
        for (i = 2, e = 0; d > e; e++) p = p << 1 | 1 & i, 15 == g ? (g = 0, u += f(p), 
        p = 0) : g++, i >>= 1;
        for (;;) {
            if (p <<= 1, 15 == g) {
                u += f(p);
                break;
            }
            g++;
        }
        return u;
    },
    decompress: function(t) {
        if (null == t) return "";
        if ("" == t) return null;
        var e, i, n, o, s, a, r, l, h = [], c = 4, d = 4, u = 3, p = "", g = "", f = LZString._f, m = {
            string: t,
            val: t.charCodeAt(0),
            position: 32768,
            index: 1
        };
        for (i = 0; 3 > i; i += 1) h[i] = i;
        for (o = 0, a = Math.pow(2, 2), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
        0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
        o |= (s > 0 ? 1 : 0) * r, r <<= 1;
        switch (e = o) {
          case 0:
            for (o = 0, a = Math.pow(2, 8), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
            0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
            o |= (s > 0 ? 1 : 0) * r, r <<= 1;
            l = f(o);
            break;

          case 1:
            for (o = 0, a = Math.pow(2, 16), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
            0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
            o |= (s > 0 ? 1 : 0) * r, r <<= 1;
            l = f(o);
            break;

          case 2:
            return "";
        }
        for (h[3] = l, n = g = l; ;) {
            if (m.index > m.string.length) return "";
            for (o = 0, a = Math.pow(2, u), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
            0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
            o |= (s > 0 ? 1 : 0) * r, r <<= 1;
            switch (l = o) {
              case 0:
                for (o = 0, a = Math.pow(2, 8), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
                0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
                o |= (s > 0 ? 1 : 0) * r, r <<= 1;
                h[d++] = f(o), l = d - 1, c--;
                break;

              case 1:
                for (o = 0, a = Math.pow(2, 16), r = 1; r != a; ) s = m.val & m.position, m.position >>= 1, 
                0 == m.position && (m.position = 32768, m.val = m.string.charCodeAt(m.index++)), 
                o |= (s > 0 ? 1 : 0) * r, r <<= 1;
                h[d++] = f(o), l = d - 1, c--;
                break;

              case 2:
                return g;
            }
            if (0 == c && (c = Math.pow(2, u), u++), h[l]) p = h[l]; else {
                if (l !== d) return null;
                p = n + n.charAt(0);
            }
            g += p, h[d++] = n + p.charAt(0), c--, n = p, 0 == c && (c = Math.pow(2, u), u++);
        }
    }
};

// lib\sugar\sugar.js
(function() {
    function t(t) {
        return function() {
            return t;
        };
    }
    function e(t) {
        var e = "Array" === t && oi.isArray || function(e, i) {
            return (i || ui.call(e)) === "[object " + t + "]";
        };
        return mi[t] = e;
    }
    function i(t, e) {
        function i(i) {
            return f(i) ? ui.call(i) === "[object " + e + "]" : typeof i === t;
        }
        return mi[e] = i;
    }
    function n(t) {
        t.SugarMethods || (h(t, "SugarMethods", {}), o(t, !1, !0, {
            extend: function(e, i, n) {
                o(t, !1 !== n, i, e);
            },
            sugarRestore: function() {
                return a(this, t, arguments, function(t, e, i) {
                    h(t, e, i.method);
                });
            },
            sugarRevert: function() {
                return a(this, t, arguments, function(t, e, i) {
                    i.existed ? h(t, e, i.original) : delete t[e];
                });
            }
        }));
    }
    function o(t, e, i, o) {
        var s = e ? t.prototype : t;
        n(t), v(o, function(n, o) {
            var a = s[n], l = g(s, n);
            Pi(i) && a && (o = r(a, o, i)), !1 === i && a || h(s, n, o), t.SugarMethods[n] = {
                method: o,
                existed: l,
                original: a,
                instance: e
            };
        });
    }
    function s(t, e, i, n, s) {
        var a = {};
        n = wi(n) ? n.split(",") : n, n.forEach(function(t, e) {
            s(a, t, e);
        }), o(t, e, i, a);
    }
    function a(t, e, i, n) {
        var o = 0 === i.length, s = l(i), a = !1;
        return v(e.SugarMethods, function(e, i) {
            (o || -1 !== s.indexOf(e)) && (a = !0, n(i.instance ? t.prototype : t, e, i));
        }), a;
    }
    function r(t, e, i) {
        return function() {
            return i.apply(this, arguments) ? e.apply(this, arguments) : t.apply(this, arguments);
        };
    }
    function h(t, e, i) {
        pi ? ni.defineProperty(t, e, {
            value: i,
            configurable: !0,
            enumerable: !1,
            writable: !0
        }) : t[e] = i;
    }
    function l(t, e, i) {
        var n = [];
        i = i || 0;
        var o;
        for (o = t.length; o > i; i++) n.push(t[i]), e && e.call(t, t[i], i);
        return n;
    }
    function c(t, e, i) {
        var n = t[i || 0];
        Si(n) && (t = n, i = 0), l(t, e, i);
    }
    function u(t) {
        if (!t || !t.call) throw new TypeError("Callback is not callable");
    }
    function d(t) {
        return void 0 !== t;
    }
    function p(t) {
        return void 0 === t;
    }
    function g(t, e) {
        return !!t && di.call(t, e);
    }
    function f(t) {
        return !!t && ("object" == typeof t || gi && ki(t));
    }
    function m(t) {
        var e = typeof t;
        return null == t || "string" === e || "number" === e || "boolean" === e;
    }
    function y(t, e) {
        e = e || ui.call(t);
        try {
            if (t && t.constructor && !g(t, "constructor") && !g(t.constructor.prototype, "isPrototypeOf")) return !1;
        } catch (i) {
            return !1;
        }
        return !!t && "[object Object]" === e && "hasOwnProperty" in t;
    }
    function v(t, e) {
        for (var i in t) if (g(t, i) && !1 === e.call(t, i, t[i], t)) break;
    }
    function b(t, e) {
        for (var i = 0; t > i; i++) e(i);
    }
    function C(t, e) {
        return v(e, function(i) {
            t[i] = e[i];
        }), t;
    }
    function w(t) {
        if (m(t) && (t = ni(t)), fi && wi(t)) for (var e, i = t, n = 0; e = i.charAt(n); ) i[n++] = e;
        return t;
    }
    function S(t) {
        C(this, w(t));
    }
    function x(t, e, i) {
        var n = Ii(10, Mi(e || 0));
        return i = i || Ai, 0 > e && (n = 1 / n), i(t * n) / n;
    }
    function k() {
        return "	\n\f\r \u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u2028\u2029\u3000\ufeff";
    }
    function P(t, e) {
        var i = "";
        for (t = "" + t; e > 0; ) 1 & e && (i += t), (e >>= 1) && (t += t);
        return i;
    }
    function T(t, e) {
        var i, n;
        return i = t.replace(Ti, function(t) {
            return t = zi[t], t === Hi && (n = !0), t;
        }), n ? parseFloat(i) : parseInt(i, e || 10);
    }
    function M(t, e, i, n) {
        return n = Mi(t).toString(n || 10), n = P("0", e - n.replace(/\.\d+/, "").length) + n, 
        (i || 0 > t) && (n = (0 > t ? "-" : "+") + n), n;
    }
    function I(t) {
        if (t >= 11 && 13 >= t) return "th";
        switch (t % 10) {
          case 1:
            return "st";

          case 2:
            return "nd";

          case 3:
            return "rd";

          default:
            return "th";
        }
    }
    function D(t, e) {
        function i(t, i) {
            (t || e.indexOf(i) > -1) && (n += i);
        }
        var n = "";
        return e = e || "", i(t.multiline, "m"), i(t.ignoreCase, "i"), i(t.global, "g"), 
        i(t.u, "y"), n;
    }
    function $(t) {
        return wi(t) || (t = ri(t)), t.replace(/([\/\'*+?|()\[\]{}.^$])/g, "\\$1");
    }
    function A(t, e) {
        return t["get" + (t._utc ? "UTC" : "") + e]();
    }
    function F(t, e, i) {
        return t["set" + (t._utc && "ISOWeek" != e ? "UTC" : "") + e](i);
    }
    function R(t, e) {
        var i, n, o, s, a, r, h, l = typeof t;
        if ("string" === l) return t;
        if (o = ui.call(t), i = y(t, o), n = Si(t, o), null != t && i || n) {
            if (e || (e = []), e.length > 1) for (r = e.length; r--; ) if (e[r] === t) return "CYC";
            for (e.push(t), i = t.valueOf() + ri(t.constructor), s = n ? t : ni.keys(t).sort(), 
            r = 0, h = s.length; h > r; r++) a = n ? r : s[r], i += a + R(t[a], e);
            e.pop();
        } else i = -1/0 === 1 / t ? "-0" : ri(t && t.valueOf ? t.valueOf() : t);
        return l + o + i;
    }
    function B(t, e) {
        return t === e ? 0 !== t || 1 / t === 1 / e : _(t) && _(e) ? R(t) === R(e) : !1;
    }
    function _(t) {
        var e = ui.call(t);
        return yi.test(e) || y(t, e);
    }
    function O(t, e, i) {
        var n, o = t.length, s = e.length, a = !1 !== e[s - 1];
        return s > (a ? 1 : 2) ? (n = [], l(e, function(e) {
            return bi(e) ? !1 : (n.push(L(t, o, e, a, i)), void 0);
        }), n) : L(t, o, e[0], a, i);
    }
    function L(t, e, i, n, o) {
        return n && (i %= e, 0 > i && (i = e + i)), o ? t.charAt(i) : t[i];
    }
    function H(t, e) {
        s(e, !0, !1, t, function(t, e) {
            t[e + ("equal" === e ? "s" : "")] = function() {
                return ni[e].apply(null, [ this ].concat(l(arguments)));
            };
        });
    }
    function N(t, e, i, n) {
        var o = t.length, s = -1 == n, a = s ? o - 1 : 0;
        for (i = isNaN(i) ? a : parseInt(i >> 0), 0 > i && (i = o + i), (!s && 0 > i || s && i >= o) && (i = a); s && i >= 0 || !s && o > i; ) {
            if (t[i] === e) return i;
            i += n;
        }
        return -1;
    }
    function z(t, e, i, n) {
        var o = t.length, s = 0, a = d(i);
        if (u(e), 0 == o && !a) throw new TypeError("Reduce called on empty array with no initial value");
        for (a || (i = t[n ? o - 1 : s], s++); o > s; ) a = n ? o - s - 1 : s, a in t && (i = e(i, t[a], a, t)), 
        s++;
        return i;
    }
    function E(t) {
        if (0 === t.length) throw new TypeError("First argument must be defined");
    }
    function V(t) {
        return t = si(t), function(e) {
            return t.test(e);
        };
    }
    function W(t) {
        var e = t.getTime();
        return function(t) {
            return !(!t || !t.getTime) && t.getTime() === e;
        };
    }
    function q(t) {
        return function(e, i, n) {
            return e === t || t.call(this, e, i, n);
        };
    }
    function U(t) {
        return function(e, i, n) {
            return e === t || t.call(n, i, e, n);
        };
    }
    function j(t, e) {
        var i = {};
        return function(n, o, s) {
            var a;
            if (!f(n)) return !1;
            for (a in t) if (i[a] = i[a] || G(t[a], e), !1 === i[a].call(s, n[a], o, s)) return !1;
            return !0;
        };
    }
    function K(t) {
        return function(e) {
            return e === t || B(e, t);
        };
    }
    function G(t, e) {
        if (!m(t)) {
            if (ki(t)) return V(t);
            if (xi(t)) return W(t);
            if (Pi(t)) return e ? U(t) : q(t);
            if (y(t)) return j(t, e);
        }
        return K(t);
    }
    function Y(t, e, i, n) {
        return e ? e.apply ? e.apply(i, n || []) : Pi(t[e]) ? t[e].call(t) : t[e] : t;
    }
    function Z(t, e, i, n) {
        var o = +t.length;
        for (0 > i && (i = t.length + i), i = isNaN(i) ? 0 : i, !0 === n && (o += i); o > i; ) {
            if (n = i % t.length, !(n in t)) {
                X(t, e, i);
                break;
            }
            if (!1 === e.call(t, t[n], n, t)) break;
            i++;
        }
    }
    function X(t, e, i) {
        var n, o = [];
        for (n in t) n in t && n >>> 0 == n && 4294967295 != n && n >= i && o.push(parseInt(n));
        o.sort().each(function(i) {
            return e.call(t, t[i], i, t);
        });
    }
    function J(t, e, i, n, o, s) {
        var a, r, h;
        return t.length > 0 && (h = G(e), Z(t, function(e, i) {
            return h.call(s, e, i, t) ? (a = e, r = i, !1) : void 0;
        }, i, n)), o ? r : a;
    }
    function Q(t, e) {
        var i, n = [], o = {};
        return Z(t, function(s, a) {
            i = e ? Y(s, e, t, [ s, a, t ]) : s, oe(o, i) || n.push(s);
        }), n;
    }
    function te(t, e, i) {
        var n = [], o = {};
        return e.each(function(t) {
            oe(o, t);
        }), t.each(function(t) {
            var e = R(t), s = !_(t);
            if (ne(o, e, t, s) !== i) {
                var a = 0;
                if (s) for (e = o[e]; e.length > a; ) e[a] === t ? e.splice(a, 1) : a += 1; else delete o[e];
                n.push(t);
            }
        }), n;
    }
    function ee(t, e, i) {
        e = e || 1/0, i = i || 0;
        var n = [];
        return Z(t, function(t) {
            Si(t) && e > i ? n = n.concat(ee(t, e, i + 1)) : n.push(t);
        }), n;
    }
    function ie(t) {
        var e = [];
        return l(t, function(t) {
            e = e.concat(t);
        }), e;
    }
    function ne(t, e, i, n) {
        var o = e in t;
        return n && (t[e] || (t[e] = []), o = -1 !== t[e].indexOf(i)), o;
    }
    function oe(t, e) {
        var i = R(e), n = !_(e), o = ne(t, i, e, n);
        return n ? t[i].push(e) : t[i] = e, o;
    }
    function se(t, e, i, n) {
        var o, s, a, r = [], h = "max" === i, l = "min" === i, c = oi.isArray(t);
        for (o in t) if (t.hasOwnProperty(o)) {
            if (i = t[o], a = Y(i, e, t, c ? [ i, parseInt(o), t ] : []), p(a)) throw new TypeError("Cannot compare with undefined");
            a === s ? r.push(i) : (p(s) || h && a > s || l && s > a) && (r = [ i ], s = a);
        }
        return c || (r = ee(r, 1)), n ? r : r[0];
    }
    function ae(t, e) {
        var i, n, o, s, a = 0, r = 0;
        i = oi[qi], n = oi[Ui];
        var h = oi[ji], l = oi[Wi], c = oi[Ki];
        t = re(t, i, n), e = re(e, i, n);
        do i = t.charAt(a), o = h[i] || i, i = e.charAt(a), s = h[i] || i, i = o ? l.indexOf(o) : null, 
        n = s ? l.indexOf(s) : null, -1 === i || -1 === n ? (i = t.charCodeAt(a) || null, 
        n = e.charCodeAt(a) || null, c && (i >= Bi && _i >= i || i >= Oi && Li >= i) && (n >= Bi && _i >= n || n >= Oi && Li >= n) && (i = T(t.slice(a)), 
        n = T(e.slice(a)))) : (o = o !== t.charAt(a), s = s !== e.charAt(a), o !== s && 0 === r && (r = o - s)), 
        a += 1; while (null != i && null != n && i === n);
        return i === n ? r : i - n;
    }
    function re(t, e, i) {
        return wi(t) || (t = ri(t)), i && (t = t.toLowerCase()), e && (t = t.replace(e, "")), 
        t;
    }
    function he(t, e) {
        s(ni, !1, !0, t, function(t, i) {
            t[i] = function(t, n, o) {
                var s, a = ni.keys(w(t));
                return e || (s = G(n, !0)), o = oi.prototype[i].call(a, function(i) {
                    var o = t[i];
                    return e ? Y(o, n, t, [ i, o, t ]) : s(o, i, t);
                }, o), Si(o) && (o = o.reduce(function(e, i) {
                    return e[i] = t[i], e;
                }, {})), o;
            };
        }), H(t, S);
    }
    function le(t) {
        C(this, t), this.g = rn.concat();
    }
    function ce(t, e, i) {
        var n, o, s = e[0], a = e[1], r = e[2];
        return e = t[i] || t.relative, Pi(e) ? e.call(t, s, a, r, i) : (o = t.units[8 * (t.plural && s > 1 ? 1 : 0) + a] || t.units[a], 
        t.capitalizeUnit && (o = ye(o)), n = t.modifiers.filter(function(t) {
            return "sign" == t.name && t.value == (r > 0 ? 1 : -1);
        })[0], e.replace(/\{(.*?)\}/g, function(t, e) {
            switch (e) {
              case "num":
                return s;

              case "unit":
                return o;

              case "sign":
                return n.src;
            }
        }));
    }
    function ue(t, e) {
        return e = e || t.code, "en" === e || "en-US" === e ? !0 : t.variant;
    }
    function de(t, e) {
        return e.replace(si(t.num, "g"), function(e) {
            return pe(t, e) || "";
        });
    }
    function pe(t, e) {
        var i;
        return Ci(e) ? e : e && -1 !== (i = t.numbers.indexOf(e)) ? (i + 1) % 10 : 1;
    }
    function ge(t, e) {
        var i;
        if (wi(t) || (t = ""), i = un[t] || un[t.slice(0, 2)], !1 === e && !i) throw new TypeError("Invalid locale.");
        return i || Qi;
    }
    function fe(t, e) {
        function i(t) {
            var e = r[t];
            wi(e) ? r[t] = e.split(",") : e || (r[t] = []);
        }
        function n(t, e) {
            t = t.split("+").map(function(t) {
                return t.replace(/(.+):(.+)$/, function(t, e, i) {
                    return i.split("|").map(function(t) {
                        return e + t;
                    }).join("|");
                });
            }).join("|"), t.split("|").forEach(e);
        }
        function o(t, e, i) {
            var o = [];
            r[t].forEach(function(t, s) {
                e && (t += "+" + t.slice(0, 3)), n(t, function(t, e) {
                    o[e * i + s] = t.toLowerCase();
                });
            }), r[t] = o;
        }
        function s(t, e, i) {
            return t = "\\d{" + t + "," + e + "}", i && (t += "|(?:" + ve(r.numbers) + ")+"), 
            t;
        }
        function a(t, e) {
            r[t] = r[t] || e;
        }
        var r, h;
        return r = new le(e), i("modifiers"), "months weekdays units numbers articles tokens timeMarker ampm timeSuffixes dateParse timeParse".split(" ").forEach(i), 
        h = !r.monthSuffix, o("months", h, 12), o("weekdays", h, 7), o("units", !1, 8), 
        o("numbers", !1, 10), a("code", t), a("date", s(1, 2, r.digitDate)), a("year", "'\\d{2}|" + s(4, 4)), 
        a("num", function() {
            var t = [ "-?\\d+" ].concat(r.articles);
            return r.numbers && (t = t.concat(r.numbers)), ve(t);
        }()), function() {
            var t = [];
            r.i = {}, r.modifiers.push({
                name: "day",
                src: "yesterday",
                value: -1
            }), r.modifiers.push({
                name: "day",
                src: "today",
                value: 0
            }), r.modifiers.push({
                name: "day",
                src: "tomorrow",
                value: 1
            }), r.modifiers.forEach(function(e) {
                var i = e.name;
                n(e.src, function(n) {
                    var o = r[i];
                    r.i[n] = e, t.push({
                        name: i,
                        src: n,
                        value: e.value
                    }), r[i] = o ? o + "|" + n : n;
                });
            }), r.day += "|" + ve(r.weekdays), r.modifiers = t;
        }(), r.monthSuffix && (r.month = s(1, 2), r.months = "1 2 3 4 5 6 7 8 9 10 11 12".split(" ").map(function(t) {
            return t + r.monthSuffix;
        })), r.full_month = s(1, 2) + "|" + ve(r.months), r.timeSuffixes.length > 0 && r.addFormat(Le(r), !1, on), 
        r.addFormat("{day}", !0), r.addFormat("{month}" + (r.monthSuffix || "")), r.addFormat("{year}" + (r.yearSuffix || "")), 
        r.timeParse.forEach(function(t) {
            r.addFormat(t, !0);
        }), r.dateParse.forEach(function(t) {
            r.addFormat(t);
        }), un[t] = r;
    }
    function me(t, e, i, n) {
        t.g.unshift({
            r: n,
            locale: t,
            q: si("^" + e + "$", "i"),
            to: i
        });
    }
    function ye(t) {
        return t.slice(0, 1).toUpperCase() + t.slice(1);
    }
    function ve(t) {
        return t.filter(function(t) {
            return !!t;
        }).join("|");
    }
    function be() {
        var t = ai.SugarNewDate;
        return t ? t() : new ai();
    }
    function Ce(t, e) {
        var i;
        return f(t[0]) ? t : Ci(t[0]) && !Ci(t[1]) ? [ t[0] ] : wi(t[0]) && e ? [ we(t[0]), t[1] ] : (i = {}, 
        en.forEach(function(e, n) {
            i[e.name] = t[n];
        }), [ i ]);
    }
    function we(t) {
        var e, i = {};
        return (t = t.match(/^(\d+)?\s?(\w+?)s?$/i)) && (p(e) && (e = parseInt(t[1]) || 1), 
        i[t[2].toLowerCase()] = e), i;
    }
    function Se(t, e, i) {
        var n;
        for (p(i) && (i = nn.length), e = e || 0; i > e && (n = nn[e], !1 !== t(n.name, n, e)); e++) ;
    }
    function xe(t, e) {
        var i, n, o = {};
        return e.forEach(function(e, s) {
            i = t[s + 1], p(i) || "" === i || ("year" === e && (o.t = i.replace(/'/, "")), n = parseFloat(i.replace(/'/, "").replace(/,/, ".")), 
            o[e] = isNaN(n) ? i.toLowerCase() : n);
        }), o;
    }
    function ke(t) {
        return t = t.trim().replace(/^just (?=now)|\.+$/i, ""), Pe(t);
    }
    function Pe(t) {
        return t.replace(tn, function(t, e, i) {
            var n, o, s = 0, a = 1;
            return e ? t : (i.split("").reverse().forEach(function(t) {
                t = an[t];
                var e = t > 9;
                e ? (n && (s += a), a *= t / (o || 1), o = t) : (!1 === n && (a *= 10), s += a * t), 
                n = e;
            }), n && (s += a), s);
        });
    }
    function Te(t, e, i, n) {
        function o(t) {
            p.push(t);
        }
        function s() {
            p.forEach(function(t) {
                t.call();
            });
        }
        function a() {
            var t = l.getWeekday();
            l.setWeekday(7 * (m.num - 1) + (t > C ? C + 7 : C));
        }
        function r() {
            var t = g.i[m.edge];
            Se(function(t) {
                return d(m[t]) ? (y = t, !1) : void 0;
            }, 4), "year" === y ? m.e = "month" : ("month" === y || "week" === y) && (m.e = "day"), 
            l[(0 > t.value ? "endOf" : "beginningOf") + ye(y)](), -2 === t.value && l.reset();
        }
        function h() {
            var t;
            Se(function(e, i, n) {
                if ("day" === e && (e = "date"), d(m[e])) {
                    if (n >= b) return l.setTime(0/0), !1;
                    t = t || {}, t[e] = m[e], delete m[e];
                }
            }), t && o(function() {
                l.set(t, !0);
            });
        }
        var l, c, u, p, g, m, y, b, C, w, S;
        return l = be(), p = [], l.utc(n), xi(t) ? l.utc(t.isUTC()).setTime(t.getTime()) : Ci(t) ? l.setTime(t) : f(t) ? (l.set(t, !0), 
        m = t) : wi(t) && (u = ge(e), t = ke(t), u && v(u.o ? [ u.o ].concat(u.g) : u.g, function(i, n) {
            var s = t.match(n.q);
            return s ? (g = n.locale, m = xe(s, n.to), g.o = n, m.utc && l.utc(), m.timestamp ? (m = m.timestamp, 
            !1) : (n.r && !wi(m.month) && (wi(m.date) || ue(u, e)) && (S = m.month, m.month = m.date, 
            m.date = S), m.year && 2 === m.t.length && (m.year = 100 * Ai(A(be(), "FullYear") / 100) - 100 * Ai(m.year / 100) + m.year), 
            m.month && (m.month = g.getMonth(m.month), m.shift && !m.unit && (m.unit = g.units[7])), 
            m.weekday && m.date ? delete m.weekday : m.weekday && (m.weekday = g.getWeekday(m.weekday), 
            m.shift && !m.unit && (m.unit = g.units[5])), m.day && (S = g.i[m.day]) ? (m.day = S.value, 
            l.reset(), c = !0) : m.day && (C = g.getWeekday(m.day)) > -1 && (delete m.day, m.num && m.month ? (o(a), 
            m.day = 1) : m.weekday = C), m.date && !Ci(m.date) && (m.date = de(g, m.date)), 
            m.ampm && m.ampm === g.ampm[1] && 12 > m.hour ? m.hour += 12 : m.ampm === g.ampm[0] && 12 === m.hour && (m.hour = 0), 
            ("offset_hours" in m || "offset_minutes" in m) && (l.utc(), m.offset_minutes = m.offset_minutes || 0, 
            m.offset_minutes += 60 * m.offset_hours, "-" === m.offset_sign && (m.offset_minutes *= -1), 
            m.minute -= m.offset_minutes), m.unit && (c = !0, w = pe(g, m.num), b = g.units.indexOf(m.unit) % 8, 
            y = Ji.units[b], h(), m.shift && (w *= (S = g.i[m.shift]) ? S.value : 0), m.sign && (S = g.i[m.sign]) && (w *= S.value), 
            d(m.weekday) && (l.set({
                weekday: m.weekday
            }, !0), delete m.weekday), m[y] = (m[y] || 0) + w), m.edge && o(r), "-" === m.year_sign && (m.year *= -1), 
            Se(function(t, e, i) {
                e = m[t];
                var n = e % 1;
                n && (m[nn[i - 1].name] = Ai(n * ("second" === t ? 1e3 : 60)), m[t] = $i(e));
            }, 1, 4), !1)) : void 0;
        }), m ? c ? l.advance(m) : (l._utc && l.reset(), Oe(l, m, !0, !1, i)) : ("now" !== t && (l = new ai(t)), 
        n && l.addMinutes(-l.getTimezoneOffset())), s(), l.utc(!1)), {
            c: l,
            set: m
        };
    }
    function Me(t) {
        var e, i = Mi(t), n = i, o = 0;
        return Se(function(t, s, a) {
            e = $i(x(i / s.b(), 1)), e >= 1 && (n = e, o = a);
        }, 1), [ n, o, t ];
    }
    function Ie(t) {
        var e = Me(t.millisecondsFromNow());
        return (6 === e[1] || 5 === e[1] && 4 === e[0] && t.daysFromNow() >= be().daysInMonth()) && (e[0] = Mi(t.monthsFromNow()), 
        e[1] = 6), e;
    }
    function De(t, e, i) {
        function n(t, i) {
            var n = A(t, "Month");
            return ge(i).months[n + 12 * e];
        }
        $e(t, n, i), $e(ye(t), n, i, 1);
    }
    function $e(t, e, i, n) {
        ln[t] = function(t, o) {
            var s = e(t, o);
            return i && (s = s.slice(0, i)), n && (s = s.slice(0, n).toUpperCase() + s.slice(n)), 
            s;
        };
    }
    function Ae(t, e, i) {
        ln[t] = e, ln[t + t] = function(t, i) {
            return M(e(t, i), 2);
        }, i && (ln[t + t + t] = function(t, i) {
            return M(e(t, i), 3);
        }, ln[t + t + t + t] = function(t, i) {
            return M(e(t, i), 4);
        });
    }
    function Fe(t) {
        var e = t.match(/(\{\w+\})|[^{}]+/g);
        hn[t] = e.map(function(t) {
            return t.replace(/\{(\w+)\}/, function(e, i) {
                return t = ln[i] || i, i;
            }), t;
        });
    }
    function Re(t, e, i, n) {
        var o;
        if (!t.isValid()) return "Invalid Date";
        if (Date[e] ? e = Date[e] : Pi(e) && (o = Ie(t), e = e.apply(t, o.concat(ge(n)))), 
        !e && i) return o = o || Ie(t), 0 === o[1] && (o[1] = 1, o[0] = 1), t = ge(n), ce(t, o, o[2] > 0 ? "future" : "past");
        e = e || "long", ("short" === e || "long" === e || "full" === e) && (e = ge(n)[e]), 
        hn[e] || Fe(e);
        var s, a;
        for (o = "", e = hn[e], s = 0, i = e.length; i > s; s++) a = e[s], o += Pi(a) ? a(t, n) : a;
        return o;
    }
    function Be(t, e, i, n, o) {
        var s, a, r, h = 0, l = 0, c = 0;
        return s = Te(e, i, null, o), n > 0 && (l = c = n, a = !0), s.c.isValid() ? (s.set && s.set.e && (cn.forEach(function(e) {
            e.name === s.set.e && (h = e.b(s.c, t - s.c) - 1);
        }), e = ye(s.set.e), (s.set.edge || s.set.shift) && s.c["beginningOf" + e](), "month" === s.set.e && (r = s.c.clone()["endOf" + e]().getTime()), 
        !a && s.set.sign && "millisecond" != s.set.e && (l = 50, c = -50)), a = t.getTime(), 
        e = s.c.getTime(), r = _e(t, e, r || e + h), a >= e - l && r + c >= a) : !1;
    }
    function _e(t, e, i) {
        return e = new ai(e), t = new ai(i).utc(t.isUTC()), 23 !== A(t, "Hours") && (e = e.getTimezoneOffset(), 
        t = t.getTimezoneOffset(), e !== t && (i += (t - e).minutes())), i;
    }
    function Oe(t, e, i, n, o) {
        function s(t) {
            return d(e[t]) ? e[t] : e[t + "s"];
        }
        function a(t) {
            return d(s(t));
        }
        var r;
        if (Ci(e) && n) e = {
            milliseconds: e
        }; else if (Ci(e)) return t.setTime(e), t;
        d(e.date) && (e.day = e.date), Se(function(n, o, s) {
            var h = "day" === n;
            return a(n) || h && a("weekday") ? (e.e = n, r = +s, !1) : (!i || "week" === n || h && a("week") || F(t, o.method, h ? 1 : 0), 
            void 0);
        }), cn.forEach(function(i) {
            var o = i.name;
            i = i.method;
            var r;
            r = s(o), p(r) || (n ? ("week" === o && (r = (e.day || 0) + 7 * r, i = "Date"), 
            r = r * n + A(t, i)) : "month" === o && a("day") && F(t, "Date", 15), F(t, i, r), 
            n && "month" === o && (o = r, 0 > o && (o = o % 12 + 12), o % 12 != A(t, "Month") && F(t, "Date", 0)));
        }), n || a("day") || !a("weekday") || t.setWeekday(s("weekday"));
        var h;
        t: {
            switch (o) {
              case -1:
                h = t > be();
                break t;

              case 1:
                h = be() > t;
                break t;
            }
            h = void 0;
        }
        return h && Se(function(e, i) {
            return !(i.k || "week" === e && a("weekday")) || a(e) || "day" === e && a("weekday") ? void 0 : (t[i.j](o), 
            !1);
        }, r + 1), t;
    }
    function Le(t, e) {
        var i, n = sn, o = {
            h: 0,
            m: 1,
            s: 2
        };
        return t = t || Ji, n.replace(/{([a-z])}/g, function(n, s) {
            var a = [], r = "h" === s, h = r && !e;
            return "t" === s ? t.ampm.join("|") : (r && a.push(":"), (i = t.timeSuffixes[o[s]]) && a.push(i + "\\s*"), 
            0 === a.length ? "" : "(?:" + a.join("|") + ")" + (h ? "" : "?"));
        });
    }
    function He(t, e, i) {
        var n, o;
        return Ci(t[1]) ? n = Ce(t)[0] : (n = t[0], o = t[1]), Te(n, o, e, i).c;
    }
    function Ne(t, e) {
        function i() {
            return Ai(this * e);
        }
        function n() {
            return He(arguments)[t.j](this);
        }
        function o() {
            return He(arguments)[t.j](-this);
        }
        var s = t.name, a = {};
        a[s] = i, a[s + "s"] = i, a[s + "Before"] = o, a[s + "sBefore"] = o, a[s + "Ago"] = o, 
        a[s + "sAgo"] = o, a[s + "After"] = n, a[s + "sAfter"] = n, a[s + "FromNow"] = n, 
        a[s + "sFromNow"] = n, hi.extend(a);
    }
    function ze(t, e) {
        this.start = Ee(t), this.end = Ee(e);
    }
    function Ee(t) {
        return xi(t) ? new ai(t.getTime()) : null == t ? t : xi(t) ? t.getTime() : t.valueOf();
    }
    function Ve(t) {
        return t = null == t ? t : xi(t) ? t.getTime() : t.valueOf(), !!t || 0 === t;
    }
    function We(t, e) {
        var i, n, o, s;
        return Ci(e) ? new ai(t.getTime() + e) : (i = e[0], n = e[1], o = A(t, n), s = new ai(t.getTime()), 
        F(s, n, o + i), s);
    }
    function qe(t, e) {
        return ri.fromCharCode(t.charCodeAt(0) + e);
    }
    function Ue(t, e) {
        return t + e;
    }
    function je(t, e, i, n, o) {
        1/0 !== e && (t.timers || (t.timers = []), Ci(e) || (e = 1), t.n = !1, t.timers.push(setTimeout(function() {
            t.n || i.apply(n, o || []);
        }, e)));
    }
    function Ke(t, e, i, n, o, s) {
        var a = t.toFixed(20), r = a.search(/\./), a = a.search(/[1-9]/), r = r - a;
        return r > 0 && (r -= 1), o = Ri(Fi($i(r / 3), !1 === o ? i.length : o), -n), n = i.charAt(o + n - 1), 
        -9 > r && (o = -3, e = Mi(r) - 9, n = i.slice(0, 1)), i = s ? Ii(2, 10 * o) : Ii(10, 3 * o), 
        x(t / i, e || 0).format() + n.trim();
    }
    function Ge(t, e, i, n) {
        var o, s, a;
        (s = e.match(/^(.+?)(\[.*\])$/)) ? (a = s[1], e = s[2].replace(/^\[|\]$/g, "").split("]["), 
        e.forEach(function(e) {
            o = !e || e.match(/^\d+$/), !a && Si(t) && (a = t.length), g(t, a) || (t[a] = o ? [] : {}), 
            t = t[a], a = e;
        }), !a && o && (a = "" + t.length), Ge(t, a, i, n)) : t[e] = n && "true" === i ? !0 : n && "false" === i ? !1 : i;
    }
    function Ye(t, e) {
        var i;
        return Si(e) || f(e) && e.toString === ui ? (i = [], v(e, function(e, n) {
            t && (e = t + "[" + e + "]"), i.push(Ye(e, n));
        }), i.join("&")) : t ? Ze(t) + "=" + (xi(e) ? e.getTime() : Ze(e)) : "";
    }
    function Ze(t) {
        return t || !1 === t || 0 === t ? encodeURIComponent(t).replace(/%20/g, "+") : "";
    }
    function Xe(t, e, i) {
        var n, o = t instanceof S ? new S() : {};
        return v(t, function(t, s) {
            n = !1, c(e, function(e) {
                (ki(e) ? e.test(t) : f(e) ? e[t] === s : t === ri(e)) && (n = !0);
            }, 1), n === i && (o[t] = s);
        }), o;
    }
    function Je(t) {
        if (t = +t, 0 > t || 1/0 === t) throw new RangeError("Invalid number");
        return t;
    }
    function Qe(t, e) {
        return P(d(e) ? e : " ", t);
    }
    function ti(t, e, i, n, o) {
        var s;
        if (e >= t.length) return "" + t;
        switch (n = p(n) ? "..." : n, i) {
          case "left":
            return t = o ? ei(t, e, !0) : t.slice(t.length - e), n + t;

          case "middle":
            return i = Di(e / 2), s = $i(e / 2), e = o ? ei(t, i) : t.slice(0, i), t = o ? ei(t, s, !0) : t.slice(t.length - s), 
            e + n + t;

          default:
            return e = o ? ei(t, e) : t.slice(0, e), e + n;
        }
    }
    function ei(t, e, i) {
        if (i) return ei(t.reverse(), e).reverse();
        i = si("(?=[" + k() + "])");
        var n = 0;
        return t.split(i).filter(function(t) {
            return n += t.length, e >= n;
        }).join("");
    }
    function ii(t, e, i) {
        return wi(e) && (e = t.indexOf(e), -1 === e && (e = i ? t.length : 0)), e;
    }
    var ni = Object, oi = Array, si = RegExp, ai = Date, ri = String, hi = Number, li = Math, ci = "undefined" != typeof global ? global : this, ui = ni.prototype.toString, di = ni.prototype.hasOwnProperty, pi = ni.defineProperty && ni.defineProperties, gi = "function" == typeof si(), fi = !("0" in new ri("a")), mi = {}, yi = /^\[object Date|Array|String|Number|RegExp|Boolean|Arguments\]$/, vi = "Boolean Number String Array Date RegExp Function".split(" "), bi = i("boolean", vi[0]), Ci = i("number", vi[1]), wi = i("string", vi[2]), Si = e(vi[3]), xi = e(vi[4]), ki = e(vi[5]), Pi = e(vi[6]);
    S.prototype.constructor = ni;
    var Ti, Mi = li.abs, Ii = li.pow, Di = li.ceil, $i = li.floor, Ai = li.round, Fi = li.min, Ri = li.max, Bi = 48, _i = 57, Oi = 65296, Li = 65305, Hi = ".", Ni = "", zi = {};
    n(ni), v(vi, function(t, e) {
        n(ci[e]);
    });
    var Ei, Vi;
    for (Vi = 0; 9 >= Vi; Vi++) Ei = ri.fromCharCode(Vi + Oi), Ni += Ei, zi[Ei] = ri.fromCharCode(Vi + Bi);
    zi[","] = "", zi["\uff0e"] = Hi, zi[Hi] = Hi, Ti = si("[" + Ni + "\uff0e," + Hi + "]", "g"), 
    o(ni, !1, !1, {
        keys: function(t) {
            var e = [];
            if (!f(t) && !ki(t) && !Pi(t)) throw new TypeError("Object required");
            return v(t, function(t) {
                e.push(t);
            }), e;
        }
    }), o(oi, !1, !1, {
        isArray: function(t) {
            return Si(t);
        }
    }), o(oi, !0, !1, {
        every: function(t, e) {
            var i = this.length, n = 0;
            for (E(arguments); i > n; ) {
                if (n in this && !t.call(e, this[n], n, this)) return !1;
                n++;
            }
            return !0;
        },
        some: function(t, e) {
            var i = this.length, n = 0;
            for (E(arguments); i > n; ) {
                if (n in this && t.call(e, this[n], n, this)) return !0;
                n++;
            }
            return !1;
        },
        map: function(t, e) {
            e = arguments[1];
            var i = this.length, n = 0, o = Array(i);
            for (E(arguments); i > n; ) n in this && (o[n] = t.call(e, this[n], n, this)), n++;
            return o;
        },
        filter: function(t) {
            var e = arguments[1], i = this.length, n = 0, o = [];
            for (E(arguments); i > n; ) n in this && t.call(e, this[n], n, this) && o.push(this[n]), 
            n++;
            return o;
        },
        indexOf: function(t, e) {
            return wi(this) ? this.indexOf(t, e) : N(this, t, e, 1);
        },
        lastIndexOf: function(t, e) {
            return wi(this) ? this.lastIndexOf(t, e) : N(this, t, e, -1);
        },
        forEach: function(t, e) {
            var i = this.length, n = 0;
            for (u(t); i > n; ) n in this && t.call(e, this[n], n, this), n++;
        },
        reduce: function(t, e) {
            return z(this, t, e);
        },
        reduceRight: function(t, e) {
            return z(this, t, e, !0);
        }
    }), o(Function, !0, !1, {
        bind: function(t) {
            var e, i = this, n = l(arguments, null, 1);
            if (!Pi(this)) throw new TypeError("Function.prototype.bind called on a non-function");
            return e = function() {
                return i.apply(i.prototype && this instanceof i ? this : t, n.concat(l(arguments)));
            }, e.prototype = this.prototype, e;
        }
    }), o(ai, !1, !1, {
        now: function() {
            return new ai().getTime();
        }
    }), function() {
        var t = k().match(/^\s+$/);
        try {
            ri.prototype.trim.call([ 1 ]);
        } catch (e) {
            t = !1;
        }
        o(ri, !0, !t, {
            trim: function() {
                return ("" + this).trimLeft().trimRight();
            },
            trimLeft: function() {
                return this.replace(si("^[" + k() + "]+"), "");
            },
            trimRight: function() {
                return this.replace(si("[" + k() + "]+$"), "");
            }
        });
    }(), function() {
        var t = new ai(ai.UTC(1999, 11, 31)), t = t.toISOString && "1999-12-31T00:00:00.000Z" === t.toISOString();
        s(ai, !0, !t, "toISOString,toJSON", function(t, e) {
            t[e] = function() {
                return M(this.getUTCFullYear(), 4) + "-" + M(this.getUTCMonth() + 1, 2) + "-" + M(this.getUTCDate(), 2) + "T" + M(this.getUTCHours(), 2) + ":" + M(this.getUTCMinutes(), 2) + ":" + M(this.getUTCSeconds(), 2) + "." + M(this.getUTCMilliseconds(), 3) + "Z";
            };
        });
    }();
    var Wi = "AlphanumericSortOrder", qi = "AlphanumericSortIgnore", Ui = "AlphanumericSortIgnoreCase", ji = "AlphanumericSortEquivalents", Ki = "AlphanumericSortNatural";
    o(oi, !1, !0, {
        create: function() {
            var t = [];
            return l(arguments, function(e) {
                (!m(e) && "length" in e && ("[object Arguments]" === ui.call(e) || e.callee) || !m(e) && "length" in e && !wi(e) && !y(e)) && (e = oi.prototype.slice.call(e, 0)), 
                t = t.concat(e);
            }), t;
        }
    }), o(oi, !0, !1, {
        find: function(t, e) {
            return u(t), J(this, t, 0, !1, !1, e);
        },
        findIndex: function(t, e) {
            var i;
            return u(t), i = J(this, t, 0, !1, !0, e), p(i) ? -1 : i;
        }
    }), o(oi, !0, !0, {
        findFrom: function(t, e, i) {
            return J(this, t, e, i);
        },
        findIndexFrom: function(t, e, i) {
            return e = J(this, t, e, i, !0), p(e) ? -1 : e;
        },
        findAll: function(t, e, i) {
            var n, o = [];
            return this.length > 0 && (n = G(t), Z(this, function(t, e, i) {
                n(t, e, i) && o.push(t);
            }, e, i)), o;
        },
        count: function(t) {
            return p(t) ? this.length : this.findAll(t).length;
        },
        removeAt: function(t, e) {
            return p(t) ? this : (p(e) && (e = t), this.splice(t, e - t + 1), this);
        },
        include: function(t, e) {
            return this.clone().add(t, e);
        },
        exclude: function() {
            return oi.prototype.remove.apply(this.clone(), arguments);
        },
        clone: function() {
            return C([], this);
        },
        unique: function(t) {
            return Q(this, t);
        },
        flatten: function(t) {
            return ee(this, t);
        },
        union: function() {
            return Q(this.concat(ie(arguments)));
        },
        intersect: function() {
            return te(this, ie(arguments), !1);
        },
        subtract: function() {
            return te(this, ie(arguments), !0);
        },
        at: function() {
            return O(this, arguments);
        },
        first: function(t) {
            return p(t) ? this[0] : (0 > t && (t = 0), this.slice(0, t));
        },
        last: function(t) {
            return p(t) ? this[this.length - 1] : this.slice(0 > this.length - t ? 0 : this.length - t);
        },
        from: function(t) {
            return this.slice(t);
        },
        to: function(t) {
            return p(t) && (t = this.length), this.slice(0, t);
        },
        min: function(t, e) {
            return se(this, t, "min", e);
        },
        max: function(t, e) {
            return se(this, t, "max", e);
        },
        least: function(t, e) {
            return se(this.groupBy.apply(this, [ t ]), "length", "min", e);
        },
        most: function(t, e) {
            return se(this.groupBy.apply(this, [ t ]), "length", "max", e);
        },
        sum: function(t) {
            return t = t ? this.map(t) : this, t.length > 0 ? t.reduce(function(t, e) {
                return t + e;
            }) : 0;
        },
        average: function(t) {
            return t = t ? this.map(t) : this, t.length > 0 ? t.sum() / t.length : 0;
        },
        inGroups: function(t, e) {
            var i = arguments.length > 1, n = this, o = [], s = Di(this.length / t);
            return b(t, function(t) {
                t *= s;
                var a = n.slice(t, t + s);
                i && s > a.length && b(s - a.length, function() {
                    a = a.add(e);
                }), o.push(a);
            }), o;
        },
        inGroupsOf: function(t, e) {
            var i, n = [], o = this.length, s = this;
            return 0 === o || 0 === t ? s : (p(t) && (t = 1), p(e) && (e = null), b(Di(o / t), function(o) {
                for (i = s.slice(t * o, t * o + t); t > i.length; ) i.push(e);
                n.push(i);
            }), n);
        },
        isEmpty: function() {
            return 0 == this.compact().length;
        },
        sortBy: function(t, e) {
            var i = this.clone();
            return i.sort(function(n, o) {
                var s, a;
                return s = Y(n, t, i, [ n ]), a = Y(o, t, i, [ o ]), (wi(s) && wi(a) ? ae(s, a) : a > s ? -1 : s > a ? 1 : 0) * (e ? -1 : 1);
            }), i;
        },
        randomize: function() {
            for (var t, e, i = this.concat(), n = i.length; n; ) t = 0 | li.random() * n, e = i[--n], 
            i[n] = i[t], i[t] = e;
            return i;
        },
        zip: function() {
            var t = l(arguments);
            return this.map(function(e, i) {
                return [ e ].concat(t.map(function(t) {
                    return i in t ? t[i] : null;
                }));
            });
        },
        sample: function(t) {
            var e = this.randomize();
            return arguments.length > 0 ? e.slice(0, t) : e[0];
        },
        each: function(t, e, i) {
            return Z(this, t, e, i), this;
        },
        add: function(t, e) {
            return (!Ci(hi(e)) || isNaN(e)) && (e = this.length), oi.prototype.splice.apply(this, [ e, 0 ].concat(t)), 
            this;
        },
        remove: function() {
            var t = this;
            return l(arguments, function(e) {
                var i = 0;
                for (e = G(e); t.length > i; ) e(t[i], i, t) ? t.splice(i, 1) : i++;
            }), t;
        },
        compact: function(t) {
            var e = [];
            return Z(this, function(i) {
                Si(i) ? e.push(i.compact()) : t && i ? e.push(i) : t || null == i || i.valueOf() !== i.valueOf() || e.push(i);
            }), e;
        },
        groupBy: function(t, e) {
            var i, n = this, o = {};
            return Z(n, function(e, s) {
                i = Y(e, t, n, [ e, s, n ]), o[i] || (o[i] = []), o[i].push(e);
            }), e && v(o, e), o;
        },
        none: function() {
            return !this.any.apply(this, arguments);
        }
    }), o(oi, !0, !0, {
        all: oi.prototype.every,
        any: oi.prototype.some,
        insert: oi.prototype.add
    }), o(ni, !1, !0, {
        map: function(t, e) {
            var i, n, o = {};
            for (i in t) g(t, i) && (n = t[i], o[i] = Y(n, e, t, [ i, n, t ]));
            return o;
        },
        reduce: function(t) {
            var e = ni.keys(w(t)).map(function(e) {
                return t[e];
            });
            return e.reduce.apply(e, l(arguments, null, 1));
        },
        each: function(t, e) {
            return u(e), v(t, e), t;
        },
        size: function(t) {
            return ni.keys(w(t)).length;
        }
    });
    var Gi = "any all none count find findAll isEmpty".split(" "), Yi = "sum average min max least most".split(" "), Zi = [ "map", "reduce", "size" ], Xi = Gi.concat(Yi).concat(Zi);
    (function() {
        function t() {
            var t = arguments;
            return t.length > 0 && !Pi(t[0]);
        }
        var e = oi.prototype.map;
        s(oi, !0, t, "every,all,some,filter,any,none,find,findIndex", function(t, e) {
            var i = oi.prototype[e];
            t[e] = function(t) {
                var e = G(t);
                return i.call(this, function(t, i) {
                    return e(t, i, this);
                });
            };
        }), o(oi, !0, t, {
            map: function(t) {
                return e.call(this, function(e, i) {
                    return Y(e, t, this, [ e, i, this ]);
                });
            }
        });
    })(), function() {
        oi[Wi] = "A\u00c1\u00c0\u00c2\u00c3\u0104BC\u0106\u010c\u00c7D\u010e\u00d0E\u00c9\u00c8\u011a\u00ca\u00cb\u0118FG\u011eH\u0131I\u00cd\u00cc\u0130\u00ce\u00cfJKL\u0141MN\u0143\u0147\u00d1O\u00d3\u00d2\u00d4PQR\u0158S\u015a\u0160\u015eT\u0164U\u00da\u00d9\u016e\u00db\u00dcVWXY\u00ddZ\u0179\u017b\u017d\u00de\u00c6\u0152\u00d8\u00d5\u00c5\u00c4\u00d6".split("").map(function(t) {
            return t + t.toLowerCase();
        }).join("");
        var t = {};
        Z("A\u00c1\u00c0\u00c2\u00c3\u00c4 C\u00c7 E\u00c9\u00c8\u00ca\u00cb I\u00cd\u00cc\u0130\u00ce\u00cf O\u00d3\u00d2\u00d4\u00d5\u00d6 S\u00df U\u00da\u00d9\u00db\u00dc".split(" "), function(e) {
            var i = e.charAt(0);
            Z(e.slice(1).split(""), function(e) {
                t[e] = i, t[e.toLowerCase()] = i.toLowerCase();
            });
        }), oi[Ki] = !0, oi[Ui] = !0, oi[ji] = t;
    }(), he(Gi), he(Yi, !0), H(Zi, S), oi.AlphanumericSort = ae;
    var Ji, Qi, tn, en, nn, on = "ampm hour minute second ampm utc offset_sign offset_hours offset_minutes ampm".split(" "), sn = "({t})?\\s*(\\d{1,2}(?:[,.]\\d+)?)(?:{h}([0-5]\\d(?:[,.]\\d+)?)?{m}(?::?([0-5]\\d(?:[,.]\\d+)?){s})?\\s*(?:({t})|(Z)|(?:([+-])(\\d{2,2})(?::?(\\d{2,2}))?)?)?|\\s*({t}))", an = {}, rn = [], hn = {}, ln = {
        yyyy: function(t) {
            return A(t, "FullYear");
        },
        yy: function(t) {
            return A(t, "FullYear") % 100;
        },
        ord: function(t) {
            return t = A(t, "Date"), t + I(t);
        },
        tz: function(t) {
            return t.getUTCOffset();
        },
        isotz: function(t) {
            return t.getUTCOffset(!0);
        },
        Z: function(t) {
            return t.getUTCOffset();
        },
        ZZ: function(t) {
            return t.getUTCOffset().replace(/(\d{2})$/, ":$1");
        }
    }, cn = [ {
        name: "year",
        method: "FullYear",
        k: !0,
        b: function(t) {
            return 864e5 * (365 + (t ? t.isLeapYear() ? 1 : 0 : .25));
        }
    }, {
        name: "month",
        error: .919,
        method: "Month",
        k: !0,
        b: function(t, e) {
            var i, n = 30.4375;
            return t && (i = t.daysInMonth(), i.days() >= e && (n = i)), 864e5 * n;
        }
    }, {
        name: "week",
        method: "ISOWeek",
        b: t(6048e5)
    }, {
        name: "day",
        error: .958,
        method: "Date",
        k: !0,
        b: t(864e5)
    }, {
        name: "hour",
        method: "Hours",
        b: t(36e5)
    }, {
        name: "minute",
        method: "Minutes",
        b: t(6e4)
    }, {
        name: "second",
        method: "Seconds",
        b: t(1e3)
    }, {
        name: "millisecond",
        method: "Milliseconds",
        b: t(1)
    } ], un = {};
    le.prototype = {
        getMonth: function(t) {
            return Ci(t) ? t - 1 : this.months.indexOf(t) % 12;
        },
        getWeekday: function(t) {
            return this.weekdays.indexOf(t) % 7;
        },
        addFormat: function(t, e, i, n, o) {
            var s, a = i || [], r = this;
            t = t.replace(/\s+/g, "[,. ]*"), t = t.replace(/\{([^,]+?)\}/g, function(t, e) {
                var n, o, s, h = e.match(/\?$/);
                s = e.match(/^(\d+)\??$/);
                var l = e.match(/(\d)(?:-(\d))?/), c = e.replace(/[^a-z]+$/, "");
                return s ? n = r.tokens[s[1]] : r[c] ? n = r[c] : r[c + "s"] && (n = r[c + "s"], 
                l && (o = [], n.forEach(function(t, e) {
                    var i = e % (r.units ? 8 : n.length);
                    i >= l[1] && (l[2] || l[1]) >= i && o.push(t);
                }), n = o), n = ve(n)), s ? s = "(?:" + n + ")" : (i || a.push(c), s = "(" + n + ")"), 
                h && (s += "?"), s;
            }), e ? (e = Le(r, o), o = [ "t", "[\\s\\u3000]" ].concat(r.timeMarker), s = t.match(/\\d\{\d,\d\}\)+\??$/), 
            me(r, "(?:" + e + ")[,\\s\\u3000]+?" + t, on.concat(a), n), me(r, t + "(?:[,\\s]*(?:" + o.join("|") + (s ? "+" : "*") + ")" + e + ")?", a.concat(on), n)) : me(r, t, a, n);
        }
    }, o(ai, !1, !0, {
        create: function() {
            return He(arguments);
        },
        past: function() {
            return He(arguments, -1);
        },
        future: function() {
            return He(arguments, 1);
        },
        addLocale: function(t, e) {
            return fe(t, e);
        },
        setLocale: function(t) {
            var e = ge(t, !1);
            return Qi = e, t && t != e.code && (e.code = t), e;
        },
        getLocale: function(t) {
            return t ? ge(t, !1) : Qi;
        },
        addFormat: function(t, e, i) {
            me(ge(i), t, e);
        }
    }), o(ai, !0, !0, {
        set: function() {
            var t = Ce(arguments);
            return Oe(this, t[0], t[1]);
        },
        setWeekday: function(t) {
            return p(t) ? void 0 : F(this, "Date", A(this, "Date") + t - A(this, "Day"));
        },
        setISOWeek: function(t) {
            var e = A(this, "Day") || 7;
            return p(t) ? void 0 : (this.set({
                month: 0,
                date: 4
            }), this.set({
                weekday: 1
            }), t > 1 && this.addWeeks(t - 1), 1 !== e && this.advance({
                days: e - 1
            }), this.getTime());
        },
        getISOWeek: function() {
            var t;
            t = this.clone();
            var e = A(t, "Day") || 7;
            return t.addDays(4 - e).reset(), 1 + $i(t.daysSince(t.clone().beginningOfYear()) / 7);
        },
        beginningOfISOWeek: function() {
            var t = this.getDay();
            return 0 === t ? t = -6 : 1 !== t && (t = 1), this.setWeekday(t), this.reset();
        },
        endOfISOWeek: function() {
            return 0 !== this.getDay() && this.setWeekday(7), this.endOfDay();
        },
        getUTCOffset: function(t) {
            var e = this._utc ? 0 : this.getTimezoneOffset(), i = !0 === t ? ":" : "";
            return !e && t ? "Z" : M($i(-e / 60), 2, !0) + i + M(Mi(e % 60), 2);
        },
        utc: function(t) {
            return h(this, "_utc", !0 === t || 0 === arguments.length), this;
        },
        isUTC: function() {
            return !!this._utc || 0 === this.getTimezoneOffset();
        },
        advance: function() {
            var t = Ce(arguments, !0);
            return Oe(this, t[0], t[1], 1);
        },
        rewind: function() {
            var t = Ce(arguments, !0);
            return Oe(this, t[0], t[1], -1);
        },
        isValid: function() {
            return !isNaN(this.getTime());
        },
        isAfter: function(t, e) {
            return this.getTime() > ai.create(t).getTime() - (e || 0);
        },
        isBefore: function(t, e) {
            return this.getTime() < ai.create(t).getTime() + (e || 0);
        },
        isBetween: function(t, e, i) {
            var n = this.getTime();
            t = ai.create(t).getTime();
            var o = ai.create(e).getTime();
            return e = Fi(t, o), t = Ri(t, o), i = i || 0, n > e - i && t + i > n;
        },
        isLeapYear: function() {
            var t = A(this, "FullYear");
            return 0 === t % 4 && 0 !== t % 100 || 0 === t % 400;
        },
        daysInMonth: function() {
            return 32 - A(new ai(A(this, "FullYear"), A(this, "Month"), 32), "Date");
        },
        format: function(t, e) {
            return Re(this, t, !1, e);
        },
        relative: function(t, e) {
            return wi(t) && (e = t, t = null), Re(this, t, !0, e);
        },
        is: function(t, e, i) {
            var n, o;
            if (this.isValid()) {
                if (wi(t)) switch (t = t.trim().toLowerCase(), o = this.clone().utc(i), !0) {
                  case "future" === t:
                    return this.getTime() > be().getTime();

                  case "past" === t:
                    return this.getTime() < be().getTime();

                  case "weekday" === t:
                    return A(o, "Day") > 0 && 6 > A(o, "Day");

                  case "weekend" === t:
                    return 0 === A(o, "Day") || 6 === A(o, "Day");

                  case (n = Ji.weekdays.indexOf(t) % 7) > -1:
                    return A(o, "Day") === n;

                  case (n = Ji.months.indexOf(t) % 12) > -1:
                    return A(o, "Month") === n;
                }
                return Be(this, t, null, e, i);
            }
        },
        reset: function(t) {
            var e, i = {};
            return t = t || "hours", "date" === t && (t = "days"), e = cn.some(function(e) {
                return t === e.name || t === e.name + "s";
            }), i[t] = t.match(/^days?/) ? 1 : 0, e ? this.set(i, !0) : this;
        },
        clone: function() {
            var t = new ai(this.getTime());
            return t.utc(!!this._utc), t;
        }
    }), o(ai, !0, !0, {
        iso: function() {
            return this.toISOString();
        },
        getWeekday: ai.prototype.getDay,
        getUTCWeekday: ai.prototype.getUTCDay
    }), o(hi, !0, !0, {
        duration: function(t) {
            return t = ge(t), ce(t, Me(this), "duration");
        }
    }), Ji = Qi = ai.addLocale("en", {
        plural: !0,
        timeMarker: "at",
        ampm: "am,pm",
        months: "January,February,March,April,May,June,July,August,September,October,November,December",
        weekdays: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday",
        units: "millisecond:|s,second:|s,minute:|s,hour:|s,day:|s,week:|s,month:|s,year:|s",
        numbers: "one,two,three,four,five,six,seven,eight,nine,ten",
        articles: "a,an,the",
        tokens: "the,st|nd|rd|th,of",
        "short": "{Month} {d}, {yyyy}",
        "long": "{Month} {d}, {yyyy} {h}:{mm}{tt}",
        full: "{Weekday} {Month} {d}, {yyyy} {h}:{mm}:{ss}{tt}",
        past: "{num} {unit} {sign}",
        future: "{num} {unit} {sign}",
        duration: "{num} {unit}",
        modifiers: [ {
            name: "sign",
            src: "ago|before",
            value: -1
        }, {
            name: "sign",
            src: "from now|after|from|in|later",
            value: 1
        }, {
            name: "edge",
            src: "last day",
            value: -2
        }, {
            name: "edge",
            src: "end",
            value: -1
        }, {
            name: "edge",
            src: "first day|beginning",
            value: 1
        }, {
            name: "shift",
            src: "last",
            value: -1
        }, {
            name: "shift",
            src: "the|this",
            value: 0
        }, {
            name: "shift",
            src: "next",
            value: 1
        } ],
        dateParse: [ "{month} {year}", "{shift} {unit=5-7}", "{0?} {date}{1}", "{0?} {edge} of {shift?} {unit=4-7?}{month?}{year?}" ],
        timeParse: "{num} {unit} {sign};{sign} {num} {unit};{0} {num}{1} {day} of {month} {year?};{weekday?} {month} {date}{1?} {year?};{date} {month} {year};{date} {month};{shift} {weekday};{shift} week {weekday};{weekday} {2?} {shift} week;{num} {unit=4-5} {sign} {day};{0?} {date}{1} of {month};{0?}{month?} {date?}{1?} of {shift} {unit=6-7}".split(";")
    }), nn = cn.concat().reverse(), en = cn.concat(), en.splice(2, 1), s(ai, !0, !0, cn, function(t, e, i) {
        function n(t) {
            t /= h;
            var i = t % 1, n = e.error || .999;
            return i && Mi(i % 1) > n && (t = Ai(t)), 0 > t ? Di(t) : $i(t);
        }
        var o, s, a = e.name, r = ye(a), h = e.b();
        e.j = "add" + r + "s", o = function(t, e) {
            return n(this.getTime() - ai.create(t, e).getTime());
        }, s = function(t, e) {
            return n(ai.create(t, e).getTime() - this.getTime());
        }, t[a + "sAgo"] = s, t[a + "sUntil"] = s, t[a + "sSince"] = o, t[a + "sFromNow"] = o, 
        t[e.j] = function(t, e) {
            var i = {};
            return i[a] = t, this.advance(i, e);
        }, Ne(e, h), 3 > i && [ "Last", "This", "Next" ].forEach(function(e) {
            t["is" + e + r] = function() {
                return Be(this, e + " " + a, "en");
            };
        }), 4 > i && (t["beginningOf" + r] = function() {
            var t = {};
            switch (a) {
              case "year":
                t.year = A(this, "FullYear");
                break;

              case "month":
                t.month = A(this, "Month");
                break;

              case "day":
                t.day = A(this, "Date");
                break;

              case "week":
                t.weekday = 0;
            }
            return this.set(t, !0);
        }, t["endOf" + r] = function() {
            var t = {
                hours: 23,
                minutes: 59,
                seconds: 59,
                milliseconds: 999
            };
            switch (a) {
              case "year":
                t.month = 11, t.day = 31;
                break;

              case "month":
                t.day = this.daysInMonth();
                break;

              case "week":
                t.weekday = 6;
            }
            return this.set(t, !0);
        });
    }), Ji.addFormat("([+-])?(\\d{4,4})[-.]?{full_month}[-.]?(\\d{1,2})?", !0, [ "year_sign", "year", "month", "date" ], !1, !0), 
    Ji.addFormat("(\\d{1,2})[-.\\/]{full_month}(?:[-.\\/](\\d{2,4}))?", !0, [ "date", "month", "year" ], !0), 
    Ji.addFormat("{full_month}[-.](\\d{4,4})", !1, [ "month", "year" ]), Ji.addFormat("\\/Date\\((\\d+(?:[+-]\\d{4,4})?)\\)\\/", !1, [ "timestamp" ]), 
    Ji.addFormat(Le(Ji), !1, on), rn = Ji.g.slice(0, 7).reverse(), Ji.g = Ji.g.slice(7).concat(rn), 
    Ae("f", function(t) {
        return A(t, "Milliseconds");
    }, !0), Ae("s", function(t) {
        return A(t, "Seconds");
    }), Ae("m", function(t) {
        return A(t, "Minutes");
    }), Ae("h", function(t) {
        return A(t, "Hours") % 12 || 12;
    }), Ae("H", function(t) {
        return A(t, "Hours");
    }), Ae("d", function(t) {
        return A(t, "Date");
    }), Ae("M", function(t) {
        return A(t, "Month") + 1;
    }), function() {
        function t(t, e) {
            var i = A(t, "Hours");
            return ge(e).ampm[$i(i / 12)] || "";
        }
        $e("t", t, 1), $e("tt", t), $e("T", t, 1, 1), $e("TT", t, null, 2);
    }(), function() {
        function t(t, e) {
            var i = A(t, "Day");
            return ge(e).weekdays[i];
        }
        $e("dow", t, 3), $e("Dow", t, 3, 1), $e("weekday", t), $e("Weekday", t, null, 1);
    }(), De("mon", 0, 3), De("month", 0), De("month2", 1), De("month3", 2), ln.ms = ln.f, 
    ln.milliseconds = ln.f, ln.seconds = ln.s, ln.minutes = ln.m, ln.hours = ln.h, ln["24hr"] = ln.H, 
    ln["12hr"] = ln.h, ln.date = ln.d, ln.day = ln.d, ln.year = ln.yyyy, s(ai, !0, !0, "short,long,full", function(t, e) {
        t[e] = function(t) {
            return Re(this, e, !1, t);
        };
    }), "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07".split("").forEach(function(t, e) {
        e > 9 && (e = Ii(10, e - 9)), an[t] = e;
    }), C(an, zi), tn = si("([\u671f\u9031\u5468])?([\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07" + Ni + "]+)(?!\u6628)", "g"), 
    function() {
        var t = Ji.weekdays.slice(0, 7), e = Ji.months.slice(0, 12);
        s(ai, !0, !0, "today yesterday tomorrow weekday weekend future past".split(" ").concat(t).concat(e), function(t, e) {
            t["is" + ye(e)] = function(t) {
                return this.is(e, 0, t);
            };
        });
    }(), ai.utc || (ai.utc = {
        create: function() {
            return He(arguments, 0, !0);
        },
        past: function() {
            return He(arguments, -1, !0);
        },
        future: function() {
            return He(arguments, 1, !0);
        }
    }), o(ai, !1, !0, {
        RFC1123: "{Dow}, {dd} {Mon} {yyyy} {HH}:{mm}:{ss} {tz}",
        RFC1036: "{Weekday}, {dd}-{Mon}-{yy} {HH}:{mm}:{ss} {tz}",
        ISO8601_DATE: "{yyyy}-{MM}-{dd}",
        ISO8601_DATETIME: "{yyyy}-{MM}-{dd}T{HH}:{mm}:{ss}.{fff}{isotz}"
    }), ze.prototype.toString = function() {
        return this.isValid() ? this.start + ".." + this.end : "Invalid Range";
    }, o(ze, !0, !0, {
        isValid: function() {
            return Ve(this.start) && Ve(this.end) && typeof this.start == typeof this.end;
        },
        span: function() {
            return this.isValid() ? Mi((wi(this.end) ? this.end.charCodeAt(0) : this.end) - (wi(this.start) ? this.start.charCodeAt(0) : this.start)) + 1 : 0/0;
        },
        contains: function(t) {
            return null == t ? !1 : t.start && t.end ? t.start >= this.start && t.start <= this.end && t.end >= this.start && t.end <= this.end : t >= this.start && this.end >= t;
        },
        every: function(t, e) {
            var i, n = this.start, o = this.end, s = n > o, a = n, r = 0, h = [];
            for (Pi(t) && (e = t, t = null), t = t || 1, Ci(n) ? i = Ue : wi(n) ? i = qe : xi(n) && (i = t, 
            Ci(i) ? t = i : (n = i.toLowerCase().match(/^(\d+)?\s?(\w+?)s?$/i), i = parseInt(n[1]) || 1, 
            n = n[2].slice(0, 1).toUpperCase() + n[2].slice(1), n.match(/hour|minute|second/i) ? n += "s" : "Year" === n ? n = "FullYear" : "Day" === n && (n = "Date"), 
            t = [ i, n ]), i = We), s && t > 0 && (t *= -1); s ? a >= o : o >= a; ) h.push(a), 
            e && e(a, r), a = i(a, t), r++;
            return h;
        },
        union: function(t) {
            return new ze(this.start < t.start ? this.start : t.start, this.end > t.end ? this.end : t.end);
        },
        intersect: function(t) {
            return t.start > this.end || t.end < this.start ? new ze(0/0, 0/0) : new ze(this.start > t.start ? this.start : t.start, this.end < t.end ? this.end : t.end);
        },
        clone: function() {
            return new ze(this.start, this.end);
        },
        clamp: function(t) {
            var e = this.start, i = this.end, n = e > i ? i : e, e = e > i ? e : i;
            return Ee(n > t ? n : t > e ? e : t);
        }
    }), [ hi, ri, ai ].forEach(function(t) {
        o(t, !1, !0, {
            range: function(e, i) {
                return t.create && (e = t.create(e), i = t.create(i)), new ze(e, i);
            }
        });
    }), o(hi, !0, !0, {
        upto: function(t, e, i) {
            return hi.range(this, t).every(i, e);
        },
        clamp: function(t, e) {
            return new ze(t, e).clamp(this);
        },
        cap: function(t) {
            return this.clamp(void 0, t);
        }
    }), o(hi, !0, !0, {
        downto: hi.prototype.upto
    }), o(oi, !1, function(t) {
        return t instanceof ze;
    }, {
        create: function(t) {
            return t.every();
        }
    }), o(Function, !0, !0, {
        lazy: function(t, e, i) {
            function n() {
                return i - (c && e ? 1 : 0) > l.length && l.push([ this, arguments ]), c || (c = !0, 
                e ? o() : je(n, s, o)), r;
            }
            var o, s, a, r, h = this, l = [], c = !1;
            return t = t || 1, i = i || 1/0, s = Di(t), a = Ai(s / t) || 1, o = function() {
                var t, e = l.length;
                if (0 != e) {
                    for (t = Ri(e - a, 0); e > t; ) r = Function.prototype.apply.apply(h, l.shift()), 
                    e--;
                    je(n, s, function() {
                        c = !1, o();
                    });
                }
            }, n;
        },
        throttle: function(t) {
            return this.lazy(t, !0, 1);
        },
        debounce: function(t) {
            function e() {
                e.cancel(), je(e, t, i, this, arguments);
            }
            var i = this;
            return e;
        },
        delay: function(t) {
            var e = l(arguments, null, 1);
            return je(this, t, this, this, e), this;
        },
        every: function(t) {
            function e() {
                i.apply(i, n), je(i, t, e);
            }
            var i = this, n = arguments, n = n.length > 1 ? l(n, null, 1) : [];
            return je(i, t, e), i;
        },
        cancel: function() {
            var t, e = this.timers;
            if (Si(e)) for (;t = e.shift(); ) clearTimeout(t);
            return this.n = !0, this;
        },
        after: function(t) {
            var e = this, i = 0, n = [];
            if (Ci(t)) {
                if (0 === t) return e.call(), e;
            } else t = 1;
            return function() {
                var o;
                return n.push(l(arguments)), i++, i == t ? (o = e.call(this, n), i = 0, n = [], 
                o) : void 0;
            };
        },
        once: function() {
            return this.throttle(1/0, !0);
        },
        fill: function() {
            var t = this, e = l(arguments);
            return function() {
                var i = l(arguments);
                return e.forEach(function(t, e) {
                    (null != t || e >= i.length) && i.splice(e, 0, t);
                }), t.apply(this, i);
            };
        }
    }), o(hi, !1, !0, {
        random: function(t, e) {
            var i, n;
            return 1 == arguments.length && (e = t, t = 0), i = Fi(t || 0, p(e) ? 1 : e), n = Ri(t || 0, p(e) ? 1 : e) + 1, 
            $i(li.random() * (n - i) + i);
        }
    }), o(hi, !0, !0, {
        log: function(t) {
            return li.log(this) / (t ? li.log(t) : 1);
        },
        abbr: function(t) {
            return Ke(this, t, "kmbt", 0, 4);
        },
        metric: function(t, e) {
            return Ke(this, t, "n\u03bcm kMGTPE", 4, p(e) ? 1 : e);
        },
        bytes: function(t, e) {
            return Ke(this, t, "kMGTPE", 0, p(e) ? 4 : e, !0) + "B";
        },
        isInteger: function() {
            return 0 == this % 1;
        },
        isOdd: function() {
            return !isNaN(this) && !this.isMultipleOf(2);
        },
        isEven: function() {
            return this.isMultipleOf(2);
        },
        isMultipleOf: function(t) {
            return 0 === this % t;
        },
        format: function(t, e, i) {
            var n, o, s, a = "";
            for (p(e) && (e = ","), p(i) && (i = "."), n = (Ci(t) ? x(this, t || 0).toFixed(Ri(t, 0)) : "" + this).replace(/^-/, "").split("."), 
            o = n[0], s = n[1], n = o.length; n > 0; n -= 3) o.length > n && (a = e + a), a = o.slice(Ri(0, n - 3), n) + a;
            return s && (a += i + P("0", (t || 0) - s.length) + s), (0 > this ? "-" : "") + a;
        },
        hex: function(t) {
            return this.pad(t || 1, !1, 16);
        },
        times: function(t) {
            if (t) for (var e = 0; this > e; e++) t.call(this, e);
            return this.toNumber();
        },
        chr: function() {
            return ri.fromCharCode(this);
        },
        pad: function(t, e, i) {
            return M(this, t, e, i);
        },
        ordinalize: function() {
            var t = Mi(this), t = parseInt(("" + t).slice(-2));
            return this + I(t);
        },
        toNumber: function() {
            return parseFloat(this, 10);
        }
    }), function() {
        function t(t) {
            return function(e) {
                return e ? x(this, e, t) : t(this);
            };
        }
        o(hi, !0, !0, {
            ceil: t(Di),
            round: t(Ai),
            floor: t($i)
        }), s(hi, !0, !0, "abs,pow,sin,asin,cos,acos,tan,atan,exp,pow,sqrt", function(t, e) {
            t[e] = function(t, i) {
                return li[e](this, t, i);
            };
        });
    }();
    var dn = [ "isObject", "isNaN" ], pn = "keys values select reject each merge clone equal watch tap has toQueryString".split(" ");
    o(ni, !1, !0, {
        watch: function(t, e, i) {
            if (pi) {
                var n = t[e];
                ni.defineProperty(t, e, {
                    enumerable: !0,
                    configurable: !0,
                    get: function() {
                        return n;
                    },
                    set: function(o) {
                        n = i.call(t, e, n, o);
                    }
                });
            }
        }
    }), o(ni, !1, function() {
        return arguments.length > 1;
    }, {
        keys: function(t, e) {
            var i = ni.keys(t);
            return i.forEach(function(i) {
                e.call(t, i, t[i]);
            }), i;
        }
    }), o(ni, !1, !0, {
        isObject: function(t) {
            return y(t);
        },
        isNaN: function(t) {
            return Ci(t) && t.valueOf() !== t.valueOf();
        },
        equal: function(t, e) {
            return B(t, e);
        },
        extended: function(t) {
            return new S(t);
        },
        merge: function(t, e, i, n) {
            var o, s, a, r, h, l, c;
            if (t && "string" != typeof e) for (o in e) if (g(e, o) && t) {
                if (r = e[o], h = t[o], l = d(h), s = f(r), a = f(h), c = l && !1 === n ? h : r, 
                l && Pi(n) && (c = n.call(e, o, h, r)), i && (s || a)) if (xi(r)) c = new ai(r.getTime()); else {
                    if (!ki(r)) {
                        a || (t[o] = oi.isArray(r) ? [] : {}), ni.merge(t[o], r, i, n);
                        continue;
                    }
                    c = new si(r.source, D(r));
                }
                t[o] = c;
            }
            return t;
        },
        values: function(t, e) {
            var i = [];
            return v(t, function(n, o) {
                i.push(o), e && e.call(t, o);
            }), i;
        },
        clone: function(t, e) {
            var i;
            if (!f(t)) return t;
            if (i = ui.call(t), xi(t, i) && t.clone) return t.clone();
            if (xi(t, i) || ki(t, i)) return new t.constructor(t);
            if (t instanceof S) i = new S(); else if (Si(t, i)) i = []; else {
                if (!y(t, i)) throw new TypeError("Clone must be a basic data type.");
                i = {};
            }
            return ni.merge(i, t, e);
        },
        fromQueryString: function(t, e) {
            var i = ni.extended();
            return t = t && t.toString ? "" + t : "", t.replace(/^.*?\?/, "").split("&").forEach(function(t) {
                t = t.split("="), 2 === t.length && Ge(i, t[0], decodeURIComponent(t[1]), e);
            }), i;
        },
        toQueryString: function(t, e) {
            return Ye(e, t);
        },
        tap: function(t, e) {
            var i = e;
            return Pi(e) || (i = function() {
                e && t[e]();
            }), i.call(t, t), t;
        },
        has: function(t, e) {
            return g(t, e);
        },
        select: function(t) {
            return Xe(t, arguments, !0);
        },
        reject: function(t) {
            return Xe(t, arguments, !1);
        }
    }), s(ni, !1, !0, vi, function(t, e) {
        var i = "is" + e;
        dn.push(i), t[i] = mi[e];
    }), o(ni, !1, function() {
        return 0 === arguments.length;
    }, {
        extend: function() {
            var t = dn.concat(pn);
            Xi !== void 0 && (t = t.concat(Xi)), H(t, ni);
        }
    }), H(pn, S), o(si, !1, !0, {
        escape: function(t) {
            return $(t);
        }
    }), o(si, !0, !0, {
        getFlags: function() {
            return D(this);
        },
        setFlags: function(t) {
            return si(this.source, t);
        },
        addFlag: function(t) {
            return this.setFlags(D(this, t));
        },
        removeFlag: function(t) {
            return this.setFlags(D(this).replace(t, ""));
        }
    });
    var gn, fn;
    o(ri, !0, !1, {
        repeat: function(t) {
            return t = Je(t), P(this, t);
        }
    }), o(ri, !0, function(t) {
        return ki(t) || arguments.length > 2;
    }, {
        startsWith: function(t) {
            var e = arguments, i = e[1], e = e[2], n = this;
            return i && (n = n.slice(i)), p(e) && (e = !0), i = ki(t) ? t.source.replace("^", "") : $(t), 
            si("^" + i, e ? "" : "i").test(n);
        },
        endsWith: function(t) {
            var e = arguments, i = e[1], e = e[2], n = this;
            return d(i) && (n = n.slice(0, i)), p(e) && (e = !0), i = ki(t) ? t.source.replace("$", "") : $(t), 
            si(i + "$", e ? "" : "i").test(n);
        }
    }), o(ri, !0, !0, {
        escapeRegExp: function() {
            return $(this);
        },
        escapeURL: function(t) {
            return t ? encodeURIComponent(this) : encodeURI(this);
        },
        unescapeURL: function(t) {
            return t ? decodeURI(this) : decodeURIComponent(this);
        },
        escapeHTML: function() {
            return this.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;").replace(/\//g, "&#x2f;");
        },
        unescapeHTML: function() {
            return this.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&quot;/g, '"').replace(/&apos;/g, "'").replace(/&#x2f;/g, "/").replace(/&amp;/g, "&");
        },
        encodeBase64: function() {
            return gn(unescape(encodeURIComponent(this)));
        },
        decodeBase64: function() {
            return decodeURIComponent(escape(fn(this)));
        },
        each: function(t, e) {
            var i, n, o;
            if (Pi(t) ? (e = t, t = /[\s\S]/g) : t ? wi(t) ? t = si($(t), "gi") : ki(t) && (t = si(t.source, D(t, "g"))) : t = /[\s\S]/g, 
            i = this.match(t) || [], e) for (n = 0, o = i.length; o > n; n++) i[n] = e.call(this, i[n], n, i) || i[n];
            return i;
        },
        shift: function(t) {
            var e = "";
            return t = t || 0, this.codes(function(i) {
                e += ri.fromCharCode(i + t);
            }), e;
        },
        codes: function(t) {
            var e, i, n = [];
            for (e = 0, i = this.length; i > e; e++) {
                var o = this.charCodeAt(e);
                n.push(o), t && t.call(this, o, e);
            }
            return n;
        },
        chars: function(t) {
            return this.each(t);
        },
        words: function(t) {
            return this.trim().each(/\S+/g, t);
        },
        lines: function(t) {
            return this.trim().each(/^.*$/gm, t);
        },
        paragraphs: function(t) {
            var e = this.trim().split(/[\r\n]{2,}/);
            return e = e.map(function(e) {
                if (t) var i = t.call(e);
                return i ? i : e;
            });
        },
        isBlank: function() {
            return 0 === this.trim().length;
        },
        has: function(t) {
            return -1 !== this.search(ki(t) ? t : $(t));
        },
        add: function(t, e) {
            return e = p(e) ? this.length : e, this.slice(0, e) + t + this.slice(e);
        },
        remove: function(t) {
            return this.replace(t, "");
        },
        reverse: function() {
            return this.split("").reverse().join("");
        },
        compact: function() {
            return this.trim().replace(/([\r\n\s\u3000])+/g, function(t, e) {
                return "\u3000" === e ? e : " ";
            });
        },
        at: function() {
            return O(this, arguments, !0);
        },
        from: function(t) {
            return this.slice(ii(this, t, !0));
        },
        to: function(t) {
            return p(t) && (t = this.length), this.slice(0, ii(this, t));
        },
        dasherize: function() {
            return this.underscore().replace(/_/g, "-");
        },
        underscore: function() {
            return this.replace(/[-\s]+/g, "_").replace(ri.Inflector && ri.Inflector.acronymRegExp, function(t, e) {
                return (e > 0 ? "_" : "") + t.toLowerCase();
            }).replace(/([A-Z\d]+)([A-Z][a-z])/g, "$1_$2").replace(/([a-z\d])([A-Z])/g, "$1_$2").toLowerCase();
        },
        camelize: function(t) {
            return this.underscore().replace(/(^|_)([^_]+)/g, function(e, i, n, o) {
                return e = (e = ri.Inflector) && e.acronyms[n], e = wi(e) ? e : void 0, o = !1 !== t || o > 0, 
                e ? o ? e : e.toLowerCase() : o ? n.capitalize() : n;
            });
        },
        spacify: function() {
            return this.underscore().replace(/_/g, " ");
        },
        stripTags: function() {
            var t = this;
            return c(arguments.length > 0 ? arguments : [ "" ], function(e) {
                t = t.replace(si("</?" + $(e) + "[^<>]*>", "gi"), "");
            }), t;
        },
        removeTags: function() {
            var t = this;
            return c(arguments.length > 0 ? arguments : [ "\\S+" ], function(e) {
                e = si("<(" + e + ")[^<>]*(?:\\/>|>.*?<\\/\\1>)", "gi"), t = t.replace(e, "");
            }), t;
        },
        truncate: function(t, e, i) {
            return ti(this, t, e, i);
        },
        truncateOnWord: function(t, e, i) {
            return ti(this, t, e, i, !0);
        },
        pad: function(t, e) {
            var i, n;
            return t = Je(t), i = Ri(0, t - this.length) / 2, n = $i(i), i = Di(i), Qe(n, e) + this + Qe(i, e);
        },
        padLeft: function(t, e) {
            return t = Je(t), Qe(Ri(0, t - this.length), e) + this;
        },
        padRight: function(t, e) {
            return t = Je(t), this + Qe(Ri(0, t - this.length), e);
        },
        first: function(t) {
            return p(t) && (t = 1), this.substr(0, t);
        },
        last: function(t) {
            return p(t) && (t = 1), this.substr(0 > this.length - t ? 0 : this.length - t);
        },
        toNumber: function(t) {
            return T(this, t);
        },
        capitalize: function(t) {
            var e;
            return this.toLowerCase().replace(t ? RegExp("[^']", "g") : /^\S/, function(t) {
                var i, n = t.toUpperCase();
                return i = e ? t : n, e = n !== t, i;
            });
        },
        assign: function() {
            var t = {};
            return c(arguments, function(e, i) {
                f(e) ? C(t, e) : t[i + 1] = e;
            }), this.replace(/\{([^{]+?)\}/g, function(e, i) {
                return g(t, i) ? t[i] : e;
            });
        }
    }), o(ri, !0, !0, {
        insert: ri.prototype.add
    }), function(t) {
        if (ci.btoa) gn = ci.btoa, fn = ci.atob; else {
            var e = /[^A-Za-z0-9\+\/\=]/g;
            gn = function(e) {
                var i, n, o, s, a, r, h = "", l = 0;
                do i = e.charCodeAt(l++), n = e.charCodeAt(l++), o = e.charCodeAt(l++), s = i >> 2, 
                i = (3 & i) << 4 | n >> 4, a = (15 & n) << 2 | o >> 6, r = 63 & o, isNaN(n) ? a = r = 64 : isNaN(o) && (r = 64), 
                h = h + t.charAt(s) + t.charAt(i) + t.charAt(a) + t.charAt(r); while (e.length > l);
                return h;
            }, fn = function(i) {
                var n, o, s, a, r, h = "", l = 0;
                if (i.match(e)) throw Error("String contains invalid base64 characters");
                i = i.replace(/[^A-Za-z0-9\+\/\=]/g, "");
                do n = t.indexOf(i.charAt(l++)), o = t.indexOf(i.charAt(l++)), a = t.indexOf(i.charAt(l++)), 
                r = t.indexOf(i.charAt(l++)), n = n << 2 | o >> 4, o = (15 & o) << 4 | a >> 2, s = (3 & a) << 6 | r, 
                h += ri.fromCharCode(n), 64 != a && (h += ri.fromCharCode(o)), 64 != r && (h += ri.fromCharCode(s)); while (i.length > l);
                return h;
            };
        }
    }("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
})();

// source\controls\toaster\slideable3d.js
enyo.kind({
    name: "Slideable3d",
    kind: "Slideable",
    published: {
        timingDuration: .3,
        timingFunction: "ease"
    },
    use3d: !0,
    useKeyframes: !1,
    freeze: !1,
    statics: {
        count: 0
    },
    create: function() {
        if ((enyo.platform.blackberry || enyo.platform.androidChrome || enyo.platform.firefoxOS) && (this.useKeyframes = !1), 
        enyo.platform.firefoxOS && (this.use3d = !1), this.inherited(arguments), this.useKeyframes === !0) {
            Slideable3d.count++;
            var t = [];
            t.push({
                keyText: "0%",
                keyValue: "{" + enyo.dom.getCssTransformProp() + ": translate3d(0,0,0);}"
            }), t.push({
                keyText: "100%",
                keyValue: "{" + enyo.dom.getCssTransformProp() + ": translate3d(0,0,0);}"
            }), this.applyStyle(enyo.dom.getCSSPrefix("animation-duration", "AnimationDuration"), this.timingDuration + "s"), 
            this.applyStyle(enyo.dom.getCSSPrefix("animation-timing-function", "AnimationTimingFunction"), this.timingFunction), 
            enyo.dom.createKeyframes("slideable-slide" + Slideable3d.count, t), this.keyFrameRule = "slideable-slide" + Slideable3d.count;
        }
    },
    rendered: function() {
        this.inherited(arguments), this.useKeyframes === !0 && enyo.dispatcher.listen(this.hasNode(), enyo.dom.getAnimationEvent("AnimationEnd"), enyo.bind(this, this.animateEnd));
    },
    lastEvent: {},
    animateEnd: function() {
        this.useKeyframes === !0 && (this.valueChanged(this.value), this.applyStyle(enyo.dom.getCSSPrefix("animation-name", "AnimationName"), "none"), 
        this.bubble("onAnimateFinish"));
    },
    destroy: function() {
        this.useKeyframes === !0 && (Slideable3d.count--, enyo.dom.deleteKeyframes(this.keyFrameRule)), 
        this.inherited(arguments);
    },
    valueChanged: function(t) {
        var e = this.value;
        this.isOob(e) && !this.isAnimating() && (this.value = this.overMoving ? this.dampValue(e) : this.clampValue(e)), 
        enyo.platform.android > 2 && this.use3d === !1 && (this.value ? (0 === t || void 0 === t) && enyo.dom.accelerate(this, this.accelerated) : enyo.dom.accelerate(this, !1)), 
        this.canTransform ? this.use3d ? "translateX" == this.transform ? enyo.dom.transformValue(this, "translate3d", this.value + this.unit + ",0,0") : enyo.dom.transformValue(this, "translate3d", "0," + this.value + this.unit + ",0") : enyo.dom.transformValue(this, this.transform, this.value + this.unit) : this.setInlineStyles(this.value, !1), 
        this.doChange();
    },
    play: function(t, e) {
        if (this.use3d && this.useKeyframes) {
            var i = [];
            i.push({
                keyText: "0%",
                keyValue: "translateX" == this.transform ? "{" + enyo.dom.getCssTransformProp() + ": translate3d(" + t + this.unit + ",0,0);}" : "{" + enyo.dom.getCssTransformProp() + ": translate3d(0," + t + this.unit + ",0);}"
            }), i.push({
                keyText: "100%",
                keyValue: "translateX" == this.transform ? "{" + enyo.dom.getCssTransformProp() + ": translate3d(" + e + this.unit + ",0,0);}" : "{" + enyo.dom.getCssTransformProp() + ": translate3d(0," + e + this.unit + ",0);}"
            }), this.applyStyle(enyo.dom.getCSSPrefix("animation-name", "AnimationName"), enyo.dom.changeKeyframes(this.keyFrameRule, i)), 
            this.value = e, this.valueChanged(e);
        } else this.inherited(arguments);
    },
    dragfinish: function(t, e) {
        if (this.freeze === !0) {
            if (this.dragging) return this.dragging = !1, this.value > this.max && this.animateToMax(), 
            this.value < this.min && this.animateToMin(), e.preventTap(), this.preventDragPropagation;
        } else this.inherited(arguments);
    }
}), enyo.kind({
    name: "FloatingSlideable3d",
    kind: "Slideable3d",
    create: function() {
        enyo.floatingLayer.hasNode() || enyo.floatingLayer.render(), this.parentNode = enyo.floatingLayer.hasNode(), 
        this.inherited(arguments);
    }
});

// source\controls\toaster\toaster.js
enyo.kind({
    name: "ToasterPopup",
    kind: "Slideable3d",
    classes: "toaster",
    published: {
        align: "left",
        top: 0,
        left: 0,
        modal: !0,
        autoDismiss: !0,
        scrim: !1,
        anchor: !0,
        floating: !1,
        centered: !1,
        centeredY: !1,
        centeredX: !1,
        duration: 500
    },
    captureEvents: !0,
    eventsToCapture: {
        ondown: "capturedDown",
        ontap: "capturedTap"
    },
    unit: "%",
    draggable: !1,
    events: {
        onShow: "",
        onHide: ""
    },
    showing: !1,
    handlers: {
        ondown: "down",
        onkeydown: "keydown",
        ondragstart: "dragstart",
        onAnimateFinish: "checkForHide"
    },
    scrimTools: [ {
        kind: "onyx.Scrim",
        classes: "onyx-scrim-translucent",
        isChrome: !0,
        name: "scrim",
        style: "-webkit-transform: translate3d(0,0,0);",
        ontap: "scrimTap",
        addBefore: null
    } ],
    components: [],
    defaultZ: 120,
    create: function() {
        this.canGenerate = !this.floating, this.floating && (enyo.floatingLayer.hasNode() || enyo.floatingLayer.render(), 
        this.parentNode = enyo.floatingLayer.hasNode()), this.inherited(arguments), this.floating || this.scrimChanged(), 
        this.applyAlign(!0), this.$.animator.setDuration(this.duration), this.centeredChanged(), 
        this.addClass("fill-forwards");
    },
    render: function() {
        this.inherited(arguments);
    },
    setPosition: function(t) {
        t && (t.left && this.setLeft(t.left), t.top && this.setTop(t.top));
    },
    calcViewportSize: function() {
        return {
            width: enyo.dom.getWindowWidth(),
            height: enyo.dom.getWindowHeight()
        };
    },
    centeredChanged: function() {
        this.updatePosition(!1);
    },
    centeredXChanged: function() {
        this.updatePosition(!1);
    },
    centeredYChanged: function() {
        this.updatePosition(!1);
    },
    resizeHandler: function() {
        this.inherited(arguments), this.updatePosition(!1);
    },
    updatePosition: function(t) {
        if (this.centered || this.centeredY || this.centeredX) {
            var e = this.calcViewportSize(), i = this.getBounds();
            if (void 0 === i.top || 0 === i.width) return;
            this.centeredX ? this.left = Math.max((e.width - i.width) / 2, 0) : this.centeredY ? this.top = Math.max((e.height - i.height) / 2, 0) : this.centered && (this.top = Math.max((e.height - i.height) / 2, 0), 
            this.left = Math.max((e.width - i.width) / 2, 0));
        }
        this.applyAlign(t);
    },
    _zIndex: 120,
    applyZIndex: function() {
        onyx.Popup.highestZ && onyx.Popup.highestZ >= this._zIndex && (this._zIndex = onyx.Popup.highestZ + 4, 
        onyx.Popup.highestZ = this._zIndex), this.applyStyle("z-index", this._zIndex), this.scrim && (this.createScrim(), 
        this.$.scrim.setZIndex(this._zIndex - 1));
    },
    createScrim: function() {
        this.scrim && (this.$.scrim || (this.createComponents(this.scrimTools, {
            owner: this,
            floating: this.floating
        }), this.floating || this.$.scrim.setContainer(this.parent), this.$.scrim.render(), 
        this.isOpen && this.$.scrim.show()));
    },
    scrimChanged: function() {
        this.scrim ? this.createScrim() : this.$.scrim && this.$.scrim.destroy();
    },
    alignChanged: function(t) {
        this.canTransform ? this.use3d ? enyo.dom.transformValue(this, "translate3d", null) : (enyo.dom.transformValue(this, "translateX", null), 
        enyo.dom.transformValue(this, "translateY", null)) : this.setInlineStyles(null, !1), 
        this.removeClass(t), this.applyAlign(!1);
    },
    applyAlign: function(t) {
        var e = this.getBounds();
        if (e && 0 !== e.height && void 0 !== e.height) {
            this.hasClass(this.align) || this.addClass(this.align), this.applyStyle("top", null), 
            this.applyStyle("left", null);
            var i = this.calcViewportSize(), n = i.width, o = i.height;
            switch (this.align) {
              case "left":
                this.setAxis("h"), this.setMax(0), this.applyStyle("top", this.top + "px"), this.anchor ? (this.setMin(-100), 
                t && this.setValue(-100)) : (this.applyStyle("left", this.left + "px"), x = Math.floor(100 * (n / e.width)), 
                x = -1 * x, this.setMin(x), t && this.setValue(x), this.addClass("full-radius"));
                break;

              case "right":
                this.setAxis("h"), this.setMin(0), this.applyStyle("top", this.top + "px"), this.anchor ? (this.setMax(100), 
                t && this.setValue(100)) : (this.applyStyle("left", this.left + "px"), x = Math.floor(100 * (n / e.width)), 
                this.setMax(x), t && this.setValue(x), this.addClass("full-radius"));
                break;

              case "top":
                this.setAxis("v"), this.setMax(0), this.applyStyle("left", this.left + "px"), this.anchor ? (this.setMin(-100), 
                t && this.setValue(-100)) : (this.applyStyle("top", this.top + "px"), x = Math.floor(100 * (o / e.height)), 
                x = -1 * x, this.setMin(x), t && this.setValue(x));
                break;

              case "bottom":
                this.setAxis("v"), this.setMin(0), this.applyStyle("left", this.left + "px"), this.anchor ? (this.setMax(100), 
                t && this.setValue(100)) : (this.applyStyle("top", this.top + "px"), x = Math.floor(100 * (o / e.height)), 
                this.setMax(x), t && this.setValue(x));
            }
        }
    },
    animateCellOpen: function() {
        switch (this.align) {
          case "left":
          case "top":
            this.animateToMax();
            break;

          case "right":
          case "bottom":
            this.animateToMin();
        }
    },
    animateCellClose: function() {
        switch (this.align) {
          case "left":
          case "top":
            this.animateToMin();
            break;

          case "right":
          case "bottom":
            this.animateToMax();
        }
    },
    isOpen: !1,
    showingChanged: function() {
        this.floating && this.showing && !this.hasNode() && this.render(), this.showing && (this.applyStyle("visibility", "hidden"), 
        this.updatePosition(!0)), this.showing ? (this.inherited(arguments), this.resized(), 
        this.setValue("left" == this.align || "top" == this.align ? this.min : this.max), 
        this.applyStyle("visibility", null), this.animateOpen(), this.doShow(), this.isOpen = !0) : (this.hideScrim(), 
        this.isOpen === !0 ? this.animateClose() : (this.inherited(arguments), this.isOpen = !1));
    },
    hide: function() {
        this.isOpen !== !1 && (this.inherited(arguments), this.release());
    },
    animateOpen: function() {
        this.show(), ToasterPopup.count++, this.applyZIndex(), this.scrim && (this.createScrim(), 
        this.$.scrim.show()), this.animateCellOpen(), this.capture();
    },
    animateClose: function() {
        ToasterPopup.count > 0 && ToasterPopup.count--, this.release(), this.calledClose = !0, 
        this.animateCellClose();
    },
    calledClose: !1,
    checkForHide: function() {
        if (this.calledClose) {
            switch (this.align) {
              case "left":
              case "top":
                this.value == this.min && (this.showing = !1, this.syncDisplayToShowing(), this.isOpen = !1, 
                this.doHide());
                break;

              case "right":
              case "bottom":
                this.value == this.max && (this.showing = !1, this.syncDisplayToShowing(), this.isOpen = !1, 
                this.doHide());
            }
            this.calledClose = !1;
        }
    },
    captured: !1,
    capture: function() {
        this.captured === !1 && this.captureEvents && (enyo.dispatcher.capture(this, this.eventsToCapture), 
        this.captured = !0);
    },
    release: function() {
        this.captured !== !1 && (enyo.dispatcher.release(this), this.captured = !1);
    },
    capturedDown: function(t, e) {
        return this.downEvent = e, this.modal && !this.allowDefault && e.preventDefault(), 
        this.modal;
    },
    capturedTap: function(t, e) {
        return this.autoDismiss && !e.dispatchTarget.isDescendantOf(this) && this.downEvent && !this.downEvent.dispatchTarget.isDescendantOf(this) && (this.downEvent = null, 
        this.hideScrim(), this.animateClose()), this.modal;
    },
    dragstart: function(t, e) {
        var i = e.dispatchTarget === this || e.dispatchTarget.isDescendantOf(this);
        return t.autoDismiss && !i && (this.hideScrim(), t.animateClose()), !0;
    },
    keydown: function(t, e) {
        this.autoDismiss && 27 == e.keyCode && (this.hideScrim(), this.animateClose());
    },
    hideScrim: function() {
        this.$.scrim && this.$.scrim.hide();
    },
    scrimTap: function() {
        this.autoDismiss && (this.hideScrim(), this.animateClose());
    }
});

// source\controls\customdatacontrols.js
enyo.kind({
    name: "enyo.AutoFetchDataList",
    kind: "enyo.DataList",
    fetchThreshold: .9,
    _last_fetch: 0,
    didScroll: function(t, e) {
        this.inherited(arguments);
        var i = e.scrollBounds.maxTop, n = e.scrollBounds.top;
        return n > i * this.fetchThreshold && this.collection.get("length") != this._last_fetch && (this._last_fetch = this.collection.get("length"), 
        this.collection.fetch()), !0;
    }
}), enyo.kind({
    name: "enyo.DataTableList",
    kind: "enyo.AutoFetchDataList",
    fixedChildSize: 32,
    containerOptions: {
        name: "scroller",
        kind: "enyo.Scroller",
        components: [ {
            name: "active",
            classes: "active",
            defaultKind: "enyo.TableRow",
            style: "display: table;",
            components: [ {
                kind: "enyo.Table",
                name: "page1",
                classes: "page page1"
            }, {
                kind: "enyo.Table",
                name: "page2",
                classes: "page page2"
            }, {
                kind: "enyo.Table",
                name: "buffer",
                classes: "buffer"
            } ]
        } ],
        canGenerate: !1,
        classes: "enyo-fit enyo-data-list-scroller"
    }
}), enyo.kind({
    name: "enyo.AutoFetchDataGridList",
    kind: enyo.DataGridList,
    fetchThreshold: .9,
    _last_fetch: 0,
    didScroll: function(t, e) {
        this.inherited(arguments);
        var i = e.scrollBounds.maxTop, n = e.scrollBounds.top;
        return n > i * this.fetchThreshold && this.collection.get("length") != this._last_fetch && (this._last_fetch = this.collection.get("length"), 
        this.collection.fetch()), !0;
    }
});

// source\controls\dragview.js
enyo.kind({
    name: "onyx.DragPopup",
    kind: "onyx.Popup",
    published: {
        fade: !0,
        dragable: !0,
        destroyOnClose: !1,
        title: "",
        subTitle: "",
        sizeable: !1
    },
    events: {
        onCloseClicked: ""
    },
    noDefer: !0,
    style: "border-radius:0;min-height:300px;",
    classes: "drag-popup-fade drag-view",
    showTransitions: !0,
    autoDismiss: !1,
    centered: !0,
    floating: !0,
    handlers: {
        ondragstart: "dragstart",
        ondrag: "drag",
        ondragfinish: "dragfinish",
        ondown: "sendZIndexChange"
    },
    toolbarComponents: [ {
        kind: "FittableRows",
        style: "height:100%;",
        components: [ {
            kind: "onyx.Toolbar",
            style: "",
            components: [ {
                content: "",
                name: "header"
            }, {
                kind: "onyx.Button",
                classes: "onyx-negative",
                content: "X",
                style: "float:right;",
                ontap: "doCloseClicked"
            }, {
                kind: "onyx.Button",
                classes: "",
                content: "_",
                style: "float:right;",
                ontap: "minimizeView"
            } ]
        }, {
            name: "client",
            fit: !0,
            components: []
        } ]
    } ],
    sizeableComponent: {
        kind: "Image",
        name: "sizer",
        style: "width:35px;height:35px;position:absolute;bottom:-5px;right:-5px;",
        src: "assets/resizethumb.png"
    },
    bindings: [ {
        from: ".title",
        to: ".$.header.content"
    } ],
    initComponents: enyo.inherit(function(t) {
        return function() {
            this.log(this.components, this.kindComponents);
            var e = enyo.clone(this.toolbarComponents);
            e[0].components[1].components = enyo.clone(this.kindComponents), this.kindComponents = e, 
            t.apply(this, arguments);
        };
    }),
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.createComponent({
                kind: "enyo.Signals",
                onZIndexChange: "setZIndex",
                onTakeTop: "setAtTop"
            }), enyo.Signals.send("onDragPopupCreated", {
                reference: this
            }), this.sizeable && this.createComponent(this.sizeableComponent, {
                owner: this
            }).render();
        };
    }),
    extractXY: function(t) {
        if (t) {
            var e = t.indexOf("(") + 1, i = t.indexOf(","), n = t.indexOf(",", i + 1);
            return {
                x: parseInt(t.substr(e, i - e), 10),
                y: parseInt(t.substr(i + 1, n - i - 1), 10)
            };
        }
        return {
            x: 0,
            y: 0
        };
    },
    atTop: !1,
    setAtTop: function(t, e) {
        this.atTop = e.reference == this ? !0 : !1;
    },
    setZIndex: function(t, e) {
        this.setAtTop(t, e), e.reference == this ? (this.applyZIndex(), this.minimized && (this.minimized = !1, 
        enyo.dom.transformValue(this, "translate3d", this.prevCords.x + "px," + this.prevCords.y + "px,0"), 
        setTimeout(enyo.bind(this, function() {
            this.removeClass("drag-popup-minimize-transition");
        }), 750)), t && enyo.Signals.send("onDragPopupSelected", {
            reference: this
        })) : this.applyStyle("z-index", this.defaultZ);
    },
    sendZIndexChange: function() {
        return this.atTop !== !1 ? (enyo.Signals.send("onTakeTop", {
            reference: this
        }), this.applyZIndex(), enyo.Signals.send("onDragPopupSelected", {
            reference: this
        }), !0) : (enyo.Signals.send("onTakeTop", {
            reference: this
        }), enyo.Signals.send("onZIndexChange", {
            reference: this
        }), void 0);
    },
    dragstart: function(t, e) {
        if (this.sizeable && e.target.id.indexOf("sizer") > -1) this.sizing = !0, this.prevCords = this.getBounds(); else if (this.dragable && (e.target.id.indexOf("toolbar") > -1 || e.target.id.indexOf("header") > -1)) return this.dragging = !0, 
        this.prevCords = this.extractXY(this.domStyles[enyo.dom.getCssTransformProp()]), 
        this.sendZIndexChange(), !0;
    },
    minimized: !1,
    minimizeView: function() {
        return this.minimized = !0, this.prevCords = this.extractXY(this.domStyles[enyo.dom.getCssTransformProp()]), 
        this.atTop = !1, this.addClass("drag-popup-minimize-transition"), setTimeout(enyo.bind(this, function() {
            enyo.dom.transformValue(this, "translate3d", "-2000px," + (enyo.dom.getWindowHeight() - this.getBounds().height) + "px,0"), 
            enyo.Signals.send("onDragPopupMinimized", {
                reference: this
            });
        }), 0), !0;
    },
    show: function() {
        this.render(), this.setZIndex(null, {
            reference: this
        }), this.updatePosition(), this.showHideScrim(!0), enyo.Signals.send("onTakeTop", {
            reference: this
        }), this.applyStyle("display", "block"), this.resized(), this.addClass("drag-popup-fade-in"), 
        setTimeout(enyo.bind(this, function() {
            this.setShowing(!0);
        }), 500);
    },
    hide: function() {
        return this.showHideScrim(!1), this.atTop = !1, this.removeClass("drag-popup-fade-in"), 
        setTimeout(enyo.bind(this, function() {
            this.setShowing(!1);
        }), 500), !0;
    },
    drag: function(t, e) {
        if (this.sizing) {
            var i = this.prevCords;
            i.width = i.width + e.ddx, i.height = i.height + e.ddy, this.setBounds(i);
        } else if (this.dragging) return this.prevCords.x += e.ddx, this.prevCords.y += e.ddy, 
        enyo.dom.transformValue(this, "translate3d", this.prevCords.x + "px," + this.prevCords.y + "px,0"), 
        !0;
    },
    dragfinish: function() {
        return this.sizing ? (this.sizing = !1, this.resized(), !0) : this.dragging ? (this.dragging = !1, 
        !0) : void 0;
    },
    showingChanged: function() {
        this.showing ? (onyx.Popup.count++, this.applyZIndex()) : onyx.Popup.count > 0 && onyx.Popup.count--, 
        enyo.Popup.prototype.showingChanged.apply(this, arguments), !this.showing && this.destroyOnClose && (enyo.Signals.send("onDragPopupDestroyed", {
            reference: this
        }), setTimeout(enyo.bind(this, function() {
            this.destroy();
        }), 250));
    }
}), enyo.kind({
    name: "onyx.WindowSelectButton",
    kind: "enyo.ToolDecorator",
    classes: "window-select-button",
    published: {
        disabled: !1,
        header: "",
        footer: ""
    },
    components: [ {
        name: "headerLabel",
        classes: "window-select-button-header"
    }, {
        name: "footerLabel",
        classes: "window-select-button-footer"
    } ],
    bindings: [ {
        from: ".header",
        to: ".$.headerLabel.content"
    }, {
        from: ".footer",
        to: ".$.footerLabel.content"
    } ],
    create: enyo.inherit(function(t) {
        return function() {
            t.apply(this, arguments), this.disabledChanged();
        };
    }),
    disabledChanged: function() {
        this.setAttribute("disabled", this.disabled);
    },
    tap: function() {
        return this.disabled ? !0 : (this.setActive(!0), void 0);
    }
});

// source\controls\item.js
enyo.kind({
    name: "onyx.DataListItem",
    classes: "onyx-item",
    tapHighlight: !0,
    handlers: {
        ondown: "hold",
        onup: "release"
    },
    hold: function() {
        this.tapHighlight && this.addClass("onyx-highlight");
    },
    release: function() {
        this.tapHighlight && this.removeClass("onyx-highlight");
    }
});

// source\controls\rangeselect.js
enyo.kind({
    name: "chore.RangeSelect",
    kind: "onyx.Popup",
    style: "width:300px;",
    events: {
        onCanceled: "",
        onDone: ""
    },
    components: [ {
        kind: "FittableRows",
        style: "text-align: center;",
        components: [ {
            content: "Show only:"
        }, {
            kind: "onyx.RadioGroup",
            name: "radio",
            onActivate: "radioClick",
            style: "border-bottom: 2px solid #333;",
            components: [ {
                content: "Range",
                icon: "",
                value: 0,
                active: !0
            }, {
                content: "Day",
                icon: "",
                value: 1
            }, {
                content: "Interval",
                icon: "",
                value: 2
            } ]
        }, {
            kind: "FittableRows",
            name: "optionOne",
            style: "padding:3px;border-top: 1px solid gray;border-bottom: 2px solid #333;",
            components: [ {
                content: "Select a date range:"
            }, {
                kind: "onyx.InputDecorator",
                components: [ {
                    content: "From:",
                    style: "margin-right: 3px"
                }, {
                    kind: "onyx.Input",
                    type: "date",
                    name: "dPickMin"
                } ]
            }, {
                kind: "onyx.InputDecorator",
                components: [ {
                    content: "To:",
                    style: "margin-right: 3px"
                }, {
                    kind: "onyx.Input",
                    type: "date",
                    name: "dPickMax"
                } ]
            } ]
        }, {
            kind: "FittableRows",
            name: "optionTwo",
            style: "padding:3px;border-top: 1px solid gray;border-bottom: 2px solid #333;",
            showing: !1,
            components: [ {
                kind: "onyx.RadioGroup",
                name: "radioDay",
                onActivate: "radioClickSingle",
                components: [ {
                    content: "Date",
                    icon: "",
                    value: 0,
                    active: !0
                }, {
                    content: "Day",
                    icon: "",
                    value: 1
                } ]
            }, {
                kind: "FittableRows",
                name: "interval",
                components: [ {
                    content: "Select a date:"
                }, {
                    kind: "onyx.InputDecorator",
                    components: [ {
                        content: "Date:",
                        style: "margin-right: 3px"
                    }, {
                        kind: "onyx.Input",
                        type: "date",
                        name: "dPickSingle"
                    } ]
                } ]
            }, {
                kind: "FittableRows",
                name: "days",
                showing: !1,
                components: [ {
                    content: "Select a day:"
                }, {
                    kind: "onyx.PickerDecorator",
                    components: [ {}, {
                        kind: "onyx.Picker",
                        name: "dayPicker",
                        components: [ {
                            content: "Sunday",
                            value: 0,
                            active: !0
                        }, {
                            content: "Monday",
                            value: 1
                        }, {
                            content: "Tuesday",
                            value: 2
                        }, {
                            content: "Wednesday",
                            value: 3
                        }, {
                            content: "Thursday",
                            value: 4
                        }, {
                            content: "Friday",
                            value: 5
                        }, {
                            content: "Saturday",
                            value: 6
                        } ]
                    } ]
                } ]
            } ]
        }, {
            kind: "FittableRows",
            name: "optionThree",
            style: "padding:3px;border-top: 1px solid gray;border-bottom: 2px solid #333;",
            showing: !1,
            compone