window.addEventListener('DOMContentLoaded', function() {
  var $ = document.querySelector.bind(document);

  var pitchArea = $('.pitch-area');
  var pitchWrapper = $('.pitch-wrapper');
  var noteName = $('.tuner-noteName');
  var tunerInfo = $('.tuner-info');
  var accidental = $('.tuner-accidental');
  var tuner = window.tuner = new Tuner();
  tuner.onpitchchange = function(tuner) {
    if (Math.abs(tuner.cents) < 10) {
      tuner.cents = 0;
    }

    if (tuner.noteName !== '?') {
      noteName.textContent = tuner.noteName[0];
      accidental.textContent = tuner.noteName[1];
      tunerInfo.classList.add('known');
    } else {
      tunerInfo.classList.remove('known');
    }

    var percentDown = 1 - (tuner.cents + 50) / 100;
    var maxY = pitchWrapper.scrollHeight - pitchArea.scrollHeight;
    pitchArea.style.transform = 'translateY(' + ((percentDown * maxY) | 0) + 'px)';

    pitchArea.dataset.tuning = tuner.cents / 10 | 0;
    pitchArea.style.opacity = Math.min(1, (tuner.confidence | 0) / 100);
  }

  document.addEventListener('visibilitychange', () => {
    if (document.hidden) {
      tuner.stop();
    } else {
      tuner.start();
    }
  });
});
