// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };
  Module['load'] = function load(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module['exports'] = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }
  Module['readBinary'] = function readBinary(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
  eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  if (typeof console !== 'undefined') {
    Module['print'] = function print(x) {
      console.log(x);
    };
    Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  if (ENVIRONMENT_IS_WEB) {
    this['Module'] = Module;
  } else {
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      return '(((' +target + ')+' + (quantum-1) + ')&' + -quantum + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else if (field[0] === '<') {
        // vector type
        size = alignSize = Types.types[field].flatSize; // fully aligned
      } else if (field[0] === 'i') {
        // illegal integer field, that could not be legalized because it is an internal structure field
        // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
        size = alignSize = parseInt(field.substr(1))/8;
        assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
      } else {
        assert(false, 'invalid type for calculateStructAlignment');
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    if (type.name_[0] === '[') {
      // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
      // allocating a potentially huge array for [999999 x i8] etc.
      type.flatSize = parseInt(type.name_.substr(1))*type.flatSize/2;
    }
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  getAsmConst: function (code, numArgs) {
    // code is a constant string on the heap, so we can cache these
    if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
    var func = Runtime.asmConstCache[code];
    if (func) return func;
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(String.fromCharCode(36) + i); // $0, $1 etc
    }
    return Runtime.asmConstCache[code] = eval('(function(' + args.join(',') + '){ ' + Pointer_stringify(code) + ' })'); // new Function does not allow upvars in node
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function processJSString(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+7)&-8); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+7)&-8); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+7)&-8); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      value = intArrayFromString(value);
      type = 'array';
    }
    if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0
}
Module['stringToUTF16'] = stringToUTF16;
// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0
}
Module['stringToUTF32'] = stringToUTF32;
function demangle(func) {
  try {
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    var i = 3;
    // params, etc.
    var basicTypes = {
      'v': 'void',
      'b': 'bool',
      'c': 'char',
      's': 'short',
      'i': 'int',
      'l': 'long',
      'f': 'float',
      'd': 'double',
      'w': 'wchar_t',
      'a': 'signed char',
      'h': 'unsigned char',
      't': 'unsigned short',
      'j': 'unsigned int',
      'm': 'unsigned long',
      'x': 'long long',
      'y': 'unsigned long long',
      'z': '...'
    };
    function dump(x) {
      //return;
      if (x) Module.print(x);
      Module.print(func);
      var pre = '';
      for (var a = 0; a < i; a++) pre += ' ';
      Module.print (pre + '^');
    }
    var subs = [];
    function parseNested() {
      i++;
      if (func[i] === 'K') i++; // ignore const
      var parts = [];
      while (func[i] !== 'E') {
        if (func[i] === 'S') { // substitution
          i++;
          var next = func.indexOf('_', i);
          var num = func.substring(i, next) || 0;
          parts.push(subs[num] || '?');
          i = next+1;
          continue;
        }
        if (func[i] === 'C') { // constructor
          parts.push(parts[parts.length-1]);
          i += 2;
          continue;
        }
        var size = parseInt(func.substr(i));
        var pre = size.toString().length;
        if (!size || !pre) { i--; break; } // counter i++ below us
        var curr = func.substr(i + pre, size);
        parts.push(curr);
        subs.push(curr);
        i += pre + size;
      }
      i++; // skip E
      return parts;
    }
    var first = true;
    function parse(rawList, limit, allowVoid) { // main parser
      limit = limit || Infinity;
      var ret = '', list = [];
      function flushList() {
        return '(' + list.join(', ') + ')';
      }
      var name;
      if (func[i] === 'N') {
        // namespaced N-E
        name = parseNested().join('::');
        limit--;
        if (limit === 0) return rawList ? [name] : name;
      } else {
        // not namespaced
        if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
        var size = parseInt(func.substr(i));
        if (size) {
          var pre = size.toString().length;
          name = func.substr(i + pre, size);
          i += pre + size;
        }
      }
      first = false;
      if (func[i] === 'I') {
        i++;
        var iList = parse(true);
        var iRet = parse(true, 1, true);
        ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
      } else {
        ret = name;
      }
      paramLoop: while (i < func.length && limit-- > 0) {
        //dump('paramLoop');
        var c = func[i++];
        if (c in basicTypes) {
          list.push(basicTypes[c]);
        } else {
          switch (c) {
            case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
            case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
            case 'L': { // literal
              i++; // skip basic type
              var end = func.indexOf('E', i);
              var size = end - i;
              list.push(func.substr(i, size));
              i += size + 2; // size + 'EE'
              break;
            }
            case 'A': { // array
              var size = parseInt(func.substr(i));
              i += size.toString().length;
              if (func[i] !== '_') throw '?';
              i++; // skip _
              list.push(parse(true, 1, true)[0] + ' [' + size + ']');
              break;
            }
            case 'E': break paramLoop;
            default: ret += '?' + c; break paramLoop;
          }
        }
      }
      if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
      return rawList ? list : ret + flushList();
    }
    return parse();
  } catch(e) {
    return func;
  }
}
function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}
function stackTrace() {
  var stack = new Error().stack;
  return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return (x+4095)&-4096;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=str.charCodeAt(i)
  }
  if (!dontAddNull) HEAP8[(((buffer)+(str.length))|0)]=0
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
var memoryInitializer = null;
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 1780496;
var _stdout;
var _stdout=_stdout=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stdin;
var _stdin=_stdin=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stderr;
var _stderr=_stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } },{ func: function() { __GLOBAL__I_a() } },{ func: function() { __GLOBAL__I_a196() } },{ func: function() { __GLOBAL__I_a416() } },{ func: function() { __GLOBAL__I_a468() } },{ func: function() { __GLOBAL__I_a827() } });
var ___fsmu8;
var ___dso_handle;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,152,86,0,0,38,3,0,0,126,1,0,0,182,0,0,0,192,1,0,0,16,0,0,0,10,0,0,0,6,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZTVN10__cxxabiv117__class_type_infoE;
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,168,86,0,0,38,3,0,0,18,3,0,0,182,0,0,0,192,1,0,0,16,0,0,0,26,0,0,0,2,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZN11AboutScreenC1EP4Game;
var __ZN11ChangeWatchC1EPvj;
var __ZN4GameC1Ev;
var __ZN8GameplayC1EP4Game;
var __ZN16HighScoresScreenC1EP4GameP4Page3RGBPKc8FontSizeP8Resource;
var __ZN12LevelManagerC1EP5Scene;
var __ZN12LevelManagerD1Ev;
var __ZN13LevelSelectorC1EP4Game;
var __ZN13LevelSelectorD1Ev;
var __ZN17LevelSelectorPackC1EP4GamePFvP9LevelPackPvES4_;
var __ZN4MenuC1EP4Game;
var __ZN4MenuD1Ev;
var __ZN10MessageBoxC1Ev;
var __ZN10MessageBoxD1Ev;
var __ZN5MixerC1Ev;
var __ZN5MixerD1Ev;
var __ZN13OptionsScreenC1EP4GameP14StorageManager;
var __ZN13OptionsScreenD1Ev;
var __ZN11PauseScreenC1EP4Game;
var __ZN11PauseScreenD1Ev;
var __ZN11PerformanceC1Ev;
var __ZN14ResourceAccessC1EP8Resource;
var __ZN14ResourceAccessD1Ev;
var __ZN13ResultsScreenC1EP4GameP12LevelManagerP12ScoreManager;
var __ZN13ResultsScreenD1Ev;
var __ZN12ScoreManagerC1EP12LevelManagerP14StorageManager;
var __ZN12ScoreManagerD1Ev;
var __ZN14StorageManagerC1EPc;
var __ZN14StorageManagerD1Ev;
var __ZN10TransitionC1Ev;
var __ZN10TransitionD1Ev;
var __ZN10BackgroundC1EP14OpenGLRenderer;
var __ZN12CachedScreenC1EP14OpenGLRenderer;
var __ZN5DecalC1EP14OpenGLRenderer;
var __ZN6EffectC1EP14OpenGLRenderer;
var __ZN13EffectOverlayC1EP14OpenGLRenderer;
var __ZN4FontC1EP14OpenGLRenderer;
var __ZN12RenderedTextC1EP4FontPKc;
var __ZN12RenderedTextD1Ev;
var __ZN11FramebufferC1EP14OpenGLRendereriif;
var __ZN11FramebufferD1Ev;
var __ZN5IconsC1EP14OpenGLRenderer;
var __ZN12LevelPreviewC1EP14OpenGLRenderer;
var __ZN4LineC1EP14OpenGLRenderer;
var __ZN7LoadingC1EP14OpenGLRenderer;
var __ZN7LoadingD1Ev;
var __ZN14OpenGLRendererC1EP4Gameii;
var __ZN13PageIndicatorC1EP14OpenGLRenderer;
var __ZN10ProjectionC1Eii;
var __ZN6ShaderC1ENS_4TypeEP8Resource;
var __ZN7ProgramC1EP14OpenGLRendererPKcP6ShaderS5_;
var __ZN7ProgramD1Ev;
var __ZN6ShadowC1EP14OpenGLRenderer;
var __ZN6SphereC1EP14OpenGLRenderer;
var __ZN14SphereTemplateC1EP14OpenGLRenderer;
var __ZN6SwitchC1EP14OpenGLRenderer;
var __ZN7TextureC1Ev;
var __ZN7TextureD1Ev;
var __ZN17VertexAccumulatorC1Ev;
var __ZN17VertexAccumulatorD1Ev;
var __ZN12VertexBufferC1Ev;
var __ZN12VertexBufferD1Ev;
var __ZN9HintDecalC1EP5SceneN8Circle1D5DecalEii;
var __ZN6ObjectC1EP5Scenefffi3RGB;
var __ZN5JointC1EP5SceneP6ObjectS3_i;
var __ZN15SerializeBufferC1Ev;
var __ZN15SerializeBufferD1Ev;
var __ZNSt13runtime_errorC1EPKc;
var __ZNSt13runtime_errorD1Ev;
var __ZNSt12length_errorD1Ev;
var __ZNSt3__16localeC1Ev;
var __ZNSt3__16localeC1ERKS0_;
var __ZNSt3__16localeD1Ev;
var __ZNSt8bad_castC1Ev;
var __ZNSt8bad_castD1Ev;
/* memory initializer */ allocate([104,17,0,0,192,9,7,0,106,0,0,0,106,0,0,0,168,17,0,0,48,10,7,0,77,0,0,0,77,0,0,0,80,18,0,0,88,234,2,0,71,1,0,0,71,1,0,0,56,19,0,0,160,235,2,0,180,2,0,0,180,2,0,0,144,19,0,0,88,238,2,0,19,1,0,0,19,1,0,0,56,20,0,0,112,239,2,0,191,0,0,0,191,0,0,0,8,13,0,0,0,104,2,0,237,14,0,0,237,14,0,0,64,13,0,0,0,89,2,0,250,14,0,0,250,14,0,0,144,13,0,0,240,118,2,0,152,15,0,0,152,15,0,0,216,13,0,0,136,134,2,0,62,24,0,0,62,24,0,0,112,14,0,0,32,108,0,0,123,16,0,0,123,16,0,0,152,14,0,0,0,165,0,0,0,17,0,0,0,17,0,0,200,14,0,0,184,93,0,0,103,14,0,0,103,14,0,0,240,14,0,0,72,160,2,0,171,20,0,0,171,20,0,0,48,15,0,0,160,124,0,0,235,19,0,0,235,19,0,0,88,15,0,0,144,144,0,0,108,20,0,0,108,20,0,0,152,15,0,0,88,200,2,0,98,16,0,0,98,16,0,0,240,15,0,0,248,180,2,0,30,14,0,0,30,14,0,0,56,16,0,0,192,216,2,0,156,14,0,0,156,14,0,0,216,20,0,0,128,10,7,0,165,0,0,0,165,0,0,0,88,21,0,0,40,11,7,0,85,0,0,0,85,0,0,0,0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,208,21,0,0,48,240,2,0,211,0,0,0,211,0,0,0,80,22,0,0,8,241,2,0,181,1,0,0,181,1,0,0,104,16,0,0,80,27,5,0,60,231,1,0,60,231,1,0,232,16,0,0,192,242,2,0,216,13,1,0,216,13,1,0,8,17,0,0,152,28,4,0,199,151,0,0,199,151,0,0,48,17,0,0,136,191,4,0,193,91,0,0,193,91,0,0,184,22,0,0,64,4,7,0,106,0,0,0,106,0,0,0,248,22,0,0,176,4,7,0,61,0,0,0,61,0,0,0,144,23,0,0,128,16,27,0,159,0,0,0,159,0,0,0,224,23,0,0,32,17,27,0,57,0,0,0,57,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,0,0,0,0,158,0,0,0,232,3,0,0,88,2,0,0,44,1,0,0,0,0,0,0,78,2,0,0,232,3,0,0,88,2,0,0,44,1,0,0,0,0,0,0,40,1,0,0,184,11,0,0,120,5,0,0,188,2,0,0,6,0,0,0,138,2,0,0,208,7,0,0,176,4,0,0,88,2,0,0,6,0,0,0,108,1,0,0,8,7,0,0,232,3,0,0,244,1,0,0,6,0,0,0,210,0,0,0,220,0,0,0,150,0,0,0,135,0,0,0,12,0,0,0,236,0,0,0,88,2,0,0,74,1,0,0,210,0,0,0,12,0,0,0,206,0,0,0,153,2,0,0,244,1,0,0,109,1,0,0,12,0,0,0,48,1,0,0,220,5,0,0,226,4,0,0,182,3,0,0,20,0,0,0,96,2,0,0,184,11,0,0,208,7,0,0,232,3,0,0,20,0,0,0,150,2,0,0,188,2,0,0,144,1,0,0,54,1,0,0,20,0,0,0,226,1,0,0,194,1,0,0,44,1,0,0,180,0,0,0,25,0,0,0,208,2,0,0,184,11,0,0,208,7,0,0,232,3,0,0,27,0,0,0,226,2,0,0,76,4,0,0,138,2,0,0,144,1,0,0,30,0,0,0,36,2,0,0,184,11,0,0,208,7,0,0,232,3,0,0,35,0,0,0,216,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,35,0,0,0,136,2,0,0,164,6,0,0,176,4,0,0,132,3,0,0,35,0,0,0,24,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,42,0,0,0,62,2,0,0,96,9,0,0,108,7,0,0,76,4,0,0,45,0,0,0,196,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,47,0,0,0,122,2,0,0,184,11,0,0,208,7,0,0,232,3,0,0,51,0,0,0,214,0,0,0,38,2,0,0,94,1,0,0,225,0,0,0,55,0,0,0,68,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,60,0,0,0,118,2,0,0,244,1,0,0,44,1,0,0,90,0,0,0,62,0,0,0,80,0,0,0,188,2,0,0,144,1,0,0,54,1,0,0,64,0,0,0,128,2,0,0,144,1,0,0,250,0,0,0,190,0,0,0,66,0,0,0,58,0,0,0,88,2,0,0,154,1,0,0,94,1,0,0,68,0,0,0,174,2,0,0,176,4,0,0,132,3,0,0,188,2,0,0,72,0,0,0,6,3,0,0,184,11,0,0,208,7,0,0,232,3,0,0,74,0,0,0,200,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,76,0,0,0,210,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,79,0,0,0,132,0,0,0,88,2,0,0,144,1,0,0,250,0,0,0,82,0,0,0,82,2,0,0,240,0,0,0,190,0,0,0,150,0,0,0,85,0,0,0,54,2,0,0,208,7,0,0,232,3,0,0,244,1,0,0,87,0,0,0,186,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,89,0,0,0,230,2,0,0,220,5,0,0,132,3,0,0,244,1,0,0,91,0,0,0,242,1,0,0,220,5,0,0,132,3,0,0,244,1,0,0,94,0,0,0,26,1,0,0,220,5,0,0,132,3,0,0,244,1,0,0,96,0,0,0,50,3,0,0,184,11,0,0,208,7,0,0,232,3,0,0,98,0,0,0,20,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,100,0,0,0,114,2,0,0,38,2,0,0,94,1,0,0,225,0,0,0,85,0,0,0,168,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,90,0,0,0,30,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,95,0,0,0,164,0,0,0,184,11,0,0,208,7,0,0,232,3,0,0,105,0,0,0,140,1,0,0,184,11,0,0,208,7,0,0,232,3,0,0,115,0,0,0,168,2,0,0,176,4,0,0,224,1,0,0,64,1,0,0,120,0,0,0,206,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,24,0,0,96,180,4,0,165,0,0,0,165,0,0,0,240,24,0,0,8,181,4,0,180,0,0,0,180,0,0,0,168,25,0,0,104,13,15,0,165,0,0,0,165,0,0,0,224,28,0,0,16,14,15,0,0,0,12,0,0,0,12,0,24,26,0,0,16,14,27,0,40,1,0,0,40,1,0,0,128,15,0,0,192,181,4,0,57,8,0,0,57,8,0,0,184,26,0,0,96,17,27,0,84,1,0,0,84,1,0,0,8,27,0,0,184,18,27,0,15,1,0,0,15,1,0,0,56,27,0,0,200,158,2,0,155,0,0,0,155,0,0,0,168,27,0,0,104,159,2,0,221,0,0,0,221,0,0,0,112,28,0,0,152,0,4,0,206,0,0,0,206,0,0,0,240,28,0,0,104,1,4,0,104,0,0,0,104,0,0,0,144,29,0,0,128,11,7,0,37,1,0,0,37,1,0,0,32,30,0,0,168,12,7,0,185,0,0,0,185,0,0,0,224,12,0,0,104,13,7,0,0,0,8,0,0,0,8,0,192,31,0,0,56,15,27,0,165,0,0,0,165,0,0,0,240,32,0,0,224,15,27,0,158,0,0,0,158,0,0,0,0,19,0,0,208,1,4,0,193,26,0,0,193,26,0,0,224,34,0,0,0,190,4,0,25,1,0,0,25,1,0,0,248,7,0,0,32,191,4,0,104,0,0,0,104,0,0,0,192,8,0,0,96,231,2,0,232,0,0,0,232,0,0,0,232,9,0,0,72,232,2,0,13,2,0,0,13,2,0,0,80,11,0,0,144,2,7,0,221,0,0,0,221,0,0,0,248,12,0,0,112,3,7,0,181,0,0,0,181,0,0,0,74,117,108,0,0,0,0,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,0,0,74,117,110,0,0,0,0,0,114,101,116,117,114,110,32,119,105,110,100,111,119,46,105,110,110,101,114,72,101,105,103,104,116,59,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,0,0,65,112,114,0,0,0,0,0,77,97,114,0,0,0,0,0,99,97,99,104,101,100,115,99,114,101,101,110,95,102,115,104,0,0,0,0,0,0,0,0,70,101,98,0,0,0,0,0,78,79,65,85,84,79,67,79,76,79,82,32,0,0,0,0,74,97,110,0,0,0,0,0,68,101,99,101,109,98,101,114,0,0,0,0,0,0,0,0,78,111,118,101,109,98,101,114,0,0,0,0,0,0,0,0,78,101,119,32,104,105,103,104,115,99,111,114,101,33,0,0,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,32,61,61,32,48,0,0,79,99,116,111,98,101,114,0,83,101,112,116,101,109,98,101,114,0,0,0,0,0,0,0,72,111,119,32,116,111,32,80,108,97,121,0,0,0,0,0,65,117,103,117,115,116,0,0,74,117,108,121,0,0,0,0,74,117,110,101,0,0,0,0,77,97,121,0,0,0,0,0,98,97,99,107,103,114,111,117,110,100,116,101,109,112,108,97,116,101,95,118,115,104,0,0,119,98,0,0,0,0,0,0,65,112,114,105,108,0,0,0,83,87,73,84,67,72,79,78,76,89,32,0,0,0,0,0,65,120,105,115,67,111,110,115,116,114,97,105,110,116,66,101,104,97,118,105,111,114,0,0,77,97,114,99,104,0,0,0,70,101,98,114,117,97,114,121,0,0,0,0,0,0,0,0,74,97,110,117,97,114,121,0,115,116,97,114,115,0,0,0,108,101,110,32,33,61,32,78,79,95,67,79,68,69,0,0,98,97,115,105,99,95,115,116,114,105,110,103,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,80,108,97,121,0,0,0,0,114,101,116,117,114,110,32,119,105,110,100,111,119,46,105,110,110,101,114,87,105,100,116,104,59,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,70,97,108,108,105,110,103,79,98,106,101,99,116,115,66,101,104,97,118,105,111,114,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,98,97,99,107,103,114,111,117,110,100,116,101,109,112,108,97,116,101,95,102,115,104,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,67,79,76,79,82,84,82,65,78,83,70,69,82,32,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,102,114,97,109,101,95,98,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,115,116,97,114,0,0,0,0,99,45,62,115,111,114,116,101,100,95,99,111,100,101,119,111,114,100,115,91,120,93,32,61,61,32,99,111,100,101,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,101,118,101,110,116,81,117,101,117,101,46,108,101,110,103,116,104,59,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,98,97,99,107,103,114,111,117,110,100,95,118,115,104,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,79,68,82,65,71,32,0,67,111,108,111,114,67,111,109,98,105,110,97,116,105,111,110,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,102,114,97,109,101,95,97,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,84,105,109,101,32,110,101,101,100,101,100,32,102,111,114,32,37,100,32,37,115,58,32,37,115,0,0,0,0,0,0,0,107,32,61,61,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,72,79,77,69,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,121,59,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,100,101,99,97,108,115,95,114,103,98,0,0,0,0,0,0,80,77,0,0,0,0,0,0,98,97,99,107,103,114,111,117,110,100,95,102,115,104,0,0,115,111,117,110,100,95,116,111,103,103,108,101,95,115,119,105,116,99,104,95,111,110,95,111,103,103,0,0,0,0,0,0,65,77,0,0,0,0,0,0,67,79,76,79,82,65,66,76,69,32,0,0,0,0,0,0,115,111,117,110,100,95,116,111,103,103,108,101,95,115,119,105,116,99,104,95,111,102,102,95,111,103,103,0,0,0,0,0,109,95,112,111,115,32,43,32,115,105,122,101,32,60,61,32,109,95,108,101,110,103,116,104,0,0,0,0,0,0,0,0,67,104,97,112,116,101,114,115,0,0,0,0,0,0,0,0,115,111,117,110,100,95,115,112,104,101,114,101,95,104,105,116,115,95,119,97,108,108,95,111,103,103,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,112,111,114,116,114,97,105,116,0,0,0,0,0,0,0,0,99,111,108,111,114,0,0,0,115,111,117,110,100,95,112,97,103,101,95,116,114,97,110,115,105,116,105,111,110,95,111,103,103,0,0,0,0,0,0,0,84,105,109,101,32,116,97,107,101,110,58,32,37,115,0,0,65,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,47,46,99,104,114,111,109,111,110,111,95,115,99,111,114,101,115,0,0,0,0,0,0,0,84,111,103,103,108,101,79,112,116,105,111,110,0,0,0,0,40,105,110,116,41,32,102,108,111,111,114,40,112,111,119,40,40,102,108,111,97,116,41,32,114,44,32,100,105,109,41,41,32,60,61,32,101,110,116,114,105,101,115,0,0,0,0,0,115,111,117,110,100,95,109,111,118,97,98,108,101,95,115,112,104,101,114,101,95,114,101,108,101,97,115,101,95,111,103,103,0,0,0,0,0,0,0,0,115,111,117,110,100,95,109,111,118,97,98,108,101,95,115,112,104,101,114,101,95,112,114,101,115,115,95,111,103,103,0,0,108,101,118,101,108,46,99,104,114,111,109,111,110,111,0,0,115,111,117,110,100,95,108,101,118,101,108,95,108,111,99,107,101,100,95,109,101,115,115,97,103,101,95,98,111,120,95,111,103,103,0,0,0,0,0,0,115,111,117,110,100,95,108,101,118,101,108,95,99,111,109,112,108,101,116,101,95,111,103,103,0,0,0,0,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,120,59,0,115,111,117,110,100,95,99,111,108,111,114,95,99,104,97,110,103,101,115,95,116,111,95,119,114,111,110,103,95,111,103,103,0,0,0,0,0,0,0,0,115,111,117,110,100,95,99,111,108,111,114,95,99,104,97,110,103,101,115,95,116,111,95,114,105,103,104,116,95,111,103,103,0,0,0,0,0,0,0,0,104,111,119,116,111,112,108,97,121,95,109,97,114,107,117,112,0,0,0,0,0,0,0,0,115,111,117,110,100,95,99,104,97,105,110,95,98,114,101,97,107,115,95,111,103,103,0,0,70,73,88,69,68,32,0,0,79,98,106,101,99,116,73,115,76,105,103,104,116,83,111,117,114,99,101,66,101,104,97,118,105,111,114,0,0,0,0,0,82,111,116,97,116,105,110,103,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,115,111,117,110,100,95,98,117,116,116,111,110,95,114,101,108,101,97,115,101,95,111,103,103,0,0,0,0,0,0,0,0,102,114,97,109,101,98,117,102,102,101,114,95,115,105,122,101,0,0,0,0,0,0,0,0,100,101,115,105,114,101,100,0,102,105,108,108,101,100,0,0,115,111,117,110,100,95,98,117,116,116,111,110,95,112,114,101,115,115,95,111,103,103,0,0,99,111,108,111,114,0,0,0,112,111,114,116,114,97,105,116,0,0,0,0,0,0,0,0,109,117,115,105,99,95,115,117,98,100,95,111,103,103,0,0,98,114,105,103,104,116,110,101,115,115,0,0,0,0,0,0,114,111,116,97,116,101,100,0,114,97,110,100,111,109,115,105,122,101,0,0,0,0,0,0,78,101,101,100,32,37,100,32,115,116,97,114,115,0,0,0,76,101,118,101,108,32,37,100,32,99,111,109,112,108,101,116,101,0,0,0,0,0,0,0,112,111,119,40,40,102,108,111,97,116,41,32,114,43,49,44,32,100,105,109,41,32,62,32,101,110,116,114,105,101,115,0,109,117,115,105,99,95,115,110,97,112,112,101,114,95,111,103,103,0,0,0,0,0,0,0,115,119,105,116,99,104,0,0,109,117,115,105,99,95,107,97,115,97,57,48,95,111,103,103,0,0,0,0,0,0,0,0,91,76,101,103,97,108,32,110,111,116,105,99,101,115,93,0,109,117,115,105,99,95,97,108,118,101,103,95,111,103,103,0,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,0,0,115,112,104,101,114,101,116,101,109,112,108,97,116,101,0,0,115,119,105,116,99,104,95,118,115,104,0,0,0,0,0,0,67,111,110,116,105,110,117,101,0,0,0,0,0,0,0,0,115,112,104,101,114,101,100,101,102,97,117,108,116,0,0,0,91,69,68,73,84,73,78,71,93,0,0,0,0,0,0,0,115,119,105,116,99,104,95,102,115,104,0,0,0,0,0,0,71,111,116,58,32,37,100,10,0,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,115,104,97,100,111,119,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,115,116,97,116,101,59,0,0,0,0,0,82,101,103,105,115,116,101,114,105,110,103,58,32,39,37,115,39,10,0,0,0,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,115,112,104,101,114,101,116,101,109,112,108,97,116,101,95,118,115,104,0,0,0,0,0,0,67,79,85,76,68,32,78,79,84,32,82,69,45,73,78,83,84,65,78,84,73,65,84,69,32,66,69,72,65,86,73,79,82,58,32,37,115,10,0,0,83,119,105,116,99,104,84,111,103,103,108,101,66,101,104,97,118,105,111,114,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,99,111,112,121,114,105,103,104,116,115,95,109,97,114,107,117,112,0,0,0,0,0,0,0,78,101,101,100,32,37,100,32,109,111,114,101,32,115,116,97,114,115,32,116,111,32,117,110,108,111,99,107,0,0,0,0,115,112,104,101,114,101,116,101,109,112,108,97,116,101,95,102,115,104,0,0,0,0,0,0,66,101,104,97,118,105,111,114,32,37,100,58,32,37,115,10,0,0,0,0,0,0,0,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,0,0,0,78,79,71,82,65,86,73,84,89,32,0,0,0,0,0,0,115,112,104,101,114,101,100,101,102,97,117,108,116,95,118,115,104,0,0,0,0,0,0,0,68,101,99,97,108,58,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,0,0,0,78,101,101,100,32,37,100,32,109,111,114,101,32,115,116,97,114,115,32,116,111,32,117,110,108,111,99,107,0,0,0,0,84,104,101,66,97,115,105,99,115,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,37,100,0,0,0,0,0,0,115,105,122,101,0,0,0,0,99,111,108,111,114,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,115,112,104,101,114,101,100,101,102,97,117,108,116,95,102,115,104,0,0,0,0,0,0,0,79,98,106,101,99,116,32,37,100,58,32,40,37,46,50,102,44,32,37,46,50,102,41,32,64,32,37,46,50,102,32,61,61,61,32,37,120,10,0,0,115,105,122,101,0,0,0,0,116,105,109,101,0,0,0,0,112,97,103,101,105,110,100,105,99,97,116,111,114,0,0,0,82,111,112,101,115,66,101,104,97,118,105,111,114,0,0,0,99,111,108,111,114,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,0,0,0,0,116,114,97,110,115,102,111,114,109,0,0,0,0,0,0,0,115,117,98,116,101,120,0,0,115,104,97,100,111,119,95,118,115,104,0,0,0,0,0,0,115,105,122,101,0,0,0,0,111,112,97,99,105,116,121,0,68,97,116,97,32,115,105,122,101,58,32,37,100,10,0,0,115,117,98,115,105,122,101,0,115,99,114,101,101,110,115,105,122,101,0,0,0,0,0,0,80,117,122,122,108,101,115,66,101,104,97,118,105,111,114,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,115,104,97,100,111,119,95,102,115,104,0,0,0,0,0,0,66,101,104,97,118,105,111,114,32,37,100,58,32,37,115,58,32,37,112,10,0,0,0,0,102,45,62,98,121,116,101,115,95,105,110,95,115,101,103,32,62,32,48,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,67,111,108,111,114,105,122,101,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,37,109,47,37,100,47,37,121,0,0,0,0,0,0,0,0,112,97,103,101,105,110,100,105,99,97,116,111,114,95,118,115,104,0,0,0,0,0,0,0,78,79,32,73,47,79,32,73,77,80,76,69,77,69,78,84,65,84,73,79,78,32,70,79,82,32,66,69,72,65,86,73,79,82,58,32,37,115,10,0,85,110,116,97,110,103,108,101,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,104,116,116,112,58,47,47,116,104,112,46,105,111,47,50,48,49,51,47,99,104,114,111,109,111,110,111,47,0,0,0,0,48,0,0,0,0,0,0,0,112,97,103,101,105,110,100,105,99,97,116,111,114,95,102,115,104,0,0,0,0,0,0,0,108,111,97,100,105,110,103,0,68,101,99,97,108,32,37,100,58,32,37,100,32,37,100,32,37,100,10,0,0,0,0,0,108,105,110,101,0,0,0,0,108,101,118,101,108,112,114,101,118,105,101,119,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,108,111,97,100,105,110,103,95,118,115,104,0,0,0,0,0,105,99,111,110,115,0,0,0,74,111,105,110,116,32,37,100,58,32,37,112,32,40,37,100,41,32,37,112,32,40,37,100,41,32,40,37,100,41,10,0,72,101,108,112,0,0,0,0,108,111,97,100,105,110,103,95,102,115,104,0,0,0,0,0,37,112,0,0,0,0,0,0,79,98,106,101,99,116,32,37,100,58,32,37,46,50,102,32,37,46,50,102,32,40,37,100,41,32,61,61,61,32,37,120,10,0,0,0,0,0,0,0,102,97,108,115,101,0,0,0,102,111,110,116,0,0,0,0,114,101,116,117,114,110,32,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,46,105,100,59,0,0,0,0,0,0,0,0,83,119,105,116,99,104,70,111,114,82,111,116,97,116,105,110,103,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,108,105,110,101,95,118,115,104,0,0,0,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,0,0,0,74,111,105,110,116,32,102,108,97,103,115,61,91,37,115,93,0,0,0,0,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,108,105,110,101,95,102,115,104,0,0,0,0,0,0,0,0,78,101,101,100,32,37,100,32,109,111,114,101,32,115,116,97,114,32,116,111,32,117,110,108,111,99,107,0,0,0,0,0,85,78,84,65,78,71,76,69,32,0,0,0,0,0,0,0,101,102,102,101,99,116,0,0,116,114,117,101,0,0,0,0,100,101,99,97,108,0,0,0,83,76,79,87,32,0,0,0,108,101,118,101,108,112,114,101,118,105,101,119,95,118,115,104,0,0,0,0,0,0,0,0,99,97,99,104,101,100,115,99,114,101,101,110,0,0,0,0,77,79,85,83,69,32,0,0,67,101,110,116,101,114,79,102,79,98,106,101,99,116,115,76,105,103,104,116,83,111,117,114,99,101,0,0,0,0,0,0,78,101,101,100,32,37,100,32,109,111,114,101,32,115,116,97,114,32,116,111,32,117,110,108,111,99,107,0,0,0,0,0,58,32,0,0,0,0,0,0,99,111,108,111,114,0,0,0,99,101,110,116,101,114,0,0,98,97,99,107,103,114,111,117,110,100,0,0,0,0,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,111,112,97,99,105,116,121,0,108,101,118,101,108,112,114,101,118,105,101,119,95,102,115,104,0,0,0,0,0,0,0,0,73,83,95,82,65,73,76,32,0,0,0,0,0,0,0,0,67,104,97,108,108,101,110,103,101,115,0,0,0,0,0,0,99,101,110,116,101,114,0,0,37,48,50,108,100,58,37,48,50,108,100,46,37,48,51,108,100,0,0,0,0,0,0,0,112,114,111,106,101,99,116,105,111,110,0,0,0,0,0,0,99,111,108,111,114,0,0,0,99,111,108,111,114,0,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,105,99,111,110,115,95,118,115,104,0,0,0,0,0,0,0,115,117,98,116,101,120,0,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,72,65,83,95,75,78,79,84,32,0,0,0,0,0,0,0,111,102,102,115,101,116,0,0,85,110,116,97,110,103,108,101,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,78,101,120,116,32,76,101,118,101,108,0,0,0,0,0,0,105,99,111,110,115,95,102,115,104,0,0,0,0,0,0,0,71,97,109,101,32,112,97,117,115,101,100,0,0,0,0,0,66,82,79,75,69,78,32,0,77,105,120,101,114,115,0,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,114,98,0,0,0,0,0,0,83,101,116,116,105,110,103,115,0,0,0,0,0,0,0,0,37,46,50,102,32,70,80,83,0,0,0,0,0,0,0,0,102,45,62,116,101,109,112,95,111,102,102,115,101,116,32,61,61,32,102,45,62,97,108,108,111,99,46,97,108,108,111,99,95,98,117,102,102,101,114,95,108,101,110,103,116,104,95,105,110,95,98,121,116,101,115,0,102,111,110,116,95,118,115,104,0,0,0,0,0,0,0,0,66,82,69,65,75,65,66,76,69,32,0,0,0,0,0,0,82,97,105,108,115,0,0,0,67,111,112,121,114,105,103,104,116,32,40,99,41,32,50,48,49,51,44,32,50,48,49,52,32,84,104,111,109,97,115,32,80,101,114,108,0,0,0,0,102,111,110,116,95,102,115,104,0,0,0,0,0,0,0,0,83,84,82,79,78,71,32,0,82,111,112,101,115,0,0,0,33,99,45,62,115,112,97,114,115,101,0,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,116,101,109,112,108,97,116,101,95,118,115,104,0,0,0,0,0,0,0,82,85,66,66,69,82,66,65,78,68,32,0,0,0,0,0,82,101,115,116,97,114,116,0,67,104,97,112,116,101,114,115,0,0,0,0,0,0,0,0,99,45,62,115,111,114,116,101,100,95,99,111,100,101,119,111,114,100,115,32,124,124,32,99,45,62,99,111,100,101,119,111,114,100,115,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,116,101,109,112,108,97,116,101,95,102,115,104,0,0,0,0,0,0,0,79,98,106,101,99,116,32,40,37,46,50,102,44,32,37,46,50,102,41,44,32,115,105,122,101,61,37,46,50,102,44,32,102,108,97,103,115,61,91,37,115,93,0,0,0,0,0,0,84,104,101,32,66,97,115,105,99,115,0,0,0,0,0,0,67,0,0,0,0,0,0,0,69,109,84,111,117,99,104,111,46,99,117,114,114,101,110,116,69,118,101,110,116,32,61,32,69,109,84,111,117,99,104,111,46,101,118,101,110,116,81,117,101,117,101,46,115,104,105,102,116,40,41,59,0,0,0,0,33,99,45,62,115,112,97,114,115,101,32,124,124,32,122,32,60,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,95,118,115,104,0,0,0,0,0,0,0,73,78,86,73,83,73,66,76,69,32,0,0,0,0,0,0,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,70,114,111,109,79,98,106,101,99,116,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,118,101,99,116,111,114,0,0,122,32,60,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,0,105,99,111,110,115,95,114,103,98,0,0,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,95,102,115,104,0,0,0,0,0,0,0,37,100,47,37,100,0,0,0,83,73,76,69,78,84,32,0,47,85,115,101,114,115,47,116,104,112,47,115,114,99,47,115,104,97,100,121,112,111,115,116,112,114,111,99,47,115,114,99,47,101,120,116,101,114,110,97,108,47,99,105,114,99,108,101,49,100,47,115,101,114,105,97,108,105,122,101,46,99,112,112,0,0,0,0,0,0,0,0,37,46,48,76,102,0,0,0,82,101,115,116,97,114,116,0,40,110,32,38,32,51,41,32,61,61,32,48,0,0,0,0,67,79,76,76,73,68,69,82,32,0,0,0,0,0,0,0,101,102,102,101,99,116,95,118,115,104,0,0,0,0,0,0,83,72,65,68,79,87,67,65,83,84,32,0,0,0,0,0,37,100,0,0,0,0,0,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,88,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,101,102,102,101,99,116,95,102,115,104,0,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,0,0,0,0,0,0,0,83,101,108,101,99,116,32,97,32,76,101,118,101,108,0,0,78,79,79,86,69,82,76,65,80,32,0,0,0,0,0,0,83,97,116,0,0,0,0,0,70,114,105,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,105,111,115,116,114,101,97,109,0,0,0,0,0,0,0,0,37,76,102,0,0,0,0,0,84,104,117,0,0,0,0,0,87,101,100,0,0,0,0,0,47,85,115,101,114,115,47,116,104,112,47,115,114,99,47,115,104,97,100,121,112,111,115,116,112,114,111,99,47,115,114,99,47,114,101,110,100,101,114,101,114,47,111,112,101,110,103,108,95,114,101,110,100,101,114,101,114,46,99,112,112,0,0,0,84,117,101,0,0,0,0,0,102,45,62,97,108,108,111,99,46,97,108,108,111,99,95,98,117,102,102,101,114,95,108,101,110,103,116,104,95,105,110,95,98,121,116,101,115,32,61,61,32,102,45,62,116,101,109,112,95,111,102,102,115,101,116,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,77,111,110,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,83,117,110,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,83,97,116,117,114,100,97,121,0,0,0,0,0,0,0,0,101,102,102,101,99,116,111,118,101,114,108,97,121,116,101,109,112,108,97,116,101,0,0,0,100,101,99,97,108,95,118,115,104,0,0,0,0,0,0,0,70,114,105,100,97,121,0,0,99,111,111,114,100,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,84,104,117,114,115,100,97,121,0,0,0,0,0,0,0,0,87,101,100,110,101,115,100,97,121,0,0,0,0,0,0,0,67,65,78,71,82,65,66,32,0,0,0,0,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,89,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,0,0,0,98,97,99,107,103,114,111,117,110,100,116,101,109,112,108,97,116,101,0,0,0,0,0,0,69,110,97,98,108,101,32,109,117,115,105,99,0,0,0,0,84,117,101,115,100,97,121,0,77,111,110,100,97,121,0,0,119,98,0,0,0,0,0,0,83,117,110,100,97,121,0,0,102,45,62,98,121,116,101,115,95,105,110,95,115,101,103,32,61,61,32,48,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,84,111,32,77,101,110,117,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,100,101,99,97,108,95,102,115,104,0,0,0,0,0,0,0,84,111,32,77,101,110,117,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,83,84,65,89,73,78,86,73,69,87,32,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,69,110,97,98,108,101,32,115,111,117,110,100,32,101,102,102,101,99,116,115,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,47,85,115,101,114,115,47,116,104,112,47,115,114,99,47,115,104,97,100,121,112,111,115,116,112,114,111,99,47,115,114,99,47,101,120,116,101,114,110,97,108,47,115,116,98,95,118,111,114,98,105,115,46,99,0,0,76,101,103,97,108,32,78,111,116,105,99,101,115,0,0,0,97,118,97,105,108,97,98,108,101,91,121,93,32,61,61,32,48,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,99,97,99,104,101,100,115,99,114,101,101,110,95,118,115,104,0,0,0,0,0,0,0,0,114,98,0,0,0,0,0,0,66,79,82,68,69,82,66,79,85,78,67,69,32,0,0,0,88,65,120,105,115,79,114,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,0,0,68,101,99,0,0,0,0,0,78,111,118,0,0,0,0,0,79,99,116,0,0,0,0,0,83,101,112,0,0,0,0,0,98,117,102,95,99,32,61,61,32,50,0,0,0,0,0,0,65,117,103,0,0,0,0,0,48,0,0,0,0,0,0,0,86,101,114,115,105,111,110,32,49,46,48,46,49,0,0,0,99,104,114,111,46,109,111,110,111,0,0,0,0,0,0,0,114,101,97,100,0,0,0,0,108,97,116,101,95,105,110,105,116,105,97,108,105,122,101,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,100,101,105,110,116,101,114,108,101,97,118,101,95,114,101,112,101,97,116,0,0,0,0,0,99,111,110,118,101,114,116,95,99,104,97,110,110,101,108,115,95,115,104,111,114,116,95,105,110,116,101,114,108,101,97,118,101,100,0,0,0,0,0,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,115,99,97,108,97,114,95,114,97,119,0,0,0,0,0,0,118,111,114,98,105,115,95,100,101,99,111,100,101,95,112,97,99,107,101,116,95,114,101,115,116,0,0,0,0,0,0,0,105,109,100,99,116,95,115,116,101,112,51,95,105,116,101,114,48,95,108,111,111,112,0,0,99,111,109,112,117,116,101,95,115,111,114,116,101,100,95,104,117,102,102,109,97,110,0,0,118,111,114,98,105,115,95,100,101,99,111,100,101,95,105,110,105,116,105,97,108,0,0,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,115,116,97,114,116,0,0,0,99,111,109,112,117,116,101,95,99,111,100,101,119,111,114,100,115,0,0,0,0,0,0,0,105,110,99,108,117,100,101,95,105,110,95,115,111,114,116,0,103,101,116,56,95,112,97,99,107,101,116,95,114,97,119,0,108,111,111,107,117,112,49,95,118,97,108,117,101,115,0,0,115,116,97,114,116,95,100,101,99,111,100,101,114,0,0,0,110,101,120,116,95,115,101,103,109,101,110,116,0,0,0,0,103,101,116,95,119,105,110,100,111,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,72,58,37,77,58,37,83,37,72,58,37,77,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,37,89,45,37,109,45,37,100,37,109,47,37,100,47,37,121,37,72,58,37,77,58,37,83,37,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,191,0,0,128,191,0,0,128,63,0,0,128,63,0,0,128,191,0,0,128,63,0,0,128,63,0,0,0,191,0,0,0,191,0,0,0,63,0,0,0,191,0,0,0,191,0,0,0,63,0,0,0,63,0,0,0,63,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,128,63,0,0,128,63,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,191,0,0,128,191,0,0,128,191,0,0,128,63,0,0,128,63,0,0,128,191,0,0,128,63,0,0,128,63,0,0,128,191,0,0,128,191,0,0,128,63,0,0,128,191,0,0,128,191,0,0,128,63,0,0,128,63,0,0,128,63,0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,0,1,0,0,128,0,0,0,86,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,4,0,0,0,118,111,114,98,105,115,0,0,0,0,0,0,112,80,0,0,78,0,0,0,94,1,0,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,80,0,0].concat([98,2,0,0,232,1,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,80,0,0,208,0,0,0,32,3,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,80,0,0,16,1,0,0,22,0,0,0,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,80,0,0,16,1,0,0,48,0,0,0,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,80,0,0,36,3,0,0,248,0,0,0,128,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,80,0,0,52,3,0,0,50,2,0,0,128,0,0,0,4,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,81,0,0,228,1,0,0,52,2,0,0,128,0,0,0,8,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,81,0,0,54,3,0,0,158,1,0,0,128,0,0,0,6,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,81,0,0,44,3,0,0,14,1,0,0,128,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,81,0,0,222,1,0,0,80,1,0,0,128,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,82,0,0,98,0,0,0,82,1,0,0,128,0,0,0,176,0,0,0,6,0,0,0,12,0,0,0,8,0,0,0,22,0,0,0,64,0,0,0,2,0,0,0,248,255,255,255,8,82,0,0,34,0,0,0,14,0,0,0,52,0,0,0,24,0,0,0,4,0,0,0,86,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,82,0,0,12,3,0,0,212,2,0,0,128,0,0,0,32,0,0,0,2,0,0,0,68,0,0,0,32,0,0,0,20,0,0,0,4,0,0,0,4,0,0,0,248,255,255,255,48,82,0,0,102,0,0,0,120,0,0,0,172,0,0,0,68,0,0,0,136,0,0,0,66,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,82,0,0,106,2,0,0,60,2,0,0,128,0,0,0,72,0,0,0,62,0,0,0,30,0,0,0,102,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,82,0,0,34,1,0,0,192,0,0,0,128,0,0,0,64,0,0,0,6,0,0,0,44,0,0,0,124,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,82,0,0,22,3,0,0,2,0,0,0,128,0,0,0,46,0,0,0,28,0,0,0,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,82,0,0,122,0,0,0,226,0,0,0,128,0,0,0,58,0,0,0,16,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,82,0,0,192,2,0,0,90,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,82,0,0,74,0,0,0,154,1,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,82,0,0,136,0,0,0,246,1,0,0,128,0,0,0,8,0,0,0,6,0,0,0,16,0,0,0,4,0,0,0,14,0,0,0,4,0,0,0,2,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,82,0,0,22,1,0,0,40,0,0,0,128,0,0,0,18,0,0,0,24,0,0,0,42,0,0,0,22,0,0,0,40,0,0,0,8,0,0,0,6,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,83,0,0,100,0,0,0,54,0,0,0,128,0,0,0,58,0,0,0,56,0,0,0,50,0,0,0,52,0,0,0,38,0,0,0,44,0,0,0,48,0,0,0,62,0,0,0,46,0,0,0,60,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,83,0,0,66,2,0,0,12,0,0,0,128,0,0,0,26,0,0,0,74,0,0,0,30,0,0,0,34,0,0,0,66,0,0,0,72,0,0,0,70,0,0,0,36,0,0,0,78,0,0,0,76,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,83,0,0,224,0,0,0,12,1,0,0,128,0,0,0,10,0,0,0,30,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,83,0,0,70,0,0,0,254,1,0,0,128,0,0,0,18,0,0,0,38,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,83,0,0,32,0,0,0,44,2,0,0,128,0,0,0,2,0,0,0,14,0,0,0,2,0,0,0,174,0,0,0,98,0,0,0,24,0,0,0,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,83,0,0,12,2,0,0,132,1,0,0,128,0,0,0,12,0,0,0,16,0,0,0,6,0,0,0,76,0,0,0,12,0,0,0,20,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,83,0,0,12,2,0,0,50,0,0,0,128,0,0,0,6,0,0,0,4,0,0,0,4,0,0,0,144,0,0,0,116,0,0,0,14,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,83,0,0,12,2,0,0,38,1,0,0,128,0,0,0,8,0,0,0,10,0,0,0,22,0,0,0,44,0,0,0,106,0,0,0,12,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,83,0,0,12,2,0,0,88,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,0,166,0,0,0,214,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,84,0,0,12,2,0,0,242,0,0,0,128,0,0,0,2,0,0,0,6,0,0,0,2,0,0,0,10,0,0,0,18,0,0,0,40,0,0,0,36,0,0,0,8,0,0,0,6,0,0,0,8,0,0,0,20,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,84,0,0,58,3,0,0,90,0,0,0,128,0,0,0,12,0,0,0,6,0,0,0,26,0,0,0,18,0,0,0,48,0,0,0,4,0,0,0,48,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,84,0,0,118,1,0,0,228,0,0,0,112,0,0,0,14,0,0,0,32,0,0,0,56,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,84,0,0,12,2,0,0,254,0,0,0,128,0,0,0,8,0,0,0,10,0,0,0,22,0,0,0,44,0,0,0,106,0,0,0,12,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,84,0,0,12,2,0,0,184,1,0,0,128,0,0,0,8,0,0,0,10,0,0,0,22,0,0,0,44,0,0,0,106,0,0,0,12,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,84,0,0,124,1,0,0,242,2,0,0,60,0,0,0,44,0,0,0,32,0,0,0,18,0,0,0,128,0,0,0,150,0,0,0,10,0,0,0,42,0,0,0,40,0,0,0,8,0,0,0,64,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,84,0,0,26,0,0,0,98,1,0,0,150,0,0,0,60,0,0,0,30,0,0,0,26,0,0,0,74,0,0,0,122,0,0,0,38,0,0,0,10,0,0,0,16,0,0,0,44,0,0,0,34,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,232,84,0,0,110,0,0,0,166,2,0,0,252,255,255,255,252,255,255,255,232,84,0,0,172,1,0,0,120,1,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,85,0,0,194,2,0,0,244,2,0,0,252,255,255,255,252,255,255,255,0,85,0,0,74,1,0,0,112,2,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,24,85,0,0,6,1,0,0,34,3,0,0,248,255,255,255,248,255,255,255,24,85,0,0,16,2,0,0,72,1,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,48,85,0,0,66,1,0,0,142,2,0,0,248,255,255,255,248,255,255,255,48,85,0,0,144,1,0,0,140,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,72,85,0,0,56,0,0,0,42,2,0,0,104,0,0,0,248,255,255,255,72,85,0,0,120,2,0,0,116,2,0,0,144,255,255,255,144,255,255,255,72,85,0,0,240,0,0,0,240,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,85,0,0,68,0,0,0,184,0,0,0,106,0,0,0,36,0,0,0,14,0,0,0,14,0,0,0,70,0,0,0,122,0,0,0,38,0,0,0,130,0,0,0,16,0,0,0,24,0,0,0,34,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,85,0,0,130,2,0,0,198,2,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,85,0,0,24,3,0,0,24,2,0,0,12,0,0,0,44,0,0,0,32,0,0,0,18,0,0,0,82,0,0,0,150,0,0,0,10,0,0,0,42,0,0,0,40,0,0,0,8,0,0,0,52,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,85,0,0,204,1,0,0,4,2,0,0,92,0,0,0,60,0,0,0,30,0,0,0,26,0,0,0,8,0,0,0,122,0,0,0,38,0,0,0,10,0,0,0,16,0,0,0,44,0,0,0,62,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,85,0,0,210,2,0,0,162,1,0,0,128,0,0,0,100,0,0,0,18,0,0,0,142,0,0,0,168,0,0,0,94,0,0,0,86,0,0,0,78,0,0,0,64,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,85,0,0,60,1,0,0,156,0,0,0,128,0,0,0,184,0,0,0,170,0,0,0,156,0,0,0,184,0,0,0,188,0,0,0,74,0,0,0,168,0,0,0,118,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,86,0,0,214,2,0,0,92,1,0,0,128,0,0,0,26,0,0,0,90,0,0,0,26,0,0,0,96,0,0,0,190,0,0,0,120,0,0,0,134,0,0,0,126,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,86,0,0,230,0,0,0,244,1,0,0,128,0,0,0,152,0,0,0,160,0,0,0,84,0,0,0,182,0,0,0,78,0,0,0,62,0,0,0,114,0,0,0,170,0,0,0,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,86,0,0,86,2,0,0,200,0,0,0,128,0,0,0,44,0,0,0,32,0,0,0,18,0,0,0,128,0,0,0,150,0,0,0,10,0,0,0,138,0,0,0,118,0,0,0,14,0,0,0,64,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,86,0,0,38,0,0,0,130,0,0,0,154,0,0,0,60,0,0,0,30,0,0,0,26,0,0,0,74,0,0,0,122,0,0,0,38,0,0,0,140,0,0,0,38,0,0,0,2,0,0,0,34,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,86,0,0,38,3,0,0,104,2,0,0,182,0,0,0,192,1,0,0,16,0,0,0,2,0,0,0,14,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,86,0,0,224,2,0,0,26,2,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,86,0,0,252,1,0,0,30,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,86,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,86,0,0,138,0,0,0,8,0,0,0,114,0,0,0,84,1,0,0,70,1,0,0,108,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,86,0,0,2,0,0,0,82,0,0,0,2,1,0,0,32,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,87,0,0,130,1,0,0,218,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,87,0,0,208,1,0,0,152,0,0,0,110,2,0,0,8,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,87,0,0,174,0,0,0,84,0,0,0,110,2,0,0,168,1,0,0,102,1,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,87,0,0,154,2,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,87,0,0,96,1,0,0,116,0,0,0,110,2,0,0,128,1,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,87,0,0,74,2,0,0,22,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,87,0,0,178,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,87,0,0,158,2,0,0,134,0,0,0,110,2,0,0,188,0,0,0,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,87,0,0,34,0,0,0,240,2,0,0,10,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,87,0,0,150,0,0,0,94,0,0,0,186,0,0,0,248,255,255,255,128,87,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,87,0,0,238,1,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,87,0,0,0,1,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,87,0,0,2,2,0,0,4,0,0,0,84,2,0,0,238,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,87,0,0,152,2,0,0,250,2,0,0,222,2,0,0,190,2,0,0,58,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,87,0,0,2,0,0,0,2,0,0,0,114,0,0,0,84,1,0,0,114,1,0,0,96,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,87,0,0,130,0,0,0,134,0,0,0,24,0,0,0,186,2,0,0,114,1,0,0,96,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,87,0,0,144,2,0,0,38,2,0,0,110,2,0,0,90,2,0,0,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,88,0,0,112,0,0,0,56,1,0,0,230,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,88,0,0,34,2,0,0,234,0,0,0,110,2,0,0,180,0,0,0,220,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,88,0,0,34,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,88,0,0,176,1,0,0,30,2,0,0,28,1,0,0,142,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,88,0,0,42,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,88,0,0,2,0,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,88,0,0,76,1,0,0,194,1,0,0,202,2,0,0,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,88,0,0,24,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,88,0,0,216,2,0,0,170,2,0,0,190,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,88,0,0,4,3,0,0,0,2,0,0,36,1,0,0,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,88,0,0,182,2,0,0,152,1,0,0,62,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,88,0,0,20,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,88,0,0,8,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,88,0,0,4,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,88,0,0,28,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,88,0,0,4,1,0,0,76,0,0,0,112,1,0,0,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,89,0,0,220,0,0,0,48,2,0,0,184,2,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,89,0,0,156,2,0,0,88,2,0,0,64,2,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,89,0,0,96,0,0,0,146,0,0,0,162,2,0,0,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,89,0,0,104,0,0,0,142,0,0,0,94,2,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,89,0,0,68,2,0,0,56,3,0,0,108,0,0,0,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,89,0,0,16,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,89,0,0,180,2,0,0,142,1,0,0,236,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,89,0,0,178,1,0,0,236,1,0,0,10,1,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,89,0,0,222,0,0,0,198,1,0,0,234,2,0,0,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,89,0,0,102,2,0,0,46,2,0,0,138,0,0,0,58,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,89,0,0,64,0,0,0,100,2,0,0,254,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,89,0,0,148,0,0,0,164,0,0,0,114,0,0,0,116,1,0,0,114,1,0,0,48,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,89,0,0,80,2,0,0,62,1,0,0,216,1,0,0,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,89,0,0,156,1,0,0,30,1,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,90,0,0,46,0,0,0,64,3,0,0,160,0,0,0,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,90,0,0,88,0,0,0,22,0,0,0,32,2,0,0,196,0,0,0,204,0,0,0,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,90,0,0,52,1,0,0,134,2,0,0,110,2,0,0,148,1,0,0,138,1,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,90,0,0,228,2,0,0,164,1,0,0,60,0,0,0,22,0,0,0,160,2,0,0,50,0,0,0,64,1,0,0,12,0,0,0,2,0,0,0,4,0,0,0,2,0,0,0,72,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,90,0,0,202,0,0,0,14,2,0,0,110,2,0,0,148,0,0,0,140,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,90,0,0,126,2,0,0,232,0,0,0,42,1,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,90,0,0,198,0,0,0,76,0,0,0,172,0,0,0,28,2,0,0,114,1,0,0,2,0,0,0,48,0,0,0,14,3,0,0,172,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,90,0,0,162,0,0,0,134,1,0,0,20,0,0,0,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,90,0,0,26,3,0,0,42,0,0,0,38,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,90,0,0,202,1,0,0,180,1,0,0,110,2,0,0,250,0,0,0,252,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,90,0,0,98,0,0,0,32,0,0,0,114,0,0,0,84,1,0,0,114,1,0,0,30,0,0,0,48,0,0,0,220,1,0,0,48,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,90,0,0,16,0,0,0,82,0,0,0,176,0,0,0,84,1,0,0,114,1,0,0,158,0,0,0,122,0,0,0,232,2,0,0,72,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,90,0,0,18,0,0,0,246,0,0,0,60,3,0,0,164,2,0,0,248,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,90,0,0,178,2,0,0,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,90,0,0,206,2,0,0,248,2,0,0,124,2,0,0,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,0,0,50,1,0,0,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,91,0,0,58,1,0,0,200,2,0,0,110,2,0,0,146,2,0,0,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,91,0,0,66,0,0,0,28,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,91,0,0,198,0,0,0,174,0,0,0,114,0,0,0,84,1,0,0,114,1,0,0,96,0,0,0,48,0,0,0,24,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,91,0,0,20,3,0,0,196,1,0,0,110,2,0,0,16,0,0,0,174,1,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,91,0,0,198,0,0,0,110,0,0,0,114,0,0,0,84,1,0,0,114,1,0,0,50,0,0,0,48,0,0,0,78,1,0,0,182,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,91,0,0,160,0,0,0,18,0,0,0,114,0,0,0,190,1,0,0,114,1,0,0,92,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,91,0,0,108,0,0,0,92,2,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,91,0,0,148,2,0,0,86,1,0,0,110,2,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,91,0,0,20,0,0,0,44,1,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,91,0,0,28,0,0,0,18,2,0,0,212,1,0,0,124,0,0,0,176,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,83,116,56,98,97,100,95,99,97,115,116,0,0,0,0,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,0,0,0,0,0,0,83,116,49,50,108,101,110,103,116,104,95,101,114,114,111,114,0,0,0,0,0,0,0,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,0,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,98,97,115,105,99,95,105,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,102,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,102,105,108,101,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,57,80,114,101,115,115,97,98,108,101,0,0,0,0,0,0,57,72,105,110,116,68,101,99,97,108,0,0,0,0,0,0,56,83,116,111,114,97,98,108,101,0,0,0,0,0,0,0,56,71,97,109,101,112,108,97,121,0,0,0,0,0,0,0,56,71,97,109,101,80,114,105,118,0,0,0,0,0,0,0,55,80,114,111,103,114,97,109,0,0,0,0,0,0,0,0,55,76,111,97,100,105,110,103,0,0,0,0,0,0,0,0,54,83,119,105,116,99,104,0,54,83,112,104,101,114,101,0,54,83,104,97,100,111,119,0,54,83,104,97,100,101,114,0,54,79,98,106,101,99,116,0,54,69,102,102,101,99,116,0,54,66,117,116,116,111,110,0,53,83,99,101,110,101,0,0,53,77,105,120,101,114,0,0,53,74,111,105,110,116,0,0,53,73,99,111,110,115,0,0,53,68,101,99,97,108,0,0,52,80,97,103,101,0,0,0,52,77,101,110,117,0,0,0,52,76,105,110,101,0,0,0,52,71,97,109,101,0,0,0,52,70,111,110,116,0,0,0,51,53,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,70,114,111,109,79,98,106,101,99,116,66,101,104,97,118,105,111,114,73,79,0,0,0,51,51,66,97,99,107,103,114,111,117,110,100,67,111,108,111,114,70,114,111,109,79,98,106,101,99,116,66,101,104,97,118,105,111,114,0,0,0,0,0,50,57,79,98,106,101,99,116,73,115,76,105,103,104,116,83,111,117,114,99,101,66,101,104,97,118,105,111,114,73,79,0,50,56,67,101,110,116,101,114,79,102,79,98,106,101,99,116,115,76,105,103,104,116,83,111,117,114,99,101,73,79,0,0,50,55,79,98,106,101,99,116,73,115,76,105,103,104,116,83,111,117,114,99,101,66,101,104,97,118,105,111,114,0,0,0,50,54,67,111,108,111,114,67,111,109,98,105,110,97,116,105,111,110,66,101,104,97,118,105,111,114,73,79,0,0,0,0,50,54,67,101,110,116,101,114,79,102,79,98,106,101,99,116,115,76,105,103,104,116,83,111,117,114,99,101,0,0,0,0,50,53,83,119,105,116,99,104,70,111,114,82,111,116,97,116,105,110,103,66,101,104,97,118,105,111,114,0,0,0,0,0,50,52,67,111,108,111,114,67,111,109,98,105,110,97,116,105,111,110,66,101,104,97,118,105,111,114,0,0,0,0,0,0,50,52,65,120,105,115,67,111,110,115,116,114,97,105,110,116,66,101,104,97,118,105,111,114,73,79,0,0,0,0,0,0,50,51,89,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,73,79,0,0,0,0,0,0,0,50,51,88,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,73,79,0,0,0,0,0,0,0,50,50,88,65,120,105,115,79,114,100,101,114,67,111,110,115,116,114,97,105,110,116,73,79,0,0,0,0,0,0,0,0,50,50,70,97,108,108,105,110,103,79,98,106,101,99,116,115,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,50,50,65,120,105,115,67,111,110,115,116,114,97,105,110,116,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,0,50,49,89,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,0,50,49,88,65,120,105,115,80,101,110,100,117,108,117,109,66,101,104,97,118,105,111,114,0,50,48,88,65,120,105,115,79,114,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,50,48,83,119,105,116,99,104,84,111,103,103,108,101,66,101,104,97,118,105,111,114,0,0,50,48,67,105,114,99,108,101,49,68,69,118,101,110,116,72,97,110,100,108,101,114,0,0,49,56,84,114,97,110,115,105,116,105,111,110,76,105,115,116,101,110,101,114,0,0,0,0,49,56,82,111,116,97,116,105,110,103,66,101,104,97,118,105,111,114,73,79,0,0,0,0,49,56,76,97,116,101,73,110,105,116,105,97,108,105,122,101,84,97,115,107,0,0,0,0,49,56,67,105,114,99,108,101,49,68,66,101,104,97,118,105,111,114,73,79,0,0,0,0,49,55,84,104,101,66,97,115,105,99,115,66,101,104,97,118,105,111,114,0,0,0,0,0,49,54,85,110,116,97,110,103,108,101,66,101,104,97,118,105,111,114,0,0,0,0,0,0,49,54,82,111,116,97,116,105,110,103,66,101,104,97,118,105,111,114,0,0,0,0,0,0,49,54,76,101,118,101,108,76,111,97,100,105,110,103,84,97,115,107,0,0,0,0,0,0,49,54,72,105,103,104,83,99,111,114,101,115,83,99,114,101,101,110,0,0,0,0,0,0,49,54,67,111,108,111,114,105,122,101,66,101,104,97,118,105,111,114,0,0,0,0,0,0,49,54,67,105,114,99,108,101,49,68,82,101,110,100,101,114,101,114,0,0,0,0,0,0,49,54,67,105,114,99,108,101,49,68,66,101,104,97,118,105,111,114,0,0,0,0,0,0,49,53,80,117,122,122,108,101,115,66,101,104,97,118,105,111,114,0,0,0,0,0,0,0,49,52,83,116,111,114,97,98,108,101,83,116,114,117,99,116,0,0,0,0,0,0,0,0,49,52,83,112,104,101,114,101,84,101,109,112,108,97,116,101,0,0,0,0,0,0,0,0,49,52,79,112,101,110,71,76,82,101,110,100,101,114,101,114,0,0,0,0,0,0,0,0,49,51,83,112,104,101,114,101,68,101,102,97,117,108,116,0,49,51,82,111,112,101,115,66,101,104,97,118,105,111,114,0,49,51,82,101,115,117,108,116,115,83,99,114,101,101,110,0,49,51,80,114,101,115,115,97,98,108,101,82,101,99,116,0,49,51,80,114,101,115,115,97,98,108,101,80,97,99,107,0,49,51,80,97,103,101,73,110,100,105,99,97,116,111,114,0,49,51,79,112,116,105,111,110,115,83,99,114,101,101,110,0,49,51,76,101,118,101,108,83,101,108,101,99,116,111,114,0,49,51,71,97,109,101,80,114,101,115,115,97,98,108,101,0,49,51,69,102,102,101,99,116,79,118,101,114,108,97,121,0,49,50,86,101,114,116,101,120,66,117,102,102,101,114,0,0,49,50,84,111,103,103,108,101,79,112,116,105,111,110,0,0,49,50,83,99,111,114,101,77,97,110,97,103,101,114,0,0,49,50,76,101,118,101,108,80,114,101,118,105,101,119,0,0,49,50,76,101,118,101,108,77,97,110,97,103,101,114,0,0,49,50,67,105,114,99,108,101,49,68,84,121,112,101,0,0,49,50,67,104,111,105,99,101,83,99,114,101,101,110,0,0,49,50,67,97,99,104,101,100,83,99,114,101,101,110,0,0,49,49,80,97,117,115,101,83,99,114,101,101,110,0,0,0,49,49,76,111,97,100,105,110])
.concat([103,84,97,115,107,0,0,0,49,49,65,98,111,117,116,83,99,114,101,101,110,0,0,0,49,48,84,114,97,110,115,105,116,105,111,110,0,0,0,0,49,48,82,101,110,100,101,114,97,98,108,101,0,0,0,0,49,48,77,101,115,115,97,103,101,66,111,120,0,0,0,0,49,48,66,97,99,107,103,114,111,117,110,100,0,0,0,0,0,0,0,0,184,61,0,0,0,0,0,0,200,61,0,0,0,0,0,0,216,61,0,0,104,80,0,0,0,0,0,0,0,0,0,0,232,61,0,0,104,80,0,0,0,0,0,0,0,0,0,0,248,61,0,0,104,80,0,0,0,0,0,0,0,0,0,0,16,62,0,0,176,80,0,0,0,0,0,0,0,0,0,0,40,62,0,0,104,80,0,0,0,0,0,0,0,0,0,0,56,62,0,0,224,50,0,0,80,62,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,176,85,0,0,0,0,0,0,224,50,0,0,152,62,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,184,85,0,0,0,0,0,0,224,50,0,0,224,62,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,192,85,0,0,0,0,0,0,224,50,0,0,40,63,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,200,85,0,0,0,0,0,0,0,0,0,0,112,63,0,0,184,82,0,0,0,0,0,0,0,0,0,0,160,63,0,0,184,82,0,0,0,0,0,0,224,50,0,0,208,63,0,0,0,0,0,0,1,0,0,0,208,84,0,0,0,0,0,0,224,50,0,0,232,63,0,0,0,0,0,0,1,0,0,0,208,84,0,0,0,0,0,0,224,50,0,0,0,64,0,0,0,0,0,0,1,0,0,0,216,84,0,0,0,0,0,0,224,50,0,0,24,64,0,0,0,0,0,0,1,0,0,0,216,84,0,0,0,0,0,0,224,50,0,0,48,64,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,96,86,0,0,0,8,0,0,224,50,0,0,120,64,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,96,86,0,0,0,8,0,0,224,50,0,0,192,64,0,0,0,0,0,0,3,0,0,0,240,83,0,0,2,0,0,0,192,80,0,0,2,0,0,0,80,84,0,0,0,8,0,0,224,50,0,0,8,65,0,0,0,0,0,0,3,0,0,0,240,83,0,0,2,0,0,0,192,80,0,0,2,0,0,0,88,84,0,0,0,8,0,0,0,0,0,0,80,65,0,0,240,83,0,0,0,0,0,0,0,0,0,0,104,65,0,0,240,83,0,0,0,0,0,0,224,50,0,0,128,65,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,224,84,0,0,2,0,0,0,224,50,0,0,152,65,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,224,84,0,0,2,0,0,0,0,0,0,0,176,65,0,0,0,0,0,0,200,65,0,0,104,85,0,0,0,0,0,0,224,50,0,0,232,65,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,104,81,0,0,0,0,0,0,224,50,0,0,48,66,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,128,81,0,0,0,0,0,0,224,50,0,0,120,66,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,152,81,0,0,0,0,0,0,224,50,0,0,192,66,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,176,81,0,0,0,0,0,0,0,0,0,0,8,67,0,0,240,83,0,0,0,0,0,0,0,0,0,0,32,67,0,0,240,83,0,0,0,0,0,0,224,50,0,0,56,67,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,120,85,0,0,2,0,0,0,224,50,0,0,96,67,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,120,85,0,0,2,0,0,0,224,50,0,0,136,67,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,120,85,0,0,2,0,0,0,224,50,0,0,176,67,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,120,85,0,0,2,0,0,0,0,0,0,0,216,67,0,0,200,84,0,0,0,0,0,0,0,0,0,0,240,67,0,0,240,83,0,0,0,0,0,0,224,50,0,0,8,68,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,88,86,0,0,2,0,0,0,224,50,0,0,32,68,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,88,86,0,0,2,0,0,0,0,0,0,0,56,68,0,0,0,0,0,0,96,68,0,0,0,0,0,0,136,68,0,0,128,85,0,0,0,0,0,0,0,0,0,0,168,68,0,0,208,83,0,0,0,0,0,0,0,0,0,0,208,68,0,0,208,83,0,0,0,0,0,0,0,0,0,0,248,68,0,0,0,0,0,0,48,69,0,0,0,0,0,0,104,69,0,0,224,50,0,0,136,69,0,0,3,0,0,0,2,0,0,0,48,85,0,0,2,0,0,0,0,85,0,0,2,8,0,0,0,0,0,0,184,69,0,0,0,0,0,0,216,69,0,0,0,0,0,0,248,69,0,0,0,0,0,0,24,70,0,0,224,50,0,0,48,70,0,0,0,0,0,0,1,0,0,0,72,81,0,0,3,244,255,255,224,50,0,0,96,70,0,0,0,0,0,0,1,0,0,0,88,81,0,0,3,244,255,255,224,50,0,0,144,70,0,0,0,0,0,0,1,0,0,0,72,81,0,0,3,244,255,255,224,50,0,0,192,70,0,0,0,0,0,0,1,0,0,0,88,81,0,0,3,244,255,255,0,0,0,0,240,70,0,0,168,84,0,0,0,0,0,0,0,0,0,0,32,71,0,0,152,84,0,0,0,0,0,0,0,0,0,0,80,71,0,0,144,80,0,0,0,0,0,0,0,0,0,0,104,71,0,0,0,0,0,0,128,71,0,0,160,84,0,0,0,0,0,0,0,0,0,0,152,71,0,0,144,84,0,0,0,0,0,0,0,0,0,0,184,71,0,0,152,84,0,0,0,0,0,0,0,0,0,0,216,71,0,0,0,0,0,0,248,71,0,0,0,0,0,0,24,72,0,0,0,0,0,0,56,72,0,0,224,50,0,0,88,72,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,80,86,0,0,2,0,0,0,224,50,0,0,120,72,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,80,86,0,0,2,0,0,0,224,50,0,0,152,72,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,80,86,0,0,2,0,0,0,224,50,0,0,184,72,0,0,0,0,0,0,2,0,0,0,240,83,0,0,2,0,0,0,80,86,0,0,2,0,0,0,0,0,0,0,216,72,0,0,0,0,0,0,240,72,0,0,0,0,0,0,8,73,0,0,0,0,0,0,32,73,0,0,144,84,0,0,0,0,0,0,0,0,0,0,56,73,0,0,152,84,0,0,0,0,0,0,0,0,0,0,80,73,0,0,168,86,0,0,0,0,0,0,0,0,0,0,120,73,0,0,168,86,0,0,0,0,0,0,0,0,0,0,160,73,0,0,184,86,0,0,0,0,0,0,0,0,0,0,200,73,0,0,96,80,0,0,0,0,0,0,0,0,0,0,240,73,0,0,0,0,0,0,0,74,0,0,32,91,0,0,0,0,0,0,0,0,0,0,16,74,0,0,0,0,0,0,32,74,0,0,216,87,0,0,0,0,0,0,0,0,0,0,48,74,0,0,96,89,0,0,0,0,0,0,0,0,0,0,64,74,0,0,0,0,0,0,80,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,96,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,104,74,0,0,0,0,0,0,112,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,120,74,0,0,0,0,0,0,128,74,0,0,32,91,0,0,0,0,0,0,0,0,0,0,136,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,144,74,0,0,200,86,0,0,0,0,0,0,224,50,0,0,152,74,0,0,0,0,0,0,2,0,0,0,32,91,0,0,2,0,0,0,88,89,0,0,2,8,0,0,0,0,0,0,160,74,0,0,0,0,0,0,168,74,0,0,32,91,0,0,0,0,0,0,0,0,0,0,176,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,184,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,192,74,0,0,88,89,0,0,0,0,0,0,0,0,0,0,200,74,0,0,216,87,0,0,0,0,0,0,0,0,0,0,208,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,216,74,0,0,88,89,0,0,0,0,0,0,0,0,0,0,224,74,0,0,128,91,0,0,0,0,0,0,0,0,0,0,232,74,0,0,136,89,0,0,0,0,0,0,0,0,0,0,16,75,0,0,248,89,0,0,0,0,0,0,0,0,0,0,56,75,0,0,136,89,0,0,0,0,0,0,0,0,0,0,88,75,0,0,136,89,0,0,0,0,0,0,0,0,0,0,120,75,0,0,248,89,0,0,0,0,0,0,0,0,0,0,152,75,0,0,136,89,0,0,0,0,0,0,0,0,0,0,184,75,0,0,248,89,0,0,0,0,0,0,0,0,0,0,216,75,0,0,248,89,0,0,0,0,0,0,0,0,0,0,248,75,0,0,248,89,0,0,0,0,0,0,0,0,0,0,24,76,0,0,136,89,0,0,0,0,0,0,0,0,0,0,56,76,0,0,136,89,0,0,0,0,0,0,0,0,0,0,88,76,0,0,136,89,0,0,0,0,0,0,0,0,0,0,120,76,0,0,136,89,0,0,0,0,0,0,0,0,0,0,152,76,0,0,248,89,0,0,0,0,0,0,0,0,0,0,184,76,0,0,248,89,0,0,0,0,0,0,0,0,0,0,216,76,0,0,248,89,0,0,0,0,0,0,0,0,0,0,240,76,0,0,248,89,0,0,0,0,0,0,0,0,0,0,8,77,0,0,248,89,0,0,0,0,0,0,0,0,0,0,32,77,0,0,248,89,0,0,0,0,0,0,0,0,0,0,56,77,0,0,0,0,0,0,80,77,0,0,0,0,0,0,104,77,0,0,136,89,0,0,0,0,0,0,0,0,0,0,128,77,0,0,88,91,0,0,0,0,0,0,0,0,0,0,152,77,0,0,0,0,0,0,176,77,0,0,248,89,0,0,0,0,0,0,0,0,0,0,200,77,0,0,248,89,0,0,0,0,0,0,0,0,0,0,224,77,0,0,248,89,0,0,0,0,0,0,0,0,0,0,248,77,0,0,88,91,0,0,0,0,0,0,0,0,0,0,16,78,0,0,216,87,0,0,0,0,0,0,0,0,0,0,40,78,0,0,248,89,0,0,0,0,0,0,0,0,0,0,64,78,0,0,0,0,0,0,88,78,0,0,32,91,0,0,0,0,0,0,0,0,0,0,112,78,0,0,248,89,0,0,0,0,0,0,0,0,0,0,136,78,0,0,224,86,0,0,0,0,0,0,0,0,0,0,160,78,0,0,128,91,0,0,0,0,0,0,0,0,0,0,184,78,0,0,240,89,0,0,0,0,0,0,0,0,0,0,208,78,0,0,128,91,0,0,0,0,0,0,0,0,0,0,224,78,0,0,248,89,0,0,0,0,0,0,0,0,0,0,240,78,0,0,40,91,0,0,0,0,0,0,0,0,0,0,0,79,0,0,200,90,0,0,0,0,0,0,0,0,0,0,16,79,0,0,200,86,0,0,0,0,0,0,0,0,0,0,32,79,0,0,128,91,0,0,0,0,0,0,0,0,0,0,48,79,0,0,216,87,0,0,0,0,0,0,0,0,0,0,64,79,0,0,216,87,0,0,0,0,0,0,0,0,0,0,80,79,0,0,200,86,0,0,0,0,0,0,0,0,0,0,96,79,0,0,128,91,0,0,0,0,0,0,0,0,0,0,112,79,0,0,0,0,0,0,128,79,0,0,248,89,0,0,0,0,0,0,0,0,0,0,144,79,0,0,0,0,0,0,160,79,0,0,128,91,0,0,0,0,0,0,0,0,0,0,176,79,0,0,0,0,0,0,192,79,0,0,0,0,0,0,208,79,0,0,216,87,0,0,0,0,0,0,0,0,0,0,224,79,0,0,128,91,0,0,0,0,0,0,0,0,0,0,240,79,0,0,40,91,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,16,80,0,0,216,87,0,0,0,0,0,0,0,0,0,0,32,80,0,0,88,89,0,0,0,0,0,0,0,0,0,0,48,80,0,0,0,0,0,0,64,80,0,0,88,89,0,0,0,0,0,0,0,0,0,0,80,80,0,0,128,91,0,0,0,0,0,0,112,0,0,0,0,0,0,0,48,85,0,0,66,1,0,0,142,2,0,0,144,255,255,255,144,255,255,255,48,85,0,0,144,1,0,0,140,0,0,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,200,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,100,0,0,0,0,0,0,0,144,1,0,0,0,0,0,0,134,1,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,10,0,0,0,0,0,0,0,70,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,0,0,16,65,0,0,0,0,154,153,153,62,0,0,0,0,224,1,0,0,0,0,0,0,205,204,76,61,0,0,0,0,32,3,0,0,0,0,0,0,205,204,204,62,102,102,102,63,205,204,76,62,0,0,0,0,0,0,128,63,0,0,128,63,0,0,128,63,0,0,0,0,51,51,51,63,102,102,38,63,205,204,204,61,0,0,0,0,102,102,102,63,102,102,102,63,102,102,102,63,0,0,0,0,205,204,204,62,205,204,204,62,205,204,204,62,0,0,0,0,0,0,0,63,205,204,76,62,205,204,204,62,0,0,0,0,205,204,76,62,154,153,25,63,205,204,76,63,0,0,0,0,102,102,102,63,205,204,76,62,205,204,204,62,0,0,0,0,0,0,0,0,202,0,0,0,240,0,0,0,131,0,0,0,0,0,0,0,0,0,0,0,44,1,0,0,202,0,0,0,51,3,0,0,202,0,0,0,150,0,0,0,71,0,0,0,44,1,0,0,119,0,0,0,212,0,0,0,69,0,0,0,151,2,0,0,202,0,0,0,156,0,0,0,73,0,0,0,184,1,0,0,202,0,0,0,223,0,0,0,106,0,0,0,44,1,0,0,0,0,0,0,77,1,0,0,119,0,0,0,115,3,0,0,0,0,0,0,122,0,0,0,97,0,0,0,160,0,0,0,77,1,0,0,155,0,0,0,113,0,0,0,0,0,0,0,77,1,0,0,160,0,0,0,125,0,0,0,240,0,0,0,202,0,0,0,200,0,0,0,120,0,0,0,121,2,0,0,0,0,0,0,250,0,0,0,119,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,250,126,16,39,0,0,0,0,139,206,149,186,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,250,126,16,39,1,0,0,0,110,120,24,88,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,46,10,0,0,0,0,0,0,250,126,16,39,2,0,0,0,183,199,37,191,7,53,44,54,42,30,45,11,114,85,151,123,189,21,162,176,153,164,90,248,34,1,82,6,192,151,119,247,166,249,29,207,245,246,91,158,13,15,61,88,31,40,165,36,245,97,54,167,65,29,234,46,38,241,10,168,91,188,98,1,0,114,79,255,78,196,1,192,237,152,84,107,80,39,64,10,0,243,160,226,150,42,153,37,44,235,187,44,235,187,44,223,123,219,8,85,237,138,126,184,132,142,30,227,2,110,73,255,227,98,38,192,38,204,167,140,0,253,219,9,127,94,220,86,86,93,62,205,99,195,180,87,11,75,38,94,45,44,153,120,181,48,144,88,231,202,0,6,114,26,64,78,48,12,133,70,32,161,1,98,73,255,167,232,194,144,0,142,213,0,128,42,131,167,29,222,223,70,173,192,179,19,64,160,6,120,112,108,107,48,53,0,102,147,87,60,125,76,71,7,0,82,71,255,71,104,34,244,232,18,10,199,2,0,144,128,1,19,0,73,67,98,152,194,119,10,173,3,60,0,7,50,77,255,48,5,0,40,48,175,140,49,118,58,172,158,135,105,152,58,99,16,25,90,247,178,161,142,144,76,48,194,153,81,64,71,112,38,72,236,116,69,51,21,1,0,30,73,159,5,127,13,128,3,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,169,173,126,119,0,0,0,0,182,64,118,64,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,169,173,126,119,1,0,0,0,169,113,95,154,14,59,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,43,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,50,48,50,48,51,32,40,79,109,110,105,112,114,101,115,101,110,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181])
.concat([148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,14,20,0,0,0,0,0,0,169,173,126,119,2,0,0,0,234,67,109,75,12,75,76,73,78,73,70,79,74,66,72,71,1,34,79,69,54,24,116,152,153,113,103,159,241,22,188,133,162,234,252,83,127,180,183,46,230,126,107,111,147,242,31,49,206,241,12,72,113,117,203,103,252,248,124,90,224,63,65,5,191,231,92,192,170,168,0,86,42,103,239,11,166,63,221,170,72,140,143,85,42,144,2,95,167,189,211,0,126,113,131,247,136,139,97,66,22,103,186,147,0,20,181,40,187,215,108,166,178,252,216,114,139,15,217,74,138,213,181,193,179,179,226,57,76,65,26,222,16,57,134,178,54,163,127,80,230,34,139,0,172,225,71,132,94,106,73,244,27,205,54,125,11,76,139,106,150,70,174,243,195,82,101,0,106,95,75,118,74,234,214,13,61,221,137,171,197,106,96,67,42,215,121,186,255,220,105,222,238,255,229,129,1,110,137,79,239,75,115,195,245,92,71,111,197,108,220,204,211,84,20,212,193,194,236,218,11,92,201,130,230,82,18,33,102,90,211,156,40,204,198,125,249,36,229,9,0,110,103,14,251,51,104,46,128,51,149,22,32,41,42,79,141,172,201,171,89,214,60,189,219,105,107,168,81,248,20,179,255,94,77,24,18,119,159,31,85,8,93,106,21,160,233,11,230,151,101,186,153,69,93,83,240,102,123,130,51,167,250,206,23,89,243,40,148,12,105,241,32,186,54,152,176,186,6,82,91,161,242,199,129,6,29,186,90,30,117,6,128,146,114,21,243,127,182,127,165,180,122,223,165,53,211,212,171,170,166,249,201,110,117,179,6,29,204,68,248,188,32,152,160,27,150,233,251,169,225,209,49,113,79,63,33,104,202,17,193,38,48,139,120,161,176,163,148,246,224,0,54,93,44,38,12,84,208,112,198,242,4,36,169,106,243,203,22,21,209,175,81,178,248,223,177,37,183,29,203,2,81,239,118,209,152,163,66,63,139,94,211,11,134,45,133,169,199,40,93,135,71,76,217,204,194,228,127,38,147,59,250,109,10,54,134,48,173,208,82,1,54,97,198,70,12,204,54,161,90,154,0,158,80,212,146,247,200,255,49,167,181,154,172,127,76,200,133,212,198,136,251,172,33,181,135,248,73,149,152,22,78,90,231,162,6,203,211,76,202,158,102,40,228,34,76,32,126,82,80,206,196,83,11,251,96,190,116,148,219,240,28,197,187,183,197,108,211,237,0,42,89,161,231,55,1,162,117,6,111,43,38,215,155,131,241,235,205,190,35,187,190,88,31,115,179,124,90,140,255,161,95,102,216,5,41,173,159,82,77,143,120,29,130,196,52,218,35,135,34,198,222,26,132,66,116,6,102,75,49,54,201,112,100,57,1,150,208,11,252,76,54,113,0,26,101,80,248,32,32,2,170,167,202,173,170,60,124,238,97,43,156,93,40,76,250,56,118,41,77,158,5,169,50,196,218,44,220,58,99,27,76,232,141,44,133,150,153,192,21,36,66,185,38,28,45,29,40,155,166,214,30,135,27,100,201,150,182,2,0,26,91,133,244,67,8,17,38,121,91,41,170,55,243,221,233,242,97,28,156,158,69,225,108,111,202,175,175,78,151,95,157,46,97,46,21,154,151,39,96,104,39,186,177,59,147,31,178,161,163,36,27,19,48,141,99,55,105,232,138,55,108,230,176,128,26,38,99,142,208,38,0,26,75,38,22,20,145,202,164,83,170,103,166,218,103,197,211,171,135,188,236,117,61,12,85,59,86,54,221,208,13,161,81,149,173,1,37,113,53,123,216,225,73,81,192,86,52,104,24,8,48,83,135,49,232,192,112,119,213,198,152,77,8,64,45,109,134,170,222,171,10,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,156,0,1,84,0,0,0,0,45,235,154,44,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,156,0,1,84,1,0,0,0,230,18,26,121,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,235,62,0,0,0,0,0,0,156,0,1,84,2,0,0,0,149,111,120,2,33,58,55,56,55,57,62,58,53,57,53,53,52,54,52,46,49,46,46,46,54,42,52,38,32,44,48,55,49,56,54,52,57,24,30,67,59,231,166,40,42,82,183,207,118,181,88,21,6,32,157,202,176,213,249,255,117,145,164,166,105,32,252,251,174,12,208,151,142,54,62,26,24,108,241,185,149,0,48,1,246,31,11,21,43,147,11,147,80,1,47,0,22,67,193,201,60,21,61,91,114,170,172,79,240,25,128,50,101,216,123,243,100,176,230,51,64,103,113,123,161,58,192,55,234,77,38,44,28,154,185,3,138,49,131,36,0,190,67,75,251,179,48,108,110,73,0,42,69,110,228,173,121,207,135,187,46,159,172,19,174,138,3,200,84,134,35,63,243,6,196,187,244,196,248,134,217,8,64,98,32,42,116,115,22,116,16,45,39,77,47,129,64,167,104,120,157,73,204,123,122,20,2,46,65,174,211,70,102,189,19,53,136,79,184,42,2,16,68,149,225,232,159,43,117,224,232,219,230,230,116,231,37,48,151,129,193,81,128,135,142,174,105,18,10,2,217,92,239,254,51,116,154,69,230,39,9,1,54,69,201,64,149,230,153,38,43,93,150,106,113,23,0,170,50,230,104,255,107,5,44,199,207,231,226,39,218,3,208,59,117,135,65,154,112,157,68,209,233,120,56,128,130,4,77,198,194,155,202,75,219,202,142,114,0,46,73,108,144,229,246,142,56,166,14,222,84,11,186,76,0,73,148,203,48,145,102,122,16,33,176,4,191,65,199,38,88,40,189,229,36,10,11,161,53,243,164,127,60,62,234,220,95,32,205,117,37,75,139,102,254,116,125,76,17,18,0,42,65,170,97,44,231,117,182,186,53,106,65,181,144,77,5,128,171,50,252,179,166,61,35,96,187,138,243,213,83,159,0,24,112,230,53,161,201,172,52,192,65,131,132,99,246,114,20,192,29,64,165,20,194,44,45,131,0,62,67,110,77,173,211,136,23,11,93,87,179,84,11,26,9,160,68,25,213,124,255,180,5,60,215,234,147,104,139,215,62,160,99,163,109,240,179,10,34,29,144,244,29,7,208,129,160,112,217,204,164,3,70,69,233,64,53,179,67,119,90,127,105,157,174,22,211,165,5,160,42,195,247,101,13,152,116,182,74,74,45,42,0,115,54,114,79,96,101,60,160,128,54,66,195,67,49,210,187,6,120,120,173,67,247,100,149,12,30,82,65,109,81,159,98,79,135,33,187,28,78,160,10,0,42,17,56,82,221,59,240,235,170,76,157,87,148,4,64,159,246,26,85,72,159,137,7,50,59,5,233,186,58,166,135,14,54,179,146,138,166,37,86,75,99,211,207,180,67,112,240,46,71,231,170,22,212,5,192,17,85,80,199,45,107,159,21,28,13,172,99,54,21,89,80,196,10,148,161,7,212,209,114,2,208,18,93,177,6,20,82,155,192,31,76,90,67,75,74,11,70,168,150,30,251,233,149,213,226,41,6,160,76,129,118,235,207,183,7,87,163,72,140,78,2,216,229,20,177,133,169,3,250,32,26,58,209,227,90,0,196,141,50,113,15,208,1,106,73,199,142,110,218,136,213,210,223,122,84,11,122,2,128,171,2,111,215,77,14,190,115,245,209,5,130,173,128,45,174,150,206,202,97,67,13,168,210,208,47,13,137,9,90,127,9,26,83,194,9,232,9,102,87,187,89,188,225,142,155,251,165,71,181,32,3,128,154,4,56,190,115,171,6,243,100,101,35,49,158,248,0,255,160,150,208,129,141,194,4,24,113,100,239,69,52,159,169,8,73,118,38,28,0,110,91,235,141,176,139,179,227,92,205,35,82,45,232,27,128,86,1,172,191,211,10,150,55,193,24,225,201,6,190,112,71,128,161,175,1,136,232,2,32,76,94,178,35,209,1,110,91,227,94,60,155,21,168,133,186,141,200,9,174,6,160,42,152,175,251,246,4,166,75,52,181,248,54,23,0,97,150,141,13,232,224,128,249,0,244,192,125,3,56,202,149,0,8,0,102,87,187,189,227,142,126,71,173,37,125,8,186,227,4,123,41,0,132,41,3,211,252,142,175,131,58,12,145,147,164,151,164,192,70,240,184,66,25,3,248,166,16,56,208,72,134,93,167,29,187,197,167,82,19,58,223,84,11,139,3,80,38,3,166,89,110,25,184,186,4,38,244,186,8,40,224,139,117,224,27,176,9,186,9,132,210,97,42,112,192,3,138,93,151,27,108,99,13,135,245,209,150,85,45,68,241,0,36,10,32,221,143,115,32,238,129,188,184,226,12,208,253,183,47,93,7,48,91,194,17,27,29,239,128,130,194,4,110,73,183,1,67,179,236,228,214,178,238,60,193,3,0,85,129,234,183,179,129,117,207,83,97,119,46,221,69,39,129,27,122,102,126,131,221,48,160,175,132,14,218,41,9,180,137,4,2,193,44,60,19,0,130,83,247,29,191,209,28,244,181,135,99,120,23,0,148,9,224,139,231,12,168,72,56,246,236,24,144,154,155,105,91,129,108,96,150,211,41,30,60,78,113,0,102,75,251,1,183,75,155,156,215,109,51,175,42,112,249,230,255,254,171,161,21,32,241,50,47,41,133,21,125,16,108,193,162,106,215,105,18,244,134,174,11,40,74,129,7,108,19,138,149,116,135,0,122,97,215,181,249,81,238,196,44,53,203,49,188,47,0,16,101,0,106,150,61,129,72,192,254,18,116,165,2,2,0,83,223,72,240,0,166,4,130,103,183,123,245,70,14,76,85,83,142,33,250,122,2,16,140,0,168,251,181,1,18,208,26,192,100,42,29,160,65,0,106,91,215,193,241,36,91,184,253,186,135,106,65,39,1,72,152,0,211,124,111,6,74,97,15,161,75,166,161,19,77,251,185,146,18,79,51,209,21,175,16,226,160,3,114,87,231,129,254,15,24,206,123,44,150,85,45,188,14,0,204,148,129,137,243,184,26,0,84,246,243,28,176,196,166,26,90,123,96,42,18,78,130,71,16,104,240,116,7,255,64,1,106,89,183,165,203,199,53,193,76,127,37,200,63,134,247,243,0,84,5,158,230,184,192,164,132,95,133,106,194,135,128,62,204,124,58,128,190,194,110,210,178,220,66,159,52,173,248,209,138,201,196,108,28,9,18,94,93,151,101,240,78,197,48,43,127,57,162,199,160,223,9,64,149,1,235,254,156,0,208,99,191,100,224,154,64,229,159,135,78,121,200,86,76,107,134,30,211,132,142,137,63,20,60,0,82,69,119,132,186,241,155,58,241,228,212,9,78,16,89,0,208,170,140,73,247,246,15,144,22,168,167,31,189,72,132,81,232,131,133,198,63,0,178,213,35,140,242,102,2,5,48,81,58,93,215,96,42,201,75,0,90,63,63,32,183,150,86,105,127,11,51,39,88,7,0,85,25,150,99,62,96,157,72,119,42,186,174,175,36,20,10,182,1,55,15,208,177,205,130,128,223,100,11,209,181,232,110,2,113,224,121,2,56,0,78,65,79,141,199,248,163,107,130,31,241,84,47,213,194,59,9,64,194,148,225,89,178,46,129,152,165,66,1,186,106,128,159,231,248,73,196,4,33,193,203,2,192,214,236,243,109,106,30,62,120,0,66,69,159,197,252,65,9,209,105,235,50,159,241,110,125,0,0,34,51,25,154,165,149,96,44,203,42,194,78,248,219,132,204,216,214,89,132,214,61,116,7,7,71,90,192,195,68,184,32,103,70,154,84,20,17,38,0,34,79,127,73,4,0,15,115,0,100,128,233,249,226,117,108,2,38,31,148,7,208,96,2,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,92,24,108,65,0,0,0,0,211,37,104,37,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,92,24,108,65,1,0,0,0,246,240,222,14,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,75,70,0,0,0,0,0,0,92,24,108,65,2,0,0,0,137,58,189,245,37,74,50,44,49,46,56,49,38,42,44,37,29,31,55,43,55,46,40,42,48,44,53,50,54,55,57,54,58,58,53,55,62,54,50,56,49,10,34,69,151,140,101,130,96,72,204,213,194,203,129,140,36,85,53,71,214,220,34,69,218,178,61,203,242,84,42,149,250,249,237,231,39,217,214,102,179,217,108,54,101,235,21,158,82,40,239,253,191,173,44,192,231,32,232,69,162,148,65,169,235,146,78,239,82,87,71,38,41,245,14,0,54,67,87,229,188,79,99,234,102,228,252,168,22,234,4,128,168,130,210,101,9,248,129,24,166,124,176,3,22,168,83,165,43,116,64,161,97,43,137,14,141,108,160,235,109,113,15,210,53,13,78,67,63,136,44,210,171,192,154,99,236,9,128,170,64,234,179,28,0,76,0,10,79,153,22,240,97,180,177,137,2,73,145,13,148,217,26,13,192,116,39,53,18,18,102,71,31,196,123,109,37,224,45,17,31,67,7,0,74,82,224,122,19,0,154,223,4,8,6,120,161,108,210,251,2,135,25,0,36,155,195,82,227,150,20,223,97,128,109,180,212,152,0,106,71,247,99,28,55,81,23,133,38,233,128,99,104,1,160,68,25,218,163,1,64,248,165,37,192,181,4,110,19,244,66,61,104,18,212,86,242,64,211,129,155,0,120,1,0,98,67,119,193,120,191,197,172,30,63,249,230,106,33,3,0,85,25,222,223,25,32,207,104,101,243,83,12,240,221,85,11,47,249,145,231,30,171,39,165,204,0,73,7,83,131,16,104,131,82,15,232,140,21,20,0,86,69,251,68,254,62,166,17,221,210,153,150,173,99,188,106,1,80,166,32,29,107,4,32,97,208,118,3,104,250,21,36,197,145,12,147,20,87,84,154,19,26,40,29,240,188,214,52,0,134,95,143,163,214,76,25,184,85,146,99,40,15,0,85,128,105,246,61,1,128,18,0,214,14,152,4,174,144,158,150,104,120,0,154,2,40,0,134,89,143,163,207,249,166,22,138,227,224,24,106,0,40,99,12,168,236,40,0,214,44,173,65,204,165,98,142,165,6,216,114,179,131,218,228,2,26,252,1,4,126,93,119,139,114,191,213,19,183,132,106,97,5,0,82,38,64,179,238,211,96,4,168,200,77,223,0,179,186,26,247,236,86,7,19,164,198,25,4,30,184,4,19,0,138,93,151,123,235,243,81,255,184,149,9,199,80,21,0,144,16,6,80,241,85,0,88,172,125,5,56,108,180,18])
.concat([0,90,210,36,112,197,3,134,101,247,123,178,93,216,56,218,58,57,134,182,0,128,12,0,48,181,130,9,224,58,0,185,50,1,104,0,154,99,239,201,126,223,230,19,7,63,255,197,49,244,35,1,104,16,0,96,64,2,220,54,64,57,59,115,194,113,0,122,79,167,197,179,63,174,111,236,76,132,230,83,101,160,95,245,170,179,91,24,123,142,21,207,166,83,0,152,193,15,252,13,183,68,131,51,1,114,152,196,146,166,79,167,40,204,69,90,153,166,160,11,133,14,130,85,151,71,121,159,106,226,120,80,45,212,192,64,89,5,160,214,166,73,168,37,11,204,30,151,135,6,88,152,67,231,217,238,130,198,0,58,1,48,129,42,0,118,73,167,65,121,191,189,188,131,219,12,172,79,176,10,36,164,42,240,165,181,32,91,215,100,134,165,244,83,1,48,183,15,134,168,135,177,14,63,5,167,107,69,130,25,0,111,26,104,160,127,226,129,4,0,142,89,151,59,227,126,204,55,30,134,236,19,180,128,128,68,1,106,137,37,48,233,222,210,210,88,58,71,22,112,76,23,209,97,243,64,122,167,129,194,161,211,187,128,130,14,146,95,167,147,113,126,76,39,134,180,228,24,107,0,1,5,3,240,189,50,88,254,80,13,219,13,172,21,123,119,49,253,166,4,5,253,153,7,26,0,126,87,155,203,9,183,105,97,40,7,231,28,67,221,3,3,78,20,160,186,229,158,224,153,150,126,44,2,36,163,249,246,0,201,21,56,93,2,4,60,128,7,126,93,251,35,214,219,165,97,68,223,38,170,133,236,0,3,87,198,128,231,249,23,172,223,2,85,153,35,2,136,180,45,107,198,6,134,0,19,13,38,30,0,147,73,122,215,145,0,126,93,167,61,223,183,217,49,153,251,44,171,90,232,5,0,156,200,0,166,173,246,133,182,205,32,73,242,116,5,34,209,94,123,32,212,2,205,3,116,38,128,131,7,138,83,215,13,191,111,151,69,157,158,83,56,134,38,128,0,87,5,245,238,87,11,77,62,201,237,199,175,0,235,29,239,6,5,88,118,160,128,84,104,148,146,64,42,180,41,184,227,121,251,0,29,0,110,79,235,133,127,110,115,3,62,71,139,156,160,147,0,112,149,129,90,191,102,9,92,111,135,154,106,192,47,235,94,50,64,213,7,15,76,42,14,65,79,14,219,104,169,104,4,46,117,0,118,77,155,141,82,30,151,141,117,7,139,106,177,229,129,64,85,224,203,159,123,130,252,159,156,229,241,3,96,101,160,184,149,244,12,130,190,56,129,164,218,209,81,56,58,73,29,197,195,101,49,1,19,0,102,75,251,153,110,167,151,29,157,175,245,27,85,11,47,38,0,85,65,45,199,173,131,120,219,114,155,161,18,45,2,188,52,216,119,129,146,208,241,13,108,130,202,70,73,0,166,77,10,244,144,10,80,152,0,86,73,195,32,247,22,22,118,62,135,138,108,92,162,140,235,225,168,209,163,224,182,234,52,209,82,159,27,2,168,45,94,138,26,151,161,80,2,19,68,3,76,148,219,34,157,27,155,92,47,59,166,139,174,67,52,0,82,65,97,230,235,45,174,106,191,94,90,186,90,104,7,12,202,148,97,107,178,45,240,254,4,150,240,42,191,7,16,216,52,3,86,3,136,87,106,32,219,55,134,75,41,224,1,169,48,245,62,37,40,0,98,67,235,81,25,183,56,170,173,125,164,90,56,48,224,170,140,218,223,37,15,124,231,23,137,77,124,22,109,64,239,109,158,155,65,152,56,16,10,106,233,224,20,248,91,193,193,164,105,64,41,11,186,130,162,159,20,0,74,67,173,99,229,175,175,106,203,153,212,186,90,8,1,6,174,202,152,245,105,247,132,122,68,240,86,106,35,0,61,118,114,85,54,80,74,128,143,38,179,236,211,142,0,26,250,11,0,16,141,105,74,243,124,209,59,9,74,67,109,102,254,232,173,219,57,115,115,12,23,0,184,42,67,243,217,19,244,91,195,74,221,53,64,114,3,27,128,90,30,131,217,113,97,49,1,88,38,30,26,96,130,169,37,61,123,79,145,160,1,66,75,229,44,243,97,14,156,137,89,170,50,220,25,53,82,113,198,246,136,96,145,42,0,191,74,234,169,107,20,14,132,66,160,164,8,148,186,253,254,90,157,17,133,172,17,205,130,248,184,70,241,85,13,10,58,73,106,109,236,159,208,176,229,188,108,161,99,200,76,0,106,202,152,236,104,154,4,111,181,225,183,211,6,0,102,218,24,48,86,3,7,38,176,184,41,63,38,155,69,28,231,70,130,206,122,209,153,243,130,230,205,141,141,151,167,1,38,67,174,147,242,22,239,110,85,53,81,45,68,30,128,68,101,248,170,174,28,213,198,134,177,166,175,4,240,138,149,222,60,75,209,65,235,7,58,38,166,32,225,105,236,36,101,145,226,194,66,71,58,0,22,67,174,100,124,104,213,97,91,242,24,210,0,168,68,198,204,211,46,9,190,37,75,54,24,83,128,195,212,41,52,19,78,52,209,214,64,192,155,80,184,164,255,70,135,148,160,164,6,0,38,65,163,114,230,71,207,106,189,117,150,52,230,49,180,0,80,149,49,89,44,181,193,47,239,194,13,183,97,0,218,0,152,37,37,114,99,234,133,94,152,18,7,186,139,70,226,64,129,232,90,183,196,132,158,0,34,67,199,80,248,27,68,14,163,106,161,209,0,80,21,152,154,148,129,107,221,96,91,222,1,64,239,119,244,108,87,157,147,4,37,129,156,128,100,51,18,240,58,230,87,152,62,64,0,34,75,191,16,1,192,3,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,104,227,5,119,0,0,0,0,48,14,62,31,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,104,227,5,119,1,0,0,0,3,208,120,235,14,59,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,43,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,50,48,50,48,51,32,40,79,109,110,105,112,114,101,115,101,110,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,219,22,0,0,0,0,0,0,104,227,5,119,2,0,0,0,136,97,246,64,13,75,75,72,79,68,74,77,69,71,74,69,74,63,22,83,117,6,139,41,64,111,157,234,89,8,215,105,252,248,194,211,111,84,238,120,199,237,16,95,198,71,138,116,130,11,29,53,113,245,175,167,83,176,138,5,40,252,233,95,204,97,141,96,202,177,79,153,131,86,5,79,127,175,156,222,255,48,24,95,197,5,194,116,168,83,24,31,1,122,101,199,190,5,160,130,209,171,86,213,242,22,64,42,215,250,103,253,237,108,82,124,123,183,173,149,237,34,202,98,97,32,111,94,204,172,132,253,247,237,105,168,25,149,217,170,108,100,193,18,144,198,40,87,242,108,147,178,175,113,5,130,17,38,204,54,119,8,219,254,104,40,65,2,106,97,251,158,143,170,148,62,60,140,92,245,162,106,255,252,170,52,236,111,95,223,157,50,138,67,15,54,83,212,208,184,230,37,211,209,1,103,244,69,66,198,109,188,38,97,25,88,215,204,118,233,75,226,120,83,218,233,105,4,160,141,133,199,186,49,48,11,151,51,117,0,78,91,42,250,161,21,42,152,188,39,51,57,64,73,83,235,248,178,95,122,175,61,95,171,206,243,184,255,92,189,243,156,186,174,49,103,89,91,62,31,194,253,239,69,39,145,163,107,226,190,178,14,234,237,61,59,60,45,38,171,32,21,3,162,245,210,154,57,213,3,58,123,222,175,23,242,121,4,0,74,101,166,80,82,68,153,0,243,41,51,179,254,83,143,92,159,95,199,180,55,151,47,223,140,197,118,109,249,237,253,178,123,246,65,193,29,99,76,182,26,7,120,184,106,143,42,5,200,205,51,225,41,70,103,60,191,105,41,202,37,60,53,243,186,66,149,4,54,93,105,237,161,34,116,48,126,213,238,17,4,12,82,53,191,154,61,178,148,68,250,182,61,107,153,236,85,63,153,238,180,235,49,164,178,158,44,137,38,15,245,89,234,37,160,84,109,124,74,99,108,27,197,43,122,206,198,86,191,22,10,9,77,125,87,36,155,39,7,131,4,0,42,95,162,239,173,1,209,38,121,243,117,154,250,190,45,12,253,175,244,158,11,195,237,88,15,211,91,212,251,85,100,237,31,252,139,65,58,101,134,137,238,134,252,32,67,164,98,2,71,197,2,14,164,182,60,65,239,235,87,240,213,36,163,40,120,216,125,81,135,84,105,10,206,96,25,60,0,30,87,100,234,77,64,237,32,175,122,170,90,248,188,56,57,127,189,196,188,195,205,113,33,152,103,197,198,46,169,24,174,74,69,47,109,94,124,251,55,90,48,248,52,56,110,144,120,50,233,152,93,242,210,85,109,50,29,107,51,161,79,191,41,103,163,33,105,0,30,103,124,234,13,32,48,105,216,170,210,212,60,149,174,211,240,46,248,239,118,40,214,33,136,209,174,117,254,90,85,36,141,226,246,156,188,178,247,145,108,92,53,239,95,67,239,86,44,128,99,153,78,71,233,2,62,118,52,200,60,37,116,129,201,242,15,122,46,20,0,22,105,182,239,1,160,129,245,124,81,139,113,243,50,221,212,85,95,189,124,46,159,46,110,44,39,79,150,23,186,200,43,60,73,139,137,21,120,189,94,84,76,190,164,111,192,237,128,97,244,15,55,86,128,108,165,243,154,14,166,231,12,198,134,188,115,171,72,222,12,61,209,4,0,14,83,162,231,141,9,116,208,184,122,42,215,211,229,218,84,172,30,78,21,79,93,117,173,85,183,162,170,56,34,84,116,128,93,62,223,171,242,115,54,142,17,87,12,115,48,214,126,84,2,38,133,83,111,22,112,82,135,196,172,192,233,38,168,103,73,50,53,0,22,91,46,251,84,55,171,139,87,102,51,95,212,146,198,198,230,177,123,91,59,123,30,169,94,57,39,239,253,245,204,230,155,72,252,237,80,164,6,78,139,249,221,208,121,13,130,98,37,76,225,143,96,30,69,65,254,176,138,135,59,210,33,119,84,155,5,215,138,112,211,248,44,3,30,61,199,170,138,38,82,89,55,84,162,20,77,101,217,126,127,151,229,162,247,75,90,180,159,164,249,146,150,1,222,219,134,183,217,6,98,92,95,3,240,67,173,193,184,195,0,178,124,30,192,244,92,242,235,236,0,20,237,170,182,75,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,2,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,4,1,0,0,0,0,0,0,0,0,3,5,5,5,5,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,5,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,6,15,20,22,22,22,22,22,19,13,3,0,0,0,0,0,0,0,0,0,0,0,8,18,25,27,27,27,22,14,4,0,0,0,0,0,0,0,0,0,9,19,27,27,25,20,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,21,26,27,26,17,8,0,0,0,0,0,0,0,7,19,27,30,30,30,29,27,23,17,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,19,24,27,29,30,30,30,26,16,4,0,0,0,0,8,20,27,30,30,30,30,30,30,30,30,30,30,26,17,5,0,0,0,0,5,16,24,27,27,27,27,26,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,19,27,30,30,30,30,30,30,30,30,30,30,26,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,26,27,27,27,27,23,14,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,29,30,30,30,30,27,19,7,0,0,0,0,0,0,0,0,0,0,0,2,15,22,25,25,25,25,25,25,21,12,0,0,0,0,0,13,27,38,45,48,48,48,48,48,44,35,24,10,0,0,0,0,0,0,0,0,2,17,30,40,48,52,53,50,45,36,24,10,0,0,0,0,0,0,12,22,31,41,49,53,50,41,26,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,29,42,51,53,49,40,30,21,11,0,0,0,0,7,26,40,49,53,53,53,53,50,46,40,31,20,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,32,41,47,51,53,53,53,53,48,37,22,3,0,0,11,28,41,50,53,53,53,53,53,53,53,53,53,53,48,37,24,7,0,0,7,22,36,46,50,50,50,50,49,42,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,38,49,53,53,53,53,53,53,53,53,53,53,49,38,24,7,0,0,0,0,0,0,0,0,0,0,0,0,9,26,40,48,50,50,50,50,45,33,17,0,0,0,0,0,0,0,0,0,0,0,13,31,44,51,53,53,53,53,49,40,26,9,0,0,0,0,0,0,0,0,0,6,22,38,47,50,50,50,50,50,50,45,33,19,0,0,0,12,29,45,59,69,73,73,73,73,73,67,56,42,25,0,0,0,0,0,0,0,2,19,37,51,63,72,76,78,75,67,57,44,28,11,0,0,0,4,20,34,44,54,63,73,78,73,60,43,24,4,0,0,0,0,0,0,0,0,0,0,0,0,7,26,45,62,73,78,71,62,53,43,33,19,0,0,0,21,41,58,72,78,78,78,77,75,70,63,54,40,26,8,0,0,0,0,0,0,0,0,0,0,0,0,10,27,42,55,64,71,75,77,78,78,78,71,55,37,16,0,6,25,43,60,73,78,78,78,78,78,78,78,78,78,78,71,56,39,21,0,1,20,39,56,70,76,76,76,76,74,64,49,31,11,0,0,0,0,0,0,0,0,0,0,0,2,23,41,58,72,78,78,78,78,78,78,78,78,78,78,71,56,41,21,0,0,0,0,0,0,0,0,0,0,0,1,23,43,61,73,76,76,76,75,67,53,33,13,0,0,0,0,0,0,0,0,0,7,28,47,65,76,78,78,78,78,73,60,43,22,1,0,0,0,0,0,0,0,0,20,39,58,71,76,76,76,76,76,75,67,53,35,13,0,0,21,41,59,77,92,99,99,99,99,98,89,73,55,36,0,0,0,0,0,0,0,16,36,53,69,84,94,101,101,98,89,76,62,44,26,5,0,0,17,36,53,66,75,85,95,101,94,76,56,36,16,0,0,0,0,0,0,0,0,0,0,0,0,19,39,59,79,95,101,93,84,74,65,51,34,15,0,7,29,53,74,92,101,101,101,101,98,93,85,74,58,42,24,4,0,0,0,0,0,0,0,0,0,0,7,26,44,60,76,86,94,99,101,101,101,101,89,70,49,24,0,14,34,56,76,94,101,101,101,101,101,101,101,101,101,101,89,70,51,29,0,9,29,51,72,91,101,101,101,101,97,81,62,41,20,0,0,0,0,0,0,0,0,0,0,0,9,32,53,73,91,101,101,101,101,101,101,101,101,101,101,91,72,51,29,0,0,0,0,0,0,0,0,0,0,0,9,33,55,77,95,101,101,101,101,87,67,44,21,0,0,0,0,0,0,0,0,0,16,39,60,81,99,104,104,104,104,94,75,53,32,9,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,99,99,98,87,66,45,21,0,0,25,45,65,86,106,124,124,124,124,121,101,81,60,40,0,0,0,0,0,0,5,27,48,69,87,103,116,124,124,121,110,94,78,58,38,16,0,6,28,49,69,87,98,107,116,129,108,88,69,48,28,7,0,0,0,0,0,0,0,0,0,0,11,31,50,71,91,110,124,115,106,97,85,67,47,25,0,10,33,58,81,104,129,129,129,124,121,116,107,92,76,57,37,16,0,0,0,0,0,0,0,0,0,0,19,40,59,78,94,108,117,121,124,129,129,121,99,76,53,27,0,17,38,60,83,106,129,129,129,129,129,129,129,129,129,121,99,76,55,33,0,12,35,58,78,101,123,124,124,124,114,92,70,49,27,5,0,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,129,129,129,129,129,129,129,129,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,16,40,63,87,110,124,124,124,121,98,73,48,25,0,0,0,0,0,0,0,0,0,20,43,66,88,111,129,129,129,129,104,81,58,35,12,0,0,0,0,0,0,0,7,32,55,81,103,124,124,124,124,124,121,98,73,50,25,0,0,25,45,66,86,106,129,149,152,144,121,101,81,60,40,0,0,0,0,0,0,12,35,57,80,100,121,138,149,152,144,130,110,90,69,46,24,0,9,32,55,78,100,119,132,140,141,121,100,80,59,39,19,0,0,0,0,0,0,0,0,0,0,21,41,63,83,103,123,144,139,130,117,98,75,52,30,0,10,33,58,81,104,129,152,152,152,147,140,129,109,90,70,48,25,4,0,0,0,0,0,0,0,0,7,29,50,72,92,112,129,141,147,152,152,149,121,99,76,53,27,0,17,38,60,83,106,129,152,152,152,152,152,152,152,147,121,99,76,55,33,0,9,32,54,76,98,119,143,152,144,119,98,77,55,33,11,0,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,152,152,152,152,152,152,147,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,22,46,69,93,116,141,152,142,116,93,70,46,23,0,0,0,0,0,0,0,0,7,20,43,66,88,111,137,154,152,129,104,81,58,35,20,9,0,0,0,0,0,0,7,33,55,81,104,129,152,152,152,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,17,40,63,86,109,132,154,171,175,164,144,119,98,75,51,27,0,9,31,54,77,98,118,140,161,154,134,112,91,71,49,29,8,0,0,0,0,0,0,0,0,11,32,53,73,93,115,136,156,158,138,116,96,74,52,29,0,10,33,58,81,104,129,142,144,153,168,161,143,121,100,78,56,33,11,0,0,0,0,0,0,0,0,14,37,59,81,104,124,146,162,164,152,144,142,121,99,76,53,27,0,17,38,60,83,106,129,142,142,142,142,143,158,170,147,121,99,76,55,33,0,4,26,48,70,92,114,137,159,150,129,105,83,61,40,17,0,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,155,142,142,142,142,142,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,4,28,52,75,99,121,147,159,137,111,88,64,40,17,0,0,0,0,0,0,0,14,27,40,49,66,88,111,137,160,152,129,104,81,61,52,42,30,17,4,0,0,0,0,7,33,55,81,104,129,154,175,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,17,40,63,86,109,134,157,180,185,169,147,121,99,76,50,27,0,4,25,46,66,87,107,129,149,165,145,123,101,81,61,40,19,0,0,0,0,0,0,0,0,22,42,63,83,105,124,147,167,146,124,105,84,64,44,23,0,9,32,57,80,101,116,116,119,134,152,173,154,132,108,85,62,39,16,0,0,0,0,0,0,0,0,19,42,65,89,111,136,157,170,148,130,119,116,115,97,75,52,27,0,17,37,60,82,104,116,116,116,116,116,129,152,170,147,121,99,76,55,33,0,0,20,41,64,85,107,132,152,155,134,111,90,67,46,24,2,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,116,116,116,116,115,99,77,55,32,0,0,0,0,0,0,0,0,0,0,11,35,58,81,106,130,153,152,130,105,81,58,34,11,0,0,0,0,0,0,17,33,48,60,72,81,90,111,137,160,152,129,104,91,84,74,63,50,37,24,8,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,14,37,61,83,106,129,146,160,162,154,137,116,94,72,49,26,0,0,14,34,55,75,96,116,139,160,156,135,113,91,70,49,28,7,0,0,0,0,0,0,9,31,52,73,95,115,137,158,157,137,114,93,73,53,32,12,0,4,26,49,69,84,91,93,98,119,143,165,160,137,113,89,66,43,20,0,0,0,0,0,0,0,0,22,45,68,93,116,140,163,162,139,116,97,93,91,81,64,45,21,0,12,31,51,71,86,91,91,91,91,106,129,152,170,147,121,99,76,55,33,0,0,13,35,57,79,101,123,146,162,140,117,96,74,52,30,8,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,91,91,91,91,83,67,47,26,0,0,0,0,0,0,0,0,0,0,17,41,65,88,111,137,160,147,121,98,75,52,28,4,0,0,0,0,0,16,33,49,65,81,94,104,114,119,137,160,152,129,121,115,107,96,84,71,58,42,26,10,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,9,31,53,74,94,112,124,136,137,132,118,103,84,64,42,20,0,0,3,23,44,65,86,107,129,150,166,145,121,101,80,58,37,16,0,0,0,0,0,0,19,40,62,82,104,124,147,169,147,124,104,83,62,41,21,0,0,0,16,35,52,64,68,68,91,114,139,162,162,139,114,91,68,43,20,0,0,0,0,0,0,0,0,22,48,71,93,116,142,166,160,137,111,88,68,68,62,49,31,11,0,1,20,38,54,64,68,68,68,83,106,129,152,170,147,121,99,76,55,33,0,0,7,29,51,73,95,116,139,162,147,124,101,80,59,36,15,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,68,68,68,62,51,34,16,0,0,0,0,0,0,0,0,0,0,24,47,71,93,117,143,164,140,116,93,69,45,22,0,0,0,0,0,12,31,50,67,83,99,114,129,138,144,152,167,162,151,147,139,130,117,105,91,76,60,44,25,5,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,0,21,41,60,78,92,104,111,111,108,99,85,69,51,31,11,0,0,0,13,34,55,76,98,118,142,163,154,132,110,89,67,45,24,2,0,0,0,0,5,27,49,71,92,113,136,157,160,139,116,94,73,52,31,10,0,0,0,1,18,31,40,43,66,88,111,139,162,165,140,114,91,68,45,20,0,0,0,0,0,0,0,0,22,48,71,93,119,144,167,160,134,109,86,63,43,38,28,15,0,0,0,4,20,32,40,43,43,60,83,106,129,152,170,147,121,99,76,55,33,0,0,1,22,45,67,88,110,134,155,153,132,109,86,65,43,21,0,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,43,43,39,30,17,1,0,0,0,0,0,0,0,0,0,6,30,53,77,101,124,149,158,134,109,86,62,39,15,0,0,0,0,3,23,45,64,83,101,117,136,148,160,168,174,173,172,175,170,162,152,139,124,109,94,78,58,36,13,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,0,15,35,53,67,75,81,86,86,85,76,73,60,43,24,4,0,0,0,3,24,46,67,89,110,134,155,163,142,118,97,75,53,32,10,0,0,0,0,13,35,57,79,100,121,145,166,152,130,107,86,65,43,21,0,0,0,0,0,0,9,19,43,66,88,114,139,162,162,139,114,91,68,43,20,0,0,0,0,0,0,0,0,22,48,71,93,116,143,167,160,137,109,86,63,40,16,8,0,0,0,0,0,0,10,17,20,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,16,38,60,82,104,124,149,160,137,114,93,71,49,27,6,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,20,16,8,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,106,132,155,152,129,103,80,56,33,9,0,0,0,0,12,34,55,75,97,116,136,154,169,174,162,153,149,147,150,155,163,172,159,144,129,110,88,65,40,17,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,1,24,46,67,87,100,101,101,101,101,101,94,76,56,34,12,0,0,0,0,16,37,59,81,102,124,148,171,149,129,105,83,61,39,17,0,0,0,0,20,43,65,87,108,132,153,167,144,121,99,77,56,34,13,0,0,0,0,0,0,0,20,43,66,91,114,139,162,162,139,114,89,66,43,20,0,0,0,0,0,0,0,0,22,45,70,93,116,142,165,160,137,111,86,63,40,17,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,10,32,54,76,98,119,143,164,144,121,99,77,56,34,12,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,90,113,138,161,146,121,98,73,50,27,3,0,0,0,0,20,42,64,86,107,129,150,169,172,155,140,129,121,121,124,132,141,154,157,139,121,103,84,63,41,16,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,129,129,129,129,129,109,83,60,38,15,0,0,0,0,8,30,52,74,96,118,142,164,157,136,112,90,68,46,23,1,0,0,4,27,49,72,93,116,139,161,160,138,114,93,70,48,26,4,0,0,0,0,0,0,0,21,45,68,91,114,139,163,160,137,111,88,64,40,17,0,0,0,0,0,0,0,0,22,45,68,91,115,139,163,160,137,111,88,63,40,17,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,4,25,48,69,91,114,137,158,150,129,106,84,62,40,18,0,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,96,119,144,163,139,114,91,67,44,20,0,0,0,0,2,25,48,70,93,114,139,160,181,161,139,119,106,98,96,99,107,119,134,141,121,105,87,69,52,31,10,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,152,152,152,134,109,83,60,38,15,0,0,0,0,1,23,45,67,90,112,136,158,164,142,118,96,74,52,30,7,0,0,10,33,55,77,100,121,145,167,155,132,108,86,64,41,20,0,0,0,0,0,0,0,0,22,45,68,93,116,142,165,157,134,109,86,63,40,16,0,0,0,0,0,0,0,0,20,43,66,91,114,139,162,161,137,111,88,66,42,18,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,19,41,63,85,106,130,152,156,135,112,90,69,46,25,3,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,8,31,54,78,101,124,150,156,134,108,85,61,37,14,0,0,0,0,5,28,51,74,97,119,144,167,175,152,130,106,87,75,72,76,86,98,113,123,105,88,71,53,36,18,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,177,157,134,109,83,60,38,15,0,0,0,0,0,17,39,62,84,106,132,153,170,148,124,102,80,57,34,12,0,0,15,38,61,83,106,129,152,173,150,124,103,80,58,35,13,0,0,0,0,0,0,0,0,22,45,68,93,116,142,165,157,134,109,84,60,38,15,0,0,0,0,0,0,0,0,18,41,65,88,111,137,160,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,12,35,57,78,101,121,145,163,141,118,97,75,53,31,9,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,14,37,61,85,109,132,156,150,124,101,79,55,31,8,0,0,0,0,7,30,53,76,99,121,147,170,175,149,124,101,79,56,48,53,65,80,93,98,89,72,55,37,20,3,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149])
.concat([165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,11,34,57,79,101,124,148,171,153,132,106,84,62,39,16,0,0,19,42,65,88,109,134,157,167,144,121,98,75,53,31,8,0,0,0,0,0,0,0,0,22,45,71,93,116,142,167,154,132,106,83,59,35,14,5,0,0,0,0,0,0,6,17,40,63,86,110,135,160,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,6,28,50,72,94,116,139,161,147,124,103,81,59,37,16,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,20,44,67,91,114,139,162,144,119,96,73,49,25,2,0,0,0,0,7,30,53,76,99,121,147,169,175,152,130,107,88,73,60,48,46,59,70,73,67,55,38,21,4,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,6,29,52,75,98,119,144,167,157,135,111,88,66,43,20,0,0,23,46,69,91,114,139,160,165,142,116,93,71,48,26,3,0,0,0,0,0,0,0,0,22,45,71,93,116,142,167,154,132,106,83,58,43,37,27,13,0,0,0,0,15,28,38,43,61,86,109,134,157,164,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,22,44,66,88,109,134,155,154,132,109,88,65,44,22,0,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,3,26,50,73,97,121,145,161,138,114,90,66,43,19,0,0,0,0,0,4,27,50,73,96,117,141,163,182,161,141,121,107,93,81,71,60,49,46,50,45,35,21,4,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,3,25,48,71,93,116,142,164,162,139,114,91,69,46,23,0,2,26,49,72,95,117,142,165,160,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,22,45,69,93,116,142,165,155,132,109,86,69,65,59,45,29,10,0,0,12,31,47,60,65,70,88,111,135,159,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,16,38,60,81,103,124,148,160,139,115,93,72,50,28,6,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,9,32,56,80,103,129,152,155,132,107,83,60,36,12,0,0,0,0,0,0,22,45,67,89,110,132,153,171,174,157,141,129,114,103,92,82,72,61,50,38,24,11,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,22,45,68,91,114,139,162,165,142,116,93,71,48,25,0,5,28,51,74,97,119,144,167,159,136,111,88,65,42,19,0,0,0,0,0,0,0,0,0,21,45,68,91,114,139,161,161,139,117,101,93,91,80,63,42,21,0,1,24,45,65,81,91,93,103,119,142,163,158,136,111,88,65,42,19,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,9,32,53,75,97,119,142,163,144,121,100,78,56,35,12,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,15,38,62,86,109,134,157,149,124,101,77,54,30,6,0,0,0,0,0,0,16,37,58,79,99,117,137,155,171,175,161,148,137,124,114,104,93,83,71,58,45,30,13,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,20,43,66,88,111,137,160,167,144,119,96,73,50,27,0,7,30,53,76,99,121,147,170,157,134,109,86,63,40,17,0,0,0,0,0,0,0,0,0,17,40,63,86,108,132,152,167,152,136,121,116,113,96,73,49,27,0,6,29,52,76,98,114,116,124,138,155,165,149,129,106,83,60,38,15,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,3,25,47,69,91,113,136,157,151,129,106,85,63,41,19,0,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,21,45,69,92,115,140,163,143,118,95,71,48,24,0,0,0,0,0,0,0,6,27,47,67,85,103,119,137,152,165,177,170,158,148,138,129,116,105,92,78,64,47,31,14,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,17,40,63,86,109,134,157,170,147,121,99,75,51,27,0,7,31,55,78,101,124,149,172,154,132,106,83,60,38,15,0,0,0,0,0,0,0,0,0,12,33,56,76,98,116,134,145,155,156,147,142,121,99,76,50,27,0,7,30,53,78,101,124,142,147,158,154,144,132,114,96,74,52,31,9,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,19,41,62,85,106,129,151,157,136,113,91,69,47,25,3,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,4,28,51,75,98,121,147,160,137,112,89,65,41,17,0,0,0,0,0,0,0,0,14,33,52,70,87,101,117,132,144,155,165,175,171,161,149,139,124,112,98,82,65,47,29,10,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,17,40,63,86,109,134,157,170,147,121,99,76,53,30,0,9,33,55,78,101,124,149,172,154,132,106,83,60,36,13,0,0,0,0,0,0,0,0,0,4,24,46,66,85,101,114,124,147,170,167,147,121,99,76,50,27,0,7,30,53,78,101,124,149,168,167,144,123,113,99,83,64,44,22,1,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,12,34,56,78,100,121,144,163,142,119,98,75,53,32,9,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,10,34,57,81,104,129,153,154,132,106,82,58,35,11,0,0,0,0,0,0,0,0,0,18,37,53,69,83,97,109,121,134,144,154,165,176,171,159,146,132,116,98,81,62,43,22,2,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,15,38,60,85,109,134,157,170,147,121,99,76,53,30,0,10,33,55,78,101,124,149,172,154,132,105,81,58,35,12,0,0,0,0,0,0,0,0,0,12,34,56,78,99,117,136,147,159,154,144,139,121,99,76,50,27,0,7,30,53,78,101,124,139,145,155,155,147,134,116,97,75,53,32,9,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,6,28,50,72,93,115,139,160,148,124,103,81,60,38,16,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,16,40,64,88,110,136,160,147,123,99,76,52,29,5,0,0,0,0,0,0,0,0,0,3,19,35,50,64,76,88,99,109,119,132,144,155,168,179,166,150,134,114,95,74,54,33,12,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,17,40,63,86,109,134,157,170,147,121,99,76,53,30,0,10,33,55,78,101,124,149,172,154,132,106,83,60,37,13,0,0,0,0,0,0,0,0,0,18,41,64,86,109,132,153,170,152,134,119,113,110,95,73,49,26,0,6,29,51,75,97,111,114,121,136,154,168,150,129,106,84,61,38,15,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,22,43,65,87,109,132,154,155,134,109,88,66,44,22,0,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,0,23,46,70,93,116,142,165,142,116,93,70,46,23,0,0,0,0,0,0,0,0,0,0,0,1,16,30,43,55,66,78,88,98,109,121,135,150,164,181,167,148,129,106,85,64,42,20,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,17,40,63,86,109,134,157,170,147,121,99,76,52,27,0,7,32,55,78,101,124,149,172,154,132,106,83,60,38,15,0,0,0,0,0,0,0,0,0,22,45,68,91,114,139,161,160,139,116,99,90,87,77,61,40,19,0,0,22,42,63,79,88,91,101,119,141,163,159,137,111,88,65,42,19,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,15,37,59,81,103,124,147,161,139,116,94,73,51,28,7,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,5,29,53,76,100,123,147,159,136,110,87,64,40,16,0,0,0,0,0,0,0,0,0,0,7,23,33,37,34,33,45,55,65,76,88,100,114,132,148,167,181,160,138,115,93,70,48,25,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,20,43,66,88,111,137,160,167,144,119,96,73,50,27,0,7,30,53,77,99,121,147,170,157,134,109,86,63,40,17,0,0,0,0,0,0,0,0,0,22,45,70,93,116,142,165,155,132,108,85,66,63,56,44,27,9,0,0,11,29,45,58,63,68,88,111,135,159,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,9,31,53,75,97,118,141,163,145,121,101,79,57,35,13,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,11,35,59,82,106,132,154,152,129,104,81,57,33,10,0,0,0,0,0,0,0,0,0,8,26,42,54,60,59,51,38,33,44,55,67,80,96,114,135,156,179,167,144,119,98,75,52,28,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,0,22,45,68,91,114,139,162,165,142,116,93,71,48,25,0,5,28,51,75,97,119,144,167,160,137,111,88,65,42,19,0,0,0,0,0,0,0,0,0,22,45,71,93,116,142,167,154,132,106,83,58,40,33,23,9,0,0,0,0,11,25,34,40,63,86,109,134,157,164,139,114,91,68,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,3,24,46,69,90,112,135,156,152,130,107,85,63,41,19,0,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,0,17,41,65,88,112,137,160,146,121,98,75,51,27,4,0,0,0,0,0,0,0,0,2,21,41,60,76,85,83,72,59,46,34,33,47,62,81,104,129,152,175,170,147,121,99,76,53,30,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,3,26,48,71,93,116,142,164,162,139,114,91,69,46,22,0,3,26,49,72,95,117,142,165,161,139,114,91,68,45,22,0,0,0,0,0,0,0,0,0,22,45,71,93,116,142,167,154,132,106,83,59,35,12,3,0,0,0,0,0,0,4,17,40,63,86,111,137,160,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,18,40,62,84,106,129,150,158,137,114,91,70,48,25,4,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,1,24,48,72,94,118,143,163,139,116,92,69,45,21,0,0,0,0,0,0,0,0,0,17,36,55,74,93,109,106,92,79,67,57,52,50,57,80,104,129,152,175,169,147,121,99,76,53,29,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,7,29,52,75,98,119,144,167,157,135,111,88,65,43,20,0,0,23,46,69,91,114,138,160,165,142,116,93,72,49,26,3,0,0,0,0,0,0,0,0,22,45,68,93,116,142,165,157,134,109,85,60,38,15,0,0,0,0,0,0,0,0,18,42,65,88,111,137,160,162,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,12,33,56,77,99,121,144,164,143,119,98,76,54,32,10,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,7,30,54,78,101,124,149,157,134,109,86,62,38,15,0,0,0,0,0,0,0,0,10,30,49,69,88,107,124,124,112,100,89,81,76,75,78,90,109,132,155,177,164,142,118,96,73,50,27,0,7,33,55,81,104,129,154,175,172,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,12,35,57,80,101,124,149,172,152,132,106,84,61,39,16,0,0,19,42,65,87,109,134,156,168,145,121,98,76,54,31,8,0,0,0,0,0,0,0,0,22,45,68,93,116,142,165,157,134,109,86,63,40,16,0,0,0,0,0,0,0,0,20,43,66,91,114,139,162,161,137,111,88,66,43,19,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,5,27,49,71,93,114,137,160,149,129,104,82,61,38,16,0,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,13,36,60,84,107,132,155,152,129,103,80,56,32,8,0,0,0,0,0,0,0,0,22,42,63,82,101,119,141,146,135,121,112,104,100,99,101,109,123,143,163,178,156,136,113,91,68,46,23,0,7,33,55,81,104,129,149,149,149,147,121,99,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,0,17,40,62,85,107,132,154,170,147,124,101,80,57,34,11,0,0,15,37,60,83,106,129,151,173,150,129,103,81,58,36,14,0,0,0,0,0,0,0,0,21,45,68,91,114,139,163,160,137,111,88,64,40,17,0,0,0,0,0,0,0,0,22,45,68,91,115,139,164,160,137,111,88,63,40,17,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,21,43,65,86,109,132,153,155,134,110,89,67,45,23,1,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,0,19,43,66,90,114,139,162,145,119,97,73,49,26,2,0,0,0,0,0,0,0,6,29,53,75,95,115,136,154,167,156,145,136,129,124,124,129,134,144,159,177,165,146,124,104,82,61,39,17,0,7,32,55,80,103,121,121,121,121,121,119,98,73,50,25,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,1,24,46,68,90,113,137,159,163,141,117,96,73,51,29,6,0,0,10,32,54,77,99,121,144,167,155,132,109,86,65,42,20,0,0,0,0,0,0,0,0,20,43,66,91,114,139,162,162,139,114,89,66,43,20,0,0,0,0,0,0,0,0,22,45,70,93,116,142,165,160,137,111,86,63,40,17,0,0,0,0,0,0,0,0,0,17,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,15,36,59,80,101,124,147,162,139,116,95,73,51,29,7,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,12,0,0,0,0,0,0,0,1,25,49,73,96,119,144,162,139,114,91,67,43,20,0,0,0,0,0,0,0,0,7,30,53,78,100,119,137,150,162,173,168,160,154,152,150,152,157,165,177,164,148,132,112,92,72,51,30,9,0,4,28,50,73,90,99,99,99,99,99,98,87,66,45,21,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,0,0,5,27,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,8,30,53,75,97,119,142,165,156,135,111,90,67,45,22,0,0,0,4,26,49,71,93,115,138,160,161,139,115,93,71,49,27,5,0,0,0,0,0,2,13,20,43,66,88,114,139,162,162,139,114,91,68,43,20,0,0,0,0,0,0,0,0,22,48,71,93,116,143,167,160,135,109,86,63,39,19,11,0,0,0,0,0,3,14,20,22,38,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,8,30,52,74,96,117,140,162,146,123,101,79,57,35,14,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,35,22,19,12,0,0,0,0,0,8,32,55,79,102,124,151,156,132,108,85,61,37,14,0,0,0,0,0,0,0,0,3,25,47,67,85,101,116,130,141,150,158,165,169,174,175,177,168,163,154,144,130,114,96,79,59,40,20,0,0,0,18,38,56,68,73,73,73,73,73,73,66,51,33,12,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,0,8,20,27,30,50,73,96,119,147,170,180,157,134,109,83,60,38,15,0,0,0,0,16,38,60,81,103,124,149,171,148,124,104,82,61,39,16,0,0,0,0,20,42,64,85,107,130,152,168,146,121,100,78,57,35,14,0,0,0,0,2,20,33,42,45,66,88,111,139,162,165,139,114,91,68,43,20,0,0,0,0,0,0,0,0,22,48,71,93,117,144,167,160,134,109,86,63,45,41,31,17,0,0,0,6,22,34,43,45,45,60,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,2,24,46,68,90,111,134,155,152,132,108,86,64,42,20,0,0,12,35,58,81,101,124,149,172,149,124,101,81,58,45,45,41,32,18,2,0,0,0,14,38,61,85,109,134,157,150,124,101,78,54,31,8,0,0,0,0,0,0,0,0,0,15,36,53,68,82,95,107,117,129,135,142,145,152,167,159,145,139,132,121,109,96,80,64,45,26,7,0,0,0,4,20,35,45,48,48,48,48,48,48,43,31,17,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,0,9,26,42,52,55,53,75,99,121,147,170,180,155,132,106,83,60,38,15,0,0,0,4,25,47,68,90,112,135,156,162,141,117,96,74,53,31,9,0,0,0,0,12,34,56,77,99,121,144,165,153,132,108,87,65,44,22,2,0,0,0,17,38,54,66,71,71,91,114,139,162,162,139,114,91,68,43,20,0,0,0,0,0,0,0,0,22,48,71,93,116,142,165,160,137,111,88,71,70,64,51,34,13,0,4,21,40,56,67,71,71,71,83,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,0,17,40,61,83,105,129,150,159,137,114,92,70,48,26,4,0,12,35,58,81,101,124,149,172,149,124,101,81,71,71,70,65,53,36,17,0,0,0,20,45,67,91,115,139,163,144,119,95,72,48,25,1,0,0,0,0,0,0,0,0,0,2,19,34,49,62,74,86,95,102,110,115,119,137,160,152,129,114,108,98,88,76,62,46,30,13,0,0,0,0,0,2,15,22,25,25,25,25,25,25,21,12,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,1,22,43,60,75,81,77,78,101,124,147,170,176,154,132,106,83,60,36,12,0,0,0,14,35,56,77,98,119,143,164,153,132,109,88,66,45,23,1,0,0,0,0,4,26,48,69,91,112,135,156,161,139,116,95,74,54,32,11,0,0,5,27,50,70,87,96,96,100,119,144,166,160,137,112,88,65,43,19,0,0,0,0,0,0,0,0,22,45,68,92,116,139,163,163,140,116,99,96,96,83,66,46,23,0,12,32,53,72,88,96,96,96,96,106,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,0,11,33,55,77,98,119,143,165,144,119,98,77,54,33,11,0,12,35,58,81,101,124,149,172,149,124,101,96,96,96,96,85,68,48,28,0,0,3,27,51,73,98,121,145,160,137,113,89,66,42,18,0,0,0,0,0,0,0,0,0,0,0,0,15,28,41,53,63,72,79,86,91,111,137,160,152,129,104,84,76,66,55,42,28,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,8,31,54,75,94,104,100,98,109,132,153,175,172,149,124,102,80,57,34,10,0,0,4,24,45,66,87,108,130,152,165,144,121,100,79,57,36,15,0,0,0,0,0,0,18,39,61,81,103,124,147,167,148,129,105,84,63,42,22,2,0,9,32,57,80,102,119,119,121,136,153,173,153,132,108,85,62,39,16,0,0,0,0,0,0,0,0,19,42,65,88,111,135,156,171,149,132,121,119,117,98,75,52,27,0,17,37,60,83,105,119,119,119,119,119,129,152,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,0,5,27,49,70,92,114,137,159,150,129,105,83,61,39,17,0,12,35,58,81,101,124,149,172,149,124,119,119,119,119,117,100,78,55,32,0,0,9,33,57,80,103,129,152,155,132,106,83,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,8,20,30,40,49,56,66,88,111,137,160,152,129,104,81,58,44,34,21,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,14,37,60,83,105,129,124,121,129,144,163,183,164,142,119,97,75,53,29,6,0,0,15,36,56,76,97,117,140,161,154,134,112,90,69,48,27,6,0,0,0,0,0,0,8,30,51,72,93,114,137,157,158,137,115,95,74,54,33,13,0,10,33,58,81,104,129,147,147,155,168,159,141,121,99,77,55,33,11,0,0,0,0,0,0,0,0,14,36,59,81,103,123,144,161,166,154,147,147,121,99,76,53,27,0,17,38,60,83,106,129,147,147,147,147,147,159,170,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,0,0,20,42,64,86,107,132,152,155,134,111,89,67,45,24,0,12,35,58,81,101,124,149,172,157,147,147,147,147,147,121,101,78,55,33,0,0,16,39,63,86,109,135,158,148,124,101,77,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,25,43,66,88,111,137,149,149,129,104,81,58,35,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,0,20,43,66,89,111,134,149,147,152,162,177,171,152,132,110,90,67,45,23,1,0,4,26,47,67,88,108,130,150,164,144,121,100,80,59,39,17,0,0,0,0,0,0,0,0,21,41,62,82,104,124,146,167,147,129,106,86,65,45,24,0,10,33,58,81,104,129,149,149,149,144,138,123,107,88,69,47,25,3,0,0,0,0,0,0,0,0,7,28,49,71,91,109,124,139,146,149,149,149,121,99,76,53,27,0,17,38,60,83,106,129,149,149,149,149,149,149,149,147,121,99,76,55,33,0,0,0,0,0,0,0,0,0,0,0,14,36,57,80,101,123,146,149,140,116,96,73,51,29,0,12,35,58,81,101,124,149,149,149,149,149,149,149,147,121,101,78,55,33,0,0,21,45,69,93,116,141,149,142,117,94,70,47,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,43,65,88,110,121,121,121,121,103,80,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,4,27,49,72,94,116,140,163,172,175,170,164,152,137,117,98,79,58,37,15,0,0,9,32,55,77,99,119,141,160,153,132,110,90,70,48,28,7,0,0,0,0,0,0,0,0,9,31,51,72,92,114,135,155,158,139,117,97,75,52,29,0,10,32,58,80,103,121,121,121,121,119,114,105,90,74,55,35,15,0,0,0,0,0,0,0,0,0,0,17,38,57,76,92,106,116,119,121,121,121,119,98,75,53,27,0,17,37,60,83,106,121,121,121,121,121,121,121,121,121,119,98,75,55,32,0,0,0,0,0,0,0,0,0,0,0,8,30,51,73,95,115,121,121,121,119,98,75,53,30,0,12,35,58,80,101,121,121,121,121,121,121,121,121,121,119,101,78,55,32,0,0,22,48,70,96,117,121,121,121,110,88,64,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,38,59,79,95,99,99,99,99,90,73,52,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,7,30,53,78,101,121,144,147,149,149,147,141,132,117,101,85,66,46,26,5,0,0,9,32,55,77,99,117,129,137,140,119,99,79,58,38,17,0,0,0,0,0,0,0,0,0,0,20,40,62,81,101,121,143,137,124,116,97,75,52,29,0,6,28,52,73,90,99,99,99,99,96,92,83,72,56,40,22,2,0,0,0,0,0,0,0,0,0,0,5,24,42,58,73,84,93,96,99,99,99,98,87,69,48,24,0,14,33,55,75,92,99,99,99,99,99,99,99,99,99,98,87,69,49,28,0,0,0,0,0,0,0,0,0,0,0,1,23,44,64,83,97,99,99,99,98,87,69,48,26,0,9,31,51,72,89,98,99,99,99,99,99,99,99,99,98,89,71,50,28,0,0,19,41,64,85,98,99,99,99,95,78,56,34,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,27,45,61,71,73,73,73,73,68,56,40,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,165,144,121,101,81,60,40,0,6,29,51,76,97,112,118,121,121,121,121,116,109,98,83,69,51,33,14,0,0,0,4,26,48,68,85,95,105,114,121,107,87,67,47,27,6,0,0,0,0,0,0,0,0,0,0,9,29,49,69,89,109,121,113,104,94,83,66,45,24,0,0,18,40,56,68,73,73,73,73,73,68,61,50,38,22,6,0,0,0,0,0,0,0,0,0,0,0,0,8,25,40,53,62,69,73,73,73,73,73,66,53,36,14,0,5,23,42,58,69,73,73,73,73,73,73,73,73,73,73,66,53,38,18,0,0,0,0,0,0,0,0,0,0,0,0,13,32,49,64,72,73,73,73,73,66,53,36,16,0,0,21,40,56,67,73,73,73,73,73,73,73,73,73,73,67,55,38,18,0,0,9,31,49,65,73,73,73,73,71,59,44,23,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,27,39,46,48,48,48,48,45,35,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,66,86,106,129,149,149,144,121,101,81,60,40,0,0,22,44,63,79,89,94,98,99,99,98,93,87,76,64,51,35,18,0,0,0,0,0,16,34,51,64,73,82,92,99,92,74,55,34,15,0,0,0,0,0,0,0,0,0,0,0,0,17,37,57,77,93,98,90,81,72,62,49,32,14,0,0,6,24,38,47,50,50,50,50,48,44,38,29,18,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,19,30,40,45,48,50,50,50,50,45,35,21,2,0,0,9,26,39,48,50,50,50,50,50,50,50,50,50,50,45,35,21,6,0,0,0,0,0,0,0,0,0,0,0,0,0,17,32,43,50,50,50,50,50,45,35,21,4,0,0,7,22,36,46,50,50,50,50,50,50,50,50,50,50,46,36,22,6,0,0,0,15,32,44,50,50,50,50,48,40,26,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,24,25,25,25,25,22,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,45,65,86,106,121,121,121,121,119,101,80,60,40,0,0,11,29,47,58,65,71,73,73,73,73,70,64,55,45,31,17,1,0,0,0,0,0,1,17,32,41,51,61,69,73,69,58,42,23,3,0,0,0,0,0,0,0,0,0,0,0,0,5,25,44,59,70,73,68,59,50,41,29,15,0,0,0,0,4,15,22,25,25,25,25,25,21,16,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,21,25,25,25,25,25,21,13,1,0,0,0,0,5,16,23,25,25,25,25,25,25,25,25,25,25,21,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,24,25,25,25,25,21,13,1,0,0,0,0,4,15,22,25,25,25,25,25,25,25,25,25,25,22,14,2,0,0,0,0,0,11,20,25,25,25,25,24,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,40,58,76,90,96,96,96,96,96,87,72,54,35,0,0,0,11,25,35,41,47,50,50,50,50,46,41,33,23,11,0,0,0,0,0,0,0,0,0,9,19,29,38,47,50,48,38,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,26,39,48,50,46,37,28,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,28,44,57,67,71,71,71,71,70,65,54,40,24,0,0,0,0,4,12,19,23,25,25,25,25,23,17,10,2,0,0,0,0,0,0,0,0,0,0,0,0,7,16,23,25,23,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,17,23,25,22,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,36,43,45,45,45,45,45,41,33,22,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,20,20,20,20,20,17,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,7,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,3,0,0,0,0,0,0,0,0,5,7,7,7,7,7,7,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,5,4,1,0,0,0,0,0,0,0,1,4,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,17,22,25,27,27,27,25,21,16,10,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,9,16,20,24,27,28,30,27,26,23,19,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,21,28,30,30,30,30,30,30,28,22,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,20,24,26,27,26,23,19,15,15,15,15,15,15,15,14,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,27,30,30,30,30,30,30,26,16,4,0,0,0,0,7,20,27,30,30,30,30,30,30,25,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,15,24,27,27,27,27,27,27,24,15,3,0,0,0,0,14,23,27,27,27,27,27,27,23,14,0,0,0,0,0,0,0,0,0,0,0,0,5,13,19,24,27,27,25,22,17,10,12,15,15,15,15,15,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,26,34,41,46,50,52,53,51,49,45,40,33,25,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,26,33,39,45,48,50,53,55,51,50,47,43,37,30,22,13,3,0,0,0,0,0,0,0,0,0,0,0,15,31,43,53,55,55,55,55,55,55,53,45,33,17,0,0,0,0,0,0,0,0,0,0,0,10,21,30,37,43,48,50,50,50,47,43,40,40,40,40,40,40,40,39,32,21,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,24,39,50,55,55,55,55,55,55,49,38,22,2,0,0,9,26,42,52,55,55,55,55,55,55,49,38,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,21,37,48,53,53,53,53,53,53,48,37,21,4,0,1,19,36,47,52,53,53,53,53,53,47,36,19,1,0,0,0,0,0,0,0,0,5,16,27,36,43,48,50,50,50,46,41,33,34,38,38,38,38,37,33,23,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,28,39,49,57,65,70,73,77,78,76,73,70,64,57,48,37,26,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,21,31,41,49,57,63,69,73,76,76,78,76,75,72,67,61,53,46,36,24,12,0,0,0,0,0,0,0,0,0,7,28,47,62,74,78,78,78,78,78,78,75,63,49,30,11,0,0,0,0,0,0,0,0,4,18,31,42,53,61,67,73,75,76,75,72,67,63,63,63,63,63,63,63,62,54,38,21,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,56,72,78,78,78,78,78,78,71,55,36,15,0,0,21,41,60,73,78,78,78,78,78,78,69,55,34,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,55,69,76,76,76,76,76,76,70,55,37,17,0,14,35,53,67,75,76,76,76,76,75,67,53,35,13,0,0,0,0,0,0,0,11,25,38,49,59,67,73,76,76,75,70,65,55,58,63,63,63,63,63,57,44,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,6,21,36,49,61,72,81,89,95,99,101,104,101,98,93,88,80,71,59,47,33,19,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,18,31,42,53,64,72,80,86,93,96,99,101,103,101,99,96,91,85,77,67,57,46,33,19,5,0,0,0,0,0,0,0,15,37,59,78,96,104,104,104,104,104,104,98,80,61,40,19,0,0,0,0,0,0,0,4,21,38,52,64,75,84,91,96,99,99,99,95,90,88,88,88,88,88,88,88,86,73,55,34,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,26,49,71,91,103,104,104,104,104,103,89,68,47,24,0,5,30,52,75,94,104,104,104,104,104,102,88,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,46,70,89,101,101,101,101,101,101,89,71,48,26,4,23,45,67,87,101,101,101,101,101,101,87,67,44,22,0,0,0,0,0,0,13,30,45,59,71,81,90,96,99,99,98,93,87,76,81,88,88,88,88,88,78,61,41,19,0,0,0,0,0,0,0,0,0,0,0,0,6,22,40,56,70,83,95,105,113,119,123,129,129,124,121,118,112,103,92,81,68,53,38,21,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,25,39,52,64,75,86,95,104,110,116,121,124,124,129,124,123,119,114,108,100,90,79,67,54,39,23,6,0,0,0,0,0,0,17,40,63,83,106,129,129,129,129,129,129,109,86,66,43,22,0,0,0,0,0,0,3,22,38,55,71,85,97,107,114,119,121,124,123,119,114,111,111,111,111,111,111,111,107,88,64,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,129,129,129,129,121,99,73,50,27,0,7,33,55,81,104,129,129,129,129,129,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,76,98,123,124,124,124,124,123,102,80,57,34,12,30,53,76,98,121,124,124,124,124,121,96,73,50,25,0,0,0,0,0,13,31,47,64,79,92,104,113,119,124,124,121,117,109,99,97,111,111,111,111,110,95,71,49,26,0,0,0,0,0,0,0,0,0,0,0,4,23,40])
.concat([58,74,90,104,116,129,138,144,149,152,154,152,149,144,137,129,115,103,88,73,56,38,21,2,0,0,0,0,0,0,0,0,0,0,0,0,0,13,29,45,59,73,86,98,108,118,129,136,142,147,150,152,152,152,149,145,139,132,121,113,100,88,73,58,41,24,6,0,0,0,0,0,17,40,63,83,106,129,152,154,154,154,134,109,86,66,43,22,0,0,0,0,0,0,17,36,55,73,89,105,118,132,139,144,149,151,149,144,139,139,139,139,139,139,139,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,154,154,149,121,99,73,50,27,0,7,33,55,81,104,129,154,154,154,147,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,25,49,72,94,116,140,152,152,152,134,110,88,65,42,20,37,60,83,106,130,152,152,152,139,115,92,69,46,23,0,0,0,0,10,29,47,65,82,98,113,124,137,144,149,151,148,142,132,119,106,129,139,139,139,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,19,38,58,76,92,109,124,139,152,161,168,174,177,179,177,173,168,160,149,137,123,107,91,73,55,36,17,0,0,0,0,0,0,0,0,0,0,0,0,13,30,47,64,79,93,106,118,132,141,150,159,161,156,152,152,152,152,155,160,163,155,146,135,121,107,92,76,58,41,22,4,0,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,8,29,50,69,89,107,123,139,152,162,168,162,160,162,167,165,165,165,165,165,165,165,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,63,85,108,132,153,175,164,142,118,96,73,50,28,44,67,90,113,137,160,175,153,132,107,85,61,39,16,0,0,0,2,22,43,62,81,99,116,134,147,160,168,173,175,172,164,154,141,124,134,157,165,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,12,33,53,73,92,110,130,145,160,173,177,166,159,154,154,155,160,167,178,172,158,143,124,109,90,71,51,31,10,0,0,0,0,0,0,0,0,0,0,12,30,47,65,82,98,113,129,141,154,164,153,144,137,132,129,124,124,129,132,136,142,150,162,156,143,129,110,94,76,57,38,18,0,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,18,40,62,82,103,123,143,159,173,158,146,137,137,138,147,160,177,178,161,154,154,154,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,32,54,77,99,121,145,166,172,150,129,104,81,58,36,51,73,97,119,144,167,168,145,121,99,77,53,31,8,0,0,0,14,34,56,76,96,116,136,152,167,181,167,158,152,152,154,160,161,145,145,163,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,2,24,46,67,87,107,129,146,164,180,169,155,144,135,130,129,132,137,145,156,171,177,162,144,124,105,85,64,44,21,0,0,0,0,0,0,0,0,0,8,28,46,65,83,99,116,134,148,163,154,141,132,121,113,106,102,101,101,101,105,110,117,129,140,153,162,146,130,110,92,72,52,31,11,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,3,26,49,71,93,114,137,157,176,158,141,123,114,109,114,124,143,161,170,147,129,129,129,129,114,91,66,43,20,0,0,0,0,0,0,0,0,0,0,0,4,11,15,17,17,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,17,17,17,14,9,2,0,0,0,0,0,0,0,0,0,0,0,23,45,68,90,112,136,157,180,158,136,112,89,66,44,58,81,104,129,151,173,160,138,114,91,69,45,24,0,0,0,1,24,46,67,88,109,132,150,169,180,162,148,136,129,124,130,137,147,159,166,179,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,12,34,56,79,100,121,143,162,181,168,150,134,119,109,104,101,104,111,121,137,154,170,179,160,140,118,98,76,55,32,10,0,0,0,0,0,0,0,2,22,43,62,81,99,117,136,152,162,148,134,119,108,98,90,83,78,76,76,78,81,87,95,106,118,134,150,164,146,129,106,86,65,44,22,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,9,32,55,78,101,124,147,169,168,146,123,105,90,86,91,107,124,148,170,154,134,110,104,104,100,83,61,40,17,0,0,0,0,0,0,0,0,0,9,19,28,35,40,43,43,42,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,40,43,43,41,38,32,25,15,5,0,0,0,0,0,0,0,0,0,14,36,59,81,103,124,148,172,166,144,119,97,74,52,65,88,111,135,158,175,152,130,106,83,61,38,16,0,0,0,10,33,55,77,99,121,144,163,184,164,146,129,113,104,101,106,113,124,140,156,178,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,21,44,67,89,112,135,156,177,172,152,134,114,98,87,80,77,80,88,100,116,136,155,175,174,154,132,109,88,65,42,19,0,0,0,0,0,0,0,15,36,57,76,96,116,136,154,161,144,129,112,98,86,75,66,59,54,51,50,53,57,64,73,84,98,113,132,150,162,141,119,99,77,55,33,10,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,12,35,59,83,106,132,154,177,162,139,114,91,71,60,73,93,116,140,163,165,142,118,96,78,77,67,49,30,8,0,0,0,0,0,0,0,4,18,30,41,50,58,63,66,66,65,61,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,58,63,66,66,65,61,55,47,37,25,12,0,0,0,0,0,0,0,0,5,27,50,72,94,116,140,163,174,152,129,105,82,60,72,95,118,142,165,167,144,121,98,75,53,30,8,0,0,0,17,41,63,86,109,132,154,175,172,152,132,110,92,81,77,81,91,105,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,6,29,53,76,98,121,145,167,181,160,138,116,97,79,64,55,53,56,66,82,99,119,141,163,184,165,144,119,97,73,50,28,4,0,0,0,0,0,6,28,49,70,90,110,132,152,162,144,124,109,92,78,64,58,66,72,73,73,70,61,65,66,66,66,79,96,114,136,155,155,134,110,88,65,42,20,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,12,38,60,83,109,134,157,180,160,136,110,86,63,41,65,88,111,138,162,172,147,121,99,75,52,45,31,15,0,0,0,0,0,0,0,8,23,38,51,63,73,81,88,91,91,90,85,78,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,81,88,91,91,89,85,78,70,58,45,31,15,0,0,0,0,0,0,0,0,18,41,63,85,108,132,154,175,160,137,113,90,68,79,101,124,149,172,159,137,113,90,67,45,22,0,0,0,0,22,46,69,93,116,139,163,185,163,141,117,97,76,59,53,58,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,13,36,60,83,106,132,154,177,172,149,124,104,82,62,44,31,27,32,47,65,86,107,130,152,175,174,152,129,105,81,57,34,11,0,0,0,0,0,17,39,62,82,104,124,146,166,147,129,109,91,74,58,69,80,90,96,99,98,93,83,90,91,91,91,86,80,100,121,144,165,144,119,97,74,51,28,4,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,12,37,60,83,107,134,157,180,160,137,111,88,64,43,66,90,112,139,162,172,147,121,99,76,50,27,12,0,0,0,0,0,0,0,7,24,40,56,71,84,95,104,111,114,114,113,108,100,101,124,149,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,170,147,121,96,96,105,111,114,114,113,108,100,90,79,65,49,33,15,0,0,0,0,0,0,0,9,32,54,76,99,121,145,166,167,145,121,98,76,86,109,134,155,173,152,129,105,82,59,36,14,0,0,0,3,27,50,73,98,121,145,169,181,157,134,109,87,65,43,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,18,42,66,90,114,138,161,185,164,140,116,93,71,49,28,10,2,12,31,53,74,97,119,144,168,182,160,136,111,88,63,40,15,0,0,0,0,5,28,49,72,95,116,138,160,153,132,112,92,74,60,76,90,103,113,119,121,121,116,105,112,114,114,114,103,81,88,109,134,156,152,130,105,81,58,35,10,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,11,34,57,81,104,129,152,174,163,139,116,95,75,67,76,97,117,142,165,167,144,119,96,73,50,27,2,0,0,0,0,0,0,4,23,41,58,76,91,105,117,129,136,139,142,139,134,121,109,124,149,172,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,170,144,119,105,117,129,136,140,142,139,134,123,112,99,83,67,49,30,10,0,0,0,0,0,0,0,23,45,67,90,112,136,157,176,153,130,106,84,93,116,140,163,165,144,119,97,74,51,29,6,0,0,0,5,29,53,77,101,124,149,173,177,152,129,105,81,58,34,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,22,46,70,93,118,144,167,181,158,134,109,86,62,39,16,0,0,0,20,43,66,89,113,138,161,185,165,141,116,92,68,45,20,0,0,0,0,14,37,60,82,105,129,150,161,140,117,97,77,60,78,94,110,123,137,144,149,147,139,123,124,142,142,132,106,82,77,100,123,148,160,137,111,88,64,40,15,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,7,30,53,76,98,119,144,164,171,148,129,109,96,91,97,110,130,150,172,160,137,114,91,68,45,22,0,0,0,0,0,0,0,17,38,56,74,92,109,124,139,150,158,163,165,162,155,144,132,121,147,172,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,170,144,119,129,139,150,159,163,165,162,155,146,134,117,99,83,64,44,23,3,0,0,0,0,0,0,14,36,58,81,103,124,148,172,161,138,115,92,101,123,147,170,157,136,111,89,66,44,21,0,0,0,0,7,32,55,80,103,129,152,175,175,152,129,101,78,55,30,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,1,25,49,73,98,121,147,172,178,154,130,104,81,56,33,9,0,0,0,12,36,60,83,109,134,157,181,170,144,119,96,71,47,22,0,0,0,0,22,45,68,92,115,138,161,150,129,106,84,63,75,94,112,130,145,158,163,160,158,159,139,132,155,150,124,101,77,69,93,116,142,165,142,116,93,68,44,20,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,23,45,67,89,109,132,150,168,162,144,130,119,115,119,132,146,164,165,147,124,104,83,61,39,16,0,0,0,0,0,0,9,30,50,71,90,109,129,144,159,172,177,168,162,162,163,165,150,137,149,173,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,170,145,132,146,161,165,162,162,165,173,178,167,154,136,116,97,77,56,34,14,0,0,0,0,0,0,5,27,50,72,94,116,140,163,169,146,121,99,107,132,155,172,150,129,103,81,58,36,13,0,0,0,0,7,33,55,81,104,129,154,177,175,152,129,101,78,54,30,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,2,27,50,76,99,124,150,175,175,152,124,101,78,53,29,5,0,0,0,8,32,57,81,105,132,154,180,172,147,121,98,73,49,25,0,0,0,5,30,53,77,100,123,147,163,140,116,95,72,69,89,109,130,148,165,154,140,134,134,141,155,151,166,146,119,96,73,64,88,111,137,162,147,119,96,71,47,22,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,14,35,56,76,96,114,134,150,169,163,150,144,142,144,152,164,161,148,132,112,92,72,50,30,8,0,0,0,0,0,0,20,41,63,83,104,123,144,162,179,170,156,146,139,137,139,146,156,160,167,184,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,178,160,155,161,150,142,139,139,143,152,165,182,170,150,132,109,89,67,45,23,0,0,0,0,0,0,0,18,41,63,85,108,132,154,175,153,132,106,114,138,161,164,142,118,95,73,50,28,5,0,0,0,0,7,32,55,78,102,129,152,175,177,152,129,103,79,56,32,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,2,27,52,76,101,124,152,175,175,152,124,99,76,50,27,2,0,0,0,6,30,55,78,104,129,154,178,174,149,121,99,73,50,25,2,0,0,11,35,59,83,106,132,155,155,132,108,85,62,81,101,123,145,164,152,136,118,109,109,121,140,161,165,141,115,91,68,60,83,109,134,160,149,121,96,73,48,23,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,7,29,50,69,87,105,121,142,161,150,154,160,162,160,155,149,140,129,112,96,78,59,40,19,0,0,0,0,0,0,7,29,51,73,95,116,138,158,177,170,154,136,121,114,111,115,121,135,148,162,182,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,188,170,155,141,129,117,112,113,119,132,148,166,184,164,144,119,98,76,53,31,8,0,0,0,0,0,0,10,32,54,76,99,121,145,167,160,137,114,119,144,168,157,134,110,87,65,42,20,0,0,0,0,0,5,28,53,76,100,124,149,172,178,155,132,106,83,60,36,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,2,27,53,76,101,124,152,175,175,152,124,99,76,50,27,2,0,0,0,5,30,55,78,104,129,154,177,175,149,124,99,73,50,25,2,0,0,16,41,65,88,113,138,161,149,123,100,77,69,91,113,137,158,158,137,116,99,85,87,106,132,157,160,137,110,86,63,58,83,106,134,157,149,121,99,73,48,25,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,16,39,61,82,103,121,141,156,144,129,132,137,137,137,132,124,116,107,93,78,62,45,26,7,0,0,0,0,0,0,14,37,60,82,105,129,149,171,178,157,137,117,101,91,88,92,100,114,130,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,175,154,137,119,107,95,88,89,98,113,134,155,175,175,153,130,106,84,61,38,14,0,0,0,0,0,0,1,23,45,67,90,112,136,158,167,144,121,129,150,171,149,124,102,80,57,34,12,0,0,0,0,0,2,26,50,73,96,119,144,168,183,159,137,113,90,67,48,45,57,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,2,27,50,76,101,124,151,175,175,152,124,101,77,53,29,4,0,0,0,7,32,56,80,104,132,154,180,172,147,121,99,73,50,25,0,0,0,20,45,69,93,116,144,167,143,117,94,70,77,100,123,147,170,147,124,103,83,64,87,111,137,160,155,132,106,82,58,58,83,106,134,157,149,121,98,73,48,25,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,23,46,69,92,114,137,156,155,132,110,106,109,111,109,107,101,94,84,73,59,46,39,30,19,6,0,0,0,0,0,20,44,67,90,113,137,160,181,168,145,123,103,83,69,63,69,80,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,101,86,74,65,65,80,99,121,144,167,183,160,137,113,90,66,43,19,0,0,0,0,0,0,0,14,37,58,81,103,124,149,172,152,129,134,156,163,141,116,94,72,49,26,4,0,0,0,0,0,0,21,45,69,92,114,139,162,184,166,144,121,100,82,69,68,76,90,107,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,2,25,50,74,99,121,149,172,177,154,129,104,80,56,32,8,0,0,0,11,35,60,83,107,132,157,181,170,146,119,96,71,48,22,0,0,0,22,48,73,96,121,147,165,139,114,90,65,83,106,132,155,162,139,114,91,70,67,91,115,141,165,151,124,101,77,53,61,86,109,136,160,147,121,96,73,48,22,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,2,27,50,73,97,121,146,168,154,130,106,89,86,86,86,83,83,83,83,80,76,70,62,51,40,26,10,0,0,0,1,25,49,72,96,119,144,167,183,160,137,114,91,70,49,40,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,53,41,46,69,91,114,138,161,185,165,142,116,93,70,47,22,0,0,0,0,0,0,0,5,28,49,72,94,116,140,163,159,137,141,163,155,134,109,86,64,41,18,0,0,0,0,0,0,0,16,40,62,85,108,132,154,175,176,155,136,116,101,93,93,99,110,123,143,159,180,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,23,47,71,95,119,144,168,180,157,134,109,85,61,37,14,0,0,0,17,41,64,88,111,137,160,184,166,142,116,93,68,45,20,0,0,0,25,49,73,99,121,149,162,137,111,86,63,88,112,137,161,156,134,107,83,60,71,96,119,144,170,146,119,96,72,48,67,91,114,139,163,143,116,93,69,45,20,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,2,27,50,73,99,121,147,170,160,138,119,111,109,109,109,109,109,109,106,104,99,93,83,73,59,44,26,9,0,0,4,28,52,76,99,121,147,172,178,155,132,106,83,60,37,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,38,63,86,109,134,157,181,170,145,119,96,73,49,25,0,0,0,0,0,0,0,0,19,41,64,85,108,132,154,171,159,160,170,147,124,101,79,56,33,11,0,0,0,0,0,0,0,9,33,55,77,99,121,144,164,184,170,152,136,124,116,116,121,132,145,159,177,193,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,19,43,68,91,114,139,163,186,162,139,114,91,68,46,23,2,0,5,25,49,71,94,117,142,165,183,160,137,111,88,64,41,16,0,0,2,25,50,75,99,124,150,162,137,109,86,66,91,114,141,165,154,129,103,78,55,75,100,124,149,164,140,116,91,68,54,76,98,121,145,160,137,112,88,65,40,16,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,2,25,48,72,96,118,142,163,172,155,144,137,137,134,134,134,134,134,134,129,123,116,106,93,78,61,42,22,2,0,7,31,55,78,101,124,151,175,177,152,129,104,79,56,32,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,35,59,83,106,132,157,180,172,147,121,99,73,50,25,0,0,0,0,0,0,0,0,10,32,55,76,99,121,145,167,183,184,163,139,116,93,71,48,25,3,0,0,0,0,0,0,0,1,24,45,67,88,109,130,150,168,183,170,156,147,144,142,145,154,161,150,159,178,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,14,38,62,85,109,134,156,180,169,146,121,100,78,57,36,19,12,21,38,59,81,103,124,149,172,176,153,130,106,82,59,35,11,0,0,2,25,50,76,99,124,152,160,137,109,86,66,91,116,142,167,152,129,101,78,64,82,104,129,153,160,137,110,86,62,67,88,109,132,154,152,129,105,81,58,35,11,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,20,43,65,88,108,130,147,162,175,166,161,160,160,160,160,160,160,157,152,147,139,129,112,94,75,54,33,11,0,7,33,55,81,104,129,154,177,175,152,124,101,78,54,30,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,34,58,81,106,132,154,180,172,147,121,99,73,50,25,0,0,0,0,0,0,0,0,1,23,46,67,90,112,136,158,180,177,155,132,108,85,63,40,17,0,0,0,0,0,0,0,0,0,14,34,56,76,96,114,134,149,163,173,179,171,167,167,168,156,143,124,147,172,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,8,32,55,78,101,124,147,170,178,156,134,110,90,71,53,41,38,42,55,73,93,114,137,158,181,167,145,121,98,75,52,28,5,0,0,0,25,50,74,99,124,149,162,137,111,86,66,91,114,142,165,155,132,106,83,84,98,116,136,158,160,134,108,83,73,85,103,121,144,163,141,118,96,73,51,27,4,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,0,21,40,59,76,94,112,129,152,162,157,160,162,165,165,165,165,165,169,177,171,161,148,130,108,87,65,42,19,0,7,32,55,80,104,129,152,176,175,152,129,101,78,55,30,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,35,59,83,106,132,157,180,170,147,121,98,73,50,25,0,0,0,0,0,0,0,6,10,14,37,58,81,103,124,150,173,169,147,121,100,77,55,32,9,0,0,0,0,0,0,0,0,0,2,23,43,62,80,98,114,130,141,151,157,160,160,155,147,136,121,121,148,172,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,1,24,47,70,92,114,137,160,180,166,146,124,105,88,74,65,62,65,76,90,108,129,148,170,178,156,135,112,90,67,44,21,0,0,0,0,24,48,73,97,121,147,165,139,114,90,65,87,111,137,160,162,140,118,106,106,117,135,152,159,160,137,113,97,96,105,119,139,157,150,130,107,86,63,41,19,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,12,32,54,74,92,110,129,143,158,143,132,137,139,139,139,139,139,142,146,155,171,181,163,140,116,94,71,48,24,0,6,30,54,77,101,124,149,175,177,152,129,104,81,58,34,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,39,63,86,109,135,158,182,168,144,119,96,71,48,24,0,0,0,0,0,6,21,30,35,34,38,59,82,105,129,152,175,161,139,114,92,69,47,24,1,0,0,0,0,0,0,0,0,0,0,9,28,46,64,80,95,107,118,129,132,136,134,132,123,113,101,124,149,173,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,15,38,59,81,103,124,146,166,179,160,141,123,108,96,89,86,90,98,109,124,144,163,182,164,144,121,100,79,57,35,12,0,0,0,0,21,45,70,93,119,144,168,144,118,95,71,81,104,129,150,171,155,139,132,132,140,154,139,138,161,148,130,119,119,129,140,155,154,136,115,95,74,52,31,8,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,22,0,0,0,0,20,42,65,87,107,129,146,162,144,123,108,111,111,111,111,111,114,116,121,137,156,178,170,147,121,99,73,50,27,0,4,27,52,75,99,121,147,170,180,157,134,109,86,63,40,33,53,76,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,31,48,70,92,115,139,162,186,163,139,115,92,68,45,21,0,0,0,0,4,24,40,52,58,57,54,71,91,113,137,159,174,152,130,106,84,61,39,16,0,0,0,0,0,0,0,0,0,0,0,0,12,30,46,61,74,86,95,102,106,109,109,106,100,91,101,124,150,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,5,27,48,70,90,110,132,150,170,177,159,143,130,119,114,111,114,121,132,146,161,179,168,150,130,109,88,67,46,24,3,0,0,0,0,18,42,66,90,114,139,162,150,124,102,79,72,95,115,137,154,166,162,157,157,154,139,121,130,152,165,153,147,147,151,161,150,136,117,99,81,60,40,19,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,66,43,31,15,0,0,3,26,49,72,95,117,140,161,157,134,110,90,86,88,88,88,88,88,91,101,124,149,172,172,147,121,99,73,50,27,0,0,24,48,71,95,117,142,165,186,162,139,116,94,73,57,55,66,80,101,124,152,175,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,96,73,59,55,64,81,101,123,147,169,179,156,134,109,86,64,40,16,0,0,0,0,16,38,58,74,83,81,78,87,105,124,146,167,164,143,119,97,75,53,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,12,27,41,54,64,73,79,83,85,85,83,77,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,15,36,57,77,96,115,134,152,166,178,164,153,144,139,139,140,146,154,166,179,164,150,132,113,94,74,55,34,13,0,0,0,0,0,12,36,61,84,108,134,155,157,135,110,89,67,81,101,117,134,144,149,149,144,134,119,103,116,136,148,155,160,157,151,143,130,116,99,83,65,46,26,6,0,0,0,17,40,63,83,106,129,152,175,177,154,134,109,86,75,63,49,30,11,0,5,30,53,76,101,124,148,172,154,132,106,83,67,63,63,63,63,70,83,102,124,149,172,166,143,119,96,73,49,26,0,0,19,43,65,89,112,136,159,180,170,149,129,107,90,81,80,87,99,114,134,153,176,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,121,104,91,83,78,84,98,114,136,156,178,170,147,124,102,80,57,34,11,0,0,0,1,24,48,70,92,106,103,101,107,121,139,159,174,154,132,109,88,66,44,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,21,31,41,49,55,58,60,60,58,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,2,22,43,62,80,98,114,132,146,158,169,176,168,165,165,165,169,176,168,157,144,130,112,96,78,60,41,21,0,0,0,0,0,0,7,31,54,77,100,123,147,167,145,121,100,79,65,83,99,110,119,124,124,119,110,99,85,99,114,124,132,134,134,129,118,108,95,82,65,47,31,11,0,0,0,0,17,40,62,83,105,129,149,172,177,155,134,111,101,98,79,60,40,19,0,5,30,53,76,101,124,149,173,159,137,114,99,90,86,83,83,86,92,101,116,136,156,175,155,135,112,90,67,45,21,0,0,13,36,59,81,104,129,149,170,181,161,143,123,111,104,104,109,119,134,150,166,185,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,176,154,139,123,113,106,102,106,117,132,150,169,179,158,138,115,93,71,49,27,4,0,0,0,7,30,54,77,100,123,129,129,132,141,157,173,161,140,118,98,76,56,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,25,31,35,35,35,34,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,8,27,46,64,80,96,110,124,137,146,153,159,171,187,180,163,152,145,136,121,109,94,78,62,44,35,32,22,9,0,0,0,0,0,23,46,69,91,114,137,158,156,136,114,94,76,64,78,89,96,99,99,96,88,78,65,80,92,101,106,109,106,103,96,86,75,62,47,31,13,0,0,0,0,0,15,37,58,80,101,123,147,167,182,162,143,129,129,109,88,67,45,24,0,4,27,51,73,98,119,144,165,169,150,134,121,114,109,106,107,110,115,124,137,152,170,159,141,121,100,80,58,36,14,0,0,6,28,50,73,95,116,138,158,177,177,159,145,136,130,129,134,142,154,158,160,173,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,171,160,158,146,137,132,129,132,139,152,166,181,164,144,124,104,82,61,39,18,0,0,0,0,12,35,59,82,106,130,152,152,155,163,175,162,144,124,106,86,66,45,23,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,7,10,12,12,30,53,76,101,124,152,175,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,0,11,28,46,62,76,90,103,113,121,129,137,158,179,172,150,129,119,112,100,88,75,60,51,57,60,56,43,28,8,0,0,0,0,14,37,58,81,103,124,146,167,149,130,110,94,79,65,65,72,76,76,72,65,56,45,59,70,78,83,83,83,79,73,64,53,41,27,12,0,0,0,0,0,0,11,33,54,76,97,117,139,160,180,175,161,152,137,114,92,71,49,28,0,0,22,45,67,89,110,132,150,164,168,154,145,139,134,134,134,135,139,147,157,166,154,141,123,107,88,68,47,27,5,0,0,0,20,41,62,83,104,123,143,160,174,178,166,158,154,152,156,164,152,137,141,163,172,149,121,99,73,50,27,0,7,33,55,81,104,129,154,177,158,138,144,159,160,154,152,154,161,172,177,163,148,130,110,91,71,50,29,7,0,0,0,0,18,41,64,88,111,136,159,172,170,166,156,143,129,109,91,73,52,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,172,172,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,10,26,42,56,69,80,90,98,103,123,146,166,177,155,136,116,101,90,81,77,75,76,81,83,79,62,42,21,0,0,0,0,4,25,48,69,90,110,132,152,164,146,129,112,98,87,76,68,62,58,55,57,59,64,72,80,90,96,85,66,55,49,41,31,20,7,0,0,0,0,0,0,0,6,27,48,69,89,109,130,148,163,171,173,162,141,117,96,75,53,32,0,0,15,36,57,78,96,114,130,144,154,161,167,162,160,157,157,160,163,160,153,144,134,119,105,89,72,54,35,15,0,0,0,0,9,30,50,70,89,107,124,141,154,163,170,173,172,168,158,146,134,117,136,160,162,149,121,99,73,50,27,0,7,33,55,81,104,129,154,162,152,129,124,140,153,163,170,174,171,165,156,144,130,112,94,76,57,38,17,0,0,0,0,0,22,45,68,93,116,141,147,149,147,143,135,121,109,92,76,58,39,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,149,149,149,149,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,21,34,47,57,66,73,90,112,132,152,171,171,154,137,123,113,106,101,100,101,105,109,96,75,53,28,5,0,0,0,0,15,35,57,77,97,116,137,154,164,148,134,119,108,99,92,86,83,81,81,83,88,95,103,113,118,99,76,54,31,18,9,0,0,0,0,0,0,0,0,0,0,19,39,59,79,98,114,132,141,147,149,149,144,121,101,78,57,35,0,0,4,24,44,62,80,96,110,121,132,139,144,147,148,149,147,146,142,137,130,121,110,99,86,72,55,38,20,2,0,0,0,0,0,17,37,56,73,91,107,119,132,141,147,149,149,144,137,124,112,107,132,139,139,139,121,99,73,50,27,0,7,33,55,81,104,129,139,139,139,123,105,118,132,141,147,149,147,142,134,121,109,94,78,60,43,24,4,0,0,0,0,0,21,44,69,91,110,117,121,121,121,117,111,100,89,74,58,42,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,30,53,75,101,121,121,121,121,121,119,98,73,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,24,34,42,57,77,97,116,136,154,170,171,157,146,138,132,129,124,129,132,132,106,81,58,34,11,0,0,0,0,2,23,43,62,82,99,117,136,152,166,154,143,132,121,115,109,106,104,106,107,111,117,124,136,132,108,86,64,41,18,0,0,0,0,0,0,0,0,0,0,0,9,28,48,65,82,98,109,116,121,121,121,119,114,98,77,57,34,0,0,0,11,28,46,62,76,89,99,107,114,117,121,121,121,121,119,116,112,106,98,89,78,66,53,38,22,4,0,0,0,0,0,0,3,22,40,56,72,86,98,109,116,121,121,121,119,114,104,92,101,111,111,111,111,110,95,71,49,26,0,6,31,54,78,99,111,111,111,111,110,93,98,108,116,121,121,121,117,110,100,89,76,60,44,26,9,0,0,0,0,0,0,15,37,57,76,88,94,98,99,97,94,88,79,67,55,40,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,47,69,87,98,99,99,99,99,98,85,66,44,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,23,43,62,82,99,117,136,150,163,175,169,161,155,152,152,152,155,137,111,88,64,40,17,0,0,0,0,0,9,28,47,65,83,100,116,132,146,157,164,155,147,140,136,132,132,132,134,137,142,150,158,142,117,96,73,49,24,1,0,0,0,0,0,0,0,0,0,0,0,16,33,49,65,76,88,93,98,99,99,96,91,81,67,48,27,0,0,0,0,12,28,43,56,66,76,84,90,93,96,98,99,96,96,93,88,82,75,66,56,45,33,19,4,0,0,0,0,0,0,0,0,6,22,38,53,66,76,86,93,97,99,99,96,90,82,71,81,86,86,86,86,86,77,59,40,19,0,0,24,45,65,80,86,86,86,86,86,76,76,86,93,98,99,99,94,88,79,69,56,42,26,10,0,0,0,0,0,0,0,5,25,42,57,65,72,73,73,73,70,65,57,47,35,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,53,67,73,73,73,73,73,73,66,51,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,28,47,65,82,99,114,130,143,153,161,167,172,172,173,172,165,142,116,93,70,46,22,0,0,0,0,0,0,13,31,47,65,82,97,110,123,136,145,153,160,164,160,157,157,157,157,162,160,152,144,134,121,98,75,50,25,2,0,0,0,0,0,0,0,0,0,0,0,1,17,31,45,56,65,71,73,73,73,73,69,61,49,35,17,0,0,0,0,0,9,23,34,45,54,61,66,70,73,73,73,73,71,69,65,59,53,44,34,24,12,0,0,0,0,0,0,0,0,0,0,0,4,19,33,45,55,64,70,73,73,73,73,67,60,49,60,63,63,63,63,63,57,44,27,7,0,0,13,31,48,59,63,63,63,63,63,56,55,64,70,73,73,73,70,65,57,47,35,22,8,0,0,0,0,0,0,0,0,0,8,22,34,41,47,48,50,48,47,41,34,25,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,33,44,48,48,48,48,48,48,43,31,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,30,47,64,80,95,107,119,129,137,142,147,147,149,147,144,138,121,99,73,48,25,0,0,0,0,0,0,0,13,31,47,63,76,90,101,113,121,132,137,142,146,148,149,147,146,142,137,129,121,110,99,87,67,44,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,24,34,41,47,50,50,50,48,45,38,28,17,1,0,0,0,0,0,0,2,13,23,30,37,42,45,48,48,48,48,47,45,41,35,28,21,12,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,23,33,40,46,50,50,50,49,44,36,28,35,38,38,38,38,37,33,23,9,0,0,0,0,13,27,35,38,38,38,38,37,33,32,40,46,50,50,50,47,41,34,25,14,2,0,0,0,0,0,0,0,0,0,0,0,3,12,19,23,25,25,25,23,18,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,30,45,60,73,86,96,105,111,116,119,121,121,121,116,112,105,90,68,45,22,0,0,0,0,0,0,0,0,13,28,43,56,69,80,90,98,106,111,116,119,121,121,121,119,116,111,105,97,88,78,66,53,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,18,24,25,25,25,25,21,16,7,0,0,0,0,0,0,0,0,0,0,0,8,14,18,22,23,25,25,25,22,21,17,12,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,17,22,25,25,25,25,20,14,6,12,15,15,15,15,15,11,3,0,0,0,0,0,0,6,12,15,15,15,15,15,11,10,17,23,25,25,25,23,19,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,26,39,51,63,73,81,87,92,94,96,96,96,93,88,81,72,55,34,14,0,0,0,0,0,0,0,0,0,8,22,35,47,57,67,75,82,88,92,95,96,96,96,95,92,87,81,73,66,55,45,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,18,30,41,49,57,63,68,70,71,71,71,68,64,57,49,36,20,1,0,0,0,0,0,0,0,0,0,0,2,14,25,35,45,52,59,64,68,71,73,73,73,71,68,64,58,51,43,33,23,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,26,33,39,43,45,47,48,45,43,40,34,26,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,21,28,35,40,44,47,48,48,48,46,44,39,35,28,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,9,14,19,20,22,22,21,19,15,10,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,16,20,22,23,25,23,22,19,15,10,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,5,4,0,0,0,0,0,0,0,0,0,4,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,15,15])
.concat([15,15,15,12,5,13,20,24,27,27,25,22,17,10,1,0,0,0,0,0,0,0,0,0,0,8,20,27,30,30,30,30,30,30,25,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,20,24,27,27,24,20,13,4,0,0,0,0,0,0,8,20,27,30,30,30,30,30,30,26,17,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,17,22,25,25,25,24,19,14,7,0,0,0,0,0,0,0,0,0,0,0,3,12,19,24,27,27,27,25,22,16,10,1,0,0,0,0,0,0,0,0,0,0,14,24,27,27,27,27,27,27,22,11,0,0,0,0,0,9,20,27,27,27,27,27,27,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,8,15,20,24,27,30,30,27,24,20,14,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,23,27,29,30,29,26,22,17,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,27,35,38,38,38,38,38,34,27,36,43,48,50,50,50,46,41,33,23,12,0,0,0,0,0,0,0,0,7,26,40,49,53,53,53,53,53,53,47,36,21,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,26,36,45,49,52,52,49,44,36,25,13,0,0,0,0,7,26,40,49,53,53,53,53,53,53,48,37,21,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,22,33,41,46,50,50,50,48,44,38,30,19,4,0,0,0,0,0,0,0,1,14,24,34,42,47,50,50,50,50,45,40,33,23,12,0,0,0,0,0,0,0,0,19,36,48,53,53,53,53,53,52,45,31,13,0,0,0,11,28,42,51,53,53,53,53,53,47,34,17,0,0,0,0,0,0,0,0,0,0,11,21,30,38,44,49,52,55,55,51,48,43,37,29,21,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,17,27,36,42,47,50,54,55,53,50,47,41,34,25,15,5,0,0,0,0,0,0,0,0,0,0,0,0,13,31,48,59,63,63,63,63,63,58,49,59,67,73,76,76,74,70,64,56,45,33,19,4,0,0,0,0,0,0,21,43,60,73,78,78,78,78,78,78,69,55,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,17,33,46,58,67,73,76,76,73,66,57,45,31,17,0,0,0,21,43,60,73,78,78,78,78,78,78,71,56,37,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,31,44,55,65,70,74,76,75,73,68,61,53,40,22,2,0,0,0,0,0,7,22,35,47,57,65,71,76,76,76,73,69,64,56,45,33,19,4,0,0,0,0,0,13,33,53,69,76,76,76,76,76,75,66,49,28,6,0,1,24,45,63,74,76,76,76,76,75,69,53,33,11,0,0,0,0,0,0,0,5,19,32,44,53,61,69,73,76,78,78,76,73,67,61,53,43,32,21,8,0,0,0,0,0,0,0,0,0,0,0,0,2,16,29,40,50,59,66,72,75,77,78,76,75,71,65,57,48,38,26,13,0,0,0,0,0,0,0,0,0,0,1,25,46,67,82,88,88,88,88,88,81,71,81,90,96,99,99,98,93,87,78,66,53,38,22,4,0,0,0,0,7,30,54,75,94,104,104,104,104,104,102,88,68,47,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,33,49,65,79,89,98,101,101,97,89,77,64,48,31,14,0,7,30,54,75,94,104,104,104,104,104,103,90,71,49,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,51,65,78,88,95,99,101,99,98,93,85,75,58,37,14,0,0,0,0,11,27,42,56,69,79,88,95,99,101,99,98,93,86,78,66,53,38,21,4,0,0,0,0,21,44,67,89,101,101,101,101,101,99,83,62,38,14,0,9,34,57,79,97,101,101,101,101,101,87,66,43,19,0,0,0,0,0,0,8,24,38,52,65,75,84,92,97,101,104,103,100,96,91,83,75,65,54,42,28,14,0,0,0,0,0,0,0,0,0,0,6,21,36,49,62,72,81,90,96,99,101,104,101,99,94,88,80,70,59,47,33,18,2,0,0,0,0,0,0,0,0,6,31,54,78,99,111,111,111,111,111,97,92,104,113,119,124,124,121,117,109,99,87,72,56,38,21,2,0,0,0,10,33,58,81,104,129,129,129,129,129,121,96,73,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,27,46,64,82,98,110,121,124,124,119,109,96,80,63,45,25,0,10,33,58,81,104,129,129,129,129,129,121,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,51,69,85,100,112,119,124,124,124,121,116,109,93,70,46,21,0,0,0,11,29,46,61,76,89,100,111,118,123,124,124,121,116,109,99,87,73,56,38,20,0,0,0,0,25,48,73,98,123,124,124,124,124,116,93,68,43,17,0,12,38,63,88,114,124,124,124,124,121,98,73,48,22,0,0,0,0,0,7,24,42,58,72,86,97,107,115,121,124,129,129,124,121,114,106,97,87,75,62,48,33,17,0,0,0,0,0,0,0,0,6,22,40,56,70,83,95,105,113,119,123,129,129,124,121,117,111,103,92,81,67,53,37,21,3,0,0,0,0,0,0,0,7,33,55,81,104,129,139,139,139,129,103,113,124,137,145,149,150,147,142,134,121,107,91,73,55,36,16,0,0,0,10,33,58,81,104,129,154,154,154,147,121,96,73,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,56,75,95,113,132,144,152,152,144,130,112,93,73,53,33,0,10,33,58,81,104,129,154,154,154,149,121,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,24,46,67,86,105,121,136,145,150,152,152,148,142,121,96,73,48,22,0,0,7,27,46,64,80,95,109,123,135,143,148,152,149,147,141,134,121,107,91,73,54,33,13,0,0,0,25,48,73,99,124,152,152,152,144,116,93,68,43,17,0,12,38,63,88,114,142,152,152,149,121,99,73,48,22,0,0,0,0,2,22,41,58,76,92,107,119,132,140,147,150,152,152,150,145,139,132,119,108,96,82,67,51,32,14,0,0,0,0,0,0,4,22,40,58,74,90,104,116,129,137,144,149,152,154,152,149,143,136,124,114,101,87,71,55,37,19,0,0,0,0,0,0,0,7,33,55,81,104,129,154,165,155,132,119,136,147,159,168,173,175,172,165,154,141,124,107,89,69,49,28,7,0,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,60,81,102,123,144,163,175,175,161,142,121,101,79,58,38,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,80,101,121,141,157,168,175,170,170,165,141,116,91,67,43,19,0,0,18,40,61,80,98,114,130,144,156,166,172,175,174,170,164,155,143,124,107,88,67,46,23,1,0,0,25,48,73,99,124,152,175,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,0,14,35,55,74,92,110,124,141,153,163,170,175,178,177,173,168,162,153,143,130,116,101,85,66,46,22,0,0,0,0,0,0,19,38,57,74,92,109,124,139,150,160,167,173,176,178,175,172,166,158,148,136,121,105,89,71,53,34,15,0,0,0,0,0,0,7,33,55,81,104,129,154,177,160,139,141,155,163,155,152,152,155,164,177,175,161,143,121,103,82,61,39,17,0,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,40,60,81,104,124,147,167,183,183,165,144,121,101,81,58,38,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,68,91,114,137,157,177,171,155,146,144,147,135,109,85,61,37,13,0,0,24,49,72,95,114,134,150,165,166,157,152,149,152,160,172,176,161,143,121,100,78,56,33,9,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,4,25,48,69,88,109,129,146,161,174,173,163,157,155,154,157,162,169,175,164,150,137,119,99,75,52,29,4,0,0,0,0,11,32,52,72,91,110,129,144,159,172,177,167,160,157,154,157,161,169,179,170,157,141,123,107,88,69,49,28,8,0,0,0,0,0,7,33,55,81,104,129,154,177,173,160,162,153,140,132,129,129,134,143,157,175,177,157,137,114,92,71,49,26,4,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,27,2,0,6,7,7,7,7,7,7,5,0,0,0,0,0,17,38,58,78,98,117,137,152,160,159,150,136,116,97,77,56,36,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,27,18,20,20,18,15,9,2,0,0,0,0,0,0,0,0,0,0,1,25,50,75,98,121,147,170,175,154,136,121,117,121,129,103,79,55,31,7,0,0,25,50,73,98,119,137,154,160,146,135,129,124,129,139,154,171,177,156,134,110,87,64,40,16,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,12,35,57,80,100,121,143,162,180,166,152,140,134,132,132,134,139,147,157,169,155,137,116,97,74,51,27,4,0,0,0,0,23,45,66,86,107,124,146,162,179,170,155,145,137,132,132,132,138,147,158,173,175,161,143,121,103,83,62,41,20,0,0,0,0,0,7,33,55,81,104,129,154,177,181,162,147,132,117,108,101,102,109,121,141,161,182,169,147,124,102,79,57,34,11,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,27,12,23,31,33,33,33,33,33,33,30,22,9,0,0,0,11,31,50,69,88,103,117,130,135,134,129,117,101,86,67,48,29,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,39,43,43,43,42,38,33,24,14,2,0,0,0,0,0,0,0,0,5,30,55,80,104,129,154,178,167,143,118,99,93,98,104,92,71,49,24,1,0,0,20,43,65,83,101,117,136,141,124,111,102,101,105,117,137,158,180,165,142,116,93,70,45,20,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,19,42,65,88,110,135,155,177,169,149,132,117,109,105,104,108,114,124,136,148,139,119,101,83,64,44,21,0,0,0,0,11,33,55,78,99,119,141,161,180,168,152,136,121,112,106,104,106,114,124,139,155,173,177,157,138,116,96,74,51,30,8,0,0,0,0,7,33,55,81,104,129,154,177,173,147,129,112,98,85,78,78,88,106,129,149,172,179,156,134,109,86,63,40,16,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,27,31,45,53,55,55,55,55,55,55,52,42,26,9,0,0,2,21,38,56,71,86,97,106,109,109,106,97,85,71,54,37,19,0,10,33,58,81,104,129,154,177,172,149,121,99,76,57,63,67,68,68,67,62,56,46,35,22,6,0,0,0,0,0,0,11,27,38,57,81,106,134,158,182,162,137,111,86,68,74,78,72,56,37,15,0,0,0,11,32,49,67,83,99,116,123,105,91,80,76,83,103,124,150,173,170,147,121,96,73,48,22,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,24,47,71,93,116,142,164,181,160,137,114,96,85,81,81,84,91,101,114,129,123,105,86,67,49,30,11,0,0,0,0,20,43,66,88,110,134,155,175,173,153,134,116,100,89,82,80,83,91,103,119,139,157,178,172,152,130,107,84,62,40,16,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,78,64,54,55,73,95,117,142,164,186,163,139,114,91,68,45,21,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,29,48,65,77,81,81,81,81,81,81,75,62,42,22,1,0,0,16,34,51,67,76,78,81,83,83,81,78,75,65,49,32,14,0,10,33,58,81,104,129,154,177,172,149,121,99,76,80,87,91,93,93,91,86,79,69,56,40,24,7,0,0,0,0,8,29,45,59,68,83,109,134,160,185,162,137,109,83,71,71,67,54,37,21,3,0,0,0,0,15,32,49,65,82,97,102,87,71,57,52,71,96,119,147,170,172,148,121,96,73,48,22,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,2,25,48,73,96,119,147,170,180,154,132,106,83,63,56,56,61,69,80,94,107,107,90,71,52,33,15,0,0,0,0,5,28,52,74,98,121,144,166,182,161,139,117,98,81,67,58,55,59,69,85,103,123,144,165,184,163,140,116,93,71,49,24,1,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,31,42,65,88,111,137,160,183,167,144,119,96,71,48,24,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,45,64,82,99,106,106,106,106,106,106,96,76,53,30,8,0,4,25,45,64,84,99,104,104,104,104,104,104,98,81,61,42,22,0,10,33,58,81,104,129,154,177,172,147,121,99,92,103,110,116,117,117,115,110,101,89,74,58,41,22,2,0,0,0,19,42,62,81,93,93,109,137,160,185,162,137,109,96,96,96,90,72,49,25,1,0,0,0,0,0,15,31,47,63,76,78,69,53,37,55,75,98,121,147,172,168,146,119,96,71,47,22,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,2,25,48,73,96,119,147,170,180,156,132,108,88,72,61,52,42,48,60,74,85,85,72,56,37,18,0,0,0,0,0,12,35,59,82,106,130,153,176,172,150,129,105,84,64,47,35,32,36,50,69,89,109,132,155,178,172,149,124,101,78,55,32,8,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,37,60,83,107,134,157,180,170,147,121,98,73,50,25,0,10,33,58,81,104,129,154,177,170,147,121,96,73,50,60,79,98,116,134,134,134,134,134,124,103,81,55,32,10,0,7,27,48,68,91,111,132,132,132,132,132,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,170,147,121,99,113,124,135,141,144,144,140,134,123,109,92,74,55,35,14,0,0,0,24,50,72,97,116,119,121,137,160,185,162,137,121,121,121,121,106,80,55,30,4,0,0,0,0,0,0,13,29,44,51,55,47,36,49,69,88,109,132,154,177,161,139,114,90,67,43,19,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,24,48,71,94,118,143,165,185,163,141,121,106,93,84,74,65,56,47,53,60,60,51,38,22,3,0,0,0,0,0,17,41,65,88,112,137,160,184,165,142,116,95,72,50,30,12,7,15,35,55,77,99,121,147,170,180,156,134,109,85,61,37,13,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,35,58,81,106,132,155,180,172,147,121,99,73,50,25,0,10,33,58,81,104,129,154,177,170,147,121,96,73,57,76,94,112,132,150,157,157,146,129,109,92,73,51,28,6,0,7,27,48,68,91,111,134,157,157,157,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,170,147,121,119,135,147,158,165,170,168,165,157,144,129,108,88,67,47,25,4,0,0,25,50,73,99,124,146,147,152,167,189,169,152,149,149,149,134,106,81,55,30,5,0,0,0,0,0,0,0,10,22,29,30,26,45,64,83,101,121,144,164,170,149,129,105,82,60,36,12,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,20,43,67,90,112,137,157,179,175,157,141,129,115,106,97,88,79,70,60,50,40,31,19,4,0,0,0,0,0,0,21,45,70,93,116,143,166,183,159,136,109,87,63,40,17,0,0,0,23,45,69,92,114,140,163,187,162,139,114,90,66,42,18,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,35,58,83,106,132,155,180,172,147,121,99,73,50,25,0,10,33,58,81,104,129,154,177,170,147,121,96,73,73,91,109,129,147,166,167,149,132,112,94,76,58,39,20,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,167,144,123,141,155,165,162,162,163,171,183,178,162,143,121,100,79,57,34,12,0,0,25,50,73,99,124,152,172,173,184,202,184,173,172,172,157,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,4,22,42,61,80,98,117,137,157,175,155,136,114,93,72,50,28,5,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,14,36,60,82,103,124,146,165,182,175,161,149,139,130,119,110,101,92,83,73,62,50,36,22,6,0,0,0,0,0,25,48,73,96,121,147,170,178,154,132,105,81,57,33,10,0,0,0,15,38,62,86,109,136,160,183,167,144,116,93,69,45,20,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,37,61,85,108,134,157,181,170,146,121,96,73,50,25,0,10,33,58,81,104,129,154,177,170,147,121,96,73,88,107,124,144,162,170,152,134,114,96,78,60,42,24,6,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,154,147,159,152,143,137,137,140,150,164,182,175,154,132,109,87,64,41,19,0,0,25,50,73,99,124,149,149,152,167,189,169,152,149,149,149,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,14,36,56,76,95,114,134,154,171,159,141,119,101,81,60,39,17,0,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,7,28,49,71,91,110,132,148,164,178,182,171,162,153,144,135,124,115,105,95,83,71,56,40,22,6,0,0,0,2,27,50,76,99,124,149,173,175,152,129,101,78,53,29,5,0,0,0,10,34,58,83,106,132,157,180,170,147,119,96,71,48,22,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,43,66,89,111,137,160,184,165,142,117,93,70,47,22,0,10,33,58,81,104,129,154,177,170,147,121,96,85,103,121,141,160,171,154,136,116,98,80,62,44,26,8,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,186,173,159,144,130,118,111,111,116,130,148,169,185,162,139,116,93,70,46,24,0,0,25,50,73,98,121,121,121,137,160,185,162,137,121,121,121,121,105,80,55,30,4,0,0,0,0,0,0,0,0,4,25,48,69,90,110,130,150,168,161,143,123,105,86,67,47,26,6,0,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,0,16,38,58,77,96,112,130,144,157,167,178,184,175,165,156,147,138,129,116,104,90,74,56,40,21,2,0,0,2,27,50,76,101,124,152,175,175,150,124,99,76,50,27,2,0,0,0,7,32,55,81,104,132,154,180,172,147,121,96,73,48,22,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,49,43,55,75,97,119,143,165,183,160,137,113,90,66,43,19,0,10,33,58,81,104,129,154,177,170,147,121,96,101,119,139,157,173,155,137,117,99,82,64,46,28,11,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,177,157,141,123,109,96,88,86,95,114,137,160,182,167,144,119,96,73,50,27,0,0,20,43,65,85,96,96,109,137,160,185,162,137,109,96,96,96,90,72,49,25,1,0,0,0,0,0,0,0,0,14,36,58,81,103,123,145,164,166,146,129,107,89,71,52,32,13,0,0,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,0,5,24,43,62,78,94,109,123,136,146,155,164,174,183,179,170,161,150,139,123,109,91,74,55,35,15,0,0,2,27,53,76,101,124,152,176,175,149,124,99,76,50,25,2,0,0,0,7,30,55,80,104,132,154,180,172,149,121,96,73,48,22,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,81,72,68,74,89,108,130,151,173,174,152,130,106,83,60,37,14,0,10,33,58,81,104,129,154,177,170,147,121,98,116,136,154,172,158,140,121,103,85,67,49,31,13,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,123,105,91,76,64,63,84,106,132,154,177,171,147,121,99,76,52,27,0,0,11,30,49,64,71,83,109,137,160,185,162,137,109,83,71,71,67,54,36,15,0,0,0,0,0,0,0,0,0,21,45,68,91,113,137,158,175,154,132,112,92,73,55,36,17,0,0,0,0,0,25,48,73,99,124,152,177,170,144,116,93,68,43,17,0,12,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,0,0,9,28,44,60,76,89,101,112,121,132,142,152,161,170,180,183,172,159,144,124,107,88,69,47,26,4,0,2,27,50,76,101,124,152,175,175,152,124,101,76,52,27,4,0,0,0,8,32,56,81,104,132,155,180,172,147,121,96,73,48,22,0,0,0,7,33,55,81,104,129,154,177,173,148,130,114,103,95,91,97,108,123,143,163,183,164,143,119,98,75,53,30,7,0,10,33,58,81,104,129,154,177,170,147,121,113,132,150,169,160,143,123,105,87,69,51,33,15,0,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,56,42,57,80,104,129,152,175,172,149,121,99,76,53,27,0,0,0,15,29,41,58,83,109,137,160,185,162,137,109,83,58,45,43,33,18,0,0,0,0,0,0,0,0,0,3,28,51,75,99,121,146,169,165,143,119,98,77,57,38,20,2,0,0,0,0,0,24,48,73,99,124,152,177,170,144,118,93,68,43,17,0,14,38,63,88,114,142,167,175,149,121,99,73,48,22,0,0,0,0,0,0,10,26,42,56,69,80,90,100,109,118,129,139,148,158,170,184,178,161,143,121,100,79,57,36,12,0,2,26,50,75,99,123,149,172,177,152,129,103,78,55,30,6,0,0,0,11,35,60,83,107,134,157,182,170,144,119,95,71,46,22,0,0,0,7,33,55,81,104,129,154,177,181,164,149,137,124,119,116,119,129,143,159,177,171,152,132,109,88,66,44,22,0,0,10,33,58,81,104,129,154,177,170,147,121,130,148,166,175,149,124,107,89,71,53,35,17,0,0,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,18,10,0,0,0,0,0,0,0,0,0,0,7,31,55,80,104,129,154,177,156,132,109,87,65,44,24,4,0,0,0,0,0,0,22,48,73,99,124,151,175,170,145,119,93,68,44,19,0,15,40,66,91,114,142,167,175,149,121,96,73,48,22,0,0,0,0,0,0,12,23,31,35,47,57,67,77,87,96,106,115,124,137,150,166,182,176,156,134,110,89,65,43,19,0,0,24,48,73,96,121,146,170,180,156,132,106,83,59,35,12,0,0,0,17,40,64,88,111,137,160,185,165,142,116,93,68,44,20,0,0,0,7,33,55,81,104,129,154,177,177,162,157,158,150,144,142,144,152,163,177,171,155,137,117,97,76,56,34,13,0,0,10,33,58,81,104,129,154,177,170,147,124,144,163,181,180,158,139,118,98,79,59,39,19,0,0,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,7,33,58,81,106,132,157,162,152,129,101,78,54,32,11,0,0,0,0,0,0,0,22,47,72,96,121,149,173,172,147,121,96,71,47,22,0,18,43,68,93,116,144,168,172,147,121,96,71,45,20,0,0,0,0,0,13,31,45,55,58,53,41,45,55,64,73,83,92,103,115,132,148,169,187,165,142,117,95,72,48,24,0,0,20,44,68,92,116,142,165,184,161,137,113,90,66,43,21,0,0,4,25,48,71,94,116,142,165,185,161,138,112,88,65,40,16,0,0,0,7,33,55,81,104,129,154,177,168,145,134,148,162,168,167,168,175,175,165,152,137,119,103,83,64,44,23,2,0,0,10,33,58,81,104,129,154,177,177,157,150,161,168,160,165,172,152,132,112,91,72,52,32,12,0,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,106,132,139,139,139,124,101,76,50,27,2,0,0,0,0,0,0,0,20,45,70,93,119,145,170,175,150,124,101,76,52,28,12,25,49,73,98,121,147,172,169,144,117,93,68,43,19,0,0,0,0,11,30,47,65,79,83,75,60,45,32,42,51,61,71,82,96,114,137,159,182,170,147,121,98,73,50,26,0,0,16,39,64,87,110,136,158,182,168,144,119,98,75,54,33,16,10,19,38,58,80,102,124,149,172,178,155,132,106,83,60,36,12,0,0,0,7,33,55,81,104,129,154,177,170,144,119,129,140,150,157,160,157,152,144,132,117,103,85,69,50,31,11,0,0,0,10,33,58,81,104,129,154,177,191,179,175,168,150,135,147,168,165,146,124,105,85,65,45,25,6,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,6,30,54,78,99,111,111,111,111,111,97,73,51,26,1,0,0,0,0,0,0,0,16,41,65,91,115,141,165,180,155,132,107,83,61,42,37,41,59,81,104,129,152,176,164,139,114,90,65,40,15,0,0,0,10,27,46,64,82,99,106,94,80,66,54,44,37,38,48,62,83,106,132,155,180,172,149,121,99,76,50,27,0,0,10,33,57,80,104,129,150,173,176,154,132,108,88,67,51,38,35,40,54,72,92,113,136,158,180,170,147,123,100,77,53,30,6,0,0,0,7,33,55,81,104,129,154,177,170,144,119,106,117,124,134,137,134,129,119,109,98,83,69,51,35,16,0,0,0,0,10,33,58,81,104,129,154,177,200,187,170,152,134,115,136,155,175,159,139,117,98,79,58,38,19,0,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,0,23,45,65,82,88,89,91,88,88,79,63,41,19,0,0,0,0,0,0,0,0,12,36,61,85,109,136,159,183,163,140,116,95,76,65,60,64,74,93,114,138,161,182,158,134,109,84,60,35,11,0,0,7,25,43,61,80,98,116,130,114,99,87,75,67,61,58,61,68,86,108,132,156,180,170,147,121,98,73,50,27,0,0,3,26,49,72,95,118,141,163,185,164,143,121,101,85,71,61,58,62,73,88,106,124,147,169,181,160,138,114,91,69,46,23,0,0,0,0,7,33,55,81,104,129,154,177,170,147,121,96,95,102,106,109,109,103,97,88,76,64,49,34,17,1,0,0,0,0,10,33,58,81,104,129,154,177,188,171,154,136,116,101,121,143,163,172,152,132,112,92,72,52,32,12,0,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,9,31,52,71,89,103,112,114,112,101,87,70,50,30,8,0,0,0,0,0,0,0,6,30,55,79,102,129,150,173,173,152,130,110,96,88,86,88,96,110,129,149,171,172,150,124,101,77,53,30,5,0,0,19,40,59,77,95,113,134,148,134,119,108,98,90,85,83,85,90,101,118,140,162,185,163,140,116,93,70,47,23,0,0,0,18,41,63,86,107,130,152,172,177,157,137,119,104,92,85,83,86,94,107,123,141,161,181,169,148,124,104,82,59,37,14,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,79,83,86,83,80,74,66,56,44,30,16,1,0,0,0,0,0,10,33,58,81,104,129,154,177,174,155,137,117,99,89,109,130,150,171,165,145,124,105,85,65,45,26,5,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,19,42,64,86,106,123,137,142,137,121,105,84,63,40,18,0,0,0,0,0,0,0,0,23,47,70,93,116,140,162,182,166,148,132,117,111,109,111,117,130,146,164,182,161,139,115,92,69,46,22,0,0,3,27,50,73,92,110,130,148,166,154,143,132,121,114,109,106,109,114,121,137,154,173,173,153,132,109,87,64,41,18,0,0,0,8,31,53,74,96,116,139,158,177,173,155,139,124,115,109,106,110,116,129,143,159,177,173,154,136,113,92,71,49,28,5,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,56,58,60,60,56,51,43,33,22,10,0,0,0,0,0,0,0,10,33,58,81,104,129,154,177,170,147,121,101,83,76,97,117,138,158,179,158,139,117,98,78,58,38,19,0,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,1,25,49,73,97,119,141,158,165,157,139,117,95,72,48,25,0,0,0,0,0,0,0,0,15,38,61,83,105,129,148,168,182,165,152,142,137,134,137,142,152,164,180,167,148,124,105,82,59,37,14,0,0,5,30,53,76,101,124,143,158,172,175,164,153,144,139,134,134,134,138,145,156,171,175,158,140,118,98,76,55,33,11,0,0,0,0,20,41,62,83,103,123,143,161,175,173,160,148,139,134,134,136,141,150,162,177,173,157,139,119,99,80,59,38,16,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,35,35,35,32,27,20,11,0,0,0,0,0,0,0,0,0,10,33,58,81,104,129,154,177,170,147,121,96,73,64,84,105,124,146,166,172,152,132,110,91,72,52,32,12,0,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,4,29,53,78,101,129,152,175,189,173,150,124,101,76,52,27,4,0,0,0,0,0,0,0,5,27,49,71,92,112,134,150,165,178,173,165,160,160,160,165,172,178,165,150,132,112,92,71,49,27,4,0,0,4,27,49,72,91,107,123,139,152,164,174,176,168,162,160,157,160,162,168,178,170,156,141,123,105,86,66,45,23,2,0,0,0,0,8,28,50,69,88,107,124,141,156,170,180,170,163,160,157,160,164,172,179,167,154,138,121,103,85,65,45,25,5,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,25,12,11,8,4,0,0,0,0,0,0,0,0,0,0,0,10,33,58,81,104,129,154,177,170,147,121,96,73,51,72,92,112,134,154,174,165,146,124,105,85,65,45,25,5,0,7,27,48,68,91,111,134,157,177,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,185,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,5,30,53,78,103,129,153,177,198,176,152,129,101,78,53,27,4,0,0,0,0,0,0,0,0,15,37,58,78,96,114,132,145,156,164,170,172,172,172,170,163,156,144,130,114,96,76,57,36,15,0,0,0,0,17,38,56,74,89,103,117,130,141,152,159,165,170,173,175,173,170,165,157,147,136,121,105,89,71,52,32,12,0,0,0,0,0,0,15,34,54,71,89,105,121,136,147,157,165,170,173,175,172,169,163,155,145,134,117,103,85,68,50,31,12,0,0,0,0,0,0,7,33,55,81,104,129,154,172,172,147,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,58,81,104,129,154,175,170,147,121,96,73,50,59,79,99,119,141,161,175,158,139,117,98,78,58,38,17,0,7,27,48,68,91,111,134,157,175,175,152,132,109,88,66,45,25,0,10,33,58,81,104,129,154,175,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,160,175,162,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,3,27,52,75,99,123,146,165,173,164,145,121,98,74,50,26,1,0,0,0,0,0,0,0,0,2,23,43,62,80,95,110,123,134,141,146,149,149,149,146,141,134,121,109,95,78,60,42,22,2,0,0,0,0,5,22,40,55,70,84,97,108,118,129,137,142,147,149,149,149,147,142,135,124,114,101,87,71,55,37,18,0,0,0,0,0,0,0,0,20,37,55,71,87,101,114,124,135,142,147,149,149,149,146,140,134,123,112,98,83,69,51,33,16,0,0,0,0,0,0,0,7,33,55,81,104,129,149,149,149,147,121,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,58,81,104,129,149,149,149,147,121,96,73,50,47,67,87,107,129,149,149,149,149,132,110,91,69,48,25,0,7,27,48,68,91,111,134,149,149,149,149,132,109,88,66,45,25,0,10,33,58,81,104,129,149,149,149,149,121,99,76,53,33,55,78,101,129,149,149,149,149,121,99,76,53,27,0,0,0,0,7,33,58,83,109,137,149,149,149,137,109,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,22,45,67,90,110,132,145,149,144,130,109,89,66,44,20,0,0,0,0,0,0,0,0,0,0,8,26,44,61,76,90,101,109,116,119,121,121,121,119,116,109,100,89,76,61,44,26,7,0,0,0,0,0,0,6,21,36,50,63,75,86,96,104,111,116,121,121,121,121,121,116,110,102,92,81,68,53,37,21,3,0,0,0,0,0,0,0,0,3,21,37,53,67,80,91,101,110,116,119,121,121,121,119,115,109,100,89,78,64,49,33,17,0,0,0,0,0,0,0,0,7,32,55,80,103,121,121,121,121,121,119,96,73,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,32,58,80,103,121,121,121,121,121,119,96,73,50,34,55,74,95,115,121,121,121,121,121,117,96,73,50,25,0,7,27,48,68,91,110,121,121,121,121,121,121,108,88,65,45,25,0,10,32,58,80,103,121,121,121,121,121,119,98,75,53,32,55,78,101,121,121,121,121,121,119,98,75,53,27,0,0,0,0,7,32,58,83,108,121,121,121,121,121,108,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,13,36,57,77,96,110,121,121,119,109,94,76,55,33,12,0,0,0,0,0,0,0,0,0,0,0,10,27,42,56,69,79,86,93,96,99,99,99,96,93,86,78,67,56,42,26,8,0,0,0,0,0,0,0,0,2,16,30,42,54,64,73,81,88,93,96,99,99,99,96,93,87,79,70,59,47,34,19,3,0,0,0,0,0,0,0,0,0,0,2,18,33,46,58,70,79,86,93,96,99,99,99,96,91,85,77,67,56,44,30,15,0,0,0,0,0,0,0,0,0,3,28,49,72,88,98,99,99,99,99,97,83,65,42,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,52,73,90,99,99,99,99,99,98,85,66,45,24,42,62,81,96,99,99,99,99,99,98,87,66,45,24,0,4,24,43,62,81,95,99,99,99,99,99,99,93,79,59,41,21,0,6,28,52,73,90,99,99,99,99,99,98,87,69,48,28,50,71,89,99,99,99,99,99,98,87,69,48,24,0,0,0,0,4,28,52,75,93,99,99,99,99,99,93,75,52,31,6,0,0,0,0,0,0,0,0,0,0,0,2,23,43,60,76,89,98,99,97,88,76,58,41,21,1,0,0,0,0,0,0,0,0,0,0,0,0,7,22,35,47,57,64,69,73,73,73,73,73,69,63,56,46,35,22,7,0,0,0,0,0,0,0,0,0,0,0,9,21,32,41,50,58,64,69,73,73,73,73,73,69,64,57,48,38,27,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,26,37,48,57,63,69,73,73,73,73,72,68,62,55,46,34,24,10,0,0,0,0,0,0,0,0,0,0,0,18,38,56,68,73,73,73,73,73,73,65,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,56,68,73,73,73,73,73,73,65,51,33,14,29,47,62,72,73,73,73,73,73,73,65,51,33,14,0,0,14,31,47,62,71,73,73,73,73,73,73,70,61,45,29,12,0,0,18,40,56,68,73,73,73,73,73,73,66,53,36,18,38,55,67,73,73,73,73,73,73,66,53,36,14,0,0,0,0,0,18,40,58,70,73,73,73,73,73,70,58,40,21,0,0,0,0,0,0,0,0,0,0,0,0,0,8,26,43,56,67,73,73,73,66,55,42,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,24,33,40,45,49,50,50,50,49,45,40,33,24,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,27,34,40,45,48,50,50,50,48,45,40,33,25,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,24,33,39,45,48,50,50,49,47,44,38,32,23,13,2,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,45,48,48,48,48,48,48,42,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,35,45,48,48,48,48,48,48,42,31,17,0,13,28,40,47,48,48,48,48,48,47,42,31,17,0,0,0,0,15,28,40,46,48,48,48,48,48,48,46,39,27,13,0,0,0,4,22,35,45,48,48,48,48,48,48,43,33,19,4,20,34,44,48,48,48,48,48,48,43,33,19,0,0,0,0,0,0,4,22,37,46,48,48,48,48,48,46,37,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,23,34,44,50,50,49,43,33,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,17,22,25,25,25,25,25,22,17,10,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,16,20,24,25,25,25,23,20,16,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,16,20,24,25,25,25,23,19,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,22,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,22,25,25,25,25,25,25,20,12,0,0,0,9,19,24,25,25,25,25,25,25,21,12,0,0,0,0,0,0,9,19,24,25,25,25,25,25,25,23,18,8,0,0,0,0,0,4,15,22,25,25,25,25,25,25,21,13,1,0,2,14,22,25,25,25,25,25,25,21,13,1,0,0,0,0,0,0,0,2,14,21,22,22,22,22,22,21,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,13,21,25,25,25,20,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,7,10,10,10,10,10,10,6,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,6,17,25,27,27,27,27,27,27,24,15,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,22,26,28,30,29,27,23,19,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,20,24,27,30,30,27,24,20,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,21,26,27,27,26,21,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,20,25,29,30,28,24,19,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,22,27,30,30,26,21,14,4,0,0,0,0,0,0,0,7,20,28,30,30,30,29,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,10,19,26,27,27,27,27,27,27,25,18,9,0,0,0,0,0,0,0,11,20,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,9,22,30,33,33,33,33,33,32,28,20,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,24,40,49,53,53,53,53,53,53,48,37,21,4,0,0,0,0,0,0,0,0,0,0,0,9,19,28,36,41,47,50,53,55,55,50,47,42,35,27,17,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,22,30,38,44,48,51,55,55,51,48,44,36,28,17,6,0,0,0,0,0,0,0,0,0,2,15,26,37,45,50,52,52,49,45,36,26,15,1,0,0,0,0,0,0,0,0,0,0,0,0,12,24,35,43,49,54,55,53,49,43,34,23,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,17,29,38,46,51,55,55,50,45,37,27,14,0,0,0,0,0,7,26,42,53,55,55,55,55,47,34,17,0,0,0,0,0,0,0,0,0,0,0,15,29,42,51,53,53,53,53,53,53,49,41,28,13,0,0,0,0,0,15,32,44,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,44,32,17,0,0,0,9,26,42,52,55,55,55,55,55,55,50,39,22,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,22,41,58,71,76,76,76,76,76,75,69,55,37,17,0,0,0,0,0,0,0,0,0,7,19,31,41,51,59,65,71,75,76,78,78,75,72,66,59,49,39,28,16,2,0,0,0,0,0,0,0,0,0,0,0,0,9,22,33,45,54,62,68,73,76,78,78,76,73,67,60,50,40,28,14,1,0,0,0,0,0,0,4,19,33,47,58,67,73,76,76,73,67,58,47,33,19,2,0,0,0,0,0,0,0,0,0,2,18,33,46,58,67,73,77,78,76,73,66,56,45,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,37,50,61,70,75,78,78,75,69,59,48,34,19,1,0,0,0,21,41,60,74,78,78,78,77,67,51,30,7,0,0,0,0,0,0,0,0,0,11,28,47,61,73,76,76,76,76,76,76,72,60,45,26,8,0,0,0,8,31,49,66,75,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,75,67,51,33,11,0,0,21,41,60,73,78,78,78,78,78,78,71,56,36,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,52,74,92,101,101,101,101,101,101,89,70,48,26,0,0,0,0,0,0,0,0,12,26,40,52,64,73,81,90,95,99,101,104,101,99,96,89,81,72,61,49,36,21,6,0,0,0,0,0,0,0,0,0,0,14,29,43,55,66,76,85,91,96,100,103,104,101,96,90,82,72,61,48,35,20,4,0,0,0,0,0,18,35,51,65,79,89,97,101,101,97,89,78,64,49,34,17,0,0,0,0,0,0,0,0,1,19,37,53,67,79,90,97,101,104,101,96,89,78,65,49,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,40,56,71,83,93,99,104,103,98,91,81,68,53,37,19,0,0,11,32,54,75,96,104,104,104,101,84,64,40,15,0,0,0,0,0,0,0,0,0,19,39,60,79,95,101,101,101,101,101,101,94,76,58,36,16,0,0,0,16,41,64,85,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,85,64,43,19,0,5,30,52,75,94,104,104,104,104,104,103,90,71,47,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,103,124,124,124,124,124,121,98,76,53,30,0,0,0,0,0,0,0,15,31,46,61,74,86,96,105,113,119,121,124,129,129,124,119,113,104,93,82,69,55,40,24,6,0,0,0,0,0,0,0,0,17,33,49,63,76,88,99,108,115,121,124,129,129,124,121,114,105,94,82,69,54,38,22,4,0,0,0,11,30,48,66,82,98,110,119,124,124,119,109,96,81,64,47,29,9,0,0,0,0,0,0,0,16,36,55,72,87,100,113,121,124,129,124,119,112,99,84,67,48,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,19,38,56,74,91,105,116,123,129,129,121,114,103,88,71,53,34,14,0,22,44,65,87,109,129,129,129,116,91,66,43,17,0,0,0,0,0,0,0,0,0,22,43,66,88,109,129,129,129,129,129,129,106,83,63,40,20,0,0,0,20,45,71,96,118,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,96,71,48,22,0,7,33,55,81,104,129,129,129,129,129,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,152,152,152,149,121,99,76,53,30,0,0,0,0,0,0,15,31,49,65,80,95,107,118,129,137,144,149,152,154,152,149,144,137,129,115,103,89,74,58,40,22,2,0,0,0,0,0,0,16,33,51,67,83,97,109,121,132,140,146,150,152,152,150,145,138,129,115,103,89,73,56,40,20,0,0,0,19,39,58,78,96,113,130,143,150,150,143,130,112,95,76,57,37,18,0,0,0,0,0,0,7,30,51,71,89,107,121,136,146,152,154,152,145,135,119,101,83,62,40,19,0,0,0,0,0,0,0,0,0,0,0,0,11,32,52,73,92,109,124,139,148,152,152,147,137,121,105,88,69,48,28,11,33,55,76,98,121,144,152,130,106,84,63,39,14,0,0,0,0,0,0,0,0,0,22,43,66,86,109,134,152,152,152,152,129,106,83,63,40,19,0,0,0,20,45,71,96,119,147,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,96,71,48,22,0,7,32,55,80,104,129,152,152,152,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,175,172,149,121,99,76,53,30,0,0,0,0,0,12,30,49,65,83,99,114,129,141,152,160,167,172,175,178,176,173,167,159,149,137,123,109,92,74,55,33,10,0,0,0,0,0,12,31,50,67,85,101,116,132,144,154,163,169,174,177,177,174,168,160,149,137,121,107,91,74,53,30,8,0,4,24,45,65,85,105,124,145,162,173,173,161,143,123,103,84,64,44,23,0,0,0,0,0,0,19,41,64,86,105,124,143,157,167,159,157,160,167,155,138,117,97,74,51,28,5,0,0,0,0,0,0,0,0,0,0,0,21,44,65,87,107,129,146,161,153,147,147,155,158,143,123,103,82,61,39,22,45,66,88,109,134,155,140,117,95,73,51,29,7,0,0,0,0,0,0,0,0,0,22,43,66,86,109,132,154,175,172,149,129,104,83,60,40,17,0,0,0,20,45,71,96,119,147,172,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,96,71,48,22,0,6,30,53,78,101,124,152,175,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,0,0,5,26,45,64,83,99,117,135,149,162,174,177,167,160,157,154,155,157,163,172,171,158,144,129,108,85,63,40,14,0,0,0,0,6,26,46,65,84,103,119,137,152,165,177,173,164,158,155,154,157,163,172,171,158,143,124,107,85,60,37,12,0,5,25,48,68,88,109,132,152,172,191,190,170,149,129,106,86,66,45,25,0,0,0,0,0,4,28,52,75,97,119,141,161,164,146,136,132,136,150,168,154,132,107,84,60,36,12,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,143,162,148,132,119,121,136,152,158,139,116,93,72,49,33,56,78,99,121,145,150,129,106,83,62,40,17,0,0,0,0,0,0,0,0,0,0,20,43,65,86,109,132,154,175,172,149,129,104,81,60,38,17,0,0,0,20,45,71,96,119,147,154,154,154,154,154,154,154,154,154,154,155,166,187,184,164,144,121,96,71,48,22,0,5,29,53,76,101,124,149,175,172,149,121,99,74,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,0,0,17,39,59,79,98,116,136,154,168,180,166,154,144,137,132,132,132,134,140,150,162,161,143,123,105,84,61,39,14,0,0,0,0,19,39,60,80,99,118,139,155,171,177,163,150,141,134,132,132,134,139,150,162,161,143,123,105,83,59,36,11,0,5,25,47,67,88,108,129,149,168,186,184,167,147,129,106,86,66,45,25,0,0,0,0,0,11,35,59,83,107,132,154,171,148,129,112,106,113,134,156,164,140,114,90,65,41,17,0,0,0,0,0,0,0,0,0,0,13,38,61,85,108,132,155,156,134,112,97,99,116,139,161,150,129,103,80,57,45,67,89,110,134,156,139,116,95,72,50,29,6,0,0,0,0,0,0,0,0,0,0,20,43,63,86,106,132,152,175,170,149,124,104,81,60,38,17,0,0,0,20,45,71,96,119,129,129,129,129,129,129,129,129,129,129,129,132,155,180,171,150,130,108,87,65,43,19,0,5,27,53,76,99,124,149,173,172,147,121,99,73,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,0,8,29,50,72,92,112,134,152,170,179,162,146,134,121,113,106,104,106,109,116,129,141,144,124,107,89,72,52,31,8,0,0,0,8,30,51,72,93,114,136,154,173,176,159,143,130,117,109,106,104,109,116,129,143,144,124,107,89,71,50,28,6,0,2,22,43,62,82,101,119,139,154,162,162,154,137,118,100,81,61,41,21,0,0,0,0,0,14,40,65,90,114,139,163,162,138,114,92,81,101,124,150,170,144,118,93,68,43,17,0,0,0,0,0,0,0,0,0,0,19,43,67,91,115,140,163,147,121,99,78,82,104,129,152,160,136,110,86,63,56,78,100,121,145,149,129,105,83,61,39,17,0,0,0,0,0,0,0,0,0,0,0,20,40,63,84,106,130,152,173,170,147,124,101,81,58,37,15,0,0,0,17,41,65,87,101,104,104,104,104,104,104,104,104,104,104,118,141,161,179,158,137,116,95,74,53,33,11,0,4,27,51,76,99,121,147,172,170,147,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,0,17,39,62,83,104,124,146,167,181,162,144,129,112,99,89,83,80,81,85,95,107,121,129,109,91,73,55,37,19,0,0,0,0,17,40,62,83,105,129,148,168,179,160,141,123,108,95,86,81,81,85,95,107,121,124,107,90,72,54,36,17,0,0,0,16,35,54,72,90,107,121,134,139,139,132,119,105,89,71,53,34,14,0,0,0,0,0,17,42,67,91,116,144,167,157,134,106,82,73,99,123,149,170,146,119,93,68,43,17,0,0,0,0,0,0,0,0,0,0,22,47,71,96,119,147,167,142,116,92,69,73,97,121,147,165,142,115,91,67,67,90,112,135,156,138,115,93,72,49,28,6,1,0,0,0,0,0,0,0,0,0,0,19,40,62,83,106,129,150,172,167,147,121,101,78,58,35,15,0,0,0,9,32,53,68,78,78,78,78,78,78,78,78,78,90,112,134,154,174,165,144,123,103,81,60,40,19,0,0,2,25,50,73,96,119,144,169,167,144,119,95,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,4,26,49,71,93,115,138,158,180,169,148,129,109,92,78,66,59,55,57,62,74,87,103,107,92,74,56,39,21,4,0,0,0,4,26,49,72,93,116,139,161,182,166,146,124,105,89,74,63,57,56,62,74,87,103,107,91,74,56,38,20,2,0,0,0,6,24,43,59,74,89,100,109,114,114,109,100,88,74,58,41,23,5,0,0,0,0,0,17,43,68,93,116,144,170,157,132,106,81,84,105,129,153,166,142,116,91,67,42,17,0,0,0,0,0,0,0,0,0,0,25,50,73,99,121,149,165,139,114,88,65,69,93,118,144,169,144,118,93,70,79,100,123,146,149,124,104,82,61,38,30,29,25,17,8,0,0,0,0,0,0,0,0,17,38,60,83,104,129,149,172,167,144,121,99,78,56,35,12,0,0,0,0,17,34,46,52,53,53,53,53,53,53,63,83,104,124,146,167,172,152,132,109,89,68,47,26,6,0,0,0,22,47,70,93,116,142,167,165,140,116,92,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,11,34,57,80,102,124,147,169,179,157,136,114,94,74,58,45,35,32,33,41,53,69,81,83,75,58,40,23,5,0,0,0,0,11,33,57,80,103,124,149,171,177,155,134,110,91,71,55,41,33,32,40,53,69,81,83,74,56,39,21,4,0,0,0,0,0,12,28,44,58,69,80,86,88,88,86,79,69,56,42,27,11,0,0,0,0,0,0,15,40,66,91,116,142,166,160,136,109,85,101,119,140,162,157,135,109,85,61,38,15,15,15,15,14,9,0,0,0,0,0,25,50,75,99,124,152,163,139,111,86,63,67,91,116,144,167,147,119,93,71,90,112,136,157,138,114,92,71,53,55,55,53,48,40,30,18,4,0,0,0,0,0,0,17,38,60,81,104,124,149,170,167,144,121,99,76,55,33,12,0,0,0,0,0,14,24,29,30,30,30,30,34,55,76,97,117,139,160,180,160,139,116,96,76,55,34,13,0,0,0,0,20,44,68,91,114,139,163,162,137,113,89,65,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,17,41,64,87,109,134,156,179,170,147,124,103,81,61,41,27,32,33,33,33,35,49,56,58,54,40,32,28,18,6,0,0,0,16,40,64,87,110,134,157,180,168,145,121,99,78,57,38,20,9,8,19,35,48,59,58,53,40,22,5,0,0,0,0,0,0,0,12,26,38,48,57,62,66,65,62,57,48,37,24,10,0,0,0,0,0,0,0,13,38,62,87,111,137,160,165,141,116,105,121,138,155,164,144,121,99,78,54,37,38,38,38,38,37,31,19,3,0,0,0,25,50,75,99,124,152,163,139,111,86,63,66,91,116,144,167,147,119,93,79,101,123,146,148,124,103,81,71,78,81,81,78,72,63,51,38,22,6,0,0,0,0,0,15,37,58,81,101,124,147,170,165,143,119,98,76,55,33,11,0,0,0,0,0,0,0,4,5,5,7,27,48,69,89,110,132,152,173,167,146,124,103,83,62,41,21,0,0,0,0,0,17,41,65,88,111,137,160,160,135,109,86,63,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,22,46,69,93,115,139,163,186,163,140,116,93,71,49,38,49,55,55,55,55,55,55,55,55,55,55,55,50,38,22,2,0,0,21,45,69,92,116,141,164,184,161,138,114,90,68,46,24,3,0,0,1,15,27,34,35,30,19,6,0,0,0,0,0,0,0,0,0,7,17,27,34,39,40,40,39,34,27,17,6,0,0,0,0,0,0,0,0,8,32,57,81,105,129,153,173,149,124,124,141,157,165,148,130,109,88,66,54,62,63,63,63,63,62,54,38,19,0,0,0,25,50,73,98,121,149,165,139,114,88,65,69,93,118,144,169,144,118,93,90,113,136,158,137,114,92,84,94,101,104,104,101,95,84,72,57,40,22,4,0,0,0,0,15,35,58,78,101,121,147,167,165,142,119,96,75,53,31,10,0,0,0,0,0,0,0,0,0,0,20,41,61,82,103,123,145,166,174,154,132,110,90,69,49,28,7,0,0,0,0,0,14,38,62,86,109,134,158,156,132,106,83,60,37,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,2,25,50,73,96,119,144,168,181,157,134,109,86,64,41,55,72,80,81,81,81,81,81,81,81,81,81,80,73,56,38,15,0,0,25,48,73,96,119,146,169,180,157,132,108,84,61,37,14,0,0,0,0,0,4,9,10,6,0,0,0,0,0,0,0,0,0,0,0,10,21,30,37,43,45,45,45,40,33,24,13,1,0,0,0,0,0,0,0,2,26,49,73,97,119,144,166,160,140,146,161,162,146,130,112,94,74,55,74,86,88,88,88,88,87,74,55,32,8,0,0,22,47,71,96,119,146,167,143,116,93,69,73,98,121,147,165,141,114,91,101,124,147,148,124,103,91,105,116,124,132,132,124,117,106,92,74,57,38,19,0,0,0,0,12,35,56,78,99,121,144,167,162,142,116,96,73,53,30,9,0,0,0,0,0,0,0,0,0,12,33,54,74,95,116,138,158,179,161,140,118,98,76,56,36,14,0,0,0,0,0,0,12,36,59,83,106,132,155,153,129,104,81,57,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,5,27,53,76,99,123,148,172,178,154,132,106,82,59,45,68,88,105,106,106,106,106,106,106,106,106,106,106,90,69,47,23,0,2,27,50,75,99,123,149,172,177,154,129,104,80,56,32,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,28,41,51,60,67,70,70,68,63,55,45,32,19,4,0,0,0,0,0,0,19,37,53,69,87,109,134,156,175,165,168,157,143,129,110,94,76,58,65,89,108,111,111,111,111,108,88,64,39,14,0,0,18,43,67,91,114,140,163,147,121,99,78,82,105,129,152,159,136,110,91,113,137,158,137,113,91,109,124,140,150,154,154,150,141,129,110,92,73,52,31,11,0,0,0,12,33,55,76,99,121,144,167,162,139,116,93,73,50,30,7,0,0,0,0,0,0,0,0,5,26,47,67,88,109,130,152,172,168,147,124,105,84,63,43,22,1,0,0,0,0,0,0,9,33,56,81,104,129,147,147,124,101,78,54,31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,5,29,53,76,101,124,149,175,177,152,129,104,79,55,48,73,96,119,132,132,132,132,132,132,132,132,132,121,99,73,50,25,0,4,27,53,76,101,124,152,175,175,152,124,101,78,53,29,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,31,46,60,72,82,90,93,93,92,85,76,64,49,35,19,2,0,0,0,0,15,35,53,71,87,103,117,135,155,180,181,157,138,121,107,92,76,58,49,73,97,121,139,139,139,139,114,90,65,40,15,0,0,13,37,61,84,108,132,155,156,134,112,97,99,116,139,161,150,129,103,103,124,148,147,124,103,106,124,145,161,152,144,144,152,162,146,129,107,87,65,42,21,0,0,0,11,33,55,76,98,119,143,165,160,139,114,93,71,50,27,7,0,0,0,0,0,0,0,0,18,39,60,81,101,121,144,165,175,155,134,112,92,71,50,29,9,0,0,0,0,0,0,0,6,30,54,78,101,121,121,121,119,98,75,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,5,30,53,78,101,124,152,175,177,152,129,101,78,55,48,73,96,119,147,157,157,157,157,157,157,157,147,121,99,73,50,25,0,5,27,53,76,101,124,152,175,175,152,124,101,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,27,45,61,78,92,104,113,116,119,115,107,96,82,66,50,32,14,0,0,0,8,29,50,69,89,106,123,139,154,170,175,181,156,136,114,94,74,57,41,57,81,104,129,152,165,155,132,106,82,58,35,11,0,0,6,30,53,75,98,119,143,162,148,132,121,121,136,153,158,138,115,93,114,137,157,136,113,97,118,141,162,149,132,118,117,130,148,162,143,121,98,75,53,29,6,0,0,10,31,53,75,96,119,142,165,160,137,114,92,71,49,27,5,0,0,0,0,0,0,0,11,32,52,73,94,114,137,157,178,162,141,119,99,79,57,37,16,0,0,0,0,0,0,0,0,2,26,48,69,89,98,99,99,98,87,67,45,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,5,30,53,76,101,124,150,175,177,152,129,104,80,56,48,73,96,119,147,170,170,170,170,172,182,172,147,121,99,73,50,25,0,5,27,53,76,101,124,152,175,175,152,124,101,78,53,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,56,74,92,109,123,136,143,144,139,129,112,97,80,62,43,24,0,0,0,21,42,64,85,105,123,143,159,173,159,149,161,170,150,130,110,91,73,55,66,90,113,137,160,170,147,121,98,74,51,27,4,0,0,0,21,42,65,87,107,129,145,161,153,147,147,155,157,143,123,103,104,124,148,146,123,101,106,130,153,157,136,114,96,95,112,135,156,155,132,107,84,61,36,12,0,0,9,30,53,73,96,116,142,162,160,137,114,91,69,48,25,5,0,0,0,0,0,0,4,24,45,66,87,107,129,149,170,169,148,129,106,86,65,44,23,2,0,0,0,0,0,0,0,0,0,17,37,55,70,76,76,76,75,69,53,35,15,0,0,0,0,0,0,0,0,0,0,3,7,6,2,0,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,5,27,53,76,100,124,149,172,178,154,132,106,82,59,48,73,96,119,147,147,147,147,147,150,170,172,147,121,99,73,50,25,0,2,27,50,76,99,124,149,172,177,154,129,104,80,57,32,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,22,43,63,83,102,121,141,157,167,167,161,146,129,109,90,71,51,32,0,0,8,31,54,76,98,119,141,159,177,157,141,124,146,166,165,146,129,108,91,73,78,99,121,147,170,160,137,113,90,66,43,19,0,0,0,0,9,31,52,73,92,109,124,139,147,152,152,147,137,121,105,93,115,138,157,135,112,90,112,138,162,150,124,101,79,78,100,123,148,163,139,114,90,67,42,18,0,0,7,30,50,73,93,116,139,162,157,136,111,91,68,47,25,4,0,0,0,0,0,0,17,38,58,79,100,121,143,163,177,156,136,114,92,72,52,31,10,0,0,0,0,0,0,0,0,0,0,4,21,37,48,53,53,53,53,48,36,21,2,0,0,0,0,0,0,0,0,4,17,27,32,32,26,16,12,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,2,26,50,73,97,121,146,169,182,157,134,109,86,64,47,73,95,116,119,119,119,119,119,139,165,172,147,121,99,73,50,25,0,1,25,49,73,96,121,146,170,180,157,132,108,84,61,37,14,0,0,0,0,0,12,21,25,23,16,5,0,0,0,0,0,2,25,45,66,86,106,129,149,169,188,191,175,157,138,117,98,78,57,37,0,0,15,39,63,87,109,134,155,175,161,141,121,110,132,152,170,162,144,124,109,91,89,110,135,156,172,150,124,103,80,57,33,11,0,0,0,0,0,18,38,56,74,91,105,115,123,129,124,121,114,103,87,105,129,149,146,121,100,93,116,143,167,145,119,95,71,69,93,116,144,167,144,119,94,70,46,22,0,0,7,27,50,71,93,114,139,160,157,134,111,88,68,45,24,2,0,0,0,0,0,10,31,51,72,92,113,136,155,177,163,143,121,100,79,59,38,17,0,0,0,0,0,0,0,0,0,0,0,0,3,16,24,27,27,27,27,24,15,2,0,0,0,0,0,0,0,0,10,24,38,49,55,54,47,34,19,35,58,81,104,132,154,177,172,149,121,99,76,53,30,0,0,23,46,70,93,116,141,164,186,163,139,116,93,71,48,64,82,93,93,93,93,93,114,139,165,172,147,121,99,73,50,25,0,0,22,45,69,93,116,142,165,185,162,138,114,90,68,45,23,2,0,0,1,17,33,43,48,46,38,24,8,0,0,0,0,2,24,45,65,86,106,124,147,165,178,180,183,163,144,121,101,81,60,40,0,0,21,45,70,93,118,144,166,171,148,124,105,95,115,136,154,173,161,144,129,110,101,123,146,167,160,138,115,92,70,47,24,1,0,0,0,0,0,4,22,40,56,71,83,93,99,101,101,98,91,81,93,116,139,156,135,110,89,96,119,147,167,142,116,91,67,65,90,114,142,165,149,121,96,73,48,22,0,0,5,27,49,71,92,114,137,142,142,134,109,88,66,45,22,2,0,0,0,0,2,23,44,64,85,106,129,148,169,171,150,129,107,87,66,45,25,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,29,43,57,70,80,79,69,52,33,35,60,83,106,132,154,177,172,149,121,99,76,53,30,0,0,18,41,65,88,111,135,157,180,170,147,124,101,81,59,47,63,70,71,71,71,91,114,139,165,172,147,121,99,73,50,25,0,0,17,40,64,88,111,135,158,181,168,145,121,99,78,56,36,19,10,11,20,35,51,66,73,70,58,42,24,6,0,0,0,0,20,40,60,80,99,117,136,148,155,157,165,166,146,121,101,81,60,40,0,0,25,49,73,99,124,150,174,165,140,115,92,80,99,117,139,155,173,162,146,130,115,137,158,170,148,124,104,81,59,37,14,0,0,0,0,0,0,0,4,22,37,50,61,69,75,78,77,75,69,83,105,129,150,145,121,99,78,96,121,147,167,142,116,91,66,63,88,114,139,165,149,121,99,73,48,22,0,0,4,24,47,69,90,109,116,116,116,116,105,85,64,42,22,0,0,0,0,0,16,36,57,78,98,119,141,162,178,158,137,115,94,74,52,32,30,30,30,30,30,30,26,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,20,35,49,62,76,90,102,100,85,66,47,39,62,86,108,132,155,178,170,147,121,99,76,53,29,0,0,12,35,58,81,103,129,149,171,178,156,136,113,93,74,58,45,45,45,45,66,91,114,139,165,172,147,121,99,73,50,25,0,0,11,34,57,81,103,129,150,172,177,154,132,109,90,71,54,41,35,35,41,54,69,87,98,93,76,58,40,22,4,0,0,0,13,33,51,70,87,101,115,124,132,132,150,165,144,121,101,81,60,40,0,2,27,53,78,102,129,152,177,162,137,111,86,64,83,101,119,139,155,173,165,149,137,152,172,155,136,114,91,70,48,25,13,0,0,0,0,0,0,0,0,2,16,28,38,46,50,53,53,50,73,95,116,139,155,134,110,88,71,96,121,147,167,142,116,91,66,63,88,114,139,165,149,121,99,73,48,22,0,0,5,22,40,59,76,89,91,91,91,91,87,72,56,35,18,1,0,0,0,8,29,50,71,91,112,134,154,175,165,144,121,101,81,60,53,53,53,53,53,53,53,53,48,36,19,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,53,68,82,95,109,123,117,98,80,66,61,70,91,113,137,159,182,166,144,119,97,73,50,27,0,0,5,28,50,73,95,116,140,161,182,167,147,129,109,92,78,68,62,58,59,66,91,114,139,165,172,147,121,99,73,50,25,0,0,4,27,50,73,95,117,140,162,183,165,144,123,105,87,74,64,59,59,64,74,88,103,121,110,92,74,56,38,21,2,0,0,4,22,39,55,71,84,95,102,109,129,150,160,141,119,100,80,60,39,0,2,27,52,77,101,129,152,177,165,139,114,90,67,67,83,101,119,137,155,171,168,160,168,163,143,121,99,79,61,53,46,32,15,0,0,0,0,0,0,0,0,0,6,15,22,27,27,40,62,84,106,129,150,144,121,99,77,71,94,119,145,167,144,116,93,68,66,91,114,142,165,147,121,96,73,48,22,0,0,17,36,54,71,86,98,108,111,111,106,97,83,67,51,32,14,0,0,1,22,43,63,84,105,124,147,167,172,152,132,109,88,78,78,78,78,78,78,78,78,78,78,71,55,34,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,25,49,69,87,101,115,130,144,132,114,99,89,86,90,103,121,144,165,184,161,139,114,93,70,47,23,0,0,0,20,41,64,86,106,129,149,169,181,161,143,124,112,99,91,86,83,83,87,95,114,139,165,172,147,121,99,73,50,25,0,0,0,18,41,63,86,107,129,150,170,178,159,140,121,107,95,87,83,83,87,96,108,121,139,129,109,91,73,55,36,14,0,0,10,25,37,46,56,68,82,99,116,137,155,154,136,114,94,75,54,34,0,0,24,48,73,98,121,148,173,170,146,123,101,85,74,71,85,101,117,136,154,177,185,182,157,132,117,105,93,84,77,67,51,31,11,0,0,0,0,0,0,0,0,0,0,0,7,30,51,73,96,117,140,155,132,109,88,66,68,91,116,142,166,147,121,97,72,71,94,119,144,167,144,118,93,70,45,20,0,7,28,48,67,86,103,118,132,139,138,130,116,100,82,64,44,24,0,0,13,35,56,76,98,117,139,161,181,158,138,116,104,104,104,104,104,104,104,104,104,104,104,103,90,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,100,121,136,149,163,150,134,119,111,109,113,121,137,155,175,175,154,132,109,87,65,42,19,0,0,0,10,31,53,74,95,114,136,154,172,179,161,146,134,121,114,109,107,109,111,118,130,144,167,172,147,121,99,73,50,25,0,0,0,9,31,53,74,95,115,137,155,174,175,157,143,129,118,111,109,109,111,118,130,143,158,144,124,108,90,68,46,22,0,6,26,42,56,67,76,87,99,114,132,148,163,145,124,106,87,68,49,29,0,0,20,44,69,93,116,141,164,179,158,139,119,106,98,96,99,107,117,132,151,175,178,180,168,152,139,129,116,107,101,87,65,41,19,0,0,0,0,0,0,0,0,0,0,0,19,41,63,84,107,130,152,144,119,98,76,55,63,87,111,137,160,152,129,104,82,81,103,124,150,161,138,113,89,65,41,16,0,14,35,56,77,98,117,137,153,162,161,150,134,113,93,73,52,31,0,0,22,46,69,90,110,132,153,174,177,152,130,129,129,129,129,129,129,129,129,129,129,129,129,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,76,97,116,137,155,173,166,153,143,137,134,137,144,155,171,181,163,143,121,100,79,57,35,12,0,0,0,0,20,41,61,81,101,119,139,155,170,179,166,155,146,139,136,134,134,137,142,150,163,179,169,147,121,99,73,50,25,0,0,0,0,20,41,62,81,101,119,140,157,172,176,162,150,142,137,134,134,137,142,152,163,177,161,144,121,99,73,50,25,0,16,37,56,74,88,98,107,117,132,146,162,149,132,114,96,78,59,40,21,0,0,13,37,61,84,107,130,152,171,173,155,140,129,121,119,121,130,140,153,166,167,155,158,170,173,161,149,139,132,121,96,71,45,22,0,0,0,0,0,0,0,0,0,0,8,30,52,74,96,118,141,154,132,108,87,65,43,57,80,103,129,150,160,138,116,101,100,116,137,160,152,129,106,81,58,35,11,0,19,40,62,83,104,124,147,168,185,183,164,144,121,99,78,55,35,0,0,25,50,76,99,124,146,166,187,184,164,154,154,154,154,154,154,154,154,154,154,154,154,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,23,44,64,84,103,121,141,155,170,174,165,160,160,160,166,176,177,163,148,130,109,89,69,48,27,5,0,0,0,0,8,28,48,67,85,103,119,137,150,163,174,177,169,163,160,158,159,160,165,173,173,162,149,136,117,98,73,50,25,0,0,0,0,8,28,48,67,86,103,121,139,154,166,177,173,165,160,158,159,160,165,174,170,157,143,124,107,90,68,47,22,0,20,42,63,83,102,119,130,140,152,162,148,134,117,101,83,66,49,30,12,0,0,6,29,50,73,95,116,136,154,168,174,162,152,147,147,147,154,163,173,161,148,132,137,149,162,172,172,163,142,116,93,69,44,20,0,0,0,0,0,0,0,0,0,0,20,41,64,86,107,132,153,143,119,97,75,54,32,49,72,93,116,139,158,154,136,124,124,136,152,159,139,117,96,73,50,28,4,0,20,40,63,83,106,129,150,171,192,188,167,146,121,101,78,55,35,0,0,25,50,76,99,124,152,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,32,52,70,88,105,121,137,149,160,167,171,172,172,170,165,156,144,130,112,95,76,57,37,16,0,0,0,0,0,0,14,33,51,69,85,101,116,130,142,152,160,166,170,173,175,172,170,165,159,150,140,129,114,99,83,65,43,20,0,0,0,0,0,14,33,52,69,87,103,117,132,144,154,162,168,172,175,173,170,165,158,148,137,121,107,91,73,56,36,14,0,19,41,61,81,100,118,139,158,154,143,130,116,101,85,70,53,36,19,0,0,0,0,17,39,60,80,99,117,134,148,158,167,172,172,170,171,167,160,150,139,124,112,114,129,139,150,159,159,135,109,85,61,37,13,0,0,0,0,0,0,0,0,0,8,31,53,74,97,118,143,153,132,108,86,64,42,21,39,61,82,103,121,141,156,157,149,149,156,157,143,123,104,83,62,40,18,0,0,17,38,59,80,101,121,143,161,173,172,158,139,117,97,76,54,34,0,0,25,50,76,99,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,37,55,71,87,103,116,129,137,144,147,149,149,147,142,134,123,110,95,80,62,44,24,5,0,0,0,0,0,0,0,17,35,51,67,82,96,108,118,129,137,143,147,149,149,149,147,142,137,129,117,106,94,81,65,49,32,11,0,0,0,0,0,0,18,35,53,69,83,98,110,121,132,139,144,147,149,149,147,143,136,124,114,101,88,73,56,38,21,2,0,14,33,53,72,91,110,130,141,132,121,110,98,83,69,55,38,23,5,0,0,0,0,5,26,46,64,82,98,113,124,137,144,147,149,149,147,143,137,129,116,105,92,93,105,116,129,137,144,129,102,78,54,30,6,0,0,0,0,0,0,0,0,0,15,38,63,86,108,132,149,141,118,97,74,53,31,9,28,48,69,87,105,121,136,144,149,149,145,137,121,106,89,69,49,28,7,0,0,11,32,52,72,91,110,129,143,149,148,140,124,107,88,68,48,28,0,0,25,50,75,98,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,38,54,69,83,95,105,113,118,121,121,121,121,116,110,101,90,76,62,46,29,11,0,0,0,0,0,0,0,0,1,17,33,48,62,75,87,97,105,112,117,121,121,121,121,119,116,111,104,95,84,73,60,47,31,15,0,0,0,0,0,0,0,1,17,35,50,64,77,89,99,107,114,119,121,121,121,121,117,111,103,92,81,68,54,38,22,4,0,0,5,24,44,63,82,101,119,117,109,100,90,78,65,53,38,23,8,0,0,0,0,0,0,11,30,47,64,79,91,103,112,118,121,121,121,121,117,112,104,95,83,71,72,83,95,104,112,119,117,95,71,47,23,0,0,0,0,0,0,0,0,0,0,15,40,65,91,113,121,121,121,107,86,63,41,20,0,14,34,53,71,87,100,112,119,121,121,119,113,101,88,71,53,35,15,0,0,0,2,23,41,61,78,94,108,118,121,121,117,106,91,75,57,38,19,0,0,21,45,69,87,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,36,50,63,73,82,90,94,99,99,99,98,93,88,80,69,57,44,28,12,0,0,0,0,0,0,0,0,0,0,0,14,28,41,54,64,74,81,88,93,96,99,99,99,96,93,88,81,73,63,51,40,27,13,0,0,0,0,0,0,0,0,0,1,15,30,43,56,66,76,84,90,94,98,99,99,96,93,88,80,71,59,48,33,19,4,0,0,0,0,16,35,54,72,87,96,95,87,79,69,58,47,33,21,6,0,0,0,0,0,0,0,0,12,29,44,58,70,80,88,93,98,99,99,97,93,88,81,72,62,50,50,61,72,81,89,96,98,83,62,40,16,0,0,0,0,0,0,0,0,0,0,14,36,59,81,97,99,99,99,92,74,52,30,8,0,0,18,35,52,67,79,89,96,99,99,96,90,80,68,53,37,19,0,0,0,0,0,11,29,46,62,76,87,95,99,99,93,85,73,58,42,25,7,0,0,12,33,53,66,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,17,30,41,51,60,67,71,73,73,73,73,70,65,57,48,37,24,10,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,32,42,51,59,65,70,73,73,73,73,73,69,64,58,50,41,30,19,7,0,0,0,0,0,0,0,0,0,0,0,0,10,23,34,45,53,61,67,71,73,73,73,73,70,64,57,49,39,27,14,0,0,0,0,0,0,6,24,42,56,67,73,72,65,57,48,38,27,15,2,0,0,0,0,0,0,0,0,0,0,10,24,37,48,58,65,70,73,73,73,73,70,65,58,50,40,29,29,39,49,58,65,72,73,64,47,28,6,0,0,0,0,0,0,0,0,0,0,5,25,45,62,72,73,73,73,69,56,40,18,0,0,0,1,17,33,46,57,66,72,73,73,73,67,58,47,33,18,1,0,0,0,0,0,0,13,29,43,55,65,72,73,73,70,63,53,40,26,10,0,0,0,0,17,33,43,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,29,36,43,47,50,50,50,50,47,41,35,26,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,28,35,41,45,48,50,50,50,48,45,40,34,27,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,12,22,30,37,43,46,48,50,50,48,45,40,34,26,16,5,0,0,0,0,0,0,0,0,10,24,35,44,48,47,42,34,27,17,6,0,0,0,0,0,0,0,0,0,0,0,0,0,3,15,25,34,41,46,48,50,50,48,45,41,34,27,17,6,6,17,26,35,42,48,50,43,30,13,0,0,0,0,0,0,0,0,0,0,0,0,13,29,42,50,50,50,50,48,38,22,4,0,0,0,0,0,12,24,34,42,47,50,50,48,43,35,25,13,0,0,0,0,0,0,0,0,0,10,23,33,41,47,48,48,46,41,31,21,8,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,23,25,25,25,25,23,18,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,17,21,24,25,25,25,24,20,16,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,13,18,22,25,25,25,25,21,17,11,3,0,0,0,0,0,0,0,0,0,0,0,5,15,22,25,24,20,13,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,17,22,25,25,25,24,21,17,11,4,0,0,0,0,3,11,18,24,25,20,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,19,24,25,25,25,23,15,2,0,0,0,0,0,0,0,2,12,19,23,25,25,24,19,12,3,0,0,0,0,0,0,0,0,0,0,0,1,10,18,22,25,25,22,16,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,3,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,24,17,7,0,0,0,0,0,7,17,23,25,25,25,25,25,25,21,13,1,0,0,0,0,0,8,18,24,25,25,25,25,25,25,22,14,2,0,0,0,1,13,22,25,25,25,25,25,25,23,16,5,0,0,0,0,0,1,14,22,25,25,25,25,25,25,22,13,1,0,0,1,14,22,25,25,25,25,25,23,16,4,0,0,0,11,20,25,25,25,25,25,25,21,12,0,0,0,0,0,1,13,22,25,25,25,25,25,25,23,16,4,0,0,0,0,0,0,2,15,22,25,25,25,25,25,25,21,13,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,25,25,22,18,13,7,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,25,24,22,17,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,21,26,27,27,26,20,13,3,0,0,0,0,0,0,0,0,4,22,36,46,50,50])
.concat([50,50,50,50,49,40,27,11,0,0,0,10,27,40,48,50,50,50,50,50,50,45,35,21,4,0,0,0,13,29,41,49,50,50,50,50,50,50,46,36,21,4,0,2,21,35,45,50,50,50,50,50,50,48,40,26,9,0,0,0,4,22,36,47,50,50,50,50,50,50,46,35,21,2,4,21,36,46,50,50,50,50,50,48,39,24,7,0,17,32,44,50,50,50,50,50,50,45,33,19,0,0,0,4,21,35,46,50,50,50,50,50,50,48,38,24,7,0,0,0,0,6,22,38,47,50,50,50,50,50,50,45,35,19,2,0,0,2,19,35,46,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,33,17,0,0,0,4,21,36,47,50,50,50,50,50,50,50,50,50,50,50,48,46,42,37,31,22,12,0,0,0,0,0,0,0,0,0,2,21,36,47,50,50,50,50,50,50,50,50,50,50,50,48,46,42,37,30,22,11,0,0,0,0,0,0,0,0,0,0,13,25,36,45,50,53,53,49,43,34,23,10,0,0,0,0,0,0,0,17,37,55,70,76,76,76,76,76,76,73,61,45,26,6,0,5,25,44,61,73,76,76,76,76,76,75,69,55,37,15,0,0,6,26,47,63,74,76,76,76,76,76,76,70,55,38,17,0,16,36,55,69,76,76,76,76,76,76,73,60,43,24,1,0,0,17,37,56,70,76,76,76,76,76,76,69,55,36,15,17,37,56,70,76,76,76,76,76,72,60,41,22,11,31,51,66,75,76,76,76,76,75,69,53,35,13,0,0,15,37,55,70,76,76,76,76,76,76,72,58,41,21,0,0,0,0,20,39,56,71,76,76,76,76,76,75,69,53,35,15,0,0,14,35,55,70,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,75,69,53,33,11,0,0,17,37,56,71,76,76,76,76,76,76,76,76,76,76,75,73,71,67,61,54,45,33,21,7,0,0,0,0,0,0,0,15,37,56,71,76,76,76,76,76,76,76,76,76,76,75,73,70,66,61,53,44,33,20,6,0,0,0,0,0,0,0,15,31,45,57,67,73,76,76,73,65,55,42,28,11,0,0,0,0,0,4,26,48,71,89,98,99,99,99,99,99,95,78,58,37,16,0,15,36,57,77,93,99,99,99,99,99,98,87,69,48,24,0,0,14,36,59,79,96,99,99,99,99,99,99,89,71,50,28,7,27,48,69,89,98,99,99,99,99,99,93,75,55,33,9,0,1,26,48,71,89,99,99,99,99,99,98,89,69,48,24,26,49,71,89,99,99,99,99,99,92,75,54,31,19,43,64,85,98,99,99,99,99,98,87,66,45,21,0,1,24,48,69,89,98,99,99,99,99,99,92,75,53,31,8,0,0,6,28,51,73,90,99,99,99,99,99,98,87,69,45,24,0,0,24,45,69,89,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,19,0,1,26,48,71,90,99,99,99,99,99,99,99,99,99,99,99,98,94,91,85,77,66,55,41,26,10,0,0,0,0,0,0,24,48,71,90,99,99,99,99,99,99,99,99,99,99,99,97,93,90,84,76,66,54,41,25,8,0,0,0,0,0,11,30,47,62,77,89,97,101,101,96,87,74,60,44,26,8,0,0,0,0,7,30,55,78,101,123,124,124,124,124,124,112,90,68,47,25,4,24,46,67,89,110,124,124,124,124,124,121,98,76,53,30,0,0,17,43,65,88,114,124,124,124,124,124,123,103,82,61,39,17,37,59,80,101,123,124,124,124,124,124,109,86,60,38,12,0,7,30,55,78,103,124,124,124,124,124,123,101,77,53,29,32,56,79,102,124,124,124,124,124,107,84,61,37,24,48,72,96,118,124,124,124,124,121,98,73,50,25,0,5,30,53,76,101,123,124,124,124,124,124,106,84,61,37,15,0,0,12,35,59,82,105,124,124,124,124,124,121,98,76,50,27,0,2,27,50,76,101,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,98,73,48,22,0,5,30,53,78,103,124,124,124,124,124,124,124,124,124,124,124,121,119,114,108,99,89,76,61,44,28,9,0,0,0,0,2,27,53,78,103,124,124,124,124,124,124,124,124,124,124,124,121,118,114,108,99,88,75,60,42,25,6,0,0,0,2,23,42,62,79,96,109,119,124,124,118,107,92,76,58,39,20,0,0,0,0,5,28,51,74,95,116,138,152,152,152,144,121,99,78,56,35,13,34,55,76,98,119,143,152,152,152,137,114,93,72,49,26,0,0,15,38,62,83,105,124,148,152,152,152,137,114,92,72,50,29,48,70,90,112,135,152,152,152,144,121,100,80,57,35,11,0,4,28,51,75,99,121,147,152,152,152,130,105,81,57,34,38,61,85,109,134,152,152,152,138,114,90,66,43,29,52,76,100,124,149,152,152,144,119,96,72,49,24,0,3,26,51,73,97,119,143,152,152,152,138,114,90,67,44,21,0,0,19,42,65,88,111,136,152,152,152,141,117,94,72,49,25,0,2,27,50,76,101,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,73,48,22,0,5,30,53,78,104,129,152,152,152,152,152,152,152,152,152,149,148,144,139,132,121,109,96,80,62,43,23,3,0,0,0,2,27,53,78,104,129,152,152,152,152,152,152,152,152,152,149,147,144,139,132,121,109,94,78,60,41,21,0,0,0,11,32,52,73,92,110,130,143,149,149,140,124,107,88,69,49,28,0,0,0,0,0,21,42,63,84,106,129,149,171,174,153,132,109,87,66,45,23,43,65,86,108,132,152,173,169,147,124,104,83,62,40,19,0,0,9,30,51,72,92,114,136,156,175,169,147,124,104,82,61,40,58,80,101,123,146,166,174,153,132,110,89,69,47,27,4,0,0,23,47,70,93,117,142,166,175,157,134,109,86,62,38,44,67,91,114,139,162,175,167,144,119,96,72,49,33,57,80,104,129,152,175,163,139,114,91,68,44,20,0,0,20,44,66,90,112,137,159,175,167,144,119,97,74,51,28,4,2,25,48,72,95,117,142,165,175,157,134,110,87,64,41,19,0,2,27,50,76,101,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,149,121,99,73,48,22,0,5,30,53,78,104,129,154,175,175,175,175,175,175,175,175,175,172,168,163,155,144,132,114,96,78,57,36,15,0,0,0,2,27,53,78,104,129,154,175,175,175,175,175,175,175,175,175,172,167,162,155,144,130,112,95,76,55,34,13,0,0,17,37,59,80,101,121,143,161,173,172,158,139,118,97,76,55,34,0,0,0,0,0,11,31,53,74,95,116,138,160,181,163,141,118,97,75,54,32,53,74,96,117,140,162,179,158,137,114,93,72,51,30,8,0,0,0,19,39,61,81,101,123,145,165,180,158,137,114,93,72,50,69,90,112,135,156,178,163,141,119,98,78,57,36,15,0,0,0,18,42,65,90,113,138,161,185,162,139,114,90,65,42,49,73,96,119,144,167,191,172,149,124,101,78,54,37,61,85,109,134,157,180,159,135,110,86,63,39,16,0,0,13,36,59,82,105,129,152,174,173,151,129,103,81,57,35,11,9,32,55,78,101,124,148,171,172,150,124,103,80,57,35,11,0,2,27,50,76,101,129,154,154,154,154,154,154,154,156,172,191,170,156,154,154,154,154,154,154,149,121,99,73,48,22,0,5,30,53,78,104,129,154,180,175,155,149,149,149,149,149,150,154,160,170,178,165,150,134,112,91,70,48,25,2,0,0,2,27,53,78,104,129,154,180,175,155,149,149,149,149,149,150,154,160,170,178,165,150,132,110,90,68,46,23,0,0,20,40,63,83,106,129,150,171,192,188,167,146,121,101,78,55,35,0,0,0,0,0,0,21,42,64,84,106,129,149,171,172,151,129,106,85,64,42,63,84,105,129,150,171,169,147,124,104,82,62,40,19,0,0,0,0,7,28,49,70,90,112,134,154,174,170,148,124,104,82,62,79,101,121,145,166,172,150,130,108,87,66,45,24,3,0,0,0,14,37,61,85,109,134,157,180,166,142,116,93,70,46,55,78,101,124,150,173,190,178,155,132,106,83,60,41,65,88,112,137,161,178,154,132,106,82,58,35,11,0,0,6,29,52,75,98,119,144,167,180,157,134,110,87,64,41,17,15,38,61,85,108,132,155,178,165,143,118,96,73,50,27,4,0,2,27,50,76,101,129,129,129,129,129,129,129,129,138,162,185,160,137,129,129,129,129,129,129,129,121,99,73,48,22,0,5,30,53,78,104,129,154,180,170,144,121,121,121,121,121,124,129,137,147,162,179,167,147,124,103,80,57,34,11,0,0,2,27,53,78,104,129,154,180,170,144,121,121,121,121,121,124,129,137,147,162,179,166,146,124,101,79,56,33,8,0,19,40,62,83,104,124,147,168,186,184,164,144,121,99,78,55,35,0,0,0,0,0,0,11,32,53,74,95,116,139,160,181,161,139,116,95,73,51,72,93,115,138,160,179,157,137,114,92,72,51,30,8,0,0,0,0,0,16,37,57,79,99,119,143,163,180,158,137,115,93,73,90,112,134,155,177,161,139,117,96,75,55,33,12,0,0,0,0,9,33,56,80,103,129,152,175,170,147,121,98,74,50,61,85,108,132,155,173,167,174,160,137,113,90,65,45,69,93,116,142,165,173,150,124,101,78,54,30,6,0,0,0,22,45,68,90,114,137,160,183,163,140,116,93,70,48,24,22,45,68,91,114,138,161,181,158,136,111,89,65,43,20,0,0,0,24,46,70,91,103,104,104,104,104,104,104,109,137,162,185,160,137,109,104,104,104,104,104,104,103,89,67,44,19,0,5,30,53,78,104,129,154,180,170,144,119,99,99,99,99,101,106,113,129,145,165,181,158,136,112,88,64,41,17,0,0,2,27,53,78,104,129,154,180,170,144,116,99,99,99,99,101,106,113,124,144,165,180,158,136,111,87,63,39,15,0,14,35,56,77,98,117,138,154,163,163,152,135,114,94,73,53,32,0,0,0,0,0,0,0,21,42,64,84,106,129,149,171,170,148,124,104,83,61,82,103,124,147,169,168,147,124,104,82,62,40,19,0,0,0,0,0,0,4,25,46,66,88,108,130,152,172,170,148,129,105,83,100,121,145,166,170,148,129,105,84,64,42,22,0,0,0,0,0,4,28,52,75,99,121,147,170,174,150,124,101,78,55,67,90,114,138,161,154,142,155,166,143,118,95,72,50,73,97,121,145,169,168,144,119,96,73,49,25,2,0,0,0,15,37,61,83,106,130,152,176,170,147,123,100,77,54,31,28,51,74,98,121,144,168,174,151,129,104,81,59,36,13,0,0,0,15,36,56,72,78,78,78,78,78,78,86,109,137,162,185,160,137,109,83,78,78,78,78,78,78,71,55,34,12,0,5,30,53,78,104,129,154,180,170,144,119,93,73,73,73,76,81,92,109,132,155,179,167,143,118,93,69,45,21,0,0,2,27,53,78,104,129,154,180,170,144,116,91,73,73,73,76,81,91,108,132,154,178,167,144,117,93,68,44,20,0,8,28,48,69,88,105,119,134,139,139,132,117,101,83,65,45,24,0,0,0,0,0,0,0,11,32,53,74,95,116,139,160,180,158,137,114,92,70,91,113,136,156,179,157,137,114,93,72,50,30,8,0,0,0,0,0,0,0,13,34,55,76,97,117,139,161,180,160,138,115,95,110,134,155,177,158,137,115,93,73,52,31,11,0,0,0,0,0,0,23,47,70,93,117,142,166,178,154,132,106,82,59,72,96,119,144,167,146,123,148,172,148,124,101,77,54,77,101,124,149,173,164,140,116,92,68,45,21,0,0,0,0,8,30,53,76,98,121,145,168,177,154,132,106,83,61,37,35,58,81,104,129,151,174,167,144,119,97,74,51,28,6,0,0,0,2,21,37,49,53,53,53,53,53,60,86,109,137,162,185,160,137,109,83,58,53,53,53,53,53,48,36,19,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,48,49,52,58,77,100,124,149,175,171,147,121,96,71,48,22,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,48,49,52,58,74,98,121,147,172,172,147,121,96,71,47,22,0,0,19,38,56,73,88,101,110,114,114,109,99,85,69,52,34,15,0,0,0,0,0,0,0,0,22,42,64,84,106,129,149,171,167,145,121,101,79,100,121,144,166,168,147,124,104,82,61,40,19,0,0,0,0,0,0,0,0,2,22,43,64,84,106,129,148,170,170,149,129,105,121,144,165,167,146,124,103,82,62,40,20,0,0,0,0,0,0,0,18,42,65,90,113,138,162,182,159,135,109,86,63,78,101,124,149,165,142,119,144,167,154,132,106,83,59,81,105,130,154,177,160,137,111,88,64,40,16,0,0,0,0,0,23,46,69,92,114,139,161,184,160,137,114,90,67,44,41,64,87,110,135,157,181,160,137,113,90,67,44,21,0,0,0,0,0,2,16,26,30,30,30,30,35,60,86,109,137,162,185,160,137,109,83,58,33,30,30,30,30,25,15,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,43,25,28,48,73,96,121,149,172,172,149,121,96,73,48,22,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,25,28,45,69,93,119,147,170,175,149,121,98,73,48,22,0,0,7,24,40,56,69,80,87,91,91,86,78,67,53,37,20,3,0,0,0,0,0,0,0,0,11,32,53,74,96,116,139,160,176,154,132,109,88,109,132,153,175,157,137,114,93,72,50,30,8,0,0,0,0,0,0,0,0,0,11,31,53,73,93,115,137,158,179,160,138,116,132,154,175,156,135,113,91,71,50,29,8,0,0,0,0,0,0,0,14,37,61,85,109,134,157,180,162,139,114,91,67,84,107,132,155,160,137,114,139,163,160,137,112,89,65,86,109,134,157,178,155,132,106,83,59,35,12,0,0,0,0,0,16,39,61,85,107,132,155,176,167,144,119,97,74,51,48,71,93,116,141,163,175,152,129,106,82,60,37,14,0,0,0,0,0,0,0,2,5,5,5,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,5,5,4,1,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,43,38,41,54,76,99,124,149,174,172,147,121,96,71,48,22,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,22,27,45,70,94,119,147,170,175,149,121,98,73,48,22,0,0,0,8,24,37,48,58,64,66,66,64,57,47,34,21,4,0,0,0,0,0,0,0,0,0,0,22,42,64,86,106,129,149,171,163,141,118,97,118,141,163,168,147,124,104,82,61,40,19,0,0,0,0,0,0,0,0,0,0,0,20,41,62,82,103,123,146,166,171,149,129,141,163,165,144,121,101,80,59,38,17,0,0,0,0,0,0,0,0,9,33,56,80,104,129,152,175,167,144,118,94,71,90,113,137,160,155,132,111,136,159,165,142,117,94,71,90,114,139,162,174,150,124,101,78,55,31,7,0,0,0,0,0,8,32,54,77,100,121,147,170,173,151,129,103,81,57,54,77,100,123,147,170,168,145,121,98,75,53,30,7,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,60,63,65,73,87,108,132,155,178,167,143,117,93,69,45,21,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,45,48,51,59,78,101,124,150,173,171,147,119,96,71,46,22,0,0,0,0,5,17,27,35,40,43,43,40,33,25,15,2,0,0,0,0,0,0,0,0,0,0,0,11,32,53,74,96,116,139,161,172,151,129,107,130,151,172,157,136,114,93,72,50,29,8,0,0,0,0,0,0,0,0,0,0,0,8,29,49,71,91,112,135,155,175,162,150,155,173,154,132,110,90,69,48,27,6,0,0,0,0,0,0,0,0,4,28,52,75,99,121,147,171,171,147,121,99,75,95,118,143,166,151,124,106,132,154,171,147,123,100,77,93,116,142,166,170,146,121,98,73,50,26,2,0,0,0,0,0,1,24,47,70,93,116,139,162,180,157,134,109,87,64,61,84,106,132,154,176,160,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,86,86,86,89,96,107,123,143,164,182,160,137,113,88,64,41,16,0,0,2,27,53,78,104,129,154,180,170,144,116,91,71,71,71,75,81,93,112,135,157,180,164,141,115,91,67,43,18,0,0,0,0,6,18,28,36,42,43,43,41,35,27,16,4,0,0,0,0,0,0,0,0,0,0,0,0,22,42,64,86,106,129,150,171,160,139,116,139,161,168,147,124,104,82,62,40,19,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,58,80,100,121,144,164,182,175,178,163,141,119,98,78,57,36,15,0,0,0,0,0,0,0,0,0,0,23,47,70,94,117,143,166,175,152,129,103,79,101,124,149,170,146,121,101,124,149,172,154,132,106,82,98,121,147,170,165,142,116,93,69,45,22,0,0,0,0,0,0,0,17,40,63,86,109,134,155,178,163,140,116,93,70,67,90,113,137,160,176,153,132,106,84,61,38,16,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,109,109,109,111,114,118,129,141,159,177,169,148,129,104,81,57,35,11,0,0,2,27,53,78,104,129,154,180,170,144,116,93,93,93,96,98,104,114,130,148,169,177,155,132,108,85,61,37,13,0,0,0,10,24,38,50,59,65,68,68,65,58,48,36,22,6,0,0,0,0,0,0,0,0,0,0,0,11,32,54,74,96,116,139,161,170,148,132,149,170,157,137,114,92,72,50,30,8,0,0,0,0,0,0,0,0,0,0,0,0,0,5,26,47,67,88,109,132,155,180,198,175,152,130,108,87,66,45,24,4,0,0,0,0,0,0,0,0,0,0,19,42,66,90,114,138,162,180,155,132,106,83,106,132,155,163,140,116,96,119,144,167,160,137,111,88,101,124,151,175,160,137,111,88,65,41,17,0,0,0,0,0,0,0,10,33,56,78,101,124,148,171,170,147,123,100,77,74,97,119,144,167,169,146,121,99,77,53,31,8,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,171,147,137,137,137,137,137,139,144,152,163,177,169,153,134,113,92,71,49,26,3,0,0,2,27,53,78,104,129,154,180,170,144,119,119,119,119,121,121,129,137,149,164,180,162,143,119,98,75,52,29,6,0,0,7,25,42,56,70,81,88,91,91,88,79,68,53,38,21,4,0,0,0,0,0,0,0,0,0,0,0,22,44,64,86,106,129,150,171,165,157,165,167,147,124,103,82,61,40,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,56,78,98,118,141,162,184,183,177,155,135,113,91,71,50,29,9,0,0,0,0,0,0,0,0,0,0,14,38,61,85,109,134,157,180,160,137,111,89,113,137,160,158,135,110,90,114,138,161,165,142,117,94,106,132,155,178,155,132,107,83,60,36,12,0,0,0,0,0,0,0,3,25,49,72,94,116,141,164,176,154,132,107,84,81,104,129,152,173,162,139,115,92,69,46,24,1,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,182,166,162,162,162,162,162,162,167,174,171,162,149,135,116,98,79,58,38,16,0,0,0,2,27,53,78,104,129,154,180,174,154,147,147,147,147,147,147,152,160,170,174,161,144,124,107,86,64,42,20,0,0,0,20,38,57,74,89,103,112,116,116,110,100,87,71,53,34,15,0,0,0,0,0,0,0,0,0,0,0,11,33,54,74,96,117,139,161,181,180,178,157,137,114,92,72,50,30,8,0,0,0,0,0,0,0,0,0,0,0,0,0,6,27,47,69,89,109,132,153,173,161,158,170,167,146,124,104,83,62,41,21,0,0,0,0,0,0,0,0,0,0,9,33,57,80,104,129,152,175,164,140,114,93,117,142,166,153,129,105,84,108,132,155,171,147,121,99,109,136,160,175,152,129,102,79,55,32,8,0,0,0,0,0,0,0,0,18,41,64,87,110,134,157,180,160,137,114,90,87,110,134,157,177,155,132,108,85,62,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,182,166,162,162,162,162,162,173,191,171,150,139,129,114,98,82,64,45,24,4,0,0,0,2,27,53,78,104,129,154,180,188,173,170,170,170,170,172,172,174,169,162,153,141,124,109,91,72,51,30,8,0,0,8,29,49,69,88,105,121,135,142,141,134,119,103,84,65,45,25,0,0,0,0,0,0,0,0,0,0,0,0,22,44,64,86,107,129,150,171,189,167,147,124,104,82,61,40,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,39,59,80,101,121,144,164,163,141,136,157,179,158,138,115,95,74,53,33,12,0,0,0,0,0,0,0,0,0,4,28,52,75,99,121,147,171,167,144,119,99,121,147,171,147,121,99,78,101,124,150,173,152,129,104,114,139,162,170,147,121,98,75,51,27,3,0,0,0,0,0,0,0,0,11,34,57,80,103,124,150,172,167,144,119,96,93,116,140,163,170,147,123,101,77,55,32,9,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,172,148,137,137,137,137,139,158,179,167,143,119,105,93,80,64,47,29,10,0,0,0,0,2,27,53,78,104,129,154,180,178,160,154,154,154,154,154,152,149,145,139,130,118,105,91,73,55,36,17,0,0,0,14,36,57,78,98,118,139,155,165,164,153,136,115,94,74,53,32,0,0,0,0,0,0,0,0,0,0,0,0,12,33,54,75,96,117,142,165,185,162,139,114,92,72,50,30,8,0,0,0,0,0,0,0,0,0,0,0,0,0,9,30,50,71,92,113,135,155,174,153,132,123,146,167,170,149,129,107,86,65,45,24,3,0,0,0,0,0,0,0,0,0,23,47,70,94,117,143,167,172,147,121,104,129,152,165,142,116,93,73,96,119,144,168,157,134,109,116,142,167,165,142,116,93,70,46,22,0,0,0,0,0,0,0,0,0,4,27,50,73,96,118,143,165,173,150,124,102,99,121,147,170,163,140,116,93,70,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,111,111,111,123,146,167,175,154,132,110,89,67,46,29,12,0,0,0,0,0,2,27,53,78,104,129,154,180,170,144,129,129,129,129,129,129,124,121,114,107,97,85,71,56,38,21,2,0,0,0,19,40,62,83,104,124,148,168,187,184,165,144,121,99,78,55,35,0,0,0,0,0,0,0,0,0,0,0,0,2,22,45,68,91,116,142,165,185,162,139,111,88,66,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,41,62,83,104,124,146,167,164,143,119,113,136,157,178,162,140,118,98,77,57,36,15,0,0,0,0,0,0,0,0,0,19,42,66,90,114,139,162,175,152,129,109,134,157,160,137,112,88,67,91,114,139,162,162,139,114,121,147,170,161,137,112,89,65,42,18,0,0,0,0,0,0,0,0,0,0,20,43,65,89,111,136,158,179,155,134,109,106,130,152,176,155,134,109,86,63,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,86,90,112,135,156,177,166,145,121,101,79,58,37,15,0,0,0,0,0,2,27,53,78,104,129,154,180,170,144,116,104,104,104,103,101,100,96,91,84,74,63,51,36,21,3,0,0,0,0,20,40,63,83,106,129,150,170,192,188,167,146,121,101,78,55,35,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,12,32,53,74,95,115,138,158,176,154,132,109,103,123,146,167,173,153,132,109,89,69,48,27,6,0,0,0,0,0,0,0,0,14,38,62,85,109,134,157,178,155,132,114,139,162,155,132,106,83,62,85,109,134,157,167,144,119,124,150,173,156,134,108,84,61,37,13,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,129,151,173,162,139,114,111,137,160,172,148,124,101,79,56,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,78,99,121,144,165,178,157,136,113,91,70,49,28,6,0,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,78,78,78,78,76,72,67,60,51,41,30,17,2,0,0,0,0,0,16,37,59,80,101,121,143,161,172,171,157,139,117,97,76,54,34,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,3,24,45,65,86,107,129,149,170,165,144,121,99,91,112,135,156,177,164,144,121,101,81,59,39,18,0,0,0,0,0,0,0,0,9,33,57,80,104,129,152,176,159,135,119,144,167,149,124,101,78,56,80,103,129,152,173,149,124,129,153,175,152,129,103,80,56,32,9,0,0,0,0,0,0,0,0,0,0,5,28,51,74,97,119,144,166,168,146,121,117,142,165,164,142,117,94,72,49,26,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,66,88,109,132,154,175,169,148,124,104,82,62,40,18,0,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,53,53,53,51,48,43,37,29,20,8,0,0,0,0,0,0,0,10,32,52,72,91,110,129,141,149,147,139,123,107,88,68,48,28,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,14,36,56,76,98,118,140,162,177,155,134,112,90,80,101,121,145,165,177,156,135,113,92,71,50,30,9,0,0,0,0,0,0,0,5,28,52,75,99,121,147,171,162,139,124,148,167,144,119,96,72,51,74,98,121,145,169,154,132,134,157,170,147,121,99,75,52,28,4,0,0,0,0,0,0,0,0,0,0,0,21,44,67,90,113,137,159,175,152,129,124,149,172,157,134,110,87,65,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,55,76,98,119,143,163,181,160,139,116,95,73,52,30,9,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,30,27,27,24,19,13,6,0,0,0,0,0,0,0,0,0,2,22,41,61,78,94,108,118,121,121,117,107,91,75,57,38,19,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,0,6,27,47,68,89,109,132,153,173,165,144,121,100,79,69,90,110,134,154,175,167,147,124,104,83,63,42,21,0,0,0,0,0,0,0,0,24,47,71,94,118,143,167,166,142,130,153,162,138,114,90,67,45,69,92,115,139,163,159,136,137,160,166,143,117,93,70,47,23,0,0,0,0,0,0,0,0,0,0,0,0,14,36,60,82,106,129,152,175,160,137,132,155,173,150,124,103,80,57,34,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,43,64,86,107,130,152,173,172,150,129,107,86,64,42,21,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,29,46,62,76,88,96,99,99,94,86,74,58,43,26,8,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,0,17,38,59,80,100,121,144,164,175,154,132,110,89,67,57,79,100,121,144,164,179,158,138,116,95,74,54,33,12,0,0,0,0,0,0,0,19,43,66,90,114,139,162,173,154,147,161,156,132,108,85,61,40,63,86,109,134,157,167,149,150,167,162,138,114,90,66,42,19,0,0,0,0,0,0,0,0,0,0,0,0,7,29,53,75,98,121,144,168,167,148,146,164,166,143,119,96,73,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,43,53,74,96,117,140,162,183,163,141,118,98,76,55,33,12,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,30,44,56,66,72,76,75,72,64,54,42,26,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,185,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,8,30,50,71,91,112,135,155,176,164,144,121,99,78,56,46,67,89,109,132,153,174,171,149,129,107,87,66,45,24,4,0,0,0,0,0,0,14,38,62,85,109,134,157,180,176,173,174,151,129,102,79,56,34,57,81,104,129,152,175,173,173,180,157,134,109,85,61,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,114,137,160,182,172,170,181,159,136,111,89,65,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,185,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,170,144,119,93,68,43,41,63,84,105,129,150,172,175,154,132,109,88,67,46,24,3,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,24,34,43,49,50,50,48,42,33,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,175,162,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,0,20,41,62,83,104,124,146,167,174,153,132,109,88,67,46,34,56,78,98,119,141,163,175,162,141,118,98,78,57,36,15,0,0,0,0,0,0,9,33,57,80,104,129,152,175,175,175,168,145,121,97,73,50,28,52,75,98,121,147,170,175,175,175,152,129,104,80,57,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,106,132,153,175,175,175,174,152,129,104,81,59,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,162,175,160,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,175,170,144,119,93,68,43,29,50,72,93,115,138,160,175,165,144,121,100,79,58,37,14,0,2,27,53,78,104,129,154,175,170,144,116,91,66,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,20,25,27,27,24,19,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,149,149,149,139,111,88,66,43,17,0,0,0,0,0,0,0,0,0,3,28,51,73,95,115,137,149,149,149,143,119,98,76,56,34,24,45,66,87,108,132,149,149,149,149,132,110,90,68,45,21,0,0,0,0,0,0,5,28,52,76,99,123,147,149,149,149,149,139,115,91,68,45,23,46,70,93,116,141,149,149,149,149,147,123,99,76,52,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,53,77,99,121,146,149,149,149,149,144,119,98,74,51,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,109,137,149,149,149,137,109,83,58,33,7,0,0,0,0,0,0,0,0,5,30,53,78,104,129,149,149,149,144,119,93,68,43,20,39,61,82,104,124,148,149,149,149,136,113,91,69,45,21,0,2,27,53,78,104,129,149,149,149,144,116,91,66,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,115,121,121,121,121,121,110,88,65,43,17,0,0,0,0,0,0,0,0,0,4,30,53,75,101,121,121,121,121,121,121,108,87,66,45,23,13,33,55,75,97,117,121,121,121,121,121,117,93,70,48,22,0,0,0,0,0,0,0,24,47,71,95,117,121,121,121,121,121,121,109,86,63,39,17,41,64,88,110,121,121,121,121,121,121,117,95,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,46,69,92,114,121,121,121,121,121,121,113,90,67,44,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,60,86,108,121,121,121,121,121,108,83,58,32,7,0,0,0,0,0,0,0,0,4,30,53,78,103,121,121,121,121,121,117,93,68,43,20,27,49,70,92,114,121,121,121,121,121,119,96,73,48,22,0,2,27,53,78,103,121,121,121,121,121,115,91,65,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,41,62,81,97,99,99,99,99,99,95,79,59,38,14,0,0,0,0,0,0,0,0,0,1,26,48,71,89,98,99,99,99,99,99,93,76,55,34,13,2,22,44,64,83,98,99,99,99,99,99,98,85,64,43,21,0,0,0,0,0,0,0,19,41,64,83,98,99,99,99,99,99,99,93,77,55,33,11,34,57,77,95,99,99,99,99,99,99,98,83,64,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,39,61,81,96,99,99,99,99,99,99,95,79,59,36,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,31,55,77,93,99,99,99,99,99,93,75,52,28,4,0,0,0,0,0,0,0,0,1,26,48,71,90,99,99,99,99,99,98,83,62,38,16,15,37,58,79,96,99,99,99,99,99,98,85,66,43,19,0,0,24,48,71,90,99,99,99,99,99,97,81,59,36,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,47,62,72,73,73,73,73,73,71,61,45,27,5,0,0,0,0,0,0,0,0,0,0,16,36,53,67,73,73,73,73,73,73,70,58,42,23,2,0,11,31,49,64,73,73,73,73,73,73,73,65,49,31,9,0,0,0,0,0,0,0,9,29,49,64,73,73,73,73,73,73,73,70,59,42,23,3,23,44,59,71,73,73,73,73,73,73,73,64,49,30,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,27,47,62,72,73,73,73,73,73,73,72,61,45,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,59,70,73,73,73,73,73,70,58,40,18,0,0,0,0,0,0,0,0,0,0,16,36,55,68,73,73,73,73,73,73,64,47,27,7,4,25,44,61,72,73,73,73,73,73,73,65,51,31,9,0,0,14,36,55,68,73,73,73,73,73,72,62,45,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,28,40,47,48,48,48,48,48,46,39,27,11,0,0,0,0,0,0,0,0,0,0,0,2,19,33,44,48,48,48,48,48,48,46,37,24,8,0,0,0,15,30,42,47,48,48,48,48,48,47,41,30,15,0,0,0,0,0,0,0,0,0,13,30,41,47,48,48,48,48,48,48,46,38,24,8,0,8,25,38,46,48,48,48,48,48,48,47,41,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,28,40,47,48,48,48,48,48,48,47,39,27,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,24,38,46,48,48,48,48,48,46,37,22,4,0,0,0,0,0,0,0,0,0,0,2,19,34,45,48,48,48,48,48,47,41,28,11,0,0,10,27,39,47,48,48,48,48,48,48,42,31,15,0,0,0,0,19,34,45,48,48,48,48,48,47,40,27,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,24,25,25,25,25,25,24,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,23,16,5,0,0,0,0,0,11,20,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,11,20,25,25,25,25,25,25,25,23,17,5,0,0,0,7,17,24,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,19,24,25,25,25,25,25,25,24,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,23,25,25,25,25,25,23,16,4,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,20,9,0,0,0,0,7,18,24,25,25,25,25,25,25,20,12,0,0,0,0,0,1,14,22,25,25,25,25,25,24,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,20,12,0,0,0,0,0,8,19,24,25,25,25,25,25,21,12,0,0,0,0,0,2,14,22,25,25,25,25,25,25,23,16,4,0,0,0,0,0,0,0,7,18,24,25,25,25,25,25,25,21,12,0,0,0,0,0,1,14,22,25,25,25,25,25,25,20,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,24,20,9,0,0,0,0,11,20,25,25,25,25,25,25,24,18,7,0,0,0,0,0,0,2,15,22,25,25,25,25,25,25,21,12,0,0,0,0,0,1,13,22,25,25,25,25,25,25,21,13,0,0,0,0,0,4,15,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,2,15,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,18,8,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,22,18,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,36,47,50,50,50,50,50,50,44,33,17,0,0,0,11,29,42,49,50,50,50,50,50,45,33,17,0,0,0,4,22,36,47,50,50,50,50,50,50,48,39,24,6,0,0,0,0,0,9,27,41,49,50,50,50,50,50,50,45,33,17,0,0,0,4,21,36,47,50,50,50,50,50,50,43,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,36,47,50,50,50,50,50,50,43,30,13,0,0,15,32,43,50,50,50,50,50,50,49,41,27,9,0,0,0,0,6,22,38,47,50,50,50,50,50,50,45,33,19,0,0,0,4,21,35,46,50,50,50,50,50,50,45,35,19,2,0,0,6,24,38,47,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,33,19,2,0,0,6,22,38,47,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,49,41,29,11,0,0,0,2,21,36,47,50,50,50,50,50,50,50,50,50,50,47,43,38,31,23,14,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,56,71,76,76,76,76,76,75,67,51,32,11,0,4,26,47,63,74,76,76,76,76,75,69,53,33,11,0,0,17,39,56,71,76,76,76,76,76,76,72,58,41,21,0,0,0,0,3,24,45,61,73,76,76,76,76,76,75,67,53,33,12,0,0,17,37,56,71,76,76,76,76,76,75,66,49,29,8,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,56,71,76,76,76,76,76,75,64,49,28,6,12,31,49,66,75,76,76,76,76,76,73,63,45,24,1,0,0,0,20,39,58,71,76,76,76,76,76,75,67,53,33,13,0,0,16,37,55,69,76,76,76,76,76,75,69,55,35,15,0,0,20,41,58,71,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,75,69,53,35,15,0,0,20,39,58,71,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,74,63,47,26,6,0,0,15,37,56,71,76,76,76,76,76,76,76,76,76,73,71,67,61,54,46,37,25,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99])
.concat([99,99,99,98,85,66,45,23,1,11,36,59,81,96,99,99,99,99,98,87,66,43,19,0,1,26,50,71,90,99,99,99,99,99,99,92,75,54,31,8,0,0,0,12,35,57,79,95,99,99,99,99,99,98,87,66,43,21,0,1,26,48,71,90,99,99,99,99,99,98,83,62,41,16,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,97,83,62,38,14,27,46,65,85,98,99,99,99,99,99,95,79,57,33,9,0,0,4,28,50,73,90,99,99,99,99,99,98,87,66,45,21,0,1,26,48,69,89,98,99,99,99,99,98,87,69,45,24,0,6,28,52,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,24,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,96,79,59,36,14,0,0,24,48,71,90,99,99,99,99,99,99,99,99,99,98,95,91,85,77,68,58,46,33,19,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,103,124,124,124,124,124,121,99,78,56,34,13,15,40,65,91,114,124,124,124,124,121,98,73,48,22,0,5,30,55,78,103,124,124,124,124,124,124,108,85,62,39,16,0,0,0,20,43,66,90,112,124,124,124,124,124,121,98,73,48,25,0,5,30,53,78,103,124,124,124,124,124,118,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,103,124,124,124,124,124,116,93,68,43,22,42,61,81,100,119,124,124,124,124,124,114,88,63,38,15,0,0,7,32,55,81,103,124,124,124,124,124,121,98,73,50,25,2,5,30,53,76,101,123,124,124,124,124,121,98,76,50,27,0,10,32,58,81,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,98,73,50,27,0,7,32,55,81,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,114,88,65,40,17,0,2,27,53,78,103,124,124,124,124,124,124,124,124,124,121,119,114,109,101,91,80,67,54,38,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,152,152,152,152,135,112,90,69,46,25,15,40,66,91,114,142,152,152,149,121,99,73,48,22,0,5,30,55,78,104,129,152,152,152,152,141,116,93,71,48,25,2,0,5,28,51,74,98,119,144,152,152,152,149,121,99,73,48,25,0,5,30,53,78,104,129,152,152,152,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,152,152,152,144,116,93,68,43,38,57,76,96,116,136,152,152,152,143,121,103,82,59,35,10,0,0,7,33,55,81,104,129,152,152,152,147,121,99,73,50,25,2,5,30,53,76,101,124,152,152,152,149,121,99,76,50,27,0,10,33,58,81,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,147,121,99,73,50,27,0,7,33,55,81,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,139,114,88,66,40,17,0,2,27,53,78,104,129,152,152,152,152,152,152,152,151,148,144,140,134,123,114,101,88,73,56,40,22,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,175,167,146,123,101,80,58,37,15,40,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,175,175,172,149,124,102,79,56,33,10,0,13,37,59,82,106,130,153,175,175,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,175,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,170,144,116,93,68,43,52,72,91,110,132,152,170,166,147,129,107,88,68,48,27,4,0,0,7,33,55,81,104,129,154,175,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,172,147,121,99,73,50,27,0,7,33,55,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,165,139,114,88,66,40,17,0,2,27,53,78,104,129,154,175,175,175,175,175,175,175,172,168,163,156,147,136,121,108,92,74,56,38,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,200,180,158,137,114,92,70,48,27,40,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,200,180,158,135,110,88,65,42,19,0,22,45,68,91,114,138,161,184,198,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,68,48,67,87,107,124,146,166,171,152,132,110,92,72,53,33,14,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,180,163,154,154,154,154,154,154,154,154,154,154,154,147,121,99,73,50,27,0,7,33,55,81,104,129,154,177,180,161,154,154,154,154,154,154,154,154,154,154,154,139,114,88,66,40,17,0,2,27,53,78,104,129,154,180,175,155,149,149,149,152,154,160,168,178,170,158,144,129,110,92,72,52,32,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,185,180,170,148,124,104,82,61,39,40,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,184,180,166,143,119,96,73,50,27,7,30,53,76,99,121,146,169,180,186,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,68,63,83,101,121,143,162,175,155,136,116,96,76,57,38,18,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,150,129,129,129,129,129,129,129,129,129,129,129,129,121,99,73,50,27,0,7,33,55,81,104,129,154,177,172,147,129,129,129,129,129,129,129,129,129,129,129,129,114,88,66,40,17,0,2,27,53,78,104,129,154,180,170,144,121,121,124,124,130,137,145,156,170,178,162,146,129,107,87,66,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,163,154,164,160,139,115,93,72,50,40,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,161,155,166,152,129,105,81,59,36,16,38,61,84,107,132,154,161,155,164,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,68,78,98,117,137,157,177,160,141,119,100,81,62,42,23,3,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,104,104,104,104,104,104,104,104,104,104,104,103,89,68,47,24,0,7,33,55,81,104,129,154,177,172,147,121,104,104,104,104,104,104,104,104,104,104,104,99,81,60,36,14,0,2,27,53,78,104,129,154,180,170,144,116,99,99,101,106,112,121,136,150,168,181,162,143,121,100,78,56,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,150,129,150,172,150,129,106,84,63,41,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,172,147,132,152,160,137,113,90,67,44,24,46,70,92,115,139,163,147,130,152,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,74,93,112,134,153,172,164,144,124,105,85,65,46,27,7,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,7,7,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,78,78,78,78,78,78,78,78,78,78,78,71,55,36,16,0,7,33,55,81,104,129,154,177,172,147,121,96,78,78,78,78,78,78,78,78,78,78,77,65,49,28,7,0,2,27,53,78,104,129,154,180,170,144,116,91,74,77,81,89,100,114,132,152,172,177,157,136,112,89,65,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,151,124,139,162,162,140,117,96,74,53,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,172,147,121,144,168,146,121,98,76,53,32,55,78,101,124,148,162,139,129,154,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,89,109,129,148,168,168,149,130,109,90,70,51,31,12,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,30,30,30,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,53,53,53,53,53,53,53,53,53,48,36,21,3,0,7,33,55,81,104,129,154,177,172,147,121,96,73,53,53,53,53,53,53,53,53,53,52,44,31,13,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,52,57,66,80,96,115,137,158,181,169,146,121,98,74,50,27,3,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,177,152,129,129,150,173,152,130,108,86,64,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,175,149,124,137,160,154,132,107,84,61,40,63,86,109,134,156,154,132,132,157,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,93,104,123,144,163,173,154,134,113,94,74,55,36,16,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,55,55,55,55,55,55,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,35,35,35,35,35,35,35,32,30,25,16,4,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,53,53,53,53,53,53,53,52,46,34,22,11,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,34,45,61,81,101,124,148,172,178,155,132,106,81,57,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,154,129,117,140,162,164,143,119,98,76,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,175,152,124,129,152,163,139,115,93,69,49,71,94,116,141,164,146,121,134,159,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,99,118,139,159,177,158,139,117,98,79,59,40,20,1,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,81,81,81,81,81,81,81,81,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,60,60,60,60,60,60,60,60,57,45,30,12,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,78,78,78,78,78,78,78,78,77,68,53,32,12,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,26,46,69,91,115,139,163,185,161,137,111,87,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,157,132,106,130,152,174,154,132,110,88,66,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,178,154,129,119,144,167,147,123,101,78,57,79,103,124,149,160,138,113,137,160,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,114,136,155,174,164,143,121,103,83,64,44,24,5,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,104,104,104,104,104,104,104,104,104,104,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,83,83,83,83,83,83,83,83,83,78,64,45,23,2,0,0,7,33,55,81,104,129,154,177,172,147,121,104,104,104,104,104,104,104,104,104,101,85,65,41,19,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,13,36,60,84,109,134,158,183,167,142,116,91,67,42,17,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,160,134,106,117,141,164,166,145,121,100,79,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,155,132,111,136,159,156,134,109,86,65,88,111,135,158,152,129,113,139,162,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,116,132,150,170,188,163,141,118,97,75,54,33,11,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,173,148,132,132,132,132,132,132,132,132,132,132,132,132,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,109,109,109,109,109,109,109,109,109,109,98,77,55,31,8,0,0,7,33,55,81,104,129,154,177,172,147,129,129,129,129,129,129,129,129,129,129,119,93,71,45,22,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,5,29,54,79,104,130,154,180,170,145,119,93,69,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,160,137,109,107,130,152,173,156,135,112,90,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,157,134,106,129,150,164,141,117,95,73,96,119,143,166,144,119,114,141,165,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,170,144,124,146,165,184,186,174,153,132,109,88,67,45,24,2,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,181,163,157,157,157,157,157,157,157,157,157,157,157,157,166,184,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,173,152,137,137,137,137,137,137,137,137,137,137,129,104,81,58,33,10,0,0,7,33,55,81,104,129,154,177,180,161,154,154,154,154,154,154,154,154,154,144,119,93,71,45,22,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,2,26,50,76,101,129,152,177,172,147,121,96,71,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,162,138,111,95,116,140,162,168,147,123,101,91,114,142,167,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,160,134,109,117,141,164,150,129,103,82,105,129,151,158,135,111,116,142,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,174,154,147,161,177,162,162,177,165,144,121,100,79,57,36,14,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,195,182,177,177,177,177,177,177,177,177,177,177,177,177,183,197,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,184,167,160,160,160,160,160,160,160,160,160,154,129,104,81,58,33,10,0,0,7,33,55,81,104,129,154,177,195,180,175,175,175,175,175,175,175,175,170,144,119,93,71,45,22,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,0,25,50,73,99,124,152,177,175,149,121,96,71,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,86,105,129,149,171,158,137,114,92,114,142,165,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,160,137,109,109,134,155,158,136,111,90,113,138,160,149,124,102,116,142,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,188,173,170,179,161,141,143,163,178,156,135,112,91,70,48,27,6,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,179,161,152,152,152,152,152,152,152,152,152,152,152,152,162,182,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,189,175,170,170,170,170,170,170,170,170,170,154,129,104,81,58,33,10,0,0,7,33,55,81,104,129,154,177,179,159,152,152,152,152,152,152,152,152,152,144,119,93,71,45,22,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,0,25,50,74,99,124,152,177,175,149,121,96,71,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,93,115,138,160,170,148,124,105,111,139,165,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,101,123,147,166,144,119,98,121,145,163,140,116,93,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,197,184,164,145,124,129,150,172,169,147,124,104,82,61,39,18,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,129,129,129,129,129,129,129,129,129,129,129,129,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,177,155,144,144,144,144,144,144,144,144,144,144,129,104,81,58,33,10,0,0,7,33,55,81,104,129,154,177,172,147,124,124,124,124,124,124,124,124,124,124,118,93,71,45,22,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,2,27,51,76,101,129,152,177,172,147,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,81,103,124,147,169,161,138,115,111,137,162,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,92,114,139,162,152,129,106,130,153,155,132,108,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,188,168,149,130,109,116,138,160,181,160,138,116,95,73,52,31,9,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,101,101,101,101,101,101,101,101,101,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,119,119,119,119,119,119,119,119,119,119,102,80,57,32,9,0,0,7,33,55,81,104,129,154,177,172,147,121,99,99,99,99,99,99,99,99,99,98,83,64,41,19,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,6,30,55,80,104,132,155,180,170,144,119,93,68,44,19,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,70,91,113,136,157,172,149,124,109,136,160,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,106,130,153,160,137,114,138,161,146,121,99,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,192,172,154,134,114,94,104,124,147,169,172,150,130,107,86,64,43,22,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,76,76,76,76,76,76,76,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,93,93,93,93,93,93,93,93,93,86,70,49,27,5,0,0,7,33,55,81,104,129,154,177,172,147,121,96,76,76,76,76,76,76,76,76,75,66,49,31,9,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,14,37,61,85,109,135,160,183,165,141,114,90,65,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,79,101,123,145,167,160,138,114,134,157,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,98,119,144,167,144,121,145,160,138,114,90,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,20,5,5,5,5,5,5,4,1,0,0,0,0,5,27,53,78,104,129,154,180,177,157,137,117,98,79,91,113,136,157,179,163,143,119,98,76,55,34,13,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,53,53,53,53,53,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,68,68,68,68,68,68,68,68,64,52,36,16,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,50,50,50,50,50,50,50,50,43,32,15,0,0,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,15,28,48,70,93,116,141,165,183,160,136,109,86,61,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,67,89,110,134,155,170,148,124,132,155,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,89,112,136,158,155,144,155,152,129,105,82,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,45,30,30,30,30,30,30,30,30,25,15,2,0,0,5,27,53,78,104,129,154,180,170,144,121,101,83,63,79,100,121,145,166,175,154,134,110,89,68,47,25,4,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,27,27,27,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,45,45,45,45,45,45,45,42,32,18,2,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,48,30,30,30,30,30,30,30,30,30,26,16,4,0,0,2,27,53,78,104,129,154,180,170,144,116,91,66,40,35,47,63,82,104,124,149,173,175,152,129,103,79,55,31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,56,78,99,121,144,165,158,137,129,154,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,80,103,129,149,172,167,166,143,119,96,73,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,68,53,53,53,53,53,53,53,53,53,48,36,19,0,0,5,27,53,78,104,129,154,180,170,144,116,93,68,48,67,88,109,132,154,175,167,146,123,101,80,59,38,16,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,27,20,20,20,20,20,20,17,10,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,73,53,53,53,53,53,53,53,53,53,53,48,37,21,3,0,2,27,53,78,104,129,154,180,170,144,116,91,66,53,58,67,81,98,117,139,161,182,165,144,118,95,72,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,44,66,87,108,132,154,170,147,130,152,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,71,94,117,141,164,180,157,134,110,88,68,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,93,78,78,78,78,78,78,78,78,78,78,71,55,34,12,0,5,27,53,78,104,129,154,180,170,144,116,93,68,43,55,76,98,119,143,163,179,158,137,114,92,72,50,28,7,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,96,78,78,78,78,78,78,78,78,78,78,78,71,56,36,16,0,2,27,53,78,104,129,154,180,170,144,116,91,76,77,81,90,101,116,134,154,173,175,154,132,109,86,63,40,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,38,54,75,97,118,141,163,163,155,164,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,63,86,109,132,155,172,148,124,102,79,68,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,144,119,104,104,104,104,104,104,104,104,104,104,103,89,67,45,20,0,5,27,53,78,104,129,154,180,170,144,116,93,68,43,43,64,86,107,130,152,172,170,148,129,105,83,62,41,20,0,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,121,104,104,104,104,104,104,104,104,104,104,104,103,90,70,47,24,0,2,27,53,78,104,129,154,180,170,144,116,99,99,101,106,113,123,137,152,170,179,161,141,118,98,75,53,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,38,42,64,85,107,130,152,173,180,186,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,60,77,100,121,147,163,140,116,93,70,68,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,170,145,129,129,129,129,129,129,129,129,129,129,129,121,99,73,48,22,0,5,27,53,78,104,129,154,180,170,144,116,93,68,43,31,52,73,95,116,139,161,182,161,139,117,96,74,53,32,11,0,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,172,147,129,129,129,129,129,129,129,129,129,129,129,129,121,99,76,50,27,0,2,27,53,78,104,129,154,180,170,144,124,124,124,124,132,137,146,157,171,177,162,144,124,105,85,64,41,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,165,139,111,88,63,38,30,51,73,95,116,139,161,182,198,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,180,162,137,109,86,60,69,91,114,138,139,132,107,85,62,68,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,180,178,160,154,154,154,154,154,154,154,154,154,154,149,121,99,73,48,22,0,5,27,53,78,104,129,154,180,170,144,116,93,68,43,19,40,61,83,105,124,148,170,173,152,132,108,87,65,45,23,2,0,7,33,55,81,104,129,154,177,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,180,161,154,154,154,154,154,154,154,154,154,154,154,149,121,99,76,50,27,0,2,27,53,78,104,129,154,180,175,155,149,149,150,152,155,160,168,179,169,157,143,124,109,89,71,50,29,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,165,139,111,88,63,38,18,40,62,83,105,129,149,171,175,175,149,121,99,73,48,22,0,5,30,55,78,104,129,154,175,162,137,109,86,60,60,82,103,111,111,111,98,76,53,68,91,116,144,167,172,149,121,99,73,48,25,0,5,30,53,78,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,149,121,99,73,48,22,0,5,27,53,78,104,129,154,175,170,144,116,93,68,43,17,28,49,71,92,114,136,157,175,164,144,121,99,78,57,35,13,0,7,33,55,81,104,129,154,175,172,147,121,99,73,50,25,2,5,30,53,76,101,124,152,175,172,149,121,99,76,50,27,0,10,33,58,81,104,129,154,175,172,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,99,76,50,27,0,2,27,53,78,104,129,154,175,175,175,175,175,175,175,172,168,163,156,147,136,121,107,91,73,55,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,149,149,149,139,111,88,63,38,12,28,49,71,93,114,137,149,149,149,149,121,99,73,48,22,0,5,30,55,78,104,129,149,149,149,137,109,86,60,49,69,83,88,88,88,81,63,44,68,91,116,144,149,149,149,121,99,73,48,25,0,5,30,53,78,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,48,22,0,5,27,53,78,104,129,149,149,149,144,116,93,68,43,17,15,37,58,80,101,123,146,149,149,149,135,112,90,68,43,20,0,7,33,55,81,104,129,149,149,149,147,121,99,73,50,25,2,5,30,53,76,101,124,149,149,149,149,121,99,76,50,27,0,10,33,58,81,104,129,149,149,149,149,124,99,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,76,50,27,0,2,27,53,78,104,129,149,149,149,149,149,149,149,149,149,145,139,134,123,113,101,87,72,55,38,20,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,53,78,103,121,121,121,121,121,110,88,63,37,12,16,38,59,81,103,121,121,121,121,121,119,98,73,48,22,0,4,30,55,78,103,121,121,121,121,121,108,86,60,37,50,61,63,63,63,58,45,43,68,91,115,121,121,121,121,119,98,73,48,25,0,4,30,53,78,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,22,0,4,27,53,78,103,121,121,121,121,121,115,93,68,43,17,4,24,46,68,89,110,121,121,121,121,121,117,96,70,45,20,0,7,32,55,80,103,121,121,121,121,121,119,98,73,50,25,2,4,30,53,75,101,121,121,121,121,121,119,98,75,50,27,0,10,32,58,80,103,121,121,121,121,121,121,98,75,53,27,4,0,0,0,0,0,0,0,0,0,0,0,0,7,32,55,80,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,50,27,0,2,27,53,78,103,121,121,121,121,121,121,121,121,121,121,119,114,109,100,91,79,67,52,37,21,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,95,79,57,33,9,4,25,48,69,89,98,99,99,99,99,98,87,66,43,19,0,1,26,50,71,90,99,99,99,99,99,93,77,55,33,28,36,38,38,38,34,25,38,62,81,97,99,99,99,99,98,87,66,43,21,0,1,26,48,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,19,0,1,24,48,71,90,99,99,99,99,99,97,83,62,38,14,0,13,34,56,77,93,99,99,99,99,99,98,85,64,43,19,0,4,28,50,73,90,99,99,99,99,99,98,87,66,45,21,0,1,26,48,69,89,98,99,99,99,99,98,87,69,45,24,0,6,28,52,73,90,99,99,99,99,99,98,87,69,48,24,1,0,0,0,0,0,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,45,24,0,0,24,48,71,90,99,99,99,99,99,99,99,99,99,98,95,91,85,77,68,57,46,32,18,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,55,68,73,73,73,73,73,71,61,44,23,0,0,14,34,53,67,73,73,73,73,73,73,66,51,31,9,0,0,16,38,55,68,73,73,73,73,73,70,59,42,23,6,13,15,15,15,12,5,27,47,62,72,73,73,73,73,73,66,51,31,12,0,0,16,36,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,9,0,0,14,36,55,68,73,73,73,73,73,72,64,47,27,5,0,0,21,42,59,71,73,73,73,73,73,73,65,49,29,9,0,0,18,38,56,68,73,73,73,73,73,73,66,51,33,12,0,0,16,36,53,67,73,73,73,73,73,73,66,53,33,14,0,0,18,40,56,68,73,73,73,73,73,73,66,53,36,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,53,33,14,0,0,14,36,55,68,73,73,73,73,73,73,73,73,73,73,71,67,62,54,46,36,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,34,45,48,48,48,48,48,46,39,25,8,0,0,0,19,33,44,48,48,48,48,48,48,43,31,15,0,0,0,2,20,34,45,48,48,48,48,48,46,38,24,8,0,0,0,0,0,0,0,11,28,40,47,48,48,48,48,48,43,31,15,0,0,0,2,19,34,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,0,19,34,45,48,48,48,48,48,47,41,28,11,0,0,0,6,24,38,46,48,48,48,48,48,47,42,30,13,0,0,0,4,20,35,45,48,48,48,48,48,48,43,31,17,0,0,0,2,19,33,44,48,48,48,48,48,48,43,33,17,0,0,0,4,22,35,45,48,48,48,48,48,48,43,33,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,33,17,0,0,0,0,19,34,45,48,48,48,48,48,48,48,48,48,48,47,43,38,31,23,13,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,24,18,7,0,0,0,0,0,13,22,25,25,25,25,25,25,21,12,0,0,0,0,0,2,14,22,25,25,25,25,25,23,17,5,0,0,0,0,0,0,0,0,0,9,19,24,25,25,25,25,25,21,12,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,1,14,22,25,25,25,25,25,24,20,9,0,0,0,0,0,5,17,23,25,25,25,25,25,25,20,11,0,0,0,0,0,2,15,22,25,25,25,25,25,25,21,12,0,0,0,0,0,1,13,22,25,25,25,25,25,25,21,13,0,0,0,0,0,4,15,22,25,25,25,25,25,25,21,13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,13,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,22,18,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,22,25,25,25,25,25,25,25,25,25,25,25,24,21,17,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,17,22,25,30,29,25,21,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,24,26,30,28,25,20,15,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,17,22,25,29,29,25,22,17,11,2,0,0,0,0,0,0,0,0,0,0,0,0,7,19,27,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,29,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,8,15,21,24,27,30,28,25,22,17,12,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,12,19,24,27,30,27,24,19,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,36,47,50,50,50,50,50,50,50,50,50,50,50,48,45,42,37,31,23,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,36,46,50,50,50,50,50,50,50,45,33,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,24,33,41,47,50,53,53,50,46,40,31,22,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,20,29,38,44,49,50,53,52,50,45,39,31,21,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,25,34,41,47,50,53,53,50,47,41,34,25,14,2,0,0,0,0,0,0,0,0,0,7,26,41,51,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,48,34,18,0,0,0,0,0,0,0,0,0,1,13,23,32,39,45,49,51,53,52,50,47,42,36,28,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,27,36,44,49,51,53,51,48,43,36,27,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,39,56,71,76,76,76,76,76,76,76,76,76,76,75,73,70,66,61,54,46,35,24,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,37,55,70,76,76,76,76,76,76,75,69,53,35,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,22,35,47,57,65,71,75,78,77,74,69,63,54,44,32,19,4,0,0,0,0,0,0,0,0,0,0,0,1,15,29,41,51,61,67,73,76,78,76,73,69,62,53,42,31,17,1,0,0,0,0,0,0,0,0,0,0,0,0,11,24,37,48,57,65,71,75,78,77,75,71,65,57,47,36,23,10,0,0,0,0,0,0,0,0,19,41,58,72,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,77,68,51,32,12,0,0,0,0,0,0,0,10,23,34,45,55,63,69,73,76,78,76,74,71,66,60,51,41,30,16,2,0,0,0,0,0,0,0,0,0,0,0,9,24,38,49,59,67,73,76,78,76,73,67,59,49,37,24,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,26,50,71,90,99,99,99,99,99,99,99,99,99,99,99,97,93,90,85,77,67,56,44,29,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,49,71,89,98,99,99,99,99,99,98,87,69,47,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,8,26,42,56,69,79,88,95,99,102,101,98,93,86,76,65,52,38,22,4,0,0,0,0,0,0,0,0,0,1,19,35,49,63,74,84,91,97,99,103,101,98,93,85,75,64,51,35,19,1,0,0,0,0,0,0,0,0,0,0,13,29,45,58,70,80,89,95,99,102,101,99,95,89,80,69,57,43,29,13,0,0,0,0,0,0,5,28,52,73,92,103,104,104,104,104,104,104,104,104,104,104,104,104,104,104,101,86,64,42,20,0,0,0,0,0,2,16,30,43,56,67,77,85,93,98,101,103,101,99,95,90,83,73,63,50,36,20,3,0,0,0,0,0,0,0,0,0,10,28,44,58,71,82,91,97,101,104,101,96,90,81,71,58,43,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,103,124,124,124,124,124,124,124,124,124,124,124,121,118,114,108,100,90,78,64,47,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,57,79,102,123,124,124,124,124,124,121,100,77,54,33,9,0,0,0,0,0,0,0,0,0,0,0,0,7,26,44,60,76,90,101,111,119,124,129,124,121,116,109,98,86,72,56,40,22,4,0,0,0,0,0,0,0,0,17,35,53,69,83,97,107,115,121,124,129,124,121,116,108,98,85,70,53,37,18,0,0,0,0,0,0,0,0,0,13,31,48,64,79,92,103,112,119,124,129,124,124,119,112,103,91,78,64,47,31,13,0,0,0,0,0,8,32,55,78,101,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,116,93,68,45,22,0,0,0,0,4,21,36,50,64,77,89,99,109,116,121,124,129,124,124,119,114,106,96,83,70,55,37,20,1,0,0,0,0,0,0,0,9,28,46,62,78,92,105,114,121,124,129,124,121,114,104,92,78,62,44,27,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,152])
.concat([152,152,152,152,152,152,152,152,149,147,144,139,134,123,112,98,82,65,47,26,6,0,0,0,0,0,0,0,0,0,0,0,0,20,42,65,87,109,134,152,152,152,152,152,132,107,85,62,40,16,0,0,0,0,0,0,0,0,0,0,0,1,22,42,60,78,95,110,123,136,144,150,152,152,148,142,134,121,107,92,74,56,38,19,0,0,0,0,0,0,0,11,31,52,69,87,104,117,132,140,147,152,152,152,147,141,132,119,105,89,71,52,32,12,0,0,0,0,0,0,0,11,30,48,65,83,99,113,124,137,144,149,152,152,149,144,137,124,112,98,83,65,48,27,6,0,0,0,0,10,33,56,80,104,129,152,154,154,154,154,154,154,154,154,154,154,154,154,142,116,93,68,45,22,0,0,0,0,17,38,55,70,84,98,110,121,134,142,147,152,152,152,149,144,139,130,117,104,89,71,54,35,15,0,0,0,0,0,0,3,24,43,62,80,98,112,129,139,147,152,152,152,146,138,124,112,96,80,62,43,23,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,175,175,174,170,170,170,170,172,172,172,167,162,155,145,134,116,99,80,59,39,17,0,0,0,0,0,0,0,0,0,0,0,4,27,49,72,94,117,141,163,174,170,175,160,138,115,92,69,47,24,2,0,0,0,0,0,0,0,0,0,0,14,35,56,76,94,112,132,146,158,167,170,167,167,172,164,155,143,129,109,91,73,53,33,12,0,0,0,0,0,2,23,45,65,86,105,121,139,153,163,169,162,160,162,168,164,154,141,123,105,86,66,45,23,1,0,0,0,0,0,4,25,45,64,83,101,117,135,148,160,168,173,173,172,173,168,158,146,134,117,101,81,59,35,12,0,0,0,0,11,35,58,81,104,132,154,177,180,178,177,177,177,177,177,177,177,177,165,142,116,93,68,45,22,0,0,0,6,28,49,69,89,103,117,132,145,156,164,172,170,170,170,173,168,162,152,139,123,105,87,68,48,27,6,0,0,0,0,0,16,37,57,78,97,114,134,148,161,170,170,170,171,169,161,148,132,114,96,77,57,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,177,155,147,147,147,147,147,147,152,158,169,178,167,152,136,114,92,71,49,27,4,0,0,0,0,0,0,0,0,0,0,12,34,57,80,102,124,148,171,154,147,159,168,146,121,99,77,55,32,9,0,0,0,0,0,0,0,0,0,2,24,47,68,89,109,130,148,165,170,157,147,142,143,148,158,171,162,145,129,107,88,67,46,24,2,0,0,0,0,11,33,56,78,99,119,141,158,173,158,146,138,137,137,145,156,172,159,141,119,99,78,55,33,10,0,0,0,0,0,16,37,58,79,98,117,137,154,168,171,160,153,149,148,152,158,169,167,153,135,111,88,63,38,15,0,0,0,0,12,36,60,83,106,132,154,177,168,153,152,152,152,152,152,152,152,152,152,142,116,93,68,45,22,0,0,0,9,32,55,78,102,123,139,153,165,169,158,150,147,144,147,152,162,175,172,157,141,121,100,80,59,37,15,0,0,0,0,5,28,49,71,91,112,132,152,168,167,155,147,144,147,156,168,167,150,132,110,90,70,48,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,119,119,119,119,121,129,136,147,162,181,169,148,124,103,80,57,34,10,0,0,0,0,0,0,0,0,0,0,20,42,65,87,109,134,155,166,143,124,150,173,153,132,107,85,62,40,17,0,0,0,0,0,0,0,0,0,11,33,57,79,101,123,144,165,171,152,136,121,116,116,124,137,154,170,161,143,121,100,79,57,34,13,0,0,0,0,17,41,65,88,110,134,154,174,157,139,123,113,109,112,121,137,155,175,155,134,109,87,64,41,17,0,0,0,0,5,27,49,71,91,113,134,154,171,166,150,138,129,121,121,124,136,147,155,136,117,98,80,58,34,12,0,0,0,0,14,38,60,83,108,134,157,180,157,135,124,124,124,124,124,124,124,124,124,124,116,93,68,45,22,0,0,0,8,31,53,77,98,116,136,154,160,147,136,124,119,118,121,129,141,157,175,174,155,135,111,90,68,45,22,0,0,0,0,15,38,59,82,104,124,147,166,167,148,134,121,116,121,134,150,168,166,146,124,103,81,58,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,93,93,96,98,103,113,129,148,170,180,157,134,109,86,62,38,14,0,0,0,0,0,0,0,0,0,4,27,49,73,94,116,141,163,160,137,119,144,167,161,139,114,92,70,47,24,2,0,0,0,0,0,0,0,0,18,41,65,88,110,135,156,178,157,137,116,100,91,92,101,117,136,155,176,155,135,111,89,67,44,21,0,0,0,0,22,47,70,94,117,142,165,168,145,123,103,89,83,88,101,119,143,164,165,142,116,93,70,46,22,0,0,0,0,15,37,59,81,104,124,147,167,168,150,132,115,105,99,96,102,112,124,139,118,100,82,64,45,25,4,0,0,0,0,15,39,63,86,109,134,157,180,155,132,107,101,101,101,101,101,101,101,101,101,98,83,63,41,19,0,0,0,2,23,45,63,82,99,117,137,141,124,113,101,96,93,97,106,121,141,163,184,165,144,119,96,73,50,27,4,0,0,0,23,47,69,92,115,138,160,175,154,132,112,98,93,99,114,134,155,177,159,137,114,91,68,46,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,71,71,73,80,93,114,138,161,185,162,139,112,88,65,40,17,0,0,0,0,0,0,0,0,0,12,35,57,80,102,124,148,171,155,132,114,137,160,168,146,121,100,77,54,32,10,0,0,0,0,0,0,0,0,24,47,71,94,117,143,165,170,147,123,101,82,68,69,82,101,121,144,166,166,144,121,98,75,52,28,6,0,0,2,25,50,73,98,121,147,172,162,139,114,90,69,60,67,87,109,134,157,171,147,121,97,73,49,25,1,0,0,0,23,46,69,91,114,137,160,177,155,135,114,96,81,73,73,80,91,107,118,103,84,65,47,30,11,0,0,0,0,0,17,40,63,86,111,137,160,177,154,132,106,83,76,76,76,76,76,76,76,76,75,66,49,31,11,0,0,0,0,12,30,48,66,83,101,119,119,105,92,80,72,68,73,88,108,132,155,178,172,148,124,101,76,53,30,7,0,0,7,30,54,77,101,124,147,171,166,144,119,98,78,68,79,99,119,144,167,169,146,121,100,76,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,48,46,49,61,86,109,134,160,182,162,139,114,88,65,40,17,0,0,0,0,0,0,0,0,0,20,42,65,87,109,134,156,171,148,124,108,132,155,176,153,132,107,85,62,40,17,0,0,0,0,0,0,0,2,27,50,75,99,121,148,172,165,142,116,93,69,48,48,67,88,110,134,157,176,153,130,106,82,59,35,12,0,0,2,25,50,73,99,123,149,173,162,137,111,88,63,40,56,80,104,129,154,172,149,121,99,73,50,25,2,0,0,8,30,54,77,100,123,147,170,166,144,121,99,80,61,50,48,58,72,88,93,85,67,49,31,13,0,0,0,0,0,0,17,42,66,88,111,137,160,175,152,129,104,81,63,63,63,59,53,53,53,53,52,45,32,17,0,0,0,0,0,0,14,32,51,69,87,101,100,86,71,59,48,45,57,80,104,129,152,175,172,149,124,101,78,53,30,7,0,0,12,36,61,84,107,132,155,179,159,135,110,88,65,45,66,89,111,137,160,178,155,132,106,83,59,35,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,48,48,52,65,87,110,137,160,181,158,135,110,87,63,40,15,0,0,0,0,0,0,0,0,4,27,49,72,95,117,140,163,165,142,117,101,124,148,171,161,138,114,93,69,47,24,2,0,0,0,0,0,0,2,27,52,76,101,124,152,175,162,139,111,88,64,40,34,56,79,103,124,151,173,160,137,112,88,65,41,17,0,0,1,25,49,73,97,121,147,170,165,140,116,94,74,59,58,81,106,130,154,169,145,121,96,73,48,24,0,0,0,14,36,61,84,107,132,155,178,158,135,111,89,66,65,68,67,65,60,65,68,63,51,33,15,0,0,0,0,0,0,0,20,43,66,90,114,139,162,173,149,124,101,86,88,88,86,82,77,69,59,48,35,22,11,0,0,0,0,0,0,0,0,17,35,53,68,77,77,67,52,45,47,53,64,84,106,130,154,177,170,147,121,99,76,53,29,5,0,0,17,41,65,88,113,139,162,176,153,129,104,81,57,34,57,81,105,130,154,178,160,137,111,88,64,40,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,71,73,76,83,98,118,142,164,170,149,129,104,81,58,34,11,0,0,0,0,0,0,0,0,12,35,57,80,102,124,148,171,158,136,111,95,117,142,164,168,146,121,100,77,55,33,9,0,0,0,0,0,0,2,27,50,76,101,124,152,175,162,139,111,88,64,40,29,49,73,97,121,147,170,165,142,116,93,69,45,22,0,0,0,21,45,69,93,116,139,163,172,149,129,109,93,81,70,90,113,136,160,161,138,114,91,68,45,20,0,0,0,18,42,66,90,114,138,161,174,152,124,103,80,85,90,91,91,89,84,77,69,57,44,29,12,0,0,0,0,0,0,0,21,45,68,91,114,139,163,172,147,121,105,110,111,111,109,106,100,91,81,69,54,38,22,4,0,0,0,0,0,0,0,1,19,34,46,52,52,64,68,70,72,77,85,98,116,138,160,180,161,139,116,93,72,48,25,2,0,0,21,45,69,93,116,143,166,172,149,123,99,75,51,28,52,77,100,124,149,173,165,142,116,92,68,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,96,96,98,101,106,117,134,153,171,155,137,115,95,72,50,28,4,0,0,0,0,0,0,0,0,20,42,65,87,109,134,155,174,152,129,105,88,110,135,157,176,153,132,107,85,62,40,17,0,0,0,0,0,0,2,27,50,75,99,121,149,172,165,142,116,93,70,51,51,62,78,98,116,144,167,170,147,119,96,72,48,24,0,0,0,16,39,62,85,107,129,150,169,163,144,129,114,101,91,103,124,146,168,149,129,105,83,60,38,14,0,0,0,22,46,70,93,117,143,167,170,147,121,98,98,107,114,116,116,114,108,100,90,78,63,46,29,11,0,0,0,0,0,0,22,45,69,93,116,142,165,170,147,121,129,136,139,138,137,132,121,113,101,88,73,56,38,20,0,0,0,0,0,0,0,0,0,14,28,49,70,86,93,93,96,100,107,117,134,150,170,164,147,129,106,85,64,42,19,0,0,0,24,48,73,96,119,147,170,170,147,119,96,72,47,24,48,73,96,121,147,170,169,145,119,96,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,121,121,121,121,124,132,139,152,160,150,137,119,101,82,61,40,18,0,0,0,0,0,0,0,0,4,27,50,72,94,117,141,163,168,145,121,98,81,104,129,151,173,160,139,115,92,69,47,24,2,0,0,0,0,0,0,24,47,72,96,119,144,167,170,147,124,103,84,75,75,83,96,113,132,152,172,172,149,121,99,73,50,25,0,0,0,8,31,53,74,95,114,136,152,169,162,148,137,124,114,117,138,158,154,136,114,93,72,50,29,6,0,0,0,25,48,73,96,121,147,170,167,143,116,107,121,132,139,144,142,139,134,123,112,98,82,64,45,26,5,0,0,0,0,0,24,48,71,93,116,144,167,173,154,144,152,159,162,162,160,154,146,136,121,107,89,72,53,33,13,0,0,0,0,0,0,0,0,12,34,57,80,104,116,118,119,124,132,140,152,168,158,146,130,112,93,74,54,32,11,0,0,1,25,50,73,99,121,149,172,167,144,116,93,69,45,22,45,71,93,119,144,170,172,147,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,177,155,147,147,147,147,149,150,155,162,150,137,129,116,101,85,67,48,31,15,0,0,0,0,0,0,0,0,12,34,57,80,102,124,148,171,161,139,114,92,75,97,119,144,166,168,146,121,99,77,55,32,9,0,0,0,0,0,0,20,43,67,90,113,137,160,179,158,137,119,106,99,99,106,117,132,150,167,182,173,149,121,99,73,50,25,0,0,0,0,20,41,61,80,98,116,134,149,166,170,158,148,139,136,154,150,136,117,98,80,60,39,18,0,0,0,2,27,50,76,99,124,149,173,165,141,114,129,143,155,163,167,167,163,157,147,134,116,98,79,59,38,16,0,0,0,0,2,25,49,73,96,119,144,167,173,164,156,152,152,152,157,165,177,169,156,141,123,105,86,66,45,24,3,0,0,0,0,0,0,0,12,35,58,81,106,132,144,147,150,155,163,163,147,137,124,110,94,78,60,41,21,0,0,0,2,26,50,76,99,124,149,175,167,142,116,91,68,43,20,44,68,93,116,144,167,173,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,188,172,167,167,167,167,167,167,170,173,149,134,129,119,109,98,83,67,49,30,10,0,0,0,0,0,0,0,20,42,65,87,109,134,155,177,154,132,108,85,68,90,114,137,160,176,153,132,107,85,62,40,17,0,0,0,0,0,0,13,36,59,81,104,124,148,167,172,155,140,132,124,124,130,140,152,145,146,168,175,149,121,99,73,50,25,0,0,0,0,18,37,55,71,87,101,114,134,157,165,168,171,162,160,160,137,115,101,88,72,55,37,19,0,0,0,2,27,51,76,101,124,152,175,162,139,130,148,160,151,147,147,152,161,172,167,152,134,114,92,71,49,27,5,0,0,0,2,25,50,73,96,119,138,150,153,143,134,129,124,129,135,145,157,173,175,158,139,118,98,77,56,33,12,0,0,0,0,0,0,0,12,35,58,81,106,132,154,172,174,178,180,157,132,121,112,101,88,74,58,40,22,4,0,0,2,27,50,76,99,124,152,175,167,142,116,91,68,43,20,43,68,91,116,144,167,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,175,152,142,142,142,142,142,144,146,150,157,157,152,144,132,116,101,83,64,44,22,0,0,0,0,0,0,4,27,49,73,95,116,141,163,170,147,124,101,78,78,83,106,132,152,176,161,139,114,92,70,47,24,2,0,0,0,0,0,5,27,49,71,92,113,134,152,165,174,162,154,149,149,153,161,144,129,139,165,172,149,121,99,73,50,25,0,0,0,13,33,53,71,89,105,121,137,148,152,139,146,155,164,175,167,150,137,121,107,91,72,53,33,12,0,0,5,27,53,76,101,124,152,175,167,148,148,149,137,129,121,121,129,139,154,172,168,148,124,104,81,59,35,12,0,0,0,0,22,46,67,88,103,116,130,132,118,109,103,101,103,110,123,139,157,177,172,153,132,108,86,64,41,19,0,0,0,0,0,0,0,12,35,58,81,106,132,147,149,152,155,160,166,153,145,136,121,107,91,74,56,37,17,0,0,2,27,50,76,99,124,152,175,167,142,116,91,68,43,20,43,68,91,116,144,167,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,116,116,116,116,116,119,124,135,146,161,165,152,137,117,98,76,55,33,11,0,0,0,0,0,12,35,57,80,102,124,148,171,163,140,116,104,104,104,104,104,121,146,169,168,146,121,100,77,54,32,10,0,0,0,0,0,0,16,38,59,79,98,116,132,145,154,160,163,165,160,152,140,124,116,142,165,171,147,121,97,73,49,25,0,0,3,24,47,67,87,105,123,143,156,150,134,116,121,132,143,153,165,171,157,143,124,107,87,67,46,24,2,0,4,27,53,76,101,124,152,175,182,164,146,130,114,103,96,97,105,117,137,158,180,159,137,112,90,66,42,19,0,0,0,0,14,36,55,70,83,96,108,109,98,87,80,78,81,89,104,121,145,165,184,162,139,116,93,70,47,24,0,0,0,0,0,0,0,12,35,57,80,105,119,121,121,124,132,137,146,158,167,156,143,124,109,90,71,49,28,7,0,2,25,50,76,99,124,149,174,167,144,116,91,68,43,20,45,68,93,116,144,167,172,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,91,91,91,92,96,101,110,124,144,163,171,152,132,109,87,64,41,17,0,0,0,0,0,20,42,65,88,109,134,156,178,160,137,129,129,129,129,129,129,129,143,167,176,154,132,107,85,62,40,17,0,0,0,0,0,0,5,25,45,63,80,96,109,121,130,137,139,139,137,129,117,105,118,144,167,168,144,119,95,71,47,22,0,0,13,36,57,79,101,121,141,161,155,136,115,98,98,108,118,132,144,160,177,161,143,121,100,78,56,34,12,0,2,27,50,76,100,124,149,174,171,150,130,110,94,81,72,73,83,103,124,148,171,167,144,119,95,71,47,24,0,0,0,0,2,21,36,50,62,75,86,87,76,65,56,53,57,71,90,111,135,157,180,168,145,121,98,75,51,27,0,0,0,0,0,0,6,15,29,50,70,88,93,96,97,101,106,112,123,138,155,174,161,143,123,103,82,60,38,16,0,0,25,48,73,97,121,147,172,167,144,119,93,70,45,22,46,71,93,119,144,170,171,147,121,96,73,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,66,68,68,72,79,91,109,132,154,176,164,142,116,93,70,47,23,0,0,0,0,4,28,49,72,95,117,141,163,186,170,156,154,154,154,154,154,154,154,158,176,184,161,138,115,93,69,47,25,2,0,0,0,0,0,0,10,29,46,62,76,88,98,105,110,111,114,110,104,95,99,121,147,172,164,141,115,91,68,44,20,0,0,20,44,67,90,112,135,155,165,144,119,99,81,76,86,96,109,124,143,161,176,155,134,110,88,65,41,18,0,1,25,50,73,98,121,147,172,167,142,116,95,76,60,48,49,70,93,116,143,166,172,147,121,99,73,50,25,0,0,0,0,0,15,31,42,47,55,62,63,56,44,33,29,37,59,82,105,132,154,177,172,149,121,99,76,53,27,0,0,0,0,0,13,28,39,42,44,54,66,71,71,73,76,81,90,103,119,141,163,177,157,136,113,91,67,45,22,0,0,22,47,71,96,119,144,169,170,147,121,96,73,48,25,49,73,97,121,147,171,167,144,119,93,71,46,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,48,43,44,48,57,77,99,121,149,172,171,147,121,98,73,50,25,0,0,0,0,12,35,57,80,102,124,148,171,178,170,170,170,170,170,170,170,170,170,170,172,182,168,146,121,100,77,55,33,9,0,0,0,0,0,0,0,12,28,42,55,66,75,81,86,88,88,86,81,82,106,129,153,176,159,136,111,87,64,40,16,0,1,26,49,73,97,119,145,167,159,137,110,88,66,54,64,76,90,107,129,149,172,166,143,118,94,71,47,24,0,0,23,47,71,94,119,144,167,170,146,119,96,73,49,26,43,66,91,114,142,165,175,149,121,99,73,50,25,0,0,0,0,14,32,49,63,70,69,59,45,33,23,11,10,33,57,80,104,129,152,175,172,149,121,99,76,53,27,0,0,0,0,11,29,46,61,68,67,58,44,45,47,49,52,58,69,88,109,134,157,180,165,143,119,96,73,50,26,0,0,20,44,68,92,116,142,165,173,149,124,101,77,53,30,53,78,101,124,150,175,164,140,115,91,68,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,48,25,24,29,50,73,98,121,147,172,172,149,121,99,73,50,25,0,0,0,0,20,42,65,87,110,134,155,179,160,145,144,144,144,144,144,144,144,144,144,148,166,176,153,132,107,85,62,40,17,0,0,0,0,0,0,0,18,37,53,66,71,67,57,61,63,63,62,69,90,113,137,160,175,152,129,105,81,58,34,11,0,4,28,52,76,101,124,151,175,157,132,106,83,58,35,42,55,73,94,116,143,167,172,148,121,99,73,50,25,0,0,19,42,67,90,114,139,162,173,150,124,102,78,56,33,43,66,91,114,142,165,174,149,121,99,73,50,25,0,0,0,8,27,47,66,83,95,92,78,63,50,37,30,30,40,61,83,106,132,154,177,170,147,121,99,76,53,27,0,0,0,7,25,45,63,82,93,91,78,62,48,35,27,28,36,59,82,106,132,154,177,170,147,121,99,75,50,27,0,0,16,40,64,88,111,137,160,178,154,132,106,82,58,36,59,83,106,132,155,178,159,137,111,86,63,39,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,48,45,48,53,62,80,102,124,150,173,172,147,121,99,73,50,25,0,0,0,4,27,50,73,94,117,141,163,174,152,129,116,116,116,116,116,116,116,116,116,136,158,180,160,139,115,92,69,48,24,2,0,0,0,0,0,17,35,53,71,88,96,88,73,58,51,53,64,82,101,123,146,168,166,144,119,98,74,51,28,4,0,5,30,53,78,101,129,152,175,157,134,107,85,62,44,38,45,68,92,116,142,165,174,149,121,99,73,50,25,0,0,14,37,61,85,108,132,155,178,156,134,110,88,67,48,51,72,95,118,144,167,170,147,121,97,73,49,25,0,0,3,22,42,61,80,99,117,112,96,83,70,59,54,53,59,73,92,113,137,159,181,165,143,119,96,73,50,27,0,0,2,21,40,59,78,97,116,112,96,82,69,57,52,50,54,65,85,108,132,155,178,170,147,121,99,75,50,27,0,0,11,35,59,81,106,130,153,177,160,137,113,90,67,47,68,91,114,138,161,176,152,129,105,81,58,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,73,71,71,72,76,83,96,114,136,157,180,167,144,119,96,72,48,24,0,0,0,12,35,57,80,102,124,148,171,167,144,121,98,93,93,93,93,93,93,93,104,129,151,173,168,146,121,100,77,55,32,10,0,0,0,0,15,33,51,69,87,105,121,107,92,81,76,77,84,98,116,137,156,178,156,135,111,89,66,44,20,0,0,4,27,52,76,99,124,149,172,162,139,115,95,78,67,63,66,78,99,121,145,168,170,147,121,98,73,50,25,0,0,8,31,54,77,100,121,146,168,165,143,121,100,82,71,71,85,105,129,150,172,163,141,116,93,70,46,22,0,0,16,36,56,75,94,113,134,132,116,103,91,83,78,78,82,92,107,124,146,167,179,158,136,113,91,68,45,22,0,0,16,36,55,74,92,112,132,132,115,103,90,81,76,75,78,86,99,117,140,161,184,165,143,119,96,73,49,26,0,0,5,28,52,75,98,121,145,168,168,146,121,100,80,71,82,101,123,146,169,167,144,121,98,74,51,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,96,96,96,96,96,101,107,116,132,148,169,178,157,136,112,90,66,43,19,0,0,0,20,42,65,87,109,134,156,178,160,138,114,91,69,68,68,68,68,68,75,98,121,144,167,176,153,132,107,85,62,40,17,0,0,0,7,28,49,67,85,103,121,141,124,113,104,99,101,107,117,134,152,170,165,145,121,101,79,57,34,12,0,0,0,24,48,72,94,117,141,163,171,150,130,112,98,90,86,90,98,113,134,154,176,162,139,115,92,69,45,22,0,0,0,23,46,68,90,113,136,156,176,155,136,116,103,93,93,104,119,139,160,175,154,132,109,86,63,40,17,0,3,26,48,69,89,108,129,147,150,137,123,113,106,101,101,106,113,124,143,160,178,167,147,124,104,82,60,38,16,0,3,25,48,69,89,107,129,146,150,137,123,112,104,100,99,101,108,118,136,152,172,177,156,135,112,90,67,45,22,0,0,0,21,44,67,90,112,136,157,178,156,136,116,101,96,101,116,136,157,177,156,135,112,89,66,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,172,147,121,119,119,119,119,121,124,132,139,150,166,179,162,144,123,101,80,58,36,13,0,0,5,27,49,73,95,116,141,163,176,154,132,107,85,62,43,43,43,43,46,68,91,114,137,160,183,161,139,114,93,70,47,24,2,0,0,15,37,61,82,101,119,139,157,148,137,129,124,124,132,140,153,168,168,150,132,109,89,68,46,24,2,0,0,0,18,41,64,86,108,130,150,170,165,148,134,121,114,111,114,121,134,150,167,169,149,129,106,84,62,39,16,0,0,0,14,36,58,80,101,121,143,162,170,154,138,124,119,119,124,139,155,174,162,143,121,99,76,55,32,9,0,7,30,53,76,101,121,143,161,170,158,146,137,132,129,129,132,137,147,161,177,171,154,135,114,93,72,51,29,8,0,7,30,53,78,101,121,143,161,170,158,146,137,129,124,124,124,132,141,154,170,179,162,144,123,101,81,59,37,15,0,0,0,12,35,57,80,101,121,144,164,170,152,136,123,119,124,136,152,170,163,144,121,100,79,56,34,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,177,155,147,147,147,147,147,147,150,154,162,172,172,160,145,129,109,90,69,48,26,4,0,0,12,35,57,80,102,124,148,171,170,147,123,101,77,55,33,20,20,20,39,61,84,107,132,153,176,168,146,121,100,77,54,33,10,0,0,17,40,66,88,114,137,152,166,169,160,153,152,152,155,163,174,165,150,134,114,95,76,56,34,14,0,0,0,0,9,32,54,75,95,115,136,152,166,167,155,145,139,139,139,145,155,168,166,152,134,114,94,73,51,30,8,0,0,0,4,25,47,67,88,107,129,146,161,172,158,150,144,144,150,160,173,162,146,129,107,87,66,45,22,0,0,6,28,51,73,95,112,130,144,157,169,167,160,154,152,152,154,160,169,179,167,153,137,118,99,81,61,40,19,0,0,6,28,51,73,95,112,130,145,158,171,168,160,154,152,150,152,156,164,174,173,161,146,129,109,90,70,49,28,6,0,0,0,3,25,47,68,89,109,130,148,165,170,157,149,147,150,158,170,164,148,129,109,88,67,46,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,175,175,175,172,172,172,172,172,172,172,170,165,160,150,139,124,109,92,74,56,36,15,0,0,0,20,42,65,88,109,134,156,175,163,140,116,93,71,48,25,3,0,9,32,54,77,101,121,147,170,175,154,132,107,85,62,40,17,0,0,14,37,60,82,99,116,132,146,157,166,172,175,175,171,165,156,145,132,114,98,80,61,42,22,1,0,0,0,0,0,21,42,62,81,99,116,132,146,156,164,169,165,162,165,168,164,156,146,132,116,98,80,60,40,19,0,0,0,0,0,13,34,54,74,92,109,124,141,154,163,170,170,170,171,164,155,143,129,110,92,73,53,33,11,0,0,0,22,42,62,78,94,109,123,137,148,157,164,169,172,173,173,170,164,156,146,134,117,101,85,67,48,28,8,0,0,0,21,42,61,78,94,110,123,138,149,158,165,170,173,175,173,172,167,160,152,140,124,110,92,76,57,37,16,0,0,0,0,0,14,34,55,75,94,112,130,146,158,167,173,172,173,167,158,145,130,112,94,74,55,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,149,149,149,149,149,149,149,149,149,149,149,146,142,137,129,116,105,91,74,58,40,22,2,0,0,3,26,50,72,95,117,141,149,149,149,134,109,87,64,41,19,0,0,2,25,48,70,93,116,139,149,149,149,138,115,93,69,47,24,0,0,6,28,49,65,82,98,110,123,135,142,147,149,149,147,142,134,121,110,96,80,64,46,27,7,0,0,0,0,0,0,7,28,47,64,82,98,110,121,134,141,147,149,149,149,147,141,134,123,110,97,82,64,45,26,6,0,0,0,0,0,0,20,40,57,74,91,107,119,132,141,147,149,149,147,141,132,119,107,92,74,58,39,19,0,0,0,0,10,28,45,61,76,90,103,114,124,135,141,145,149,149,149,147,141,135,123,112,99,84,67,51,33,15,0,0,0,0,10,28,44,61,76,90,104,115,124,136,142,147,149,149,149,147,143,137,129,117,105,92,76,60,42,23,4,0,0,0,0,0,1,21,41,60,78,94,110,123,136,144,149,149,149,144,136,123,109,94,76,59,40,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,103,121,121,121,121,121,121,121,121,121,121,121,121,119,116,111,104,95,83,71,56,40,24,6,0,0,0,4,27,50,75,98,119,121,121,121,121,121,103,80,57,35,12,0,0,0,19,41,64,87,108,121,121,121,121,121,117,96,73,48,25,0,0,0,13,31,47,63,76,89,100,110,116,121,121,121,121,116,109,100,89,76,62,46,28,11,0,0,0,0,0,0,0,0,12,30,47,63,77,89,100,109,116,119,121,121,121,119,116,109,100,89,77,63,46,30,11,0,0,0,0,0,0,0,4,22,40,56,72,86,98,108,115,121,121,121,121,116,108,98,87,72,57,40,22,5,0,0,0,0,0,12,28,42,56,69,81,92,102,110,116,119,121,121,121,121,116,110,101,91,79,65,51,35,17,0,0,0,0,0,0,10,26,42,57,70,82,93,103,111,116,119,121,121,121,121,116,112,105,95,84,72,57,42,26,8,0,0,0,0,0,0,0,6,24,42,60,76,90,101,112,119,121,121,121,118,111,101,89,75,58,42,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,26,50,71,90,99,99,99,99,99,99,99,99,99,99,99,98,96,92,88,81,72,62,50,37,22,6,0,0,0,0,1,24,48,69,87,98,99,99,99,99,99,89,71,50,28,5,0,0,0,12,34,56,77,93,99,99,99,99,99,98,85,66,45,21,0,0,0,0,13,28,43,56,67,78,87,93,96,99,99,96,93,85,77,66,55,42,27,11,0,0,0,0,0,0,0,0,0,0,12,28,43,56,67,77,85,91,96,99,99,99,96,91,85,77,67,56,43,28,12,0,0,0,0,0,0,0,0,0,4,22,38,52,64,75,85,91,96,99,99,96,92,85,76,65,52,38,22,6,0,0,0,0,0,0,0,9,23,36,49,61,71,80,87,93,96,99,99,99,96,93,87,79,70,58,45,32,17,1,0,0,0,0,0,0,0,8,23,36,49,61,71,80,86,93,96,98,99,99,96,93,88,81,73,63,51,38,23,8,0,0,0,0,0,0,0,0,0,8,26,41,56,69,79,88,93,98,99,98,93,88,79,68,55,40,24,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,38,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,68,64,57,49,40,29,17,3,0,0,0,0,0,0,14,36,53,66,73,73,73,73,73,73,67,55,38,17,0,0,0,0,3,23,42,59,70,73,73,73,73,73,73,65,51,31,12,0,0,0,0,0,9,22,34,46,56,63,69,73,73,73,73,69,62,54,45,33,21,7,0,0,0,0,0,0,0,0,0,0,0,0,9,22,34,45,54,62,68,71,73,73,73,71,68,62,54,45,34,22,9,0,0,0,0,0,0,0,0,0,0,0,4,18,31,42,53,61,68,72,73,73,73,69,62,54,44,32,19,4,0,0,0,0,0,0,0,0,0,3,16,28,39,49,57,64,69,73,73,73,73,73,70,64,57,48,37,26,12,0,0,0,0,0,0,0,0,0,0,2,16,28,39,48,57,63,68,71,73,73,73,72,69,64,58,50,40,30,17,4,0,0,0,0,0,0,0,0,0,0,0,7,21,35,47,57,65,70,73,73,73,70,65,57,46,34,21,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,20,34,45,48,48,48,48,48,48,48,48,48,48,48,48,48,44,40,34,27,17,7,0,0,0,0,0,0,0,0,0,17,33,43,48,48,48,48,48,48,45,34,20,4,0,0,0,0,0,8,24,38,46,48,48,48,48,48,47,42,31,15,0,0,0,0,0,0,0,1,13,24,33,40,45,48,48,48,48,44,39,32,23,12,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,23,31,38,43,47,48,48,48,47,43,38,31,23,13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,21,30,38,44,48,48,48,48,44,39,31,21,11,0,0,0,0,0,0,0,0,0,0,0,0,0,6,17,26,34,40,45,48,50,50,50,49,45,40,33,25,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,25,33,39,44,47,48,48,48,48,45,40,35,27,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,24,34,41,46,48,48,48,46,41,33,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,22,25,25,25,25,25,25,25,25,25,25,25,25,22,19,15,10,4,0,0,0,0,0,0,0,0,0,0,0,1,13,21,25,25,25,25,25,25,22,14,2,0,0,0,0,0,0,0,5,17,23,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,8,16,20,22,25,25,22,19,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,19,22,25,25,25,22,19,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,22,25,25,23,20,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,17,21,24,25,25,25,25,22,17,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,15,19,22,24,25,25,22,20,16,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,17,21,24,25,24,21,17,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,25,27,27,27,27,27,24,15,3,0,0,0,0,0,0,0,0,0,0,5,17,27,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,26,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,28,30,30,30,30,30,30,29,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,17,22,24,27,26,23,20,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,24,29,30,30,30,30,29,23,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,23,25,25,25,24,18,8,18,24,25,25,25,23,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,20,25,27,29,30,27,25,20,14,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,17,23,27,29,30,28,26,22,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,15,15,15,15,15,12,5,13,20,24,27,27,26,22,16,6,0,0,0,0,0,0,0,0,0,0,6,24,38,47,50,50,50,50,50,46,35,21,4,0,0,0,0,0,0,0,0,3,22,37,49,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,48,36,21,1,0,0,0,0,0,0,0,0,0,0,0,0,0,11,29,42,51,53,53,53,53,53,53,52,45,31,15,0,0,0,0,0,0,0,0,0,0,0,6,16,27,35,42,46,49,52,51,48,45,39,32,22,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,8,15,24,34,45,52,53,53,53,53,51,44,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,40,48,50,50,50,49,41,29,41,49,50,50,50,48,40,26,9,0,0,0,0,0,0,0,0,0,0,4,16,27,36,43,48,51,53,53,52,49,44,37,28,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,12,22,32,40,46,50,53,53,53,50,45,38,30,21,9,0,0,0,0,0,0,0,0,0,0,16,29,37,40,40,40,40,40,36,28,35,43,49,50,50,50,45,38,27,13,0,0,0,0,0,0,0,0,0,20,40,58,71,76,76,76,76,76,70,55,37,17,0,0,0,0,0,0,0,0,16,38,56,72,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,71,55,36,14,0,0,0,0,0,0,0,0,0,0,0,0,6,26,47,63,75,78,78,78,78,78,78,77,67,49,30,9,0,0,0,0,0,0,0,0,0,14,27,39,50,59,66,71,73,78,76,73,69,63,55,45,33,19,4,0,0,0,0,0,0,0,0,0,1,13,21,27,32,38,47,56,67,77,78,78,78,78,76,65,49,30,9,0,0,0,0,0,0,0,0,0,0,0,0,3,24,44,61,73,76,76,76,73,63,47,63,73,76,76,76,73,60,44,24,3,0,0,0,0,0,0,0,0,9,24,37,48,58,66,71,75,76,76,75,72,67,59,49,39,28,16,2,0,0,0,0,0,0,0,0,0,7,20,33,44,54,62,69,73,76,76,76,73,67,60,51,41,30,17,4,0,0,0,0,0,0,0,13,33,48,59,63,63,63,63,63,58,47,57,66,73,76,76,73,69,61,46,29,10,0,0,0,0,0,0,0,7,29,52,74,92,101,101,101,101,101,89,70,49,26,2,0,0,0,0,0,0,2,25,49,71,92,103,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,103,90,68,47,22,0,0,0,0,0,0,0,0,0,0,0,0,19,40,59,80,98,104,104,104,104,104,104,100,84,61,40,17,0,0,0,0,0,0,0,4,19,34,48,62,73,83,90,96,99,102,101,99,93,87,78,67,54,40,22,6,0,0,0,0,0,0,0,4,21,35,45,51,56,62,69,78,88,100,104,104,104,104,99,82,61,40,17,0,0,0,0,0,0,0,0,0,0,0,0,11,34,57,79,95,101,101,101,97,81,60,81,97,101,101,101,95,77,57,33,11,0,0,0,0,0,0,0,10,26,43,57,70,80,89,94,99,101,101,99,96,90,81,71,61,49,36,22,6,0,0,0,0,0,0,0,10,26,40,53,65,75,85,92,97,101,101,99,96,91,83,73,63,51,37,22,6,0,0,0,0,0,4,25,48,67,82,88,88,88,88,88,81,67,79,89,96,99,99,98,91,80,62,42,20,0,0,0,0,0,0,0,11,35,58,81,105,129,129,129,129,124,101,76,53,30,5,0,0,0,0,0,0,5,27,53,76,101,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,13,33,53,73,92,113,129,129,129,129,129,129,114,91,66,43,20,0,0,0,0,0,0,4,22,38,54,69,83,96,106,114,121,124,129,124,123,118,110,100,89,74,58,40,23,4,0,0,0,0,0,0,18,38,55,69,75,80,86,93,101,109,121,129,129,129,129,111,88,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,15,40,63,87,111,129,129,129,114,88,66,90,114,129,129,129,109,86,63,38,15,0,0,0,0,0,0,6,26,43,60,76,90,101,111,117,121,124,124,121,118,112,103,92,81,69,55,38,21,0,0,0,0,0,0,10,26,43,59,73,86,97,107,114,119,124,124,123,119,113,105,95,83,70,56,40,22,6,0,0,0,0,9,31,56,78,99,111,111,111,111,111,97,87,100,112,119,124,124,121,114,96,72,49,27,0,0,0,0,0,0,0,14,37,60,84,107,134,154,154,149,124,101,76,53,30,15,13,7,0,0,0,0,5,27,53,76,101,124,152,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,6,26,46,66,86,106,129,147,154,154,154,154,139,114,91,66,43,20,0,0,0,0,0,3,22,40,56,74,89,104,117,130,140,147,152,152,152,149,144,136,123,109,94,76,58,38,18,0,0,0,0,0,6,28,50,71,89,100,104,109,116,124,134,144,154,154,154,137,111,88,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,19,43,66,91,114,139,154,137,111,88,69,93,116,142,154,134,109,84,60,37,12,0,0,0,0,0,0,19,39,59,76,94,109,123,134,142,147,149,149,147,142,136,124,113,101,88,73,54,32,9,0,0,0,0,6,25,43,60,76,92,106,117,130,138,144,149,149,147,144,137,129,116,103,89,73,56,38,21,2,0,0,0,10,33,58,81,104,129,139,139,139,129,104,106,121,135,144,149,150,144,119,98,73,50,27,0,0,0,0,0,9,22,31,40,63,86,109,136,160,175,149,124,101,76,53,40,40,38,30,18,1,0,0,5,27,53,76,101,124,152,175,175,175,175,175,175,175,175,175,175,175,176,180,180,172,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,19,39,59,79,99,119,140,161,180,180,180,165,139,114,91,66,43,20,0,0,0,0,0,16,38,58,74,92,109,124,140,153,163,171,170,170,170,174,168,158,145,130,110,92,74,52,31,9,0,0,0,0,10,32,55,78,101,121,129,134,140,147,156,165,176,180,160,137,111,88,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,22,45,69,93,116,142,157,134,109,85,73,96,119,145,154,132,106,81,58,34,10,0,0,0,0,0,9,30,51,72,92,110,130,144,156,165,170,170,170,171,166,157,147,136,121,107,86,62,39,14,0,0,0,0,19,39,58,76,94,110,124,140,152,161,168,172,175,172,167,159,149,137,123,107,91,73,54,35,15,0,0,0,10,33,58,81,104,129,154,162,154,132,106,123,141,155,166,173,163,139,115,93,69,46,23,0,0,0,0,8,28,43,55,60,66])
.concat([89,112,138,162,175,149,124,101,76,66,66,66,62,52,35,17,0,0,5,27,53,76,101,124,149,149,149,149,149,149,149,149,149,149,149,149,154,170,179,160,141,121,98,73,50,25,0,0,0,0,0,0,0,0,0,12,32,52,72,92,113,134,154,169,162,169,184,165,139,114,91,66,43,20,0,0,0,0,0,25,48,72,92,110,129,144,161,170,158,149,144,144,146,153,164,179,165,148,129,107,86,64,41,19,0,0,0,0,10,33,55,78,101,124,149,158,164,171,177,180,192,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,0,0,2,15,22,25,49,73,96,119,145,155,132,106,81,76,99,123,149,152,124,101,78,55,31,12,0,0,0,0,0,16,39,62,83,105,124,146,162,175,160,151,147,147,148,155,164,167,148,130,109,87,63,40,14,0,0,0,11,31,52,72,91,110,129,144,159,172,169,160,154,152,154,161,171,170,157,141,123,106,87,68,48,27,6,0,0,10,33,58,81,104,129,154,177,157,134,121,141,159,166,160,160,159,135,111,88,65,41,18,0,0,0,0,21,41,60,76,85,86,91,114,140,165,175,149,124,101,88,88,88,88,84,69,50,30,6,0,4,27,53,76,101,123,124,124,124,124,124,124,124,124,124,124,124,124,139,162,164,145,124,105,87,66,44,21,0,0,0,0,0,0,0,0,6,26,45,66,86,106,124,147,167,150,137,152,173,165,139,114,91,66,43,20,0,0,0,0,2,27,50,76,101,124,144,161,165,150,136,124,117,116,119,130,144,161,181,163,143,119,97,74,51,28,4,0,0,0,10,33,55,78,101,124,149,152,152,152,152,158,174,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,0,6,22,38,47,50,52,76,99,121,149,152,129,103,78,78,103,129,152,149,121,99,76,52,45,33,19,0,0,0,0,23,46,69,92,114,139,159,179,159,141,129,121,121,124,134,143,154,135,114,95,76,55,34,11,0,0,0,21,42,64,84,105,124,144,162,179,162,148,137,132,129,132,139,152,166,175,159,141,119,100,80,59,38,16,0,0,10,33,58,81,104,129,154,177,158,135,135,155,155,144,137,134,137,132,106,83,60,37,14,0,0,0,3,28,51,73,95,109,111,114,116,143,167,175,149,124,114,114,114,114,114,105,81,59,37,11,0,1,24,48,69,89,98,99,99,99,99,99,99,99,99,99,99,109,130,150,170,150,130,110,90,72,53,33,12,0,0,0,0,0,0,0,0,19,39,59,79,99,118,140,160,161,140,124,149,172,165,139,114,91,66,43,20,0,0,0,0,0,24,46,70,89,107,124,143,146,130,114,101,93,91,96,108,124,146,168,175,153,130,106,82,58,35,10,0,0,0,10,32,55,78,101,123,129,129,129,129,129,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,0,20,39,58,71,76,76,78,102,129,152,149,124,100,76,82,106,132,155,146,119,96,76,75,69,53,35,13,0,0,2,27,50,73,98,121,146,168,170,147,124,106,98,96,101,109,119,135,119,99,81,62,43,24,2,0,0,8,30,52,74,96,116,139,158,178,165,146,130,114,106,104,107,117,134,150,169,173,154,135,112,91,70,47,25,4,0,10,33,58,81,104,129,154,177,167,152,152,150,136,121,112,109,111,116,100,78,55,32,9,0,0,0,5,30,53,76,101,124,137,139,142,150,171,177,155,142,142,142,142,142,134,109,83,60,38,12,0,0,14,36,53,67,73,73,73,73,73,73,73,73,73,82,103,123,144,164,157,137,115,95,76,56,38,18,0,0,0,0,0,0,0,0,12,32,52,72,92,112,134,154,171,149,129,124,152,175,165,139,114,91,66,43,20,0,0,0,0,0,14,35,55,71,89,107,123,129,110,94,79,69,66,73,91,112,136,159,182,160,137,111,88,63,39,14,0,0,0,6,28,50,71,89,101,101,101,101,101,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,4,29,51,73,92,101,101,101,106,132,154,147,119,101,101,101,109,134,159,142,116,101,101,101,87,67,46,22,0,0,4,27,52,76,99,124,149,172,167,144,116,93,75,73,79,89,100,113,105,86,67,48,28,10,0,0,0,16,38,60,83,105,129,150,171,174,153,132,112,95,83,80,85,98,116,137,157,179,166,145,121,100,78,56,33,11,0,10,33,58,81,104,129,154,177,183,173,153,134,116,100,89,83,88,91,83,67,47,25,4,0,0,0,5,30,53,76,101,124,149,165,165,171,186,190,174,167,167,167,167,157,134,109,83,60,38,12,0,0,2,19,35,45,50,50,50,50,50,50,50,53,74,95,115,137,158,164,144,121,101,81,62,42,22,3,0,0,0,0,0,0,0,5,25,45,65,86,105,124,146,167,159,138,116,129,152,175,165,139,114,91,66,43,20,0,0,0,0,0,0,19,37,55,71,89,106,108,92,74,59,45,42,57,80,103,129,154,177,165,141,114,91,66,40,17,0,0,0,0,20,39,56,70,76,76,76,76,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,7,33,55,81,104,129,129,129,129,135,157,144,129,129,129,129,129,138,162,142,129,129,129,121,98,73,50,25,0,0,4,27,51,76,99,123,149,172,170,147,124,107,96,86,78,70,81,88,84,71,52,33,14,0,0,0,0,21,44,67,90,113,137,160,181,165,143,119,99,79,62,56,65,83,103,124,147,170,176,155,132,109,86,62,40,17,0,10,33,58,81,104,129,154,177,182,161,140,118,99,82,67,60,64,66,61,49,33,14,0,0,0,0,5,30,53,76,101,124,149,157,157,166,184,184,165,157,157,157,157,157,134,109,83,60,38,12,0,0,0,0,13,21,25,25,25,25,25,25,42,64,86,107,129,149,170,153,132,109,88,68,48,28,8,0,0,0,0,0,0,0,0,19,38,59,79,98,118,139,160,167,147,124,104,129,152,177,165,139,114,91,66,43,20,0,0,0,0,0,0,1,19,37,53,71,84,85,74,56,40,24,27,52,76,101,124,152,177,166,142,116,91,66,43,17,0,0,0,0,6,22,36,46,50,50,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,7,33,55,81,104,132,154,154,154,155,170,160,154,154,154,154,154,157,172,158,154,154,149,121,99,73,50,25,0,0,1,25,49,72,96,118,143,163,179,159,143,129,117,108,100,91,82,73,63,52,37,21,3,0,0,0,2,26,49,72,96,119,143,167,182,159,136,112,90,67,46,33,50,71,93,116,139,162,184,162,139,114,92,68,45,22,0,10,33,58,81,104,129,154,177,173,151,129,106,86,66,47,35,40,43,39,30,17,0,0,0,0,0,5,30,53,76,101,124,132,132,132,152,175,175,150,132,132,132,132,132,132,109,83,60,38,12,0,0,0,0,0,0,0,0,0,0,9,31,53,75,97,118,141,162,163,141,118,97,76,55,34,14,0,0,0,0,0,0,0,0,12,32,52,72,92,112,134,153,173,154,134,112,104,129,154,177,165,139,114,91,66,43,20,0,0,0,0,0,0,0,1,19,35,50,59,60,53,38,22,11,33,57,80,104,129,154,177,162,139,114,88,65,40,16,0,0,0,0,0,3,15,24,27,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,7,33,55,81,104,132,152,152,152,159,166,153,152,152,152,152,152,159,164,152,152,152,149,121,99,73,50,25,0,0,0,20,43,65,88,109,130,149,166,175,161,149,140,132,121,113,104,93,82,69,53,37,19,1,0,0,5,29,53,76,99,121,147,172,178,154,132,106,83,60,37,19,41,64,88,111,135,159,182,167,144,119,96,71,48,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,54,33,14,17,17,15,7,0,0,0,0,0,0,2,27,49,71,92,103,104,104,124,152,175,175,149,124,104,104,104,104,104,98,78,57,35,10,0,0,0,0,0,0,0,0,0,0,20,42,64,86,107,130,152,173,153,132,107,86,64,43,22,1,0,0,0,0,0,0,0,5,25,45,65,85,105,124,146,166,160,139,118,99,104,129,154,177,165,139,114,91,66,43,20,0,0,0,0,0,0,0,0,1,17,27,34,35,29,18,4,23,44,66,88,110,136,159,180,156,134,109,85,61,37,12,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,7,32,55,81,103,124,124,124,124,144,157,134,124,124,124,124,124,147,154,132,124,124,124,121,98,73,50,25,0,0,0,13,34,56,76,95,114,132,147,160,170,172,162,154,146,137,129,115,101,87,71,53,34,14,0,0,7,30,54,78,101,124,150,175,176,152,129,104,80,56,33,13,37,60,83,106,132,157,180,170,147,121,97,73,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,19,38,56,72,78,78,101,124,152,175,175,149,124,101,78,78,78,78,75,62,45,25,2,0,0,0,0,0,0,0,0,0,6,29,51,74,96,117,141,163,165,143,119,97,75,53,31,10,0,0,0,0,0,0,0,0,18,38,58,78,98,117,139,160,166,146,124,105,86,104,129,154,177,165,139,114,91,66,43,20,0,0,0,0,0,0,0,0,0,0,4,9,9,5,0,17,37,57,78,99,121,144,167,170,147,123,101,77,54,31,7,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,121,147,153,129,104,99,99,101,124,149,151,124,101,99,99,98,87,66,45,21,0,0,0,3,23,43,62,80,98,112,129,139,148,158,167,176,167,158,148,137,121,105,87,67,47,27,5,0,7,33,55,78,104,129,152,175,175,152,124,101,78,55,31,12,35,58,83,106,132,157,180,172,147,121,99,73,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,5,24,39,50,55,76,101,124,152,175,175,149,124,101,76,55,55,55,53,43,28,11,0,0,0,0,0,0,0,0,0,0,15,37,60,82,105,129,152,173,156,134,110,88,65,43,21,0,0,0,0,0,0,0,0,12,31,52,72,91,112,132,153,172,153,132,112,92,81,104,129,154,177,165,139,114,91,66,43,31,22,7,0,0,0,0,0,0,0,0,0,0,0,0,13,32,52,72,91,112,134,155,178,158,137,114,91,69,46,23,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,0,18,38,56,68,73,78,101,124,150,150,124,101,78,81,104,129,152,147,121,99,75,73,73,66,51,33,12,0,0,0,0,10,29,46,64,80,94,106,116,124,137,146,155,164,176,169,155,139,121,100,80,58,37,14,0,7,30,54,78,101,124,150,175,176,152,129,104,79,56,33,13,37,60,83,106,132,157,180,170,147,121,98,73,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,5,17,30,53,76,101,124,152,175,175,149,124,101,76,53,30,30,28,21,10,0,0,0,0,0,0,0,0,0,0,0,23,46,69,91,114,137,160,172,149,124,102,79,57,34,12,0,0,0,0,0,0,0,5,24,45,65,85,105,124,146,165,158,139,117,98,79,81,104,129,154,177,165,139,114,91,66,60,55,43,26,7,0,0,0,0,0,0,0,0,0,0,12,30,49,67,87,106,129,147,168,167,146,124,103,81,58,36,14,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,0,13,34,51,64,71,71,81,104,130,153,147,121,98,75,83,106,132,156,144,119,96,72,71,65,53,34,17,0,0,0,0,0,2,21,38,49,60,73,84,94,104,113,121,132,144,156,172,173,155,134,112,90,67,44,20,0,5,29,53,76,99,121,147,172,178,154,132,106,83,60,37,19,41,64,88,111,135,159,182,167,144,119,96,72,48,25,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,175,149,124,101,76,53,30,5,3,0,0,0,0,0,0,0,0,0,0,0,0,6,30,53,76,99,121,146,168,165,142,117,94,72,49,26,3,0,0,0,0,0,0,0,18,38,57,78,98,117,139,159,165,145,124,105,86,86,86,104,129,154,177,165,139,114,91,86,86,77,61,40,19,0,0,0,0,0,0,0,0,0,10,28,46,65,83,101,121,143,161,173,153,134,110,90,69,47,25,4,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,1,23,47,67,85,96,96,96,107,134,157,144,119,96,96,96,109,137,160,142,116,96,96,96,87,69,47,25,1,0,0,0,0,17,36,55,69,78,77,65,73,82,91,101,110,121,139,156,178,166,144,119,96,73,49,25,0,2,26,50,73,96,119,144,167,182,159,136,112,90,66,46,33,50,71,93,116,139,162,184,162,139,114,92,68,45,22,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,175,149,124,101,76,53,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,106,130,153,176,160,137,111,88,65,41,18,0,0,0,0,0,0,0,6,28,50,73,91,110,132,153,172,152,132,111,111,111,111,111,111,129,154,177,165,139,114,111,111,110,95,73,49,26,0,0,0,0,0,0,0,0,10,28,46,63,82,99,117,139,157,177,158,138,117,98,76,56,35,14,0,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,4,27,53,75,100,121,121,121,121,137,160,142,121,121,121,121,121,139,162,139,121,121,121,121,101,78,53,30,4,0,0,0,12,31,50,69,89,102,99,85,72,60,70,79,89,103,123,147,170,172,148,121,99,75,50,27,0,0,21,45,67,91,113,137,160,181,165,143,119,99,78,62,57,65,82,103,124,147,170,176,155,132,109,86,63,40,17,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,175,149,124,101,76,53,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,89,112,137,160,178,154,132,106,82,59,35,12,0,0,0,0,0,0,0,10,32,55,80,103,124,145,165,173,152,137,137,137,137,137,137,137,138,156,178,166,144,137,137,137,121,99,76,50,27,0,0,0,0,0,0,0,10,28,46,62,80,98,116,136,155,173,162,143,121,103,83,63,43,22,1,0,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,5,27,53,76,101,124,149,149,149,152,168,154,149,149,149,149,149,153,170,153,149,149,149,129,101,78,53,30,5,0,0,6,25,45,64,83,103,121,117,105,92,81,76,73,76,96,119,144,170,171,147,121,99,74,50,27,0,0,16,38,61,83,105,129,150,171,174,153,132,112,95,84,81,86,98,116,137,157,179,166,145,121,100,78,56,33,11,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,175,149,124,101,76,53,30,7,5,0,0,0,0,0,0,0,0,0,0,0,0,23,47,71,94,118,143,166,173,149,124,101,77,53,30,6,0,0,0,0,0,0,0,10,33,55,81,104,129,154,177,182,169,162,162,162,162,162,162,162,162,172,189,179,165,162,162,149,121,99,76,50,27,0,0,0,0,0,0,10,28,46,62,80,98,116,136,154,171,164,146,124,107,87,67,48,28,8,0,0,0,0,0,0,0,0,0,0,0,5,27,50,73,96,119,144,167,182,160,137,111,88,66,43,20,0,0,0,0,0,0,5,27,53,76,101,124,152,157,157,163,170,158,157,157,157,157,157,165,168,157,157,157,152,129,101,78,53,30,5,0,0,17,39,58,78,98,116,137,139,124,113,104,99,96,99,109,129,149,172,165,143,119,96,72,48,24,0,0,8,31,52,74,96,116,139,159,178,165,146,130,114,106,104,108,117,134,150,169,174,154,135,112,91,70,48,26,4,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,152,175,175,149,124,101,76,53,30,33,30,21,9,0,0,0,0,0,0,0,0,0,4,28,52,75,99,121,147,171,169,145,119,96,73,49,25,1,0,0,0,0,0,0,0,10,33,55,81,104,129,154,160,160,160,160,160,160,160,160,160,160,160,170,187,177,162,160,160,149,121,99,76,50,27,0,0,0,0,0,12,28,46,62,80,98,116,134,152,170,166,148,130,109,91,72,52,33,25,25,20,11,0,0,0,0,0,2,13,20,22,22,27,50,73,96,119,144,167,182,160,137,111,88,66,43,22,22,19,11,0,0,0,5,27,53,76,101,124,132,132,132,147,157,136,132,132,132,132,132,150,154,132,132,132,132,129,101,78,53,30,5,0,2,25,49,71,92,112,132,152,158,147,136,129,121,119,121,130,144,161,175,155,135,111,89,65,44,20,0,0,0,21,42,64,84,105,124,144,162,179,163,149,138,132,129,132,139,152,166,175,159,141,121,100,80,59,38,16,0,0,10,33,58,81,104,129,154,177,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,76,101,124,149,175,175,150,124,101,78,54,53,58,54,42,28,9,0,0,0,0,0,0,0,0,9,32,56,80,104,129,152,175,165,142,116,93,69,45,22,0,0,0,0,0,0,0,0,10,33,55,81,104,129,134,134,134,134,134,134,134,134,134,134,134,135,155,178,165,141,134,134,134,121,99,76,50,27,0,0,0,0,12,29,46,64,80,98,116,134,152,170,168,149,130,110,92,74,56,50,50,50,50,44,32,17,0,0,0,6,22,35,45,48,48,48,50,73,96,119,144,167,182,160,137,111,88,66,48,48,48,43,33,19,2,0,2,25,49,71,91,103,104,104,121,147,154,129,105,104,104,104,124,151,150,124,104,104,104,103,92,73,49,27,2,0,5,27,53,76,101,124,143,155,166,167,158,152,147,147,147,152,163,172,159,141,121,100,80,58,36,12,0,0,0,11,31,52,72,91,110,129,144,160,172,170,160,154,154,155,162,172,170,157,143,123,107,87,68,48,27,6,0,0,10,33,58,81,104,129,154,175,172,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,76,100,124,149,172,176,152,129,106,82,73,77,81,75,62,42,22,1,0,0,0,0,0,0,0,12,36,60,83,107,134,157,180,163,139,114,90,66,42,18,0,0,0,0,0,0,0,0,8,30,53,76,96,106,106,106,106,106,106,106,106,106,106,106,106,129,154,177,165,139,114,106,106,106,92,72,48,25,0,0,0,12,30,47,64,82,98,116,136,152,170,168,150,132,112,94,76,73,73,73,73,73,73,65,51,31,9,0,0,19,38,55,67,73,73,73,73,73,96,119,144,167,182,160,137,111,88,73,73,73,73,66,53,36,16,0,0,16,38,56,71,78,78,101,124,150,151,124,101,78,80,104,129,154,147,121,99,78,78,78,72,58,38,19,0,0,2,25,49,71,92,107,121,135,146,155,163,168,170,170,170,167,161,152,140,123,107,88,68,47,27,5,0,0,0,0,19,39,58,76,94,110,124,140,152,161,167,172,172,171,166,159,149,138,123,107,91,73,54,35,15,0,0,0,10,33,58,81,104,129,149,149,149,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,50,73,97,119,144,168,181,159,137,116,101,96,101,106,96,76,53,31,8,0,0,0,0,0,0,0,15,40,63,87,111,137,160,183,162,137,111,88,63,40,16,0,0,0,0,0,0,0,0,1,22,42,62,75,83,83,83,83,83,83,83,83,83,83,83,104,129,154,177,165,139,114,91,83,83,74,58,39,17,0,0,8,28,47,65,82,99,116,136,154,170,170,152,134,114,99,99,99,99,99,99,99,99,98,85,66,43,19,0,8,30,51,72,89,98,99,99,99,99,99,119,144,167,182,160,137,111,99,99,99,99,98,87,69,48,26,0,0,3,22,37,48,56,80,104,129,153,147,121,99,75,83,107,132,157,144,119,96,71,53,53,49,38,22,5,0,0,0,17,38,58,74,88,101,112,121,132,139,144,148,149,147,144,139,130,118,105,89,73,55,35,15,0,0,0,0,0,6,25,43,60,76,92,106,118,130,138,144,147,149,147,143,137,129,116,103,89,73,56,39,21,2,0,0,0,10,32,58,80,103,121,121,121,121,121,119,98,75,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,46,69,93,115,138,160,181,170,152,136,124,121,124,130,106,83,59,36,13,0,0,0,0,0,0,0,18,42,66,90,114,139,162,183,160,136,109,86,62,38,14,0,0,0,0,0,0,0,0,0,10,28,44,54,58,58,58,58,58,58,58,58,58,58,81,104,129,154,177,165,139,114,91,66,58,52,41,24,6,0,0,18,41,64,83,99,117,136,154,170,183,157,134,119,121,124,124,124,124,124,124,124,124,121,96,73,48,22,0,12,35,58,80,103,121,121,121,121,121,121,121,144,167,182,160,137,121,121,121,121,121,119,98,75,53,30,0,0,0,3,15,36,60,83,106,132,157,144,119,96,71,86,110,136,160,142,116,93,68,45,27,24,16,3,0,0,0,0,6,24,40,55,68,80,91,101,109,116,119,121,121,121,119,114,107,97,86,72,56,38,21,2,0,0,0,0,0,0,10,26,44,59,73,86,97,107,114,119,121,121,121,119,113,105,95,83,71,56,40,22,6,0,0,0,0,6,28,52,73,90,99,99,99,99,99,98,87,69,45,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,61,84,106,129,149,168,184,170,157,150,149,151,136,111,88,65,42,19,0,0,0,0,0,0,0,20,45,68,92,116,142,165,182,157,134,108,83,60,35,12,0,0,0,0,0,0,0,0,0,0,9,22,30,33,33,33,33,33,33,33,33,33,55,81,104,129,154,177,165,139,114,91,66,43,28,20,6,0,0,0,22,47,73,95,117,137,154,171,188,186,162,147,147,149,150,152,152,152,152,152,152,149,121,96,73,48,22,0,12,35,58,81,104,129,149,149,149,149,149,149,155,173,187,167,152,149,149,149,149,147,121,99,76,53,30,0,0,0,0,15,39,63,86,110,136,160,142,116,93,68,88,114,139,162,139,114,90,65,42,18,0,0,0,0,0,0,0,0,7,22,35,48,59,70,79,87,93,97,99,99,99,96,92,85,76,65,53,38,22,5,0,0,0,0,0,0,0,0,10,26,40,54,65,76,85,92,96,99,99,99,96,90,83,74,63,51,37,22,6,0,0,0,0,0,0,18,40,56,68,73,73,73,73,73,73,66,53,33,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,53,74,95,114,136,150,163,170,175,175,172,164,141,116,94,70,48,25,0,0,0,0,0,0,0,22,45,71,93,118,144,167,175,157,132,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,0,5,7,7,7,7,7,7,7,7,33,55,81,104,129,154,175,165,139,114,91,66,43,20,0,0,0,0,0,22,48,73,96,121,149,171,175,175,175,175,170,172,173,175,175,175,175,175,175,172,149,121,96,73,48,22,0,12,35,58,81,104,129,152,175,175,175,175,175,175,175,175,175,175,175,175,175,170,147,121,99,76,53,30,0,0,0,0,18,42,66,89,114,139,162,139,114,90,68,92,116,142,160,137,109,86,63,39,15,0,0,0,0,0,0,0,0,0,2,15,27,38,48,57,64,69,73,76,76,76,73,69,62,54,44,33,19,6,0,0,0,0,0,0,0,0,0,0,7,20,33,44,54,62,69,73,76,76,75,72,67,60,51,41,31,18,4,0,0,0,0,0,0,0,6,24,38,47,50,50,50,50,50,50,45,35,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,41,62,81,99,115,130,140,147,149,149,148,144,138,121,99,76,50,27,0,0,0,0,0,0,0,23,48,71,96,119,146,149,149,149,132,104,81,57,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,149,149,149,139,114,91,66,43,20,0,0,0,0,0,22,48,73,96,121,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,96,73,48,22,0,12,35,58,81,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,147,121,99,76,53,30,0,0,0,0,21,45,68,93,116,142,149,137,109,86,71,95,119,144,149,134,106,83,60,36,12,0,0,0,0,0,0,0,0,0,0,0,6,16,26,34,41,46,50,50,50,50,50,45,40,32,23,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,23,32,40,46,50,50,50,50,49,45,38,30,21,10,0,0,0,0,0,0,0,0,0,0,4,15,22,25,25,25,25,25,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,28,47,64,81,95,106,115,121,121,121,121,119,114,106,92,72,48,25,0,0,0,0,0,0,0,25,48,73,96,119,121,121,121,121,121,103,80,55,32,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,32,55,80,103,121,121,121,121,121,113,91,65,43,20,0,0,0,0,0,22,48,73,96,119,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,96,73,48,22,0,12,35,58,80,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,53,30,0,0,0,0,22,45,70,93,117,121,121,121,106,83,73,96,119,121,121,121,103,80,57,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,23,27,27,27,27,26,22,17,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,17,22,26,27,27,27,25,21,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,30,46,61,73,84,91,96,99,99,98,93,89,82,73,58,38,17,0,0,0,0,0,0,0,21,43,66,85,98,99,99,99,99,99,90,71,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,99,99,96,81,59,38,16,0,0,0,0,0,19,43,66,85,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,85,66,43,19,0,9,31,52,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,48,26,0,0,0,0,19,41,64,83,98,99,99,99,92,75,66,85,98,99,99,99,90,73,50,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,27,41,51,61,67,72,73,73,73,70,65,59,51,39,22,5,0,0,0,0,0,0,0,12,31,51,65,73,73,73,73,73,73,68,55,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,38,56,68,73,73,73,73,73,72,62,45,27,7,0,0,0,0,0,9,31,51,65,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,65,51,31,9,0,0,21,40,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,53,36,16,0,0,0,0,9,29,49,64,73,73,73,73,69,58,51,65,73,73,73,73,68,56,38,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,19,30,37,44,48,48,48,48,46,41,35,28,18,6,0,0,0,0,0,0,0,0,0,15,31,42,48,48,48,48,48,48,45,34,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,45,48,48,48,48,48,47,40,27,11,0,0,0,0,0,0,0,15,31,42,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,42,31,15,0,0,0,6,22,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,33,19,2,0,0,0,0,0,13,30,41,47,48,48,48,45,37,31,42,48,48,48,48,45,35,20,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,14,19,22,22,22,22,21,17,11,4,0,0,0,0,0,0,0,0,0,0,0,0,12,20,25,25,25,25,25,25,22,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,22,25,25,25,25,25,24,19,8,0,0,0,0,0,0,0,0,0,9,18,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,18,9,0,0,0,0,0,4,15,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,13,1,0,0,0,0,0,0,0,8,17,22,22,22,22,20,14,9,18,22,22,22,22,20,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,19,24,27,30,30,27,24,19,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,15,20,25,27,30,30,27,24,19,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,23,27,28,30,30,27,24,19,11,2,0,0,0,0,0,0,0,0,0,6,17,25,27,27,27,27,27,27,24,15,3,0,6,17,25,27,27,27,27,27,27,24,15,2,0,0,0,0,0,6,12,15,15,15,15,15,12,5,10,17,22,26,27,27,26,22,16,8,0,0,0,0,0,0,0,0,0,0,5,12,15,15,15,15,15,11,6,14,21,25,27,27,25,22,16,8,0,0,4,12,20,24,27,27,26,23,17,9,0,0,0,0,0,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,18,8,0,0,0,0,0,0,8,18,24,25,25,25,25,25,24,19,9,0,0,8,18,24,25,25,25,25,25,24,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,24,33,41,47,52,53,53,52,48,43,35,25,15,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,29,37,44,49,52,53,53,52,48,42,34,24,13,1,0,0,0,0,0,0,0,0,0,0,7,16,26,34,41,46,50,53,53,53,51,47,41,33,23,12,0,0,0,0,0,0,0,9,26,40,49,53,53,53,53,53,53,48,37,21,7,24,38,49,53,53,53,53,53,53,47,36,21,3,0,0,0,16,29,37,40,40,40,40,40,36,28,32,40,46,50,50,50,50,45,39,31,20,7,0,0,0,0,0,0,0,15,28,37,40,40,40,40,40,35,27,36,44,49,50,50,50,45,39,30,18,14,25,35,43,48,50,50,50,46,40,31,20,7,0,0,0,0,0,0,0,0,19,33,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,49,41,29,11,0,0,0,0,11,29,41,49,50,50,50,50,50,50,42,30,13,11,29,41,49,50,50,50,50,50,49,40,27,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,21,34,45,56,64,70,75,76,76,75,71,65,57,47,35,21,6,0,0,0,0,0,0,0,0,0,0,0,4,17,30,41,51,59,67,72,75,76,76,75,71,65,56,45,33,21,7,0,0,0,0,0,0,0,5,17,29,38,48,57,64,69,73,76,76,76,74,70,64,55,45,31,17,1,0,0,0,0,0,22,41,58,71,76,76,76,76,76,76,69,55,37,22,41,58,71,76,76,76,76,76,75,69,55,35,15,0,0,13,33,48,59,63,63,63,63,63,59,47,55,63,70,74,76,76,73,69,62,53,41,27,12,0,0,0,0,0,11,31,47,59,63,63,63,63,63,57,49,59,68,73,76,76,74,70,62,51,39,34,47,58,67,73,76,76,74,70,63,53,41,27,10,0,0,0,0,0,0,13,33,53,69,75,76,76,76,76,76,76,76,76,76,76,76,76,76,76,74,63,45,26,5,0,0,6,26,47,63,74,76,76,76,76,76,75,64,49,29,27,47,63,74,76,76,76,76,76,73,61,45,24,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,26,41,55,66,78,87,93,99,101,101,99,94,88,79,68,55,40,24,8,0,0,0,0,0,0,0,0,0,6,22,37,50,62,73,82,90,96,99,101,101,99,94,87,78,66,55,40,26,10,0,0,0,0,0,13,26,38,49,60,70,79,87,93,97,99,101,101,99,93,86,76,65,51,35,18,0,0,0,0,7,32,53,74,92,101,101,101,101,101,101,89,70,49,31,52,74,92,101,101,101,101,101,101,89,69,46,24,0,4,25,48,67,82,88,88,88,88,88,81,65,76,86,93,98,99,99,98,93,84,74,61,46,29,11,0,0,0,0,23,46,65,82,88,88,88,88,88,78,70,81,90,96,99,99,98,93,84,73,58,54,68,80,90,96,99,99,98,93,85,74,61,44,28,9,0,0,0,0,0,22,45,67,89,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,98,81,59,36,14,0,0,14,36,59,81,97,101,101,101,101,101,98,83,63,42,39,61,81,97,101,101,101,101,101,95,79,57,34,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,44,59,74,87,99,109,116,121,124,124,121,116,110,100,88,74,58,40,23,5,0,0,0,0,0,0,0,6,24,40,56,70,83,95,104,112,118,121,124,124,121,116,109,98,87,74,59,42,24,5,0,0,0,10,29,46,58,71,82,91,101,109,116,119,124,124,124,121,116,108,98,85,69,51,34,15,0,0,0,10,35,58,81,103,124,124,124,124,124,123,101,76,53,35,58,81,103,124,124,124,124,124,121,98,76,50,27,0,9,31,56,78,99,111,111,111,111,111,99,85,98,108,116,121,124,124,121,116,107,95,80,63,45,26,6,0,0,4,29,54,76,99,111,111,111,111,110,95,90,103,114,121,124,124,121,116,106,92,76,73,88,101,112,119,124,124,121,116,107,95,80,62,43,24,2,0,0,0,2,25,50,73,98,123,124,124,124,124,124,124,124,124,124,124,124,124,124,124,114,88,65,40,17,0,0,17,40,65,88,114,124,124,124,124,124,117,97,76,55,50,72,93,115,124,124,124,124,124,111,86,63,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,24,43,60,76,92,107,119,132,140,147,149,149,147,141,134,121,107,92,74,56,38,18,0,0,0,0,0,0,4,22,40,56,74,89,103,115,124,136,142,147,149,149,147,140,132,118,107,92,76,57,35,14,0,0,0,22,43,63,79,91,103,113,123,134,139,144,148,149,149,146,140,132,117,103,85,67,48,28,7,0,0,10,35,58,81,104,129,152,152,152,149,124,101,76,53,35,58,81,104,132,152,152,152,147,121,99,76,50,27,0,10,33,58,81,104,129,139,139,139,129,104,105,118,132,141,147,149,149,147,140,129,114,96,78,59,38,17,0,0,5,30,55,78,104,129,139,139,139,124,99,110,124,137,146,149,149,147,139,129,112,94,92,107,121,136,144,149,150,147,140,130,114,96,78,57,36,14,0,0,0,2,25,50,73,99,124,149,152,152,152,152,152,152,152,152,152,152,152,152,142,114,88,66,40,17,0,0,15,38,61,83,105,124,146,152,152,152,132,109,89,67,62,83,105,129,149,152,152,145,123,103,81,59,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,38,58,76,94,110,129,141,154,163,170,172,172,170,164,155,143,124,109,91,72,51,31,9,0,0,0,0,0,17,37,56,74,91,107,121,137,149,158,165,170,174,173,170,163,153,141,124,110,90,65,42,17,0,0,6,28,53,75,98,112,124,137,146,155,163,168,172,175,173,170,163,152,138,119,101,82,61,39,17,0,0,10,35,58,81,104,129,154,175,172,149,124,101,76,53,35,58,81,104,132,154,175,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,162,155,132,109,124,139,153,163,170,175,174,170,162,148,132,110,91,71,49,27,6,0,5,30,55,78,104,129,154,162,152,129,112,130,145,158,168,174,175,170,161,147,130,109,110,129,143,156,167,173,175,171,163,149,132,112,90,69,47,24,1,0,0,2,25,50,73,99,124,149,170,170,170,170,170,170,170,172,177,177,177,165,142,114,88,66,40,17,0,0,7,29,50,71,91,112,134,154,174,165,144,121,101,80,72,95,115,139,160,174,154,134,110,90,69,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,30,51,72,91,110,130,146,161,173,162,152,148,147,151,158,171,161,144,124,105,84,63,41,20,0,0,0,0,9,30,50,70,89,107,124,143,156,170,175,164,157,154,152,155,163,168,149,130,110,89,65,42,19,0,0,7,30,55,80,103,129,146,157,167,166,158,154,152,152,156,165,179,171,155,136,114,93,72,49,27,4,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,157,135,129,144,160,160,157,157,159,166,179,182,165,146,123,102,81,58,36,14,0,5,30,55,78,104,129,154,180,155,132,132,150,164,157,157,157,165,178,181,164,144,121,130,146,162,158,157,157,164,177,184,166,146,124,101,79,57,33,9,0,0,2,25,50,73,99,124,144,144,144,144,144,144,144,144,150,169,191,171,152,132,109,87,64,40,16,0,0,0,17,37,57,79,99,119,141,161,177,156,136,114,92,83,105,129,150,171,162,141,119,98,78,57,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,63,84,105,124,145,164,170,154,140,130,123,121,129,138,154,170,159,139,117,96,73,51,28,6,0,0,0,20,41,62,83,103,121,143,159,175,170,155,143,134,130,129,134,143,154,136,114,96,77,57,35,14,0,0,4,27,50,72,93,115,137,158,154,144,136,132,129,129,134,145,161,179,170,148,124,103,81,57,34,12,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,164,147,148,160,147,138,132,132,136,146,161,179,178,156,134,110,88,65,42,20,0,5,30,55,78,104,129,154,180,162,145,150,155,144,135,132,135,144,161,179,178,155,137,146,157,145,136,132,134,144,159,177,180,157,135,110,86,64,39,15,0,0,2,25,50,73,98,117,119,119,119,119,119,119,119,119,140,165,177,158,137,116,96,76,55,33,10,0,0,0,4,24,45,65,86,106,129,148,169,169,148,129,105,94,116,139,161,171,149,129,107,86,65,44,23,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,51,73,95,116,139,159,174,155,136,119,106,99,99,104,117,136,156,172,150,129,105,82,59,36,13,0,0,7,29,51,73,94,115,137,156,175,170,154,136,121,110,104,104,109,119,135,119,100,82,63,44,24,4,0,0,0,19,40,61,82,104,124,144,132,121,112,106,101,104,110,129,146,166,180,158,135,111,88,64,40,17,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,181,171,155,141,124,114,106,106,112,124,146,166,186,163,140,116,93,70,47,24,0,5,30,55,78,104,129,154,180,179,168,152,136,121,110,106,110,123,145,166,188,170,162,154,137,121,111,106,109,123,144,164,187,165,142,116,93,69,44,20,0,0,0,20,43,64,83,93,93,93,93,93,93,93,112,134,154,174,163,144,121,103,82,62,41,21,0,0,0,0,0,11,31,52,73,93,114,136,156,176,160,139,116,104,129,149,172,158,137,115,95,74,53,32,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,36,59,82,105,129])
.concat([150,171,163,141,119,101,86,77,76,83,101,123,146,168,160,137,112,89,65,42,19,0,0,15,37,60,82,104,124,148,169,178,157,138,117,101,88,81,81,88,100,114,105,86,67,49,29,11,0,0,0,0,7,29,50,71,92,114,121,110,99,90,83,78,81,92,112,135,157,180,165,142,116,93,69,45,21,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,176,154,137,121,106,92,83,81,92,112,137,159,181,168,144,121,98,73,50,27,0,5,30,55,78,104,129,154,180,172,152,134,116,100,88,81,89,110,135,158,181,176,154,136,117,103,89,81,89,109,134,156,180,170,147,119,96,72,48,22,0,0,0,9,30,47,62,68,68,68,68,68,86,106,129,147,167,170,150,130,108,88,68,48,28,7,0,0,0,0,0,0,18,39,59,80,100,121,143,163,172,150,129,115,138,160,166,146,123,103,82,61,40,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,90,113,137,160,176,154,132,107,87,76,76,76,76,91,114,139,162,166,143,117,93,70,47,23,0,0,21,44,67,90,112,136,158,180,168,146,123,104,84,68,58,57,67,81,91,87,71,53,34,15,0,0,0,0,0,0,17,39,59,81,97,100,89,78,75,80,86,91,93,103,129,152,175,169,145,119,96,72,48,24,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,101,87,72,60,61,83,106,132,154,177,172,147,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,98,82,67,58,80,103,129,153,177,172,147,121,99,83,68,57,78,101,129,152,175,172,149,121,99,73,49,25,0,0,0,0,13,27,38,43,43,43,59,80,99,119,141,161,176,155,136,114,94,74,54,33,14,0,0,0,0,0,0,0,5,26,46,67,88,108,130,150,171,163,141,124,148,170,154,134,110,90,69,48,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,72,95,119,144,167,170,147,121,99,99,99,99,99,99,99,109,134,160,170,147,121,98,73,50,25,0,2,26,49,72,96,118,142,166,183,160,137,114,92,71,51,36,35,48,60,65,63,53,37,20,0,0,0,0,0,0,0,6,27,47,65,76,78,82,90,98,103,109,114,116,121,124,149,175,172,147,121,99,73,50,25,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,39,56,80,104,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,47,52,76,101,124,152,175,172,147,121,96,71,49,50,73,99,124,149,175,175,149,121,99,73,50,25,0,0,0,0,0,5,14,17,33,53,74,93,114,136,155,175,162,143,121,100,80,60,40,19,0,0,0,0,0,0,0,0,0,13,33,54,74,95,115,137,158,174,155,150,161,163,141,119,98,78,57,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,51,75,99,121,148,172,167,144,121,121,121,121,121,121,121,121,121,134,157,172,149,121,99,73,50,25,0,5,29,52,76,99,121,147,171,178,155,132,108,85,61,39,18,15,28,38,43,41,33,20,4,0,0,0,0,0,0,0,19,37,53,68,81,93,104,112,119,129,134,138,142,146,149,161,180,172,149,121,99,73,50,25,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,0,0,0,7,27,47,67,88,107,129,148,169,168,148,129,107,87,67,46,26,6,0,0,0,0,0,0,0,0,0,0,20,41,62,82,103,123,145,167,177,172,171,150,129,107,86,65,45,24,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,76,101,124,152,175,173,155,149,149,149,149,149,149,149,149,149,151,165,172,149,121,99,73,50,25,0,7,30,53,78,101,124,150,175,177,152,129,104,80,56,33,10,0,7,14,20,16,11,1,0,0,0,0,0,0,0,13,33,53,71,87,101,114,124,136,144,151,156,162,161,157,154,164,182,172,149,121,99,73,50,25,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,0,0,0,21,41,61,81,101,121,143,163,174,154,135,113,92,73,52,32,12,0,0,0,0,0,0,0,0,0,0,0,17,38,59,79,100,121,143,165,188,187,162,139,115,95,74,53,32,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,152,176,177,162,157,157,157,157,157,157,157,157,157,157,157,157,149,121,99,73,50,25,0,7,30,55,78,104,129,152,175,175,152,124,101,78,55,31,7,0,0,0,1,2,0,0,0,0,0,0,0,0,4,25,47,67,86,103,119,136,148,158,166,158,150,144,138,134,132,150,175,172,149,121,99,73,50,25,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,0,0,14,35,55,75,95,116,137,157,177,161,140,119,99,79,59,38,18,0,0,0,0,0,0,0,0,0,0,0,10,31,51,72,92,113,135,155,172,165,170,167,148,129,106,86,65,45,24,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,77,101,124,152,175,168,146,134,134,134,134,134,134,134,134,134,134,134,134,134,121,97,73,50,25,0,7,30,54,78,101,124,151,175,176,152,129,104,80,56,33,9,0,6,17,23,25,22,13,1,0,0,0,0,0,13,35,57,79,100,119,139,155,169,161,147,136,129,119,114,109,124,149,175,172,149,121,99,73,50,25,0,10,35,58,81,104,129,154,177,172,149,124,101,76,53,35,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,0,9,28,49,69,89,109,132,150,171,167,146,124,105,85,65,45,24,20,20,16,7,0,0,0,0,0,0,0,2,23,43,64,85,105,129,148,169,154,139,152,172,161,141,119,99,79,58,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,52,76,99,123,149,172,170,147,121,106,106,106,106,106,106,106,106,106,106,106,106,105,90,67,45,22,0,5,29,53,76,100,123,147,172,178,155,132,107,85,61,39,17,13,26,39,48,50,45,35,19,2,0,0,0,0,20,43,66,90,112,135,155,173,162,143,124,113,104,96,90,99,124,149,175,172,149,121,99,73,50,25,0,10,35,58,81,104,129,153,176,172,149,124,101,78,54,42,58,81,104,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,2,23,43,63,83,103,123,144,165,173,153,134,112,91,71,51,45,45,45,45,40,29,13,0,0,0,0,0,0,15,35,56,76,98,117,140,161,164,143,119,138,160,174,154,134,112,92,72,51,31,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,49,72,96,119,144,167,174,152,129,105,83,83,83,83,83,83,83,83,83,83,83,83,72,56,35,14,0,2,27,50,73,96,119,144,167,183,160,137,114,92,70,50,36,34,45,59,70,73,66,53,36,16,0,0,0,1,25,49,73,96,119,144,166,173,151,129,108,92,81,73,76,99,124,149,175,172,149,121,99,73,50,25,0,9,33,56,78,101,124,150,175,175,152,129,104,81,58,62,76,92,110,132,154,177,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,0,17,37,57,77,98,117,139,158,179,159,139,117,98,78,71,71,71,71,71,70,63,49,30,9,0,0,0,0,7,28,48,69,90,110,132,153,173,153,132,108,124,147,167,167,147,124,105,85,64,44,24,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,67,91,114,138,160,182,159,137,114,94,75,61,60,60,60,64,74,85,84,72,60,53,40,22,3,0,0,22,45,68,91,114,137,160,182,168,146,123,103,83,68,58,58,65,78,91,96,87,69,49,29,9,0,0,3,27,51,76,99,124,149,173,170,145,119,96,74,61,64,78,99,124,149,175,172,149,121,99,73,50,25,0,7,30,53,78,101,123,147,170,178,156,134,110,91,83,85,95,110,129,144,163,183,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,10,31,51,71,91,112,132,153,172,165,145,124,104,96,96,96,96,96,96,96,96,83,64,42,20,0,0,0,0,20,41,62,82,103,123,145,166,164,142,119,97,112,135,155,177,161,140,118,98,78,57,37,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,61,84,106,129,152,172,170,148,129,109,94,83,77,76,79,86,96,107,107,88,66,45,24,6,0,0,0,16,39,61,84,106,129,152,172,178,156,137,117,100,88,81,81,87,98,110,121,101,82,62,42,22,2,0,5,27,53,76,101,124,151,175,170,144,119,96,78,77,84,98,112,130,150,175,172,149,121,99,73,50,25,0,4,27,50,73,96,119,144,166,186,164,144,124,111,106,109,116,130,144,161,165,180,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,0,21,44,65,85,105,124,146,167,180,155,132,119,119,119,119,119,119,119,119,119,117,97,73,47,25,0,0,0,12,33,54,74,95,115,137,158,174,153,132,108,87,100,121,143,163,174,154,134,112,91,71,50,31,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,30,53,74,97,117,139,160,179,162,144,129,114,105,101,99,101,107,116,129,119,99,78,56,35,14,0,0,0,9,32,53,75,97,117,140,161,179,170,152,136,121,110,105,104,109,118,132,136,114,95,75,55,35,14,0,2,27,50,75,99,123,148,172,173,151,129,110,101,101,106,117,132,147,164,182,172,149,121,99,73,50,25,0,0,23,46,69,91,113,137,158,180,177,159,145,136,132,134,139,150,157,140,146,167,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,2,27,51,75,98,119,140,161,181,184,163,147,147,147,147,147,147,147,147,147,147,121,99,73,48,25,0,0,5,25,46,66,87,107,130,150,171,162,141,118,97,75,88,108,130,150,171,167,146,124,105,84,64,44,24,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,64,85,105,124,145,162,179,162,148,137,129,124,121,124,132,140,150,132,109,89,67,46,24,1,0,0,0,22,44,65,86,107,129,146,164,180,170,154,143,134,132,132,134,141,152,148,129,108,88,67,45,24,0,0,24,48,71,94,117,142,164,182,163,144,132,124,124,130,139,152,156,157,172,172,149,121,99,73,50,25,0,0,16,38,61,83,105,124,147,167,184,177,166,159,157,157,162,155,139,121,139,162,172,147,121,99,76,50,27,0,10,33,58,81,104,129,154,177,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,180,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,2,27,53,76,101,124,152,174,175,175,175,173,172,172,172,172,172,172,172,172,149,121,99,73,48,25,0,0,16,38,58,79,99,121,143,163,172,150,130,107,86,64,74,95,116,137,158,175,160,139,117,98,78,57,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,52,72,92,110,130,146,160,172,169,159,152,149,149,149,155,162,165,144,121,100,78,54,31,6,0,0,0,12,33,54,74,92,112,130,146,161,174,174,164,157,154,154,157,163,172,159,141,121,98,73,50,27,0,0,18,41,65,87,109,132,152,170,179,164,155,149,149,152,160,150,136,138,161,172,149,121,99,73,50,25,0,0,8,31,53,73,93,114,134,150,163,170,173,172,169,162,150,137,121,111,137,160,162,147,121,99,76,50,27,0,10,33,58,81,104,129,154,175,172,149,121,99,76,53,33,55,78,101,129,152,175,172,149,121,99,76,53,27,0,5,30,55,78,104,129,154,175,170,144,119,93,68,45,50,76,99,124,152,175,172,147,121,96,71,48,48,73,99,121,149,172,175,149,121,99,73,50,25,0,2,27,53,76,101,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,48,25,0,0,23,48,70,92,113,135,149,149,149,139,116,95,74,53,62,82,103,123,145,149,149,149,132,110,91,69,45,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,38,58,76,94,110,124,140,152,161,167,172,172,172,168,163,154,145,135,121,102,78,55,30,7,0,0,0,0,21,41,60,78,96,112,129,141,153,161,167,172,172,172,167,160,150,139,124,110,93,71,48,26,0,0,11,33,55,76,98,117,137,152,163,170,172,171,165,156,144,132,116,134,157,162,149,121,99,73,50,25,0,0,0,20,41,62,81,99,116,130,140,147,149,149,146,139,129,116,101,109,134,139,139,139,121,99,76,50,27,0,10,33,58,81,104,129,149,149,149,149,121,99,76,53,33,55,78,101,129,149,149,149,149,121,99,76,53,27,0,5,30,55,78,104,129,149,149,149,144,119,93,68,45,50,76,99,124,149,149,149,147,121,96,71,48,48,73,99,121,149,149,149,149,121,99,73,50,25,0,2,27,53,75,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,25,0,0,25,48,73,98,119,121,121,121,121,121,105,83,62,40,48,69,90,110,121,121,121,121,121,119,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,24,42,60,76,92,106,118,130,138,144,147,149,148,144,139,132,121,112,100,87,69,48,25,3,0,0,0,0,7,26,44,62,78,93,107,119,132,139,144,147,149,147,144,137,129,117,105,92,77,59,40,18,0,0,2,23,45,64,83,101,116,132,141,147,149,147,143,135,121,110,104,130,137,137,137,121,99,73,50,25,0,0,0,8,28,47,65,82,96,107,116,121,121,121,121,115,106,95,83,101,111,111,111,111,110,95,73,49,26,0,10,32,58,80,103,121,121,121,121,121,119,98,75,53,32,55,78,101,121,121,121,121,121,119,98,75,53,27,0,4,30,55,78,103,121,121,121,121,121,117,93,68,45,50,75,98,121,121,121,121,121,119,96,70,48,48,73,98,119,121,121,121,121,119,98,73,50,25,0,0,24,48,69,89,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,21,0,0,24,45,69,87,98,99,99,99,99,99,90,72,50,29,35,56,76,93,99,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,42,58,73,86,97,107,114,119,121,121,121,119,116,109,100,91,80,67,54,36,17,0,0,0,0,0,0,11,28,44,60,74,87,98,107,114,119,121,121,121,119,114,106,97,86,73,59,44,27,7,0,0,0,11,31,49,67,83,98,108,116,121,121,121,119,112,101,90,98,111,111,111,111,110,95,71,49,24,0,0,0,0,14,31,47,62,75,85,93,97,99,99,96,92,84,74,67,81,86,86,86,86,86,77,61,40,19,0,6,28,52,73,90,99,99,99,99,99,98,87,69,48,28,50,71,89,99,99,99,99,99,98,87,69,48,24,0,1,26,50,71,90,99,99,99,99,99,98,83,62,41,45,69,87,98,99,99,99,99,98,85,64,43,43,66,87,98,99,99,99,99,98,87,66,45,21,0,0,14,36,53,67,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,12,0,0,12,33,51,66,73,73,73,73,73,73,68,55,38,17,22,42,58,70,73,73,73,73,73,73,65,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,25,40,53,65,75,85,91,96,99,99,99,97,93,86,78,69,59,47,35,20,2,0,0,0,0,0,0,0,12,27,42,55,66,76,85,92,96,99,99,99,96,91,84,75,64,53,40,26,10,0,0,0,0,0,16,33,50,64,76,87,94,99,99,99,96,90,80,69,81,88,88,88,88,88,78,61,40,18,0,0,0,0,0,14,29,43,54,63,69,73,73,73,73,69,61,53,50,60,63,63,63,63,63,57,45,27,9,0,0,18,40,56,68,73,73,73,73,73,73,66,53,36,18,38,55,67,73,73,73,73,73,73,66,53,36,14,0,0,16,38,55,68,73,73,73,73,73,73,64,47,29,33,53,66,73,73,73,73,73,73,65,49,31,31,51,66,73,73,73,73,73,73,66,51,33,12,0,0,0,19,33,44,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,0,17,31,43,48,48,48,48,48,48,45,34,20,2,8,24,38,46,48,48,48,48,48,48,42,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,20,32,44,54,61,68,73,76,76,76,73,69,63,56,47,38,27,14,2,0,0,0,0,0,0,0,0,0,8,21,34,45,55,62,69,73,76,76,76,73,68,61,53,43,32,20,7,0,0,0,0,0,0,0,16,31,45,55,65,71,74,76,76,72,66,58,48,58,63,63,63,63,63,57,44,27,7,0,0,0,0,0,0,9,21,31,40,45,49,50,50,48,45,38,31,28,35,38,38,38,38,37,33,24,9,0,0,0,6,24,38,47,50,50,50,50,50,50,45,35,21,6,22,36,46,50,50,50,50,50,50,45,35,21,2,0,0,4,22,36,47,50,50,50,50,50,50,43,30,15,19,35,45,50,50,50,50,50,50,44,32,17,17,33,45,50,50,50,50,50,50,45,33,19,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,9,19,22,22,22,22,22,22,20,12,0,0,0,3,15,21,22,22,22,22,22,22,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,23,32,40,45,50,50,50,50,50,46,41,33,25,16,6,0,0,0,0,0,0,0,0,0,0,0,0,2,13,24,33,40,46,50,50,50,50,50,45,39,31,22,12,0,0,0,0,0,0,0,0,0,0,12,23,34,42,48,50,50,50,49,44,36,28,36,40,40,40,40,40,36,25,11,0,0,0,0,0,0,0,0,0,9,16,22,25,25,25,25,21,16,8,7,13,15,15,15,15,15,11,3,0,0,0,0,0,4,15,22,25,25,25,25,25,25,21,13,1,0,2,14,22,25,25,25,25,25,25,21,13,1,0,0,0,0,2,14,22,25,25,25,25,25,25,20,9,0,0,13,21,25,25,25,25,25,25,20,11,0,0,12,21,25,25,25,25,25,25,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,16,22,26,27,27,27,27,23,17,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,17,22,26,27,27,27,26,22,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,2,12,19,24,27,27,27,25,21,14,6,14,17,17,17,17,17,13,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,9,17,20,20,20,20,20,20,17,9,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,20,11,0,0,8,19,24,25,25,25,25,25,20,11,0,0,8,18,24,25,25,25,25,25,21,12,0,0,0,0,0,1,13,21,25,25,25,25,25,25,22,13,1,0,0,0,0,12,20,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,29,30,30,30,30,28,21,10,0,0,0,0,0,0,0,0,0,0,0,0,3,16,24,27,26,19,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,20,26,27,24,15,2,0,0,0,0,0,0,0,0,0,0,0,9,19,24,25,25,25,25,24,18,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,22,27,30,30,28,24,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,24,27,27,27,27,23,14,2,0,0,0,0,0,0,0,0,0,1,17,30,39,43,43,43,43,43,43,39,30,17,1,0,0,0,0,0,0,0,0,19,35,45,50,50,50,50,50,50,44,32,17,13,29,42,49,50,50,50,50,50,44,32,15,11,29,41,49,50,50,50,50,50,45,33,19,0,0,0,2,19,35,45,50,50,50,50,50,50,45,35,21,2,0,0,17,33,44,50,50,50,50,50,50,44,33,17,0,0,0,0,0,0,0,0,0,0,0,13,29,42,51,53,53,53,53,51,41,28,11,0,0,0,0,0,0,0,0,0,0,4,21,36,46,50,49,41,33,24,15,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,24,33,42,49,50,45,35,19,2,0,0,0,0,0,0,0,0,0,13,29,42,50,50,50,50,50,49,41,27,11,0,0,0,0,0,0,0,0,0,0,0,3,16,27,37,45,51,53,53,52,47,40,31,19,6,0,0,0,0,0,0,0,0,0,0,7,24,38,49,53,53,53,52,47,36,21,2,0,0,0,0,0,0,0,0,13,31,47,58,63,63,63,63,63,63,58,47,31,13,0,0,0,0,0,0,0,14,35,55,69,76,76,76,76,76,75,67,51,33,27,47,64,74,76,76,76,76,75,66,51,31,26,45,63,74,76,76,76,76,75,69,53,35,13,0,0,15,36,55,69,76,76,76,76,76,76,69,55,36,16,0,13,33,53,67,75,76,76,76,76,75,67,53,33,13,0,0,0,0,0,0,0,0,0,5,26,47,63,75,78,78,78,78,74,62,45,24,2,0,0,0,0,0,0,0,0,0,17,37,56,70,76,73,64,55,47,38,29,21,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,13,22,30,39,48,56,65,73,75,69,55,35,15,0,0,0,0,0,0,0,0,7,28,47,64,74,76,76,76,76,73,63,45,25,4,0,0,0,0,0,0,0,0,0,4,19,33,47,58,67,73,76,76,75,69,62,50,38,22,8,0,0,0,0,0,0,0,0,0,20,39,56,70,76,76,76,75,67,53,35,15,0,0,0,0,0,0,0,3,24,45,63,79,86,86,86,86,86,86,79,63,45,24,5,0,0,0,0,0,0,24,46,69,89,101,101,101,101,101,100,85,66,43,38,61,82,98,101,101,101,101,99,85,64,43,36,59,81,97,101,101,101,101,101,87,67,45,21,0,1,24,48,70,89,101,101,101,101,101,101,89,71,48,26,3,23,45,67,87,100,101,101,101,101,100,87,66,45,21,0,0,0,0,0,0,0,0,0,12,36,58,79,97,101,101,101,101,95,76,56,34,9,0,0,0,0,0,0,0,0,4,26,49,71,89,101,95,86,78,69,60,52,43,34,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,18,27,35,44,53,61,70,79,87,96,101,87,69,46,24,0,0,0,0,0,0,0,0,17,40,62,83,98,101,101,101,101,97,79,58,37,14,0,0,0,0,0,0,0,0,0,18,35,51,65,78,89,97,101,101,98,92,82,69,55,40,22,5,0,0,0,0,0,4,10,12,28,51,72,91,101,101,101,100,87,66,45,24,12,9,2,0,0,0,0,8,30,53,74,94,106,106,106,106,106,106,94,75,55,36,16,0,0,0,0,0,2,27,50,76,101,123,124,124,124,124,121,98,74,50,45,69,93,116,124,124,124,124,118,96,72,49,43,67,91,114,124,124,124,124,121,98,73,50,25,0,5,27,53,76,101,123,124,124,124,124,123,101,79,56,33,10,30,53,76,98,121,124,124,124,124,121,96,73,50,25,0,0,0,0,0,0,0,0,0,15,40,63,86,111,124,124,124,124,109,83,60,38,12,0,0,0,0,0,0,0,0,7,30,53,78,101,123,117,109,100,92,83,74,66,57,49,40,32,23,14,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,15,24,32,41,49,58,67,75,84,93,101,109,118,121,98,76,50,27,0,0,0,0,0,0,0,4,26,49,71,94,116,129,129,129,129,113,91,68,46,23,0,0,0,0,0,0,0,0,10,30,48,66,82,96,109,118,124,124,121,113,101,85,70,53,35,16,0,0,0,0,14,25,33,35,33,56,80,103,124,124,124,118,97,73,50,33,35,32,24,12,0,0,0,10,33,55,78,101,124,129,129,129,129,124,106,86,67,47,28,8,0,0,0,0,1,25,49,73,96,119,144,152,152,152,129,103,80,56,51,75,98,121,147,152,152,151,124,102,78,55,49,73,96,119,144,152,152,144,119,95,72,48,24,0,2,25,49,72,95,117,141,152,152,152,134,109,86,63,41,17,37,60,83,106,130,152,152,152,139,115,92,69,46,23,0,0,0,0,0,0,0,0,0,15,40,63,86,111,137,149,149,134,109,83,60,38,12,0,0,0,0,0,0,0,0,7,30,53,78,101,124,141,132,123,114,106,97,89,80,71,63,54,45,37,28,20,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,20,29,38,46,55,64,72,81,90,98,106,115,124,134,143,121,99,76,50,27,0,0,0,0,0,0,0,13,35,58,81,103,124,149,154,154,146,121,100,77,55,32,10,0,0,0,0,0,0,0,19,38,58,76,95,112,130,141,148,149,144,134,117,100,82,64,45,26,0,0,0,15,33,47,56,58,56,58,81,104,129,152,147,121,99,76,53,57,58,54,44,30,12,0,0,7,30,53,74,94,112,132,149,152,152,138,117,98,78,58,38,19,0,0,0,0,0,19,43,66,90,114,138,161,177,157,134,109,85,61,57,81,105,129,152,176,177,157,134,109,85,61,54,78,101,124,150,174,160,137,113,89,65,41,18,0,0,18,41,64,86,109,134,155,177,163,140,116,93,70,48,24,45,67,90,113,137,160,176,154,132,107,85,61,39,16,0,0,0,0,0,0,0,0,0,15,40,63,86,111,137,162,160,134,109,83,60,38,12,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,155,147,138,129,119,111,102,93,85,76,68,59,50,42,33,24,16,8,0,0,0,0,0,0,0,0,0,0,8,17,25,34,43,51,60,69,77,86,95,103,112,121,130,139,147,156,149,121,99,76,50,27,0,0,0,0,0,0,0,22,44,67,90,112,136,158,177,177,155,132,109,86,64,41,19,0,0,0,0,0,0,2,23,44,64,85,104,124,144,161,172,173,164,148,132,111,92,73,53,33,0,0,7,28,48,65,79,83,79,74,83,106,132,154,149,124,101,78,75,80,83,78,64,45,24,2,0,2,23,44,63,81,99,116,136,154,169,149,130,109,89,69,50,30,11,0,0,0,0,12,36,60,83,107,132,155,179,162,139,114,91,67,64,87,111,136,159,176,176,163,139,114,91,67,60,84,107,132,156,178,155,132,106,83,59,35,12,0,0,10,33,56,78,101,124,147,170,170,147,123,101,77,55,32,52,74,98,119,144,167,168,146,121,99,77,53,31,8,0,0,0,0,0,2,5,5,5,15,40,63,86,111,137,162,160,134,109,83,60,38,12,5,5,4,1,0,0,0,0,7,30,53,78,101,124,152,166,169,161,152,144,135,124,116,108,99,91,82,73,65,56,48,39,30,22,12,0,0,0,0,0,1,13,23,31,40,49,57,65,74,83,91,100,109,117,129,136,144,153,162,170,165,149,121,99,76,50,27,0,0,0,0,0,0,8,31,53,76,98,121,144,167,161,162,164,141,118,95,73,50,28,5,0,0,0,0,0,2,25,45,66,86,106,129,149,170,190,196,178,159,139,119,98,78,58,38,0,0,15,37,59,81,99,106,102,97,92,109,134,157,152,129,104,93,98,103,106,96,76,55,33,11,0,0,13,31,49,67,85,103,121,141,159,161,141,119,100,81,61,41,21,2,0,0,0,6,30,54,77,101,124,149,172,168,144,119,96,72,69,93,116,141,165,152,153,169,145,121,97,73,65,90,113,138,162,172,148,124,101,77,53,29,6,0,0,2,25,48,70,93,115,139,162,177,155,132,108,85,62,39,59,81,105,129,152,174,160,138,114,91,69,45,23,0,0,0,0,3,16,24,27,27,27,27,40,63,86,111,137,162,160,134,109,83,60,38,27,27,27,27,24,15,2,0,0,7,30,53,78,101,124,136,144,152,160,168,166,157,148,140,132,121,113,104,96,87,78,70,61,53,44,33,17,0,0,0,2,19,34,45,53,62,71,79,88,97,105,114,121,132,140,149,158,166,167,159,151,143,135,121,99,76,50,27,0,0,0,0,0,0,17,40,63,85,107,132,154,160,139,141,163,150,129,104,82,59,37,14,0,0,0,0,0,2,23,44,65,85,105,124,145,163,174,177,182,164,144,121,101,81,60,40,0,0,22,45,66,89,110,132,124,121,115,111,137,160,154,132,111,116,121,129,129,106,84,62,40,18,0,0,0,18,36,54,72,90,108,124,145,163,152,132,112,92,72,53,33,13,0,0,0,0,24,48,70,94,118,142,166,173,150,124,101,78,75,98,121,147,160,135,138,162,152,129,103,80,71,95,118,144,167,166,142,118,94,70,47,23,0,0,0,0,17,40,62,85,107,132,154,176,162,139,115,92,69,46,66,89,112,136,159,176,152,130,106,83,61,37,15,0,0,0,4,21,36,46,50,50,50,50,50,63,86,111,137,162,160,134,109,83,60,50,50,50,50,50,45,35,19,2,0,4,27,49,72,91,104,111,119,129,137,144,152,160,168,163,154,146,137,129,118,110,101,93,84,75,66,51,33,14,0,0,16,36,53,67,76,85,93,102,110,119,129,138,147,155,163,167,159,152,144,136,129,118,110,103,89,70,46,24,0,0,0,0,0,4,26,49,72,94,116,140,163,152,129,132,155,160,137,114,91,68,46,24,1,0,0,0,0,0,19,39,59,78,97,115,132,144,151,152,161,167,147,121,101,81,60,40,0,6,29,52,73,96,117,140,150,144,139,134,140,162,155,136,136,141,146,151,137,114,91,69,47,25,0,0,0,5,23,41,58,76,94,112,132,150,163,144,123,103,83,64,44,21,0,0,0,0,17,41,64,88,111,137,160,180,155,132,107,83,81,105,130,153,154,132,134,157,157,134,109,86,77,101,124,149,173,160,137,112,88,64,41,17,0,0,0,0,9,31,54,77,99,121,145,168,169,146,121,99,77,53,73,96,119,143,166,168,144,121,98,75,53,29,7,0,0,0,16,36,55,67,73,73,73,73,73,73,86,111,137,162,160,134,109,83,73,73,73,73,73,73,66,53,33,14,0,0,19,38,56,72,81,89,97,105,113,121,130,137,145,153,161,168,160,150,142,134,123,115,106,98,85,67,44,23,0,3,25,47,69,87,98,107,116,124,134,143,152,160,168,160,152,144,137,129,119,112,104,96,88,81,71,55,36,16,0,0,0,0,0,13,36,58,81,103,124,149,167,144,119,123,147,168,146,121,100,77,55,33,10,0,0,0,0,0,12,31,49,67,85,99,112,121,129,130,150,165,144,121,101,81,60,40,0,10,32,55,78,101,124,143,152,162,163,158,160,173,170,158,160,164,160,150,141,121,98,75,50,27,0,0,0,0,9,27,45,63,81,99,117,137,144,144,135,114,95,73,49,27,0,0,0,0,11,35,58,81,106,130,154,177,161,137,113,89,88,111,137,160,150,124,129,152,163,140,115,92,82,106,132,155,178,155,132,106,82,58,35,11,0,0,0,0,0,23,46,69,91,114,137,160,176,153,132,106,83,61,81,103,129,150,173,160,137,113,90,67,45,22,0,0,0,3,26,48,69,89,98,99,99,99,99,99,99,111,137,162,160,134,109,99,99,99,99,99,99,98,87,67,45,24,0,0,5,22,38,50,58,66,73,81,90,98,106,114,121,130,138,146,154,162,165,156,147,139,130,119,98,75,50,27,0,7,30,53,78,101,121,132,139,148,157,165,161,153,145,137,129,119,113,105,97,89,81,73,65,57,49,38,21,3,0,0,0,0,0,22,45,67,90,113,136,158,158,136,112,114,138,161,155,132,109,87,64,41,19,0,0,0,0,0,2,20,38,53,67,81,91,99,109,132,150,160,140,119,99,79,59,38,0,8,31,53,77,98,110,119,130,139,149,158,176,191,188,170,156,147,138,129,117,108,93,73,51,26,0,0,0,0,0,14,31,50,67,85,103,121,121,121,121,119,98,75,53,30,0,0,0,0,4,28,52,75,99,121,147,170,167,143,118,94,93,116,142,165,144,119,121,147,170,147,121,98,88,111,137,160,172,148,123,100,76,52,28,4,0,0,0,0,0,15,38,61,83,106,129,152,174,160,138,114,91,68,88,110,135,157,174,152,129,105,82,59,36,14,0,0,0,7,30,53,78,101,121,121,121,121,121,121,121,121,137,162,160,134,121,121,121,121,121,121,121,119,98,75,50,27,0,0,0,5,17,28,35,43,51,59,67,75,83,90,98,106,114,121,132,139,147,161,170,161,149,121,99,76,50,27,0,7,30,53,78,101,124,152,162,171,159,147,139,132,121,114,106,98,90,82,74,66,58,50,42,34,27,16,4,0,0,0,0,0,9,31,54,76,99,121,145,168,150,124,104,106,130,153,164,141,118,96,73,50,28,6,0,0,0,0,13,27,39,48,58,70,84,100,117,138,156,153,135,114,93,74,54,34,0,2,24,45,63,79,89,98,107,116,129,145,167,183,184,160,138,124,115,106,96,87,76,60,40,19,0,0,0,0,0,0,18,36,54,72,89,101,101,101,101,101,87,67,46,24,0,0,0,0,0,22,45,69,93,116,141,164,172,148,124,100,99,121,147,163,139,114,116,142,165,152,129,104,93,116,142,165,165,142,116,93,70,46,23,0,0,0,0,0,0,7,29,52,75,98,119,144,166,168,145,121,98,75,95,117,142,164,166,144,119,97,74,51,28,6,0,0,0,7,30,53,78,101,124,147,147,147,147,147,147,147,149,167,165,148,147,147,147,147,147,147,147,121,99,76,50,27,0,0,0,0,0,7,15,23,31,39,47,54,62,70,78,86,94,102,110,118,129,154,177,172,149,121,99,76,50,27,0,7,30,53,78,101,124,152,175,175,152,124,117,109,101,93,85,77,69,61,54,46,38,30,22,14,6,0,0,0,0,0,0,0,18,40,63,85,108,132,154,164,142,117,95,98,121,145,167,151,129,105,82,60,37,15,0,0,0,7,27,44,58,70,78,88,101,116,132,149,161,144,124,105,86,67,48,28,0,0,12,29,46,57,66,76,88,108,129,149,170,158,160,165,145,123,103,83,74,65,55,43,26,7,0,0,0,0,0,0,5,23,41,58,72,78,78,78,78,78,71,56,38,16,0,0,0,0,0,16,39,63,86,109,135,158,178,154,132,106,106,130,154,159,135,109,111,137,160,159,135,110,98,121,147,171,160,137,111,88,64,40,17,0,0,0,0,0,0,0,21,44,66,90,112,136,158,175,152,129,105,82,102,124,149,172,158,136,111,89,66,44,20,0,0,0,0,7,30,53,78,101,124,152,170,170,170,170,170,170,171,182,181,170,170,170,170,170,170,170,149,121,99,76,50,27,0,0,0,7,20,30,38,46,54,61,69,77,85,93,101,109,116,124,134,142,150,164,167,159,149,121,99,76,50,27,0,7,30,53,78,101,124,152,160,168,162,149,141,134,124,116,108,100,93,85,77,69,61,53,45,37,29,19,6,0,0,0,0,4,27,49,72,94,116,140,163,156,134,109,87,90,112,136,158,160,137,114,91,69,46,24,1,0,0,16,37,56,74,90,100,109,119,134,148,163,148,132,113,95,77,58,39,20,0,0,0,13,25,41,61,80,100,119,141,161,155,137,141,159,156,137,115,95,75,56,36,23,9,0,0,0,0,0,0,0,0,9,26,41,52,58,58,58,58,58,52,41,24,6,0,0,0,0,0,9,33,56,80,103,129,152,175,160,137,110,111,137,160,152,129,104,106,132,155,165,141,116,104,129,152,176,153,130,105,81,57,33,11,0,0,0,0,0,0,0,13,36,58,81,104,129,150,173,160,137,113,90,109,134,157,173,150,129,103,81,58,36,13,0,0,0,0,7,30,53,78,101,124,147,147,147,147,147,147,147,149,167,165,148,147,147,147,147,147,147,147,121,99,76,50,27,0,0,7,24,41,52,61,69,77,84,92,100,108,116,124,134,141,149,156,164,162,154,145,137,129,117,98,75,50,27,0,7,30,52,77,100,118,129,137,146,155,163,163,156,148,140,132,123,115,107,99,91,83,76,68,60,51,40,22,5,0,0,0,13,36,58,81,104,124,150,171,147,124,101,79,81,103,129,150,169,147,121,100,78,55,33,10,0,0,20,43,63,83,103,121,132,141,152,161,148,134,116,99,83,65,48,30,11,0,0,0,8,30,52,73,92,112,134,154,157,139,119,123,143,161,148,129,107,88,67,47,25,3,0,0,0,0,0,0,0,0,0,11,23,32,35,35,35,35,35,31,22,9,0,0,0,0,0,0,3,26,50,73,97,121,145,168,164,140,114,117,142,166,147,121,98,100,124,149,170,147,121,109,134,157,170,147,121,98,75,51,28,4,0,0,0,0,0,0,0,5,28,50,73,96,118,142,165,167,143,119,96,116,140,163,165,142,118,96,73,50,28,5,0,0,0,0,7,30,52,78,100,118,119,119,119,119,119,119,119,137,162,160,134,119,119,119,119,119,119,119,117,98,75,50,27,0,0,20,40,58,74,84,92,100,107,115,123,132,140,148,156,164,165,156,148,139,132,121,113,104,95,83,66,43,22,0,2,24,46,68,85,96,105,114,121,132,140,149,157,166,163,155,147,139,132,121,114,106,99,91,83,73,58,38,17,0,0,0,22,45,67,90,113,136,159,162,139,116,93,70,73,95,117,141,164,155,134,109,87,64,42,19,0,0,19,41,61,81,99,118,139,158,153,143,130,115,100,85,69,52,36,18,0,0,0,0,12,35,58,80,103,124,146,159,141,121,105,109,124,144,159,141,119,98,75,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,67])
.concat([91,114,139,162,168,144,119,123,147,164,141,116,92,93,117,143,166,152,129,113,139,162,164,141,116,93,69,45,22,0,0,0,0,0,0,0,0,0,20,42,65,87,110,134,157,173,150,124,102,123,147,170,157,134,110,88,65,42,20,0,0,0,0,0,3,25,47,69,87,96,96,96,96,96,96,96,111,137,162,160,134,109,96,96,96,96,96,96,96,85,67,44,23,0,5,27,50,73,92,106,114,121,132,139,147,155,163,169,160,152,144,135,124,116,107,99,90,81,73,64,49,32,13,0,0,15,34,51,65,74,82,91,100,108,117,124,136,144,153,161,170,162,154,146,138,130,121,114,106,90,71,48,25,0,0,9,32,54,76,99,121,145,168,154,132,107,84,62,64,86,109,134,156,164,142,118,96,73,51,28,6,0,14,33,53,72,91,109,130,140,132,121,109,97,83,69,54,38,22,5,0,0,0,0,11,33,56,78,99,114,129,143,123,107,89,92,110,129,139,124,110,95,73,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,37,61,85,109,134,156,173,149,124,129,153,158,135,110,86,88,112,137,160,158,135,116,143,166,158,135,110,86,63,39,16,0,0,0,0,0,0,0,0,0,12,34,57,79,102,124,148,171,156,134,109,132,154,172,149,124,103,80,57,34,12,0,0,0,0,0,0,16,36,53,67,73,73,73,73,73,73,86,111,137,162,160,134,109,83,73,73,73,73,73,73,66,51,33,14,0,7,30,53,78,101,124,139,146,154,162,170,163,155,146,137,129,119,110,101,93,85,76,67,59,50,41,31,15,0,0,0,0,17,32,42,51,60,68,77,85,94,103,111,119,130,138,147,155,164,169,161,153,146,138,121,99,76,50,27,0,0,18,41,63,85,108,132,154,168,145,121,99,76,53,56,78,101,123,147,170,151,129,105,82,60,37,15,0,5,24,44,63,82,101,119,117,109,100,90,78,65,53,38,23,8,0,0,0,0,0,5,26,47,65,81,95,109,121,109,91,73,77,94,112,119,105,92,78,61,42,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,31,55,78,101,124,150,173,154,130,134,158,152,129,104,80,82,106,132,155,163,140,121,147,170,152,129,104,80,57,33,9,0,0,0,0,0,0,0,0,0,4,26,49,71,94,116,140,163,163,140,116,138,160,163,141,116,95,72,49,26,4,0,0,0,0,0,0,2,21,35,45,50,50,50,50,50,63,86,111,137,162,160,134,109,83,60,50,50,50,50,50,44,33,19,0,0,7,30,53,78,101,124,152,169,167,158,150,141,132,123,114,106,97,88,80,71,62,54,45,36,28,19,9,0,0,0,0,0,0,11,20,29,37,46,55,63,72,81,89,98,106,115,123,134,142,150,160,168,168,149,121,99,76,50,27,0,1,25,48,72,95,117,141,149,149,137,113,90,67,45,47,69,93,115,139,149,149,138,114,91,69,46,21,0,0,16,35,54,72,89,98,96,88,80,69,59,47,34,21,6,0,0,0,0,0,0,0,15,33,49,62,76,89,96,90,74,58,62,78,93,96,86,72,59,45,29,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,96,119,144,167,158,134,139,162,147,121,98,75,77,101,124,148,169,146,129,152,170,147,121,98,74,51,27,3,0,0,0,0,0,0,0,0,0,0,18,41,63,86,108,132,155,170,147,121,144,167,155,134,109,87,64,41,18,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,40,63,86,111,137,162,160,134,109,83,60,38,25,25,25,25,21,13,0,0,0,7,30,53,78,101,124,152,153,144,136,124,117,108,100,91,82,74,65,57,48,40,31,22,14,5,0,0,0,0,0,0,0,0,0,0,6,15,23,32,41,49,57,66,75,83,92,101,109,118,129,137,145,154,149,121,99,76,50,27,0,2,27,50,75,98,121,121,121,121,121,104,82,59,36,39,61,84,106,121,121,121,121,117,96,70,48,22,0,0,6,25,42,56,67,73,72,65,57,49,38,27,15,2,0,0,0,0,0,0,0,0,0,15,29,43,56,68,73,69,58,42,46,61,71,73,66,53,39,26,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,65,90,113,137,161,168,152,155,165,141,116,93,69,70,94,118,143,167,159,150,162,164,140,115,92,68,45,21,0,0,0,0,0,0,0,0,0,0,0,9,33,55,78,100,123,147,169,155,144,154,171,147,124,101,79,56,33,11,0,0,0,0,0,0,0,0,0,0,0,2,2,2,15,40,63,86,111,137,162,160,134,109,83,60,38,12,2,2,2,0,0,0,0,0,7,30,53,78,101,124,139,130,121,112,103,95,86,77,69,60,52,43,34,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,18,27,35,44,53,61,70,78,87,96,104,113,121,132,139,121,99,76,50,27,0,0,23,44,67,85,96,96,96,96,96,88,72,49,28,30,51,74,90,96,96,96,96,95,83,63,42,18,0,0,0,10,26,38,46,50,49,44,36,28,18,7,0,0,0,0,0,0,0,0,0,0,0,0,10,23,36,46,50,48,39,26,29,41,49,50,44,33,20,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,106,132,155,175,175,175,159,135,110,86,63,65,88,112,137,160,175,175,175,158,134,109,86,62,38,15,0,0,0,0,0,0,0,0,0,0,0,1,24,47,69,92,115,139,161,174,170,173,163,139,116,93,71,48,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,40,63,86,111,137,162,160,134,109,83,60,38,12,0,0,0,0,0,0,0,0,7,30,53,78,101,121,115,106,98,90,81,72,64,55,46,38,29,20,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,13,21,30,39,47,56,65,73,81,90,99,107,116,119,98,75,50,27,0,0,13,32,51,64,71,71,71,71,71,66,54,36,17,19,38,56,67,71,71,71,71,70,63,47,30,8,0,0,0,0,6,16,24,27,27,22,14,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,22,25,23,16,5,8,18,24,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,77,100,123,148,149,149,149,149,129,104,81,57,59,83,106,132,149,149,149,149,149,129,103,80,56,32,9,0,0,0,0,0,0,0,0,0,0,0,0,16,39,61,84,107,130,149,149,149,149,149,132,109,85,63,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,40,63,86,111,137,149,149,134,109,83,60,38,12,0,0,0,0,0,0,0,0,3,25,48,69,87,98,92,84,75,67,58,49,41,32,24,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,16,24,33,41,50,59,67,76,85,93,98,85,67,45,23,0,0,0,15,31,43,48,48,48,48,48,44,34,19,2,4,20,35,45,48,48,48,48,47,41,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,46,70,93,116,121,121,121,121,121,119,98,75,51,53,77,101,121,121,121,121,121,121,119,97,73,49,26,3,0,0,0,0,0,0,0,0,0,0,0,0,8,30,53,76,99,119,121,121,121,121,121,121,101,77,55,32,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,40,63,86,110,121,121,121,121,108,83,60,37,12,0,0,0,0,0,0,0,0,0,16,36,55,67,73,70,61,53,44,36,27,18,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,19,28,36,45,54,62,71,73,66,53,33,14,0,0,0,0,11,19,22,22,22,22,22,20,13,0,0,0,2,13,20,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,62,83,97,99,99,99,99,99,98,87,66,44,46,69,87,98,99,99,99,99,99,98,85,65,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,66,87,98,99,99,99,99,99,98,87,69,47,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,36,57,77,95,99,99,99,99,93,75,55,33,9,0,0,0,0,0,0,0,0,0,2,19,34,44,48,46,39,30,21,13,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,22,31,40,46,48,43,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,47,64,72,73,73,73,73,73,73,66,51,32,33,53,66,73,73,73,73,73,73,73,65,51,31,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,73,73,66,53,34,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,25,45,61,73,76,76,76,76,73,60,43,24,1,0,0,0,0,0,0,0,0,0,0,1,14,22,25,23,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,23,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,28,41,47,48,48,48,48,48,48,43,31,15,17,33,44,48,48,48,48,48,48,48,42,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,48,48,43,33,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,29,42,51,53,53,53,53,50,41,28,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,17,22,22,22,22,22,22,22,19,9,0,0,11,19,22,22,22,22,22,22,22,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,22,22,22,22,22,22,22,19,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,26,27,27,27,27,26,18,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,0,0,0,0,0,0,0,1,7,10,10,10,10,10,10,7,1,7,10,10,10,10,10,10,6,0,0,0,0,0,0,0,0,0,0,0,4,12,18,22,22,21,17,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,9,10,10,8,3,0,0,0,0,0,0,0,0,9,24,33,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,37,33,23,8,0,0,0,0,0,10,17,20,20,20,20,20,20,20,20,20,20,20,20,17,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,27,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,26,16,4,0,0,0,0,10,22,30,33,33,33,33,33,32,29,22,30,33,33,33,33,33,32,28,18,6,0,0,0,0,0,0,0,0,12,23,32,38,42,43,42,37,29,20,8,0,0,6,15,20,19,13,4,0,0,0,0,0,0,0,0,0,8,18,26,31,33,33,31,25,17,7,0,0,0,0,0,5,22,39,50,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,49,38,20,1,0,0,1,16,29,36,40,40,40,40,40,40,40,40,40,40,40,40,36,28,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,22,38,49,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,48,37,21,3,0,0,9,28,42,52,55,55,55,55,55,55,51,42,53,55,55,55,55,55,55,50,38,22,5,0,0,0,0,0,2,17,30,41,51,58,64,66,62,57,49,38,27,14,10,24,34,40,39,33,21,7,0,0,0,0,0,0,1,15,28,39,48,54,55,55,53,47,38,26,13,0,0,0,0,14,33,53,66,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,65,51,31,11,0,0,15,33,48,58,63,63,63,63,63,63,63,63,63,63,63,63,58,47,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,56,72,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,71,55,36,15,0,0,21,43,60,73,78,78,78,78,78,78,72,62,74,78,78,78,78,78,78,71,56,36,16,0,0,0,0,1,19,34,48,60,71,78,83,86,83,77,67,57,45,31,24,40,55,60,61,51,38,24,9,0,0,0,0,0,17,31,47,59,69,76,78,78,75,67,57,44,30,13,0,0,0,21,42,64,81,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,80,62,40,18,0,7,25,45,64,76,83,83,83,83,83,83,83,83,83,83,83,83,76,62,43,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,49,71,91,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,89,70,46,24,0,7,30,53,75,94,104,104,104,104,104,103,92,76,94,104,104,104,104,104,103,89,70,47,24,0,0,0,0,17,33,49,65,79,90,99,104,106,103,97,87,75,62,49,36,56,72,83,81,69,55,41,26,10,0,0,0,13,30,47,64,78,90,98,101,101,97,88,76,60,45,27,9,0,1,26,48,73,94,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,108,92,70,46,23,0,13,33,55,76,94,106,106,106,106,106,106,106,106,106,106,106,106,94,74,53,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,121,98,76,50,27,0,10,33,58,81,104,129,129,129,129,129,124,101,83,106,129,129,129,129,129,121,98,76,50,27,0,0,0,12,30,47,65,82,96,108,118,124,129,124,116,105,92,79,65,51,67,87,102,100,86,72,57,42,26,6,0,2,23,42,62,79,96,109,119,124,124,118,107,92,76,58,38,20,0,2,27,50,76,101,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,121,98,73,48,25,0,15,35,58,81,101,124,129,129,129,129,129,129,129,129,129,129,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,76,50,27,0,10,33,57,80,104,129,152,152,152,152,124,101,81,106,132,152,152,152,147,121,99,75,50,27,0,0,4,24,43,62,80,96,112,129,139,146,150,145,136,123,110,96,82,69,80,98,118,117,103,88,74,56,38,16,0,10,32,52,72,91,110,129,141,149,147,139,124,107,88,68,48,28,0,2,27,50,76,101,124,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,121,99,73,48,25,0,15,35,58,81,101,124,149,152,152,152,152,152,152,152,152,147,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,149,121,99,76,50,27,0,7,31,55,78,101,124,150,175,173,149,124,101,81,104,132,154,175,170,147,121,99,73,50,27,0,0,14,36,55,74,93,112,130,145,157,167,170,165,154,141,129,113,99,89,95,110,132,136,119,105,89,67,46,24,0,16,37,58,80,101,121,142,159,171,170,156,138,117,96,75,54,33,0,2,27,50,76,101,124,152,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,149,121,99,73,48,25,0,15,35,58,81,101,124,149,167,167,167,167,167,167,167,167,147,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,139,139,139,139,139,139,139,139,139,139,139,139,139,139,139,139,139,139,121,99,76,50,27,0,7,30,53,77,101,124,149,174,172,149,124,101,81,104,129,153,177,170,147,121,97,73,50,27,0,0,23,46,66,87,107,124,144,162,158,150,149,153,164,159,145,132,117,110,113,124,144,152,137,121,98,75,50,27,0,20,40,63,83,106,129,149,170,191,188,166,145,121,100,78,55,35,0,2,27,50,76,101,124,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,99,73,48,25,0,15,35,58,81,101,124,147,147,147,147,147,147,147,147,147,147,121,101,78,55,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,52,77,98,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,113,96,74,49,27,0,6,30,53,76,101,124,149,172,172,149,124,99,80,104,129,152,175,170,147,119,96,73,50,25,0,4,27,52,75,98,117,139,158,157,141,130,129,135,146,160,162,148,137,132,134,144,159,155,137,116,96,73,49,26,0,20,40,63,83,106,129,149,170,190,187,166,144,121,100,78,55,35,0,2,27,50,75,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,25,0,15,35,58,80,101,121,121,121,121,121,121,121,121,121,121,121,119,101,78,55,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,23,45,65,81,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,80,63,42,20,0,5,29,53,76,99,121,147,171,170,147,121,99,78,101,129,151,174,167,144,119,96,73,48,25,0,4,27,52,75,98,119,136,149,143,123,109,106,115,129,143,156,166,156,152,154,162,159,143,123,104,84,64,43,21,0,16,37,58,79,100,121,141,159,169,168,155,138,116,96,75,54,33,0,0,25,47,71,92,103,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,103,90,68,45,22,0,11,32,53,73,91,101,101,101,101,101,101,101,101,101,101,101,101,89,71,51,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,31,49,60,65,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,65,59,47,29,10,0,4,27,50,73,96,119,144,168,167,144,119,96,76,99,123,148,171,165,142,116,93,70,47,24,0,1,24,47,69,87,103,116,132,129,109,92,86,97,110,124,139,152,161,165,163,155,143,124,109,91,72,52,33,13,0,10,31,51,72,91,109,129,140,147,147,138,123,106,87,67,48,27,0,0,19,40,61,79,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,77,59,38,17,0,5,23,43,60,72,78,78,78,78,78,78,78,78,78,78,78,78,72,58,41,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,32,51,63,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,62,49,30,11,0,1,24,47,71,93,116,142,165,165,142,116,93,73,96,121,145,168,162,139,114,91,67,44,21,0,0,16,37,56,72,86,99,114,117,96,77,66,79,93,107,119,134,141,144,142,136,123,109,94,76,59,40,21,1,0,2,22,41,61,78,94,108,118,121,121,117,107,91,75,57,38,19,0,0,11,30,49,63,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,62,47,28,9,0,0,12,30,43,53,58,58,58,58,58,58,58,58,58,58,58,58,52,41,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,24,46,67,83,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,82,64,43,21,0,0,22,45,68,91,114,139,162,162,139,114,91,71,93,117,142,165,160,137,111,88,64,41,18,0,0,5,24,40,55,69,83,97,98,85,65,49,62,76,90,103,113,119,121,121,115,105,93,78,62,46,27,9,0,0,0,11,30,47,62,77,88,97,99,99,96,87,74,60,44,26,8,0,0,2,19,35,46,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,33,17,0,0,0,0,12,24,32,35,35,35,35,35,35,35,35,35,35,35,35,32,23,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,52,77,99,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,115,97,75,50,27,0,0,19,42,65,88,111,137,160,160,137,111,88,68,91,114,139,162,157,134,109,86,61,38,15,0,0,0,9,24,38,52,67,77,78,68,53,34,45,59,72,84,93,99,101,101,95,87,75,62,47,30,13,0,0,0,0,0,15,31,45,58,67,75,76,76,74,66,56,43,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,99,76,50,27,0,0,16,39,63,86,109,134,157,157,134,109,85,66,88,112,137,160,154,130,106,83,58,35,12,0,0,0,0,7,21,36,48,57,57,50,38,21,28,42,54,65,73,78,81,80,75,67,57,45,31,15,0,0,0,0,0,0,0,14,27,38,46,52,53,53,52,45,37,25,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,99,76,50,27,0,0,13,36,60,83,106,132,154,154,132,106,82,63,86,109,134,157,152,124,103,80,55,32,9,0,0,0,0,0,5,18,30,36,37,32,21,6,11,24,36,45,53,58,58,58,54,48,38,27,14,0,0,0,0,0,0,0,0,0,7,17,24,29,30,30,29,24,16,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,76,50,27,0,0,10,34,57,81,104,129,147,147,129,103,80,60,83,106,132,147,147,121,100,77,53,30,7,0,0,0,0,0,0,0,9,16,14,12,4,0,0,6,17,26,33,37,38,38,34,28,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,50,27,0,0,8,31,55,78,101,121,121,121,121,101,77,58,80,103,121,121,121,117,97,73,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,26,48,69,89,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,45,24,0,0,4,26,48,71,89,98,99,99,98,87,69,51,73,90,99,99,99,98,85,66,44,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,37,55,70,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,75,69,53,35,14,0,0,0,17,37,55,70,76,76,76,76,69,55,40,56,71,76,76,76,75,67,53,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,36,46,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,35,19,2,0,0,0,4,22,37,48,53,53,53,53,48,37,24,38,49,53,53,53,52,47,34,19,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,15,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,14,2,0,0,0,0,0,3,16,24,27,27,27,27,24,15,6,17,25,27,27,27,27,23,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,154,93,117,48,0,0,0,0,68,82,81,33,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,154,93,117,48,1,0,0,0,182,254,83,77,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,99,12,0,0,0,0,0,0,154,93,117,48,2,0,0,0,34,209,90,249,8,88,76,41,52,49,54,53,12,22,105,7,222,187,56,253,190,184,84,160,31,159,234,101,54,56,69,238,157,220,47,247,78,247,95,168,60,126,113,174,50,246,252,251,233,206,231,243,224,252,255,255,175,96,97,166,44,152,2,0,231,243,127,41,0,166,166,226,0,171,178,42,91,233,86,10,192,85,192,241,255,255,255,175,62,64,79,77,77,77,89,200,212,148,21,14,19,50,119,69,237,84,162,51,91,79,182,131,126,119,186,164,149,204,247,96,199,158,95,169,250,168,135,158,11,55,99,211,116,115,55,134,129,238,97,24,122,88,44,90,94,94,182,1,184,247,182,225,198,133,31,10,0,112,251,198,156,168,89,94,94,94,182,1,224,170,116,94,35,192,204,84,28,46,97,137,206,80,146,64,167,243,125,252,0,156,7,10,129,51,167,106,132,103,59,247,104,55,216,3,0,124,216,41,199,37,180,153,164,26,216,151,36,0,26,63,115,172,103,85,94,174,40,163,253,45,101,138,169,192,158,165,31,167,97,174,39,206,158,138,71,40,194,43,227,26,176,233,10,46,161,65,81,0,5,252,8,154,137,108,253,153,188,192,118,5,38,65,183,69,153,135,252,10,124,106,139,231,91,166,136,176,38,17,103,63,9,10,185,52,141,148,58,117,101,156,130,61,51,38,36,128,166,193,164,72,188,0,200,105,129,168,250,3,1,42,65,247,177,228,32,223,149,95,139,222,107,107,153,34,216,221,157,186,255,26,68,222,174,226,98,11,15,180,36,33,147,86,103,66,66,17,56,208,41,60,27,235,10,64,25,43,40,27,7,203,50,154,56,34,67,47,205,8,250,119,224,3,146,35,200,148,81,23,251,25,103,54,246,210,58,205,198,206,174,138,27,54,135,7,46,225,37,128,173,98,51,154,208,231,24,76,168,210,220,226,253,184,212,193,4,0,34,77,191,36,2,128,7,128,1,192,37,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,148,200,154,66,0,0,0,0,122,220,145,112,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,148,200,154,66,1,0,0,0,53,8,47,113,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,168,11,0,0,0,0,0,0,148,200,154,66,2,0,0,0,198,212,148,84,7,82,70,37,58,55,56,55,26,119,253,190,162,234,221,1,5,243,171,82,37,154,51,90,85,133,183,16,83,110,50,183,60,127,194,220,207,188,9,89,201,255,77,177,23,242,239,191,58,37,159,143,128,213,127,82,96,239,116,149,175,187,10,236,91,241,9,88,25,194,158,211,125,34,240,231,183,192,4,205,16,26,128,127,157,138,99,207,5,0,46,127,7,83,238,110,29,223,88,69,47,222,234,133,83,112,226,148,246,116,233,251,200,225,88,244,89,78,81,179,104,50,39,65,77,127,95,88,230,241,22,129,214,249,241,148,93,224,147,186,232,0,0,230,252,36,41,233,153,240,120,139,10,36,160,75,141,220,65,21,38,121,168,112,90,146,203,236,174,80,45,192,1,116,0,128,183,76,93,219,100,217,18,171,214,91,196,37,189,123,111,121,190,8,153,162,6,34,67,78,71,111,234,245,240,229,110,63,100,170,5,200,55,64,85,151,10,239,229,202,238,7,9,147,186,253,120,34,54,13,165,79,82,7,18,198,102,35,241,35,128,9,160,61,128,51,100,7,33,161,41,190,32,21,0,34,63,155,169,95,78,228,165,110,25,86,176,93,243,173,50,99,98,72,93,241,230,73,23,109,29,59,129,77,65,166,178,149,206,73,83,17,36,152,5,135,93,118,19,120,120,222,4,78,12,171,0,72,152,0,38,65,139,111,182,206,94,230,236,246,173,109,61,223,170,44,216,136,155,23,35,190,57,117,226,228,121,37,59,112,114,165,156,122,179,131,4,203,123,96,130,9,64,40,194,207,2,160,205,49,152,92,114,1,19,0,34,61,107,89,31,162,189,234,60,147,101,57,138,42,138,19,102,238,198,117,77,78,243,108,34,30,73,20,222,1,42,69,139,15,0,118,27,96,23,92,21,128,117,21,216,0,176,65,106,183,234,128,171,50,1,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,43,169,18,94,0,0,0,0,143,205,81,80,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,43,169,18,94,1,0,0,0,225,242,135,166,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171])
.concat([174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,103,15,0,0,0,0,0,0,43,169,18,94,2,0,0,0,179,176,191,219,9,80,60,65,70,54,62,63,65,63,166,87,131,115,34,76,85,155,249,90,124,70,155,11,0,133,19,94,116,190,177,108,215,236,213,124,249,109,249,55,210,165,13,109,105,66,91,195,121,107,152,27,254,137,249,48,194,224,198,4,43,252,77,254,224,3,123,175,160,27,164,3,140,24,255,199,199,129,139,115,43,63,143,252,193,132,120,95,7,0,170,105,179,177,221,193,197,38,22,243,41,147,179,10,83,61,79,215,161,48,242,241,116,231,164,25,245,98,81,243,74,230,224,234,65,71,238,110,177,208,209,20,40,29,128,175,224,225,1,153,147,135,100,87,61,68,102,157,25,0,162,107,123,82,197,64,7,150,213,38,16,0,69,229,172,87,75,250,228,125,215,104,99,101,59,54,137,148,77,52,73,52,236,136,86,23,225,196,237,155,66,87,160,152,96,27,4,36,66,209,125,58,19,83,44,230,151,11,224,18,74,221,78,40,0,118,93,163,245,19,197,119,181,153,179,61,159,166,156,238,123,212,197,243,245,245,84,154,235,163,153,227,70,221,63,156,96,46,45,225,234,153,42,81,100,207,7,14,176,33,179,21,66,45,127,76,160,224,14,224,166,118,179,231,204,154,212,126,41,212,178,73,19,17,5,126,87,3,106,177,232,167,98,124,167,174,106,27,64,21,3,18,37,236,140,74,203,90,177,239,79,164,173,105,115,178,148,39,56,50,149,194,231,209,1,18,58,32,65,232,66,185,2,64,118,158,214,244,6,78,67,130,149,229,20,100,70,114,126,213,38,32,28,168,234,163,38,222,152,245,188,71,253,234,48,60,201,48,161,158,161,149,93,168,214,163,204,174,217,253,119,116,133,61,26,80,165,128,249,37,144,8,144,15,14,136,182,177,227,233,0,66,63,142,84,57,69,61,35,185,190,249,84,38,251,229,148,206,205,103,143,249,110,76,245,116,83,248,125,198,38,222,162,216,130,255,234,128,203,61,157,109,53,44,102,106,20,195,93,55,197,233,128,84,253,2,232,144,225,53,211,128,84,0,46,67,198,248,91,163,244,92,181,229,27,157,2,24,12,169,114,246,227,26,253,23,63,241,164,105,199,199,107,21,97,231,83,119,104,38,31,76,138,114,165,124,1,237,193,77,15,230,98,61,0,208,144,178,247,251,197,96,138,235,81,219,68,107,36,30,67,93,240,219,141,7,138,247,160,200,124,97,92,161,135,151,175,188,114,254,124,222,124,117,183,95,86,173,7,79,18,244,242,250,157,55,184,202,242,189,3,79,141,225,53,230,15,5,96,209,102,17,236,106,176,193,170,3,187,26,32,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,243,86,40,29,0,0,0,0,249,180,77,151,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,243,86,40,29,1,0,0,0,230,234,214,44,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,158,91,0,0,0,0,0,0,243,86,40,29,2,0,0,0,146,113,193,4,47,65,58,53,62,56,63,64,57,61,60,59,66,58,58,54,61,61,55,54,65,64,54,57,62,60,60,60,60,63,62,62,62,54,56,71,56,58,59,58,56,58,62,57,53,54,57,33,30,67,199,52,99,152,79,205,119,172,131,212,78,71,183,20,232,169,120,238,118,124,184,160,242,235,199,212,215,161,122,174,183,99,38,205,93,202,22,99,92,121,108,193,140,76,80,95,79,165,241,26,0,240,75,11,74,135,6,237,34,130,10,152,15,34,65,71,84,98,190,223,157,223,255,230,234,169,10,212,117,204,251,239,127,215,46,206,81,247,63,242,175,77,2,221,170,84,166,44,200,227,16,128,155,13,246,78,65,38,116,224,255,97,2,64,120,82,57,134,191,163,1,30,65,11,243,54,21,124,186,210,25,95,239,158,103,68,101,244,52,124,117,252,253,64,49,42,123,132,251,241,190,148,151,152,238,150,3,227,130,60,18,88,3,212,58,1,143,7,52,207,233,18,76,0,34,73,59,228,143,137,27,249,90,4,171,43,225,50,196,52,15,223,251,157,199,117,14,179,135,186,91,86,136,228,64,219,20,216,112,163,2,114,177,105,6,166,9,136,169,140,20,119,133,213,115,160,179,201,201,79,137,190,14,189,0,0,30,65,103,238,135,86,189,139,243,87,241,26,213,83,166,12,59,221,220,24,121,165,106,186,153,10,67,245,2,95,85,3,152,75,181,181,131,165,81,134,97,202,6,240,240,224,36,9,2,128,216,6,154,226,58,0,34,69,59,136,67,153,238,40,58,175,106,174,30,84,25,234,233,127,247,238,141,63,34,167,241,45,154,182,39,183,220,63,36,229,111,1,190,225,73,137,64,3,90,169,67,170,131,230,129,197,50,16,120,10,176,177,209,133,174,41,117,20,0,34,67,155,196,83,162,94,102,205,172,186,180,250,80,101,136,33,123,56,171,186,116,24,118,231,192,226,186,42,206,54,88,229,17,35,60,245,90,140,192,253,238,23,97,2,22,174,164,163,56,217,129,119,166,135,89,55,29,219,36,239,36,5,0,30,65,59,101,128,249,156,149,57,137,234,169,10,78,23,242,220,118,229,255,206,198,198,99,238,101,186,133,182,162,230,76,40,94,156,0,70,21,227,195,67,78,160,14,80,128,149,144,10,116,96,178,17,219,104,36,9,30,67,183,220,79,102,122,87,113,46,71,164,234,41,83,134,30,170,170,76,211,111,11,49,118,83,104,249,58,133,141,148,102,127,204,85,32,109,35,27,164,2,154,32,231,186,144,0,95,26,208,72,108,90,100,202,152,52,83,155,0,30,71,107,226,209,29,1,169,243,31,91,66,147,201,205,241,251,197,112,238,197,221,179,232,227,241,93,99,105,234,111,65,186,25,153,128,88,53,1,240,131,64,89,208,17,104,179,232,174,40,64,160,115,252,184,150,110,65,2,0,34,65,59,240,81,65,24,85,217,213,173,26,213,147,168,12,89,23,199,190,58,30,57,63,184,59,213,245,61,91,93,235,196,44,20,49,161,51,93,206,170,67,195,18,241,10,2,192,41,40,240,196,129,99,138,162,11,4,0,30,69,163,50,60,205,101,210,52,35,171,90,8,248,34,145,76,57,99,189,242,52,21,215,243,127,186,212,244,79,172,108,229,198,241,83,100,180,83,216,83,210,22,0,108,184,2,45,14,18,5,124,208,37,221,96,93,69,204,197,249,2,106,33,104,0,30,67,39,240,231,194,188,139,91,71,245,160,68,134,13,243,22,190,186,124,182,7,99,99,47,231,80,203,150,21,85,234,248,188,174,177,77,41,60,33,211,124,38,58,1,101,196,10,19,29,224,107,26,3,92,89,194,3,30,71,131,240,180,153,117,148,93,223,84,11,60,97,40,32,202,48,75,181,79,172,110,191,136,248,93,124,103,249,176,111,58,27,5,109,11,199,228,247,88,91,131,76,82,158,154,206,113,104,223,81,76,173,244,84,223,1,30,63,11,243,177,171,231,53,42,91,251,203,205,199,64,20,236,60,31,244,43,103,211,205,229,11,133,46,214,242,171,94,210,151,103,155,45,31,4,104,246,63,131,219,196,196,19,92,7,52,164,3,156,6,30,67,131,73,4,85,79,34,66,213,139,42,99,63,191,190,55,237,211,216,248,80,136,227,250,109,103,190,199,160,86,210,192,114,85,202,32,192,210,136,254,39,240,9,88,169,80,40,30,0,60,19,60,239,194,182,116,51,157,11,36,34,67,139,241,232,111,167,234,154,102,196,213,147,168,12,169,62,174,28,206,142,191,250,237,55,38,133,35,141,172,210,62,77,193,229,226,120,156,98,213,51,128,196,240,229,186,96,237,161,232,14,231,129,214,94,83,243,219,10,130,0,34,63,139,186,31,85,60,83,215,228,194,213,3,84,198,92,200,207,143,241,243,251,226,85,103,145,234,173,86,96,195,80,254,66,5,16,177,210,42,1,97,210,135,160,81,159,128,226,145,192,99,130,84,26,0,30,73,131,240,246,206,14,148,205,48,31,3,81,134,222,252,253,92,159,134,247,221,186,207,38,73,173,5,40,12,222,235,127,48,4,244,206,92,46,33,139,162,37,52,29,253,94,215,68,234,161,123,19,0,30,67,131,241,167,179,80,229,41,129,189,168,156,177,187,19,199,79,199,175,234,219,217,241,139,202,154,214,210,230,134,222,123,238,81,192,192,152,178,186,2,172,172,74,32,152,157,39,209,117,116,104,76,20,159,183,108,210,39,180,9,129,19,5,0,30,67,11,113,199,67,140,147,50,194,124,81,101,166,41,206,70,230,241,225,58,118,231,255,142,207,247,196,90,2,191,22,220,28,7,115,43,157,129,183,185,110,55,80,243,53,32,223,30,224,215,82,96,2,38,116,164,158,186,194,13,123,30,0,30,63,35,186,191,224,125,44,200,59,152,109,173,206,25,83,208,211,181,116,177,106,228,160,174,71,142,195,39,90,136,73,11,133,22,9,0,109,65,101,140,5,96,90,108,58,139,25,5,64,64,7,9,5,30,67,131,243,35,170,50,201,59,41,213,3,147,9,60,222,215,97,252,244,60,118,115,188,133,41,208,182,61,175,64,151,90,141,41,247,59,6,174,81,20,208,230,48,166,29,2,188,4,83,196,155,58,234,237,19,9,30,67,157,243,39,80,186,74,141,5,170,115,85,70,12,109,184,55,234,163,190,110,79,187,193,145,3,18,151,183,203,195,252,82,113,139,64,239,164,193,111,1,102,225,245,28,206,142,218,31,8,157,3,52,105,68,119,127,114,9,208,1,30,63,29,115,15,132,80,149,25,147,249,84,101,236,195,180,103,59,86,241,200,249,249,90,187,61,47,193,206,29,126,160,142,182,131,46,171,88,12,35,144,126,130,12,28,96,162,32,12,116,69,97,44,230,118,212,184,14,116,0,30,63,233,144,164,250,202,35,232,167,233,68,245,84,101,56,253,25,226,69,233,246,230,203,180,117,120,235,52,7,90,40,113,64,190,95,49,255,202,76,34,91,186,2,1,0,199,53,29,6,106,99,38,4,240,18,56,76,64,0,30,65,141,120,251,108,46,179,114,102,93,171,122,74,148,209,155,245,88,244,81,133,57,230,99,242,165,78,106,45,137,101,65,75,11,54,251,54,234,12,224,26,115,163,67,221,134,11,2,207,50,144,0,208,181,81,133,138,212,0,26,65,3,88,4,241,12,242,132,11,206,167,42,35,43,135,155,170,63,191,20,42,211,28,251,91,60,199,133,215,175,186,175,77,194,76,115,116,83,1,90,133,178,63,14,48,113,148,158,80,132,73,155,64,247,33,120,144,201,1,34,67,51,242,52,45,180,160,57,199,232,245,207,0,34,65,145,41,67,236,75,251,44,253,100,247,88,35,202,217,94,166,35,225,86,97,250,68,160,135,6,50,195,117,0,240,151,45,184,67,165,105,160,192,77,146,55,251,212,154,230,36,0,34,67,99,240,180,137,26,147,210,223,91,50,103,72,68,2,173,68,134,69,182,30,125,54,109,28,41,116,14,140,105,43,36,226,180,63,194,87,81,194,43,4,88,94,142,212,29,30,232,192,122,1,29,201,127,194,63,22,173,36,16,0,34,65,165,137,233,46,159,170,116,224,232,231,234,169,202,232,28,234,226,247,249,113,121,154,206,134,250,160,237,49,175,80,204,112,239,239,96,138,167,77,144,139,27,58,241,199,68,131,14,46,1,56,164,110,171,244,248,69,116,37,77,0,30,67,107,230,209,218,156,93,190,248,250,211,150,106,50,118,168,174,120,247,236,206,28,195,223,87,174,59,108,136,171,232,154,54,114,68,255,2,212,232,228,100,6,32,65,96,31,144,10,33,1,70,53,83,189,32,96,249,19,48,167,0,34,67,71,151,228,226,218,14,169,203,76,96,62,37,10,54,122,99,158,239,252,188,92,30,203,203,145,5,146,111,217,252,130,165,14,238,87,192,58,55,5,240,192,153,208,12,191,2,96,2,133,215,249,14,30,65,35,46,164,106,142,63,223,99,219,213,219,160,12,167,74,59,254,163,183,21,38,70,191,243,24,254,228,134,185,35,167,152,211,16,0,240,117,224,247,60,1,72,0,19,202,67,143,239,40,5,232,208,38,0,30,63,235,202,143,110,87,228,167,43,157,123,175,149,39,227,172,234,160,190,29,59,59,213,47,203,251,85,101,28,212,195,0,195,176,49,12,156,109,126,49,36,45,190,8,25,108,151,77,48,193,30,188,103,194,14,166,0,20,112,73,36,50,21,187,21,231,82,231,1,52,30,69,139,182,113,65,33,102,73,86,11,62,0,73,136,50,42,213,232,214,20,79,104,242,196,64,189,247,108,211,238,182,205,56,136,209,209,179,137,165,10,9,140,204,158,16,193,203,19,156,16,39,187,159,56,0,34,63,103,40,49,147,5,222,199,93,195,170,158,170,140,13,31,151,143,199,63,210,53,139,123,37,249,6,234,156,103,13,156,119,201,80,38,41,175,128,54,172,0,202,22,140,41,32,93,6,56,61,30,30,224,16,208,0,30,67,107,29,169,34,74,76,59,86,170,158,202,100,236,29,231,238,31,169,48,151,175,117,84,22,27,84,124,158,180,182,16,180,136,38,43,198,142,175,80,8,11,72,192,222,133,11,0,158,34,28,208,168,56,190,208,208,0,34,67,71,237,71,85,38,45,119,192,173,154,87,79,198,148,33,179,120,156,227,247,238,220,222,206,195,188,209,240,218,96,176,211,184,92,164,207,123,0,202,18,86,207,3,223,139,2,31,2,116,64,72,1,125,106,166,4,30,67,59,234,38,33,90,126,57,116,44,109,169,76,198,240,124,248,242,252,248,244,92,70,236,226,117,107,189,32,178,169,7,153,252,169,98,103,13,10,9,156,163,208,20,0,65,23,8,232,110,94,157,41,76,0,30,67,151,36,35,208,62,113,78,23,243,169,114,160,211,88,207,95,242,118,182,67,165,80,9,113,87,38,167,231,226,212,134,8,83,151,160,112,128,163,195,23,133,58,138,7,71,59,114,150,54,153,97,42,26,88,59,0,30,63,107,90,16,65,224,81,205,207,0,77,0,37,153,50,170,218,126,82,175,253,186,126,138,26,191,219,49,135,146,67,251,20,120,253,138,29,184,222,43,93,127,41,72,43,228,47,40,129,4,66,190,84,20,166,148,78,75,112,144,0,30,67,87,225,193,244,113,200,83,84,79,166,50,92,135,249,120,190,253,118,158,6,117,215,191,167,42,194,65,4,137,219,110,68,205,158,91,145,64,0,178,133,99,46,102,55,21,0,19,188,5,25,148,104,154,9,0,30,69,119,50,3,18,3,103,79,183,235,84,101,206,206,217,210,231,124,173,151,128,244,182,140,189,49,4,99,120,208,134,41,112,170,165,11,60,120,137,152,4,104,30,4,22,250,211,213,51,27,19,0,30,67,87,92,0,152,56,152,175,82,101,88,117,189,197,82,82,215,187,217,251,93,248,82,100,143,117,212,163,15,15,148,5,86,81,232,88,193,1,228,36,142,83,64,131,7,29,214,168,169,23,5,77,2,34,67,143,60,129,46,157,7,90,69,149,161,84,135,235,89,221,0,101,222,68,124,222,184,200,188,12,217,189,189,75,179,198,81,128,130,19,211,182,166,200,58,126,61,133,137,99,206,20,93,54,85,108,211,67,242,0,34,75,95,150,48,30,224,17,131,168,98,189,195,58,169,194,184,96,3,96,40,48,6,184,12,92,130,13,176,135,151,240,1,0,0,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,118,101,99,50,32,112,111,115,32,61,32,118,116,120,99,111,111,114,100,46,120,121,59,32,103,108,95,80,111,115,105,116,105,111,110,46,120,121,32,61,32,112,111,115,32,42,32,50,46,48,32,45,32,118,101,99,50,40,49,46,48,44,32,49,46,48,41,59,32,103,108,95,80,111,115,105,116,105,111,110,46,122,32,61,32,48,46,48,59,32,103,108,95,80,111,115,105,116,105,111,110,46,119,32,61,32,49,46,48,59,32,125,0,0,0,0,0,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,117,110,105,102,111,114,109,32,98,111,111,108,32,112,111,114,116,114,97,105,116,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,105,102,32,40,109,111,100,40,112,111,114,116,114,97,105,116,32,63,32,103,108,95,70,114,97,103,67,111,111,114,100,46,120,32,58,32,103,108,95,70,114,97,103,67,111,111,114,100,46,121,44,32,50,46,48,41,32,60,32,49,46,48,41,32,123,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,48,46,48,44,32,48,46,48,44,32,48,46,48,44,32,48,46,55,54,41,59,32,125,32,101,108,115,101,32,123,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,48,46,48,44,32,48,46,48,44,32,48,46,48,44,32,48,46,54,53,41,59,32,125,32,125,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,230,225,19,37,0,0,0,0,104,207,40,104,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,230,225,19,37,1,0,0,0,212,83,136,65,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13])
.concat([89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,254,94,0,0,0,0,0,0,230,225,19,37,2,0,0,0,249,124,150,171,49,72,42,45,44,44,35,33,32,31,33,40,42,42,46,41,37,38,35,35,32,34,39,35,33,35,44,37,36,35,35,40,32,32,32,35,35,37,36,37,32,34,32,36,36,40,39,41,47,26,42,125,180,22,167,101,61,153,20,224,41,176,90,44,50,64,155,164,241,0,180,9,24,90,45,255,127,151,239,221,119,188,211,101,9,80,217,178,52,147,248,109,179,63,234,15,214,151,166,126,182,54,241,162,195,117,2,224,199,7,224,62,169,69,128,125,0,220,183,210,6,0,78,125,176,18,95,151,207,103,220,125,151,50,94,134,122,12,0,9,134,3,128,1,64,5,72,132,181,79,0,136,4,248,165,67,74,208,101,0,64,0,149,1,78,111,55,169,36,63,255,127,251,95,235,77,91,196,127,27,97,180,1,28,0,42,0,149,6,160,237,212,105,223,103,240,50,219,198,144,0,40,216,16,224,181,238,35,0,78,109,135,168,95,219,27,188,255,103,85,154,127,43,151,159,159,0,240,0,97,180,1,12,0,42,40,72,230,56,2,128,169,4,48,203,208,0,80,48,12,232,114,1,78,103,219,166,122,174,96,181,255,190,145,95,153,116,247,255,9,0,26,4,52,48,7,194,18,53,239,17,224,84,18,88,110,24,92,192,195,0,176,11,108,9,0,0,94,111,5,105,255,237,92,241,36,209,81,215,198,59,13,4,24,144,189,103,151,191,2,192,30,0,46,36,0,208,1,176,195,37,0,94,113,154,182,239,119,219,197,18,95,249,145,48,184,104,32,192,0,57,101,187,68,128,171,195,72,0,0,131,0,88,67,2,94,101,84,214,219,187,91,72,106,101,102,163,129,64,5,136,28,182,135,10,1,102,18,175,19,0,152,0,216,65,2,0,90,97,90,54,215,211,77,146,100,171,163,217,104,32,192,0,17,83,61,124,5,72,226,39,0,96,2,160,67,29,0,62,87,5,20,251,110,83,72,122,163,99,167,54,42,4,24,72,245,44,79,23,79,224,244,25,151,31,112,0,88,195,248,0,38,79,171,164,184,119,110,125,238,1,236,87,64,107,126,41,73,208,64,5,88,80,238,254,183,6,44,20,2,108,53,96,28,192,40,0,182,135,92,0,34,79,171,180,60,183,215,243,119,119,192,254,92,168,77,241,237,84,4,160,2,189,243,217,112,234,143,115,244,2,125,0,104,13,176,15,128,127,4,78,14,0,34,77,83,237,191,159,252,243,143,171,233,248,253,198,123,17,112,6,6,149,187,27,123,118,42,49,23,174,14,67,3,140,1,0,150,248,19,35,60,29,117,0,34,101,189,194,240,95,238,119,39,111,208,177,189,252,98,35,136,0,134,179,249,242,113,213,52,245,157,251,77,118,199,172,128,113,0,27,2,0,76,229,2,248,42,148,113,0,34,97,147,218,135,119,240,127,223,247,102,58,126,91,62,115,2,128,0,65,4,208,193,144,18,19,1,230,32,49,36,96,24,0,224,0,176,254,254,1,20,34,79,23,33,147,143,203,127,252,223,117,57,48,169,96,179,170,69,16,128,10,88,61,108,28,31,4,58,21,212,0,29,0,219,33,1,0,30,93,219,220,167,45,47,191,125,175,229,142,73,109,217,251,255,4,128,1,65,0,24,138,118,165,210,19,96,86,33,1,91,0,120,0,117,0,42,89,7,105,246,156,161,246,190,215,42,29,17,42,140,108,84,4,128,65,170,123,245,115,53,32,23,3,0,140,1,224,29,95,0,50,77,125,18,199,174,181,125,175,85,249,37,104,102,163,34,0,21,176,12,217,143,203,192,55,7,21,1,29,0,31,199,105,30,0,50,73,125,136,237,105,51,238,123,22,125,44,72,109,84,4,128,1,180,254,62,14,40,69,21,96,1,0,31,129,241,1,46,73,145,251,229,221,77,187,147,179,126,36,228,109,84,72,192,0,45,250,249,16,120,21,24,16,208,0,176,4,7,248,10,0,30,73,53,137,235,238,15,119,75,166,245,43,173,134,141,32,16,84,208,243,170,175,215,83,241,215,192,171,10,3,128,6,128,255,97,2,102,101,0,34,63,117,200,202,83,59,243,238,37,117,164,211,177,81,33,192,64,204,41,134,227,187,128,92,180,14,176,7,0,86,146,245,40,0,34,69,158,197,118,55,60,247,221,77,48,119,51,27,21,2,12,180,186,200,99,182,34,95,24,16,48,8,128,125,244,81,0,34,69,5,73,237,254,225,97,178,87,150,205,189,17,12,128,129,218,16,155,67,89,194,233,9,67,2,70,0,224,195,37,81,5,0,34,67,133,204,252,110,188,87,178,219,117,250,159,90,132,8,36,200,169,231,84,223,95,217,81,225,199,80,3,0,110,8,0,126,207,147,78,162,25,167,86,227,3,0,34,87,149,117,251,167,246,227,62,109,154,85,134,189,8,2,80,193,48,12,195,48,12,253,124,51,5,124,5,67,2,58,0,222,32,130,202,34,85,181,245,201,127,254,159,201,187,214,145,173,6,207,70,69,0,24,108,88,156,29,77,112,227,193,80,13,80,0,240,197,254,158,3,34,75,189,156,217,25,254,175,100,223,233,250,42,168,52,112,2,128,4,65,0,24,192,240,84,2,167,2,42,128,9,128,23,84,0,34,83,125,148,141,237,245,243,73,206,226,40,169,160,226,96,19,2,12,214,194,229,231,4,179,20,128,31,26,96,13,128,15,212,0,34,77,43,73,251,189,194,235,78,178,245,35,81,243,255,78,69,68,80,1,220,57,127,210,175,3,64,151,1,21,0,11,0,0,159,128,0,102,159,1,34,67,21,43,247,217,48,118,50,205,99,83,102,81,65,37,96,160,173,206,61,154,224,171,168,6,128,23,30,240,67,1,34,65,145,21,249,105,123,172,59,139,19,92,84,72,192,0,185,246,58,146,224,107,232,19,160,3,96,135,79,192,120,0,34,65,85,217,58,159,134,149,73,54,214,99,110,2,34,42,96,40,133,175,162,10,128,13,18,32,92,34,205,147,4,0,34,65,185,108,174,187,205,206,164,90,29,185,139,65,133,132,48,116,13,175,145,12,39,129,202,128,14,128,53,214,0,19,80,3,0,34,65,197,186,57,238,192,84,146,139,181,151,157,110,4,10,6,136,197,72,130,89,138,113,0,195,0,216,129,2,30,204,188,26,0,34,63,126,168,142,51,200,76,210,172,219,242,240,34,80,25,0,186,34,112,13,85,192,32,0,214,85,128,226,121,20,244,48,165,0,215,0,34,71,126,40,247,187,146,36,19,142,73,74,190,8,100,50,128,164,15,19,92,162,6,24,4,192,14,116,208,53,93,131,2,170,174,0,34,67,20,37,255,213,70,187,187,85,84,188,122,163,66,128,14,116,204,67,189,243,209,108,80,73,84,0,72,0,191,231,29,60,224,198,56,34,69,88,22,234,147,223,118,103,25,42,47,184,9,2,8,3,223,74,194,87,49,52,192,4,192,3,32,241,128,161,1,34,71,216,102,246,11,221,231,157,86,102,104,187,190,217,8,2,192,0,112,173,6,234,65,162,6,216,16,0,182,99,101,1,0,34,67,18,178,246,56,238,59,153,118,155,218,174,239,189,168,8,0,3,192,86,0,190,138,65,0,134,1,240,0,170,0,34,69,126,104,223,111,215,149,137,154,109,105,187,234,14,161,168,128,89,5,18,0,220,16,128,29,0,54,72,132,171,35,160,67,41,0,34,67,248,216,123,222,53,14,243,102,169,78,176,8,130,50,0,244,104,224,106,168,3,116,0,140,30,112,128,148,60,244,34,1,151,0,34,69,174,107,95,119,131,87,243,17,249,139,16,149,1,96,47,0,151,168,1,192,209,57,19,157,14,152,38,17,128,142,77,252,28,180,226,75,234,38,34,65,93,217,26,187,45,63,204,7,100,47,66,84,6,144,184,27,224,198,71,21,224,129,9,48,253,62,173,6,66,131,134,151,79,234,8,64,2,34,73,105,104,190,63,149,133,136,162,141,16,162,0,192,233,146,73,228,228,162,6,40,117,30,20,38,200,199,56,173,183,92,132,211,210,107,187,126,148,14,34,73,71,86,93,143,215,19,222,146,38,106,50,160,34,124,96,92,0,19,111,145,14,47,172,32,168,159,231,206,92,247,25,138,124,203,97,19,59,105,65,61,109,218,2,52,0,34,77,191,36,2,128,7,64,101,0,108,87,0,182,203,215,0,89,195,24,135,75,184,137,48,1,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,70,99,125,46,0,0,0,0,242,44,163,83,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,70,99,125,46,1,0,0,0,131,137,174,78,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,184,3,0,0,0,0,0,0,70,99,125,46,2,0,0,0,68,116,91,64,3,84,72,54,26,97,98,234,147,102,178,138,80,199,255,207,151,76,58,203,113,245,188,247,220,233,47,121,231,246,235,241,185,167,152,172,170,223,88,186,97,217,242,177,250,103,242,23,3,96,82,58,127,53,202,32,46,184,234,15,128,207,126,186,138,63,83,253,137,249,91,85,80,89,89,40,194,36,98,229,45,197,40,192,228,47,230,0,26,89,25,219,190,196,227,5,7,230,94,249,191,173,112,89,122,124,59,12,67,213,243,89,78,211,251,114,72,187,27,132,153,117,86,169,74,98,27,40,216,5,28,27,81,74,195,184,36,207,231,61,0,210,182,0,183,254,90,239,18,174,53,201,160,144,240,134,83,131,168,2,22,83,205,23,24,61,41,196,157,76,245,86,70,112,118,49,167,232,252,248,70,236,229,160,191,92,209,0,84,209,42,222,215,117,216,96,59,1,216,13,133,175,237,172,19,155,106,0,224,29,96,40,216,5,0,0,39,0,12,0,11,0,13,0,9,0,12,0,12,0,11,0,9,0,9,0,10,0,16,0,33,0,27,0,33,0,10,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,19,0,19,0,17,0,19,0,17,0,11,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,10,0,10,0,10,0,12,0,41,0,10,0,18,0,10,0,18,0,10,0,18,0,10,0,18,0,10,0,10,0,10,0,10,0,10,0,18,0,18,0,18,0,18,0,18,0,18,0,18,0,14,0,19,0,19,0,19,0,19,0,19,0,19,0,10,0,9,0,10,0,22,0,0,0,0,0,3,0,3,0,1,0,1,0,1,0,1,0,3,0,3,0,1,0,1,0,1,0,1,0,1,0,2,0,0,0,1,0,2,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,255,255,3,0,1,0,3,0,3,0,3,0,1,0,3,0,3,0,0,0,3,0,3,0,3,0,3,0,1,0,3,0,1,0,3,0,1,0,1,0,3,0,255,255,0,0,0,0,255,255,1,0,3,0,0,0,1,0,2,0,0,0,5,0,2,0,2,0,1,0,1,0,1,0,1,0,1,0,2,0,2,0,254,255,2,0,2,0,2,0,2,0,1,0,2,0,1,0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,1,0,1,0,3,0,1,0,1,0,0,0,0,0,17,0,24,0,29,0,28,0,42,0,34,0,15,0,19,0,19,0,25,0,29,0,19,0,21,0,17,0,23,0,28,0,27,0,28,0,29,0,30,0,29,0,28,0,28,0,28,0,28,0,17,0,19,0,29,0,29,0,29,0,25,0,42,0,34,0,30,0,31,0,30,0,27,0,27,0,32,0,31,0,15,0,27,0,31,0,26,0,34,0,30,0,34,0,29,0,35,0,30,0,30,0,30,0,30,0,33,0,42,0,32,0,32,0,29,0,19,0,24,0,19,0,27,0,30,0,19,0,27,0,29,0,27,0,29,0,28,0,23,0,30,0,28,0,17,0,21,0,29,0,18,0,39,0,28,0,30,0,29,0,29,0,23,0,26,0,24,0,28,0,30,0,39,0,29,0,30,0,26,0,21,0,14,0,21,0,29,0,0,0,39,0,137,0,135,1,34,1,1,0,137,0,137,0,137,0,1,0,1,0,104,1,104,1,104,1,135,1,135,1,1,0,252,0,34,1,34,1,252,0,34,1,252,0,252,0,34,1,252,0,252,0,176,0,137,0,104,1,135,1,104,1,97,0,52,0,252,0,252,0,137,0,214,0,214,0,214,0,137,0,214,0,1,0,137,0,214,0,214,0,214,0,214,0,97,0,176,0,52,0,176,0,97,0,176,0,97,0,176,0,176,0,176,0,176,0,137,0,1,0,1,0,1,0,104,1,135,1,104,1,71,1,52,0,71,1,52,0,71,1,97,0,52,0,97,0,97,0,1,0,97,0,52,0,71,1,71,1,34,1,97,0,52,0,34,1,34,1,34,1,71,1,104,1,104,1,71,1,52,0,71,1,1,0,1,0,1,0,135,1,0,0,240,0,192,0,31,0,143,0,211,0,149,0,114,0,240,0,58,0,38,0,210,0,72,0,190,0,135,0,86,0,187,0,214,0,115,0,86,0,184,0,55,0,154,0,125,0,26,0,96,0,67,0,236,0,94,0,132,0,1,0,102,0,132,0,37,0,32,0,1,0,62,0,214,0,186,0,158,0,29,0,126,0,240,0,1,0,94,0,67,0,32,0,1,0,220,0,206,0,1,0,175,0,189,0,144,0,158,0,110,0,67,0,34,0,1,0,210,0,167,0,142,0,122,0,162,0,104,0,236,0,58,0,160,0,30,0,130,0,1,0,108,0,99,0,79,0,61,0,16,0,31,0,80,0,144,0,115,0,200,0,1,0,221,0,231,0,173,0,1,0,86,0,41,0,1,0,211,0,190,0,184,0,100,0,1,0,78,0,56,0,0,0,0,0,38,0,23,0,36,0,45,0,38,0,38,0,23,0,48,0,48,0,24,0,30,0,24,0,14,0,17,0,46,0,37,0,36,0,36,0,37,0,36,0,37,0,37,0,36,0,37,0,37,0,31,0,38,0,28,0,23,0,28,0,39,0,44,0,37,0,37,0,38,0,37,0,37,0,37,0,38,0,37,0,37,0,38,0,37,0,37,0,37,0,37,0,38,0,37,0,44,0,37,0,38,0,37,0,38,0,37,0,37,0,37,0,37,0,37,0,46,0,46,0,46,0,26,0,14,0,17,0,32,0,40,0,32,0,40,0,32,0,39,0,40,0,39,0,39,0,48,0,39,0,40,0,31,0,31,0,32,0,39,0,39,0,31,0,32,0,36,0,31,0,30,0,30,0,30,0,39,0,30,0,46,0,50,0,46,0,18,0,0,0,130,0,200,0,51,1,70,1,70,1,23,2,151,1,175,0,206,0,206,0,23,1,70,1,175,0,205,0,175,0,219,0,70,1,70,1,70,1,70,1,70,1,70,1,70,1,70,1,70,1,70,1,175,0,175,0,70,1,70,1,70,1,27,1,45,2,99,1,124,1,111,1,142,1,86,1,69,1,144,1,166,1,179,0,58,1,124,1,63,1,218,1,162,1,173,1,121,1,173,1,125,1,91,1,91,1,161,1,85,1,253,1,88,1,63,1,88,1,206,0,219,0,206,0,70,1,62,1,93,1,77,1,103,1,38,1,103,1,67,1,202,0,75,1,99,1,167,0,167,0,76,1,172,0,25,2,100,1,93,1,103,1,101,1,237,0,18,1,230,0,98,1,59,1,220,1,50,1,59,1,26,1,206,0,162,0,206,0,70,1,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,95,38,160,47,0,0,0,0,77,113,53,49,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,95,38,160,47,1,0,0,0,7,231,194,76,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28])
.concat([187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,177,20,0,0,0,0,0,0,95,38,160,47,2,0,0,0,34,139,172,179,12,79,72,66,69,67,62,63,57,64,63,67,52,34,93,109,218,206,240,237,157,57,187,93,163,213,147,147,180,204,189,227,253,98,236,235,225,220,181,88,199,237,48,242,208,86,118,212,184,181,62,140,140,127,176,80,73,44,45,192,66,172,20,243,45,223,98,80,199,225,170,171,241,111,204,64,199,98,126,229,87,128,9,240,197,74,147,82,92,201,2,0,30,121,244,130,159,172,128,139,117,156,63,219,172,94,82,86,25,35,121,83,159,159,47,159,46,222,28,60,231,20,195,74,127,134,209,224,104,133,126,33,26,85,151,7,84,168,188,100,120,41,176,6,167,21,247,7,93,175,2,160,177,110,186,64,21,0,137,111,194,72,53,1,54,135,245,22,75,229,235,243,130,146,58,100,87,79,149,117,209,124,103,120,241,170,202,77,123,103,92,157,159,191,123,8,160,240,227,211,86,57,246,249,11,131,48,196,194,10,88,133,133,21,28,7,49,62,26,18,86,248,36,26,160,10,84,81,166,9,46,117,197,170,37,202,220,190,81,124,103,199,124,114,101,108,36,221,92,30,59,123,229,149,151,231,207,231,52,54,189,179,252,188,195,188,252,146,20,230,147,243,53,125,67,232,170,254,146,7,138,78,204,26,48,166,109,36,113,192,180,107,204,194,4,154,245,186,0,34,125,228,70,235,162,93,203,140,124,47,154,171,77,0,64,204,148,117,37,41,214,46,173,17,95,74,205,178,137,42,182,6,226,249,75,23,146,242,22,36,129,152,52,64,215,92,234,71,216,220,166,103,47,137,14,39,38,83,1,5,24,85,46,74,9,0,38,125,233,118,243,114,53,17,96,226,229,173,91,81,137,163,147,158,79,197,10,123,86,117,61,171,154,118,124,145,234,179,229,46,190,27,8,111,80,15,94,32,59,217,79,0,108,58,100,64,243,5,232,63,0,14,30,48,17,77,10,0,46,101,221,65,167,94,117,2,117,65,125,178,171,5,168,19,72,85,150,131,54,158,159,91,218,181,241,92,190,66,230,241,234,26,18,197,73,33,190,182,88,235,72,148,158,125,86,17,250,153,172,23,56,126,24,224,31,40,18,232,232,71,3,38,97,221,74,167,78,94,244,140,189,101,49,159,42,122,4,58,202,175,11,149,231,175,42,183,248,208,185,254,255,228,46,62,20,72,10,16,207,29,179,245,239,112,60,193,193,87,193,60,81,115,72,15,24,2,5,0,42,113,109,165,197,4,38,58,3,173,62,227,202,88,17,186,254,60,255,231,204,20,115,252,103,209,156,123,160,166,81,171,15,44,114,52,223,154,146,201,95,236,155,18,44,36,96,74,38,41,56,224,237,115,128,142,149,79,77,7,8,101,114,0,42,115,195,106,87,80,129,28,116,193,129,206,23,149,208,21,33,231,31,207,227,243,216,116,188,195,190,39,120,53,216,73,168,132,57,120,36,209,134,60,201,145,158,192,102,123,3,139,161,160,55,40,139,71,37,18,2,28,64,197,204,5,3,38,95,187,73,211,103,208,121,6,51,95,148,235,160,89,227,21,190,49,79,115,161,215,245,139,24,221,83,169,230,40,47,13,222,181,154,196,82,142,9,147,134,183,126,160,141,85,161,157,28,163,20,129,51,204,186,187,132,142,38,151,111,213,193,172,233,0,30,61,223,42,18,84,187,240,43,24,33,73,10,147,11,115,120,51,225,138,146,138,144,34,176,11,59,231,45,174,1,24,27,6,187,49,64,23,189,9,7,62,48,129,80,250,89,32,0,154,19,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,44,164,9,28,0,0,0,0,143,25,87,129,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,44,164,9,28,1,0,0,0,171,174,113,126,14,61,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,45,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,48,49,49,48,49,32,40,83,99,104,97,117,102,101,110,117,103,103,101,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,4,94,8,0,0,0,0,0,0,44,164,9,28,2,0,0,0,190,224,166,151,6,77,75,57,65,47,12,26,89,98,234,78,17,70,192,240,90,222,111,245,146,166,57,92,216,156,199,111,239,204,119,238,124,157,155,123,62,167,153,175,237,18,248,255,247,97,132,41,249,83,0,122,42,14,176,231,186,9,123,14,131,172,84,0,157,18,184,127,29,192,13,33,65,98,74,254,71,171,212,113,123,143,223,1,30,81,118,234,246,33,106,85,5,211,38,63,91,170,150,184,45,244,58,189,172,114,243,253,252,249,129,93,219,82,172,250,166,144,164,129,229,162,158,233,211,85,213,148,89,50,65,96,55,140,225,154,66,23,184,100,131,42,95,3,160,29,80,240,178,184,246,22,31,111,113,249,241,192,1,50,75,227,86,161,76,224,182,101,211,45,170,215,92,0,63,111,162,175,99,143,207,235,52,157,221,22,182,182,79,151,90,113,181,10,117,245,186,50,115,138,246,179,2,233,52,167,243,226,214,2,174,140,129,154,174,0,34,73,67,191,74,185,154,4,170,105,43,50,245,247,33,221,212,231,139,223,111,239,83,53,228,169,94,245,247,30,211,220,69,53,12,59,10,98,224,6,212,184,98,42,157,173,32,24,150,38,64,115,87,52,4,29,93,186,4,235,225,34,58,99,0,30,73,151,185,8,78,215,31,43,203,122,94,46,0,195,246,208,195,30,12,131,97,174,51,12,189,22,158,86,55,44,219,37,13,114,168,42,104,222,178,3,76,211,170,231,18,8,34,77,191,52,2,128,7,128,0,0,9,195,0,0,0,0,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,115,99,114,101,101,110,115,105,122,101,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,114,97,110,100,111,109,115,105,122,101,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,59,32,112,111,115,32,61,32,118,116,120,99,111,111,114,100,46,120,121,59,32,116,101,120,32,61,32,40,40,112,111,115,32,43,32,118,101,99,50,40,49,46,48,41,41,32,47,32,50,46,48,41,32,42,32,115,99,114,101,101,110,115,105,122,101,32,47,32,114,97,110,100,111,109,115,105,122,101,59,32,125,117,110,105,102,111,114,109,32,102,108,111,97,116,32,116,105,109,101,59,32,117,110,105,102,111,114,109,32,115,97,109,112,108,101,114,50,68,32,115,97,109,112,108,101,114,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,102,108,111,97,116,32,105,110,116,101,110,115,105,116,121,32,61,32,48,46,54,59,32,102,108,111,97,116,32,114,97,110,100,111,109,95,99,111,108,111,114,32,61,32,116,101,120,116,117,114,101,50,68,40,115,97,109,112,108,101,114,44,32,109,111,100,40,116,101,120,44,32,118,101,99,50,40,49,46,48,41,41,41,46,114,59,32,105,110,116,101,110,115,105,116,121,32,43,61,32,48,46,48,54,32,42,32,114,97,110,100,111,109,95,99,111,108,111,114,59,32,102,108,111,97,116,32,104,118,105,103,110,101,116,116,101,32,61,32,115,109,111,111,116,104,115,116,101,112,40,50,46,53,44,32,48,46,53,44,32,97,98,115,40,112,111,115,46,120,41,41,59,32,102,108,111,97,116,32,118,118,105,103,110,101,116,116,101,32,61,32,115,109,111,111,116,104,115,116,101,112,40,50,46,52,44,32,48,46,53,44,32,97,98,115,40,112,111,115,46,121,41,41,59,32,105,110,116,101,110,115,105,116,121,32,42,61,32,104,118,105,103,110,101,116,116,101,32,42,32,118,118,105,103,110,101,116,116,101,59,32,102,108,111,97,116,32,104,105,103,104,108,105,103,104,116,32,61,32,115,109,111,111,116,104,115,116,101,112,40,49,46,48,44,32,48,46,48,44,32,100,105,115,116,97,110,99,101,40,112,111,115,44,32,118,101,99,50,40,45,48,46,50,44,32,45,48,46,51,41,41,41,59,32,105,110,116,101,110,115,105,116,121,32,43,61,32,104,105,103,104,108,105,103,104,116,32,42,32,48,46,50,59,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,105,110,116,101,110,115,105,116,121,44,32,105,110,116,101,110,115,105,116,121,44,32,105,110,116,101,110,115,105,116,121,44,32,49,46,48,41,59,32,125,0,0,0,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,102,114,97,109,101,98,117,102,102,101,114,95,115,105,122,101,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,99,101,110,116,101,114,59,32,117,110,105,102,111,114,109,32,102,108,111,97,116,32,115,105,122,101,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,112,111,115,32,61,32,99,101,110,116,101,114,32,43,32,118,116,120,99,111,111,114,100,46,120,121,32,42,32,115,105,122,101,59,32,103,108,95,80,111,115,105,116,105,111,110,46,120,32,61,32,50,46,48,32,42,32,40,112,111,115,46,120,32,47,32,102,114,97,109,101,98,117,102,102,101,114,95,115,105,122,101,46,120,41,32,45,32,49,46,48,59,32,103,108,95,80,111,115,105,116,105,111,110,46,121,32,61,32,50,46,48,32,42,32,40,112,111,115,46,121,32,47,32,102,114,97,109,101,98,117,102,102,101,114,95,115,105,122,101,46,121,41,32,45,32,49,46,48,59,32,103,108,95,80,111,115,105,116,105,111,110,46,122,32,61,32,48,46,48,59,32,103,108,95,80,111,115,105,116,105,111,110,46,119,32,61,32,49,46,48,59,32,125,0,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,99,101,110,116,101,114,59,32,117,110,105,102,111,114,109,32,102,108,111,97,116,32,115,105,122,101,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,102,108,111,97,116,32,100,105,115,116,32,61,32,108,101,110,103,116,104,40,112,111,115,32,45,32,99,101,110,116,101,114,41,59,32,102,108,111,97,116,32,115,104,97,100,111,119,95,98,111,114,100,101,114,32,61,32,48,46,48,48,53,32,42,32,115,105,122,101,59,32,102,108,111,97,116,32,115,104,97,100,111,119,95,100,105,115,116,32,61,32,108,101,110,103,116,104,40,112,111,115,32,45,32,40,99,101,110,116,101,114,32,43,32,118,101,99,50,40,115,104,97,100,111,119,95,98,111,114,100,101,114,41,41,41,59,32,102,108,111,97,116,32,104,105,103,104,108,105,103,104,116,32,61,32,108,101,110,103,116,104,40,112,111,115,32,45,32,40,99,101,110,116,101,114,32,45,32,48,46,50,32,42,32,115,105,122,101,41,41,59,32,102,108,111,97,116,32,98,111,114,100,101,114,32,61,32,50,46,55,59,32,103,108,95,70,114,97,103,67,111,108,111,114,46,114,103,98,97,32,61,32,118,101,99,52,40,115,109,111,111,116,104,115,116,101,112,40,115,105,122,101,44,32,115,105,122,101,45,98,111,114,100,101,114,44,32,100,105,115,116,41,41,59,32,105,102,32,40,115,104,97,100,111,119,95,100,105,115,116,32,60,32,100,105,115,116,41,32,123,32,103,108,95,70,114,97,103,67,111,108,111,114,46,97,32,43,61,32,115,109,111,111,116,104,115,116,101,112,40,115,105,122,101,45,115,104,97,100,111,119,95,98,111,114,100,101,114,44,32,115,105,122,101,45,98,111,114,100,101,114,44,32,115,104,97,100,111,119,95,100,105,115,116,41,59,32,125,32,102,108,111,97,116,32,105,110,116,101,110,115,105,116,121,32,61,32,48,46,49,53,59,32,104,105,103,104,108,105,103,104,116,32,61,32,115,109,111,111,116,104,115,116,101,112,40,115,105,122,101,44,32,115,105,122,101,47,50,46,48,44,32,104,105,103,104,108,105,103,104,116,41,59,32,103,108,95,70,114,97,103,67,111,108,111,114,46,98,32,42,61,32,105,110,116,101,110,115,105,116,121,32,42,32,104,105,103,104,108,105,103,104,116,59,32,102,108,111,97,116,32,109,105,120,101,114,32,61,32,115,109,111,111,116,104,115,116,101,112,40,115,105,122,101,47,50,46,48,44,32,115,105,122,101,47,50,46,48,32,45,32,98,111,114,100,101,114,44,32,100,105,115,116,41,59,32,103,108,95,70,114,97,103,67,111,108,111,114,46,114,32,42,61,32,109,105,120,101,114,59,32,103,108,95,70,114,97,103,67,111,108,111,114,46,103,32,42,61,32,40,49,46,48,32,45,32,109,105,120,101,114,41,59,32,125,0,0,0,0,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,97,116,116,114,105,98,117,116,101,32,118,101,99,50,32,116,101,120,99,111,111,114,100,59,32,97,116,116,114,105,98,117,116,101,32,118,101,99,51,32,99,111,108,111,114,59,32,97,116,116,114,105,98,117,116,101,32,118,101,99,51,32,100,101,115,105,114,101,100,59,32,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,32,118,97,114,121,105,110,103,32,118,101,99,51,32,99,111,108,59,32,118,97,114,121,105,110,103,32,118,101,99,51,32,100,101,115,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,116,120,99,111,111,114,100,32,42,32,112,114,111,106,101,99,116,105,111,110,59,32,116,101,120,32,61,32,116,101,120,99,111,111,114,100,59,32,99,111,108,32,61,32,99,111,108,111,114,59,32,100,101,115,32,61,32,100,101,115,105,114,101,100,59,32,125,0,0,0,0,0,118,97,114,121,105,110,103,32,118,101,99,50,32,116,101,120,59,32,118,97,114,121,105,110,103,32,118,101,99,51,32,99,111,108,59,32,118,97,114,121,105,110,103,32,118,101,99,51,32,100,101,115,59,32,117,110,105,102,111,114,109,32,115,97,109,112,108,101,114,50,68,32,115,97,109,112,108,101,114,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,118,101,99,52,32,116,32,61,32,116,101,120,116,117,114,101,50,68,40,115,97,109,112,108,101,114,44,32,116,101,120,41,59,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,116,46,114,32,42,32,100,101,115,32,43,32,116,46,103,32,42,32,99,111,108,32,43,32,116,46,98,98,98,44,32,116,46,97,41,59,32,125,0,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,117,110,105,102,111,114,109,32,109,97,116,52,32,112,114,111,106,101,99,116,105,111,110,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,99,101,110,116,101,114,59,32,117,110,105,102,111,114,109,32,102,108,111,97,116,32,115,105,122,101,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,112,111,115,32,61,32,99,101,110,116,101,114,32,43,32,118,116,120,99,111,111,114,100,46,120,121,32,42,32,115,105,122,101,59,32,103,108,95,80,111,115,105,116,105,111,110,32,61,32,118,101,99,52,40,112,111,115,44,32,48,46,48,44,32,49,46,48,41,32,42,32,112,114,111,106,101,99,116,105,111,110,59,32,125,0,0,0,0,0,117,110,105,102,111,114,109,32,98,111,111,108,32,102,105,108,108,101,100,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,99,101,110,116,101,114,59,32,117,110,105,102,111,114,109,32,102,108,111,97,116,32,115,105,122,101,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,102,108,111,97,116,32,100,105,115,116,32,61,32,100,105,115,116,97,110,99,101,40,112,111,115,44,32,99,101,110,116,101,114,41,59,32,102,108,111,97,116,32,98,111,114,100,101,114,32,61,32,48,46,56,59,32,102,108,111,97,116,32,111,117,116,101,114,95,114,97,100,105,117,115,32,61,32,115,105,122,101,32,47,32,50,46,48,59,32,102,108,111,97,116,32,105,110,110,101,114,95,114,97,100,105,117,115,32,61,32,115,105,122,101,32,47,32,50,46,48,32,45,32,98,111,114,100,101,114,32,42,32,50,46,48,59,32,102,108,111,97,116,32,105,110,116,101,110,115,105,116,121,32,61,32,115,109,111,111,116,104,115,116,101,112,40,111,117,116,101,114,95,114,97,100,105,117,115,44,32,111,117,116,101,114,95,114,97,100,105,117,115,45,98,111,114,100,101,114,44,32,100,105,115,116,41,59,32,105,102,32,40,33,102,105,108,108,101,100,41,32,123,32,105,110,116,101,110,115,105,116,121,32,45,61,32,115,109,111,111,116,104,115,116,101,112,40,105,110,110,101,114,95,114,97,100,105,117,115,44,32,105,110,110,101,114,95,114,97,100,105,117,115,45,98,111,114,100,101,114,44,32,100,105,115,116,41,59,32,125,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,118,101,99,52,40,49,46,48,44,32,49,46,48,44,32,49,46,48,44,32,105,110,116,101,110,115,105,116,121,41,59,32,125,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,81,117,155,31,0,0,0,0,135,154,16,224,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,81,117,155,31,1,0,0,0,12,93,44,221,14,59,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,43,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,50,48,50,48,51,32,40,79,109,110,105,112,114,101,115,101,110,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228])
.concat([57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,0,0,118,0,0,0,0,0,0,81,117,155,31,2,0,0,0,203,176,50,169,60,73,74,72,71,74,74,73,67,74,71,73,76,70,70,68,68,64,64,65,67,65,68,69,70,68,68,67,66,64,65,65,70,64,65,73,63,70,59,73,68,68,71,65,72,71,69,68,68,74,70,70,69,71,69,65,69,65,66,71,71,90,83,16,69,20,178,131,46,57,87,160,85,241,22,169,60,125,23,106,186,251,55,117,156,137,183,51,127,136,160,224,66,79,45,77,25,74,63,197,251,178,116,172,66,135,193,186,142,133,65,26,96,97,63,111,33,48,73,193,102,19,213,16,52,80,173,167,208,0,199,119,244,4,102,81,4,128,208,174,145,232,138,45,91,245,223,48,95,207,166,249,171,107,213,249,233,55,51,99,230,46,106,174,110,159,245,235,80,125,117,157,33,90,89,244,224,106,27,178,134,249,154,185,11,234,128,22,139,216,164,153,178,105,152,74,103,80,127,133,146,146,103,36,42,255,8,30,114,85,142,240,84,170,14,214,233,138,83,2,121,9,90,83,186,124,93,230,155,254,214,164,219,218,54,185,167,142,201,184,144,218,52,140,84,166,232,12,250,198,132,77,107,128,157,216,109,66,19,218,40,95,194,65,34,65,69,208,117,253,204,192,124,58,199,229,202,238,64,0,118,85,65,42,9,208,32,239,148,152,212,0,102,69,101,247,89,234,139,109,233,219,236,89,150,106,158,238,210,123,145,106,124,49,169,91,208,173,8,40,124,65,131,228,163,93,250,96,50,69,9,2,7,104,138,82,2,125,195,146,9,247,166,1,147,199,60,229,206,79,0,98,87,132,83,13,16,173,99,52,63,107,229,121,24,251,252,121,185,170,47,247,239,207,23,229,236,143,49,92,12,121,118,212,77,74,43,92,81,157,248,189,7,66,96,12,193,233,133,53,0,15,202,136,112,65,153,36,186,45,237,89,184,93,65,50,146,173,160,105,70,151,239,130,2,102,83,170,150,2,168,192,228,12,213,1,88,77,44,217,103,113,164,91,223,148,107,207,151,83,53,182,14,202,229,169,114,51,175,189,173,75,105,119,245,212,124,138,79,60,92,58,1,123,70,128,161,1,234,120,37,14,152,19,153,204,152,200,47,5,103,32,128,179,124,18,93,108,4,98,81,184,175,32,160,128,220,62,76,174,231,166,219,127,119,126,123,26,95,207,115,209,88,28,108,218,219,133,121,152,234,40,244,29,134,105,211,140,229,4,49,232,0,140,217,167,249,137,225,151,160,1,210,137,192,47,201,17,29,140,160,48,67,194,150,62,96,26,76,225,251,1,102,77,168,175,104,69,105,177,138,22,218,70,43,247,117,223,188,95,252,57,46,216,179,223,143,175,197,222,151,125,171,105,33,230,114,24,70,239,98,193,16,2,176,151,13,0,214,9,122,193,211,150,8,128,99,182,201,22,114,85,181,139,44,95,78,192,1,106,81,56,27,56,152,32,105,248,67,30,14,226,204,136,250,182,83,107,117,245,84,77,214,133,241,119,221,198,195,218,105,10,86,136,219,87,10,1,24,9,11,176,123,154,91,252,9,141,96,249,44,170,9,192,0,244,169,216,164,151,19,74,35,117,76,13,178,125,70,153,175,151,3,114,85,76,42,42,77,21,155,17,211,61,3,145,231,221,216,231,234,59,7,215,247,160,106,236,252,117,135,173,38,90,198,70,91,123,99,145,190,74,166,249,161,193,252,2,94,209,99,77,192,246,0,140,191,72,18,20,141,133,236,185,76,8,129,224,131,111,60,28,14,0,102,81,220,107,36,93,5,232,166,71,166,112,3,69,229,185,173,205,109,91,43,142,246,137,244,180,162,75,12,27,77,161,99,16,41,230,227,238,1,72,190,212,83,168,9,96,158,34,14,216,214,26,160,72,143,161,20,26,44,137,40,161,146,85,231,200,205,38,231,215,215,4,1,110,83,16,21,28,36,224,20,8,1,140,56,166,37,239,214,239,73,237,125,162,189,246,39,140,79,156,42,123,181,194,217,238,197,140,26,160,139,91,2,186,10,192,180,7,64,46,74,23,160,1,66,211,203,250,114,186,100,211,236,146,11,235,170,238,30,67,157,116,90,238,9,103,219,31,0,106,85,132,51,0,17,24,109,147,68,78,119,119,168,191,84,60,174,30,155,75,31,149,197,91,253,202,235,55,166,229,88,144,160,219,172,177,53,244,147,190,12,236,204,118,190,109,98,106,9,230,192,118,227,191,233,232,64,147,244,179,49,161,133,138,14,145,32,130,2,94,87,96,1,194,0,97,181,225,28,56,196,65,171,220,101,41,205,177,85,202,111,255,188,105,247,59,41,117,115,52,91,158,138,251,165,59,11,233,12,140,153,138,64,64,109,143,167,3,192,16,43,8,104,148,232,192,124,4,183,115,86,68,196,188,62,85,143,202,4,106,77,64,20,132,86,21,51,254,238,125,160,222,9,32,165,106,54,205,28,203,114,46,210,155,167,124,147,93,166,79,57,15,98,48,244,230,236,184,13,48,192,208,14,83,67,131,5,29,240,89,64,114,76,254,152,222,97,42,184,231,112,15,171,236,10,58,0,114,87,140,25,152,88,58,208,83,223,226,3,135,52,88,242,214,164,234,158,117,42,59,196,47,101,177,101,118,152,134,20,189,214,37,100,118,194,37,181,55,81,164,132,5,104,0,176,61,72,188,130,2,184,214,19,138,104,92,41,244,236,111,14,29,103,18,0,102,89,192,128,136,35,2,29,124,46,98,0,72,137,220,102,141,61,142,188,61,182,18,71,227,77,62,94,74,230,113,65,23,228,236,15,234,136,29,134,17,64,243,64,235,48,23,21,202,99,202,135,232,50,109,164,169,86,8,103,229,67,1,0,86,73,26,1,1,17,12,222,185,230,151,6,88,129,66,125,183,229,82,141,223,242,100,221,163,253,56,249,97,212,182,196,49,50,113,32,147,48,122,28,58,166,128,65,165,0,151,88,234,44,201,187,14,69,167,211,72,157,22,250,48,38,2,0,98,75,128,1,32,130,209,59,37,38,1,116,160,144,179,61,197,162,141,236,52,41,154,212,38,19,43,85,186,242,108,177,223,132,228,114,79,83,37,149,137,162,160,65,21,0,41,158,168,55,153,161,7,79,66,135,8,226,240,234,184,36,149,109,0,90,75,28,64,2,5,58,241,185,70,43,97,208,77,212,119,113,196,186,29,103,222,62,105,207,22,86,94,155,121,116,60,42,20,250,127,115,174,103,193,112,26,216,97,20,68,104,128,18,19,239,216,111,253,12,195,153,26,61,105,169,208,101,176,63,64,2,90,69,20,128,209,22,65,175,193,25,171,32,129,54,168,247,72,239,172,255,181,93,90,105,217,231,206,170,11,118,40,158,178,139,86,194,178,69,47,225,91,199,130,4,104,0,9,176,243,214,181,206,51,239,1,20,220,178,100,106,222,36,83,3,0,94,69,20,51,47,170,10,72,223,124,213,83,213,81,61,228,255,110,170,206,134,138,123,156,103,67,213,19,241,84,70,91,153,32,78,87,85,201,80,99,188,137,14,192,48,192,49,129,175,206,238,195,18,142,230,90,201,130,37,68,209,124,40,197,32,233,58,0,94,83,148,1,231,58,2,211,83,195,3,18,72,149,231,109,153,195,119,79,41,35,189,91,205,190,127,227,206,180,61,149,168,168,142,237,42,84,246,49,248,0,134,1,80,38,216,37,74,167,179,241,34,154,73,119,139,179,77,124,28,41,52,249,88,7,10,76,0,106,81,64,20,76,74,4,26,240,156,72,72,96,72,228,46,210,187,190,253,178,102,109,159,31,107,216,76,77,53,138,150,140,246,154,170,7,134,232,40,175,81,0,88,173,59,108,101,223,136,194,235,66,129,38,44,119,91,44,167,110,69,237,105,97,36,229,204,65,0,98,85,4,0,116,139,152,173,54,159,139,136,3,32,39,154,251,104,246,99,109,190,188,221,210,218,68,87,239,211,26,10,139,156,250,118,182,88,26,101,25,251,2,140,123,9,226,192,27,78,48,149,178,89,210,108,152,76,158,146,157,46,14,246,131,151,41,0,106,81,2,43,40,106,85,152,213,166,205,64,228,62,27,126,190,250,245,126,190,139,183,183,67,229,238,69,174,43,210,110,217,252,198,77,163,76,234,168,91,99,67,0,69,178,6,111,233,50,81,144,22,123,73,243,72,139,144,118,211,66,198,58,49,12,29,0,94,69,136,75,160,154,6,94,227,157,161,185,3,168,106,43,234,150,117,199,235,183,84,158,122,121,185,74,187,42,92,141,85,87,99,153,42,203,143,97,9,200,14,88,169,0,63,216,18,169,88,74,236,127,161,57,253,21,211,121,241,78,54,159,244,16,0,90,83,0,44,65,70,96,122,198,119,0,90,34,103,82,95,253,121,171,183,105,254,217,18,149,108,238,140,227,244,97,77,120,229,187,88,83,245,209,209,91,211,184,190,65,14,3,170,94,72,58,80,20,138,22,46,182,92,248,153,30,200,84,164,246,58,90,87,4,3,136,69,160,73,207,193,127,0,84,205,16,103,118,116,239,47,107,143,236,152,9,92,186,38,34,239,173,194,82,120,70,136,53,10,0,157,11,120,114,82,3,15,116,190,52,237,189,86,119,62,252,128,210,23,64,66,71,50,26,15,94,77,24,75,12,62,129,196,57,81,63,226,28,82,213,136,202,154,99,191,159,177,30,233,105,243,93,157,177,140,26,125,10,63,113,144,155,26,117,116,35,168,128,141,29,128,27,44,41,117,218,117,192,212,21,19,40,28,78,215,179,198,71,38,0,98,85,8,1,136,117,196,134,243,45,145,251,66,252,248,51,151,250,90,61,86,172,174,39,18,175,52,134,175,213,194,42,7,193,172,208,55,218,50,177,6,58,88,91,12,102,212,1,26,16,84,109,10,206,83,76,197,53,101,87,103,82,234,11,0,86,81,148,1,161,152,145,52,61,99,19,24,216,36,22,247,174,125,178,54,77,202,222,99,73,107,35,82,85,109,237,35,172,99,160,12,4,161,49,226,120,163,58,118,64,39,253,172,234,240,59,69,81,8,206,49,59,118,59,44,234,116,237,24,96,232,6,145,94,1,90,77,148,128,66,229,1,162,231,34,46,48,144,202,180,137,108,22,253,113,213,167,226,104,6,182,219,178,74,163,195,154,104,251,121,127,238,237,96,58,245,209,156,42,169,7,200,4,230,18,29,104,214,76,201,69,215,104,144,122,46,114,162,3,90,73,148,1,167,236,5,38,137,115,129,15,8,72,57,211,190,82,109,213,76,138,127,191,180,217,74,201,175,229,92,133,134,205,80,92,190,28,24,165,188,174,192,68,232,0,233,160,230,197,212,0,49,134,160,16,100,50,163,20,103,40,74,163,3,110,85,196,40,105,116,153,97,164,225,85,27,104,193,121,90,18,139,49,177,52,205,182,164,168,153,115,219,99,229,113,9,165,236,114,208,101,172,109,194,98,6,15,83,75,96,14,114,35,24,158,1,66,158,46,73,142,123,14,183,139,132,75,62,58,161,212,111,141,193,70,14,0,90,71,84,1,3,7,216,205,166,170,95,29,231,241,143,211,77,125,218,233,108,207,66,240,183,138,197,104,143,177,168,232,221,47,30,49,112,88,64,125,192,109,6,217,1,206,82,84,116,125,229,21,14,208,105,116,226,105,200,34,104,93,2,82,83,220,128,2,153,129,189,115,129,181,0,72,149,219,78,57,111,243,29,206,101,253,38,82,244,138,70,110,112,74,13,102,216,17,225,43,212,49,13,235,179,54,225,6,77,10,0,109,53,152,205,164,249,9,22,233,223,242,236,74,124,216,62,45,196,190,107,76,0,82,73,156,129,164,100,6,206,157,51,148,2,64,74,152,70,187,166,253,168,57,165,53,117,119,180,117,219,24,51,45,221,219,3,38,99,54,210,30,29,192,21,192,173,6,145,109,77,65,28,157,96,122,169,148,34,59,107,0,98,83,56,81,72,81,174,48,81,221,234,53,87,110,133,219,250,223,189,227,170,211,133,249,78,165,98,97,230,109,26,185,34,77,101,221,43,45,116,44,1,146,161,176,5,8,85,204,78,83,224,0,118,43,216,98,162,241,10,105,182,25,5,235,186,94,42,48,181,216,158,76,0,82,77,156,1,23,236,0,14,83,189,37,234,235,179,249,171,10,67,241,166,114,190,222,214,55,243,212,206,205,49,121,234,208,50,219,149,20,107,54,75,9,188,2,180,225,210,31,184,61,115,80,1,38,13,51,152,38,91,238,50,204,139,238,179,148,32,77,0,94,81,132,2,168,140,192,226,92,68,74,0,170,186,173,154,214,118,54,107,211,103,71,133,174,203,213,116,171,138,53,219,124,136,206,170,198,131,9,44,216,110,239,70,0,224,54,55,160,105,141,150,97,118,150,195,45,79,234,47,47,91,177,114,19,99,20,0,94,81,0,220,141,94,1,102,181,177,122,74,204,188,56,196,247,35,243,157,170,169,252,40,20,230,66,191,47,52,205,69,80,83,88,244,201,5,122,152,126,56,128,13,225,65,27,93,135,73,129,174,251,134,209,60,24,57,214,157,18,213,41,118,46,149,206,22,163,116,0,82,71,156,3,193,82,160,21,51,191,77,84,245,215,113,254,226,203,169,106,239,148,231,46,212,197,42,93,61,182,195,25,204,101,0,220,20,170,141,199,16,128,55,0,128,149,97,27,234,108,88,136,46,38,56,78,79,66,23,175,121,218,69,1,0,106,77,130,25,40,170,84,152,120,240,171,54,120,99,147,71,168,37,234,151,28,181,126,75,202,142,102,174,92,241,228,131,175,44,188,148,212,206,68,80,83,28,228,147,99,19,192,240,56,72,5,219,182,29,115,83,218,154,132,70,210,82,195,153,10,217,93,43,22,73,232,0,98,73,160,52,140,80,65,135,222,186,16,211,163,155,127,95,61,13,239,241,241,66,177,190,153,11,227,227,238,239,90,18,34,149,169,217,110,198,232,50,156,186,212,91,209,100,49,43,7,228,226,222,107,218,84,213,98,66,111,202,153,4,82,32,77,66,155,209,160,79,0,86,67,148,1,129,119,88,119,225,115,141,31,0,85,253,229,109,147,142,101,251,174,227,112,93,233,137,123,218,163,29,50,252,246,117,209,249,1,182,60,19,35,49,25,94,68,71,7,15,54,172,156,233,248,155,251,198,52,224,243,149,176,203,22,157,230,95,0,0,82,69,148,1,33,62,131,92,181,201,6,72,164,170,183,81,251,44,235,19,181,108,79,244,75,59,89,42,85,90,167,116,103,65,230,165,194,173,189,144,70,160,23,109,69,55,6,135,197,22,181,217,50,134,160,21,137,4,141,45,219,4,197,36,194,22,240,0,86,75,84,1,163,188,130,188,83,178,6,0,157,42,251,154,250,174,201,190,39,62,125,125,77,223,103,101,100,138,34,223,123,217,142,9,236,25,36,196,176,173,189,96,136,67,159,13,96,190,193,5,182,71,47,70,105,192,148,69,11,122,60,69,93,143,155,0,82,85,52,128,212,253,192,150,88,156,147,87,192,161,168,220,181,214,126,95,111,205,18,14,121,109,84,253,108,174,43,91,188,95,250,77,59,128,167,184,24,231,192,144,178,191,186,54,181,94,0,98,150,182,64,103,154,160,232,50,55,118,77,241,161,0,102,223,168,181,239,44,6,0,82,71,148,128,20,74,133,101,87,156,147,31,2,224,169,122,164,88,219,233,100,249,185,102,140,185,242,227,218,4,213,129,222,186,165,170,88,18,86,42,20,252,180,83,105,99,22,196,131,58,0,63,54,21,10,87,52,242,184,198,187,6,202,153,93,121,27,27,33,0,82,71,88,1,144,21,182,186,231,115,17,3,4,98,202,245,103,249,237,123,68,132,95,146,118,131,234,49,52,133,93,98,96,2,98,66,125,8,244,108,34,109,62,126,42,122,37,87,15,104,174,44,78,32,44,22,35,241,101,195,46,85,225,32,65,71,241,215,21,0,82,71,82,24,56,61,34,116,74,119,84,159,87,181,226,80,249,227,118,152,78,157,95,138,37,209,63,156,50,137,225,161,48,73,239,65,13,160,227,11,15,103,56,148,82,216,214,19,30,240,63,166,35,144,54,10,254,231,95,74,165,1,190,119,162,94,116,18,0,78,69,20,41,218,196,213,173,211,80,61,152,202,238,198,241,243,139,83,245,70,241,224,151,56,155,188,167,148,52,22,205,176,91,60,148,217,233,9,33,218,201,233,70,102,217,54,233,129,12,93,43,114,123,196,70,40,71,62,253,40,73,141,212,38,50,184,247,114,42,2,86,73,84,88,52,125,84,144,119,110,249,193,64,170,122,180,215,117,52,113,246,154,43,189,109,146,97,16,61,83,195,226,76,194,232,4,216,51,145,128,165,194,226,210,129,249,218,220,122,83,72,230,235,139,40,247,133,22,138,30,204,132,164,191,54,102,89,1,0,74,69,156,0,161,87,133,73,203,227,52,14,24,4,162,218,223,22,221,193,229,122,243,50,39,177,176,34,145,85,253,87,42,158,236,81,82,188,122,58,157,55,172,227,72,208,193,24,115,151,214,135,210,113,138,47,102,98,206,21,147,105,210,76,0,106,73,66,57,25,122,169,160,21,124,14,36,70,36,90,213,163,169,101,59,119,255,121,250,223,76,201,241,213,55,169,157,160,199,254,17,197,38,58,204,210,236,32,97,247,137,135,31,78,44,1,101,89,209,141,112,94,243,133,137,64,203,105,37,136,208,59,169,3,102,87,10,219,24,245,86,48,203,251,6,220,144,224,68,185,183,204,81,117,249,210,87,239,170,163,170,122,35,54,205,12,88,47,209,15,79,232,253,54,80,10,28,28,32,233,148,34,20,33,109,224,251,9,137,157,235,228,1,153,165,205,58,135,4,94,77,76,107,152,48,20,204,253,51,213,139,170,175,42,14,207,167,227,252,116,52,10,249,168,84,249,219,7,232,8,74,76,162,147,8,212,134,64,230,239,95,59,128,2,212,129,7,179,78,143,32,74,123,24,191,33,136,238,160,9,221,172,147,168,3,102,83,192,65,1,6,26,127,32,184,4,70,203,147,173,77,106,247,182,151,29,109,191,165,180,26,50,119,183,203,209,219,58,52,93,88,29,44,88,112,163,157,117,207,156,89,140,130,205,93,21,29,168,129,161,48,9,195,14,77,81,84,125,48,192,251,30,0,61,208,26,98,83,132,0,64,5,214,231,224,36,136,128,19,45,249,172,85,151,174,171,217,151,253,82,108,188,147,2,155,101,39,221,77,239,46,77,119,243,11,101,149,134,152,116,22,21,44,185,169,63,201,191,214,216,21,52,121,111,216,161,9,194,58,188,96,210,109,29,107,58,0,79,103,103,83,0,0,0,238,0,0,0,0,0,0,81,117,155,31,3,0,0,0,175,10,198,91,60,69,69,73,67,68,65,72,68,71,74,70,70,67,74,67,71,65,71,66,68,68,67,75,73,75,69,72,73,72,70,71,75,72,66,67,67,64,67,66,68,70,72,66,72,73,68,69,71,70,74,67,68,63,62,65,70,61,66,69,73,94,73,88,0,144,29,150,163,87,125,169,122,174,180,127,223,123,88,156,70,95,11,195,157,109,81,115,72,96,232,73,138,124,78,18,43,187,142,11,99,109,114,115,113,178,30,183,10,19,40,98,17,144,215,27,132,249,5,3,1,253,136,166,80,169,158,148,169,1,90,77,160,128,8,25,97,171,131,86,87,185,254,119,237,250,149,233,48,62,166,173,186,156,195,228,54,223,86,8,181,208,69,175,155,138,92,58,219,3,44,195,236,10,205,104,123,138,221,40,32,82,177,177,133,155,191,158,150,161,125,209,17,220,193,214,17,72,0,90,75,136,1,55,157,26,150,29,249,156,236,56,2,105,114,173,182,162,158,62,29,237,161,207,179,246,217,3,83,9,197,33,202,58,210,95,230,54,209,75,217,97,250,192,215,0,67,49,165,186,64,224,218,199,2,165,40,134,122,92,192,169,71,235,154,204,210,18,151,200,3,0,78,71,20,129,34,102,0,253,210,86,79,91,217,113,22,206,126,227,90,149,31,83,49,230,155,121,26,123,236,13,75,85,26,33,212,135,201,153,27,195,136,62,3,40,103,138,68,160,187,209,73,64,114,218,77,156,65,219,120,182,138,16,26,221,165,151,5,94,69,140,0,197,85,128,184,167,242,252,98,21,174,71,42,231,63,127,222,103,241,89,184,30,15,103,103,85,17,89,140,151,142,197,175,65,25,90,144,115,96,163,23,168,227,35,252,101,97,39,67,72,105,48,73,233,204,231,38,194,119,157,152,210,139,217,0,86,75,32,64,154,87,128,73,143,231,115,89,238,8,28,157,83,239,107,170,243,80,255,252,109,215,179,177,171,141,228,6,217,105,198,250,116,245,236,25,180,141,208,233,9,38,0,96,75,53,104,157,49,103,73,123,188,249,4,141,110,95,167,131,4,86,71,136,129,212,71,4,61,15,103,104,239,2,80,149,53,217,52,71,205,149,231,103,223,71,75,62,221,95,203,110,202,110,237,185,109,140,112,171,33,183,57,103,94,165,151,14,108,26,6,115,179,169,36,80,246,197,238,157,150,229,40,205,66,83,55,105,52,119,163,116,21,94,69,204,0,37,174,10,235,118,158,57,97,1,1,168,202,94,21,237,179,76,202,175,45,207,35,45,184,157,179,209,165,125,249,233,155,75,142,229,82,58,189,63,219,80,120,232,244,145,121,80,248,69,103,172,110,237,105,94,52,47,38,45,184,197,204,245,3,86,81,140,1,37,148,14,28,226,93,181,228,207,227,62,187,115,83,121,86,121,95,110,223,188,231,39,165,57,68,106,161,165,109,75,201,137,201,179,62,248,174,75,197,241,0,234,20,112,76,59,47,194,232,121,24,183,97,3,91,5,2,75,251,233,253,109,234,200,160,7,86,77,76,1,132,246,10,84,231,140,199,131,112,24,156,200,51,150,104,227,234,223,219,254,158,218,218,88,207,220,173,177,153,160,158,159,30,22,65,79,28,236,68,150,86,23,165,96,88,139,203,174,203,0,236,111,55,114,130,8,225,219,45,141,5,140,77,113,156,253,70,48,7,0,86,81,200,0,132,117,133,137,234,57,39,79,12,48,56,49,243,169,9,75,118,190,98,223,254,33,244,124,44,137,202,152,218,219,77,234,176,22,66,100,186,209,7,156,51,100,183,98,131,33,242,129,32,24,6,35,121,199,88,105,221,184,226,222,140,217,124,40,144,0,82,73,196,0,109,94,7,172,125,57,119,30,14,9,168,170,252,200,110,235,47,221,182,170,223,185,36,150,255,64,65,2,235,109,117,230,126,250,206,178,180,48,20,180,226,175,107,212,27,10,160,95,207,2,197,149,239,212,11,205,34,14,39,132,119,244,136,38,5,0,90,69,10,1,244,50,193,186,117,125,30,171,5,9,180,170,95,120,159,101,143,218,82,157,121,243,52,195,13,181,167,92,212,119,67,11,11,162,111,103,144,37,160,151,198,19,250,37,192,185,154,130,82,44,247,55,11,157,116,142,112,78,167,193,12,29,0,82,77,32,0,180,28,152,211,129,156,131,53,130,52,168,85,158,187,120,106,242,251,19,207,191,29,235,210,225,43,39,105,173,32,159,83,209,100,151,103,112,232,47,96,91,32,142,110,13,148,248,213,119,64,159,240,166,156,40,165,149,40,20,145,16,106,29,96,183,199,73,24,76,0,86,71,130,3,211,61,32,212,66,156,97,56,140,24,75,53,45,203,63,53,183,57,82,151,170,105,219,153,233,136,153,24,137,214,243,23,76,43,236,24,17,248,165,192,100,126,246,107,119,153,175,36,197,212,155,62,249,14,44,207,254,116,244,2,78,3,29,86,69,132,1,76,62,99,223,165,239,156,252,96,156,52,213,255,86,71,83,226,171,239,234,143,72,211,90,254,116,132,40,44,189,133,68,128,102,213,2,5,172,3,64,244,102,163,97,195,182,70,119,218,162,194,226,3,167,48,237,73,111,229,228,53,94,242,245,34,11,1,94,67,68,40,152,121,204,176,110,56,67,13,50,64,131,26,215,250,203,142,39,38,101,237,126,219,162,51,121,147,21,17,54,158,74,76,185,210,121,96,110,37,4,38,76,228,9,213,186,192,156,94,189,220,136,56,18,208,44,34,61,26,87,160,3,106,73,10,217,52,211,25,17,25,220,7,59,0,218,84,75,243,38,223,247,196,247,124,125,111,68,15,125,26,130,182,98,247,125,58,16,44,53,230,149,13,57,121,7,10,168,132,139,14,78,89,116,192,196,189,146,52,98,232,220,105,186,222,21,137,150,170,206,44,18,0,82,65,40,130,98,126,4,244,86,159,206,6,200,164,85,189,87,188,42,173,150,229,92,162,73,245,72,255,77,110,137,49,182,205,37,12,73,241,59,152,29,96,7,176,219,170,163,64,99,182,136,8,22,27,213,93,139,150,5,251,92,76,19,208,156,7,70,69,4,3,101,30,21,19,183,190,253,112,146,171,37,85,253,126,237,147,59,186,137,243,255,107,183,62,142,223,199,108,70,4,59,176,82,179,61,54,195,132,155,202,24,16,44,152,192,252,161,18,128,182,229,95,35,2,198,100,66,193,51,210,253,183,6,0,90,71,130,49,130,88,58,221,236,251,121,231,154,3,111,21,225,156,168,19,115,222,214,138,71,219,165,43,53,197,58,66,146,3,140,177,18,54,241,139,176,91,211,0,150,208,159,142,16,101,7,208,154,215,45,209,105,205,221,190,73,82,209,104,133,164,3,0,82,71,142,178,30,69,239,214,104,239,155,106,107,36,64,129,141,171,126,207,225,157,213,51,239,154,29,213,44,102,93,244,98,235,147,100,201,2,118,127,168,21,251,0,155,157,129,30,114,59,164,1,88,239,5,64,19,180,148,0,199,131,182,216,196,60,0,90,81,74,49,162,94,14,146,165,234,115,42,98,128,170,149,109,176,184,245,115,252,60,237,100,221,191,223,99,107,60,228,23,68,250,60,231,144,201,55,121,219,70,30,14,66,171,205,191,9,192,151,14,104,19,249,185,241,196,14,137,233,12,17,13,36,66,178,189,176,73,246,133,6,0,94,87,206,241,168,245,54,179,140,84,191,106,139,72,48,85,145,230,68,110,133,43,123,181,95,179,180,89,39,66,210,180,138,21,219,225,249,91,136,93,61,140,47,139,19,233,130,195,212,19,38,131,15,0,126,147,21,98,173,144,63,170,159,83,73,207,9,12,244,182,227,30,0,94,85,78,41,186,155,214,129,37,168,182,218,26,32,86,45,105,181,228,211,215,100,235,89,255,246,201,215,108,226,199,255,157,184,200,137,85,42,155,234,57,45,87,57,234,71,96,74,109,154,241,1,64,3,40,86,160,123,57,95,206,57,149,87,151,14,40,187,157,81,227,196,161,29,0,70,71,10,209,204,166,54,67,85,173,135,51,36,132,8,168,234,253,191,236,29,42,173,199,249,180,29,211,50,188,99,161,241,128,81,67,199,165,88,97,162,244,125,61,193,245,193,53,0,170,38,54,233,102,52,250,84,231,53,17,154,49,71,17,249,179,161,1,0,78,71,10,64,0,29,44,222,41,6,44,120,178,167,106,243,53,109,60,150,167,205,214,118,137,186,101,217,25,86,104,103,234,174,33,224,49,124,18,12,73,29,144,52,153,41,208,135,224,100,90,0,185,196,53,201,179,14,179,184,82,112,88,54,101,67,209,20,154,210,76,0,78,71,18,131,84,99,196,73,114,114,167,22,176,139,68,203,83,155,229,212,138,214,237,237,191,101,217,174,125,208,200,117,134,180,175,17,53,94,117,172,117,252,104,101,194,66,106,168,237,131,39,144,44,203,31,176,145,57,190,224,10,137,126,88,12,55,217,137,11,173,53,13,0,62,79,26,211,230,66,141,72,25,156,2,56,20,81,7,45,89,75,69,116,75,59,125,149,89,150,241,253,11,138,68,170,89,167,153,197,225,46,208,43,187,144,52,19,176,3,232,0,169,104,86,233,58,69,13,102,131,112,7,46,82,56,119,246,78,185,214,20,177,51,92,2,74,77,202,3,45,150,128,193,235,132,115,128,168,32,209,170,236,172,153,136,253,127,100,183,223,217,158,107,117,235,238,237,36,199,142,248,185,251,52,69,199,200,112,199,132,53,76,155,207,65,128,9,43,3,32,91,14,20,93,103,2,239,127,115,52,80,216,219,220,7,78,79,140,3,165,15,5,251,221,112,46,0,70,36,98,170,172,185,47,104,214,55,95,191,154,118,166,165,82,44,251,66,102,168,110,95,117,134,235,57,97,210,89,105,218,68,132,121,125,89,131,38,87,42,186,160,104,205,86,49,173,189,148,224,221,40,122,98,56,82,2,78,71,138,115,38,209,20,193,186,61,221,111,0,242,221,43,4,46,215,148,69,115,69,188,183,237,56,247,8,115,204,149,59,13,147,70,223,11,189,206,167,47,70,9,86,208,10,241,164,178,189,2,61,192,180,228,160,97,218,5,59,183,241,64,60,178,116,141,83,52,105,102,63,10,0,62,71,12,160,15,61,103,216,106,167,229,148,192,228,85,73,72,162,46,247,119,218,202,158,55,59,82,255,235,214,69,247,32,115,61,205,176,75,159,126,254,56,52,233,56,61,23,78,12,202,92,25,3,183,153,58,129,89,30,5,43,52,104,27,178,63,73,148,208,96,78,0,46,69,24,4,61,233,118,0,223,231,157,35,128,167,172,70,145,170,254,47,41,93,203,115,52,109,236,200,201,113,5,89,174,66,14,187,120,4,165,253,52,40,49,85,162,128,178,177,205,217,128,161,168,1,169,161,0,162,101,215,168,67,234,54,2,18,90,69,1,73,53,169,109,166,208,122,168,182,1,60,165,64,85,99,210,113,157,220,187,255,235,177,200,110,28,218,119,148,236,105,144,11,210,70,106,253,248,119,140,87,138,100,20,0,118,105,1,226,132,55,98,246,170,7,92,246,222,137,217,40,58,5,0,74,71,12,193,162,152,29,180,198,91,26,212,111,203,211,169,207,194,191,115,7,195,252,85,113,82,165,189,39,179,185,176,142,251,197,133,222,162,135,199,4,90,107,69,185,123,13,64,123,82,145,124,243,156,25,196,183,66,40,74,17,93,244,100,99,121,0,82,71,134,16,221,205,227,128,181,115,238,227,192,109,57,84,101,219,253,51,87,154,163,203,246,95,35,181,196,201,134,224,193,174,77,220,66,167,198,243,209,96,184,80,79,52,0,108,13,26,211,73,20,63,241,166,190,125,49,167,102,18,10,18,74,69,78,82,97,22,199,4,243,222,171,118,3,196,214,130,27,212,120,98,92,107,60,189,101,121,99,126,109,83,73,75,167,108,85,23,48,227,224,247,16,128,69,122,67,149,178,57,6,70,1,112,155,30,138,47,0,228,148,112,221,52,223,126,23,152,0,66,69,8,1,237,178,15,88,111,238,28,1,8,145,137,6,53,84,218,219,61,95,238,199,245,222,254,219,119,18,133,246,33,77,100,44,174,92,248,96,166,253,210,1,97,58,46,115,20,128,243,242,5,132,121,232,166,2,27,145,230,227,250,116,222,3,82,71,165,164,245,44,120,39,162,83,170,61,64,80,35,166,234,26,89,56,250,111,217,159,103,109,90,171,133,98,137,138,29,226,241,188,2,142,203,178,131,189,5,184,4,85,208,250,254,0,0,122,179,208,104,199,65,193,149,25,161,11,136,162,104,152,2,0,74,75,140,10,84,161,77,20,147,202,57,37,128,127,73,109,208,188,79,123,236,213,31,149,181,183,102,221,43,173,174,107,40,78,43,84,112,233,236,75,134,57,156,229,33,82,32,18,108,172,27,233,0,102,174,213,232,80,26,36,96,38,166,249,201,124,104,68,121,2,98,77,138,19,220,132,206,164,66,185,115,2,231,214,164,54,213,60,85,187,44,253,149,186,230,86,71,151,172,109,242,17,151,11,115,177,111,152,212,52,249,78,10,19,236,7,60,58,224,87,182,136,95,128,234,136,69,144,142,73,94,240,186,169,109,21,157,203,169,137,84,0,82,71,132,162,154,41,187,141,20,220,169,28,64,156,34,193,84,111,147,214,138,188,59,254,117,215,16,23,76,137,165,180,196,184,205,26,73,10,90,16,14,20,0,26,22,94,136,54,96,151,175,241,26,82,127,104,202,212,124,3,69,79,101,49,241,0,82,81,202,146,217,132,22,108,12,10,86,91,4,114,80,32,89,91,236,250,120,103,210,109,63,38,101,167,98,77,19,247,107,47,155,121,118,74,181,176,2,19,251,1,36,186,166,133,5,69,179,206,190,81,120,15,47,112,95,184,115,46,75,210,64,60,144,105,216,22,26,0,94,81,78,43,61,50,209,78,29,77,85,109,2,22,236,180,202,221,243,138,118,79,217,186,159,125,119,45,171,115,84,83,249,10,126,111,180,169,155,207,0,75,184,169,163,51,1,31,236,105,104,128,84,250,203,243,194,7,194,194,178,145,27,245,82,194,112,179,156,122,210,27,0,90,73,74,243,26,53,165,156,34,206,190,106,235,4,152,78,210,170,78,231,88,83,219,95,158,182,237,4,154,91,143,228,214,30,119,65,88,74,90,166,163,247,189,65,235,192,9,220,158,9,38,168,239,239,249,170,225,5,210,20,26,72,83,217,56,43,52,0,70,79,20,131,8,34,246,197,222,39,3,22,144,42,207,166,110,95,35,45,71,243,157,77,219,253,199,69,96,139,160,132,142,68,128,197,10,67,0,250,106,160,152,192,131,117,211,1,114,185,55,147,89,52,202,216,159,188,151,74,196,112,88,12,147,231,189,4,0,70,81,66,210,84,129,138,57,29,200,105,1,140,72,141,161,234,47,127,151,247,91,173,251,209,95,115,191,22,37,230,174,129,161,183,246,241,162,14,236,44,165,41,0,109,87,3,10,240,7,189,143,192,171,56,120,73,49,77,98,223,216,46,152,74,126,17,178,46,81,0,86,75,165,166,106,87,123,71,218,151,78,181,5,14,99,175,27,169,234,186,60,87,77,242,124,87,52,251,149,87,166,177,240,4,51,97,72,185,112,12,63,157,125,32,33,171,108,2,133,44,96,83,104,74,44,57,28,20,58,22,119,14,111,190,185,208,25,14,169,1,82,69,78,178,48,153,236,130,245,74,156,22,36,164,104,43,210,146,186,238,19,219,18,203,25,149,55,203,51,171,194,42,13,52,143,233,201,128,118,53,10,109,42,9,208,61,31,183,43,168,195,143,132,68,196,212,43,241,246,37,5,128,4,56,96,147,217,155,55,153,215,175,145,0,90,71,6,113,211,142,156,144,244,125,222,169,192,64,146,24,170,238,81,239,185,150,51,82,183,172,77,90,62,97,81,151,52,107,227,219,230,68,185,52,181,119,38,235,93,33,40,2,7,128,149,62,160,202,117,226,1,125,210,136,249,192,107,220,18,39,1,86,79,9,240,120,161,179,35,232,244,156,75,0,200,69,141,150,171,123,227,176,182,204,151,71,229,103,107,109,107,183,209,40,219,15,145,75,162,96,66,95,152,48,138,12,54,6,130,118,32,231,49,25,98,78,143,131,240,231,245,116,28,141,169,121,10,2,0,82,71,138,50,29,188,180,11,182,182,159,196,55,8,72,231,161,172,245,156,101,233,87,158,74,221,219,220,254,189,102,108,13,121,17,148,113,239,150,206,4,125,165,144,208,26,18,248,54,116,8,72,210,131,214,223,142,136,116,161,11,232,0,82,71,140,50,52,173,103,240,124,115,42,112,144,12,75,43,250,111,28,105,102,158,108,237,111,191,154,116,228,43,11,10,18,186,141,128,78,120,26,85,126,46,109,6,80,80,7,128,62,194,144,8,44,54,57,103,210,59,94,122,65,3,74,69,206,82,189,170,211,140,44,63,185,115,17,112,190,76,217,170,77,22,177,172,53,77,251,30,217,22,73,87,75,48,236,156,75,167,16,85,230,0,11,236,41,4,70,35,240,120,1,64,59,28,120,2,20,166,15,31,128,238,244,40,152,58,0,90,73,88,2,3,1,116,200,54,82,245,69,14,223,239,57,247,37,11,238,85,93,48,44,54,167,86,114,159,212,101,77,117,211,146,94,198,102,181,194,154,44,72,12,80,122,166,66,1,191,184,52,139,113,121,166,137,62,224,148,135,78,64,255,193,239,169,67,30,0,90,71,0,32,240,151,25,217,213,115,130,128,248,34,8,178,214,170,246,146,234,252,255,143,111,223,183,186,39,186,25,231,201,117])
.concat([117,29,151,160,160,230,194,4,169,8,249,160,174,222,2,36,28,56,30,98,122,93,209,250,206,1,0,86,71,10,136,210,226,203,21,217,229,58,159,227,72,124,200,90,207,181,185,231,217,122,124,222,57,254,115,46,10,75,119,41,7,16,172,117,78,93,155,221,178,4,106,46,60,0,125,198,227,185,93,105,10,152,0,31,208,124,43,49,27,109,186,160,1,90,81,12,3,133,105,2,122,201,233,28,224,65,205,148,231,181,164,248,89,165,57,255,241,93,253,210,154,204,156,41,218,75,184,114,10,149,96,32,129,145,90,28,114,124,1,147,110,49,55,110,166,9,76,174,105,52,27,137,165,32,161,102,154,140,160,153,9,0,82,79,196,83,136,217,2,182,69,157,249,12,9,22,199,80,185,125,178,84,164,182,237,158,190,89,255,13,67,60,200,38,230,93,240,217,248,93,48,232,53,224,219,77,9,179,46,1,69,95,26,102,7,22,249,94,120,215,33,233,76,43,204,57,38,21,213,18,122,70,152,34,1,79,103,103,83,0,0,0,102,1,0,0,0,0,0,81,117,155,31,4,0,0,0,59,233,0,225,60,67,70,70,70,71,65,67,67,66,71,75,67,70,68,66,72,67,71,72,69,68,63,67,63,71,69,68,67,70,67,72,64,72,74,73,70,71,76,65,68,71,66,64,65,67,69,73,70,73,65,70,69,74,72,66,70,64,64,66,72,82,81,202,67,117,81,2,214,170,164,125,200,52,207,101,126,251,17,67,241,116,119,120,58,87,44,145,229,38,54,19,59,206,41,239,14,198,90,179,72,155,10,32,39,112,245,200,173,164,14,248,80,192,2,211,202,182,174,25,232,200,122,145,46,241,26,0,90,67,33,146,90,93,84,192,22,180,69,113,78,54,96,121,130,173,102,251,172,223,114,104,102,182,26,239,226,20,199,109,13,62,115,74,179,55,198,158,73,44,174,107,234,128,89,128,162,4,95,123,3,103,69,3,77,151,186,26,103,163,41,22,208,201,210,164,198,4,86,81,74,82,161,170,58,90,108,75,255,57,37,2,176,5,174,22,155,202,231,191,168,170,175,233,219,62,174,157,221,42,36,244,241,65,242,151,12,53,39,36,135,97,224,15,248,33,1,19,5,13,174,101,106,100,87,157,201,173,139,95,233,105,101,218,40,114,82,0,82,73,138,210,71,119,72,167,171,202,95,115,39,124,224,214,157,161,234,109,89,218,127,90,212,218,126,41,31,177,41,236,45,76,215,136,15,246,156,66,207,39,65,125,106,55,128,208,17,43,66,153,192,232,0,128,109,87,36,144,124,106,249,18,138,51,171,186,72,0,78,83,76,224,162,93,124,134,217,225,158,10,56,184,247,201,72,229,222,179,180,28,107,168,137,165,249,123,98,187,162,148,42,107,39,116,168,168,64,141,78,205,14,117,20,146,109,9,248,7,104,55,5,194,64,41,102,87,253,17,143,155,179,23,214,84,138,185,224,200,3,86,85,134,225,168,116,157,92,155,181,35,247,84,96,3,104,80,162,108,181,62,187,166,45,179,158,153,166,143,157,46,139,102,43,54,167,214,58,198,147,210,24,42,128,38,183,93,231,0,102,209,25,64,247,122,233,146,158,187,162,36,111,232,165,3,82,85,138,9,189,147,235,76,95,131,246,123,236,128,242,73,173,114,183,136,188,107,76,171,238,199,39,175,123,145,89,167,104,7,164,21,50,48,212,96,27,0,251,1,0,133,2,210,7,15,51,121,129,198,79,20,3,235,42,130,179,178,204,238,26,18,0,82,81,142,210,84,234,245,74,77,114,110,80,129,173,203,81,229,230,161,253,87,148,244,52,113,228,207,171,237,221,117,72,201,196,223,111,176,167,38,55,4,58,0,54,142,230,10,192,91,104,165,165,55,149,142,208,200,6,0,65,210,245,191,134,38,53,0,82,73,106,10,42,235,47,72,59,40,125,145,31,76,149,217,42,73,89,99,185,142,73,147,246,53,91,75,123,48,221,57,211,38,208,215,180,173,142,240,155,63,35,1,99,0,49,0,252,82,11,128,28,43,17,103,221,62,148,2,104,4,52,165,60,7,82,73,102,133,212,206,227,11,150,91,85,167,97,128,183,173,12,36,101,223,218,188,95,45,79,53,237,213,244,183,212,83,177,104,205,193,201,101,191,171,7,193,140,26,45,96,67,128,189,244,134,193,156,173,39,244,147,207,245,242,82,184,0,208,27,220,124,146,182,232,1,90,77,138,3,196,122,32,164,19,206,45,75,64,187,172,135,20,220,60,164,247,213,84,234,175,219,249,221,126,111,214,108,213,137,214,187,120,158,166,230,60,142,58,120,112,80,119,103,44,16,100,96,154,11,141,57,157,204,222,149,218,187,206,144,108,41,8,65,189,49,202,163,172,104,0,94,67,202,74,250,85,20,56,19,233,204,115,50,128,108,8,156,112,149,155,91,219,252,127,233,176,181,205,117,37,19,185,44,1,152,24,47,3,62,26,96,5,220,85,217,117,10,184,162,163,40,183,49,173,226,13,93,7,120,64,104,35,120,160,152,29,0,50,71,182,2,162,218,55,150,173,69,206,73,54,4,190,36,38,69,106,54,177,228,141,188,187,150,243,159,213,245,194,219,140,65,20,98,148,168,197,177,20,248,44,0,101,11,160,12,125,30,112,175,110,112,74,48,228,183,89,227,42,104,104,144,193,79,18,51,32,0,86,71,76,51,76,87,175,152,180,54,252,56,224,233,213,224,68,253,41,89,59,199,210,215,217,45,253,127,216,131,237,9,132,92,154,114,20,145,111,22,176,161,4,224,162,219,30,160,36,84,199,160,71,115,85,197,68,239,219,232,53,29,229,59,87,136,9,0,78,69,148,2,191,93,141,184,59,39,125,10,158,128,192,104,213,237,167,25,210,132,255,149,53,205,111,195,120,141,212,59,143,254,202,58,252,51,18,224,1,192,172,186,38,0,244,50,187,222,32,47,126,32,87,0,116,230,103,85,167,120,89,156,41,0,82,75,72,91,221,110,52,71,210,144,233,115,82,1,44,105,110,18,186,117,109,255,169,186,51,183,111,221,239,36,141,86,65,110,223,45,191,131,213,17,171,38,1,211,28,12,90,139,131,176,90,12,48,45,163,160,158,157,104,34,49,51,197,244,39,70,14,134,148,188,18,25,90,79,2,75,20,29,191,49,106,62,103,0,213,136,169,50,223,186,231,77,245,77,204,154,255,183,245,104,15,245,105,78,6,136,161,223,108,74,224,158,12,80,239,103,5,100,36,73,3,176,249,177,130,225,70,150,180,11,0,77,51,57,103,182,249,77,7,98,75,1,27,19,183,51,210,173,211,213,38,2,2,193,80,78,252,183,241,239,27,218,244,164,238,249,218,229,244,98,65,99,59,231,118,42,238,10,120,10,29,192,28,10,139,20,204,45,38,196,43,192,236,173,44,182,85,173,167,182,12,48,184,35,170,186,217,53,15,1,70,77,192,129,221,40,13,203,149,125,238,42,7,142,196,185,105,254,207,57,18,154,173,25,217,118,163,27,157,118,15,141,66,38,75,137,123,196,119,144,62,197,40,26,4,83,210,150,221,5,96,194,234,150,131,233,117,135,153,161,28,64,66,58,102,9,229,171,90,16,154,0,82,73,8,27,181,152,228,53,37,56,213,128,49,163,53,181,123,183,37,141,180,198,236,255,163,219,111,201,198,241,9,115,177,214,168,115,51,233,234,81,176,235,28,16,218,98,187,42,249,0,74,144,94,151,56,219,41,211,26,104,147,152,196,116,249,189,89,134,9,106,69,138,91,24,157,95,84,107,221,242,45,18,99,237,81,219,172,148,142,174,73,245,164,227,217,110,99,135,202,44,7,164,60,5,43,210,212,55,190,9,54,153,24,177,88,193,182,146,238,0,9,140,189,83,1,72,128,249,164,39,171,9,153,72,174,33,0,106,87,74,120,80,23,199,20,235,121,157,75,3,102,158,23,100,234,151,92,145,218,122,146,186,159,213,200,42,222,152,176,136,169,54,84,3,223,108,83,7,101,173,76,128,119,138,137,134,182,149,90,2,128,208,185,144,35,75,213,38,60,0,110,87,9,184,81,55,14,68,178,92,246,23,19,144,212,203,181,50,83,118,181,215,211,39,93,27,75,116,111,33,75,67,97,39,64,21,223,124,188,132,51,244,116,108,4,201,59,112,112,218,4,160,255,40,16,192,127,14,4,158,196,252,92,27,82,65,3,98,83,134,90,147,137,229,139,100,251,109,159,107,128,20,75,84,166,179,212,188,79,138,223,102,127,191,68,108,31,182,209,81,152,98,167,44,225,186,148,230,172,64,147,48,128,101,128,6,192,74,157,14,9,55,198,120,111,192,9,175,134,4,102,75,130,72,16,213,23,197,22,231,0,60,197,34,37,207,230,222,194,218,154,245,122,228,233,127,155,79,43,45,113,164,36,74,60,26,55,2,251,47,137,156,40,9,244,210,53,236,122,147,114,8,134,107,0,93,163,14,224,49,9,136,203,157,228,117,185,46,5,5,0,102,85,74,41,147,18,120,117,104,246,67,231,2,224,67,145,108,83,223,141,117,226,75,255,105,242,78,17,159,250,17,22,97,230,16,18,211,36,166,159,144,106,140,2,204,54,155,64,113,22,47,2,119,151,30,248,176,161,3,131,250,22,59,229,160,235,199,55,0,94,79,140,201,170,4,102,215,104,93,28,167,178,128,59,5,90,233,244,46,93,205,19,217,49,215,187,92,82,78,38,124,134,50,115,55,152,198,103,199,4,29,192,78,65,151,97,67,54,21,47,212,67,78,70,13,243,79,57,78,163,71,235,34,136,143,2,0,82,71,32,148,46,130,95,93,34,137,106,27,0,183,147,74,167,41,171,88,150,88,167,109,147,124,121,205,151,26,156,3,201,236,85,49,0,111,200,162,16,206,70,152,26,48,116,113,17,224,166,100,95,135,125,86,138,60,121,13,69,24,163,161,240,14,0,86,69,200,42,49,169,17,220,187,200,183,231,148,233,1,232,212,44,83,221,51,103,111,139,154,37,61,191,58,118,151,105,111,170,42,17,39,28,0,98,197,32,10,209,209,117,1,216,94,97,170,0,141,249,111,137,129,95,198,132,14,78,29,223,62,157,3,69,1,0,102,79,194,219,20,122,24,157,127,215,185,8,96,180,147,76,181,105,234,151,102,139,234,222,239,188,126,222,160,238,185,135,0,125,150,57,56,68,198,232,52,179,179,33,193,1,172,221,64,41,191,152,54,28,138,0,197,130,18,94,47,130,130,167,77,18,0,90,83,12,27,29,122,104,186,9,231,34,128,101,166,84,229,222,210,155,165,173,25,157,45,91,150,219,104,57,49,20,201,219,25,125,75,165,238,222,171,179,63,205,197,0,5,54,91,13,96,191,0,206,75,66,215,53,213,77,138,150,161,176,109,14,123,125,35,81,146,227,1,58,73,86,130,34,14,64,223,194,185,101,192,188,14,210,169,172,255,103,15,241,76,147,29,71,242,175,45,89,238,48,42,157,61,205,72,50,130,68,103,198,92,192,120,180,84,160,103,84,237,147,33,133,248,132,41,237,229,68,211,85,136,75,0,86,73,88,107,20,42,103,42,91,248,53,2,204,131,214,212,174,73,107,223,70,122,162,157,251,21,123,57,115,200,29,152,87,94,55,14,165,55,41,230,92,161,9,118,0,246,183,124,227,32,249,140,212,58,155,18,81,54,218,1,232,74,233,202,41,58,223,69,14,11,9,0,90,77,224,109,18,15,64,207,250,10,192,34,145,106,209,178,126,105,186,231,105,82,30,121,125,179,51,133,97,202,186,161,26,69,51,77,168,237,13,182,111,75,30,224,199,189,2,160,49,166,181,194,44,54,21,157,166,155,200,138,177,116,100,225,13,100,245,210,199,88,32,75,152,0,102,87,12,123,40,98,81,64,83,159,11,0,193,192,37,114,215,198,228,181,221,98,191,109,223,177,47,245,92,51,113,160,25,10,234,56,101,68,251,35,240,231,167,181,200,0,250,94,253,27,44,186,198,57,116,165,136,180,85,82,213,81,11,120,210,198,91,75,195,101,217,61,0,106,91,2,121,147,194,53,34,105,62,151,0,16,121,154,144,19,57,203,99,174,188,105,106,203,179,35,111,238,223,131,132,85,104,89,176,150,62,81,88,112,156,109,119,189,112,124,165,189,16,192,194,96,184,210,92,243,147,148,244,206,197,202,161,0,127,231,132,35,1,110,87,204,199,110,252,16,202,214,182,125,42,0,30,161,130,156,240,100,111,164,182,173,35,142,61,255,229,95,45,167,145,245,199,190,72,80,199,53,75,185,7,84,26,212,224,54,27,204,151,212,166,78,167,124,201,196,254,50,71,179,201,167,90,213,25,240,130,114,165,3,102,85,140,250,84,193,181,99,187,205,231,2,64,176,76,38,5,215,236,38,197,26,105,93,223,229,23,217,106,239,153,80,4,145,142,88,24,253,18,108,27,83,160,243,152,50,201,216,5,172,234,49,32,70,183,127,139,5,166,201,97,47,33,17,232,84,180,34,202,53,20,254,88,76,0,0,102,83,96,34,197,60,207,216,222,3,254,6,32,88,160,68,237,206,154,50,207,237,122,22,151,125,212,36,122,172,33,244,162,44,148,176,91,117,38,184,172,2,220,126,104,114,22,115,99,163,197,95,21,151,143,166,120,108,21,102,224,104,58,26,0,50,73,17,1,51,203,140,121,47,244,92,134,52,64,0,45,218,252,230,254,38,105,142,255,115,59,178,77,181,128,214,95,72,90,212,169,58,110,217,61,245,135,250,226,131,128,232,108,210,186,10,100,144,18,38,160,211,67,251,157,70,67,247,24,76,72,4,0,90,71,8,57,41,102,61,163,227,88,76,181,79,96,212,113,82,213,179,169,38,159,185,111,217,251,115,223,126,213,173,223,246,77,153,243,221,168,124,111,153,122,182,226,80,90,226,88,166,166,246,0,208,236,25,67,35,17,58,232,244,134,142,118,215,96,177,222,40,104,0,58,69,146,202,158,244,101,66,242,25,87,109,50,28,154,160,57,81,150,183,243,180,125,119,59,83,214,222,151,190,207,231,231,4,169,55,107,170,175,85,33,223,97,74,30,38,152,74,58,61,1,96,101,104,192,161,65,167,105,36,143,80,111,223,156,0,82,73,146,56,73,90,119,100,175,222,231,1,185,221,181,68,217,119,244,179,182,213,54,219,251,197,122,169,149,231,27,129,108,177,194,44,226,160,49,216,200,208,17,221,178,126,158,166,136,56,96,171,128,162,111,129,163,97,22,132,244,13,179,16,58,69,154,2,19,36,34,107,122,231,166,62,0,224,170,238,183,235,246,46,139,200,175,107,79,217,12,196,176,40,108,85,180,10,13,11,186,66,249,96,83,3,5,204,0,0,227,74,247,101,90,158,40,116,60,62,197,188,217,113,221,146,110,145,4,82,79,28,219,164,222,42,101,242,197,39,13,0,121,90,53,251,107,166,221,38,246,183,93,218,126,89,6,56,27,23,247,125,3,116,183,75,61,169,173,166,20,16,16,148,128,152,64,242,4,132,87,24,126,47,211,140,93,52,253,176,207,57,227,50,9,0,90,71,64,61,189,152,9,244,236,150,205,57,112,192,22,82,174,46,205,191,189,73,233,139,107,107,251,62,48,210,110,15,194,179,41,38,59,234,117,97,11,224,129,75,143,30,192,162,97,129,141,35,108,212,43,116,83,193,115,40,97,80,161,133,233,169,243,18,0,86,75,160,221,115,81,75,176,33,171,83,206,17,192,177,22,85,237,122,219,218,182,233,106,42,123,118,80,255,90,251,118,66,221,106,118,93,83,121,41,177,113,33,147,243,104,217,36,227,159,70,111,76,210,28,177,128,103,241,190,166,80,177,111,210,152,184,142,86,146,190,160,0,94,85,132,59,231,84,71,180,33,75,222,169,24,128,64,7,85,158,243,31,223,84,60,237,108,203,175,196,150,76,29,138,180,242,125,133,203,78,83,49,226,20,176,53,22,80,3,2,29,142,9,113,121,52,83,151,233,203,159,171,106,153,35,136,106,42,157,233,74,1,110,85,138,121,38,215,243,112,197,105,245,214,185,136,1,214,144,42,183,182,121,190,105,39,101,79,252,22,135,38,151,93,153,217,173,128,175,136,146,217,10,139,73,56,209,48,188,15,20,192,192,210,77,96,186,164,54,188,40,135,129,41,236,107,139,81,34,4,209,200,215,56,0,106,93,10,121,98,17,6,238,13,117,175,218,18,1,115,75,82,162,44,146,244,165,106,158,237,104,182,188,214,9,183,104,220,73,244,95,161,162,221,29,166,229,3,216,110,96,104,192,116,131,245,132,168,80,96,210,90,253,180,205,166,166,124,15,104,122,95,137,240,239,70,123,165,135,84,169,182,52,0,171,145,133,40,251,82,173,103,197,28,203,243,191,237,105,185,106,30,208,244,98,49,234,41,110,67,143,131,4,37,99,54,133,164,197,60,167,189,0,216,182,2,208,255,12,236,207,210,104,80,65,91,129,0,58,0,110,93,42,248,116,163,188,83,80,61,213,150,6,32,35,147,156,88,124,242,115,29,177,222,159,174,233,155,236,95,187,39,84,67,246,154,241,109,41,6,121,186,147,112,51,155,83,72,163,1,238,57,125,138,20,194,134,190,253,248,15,79,8,54,89,138,135,2,0,102,85,66,25,40,218,103,24,169,250,92,3,137,90,146,42,207,10,201,186,254,246,127,109,179,237,23,29,113,85,134,200,179,48,63,44,249,174,136,45,22,42,56,106,75,246,217,228,31,30,128,175,0,76,197,64,75,190,53,66,81,167,105,205,166,131,49,177,90,135,14,116,13,0,86,81,90,128,38,132,11,82,170,84,219,28,144,180,72,174,220,227,84,79,108,89,93,231,253,214,84,59,63,238,173,99,190,21,235,120,37,67,95,141,5,128,77,189,193,36,177,14,221,1,128,117,29,48,185,98,35,97,170,146,44,26,181,254,231,240,174,204,127,239,19,0,74,75,86,1,195,244,130,140,170,171,45,36,192,12,45,209,252,110,239,217,153,253,241,236,239,19,73,166,226,188,253,132,188,25,159,77,158,174,139,216,16,19,28,224,77,184,57,193,200,227,187,7,6,90,198,8,39,194,253,254,140,79,27,26,10,0,66,77,62,1,77,236,175,200,83,61,213,150,10,16,146,64,170,220,239,42,227,251,159,217,241,236,173,74,142,218,201,253,216,214,222,33,197,3,209,33,116,246,96,130,29,204,134,220,22,0,176,169,1,4,54,59,140,226,136,159,59,238,156,118,250,156,230,181,4,0,106,85,164,180,41,116,253,70,99,231,64,181,5,64,166,67,42,151,117,157,200,196,218,105,218,126,214,230,41,42,5,143,104,175,74,78,169,41,157,94,5,1,52,197,200,160,75,0,244,132,67,243,199,56,178,3,52,82,239,69,167,5,250,21,110,89,36,181,74,81,245,23,214,207,238,92,2,146,104,39,32,85,89,158,153,173,113,191,61,251,253,93,155,198,64,143,161,28,129,109,181,67,45,36,225,24,101,93,195,60,192,77,215,57,0,80,75,144,49,245,209,76,32,86,0,20,5,20,110,89,76,185,49,58,118,88,170,82,109,33,64,194,146,152,42,251,247,26,79,234,246,184,108,93,19,76,75,100,245,18,171,188,219,151,3,121,84,120,58,131,215,160,136,49,18,224,184,132,160,120,225,167,253,79,12,27,163,247,162,19,178,245,5,38,110,85,44,248,83,204,97,134,165,47,19,167,2,28,41,32,150,92,217,30,203,113,28,91,247,207,214,187,180,181,209,82,58,215,156,92,45,54,87,54,13,185,132,221,37,41,212,168,238,112,102,113,1,63,33,0,88,127,75,159,240,82,209,189,2,182,122,112,52,221,4,9,79,103,103,83,0,0,0,220,1,0,0,0,0,0,81,117,155,31,5,0,0,0,171,137,141,142,59,65,65,66,73,69,68,67,67,65,63,64,62,64,66,70,68,70,68,71,81,69,69,67,71,74,68,75,73,78,70,79,77,73,69,71,68,74,72,72,73,66,68,66,70,69,74,64,67,73,76,68,68,69,65,74,71,68,66,71,94,83,200,216,64,243,130,78,80,229,84,64,51,137,24,84,101,38,220,191,248,189,229,254,110,107,187,187,226,134,10,11,79,99,42,133,202,196,37,240,53,12,84,48,243,19,38,152,91,233,2,116,179,56,48,103,113,22,153,61,86,52,235,47,112,90,77,128,221,152,202,1,244,138,243,57,112,80,84,217,86,115,221,103,159,127,186,235,150,252,80,154,81,154,230,42,35,234,54,90,128,156,4,240,153,121,104,28,224,16,0,82,1,251,1,192,216,72,1,172,172,166,155,83,46,46,79,107,217,0,90,79,128,60,184,201,47,64,250,84,4,220,25,114,162,222,83,230,109,143,56,142,174,222,165,214,125,11,87,87,158,77,217,150,105,161,194,8,37,135,59,15,68,15,42,235,0,74,191,193,142,5,111,234,107,131,160,119,120,219,136,103,106,175,49,1,102,77,132,250,144,55,20,4,150,125,206,4,41,72,196,184,156,123,255,169,126,57,126,190,37,109,203,148,189,224,129,157,165,189,206,112,205,231,83,142,226,113,196,66,172,52,232,47,228,80,194,121,128,100,9,138,43,152,140,113,49,0,64,193,202,99,139,161,128,82,240,34,1,102,79,138,58,209,196,94,144,210,190,234,45,87,191,31,159,142,167,143,174,188,86,136,139,55,195,213,114,79,84,35,176,124,184,247,206,234,225,81,38,22,18,38,107,92,65,15,128,94,12,64,87,177,107,22,43,7,107,224,192,161,52,149,230,60,221,246,156,14,110,91,110,219,27,195,123,66,224,107,237,106,11,128,8,18,77,90,249,181,164,116,206,83,123,171,26,123,74,254,85,109,189,213,239,178,115,74,159,16,141,29,43,0,11,39,110,214,85,1,4,192,202,202,162,8,0,52,16,190,79,64,127,2,194,252,36,1,102,91,108,226,67,17,223,17,188,127,159,75,192,33,144,40,93,234,23,51,199,188,142,86,106,83,74,30,196,162,4,58,11,133,55,108,127,152,204,27,24,129,46,1,240,213,14,3,51,194,75,144,231,221,35,31,0,166,89,76,103,61,105,36,206,19,2,106,85,172,242,80,196,241,74,160,223,75,167,178,124,192,243,169,153,76,251,54,157,79,211,181,17,117,54,71,183,212,251,171,193,66,230,18,49,116,239,76,246,11,230,47,251,10,179,170,5,208,65,104,219,41,1,20,204,153,133,203,110,26,78,225,117,0,98,79,66,26,200,141,99,164,176,220,231,39,9,168,75,147,166,196,43,218,250,45,245,29,231,21,239,91,21,44,59,80,153,130,3,129,123,43,181,243,105,20,30,51,0,13,218,177,87,224,129,9,244,121,115,189,167,2,40,40,205,212,68,16,0,102,79,140,187,99,187,181,20,42,78,173,83,17,3,68,129,150,113,194,110,107,29,239,90,145,222,90,251,197,58,62,196,254,98,161,234,221,53,87,95,189,38,12,210,135,132,9,192,166,147,171,42,0,177,31,54,63,226,0,15,111,38,9,90,73,72,91,112,117,14,20,147,119,103,181,153,192,130,149,35,101,28,222,187,58,190,90,230,201,215,110,187,213,166,73,209,184,186,252,13,73,114,24,36,62,220,132,148,80,98,177,77,141,64,213,8,40,242,63,95,253,197,56,72,2,4,0,98,75,12,91,112,41,27,144,60,21,1,195,106,98,202,225,182,174,207,77,88,242,167,205,158,182,234,107,108,47,169,27,182,228,176,150,177,109,28,47,5,13,5,166,81,243,161,225,234,0,208,187,90,48,243,248,44,172,133,80,80,0,98,81,12,156,112,195,40,8,198,231,34,135,193,104,229,132,53,181,30,187,152,95,190,246,235,115,11,83,228,173,217,213,219,11,226,212,62,7,94,132,201,227,16,4,1,43,167,1,217,18,60,166,171,22,102,95,229,189,182,86,28,122,130,4,54,65,49,2,185,106,59,196,150,231,42,31,128,212,202,84,174,253,118,203,155,20,117,244,41,107,143,165,163,220,194,28,173,70,5,52,69,76,18,208,238,181,148,38,56,240,124,29,176,235,208,224,53,182,75,111,231,93,82,1,32,96,42,206,73,0,90,69,204,219,200,237,55,34,96,112,42,4,9,201,203,83,165,92,215,61,142,108,89,151,38,115,63,127,217,122,226,141,139,215,174,124,86,177,145,61,237,19,34,174,232,40,233,1,137,130,6,176,13,192,92,116,74,42,241,164,118,115,6,0,73,71,105,239,8,0,86,71,196,27,104,172,23,36,56,31,1,41,179,165,149,22,241,203,154,234,205,18,142,91,118,82,218,5,148,238,169,48,232,163,90,22,162,177,2,58,54,153,26,0,37,217,12,192,174,55,10,175,152,22,193,184,162,175,125,40,116,186,46,184,220,106,28,0,82,81,64,156,104,170,205,148,60,123,167,34,64,142,36,166,242,236,165,117,142,212,190,203,174,205,107,77,198,139,227,85,119,206,74,37,145,130,200,3,112,10,144,24,11,18,128,161,167,3,165,51,60,162,78,83,212,171,120,72,236,200,181,236,81,104,23,50,225,1,82,81,88,56,49,49,47,192,174,218,26,72,147,137,52,40,251,178,229,121,205,246,60,87,118,171,52,29,193,109,246,231,202,171,126,98,223,70,20,230,141,167,120,250,98,237,125,30,29,29,0,35,3,104,147,86,20,176,172,44,53,45,150,217,168,10,83,7,82,73,64,45,49,213,94,1,213,54,192,142,68,28,229,90,125,212,89,177,156,205,41,219,223,161,92,232,66,78,175,155,215,67,186,34,7,40,55,128,212,55,7,219,110,242,229,173,0,224,151,10,175,133,31,119,105,34,210,192,52,137,169,197,70,39,187,210,135,75,3,74,73,186,230,36,218,132,156,38,57,7,67,226,129,152,201,205,255,185,60,109,74,231,155,69,236,123,27,189,95,23,12,89,91,111,170,101,46,236,226,221,76,157,82,136,9,118,171,75,112,175,198,27,44,109,249,50,193,164,48,215,122,212,68,163,211,246,172,194,100,9,97,58,83,23,116,7,169,224,64,9,86,73,68,26,232,171,245,0,146,243,41,227,250,234,56,85,13,55,71,15,62,114,24,43,13,197,89,135,156,49,195,26,71,61,247,11,140,216,175,128,223,186,10,88,90,44,119,238,154,201,241,243,124,84,253,210,170,42,186,42,0,224,93,143,30,30,189,75,0,82,69,160,45,228,86,43,72,104,254,213,99,202,43,198,209,190,61,56,247,49,162,158,111,70,117,203,87,154,30,67,29,74,206,33,46,135,106,37,164,60,29,64,223,31,7,24,18,40,64,78,0,194,86,116,59,137,188,115,20,141,52,0,26,51,128,69,61,1,86,75,216,43,200,173,163,144,112,102,121,14,128,240,68,43,215,38,139,137,89,214,255,58,113,182,84,77,87,19,86,172,164,169,61,38,158,51,40,108,181,217,193,184,96,178,90,227,246,1,36,0,175,209,2,239,16,26,192,211,159,183,162,219,162,71,2,98,75,170,48,48,211,58,16,182,174,182,28,176,115,168,82,110,86,30,65,61,182,183,233,210,178,156,61,61,79,183,113,21,209,17,66,75,210,136,101,29,244,101,72,92,209,75,47,81,158,42,0,185,228,39,69,123,117,18,71,4,112,248,2,15,183,9,176,145,19,0,110,87,166,242,70,132,103,38,7,183,250,84,4,242,126,193,204,228,178,182,143,168,73,221,45,157,205,251,175,148,142,47,22,85,212,141,207,44,78,121,61,29,53,2,33,117,137,76,227,30,96,6,211,168,247,8,151,0,250,20,107,141,160,122,158,116,83,51,79,206,124,212,129,3,110,87,46,250,4,168,166,172,163,59,171,45,2,22,7,173,202,206,108,109,151,117,245,92,199,183,230,171,118,182,38,217,137,68,143,99,193,88,242,17,86,224,72,82,36,84,237,76,99,19,1,83,175,115,134,34,148,82,40,207,212,239,8,91,206,21,238,61,82,71,80,88,24,198,21,187,179,172,54,19,88,24,180,201,245,77,111,127,236,218,167,141,111,155,224,47,62,69,195,57,165,37,167,179,173,46,59,62,25,78,220,68,2,76,223,224,148,116,28,165,65,0,52,6,123,18,55,198,141,214,127,93,9,32,39,214,229,139,21,49,141,0,0,86,69,48,245,32,234,103,66,216,86,181,17,192,18,73,155,92,207,84,75,22,173,101,107,238,251,146,77,254,125,137,213,222,45,187,87,147,62,62,129,1,87,70,97,146,19,208,198,52,82,173,158,0,170,192,122,3,167,2,139,118,214,205,3,189,32,109,105,8,243,102,79,7,94,73,204,123,48,199,19,17,52,60,71,144,24,160,77,206,157,195,211,165,47,148,223,117,53,167,75,138,110,18,136,62,168,206,55,108,227,167,74,40,139,246,27,254,104,131,128,122,10,138,135,108,253,39,160,17,175,96,87,130,196,98,98,163,147,173,222,93,14,126,193,164,211,160,169,188,5,0,82,67,168,242,158,208,223,47,64,39,85,219,0,64,75,178,164,69,60,186,231,124,175,244,28,191,46,181,119,179,78,182,21,90,210,70,230,23,45,101,159,71,193,156,149,34,166,241,211,50,192,144,0,204,175,107,34,135,243,75,109,9,66,211,12,191,23,60,19,0,90,73,172,231,38,29,191,136,16,167,12,64,46,149,167,74,57,55,254,79,251,85,202,238,217,243,171,223,21,167,143,168,180,228,122,36,53,45,102,191,55,3,35,145,169,242,120,28,218,20,177,30,165,185,225,0,160,126,143,109,110,206,235,164,101,32,172,121,3,173,21,226,69,230,173,104,38,147,4,82,75,194,123,31,90,111,149,132,166,87,109,2,36,213,137,175,188,120,239,222,90,250,90,221,110,235,58,74,55,94,50,22,215,105,25,58,67,11,250,186,22,70,243,234,26,250,109,107,64,19,176,133,149,26,0,13,116,105,204,8,78,239,8,90,106,169,204,135,201,46,127,106,61,46,45,0,86,69,40,58,81,226,186,146,140,168,182,2,72,143,34,173,92,83,138,117,221,215,182,109,246,35,239,218,199,185,41,102,183,150,89,103,162,123,35,200,85,29,66,99,202,14,252,118,187,10,48,120,0,136,206,248,55,90,255,33,67,35,166,94,166,254,105,100,9,101,118,141,7,90,81,168,118,82,76,55,64,168,218,0,200,131,152,114,238,123,203,231,138,119,242,37,250,202,205,238,207,104,154,95,102,52,153,213,208,48,249,130,79,192,225,46,117,64,85,111,224,187,69,230,162,139,44,107,164,143,47,84,145,232,46,59,241,26,51,36,18,0,90,81,76,218,40,117,69,160,253,206,21,64,62,157,86,98,106,218,38,73,233,221,206,90,42,95,211,214,36,183,177,232,82,57,49,148,199,2,253,18,127,183,164,83,34,110,118,102,71,30,52,32,228,213,101,83,148,125,187,15,131,105,167,89,27,221,153,198,244,115,0,90,77,204,90,96,94,51,160,218,66,67,224,41,141,52,83,235,78,222,200,142,174,57,214,93,117,188,218,174,117,9,106,171,99,83,117,96,11,23,46,128,120,238,59,242,25,92,251,102,181,3,0,255,76,173,10,13,48,209,138,70,15,12,204,103,43,167,0,90,85,162,80,80,234,130,0,167,18,128,103,181,58,144,26,211,127,195,28,237,185,124,143,250,29,241,90,87,113,51,187,144,14,222,254,37,218,53,69,191,49,94,98,32,65,3,195,107,72,15,20,1,110,182,231,15,188,22,35,180,107,122,81,54,117,215,230,13,163,68,139,167,0,70,71,84,10,25,5,215,148,92,174,218,224,208,198,214,38,169,234,127,255,174,106,227,188,205,243,207,178,148,82,215,211,139,116,40,187,71,87,241,216,134,198,94,0,131,0,253,229,146,132,38,173,170,32,155,101,185,80,154,94,128,119,20,203,174,152,182,157,111,2,208,0,82,79,4,113,196,81,58,26,219,84,91,10,200,155,26,201,137,37,255,89,10,98,123,182,137,173,175,146,164,61,149,196,239,130,73,135,11,102,122,140,194,6,20,120,124,55,222,117,55,127,157,9,72,105,234,42,4,223,37,164,202,254,59,12,81,220,245,66,115,168,3,0,74,81,8,91,104,218,43,26,84,169,182,0,184,85,129,84,75,118,149,69,170,36,203,222,39,95,158,242,94,246,23,189,50,188,148,106,139,191,25,213,228,66,191,26,38,38,192,122,152,4,14,183,39,0,115,159,123,26,30,181,11,185,117,22,109,147,73,208,129,194,26,9,0,66,73,52,114,115,213,2,26,42,227,60,1,22,2,98,6,245,183,229,231,150,252,127,253,241,124,173,186,153,196,173,69,69,211,207,197,123,9,193,128,223,44,192,38,30,192,50,160,206,199,70,150,0,150,116,58,48,27,72,66,241,93,17,34,37,0,74,69,84,26,136,168,58,50,239,153,115,11,88,136,64,154,234,253,250,82,88,183,111,61,250,190,173,37,30,155,211,57,35,189,248,34,121,14,253,48,155,111,40,9,4,96,183,39,120,62,128,194,66,86,4,93,121,32,128,243,148,147,164,152,20,179,207,2,62,75,220,74,92,151,142,188,212,150,114,53,47,157,239,116,93,214,165,211,168,35,166,148,188,106,182,139,227,155,189,95,133,116,88,97,56,104,168,95,212,40,14,64,5,25,115,65,194,86,29,29,87,52,66,52,224,35,59,81,166,232,154,76,15,0,90,73,34,218,46,102,155,172,12,174,172,213,230,1,113,144,182,220,189,17,199,250,116,141,227,72,111,187,196,27,151,80,180,215,180,243,43,133,204,143,70,49,3,150,91,21,48,3,48,32,180,16,55,175,42,129,37,8,2,112,26,10,130,203,45,70,132,43,28,0,110,75,137,245,209,202,81,170,149,224,187,240,212,2,169,49,152,55,180,182,125,23,102,203,154,123,154,102,86,231,6,215,149,58,46,74,97,110,168,223,49,64,102,162,137,9,160,65,178,3,170,0,124,150,64,116,36,18,154,134,3,117,101,208,219,164,116,1,0,110,89,45,250,35,38,131,180,57,241,185,8,16,22,72,121,202,86,139,99,173,124,214,121,243,174,105,229,85,149,135,250,248,176,106,168,56,74,86,131,210,10,13,179,56,232,159,137,86,219,27,50,245,214,221,13,64,53,150,77,111,100,106,176,98,146,215,211,94,68,89,162,130,4,110,91,105,246,195,93,139,131,50,159,74,3,198,160,131,169,143,106,179,170,102,179,253,159,180,246,187,249,161,171,247,19,79,186,57,33,189,205,88,107,116,201,67,152,64,57,104,0,166,202,76,159,52,8,28,73,247,133,159,20,65,51,37,0,90,75,42,91,90,209,142,245,205,27,212,169,8,24,131,214,212,238,104,210,106,77,177,190,207,30,203,172,236,214,220,55,159,238,175,241,248,4,24,131,45,168,51,129,45,16,128,126,51,127,9,6,33,161,0,74,163,107,90,82,108,172,167,19,182,73,0,90,79,172,240,167,121,25,32,39,176,85,105,114,127,253,113,179,29,133,143,170,170,60,141,150,18,75,215,241,161,200,47,144,88,133,30,250,47,5,214,217,58,19,9,80,252,1,32,22,121,83,54,218,171,108,80,42,108,148,185,83,248,40,102,189,100,33,149,129,5,133,108,0,78,69,200,187,73,47,45,34,149,57,7,14,73,162,202,84,79,253,117,203,235,249,26,245,203,219,213,102,59,192,2,247,245,176,66,121,237,13,247,163,208,151,180,65,244,81,79,76,26,195,83,208,55,89,4,42,250,44,62,54,100,209,124,32,3,164,164,92,211,215,95,72,177,136,12,0,90,85,128,20,220,213,34,176,57,21,128,107,181,208,42,247,109,67,85,92,213,237,217,125,106,52,230,17,151,87,204,66,151,97,91,121,220,174,33,176,74,19,122,79,166,14,110,86,225,159,73,18,88,140,180,195,242,176,108,218,117,136,250,25,175,244,131,3,94,81,204,131,116,41,129,42,36,121,42,0,20,61,208,14,245,191,54,103,209,87,72,77,79,245,70,26,186,197,136,184,174,187,56,190,232,203,51,72,55,79,139,134,3,138,46,192,251,19,65,83,208,38,58,80,208,244,35,245,246,141,144,141,235,225,2,0,86,73,34,50,204,197,53,18,185,106,35,193,165,67,149,156,233,115,75,209,196,92,221,53,101,51,95,197,234,161,233,106,137,178,208,201,147,44,130,78,25,132,239,240,212,214,100,97,218,24,91,19,204,83,175,141,148,2,142,155,18,200,217,144,209,138,108,10,0,78,69,136,18,81,14,53,129,212,169,8,196,146,76,82,213,174,79,163,230,254,172,237,146,101,106,191,145,86,118,123,210,74,46,14,226,224,158,194,17,249,9,10,121,68,203,160,54,252,172,183,22,227,82,1,64,152,180,71,162,77,237,40,1,0,66,81,44,178,168,29,94,97,192,57,4,80,39,24,42,207,175,235,77,92,77,122,178,169,94,197,210,251,34,27,94,146,26,187,241,120,102,51,137,70,107,82,215,202,116,128,145,87,55,193,180,145,101,10,40,180,83,64,179,111,187,47,235,126,71,90,178,74,18,68,12,187,169,0,82,73,200,26,52,135,24,162,125,6,231,82,128,251,19,157,92,125,218,39,234,154,116,141,250,29,28,34,99,101,120,213,186,221,181,139,219,120,145,8,59,8,121,181,41,1,68,77,239,70,28,0,85,126,118,165,108,184,78,81,126,138,199,174,104,1,29,234,31,104,0,82,83,140,107,96,210,17,72,158,27,9,238,36,169,234,242,4,85,103,211,215,191,221,150,244,214,98,88,32,86,174,228,188,24,133,157,131,118,216,154,180,150,26,152,95,168,129,118,11,93,41,128,162,235,244,134,238,219,236,82,170,149,193,215,250,138,68,0,94,83,42,58,17,135,64,69,214,41,0,60,5,169,154,239,85,213,69,165,181,189,45,93,79,188,156,172,108,62,89,187,224,22,119,130,217,135,161,2,32,122,66,18,192,169,1,186,25,227,152,136,52,167,216,232,27,3,77,238,220,82,84,4,15,0,66,71,16,37,202,172,19,244,91,231,84,0,60,164,36,53,147,149,108,125,218,20,199,17,145,54,105,105,245,218,235,5,118,217,190,226,137,90,156,163,49,52,66,237,49,27,203,83,73,243,65,150,97,25,112,66,96,85,102,148,30,1,223,96,198,56,72,40,4,63,62,79,103,103,83,0,0,0,82,2,0,0,0,0,0,81,117,155,31,6,0,0,0,62,62,210,29,59,69,70,73,72,69,69,68,71,68,69,73,76,72,70,70,69,73,70,74,80,75,68,76,79,65,70,67,79,76,70,61,69,70,73,71,77,74,68,70,72,75,73,73,65,68,59,74,68,70,70,62,63,64,69,67,68,72,69,67,94,75,10,59,193,164,2,58,100,239,157,171,0,110,158,196,148,235,187,174,209,74,174,37,246,54,83,199,244,4,135,14,51,29,215,109,147,130,16,12,193,250,131,58,15,105,42,2,140,242,125,49,16,142,169,144,198,16,209,65,118,77,132,232,73,177,72,51,1,86,75,1,27,18,77,97,2,78,223,185,44,224,38,81,84,237,163,218,221,18,109,150,125,183,101,93,164,200,14,221,91,87,101,195,165,69,10,226,3,165,90,50,50,255,114,182,84,90,103,191,206,3,176,107,8,232,217,38,219,64,116,166,51,153,167,131,8,20,0,98,85,1,59,81,106,232,132,142,235,24,87,91,22,32,214,64,170,197,107,154,57,219,118,214,251,155,207,204,252,189,60,151,146,181,203,55,64,85,44,26,51,161,215,249,15,192,99,2,92,217,175,75,208,28,199,117,135,49,195,80,35,246,209,181,90,207,214,162,190,144,89,0,82,83,78,90,58,170,177,163,177,189,249,148,155,249,231,213,133,188,110,159,198,71,125,255,59,105,113,29,103,159,251,189,156,191,80,130,161,128,15,136,247,59,36,91,243,220,156,0,250,135,78,14,40,28,124,57,225,212,69,6,209,34,142,18,60,134,102,117,110,138,21,9,98,81,134,123,4,234,136,104,216,139,106,139,9,44,38,208,154,178,182,203,77,173,249,99,182,61,75,241,151,154,142,195,174,164,33,124,238,227,146,238,217,175,224,184,168,163,21,133,8,40,32,47,92,249,115,37,2,25,148,224,11,204,153,66,73,180,114,26,0,98,83,70,123,72,71,172,200,133,171,45,2,134,64,44,131,218,126,106,242,154,89,239,231,122,54,242,158,87,68,231,130,139,212,112,131,134,74,162,224,21,0,196,6,139,0,145,160,233,99,13,252,84,186,187,172,94,72,15,14,124,211,15,189,33,201,36,75,0,86,75,76,91,164,171,154,144,10,87,155,64,114,129,86,181,111,35,109,246,44,229,231,217,76,196,139,101,127,95,24,206,187,132,102,189,110,169,177,213,158,216,99,35,152,200,3,134,159,132,213,218,85,22,246,6,208,145,2,52,74,153,22,154,123,145,140,0,102,81,41,245,104,237,82,39,132,157,104,181,69,192,19,104,131,26,255,198,172,243,59,206,137,9,147,118,158,75,30,19,201,106,168,126,62,193,8,203,101,116,194,125,209,111,89,97,48,16,1,176,25,206,148,173,72,240,200,110,42,66,83,38,23,93,179,132,118,1,0,106,91,105,244,198,29,2,18,156,138,128,51,104,169,201,217,209,175,211,148,188,73,109,138,233,223,97,165,59,219,235,217,213,105,209,187,134,180,238,80,211,232,108,187,69,128,89,105,8,164,139,97,249,47,1,160,1,175,31,23,92,135,170,131,154,153,217,120,102,83,161,242,161,57,148,145,236,6,85,109,17,32,13,134,210,169,117,106,89,230,252,109,249,250,197,72,213,146,59,13,241,195,76,11,131,138,177,199,177,126,49,104,169,155,134,4,10,40,0,134,220,43,68,109,197,100,240,58,27,221,189,46,56,105,110,2,0,94,83,206,123,163,5,29,81,30,137,47,102,0,9,164,202,189,109,125,133,53,143,154,251,53,214,235,71,214,243,16,58,13,211,176,242,130,115,75,179,54,6,18,55,121,0,37,58,116,128,205,212,173,244,14,240,57,159,91,161,108,188,2,251,96,23,8,199,208,153,57,31,0,86,73,162,242,33,93,92,33,60,184,47,2,129,8,116,146,214,91,124,117,57,211,100,213,231,19,109,59,8,81,119,102,157,61,27,154,50,119,221,142,86,135,57,90,78,45,19,118,67,174,86,81,80,64,81,29,120,228,61,186,186,75,153,18,79,123,154,217,94,42,79,160,148,66,226,0,74,75,88,218,184,195,35,18,155,59,7,26,156,67,23,42,157,44,219,143,186,47,183,229,200,227,254,173,234,63,138,237,193,164,222,40,161,208,35,93,250,22,180,54,218,122,67,2,172,82,218,74,41,228,176,96,10,176,242,35,197,55,117,48,0,130,153,207,97,186,226,43,94,75,198,122,147,14,38,136,163,213,86,32,128,164,219,214,95,183,198,49,255,122,60,255,60,194,208,175,172,210,154,14,233,238,6,77,75,148,104,138,82,40,164,196,23,232,38,2,86,198,224,115,251,167,211,216,95,3,132,217,53,20,208,116,181,34,186,46,52,38,106,79,105,225,71,186,120,64,48,113,142,0,26,8,170,180,245,215,199,88,215,54,95,210,122,222,149,215,121,29,37,37,156,73,21,216,16,78,152,35,22,160,61,101,6,243,169,155,2,248,97,184,141,99,151,63,140,167,3,144,80,48,80,160,127,54,26,115,10,0,102,75,137,246,163,184,234,9,228,170,109,0,110,90,82,222,178,115,139,182,233,163,206,198,155,221,26,26,27,252,211,130,89,44,158,69,237,248,75,4,203,145,115,194,220,85,183,209,104,128,157,152,1,157,43,166,173,52,221,5,40,64,129,241,47,52,240,9,9,70,71,196,91,152,139,62,64,87,174,182,194,160,226,200,90,181,207,150,246,145,181,214,166,63,239,181,252,254,117,148,129,210,118,101,79,41,136,220,16,136,30,66,20,206,94,248,230,3,209,2,155,116,71,2,48,219,181,190,249,4,176,75,128,61,214,85,141,73,103,210,21,0,90,83,161,240,32,46,84,96,80,109,89,28,66,4,178,168,158,89,151,14,38,190,233,255,255,153,200,100,111,125,232,166,232,176,228,47,42,242,236,3,95,194,164,17,66,62,203,10,205,3,56,92,246,45,31,128,153,77,146,236,79,237,184,206,226,24,20,157,70,0,98,85,73,118,211,92,153,128,229,185,0,120,220,145,202,211,45,210,52,179,30,199,212,173,162,159,36,99,142,102,60,62,226,37,146,210,21,14,55,123,178,221,147,197,237,120,141,137,91,246,0,230,87,44,2,64,172,216,148,52,27,67,29,45,255,168,214,180,108,94,140,38,18,15,82,83,162,0,128,9,88,159,75,1,56,24,41,79,223,91,202,215,104,60,223,181,166,106,42,71,14,73,100,19,9,109,216,153,214,163,179,218,92,220,188,143,170,195,93,115,39,137,71,46,130,60,96,189,28,4,239,23,205,6,128,189,188,37,225,200,16,23,39,179,244,126,194,207,164,238,45,66,188,9,90,81,164,0,0,13,18,231,66,128,171,72,212,170,78,95,105,42,213,243,95,214,47,153,247,240,72,82,212,159,217,238,90,12,126,111,252,174,98,87,8,217,241,236,42,134,101,40,85,70,26,74,64,187,2,125,112,241,28,179,56,129,217,117,37,121,20,34,52,197,82,78,128,15,121,82,89,32,193,210,181,70,99,139,106])
.concat([203,8,216,73,52,167,144,59,223,129,228,105,234,43,224,235,152,26,139,69,167,180,121,187,178,34,246,241,53,233,57,12,61,179,155,153,25,73,135,98,189,4,48,241,113,146,212,5,147,77,183,211,176,135,238,149,130,9,94,81,70,107,233,38,42,9,123,167,82,0,245,14,49,149,231,154,82,83,147,246,244,251,150,179,82,132,24,231,133,135,234,227,237,246,11,164,3,145,103,181,112,27,100,104,246,47,42,185,4,14,64,183,27,4,79,159,142,197,78,69,167,12,164,121,29,90,88,255,136,16,114,16,1,0,114,91,169,246,224,116,128,208,192,185,0,132,216,3,41,45,139,77,240,165,37,159,244,158,255,152,18,52,217,72,192,185,177,67,142,95,242,112,169,175,41,43,13,14,139,66,3,195,40,95,7,40,168,90,10,96,84,149,253,124,189,155,38,91,9,119,174,125,30,9,46,135,49,84,35,148,82,224,1,98,83,38,122,72,33,42,52,227,36,206,13,144,174,133,236,160,138,166,137,212,103,233,118,116,19,236,27,82,161,31,48,193,133,117,234,193,128,253,10,96,190,248,99,219,228,21,0,233,104,1,2,45,60,157,9,21,156,212,2,165,214,164,151,0,82,83,34,90,110,102,2,204,54,231,4,72,32,150,106,254,189,75,223,53,235,162,188,156,150,235,67,27,103,73,73,95,227,5,8,72,167,86,219,237,228,172,202,7,194,54,148,55,28,55,1,232,163,192,3,146,110,104,130,141,77,167,20,133,46,7,193,97,58,0,98,75,34,122,83,196,30,144,218,221,185,205,4,66,38,82,170,122,108,93,60,177,204,147,111,217,166,123,126,17,14,90,26,35,56,112,83,211,0,191,142,193,26,208,85,152,77,220,131,122,145,164,39,215,77,144,120,239,193,68,4,43,69,107,64,18,0,94,87,166,112,179,92,53,200,112,46,13,144,181,68,44,185,230,164,148,206,204,94,239,175,110,218,36,22,89,29,185,30,78,253,246,154,80,216,169,11,188,192,152,232,246,27,80,232,201,236,180,133,109,0,89,118,63,247,183,54,203,195,135,43,223,254,75,209,79,233,105,12,166,120,111,76,230,20,5,102,89,101,101,32,174,6,224,92,14,32,29,106,67,114,111,235,104,26,177,86,118,92,77,132,220,193,164,69,212,9,74,220,219,89,251,153,118,4,118,118,66,9,172,4,83,147,47,17,99,29,152,231,89,102,93,180,113,14,56,17,184,166,51,125,192,226,37,157,147,37,179,141,72,7,0,102,85,33,71,82,156,20,8,87,91,76,18,18,168,13,76,215,204,247,235,93,239,237,183,174,107,86,3,201,105,227,249,102,51,126,175,123,74,38,4,96,9,241,77,2,58,137,211,204,71,41,3,128,206,131,74,188,89,3,197,79,58,77,51,118,46,205,164,0,0,102,85,233,212,143,98,166,128,97,156,138,128,3,82,170,178,107,61,53,44,233,126,86,191,37,159,107,252,220,85,196,24,107,89,19,175,52,16,250,190,228,184,44,0,19,8,153,213,219,132,14,38,38,161,168,23,129,83,2,217,77,106,83,101,223,15,167,181,97,241,18,231,34,224,73,38,29,83,109,42,218,179,218,174,139,55,61,221,52,204,53,126,183,181,8,211,182,236,116,97,65,192,66,10,13,50,206,36,128,49,160,61,104,175,62,107,152,14,5,13,96,6,253,187,174,108,67,153,116,0,102,85,73,223,7,215,165,144,130,165,113,46,2,228,179,69,106,202,214,47,108,154,103,201,206,237,236,102,63,158,214,180,166,56,67,69,36,177,47,242,86,10,96,56,161,113,9,176,239,51,56,96,99,217,143,73,48,57,172,14,156,195,136,66,9,13,18,93,39,0,98,81,73,207,141,6,70,34,250,165,1,231,16,55,85,51,53,77,164,252,202,215,233,53,201,243,176,154,206,205,144,194,162,208,217,202,13,87,113,114,236,189,214,5,32,108,56,51,164,107,186,213,35,64,193,86,90,109,195,130,9,193,4,133,98,173,94,75,175,191,148,209,1,70,77,216,26,12,71,70,68,235,230,60,192,3,72,105,85,100,221,81,21,235,17,125,255,124,235,186,78,179,66,84,136,187,50,197,253,169,137,204,30,148,189,0,182,236,39,102,94,173,120,104,167,183,132,249,35,193,171,206,142,47,238,82,64,20,147,99,50,155,80,18,66,81,164,15,4,0,56,21,14,28,137,182,110,158,183,51,143,170,181,206,37,214,172,218,185,108,149,213,78,21,83,201,8,74,242,167,36,219,132,110,211,18,1,19,20,103,81,129,81,129,38,93,223,191,156,117,72,205,9,93,6,215,68,187,34,76,235,18,245,66,155,190,22,19,252,34,18,90,79,161,111,3,208,4,162,213,150,144,28,80,97,36,111,253,103,145,29,17,203,191,82,243,10,225,213,175,146,46,249,163,124,232,217,107,164,107,157,65,136,86,28,233,203,163,113,10,170,195,174,55,102,104,198,213,230,210,102,108,122,0,222,209,200,86,64,209,124,32,121,28,0,86,73,170,54,36,205,84,75,36,206,13,224,128,152,92,61,247,154,200,235,154,250,102,189,87,208,239,136,96,128,75,187,105,63,219,56,48,114,212,36,86,70,72,48,47,232,130,163,242,151,56,127,209,222,93,3,28,0,117,254,66,111,221,139,107,154,211,1,86,83,170,231,196,1,128,115,1,137,35,80,27,154,179,125,222,116,203,38,89,53,237,12,255,123,146,58,121,154,36,123,122,103,163,215,110,29,3,210,62,215,136,229,14,139,245,6,48,173,227,43,62,44,116,53,104,158,73,162,29,207,147,142,168,31,98,94,52,58,82,75,110,197,51,1,20,137,204,185,0,64,5,49,174,178,202,22,233,109,143,103,61,190,231,138,250,72,101,142,101,71,21,61,204,213,95,137,221,223,197,111,161,43,156,177,134,206,43,207,203,176,58,8,196,71,247,203,245,189,66,130,120,152,93,215,104,92,113,83,35,31,98,77,161,239,198,105,21,1,231,38,0,241,128,52,57,183,250,212,108,109,63,169,63,246,95,106,82,124,125,147,44,13,65,248,29,75,67,214,18,84,87,40,3,232,45,21,208,15,151,132,88,8,232,243,158,148,0,177,48,180,210,28,178,174,110,63,233,140,185,235,105,36,132,116,0,78,79,102,226,4,16,128,213,57,198,192,3,170,90,57,91,150,231,247,44,119,19,181,255,107,234,162,170,178,106,47,75,180,76,118,29,28,117,165,6,109,209,62,25,46,198,190,148,88,210,9,96,46,174,131,43,35,165,20,0,54,86,73,158,145,210,33,68,117,254,193,239,9,98,79,229,196,141,2,138,138,147,170,182,224,79,64,139,56,114,53,242,235,104,154,84,141,37,63,239,102,161,62,244,218,252,206,118,81,121,106,139,150,19,217,120,170,60,161,219,150,115,120,39,142,54,129,233,53,112,209,85,157,144,130,89,192,176,130,206,75,179,16,128,7,0,86,79,204,187,105,162,84,228,57,203,213,22,0,194,19,169,202,38,171,251,158,246,103,237,231,124,39,220,87,108,144,78,30,146,183,75,222,80,183,201,22,105,119,79,43,174,185,198,23,0,35,172,172,244,77,18,10,78,153,32,21,20,232,44,1,102,83,101,246,198,68,58,1,213,158,75,1,112,136,169,178,61,142,43,210,245,86,42,55,203,242,236,41,136,155,179,246,242,92,56,59,224,40,216,230,125,235,10,176,119,206,229,236,40,94,0,204,69,163,37,97,27,26,0,133,169,139,190,52,77,167,185,0,110,87,105,244,199,41,93,137,134,207,17,115,42,11,28,135,52,16,89,171,141,90,82,173,93,245,89,176,159,134,53,181,168,203,11,231,191,56,3,38,184,2,240,9,220,161,8,192,230,182,128,75,40,79,2,164,230,113,0,94,81,170,240,161,209,58,82,58,25,7,115,110,237,0,129,54,168,125,109,231,51,173,165,137,125,215,164,106,242,197,76,81,25,208,104,72,235,153,174,128,154,32,205,239,64,190,178,56,199,116,168,77,207,109,77,116,36,193,74,30,136,119,156,189,148,37,230,112,183,200,41,28,0,90,79,170,240,167,136,125,2,246,170,173,185,132,4,201,131,178,127,187,28,247,44,230,216,50,111,250,186,184,218,103,227,109,198,214,180,33,196,192,134,198,193,179,66,50,25,65,210,107,38,128,57,27,73,161,119,112,9,152,212,37,90,41,87,202,255,107,29,94,75,44,123,179,196,218,145,216,211,83,11,56,142,54,168,199,114,111,125,186,107,127,255,231,222,234,61,101,161,88,148,169,94,226,241,181,93,40,70,88,45,129,95,122,21,212,160,123,115,25,116,102,181,90,235,46,39,64,23,152,226,138,162,151,233,180,153,65,2,102,83,166,144,24,66,39,202,11,84,91,26,216,195,43,180,145,220,81,42,89,170,207,155,84,51,175,147,230,167,182,38,248,246,53,21,253,171,37,27,74,222,154,231,58,151,64,155,106,18,88,216,178,54,196,98,128,22,160,147,129,16,241,156,26,212,76,166,14,0,102,89,134,91,52,83,236,64,117,206,37,2,26,52,72,101,178,102,177,24,255,94,35,150,213,199,68,154,36,142,46,161,26,170,105,230,83,93,103,11,189,171,242,178,32,249,82,0,108,110,34,122,0,15,233,147,28,58,146,186,166,1,106,83,174,176,41,162,170,96,83,213,22,129,120,8,72,35,19,77,172,203,58,242,252,254,246,235,33,37,17,234,131,103,239,166,225,141,129,81,105,195,90,1,139,22,1,255,170,80,15,0,11,15,43,198,1,112,64,200,147,159,50,10,40,106,87,161,246,38,65,4,227,119,46,2,238,32,99,68,58,219,53,98,73,157,246,159,207,149,71,197,69,22,30,107,50,91,100,12,140,80,77,118,96,132,245,192,135,3,218,2,126,149,205,212,69,227,64,180,152,0,62,243,22,129,9,192,4,98,81,174,118,83,4,34,162,125,40,231,58,1,126,72,137,233,127,155,166,227,254,237,174,101,102,121,158,58,161,82,180,220,217,80,246,251,58,166,67,26,123,37,116,229,65,98,179,64,219,171,45,50,77,179,128,210,39,156,4,239,146,204,4,2,10,29,190,1,86,77,108,106,147,66,6,144,58,213,0,209,128,86,181,214,124,106,209,84,158,247,153,74,143,108,99,65,76,79,112,90,81,44,49,253,156,128,182,168,111,179,95,48,236,0,244,222,70,45,222,142,238,122,3,102,7,59,147,34,58,35,184,137,3,109,2,78,75,162,210,128,30,29,41,149,38,170,141,4,144,129,150,162,53,98,158,55,159,70,188,199,127,105,237,73,24,127,21,29,58,46,132,133,29,223,2,134,190,37,59,128,158,166,206,193,25,29,247,173,197,169,6,120,32,190,164,148,188,65,169,200,39,53,0,86,75,166,176,16,74,29,164,240,78,79,5,28,72,168,226,170,233,252,205,161,105,235,105,202,26,71,148,92,176,51,205,78,75,175,28,102,162,145,80,209,94,9,152,37,103,132,215,1,195,10,147,163,227,180,178,53,26,35,157,162,16,192,164,210,33,253,84,112,30,15,0,86,77,102,98,83,116,155,16,9,87,27,24,24,168,210,150,101,109,179,204,51,145,221,164,36,197,155,53,148,43,40,93,103,104,43,147,183,182,128,33,19,139,110,66,115,66,43,44,26,56,140,117,180,220,54,47,204,94,173,0,72,147,25,140,16,36,79,239,0,94,105,65,218,20,47,101,162,96,87,109,4,3,3,169,114,242,251,207,250,175,137,148,142,104,247,54,158,73,174,22,76,109,54,72,1,166,43,58,138,185,98,126,29,112,103,219,254,54,14,112,89,22,26,0,222,139,66,43,250,247,98,200,14,122,29,21,79,103,103,83,0,0,0,200,2,0,0,0,0,0,81,117,155,31,7,0,0,0,55,85,47,109,59,72,80,70,75,69,71,73,72,71,73,72,73,71,68,64,67,69,69,68,69,67,72,68,77,73,69,69,74,71,69,72,75,68,73,79,72,66,66,65,70,69,73,66,69,65,67,70,66,66,68,69,68,68,67,68,73,75,67,63,90,87,73,109,99,174,227,64,204,57,130,131,9,116,134,214,163,218,58,182,90,222,218,235,110,149,92,100,109,178,202,166,70,51,111,215,88,215,1,133,3,73,223,73,88,206,237,70,98,199,33,152,182,196,89,226,169,11,29,96,7,64,143,165,128,166,19,162,33,237,81,3,98,91,73,207,29,29,96,19,78,13,224,4,180,161,230,54,203,18,107,90,206,182,235,239,183,146,94,246,170,87,95,110,215,99,159,133,135,75,77,20,71,183,76,227,0,93,20,204,54,65,81,115,45,86,146,45,35,22,109,138,72,247,90,43,234,50,90,196,226,150,77,21,196,121,93,145,97,2,11,0,78,81,172,182,113,181,28,16,83,125,169,250,255,113,123,91,249,124,83,117,59,189,82,184,243,206,185,253,207,154,158,80,134,50,154,157,73,123,8,11,239,225,197,146,70,57,192,54,3,14,60,230,135,170,7,202,162,2,173,141,208,111,68,153,137,220,17,46,72,0,94,79,233,196,141,137,118,37,105,122,84,79,85,127,243,184,199,171,251,122,62,227,230,200,241,97,213,214,250,245,216,85,4,129,70,53,228,36,92,30,97,25,85,125,145,214,20,23,221,220,7,126,171,46,31,215,126,36,2,232,173,24,42,112,90,155,158,5,201,76,145,7,90,159,0,70,71,100,10,154,170,14,16,173,182,84,144,192,160,74,174,110,41,155,174,92,105,91,191,103,29,163,155,159,237,100,58,97,165,236,64,94,39,21,90,183,141,148,64,39,215,135,6,198,174,96,128,219,234,44,30,151,76,211,108,120,212,36,93,113,136,2,175,3,90,75,174,114,226,130,93,129,170,207,13,240,3,134,170,121,229,183,181,92,77,106,218,47,118,119,9,171,211,140,2,52,29,159,201,141,78,196,26,242,172,128,233,55,206,188,53,36,220,185,227,202,162,238,52,120,235,16,212,183,158,102,41,75,166,198,60,93,23,16,19,74,81,204,123,227,180,189,32,163,234,249,84,245,171,139,55,167,177,211,112,118,241,93,121,186,119,115,241,244,107,49,146,50,181,103,114,165,199,51,21,237,198,206,37,237,168,241,25,115,12,36,128,69,171,155,64,156,210,30,102,65,246,145,240,155,196,39,70,244,194,233,152,0,106,85,137,245,83,75,212,23,171,168,186,218,2,194,192,16,51,168,121,204,151,183,223,180,82,252,155,174,121,153,247,101,9,175,108,19,81,61,183,146,224,156,164,234,30,174,162,88,64,13,36,112,157,195,78,13,19,69,81,241,152,245,34,188,75,223,213,217,19,66,80,0,82,83,42,219,56,249,122,1,218,175,122,204,72,253,115,126,63,95,158,134,239,143,138,187,197,57,246,192,75,94,26,19,115,184,174,225,44,162,157,242,158,128,149,253,58,208,217,230,93,76,0,137,221,40,105,116,64,182,171,64,23,243,57,79,49,90,98,1,246,145,0,82,81,38,123,200,69,255,10,244,190,115,58,80,1,173,234,247,191,201,207,246,219,255,219,146,109,115,164,122,25,230,37,2,105,224,44,186,155,83,105,98,197,74,216,186,42,64,137,156,9,52,103,250,205,251,122,8,152,27,238,28,141,121,241,198,90,121,178,245,78,49,5,0,86,81,161,231,142,168,250,138,230,177,171,94,12,234,171,135,255,85,110,229,80,168,224,51,47,15,49,233,126,194,94,212,28,154,198,156,32,109,124,20,184,168,38,189,35,125,84,232,41,208,65,2,81,78,42,133,196,219,70,233,247,19,58,44,233,125,164,205,38,9,14,0,94,85,42,250,113,250,46,23,204,79,223,156,139,238,172,9,32,166,234,153,206,116,180,217,115,207,163,185,105,55,122,246,76,177,187,8,137,106,122,105,9,240,145,92,208,206,236,80,72,140,77,38,146,127,13,79,128,79,186,49,101,112,128,186,18,169,116,23,115,160,107,58,18,82,77,174,182,48,223,242,138,153,162,213,158,148,8,18,49,131,178,124,95,51,191,118,207,218,170,108,117,252,222,235,252,23,47,21,27,156,140,80,130,153,72,35,34,155,7,86,117,2,196,216,249,128,110,62,220,187,118,213,14,144,154,208,123,248,122,20,238,83,82,0,102,81,105,225,77,134,218,1,235,205,156,107,128,16,146,32,85,89,234,43,29,135,239,248,55,121,155,241,88,219,132,21,50,26,152,75,220,80,29,151,63,168,105,32,210,76,39,54,53,251,18,216,230,183,240,5,241,116,89,88,136,50,45,50,129,164,73,58,82,81,166,103,184,139,114,1,29,204,41,49,8,131,52,72,135,124,239,247,127,84,115,230,231,175,49,17,139,234,233,188,56,236,198,68,130,49,155,170,22,166,132,46,11,64,153,208,81,67,106,204,166,57,138,198,177,181,100,2,168,199,223,216,78,87,170,246,38,5,102,208,66,91,109,13,16,36,98,106,5,223,99,157,88,186,171,255,219,178,148,237,77,236,13,191,37,77,143,184,138,18,36,129,58,125,40,80,135,57,251,4,40,160,129,137,113,55,168,131,83,16,61,110,75,88,16,206,226,157,12,58,79,108,2,180,32,7,44,243,78,37,226,224,160,168,122,164,250,110,95,154,99,189,119,121,107,93,116,227,211,175,149,56,190,144,172,21,119,216,134,125,54,0,151,80,48,68,58,0,74,174,214,54,151,51,105,19,57,59,166,145,82,63,93,75,64,66,2,0,82,79,166,118,227,250,62,144,240,170,239,92,5,146,72,71,164,42,123,212,83,157,227,190,253,142,60,107,238,140,201,19,130,229,106,119,179,101,179,75,64,118,99,209,52,163,38,216,135,81,15,152,208,87,134,156,17,116,60,154,48,221,182,158,76,197,41,58,0,86,81,44,3,163,185,32,156,59,53,1,96,21,82,174,172,73,103,180,157,255,89,239,243,103,221,43,138,149,216,170,216,239,126,51,37,186,93,189,182,136,21,176,16,180,174,165,201,228,81,200,126,16,251,155,55,103,55,1,72,137,186,95,4,226,51,8,14,78,79,40,34,11,205,133,66,222,169,192,33,89,131,148,22,147,165,88,142,117,68,215,53,249,209,148,191,116,231,220,141,165,146,62,147,137,213,21,67,99,55,65,187,252,41,20,24,162,161,91,3,179,99,84,219,155,57,144,139,186,199,156,110,120,6,158,0,15,90,85,73,148,136,201,47,160,43,159,34,192,68,100,34,85,89,211,71,61,214,255,125,237,143,149,25,234,47,78,182,165,158,46,229,46,119,54,216,179,72,134,253,209,19,213,213,249,7,192,226,222,86,53,221,52,125,167,101,125,17,211,190,191,7,13,7,90,95,142,107,184,57,15,2,93,181,218,178,128,12,89,161,211,212,156,168,152,173,169,227,183,183,41,254,172,91,197,123,5,67,174,177,92,122,175,139,5,14,112,246,53,178,201,174,195,202,202,161,29,196,250,42,9,31,253,56,58,228,24,153,164,52,148,2,26,192,135,3,94,87,206,186,41,106,94,40,116,195,185,20,0,26,180,182,108,230,122,214,84,233,88,206,182,93,39,25,47,230,19,33,211,8,251,52,187,182,101,27,112,13,141,145,69,179,188,23,12,206,178,191,4,128,233,120,176,83,4,242,38,104,193,52,209,18,52,15,58,95,36,2,3,23,192,169,1,8,134,25,79,139,191,61,123,83,43,234,222,122,19,246,175,177,211,183,107,81,8,174,134,175,204,91,88,141,102,122,0,177,69,199,117,213,185,66,32,58,173,2,2,136,115,210,16,64,55,10,74,58,7,237,215,177,84,44,85,50,180,133,241,136,128,78,1,86,93,206,218,56,9,95,36,123,156,234,60,64,4,210,148,251,207,174,104,179,229,168,74,237,215,70,61,82,95,46,235,116,49,125,33,219,218,76,19,189,161,12,3,13,220,18,143,85,11,38,212,27,149,192,212,54,150,196,180,102,126,73,217,228,247,192,198,222,100,247,104,0,90,85,33,123,147,162,92,65,222,169,6,17,110,70,171,178,127,222,44,155,127,223,222,150,39,214,54,127,173,185,231,46,52,136,11,230,114,127,170,179,128,57,105,7,29,228,10,80,184,173,61,13,194,198,182,56,42,5,36,167,153,116,74,87,104,5,37,52,0,86,79,42,122,135,33,232,43,196,221,113,142,4,231,160,229,41,226,22,231,253,140,99,91,239,77,21,178,95,157,84,165,86,132,162,103,91,20,210,89,4,173,143,4,151,52,116,127,78,55,252,64,116,8,64,74,71,115,237,140,195,148,26,50,61,77,29,195,18,78,79,204,186,41,130,92,65,247,168,182,152,35,144,64,76,110,178,108,251,206,73,239,88,190,244,116,93,122,197,203,99,69,222,154,236,45,169,231,147,139,165,122,212,209,49,67,195,152,235,174,210,14,160,235,71,42,181,10,98,118,40,31,49,167,40,79,99,69,14,199,116,14,0,94,91,137,245,32,148,125,3,155,106,235,57,159,4,90,229,108,125,226,212,222,158,105,242,54,242,214,188,229,34,62,185,180,212,112,131,64,81,168,198,182,38,109,219,36,224,209,92,221,1,48,23,109,27,166,3,141,159,72,217,102,252,103,170,177,226,45,185,9,97,2,86,89,206,91,146,180,254,134,216,166,218,39,32,129,165,114,86,49,207,123,157,121,166,210,53,121,197,185,151,37,182,212,58,66,253,36,32,104,229,245,138,228,38,50,205,130,47,76,1,216,107,28,116,128,69,70,156,110,137,21,205,40,14,204,173,150,168,199,1,102,89,105,244,193,78,134,0,232,172,106,139,128,72,160,51,88,216,169,154,243,106,254,233,205,166,142,218,11,137,39,147,44,62,113,254,104,209,95,212,199,130,3,190,165,201,1,52,80,247,38,0,99,118,49,0,96,214,20,57,24,149,171,56,115,253,17,11,121,232,121,52,82,83,46,218,194,201,49,178,222,160,119,157,19,131,228,168,57,213,244,138,138,85,234,175,95,51,199,170,213,168,157,63,88,193,62,20,219,212,227,123,0,124,131,63,41,239,18,112,126,75,93,76,32,214,190,10,5,192,46,170,141,87,189,90,19,37,102,206,70,253,54,169,202,116,0,78,79,200,179,214,76,246,141,46,252,153,171,30,51,152,236,155,195,35,6,243,151,111,222,219,99,117,45,28,240,19,66,126,254,48,55,143,43,245,1,255,188,56,16,193,32,4,228,195,4,186,115,114,58,205,84,3,45,9,54,57,220,233,162,23,58,80,0,94,87,76,115,210,165,124,167,130,241,185,8,120,82,128,60,200,61,99,98,93,92,109,211,228,125,226,14,137,5,51,251,22,45,203,133,213,48,220,7,192,54,89,69,239,102,128,100,104,243,9,96,88,37,14,28,151,108,98,182,218,166,183,254,197,140,9,65,83,216,15,76,0,82,121,162,224,172,80,252,66,182,185,218,34,64,82,22,102,90,188,142,240,100,115,31,234,94,37,93,44,189,217,247,145,115,81,118,43,44,35,1,155,87,21,82,96,142,128,84,165,206,25,48,55,36,193,98,190,12,234,175,83,245,105,209,253,164,234,178,180,238,70,178,147,243,218,110,115,43,14,0,94,99,73,161,224,190,219,55,178,38,115,94,0,18,40,6,211,118,159,122,214,165,83,71,251,169,88,48,101,136,213,220,185,71,140,114,175,4,129,112,222,108,232,71,175,167,241,217,148,80,143,14,186,186,170,152,190,27,236,208,172,28,184,72,222,149,65,195,21,144,38,0,82,95,44,218,140,91,21,192,102,242,206,7,46,25,90,173,32,109,125,118,164,106,99,59,235,111,145,104,75,178,12,67,97,160,200,59,109,215,5,102,32,223,8,40,176,144,128,1,10,179,109,232,174,241,155,192,146,77,115,17,206,154,43,20,61,0,42,89,16,129,190,42,34,208,33,213,250,13,79,2,169,38,242,235,182,110,105,175,171,190,118,175,110,25,50,212,77,124,162,219,253,74,55,148,188,105,232,93,173,105,220,3,80,238,214,240,128,235,101,216,67,156,23,115,55,131,182,198,188,39,165,1,78,83,44,91,56,225,11,100,170,183,42,249,141,235,157,252,168,211,127,85,197,203,7,145,157,56,201,58,242,38,244,86,177,83,125,113,155,16,208,3,148,214,2,87,195,66,121,14,128,30,99,152,179,188,79,121,57,234,75,126,155,124,3,38,0,82,83,204,219,180,59,13,0,139,170,182,236,16,156,65,74,212,251,255,72,177,71,90,83,255,91,198,236,243,231,61,213,98,137,241,21,149,87,213,189,64,235,62,177,160,101,114,243,195,188,174,192,232,220,95,4,176,194,146,240,179,164,253,37,64,161,57,0,58,0,78,79,42,219,148,59,25,128,212,185,130,116,121,144,114,69,254,90,143,95,126,52,219,121,53,105,33,227,73,25,145,205,154,105,18,121,79,7,248,156,19,108,108,45,254,9,165,136,162,33,204,7,83,172,158,93,105,232,105,39,40,60,81,244,98,195,13,146,7,94,75,73,225,71,187,147,70,8,101,206,1,32,18,82,158,137,223,214,102,251,173,201,204,222,197,214,47,190,197,100,213,56,184,93,162,88,173,18,242,137,153,140,16,232,198,94,140,66,235,46,203,193,230,48,157,139,197,143,70,54,9,12,80,200,110,67,177,81,185,8,38,0,110,81,93,244,103,221,87,229,144,44,190,106,11,128,140,0,106,139,246,120,214,117,169,244,219,247,126,218,229,76,90,214,95,211,77,125,49,58,173,159,77,145,19,96,245,1,32,238,56,219,112,177,22,219,70,112,64,63,90,244,151,180,238,151,14,0,114,85,67,244,38,239,139,97,164,131,95,0,28,192,85,89,109,169,157,246,89,210,82,167,154,229,206,115,102,152,230,141,237,205,238,69,89,56,247,143,105,242,12,105,63,8,112,236,191,3,247,203,190,210,135,190,41,152,152,49,37,179,56,191,237,153,40,80,0,118,87,99,246,103,220,239,13,128,115,89,192,35,68,210,170,44,69,83,95,212,184,82,159,103,111,151,21,30,240,85,176,105,46,84,59,129,48,54,1,114,87,175,128,226,227,6,128,130,97,31,250,18,129,179,98,19,79,154,46,204,14,229,29,0,98,87,193,123,83,238,247,0,66,154,83,9,0,49,160,42,235,147,106,191,121,214,125,242,79,158,210,145,199,211,180,153,113,253,57,131,172,54,220,52,102,155,196,131,155,190,59,240,65,185,176,25,7,83,14,196,70,90,177,152,182,87,22,165,97,22,0,90,81,33,59,41,247,187,57,164,169,246,0,18,164,114,153,183,190,115,191,175,77,58,179,89,87,191,165,115,92,178,91,212,80,179,91,93,208,26,190,204,30,83,25,4,112,223,135,97,113,132,224,203,162,101,33,161,144,104,219,131,215,148,166,203,242,7,149,77,10,70,81,216,211,222,238,203,64,136,169,118,3,22,12,173,202,124,73,164,104,187,235,217,127,91,18,93,162,254,197,13,91,116,243,70,246,179,3,172,66,21,22,239,13,44,47,6,251,240,45,32,55,42,29,100,211,39,49,179,205,119,214,52,146,99,2,74,79,52,130,243,30,5,1,170,39,9,234,191,202,24,122,11,255,250,222,231,205,107,246,126,169,201,206,9,57,229,63,241,225,75,40,130,189,232,160,246,7,255,243,181,210,221,111,82,148,108,71,81,26,232,201,21,30,93,227,69,239,154,8,14,0,98,79,38,114,218,125,73,132,88,195,59,21,1,15,138,152,151,40,251,101,145,90,115,158,237,90,93,42,247,122,238,90,227,245,108,17,177,54,81,151,72,228,90,128,100,2,19,160,106,17,154,205,247,121,40,186,210,138,201,76,141,190,95,132,34,179,16,0,86,79,38,50,236,206,13,1,85,207,167,92,238,139,231,194,118,61,253,249,24,187,185,190,104,244,170,183,78,132,29,235,2,29,95,128,217,170,121,7,157,50,160,176,233,1,192,243,183,196,35,161,80,228,141,79,15,169,139,235,78,40,218,167,67,107,231,37,0,94,75,202,59,41,87,215,2,177,170,207,45,80,227,208,6,245,254,106,214,108,217,214,55,29,217,26,201,27,230,196,94,77,239,162,138,70,196,251,92,20,116,176,111,124,34,204,206,43,37,39,128,48,54,86,18,5,97,84,215,39,158,135,62,5,77,193,1,90,77,34,218,50,110,253,114,214,211,142,77,181,9,8,121,104,85,214,55,214,95,187,52,249,246,222,151,104,244,106,211,67,117,182,10,205,84,164,103,182,234,148,176,188,7,224,20,50,18,208,209,71,205,122,225,192,202,104,97,106,196,55,76,152,184,158,0,62,73,212,75,47,55,234,130,102,28,232,249,194,169,38,243,202,235,195,219,242,112,47,84,229,37,106,187,111,90,206,123,131,23,220,163,24,111,7,176,101,18,239,192,1,11,71,37,157,49,41,203,75,69,1,71,65,37,100,92,46,5,121,102,167,104,0,98,81,105,229,77,222,151,6,64,149,115,17,32,46,16,51,40,59,158,42,105,255,242,251,249,125,211,44,113,36,80,179,27,162,45,130,135,87,5,255,43,5,230,45,34,242,134,230,209,192,129,58,198,242,181,145,158,36,234,29,195,12,74,69,167,47,32,1,86,91,97,226,198,238,53,58,52,226,92,4,60,38,19,77,245,58,28,199,81,221,125,255,100,157,116,103,246,132,68,19,136,28,139,247,217,133,253,77,219,32,177,74,165,0,8,248,255,127,13,128,223,110,191,169,209,58,172,202,34,194,5,219,18,251,117,201,1,119,21,218,4,98,87,110,197,159,113,95,163,71,249,115,46,2,113,142,104,53,253,237,19,87,215,164,243,109,111,53,237,126,243,92,37,40,250,186,195,75,237,210,224,1,53,190,128,13,18,151,216,255,97,208,108,172,129,54,156,17,231,141,171,200,2,109,230,229,66,70,134,163,209,64,241,20,58,0,70,79,172,111,147,119,142,30,132,207,233,78,74,2,205,185,12,199,119,204,245,232,154,38,249,175,211,134,235,237,24,142,134,42,230,194,149,108,170,72,186,138,73,175,107,152,237,44,48,162,20,60,240,21,183,222,125,46,72,13,124,209,121,203,109,165,1,106,77,73,207,41,195,204,183,213,224,98,206,9,144,3,41,145,14,255,235,106,87,113,92,217,122,229,147,22,197,95,62,85,140,6,74,228,68,219,166,59,155,5,100,50,111,1,250,49,105,67,69,29,241,189,10,41,150,187,79,184,179,80,79,103,103,83,0,0,0,60,3,0,0,0,0,0,81,117,155,31,8,0,0,0,82,152,24,35,58,75,63,73,68,68,70,70,71,69,64,72,72,72,69,68,73,66,69,73,68,72,72,66,75,73,73,67,79,72,72,71,73,68,72,75,73,77,73,65,70,72,75,74,70,74,66,69,68,68,70,70,66,76,69,69,73,67,70,98,75,101,223,27,185,97,194,40,73,170,173,129,196,32,229,38,91,215,38,234,156,91,115,197,175,209,166,33,73,241,226,94,85,171,205,107,134,50,165,202,38,198,138,130,179,85,37,230,119,68,231,109,108,48,217,56,217,31,29,194,71,135,70,209,225,102,77,14,129,77,18,5,161,3,82,77,98,226,161,153,250,23,210,84,231,82,40,27,93,127,243,184,231,125,25,245,241,241,60,237,234,211,15,112,137,187,244,81,22,212,227,28,184,197,34,72,194,28,2,116,142,172,179,108,98,115,122,200,67,235,232,30,154,78,60,8,0,98,77,102,226,77,161,228,10,108,170,109,1,17,64,225,68,189,210,246,172,253,210,230,71,117,21,218,77,178,233,118,242,122,77,172,116,77,181,242,31,42,33,30,138,242,73,171,244,232,115,36,165,200,13,230,134,214,201,212,188,103,32,61,51,251,132,197,129,210,4,197,236,0,78,77,80,24,156,162,124,1,123,231,29,24,32,185,50,247,102,109,74,90,219,223,172,75,87,44,221,140,66,118,61,142,131,94,144,53,200,199,149,233,189,237,12,227,99,125,193,3,35,66,82,48,18,106,235,85,163,76,58,96,2,245,239,122,80,132,6,0,86,75,42,219,33,175,174,96,51,96,119,218,12,6,72,77,217,239,119,60,213,108,167,237,203,142,148,44,200,174,253,154,179,158,41,35,72,48,119,44,9,1,246,2,48,54,160,6,52,124,108,26,94,210,237,50,128,14,77,215,102,246,188,40,5,240,222,4,78,69,102,106,97,38,251,198,178,131,167,198,131,89,32,81,158,122,219,174,190,60,205,172,191,182,201,38,83,231,232,17,198,151,4,131,181,247,45,54,210,29,72,29,232,241,143,220,10,127,117,162,166,120,106,90,169,140,3,157,32,1,197,109,71,1,157,78,107,0,106,79,101,207,195,112,45,175,72,30,74,206,5,128,112,72,85,211,146,154,38,150,244,248,183,207,242,185,63,217,174,51,215,170,237,5,89,161,232,85,192,72,83,154,13,21,128,125,22,193,132,232,46,215,183,56,59,224,38,154,22,94,154,221,20,194,84,66,3,0,98,81,173,111,99,94,198,43,204,27,87,91,0,104,128,160,202,142,166,218,117,98,249,142,223,215,133,108,21,47,90,136,47,49,55,16,165,36,165,188,131,160,221,103,181,19,184,173,27,153,43,138,36,242,113,85,149,123,172,188,7,129,238,77,131,70,38,161,201,87,0,102,81,73,223,155,230,24,95,4,146,231,6,192,6,173,169,221,155,158,183,153,111,223,159,253,77,77,219,253,42,162,192,38,118,51,214,161,135,68,195,68,204,154,62,12,160,102,113,138,77,201,244,58,58,116,4,133,70,251,2,160,39,63,8,241,158,108,104,0,86,79,162,246,248,240,82,94,172,52,97,115,14,128,28,104,85,179,219,23,91,173,103,243,126,205,127,12,157,24,74,214,133,24,114,79,163,240,87,100,161,71,3,131,128,228,68,225,215,45,128,140,173,26,156,215,57,128,6,13,65,239,72,0,94,77,110,226,71,115,236,9,38,246,206,129,99,128,212,212,91,180,231,237,57,179,253,59,159,55,95,202,241,100,105,76,132,137,220,119,215,174,169,35,86,26,41,216,213,116,13,226,7,150,152,146,47,139,2,77,64,35,106,57,74,11,38,15,80,213,103,20,72,229,105,0,98,79,97,226,67,58,238,142,136,19,220,90,213,63,95,111,253,122,216,225,149,195,236,226,84,23,179,227,187,93,203,22,155,226,82,234,38,222,66,80,122,195,143,182,69,4,58,246,254,118,3,0,35,221,217,184,177,209,154,221,107,2,28,174,46,36,228,76,159,170,10,4,102,77,229,212,141,153,207,3,236,248,92,10,248,147,163,13,234,126,84,84,147,142,51,123,181,109,226,167,70,29,78,41,135,29,247,242,75,206,195,119,76,186,82,235,65,16,77,43,8,217,112,80,199,30,35,186,206,148,211,8,128,163,116,97,234,93,185,108,45,120,9,0,102,83,73,207,143,38,250,1,118,116,10,64,112,72,131,250,91,150,166,89,182,117,95,159,251,185,71,218,10,237,153,149,134,73,23,188,78,37,177,81,188,129,100,35,56,240,183,248,138,135,136,165,219,116,44,100,52,64,128,2,222,54,232,65,26,141,122,69,3,94,81,166,231,71,161,47,7,210,142,228,252,96,28,32,85,89,254,151,94,205,217,222,151,200,234,224,105,150,64,92,174,193,174,79,1,138,141,108,119,209,18,110,165,129,66,166,202,104,76,160,123,27,218,114,173,20,128,128,159,30,202,0,203,147,143,16,1,78,77,98,234,238,77,184,78,54,209,251,205,23,131,250,242,101,61,149,42,247,230,227,249,122,127,78,25,245,166,7,217,138,171,72,161,180,170,14,162,192,184,250,13,31,120,226,56,219,32,26,147,30,206,66,122,204,225,144,36,4,244,77,104,100,41,84,175,50,173,29,7,13,106,81,173,239,196,85,155,49,61,199,181,218,34,176,8,32,141,212,101,29,149,117,191,190,102,218,70,44,238,219,230,87,239,114,250,181,162,146,177,178,186,14,102,2,117,160,142,167,3,136,64,73,103,10,106,32,121,57,121,196,241,197,228,156,192,4,78,79,208,3,69,205,10,236,170,173,3,88,144,200,12,106,218,39,205,105,38,45,109,19,218,142,122,127,46,193,43,204,238,71,9,89,141,205,29,29,205,77,139,195,147,146,31,238,232,8,160,149,201,70,1,216,110,7,237,10,133,104,77,84,206,18,78,193,1,66,71,242,2,56,29,117,70,35,129,83,155,0,4,50,51,101,115,111,154,144,250,62,139,245,174,26,11,189,241,159,110,214,95,145,13,147,42,251,241,79,71,151,182,12,28,248,1,144,250,117,57,101,129,185,33,136,225,180,44,77,101,75,234,114,165,181,46,229,153,32,20,2,102,73,225,176,135,38,234,25,89,156,107,224,11,135,228,50,217,186,28,209,172,115,251,167,185,158,48,5,227,82,177,98,20,148,38,213,175,95,133,49,101,10,234,149,216,132,141,6,147,168,65,208,166,0,90,95,181,220,217,100,215,160,62,32,40,132,67,2,90,79,98,219,102,233,0,168,222,134,76,186,207,167,185,142,41,159,243,104,252,27,138,177,202,242,157,31,255,110,137,210,69,81,130,198,120,106,58,179,22,0,6,209,161,232,250,102,169,106,44,59,41,116,230,149,72,54,96,19,156,92,180,102,121,107,25,86,66,88,192,0,94,81,225,144,155,2,13,66,156,51,1,72,180,166,238,93,187,191,89,188,41,191,127,143,180,82,191,160,222,135,145,45,43,169,234,174,50,113,133,170,14,92,165,221,85,5,239,96,66,227,86,50,57,29,185,172,230,9,229,122,121,3,54,202,174,63,138,252,183,207,3,0,70,77,106,27,56,61,87,196,156,75,39,32,129,76,213,117,107,142,88,135,240,20,225,147,78,100,138,82,75,55,49,253,181,9,92,192,45,211,190,156,134,17,186,193,240,94,19,40,45,123,125,47,97,206,78,45,0,40,156,83,187,212,155,156,40,0,86,73,234,176,205,0,10,80,109,145,131,36,209,49,10,117,171,251,177,165,53,206,104,186,219,186,228,189,29,72,88,85,66,177,189,217,234,103,26,153,147,69,48,219,116,81,39,107,19,119,187,119,201,46,2,157,37,125,79,210,149,100,139,65,208,200,183,83,26,152,82,212,105,10,0,90,77,106,219,155,166,0,8,158,139,41,96,128,154,115,53,251,69,62,219,220,102,173,101,57,34,57,125,155,89,245,129,208,74,229,25,39,138,201,37,209,168,202,146,170,170,57,152,99,15,25,164,153,80,223,87,150,254,218,115,233,224,232,0,226,220,70,141,196,38,165,96,2,78,71,106,203,137,16,34,76,162,167,26,1,242,80,228,116,202,222,228,181,222,210,175,187,93,111,115,140,252,82,78,15,97,223,177,191,53,190,98,54,6,23,99,67,195,214,180,53,212,140,194,68,62,46,70,162,161,182,52,229,175,2,96,64,115,226,42,137,96,64,136,97,0,98,73,102,146,104,116,136,136,36,170,173,192,145,64,67,83,176,231,202,116,219,45,111,182,237,215,126,235,140,113,214,98,27,103,134,98,99,114,4,179,150,48,26,108,2,87,7,108,10,241,204,133,237,238,111,246,20,65,39,0,226,34,41,5,36,99,0,86,81,102,203,29,26,192,58,84,27,64,66,160,54,36,207,237,77,109,76,155,93,183,37,238,109,170,91,199,227,234,127,177,34,91,199,51,51,79,177,226,57,97,54,150,100,63,232,221,4,15,1,125,175,10,185,242,59,59,97,66,22,219,120,132,224,254,182,113,231,106,6,67,196,109,178,163,21,0,86,83,110,213,73,1,0,170,45,0,38,193,48,40,91,187,190,50,115,251,178,95,69,163,134,18,203,211,206,20,237,118,101,50,27,174,203,212,74,10,129,89,127,145,4,152,77,98,59,249,66,131,107,251,143,236,188,173,128,165,107,63,33,80,152,78,76,234,124,99,137,6,98,83,201,138,7,1,26,4,79,5,192,18,136,89,164,96,205,60,95,69,235,47,218,108,76,195,237,100,118,138,197,73,139,76,216,204,254,229,73,105,129,253,163,117,208,198,234,50,7,13,228,146,10,29,72,212,198,69,109,193,100,6,58,46,235,110,115,87,95,138,151,2,94,73,110,213,155,52,185,70,118,226,220,0,50,129,212,228,166,173,109,74,179,220,92,158,118,93,194,185,172,45,40,36,101,227,124,139,30,181,130,141,101,11,12,193,68,199,104,175,225,151,148,17,232,57,227,122,133,1,13,0,160,155,80,92,29,4,29,130,197,9,0,62,79,120,21,36,0,112,174,71,0,18,75,158,154,173,121,220,227,123,239,41,159,87,90,44,186,110,198,9,11,225,152,115,13,171,5,35,65,189,39,97,101,19,29,247,160,163,108,202,51,196,34,175,25,247,168,216,32,232,28,104,118,119,223,245,239,243,173,48,179,104,14,0,58,81,100,11,0,0,156,194,32,1,82,158,156,45,73,211,109,75,150,181,246,131,233,121,28,230,92,115,117,4,231,113,9,101,121,212,132,116,20,224,218,79,166,141,236,213,229,61,231,81,73,74,21,144,112,58,120,222,43,221,139,114,13,115,69,84,188,4,94,81,233,212,6,16,129,233,57,3,72,52,88,156,66,238,187,182,235,136,95,23,83,199,84,82,116,204,58,86,218,44,166,108,67,19,250,160,55,101,55,58,77,253,25,45,167,179,41,245,128,214,161,67,184,106,117,86,193,164,3,56,147,142,130,174,5,250,160,226,125,2,98,83,110,234,137,77,79,108,38,169,54,224,100,112,180,65,221,170,169,230,154,180,237,83,103,172,230,199,91,170,165,142,44,40,170,135,144,203,162,114,83,138,199,52,186,74,53,160,21,10,4,246,246,109,219,139,168,105,96,163,117,54,28,164,105,145,175,35,70,217,104,91,83,37,0,78,73,108,234,33,217,220,65,176,218,234,192,92,142,148,171,255,232,143,148,38,158,182,42,91,155,180,91,130,38,198,165,235,117,58,204,43,96,221,235,239,115,226,86,216,82,103,161,131,76,130,131,230,237,247,193,216,130,99,46,74,64,163,23,10,189,55,94,187,126,102,234,0,86,81,102,197,143,34,190,130,44,201,106,83,138,131,65,26,146,187,55,183,167,63,154,153,199,178,72,203,114,212,223,94,255,218,190,24,233,95,103,30,13,48,202,110,83,160,76,228,75,64,215,89,83,253,212,251,31,198,180,128,251,40,93,2,125,101,155,206,190,13,89,232,200,176,130,18,0,90,71,97,197,155,164,106,68,30,213,182,9,84,28,138,92,109,186,166,154,127,213,95,178,154,136,184,169,152,105,111,174,12,120,174,17,35,132,82,229,45,9,172,197,166,37,61,102,120,19,26,216,121,73,126,53,109,89,242,47,222,4,160,57,204,160,228,181,170,12,157,9,0,90,79,170,239,195,48,233,136,0,243,177,160,250,155,95,234,56,238,99,151,168,139,195,211,20,89,92,255,120,126,210,250,22,10,172,131,96,149,197,4,206,189,82,145,4,197,161,29,40,178,250,60,180,160,65,131,211,21,209,185,10,169,48,29,0,86,77,102,203,169,138,122,104,235,89,85,80,109,97,192,70,32,83,53,126,41,218,180,152,237,140,190,26,46,169,22,11,67,194,128,12,93,156,14,194,202,121,128,242,24,23,0,88,37,184,193,0,176,29,130,23,183,192,163,1,46,104,235,16,169,78,87,78,54,0,86,69,225,134,155,230,120,1,29,71,184,122,166,234,223,207,210,248,84,44,78,143,177,170,241,169,243,198,174,107,200,65,9,39,43,58,252,145,247,7,10,128,171,20,193,121,210,175,172,113,190,123,160,173,101,118,114,87,90,155,0,204,118,24,20,139,237,52,198,146,86,0,66,81,104,213,98,80,87,1,38,231,138,132,73,208,133,66,238,122,186,29,79,28,233,159,205,55,77,35,42,222,105,33,28,56,116,93,151,41,146,115,201,247,65,21,96,227,255,30,140,103,103,184,8,128,44,77,249,118,147,29,60,83,3,102,171,135,200,85,50,59,105,78,212,1,0,74,79,106,213,38,117,20,48,170,158,69,245,235,95,158,138,113,62,167,223,158,189,62,203,236,252,232,211,8,233,10,114,136,23,117,193,134,217,101,123,19,126,165,211,236,155,54,41,49,184,31,90,7,147,222,190,201,208,188,30,23,64,17,110,22,172,144,101,116,212,97,17,49,1,90,79,233,182,167,26,190,20,210,150,231,210,0,41,32,83,245,249,77,115,60,225,122,143,126,143,57,83,235,168,4,189,205,75,182,30,46,2,154,84,175,112,67,32,115,19,223,198,236,56,7,48,17,185,100,129,128,39,1,147,207,233,237,31,147,97,125,209,61,0,82,79,98,226,164,81,95,1,17,93,174,158,129,66,138,252,255,179,194,151,185,190,29,123,151,139,213,103,123,107,90,249,188,209,110,101,230,92,124,215,38,16,213,177,164,135,175,248,116,153,174,95,234,55,5,151,157,23,230,58,79,135,72,176,224,250,58,162,185,37,75,137,68,2,98,83,97,234,196,80,1,250,178,218,210,128,144,45,164,68,141,150,54,210,209,254,227,54,197,43,126,139,145,135,254,101,138,245,30,12,231,170,70,24,65,240,180,195,184,139,125,209,105,243,211,51,93,189,97,69,0,130,70,48,51,71,186,9,5,0,90,87,172,2,133,77,0,206,165,3,16,36,184,182,238,255,148,148,235,91,231,108,34,176,193,114,129,193,78,12,237,219,228,43,177,77,48,144])
.concat([125,126,184,132,253,122,101,38,72,232,92,131,170,234,103,60,237,204,6,16,53,167,235,230,86,161,92,234,221,3,0,70,73,212,2,99,199,4,147,82,62,25,248,211,2,181,20,116,102,252,142,169,169,19,211,104,98,54,207,162,230,213,197,73,235,74,47,188,230,172,3,118,102,138,64,15,8,204,197,139,224,178,9,57,33,183,36,0,9,253,217,215,181,10,5,212,229,224,1,78,83,172,102,0,148,117,204,213,86,7,245,1,188,85,159,35,195,100,174,61,117,137,105,175,140,177,196,131,252,162,235,169,74,147,112,107,97,205,231,3,105,47,84,171,30,1,124,112,152,149,70,19,137,130,6,38,179,66,126,47,77,209,114,99,72,9,0,74,85,172,224,136,216,65,154,83,35,161,57,160,214,228,116,199,150,69,132,43,186,58,183,48,105,182,122,140,219,27,238,169,182,177,64,52,40,249,182,44,209,66,99,49,120,96,34,181,65,106,11,136,149,91,209,59,38,92,23,226,131,115,215,126,234,148,47,215,0,82,77,200,27,164,26,59,102,225,20,53,160,5,74,42,79,219,185,70,184,255,14,87,69,88,41,22,54,195,224,85,87,45,242,104,209,68,168,135,21,96,184,234,58,103,38,250,60,32,1,83,14,184,110,5,7,8,248,204,200,22,102,245,153,21,157,61,158,3,5,86,73,162,112,82,28,177,131,2,254,66,0,106,32,85,173,61,189,53,201,251,175,247,147,42,250,80,247,28,105,213,147,141,109,57,67,62,19,152,218,128,117,59,35,128,252,240,208,128,109,217,7,104,166,110,6,16,18,46,253,67,120,77,38,5,0,82,69,204,123,51,92,235,140,116,184,122,221,74,225,231,247,179,241,222,219,35,117,212,59,146,82,69,37,38,57,52,252,80,143,56,211,179,239,119,73,129,72,37,219,20,93,53,118,210,148,129,24,233,227,194,12,66,103,46,159,125,1,150,129,138,193,13,170,17,90,253,153,223,235,75,2,78,73,170,118,227,46,84,48,138,115,75,202,75,128,105,234,221,151,53,219,189,182,60,125,196,211,156,222,209,206,100,10,54,155,232,107,72,87,87,162,26,18,27,159,110,108,59,159,128,98,147,150,217,184,154,76,28,8,169,1,47,220,155,104,125,50,67,193,3,66,73,224,13,154,23,38,152,36,78,65,86,137,4,212,84,239,186,253,187,122,206,108,233,163,137,244,129,46,66,114,113,77,177,128,21,159,184,61,44,71,143,41,207,193,248,246,91,0,164,197,49,205,26,87,51,0,48,1,6,27,93,8,218,172,217,186,130,6,98,71,73,63,78,128,96,133,137,86,91,1,216,96,75,146,218,29,186,245,49,247,231,157,247,32,199,47,93,188,164,200,158,221,204,102,215,3,211,116,92,210,208,164,36,55,206,133,179,92,149,109,180,14,160,93,151,171,138,130,4,148,135,15,107,239,45,223,83,194,18,13,0,102,83,137,245,11,110,162,219,130,234,33,85,127,251,145,198,186,232,240,96,107,183,225,110,250,178,197,46,90,190,207,172,207,158,20,88,215,210,157,189,211,205,5,102,81,112,32,8,200,73,185,106,63,64,192,7,237,211,198,181,208,177,98,182,50,48,1,70,79,34,218,184,240,117,1,70,231,76,220,196,57,157,68,125,186,62,181,151,103,237,143,230,59,243,134,248,231,86,85,100,244,156,13,197,118,233,130,241,145,179,51,49,142,41,14,213,216,72,1,35,23,127,211,113,98,2,146,172,118,153,25,68,145,206,197,1,0,79,103,103,83,0,0,0,178,3,0,0,0,0,0,81,117,155,31,9,0,0,0,194,198,218,60,59,71,70,79,71,72,69,69,72,75,72,70,71,70,76,72,70,80,71,72,60,66,69,74,76,67,71,68,73,66,66,69,68,69,69,73,76,66,71,71,67,70,70,73,74,72,78,71,68,65,71,61,72,66,61,65,63,66,64,68,82,73,204,219,140,205,248,176,74,117,84,59,128,112,40,242,214,123,77,204,99,73,221,115,46,73,185,82,31,67,232,13,211,106,165,170,19,20,58,110,24,31,152,109,231,185,144,64,33,194,139,121,10,65,58,210,148,164,0,15,77,151,134,132,28,213,218,209,11,13,0,86,71,34,251,145,170,62,208,129,195,213,230,129,156,132,146,170,87,151,121,243,39,253,182,44,203,174,169,103,59,225,164,162,186,159,244,24,139,106,224,6,95,4,32,165,50,40,138,192,153,192,224,104,2,54,154,155,81,72,0,208,36,52,115,73,11,25,211,3,0,70,83,196,27,152,90,47,128,106,99,224,210,32,150,90,252,61,203,104,219,243,214,101,239,146,74,189,100,34,110,245,102,38,181,10,4,211,177,106,193,78,27,136,80,189,255,106,242,245,40,104,99,96,189,65,1,204,109,19,8,173,107,187,194,0,218,78,11,237,122,76,4,211,150,132,201,218,107,13,58,87,168,15,196,229,21,228,83,109,147,64,141,132,201,228,89,53,169,82,52,155,88,207,212,198,144,37,154,106,164,222,82,75,211,10,125,116,118,90,208,63,195,142,108,18,246,7,160,161,172,237,35,104,174,91,112,186,110,19,227,68,119,73,146,209,40,247,66,126,0,90,79,166,118,227,230,107,64,210,178,218,22,200,0,52,87,110,63,79,51,250,232,251,101,61,55,75,53,82,33,241,87,203,55,109,201,44,63,234,176,99,9,197,97,40,72,63,13,64,0,27,91,110,235,173,17,148,73,49,31,219,40,53,162,153,146,96,219,4,114,9,0,70,77,160,109,134,203,117,6,84,107,16,81,3,138,68,243,76,203,154,85,191,111,253,255,221,230,220,122,154,151,200,102,183,229,19,49,163,128,185,46,109,146,1,31,155,1,151,103,123,192,56,33,128,217,159,162,4,173,136,188,16,175,20,145,130,42,59,160,1,94,75,33,59,49,61,70,152,235,170,218,31,56,3,229,106,126,69,76,106,191,108,98,155,212,214,130,174,135,87,3,159,196,252,97,44,76,189,180,101,206,251,241,27,13,246,1,10,164,204,237,195,141,82,146,47,72,7,116,105,88,105,94,94,211,178,2,38,0,86,71,46,122,144,69,208,160,59,170,103,154,250,171,227,169,88,247,80,248,114,113,152,207,27,159,60,227,7,174,48,91,129,121,9,168,176,210,20,24,2,29,193,179,9,192,10,64,211,203,162,212,50,135,115,85,92,126,173,96,246,214,185,98,70,160,109,148,33,24,22,0,90,77,38,122,83,204,189,19,130,114,127,0,14,69,45,166,101,233,242,180,207,247,152,124,221,120,234,169,167,73,71,205,96,147,146,5,172,11,123,98,13,172,197,142,53,31,44,210,140,252,1,220,44,72,189,0,19,211,9,66,248,161,232,252,141,203,50,35,145,77,222,105,229,2,29,86,73,34,250,35,34,17,214,185,115,74,132,51,100,73,149,125,251,166,217,239,207,213,244,95,58,207,77,198,182,6,44,157,243,76,86,200,230,119,25,185,252,38,182,219,3,138,23,172,132,110,177,54,172,96,24,49,129,15,96,112,132,166,195,145,47,32,139,108,22,201,4,82,75,137,246,196,170,94,94,96,78,157,54,71,194,192,77,101,95,190,220,215,124,201,234,150,181,191,166,93,203,227,166,222,213,133,155,91,239,53,169,177,71,156,35,123,208,216,121,40,214,66,224,156,191,13,216,96,60,203,52,100,0,124,114,186,118,210,236,248,7,66,71,152,122,64,157,174,160,184,170,23,109,221,255,95,35,123,124,249,94,233,242,180,31,121,236,92,172,40,133,165,206,139,47,24,52,116,88,173,234,144,136,109,3,67,143,6,47,164,44,62,135,110,57,97,86,140,39,64,224,193,1,255,70,242,80,186,51,11,58,0,82,73,138,187,17,215,112,192,86,230,92,67,136,73,144,114,117,178,237,154,188,190,223,245,235,26,123,8,42,65,116,200,235,167,78,154,121,183,175,185,159,155,66,55,153,14,107,206,209,1,197,147,44,244,242,95,67,50,55,2,145,60,232,58,175,123,107,166,9,0,70,73,140,26,74,121,9,135,85,235,204,57,150,4,18,40,154,90,79,214,158,121,244,253,121,245,237,186,48,51,103,204,203,138,153,15,243,249,216,190,119,201,115,0,210,182,173,179,57,5,48,245,216,168,28,185,205,24,236,136,84,106,100,90,3,148,206,148,232,114,60,244,108,112,5,0,86,71,130,38,138,47,174,160,168,62,15,72,32,229,234,115,111,254,79,219,111,235,146,249,214,114,253,108,195,206,157,217,97,245,90,245,238,116,200,8,115,60,105,192,182,200,14,178,79,76,102,129,47,220,126,149,103,155,9,57,1,248,97,55,137,212,209,66,68,241,1,0,86,73,130,251,81,194,76,72,150,239,84,156,132,227,72,85,183,209,112,159,38,213,122,200,182,31,77,135,129,101,23,151,103,103,12,21,234,104,221,66,152,204,167,19,238,198,214,99,71,113,157,225,214,251,45,129,12,9,83,147,92,63,118,37,120,72,125,18,1,0,86,85,76,74,0,21,66,134,231,34,16,201,2,179,84,158,177,175,172,109,254,222,150,46,165,41,202,37,151,210,212,10,44,110,9,187,21,252,77,85,113,179,180,100,172,212,198,152,252,21,64,88,186,84,232,224,89,100,246,141,8,124,22,153,136,51,165,16,66,172,242,119,70,107,224,25,205,79,59,72,94,79,68,144,108,94,212,21,148,206,185,52,224,97,45,138,69,89,20,67,179,231,95,186,9,63,44,22,163,238,224,78,167,3,187,25,76,23,17,75,172,27,168,143,232,206,225,213,59,100,65,13,112,242,54,92,121,247,38,38,20,157,144,186,162,211,210,176,90,235,0,62,75,8,11,66,56,175,214,227,122,122,62,1,61,128,102,155,77,103,95,68,28,203,202,183,180,66,104,177,143,84,177,173,181,214,228,160,15,70,197,58,6,192,1,49,60,187,14,36,206,210,44,150,177,245,172,9,16,153,0,104,93,76,166,206,97,110,238,144,72,58,0,98,81,78,89,166,188,240,2,252,67,207,5,192,145,72,201,210,223,107,141,136,35,110,181,44,19,170,92,85,200,185,42,168,12,31,141,141,118,83,26,170,61,32,60,115,31,32,120,39,0,2,20,164,71,114,120,201,121,239,0,90,81,14,44,81,247,18,0,80,109,3,120,48,180,170,183,234,45,107,138,219,221,243,175,90,22,247,13,126,251,204,240,238,222,94,60,46,246,144,162,13,155,236,141,195,68,73,157,0,152,183,96,53,208,8,75,253,160,52,128,142,82,213,76,233,0,42,75,154,0,243,122,249,66,28,61,231,129,133,8,164,182,222,42,142,78,159,63,109,155,139,38,94,255,150,101,177,193,232,117,13,165,219,212,91,42,122,69,220,114,2,200,165,73,163,80,186,185,164,148,19,228,162,54,1,192,38,58,39,103,104,139,120,2,0,82,73,140,123,35,102,61,17,26,106,215,151,5,96,13,138,106,222,255,215,98,107,127,253,146,125,135,107,28,63,89,107,202,144,214,143,178,169,236,140,66,203,153,55,183,198,121,165,200,199,208,55,20,138,156,163,184,221,50,13,7,102,70,122,111,130,227,72,115,46,164,219,156,0,66,83,132,26,40,87,155,129,201,185,0,16,1,134,202,51,191,79,182,44,237,218,167,251,177,44,77,170,135,97,164,202,73,44,246,233,89,239,220,181,15,171,36,123,35,241,38,8,32,214,165,0,83,46,229,3,126,60,224,240,109,194,114,163,58,9,134,203,147,224,114,96,102,72,10,0,50,85,8,43,53,184,134,23,68,152,79,153,250,141,23,23,78,211,248,89,159,255,234,113,177,170,251,84,207,67,135,148,44,90,139,222,86,230,109,141,197,155,130,68,159,117,131,5,16,108,1,229,109,72,3,132,128,86,4,203,49,153,207,149,107,38,0,62,83,24,44,44,152,47,104,100,89,189,211,212,191,215,99,85,167,194,43,133,185,250,249,98,111,28,91,152,225,31,107,155,152,187,204,110,136,89,237,146,2,219,21,155,3,76,144,4,60,158,85,177,28,106,240,192,79,83,189,201,66,52,27,205,22,114,237,132,2,0,82,73,6,123,106,117,9,23,48,152,106,107,6,193,32,53,181,27,159,206,219,222,247,167,146,219,74,41,77,173,127,94,153,216,188,146,16,255,76,234,36,44,87,26,214,240,193,146,142,63,120,116,46,151,10,6,192,4,18,141,174,36,179,50,10,205,73,0,62,79,64,20,81,94,213,43,224,92,0,212,65,160,168,220,60,91,187,88,106,223,242,169,94,61,102,158,119,82,134,109,12,37,39,139,5,165,9,188,153,69,64,61,27,205,65,102,233,190,67,163,0,166,61,212,233,192,147,69,83,6,67,95,193,30,15,43,11,94,186,210,1,62,71,64,13,148,94,175,72,142,226,220,8,160,1,10,171,48,205,127,187,37,60,77,219,25,71,76,129,97,112,209,54,67,150,22,95,41,158,253,70,193,224,66,88,244,108,76,106,44,39,58,165,13,145,154,98,76,180,67,211,232,247,81,13,38,0,62,71,132,219,53,154,227,5,233,201,109,169,76,199,15,94,169,30,27,169,171,63,231,122,47,206,83,142,134,241,55,222,103,40,238,119,53,182,27,209,59,139,170,161,39,192,4,134,152,11,0,100,216,50,135,70,184,32,117,66,65,113,211,36,2,0,42,73,153,139,184,73,117,144,119,14,64,155,6,169,106,123,107,125,121,179,100,191,246,119,82,57,35,32,114,179,159,41,165,47,206,4,98,211,115,247,58,131,1,207,241,70,247,151,160,129,58,110,177,78,153,180,66,36,187,111,209,105,150,240,72,61,58,7,0,70,71,40,138,94,41,21,64,47,205,169,8,236,181,181,72,102,106,23,141,69,218,207,39,45,93,212,44,42,90,102,146,39,24,1,191,208,237,170,223,49,66,225,97,219,224,88,67,9,148,44,44,246,106,115,16,18,147,87,152,166,60,45,157,76,222,68,1,74,77,72,83,174,5,143,224,94,119,78,128,32,81,88,166,222,215,101,161,214,219,188,115,79,52,22,195,219,42,8,239,67,223,69,130,144,77,144,68,96,136,130,132,81,162,167,237,32,209,109,190,170,17,10,61,145,132,18,146,110,148,82,212,203,206,88,206,9,82,79,72,106,40,193,2,120,230,59,21,1,227,208,44,213,117,234,168,72,71,109,203,113,111,45,239,37,233,218,45,26,186,98,175,106,169,57,78,203,167,204,255,201,129,137,109,43,160,211,17,140,181,81,179,235,58,82,11,173,104,8,83,223,56,232,41,41,1,82,83,140,107,136,235,152,177,110,203,83,5,200,36,80,76,211,148,63,109,165,246,187,101,203,178,166,153,19,119,197,134,53,213,229,81,96,255,160,92,44,40,33,83,172,3,2,152,57,151,126,20,32,178,195,52,181,83,0,22,66,69,238,230,150,182,132,140,225,215,131,241,0,74,81,66,75,211,14,63,144,173,191,79,77,2,15,2,169,114,207,219,62,81,145,238,250,171,175,148,178,97,124,229,58,174,105,38,213,7,58,146,85,122,223,95,0,29,62,6,0,237,215,51,129,214,203,207,72,116,154,228,175,230,89,171,48,153,157,21,37,182,222,250,146,40,191,8,0,46,77,156,115,165,125,149,25,89,181,111,62,85,51,239,191,86,207,149,170,250,115,159,15,16,146,237,42,38,12,97,94,98,72,109,152,98,88,244,78,211,139,2,38,176,162,0,223,2,104,243,155,7,19,78,127,130,149,188,150,137,255,40,220,9,0,66,75,136,27,104,175,57,161,137,90,179,165,33,245,191,97,236,96,158,171,170,186,98,213,203,155,172,183,75,47,172,164,86,49,58,34,197,67,109,14,73,13,103,11,148,177,165,160,96,61,27,32,217,143,73,42,162,129,128,210,64,215,76,10,133,38,28,33,196,4,0,82,75,130,123,148,118,148,10,190,240,157,139,3,114,1,82,53,223,167,230,120,226,251,237,123,202,119,228,213,22,4,165,204,145,194,109,105,209,252,2,139,3,218,132,130,214,141,84,232,0,87,180,166,91,33,22,244,163,0,244,198,51,102,110,116,49,114,75,141,4,0,58,73,146,41,134,151,81,65,119,174,30,83,245,149,121,250,56,62,184,115,246,185,255,34,35,171,118,63,36,110,205,11,179,137,250,68,63,142,10,196,163,128,53,236,168,107,36,64,163,121,35,12,142,137,67,62,83,16,233,76,169,73,211,51,98,27,0,90,93,161,112,235,174,127,2,232,169,239,115,41,128,0,146,107,250,237,235,90,79,238,59,182,103,175,5,103,94,114,105,20,45,67,39,113,196,231,194,41,26,145,128,201,148,252,253,211,1,232,246,19,92,231,134,48,62,0,254,255,255,123,74,16,0,2,250,5,5,94,105,161,118,210,201,61,89,165,219,156,3,176,136,65,81,78,231,173,177,158,249,242,123,82,255,46,125,121,234,33,226,62,42,58,188,46,205,227,191,19,166,99,242,30,32,11,72,61,224,204,49,144,0,156,17,131,165,54,160,236,207,212,31,50,133,195,161,81,0,82,103,166,118,162,233,172,136,91,203,231,6,32,96,22,151,167,221,79,210,204,225,237,42,178,167,233,60,97,91,174,13,43,27,153,75,185,77,91,71,180,25,33,176,247,62,78,224,43,163,2,5,94,60,0,246,38,168,149,185,146,186,90,199,36,144,112,64,148,16,78,23,0,90,109,161,239,36,210,94,145,213,253,115,46,0,6,40,92,158,236,94,169,154,54,45,105,150,231,91,42,24,18,5,123,78,80,168,86,61,93,20,175,155,179,10,129,190,50,76,188,158,13,33,53,140,232,80,155,13,128,224,223,69,88,229,106,26,150,96,22,134,152,58,58,0,116,82,109,36,26,130,144,221,42,221,58,231,0,171,134,161,86,78,199,150,101,137,58,222,245,23,147,189,205,186,230,52,84,48,6,193,48,62,76,102,154,66,19,92,42,189,215,63,7,166,110,162,133,108,230,34,203,162,65,2,89,122,140,33,157,198,75,133,103,223,189,33,1,78,101,92,3,97,116,208,229,156,91,7,13,142,154,203,211,99,110,169,93,219,255,117,44,247,171,209,254,131,179,188,149,14,40,70,119,53,187,43,116,10,22,54,178,163,81,154,137,154,125,70,153,105,116,237,176,121,19,38,244,11,201,180,215,37,89,72,19,84,152,141,73,119,30,91,104,56,0,86,95,24,177,6,197,12,58,152,249,228,154,236,254,97,135,249,117,222,173,15,235,227,115,197,185,240,88,121,160,230,92,74,135,164,127,98,31,249,240,185,175,89,122,128,6,7,174,167,209,196,40,100,2,122,196,13,76,214,173,251,216,68,251,52,231,208,212,112,30,0,94,87,4,164,5,74,38,208,193,156,15,67,90,32,149,39,139,137,38,189,245,172,231,241,236,101,194,12,72,171,45,12,214,177,74,181,154,29,138,54,117,221,116,96,204,136,168,145,198,208,217,150,192,193,38,16,180,157,106,184,77,92,77,57,90,17,224,52,70,89,20,131,8,85,65,199,173,94,212,100,215,71,100,253,74,245,183,145,85,149,151,245,242,12,172,78,138,34,4,42,69,123,100,7,98,204,197,96,2,80,252,208,112,224,1,109,99,34,80,250,21,53,57,213,227,126,21,106,14,32,37,240,29,74,83,88,35,163,50,119,155,116,232,115,192,229,68,66,44,16,147,221,219,107,111,210,146,189,191,123,118,69,215,210,213,105,113,150,48,202,175,61,147,120,19,170,122,117,60,70,138,198,63,111,5,128,153,21,55,196,190,2,25,162,180,107,68,166,165,15,13,28,26,0,74,81,144,1,160,131,84,245,88,164,58,254,123,24,59,24,191,121,20,198,94,40,194,0,166,201,5,31,178,219,49,103,109,35,135,78,5,86,16,14,62,206,128,5,128,171,129,167,41,172,1,5,68,110,108,152,0,99,17,152,0,74,93,116,202,137,54,14,172,207,131,153,0,98,106,113,82,127,57,235,105,239,245,180,175,228,95,152,193,114,152,125,163,83,227,185,228,105,103,29,23,226,142,0,31,251,227,0,150,198,37,18,5,222,68,223,84,20,77,135,117,59,131,226,46,187,237,145,54,160,155,26,0,70,83,188,2,85,163,194,146,83,3,32,19,114,98,114,191,111,73,105,223,62,41,235,92,141,29,148,117,49,221,25,135,46,165,240,220,40,109,53,133,142,92,64,137,15,0,48,140,172,41,38,234,0,133,212,48,184,95,93,121,104,228,138,82,225,1,86,79,160,21,170,244,11,120,29,159,19,14,2,90,146,196,35,89,102,219,179,121,238,185,199,146,30,100,24,89,59,235,243,228,10,166,234,243,53,246,121,224,106,61,61,87,3,207,156,14,162,200,26,192,91,127,227,99,44,33,0,98,77,140,91,76,210,58,102,249,21,127,17,134,148,16,147,168,91,155,202,47,191,142,173,235,210,81,174,37,54,114,131,226,96,135,23,139,82,218,29,40,7,162,193,229,129,203,14,54,75,44,128,70,129,167,43,178,164,129,58,19,251,244,9,5,114,83,6,156,192,195,5,214,242,206,69,24,68,64,7,146,178,91,106,146,127,54,101,237,253,215,106,104,31,21,108,101,155,80,189,109,178,51,141,138,6,52,32,9,48,2,125,219,103,62,0,8,141,57,209,108,108,74,100,158,86,213,0,78,77,26,56,66,202,97,29,119,244,28,112,44,91,72,165,51,239,149,102,77,203,173,254,217,109,26,141,183,9,51,179,85,108,85,75,236,5,87,43,49,79,225,144,64,242,224,33,201,10,56,59,63,79,12,0,145,156,33,20,164,226,240,131,8,2,86,79,156,104,40,42,47,48,203,157,18,26,200,65,170,156,165,45,26,247,245,254,180,203,35,167,73,73,106,168,250,206,213,90,199,186,60,84,104,212,209,186,142,39,0,29,40,160,23,134,81,64,47,102,58,93,201,113,172,244,82,105,189,1,86,73,128,53,20,228,64,192,3,226,148,48,63,135,212,148,253,219,70,91,154,243,235,15,145,218,242,69,33,45,86,198,206,184,138,179,119,145,132,162,106,66,232,248,120,128,14,202,38,100,161,160,133,80,141,39,80,208,104,88,188,64,233,122,79,23,205,1,79,103,103,83,0,0,0,44,4,0,0,0,0,0,81,117,155,31,10,0,0,0,238,81,90,253,61,67,68,60,67,64,68,65,70,62,68,64,70,71,70,68,68,67,66,67,69,61,67,66,69,66,68,62,67,67,69,67,67,71,62,67,72,66,64,70,67,72,66,71,64,69,70,67,62,74,69,70,68,70,69,70,76,69,76,69,71,74,90,75,136,216,40,74,189,34,84,199,167,10,50,60,35,33,53,53,157,241,164,44,175,235,247,191,185,151,49,110,197,253,130,174,72,13,9,68,73,215,16,38,16,248,192,65,3,234,108,1,209,28,234,12,21,5,0,68,157,5,167,189,83,92,70,3,0,58,71,17,0,204,94,64,13,159,65,15,34,32,85,205,106,126,235,145,252,154,255,83,19,156,106,86,216,58,155,162,173,245,154,227,19,125,207,83,135,148,16,147,162,17,94,119,23,229,161,237,65,169,209,1,40,148,242,70,205,210,26,173,53,243,231,8,19,82,75,146,104,8,197,43,34,250,248,28,80,37,59,80,194,116,155,54,226,31,199,243,221,123,135,212,44,31,20,186,239,206,152,117,196,183,167,18,64,1,215,30,230,130,4,18,115,7,240,147,218,96,119,147,65,187,35,38,0,90,87,212,40,46,76,14,68,244,212,57,96,144,32,85,206,162,137,169,212,52,203,18,205,124,248,230,213,118,220,112,176,21,57,126,73,33,162,24,213,32,114,66,66,0,126,115,11,1,60,223,214,197,4,186,103,76,113,60,148,210,57,194,109,82,235,0,98,77,192,44,20,31,23,224,14,87,219,192,193,141,86,205,219,76,76,31,107,44,237,189,222,226,68,106,55,186,98,179,109,117,26,238,1,139,172,208,0,18,190,3,31,192,100,97,198,44,47,11,112,208,189,102,138,97,190,100,21,135,42,0,78,83,218,25,24,241,43,144,59,21,16,13,4,80,213,94,164,253,190,198,182,228,103,187,215,210,162,164,21,141,101,238,27,41,236,106,222,230,152,193,76,32,117,138,226,54,194,4,62,110,9,1,201,51,207,138,17,211,150,225,108,110,120,190,21,194,236,4,82,73,92,88,40,195,174,136,122,214,57,29,58,12,2,53,181,75,101,94,158,115,249,249,167,26,58,105,195,166,41,159,217,150,46,205,201,28,193,218,3,31,15,0,179,73,15,178,79,208,162,54,83,146,58,7,78,82,51,187,122,229,150,57,76,78,77,90,25,20,209,175,192,248,212,64,6,18,116,32,114,143,47,172,217,213,87,190,221,245,81,151,84,111,182,202,94,90,44,118,205,5,182,49,16,9,108,20,144,51,99,0,139,54,54,116,82,113,41,149,144,58,22,75,204,115,238,62,130,85,250,107,201,107,7,98,77,72,217,64,141,43,108,121,168,158,107,56,0,169,169,95,19,77,196,26,73,251,139,183,112,42,254,120,91,165,22,22,188,48,194,131,87,252,107,0,1,5,32,252,0,64,46,17,17,197,3,80,163,57,208,132,184,210,133,46,11,82,73,214,25,56,183,23,224,58,206,1,75,96,36,49,245,106,163,154,174,187,102,171,60,62,99,135,185,236,105,165,42,60,181,99,205,198,121,168,83,223,202,49,41,171,131,99,54,226,204,188,72,36,33,26,204,1,160,144,208,234,150,137,107,20,166,124,0,90,81,216,88,104,89,94,129,218,120,142,64,29,16,78,32,202,189,242,73,75,244,99,211,198,17,21,6,45,103,165,206,75,122,181,81,84,137,21,224,18,152,0,56,49,186,169,164,89,26,4,5,10,58,41,113,185,210,200,62,205,210,61,0,94,75,84,216,46,212,126,129,217,53,159,3,14,24,41,45,245,127,174,233,123,94,81,241,205,91,191,32,2,97,121,85,206,170,201,198,157,124,63,220,2,221,9,29,18,186,79,201,162,200,84,4,152,95,55,65,128,211,0,56,10,217,94,148,198,72,111,180,211,0,78,71,146,24,136,186,95,177,221,46,122,150,136,36,12,82,174,222,126,105,153,88,102,237,235,73,123,9,0,36,253,103,117,37,242,146,208,212,219,71,65,55,7,128,124,32,246,238,78,193,172,101,161,120,161,190,36,252,10,152,0,197,163,196,37,79,163,179,200,135,0,90,83,24,73,119,125,93,237,182,154,115,192,192,33,229,154,251,178,71,181,205,82,177,119,77,182,94,131,33,220,238,225,117,21,155,188,70,8,21,42,13,178,209,241,5,96,88,191,145,146,233,141,33,161,248,73,116,9,76,29,69,146,183,194,237,162,167,24,10,0,66,87,49,37,197,196,124,197,190,56,142,115,64,27,0,84,185,249,173,181,166,212,156,115,28,213,71,227,53,139,122,227,175,42,209,54,218,201,120,148,79,169,172,128,125,144,110,99,0,52,150,105,16,221,63,128,139,171,207,196,113,146,75,154,94,99,74,0,86,77,212,80,69,187,180,111,168,38,103,245,156,112,22,14,177,64,85,54,123,45,186,181,121,82,181,150,154,134,6,161,81,70,171,92,226,221,204,15,192,195,26,143,128,49,78,79,115,34,103,1,48,123,115,22,3,65,3,160,24,96,58,178,201,176,96,49,90,79,50,145,69,168,233,5,221,194,7,244,156,48,28,224,132,164,57,109,42,103,223,31,87,118,184,164,146,145,246,182,146,238,112,188,210,19,115,196,64,194,252,54,177,212,192,40,48,219,96,11,46,99,152,64,162,72,142,211,103,201,38,48,210,5,0,102,77,196,24,174,168,248,10,251,78,234,92,76,100,144,128,154,186,100,90,103,90,186,110,94,143,101,24,212,35,217,184,89,118,11,138,229,10,150,58,231,108,224,195,53,76,251,26,0,12,215,45,33,204,100,128,4,32,147,40,15,78,183,88,52,0,98,77,200,24,164,158,47,176,191,171,115,13,61,36,96,8,41,123,151,48,141,249,110,235,82,135,168,162,35,196,200,216,173,35,13,61,144,47,59,131,214,207,76,246,8,161,163,1,128,243,187,189,95,169,131,208,65,119,114,206,12,205,59,71,78,22,0,98,75,224,108,43,166,242,101,213,254,235,226,220,66,36,146,83,180,53,75,170,61,36,211,165,184,91,175,198,39,23,245,23,87,39,30,57,85,68,150,38,36,65,66,64,71,190,132,39,0,88,180,204,167,203,212,116,34,65,130,160,7,61,12,135,215,29,19,0,98,81,16,12,207,91,7,216,178,173,166,206,9,3,4,133,160,101,189,134,123,179,172,79,246,44,119,229,105,119,146,240,53,219,96,143,84,51,236,11,186,86,10,33,124,34,24,134,60,48,46,128,64,148,158,250,89,60,103,215,1,94,73,56,104,238,55,52,4,219,245,244,156,208,134,3,184,210,105,27,147,214,109,143,43,182,173,221,155,152,102,229,18,140,182,229,208,101,130,177,26,205,143,80,234,64,224,65,129,3,176,235,159,112,172,154,10,128,176,223,253,111,228,214,186,20,2,0,94,79,200,25,34,132,23,171,182,106,170,218,128,38,129,128,158,168,108,233,73,54,107,173,71,246,111,87,220,179,139,230,50,172,117,171,66,206,192,170,77,253,144,1,2,125,38,8,160,15,14,76,115,243,139,52,26,4,160,231,83,72,158,216,55,1,82,79,49,229,185,197,242,109,11,29,116,6,29,16,6,39,202,61,30,109,45,237,44,214,222,63,165,211,43,69,102,147,70,225,161,140,5,118,147,139,88,61,153,17,32,123,130,128,245,44,229,214,197,81,86,208,65,97,197,20,157,57,221,160,233,102,167,48,1,66,87,177,17,218,173,6,214,3,156,13,25,112,24,170,44,91,106,169,148,102,217,214,123,61,26,239,116,28,157,81,95,41,8,230,110,189,96,129,253,159,53,52,183,186,131,73,3,136,114,47,187,242,52,121,128,9,83,252,138,148,167,136,97,11,13,110,83,70,89,136,190,190,108,45,129,115,192,1,35,85,109,82,196,60,235,44,226,216,254,133,213,149,237,253,177,33,27,123,166,173,148,209,66,69,77,7,217,173,138,70,240,192,70,114,120,185,136,196,44,44,161,0,104,223,243,148,16,251,148,110,10,147,6,98,85,196,57,49,193,191,1,231,128,42,3,32,38,145,219,46,201,162,217,115,217,196,115,148,238,137,172,21,220,188,64,41,34,157,230,3,197,107,15,180,128,236,50,1,68,224,217,11,112,114,2,40,108,72,228,165,189,119,13,219,0,106,77,16,156,178,213,124,177,206,35,244,124,24,24,212,18,53,177,200,187,152,195,122,221,196,41,157,183,186,95,105,57,46,178,159,109,158,237,32,150,161,48,29,51,192,87,161,3,235,178,122,20,173,183,6,120,30,244,166,189,197,173,77,118,215,41,0,90,75,92,105,122,232,237,197,230,252,194,231,193,65,3,105,208,108,19,241,253,80,87,147,44,77,159,216,140,93,187,130,52,255,28,205,9,237,179,120,56,60,220,180,2,38,112,234,102,144,44,89,4,104,192,249,192,34,213,164,16,107,23,114,183,167,1,86,75,88,104,20,93,93,208,37,137,115,3,13,39,33,102,96,250,55,89,92,125,74,209,110,162,114,151,220,219,86,67,117,88,1,170,67,245,105,197,43,174,192,129,191,71,15,141,26,192,44,47,236,154,84,182,48,165,129,194,108,10,195,133,237,86,40,19,0,74,77,214,113,89,186,126,69,39,167,176,206,9,29,16,144,36,168,219,25,109,125,103,138,104,242,233,53,119,232,27,169,12,85,8,22,85,101,0,70,164,113,140,3,204,173,254,160,3,15,214,30,31,209,69,72,0,201,53,9,49,123,39,22,28,154,14,90,85,178,116,178,204,234,130,238,215,238,84,65,6,28,6,81,217,18,147,102,75,117,116,183,187,215,82,212,205,214,171,13,219,174,206,92,139,212,104,60,233,43,206,200,161,119,36,208,31,155,21,221,78,33,161,5,82,14,123,63,3,69,27,86,79,73,114,85,34,120,194,112,41,147,205,110,59,113,46,192,1,35,152,45,203,155,212,68,182,46,185,175,75,79,149,62,80,173,218,220,123,180,85,96,85,118,157,230,157,2,64,223,8,132,132,157,32,100,218,240,137,198,133,77,76,28,165,52,30,204,244,243,79,108,212,188,4,102,91,40,241,176,92,108,70,183,45,240,13,12,225,142,36,149,221,74,52,219,78,174,113,21,37,67,8,189,157,86,216,208,226,192,236,131,81,1,152,200,81,113,68,50,192,43,115,140,130,198,5,186,81,224,99,197,160,235,27,249,7,86,85,88,25,140,240,238,80,149,134,251,2,12,212,16,72,69,243,254,12,255,172,142,173,222,104,218,121,116,72,171,59,139,59,203,193,220,242,104,218,255,153,12,176,9,152,176,212,61,221,128,34,173,56,129,164,211,91,244,222,212,76,31,26,212,43,0,94,81,212,216,220,249,115,130,109,71,79,117,78,180,228,255,138,85,25,127,10,125,118,19,71,140,219,165,137,196,129,215,100,25,183,250,239,104,235,116,142,19,128,81,202,4,248,249,9,0,109,83,167,189,68,121,225,73,41,222,190,137,113,13,217,139,21,130,85,74,26,0,106,89,66,249,48,114,247,12,91,142,60,167,76,96,36,168,234,255,76,169,125,43,222,68,62,117,251,220,153,184,41,242,39,93,14,63,194,109,163,1,160,176,13,20,128,133,201,151,182,77,192,138,142,206,145,22,244,39,103,27,156,199,201,174,3,0,102,83,68,121,88,161,125,129,181,223,229,115,105,24,8,80,83,39,41,203,170,201,151,84,41,45,135,86,96,149,169,2,159,72,24,186,179,248,129,130,137,107,24,152,5,232,155,97,82,128,104,25,100,130,3,39,152,113,141,75,169,133,192,3,94,83,96,188,217,190,206,43,201,210,151,131,231,50,129,97,135,34,145,123,202,45,245,201,103,189,199,114,53,111,240,50,173,194,46,88,82,252,19,160,164,244,118,84,50,6,203,62,121,90,77,227,6,33,157,241,1,14,56,176,166,87,108,114,77,106,103,96,42,0,110,87,44,245,231,52,231,11,150,207,167,7,207,69,192,25,20,9,211,115,109,38,190,183,61,242,103,154,180,174,91,21,155,65,217,18,92,56,151,8,212,61,147,120,206,65,3,245,38,180,33,160,37,124,218,79,66,67,115,122,250,73,239,83,215,31,0,86,75,24,121,250,118,189,175,176,118,154,207,93,0,167,129,194,73,154,207,116,44,173,236,171,203,183,68,82,50,152,213,254,162,131,175,103,2,251,185,44,27,187,225,229,66,7,112,255,229,242,31,74,3,29,153,140,0,160,161,192,236,85,178,80,205,250,93,112,238,26,0,82,75,88,219,253,246,42,135,205,172,106,62,23,97,160,6,229,76,183,72,117,62,169,246,238,121,115,198,248,86,220,33,180,128,46,97,29,222,64,128,171,1,20,216,180,14,224,178,157,99,124,167,254,59,195,192,153,102,118,124,157,53,102,107,17,0,74,79,116,69,11,167,190,5,150,19,62,151,134,68,8,224,218,186,165,56,101,81,107,202,142,38,73,226,199,38,133,145,152,106,41,27,8,54,182,25,138,3,114,134,71,195,111,207,41,13,224,115,230,110,96,95,225,94,35,1,242,17,8,154,38,153,198,204,17,219,2,90,87,200,2,19,152,96,230,7,236,222,66,115,213,212,201,196,247,68,127,180,43,241,184,156,217,50,89,129,111,163,214,225,164,182,16,80,1,123,78,88,57,40,0,182,148,174,111,54,138,70,8,58,60,122,162,179,62,154,110,32,181,9,0,82,85,146,131,71,232,21,112,142,0,231,145,72,85,243,175,45,199,68,54,206,46,85,93,249,192,198,234,148,212,230,158,72,129,70,11,134,108,11,2,198,5,134,175,37,83,0,244,179,228,75,73,131,43,160,128,181,210,52,148,109,168,154,253,69,90,242,138,3,98,87,36,74,181,4,34,108,15,224,84,0,44,1,219,148,127,210,44,249,214,230,55,143,69,250,73,250,215,82,177,135,102,129,111,241,101,10,60,216,45,172,108,120,124,19,38,124,3,110,102,33,85,18,177,1,104,192,163,105,211,91,228,68,89,176,73,97,122,3,102,89,36,43,122,155,82,99,45,222,10,158,74,193,65,13,114,211,252,106,173,57,45,249,251,203,214,164,86,107,187,101,117,116,92,40,97,77,155,245,224,21,138,183,28,84,65,39,0,232,25,219,231,98,146,1,144,13,76,36,146,195,115,164,178,158,0,102,87,202,27,52,81,42,97,157,114,167,178,0,33,32,9,42,154,138,186,165,227,185,199,175,157,138,236,226,186,170,121,175,67,214,188,14,76,139,178,101,113,167,108,150,182,8,131,104,76,86,36,120,63,21,26,217,76,169,219,173,1,86,81,160,173,184,117,233,72,26,84,91,2,192,51,17,169,105,254,83,61,233,8,203,149,173,205,177,230,9,83,114,44,45,177,93,195,28,159,24,88,220,193,25,2,235,77,109,108,54,220,1,192,16,35,250,187,189,209,160,0,104,83,211,164,208,75,119,62,92,10,183,202,170,0,66,73,82,147,120,186,196,25,217,137,115,11,7,1,201,85,111,191,17,107,155,42,229,135,103,82,67,237,225,81,241,134,38,56,9,107,24,197,213,61,176,65,3,114,229,234,194,1,241,9,219,209,222,87,182,192,105,0,39,207,123,189,119,157,210,138,129,11,0,86,85,168,210,234,219,145,218,122,82,63,56,23,64,66,38,228,36,245,46,84,247,91,214,243,252,101,89,44,38,159,115,236,184,192,138,178,96,14,73,44,1,118,112,47,54,161,120,226,0,86,198,181,99,225,79,1,30,18,169,17,16,147,80,110,151,201,86,71,0,74,81,200,106,117,152,219,129,37,41,62,181,48,4,210,155,171,94,162,213,91,159,94,45,91,123,52,84,212,116,210,58,234,73,123,167,8,148,6,211,80,240,85,118,121,134,196,1,63,33,247,115,65,222,10,225,17,4,81,0,162,70,20,125,170,207,226,1,74,79,22,107,220,226,152,97,203,59,141,213,74,156,1,82,83,247,95,125,203,186,121,186,122,194,116,243,235,95,161,86,112,172,45,205,176,82,202,22,205,112,11,192,177,115,167,129,59,76,10,49,51,192,99,50,14,180,132,79,90,9,185,73,151,118,237,54,84,0,94,79,4,156,241,212,199,5,102,183,92,61,149,78,127,227,184,107,223,24,81,156,138,47,123,168,119,80,15,50,238,190,217,237,18,6,110,208,49,164,127,102,7,54,232,226,184,132,142,54,18,153,144,232,93,254,165,168,114,148,134,179,152,226,122,232,255,116,0,86,85,192,180,186,76,251,2,107,153,83,3,67,36,80,38,167,59,59,169,185,142,99,205,179,37,45,235,57,242,220,208,31,150,48,190,133,233,152,123,44,14,212,182,1,225,86,74,209,71,209,49,198,136,89,52,242,193,235,145,145,67,38,120,247,201,125,65,76,3,74,83,136,131,237,171,205,200,182,60,183,45,18,36,66,77,158,191,51,147,150,172,154,103,185,165,118,242,167,252,68,181,114,177,130,178,228,176,95,124,84,52,216,220,96,46,73,23,9,31,148,53,104,58,197,169,104,62,94,240,111,75,83,140,10,222,81,224,180,201,46,122,252,50,27,0,90,87,12,192,118,89,23,76,68,225,92,26,14,64,115,213,95,31,21,177,166,70,211,213,179,44,39,221,180,16,171,241,82,192,201,68,108,105,206,111,6,102,159,64,123,155,13,40,128,67,49,177,81,68,15,13,128,177,248,162,25,32,210,49,244,68,43,9,0,106,89,14,217,108,211,232,48,235,231,115,13,67,2,114,229,249,53,21,178,180,28,217,51,205,145,222,83,53,148,24,194,37,128,253,86,10,71,175,159,188,185,30,161,30,70,133,215,193,137,36,213,255,161,209,117,108,81,90,115,71,184,190,205,255,142,128,225,195,51,9,33,225,236,147,0,90,81,2,192,16,56,96,105,235,92,14,134,132,139,169,73,215,188,107,212,191,35,75,17,123,157,203,77,161,148,76,25,178,114,71,209,46,45,141,175,20,176,85,64,189,15,224,129,35,41,61,50,11,38,30,56,78,211,241,179,239,83,154,141,233,139,132,66,0,102,81,142,104,97,123,25,23,235,102,147,115,194,97,32,85,110,213,164,72,91,205,241,165,246,21,158,24,3,53,66,211,80,72,71,118,16,124,147,5,143,50,105,71,214,68,28,160,252,205,79,101,154,233,163,91,19,110,10,147,183,45,187,211,67,42,205,212,74,131,6,74,87,4,129,237,245,156,97,160,171,191,78,68,2,46,185,166,223,114,76,236,93,61,107,123,53,211,28,15,33,118,151,41,115,160,182,4,49,48,39,35,90,193,72,9,64,57,32,123,1,194,116,235,14,243,137,140,35,33,196,112,115,137,10,74,83,86,46,231,87,122,115,176,5,79,103,103,83,0,0,0,164,4,0,0,0,0,0,81,117,155,31,11,0,0,0,239,227,221,90,60,71,69,68,66,72,69,71,68,72,69,68,70,70,69,69,72,72,69,76,71,69,67,74,65,74,68,68,73,71,71,70,71,72,68,65,68,69,67,67,70,69,71,66,68,68,63,63,60,71,70,69,69,74,66,67,68,71,73,70,65,74,81,12,81,161,185,222,23,235,38,242,170,77,24,32,104,85,35,111,166,206,48,205,246,59,243,110,223,186,136,217,212,229,175,206,244,192,240,34,213,210,140,125,155,192,159,187,40,80,64,0,242,13,65,115,40,133,77,136,253,51,251,207,254,122,43,47,70,188,212,1,74,85,152,129,229,24,23,88,154,119,11,177,120,228,108,26,230,75,30,68,215,115,212,231,163,143,203,103,66,99,46,192,2,207,96,250,60,124,54,46,85,99,41,206,43,134,123,128,34,128,225,10,2,242,17,200,57,186,203,56,129,47,199,247,141,24,122,161,0,98,81,6,73,150,203,184,216,92,218,124,10,56,224,168,242,60,218,176,196,94,213,237,95,119,76,220,28,34,15,170,199,1,198,152,173,92,15,108,155,64,231,20,24,4,197,4,176,250,81,18,1,202,114,163,87,37,212,201,155,160,134,240,57,75,211,18,19,78,73,8,131,237,250,28,48,154,235,212,192,192,161,85,29,205,26,91,30,237,214,220,82,229,235,45,37,170,22,118,51,173,64,125,109,184,217,113,211,212,104,238,131,137,230,32,159,94,204,235,155,173,1,111,2,136,102,102,127,31,242,123,224,81,0,70,73,12,128,187,180,11,38,157,57,75,100,64,134,148,170,166,148,95,117,203,167,153,166,187,167,236,172,167,30,228,164,178,26,179,205,72,20,40,121,249,167,64,106,54,92,244,128,73,175,136,210,161,208,199,45,181,124,77,112,16,49,237,14,72,203,226,204,51,4,32,0,78,75,136,128,230,178,39,88,238,222,151,130,131,128,78,213,182,93,147,67,181,209,92,233,136,99,126,79,49,79,219,77,145,164,87,152,134,34,85,196,12,21,9,107,14,189,52,48,49,166,131,107,151,245,248,158,48,185,142,146,154,83,204,238,60,44,169,104,0,78,87,138,129,244,178,14,88,218,59,117,131,0,45,4,149,231,49,109,178,166,58,218,127,119,223,35,122,27,111,10,150,173,67,111,153,12,150,206,86,132,180,184,69,1,237,78,57,58,0,54,179,33,208,0,9,125,250,219,125,114,56,242,124,67,135,240,193,67,8,0,62,73,152,130,59,183,59,140,186,226,180,213,0,134,148,170,254,211,111,234,170,218,99,111,127,107,165,158,154,77,179,86,138,251,47,127,35,153,130,99,207,108,96,226,174,219,131,75,160,54,90,221,214,0,247,14,19,102,167,120,52,204,48,45,209,73,40,0,82,73,140,104,44,47,229,5,163,201,156,34,128,187,216,51,229,234,153,56,246,102,61,179,251,214,127,179,116,185,26,78,83,28,255,91,248,83,8,49,44,61,96,91,147,166,86,142,143,197,223,0,28,176,153,102,217,179,117,7,44,6,152,169,117,48,131,15,57,35,195,3,94,75,202,56,105,94,203,43,1,63,168,115,11,192,146,165,182,110,63,89,255,173,107,116,77,218,22,223,212,160,246,54,77,176,71,23,76,188,102,118,220,146,209,134,55,145,128,219,7,0,215,140,31,34,27,209,117,20,8,10,165,155,77,116,197,156,93,6,0,98,75,14,89,12,95,235,74,153,74,234,84,3,208,64,170,154,44,19,103,235,59,107,246,236,182,127,112,103,218,18,211,78,25,22,225,81,170,165,240,219,106,129,105,219,116,80,254,24,197,79,167,164,109,61,4,58,192,97,234,78,158,72,209,191,79,99,0,66,75,24,64,49,233,43,108,50,231,128,89,156,56,109,72,189,173,39,143,183,191,210,253,59,158,199,209,188,123,57,160,49,174,148,56,73,151,164,108,45,150,176,52,48,14,88,234,65,2,86,156,223,213,175,36,90,0,2,154,99,186,164,247,0,109,254,100,4,0,62,71,148,128,225,162,190,176,202,104,181,2,71,198,134,33,111,189,165,180,180,231,28,219,237,31,99,121,218,17,159,28,66,39,156,82,107,71,12,94,132,14,52,109,33,221,97,17,0,94,253,136,212,191,230,193,161,208,241,148,56,201,249,48,231,91,100,155,236,29,58,73,20,129,226,240,3,145,92,245,86,181,250,190])
.concat([119,247,71,86,159,14,142,47,15,67,87,221,75,173,18,81,161,244,5,133,110,164,245,242,126,35,178,239,129,63,90,67,5,179,53,120,173,47,140,182,225,226,147,147,0,218,9,204,62,155,118,73,153,40,0,78,85,204,129,116,216,23,2,54,231,2,140,145,208,42,207,117,239,120,82,254,58,99,55,75,19,167,128,90,81,196,156,34,142,63,99,213,38,34,55,130,119,238,140,221,224,14,15,128,78,180,11,7,13,52,154,155,101,212,14,138,229,28,238,85,204,17,131,0,74,75,140,0,115,236,3,236,222,185,2,204,91,100,166,105,70,211,206,218,103,198,121,138,234,188,105,181,27,145,165,176,130,93,234,204,131,44,154,101,232,155,44,130,97,230,226,65,10,18,88,148,11,148,242,176,67,28,29,19,230,62,47,36,197,83,179,233,198,25,253,0,90,77,37,6,238,123,92,145,204,156,90,56,44,145,105,80,101,154,116,76,74,253,79,19,89,87,97,37,180,212,55,209,237,219,50,216,108,164,238,55,131,87,132,195,45,189,209,48,6,53,78,111,182,149,154,173,239,58,208,189,57,21,18,195,172,165,176,239,250,70,178,3,74,77,134,2,11,63,87,44,51,113,46,7,144,89,65,170,230,153,207,183,220,18,75,182,199,246,236,23,114,132,58,196,12,118,183,38,42,44,26,3,85,208,227,232,24,225,0,44,97,91,204,132,247,219,93,7,221,67,162,241,186,125,253,18,92,66,81,135,0,78,93,70,51,149,185,114,160,75,89,158,150,192,83,0,79,205,210,117,49,115,197,92,150,191,212,76,67,111,223,140,201,236,220,111,46,205,92,130,59,7,180,33,195,247,175,176,159,39,104,156,217,240,184,242,230,212,128,110,93,254,167,68,16,129,57,106,8,116,79,106,172,245,75,35,0,94,99,46,26,117,229,228,66,202,230,92,4,64,26,83,211,172,213,88,127,235,211,111,251,53,79,191,51,155,243,130,238,101,43,132,239,22,18,233,164,222,47,164,192,235,151,78,128,6,200,71,131,54,197,58,81,127,49,185,162,28,125,43,26,26,107,165,140,232,89,5,98,99,137,54,200,220,29,177,76,206,69,128,22,66,10,205,166,245,44,161,182,219,209,166,39,181,247,61,162,82,137,58,138,37,169,215,237,115,172,242,189,6,236,12,39,163,204,156,79,113,52,113,71,91,220,38,75,8,31,201,217,44,109,122,67,252,58,29,0,54,79,146,131,149,127,38,36,51,103,129,37,67,140,156,168,253,191,137,252,237,214,89,98,166,213,150,206,0,19,2,216,19,33,69,223,159,3,235,128,255,74,157,231,66,112,51,249,132,192,15,21,10,102,42,15,240,112,101,70,208,149,34,120,217,36,0,54,81,148,130,221,120,87,196,121,223,138,73,80,169,80,213,219,214,255,106,107,226,107,99,237,222,103,155,94,100,134,29,90,61,205,189,43,11,198,42,115,110,78,162,25,89,214,208,94,30,64,91,221,229,198,68,235,214,250,153,159,205,41,28,19,129,196,166,102,216,181,104,38,0,74,87,138,131,204,255,102,152,57,23,160,1,97,164,170,154,16,247,73,13,169,127,215,100,252,136,112,21,150,144,201,131,9,228,234,28,6,13,5,218,224,116,0,195,189,222,92,245,21,64,81,199,244,8,9,158,222,43,157,92,18,90,241,141,3,110,85,169,178,217,181,251,130,136,35,122,170,0,99,144,42,119,201,150,53,206,182,249,125,249,81,211,215,57,13,11,115,178,159,107,223,145,153,214,172,203,18,48,152,245,61,208,37,116,2,224,6,64,154,173,23,154,66,55,237,191,93,87,215,146,163,254,213,200,234,167,94,10,0,102,83,1,113,210,213,59,98,103,231,220,4,144,169,117,90,213,202,151,144,55,203,182,125,205,114,230,179,33,26,58,20,58,130,14,243,45,25,66,61,187,178,143,153,246,198,13,214,85,116,60,14,224,19,224,9,103,30,233,165,214,233,216,69,11,132,222,0,102,77,134,128,226,197,15,204,233,60,239,28,18,68,90,34,57,85,141,103,105,204,247,237,217,163,91,74,0,227,173,205,35,140,145,37,24,165,194,233,41,13,233,119,117,139,112,237,232,98,23,224,69,1,105,42,40,147,214,9,54,66,225,124,69,167,37,4,114,93,73,4,205,204,140,120,120,31,3,164,198,72,158,60,189,173,249,82,83,245,116,142,110,73,30,209,197,196,154,178,79,221,97,68,164,63,201,223,230,49,189,235,19,102,8,22,193,192,223,96,4,128,11,96,18,106,48,223,152,217,91,21,14,115,15,1,250,160,20,18,0,106,95,44,131,37,210,97,210,9,231,12,24,128,84,174,249,186,116,103,243,85,28,203,61,155,105,228,201,177,197,180,54,23,148,67,159,171,160,135,109,17,175,57,250,41,40,144,58,10,125,106,116,29,181,227,83,51,10,54,70,217,151,234,88,140,6,230,187,105,210,0,130,95,137,118,147,160,195,186,233,121,7,188,145,73,42,79,155,51,79,121,165,75,119,69,100,219,200,34,101,234,120,233,130,217,12,37,24,89,139,152,4,209,153,5,197,242,101,161,155,2,53,52,31,59,106,147,73,243,120,120,55,219,205,76,214,162,65,152,0,116,15,118,89,137,180,216,94,219,140,100,238,84,13,24,79,147,170,108,249,171,122,142,254,209,158,183,123,254,52,40,214,150,236,191,111,189,18,164,18,244,141,41,22,23,78,239,216,127,236,148,186,241,224,97,155,201,36,252,81,155,27,217,102,136,119,30,89,220,129,217,0,118,91,101,180,184,125,203,76,72,118,118,181,217,0,136,64,42,151,124,247,74,233,108,218,212,213,245,101,221,57,56,245,138,194,252,203,169,142,91,24,10,106,14,2,198,46,175,130,164,47,20,160,233,224,95,104,133,128,252,49,152,55,117,141,241,37,68,29,100,72,0,122,89,165,117,214,237,85,174,152,113,116,167,37,3,124,100,145,235,58,251,250,232,76,214,182,237,242,206,110,75,219,211,122,169,78,253,226,137,131,95,240,35,0,234,10,121,182,183,9,241,9,98,8,137,78,98,211,209,177,13,54,120,183,186,146,169,232,64,8,56,7,7,106,83,137,148,220,190,184,80,50,185,106,7,1,114,228,80,213,89,109,255,175,84,243,44,221,116,89,132,105,167,94,24,98,79,202,243,23,184,230,0,82,99,241,130,246,77,246,4,96,143,105,21,166,104,73,211,75,255,144,20,160,187,203,230,154,198,4,0,110,89,41,88,44,151,120,32,47,181,77,68,245,206,191,142,249,41,111,11,183,167,194,247,253,126,119,177,37,213,71,143,48,31,199,110,118,59,215,52,53,32,47,2,106,61,110,210,232,184,9,43,182,7,206,1,73,208,41,157,60,232,90,167,3,110,89,9,179,184,125,133,3,25,170,53,0,45,196,84,78,247,207,219,90,218,46,37,237,181,197,190,167,51,201,46,176,184,21,32,19,141,194,112,0,182,1,2,121,54,154,96,86,180,66,159,72,90,211,6,157,83,38,167,219,34,49,118,86,110,85,173,0,114,79,9,216,60,94,251,129,166,236,49,162,153,149,255,221,166,143,220,188,142,159,46,159,253,56,200,242,184,172,59,7,189,185,150,152,201,241,59,5,92,88,0,232,2,0,214,96,122,194,244,205,227,42,20,66,207,183,57,167,107,2,145,198,14,90,178,16,0,78,77,12,192,233,43,30,200,203,59,213,67,192,147,137,79,84,111,115,185,238,105,222,212,221,212,120,197,153,173,243,189,121,115,78,27,109,122,141,128,51,8,104,128,94,198,58,19,83,208,132,197,155,240,153,70,58,244,57,105,232,180,172,247,153,128,6,86,81,129,50,134,215,122,65,7,230,220,6,6,171,85,181,24,33,154,221,191,225,169,120,102,121,250,117,203,167,101,65,189,124,178,175,140,39,232,62,55,43,190,25,128,89,60,60,218,73,225,201,206,235,148,8,102,90,27,115,246,34,117,80,205,37,0,86,75,130,51,132,86,145,212,65,59,228,212,2,76,129,101,81,53,219,39,230,105,178,236,189,221,187,229,183,245,181,52,148,9,135,191,50,101,159,79,225,138,15,56,96,17,92,217,123,124,0,70,153,0,215,152,22,24,116,129,182,76,111,58,130,246,146,44,252,4,86,79,20,129,166,134,128,201,27,188,83,113,128,244,202,98,168,58,207,155,210,244,249,183,213,247,111,102,253,44,71,15,155,83,95,245,181,38,126,179,24,116,70,216,129,113,161,91,175,41,139,177,150,112,111,210,69,175,124,131,118,76,40,5,141,88,235,128,6,98,87,134,129,116,13,51,150,35,116,46,17,112,64,171,133,221,86,107,219,44,217,228,233,158,142,225,189,28,118,74,216,163,208,155,116,166,183,130,175,2,7,0,143,109,186,136,82,119,161,120,4,189,70,91,224,249,132,80,239,148,203,43,191,162,34,173,94,105,63,1,98,79,6,113,220,149,138,46,153,222,215,128,207,108,49,84,77,75,106,229,221,255,246,91,247,245,109,251,199,249,48,137,77,67,16,238,55,129,199,168,19,192,3,48,1,30,236,113,203,234,153,15,103,54,22,58,55,207,148,52,3,252,193,114,151,0,78,71,128,8,197,133,9,157,184,99,206,3,184,139,92,76,229,102,14,190,181,57,111,113,124,251,239,41,155,24,132,225,85,168,93,87,85,30,128,31,135,8,26,0,10,72,4,108,27,89,180,49,146,199,8,179,29,100,71,62,12,246,48,186,23,175,0,0,94,83,74,24,115,241,37,7,186,198,244,227,0,42,13,129,16,110,102,199,154,206,174,79,215,212,255,232,133,17,43,150,220,65,71,111,28,158,152,252,179,20,48,73,220,100,34,65,193,41,26,41,30,198,132,37,190,108,162,117,99,246,244,137,129,122,121,56,74,75,8,131,51,111,51,150,51,188,47,12,3,135,136,168,254,159,45,29,255,48,71,83,205,118,166,161,60,205,86,8,16,101,24,30,170,27,0,96,243,29,8,64,217,217,26,113,97,34,163,119,237,2,215,53,208,75,15,173,40,154,7,106,85,1,108,118,45,103,152,117,202,185,0,8,110,17,129,49,185,107,110,241,53,238,249,126,230,75,126,127,51,199,73,130,219,224,78,20,46,253,11,38,0,29,13,174,144,32,93,17,234,82,43,41,203,41,238,9,187,214,69,79,28,0,106,83,141,218,71,171,229,4,235,193,156,203,66,32,169,132,136,48,101,215,151,76,223,70,138,88,243,35,61,38,17,86,208,102,161,113,173,237,48,147,174,8,0,128,206,131,219,14,71,2,27,12,93,16,186,163,56,19,13,15,114,81,38,88,199,83,89,95,176,100,139,201,228,236,224,219,170,249,58,124,58,30,142,95,92,239,12,215,253,91,94,81,147,177,132,19,39,26,48,210,189,81,0,154,162,179,18,139,144,203,135,102,88,235,64,95,176,100,75,93,201,227,115,83,211,249,233,202,28,209,56,114,79,74,56,47,183,175,245,66,100,100,242,79,224,16,40,81,99,43,107,251,238,183,39,255,246,253,249,62,67,164,174,131,140,93,50,249,197,169,175,183,50,224,195,36,40,83,69,147,19,180,236,5,46,162,204,107,207,39,165,225,71,63,79,182,77,158,34,21,0,106,81,36,104,199,19,172,87,152,176,165,76,78,119,233,97,113,136,243,167,59,213,175,239,220,28,231,205,77,133,197,142,167,122,93,82,16,112,137,83,87,50,0,202,122,167,19,174,76,50,169,216,118,160,222,6,18,83,136,230,56,185,170,106,43,161,24,198,22,118,77,137,176,231,29,172,47,88,27,84,79,85,127,127,202,154,219,124,221,241,98,108,252,71,148,10,42,189,104,182,106,54,111,0,143,154,17,9,55,245,141,22,26,3,20,155,204,174,105,128,52,158,162,76,197,20,14,169,150,127,175,176,46,68,43,197,36,1,106,81,41,115,31,205,81,94,48,15,231,31,35,208,242,84,121,70,255,84,60,107,221,219,227,188,53,249,241,119,97,251,202,178,245,0,157,60,55,223,107,244,153,1,142,43,169,133,203,65,186,166,0,76,203,133,199,68,226,149,100,73,113,172,200,255,71,36,184,224,129,235,232,0,106,81,66,185,143,199,203,186,2,131,45,101,114,95,253,99,119,252,206,52,63,202,253,101,190,29,143,39,157,8,197,145,183,88,1,76,193,247,75,29,233,128,197,168,65,15,72,124,215,76,205,26,60,148,97,133,137,163,169,228,55,211,124,127,2,0,102,87,138,24,125,59,116,7,130,167,7,0,17,196,100,202,238,211,70,124,179,202,219,245,251,71,219,35,14,190,93,137,238,126,52,58,210,6,226,35,130,46,85,36,96,160,108,211,233,26,156,109,90,151,131,89,154,143,58,11,209,154,44,92,179,253,79,78,79,8,192,233,165,70,48,185,115,177,5,96,182,145,166,108,57,163,57,142,86,121,142,62,125,126,227,246,107,24,189,47,189,43,10,126,76,135,231,1,240,198,234,111,11,38,108,43,20,40,65,34,86,37,138,3,139,67,167,153,29,147,224,21,145,74,21,102,81,134,217,44,83,127,69,39,99,62,101,5,24,41,155,84,57,235,191,169,182,93,30,90,221,113,187,175,94,37,103,157,46,143,226,100,59,164,70,116,108,38,192,174,47,195,123,21,19,52,40,110,238,169,236,192,241,75,240,202,99,158,206,194,25,213,150,24,72,5,102,83,65,88,243,233,59,190,96,240,140,206,153,56,72,72,85,239,91,137,99,105,167,89,186,125,205,142,169,14,219,178,228,220,7,163,229,50,204,206,160,223,238,6,74,93,27,49,225,144,232,144,220,208,69,95,236,180,210,4,249,80,40,51,204,98,100,74,197,64,123,49,1,90,75,76,24,243,112,13,223,88,30,167,71,130,204,22,147,42,183,38,163,109,109,221,57,225,217,30,89,186,230,99,81,58,23,242,82,0,131,173,53,48,111,121,59,192,13,210,1,13,186,131,216,226,143,41,131,167,45,157,172,137,106,78,211,155,180,36,240,19,0,66,83,132,130,230,165,31,232,4,147,115,36,6,63,139,24,83,237,83,180,247,29,186,235,86,245,127,97,120,95,78,132,25,9,243,176,10,12,91,184,39,0,106,128,2,121,146,111,126,230,26,73,67,244,235,64,83,54,84,40,118,117,66,13,0,79,103,103,83,0,0,0,26,5,0,0,0,0,0,81,117,155,31,12,0,0,0,248,152,109,89,59,74,73,72,70,72,70,71,71,71,70,69,74,69,72,72,73,78,71,70,71,68,70,65,73,69,71,68,71,68,69,70,73,71,71,72,67,66,70,64,68,70,67,67,71,79,72,70,72,76,68,70,73,77,68,71,74,68,64,67,82,81,2,12,182,121,62,208,209,205,57,0,194,52,19,147,78,238,249,63,155,99,237,230,185,31,105,206,95,115,131,198,162,85,52,233,56,104,210,118,168,94,192,3,128,197,9,78,189,18,35,183,26,25,115,46,46,162,131,231,111,218,164,6,43,146,171,35,118,253,222,24,162,1,62,71,88,242,203,114,241,138,201,203,157,51,0,33,216,210,212,212,212,109,153,104,92,217,151,124,111,130,61,128,101,65,128,14,102,231,195,202,241,181,104,96,79,221,70,32,74,130,241,216,232,246,200,42,112,244,97,182,246,137,199,59,224,41,12,74,179,131,40,171,238,10,0,86,83,192,140,249,227,74,7,154,230,84,4,8,89,203,136,73,228,182,249,212,196,93,180,235,251,123,186,255,171,77,22,237,171,124,93,19,195,168,194,92,220,19,83,96,99,22,226,206,126,34,151,175,160,133,254,40,228,76,186,108,234,156,206,16,230,16,33,95,187,231,1,90,77,10,172,99,121,201,142,240,34,170,77,72,18,84,82,213,251,178,75,89,179,254,154,236,182,252,254,241,138,162,247,171,181,159,204,104,12,155,157,248,204,13,1,44,242,104,232,67,0,16,115,181,17,186,46,120,157,169,196,92,29,130,224,49,219,43,43,104,0,78,81,72,217,151,211,139,189,80,177,57,39,64,104,5,49,137,230,211,126,91,251,116,169,246,235,54,125,255,203,227,234,177,14,202,98,68,222,42,25,2,134,63,141,130,89,134,117,138,217,109,0,92,154,0,113,144,138,94,154,129,22,189,91,57,150,153,65,243,77,58,0,62,73,210,40,199,29,202,23,152,119,177,165,170,199,255,198,78,175,111,230,61,174,28,190,199,37,94,199,94,246,83,229,45,39,22,67,62,71,70,45,191,100,21,64,107,77,209,248,167,211,1,220,158,185,169,14,93,218,113,128,70,209,61,82,134,229,21,103,54,0,86,79,76,184,143,237,165,188,0,155,47,4,48,14,201,131,230,145,215,50,87,181,147,206,219,253,52,143,161,119,50,76,234,156,123,155,38,28,240,230,235,243,117,176,137,77,34,167,15,46,3,7,224,77,6,224,240,93,113,210,236,194,15,11,50,123,116,58,163,40,0,86,75,72,88,44,215,53,195,114,51,95,0,200,213,164,193,85,255,157,53,42,246,127,246,108,253,100,250,217,109,177,208,217,77,19,113,13,82,100,141,90,32,197,149,25,250,68,216,240,218,24,19,0,198,122,89,202,131,226,53,164,9,22,65,87,82,243,90,83,18,0,106,85,137,112,79,205,75,59,72,150,225,115,33,0,132,147,201,149,45,185,106,55,186,60,174,238,204,51,155,236,201,19,72,18,117,216,103,112,33,59,11,214,2,58,14,59,56,37,231,27,80,64,202,21,5,162,137,205,49,159,70,226,33,224,77,147,141,46,69,108,146,102,85,66,89,243,242,98,19,66,209,47,4,32,215,66,106,69,255,237,164,170,58,206,247,189,93,115,157,213,97,158,72,78,118,73,63,50,90,124,170,89,116,96,135,84,26,98,192,97,179,198,82,160,148,252,96,227,179,222,213,225,209,179,20,4,211,253,53,224,1,102,79,56,81,166,211,172,102,68,50,231,2,16,114,140,214,212,254,24,169,153,253,242,137,119,234,228,234,82,143,0,75,253,197,42,234,212,142,77,96,233,125,145,41,117,11,87,68,234,233,32,45,62,53,95,172,172,160,153,32,32,194,212,54,209,48,39,19,9,90,79,210,24,215,211,212,14,68,45,247,148,201,243,240,190,29,178,47,151,199,95,25,42,119,175,103,37,187,189,170,130,96,237,89,223,69,56,31,131,213,9,101,118,244,61,21,66,92,161,243,219,230,140,9,207,83,117,90,247,11,26,195,152,152,49,225,92,202,33,43,54,206,4,106,75,40,88,189,9,118,128,197,156,23,128,4,90,83,243,214,204,18,219,253,252,250,60,111,138,121,105,43,199,172,25,176,198,21,203,80,135,238,151,9,70,105,166,185,4,97,137,0,192,45,53,229,113,198,200,129,8,104,74,167,7,241,232,204,52,141,240,0,90,77,220,89,211,22,213,76,202,203,84,91,0,160,129,161,169,233,169,62,29,239,242,75,115,143,235,158,77,11,99,193,165,218,21,207,43,102,131,27,135,73,60,139,15,13,116,168,131,148,64,88,116,197,243,178,115,226,243,96,50,241,194,212,136,145,102,79,194,245,137,7,90,83,130,248,92,204,196,140,14,215,112,190,85,238,55,143,12,243,244,197,205,22,75,251,122,108,236,180,53,176,101,118,207,90,186,179,21,3,187,162,179,18,219,192,4,69,111,146,14,221,210,26,208,96,177,226,112,141,244,134,11,236,75,21,132,175,41,150,155,232,135,6,90,87,212,121,95,78,19,19,169,41,95,39,9,204,24,42,207,63,41,91,214,57,214,249,255,159,101,134,122,164,51,27,38,88,180,232,71,106,106,20,73,1,72,72,93,129,38,111,108,9,9,18,245,114,234,5,201,93,51,146,142,185,231,188,193,84,77,220,6,149,17,58,0,70,83,218,129,211,183,207,176,230,92,44,38,144,12,181,105,201,251,182,181,207,177,144,173,235,47,53,159,43,161,193,13,11,20,177,51,80,212,121,136,207,11,134,70,227,0,2,115,155,90,25,73,70,31,24,213,149,208,167,59,56,31,207,152,123,217,43,94,59,221,237,86,25,145,146,235,56,0,86,87,96,108,78,47,54,33,207,248,75,3,36,35,82,53,191,221,108,43,171,45,82,126,212,243,237,177,140,218,172,59,186,195,202,91,1,130,228,219,41,32,184,209,10,83,166,47,120,116,219,9,224,158,44,173,43,116,76,125,202,119,254,75,196,172,74,49,152,19,26,102,79,76,248,241,184,16,177,247,242,62,107,156,67,92,171,122,253,214,84,71,222,29,51,123,150,247,95,31,212,133,238,110,221,118,106,27,37,146,232,139,77,64,195,120,208,77,96,183,21,239,40,16,197,126,8,13,212,186,110,163,231,204,49,209,178,25,76,158,6,86,71,84,184,251,237,171,84,88,244,192,173,54,142,113,18,210,230,58,103,190,166,143,110,141,219,91,199,237,213,85,108,186,73,14,101,204,217,32,111,77,41,5,45,251,162,228,161,3,229,1,208,93,59,243,236,33,66,78,0,166,94,142,194,79,238,58,152,139,144,0,86,85,136,185,231,237,229,140,72,92,121,182,101,171,207,191,190,216,59,140,13,31,241,167,66,230,89,97,76,177,168,185,112,137,174,147,101,71,193,196,137,205,116,20,221,244,142,14,1,148,151,120,0,229,168,155,193,167,115,147,142,51,161,48,50,166,16,0,82,77,136,88,108,147,117,236,221,244,182,84,53,239,187,29,246,51,21,171,239,14,103,175,122,121,147,24,145,198,197,133,90,74,104,143,2,94,223,20,157,68,106,27,205,64,3,198,54,55,26,224,54,122,221,117,31,202,221,212,0,237,154,233,141,205,119,44,78,0,58,75,90,128,225,218,58,216,189,83,247,0,4,120,48,168,89,90,243,212,88,173,125,85,156,199,152,107,227,103,124,81,4,70,214,233,26,6,17,1,69,227,160,39,48,93,0,208,207,165,149,185,64,145,164,190,192,4,117,212,9,140,153,82,3,86,77,96,180,249,54,75,68,176,155,57,23,1,107,64,20,229,186,244,77,106,74,106,238,77,219,69,245,3,15,77,30,5,189,123,223,229,155,133,76,116,239,37,7,96,75,213,66,6,232,13,18,151,128,64,110,176,79,118,103,82,33,136,200,174,107,13,104,148,50,89,208,0,78,73,156,104,44,199,174,96,120,159,7,36,38,106,213,204,239,173,89,189,215,251,180,233,125,243,169,116,50,165,53,117,132,206,246,80,207,36,25,232,144,52,8,23,232,19,46,246,6,19,46,38,152,137,78,148,142,22,231,40,72,5,25,233,51,135,49,160,3,94,73,4,57,251,16,139,6,45,234,83,66,152,28,38,85,189,218,166,201,243,239,191,190,207,146,154,175,251,113,154,14,245,117,116,217,11,167,156,115,236,47,18,52,192,202,40,1,208,100,115,83,105,154,110,244,54,135,166,139,78,118,70,178,159,141,52,94,39,225,0,82,77,146,88,241,49,153,6,7,121,231,26,134,73,104,85,179,63,231,211,56,190,174,73,219,167,101,117,32,42,203,57,218,151,162,34,199,40,251,254,154,163,1,214,107,82,226,249,126,38,161,115,83,125,243,77,104,101,202,109,46,5,64,156,249,211,12,0,62,77,158,89,211,105,210,26,244,173,61,23,16,32,195,73,78,184,206,210,188,61,117,237,91,106,78,166,10,118,161,74,106,213,90,65,11,165,20,186,144,218,177,223,40,174,20,237,8,12,177,119,1,73,196,81,31,143,17,209,245,249,169,211,64,250,248,222,223,79,38,90,75,160,220,12,71,168,48,232,212,231,6,32,37,164,170,103,74,51,239,164,202,206,95,243,118,245,182,5,190,43,79,35,229,217,73,149,175,97,248,76,37,24,58,128,126,207,1,103,13,206,35,178,109,35,84,24,108,139,147,105,38,13,115,74,175,3,0,82,75,82,121,216,250,84,65,249,157,43,64,155,18,82,213,237,153,46,29,75,115,203,174,44,117,89,144,77,139,35,65,133,176,195,174,128,26,203,210,157,6,234,54,1,8,56,217,207,182,209,137,51,35,11,29,223,117,83,129,109,186,94,8,41,232,90,8,5,102,89,204,249,48,188,212,25,163,150,60,23,0,70,44,180,42,157,70,68,191,205,242,137,246,159,150,128,178,166,208,224,89,213,103,198,61,218,159,2,17,131,40,1,254,32,240,108,86,91,251,198,226,240,141,217,92,65,232,33,36,87,237,74,204,212,216,46,75,9,90,77,220,121,166,109,238,51,38,46,153,111,224,28,137,150,171,199,217,100,174,91,58,179,46,223,246,244,140,132,121,144,177,182,183,7,203,205,226,173,232,113,244,30,254,45,178,220,128,76,51,20,88,107,206,112,155,234,208,123,9,7,5,48,8,243,253,145,162,166,41,7,0,86,83,218,121,46,167,169,207,64,47,56,5,96,6,90,34,119,89,191,236,234,170,249,31,79,215,110,179,174,183,71,102,185,117,23,45,126,32,188,11,76,182,176,30,199,155,128,197,29,30,219,221,203,44,112,232,197,169,41,204,80,240,193,49,56,214,45,163,45,6,0,94,73,146,121,207,67,152,39,164,223,84,231,22,24,64,106,154,214,125,141,121,223,125,63,159,45,45,166,254,64,177,163,220,149,251,35,135,39,1,230,98,204,77,122,9,192,202,134,0,147,23,64,222,142,155,33,67,129,119,41,153,199,176,98,130,203,132,180,167,190,0,94,75,218,121,216,142,126,69,167,250,114,124,36,32,84,204,82,181,169,245,224,60,250,252,253,191,249,179,125,53,79,20,135,152,196,180,33,68,49,19,203,19,1,101,93,178,206,198,223,1,254,27,4,32,112,174,180,161,7,208,62,49,213,103,32,125,20,154,77,154,130,0,74,73,156,217,21,61,92,96,252,166,170,62,167,234,87,35,91,239,71,113,95,79,251,46,22,230,143,162,82,241,208,62,241,147,73,75,0,254,183,112,22,226,65,17,181,228,1,9,190,199,192,164,9,15,19,55,27,166,94,38,219,20,139,175,51,21,0,62,73,89,105,20,7,51,2,111,122,175,22,128,132,37,83,155,223,154,207,153,167,53,87,217,186,198,233,125,154,138,65,147,9,217,185,53,184,31,176,185,130,102,81,181,65,162,188,238,10,156,216,158,10,160,64,21,29,211,18,116,133,110,144,53,0,74,89,94,129,226,80,19,66,124,215,1,109,10,88,42,207,122,222,148,88,187,173,249,175,91,99,63,110,98,40,126,98,97,200,40,70,11,184,23,9,134,4,86,192,208,6,128,223,138,62,0,17,64,41,13,15,5,52,28,87,15,70,178,226,76,1,214,41,56,0,94,81,72,48,138,111,153,144,28,212,185,68,192,169,135,165,202,186,131,180,76,179,28,178,55,85,113,186,148,40,74,213,193,93,81,14,96,159,8,164,73,151,189,131,0,27,139,58,128,2,95,6,91,135,194,161,75,169,104,88,33,139,70,3,82,83,88,129,226,162,14,172,132,83,137,1,156,195,82,57,123,243,136,145,210,173,91,91,149,182,25,195,181,188,127,103,239,144,181,102,147,215,192,207,1,176,4,172,83,96,87,90,72,120,240,22,13,235,120,142,162,192,235,2,235,160,171,182,247,150,39,1,102,83,196,184,73,215,114,69,22,95,1,113,7,75,213,118,210,22,101,109,157,205,190,102,109,125,97,235,160,183,35,186,37,179,96,107,30,141,201,106,24,153,13,242,146,87,153,218,31,30,104,161,111,110,157,14,19,39,144,189,13,99,138,46,150,255,132,75,77,1,90,83,52,24,44,95,237,2,27,206,15,64,0,115,42,55,238,43,203,178,62,218,44,28,219,50,126,237,59,216,225,190,201,26,4,127,128,159,128,148,75,58,89,14,127,67,3,209,41,96,137,66,113,170,247,41,18,92,206,102,198,213,166,141,169,76,0,74,73,32,140,136,139,188,96,215,53,51,223,169,250,213,199,80,110,31,231,166,10,187,165,56,30,155,62,240,150,220,69,72,222,35,134,89,188,22,128,122,208,142,113,202,2,220,75,2,178,140,225,183,22,209,123,15,188,4,164,6,188,147,147,66,227,0,62,83,84,1,92,212,21,171,175,46,159,219,37,88,56,180,114,51,123,110,179,152,88,87,247,246,173,102,68,149,145,210,28,86,99,139,44,241,179,102,221,188,9,208,39,224,152,0,208,23,74,11,0,19,155,166,16,116,28,91,246,23,43,116,234,129,74,168,61,162,3,86,79,72,121,48,177,191,32,201,57,129,141,49,85,169,60,251,90,163,173,229,251,178,244,107,103,78,147,207,222,162,84,12,149,54,27,174,97,137,159,74,155,145,3,248,150,48,221,6,83,103,51,85,237,161,123,73,151,11,247,106,52,52,211,4,165,234,92,45,59,239,194,108,34,220,57,130,118,0,74,79,146,217,24,165,103,164,249,218,193,56,162,85,243,235,111,234,136,230,191,166,246,248,242,111,86,93,181,33,37,105,119,87,116,146,197,9,69,41,48,158,211,0,140,238,249,68,3,55,198,173,135,41,56,51,131,137,37,90,132,200,103,229,225,185,106,41,218,161,1,0,90,79,24,156,52,161,29,136,152,191,8,24,32,147,201,157,232,24,21,247,73,243,118,139,234,136,179,140,140,152,146,245,123,63,156,229,216,25,106,2,199,46,132,46,176,7,176,130,17,111,51,192,202,170,76,0,210,233,157,67,72,179,70,211,175,186,230,234,27,0,42,85,5,6,205,84,102,228,107,253,231,90,0,9,180,166,121,123,250,60,181,211,28,93,27,213,228,191,199,170,146,178,53,70,88,55,84,191,72,145,168,103,234,163,0,24,12,128,88,178,144,83,1,56,188,145,23,97,78,96,174,80,32,161,89,19,20,241,234,26,10,0,74,79,18,219,108,147,190,160,211,208,243,247,100,114,238,255,117,61,215,49,150,103,71,171,199,135,11,55,125,86,157,230,211,18,204,210,43,209,90,252,16,4,54,37,220,160,175,217,31,73,160,239,211,109,68,113,240,13,138,228,223,22,230,162,191,2,3,185,110,108,171,30,230,22,175,1,62,71,154,200,96,87,117,111,61,89,69,91,170,250,253,171,207,219,227,162,220,242,191,243,167,19,21,235,216,213,217,134,125,149,240,58,104,71,96,85,60,83,47,236,1,72,162,0,16,74,169,88,214,10,155,152,76,128,4,139,163,244,167,255,204,252,2,0,86,79,216,123,83,40,233,72,114,46,196,128,140,67,42,215,46,61,242,97,107,238,87,85,27,223,231,88,193,4,139,186,152,246,57,221,136,225,109,52,110,118,56,240,169,110,79,131,45,19,32,40,90,74,18,205,175,66,14,221,89,131,84,28,89,162,140,28,179,0,86,85,172,54,16,117,43,132,108,157,11,1,180,185,57,173,242,252,229,85,197,68,60,171,43,111,126,170,22,141,136,155,88,55,105,54,203,91,34,242,196,214,137,125,28,236,84,251,1,98,19,60,255,79,168,188,30,57,117,182,197,20,52,22,220,225,119,54,198,52,251,41,0,98,89,194,26,8,157,32,41,121,110,0,231,208,106,102,215,153,24,71,244,238,161,173,27,61,204,214,117,105,2,17,174,237,69,23,222,139,20,253,59,236,81,44,74,216,110,30,85,125,212,238,166,254,237,168,155,150,136,188,229,122,169,65,21,221,159,79,139,235,78,222,173,5,227,66,3,0,74,75,158,219,12,211,152,144,140,238,45,87,127,25,93,48,23,135,226,221,177,82,142,189,152,251,207,231,41,167,152,208,157,228,90,118,103,134,103,139,104,190,64,231,26,80,131,149,178,137,107,129,51,133,85,210,14,193,83,32,58,52,30,129,97,21,16,0,74,75,145,121,166,132,122,133,77,184,122,203,213,87,166,243,85,117,158,126,28,143,15,67,238,77,214,147,132,212,92,170,128,189,248,148,232,177,253,48,81,244,63,186,42,32,66,208,255,236,48,244,203,237,217,160,165,169,153,0,64,83,80,253,162,58,239,52,108,20,0,90,81,214,248,33,40,87,84,183,205,103,0,193,161,83,205,219,113,69,180,249,186,199,113,172,121,119,190,7,115,140,81,171,231,152,88,89,44,251,126,35,44,127,45,100,103,178,171,217,192,209,191,129,199,151,116,181,28,160,65,135,235,48,167,45,82,23,103,180,128,11,114,15,0,82,77,26,60,152,99,31,72,190,11,247,165,234,199,255,21,114,26,55,126,71,220,55,214,67,101,142,164,158,167,110,65,182,238,172,23,193,3,0,173,104,224,149,169,210,38,25,29,112,55,100,89,111,172,240,128,134,80,152,52,228,189,182,44,178,88,1,0,78,75,44,58,167,201,180,47,48,173,196,243,0,60,97,78,210,102,119,235,102,42,143,119,57,159,117,166,26,147,23,11,189,175,100,138,204,0,255,160,65,135,208,59,64,103,142,157,45,1,10,208,200,174,144,246,219,101,188,174,58,242,51,1,82,73,88,187,43,142,123,134,221,88,207,13,12,4,44,77,61,150,227,242,245,77,30,249,61,63,199,189,166,241,210,37,116,62,78,66,76,224,9,48,2,116,128,229,222,144,0,16,107,164,108,146,57,0,154,192,0,161,91,124,166,102,80,105,90,38,0,79,103,103,83,0,0,0,144,5,0,0,0,0,0,81,117,155,31,13,0,0,0,226,164,96,72,59,66,69,67,66,63,68,73,68,72,71,67,71,65,74,66,71,75,68,69,68,70,71,68,69,72,64,62,70,73,73,72,70,72,78,72,70,74,68,70,72,76,70,65,70,68,80,73,67,73,75,73,69,66,76,68,68,67,73,70,86,79,156,122,210,92,238,9,34,99,62,23,65,130,192,156,132,206,60,42,207,234,185,165,101,185,109,255,57,134,157,125,111,42,181,41,93,103,54,86,127,89,32,221,131,210,64,134,197,123,184,75,82,129,192,115,128,242,35,132,67,226,135,93,13,0,94,79,76,198,42,94,206,11,108,70,80,109,17,16,97,176,36,169,103,30,107,219,78,90,219,223,119,174,186,87,227,15,164,163,149,31,55,51,0,251,156,0,20,1,128,85,159,248,138,24,187,40,149,32,86,150,0,40,32,228,60,209,250,231,90,178,72,9,0,70,73,28,91,180,96,189,66,149,41,87,159,227,210,233,111,214,138,243,211,233,75,125,48,93,48,118,189,102,233,84,198,73,86,175,135,108,194,254,133,227,149,65,226,8,241,113,238,0,92,74,235,61,216,117,63,163,120,54,210,53,111,106,205,31,39,0,90,75,192,156,148,112,123,129,93,244,11,0,5,96,78,83,167,57,228,79,164,54,207,102,173,186,41,101,204,212,61,108,74,81,215,4,102,251,61,0,231,18,229,186,39,147,128,152,225,58,7,103,202,29,58,0,152,138,197,98,26,108,156,230,208,0,54,81,18,75,173,130,118,133,133,200,217,113,22,192,156,170,235,253,155,231,126,52,143,148,214,170,108,73,146,203,149,59,52,27,36,59,240,39,64,51,61,208,26,56,160,97,168,10,85,83,2,186,16,230,233,11,2,237,17,179,199,1,0,58,83,148,24,138,160,188,96,151,84,91,4,68,104,4,21,213,108,186,121,213,204,125,109,250,171,175,101,97,86,141,253,71,119,141,239,34,124,120,176,239,87,60,52,185,152,6,160,239,207,165,29,99,34,21,96,58,220,138,36,142,8,156,75,105,148,84,0,90,81,2,220,224,144,87,116,35,235,83,13,168,91,9,153,42,221,164,163,153,246,233,223,155,91,170,102,70,190,188,254,146,218,62,46,39,199,219,15,75,194,50,192,104,13,42,192,180,98,187,77,178,29,61,37,102,22,101,8,208,37,58,245,161,216,81,2,165,37,54,25,0,70,83,20,128,152,101,70,62,231,34,0,21,164,166,254,238,77,164,117,186,238,214,206,82,149,233,48,74,197,40,197,66,54,212,76,158,73,150,27,232,9,215,16,197,115,152,76,60,126,99,120,180,221,5,18,132,55,90,38,145,218,198,5,189,111,163,5,0,46,83,81,129,96,226,138,36,127,13,92,75,34,77,205,211,253,75,155,116,116,205,175,107,38,166,71,49,59,154,12,45,35,170,161,147,102,80,184,132,3,192,28,49,14,166,79,95,47,185,225,201,193,86,209,127,103,2,4,206,108,156,57,106,28,192,21,70,230,24,5,0,82,85,66,41,58,154,242,138,216,238,92,3,164,26,58,77,153,88,86,109,52,103,179,252,146,106,214,83,8,150,254,45,12,235,58,149,236,119,30,151,104,126,93,223,105,0,207,222,101,126,1,198,128,0,193,177,103,198,60,130,38,250,236,237,244,102,111,187,248,211,1,74,73,148,105,136,170,42,54,221,61,206,7,254,20,144,173,154,54,41,61,186,163,75,121,45,235,24,90,165,54,177,134,13,109,91,96,18,208,159,171,210,9,44,229,164,104,64,5,10,71,103,10,174,138,217,41,2,208,26,182,169,108,77,73,67,41,0,86,73,224,220,184,137,11,86,246,135,251,0,32,33,83,245,246,196,242,44,111,115,46,231,82,143,212,7,51,195,153,216,149,122,174,54,234,61,33,36,236,57,57,143,117,54,10,48,119,171,129,131,132,240,196,22,221,151,8,9,5,180,214,149,23,57,190,233,139,77,5,86,71,76,216,4,93,46,86,217,189,249,86,245,27,165,121,154,94,100,221,207,215,242,124,183,141,175,108,123,100,122,212,50,138,184,144,45,48,157,48,60,12,76,45,77,72,128,93,54,112,96,116,35,133,30,114,146,209,167,227,130,195,191,100,2,90,75,12,251,32,230,22,193,226,157,11,192,162,145,130,42,110,234,222,100,169,173,243,233,175,186,85,63,83,94,70,211,196,16,234,163,166,78,82,140,204,161,201,153,116,21,29,40,83,206,98,211,4,128,161,39,51,82,107,44,157,20,52,225,53,166,179,236,179,163,151,84,8,0,106,89,41,79,49,120,61,35,210,198,213,22,2,88,0,115,106,97,93,111,154,167,158,127,186,87,223,102,91,214,120,254,75,81,36,216,4,201,84,134,108,93,129,148,190,174,1,96,13,116,173,67,55,193,119,183,36,142,80,57,226,31,185,72,22,1,94,89,4,251,144,94,182,70,182,193,55,0,153,9,25,136,60,55,194,217,150,109,251,229,181,206,37,143,143,235,21,57,216,222,33,225,37,208,127,27,118,22,87,37,11,116,128,219,14,190,22,220,68,72,104,197,147,69,134,189,193,85,149,215,166,213,169,23,8,38,0,90,85,128,61,164,151,29,145,52,170,190,146,88,242,85,243,52,100,157,83,117,230,208,119,231,245,245,161,109,155,150,109,250,105,83,183,141,244,1,122,119,19,142,219,185,245,13,62,105,123,32,199,115,13,24,241,208,13,54,84,202,213,205,42,16,162,81,130,206,26,112,87,210,12,0,86,69,96,253,102,37,142,128,120,248,246,149,68,253,111,158,237,80,249,191,115,69,83,231,230,136,12,195,118,119,180,89,119,119,35,167,218,35,128,50,82,37,187,118,12,120,40,129,175,1,203,44,52,146,238,40,194,38,61,138,222,16,26,217,77,133,152,0,90,87,160,124,208,174,123,70,185,77,207,197,4,164,132,197,169,242,60,72,81,249,17,141,227,75,237,118,117,150,87,49,119,85,20,100,4,172,253,2,128,198,105,216,8,7,181,8,14,191,128,174,161,227,117,221,82,61,218,126,26,92,222,197,50,4,179,226,1,90,89,6,60,177,122,109,19,213,84,55,156,139,0,50,96,78,229,102,237,179,100,89,91,103,190,221,149,229,57,209,86,149,28,119,217,65,6,112,1,144,138,37,19,245,55,60,31,0,83,111,2,116,210,191,100,16,51,50,26,210,125,6,75,92,26,165,3,70,79,64,124,166,224,171,28,176,201,157,235,4,8,176,228,169,63,173,44,82,159,242,123,117,187,248,204,188,150,244,182,141,239,93,67,64,86,132,0,248,91,121,64,233,165,131,232,165,5,62,39,155,36,94,5,8,232,40,218,65,225,61,195,202,32,189,153,38,0,70,75,146,24,224,171,68,104,95,195,185,28,137,68,5,75,83,143,178,69,154,237,107,210,215,109,229,235,33,85,97,87,200,182,122,74,9,14,18,168,1,18,146,221,63,162,255,205,16,6,137,206,152,213,206,221,133,116,189,112,71,38,245,52,138,182,246,116,113,240,0,90,85,68,112,183,124,155,16,115,42,2,30,2,142,1,144,160,242,60,218,162,234,173,106,222,145,84,155,72,132,4,78,232,126,122,170,79,32,96,38,128,141,140,32,0,148,111,165,3,95,186,249,74,71,201,222,178,120,222,28,69,210,85,53,5,118,157,9,94,77,76,25,202,114,101,134,77,222,169,28,64,163,133,197,85,143,136,96,217,223,254,56,72,241,155,239,210,176,114,145,52,39,17,108,218,11,128,14,88,4,4,66,135,249,209,9,28,12,79,186,219,70,235,54,33,184,38,79,180,104,244,34,50,161,47,0,0,78,85,216,25,170,229,203,12,85,140,207,53,16,38,96,78,229,233,26,190,118,175,239,91,123,146,158,65,26,102,154,4,14,145,75,109,239,173,69,127,237,116,236,48,229,180,159,160,244,69,160,193,48,199,53,205,180,63,121,178,150,231,72,168,71,115,56,71,88,210,37,0,62,87,146,41,100,37,43,108,56,75,96,1,204,17,229,57,75,92,37,229,203,52,253,170,178,6,247,218,12,219,237,99,101,6,116,48,42,1,234,36,16,189,129,131,132,118,147,236,82,167,205,21,201,235,230,102,118,72,42,56,229,45,29,0,70,77,2,140,160,114,165,195,94,166,218,15,124,14,230,84,173,255,53,49,203,225,215,149,40,243,79,54,118,212,37,203,129,164,103,46,2,135,7,76,111,26,241,20,160,31,234,63,9,202,53,13,229,209,8,75,228,156,219,161,99,2,58,75,132,18,15,225,17,176,202,198,213,151,170,47,238,93,207,197,60,15,63,198,63,171,134,107,248,128,110,67,246,193,33,58,116,74,118,176,119,1,29,16,63,161,105,73,3,69,232,117,144,202,122,114,205,173,121,41,220,146,134,130,67,122,57,94,69,191,38,0,86,73,10,89,38,94,244,100,229,89,171,161,218,6,48,64,170,90,87,84,85,45,251,238,250,233,195,74,252,23,252,74,84,6,223,146,240,126,161,89,103,172,30,228,0,18,234,12,18,68,121,86,249,150,76,197,130,247,3,52,93,166,194,211,121,179,106,132,214,29,253,241,0,86,85,142,185,163,246,170,14,68,56,21,128,3,34,85,158,181,54,250,39,107,142,126,127,187,53,229,223,189,176,50,51,187,186,97,248,134,146,185,88,162,11,216,78,227,160,179,105,150,246,208,45,189,67,75,147,144,203,240,232,2,71,33,224,33,63,237,181,243,156,186,53,0,82,73,134,59,99,244,226,17,116,234,115,192,145,57,104,229,218,60,213,204,217,109,247,237,247,76,19,77,40,104,34,147,196,28,107,237,180,87,162,159,69,13,143,95,39,96,79,64,65,249,24,69,144,204,190,232,228,197,236,242,135,105,154,38,120,65,218,72,41,186,81,0,74,71,84,187,17,53,129,100,223,228,234,85,76,245,85,149,215,66,212,231,242,215,183,113,19,87,99,31,39,162,198,172,228,42,46,155,45,215,124,143,5,239,10,90,254,36,26,86,85,38,206,67,27,124,93,71,247,179,177,166,44,219,104,194,159,206,68,253,8,0,74,79,168,178,117,234,174,108,6,244,202,109,217,242,252,94,33,162,106,62,127,60,253,210,175,28,99,165,217,175,94,205,21,72,34,71,166,173,193,139,192,180,105,202,109,48,129,170,6,192,16,224,49,95,2,253,122,154,130,43,121,213,143,156,40,165,29,38,231,171,53,0,90,89,74,70,210,164,32,66,250,92,22,48,26,168,213,146,161,163,126,231,251,107,175,116,164,250,150,58,195,172,91,185,227,123,183,220,189,50,225,42,12,133,14,234,44,119,118,96,9,184,132,213,45,113,2,94,11,19,102,13,136,186,175,146,83,123,109,94,175,32,217,105,250,252,83,173,2,0,70,77,202,218,49,152,3,160,111,157,106,55,129,135,129,86,174,190,60,127,174,229,222,103,191,255,85,225,225,94,92,222,206,59,239,43,123,126,235,34,33,166,46,64,119,99,225,233,10,139,122,141,35,232,106,221,74,51,95,52,11,253,153,253,165,255,71,34,205,127,223,0,90,71,2,123,227,190,37,98,33,221,184,218,1,137,28,90,77,179,108,22,53,191,51,181,183,103,52,67,98,155,100,186,163,168,33,45,138,176,146,3,126,211,31,61,64,42,96,172,41,244,6,133,2,81,6,12,159,77,180,70,234,136,151,103,2,52,83,71,61,0,74,79,28,195,210,11,10,89,189,40,167,2,160,110,20,160,230,114,237,187,98,141,219,239,126,198,134,119,197,133,213,249,149,98,115,169,233,166,238,18,4,18,44,145,102,171,65,173,6,208,3,152,120,131,209,1,21,35,46,22,28,228,188,42,157,66,150,166,208,117,205,10,156,4,74,77,20,129,22,72,69,100,117,231,3,83,3,75,174,57,191,163,168,212,126,238,26,38,22,89,89,66,153,246,122,35,182,195,188,211,83,2,74,226,166,201,123,232,129,0,96,90,142,157,3,204,185,104,69,111,52,40,22,33,28,36,164,218,169,172,27,1,62,75,156,2,115,209,21,145,205,157,139,0,161,133,150,168,231,191,109,166,173,37,217,155,152,73,167,160,253,118])
.concat([181,130,240,210,130,221,22,113,12,90,115,173,120,191,73,41,74,35,244,6,126,213,42,61,101,67,71,76,45,239,20,5,116,83,107,84,152,211,54,0,86,77,12,89,4,93,95,16,25,214,185,8,228,23,21,172,66,212,245,172,150,37,59,222,244,245,73,181,220,80,139,100,29,2,121,142,192,164,148,11,22,250,145,29,233,92,61,94,35,58,84,19,83,7,54,191,186,13,3,2,137,146,20,173,76,18,233,221,226,153,10,0,86,85,130,24,224,203,103,88,24,157,139,1,252,18,86,106,49,246,106,155,102,117,234,186,173,169,184,154,165,247,168,188,91,26,211,52,195,218,231,90,0,105,181,88,8,20,2,202,63,67,35,0,7,22,22,6,157,14,160,100,122,210,173,175,186,33,158,75,223,136,179,34,221,70,1,0,82,77,2,44,173,125,251,92,21,44,242,170,109,97,168,115,112,12,128,131,170,107,222,170,55,214,37,235,38,162,173,25,17,19,0,100,115,233,153,232,26,26,220,254,54,212,76,207,3,206,212,204,254,131,81,21,206,211,77,120,169,63,93,103,194,155,163,173,53,0,74,75,8,217,81,133,228,128,85,238,92,3,52,59,44,85,35,38,166,73,231,122,188,154,10,147,12,149,254,240,153,165,33,101,130,71,3,227,240,92,173,63,13,187,1,240,197,1,88,71,194,223,211,45,70,153,228,4,106,225,200,100,93,76,36,58,77,20,105,129,16,213,214,34,243,230,151,170,23,10,127,223,198,110,234,252,113,51,114,155,177,147,49,58,116,129,240,228,48,197,34,245,23,160,49,27,118,239,214,14,35,117,220,123,5,71,47,155,104,165,159,198,146,217,208,124,78,93,204,53,208,147,163,61,1,58,69,148,42,218,242,37,218,28,119,7,174,54,2,76,24,44,85,165,46,207,59,19,167,255,4,99,105,123,159,12,53,59,122,129,235,203,4,166,62,231,233,35,93,106,218,112,163,163,0,60,189,55,247,82,209,205,225,239,110,58,152,248,130,199,93,241,0,54,81,140,115,69,197,14,236,22,167,136,144,16,21,88,42,207,39,223,215,108,173,181,89,255,183,230,137,120,70,123,216,207,104,139,33,91,208,107,95,131,222,47,155,73,95,114,134,240,244,62,106,64,43,204,6,34,144,83,75,241,148,74,198,133,102,50,64,196,225,155,92,225,137,150,83,8,17,203,0,86,79,2,123,144,112,78,216,164,225,249,32,63,14,75,45,185,236,154,137,219,245,219,143,35,77,215,120,106,181,207,2,21,183,50,73,12,246,17,64,1,246,103,113,52,51,165,209,9,10,68,110,18,76,79,162,9,2,158,23,113,230,8,39,81,234,185,139,169,224,112,150,0,82,71,70,26,34,249,172,88,101,135,62,215,192,37,112,4,128,131,114,157,219,154,42,82,93,219,253,30,81,217,2,76,32,176,24,77,30,146,64,212,108,115,151,112,37,196,1,60,180,177,156,193,97,5,13,228,179,179,37,142,201,52,179,36,65,11,0,66,87,66,27,138,144,7,108,154,249,165,102,94,127,127,170,135,233,252,94,122,27,81,89,31,174,73,182,152,42,233,179,116,91,195,196,83,64,161,140,107,190,93,19,219,144,14,204,249,251,9,12,128,238,27,197,189,43,14,142,162,125,40,53,90,114,218,50,170,198,82,51,1,74,71,38,26,25,92,81,136,116,49,231,106,32,12,168,82,174,203,203,26,179,223,191,37,123,174,74,236,202,153,217,54,85,248,168,209,169,100,92,34,120,101,57,128,18,54,211,32,64,105,172,170,109,127,244,129,44,99,41,12,56,140,83,199,23,249,179,149,69,160,123,65,242,39,1,70,69,136,178,20,47,181,34,171,59,206,21,160,78,1,133,171,230,79,154,230,213,252,182,182,169,86,229,38,148,83,34,145,110,182,15,36,127,45,102,231,178,100,24,250,161,144,208,149,145,72,23,32,116,26,83,75,75,126,158,120,148,87,154,26,130,34,154,134,38,139,70,3,90,77,193,26,162,92,192,10,221,115,181,13,48,9,116,18,181,91,90,53,237,83,199,245,91,67,148,252,161,75,211,79,198,30,249,126,187,89,231,248,229,78,131,218,39,77,117,243,233,155,137,205,122,64,241,153,108,59,236,40,138,177,47,28,186,127,252,164,3,74,73,202,43,40,71,8,96,239,157,195,0,18,82,213,95,252,190,148,170,237,218,182,73,35,123,76,170,59,149,163,86,175,44,148,174,168,4,139,113,189,115,125,27,116,86,0,131,0,50,158,230,123,234,109,114,232,174,129,128,43,167,214,152,105,2,78,83,42,186,113,51,17,24,159,2,142,57,180,90,242,237,98,93,239,79,234,222,57,255,253,98,124,67,87,169,168,219,52,148,216,149,115,153,136,67,52,199,202,44,141,7,246,110,0,183,221,20,60,164,251,114,253,8,157,60,230,199,223,140,129,161,91,50,125,61,87,235,26,22,52,0,86,89,161,114,226,14,0,156,3,160,33,145,76,211,238,22,125,95,205,210,92,21,157,24,31,205,3,49,164,26,30,184,88,172,194,190,208,222,133,22,237,110,106,26,85,128,183,166,65,199,166,236,246,15,146,78,57,242,56,192,105,138,91,230,99,37,211,4,90,75,105,244,32,142,26,64,247,124,46,7,28,131,42,137,122,251,197,164,136,166,63,114,183,168,186,185,98,92,103,148,216,232,210,216,94,77,223,16,4,154,197,99,139,245,29,80,216,231,0,141,94,72,243,30,169,139,70,180,94,64,193,39,148,47,204,3,74,75,202,26,224,8,29,236,238,156,36,130,29,210,160,174,113,102,49,219,190,207,239,48,105,29,211,66,43,116,216,37,137,31,195,175,173,157,194,72,163,168,40,3,73,203,17,212,63,0,24,232,3,14,79,33,233,7,161,232,55,86,148,46,148,98,2,70,77,66,43,105,190,173,35,57,190,106,181,9,36,137,85,136,186,29,89,138,102,61,86,211,103,247,104,34,137,250,86,10,83,25,106,162,105,166,50,168,103,149,78,64,73,222,159,103,110,219,210,117,9,216,13,217,64,50,80,98,20,142,208,20,199,199,191,169,202,150,210,1,70,73,40,186,73,47,4,196,131,119,142,4,72,208,73,212,179,73,199,34,59,243,61,98,243,165,41,248,17,165,66,16,132,152,102,175,110,165,34,88,125,81,131,236,110,187,101,249,245,212,25,227,221,184,139,138,71,106,15,130,120,218,73,248,11,6,144,97,22,0,79,103,103,83,0,0,0,2,6,0,0,0,0,0,81,117,155,31,14,0,0,0,206,221,82,74,57,83,70,74,70,72,69,66,70,74,68,73,73,70,70,73,72,69,72,73,73,71,73,79,80,71,74,72,71,71,68,73,73,71,71,69,68,73,69,71,77,74,67,74,68,68,73,75,69,79,75,72,77,70,73,74,72,69,82,79,202,59,113,95,170,35,105,244,109,2,210,2,171,40,207,43,155,171,107,183,126,189,189,147,158,201,47,220,76,33,162,110,12,179,136,58,88,38,62,160,207,105,89,29,174,99,20,151,27,142,51,70,65,89,38,192,176,206,24,104,186,166,183,110,234,83,205,50,107,188,181,203,153,154,201,184,72,47,43,116,0,78,71,34,59,81,170,138,40,241,3,238,92,4,60,129,78,162,118,179,55,89,108,250,183,93,187,94,98,46,236,179,152,57,88,206,156,43,47,80,44,129,104,47,100,59,62,205,41,241,1,230,146,28,130,211,49,96,38,72,190,104,93,116,74,163,191,220,77,186,0,102,85,205,59,53,94,165,91,127,234,182,172,182,78,224,72,52,39,22,103,123,44,150,54,156,219,182,164,73,182,78,71,103,59,240,67,59,126,62,40,166,37,220,141,181,247,200,158,205,97,132,226,179,200,1,166,132,212,116,180,30,158,28,66,60,199,35,136,200,154,230,21,59,5,90,77,73,118,107,229,213,20,86,107,242,206,69,192,73,88,154,122,94,145,34,79,217,91,93,86,83,225,247,104,78,204,198,187,35,211,148,64,137,4,27,171,74,161,235,17,169,73,195,128,163,64,103,69,9,4,57,240,145,133,195,150,224,148,222,27,214,165,28,0,82,77,42,59,17,95,174,176,144,229,59,215,24,132,132,37,79,221,255,149,158,153,179,59,250,44,214,37,82,23,223,174,66,175,28,100,45,55,33,71,0,61,91,227,239,234,153,158,196,68,29,32,5,9,179,165,193,190,51,18,116,160,211,145,88,153,110,69,211,79,131,6,90,77,196,43,94,188,160,176,201,206,156,11,192,124,1,205,85,187,149,168,39,126,199,151,231,51,234,152,18,61,87,22,193,46,86,3,255,142,88,30,26,138,175,239,176,95,161,72,64,250,2,70,208,136,107,119,151,221,116,10,136,238,192,166,174,208,49,59,0,82,77,224,149,182,66,9,108,230,87,109,89,224,13,96,169,122,165,54,152,123,186,231,199,222,138,183,248,178,4,86,72,198,148,3,80,17,40,124,162,32,249,205,111,105,160,3,161,139,205,106,167,200,32,145,236,164,40,20,164,25,178,149,122,135,7,70,77,164,144,230,65,17,76,179,107,182,165,105,94,168,56,141,213,121,189,239,245,112,115,62,54,246,135,116,158,176,230,171,237,9,180,29,5,24,68,136,193,249,216,7,209,41,32,52,215,240,163,184,144,185,41,52,45,166,39,94,64,103,155,236,140,157,121,26,0,94,79,174,112,102,241,149,130,141,59,115,174,1,26,13,44,53,77,235,180,211,28,255,254,222,167,251,101,38,105,184,25,93,7,173,100,172,64,216,67,224,108,209,153,74,165,47,182,236,86,215,1,159,240,184,167,248,18,93,43,184,99,176,21,109,168,248,60,202,180,169,20,1,0,70,73,168,82,60,131,6,108,58,187,218,114,7,164,26,150,170,221,17,105,105,93,213,156,89,210,86,49,94,241,93,113,115,106,13,73,133,148,208,32,45,86,125,10,43,200,0,132,164,205,183,129,156,158,213,23,144,241,82,185,160,77,93,131,37,218,11,0,94,77,73,225,49,11,18,172,126,195,169,74,64,10,104,77,237,187,52,107,90,143,219,214,175,214,38,11,11,122,23,111,198,246,185,82,56,217,143,67,167,78,211,134,62,129,44,181,128,4,218,99,34,215,213,81,117,35,193,44,229,36,94,215,174,20,141,43,150,103,152,30,0,90,79,229,212,141,248,26,73,88,57,239,11,0,203,128,149,170,243,104,155,166,158,218,187,212,206,150,166,38,79,29,189,3,89,166,5,54,184,11,126,101,214,0,233,135,87,227,28,175,4,83,153,250,10,48,60,77,29,207,166,67,141,57,114,36,169,177,166,117,165,47,65,2,66,75,102,98,96,94,16,48,124,213,171,84,217,123,30,47,30,221,59,243,52,246,52,126,115,187,89,80,116,239,35,28,141,150,211,116,65,240,135,177,104,19,232,75,151,15,37,240,26,104,3,128,25,108,98,179,50,164,98,167,5,197,207,243,141,57,219,252,222,1,70,75,166,103,32,174,152,165,184,43,159,50,0,1,164,170,167,213,172,253,186,250,222,174,30,39,29,235,222,41,237,107,105,163,86,169,70,117,219,44,130,238,91,243,23,44,148,71,3,24,18,16,140,233,79,159,67,243,186,118,54,149,197,152,142,252,75,222,108,0,70,71,168,231,6,144,160,83,207,151,86,61,190,91,181,183,89,241,169,186,160,206,206,115,75,220,165,56,155,28,240,199,146,227,54,11,111,134,131,226,44,94,220,101,165,225,25,44,2,208,59,203,115,57,8,40,195,126,78,197,9,93,239,5,226,108,228,75,209,69,157,215,0,82,73,110,226,6,96,96,241,170,109,4,240,102,80,167,169,103,247,101,51,237,28,199,253,93,231,75,59,251,74,129,231,105,111,169,45,116,181,126,94,19,43,228,172,70,72,94,131,90,99,2,26,192,12,12,228,91,71,43,1,176,200,146,163,72,105,114,66,42,26,19,0,50,75,176,2,12,24,200,109,117,14,245,229,248,159,31,67,100,212,149,113,119,205,187,90,120,58,157,122,20,189,177,139,131,88,205,190,116,219,221,72,37,220,134,212,222,166,48,8,12,24,128,201,200,204,58,146,115,165,112,188,196,119,15,238,140,104,173,227,0,66,71,108,98,225,38,28,116,225,179,68,224,18,74,81,125,82,151,157,233,116,92,77,200,162,39,63,61,208,208,158,156,52,219,229,157,244,1,41,245,19,42,178,255,90,235,105,83,115,166,213,101,112,208,80,110,124,38,88,170,52,106,132,227,255,143,44,152,180,0,147,2,74,81,161,239,198,204,42,32,104,241,53,48,132,211,42,207,255,44,183,52,205,251,182,89,127,157,213,84,149,234,200,161,103,75,235,93,88,74,99,223,85,48,45,81,114,74,1,218,142,167,1,184,166,226,0,65,75,94,110,160,152,8,254,122,141,68,181,149,248,18,76,97,2,94,87,73,225,166,121,53,144,166,218,1,42,64,203,45,182,177,4,205,245,172,237,122,228,107,245,156,192,74,126,246,146,84,177,146,67,159,181,79,25,10,219,130,4,174,131,0,126,217,109,91,83,131,138,37,49,50,65,190,170,60,221,185,148,59,141,136,217,180,69,77,1,0,78,75,162,50,44,93,37,88,72,167,170,61,112,94,67,203,213,237,151,166,214,231,122,219,230,247,90,215,24,139,126,45,56,115,47,10,113,83,170,32,87,109,93,162,18,73,127,217,129,114,210,142,17,46,50,137,198,41,166,162,241,232,230,161,206,86,215,218,235,158,4,62,85,164,7,138,171,131,36,231,1,16,208,169,220,123,175,141,172,171,215,124,210,50,130,236,149,22,141,54,157,180,231,35,126,36,106,161,163,113,174,146,178,96,110,34,77,100,85,1,195,10,131,188,105,69,115,143,85,20,122,182,55,203,75,88,217,228,250,21,141,37,8,0,74,83,170,210,72,135,82,20,12,79,197,3,40,66,23,45,254,206,252,13,205,178,228,237,47,79,209,150,239,55,125,53,133,19,243,251,41,78,245,109,117,122,225,164,230,62,9,213,75,238,187,149,130,2,15,151,191,15,20,69,113,239,83,209,136,146,88,219,11,187,190,92,161,221,162,158,164,148,0,62,79,164,54,16,16,128,65,245,89,19,185,55,175,156,191,86,126,222,150,255,84,123,113,170,21,126,139,218,228,10,42,5,113,168,183,180,203,46,76,210,54,4,58,76,171,211,139,132,246,93,205,115,101,100,83,192,78,17,230,64,227,128,18,16,77,179,157,27,173,174,7,218,72,57,80,164,117,134,0,94,85,73,225,198,189,154,198,116,25,157,91,224,2,88,170,201,185,140,56,150,186,82,101,77,227,113,78,11,122,171,91,193,12,1,201,19,160,73,179,209,195,178,230,159,10,208,250,99,61,138,192,48,158,166,224,79,203,223,42,52,103,52,231,32,99,10,170,103,24,0,94,81,161,176,165,120,49,109,117,97,170,173,19,16,192,82,139,207,182,196,172,109,254,234,190,89,82,122,237,70,23,182,99,161,123,27,240,143,128,253,186,192,159,164,234,168,115,38,184,220,111,14,52,94,129,97,83,168,9,46,187,84,80,136,143,115,137,43,77,92,213,202,20,0,90,85,105,223,131,120,73,16,115,174,0,11,96,169,153,205,98,174,154,152,208,232,150,144,115,241,209,172,67,219,135,102,39,216,23,128,54,8,6,234,159,2,9,252,72,195,88,67,166,238,221,34,93,170,72,1,103,66,76,19,54,141,49,151,24,51,152,222,165,170,93,3,98,79,73,225,33,189,152,130,197,112,206,13,96,1,44,78,161,102,221,112,156,79,164,99,189,186,73,156,221,143,118,95,110,23,137,30,18,220,11,80,24,65,108,141,177,229,58,149,79,208,132,1,99,180,42,143,219,28,197,217,135,73,20,5,10,41,140,53,76,26,0,78,85,166,50,50,125,55,141,225,166,250,146,168,255,95,31,207,217,83,233,151,169,248,30,159,122,204,135,156,80,69,211,221,74,173,51,106,96,159,224,56,195,99,229,149,133,196,18,27,155,164,88,164,96,34,58,15,239,144,254,219,154,197,83,185,225,82,81,120,53,0,70,73,97,197,158,196,117,8,172,26,170,47,85,255,125,173,99,236,239,225,247,209,7,185,115,182,31,130,104,100,148,11,38,86,96,147,191,36,147,84,254,99,147,227,133,126,31,147,2,36,89,243,193,160,109,83,242,114,154,244,214,26,165,3,232,65,65,2,86,85,166,231,207,242,221,192,102,113,30,176,76,96,169,37,237,41,150,110,251,154,110,244,170,125,30,114,217,182,170,142,48,32,16,188,8,96,50,113,74,10,139,1,19,223,238,230,95,74,6,223,155,204,198,113,102,145,59,167,165,155,30,8,142,236,100,140,230,214,62,10,0,82,85,166,242,38,189,142,128,197,162,218,0,22,128,149,202,93,110,75,172,117,251,237,205,109,159,60,178,117,42,234,246,59,130,1,116,240,25,192,38,28,68,165,243,78,201,43,36,33,113,76,125,150,105,147,224,39,135,224,75,121,85,98,102,162,46,208,176,225,98,193,34,0,90,83,73,223,27,119,109,80,227,188,115,1,192,193,74,213,47,150,251,247,35,230,252,173,213,78,0,27,210,72,249,114,3,187,96,40,234,11,0,27,139,36,252,36,116,8,192,7,140,252,1,105,101,63,205,41,251,150,94,4,16,88,60,141,144,229,193,95,11,1,0,86,77,201,138,55,166,11,136,228,85,251,3,25,28,153,92,205,175,181,153,168,231,214,55,207,77,170,251,9,137,136,108,27,58,75,81,1,119,98,149,12,160,173,21,209,230,69,208,84,233,203,45,175,3,253,100,166,96,155,15,255,56,179,208,164,199,33,147,160,73,15,58,89,50,3,7,17,112,14,32,158,175,3,69,229,222,211,116,113,234,243,89,127,106,104,210,156,243,144,92,150,85,73,238,226,92,206,41,11,99,90,24,14,251,155,56,100,120,104,192,226,241,113,156,46,105,128,131,219,36,89,75,133,42,230,20,115,5,1,0,46,75,182,214,49,17,13,203,220,15,152,120,64,118,80,182,95,95,151,91,214,213,153,7,163,51,120,183,28,86,108,63,86,49,10,125,218,95,47,224,41,129,14,190,65,163,107,211,117,221,138,80,147,114,177,225,215,166,14,135,98,155,204,212,200,34,205,75,54,79,188,2,194,208,144,180,123,6,158,3,117,106,241,89,117,41,52,247,249,190,140,241,114,181,72,186,102,55,36,234,24,154,157,19,244,45,17,26,194,231,50,225,25,101,5,152,13,208,183,1,197,54,96,210,48,58,156,77,120,143,74,60,27,85,55,66,189,201,146,8,0,78,87,162,39,149,0,172,192,41,128,140,0,210,144,210,221,154,46,180,147,229,207,153,55,53,205,83,202,244,88,153,210,78,229,150,224,4,58,7,155,188,194,3,251,13,95,152,190,99,19,229,216,156,253,5,159,112,226,123,161,47,49,182,4,231,240,212,153,2,70,83,98,10,28,0,56,183,1,72,9,45,151,123,238,205,84,59,191,99,146,103,164,88,4,122,123,112,102,199,175,40,46,56,242,26,169,153,170,169,6,154,2,213,130,131,140,63,84,162,181,15,83,185,80,248,180,209,18,152,99,196,226,86,116,179,137,198,178,89,0,94,87,166,118,179,40,0,156,91,192,60,160,24,44,30,75,163,249,234,251,181,71,53,253,85,145,44,243,17,59,20,70,151,138,170,137,129,98,136,71,246,22,214,167,5,152,60,60,161,183,80,52,99,87,53,251,51,60,173,164,229,163,17,127,24,12,70,70,118,160,213,86,46,67,208,74,0,70,85,170,178,17,48,1,139,83,14,88,138,64,49,168,249,239,140,253,120,238,207,246,229,247,189,77,241,71,187,203,73,77,179,160,155,218,188,78,142,51,226,57,209,191,166,44,110,100,105,1,245,0,214,41,12,104,219,53,230,212,105,96,144,2,217,166,185,60,39,166,82,28,0,70,79,164,112,51,92,242,138,44,170,61,0,57,212,6,53,246,172,162,174,255,146,174,238,201,99,137,149,55,206,123,29,73,108,50,132,147,4,212,136,151,56,74,39,165,169,28,125,130,140,234,17,156,198,209,17,222,84,192,228,129,116,92,217,36,20,0,74,71,166,239,174,69,215,7,72,156,19,164,1,106,67,202,254,109,68,214,110,182,252,122,183,89,202,84,169,46,161,82,57,165,101,121,215,78,44,239,124,200,109,59,35,187,175,38,25,69,174,113,133,148,166,113,64,97,246,81,57,163,5,48,152,64,64,185,148,51,12,55,73,38,70,83,36,59,89,94,252,64,146,115,205,113,59,104,85,179,246,126,37,218,230,169,255,214,182,84,82,91,136,129,241,246,181,190,209,139,196,47,156,14,254,115,41,110,110,34,225,150,73,176,216,214,130,71,241,115,234,14,77,122,157,108,74,195,249,36,182,0,62,85,164,210,72,170,206,128,115,29,128,136,65,75,161,249,79,34,207,211,115,164,127,250,85,53,140,197,35,85,130,96,177,251,154,87,72,223,22,5,52,64,206,222,148,91,162,144,148,88,106,104,45,58,157,198,70,30,69,129,231,144,211,185,207,97,60,0,74,85,42,26,20,147,92,144,228,92,0,8,160,139,234,101,217,219,250,182,70,251,187,45,227,144,16,5,246,218,232,66,123,67,145,246,62,110,47,176,70,145,76,52,237,214,44,69,55,135,131,7,162,159,40,212,206,2,100,131,89,20,204,124,122,209,116,33,234,221,162,14,0,90,81,33,187,73,135,186,96,218,156,19,176,0,90,121,102,127,116,77,52,95,158,146,54,197,49,165,73,175,130,37,45,5,23,44,194,131,25,81,22,232,248,34,10,130,90,52,240,110,75,135,210,76,69,87,46,104,238,55,183,161,149,170,41,11,22,105,141,89,239,28,35,174,232,0,86,79,101,223,214,230,226,23,235,139,197,57,129,39,160,85,205,151,154,181,107,207,102,127,172,49,37,215,119,229,225,96,59,185,181,78,87,243,241,201,244,83,227,122,239,48,69,18,93,1,191,68,42,56,220,209,230,3,147,236,69,167,255,107,202,239,235,87,0,102,83,101,118,3,184,0,195,83,41,128,52,168,22,0,135,162,250,52,81,107,37,247,185,150,218,150,149,32,41,179,100,41,232,146,227,139,107,55,51,65,162,246,52,80,122,83,104,51,146,227,154,244,10,160,224,209,14,229,177,180,190,32,149,186,192,152,138,109,102,147,197,205,219,210,186,163,79,0,78,83,34,218,52,151,60,168,99,161,122,115,213,251,46,23,111,111,175,149,221,103,63,158,139,83,180,46,129,243,83,42,4,225,111,166,230,19,83,175,177,217,156,27,205,81,210,166,179,21,28,160,195,5,211,253,228,180,45,230,150,53,77,145,21,69,227,43,6,251,84,79,56,153,0,86,83,161,176,112,151,54,35,205,57,1,75,96,169,230,189,121,187,252,169,195,146,150,53,153,159,168,255,85,84,3,205,20,117,74,112,0,152,155,108,218,151,150,155,169,195,151,86,0,219,18,133,68,58,93,211,204,28,212,76,122,9,27,191,135,42,110,237,80,207,34,9,70,83,36,91,164,158,7,146,156,34,128,165,65,171,37,71,56,191,148,166,57,30,237,178,140,60,244,198,217,219,84,189,228,28,113,123,23,204,223,254,10,221,164,172,208,221,132,109,5,124,85,7,244,43,37,92,185,107,167,194,68,239,30,185,194,10,198,44,230,100,93,247,52,114,218,23,0,90,85,105,97,167,153,219,11,44,56,23,0,99,176,212,244,37,154,111,106,207,223,47,143,169,57,65,159,74,219,118,25,219,96,113,55,27,76,28,155,55,246,244,32,77,185,13,38,85,87,138,31,131,192,111,195,49,8,110,87,117,237,20,109,154,194,108,234,36,0,78,83,46,91,20,151,242,138,205,98,126,169,220,175,70,250,116,252,126,220,139,53,50,245,99,146,159,29,47,241,195,24,59,128,224,57,1,177,154,5,54,85,35,39,202,172,61,30,252,76,155,26,147,80,244,254,66,144,122,239,23,103,235,181,121,130,21,164,52,61,152,26,0,82,83,166,231,161,232,237,64,136,83,11,8,6,75,102,177,79,17,181,94,181,174,233,183,79,212,54,94,207,169,92,40,17,27,177,76,250,163,193,27,90,152,68,14,236,20,154,45,116,35,147,9,120,97,147,102,36,66,24,29,181,229,36,246,225,146,175,143,146,148,173,206,21,0,86,71,174,242,193,105,125,5,13,243,117,170,254,230,52,204,131,251,111,207,174,199,133,98,68,65,11,229,174,151,2,18,59,23,233,26,196,52,94,29,71,134,149,169,234,30,60,129,101,89,116,243,119,32,108,44,94,124,100,75,189,249,217,181,147,63,55,37,144,128,9,0,82,85,73,101,96,34,175,48,115,42,2,150,64,170,69,174,182,57,82,19,163,54,211,52,236,103,119,105,238,137,94,163,164,114,141,60,251,244,49,199,176,150,80,208,58,216,250,57,36,192,107,20,10,205,14,195,229,88,88,136,164,212,113,122,154,107,161,3,0,79,103,103,83,0,0,0,120,6,0,0,0,0,0,81,117,155,31,15,0,0,0,201,91,74,152,59,75,74,64,69,70,77,65,65,67,68,68,72,68,65,75,70,70,74,69,67,72,67,73,71,69,76,75,75,72,70,69,71,72,69,65,66,72,69,66,74,71,69,71,73,69,65,72,76,72,70,69,65,68,66,77,68,72,72,72,90,77,73,118,75,51,233,201,106,164,59,170,173,0,203,4,169,166,249,178,94,203,178,93,95,220,158,107,250,120,173,219,114,33,215,135,44,200,6,191,228,134,246,101,2,219,9,178,17,95,20,188,55,39,126,31,166,208,138,210,149,214,90,170,154,75,184,23,146,8,13,133,169,23,0,66,83,166,111,35,148,31,192,176,218,6,32,155,37,82,205,76,105,218,212,182,103,187,220,255,97,210,223,18,247,167,118,219,235,14,149,194,191,70,15,90,153,156,212,23,209,42,172,1,67,3,196,166,4,132,11,116,186,185,32,250,45,81,54,213,79,69,7,149,37,16,79,121,0,46,89,80,3,7,51,160,218,66,74,0,72,131,178,61,219,150,71,91,125,159,85,27,51,174,211,198,91,130,127,163,9,235,12,247,186,83,180,99,214,9,60,176,58,208,153,12,75,162,8,199,165,169,247,162,176,96,189,201,18,74,49,155,14,58,79,168,50,104,20,51,152,190,115,219,2,153,137,105,85,175,78,90,182,207,175,182,120,211,107,211,237,45,139,178,218,65,120,173,195,248,102,211,12,80,44,207,200,83,136,50,234,57,144,5,101,174,162,153,112,90,44,106,244,217,36,71,20,73,74,15,13,0,98,79,137,247,161,209,225,2,54,87,237,128,101,2,105,80,75,179,132,245,233,34,83,169,93,150,48,244,91,146,219,195,163,213,244,229,51,165,208,45,66,127,245,35,9,101,43,70,59,5,192,74,80,205,209,133,178,64,9,66,125,77,95,192,191,247,10,73,192,3,78,91,194,26,218,69,185,88,55,50,173,182,2,180,9,20,181,184,118,154,62,189,107,214,53,169,122,145,42,77,106,201,74,199,16,107,87,236,136,51,48,78,145,6,130,109,68,208,80,143,128,102,43,191,70,58,51,41,74,176,184,247,19,73,114,119,61,9,75,141,113,100,147,178,204,14,0,90,81,76,130,34,232,23,4,86,119,110,0,13,1,114,149,53,211,168,154,61,207,215,191,164,77,160,179,108,161,202,124,187,46,82,68,160,106,20,182,7,134,205,57,18,102,2,112,220,94,202,11,232,134,141,64,155,74,119,145,52,77,58,225,1,74,77,204,131,84,229,130,172,174,124,110,1,82,36,82,149,117,53,105,34,182,239,174,203,82,16,28,137,7,74,90,124,237,105,205,99,92,99,64,2,197,193,34,228,96,5,133,6,195,26,133,94,88,25,96,35,94,36,189,76,82,73,208,38,0,58,83,200,3,161,212,5,76,223,169,92,2,14,180,42,187,221,58,233,90,243,254,246,86,106,173,115,57,247,13,236,74,20,159,90,21,108,132,99,120,157,188,155,74,42,91,29,129,122,2,44,97,197,212,217,102,134,17,200,38,108,63,143,2,56,93,121,82,97,33,106,8,227,2,56,213,128,77,66,170,230,255,86,190,106,110,249,191,186,148,205,50,87,172,125,29,70,16,243,33,243,154,226,251,90,208,212,207,77,193,114,157,32,3,16,5,120,76,76,223,210,137,94,164,158,159,191,210,158,251,172,28,49,224,0,82,91,206,219,152,144,51,178,26,206,13,192,37,180,42,51,157,154,99,154,227,74,71,219,53,247,62,20,245,130,215,65,48,172,133,122,124,58,15,23,157,124,231,152,49,221,198,166,136,132,131,41,152,252,24,115,147,2,43,121,158,158,29,69,211,111,18,0,70,81,68,186,89,142,188,160,36,59,118,181,9,16,9,90,213,123,191,84,215,207,218,164,219,145,34,197,235,191,95,241,121,46,101,63,121,254,7,84,131,60,170,145,93,63,122,107,43,64,95,220,239,14,165,49,64,30,99,215,132,156,154,217,236,154,122,194,75,115,154,0,74,85,174,176,48,181,28,48,204,59,87,32,104,129,230,166,44,159,46,170,118,249,249,156,139,213,217,190,72,92,194,93,237,230,14,182,10,204,78,199,200,127,24,192,206,12,27,92,193,156,168,245,130,112,39,228,160,190,142,135,138,48,185,195,228,108,236,4,90,87,137,245,96,170,93,65,195,185,73,96,9,52,39,202,98,75,97,123,210,151,207,90,214,201,151,195,139,253,80,20,251,179,5,163,193,217,230,152,254,38,61,59,84,57,33,177,133,65,209,167,227,151,80,70,93,43,20,39,95,71,234,14,0,94,81,33,186,85,209,203,197,230,120,53,84,111,206,213,111,86,157,235,233,122,205,56,90,56,187,105,81,106,189,178,130,12,33,107,152,219,59,62,18,21,218,204,201,108,117,4,31,77,176,214,17,29,74,84,56,199,16,83,143,153,100,232,174,222,116,3,154,58,175,170,119,2,104,0,70,83,174,176,40,142,114,1,29,249,60,146,132,22,150,42,75,177,102,53,157,181,150,102,242,189,173,78,210,206,82,23,57,148,61,129,208,111,32,39,223,141,206,78,50,187,123,74,103,250,127,60,58,61,150,28,151,39,206,38,251,180,57,191,77,83,81,20,37,0,70,85,34,27,164,96,87,88,13,223,185,1,57,1,180,242,100,55,217,179,236,217,179,166,182,137,153,181,52,7,32,119,140,245,66,54,20,77,241,35,237,145,232,224,251,77,216,72,163,107,192,15,205,193,196,253,161,176,202,39,200,145,96,189,66,6,29,77,118,0,86,91,169,119,227,247,40,8,217,124,1,126,2,104,181,176,61,111,199,113,191,127,251,246,136,44,235,139,29,83,110,72,243,110,161,195,156,226,163,193,180,251,208,131,10,19,92,97,109,152,196,55,211,36,165,194,156,146,102,174,155,82,237,138,235,237,234,181,246,234,12,54,223,29,50,81,172,6,154,178,23,132,154,158,11,2,28,208,106,34,239,254,253,118,165,247,200,228,203,113,95,191,219,3,82,35,206,118,87,93,209,190,236,80,170,7,123,79,184,226,14,60,201,248,63,39,5,101,10,115,50,245,47,173,188,212,156,107,87,223,146,40,0,86,79,73,237,12,138,113,181,25,234,128,106,75,227,136,39,72,229,137,223,186,184,38,173,233,216,174,72,201,34,183,41,20,151,245,173,212,103,209,192,207,65,189,107,108,148,32,152,162,130,17,102,7,76,150,252,108,76,29,67,241,240,184,57,59,144,0,70,77,84,131,38,242,10,58,244,41,129,84,41,7,93,203,19,107,59,35,45,89,243,139,223,94,210,147,23,146,246,236,94,98,81,85,209,191,192,60,244,123,90,240,140,26,177,28,26,209,220,209,60,245,117,9,46,207,154,16,13,105,212,105,125,142,80,104,95,235,178,1,82,75,76,131,162,242,138,89,186,232,215,64,104,84,144,92,19,121,37,102,221,159,35,75,42,130,92,245,67,176,17,61,224,179,115,188,86,12,62,216,60,8,42,212,169,166,109,209,195,206,47,106,160,101,154,167,47,188,212,35,21,9,178,69,42,215,0,54,73,210,82,173,209,242,2,235,46,122,10,224,103,80,148,39,169,99,185,109,103,244,113,102,19,22,229,217,162,241,51,218,213,159,149,11,26,68,4,23,111,3,198,93,213,212,58,29,149,216,58,128,190,45,89,32,93,131,143,4,39,227,190,250,192,86,213,152,150,15,52,0,42,81,58,130,118,181,1,160,90,84,168,113,72,53,217,210,46,255,234,154,172,91,166,91,242,88,235,191,55,37,134,24,35,54,213,114,248,232,102,27,77,122,62,204,81,1,194,248,13,64,149,130,46,46,184,169,117,151,131,154,240,82,49,23,245,45,77,215,66,105,0,46,75,50,131,228,188,130,241,59,151,206,3,62,200,12,60,89,183,87,204,150,210,209,94,187,105,230,46,41,104,13,244,219,251,231,207,192,206,82,52,154,176,241,168,56,64,103,62,1,152,250,71,73,208,204,183,209,136,235,240,10,231,183,131,253,163,120,4,144,82,81,46,59,145,219,20,2,156,218,0,243,7,52,151,23,118,229,205,191,145,175,205,85,105,214,148,102,114,211,205,197,230,119,233,83,193,37,43,69,140,53,91,94,249,151,193,213,131,51,9,57,64,64,233,21,45,192,53,252,4,17,215,11,63,249,167,145,180,177,119,174,145,1,199,3,78,81,46,219,216,69,1,48,61,151,117,32,2,180,154,236,158,159,215,72,75,115,253,167,149,154,234,153,15,89,126,182,240,116,125,113,23,54,122,158,162,205,36,165,145,99,73,107,45,144,69,7,204,218,28,32,188,238,94,155,169,151,27,54,57,245,128,121,211,16,83,134,212,190,1,78,81,161,48,176,171,29,3,195,115,33,1,1,116,208,100,121,118,229,125,108,181,124,203,47,82,240,216,163,226,240,154,87,146,214,168,174,56,251,75,209,190,115,33,132,123,245,209,73,45,42,38,16,148,97,218,120,29,184,249,138,217,240,150,71,116,147,245,141,237,50,125,90,172,39,70,79,170,176,177,107,10,1,206,17,1,94,1,41,145,219,251,55,217,214,93,199,39,158,103,173,34,168,172,93,60,60,211,138,217,162,42,197,45,209,20,155,105,73,241,234,156,254,236,47,52,198,225,207,211,129,106,202,54,141,154,49,243,146,73,108,69,160,16,130,7,0,82,81,193,91,248,13,230,108,102,83,237,1,66,2,87,211,60,42,170,221,174,232,227,205,214,178,52,185,77,44,121,90,63,167,178,141,91,173,131,97,181,154,233,209,122,71,41,147,21,76,88,172,51,74,199,77,237,50,21,84,248,235,122,82,137,206,131,71,54,0,86,79,173,103,193,213,32,64,181,69,192,2,72,229,122,165,95,29,162,109,243,53,107,163,142,61,3,137,196,94,127,207,175,5,27,210,196,144,228,82,144,111,106,124,19,47,202,52,1,7,161,235,240,178,87,220,160,242,186,166,198,213,75,193,185,210,244,0,0,94,83,105,116,82,46,10,3,170,173,129,28,156,42,174,133,85,94,172,89,151,219,98,185,68,92,180,135,156,148,246,219,69,179,45,108,10,215,78,207,186,165,142,150,127,24,160,254,234,1,112,160,185,138,230,205,108,114,42,241,73,83,208,134,199,234,20,223,187,102,2,78,81,33,58,177,27,5,163,9,170,21,135,97,144,202,147,181,115,107,76,243,213,121,61,71,118,85,108,233,227,54,97,85,27,216,183,145,219,116,46,93,164,71,128,226,20,179,7,154,99,246,46,48,12,186,161,179,208,111,137,106,128,92,156,201,242,98,107,174,142,218,3,86,75,206,123,200,171,205,35,201,185,1,150,18,180,170,245,30,53,147,190,173,239,170,196,248,109,151,210,131,24,197,222,157,53,239,41,236,57,219,122,249,73,178,177,123,74,223,7,92,101,210,159,238,109,147,226,239,29,74,200,214,219,92,160,43,26,239,81,0,86,81,33,74,228,70,193,128,115,5,184,5,164,202,89,132,106,188,107,219,252,250,174,178,243,241,72,78,208,110,6,89,151,139,11,7,236,89,91,10,46,128,55,95,135,50,57,128,242,40,165,173,167,200,48,53,173,237,154,121,174,141,100,76,4,86,77,76,2,187,21,15,115,248,92,8,96,169,133,84,245,151,218,66,243,54,253,54,161,181,137,209,217,158,6,230,103,233,26,58,80,24,43,9,163,128,155,218,168,160,67,23,166,79,138,232,237,148,52,64,211,221,66,202,226,84,52,152,15,19,0,86,83,66,27,186,221,8,88,133,115,56,180,66,36,134,170,239,28,77,120,54,121,202,111,41,165,143,84,236,148,209,69,135,221,213,213,131,174,129,162,91,148,140,208,97,226,228,254,102,59,136,49,205,243,166,212,73,161,144,38,163,234,150,91,221,61,157,107,255,25,2,0,62,77,224,129,92,196,1,206,109,2,82,66,171,154,109,203,163,166,153,247,233,118,97,24,72,198,178,117,92,36,94,40,232,186,150,44,139,22,162,64,71,99,140,73,153,2,216,147,21,207,211,44,92,51,243,229,9,251,230,142,235,11,204,46,108,36,166,3,0,66,81,40,3,187,122,0,224,156,121,96,2,90,83,246,54,215,66,138,229,91,85,82,172,202,65,247,248,13,88,61,89,228,199,27,164,53,54,74,243,129,100,234,5,197,23,167,197,76,109,12,181,208,136,73,30,145,125,64,70,85,22,166,89,94,74,54,77,56,106,216,85,233,0,231,96,134,144,208,242,84,255,246,153,223,126,222,254,207,214,125,53,119,201,229,151,75,118,5,249,91,109,134,201,17,115,81,137,102,44,152,48,201,22,2,33,24,23,220,238,240,89,25,103,76,232,153,76,25,115,186,184,207,190,81,47,132,212,208,1,82,73,166,118,83,174,114,12,168,182,77,192,36,164,154,102,49,75,146,175,199,158,150,232,162,172,170,38,179,131,188,21,45,50,68,87,65,85,83,149,162,255,88,118,9,91,44,166,161,107,3,211,236,5,232,230,169,41,66,206,87,156,218,147,242,147,225,9,58,204,0,94,75,105,237,67,94,49,4,56,21,1,8,72,53,113,196,177,238,217,154,154,110,123,106,77,213,53,87,113,175,40,234,116,107,184,248,197,237,14,179,57,156,246,167,134,189,5,141,130,116,79,192,198,242,206,135,178,81,105,221,133,2,137,32,44,50,83,47,15,82,73,166,231,164,16,251,6,245,162,218,4,8,160,24,148,253,59,111,253,150,247,94,181,62,51,71,37,236,37,238,237,213,138,181,148,176,146,98,234,200,57,182,70,155,44,32,65,43,127,132,166,127,117,67,131,180,56,147,194,50,98,137,201,76,67,179,13,160,55,13,70,73,172,182,41,55,38,32,41,111,190,200,77,71,238,188,184,191,178,231,123,191,234,56,171,204,121,235,33,190,85,189,33,162,31,232,151,155,186,83,84,234,140,1,97,162,193,112,126,231,25,216,31,15,72,1,52,117,189,181,164,194,57,231,57,75,50,116,81,152,50,37,0,82,75,172,239,173,6,61,94,172,167,153,175,13,234,175,206,68,229,126,222,84,158,226,243,99,88,89,182,252,39,246,214,171,178,171,96,8,98,155,68,131,23,48,121,123,2,252,48,28,251,22,246,76,208,173,9,58,157,71,158,150,229,153,9,68,210,164,0,0,86,69,102,98,233,114,67,1,155,73,170,109,4,124,28,218,160,230,209,183,53,117,62,205,222,85,55,201,148,127,172,118,30,131,198,160,120,153,236,147,200,52,61,139,192,179,204,132,105,142,109,87,162,9,193,163,121,89,140,153,16,2,76,111,2,82,71,174,239,193,46,14,200,230,220,62,33,71,128,6,181,142,223,155,70,183,62,87,222,245,154,178,95,11,26,104,46,79,246,174,56,179,230,58,148,27,181,88,161,157,86,232,152,154,82,81,164,153,101,87,104,77,162,137,52,112,174,151,2,75,68,64,52,33,36,23,18,106,73,101,237,79,185,117,0,70,194,185,3,96,160,51,82,159,20,89,19,247,111,233,190,45,187,180,87,159,43,163,202,9,157,241,205,214,53,195,65,209,145,59,71,93,148,179,230,138,235,147,54,29,13,219,236,83,157,123,37,239,16,172,17,82,175,127,215,103,153,83,55,209,41,60,0,90,79,174,138,164,144,47,200,178,119,62,32,2,73,203,213,37,210,226,153,37,93,113,60,239,39,191,116,23,191,37,140,101,228,211,44,115,240,152,50,23,201,67,227,135,28,132,72,30,128,224,245,155,127,108,76,165,104,93,211,218,207,142,108,178,139,206,49,91,234,13,29,82,73,162,114,50,110,52,132,72,96,62,13,202,126,142,245,116,54,143,221,142,58,172,60,90,32,99,18,91,8,73,211,139,215,213,9,183,18,12,108,77,237,45,8,77,102,104,102,195,162,64,245,75,140,53,245,104,195,163,81,76,232,147,201,31,15,108,187,217,0,78,73,170,39,51,213,241,13,168,54,0,210,161,13,202,218,255,154,47,147,182,219,184,214,88,99,188,162,120,89,138,123,71,255,174,185,178,77,16,250,143,153,204,167,185,46,13,191,40,90,145,22,22,34,157,103,80,76,221,53,18,160,235,29,150,120,222,23,0,102,77,101,101,81,84,255,182,139,153,111,85,255,86,85,246,206,211,240,99,164,234,113,54,228,174,102,9,165,156,44,177,192,98,101,230,3,248,109,201,50,55,57,240,58,187,255,242,244,252,248,65,97,91,195,247,239,56,208,225,145,80,64,3,0,86,77,161,239,38,197,246,2,56,39,32,101,66,202,213,246,214,78,147,215,150,221,154,237,9,81,41,151,74,131,110,167,159,96,74,233,253,8,92,84,145,154,101,59,16,115,90,228,173,157,209,199,192,36,103,61,223,225,57,201,165,164,5,167,158,94,32,0,74,73,162,231,198,233,242,5,56,59,82,29,128,84,85,118,222,154,223,179,229,75,55,221,125,102,116,2,249,150,127,112,153,136,241,161,128,167,53,131,30,62,161,201,178,73,193,155,110,23,217,148,25,26,78,131,133,48,203,59,15,208,211,38,120,0,90,75,161,246,166,209,118,5,156,11,18,68,48,164,60,205,126,239,146,54,206,254,223,236,207,210,154,218,136,194,43,35,73,213,222,218,80,210,246,47,114,111,140,180,70,34,18,151,122,43,96,255,190,19,139,223,5,65,17,103,178,206,85,22,142,226,104,144,250,73,210,33,90,11,1,189,0,70,77,162,231,164,137,121,5,204,23,131,58,106,84,140,213,197,145,203,151,95,78,213,149,83,102,161,158,127,85,227,205,230,93,76,60,43,196,132,70,170,166,109,234,8,104,80,160,12,126,118,3,40,106,4,231,175,103,99,2,52,20,119,58,136,3,38,0,94,83,73,225,141,9,126,133,53,213,54,8,28,80,228,234,185,229,246,37,203,218,110,174,190,218,223,75,33,84,83,34,245,194,0,41,178,225,25,141,36,178,43,12,235,232,100,239,79,17,157,237,38,217,5,254,32,50,102,199,151,210,30,13,28,56,13,20,138,208,39,0,86,79,170,31,217,230,54,1,201,106,203,2,238,32,229,234,81,77,36,149,85,215,181,233,168,100,213,87,246,19,131,202,86,189,194,8,157,191,204,159,29,3,177,21,69,199,235,58,86,165,170,230,26,51,68,255,107,122,68,52,245,20,39,32,4,132,236,230,156,57,27,0,86,77,174,231,193,41,191,0,78,141,129,137,12,164,92,189,117,223,26,97,249,103,253,45,111,23,187,173,119,238,189,167,179,219,123,20,255,46,136,185,165,28,215,80,210,39,183,168,104,18,98,117,163,206,192,10,165,206,241,240,224,229,192,108,189,177,160,81,148,32,8,0,79,103,103,83,0,0,0,236,6,0,0,0,0,0,81,117,155,31,16,0,0,0,170,153,36,26,58,70,70,68,75,66,71,70,64,72,72,71,69,71,71,63,79,78,72,69,71,71,61,71,68,69,78,74,78,74,70,75,75,66,73,71,73,73,72,70,77,68,76,68,74,76,75,67,71,75,72,67,69,73,70,70,67,71,66,78,81,102,98,83,232,60,16,115,46,96,96,53,164,65,29,103,124,105,94,207,247,123,70,142,66,129,26,121,221,147,241,28,171,14,41,85,164,218,62,167,239,141,75,154,57,155,130,223,248,87,34,165,16,148,94,112,13,136,244,204,211,21,244,47,109,36,249,9,0,58,79,102,21,40,194,5,225,192,57,3,16,64,90,212,255,183,214,49,103,138,117,233,218,165,180,78,244,93,178,141,251,132,144,214,233,201,64,232,219,13,140,34,1,13,123,115,2,23,206,105,112,211,76,30,21,34,189,8,0,26,161,211,115,79,22,120,93,2,0,90,79,201,138,27,103,106,2,156,139,0,129,145,170,110,77,124,107,77,223,125,239,212,151,210,5,135,68,164,116,178,165,81,99,167,66,125,35,151,34,1,7,120,130,180,153,62,162,172,89,112,94,183,216,136,147,2,18,83,6,209,154,169,72,34,219,73,0,106,89,221,138,55,46,13,192,169,8,24,32,45,201,51,222,182,109,204,154,61,91,181,211,249,156,124,109,252,140,213,159,234,31,10,78,143,214,27,88,2,135,0,88,98,119,157,106,90,207,127,211,156,9,59,250,121,186,109,139,209,126,162,216,38,157,130,106])
.concat([137,238,54,235,227,32,0,86,77,98,2,12,50,1,206,117,2,227,144,170,158,219,72,107,83,191,229,58,82,137,247,18,130,14,134,46,101,127,188,122,57,187,179,201,248,39,44,4,140,55,144,32,112,99,51,254,4,79,70,55,81,30,83,33,152,62,46,30,4,165,167,7,0,90,81,162,47,113,120,197,228,164,78,45,160,166,52,164,65,221,243,144,218,244,102,139,110,77,33,27,180,41,26,223,116,171,189,201,230,22,101,212,126,21,104,19,84,0,101,217,204,249,90,250,28,82,176,17,144,45,201,147,223,13,82,206,152,110,74,181,217,244,211,1,78,85,98,21,12,117,0,56,151,28,152,4,130,92,238,146,186,21,223,60,145,18,105,200,172,235,107,173,173,148,45,165,184,195,211,113,37,13,160,224,134,117,180,246,22,48,150,245,73,95,134,66,33,124,47,1,121,82,157,30,154,218,6,231,138,37,155,112,240,0,70,79,102,27,152,186,34,224,188,4,78,64,76,213,115,41,107,138,183,201,221,215,172,60,195,74,76,52,196,78,127,86,62,28,88,105,189,64,196,129,202,14,142,125,250,108,180,178,237,21,96,62,96,34,105,177,201,38,28,121,54,210,78,7,62,81,108,11,32,222,192,22,39,9,38,13,100,188,152,249,19,139,202,255,115,155,61,61,149,186,210,104,77,167,239,69,191,141,246,207,186,82,1,39,22,129,146,34,97,238,116,73,206,115,56,197,147,144,165,208,106,243,63,64,118,97,249,250,212,10,146,224,114,201,61,0,78,81,108,234,198,169,17,97,205,105,72,8,160,230,170,203,117,255,178,110,77,235,179,44,98,150,103,118,197,162,105,121,225,216,113,90,47,23,223,251,10,128,118,179,76,116,60,227,66,10,152,20,1,195,189,114,21,238,128,217,65,19,82,87,102,41,190,23,212,135,3,0,106,85,229,138,15,77,223,0,206,101,1,75,9,26,228,236,88,210,106,109,155,39,242,180,125,195,233,242,55,12,26,81,106,60,201,48,6,43,64,136,198,222,0,211,122,9,138,140,149,100,55,92,185,52,83,10,38,121,148,180,100,199,21,42,224,44,237,78,44,49,1,90,85,233,196,221,211,180,181,77,212,212,249,128,218,129,42,207,72,223,26,179,46,191,229,188,205,65,102,103,5,219,238,141,190,79,138,33,177,49,113,251,16,104,176,77,211,117,2,91,180,152,72,0,209,155,236,215,20,251,69,201,116,239,55,81,164,51,230,1,78,81,102,213,73,51,47,96,66,181,1,1,2,210,160,249,54,147,199,58,123,60,121,76,38,118,181,161,16,226,148,197,153,254,72,6,27,249,89,7,68,139,236,26,195,56,232,79,85,165,225,108,2,29,40,143,206,207,149,37,166,89,107,186,195,180,166,59,23,77,0,54,85,108,21,164,58,0,156,170,0,0,82,229,62,209,109,53,215,190,228,77,103,84,179,159,186,150,164,45,83,228,39,184,245,53,204,228,117,18,230,32,104,8,135,243,109,176,171,159,118,74,26,102,189,68,120,101,110,49,11,199,24,118,133,174,116,205,103,177,82,0,86,83,201,170,33,2,199,38,156,138,14,164,4,85,233,30,199,254,100,243,156,154,103,13,21,195,162,179,240,31,169,187,223,210,166,142,158,170,224,167,226,246,27,135,7,130,94,245,80,250,67,2,26,159,37,137,44,103,215,81,131,225,0,94,87,109,226,198,0,128,115,49,57,3,40,114,75,118,91,164,51,214,175,233,127,253,91,173,79,208,202,220,102,11,99,4,147,115,34,111,113,195,181,248,171,97,65,8,28,80,202,13,97,250,73,155,144,70,19,74,168,176,102,184,53,231,174,73,215,137,120,216,210,137,199,109,131,239,72,152,0,0,94,85,73,223,143,164,1,150,156,147,68,3,132,162,60,243,202,191,173,98,105,35,95,251,99,237,133,89,115,145,208,219,161,20,53,199,88,68,244,203,241,227,73,12,96,43,154,69,122,105,229,52,44,27,240,132,166,132,196,233,35,231,200,28,121,105,133,115,141,200,66,87,36,26,146,225,153,0,82,87,174,231,67,2,0,213,99,170,116,191,31,156,237,77,143,221,92,190,152,207,115,27,140,165,130,150,26,52,228,83,35,175,107,70,236,204,156,184,101,149,125,103,48,36,162,116,208,241,204,236,151,93,83,124,151,242,238,148,107,2,95,49,71,211,91,134,229,42,33,160,86,91,161,111,3,0,112,174,0,167,133,162,106,186,175,83,209,78,191,60,71,162,10,172,127,154,130,86,141,193,24,154,207,88,245,158,140,191,18,193,119,27,33,113,127,10,77,253,130,252,6,20,130,164,67,111,157,74,40,51,211,153,109,193,182,88,211,56,0,62,83,98,10,4,7,64,178,218,2,224,249,65,42,55,247,45,108,169,137,46,59,247,52,150,201,206,85,191,77,82,244,60,231,114,180,67,29,74,63,14,66,228,21,169,168,195,19,145,38,155,195,163,59,168,179,37,70,22,93,210,255,204,160,57,230,74,26,37,139,0,86,81,110,106,73,234,96,9,170,173,0,141,131,76,229,134,189,245,84,158,199,109,78,213,14,247,85,98,137,138,49,106,83,8,29,182,125,255,153,184,95,219,47,196,193,222,32,38,32,228,121,82,189,212,167,41,130,16,12,139,73,117,252,158,192,117,153,109,24,9,0,102,91,173,231,161,233,19,20,168,182,0,56,135,84,101,19,177,188,81,113,61,177,166,90,103,253,254,235,37,127,46,40,202,92,123,228,180,236,96,46,134,29,96,62,248,153,2,36,91,196,212,39,1,180,153,197,153,44,56,21,0,90,89,109,106,225,106,7,112,46,0,183,172,33,85,217,228,139,144,238,235,175,219,150,70,255,176,55,43,29,21,215,136,53,184,215,44,205,171,52,157,75,52,87,63,131,209,68,152,180,78,184,1,5,6,26,174,148,117,151,76,173,129,69,23,54,125,63,77,251,189,21,62,87,98,2,132,158,1,156,27,3,2,72,149,155,223,223,200,218,165,102,109,126,75,94,79,100,88,2,140,140,201,50,105,92,52,77,20,141,129,115,109,62,110,0,212,217,246,18,40,13,1,132,57,166,67,167,19,174,126,197,244,112,234,84,148,238,178,1,82,85,161,111,147,56,0,84,91,4,60,128,194,85,207,239,127,99,153,227,251,47,75,164,170,164,203,65,130,219,12,239,76,58,153,1,235,19,174,51,117,205,15,72,141,154,65,168,82,225,134,10,27,3,128,142,104,121,100,240,126,122,29,63,59,109,77,215,1,82,83,233,170,27,128,0,147,106,107,52,19,14,212,169,60,159,227,140,251,27,123,118,111,82,159,245,91,172,190,238,104,190,210,43,44,57,37,5,215,208,236,143,173,10,241,201,161,208,99,227,253,3,88,78,121,128,18,155,40,20,255,126,210,60,195,39,171,93,74,108,4,34,58,84,180,3,0,82,81,97,234,38,29,8,48,62,71,32,224,192,162,153,203,94,221,154,47,247,110,61,61,219,115,229,181,42,13,176,210,130,207,182,14,202,127,93,231,51,251,243,160,131,43,222,7,193,233,0,1,30,4,149,73,247,135,150,82,129,48,151,148,20,221,119,6,221,176,251,172,233,0,94,87,195,212,7,77,69,48,41,153,115,17,8,21,48,130,242,60,86,181,71,147,111,255,125,185,85,255,173,155,128,12,195,126,180,23,174,229,28,33,132,243,227,2,130,145,128,4,164,5,19,146,37,64,151,211,167,236,162,226,23,155,186,45,103,175,83,21,9,27,89,26,165,165,90,16,75,3,94,83,73,223,155,164,99,197,40,56,23,9,96,4,201,77,205,246,233,151,180,181,121,243,188,169,143,86,198,230,141,52,67,69,95,91,178,236,13,161,209,86,170,80,120,207,87,176,50,32,94,5,96,49,0,75,194,56,202,165,3,209,233,189,9,250,201,30,203,194,48,221,105,0,58,81,234,0,0,34,176,127,46,2,14,136,41,39,238,237,44,173,166,110,169,233,99,243,104,104,210,160,191,56,225,37,186,183,247,54,84,255,72,115,33,197,115,156,54,50,97,115,252,22,248,199,194,169,33,21,111,110,27,131,35,161,207,89,138,101,135,235,45,0,46,73,120,213,70,68,14,88,219,170,30,227,170,55,251,92,117,61,139,254,237,112,167,106,58,27,31,92,161,239,5,251,246,208,177,163,238,84,27,239,45,251,161,102,27,75,230,212,206,217,184,80,124,234,80,148,208,26,126,106,189,239,6,204,66,161,161,225,9,119,255,205,149,163,0,94,79,161,231,77,83,153,129,229,169,20,48,66,34,139,92,182,102,147,137,230,203,179,253,251,45,21,117,50,209,21,177,187,201,43,169,137,152,97,166,175,167,9,231,198,78,110,96,78,22,142,134,235,125,194,125,5,186,212,127,150,92,20,66,172,92,160,71,210,89,199,53,74,55,3,86,77,166,175,144,38,128,201,228,157,27,192,42,32,85,89,215,205,50,149,210,239,233,48,169,32,51,139,100,219,54,141,245,254,58,88,29,193,53,133,163,88,188,136,221,144,32,128,4,174,166,243,214,94,57,113,243,79,193,100,228,67,135,65,222,4,86,79,162,166,18,16,44,97,62,215,64,180,161,10,4,174,220,200,210,82,170,237,86,41,103,81,232,240,242,128,4,103,95,13,182,103,115,18,58,136,226,202,174,247,70,128,236,160,129,126,218,41,186,198,20,97,206,214,92,182,180,8,249,94,162,237,245,133,172,55,117,72,0,74,79,144,193,233,66,71,200,242,252,4,41,128,84,181,150,118,97,110,75,179,78,44,227,129,2,147,226,129,90,248,69,212,44,80,4,125,27,54,21,35,160,134,166,55,22,27,255,196,48,157,34,189,198,12,156,44,215,201,59,99,94,17,153,89,216,118,108,106,10,29,66,79,168,162,29,145,201,138,165,245,41,18,88,115,80,171,218,52,237,218,52,169,190,230,246,104,45,139,246,25,238,146,177,21,167,145,184,50,213,224,53,231,34,213,199,16,44,50,241,26,40,16,180,208,155,238,239,211,244,76,104,125,128,156,22,25,155,150,93,113,90,74,0,70,79,162,7,0,21,216,174,182,5,136,15,98,169,60,143,254,220,106,177,52,85,239,18,109,168,224,34,175,52,97,154,175,169,206,193,113,125,66,93,170,168,104,21,211,110,52,20,9,143,7,117,93,225,48,205,191,238,82,160,43,230,5,205,137,64,117,211,1,141,61,128,14,78,79,194,219,52,115,63,40,38,156,139,0,116,131,162,114,107,139,197,147,220,167,191,175,235,178,114,204,57,55,238,27,177,148,235,125,24,168,240,249,5,143,198,21,15,122,201,98,128,6,239,39,232,218,52,151,187,217,9,206,34,139,136,160,118,129,186,8,117,206,167,9,90,81,206,218,164,58,117,192,169,2,156,65,81,53,205,186,213,209,190,253,118,251,93,211,58,11,189,215,233,79,25,170,126,205,117,78,50,91,191,230,72,14,172,32,176,49,12,54,5,0,129,87,184,41,254,234,77,10,61,13,154,46,35,35,88,142,47,135,167,0,70,81,34,90,184,233,210,129,238,60,5,64,229,160,242,146,93,159,247,225,127,191,255,245,75,164,180,187,244,222,38,173,187,120,220,236,165,76,237,115,172,240,29,242,35,132,89,162,177,17,178,227,21,147,99,206,165,48,132,57,27,148,200,250,82,215,48,247,151,131,251,213,196,234,124,79,15,66,85,194,218,152,250,218,1,167,48,36,14,209,42,119,107,190,169,138,227,201,174,91,132,253,249,136,55,103,90,208,71,121,148,88,36,186,54,149,107,190,26,0,35,104,144,18,226,192,235,125,122,203,45,185,179,92,4,228,92,9,51,81,12,68,147,9,0,78,81,134,27,238,230,175,11,108,168,182,28,224,129,209,170,121,139,61,139,55,159,106,215,108,222,237,185,189,213,105,233,31,166,23,43,148,57,197,100,46,154,223,244,74,0,102,26,232,185,46,128,182,109,194,23,180,94,155,205,164,125,115,46,109,51,234,34,125,59,70,131,201,73,21,0,66,85,68,107,50,92,95,170,85,85,179,181,68,233,110,239,207,187,29,227,123,100,63,159,198,51,183,217,89,94,188,138,176,216,254,73,159,176,47,112,147,223,188,70,79,116,243,60,144,136,121,6,95,161,20,169,236,207,130,193,111,150,88,46,90,197,38,3,66,79,72,187,57,125,189,76,80,53,167,52,128,132,86,121,54,199,86,237,102,127,42,234,173,229,187,23,251,217,249,77,247,186,108,117,170,49,143,91,28,48,182,32,56,200,81,19,20,139,8,201,65,185,235,81,128,8,74,125,9,233,117,205,236,79,192,14,171,52,93,208,57,29,70,85,42,218,164,233,181,67,211,51,169,94,84,158,83,133,194,150,190,79,247,93,171,163,46,206,93,57,155,88,106,139,202,196,26,151,207,212,82,4,237,110,45,70,99,0,86,240,96,194,54,189,160,17,210,28,47,70,228,244,16,162,217,223,223,133,144,140,2,148,36,71,88,187,128,0,74,79,202,59,73,245,107,134,61,145,115,17,32,118,40,42,207,109,206,252,217,182,236,222,207,241,94,253,40,223,157,94,106,71,177,124,248,75,244,128,14,150,189,238,140,118,30,10,236,75,152,139,32,65,162,44,79,103,104,6,143,228,44,57,247,163,8,162,174,101,112,16,61,76,0,86,81,73,97,161,196,235,5,88,158,42,32,14,104,153,220,167,218,181,17,125,159,139,75,118,94,208,123,47,230,210,209,101,238,213,23,34,6,91,205,138,122,45,128,73,1,131,222,47,104,172,68,215,21,14,112,238,2,232,35,38,122,153,124,59,116,0,66,73,42,107,40,245,56,64,162,218,66,2,17,11,40,220,138,218,98,204,54,233,254,221,83,246,172,95,146,253,95,213,250,179,217,243,78,201,101,149,57,115,204,102,138,33,96,229,50,132,209,65,74,38,184,241,109,194,174,197,2,48,102,162,214,42,47,235,56,175,0,86,75,73,173,161,212,185,18,53,142,86,251,4,79,138,80,228,234,132,106,210,28,91,31,89,150,182,230,77,178,51,67,73,221,38,223,75,4,36,220,159,1,215,116,240,85,7,112,43,75,246,171,121,139,20,27,249,47,125,130,160,160,80,36,197,143,221,245,197,230,123,43,85,144,0,78,87,174,175,184,168,65,172,140,159,201,169,6,8,1,105,106,58,218,36,165,91,215,76,223,119,100,154,46,60,58,39,176,72,215,3,205,30,117,80,40,240,173,193,2,254,54,182,135,13,58,75,210,4,69,111,180,206,233,109,121,154,236,34,205,110,241,208,176,174,1,0,70,83,194,42,46,174,76,152,12,243,173,234,113,233,113,120,19,113,231,240,160,111,92,243,216,252,205,30,37,116,216,46,213,248,177,18,115,67,224,120,210,46,39,92,141,6,188,64,67,243,162,149,6,88,100,112,255,132,252,223,212,95,151,219,68,1,0,58,83,40,114,247,208,154,152,88,207,115,174,230,206,234,138,255,69,252,59,48,50,28,102,71,153,254,99,234,37,235,138,22,15,99,122,149,145,208,144,43,132,136,24,7,43,54,91,4,232,44,75,111,76,99,6,80,28,97,22,113,101,177,124,185,200,129,121,0,74,81,198,27,136,43,21,166,204,199,36,242,252,205,139,29,198,179,95,255,198,181,50,94,4,250,39,249,78,35,47,5,115,179,118,238,122,243,72,151,100,207,81,135,235,104,77,189,199,228,9,88,40,111,81,79,37,8,12,143,245,245,198,206,162,164,54,38,83,169,5,170,0,66,75,194,74,49,47,76,32,87,109,147,128,0,178,200,181,239,106,157,54,102,153,173,127,162,132,37,216,41,75,163,47,126,96,99,242,27,110,195,35,19,238,112,213,24,199,89,128,247,167,3,20,52,109,66,73,7,96,39,226,45,29,2,129,246,86,40,156,7,0,90,73,193,218,105,174,116,152,140,94,181,229,0,42,131,152,68,217,237,138,118,118,109,246,61,255,242,53,166,184,243,221,103,42,196,43,198,138,128,183,30,181,62,200,174,220,50,139,199,178,35,61,110,189,113,154,22,107,51,157,151,74,43,10,250,107,240,78,113,0,74,71,194,26,150,190,172,90,39,175,218,10,32,128,152,170,115,90,82,83,115,174,221,45,251,37,102,208,173,86,245,204,105,45,43,22,186,239,110,177,74,1,44,1,51,160,4,161,129,92,79,197,135,83,144,105,201,218,108,208,211,36,157,248,86,160,1,82,81,9,247,104,124,217,1,152,79,149,123,223,235,121,40,142,93,11,121,48,94,60,220,249,92,194,95,140,252,173,231,212,158,49,195,239,193,214,232,0,98,48,18,19,151,174,81,72,64,211,238,192,43,29,56,149,139,109,24,90,98,173,57,119,40,115,9,101,19,0,74,75,76,26,197,188,90,5,203,171,182,5,44,129,161,169,117,159,105,205,49,183,186,105,78,43,175,26,146,173,149,45,66,84,71,169,223,24,139,180,152,28,80,180,52,9,14,208,70,182,210,145,24,10,185,1,235,20,151,120,174,35,245,127,116,0,79,103,103,83,0,4,74,45,7,0,0,0,0,0,81,117,155,31,17,0,0,0,213,164,93,230,33,72,73,72,70,67,75,75,74,69,72,69,73,72,74,69,77,79,67,73,69,69,75,70,75,75,71,71,67,70,71,75,77,71,78,71,206,218,78,190,76,85,162,253,209,205,23,85,191,190,83,170,202,65,245,207,242,86,190,142,73,190,74,165,84,168,47,46,58,68,242,89,208,241,251,67,6,34,96,130,250,56,175,120,212,45,171,193,109,253,236,222,70,51,76,1,47,103,106,22,65,145,173,117,71,2,70,71,8,185,177,48,179,117,91,141,207,153,216,39,129,194,85,214,152,250,158,219,127,205,218,111,95,215,118,165,168,106,173,91,59,246,233,238,82,80,43,117,118,202,142,224,8,56,214,109,150,110,244,98,106,2,111,150,169,233,83,107,26,193,210,136,214,5,22,235,16,136,7,74,73,70,122,52,97,153,96,221,183,112,138,65,144,21,136,41,215,236,157,99,91,243,53,110,255,212,246,199,98,43,119,90,46,61,22,21,171,190,6,250,145,138,64,39,234,13,87,116,99,128,174,142,131,54,92,144,78,9,165,9,80,11,116,56,141,73,158,169,19,38,9,82,75,68,58,197,125,75,4,125,74,207,205,1,86,5,98,170,54,103,155,226,120,162,226,151,247,205,52,34,155,229,41,10,84,249,47,115,122,176,93,58,233,34,246,145,10,211,141,64,244,5,73,128,82,16,51,171,219,60,140,60,117,222,208,77,65,80,40,4,0,66,77,152,195,220,119,140,160,165,57,45,1,177,6,212,212,127,83,59,182,252,248,253,215,18,175,6,23,247,24,111,157,91,138,74,193,174,104,116,44,2,109,13,18,54,26,3,7,28,177,11,98,91,164,40,128,193,54,59,109,49,244,238,71,181,130,14,86,89,134,42,98,97,102,72,202,170,182,6,106,161,134,149,205,121,126,77,155,170,105,127,243,127,215,102,47,127,91,82,146,221,198,76,221,130,126,39,176,68,39,32,58,45,35,56,80,60,80,238,128,132,192,65,60,125,161,205,40,103,110,105,238,185,51,129,48,47,8,231,204,6,0,74,87,4,41,72,72,79,8,113,110,28,62,2,150,201,205,35,63,250,168,58,222,244,73,149,210,253,136,145,201,203,101,96,54,128,151,16,73,189,155,172,139,37,1,7,20,62,125,101,160,1,253,116,72,3,122,145,188,8,12,114,178,43,218,137,145,224,92,53,158,36,245,204,126,30,62,75,200,107,152,111,165,96,175,250,85,187,4,164,132,54,213,108,43,110,231,254,143,138,53,42,45,126,252,110,43,41,175,138,118,179,82,44,85,187,169,66,243,243,2,1,48,39,18,243,202,1,180,87,122,88,156,217,222,107,178,57,65,122,50,148,174,203,92,107,211,146,63,0,66,73,192,21,70,158,10,171,222,72,245,161,234,157,242,191,186,242,90,184,249,80,168,56,141,244,20,53,114,80,99,206,51,147,218,36,241,52,216,155,20,70,18,76,190,157,37,229,41,165,2,169,132,185,220,20,57,224,121,93,144,165,63,116,12,23,169,0,0,86,73,73,116,6,229,11,13,90,118,79,3,18,1,205,146,107,214,254,150,47,215,93,255,166,109,154,89,51,57,161,199,9,55,49,139,226,17,244,64,31,229,126,217,2,118,184,43,73,35,183,198,202,17,188,255,102,68,102,250,114,209,121,147,45,157,119,190,139,99,64,2,70,79,76,218,74,155,85,0,213,179,165,114,89,229,171,170,103,93,93,248,50,109,62,29,103,97,95,79,55,159,185,97,111,30,94,175,181,226,114,53,222,147,21,205,156,221,37,200,179,210,106,104,36,157,105,182,207,50,92,189,76,107,78,215,1,225,22,233,2,98,75,137,246,83,226,75,7,80,255,85,27,128,36,160,168,186,116,239,178,174,183,117,187,231,121,122,214,188,163,201,183,179,242,251,215,165,74,168,139,34,27,254,211,0,11,173,59,38,160,140,123,104,232,208,91,39,172,237,173,117,234,233,138,152,115,130,251,225,160,79,52,0,94,77,169,247,104,237,53,3,40,191,106,35,192,4,16,51,213,103,125,106,189,126,207,183,222,226,204,218,37,94,44,57,171,250,46,162,126,187,53,134,5,231,65,31,181,66,161,19,100,193,201,203,2,127,192,77,20,253,27,190,79,32,35,90,234,160,160,123,102,107,102,3,62,81,36,218,193,92,91,176,186,122,189,40,243,195,138,250,126,252,239,102,230,120,11,21,142,62,205,178,16,221,36,155,9,171,134,34,83,39,106,225,146,248,28,152,155,82,35,187,71,131,186,187,72,113,83,131,47,243,123,116,223,150,52,136,37,61,193,116,138,166,112,132,108,0,78,75,138,58,149,206,63,19,232,142,83,67,192,43,36,173,234,145,79,191,61,141,227,147,71,60,75,246,254,158,166,93,122,62,16,98,137,80,44,247,61,104,100,221,163,41,15,208,172,238,118,130,58,13,29,63,235,119,128,164,155,205,233,96,106,198,144,152,0,98,85,165,246,22,21,254,116,152,106,169,115,11,200,16,146,180,205,172,99,217,214,102,121,179,212,228,125,87,22,222,111,134,85,169,62,225,167,216,19,219,6,235,109,100,209,180,209,78,71,46,131,34,53,171,129,122,128,158,26,240,142,43,144,206,235,24,108,116,27,139,28,163,218,54,73,7,82,83,10,59,61,67,107,130,61,157,115,174,1,2,72,155,243,252,186,197,154,125,191,153,236,239,75,109,210,219,69,16,57,36,183,135,105,196,124,146,101,219,40,169,45,17,199,55,44,113,20,152,63,36,225,145,104,180,16,124,118,114,23,212,207,236,82,36,163,211,33,191,246,6,179,84,29,161,0,62,73,76,75,209,190,71,183,53,172,158,158,231,3,169,168,151,63,42,171,166,131,81,241,178,240,177,207,133,222,49,246,159,78,30,22,219,232,66,89,140,165,103,250,2,20,32,133,51,0,71,228,152,51,199,154,222,121,122,224,244,36,233,114,167,145,0,90,81,4,184,153,239,50,35,196,169,6,200,87,144,114,11,221,158,153,116,180,191,109,187,190,84,177,174,236,239,105,79,47,224,126,183,133,1,51,60,229,228,89,13,76,217,97,162,134,108,5,79,4,30,24,75,251,2,109,112,179,120,177,155,42,232,97,170,153,8,191,160,0,86,77,12,161,225,187,116,148,187,247,115,181,79,96,169,129,84,53,182,167,53,218,119,233,111,79,37,103,138,151,82,191,134,161,248,165,138,121,1,155,211,120,216,1,109,42,208,97,166,234,62,72,209,70,194,149,177,134,180,44,148,110,130,94,240,138,184,14,0,58,87,148,80,136,239,156,177,106,155,83,155,32,54,53,180,202,243,126,27,190,202,211,223,4,35,209,163,239,38,46,87,253,76,233,35,143,154,77,121,167,49,129,201,195,123,28,51,105,104,26,58,33,142,190,158,162,205,10,170,136,196,6,105,61,177,67,147,0,86,81,14,43,54,57,228,128,136,222,90,109,105,192,174,129,228,90,114,218,35,208,175,109,164,181,169,148,171,67,234,193,76,92,142,148,74,57,146,225,10,198,154,9,187,99,122,14,78,26,18,208,33,81,144,101,57,155,22,130,227,110,127,72,5,55,75,135,68,174,205,217,107,132,4,78,71,4,57,83,194,54,33,187,223,65,181,245,1,91,5,169,234,95,172,169,84,218,126,255,101,177,184,82,101,138,16,241,44,165,233,93,189,194,74,9,148,30,36,158,166,109,42,112,212,10,87,20,122,52,153,132,156,156,8,173,137,192,18,234,131,149,121,93,0,82,83,134,120,136,225,113,181,186,52,213,86,192,227,171,32,213,244,189,157,154,153,51,239,254,255,200,151,134,121,18,93,175,111,127,246,187,98,114,87,135,246,93,7,123,6,128,15,105,192,14,17,222,204,238,240,147,174,72,29,80,75,4,87,184,107,125,230,51,55,201,82,211,75,7,82,73,10,188,117,244,221,186,77,147,188,106,43,48,218,129,152,106,254,218,101,226,121,186,245,182,159,107,37,246,80,150,40,191,126,233,183,74,249,67,98,2,195,3,41,3,208,129,176,255,101,192,1,57,196,188,222,156,122,35,238,18,71,88,136,78,58,104,225,10,180,241,40,10,0,94,85,134,184,83,249,94,23,32,125,106,128,75,160,85,221,151,201,170,220,215,179,89,151,85,180,210,18,53,51,61,179,161,24,223,229,20,193,183,137,91,78,19,191,37,144,133,6,13,61,206,101,106,186,73,103,122,174,43,87,168,252,236,234,157,174,41,214,55,14,0,70,71,132,186,169,190,243,64,65,215,186,243,61,46,0,180,92,189,50,233,118,253,155,237,189,218,20,21,66,248,196,59,7,235,156,249,138,131,27,133,229,169,163,49,42,155,66,33,64,2,148,134,173,122,78,150,6,231,18,10,76,40,56,110,62,211,227,54,74,77,1,70,85,4,121,180,242,237,23,236,181,244,124,171,250,243,236,180,211,72,87,229,120,33,190,87,101,254,177,55,217,24,232,139,28,167,156,56,7,225,38,7,74,87,76,26,144,44,12,45,145,178,129,231,224,90,47,247,220,159,108,115,69,248,203,244,22,0,70,75,74,26,42,248,110,147,165,61,87,223,124,203,85,191,157,119,136,155,243,95,183,233,122,91,217,15,17,127,113,33,200,165,246,160,50,217,57,226,53,210,10,36,102,143,96,31,128,240,183,114,59,202,165,162,209,138,39,20,66,11,154,210,10,220,140,162,49,1,46,81,26,115,60,180,39,168,90,39,109,173,22,79,85,195,249,231,123,99,249,103,206,59,123,167,187,199,194,110,41,70,236,113,241,194,200,37,93,28,168,210,186,141,0,50,160,144,104,247,152,34,32,8,23,142,240,38,249,40,237,50,185,147,137,27,54,251,29,9,0,70,83,4,52,130,235,62,172,67,245,86,75,142,174,126,186,60,237,52,95,43,190,188,216,45,138,149,42,53,208,98,49,53,55,174,38,8,235,6,243,127,172,27,69,72,253,167,240,154,192,49,83,42,232,150,72,83,92,26,33,218,5,132,106,244,84,122,63,124,21,140,155,139,38,0,94,87,37,182,100,114,236,11,34,156,3,8,128,170,84,93,102,105,215,165,210,175,111,119,79,229,121,53,243,155,74,136,101,53,242,220,146,215,28,9,214,3,104,33,101,11,130,243,31,49,188,163,23,128,62,244,157,10,92,209,97,176,80,232,98,209,38,230,213,61,243,186,217,235,239,8,0,38,61,1,41,234,226,218,94,88,246,90,151,249,66,71,145,20,201,235,187,99,206,126,125,113,47,95,30,51,120,222,147,174,178,92,196,108,223,187,192,92,68,179,200,188,172,192,123,18,0,216,207,123,18,247,238,121,192,141,11,158,46,58,175,151,121,144,55,15,5,28,97,116,116,114,105,98,117,116,101,32,118,101,99,52,32,118,116,120,99,111,111,114,100,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,117,110,105,102,111,114,109,32,118,101,99,50,32,115,117,98,116,101,120,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,103,108,95,80,111,115,105,116,105,111,110,46,120,121,32,61,32,118,116,120,99,111,111,114,100,46,120,121,32,42,32,50,46,48,32,45,32,118,101,99,50,40,49,46,48,44,32,49,46,48,41,59,32,103,108,95,80,111,115,105,116,105,111,110,46,122,32,61,32,48,46,48,59,32,103,108,95,80,111,115,105,116,105,111,110,46,119,32,61,32,49,46,48,59,32,112,111,115,32,61,32,118,116,120,99,111,111,114,100,46,120,121,32,42,32,115,117,98,116,101,120,59,32,125,0,0,117,110,105,102,111,114,109,32,115,97,109,112,108,101,114,50,68,32,115,97,109,112,108,101,114,59,32,118,97,114,121,105,110,103,32,118,101,99,50,32,112,111,115,59,32,118,111,105,100,32,109,97,105,110,40,118,111,105,100,41,32,123,32,103,108,95,70,114,97,103,67,111,108,111,114,32,61,32,116,101,120,116,117,114,101,50,68,40,115,97,109,112,108,101,114,44,32,112,111,115,41,59,32,125,84,104,105,115,32,103,97,109,101,32,117,115,101,115,32,99,101,114,116,97,105,110,32,116,104,105,114,100,32,112,97,114,116,121,32,99,111,100,101,44,32,108,105,98,114,97,114,105,101,115,44,32,97,117,100,105,111,32,97,110,100,10,102,111,110,116,115,46,32,84,104,101,32,108,105,99,101,110,115,101,115,32,102,111,114,32,116,104,101,115,101,32,97,114,101,32,108,105,115,116,101,100,32,98,101,108,111,119,46,10,10,61,79,112,101,110,71,76,32,77,97,116,104,101,109,97,116,105,99,115,32,40,71,76,77,41,10,10,104,116,116,112,58,47,47,103,108,109,46,103,45,116,114,117,99,46,110,101,116,47,10,10,84,104,101,32,77,73,84,32,76,105,99,101,110,115,101,10,10,67,111,112,121,114,105,103,104,116,32,40,99,41,32,50,48,48,53,32,45,32,50,48,49,51,32,71,45,84,114,117,99,32,67,114,101,97,116,105,111,110,10,10,80,101,114,109,105,115,115,105,111,110,32,105,115,32,104,101,114,101,98,121,32,103,114,97,110,116,101,100,44,32,102,114,101,101,32,111,102,32,99,104,97,114,103,101,44,32,116,111,32,97,110,121,32,112,101,114,115,111,110,32,111,98,116,97,105,110,105,110,103,10,97,32,99,111,112,121,32,111,102,32,116,104,105,115,32,115,111,102,116,119,97,114,101,32,97,110,100,32,97,115,115,111,99,105,97,116,101,100,32,100,111,99,117,109,101,110,116,97,116,105,111,110,32,102,105,108,101,115,32,40,116,104,101,10,34,83,111,102,116,119,97,114,101,34,41,44,32,116,111,32,100,101,97,108,32,105,110,32,116,104,101,32,83,111,102,116,119,97,114,101,32,119,105,116,104,111,117,116,32,114,101,115,116,114,105,99,116,105,111,110,44,32,105,110,99,108,117,100,105,110,103,10,119,105,116,104,111,117,116,32,108,105,109,105,116,97,116,105,111,110,32,116,104,101,32,114,105,103,104,116,115,32,116,111,32,117,115,101,44,32,99,111,112,121,44,32,109,111,100,105,102,121,44,32,109,101,114,103,101,44,32,112,117,98,108,105,115,104,44,10,100,105,115,116,114,105,98,117,116,101,44,32,115,117,98,108,105,99,101,110,115,101,44,32,97,110,100,47,111,114,32,115,101,108,108,32,99,111,112,105,101,115,32,111,102,32,116,104,101,32,83,111,102,116,119,97,114,101,44,32,97,110,100,32,116,111,10,112,101,114,109,105,116,32,112,101,114,115,111,110,115,32,116,111,32,119,104,111,109,32,116,104,101,32,83,111,102,116,119,97,114,101,32,105,115,32,102,117,114,110,105,115,104,101,100,32,116,111,32,100,111,32,115,111,44,32,115,117,98,106,101,99,116,32,116,111,10,116,104,101,32,102,111,108,108,111,119,105,110,103,32,99,111,110,100,105,116,105,111,110,115,58,10,10,84,104,101,32,97,98,111,118,101,32,99,111,112,121,114,105,103,104,116,32,110,111,116,105,99,101,32,97,110,100,32,116,104,105,115,32,112,101,114,109,105,115,115,105,111,110,32,110,111,116,105,99,101,32,115,104,97,108,108,32,98,101,10,105,110,99,108,117,100,101,100,32,105,110,32,97,108,108,32,99,111,112,105,101,115,32,111,114,32,115,117,98,115,116,97,110,116,105,97,108,32,112,111,114,116,105,111,110,115,32,111,102,32,116,104,101,32,83,111,102,116,119,97,114,101,46,10,10,84,72,69,32,83,79,70,84,87,65,82,69,32,73,83,32,80,82,79,86,73,68,69,68,32,34,65,83,32,73,83,34,44,32,87,73,84,72,79,85,84,32,87,65,82,82,65,78,84,89,10,79,70,32,65,78,89,32,75,73,78,68,44,32,69,88,80,82,69,83,83,32,79,82,32,73,77,80,76,73,69,68,44,32,73,78,67,76,85,68,73,78,71,32,66,85,84,32,78,79,84,10,76,73,77,73,84,69,68,32,84,79,32,84,72,69,32,87,65,82,82,65,78,84,73,69,83,32,79,70,32,77,69,82,67,72,65,78,84,65,66,73,76,73,84,89,44,10,70,73,84,78,69,83,83,32,70,79,82,32,65,32,80,65,82,84,73,67,85,76,65,82,32,80,85,82,80,79,83,69,32,65,78,68,10,78,79,78,73,78,70,82,73,78,71,69,77,69,78,84,46,32,32,73,78,32,78,79,32,69,86,69,78,84,32,83,72,65,76,76,32,84,72,69,32,65,85,84,72,79,82,83,32,79,82,10,67,79,80,89,82,73,71,72,84,32,72,79,76,68,69,82,83,32,66,69,32,76,73,65,66,76,69,32,70,79,82,32,65,78,89,32,67,76,65,73,77,44,32,68,65,77,65,71,69,83,10,79,82,32,79,84,72,69,82,32,76,73,65,66,73,76,73,84,89,44,32,87,72,69,84,72,69,82,32,73,78,32,65,78,32,65,67,84,73,79,78,32,79,70,10,67,79,78,84,82,65,67,84,44,32,84,79,82,84,32,79,82,32,79,84,72,69,82,87,73,83,69,44,32,65,82,73,83,73,78,71,32,70,82,79,77,44,32,79,85,84,32,79,70,10,79,82,32,73,78,32,67,79,78,78,69,67,84,73,79,78,32,87,73,84,72,32,84,72,69,32,83,79,70,84,87,65,82,69,32,79,82,32,84,72,69,32,85,83,69,32,79,82,10,79,84,72,69,82,32,68,69,65,76,73,78,71,83,32,73,78,32,84,72,69,32,83,79,70,84,87,65,82,69,46,10,10,61,79,103,103,32,86,111,114,98,105,115,32,73,32,97,117,100,105,111,32,100,101,99,111,100,101,114,32,45,45,32,118,101,114,115,105,111,110,32,48,46,57,57,57,57,54,10,10,104,116,116,112,58,47,47,110,111,116,104,105,110,103,115,46,111,114,103,47,115,116,98,95,118,111,114,98,105,115,47,10,10,87,114,105,116,116,101,110,32,105,110,32,65,112,114,105,108,32,50,48,48,55,32,98,121,32,83,101,97,110,32,66,97,114,114,101,116,116,44,32,115,112,111,110,115,111,114,101,100,32,98,121,32,82,65,68,32,71,97,109,101,32,84,111,111,108,115,46,10,10,80,108,97,99,101,100,32,105,110,32,116,104,101,32,112,117,98,108,105,99,32,100,111,109,97,105,110,32,65,112,114,105,108,32,50,48,48,55,32,98,121,32,116,104,101,32,97,117,116,104,111,114,58,32,110,111,32,99,111,112,121,114,105,103,104,116,32,105,115,10,99,108,97,105,109,101,100,44,32,97,110,100,32,121,111,117,32,109,97,121,32,117,115,101,32,105,116,32,102,111,114,32,97,110,121,32,112,117,114,112,111,115,101,32,121,111,117,32,108,105,107,101,46,10,10,78,111,32,119,97,114,114,97,110,116,121,32,102,111,114,32,97,110,121,32,112,117,114,112,111,115,101,32,105,115,32,101,120,112,114,101,115,115,101,100,32,111,114,32,105,109,112,108,105,101,100,32,98,121,32,116,104,101,32,97,117,116,104,111,114,32,40,110,111,114,10,98,121,32,82,65,68,32,71,97,109,101,32,84,111,111,108,115,41,46,32,82,101,112,111,114,116,32,98,117,103,115,32,97,110,100,32,115,101,110,100,32,101,110,104,97,110,99,101,109,101,110,116,115,32,116,111,32,116,104,101,32,97,117,116,104,111,114,46,10,10,61,67,105,114,99,108,101,49,68,58,32,65,32,108,97,109,101,32,50,68,32,34,80,104,121,115,105,99,115,34,32,69,110,103,105,110,101,10,10,104,116,116,112,58,47,47,116,104,112,46,105,111,47,50,48,49,51,47,99,105,114,99,108,101,49,100,47,10,10,67,111,112,121,114,105,103,104,116,32,40,99,41,32,50,48,49,51,44,32,84,104,111,109,97,115,32,80,101,114,108,46,10,65,108,108,32,114,105,103,104,116,115,32,114,101,115,101,114,118,101,100,46,10,10,82,101,100,105,115,116,114,105,98,117,116,105,111,110,32,97,110,100,32,117,115,101,32,105,110,32,115,111,117,114,99,101,32,97,110,100,32,98,105,110,97,114,121,32,102,111,114,109,115,44,32,119,105,116,104,32,111,114,32,119,105,116,104,111,117,116,10,109,111,100,105,102,105,99,97,116,105,111,110,44,32,97,114,101,32,112,101,114,109,105,116,116,101,100,32,112,114,111,118,105,100,101,100,32,116,104,97,116,32,116,104,101,32,102,111,108,108,111,119,105,110,103,32,99,111,110,100,105,116,105,111,110,115,32,97,114,101,10,109,101,116,58,10,10,49,46,32,82,101,100,105,115,116,114,105,98,117,116,105,111,110,115,32,111,102,32,115,111,117,114,99,101,32,99,111,100,101,32,109,117,115,116,32,114,101,116,97,105,110,32,116,104,101,32,97,98,111,118,101,32,99,111,112,121,114,105,103,104,116,10,32,32,32,110,111,116,105,99,101,44,32,116,104,105,115,32,108,105,115,116,32,111,102,32,99,111,110,100,105,116,105,111,110,115,32,97,110,100,32,116,104,101,32,102,111,108,108,111,119,105,110,103,32,100,105,115,99,108,97,105,109,101,114,46,10,50,46,32,82,101,100,105,115,116,114,105,98,117,116,105,111,110,115,32,105,110,32,98,105,110,97,114,121,32,102,111,114,109,32,109,117,115,116,32,114,101,112,114,111,100,117,99,101,32,116,104,101,32,97,98,111,118,101,32,99,111,112,121,114,105,103,104,116,10,32,32,32,110,111,116,105,99,101,44,32,116,104,105,115,32,108,105,115,116,32,111,102,32,99,111,110,100,105,116,105,111,110,115,32,97,110,100,32,116,104,101,32,102,111,108,108,111,119,105,110,103,32,100,105,115,99,108,97,105,109,101,114,32,105,110,32,116,104,101,10,32,32,32,100,111,99,117,109,101,110,116,97,116,105,111,110,32,97,110,100,47,111,114,32,111,116,104,101,114,32,109,97,116,101,114,105,97,108,115,32,112,114,111,118,105,100,101,100,32,119,105,116,104,32,116,104,101,32,100,105,115,116,114,105,98,117,116,105,111,110,46,10,10,84,72,73,83,32,83,79,70,84,87,65,82,69,32,73,83,32,80,82,79,86,73,68,69,68,32,66,89,32,84,72,69,32,67,79,80,89,82,73,71,72,84,32,72,79,76,68,69,82,83,10,65,78,68,32,67,79,78,84,82,73,66,85,84,79,82,83,32,34,65,83,32,73,83,34,32,65,78,68,32,65,78,89,32,69,88,80,82,69,83,83,32,79,82,10,73,77,80,76,73,69,68,32,87,65,82,82,65,78,84,73,69,83,44,32,73,78,67,76,85,68,73,78,71,44,32,66,85,84,32,78,79,84,32,76,73,77,73,84,69,68,32,84,79,44,10,84,72,69,32,73,77,80,76,73,69,68,32,87,65,82,82,65,78,84,73,69,83,32,79,70,32,77,69,82,67,72,65,78,84,65,66,73,76,73,84,89,32,65,78,68,10,70,73,84,78,69,83,83,32,70,79,82,32,65,32,80,65,82,84,73,67,85,76,65,82,32,80,85,82,80,79,83,69,32,65,82,69,32,68,73,83,67,76,65,73,77,69,68,46,10,73,78,32,78,79,32,69,86,69,78,84,32,83,72,65,76,76,32,84,72,69,32,67,79,80,89,82,73,71,72,84,32,79,87,78,69,82,32,79,82,10,67,79,78,84,82,73,66,85,84,79,82,83,32,66,69,32,76,73,65,66,76,69,32,70,79,82,32,65,78,89,32,68,73,82,69,67,84,44,32,73,78,68,73,82,69,67,84,44,10,73,78,67,73,68,69,78,84,65,76,44,32,83,80,69,67,73,65,76,44,32,69,88,69,77,80,76,65,82,89,44,32,79,82,32,67,79,78,83,69,81,85,69,78,84,73,65,76,10,68,65,77,65,71,69,83,32,40,73,78,67,76,85,68,73,78,71,44,32,66,85,84,32,78,79,84,32,76,73,77,73,84,69,68,32,84,79,44,10,80,82,79,67,85,82,69,77,69,78,84,32,79,70,32,83,85,66,83,84,73,84,85,84,69,32,71,79,79,68,83,32,79,82,32,83,69,82,86,73,67,69,83,59,32,76,79,83,83,10,79,70,32,85,83,69,44,32,68,65,84,65,44,32,79,82,32,80,82,79,70,73,84,83,59,32,79,82,32,66,85,83,73,78,69,83,83,10,73,78,84,69,82,82,85,80,84,73,79,78,41,32,72,79,87,69,86,69,82,32,67,65,85,83,69,68,32,65,78,68,32,79,78,32,65,78,89,32,84,72,69,79,82,89,32,79,70,10,76,73,65,66,73,76,73,84,89,44,32,87,72,69,84,72,69,82,32,73,78,32,67,79,78,84,82,65,67,84,44,32,83,84,82,73,67,84,32,76,73,65,66,73,76,73,84,89,44,10,79,82,32,84,79,82,84,32,40,73,78,67,76,85,68,73,78,71,32,78,69,71,76,73,71,69,78,67,69,32,79,82,32,79,84,72,69,82,87,73,83,69,41,10,65,82,73,83,73,78,71,32,73,78,32,65,78,89,32,87,65,89,32,79,85,84,32,79,70,32,84,72,69,32,85,83,69,32,79,70,32,84,72,73,83,10,83,79,70,84,87,65,82,69,44,32,69,86,69,78,32,73,70,32,65,68,86,73,83,69,68,32,79,70,32,84,72,69,32,80,79,83,83,73,66,73,76,73,84,89,32,79,70,10,83,85,67,72,32,68,65,77,65,71,69,46,10,10,61,57,48,32,98,111,117,110,99,105,110,103,32,115,116,114,105,110,103,115,32,119,105,116,104,32,102,105,101,108,100,10,10,98,121,32,83,110,97,112,112,101,114,52,50,57,56,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,83,110,97,112,112,101,114,52,50,57,56,47,115,111,117,110,100,115,47,49,54,49,52,52,48,47,10,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,67,67,48,32,49,46,48,32,85,110,105,118,101,114,115,97,108,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,112,117,98,108,105,99,100,111,109,97,105,110,47,122,101,114,111,47,49,46,48,47,10,10,61,108,111,111,112,32,109,101,100,105,116,97,116,105,111,110,115,32,110,111,32,100,114,117,109,115,10,10,98,121,32,83,117,98,45,100,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,83,117,98,45,100,47,115,111,117,110,100,115,47,52,57,57,48,48,47,10,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,67,67,48,32,49,46,48,32,85,110,105,118,101,114,115,97,108,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,112,117,98,108,105,99,100,111,109,97,105,110,47,122,101,114,111,47,49,46,48,47,10,10,61,106,117,115,116,107,105,100,100,105,110,103,10,10,98,121,32,97,108,118,101,103,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,97,108,118,101,103,47,115,111,117,110,100,115,47,54,57,50,53,56,47,10,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,67,67,48,32,49,46,48,32,85,110,105,118,101,114,115,97,108,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,112,117,98,108,105,99,100,111,109,97,105,110,47,122,101,114,111,47,49,46,48,47,10,10,61,80,101,114,99,32,76,111,111,112,32,35,50,10,10,98,121,32,107,97,115,97,57,48,10,104,116,116,112,58,47,47,102,114,101])
.concat([101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,107,97,115,97,57,48,47,115,111,117,110,100,115,47,49,54,50,49,50,52,47,10,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,67,67,48,32,49,46,48,32,85,110,105,118,101,114,115,97,108,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,112,117,98,108,105,99,100,111,109,97,105,110,47,122,101,114,111,47,49,46,48,47,10,10,61,67,67,32,66,89,32,51,46,48,32,83,111,117,110,100,32,69,102,102,101,99,116,115,10,10,84,104,101,32,102,111,108,108,111,119,105,110,103,32,115,111,117,110,100,32,101,102,102,101,99,116,115,32,97,114,101,32,108,105,99,101,110,115,101,100,32,97,115,58,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,65,116,116,114,105,98,117,116,105,111,110,32,51,46,48,32,85,110,112,111,114,116,101,100,32,40,67,67,32,66,89,32,51,46,48,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,108,105,99,101,110,115,101,115,47,98,121,47,51,46,48,47,10,10,98,117,116,116,111,110,99,104,105,109,101,48,50,117,112,32,98,121,32,74,117,115,116,105,110,66,87,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,74,117,115,116,105,110,66,87,47,115,111,117,110,100,115,47,56,48,57,50,49,47,10,10,66,117,116,116,111,110,32,67,108,105,99,107,32,48,49,32,98,121,32,70,97,116,115,32,77,105,108,108,105,111,110,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,70,97,116,115,37,50,48,77,105,108,108,105,111,110,47,115,111,117,110,100,115,47,49,56,55,55,56,49,47,10,10,102,101,110,100,101,114,32,116,101,108,101,99,97,115,116,101,114,32,116,111,103,103,108,101,32,115,119,105,116,99,104,32,40,51,32,119,97,121,41,32,98,121,32,83,104,111,116,103,117,110,80,105,99,107,101,114,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,83,104,111,116,103,117,110,80,105,99,107,101,114,47,115,111,117,110,100,115,47,49,51,50,55,49,56,47,10,10,48,54,48,55,48,49,66,32,98,121,32,70,114,101,101,100,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,70,114,101,101,100,47,115,111,117,110,100,115,47,51,48,49,55,47,10,10,74,66,70,32,80,108,121,119,111,111,100,32,66,114,101,97,107,105,110,103,32,98,121,32,99,109,117,115,111,117,110,100,100,101,115,105,103,110,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,99,109,117,115,111,117,110,100,100,101,115,105,103,110,47,115,111,117,110,100,115,47,57,54,49,54,55,47,10,10,61,67,67,32,83,97,109,112,108,105,110,103,43,32,83,111,117,110,100,32,69,102,102,101,99,116,115,10,10,84,104,101,32,102,111,108,108,111,119,105,110,103,32,115,111,117,110,100,32,101,102,102,101,99,116,115,32,97,114,101,32,108,105,99,101,110,115,101,100,32,97,115,58,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,83,97,109,112,108,105,110,103,32,80,108,117,115,32,49,46,48,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,108,105,99,101,110,115,101,115,47,115,97,109,112,108,105,110,103,43,47,49,46,48,47,10,10,95,119,111,111,100,32,98,121,32,98,97,110,116,104,97,32,98,114,97,105,110,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,98,97,110,116,104,97,37,50,48,98,114,97,105,110,47,115,111,117,110,100,115,47,52,52,51,57,53,47,10,10,51,49,32,80,97,115,115,111,115,80,105,115,111,67,104,195,163,111,66,97,116,105,100,111,32,115,108,111,119,101,114,32,98,121,32,76,101,111,115,115,111,109,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,76,101,111,115,115,111,109,47,115,111,117,110,100,115,47,49,54,57,54,51,53,47,10,10,61,67,67,48,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,32,83,111,117,110,100,32,69,102,102,101,99,116,115,10,10,84,104,101,32,102,111,108,108,111,119,105,110,103,32,115,111,117,110,100,32,101,102,102,101,99,116,115,32,97,114,101,32,108,105,99,101,110,115,101,100,32,97,115,58,10,67,114,101,97,116,105,118,101,32,67,111,109,109,111,110,115,32,45,32,67,67,48,32,49,46,48,32,85,110,105,118,101,114,115,97,108,32,40,80,117,98,108,105,99,32,68,111,109,97,105,110,41,10,104,116,116,112,58,47,47,99,114,101,97,116,105,118,101,99,111,109,109,111,110,115,46,111,114,103,47,112,117,98,108,105,99,100,111,109,97,105,110,47,122,101,114,111,47,49,46,48,47,10,10,115,116,117,100,115,32,109,111,108,110,32,118,49,32,98,121,32,115,105,109,111,110,46,114,117,101,10,104,116,116,112,58,47,47,102,114,101,101,115,111,117,110,100,46,111,114,103,47,112,101,111,112,108,101,47,115,105,109,111,110,46,114,117,101,47,115,111,117,110,100,115,47,52,57,57,54,51,47,10,10,61,83,111,117,114,99,101,32,83,97,110,115,32,80,114,111,32,83,101,109,105,45,66,111,108,100,10,10,104,116,116,112,115,58,47,47,103,105,116,104,117,98,46,99,111,109,47,97,100,111,98,101,47,115,111,117,114,99,101,45,115,97,110,115,45,112,114,111,47,10,10,67,111,112,121,114,105,103,104,116,32,50,48,49,48,44,32,50,48,49,50,32,65,100,111,98,101,32,83,121,115,116,101,109,115,32,73,110,99,111,114,112,111,114,97,116,101,100,10,40,104,116,116,112,58,47,47,119,119,119,46,97,100,111,98,101,46,99,111,109,47,41,44,32,119,105,116,104,32,82,101,115,101,114,118,101,100,32,70,111,110,116,32,78,97,109,101,32,39,83,111,117,114,99,101,39,46,10,10,65,108,108,32,82,105,103,104,116,115,32,82,101,115,101,114,118,101,100,46,10,10,83,111,117,114,99,101,32,105,115,32,97,32,116,114,97,100,101,109,97,114,107,32,111,102,32,65,100,111,98,101,32,83,121,115,116,101,109,115,32,73,110,99,111,114,112,111,114,97,116,101,100,32,105,110,32,116,104,101,10,85,110,105,116,101,100,32,83,116,97,116,101,115,32,97,110,100,47,111,114,32,111,116,104,101,114,32,99,111,117,110,116,114,105,101,115,46,10,10,84,104,105,115,32,70,111,110,116,32,83,111,102,116,119,97,114,101,32,105,115,32,108,105,99,101,110,115,101,100,32,117,110,100,101,114,32,116,104,101,32,83,73,76,32,79,112,101,110,32,70,111,110,116,32,76,105,99,101,110,115,101,44,10,86,101,114,115,105,111,110,32,49,46,49,58,32,104,116,116,112,58,47,47,115,99,114,105,112,116,115,46,115,105,108,46,111,114,103,47,79,70,76,10,10,61,66,108,97,99,107,98,101,114,114,121,32,80,108,97,121,98,111,111,107,32,79,112,101,110,71,76,32,69,83,32,50,46,48,32,116,101,109,112,108,97,116,101,10,10,79,110,32,66,108,97,99,107,98,101,114,114,121,32,84,97,98,108,101,116,32,79,83,32,97,110,100,32,66,108,97,99,107,98,101,114,114,121,32,49,48,44,32,112,108,97,116,102,111,114,109,32,105,110,116,101,103,114,97,116,105,111,110,10,105,110,99,108,117,100,101,115,32,99,111,100,101,32,102,114,111,109,32,116,104,101,32,79,112,101,110,71,76,32,69,83,32,50,46,48,32,116,101,109,112,108,97,116,101,58,10,10,67,111,112,121,114,105,103,104,116,32,40,99,41,32,50,48,49,49,45,50,48,49,50,32,82,101,115,101,97,114,99,104,32,73,110,32,77,111,116,105,111,110,32,76,105,109,105,116,101,100,46,10,10,76,105,99,101,110,115,101,100,32,117,110,100,101,114,32,116,104,101,32,65,112,97,99,104,101,32,76,105,99,101,110,115,101,44,32,86,101,114,115,105,111,110,32,50,46,48,32,40,116,104,101,32,34,76,105,99,101,110,115,101,34,41,59,10,121,111,117,32,109,97,121,32,110,111,116,32,117,115,101,32,116,104,105,115,32,102,105,108,101,32,101,120,99,101,112,116,32,105,110,32,99,111,109,112,108,105,97,110,99,101,32,119,105,116,104,32,116,104,101,32,76,105,99,101,110,115,101,46,10,89,111,117,32,109,97,121,32,111,98,116,97,105,110,32,97,32,99,111,112,121,32,111,102,32,116,104,101,32,76,105,99,101,110,115,101,32,97,116,10,10,104,116,116,112,58,47,47,119,119,119,46,97,112,97,99,104,101,46,111,114,103,47,108,105,99,101,110,115,101,115,47,76,73,67,69,78,83,69,45,50,46,48,10,10,85,110,108,101,115,115,32,114,101,113,117,105,114,101,100,32,98,121,32,97,112,112,108,105,99,97,98,108,101,32,108,97,119,32,111,114,32,97,103,114,101,101,100,32,116,111,32,105,110,32,119,114,105,116,105,110,103,44,32,115,111,102,116,119,97,114,101,10,100,105,115,116,114,105,98,117,116,101,100,32,117,110,100,101,114,32,116,104,101,32,76,105,99,101,110,115,101,32,105,115,32,100,105,115,116,114,105,98,117,116,101,100,32,111,110,32,97,110,32,34,65,83,32,73,83,34,32,66,65,83,73,83,44,10,87,73,84,72,79,85,84,32,87,65,82,82,65,78,84,73,69,83,32,79,82,32,67,79,78,68,73,84,73,79,78,83,32,79,70,32,65,78,89,32,75,73,78,68,44,10,101,105,116,104,101,114,32,101,120,112,114,101,115,115,32,111,114,32,105,109,112,108,105,101,100,46,32,83,101,101,32,116,104,101,32,76,105,99,101,110,115,101,32,102,111,114,32,116,104,101,32,115,112,101,99,105,102,105,99,32,108,97,110,103,117,97,103,101,10,103,111,118,101,114,110,105,110,103,32,112,101,114,109,105,115,115,105,111,110,115,32,97,110,100,32,108,105,109,105,116,97,116,105,111,110,115,32,117,110,100,101,114,32,116,104,101,32,76,105,99,101,110,115,101,46,10,10,61,83,68,76,32,49,46,50,10,10,79,110,32,77,101,101,71,111,32,49,46,50,32,72,97,114,109,97,116,116,97,110,44,32,112,108,97,116,102,111,114,109,32,105,110,116,101,103,114,97,116,105,111,110,32,108,105,110,107,115,32,100,121,110,97,109,105,99,97,108,108,121,10,97,103,97,105,110,115,116,32,83,68,76,32,49,46,50,32,112,114,111,118,105,100,101,100,32,98,121,32,116,104,101,32,115,121,115,116,101,109,58,10,10,103,105,116,58,47,47,103,105,116,111,114,105,111,117,115,46,111,114,103,47,104,97,114,109,97,116,116,97,110,45,115,100,108,47,115,100,108,46,103,105,116,10,104,116,116,112,115,58,47,47,103,105,116,104,117,98,46,99,111,109,47,104,97,114,109,97,116,116,97,110,47,104,97,114,109,97,116,116,97,110,45,115,100,108,10,10,84,104,105,115,32,108,105,98,114,97,114,121,32,105,115,32,100,105,115,116,114,105,98,117,116,101,100,32,117,110,100,101,114,32,71,78,85,32,76,71,80,76,32,118,101,114,115,105,111,110,32,50,44,32,119,104,105,99,104,32,99,97,110,32,98,101,10,102,111,117,110,100,32,105,110,32,116,104,101,32,102,105,108,101,32,32,34,67,79,80,89,73,78,71,34,46,32,32,84,104,105,115,32,108,105,99,101,110,115,101,32,97,108,108,111,119,115,32,121,111,117,32,116,111,32,117,115,101,32,83,68,76,10,102,114,101,101,108,121,32,105,110,32,99,111,109,109,101,114,99,105,97,108,32,112,114,111,103,114,97,109,115,32,97,115,32,108,111,110,103,32,97,115,32,121,111,117,32,108,105,110,107,32,119,105,116,104,32,116,104,101,32,100,121,110,97,109,105,99,10,108,105,98,114,97,114,121,46,10,10,104,116,116,112,115,58,47,47,119,119,119,46,103,110,117,46,111,114,103,47,108,105,99,101,110,115,101,115,47,108,103,112,108,45,50,46,49,46,104,116,109,108,10,10,61,83,68,76,32,83,119,105,112,101,32,67,111,110,116,114,111,108,10,10,79,110,32,77,101,101,71,111,32,49,46,50,32,72,97,114,109,97,116,116,97,110,44,32,112,108,97,116,102,111,114,109,32,105,110,116,101,103,114,97,116,105,111,110,32,105,110,99,108,117,100,101,115,32,99,111,100,101,10,102,114,111,109,32,116,104,101,32,83,119,105,112,101,67,111,110,116,114,111,108,32,108,105,98,114,97,114,121,58,10,10,83,68,76,32,83,119,105,112,101,32,67,111,110,116,114,111,108,32,99,108,97,115,115,32,102,111,114,32,72,97,114,109,97,116,116,97,110,32,83,68,76,32,49,46,50,32,112,114,111,106,101,99,116,115,10,67,111,112,121,114,105,103,104,116,32,40,99,41,32,50,48,49,49,44,32,50,48,49,51,32,84,104,111,109,97,115,32,80,101,114,108,32,60,116,104,112,46,105,111,47,97,98,111,117,116,62,10,104,116,116,112,58,47,47,116,104,112,46,105,111,47,50,48,49,49,47,115,119,105,112,101,99,111,110,116,114,111,108,47,10,10,0,0,0,0,0,0,0,79,103,103,83,0,2,0,0,0,0,0,0,0,0,81,164,57,46,0,0,0,0,21,109,50,66,1,30,1,118,111,114,98,105,115,0,0,0,0,1,34,86,0,0,0,0,0,0,128,62,0,0,0,0,0,0,170,1,79,103,103,83,0,0,0,0,0,0,0,0,0,0,81,164,57,46,1,0,0,0,57,252,122,41,14,59,255,255,255,255,255,255,255,255,255,255,255,255,154,3,118,111,114,98,105,115,43,0,0,0,88,105,112,104,46,79,114,103,32,108,105,98,86,111,114,98,105,115,32,73,32,50,48,49,50,48,50,48,51,32,40,79,109,110,105,112,114,101,115,101,110,116,41,0,0,0,0,1,5,118,111,114,98,105,115,34,66,67,86,1,0,8,0,0,128,32,10,25,198,128,208,144,85,0,0,16,0,0,66,136,70,198,80,167,148,4,151,130,133,16,71,196,80,135,144,243,80,106,233,32,120,74,97,201,152,244,20,107,16,66,8,223,123,207,189,247,222,123,32,52,100,21,0,0,4,0,64,24,5,14,98,224,49,9,66,8,161,24,197,9,81,156,41,8,66,8,97,57,9,150,114,30,58,9,66,247,32,132,16,46,231,222,114,238,189,247,30,8,13,89,5,0,0,2,0,48,8,33,132,16,66,8,33,132,16,66,10,41,165,20,82,138,41,166,152,98,202,49,199,28,115,204,49,200,32,131,12,58,232,164,147,78,50,169,164,147,142,50,201,168,163,212,90,74,45,197,20,83,108,185,197,88,107,173,53,231,220,107,80,202,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,8,66,67,86,1,0,32,0,0,132,65,6,25,100,16,66,8,33,133,20,82,138,41,166,28,115,204,49,199,128,208,144,85,0,0,32,0,128,0,0,0,0,71,145,20,201,145,28,201,145,36,73,178,36,75,210,36,207,242,44,207,242,44,79,19,53,81,83,69,85,117,85,219,181,125,219,151,125,219,119,117,217,183,125,217,118,117,89,151,101,89,119,109,91,151,117,87,215,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,32,52,100,21,0,32,1,0,160,35,57,142,35,57,142,35,57,146,35,41,146,2,132,134,172,2,0,100,0,0,4,0,224,40,142,226,56,146,35,57,150,99,73,150,164,73,154,229,89,158,229,105,158,38,106,162,7,132,134,172,2,0,0,1,0,4,0,0,0,0,0,160,40,138,226,40,142,35,73,150,165,105,154,231,169,158,40,138,166,170,170,162,105,170,170,170,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,64,104,200,42,0,64,2,0,64,199,113,28,199,81,28,199,113,28,201,145,36,9,8,13,89,5,0,200,0,0,8,0,192,80,20,71,145,28,203,177,36,205,210,44,207,242,52,209,51,61,87,148,77,221,212,85,27,8,13,89,5,0,0,2,0,8,0,0,0,0,0,192,241,28,207,241,28,79,242,36,207,242,28,207,241,36,79,210,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,128,208,144,85,0,0,2,0,0,32,136,66,134,49,32,52,100,21,0,0,4,0,128,16,162,145,49,212,41,37,193,165,96,33,196,17,49,212,33,228,60,148,90,58,8,158,82,88,50,38,61,197,26,132,16,194,247,222,115,239,189,247,30,8,13,89,5,0,0,1,0,16,70,129,131,24,120,76,130,16,66,40,70,113,66,20,103,10,130,16,66,88,78,130,165,156,135,78,130,208,61,8,33,132,203,185,183,156,123,239,189,7,66,67,86,1,0,128,0,0,12,66,8,33,132,16,66,8,33,132,144,66,74,41,133,148,98,138,41,166,152,114,204,49,199,28,115,12,50,200,32,131,14,58,233,164,147,76,42,233,164,163,76,50,234,40,181,150,82,75,49,197,20,91,110,49,214,90,107,205,57,247,26,148,50,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,130,208,144,85,0,0,8,0,0,97,144,65,6,25,132,16,66,72,33,133,148,98,138,41,199,28,115,204,49,32,52,100,21,0,0,8,0,32,0,0,0,192,81,36,69,114,36,71,114,36,73,146,44,201,146,52,201,179,60,203,179,60,203,211,68,77,212,84,81,85,93,213,118,109,223,246,101,223,246,93,93,246,109,95,182,93,93,214,101,89,214,93,219,214,101,221,213,117,93,215,117,93,215,117,93,215,117,93,215,117,93,215,117,29,8,13,89,5,0,72,0,0,232,72,142,227,72,142,227,72,142,228,72,138,164,0,161,33,171,0,0,25,0,0,1,0,56,138,163,56,142,228,72,142,229,88,146,37,105,146,102,121,150,103,121,154,167,137,154,232,1,161,33,171,0,0,64,0,0,1,0,0,0,0,0,40,138,162,56,138,227,72,146,101,105,154,230,121,170,39,138,162,169,170,170,104,154,170,170,170,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,166,105,154,38,16,26,178,10,0,144,0,0,208,113,28,199,113,20,199,113,28,71,114,36,73,2,66,67,86,1,0,50,0,0,2,0,48,20,197,81,36,199,114,44,73,179,52,203,179,60,77,244,76,207,21,101,83,55,117,213,6,66,67,86,1,0,128,0,0,2,0,0,0,0,0,112,60,199,115,60,199,147,60,201,179,60,199,115,60,201,147,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,77,211,52,32,52,100,37,0,0,4,0,128,32,199,180,131,36,9,132,160,130,228,25,196,28,196,164,25,133,160,130,228,58,6,37,197,228,33,167,160,98,228,57,201,152,65,228,130,210,69,166,34,8,13,89,17,0,68,1,0,0,198,32,198,16,115,200,57,39,165,147,20,57,231,164,116,82,26,8,161,165,142,82,103,169,180,90,98,204,40,149,218,82,173,13,132,142,82,72,45,163,84,98,45,173,118,212,74,173,37,182,2,0,0,2,28,0,0,2,44,132,66,67,86,4,0,81,0,0,132,49,72,41,164,20,98,140,57,200,28,68,140,49,232,24,100,134,49,6,33,115,78,65,199,28,133,84,42,7,29,117,80,82,195,24,115,142,65,168,160,131,84,58,71,149,131,80,82,71,157,0,0,128,0,7,0,128,0,11,161,208,144,21,1,64,156,0,128,65,146,52,205,210,52,207,179,52,207,243,60,81,84,85,79,20,85,213,18,61,211,244,76,83,85,61,211,84,85,83,53,101,87,84,77,89,182,60,209,52,61,211,84,85,207,52,85,85,52,85,217,53,77,213,117,61,85,181,101,211,85,117,89,116,85,221,118,109,217,183,93,89,22,110,79,85,101,91,84,93,91,55,85,87,214,85,89,182,125,87,182,109,95,18,69,85,21,85,213,117,61,85,117,93,213,117,117,219,116,93,93,247,84,85,118,77,215,149,101,211,117,109,217,117,101,91,87,101,89,248,53,85,149,101,211,117,109,217,116,93,217,118,101,87,183,85,89,214,109,209,117,125,93,149,101,225,55,101,217,247,101,91,215,125,89,183,149,97,116,93,219,87,101,89,247,77,89,22,126,217,150,133,221,213,117,95,152,68,81,85,61,85,149,93,81,85,93,215,116,93,91,87,93,215,182,53,213,148,93,211,117,109,217,84,93,89,86,101,89,247,93,87,214,117,77,85,101,217,148,101,219,54,93,87,150,85,89,246,117,87,150,117,91,116,93,93,55,101,89,248,85,87,214,117,87,183,141,99,182,109,95,24,93,87,247,77,89,214,125,85,150,117,95,214,117,97,152,117,219,215,53,85,213,125,83,118,125,225,116,101,93,216,125,223,24,102,93,23,142,207,117,125,95,149,109,225,88,101,217,248,117,225,23,150,91,215,133,223,115,93,95,87,109,217,24,86,217,54,134,221,247,141,97,246,125,227,88,117,219,24,102,91,55,186,186,78,24,126,97,56,110,223,56,170,182,45,116,117,91,88,94,221,54,234,198,79,184,141,223,168,169,170,175,155,174,107,252,166,44,251,186,172,219,194,112,251,190,114,124,174,235,251,170,44,27,191,42,219,194,111,235,186,114,236,190,79,249,92,215,23,86,89,22,134,213,150,133,97,214,117,97,217,133,97,169,218,186,50,188,186,111,28,175,173,43,195,237,11,141,223,87,134,170,109,27,203,171,219,194,48,251,182,240,219,194,111,28,187,177,51,6,0,0,12,56,0,0,4,152,80,6,10,13,89,17,0,196,9,0,88,36,201,243,44,203,18,69,203,178,68,81,52,69,85,21,69,81,85,45,77,51,77,77,243,76,83,211,60,211,52,77,83,117,69,211,84,93,75,211,76,83,243,52,211,212,60,205,52,77,213,116,85,211,52,101,83,52,77,215,53,85,211,118,69,85,149,101,213,149,101,89,117,93,93,22,77,211,149,69,213,116,101,211,84,93,89,117,93,87,86,93,87,150,37,77,51,77,205,243,76,83,243,60,211,52,85,211,149,77,83,117,93,203,243,84,83,243,68,211,245,68,81,85,85,83,85,93,83,85,101,87,243,60,83,245,68,79,53,61,81,84,85,211,53,101,213,84,85,89,54,85,211,150,77,83,149,101,211,85,109,217,85,101,87,150,93,217,182,77,85,149,101,83,53,93,217,116,93,215,118,93,215,118,93,217,21,118,73,211,76,83,243,60,211,212,60,79,53,77,83,117,93,83,85,93,217,242,60,213,244,68,81,85,53,79,52,85,85,85,93,215,52,85,87,182,60,207,84,61,81,84,85,77,212,84,211,116,93,89,86,85,83,86,69,213,180,101,85,85,117,217,52,85,89,118,101,217,182,93,213,117,101,83,85,93,217,84,93,89,54,85,83,118,93,87,182,185,178,42,171,158,105,202,178,169,170,182,108,170,170,236,202,182,109,235,174,235,234,182,168,154,178,107,154,170,108,171,170,170,187,178,107,235,190,44,203,182,44,170,170,235,154,174,42,203,166,170,202,182,44,203,186,46,203,182,176,171,174,107,219,166,234,202,186,43,203,116,89,181,93,223,246,109,186,234,186,182,175,202,174,175,187,178,108,235,174,237,234,178,110,219,190,239,153,166,44,155,170,41,219,166,170,202,178,44,187,182,109,203,178,47,140,166,233,218,166,171,218,178,169,186,178,237,186,174,174,203,178,108,219,162,105,202,178,169,186,174,109,170,166,44,203,178,108,251,178,44,219,182,234,202,186,236,218,178,237,187,174,44,219,178,109,11,187,236,10,179,175,186,178,173,187,178,109,11,171,171,218,182,236,219,62,91,87,117,85,0,0,192,128,3,0,64,128,9,101,160,208,144,149,0,64,20,0,0,96,12,99,140,65,104,148,114,206,57,8,141,82,206,57,7,33,115,14,66,8,169,100,206,65,8,161,164,204,57,8,165,164,148,57,7,161,148,148,66,8,165,164,212,90,8,161,148,148,90,43,0,0,160,192,1,0,32,192,6,77,137,197,1,10,13,89,9,0,164,2,0,24,28,71,211,76,211,117,101,217,24,22,203,18,69,85,149,101,219,54,134,197,178,68,81,85,101,217,182,133,99,19,69,85,149,101,219,214,117,52,81,84,85,89,182,109,221,87,142,83,85,101,217,182,125,93,56,50,85,85,150,109,91,215,125,35,85,150,109,91,215,133,161,146,42,203,182,109,235,190,81,73,182,109,93,55,134,227,168,36,219,182,238,251,190,113,44,241,133,161,176,44,149,240,149,95,56,42,129,0,0,240,4,7,0,160,2,27,86,71,56,41,26,11,44,52,100,37,0,144,1,0,0,24,164,148,81,74,41,163,148,82,74,41,198,148,82,140,9,0,0,24,112,0,0,8,48,161,12,20,26,178,34,0,136,2,0,0,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,4,0,236,68,56,0,236,68,88,8,133,134,172,4,0,194,1,0,0,132,20,130,146,82,41,165,148,18,57,231,164,148,82,74,41,165,148,200,65,8,165,148,82,74,41,165,68,210,73,41,165,148,82,74,41,165,113,80,74,41,165,148,82,74,41,161,148,82,74,41,165,148,82,74,9,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,41,165,148,82,74,1,0,38,15,14,0,80,9,54,206,176,146,116,86,56,26,92,104,200,74,0,32,55,0,0,80,138,57,198,36,148,144,74,72,37,132,16,74,229,24,132,206,73,9,41,181,86,66,10,173,132,10,58,104,157,163,144,82,75,173,149,148,74,73,153,132,16,66,40,161,132,82,90,41,37,181,82,50,8,161,132,80,74,8,33,165,82,74,9,161,101,80,66,10,37,148,148,82,73,45,180,84,74,201,32,132,80,90,9,169,149,212,90,10,37,149,148,65,41,169,132,146,82,42,173,181,148,74,74,173,131,210,82,41,173,181,214,74,74,33,149,150,82,7,165,164,150,82,41,165,181,22,74,107,173,181,78,82,41,45,164,214,82,107,173,149,86,74,41,157,165,148,74,73,173,181,150,90,107,41,165,86,66,41,173,180,210,90,41,37,181,214,82,107,45,149,212,90,75,173,165,214,82,107,173,165,214,74,41,37,165,150,90,107,173,181,150,90,42,41,181,148,66,41,165,149,146,66,106,169,165,214,74,42,45,132,208,82,73,165,149,86,90,107,41,165,148,74,40,37,149,148,90,42,169,181,150,82,104,165,133,210,74,73,37,165,150,74,42,41,165,212,82,42,161,148,18,82,42,161,149,212,82,107,169,165,150,74,42,45,181,212,82,43,169,148,150,74,74,169,20,0,0,116,224,0,0,16,96,68,165,133,216,105,198,149,71,224,136,66,134,9,40,0,0,16,4,0,24,136,144,153,64,160,0,10,12,100,0,192,1,66,130,20,0,80,88,96,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,6,0,24,136,144,153,0,161,24,34,36,100,3,192,4,69,133,116,0,176,184,192,40,93,232,130,16,34,72,23,65,22,15,92,56,113,227,137,27,78,232,208,2,1,0,0,0,0,192,1,0,31,0,0,7,6,16,17,209,92,134,198,6,71,135,199,7,72,136,8,0,0,0,0,0,0,0,0,0,0,0,128,79,103,103,83,0,0,0,172,0,0,0,0,0,0,81,164,57,46,2,0,0,0,126,118,238,236,87,81,70,63,28,28,77,70,34,29,27,89,71,66,47,29,30,41,34,26,20,15,75,74,76,68,74,65,46,32,30,28,28,76,68,62,39,31,29,33,29,27,26,25,75,76,67,30,28,28,26,22,19,20,98,73,71,42,34,32,31,29,29,27,28,69,73,77,69,70,60,57,27,30,26,24,84,75,32,31,26,92,75,66,44,23,25,74,86,103,222,90,56,97,2,157,110,245,204,212,204,251,11,67,229,92,127,206,227,231,76,247,234,175,255,59,229,84,67,118,168,51,136,167,241,52,68,3,3,122,179,24,92,151,24,140,56,75,131,187,18,93,146,146,244,130,227,194,36,70,44,136,136,216,19,38,230,195,219,200,146,31,218,50,180,124,26,84,0,58,103,210,154,212,80,98,7,141,231,139,170,95,29,223,243,168,186,126,220,173,247,99,26,126,22,167,25,138,18,36,217,9,42,118,210,131,38,113,179,194,188,24,118,24,10,143,143,93,237,177,7,26,184,91,125,149,121,116,112,105,143,26,246,8,84,255,32,18,0,46,65,162,169,245,49,188,2,230,149,78,110,206,175,244,247,226,200,245,110,133,24,187,173,159,61,137,61,198,110,27,106,0,108,64,199,30,106,170,160,6,72,188,207,80,76,186,206,141,171,192,154,249,181,101,230,53,128,245,184,112,32,1,38,75,221,89,212,195,26,0,142,9,67,132,9,0,0,72,195,55,49,249,18,147,231,87,102,169,165,0,34,75,155,61,21,79,13,152,176,1,0,224,244,63,207,49,249,246,114,159,175,199,174,165,237,105,65,4,62,57,213,8,0,0,170,151,146,138,115,247,191,56,119,46,110,191,254,250,155,247,198,251,220,253,23,228,63,158,105,62,119,60,87,167,226,190,127,157,178,190,50,113,252,49,202,249,29,199,63,19,235,43,247,212,253,235,68,62,191,227,24,223,42,30,154,98,186,144,138,169,123,66,211,125,2,82,67,118,7,0,3,176,39,47,69,100,31,244,249,122,188,190,228,248,193,239,123,144,213,195,200,153,222,141,149,6,34,225,45,218,188,11,9,0,236,152,237,75,98,153,55,153,237,243,40,226,141,69,125,188,46,186,119,150,121,243,218,62,15,67,112,41,20,205,4,54,71,236,42,214,97,1,160,90,146,32,193,49,0,128,107,164,253,168,247,104,207,254,215,100,216,182,163,232,93,126,81,21,0,34,75,225,86,141,203,216,0,170,101,4,194,56,0,0,60,171,201,55,127,241,63,214,70,120,219,227,60,1,30,75,227,73,213,167,1,128,99,2,8,7,0,0,196,227,201,146,118,89,174,38,95,242,143,2,0,34,65,214,73,140,149,206,132,234,37,233,44,153,167,123,183,91,154,135,31,31,197,202,61,60,142,244,221,92,238,81,147,58,146,251,51,150,98,254,86,117,53,126,33,199,156,241,173,170,244,170,115,88,40,10,185,177,122,99,142,57,152,26,37,29,179,43,12,82,93,13,127,147,146,41,197,252,173,170,84,127,134,75,161,100,40,117,27,1,50,95,219,14,52,94,46,32,239,12,196,124,72,169,50,171,205,226,254,230,237,118,204,247,30,219,4,196,154,58,14,194,130,221,219,174,188,204,137,130,43,182,194,8,3,147,225,194,10,59,102,96,228,15,92,67,99,112,233,166,222,160,14,169,83,102,148,152,1,178,1,34,71,19,71,135,219,79,191,194,200,242,12,34,198,113,170,169,250,60,105,247,214,217,104,207,181,78,213,216,130,232,49,252,34,108,208,253,24,118,134,97,3,32,25,131,221,118,1,85,60,7,235,132,14,184,247,182,19,29,231,185,182,78,151,104,60,26,73,250,43,132,211,214,0,161,106,73,143,156,0,73,88,11,152,155,35,207,210,151,183,237,150,178,46,129,93,240,20,56,48,12,198,224,124,152,221,1,123,0,176,222,1,0,18,75,225,170,214,97,55,0,243,0,0,216,10,254,76,199,143,60,18,159,151,11,143,145,240,74,223,86,0,26,75,227,137,138,183,1,76,56,113,103,227,98,24,0,64,93,19,182,231,191,164,38,229,147,70,79,0,84,1,10,77,201,25,0,0,84,167,35,0,96,47,186,201,170,211,43,71,227,248,98,97,64,2,181,184,92,215,72,110,105,107,184,180,53,92,218,130,155,37,1,22,75,155,13,99,105,32,193,60,29,0,192,117,44,235,172,207,206,191,122,120,121,190,35,179,219,24,79,235,8,137,237,217,41,30,75,143,169,79,7,32,193,60,0,0,132,147,61,221,171,16,207,167,125,84,189,45,248,1,0,30,75,223,16,1,192,195,2,0,0,218,208,85,71,226,182,206,103,189,0,34,75,191,16,1,192,67,5,0,0,184,124,215,174,1,26,95,7,2,104,226,19,232,45,157,79,110,234,184,219,47,95,223,155,231,89,125,124,238,254,251,207,77,201,255,255,127,153,113,106,42,142,191,255,127,31,43,67,224,199,247,73,140,22,112,250,37,198,183,194,2,192,184,242,201,35,131,80,49,41,252,133,214,192,138,206,130,68,41,14,74,117,125,14,132,228,1,58,234,121,130,76,146,33,85,53,247,165,219,178,38,101,109,255,78,202,24,86,60,189,11,182,154,74,155,196,158,36,176,203,209,95,27,54,41,165,149,134,190,30,70,175,164,38,100,229,153,250,12,22,253,81,156,66,248,106,112,64,108,242,76,5,179,4,66,115,21,6,110,133,14,26,87,47,169,122,183,15,250,49,62,234,116,88,222,195,211,209,107,164,148,110,166,16,9,15,9,45,154,21,92,105,145,183,78,35,28,137,196,99,145,199,218,206,92,43,206,18,75,18,20,109,198,162,98,170,215,195,54,202,134,232,164,70,63,40,6,202,119,0,66,103,22,192,230,28,160,240,157,73,67,75,72,138,202,76,237,212,180,79,157,173,125,109,86,113,33,253,20,242,85,240,61,187,109,143,64,78,196,103,17,40,186,44,107,29,236,198,176,27,1,172,161,41,222,234,247,232,0,176,249,138,69,51,41,166,48,12,50,85,26,9,106,27,106,134,185,229,124,102,38,101,192,197,76,174,253,179,20,229,215,215,237,171,51,191,249,94,166,176,150,118,84,209,121,177,154,198,53,143,32,152,209,48,224,3,8,48,223,59,192,230,67,135,177,169,182,157,4,168,130,239,97,236,65,178,65,39,77,237,52,0,54,67,32,4,253,56,99,71,164,19,159,8,19,132,68,170,210,169,30,207,214,79,206,237,141,232,226,226,86,171,168,95,253,192,176,175,193,15,59,29,235,116,151,224,107,151,52,63,2,205,170,23,124,21,9,10,80,124,153,67,163,186,93,26,0,54,73,226,78,8,219,221,65,150,73,181,36,88,184,128,72,8,131,26,87,247,62,223,30,199,210,31,121,186,120,218,166,104,181,226,192,48,224,18,20,248,64,13,18,208,0,38,77,236,67,215,203,179,0,108,96,0,224,253,195,80,26,185,254,28,247,213,80,225,228,186,240,167,116,242,241,236,0,46,75,225,94,228,180,7,128,19,65,4,105,51,0,0,104,30,235,222,63,149,210,236,207,147,29,61,117,106,0,42,75,229,157,26,182,27,0,199,36,144,38,1,0,64,251,121,186,119,222,242,63,35,101,31,139,27,0,30,75,229,85,13,203,13,128,147,207,165,115,9,0,0,14,142,172,155,238,80,111,243,101,118,124,242,0,46,87,5,168,210,244,86,173,210,116,190,36,87,247,246,163,207,93,162,112,251,165,126,241,170,234,157,177,250,47,243,149,39,150,111,49,90,165,81,136,129,85,26,207,135,22,127,242,169,206,126,106,43,234,0,104,171,204,151,97,208,5,251,201,5,132,202,222,9,52,84,172,226,98,210,0,46,91,91,65,140,167,38,23,48,124,103,210,145,14,138,173,134,38,142,219,94,53,183,112,92,139,174,113,32,150,71,205,229,109,233,181,44,2,36,21,128,164,233,210,26,80,230,58,82,124,108,4,30,120,230,240,46,128,131,151,87,5,151,192,70,123,136,4,38,69,197,168,134,219,13,64,186,90,194,145,185,33,148,37,215,80,203,93,147,253,255,154,148,239,19,231,94,164,184,50,1,187,226,210,4,192,215,192,110,81,130,82,4,151,52,54,20,2,147,113,49,219,192,121,115,181,6,74,13,0,26,75,240,33,78,75,59,1,156,184,11,153,112,50,0,112,92,99,201,103,233,150,182,155,35,235,22,173,71,23,164,89,202,6,9,214,96,2,0,26,75,225,86,140,219,30,0,230,25,0,192,94,234,99,152,175,119,122,254,83,56,252,27,179,106,38,245,102,2,0,18,75,233,85,136,143,5,128,99,2,8,7,6,0,48,229,205,251,231,147,221,214,254,49,156,49,229,68,2,30,75,155,29,165,223,0,14,170,229,36,194,128,1,0,28,141,102,235,158,107,60,123,183,164,143,100,153,200,102,72,2,0,22,75,187,53,165,30,0,19,170,37,193,152,0,0,0,42,29,253,50,235,99,109,118,233,100,168,74,240,0,22,75,167,25,220,0,14,78,132,97,9,0,0,96,238,158,148,207,179,166,239,54,147,44,68,45,5,26,75,207,6,10,64,130,19,55,72,151,0,0,160,110,102,106,166,77,85,33,183,216,167,52,1,22,75,111,202,0,192,195,6,0,0,21,157,21,198,246,239,75,245,225,197,83,241,181,20,1,94,111,90,2,129,79,160,113,245,52,185,22,239,47,12,23,230,126,31,22,190,126,140,149,239,223,13,54,130,84,151,121,100,73,61,92,255,97,19,124,204,103,165,137,160,215,225,187,58,226,96,76,57,98,172,32,36,115,242,126,75,190,9,122,42,164,104,1,77,197,86,234,66,168,3,86,109,24,131,37,216,12,122,64,30,38,100,120,152,228,201,245,87,127,223,146,171,245,188,254,41,77,61,178,122,144,195,176,12,67,58,179,8,253,230,97,143,95,196,48,187,192,162,93,180,12,192,10,167,79,18,133,228,82,160,243,36,161,184,229,230,86,61,209,33,158,34,54,81,53,1,54,61,44,168,250,244,100,199,224,165,230,165,51,205,220,95,123,174,156,247,149,131,125,125,45,12,133,119,177,51,213,181,184,113,97,39,198,101,7,240,176,184,172,198,108,240,128,113,241,222,64,152,117,205,238,248,112,84,175,138,14,24,90,103,77,122,0,50,77,195,173,24,134,53,0,156,8,48,38,4,0,0,150,209,102,253,236,123,251,172,249,179,87,31,88,244,2,26,75,203,94,215,167,1,128,99,90,130,37,28,0,0,142,155,217,179,249,146,43,182,38,251,225,2,0,34,75,151,179,200,9,96,193,49,53,129,116,14,0,0,179,164,39,159,153,43,29,221,156,214,195,8,0,14,75,111,0,0,0,199,4,248,52,0,0,128,89,231,201,218,201,98,233,143,62,218,221,86,3,30,75,223,16,1,192,193,6,0,0,236,118,126,255,175,191,76,99,55,97,20,0,34,75,191,16,1,192,195,17,128,4,0,0,32,145,168,60,45,41,6,30,73,159,5,127,0,240,112,12,32,1,0,0,64,226,41,71,11,29,0,30,65,184,243,65,232,187,243,200,174,94,120,102,73,245,181,234,85,255,157,31,245,229,172,242,118,168,188,237,205,52,169,142,35,185,174,67,177,193,159,216,96,54,213,210,42,184,85,24,252,41,139,97,150,106,182,170,121,43,234,86,193,253,196,124,64,219,216,27,83,77,153,106,54,76,55,75,78,213,188,25,46,109,13,151,182,130,219,26,221,86,112,63,49,39,56,58,0,62,89,171,1,36,59,39,208,180,122,81,211,46,30,60,254,139,242,191,195,83,193,41,166,98,99,234,67,110,202,154,133,120,41,89,231,250,99,167,156,86,28,217,61,82,88,136,78,43,154,229,54,8,76,38,154,202,153,149,206,39,6,76,222,216,166,3,175,13,130,156,29,0,42,71,219,165,16,150,117,206,72,54,84,79,85,245,93,31,227,103,127,138,245,197,31,61,156,138,159,122,84,201,142,117,170,167,9,169,191,100,87,128,54,12,75,29,115,176,195,6,9,151,195,64,21,38,123,212,184,76,192,100,108,40,0,99,246,168,241,38,87,213,1,34,73,189,75,53,22,55,39,224,68,146,113,144,67,7,16,6,137,37,219,163,178,172,205,206,105,55,6,144,47,98,126,151,183,66,50,139,8,20,208,101,3,22,73,249,94,15,167,5,128,141,1,0,92,239,23,163,15,255,156,43,204,95,46,247,89,221,191,110,153,46,91,23,157,119,19,22,75,250,39,134,101,220,0,118,6,0,208,95,57,62,28,222,23,182,190,124,61,184,173,84,18,171,115,66,163,6,0,22,75,240,10,97,27,39,128,19,105,66,36,28,0,0,18,79,190,63,125,182,159,182,35,187,41,203,161,55,198,2,14,77,236,94,136,219,27,0,27,0,0,174,247,247,247,170,195,61,168,88,143,156,139,183,247,53,101,123,1,14,75,201,85,136,143,5,128,99,26,67,195,1,0,0,117,55,115,76,127,173,154,180,228,125,41,117,19,0,14,75,237,68,235,31,0,112,76,26,30,66,2,0,0,60,177,185,181,241,239,179,38,239,3,85,0,22,75,235,29,21,62,0,22,156,152,5,194,0,0,0,243,171,175,223,43,34,38,239,143,244,184,136,0,30,97,220,218,64,244,4,198,175,218,20,4,158,160,72,167,190,71,138,234,27,101,187,103,183,179,89,253,51,137,251,83,198,213,63,196,65,137,184,63,176,160,14,117,252,226,141,9,104,235,111,4,25,96,127,5,192,126,114,21,176,208,241,121,149,186,23,180,2,82,111,58,251,96,52,87,208,225,158,7,184,129,76,53,107,125,214,118,153,233,155,103,79,154,105,98,18,50,204,100,202,97,218,17,47,31,44,27,100,118,245,51,240,146,185,184,225,9,166,186,68,3,172,3,175,39,34,152,197,28,161,3,153,9,209,109,243,240,69,110,52,0,50,109,188,114,2,21,15,208,204,185,1,50,5,167,168,150,38,149,89,226,118,219,191,179,63,219,244,247,54,24,121,125,4,91,91,123,108,135,69,144,109,183,169,65,211,48,46,141,25,96,29,121,9,235,154,242,189,92,50,98,12,29,241,108,211,128,250,162,154,12,49,184,66,210,121,56,0,34,99,162,239,4,90,79,84,154,158,82,56,36,75,82,83,249,207,177,180,179,54,237,241,116,75,44,186,182,152,201,212,116,27,231,34,77,184,160,214,183,8,234,98,12,8,83,47,128,81,144,88,85,128,200,250,97,194,175,191,220,226,132,228,11,138,83,167,1,26,87,161,231,195,80,117,7,29,250,83,130,3,210,86,207,54,243,76,246,164,58,68,59,125,246,84,78,166,157,232,101,218,175,123,23,156,78,131,27,224,131,175,47,218,228,48,134,115,251,128,213,131,81,105,245,217,11,58,200,94,110,52,0,254,27,84,245,197,232,30,75,93,244,224,50,86,177,132,59,242,137,57,30,192,188,202,172,121,52,253,250,28,53,31,77,26,252,82,160,20,108,9,128,94,247,178,13,80,60,151,64,128,221,234,128,178,41,224,71,240,37,0,48,110,121,54,0,232,0,30,71,235,210,86,195,138,248,180,4,164,78,4,16,128,102,16,97,247,228,237,196,210,76,114,164,110,40,152,5,174,6,232,124,40,96,24,96,92,96,241,173,2,176,7,130,175,241,55,220,65,13,207,6,187,53,0,34,75,231,197,91,157,0,17,54,6,0,8,135,162,92,184,126,123,68,12,113,50,119,33,23,23,0,38,75,151,179,143,157,128,118,103,56,129,100,45,192,0,0,230,80,221,58,113,171,182,180,81,111,231,4,92,2,30,75,119,131,219,7,160,229,8,142,9,32,1,0,0,216,29,121,171,201,147,74,226,87,67,0,30,75,143,169,55,0,68,120,128,39,0,0,0,187,35,133,243,158,72,67,246,1,0,0,46,59,23,18,0,0,80,189,240,82,10,187,243,229,94,246,185,251,47,196,237,215,247,198,251,220,57,249,143,231,44,191,159,233,148,245,231,79,226,190,114,91,231,183,156,30,0,74,196,93,185,173,243,219,250])
.concat([252,81,62,29,249,136,81,198,194,111,235,252,81,62,70,249,99,66,153,184,43,119,220,249,45,95,50,21,13,62,57,91,35,0,0,120,56,11,8,146,151,148,45,111,187,52,149,229,123,126,95,254,251,218,21,70,134,52,109,129,33,49,121,85,251,188,217,190,154,4,128,78,129,164,46,186,164,185,232,241,102,251,241,102,125,100,145,55,22,73,194,198,235,170,144,76,221,212,20,33,223,121,83,7,42,73,213,157,170,79,55,27,80,45,225,12,19,7,0,128,224,108,243,239,77,191,95,191,31,89,226,213,194,219,121,8,26,75,248,67,141,167,113,2,168,14,0,128,211,215,62,14,79,63,223,245,240,242,148,127,204,235,77,244,162,30,0,22,75,230,86,140,167,53,0,44,0,0,236,43,166,242,216,99,174,16,183,117,249,166,248,181,0,18,65,73,20,73,48,65,154,51,65,34,92,202,82,152,37,5,213,229,71,187,186,237,221,25,175,233,160,32,219,202,221,26,254,25,254,25,254,25,254,25,191,201,223,228,111,242,23,43,197,74,177,82,172,20,115,49,103,156,113,69,169,171,64,6,25,54,166,115,110,197,170,186,26,254,25,255,198,111,252,198,159,241,27,127,198,60,126,227,52,77,0,14,91,98,202,208,170,154,65,67,181,176,164,102,144,154,153,71,253,151,39,171,38,123,150,55,111,203,171,79,145,87,72,42,218,103,123,198,203,30,110,75,53,220,75,184,237,120,31,238,237,108,205,174,123,95,30,47,230,12,185,187,151,7,40,102,101,100,3,40,151,183,140,128,74,0,26,73,167,45,218,102,208,89,194,121,213,82,27,150,198,212,92,89,154,159,39,45,245,77,251,223,186,79,1,222,197,123,60,42,133,224,188,194,34,51,115,135,27,151,194,121,205,27,76,80,52,104,177,166,239,128,78,119,174,23,125,102,5,222,38,120,22,75,247,41,101,147,166,224,91,182,197,39,194,32,93,208,50,2,144,60,41,73,125,106,183,188,162,235,144,196,172,36,96,205,135,14,168,1,195,184,113,107,116,0,30,75,223,192,1,160,132,185,10,0,64,127,122,214,254,188,218,235,97,218,160,82,0,30,75,191,32,1,32,135,99,128,135,65,5,0,192,221,17,193,21,111,159,134,142,128,36,0,94,103,56,3,33,204,160,147,173,158,153,106,158,139,124,49,221,251,241,170,120,186,112,59,220,31,47,17,78,137,100,152,91,223,138,14,254,24,234,161,206,126,18,163,108,209,192,130,197,40,151,14,56,197,41,84,190,219,152,124,34,91,133,73,42,13,117,88,0,101,124,197,164,79,79,103,103,83,0,0,0,74,1,0,0,0,0,0,81,164,57,46,3,0,0,0,116,10,110,51,79,77,68,29,26,27,25,24,21,20,82,75,71,51,32,27,75,79,63,18,16,78,78,75,71,68,67,96,38,37,34,32,78,69,68,35,34,69,81,36,34,32,31,79,77,70,39,34,33,32,31,29,28,28,75,72,61,36,32,33,30,27,27,26,81,84,78,70,73,65,100,44,37,36,31,75,78,75,74,71,82,107,156,128,69,233,3,38,29,186,122,202,211,188,220,247,12,7,103,63,207,77,31,183,70,134,131,191,238,209,172,68,42,46,164,10,11,182,129,119,118,236,81,83,124,48,198,48,88,143,149,53,166,89,129,94,38,1,139,250,136,167,217,35,58,133,154,183,65,242,128,221,112,179,221,116,10,54,63,196,168,245,182,233,96,244,230,121,170,153,215,95,187,30,57,120,156,42,14,55,179,119,105,182,189,132,216,143,108,197,48,222,243,254,46,0,51,60,162,15,27,0,108,176,250,4,252,118,213,232,232,224,183,75,13,124,141,75,5,64,130,94,86,160,0,50,75,243,89,143,105,45,0,213,18,64,26,7,0,128,25,79,150,142,84,222,125,107,50,156,157,176,5,0,30,75,203,94,213,219,0,192,2,0,192,233,107,239,177,225,244,121,113,248,197,193,71,118,13,0,22,75,251,181,200,3,0,28,83,59,30,4,0,0,136,249,57,34,171,116,95,190,126,137,252,11,0,26,75,31,137,8,0,58,28,19,64,193,1,0,0,51,94,201,147,71,83,249,145,175,59,0,26,75,127,142,2,128,4,199,28,8,0,0,0,117,247,230,173,227,141,179,239,175,212,1,30,75,191,96,0,64,130,35,106,176,27,0,0,192,47,201,67,123,248,180,5,30,73,159,11,22,0,36,56,34,192,18,0,0,128,156,196,154,167,89,0,30,69,232,233,143,18,236,162,132,234,133,174,164,76,95,187,112,120,238,243,177,35,213,119,142,175,103,1,180,185,161,78,110,210,113,107,19,111,184,158,252,103,19,173,214,83,91,177,104,61,255,108,162,13,0,63,155,120,195,245,212,22,85,151,218,132,170,75,157,137,130,232,71,233,68,161,77,178,121,105,146,0,50,97,135,59,224,164,29,32,87,189,104,234,244,60,118,250,162,124,119,228,227,241,25,71,199,206,223,87,169,167,95,62,52,215,41,142,255,234,38,181,100,61,186,54,169,118,108,76,114,136,11,131,48,7,161,63,36,234,160,126,81,178,152,77,144,38,137,232,128,57,7,235,224,5,29,26,75,91,78,143,219,77,135,121,253,206,220,51,151,96,56,87,117,220,231,204,110,207,49,191,37,207,159,254,82,199,50,47,36,107,240,225,41,122,185,40,193,195,19,96,12,176,216,218,54,187,121,80,99,140,55,108,88,247,95,67,6,58,180,64,193,47,74,28,14,0,26,69,241,86,173,167,13,128,51,53,25,234,52,134,168,12,105,126,150,44,175,39,235,159,181,190,170,241,152,135,147,23,41,107,46,141,129,49,2,9,172,171,192,7,172,19,95,3,160,77,10,22,75,226,94,13,219,218,0,78,4,73,38,64,0,0,130,166,91,167,17,233,237,174,108,244,210,20,45,23,9,208,1,10,75,230,82,12,143,5,128,5,0,128,211,23,167,114,213,222,185,152,127,182,112,45,45,111,139,6,54,105,180,50,208,162,31,160,105,245,82,76,243,222,248,80,31,31,223,95,253,57,59,87,239,92,203,239,214,28,51,14,92,121,74,248,124,136,49,10,49,38,159,15,148,70,105,41,243,215,86,87,64,29,171,96,124,200,99,28,48,74,141,21,94,229,185,128,224,95,203,163,5,90,0,38,111,177,176,25,98,206,152,70,63,210,115,0,82,214,137,76,174,185,228,181,198,251,59,186,243,182,221,214,32,172,55,65,205,168,168,159,19,246,155,192,178,13,54,19,144,89,124,131,7,87,229,146,93,45,77,160,192,155,103,131,252,169,237,161,0,52,99,57,46,224,102,184,36,152,119,214,99,0,34,69,99,209,156,28,204,251,144,172,78,28,191,53,233,148,144,116,78,100,1,28,134,176,230,181,138,174,165,122,47,179,73,27,164,238,54,5,187,26,172,175,138,75,134,26,131,42,128,89,121,71,57,192,121,156,204,54,77,141,20,73,20,38,75,187,125,189,254,0,65,135,6,0,32,139,81,216,11,85,0,34,75,231,165,12,15,96,23,131,0,0,0,52,216,142,0,34,89,146,59,1,40,208,156,234,179,52,53,207,93,239,157,238,191,249,58,67,93,121,29,239,224,22,213,74,40,252,251,229,182,104,28,113,23,190,31,140,251,111,203,111,209,22,160,28,3,183,17,117,197,205,82,135,10,211,242,41,153,224,64,6,157,74,29,0,101,97,208,196,133,11,43,159,0,90,119,218,3,205,237,2,242,206,59,132,4,116,170,197,209,53,87,211,79,22,109,83,153,182,186,233,101,75,214,200,64,185,124,204,150,174,171,94,125,215,104,87,112,155,205,218,209,70,48,210,112,51,70,194,93,211,89,198,178,173,23,36,230,197,23,32,97,209,153,10,163,107,137,106,96,27,5,70,113,53,5,75,176,11,210,77,171,23,213,188,219,247,57,171,188,119,29,74,238,29,79,91,21,232,187,188,246,40,168,146,173,46,158,232,140,237,162,78,161,171,37,187,97,14,134,127,248,235,173,36,106,148,113,113,160,180,113,85,117,138,233,236,186,3,26,211,108,67,112,125,50,0,66,101,30,168,88,12,46,160,35,170,37,137,125,144,196,84,77,72,251,119,60,155,231,90,154,156,234,64,17,241,228,42,216,3,74,230,88,35,169,66,151,240,33,253,174,153,52,75,250,225,193,240,165,103,218,46,56,48,85,199,54,110,4,178,168,160,9,155,110,118,0,58,95,82,136,225,86,152,192,67,94,117,110,171,85,215,23,174,165,35,215,167,113,213,227,163,159,7,84,175,210,131,228,110,215,43,100,68,130,199,209,60,65,129,21,192,164,143,65,236,162,3,100,44,114,102,21,174,202,75,187,22,1,56,171,26,221,7,0,58,67,210,208,242,177,100,6,13,243,193,148,78,253,13,239,202,195,107,93,209,203,247,241,89,188,174,46,36,72,231,245,118,1,24,132,108,75,135,181,239,44,99,18,40,69,155,25,112,155,161,83,164,219,204,110,40,104,128,203,5,183,248,96,82,125,0,78,67,171,74,1,0,160,122,97,188,148,140,59,21,175,119,10,197,250,230,252,187,226,216,248,139,155,183,116,114,5,193,188,53,140,55,60,88,79,253,108,226,69,7,235,46,37,27,99,64,3,91,122,222,178,212,106,99,162,209,122,189,148,90,109,76,52,90,175,187,84,106,179,137,69,135,235,245,84,234,183,77,44,26,173,215,75,169,213,102,19,162,237,200,20,0,78,63,253,91,160,148,1,236,81,45,225,56,151,208,1,0,60,23,209,31,183,110,142,233,174,119,245,21,37,177,68,149,104,193,101,182,23,0,74,65,241,18,136,189,0,156,105,92,76,8,168,0,0,28,253,208,63,139,101,254,167,229,235,159,122,135,2,213,54,201,43,158,46,210,2,78,73,252,7,210,3,128,51,233,16,38,160,3,0,72,28,253,122,92,107,125,246,9,152,54,74,172,85,45,132,130,179,73,0,62,71,252,158,214,219,9,128,121,6,0,112,125,149,155,114,213,233,151,91,35,149,211,155,236,171,20,40,130,80,14,0,82,75,181,1,134,50,129,142,168,158,37,51,189,157,223,183,183,247,110,199,15,15,231,107,215,113,252,170,175,154,39,135,227,249,204,56,53,53,101,113,123,142,10,95,134,41,129,255,50,61,21,7,255,48,14,153,18,224,86,165,2,24,167,4,252,119,48,233,9,192,127,130,253,84,20,95,7,1,82,91,125,7,146,172,14,58,225,76,194,137,224,82,213,32,186,111,233,246,245,251,207,239,172,233,150,159,147,81,73,89,229,109,143,135,41,154,1,107,218,191,155,64,25,131,31,89,67,139,0,181,210,83,206,94,80,64,175,142,61,29,148,219,29,12,235,19,0,50,63,43,27,154,226,62,59,168,152,51,97,226,41,1,157,117,170,185,199,228,123,100,117,139,244,91,238,150,241,12,154,5,178,38,194,219,131,237,152,0,64,13,215,75,27,0,138,222,60,224,241,112,60,114,14,192,30,126,168,2,76,118,129,248,90,21,0,46,73,249,146,142,203,205,6,156,185,113,96,24,0,64,221,104,255,147,178,216,171,190,190,242,25,94,73,234,7,11,46,149,222,0,42,75,242,179,66,92,206,27,192,153,52,206,49,12,0,0,51,119,77,118,188,237,49,125,177,142,92,189,157,39,36,46,105,0,30,73,242,86,100,131,4,204,151,146,12,112,189,223,115,225,224,207,185,233,169,80,149,223,251,85,127,147,240,68,235,63,177,193,159,216,224,79,108,240,39,184,213,88,178,170,217,84,191,152,191,10,110,53,156,77,53,199,6,87,193,173,2,101,241,4,161,57,5,30,59,85,7,0,0,170,207,74,81,236,241,87,206,74,243,94,200,236,60,156,195,207,10,69,83,22,70,203,197,3,179,126,133,21,69,23,231,196,246,66,194,174,4,83,121,41,184,117,118,219,11,193,84,158,194,192,58,187,237,133,132,169,4,51,240,146,221,58,183,188,94,116,205,148,186,80,164,102,42,8,30,75,242,7,130,92,0,249,213,146,4,1,142,14,0,160,77,82,106,38,165,200,159,254,8,141,75,43,175,122,226,81,152,78,17,0,14,75,244,5,169,188,1,156,124,30,4,30,71,7,0,112,100,46,139,181,229,104,15,215,241,79,33,113,130,141,217,111,27,0,30,75,238,78,137,205,15,0,243,12,0,160,191,177,127,74,121,186,27,93,112,100,74,245,210,142,116,113,198,213,49,6,30,75,229,85,11,183,19,0,213,146,14,96,24,0,64,13,209,28,75,182,180,199,242,166,57,23,119,32,84,163,1,42,111,91,4,40,148,25,116,60,213,171,138,92,239,49,252,198,168,57,247,75,213,185,235,189,211,133,156,233,76,109,211,163,70,48,38,117,36,23,26,23,43,236,141,242,71,199,209,66,137,241,243,51,128,79,246,124,159,206,41,11,232,124,254,231,51,153,122,186,55,187,79,48,87,88,88,96,21,0,62,111,83,2,10,183,43,24,188,106,67,34,5,36,201,185,186,167,145,178,230,89,243,104,126,157,46,250,243,106,129,233,110,111,32,217,188,220,202,14,99,184,15,90,169,46,227,41,144,196,184,61,53,139,1,10,120,152,198,116,87,126,40,5,68,41,192,46,190,150,9,181,225,41,62,38,0,58,65,147,53,104,238,113,192,110,112,103,42,34,52,252,65,154,114,211,243,247,173,229,170,106,207,94,86,243,245,178,213,117,5,101,186,29,193,126,0,124,13,87,165,129,97,240,38,44,3,134,130,53,27,36,86,61,207,3,232,160,136,217,206,24,166,161,93,21,0,58,71,254,5,238,4,64,181,52,30,215,4,226,232,0,0,169,46,199,253,168,171,157,39,109,71,214,229,39,50,191,114,113,81,47,44,219,30,0,54,73,242,81,8,205,3,128,106,73,151,132,1,3,0,72,73,45,183,35,19,191,107,121,83,117,157,10,20,222,23,82,235,0,46,75,252,179,130,58,181,7,64,117,0,0,92,191,245,103,71,157,142,15,250,236,184,24,101,53,227,116,245,112,44,155,1,50,75,226,67,224,180,54,128,121,6,0,208,223,240,30,174,167,199,248,254,175,174,120,42,127,213,84,200,186,189,74,0,50,75,225,41,234,225,220,0,170,37,145,36,18,0,0,180,171,39,239,142,214,252,246,238,72,79,101,31,68,42,0,30,77,230,105,210,219,3,128,99,31,25,164,49,0,0,56,54,203,214,215,87,245,251,218,199,15,221,232,4,38,75,237,82,13,203,13,128,99,26,146,51,1,0,0,234,208,116,159,254,242,255,181,149,89,52,48,10,38,77,195,85,213,203,9,128,99,18,60,92,0,0,128,118,117,228,189,171,150,43,155,201,214,181,209,9,30,97,50,2,164,62,0,213,50,19,4,80,76,75,122,22,203,218,79,154,120,107,125,82,165,94,175,59,127,56,26,93,71,111,179,1,83,234,18,85,66,71,153,21,147,67,29,202,191,177,0,77,163,243,9,2,117,32,198,102,88,182,190,156,165,43,14,63,74,48,199,167,178,160,1,30,81,96,129,27,161,130,22,165,90,194,176,0,210,78,93,154,215,212,59,207,238,72,253,228,149,232,58,137,253,11,211,19,249,73,52,39,108,126,142,117,210,80,104,30,128,115,123,57,62,98,204,37,100,51,43,44,142,70,7,248,161,124,28,48,211,184,8,195,179,24,6,30,71,108,3,220,88,64,68,230,76,154,52,192,80,101,218,207,19,217,44,187,90,44,121,172,190,82,193,132,106,64,235,246,147,102,97,91,125,64,7,124,13,224,84,215,85,176,78,124,104,220,118,130,84,3,123,212,138,14,48,1,18,75,234,142,102,248,1,224,236,3,18,72,0,128,35,185,182,110,26,158,197,153,122,171,3,115,185,198,221,5,207,120,158,131,43,0,30,75,229,21,114,59,1,80,45,1,36,12,3,0,104,94,213,45,243,86,154,20,79,29,211,147,33,207,158,145,240,0,30,75,227,137,169,183,6,128,51,73,164,3,24,0,64,61,214,60,147,29,115,166,168,236,173,145,217,1,70,21,164,168,2,18,75,235,13,173,222,0,192,137,17,60,0,0,0,60,187,103,239,220,170,57,106,100,46,74,123,175,166,150,118,22,75,251,181,192,3,0,156,8,32,0,0,0,196,226,137,165,34,139,181,217,191,204,254,92,4,19,18,75,199,153,230,4,64,146,99,90,199,2,14,0,0,199,225,144,215,124,158,53,63,92,45,152,0,26,75,143,169,0,0,42,204,3,0,224,250,139,183,186,191,95,210,241,220,215,236,234,190,4,0,26,75,74,74,129,182,217,42,13,213,18,64,2,37,75,82,148,212,204,76,27,82,126,212,167,137,114,172,60,249,155,252,77,254,38,244,170,186,170,226,111,169,40,140,37,96,85,93,13,128,95,41,25,250,39,0,95,172,100,97,128,188,53,156,57,45,160,97,148,210,22,70,249,66,137,171,174,134,127,64,1,90,115,172,182,9,148,186,130,14,246,188,128,167,145,193,44,147,155,105,79,41,218,115,155,231,255,203,238,249,99,167,166,116,163,92,129,230,164,154,194,9,150,96,73,79,203,192,183,177,134,105,12,101,242,75,39,101,104,201,217,210,44,0,11,220,130,97,124,197,208,160,77,176,72,255,163,148,83,248,55,160,19,203,0,66,111,162,103,161,69,53,19,232,81,247,27,128,185,156,162,166,53,126,203,149,87,255,77,87,205,151,226,229,48,117,177,69,78,162,30,166,183,29,137,28,222,96,207,38,131,29,212,20,37,135,225,209,88,221,18,64,73,160,23,17,75,148,190,134,233,97,166,38,10,29,177,78,157,111,227,114,20,30,107,80,91,230,58,29,52,61,167,0,25,36,138,109,186,214,190,69,106,219,141,243,54,66,120,54,53,116,3,177,158,96,121,5,197,245,244,182,1,71,141,24,221,5,152,199,177,125,39,196,36,5,245,41,251,108,46,1,4,210,139,81,13,96,179,196,21,153,0,38,87,73,101,43,161,66,247,74,154,57,165,3,1,20,59,211,166,238,142,148,212,214,92,109,106,99,223,112,43,228,235,222,55,207,229,130,1,214,239,16,52,10,137,130,205,210,216,11,149,44,192,14,18,38,84,59,80,31,133,134,129,132,201,251,130,132,238,74,66,134,152,30,34,79,75,109,121,50,174,219,88,218,178,90,6,214,0,113,85,179,230,239,72,193,21,223,2,246,3,222,92,240,148,68,13,68,223,124,153,47,131,141,254,224,241,192,102,198,64,161,10,58,172,171,0,232,35,195,27,0,188,71,5,130,28,84,1,58,61,135,83,14,0,64,245,89,150,82,216,244,117,94,191,126,148,238,61,141,13,247,223,20,43,87,231,129,153,205,132,45,77,174,107,164,209,116,110,105,114,221,143,81,39,38,234,178,9,46,155,208,38,55,55,170,186,149,25,118,63,102,216,253,152,168,75,109,162,245,212,38,12,102,43,12,150,86,177,106,94,153,225,122,202,84,167,175,182,194,96,222,10,213,188,177,12,8,29,70,69,147,43,48,50,52,236,61,117,87,167,99,0,96,71,249,56,127,239,125,238,32,62,110,134,170,41,144,109,149,14,2,21,130,131,103,102,221,94,4,148,145,6,54,67,253,59,32,206,5,160,58,29,0,192,233,143,155,163,175,92,95,181,125,123,235,79,164,20,65,219,8,170,247,133,76,8,190,53,29,62,73,250,18,184,55,39,224,76,146,33,210,56,58,0,128,57,68,54,115,45,107,124,26,253,201,147,52,174,57,177,128,91,180,59,3,58,73,252,165,104,222,0,168,150,32,83,36,226,24,0,192,28,206,238,103,167,182,116,88,181,166,41,58,15,195,0,66,97,22,131,69,244,5,116,216,234,133,167,122,39,223,115,241,155,229,241,143,98,222,214,165,66,47,131,237,124,190,137,251,88,134,114,143,83,83,192,196,42,51,153,38,32,14,248,212,98,132,73,28,192,74,5,110,136,224,12,234,250,42,40,220,16,20,176,18,131,251,166,224,179,2,78,115,61,11,6,165,102,208,220,213,139,106,254,218,41,206,205,253,184,100,229,249,121,24,110,206,155,180,19,199,110,183,195,214,66,167,59,231,174,228,77,84,140,185,114,133,41,177,191,34,45,102,16,204,155,173,216,47,69,222,233,217,115,138,224,105,219,28,64,152,230,119,237,180,111,42,52,0,82,121,60,3,232,120,1,29,248,28,128,20,128,171,250,118,153,107,173,163,121,255,231,44,89,255,41,29,104,44,108,204,176,216,250,52,44,17,193,244,168,51,187,169,154,26,105,112,162,218,134,68,22,237,171,71,159,38,150,179,145,225,52,51,82,5,230,9,173,219,140,43,198,12,36,50,115,50,3,37,196,43,232,116,182,162,154,119,70,238,25,170,120,117,241,252,113,61,118,124,177,15,249,186,98,31,167,176,149,194,167,240,20,54,9,148,46,132,104,90,120,22,34,20,109,145,70,182,158,76,175,248,82,159,52,3,224,41,47,251,244,215,249,65,157,113,164,17,1,38,115,188,7,52,37,7,152,239,156,102,200,132,73,83,93,223,127,61,145,234,22,105,239,190,39,29,156,190,29,121,123,216,94,212,102,209,28,51,43,166,232,220,17,134,113,83,131,135,226,101,48,121,88,9,129,106,160,215,112,108,244,3,193,75,180,43,99,158,239,38,79,103,103,83,0,0,0,246,1,0,0,0,0,0,81,164,57,46,4,0,0,0,25,211,132,165,86,71,70,68,62,63,58,78,72,73,29,27,59,49,36,29,29,26,77,68,54,29,29,50,45,32,29,26,91,74,76,68,70,69,57,34,29,29,29,76,72,68,39,33,34,32,28,27,28,25,76,75,63,29,28,26,26,23,16,15,14,76,72,63,38,35,30,30,27,27,27,84,81,79,71,69,64,56,38,30,25,24,74,73,33,31,29,26,109,212,3,19,212,5,185,126,134,83,10,32,29,210,84,59,159,230,151,201,107,61,35,181,203,172,53,53,151,184,166,57,39,213,108,74,97,113,219,158,99,74,83,55,65,57,131,209,161,218,0,29,56,108,118,57,113,205,17,122,77,15,24,211,231,108,176,122,69,3,30,101,86,107,64,164,83,233,192,213,211,86,251,52,174,234,238,252,111,62,27,27,191,173,186,179,211,95,205,236,152,187,114,136,38,186,49,226,96,178,239,199,8,165,89,146,16,9,35,106,152,166,211,64,238,42,117,68,9,2,63,84,105,128,191,50,41,2,79,0,26,95,210,26,184,212,19,200,85,143,169,26,46,205,219,177,227,63,10,123,252,238,177,249,176,209,236,0,89,32,82,139,58,108,164,40,22,12,148,58,13,74,213,88,21,167,134,95,1,92,128,237,160,45,233,80,128,145,2,66,179,31,163,137,31,238,164,7,22,89,200,27,117,208,28,48,153,92,117,77,53,182,218,187,190,251,247,120,82,57,197,35,251,254,118,59,204,11,164,92,251,87,222,15,23,17,38,24,181,75,22,3,146,90,183,129,254,7,64,217,37,52,8,63,6,30,12,3,152,0,30,81,46,26,177,33,94,89,104,204,51,119,121,36,180,77,218,168,115,180,113,220,214,202,150,238,48,88,208,85,13,103,40,104,246,68,218,7,183,87,49,67,21,76,18,64,28,54,2,17,28,40,32,181,255,64,65,110,38,176,44,187,3,30,61,45,91,241,38,122,102,53,212,220,166,170,140,246,49,126,238,90,42,231,103,84,120,172,176,115,72,254,132,92,23,38,250,154,15,195,0,9,151,176,193,1,51,192,225,55,194,174,6,12,111,57,144,180,2,36,60,62,111,149,212,41,76,87,100,55,174,94,52,205,186,222,47,227,79,23,174,119,242,219,87,77,119,198,143,91,243,66,123,46,236,133,173,170,85,142,229,81,152,156,127,10,49,158,171,220,16,162,153,176,82,17,44,216,155,11,148,175,60,97,194,74,128,162,96,5,176,119,106,166,172,134,27,31,0,98,113,160,193,73,235,9,140,222,158,170,26,198,167,143,222,211,37,135,155,243,81,252,211,70,236,212,114,35,167,177,201,240,38,174,171,203,203,202,176,221,25,99,234,31,110,92,85,224,86,189,10,118,1,228,48,216,174,240,92,149,254,49,73,124,128,49,246,168,169,206,4,58,69,68,168,225,116,82,65,227,234,92,211,204,235,47,62,170,70,250,146,149,253,121,51,220,84,233,235,35,85,20,33,250,49,46,104,123,182,57,193,122,83,13,214,25,145,24,94,251,26,236,134,2,56,186,136,75,146,170,244,117,250,90,21,147,15,157,194,155,64,17,10,0,54,75,237,78,213,203,216,0,170,37,128,0,9,0,64,50,150,189,177,139,236,107,206,46,26,138,23,0,0,34,75,227,73,140,167,5,128,99,146,100,97,12,0,0,142,135,110,241,127,141,236,233,127,168,6,0,54,73,112,9,2,104,128,234,201,25,3,198,251,41,238,28,62,46,248,223,248,211,171,166,123,227,175,120,75,202,135,59,107,151,39,171,242,228,199,159,250,186,21,117,128,242,185,66,121,148,191,142,251,114,136,207,142,164,1,98,77,242,14,0,54,224,12,164,176,164,66,71,193,24,80,215,50,91,159,173,179,47,217,179,252,215,169,157,96,117,58,168,130,157,212,219,73,139,0,15,69,143,140,169,129,211,165,0,70,73,248,36,234,225,228,4,156,72,75,26,48,116,0,0,109,242,100,229,234,103,91,183,213,182,122,23,212,39,63,45,227,49,47,3,46,75,234,85,195,208,78,0,243,0,0,184,254,232,239,197,49,191,173,236,239,67,225,108,204,219,150,36,0,38,75,221,85,215,203,6,192,49,141,65,24,2,0,0,205,225,105,243,250,69,252,207,89,247,250,225,50,12,30,75,235,189,170,223,0,192,49,9,132,115,0,0,168,113,168,106,94,213,229,71,246,173,6,0,46,89,91,4,56,213,58,232,192,243,37,53,89,158,43,60,74,197,234,255,29,126,61,76,93,249,116,33,206,247,75,169,212,214,38,94,116,120,176,238,82,41,217,16,139,134,225,174,59,178,252,96,100,183,216,17,211,126,146,157,22,8,165,91,113,113,0,67,28,58,40,141,240,176,52,205,5,42,73,91,134,14,219,91,87,152,59,237,25,198,9,80,212,36,75,253,77,250,197,164,255,210,247,109,119,237,214,93,14,42,153,226,77,116,6,114,33,191,121,204,208,64,109,174,122,21,128,109,1,126,40,152,93,159,220,170,67,130,119,22,73,194,3,198,0,26,65,197,218,20,110,207,6,88,111,170,116,204,158,247,232,226,159,169,30,126,22,203,215,66,92,123,49,139,112,130,0,176,227,67,7,0,18,87,173,129,15,40,142,117,174,147,9,0,236,247,212,1,0,22,75,234,206,84,135,177,1,84,75,24,23,198,1,0,0,223,82,199,150,226,91,52,17,54,46,165,30,0,26,75,201,173,16,111,27,152,176,0,0,112,250,218,115,105,236,122,238,200,126,94,46,124,228,110,143,50,1,26,77,201,45,159,34,10,128,249,76,0,216,219,145,121,158,14,111,127,92,207,29,212,213,149,93,44,142,127,101,106,202,250,254,255,203,76,166,216,155,149,240,231,51,177,56,223,85,168,3,26,77,228,3,56,6,128,234,41,0,76,55,133,253,184,41,253,61,50,242,190,188,245,187,62,105,185,58,22,136,232,108,187,232,121,127,79,2,176,234,108,23,5,224,1,18,75,201,149,197,237,6,58,204,51,0,0,71,76,85,215,143,111,84,246,35,199,94,155,238,234,69,184,233,202,184,36,26,75,167,133,235,27,32,135,106,65,18,1,0,0,160,254,154,174,159,191,184,154,229,205,201,203,5,91,1,30,75,31,137,6,0,37,156,0,132,35,1,0,224,114,228,161,123,232,242,35,134,6,17,83,0,26,69,222,216,104,181,84,142,198,213,51,139,102,214,31,85,175,250,175,234,18,159,85,23,222,197,115,215,226,212,21,233,132,38,117,75,147,186,53,92,218,26,46,89,213,169,133,169,173,170,57,54,184,10,37,220,212,54,60,156,205,224,79,12,220,42,100,83,133,89,150,14,139,231,86,194,249,14,244,163,5,186,180,53,156,99,196,237,151,100,2,90,113,21,87,128,180,3,52,91,61,83,245,121,44,250,206,205,232,219,202,44,94,226,216,52,24,249,151,162,84,136,3,235,209,37,31,123,32,24,38,242,28,245,207,162,83,246,113,11,32,250,214,195,151,148,41,5,122,221,114,72,40,94,18,130,21,113,125,229,204,133,11,138,3,70,115,61,10,6,152,65,211,115,184,11,18,166,168,230,211,220,150,154,126,178,236,200,43,125,90,255,146,213,71,35,75,85,127,145,89,237,25,27,64,183,159,98,184,211,82,125,215,165,110,143,75,26,221,78,114,121,45,181,117,237,145,18,243,34,54,162,57,102,160,193,117,213,11,123,0,70,103,22,131,84,212,1,26,206,164,187,72,137,72,85,83,50,103,123,206,215,165,95,105,243,94,46,221,0,77,59,184,136,141,82,224,41,70,105,65,249,9,114,167,116,119,64,91,47,129,82,230,100,168,53,16,248,216,26,78,32,89,125,227,205,179,214,0,58,91,24,132,88,52,117,192,186,67,87,75,69,166,134,144,34,229,106,255,252,189,89,213,189,153,188,223,38,95,91,239,201,240,170,21,187,221,121,178,58,187,222,237,0,171,14,30,20,10,224,121,146,4,130,210,24,91,169,162,0,140,11,104,196,184,128,185,24,0,50,71,218,168,242,241,168,9,131,215,73,183,194,76,117,250,134,233,176,186,47,143,138,167,121,244,60,102,33,93,207,179,143,19,162,226,146,64,40,116,145,163,0,140,117,170,124,44,59,64,147,168,26,155,171,104,200,134,226,109,218,88,0,211,30,64,249,161,0,54,65,112,20,244,99,40,5,134,115,38,73,132,188,83,38,29,147,146,166,123,143,102,170,187,53,199,66,210,88,251,134,57,220,69,0,214,0,252,80,46,145,192,122,59,193,129,91,117,232,112,130,121,123,23,58,0,46,75,234,21,195,178,55,128,19,35,211,184,128,0,0,60,63,71,214,28,207,50,199,235,77,115,252,141,234,148,20,53,29,0,42,75,225,94,212,183,61,0,108,0,0,232,111,120,204,213,167,231,67,119,207,14,162,60,99,163,212,51,2,38,75,233,157,170,79,55,0,78,164,65,218,0,0,128,118,245,212,91,41,181,243,173,71,62,147,55,169,1,26,75,237,106,210,219,13,128,13,0,0,215,111,251,187,145,254,28,157,231,207,85,124,228,217,77,67,3,0,30,67,7,29,128,26,7,232,196,213,139,153,102,248,237,157,98,156,59,87,121,127,229,245,246,222,189,241,208,203,242,251,217,29,243,173,251,247,153,178,248,124,122,10,254,234,0,224,2,252,233,196,130,253,58,42,248,124,226,12,159,175,31,223,184,10,95,231,32,153,128,126,202,68,120,14,54,89,219,6,184,28,51,152,92,245,76,213,253,40,198,247,83,241,226,37,226,238,199,187,114,170,106,49,248,177,158,84,57,241,246,206,242,50,151,132,170,38,76,43,132,205,12,167,35,170,155,1,102,215,102,88,195,13,84,53,15,232,39,137,102,32,69,99,218,210,41,0,38,59,253,38,234,183,143,158,65,7,61,19,134,144,144,153,166,12,158,232,219,148,110,91,222,29,157,183,150,128,62,174,69,59,233,196,0,115,20,187,161,160,24,238,221,195,238,113,17,96,23,134,2,14,92,210,12,36,118,160,33,53,123,4,80,24,3,1,30,77,244,79,172,75,91,0,230,233,4,0,167,47,206,14,74,167,131,114,124,63,63,125,79,60,219,35,111,139,57,183,241,76,96,12,240,1,0,18,75,234,78,13,195,27,0,243,12,0,96,95,45,171,247,244,186,42,95,30,31,62,199,151,44,225,81,94,88,5,71,7,22,75,201,37,21,30,39,0,54,6,0,176,21,92,11,85,103,175,171,227,61,141,100,225,3,78,123,179,102,173,22,99,31,0,26,75,195,137,242,159,2,44,168,150,59,132,3,3,0,168,99,106,235,142,197,220,190,178,133,196,190,36,18,213,118,0,22,75,187,53,212,27,192,132,121,0,0,236,165,254,196,116,58,29,169,191,207,165,141,86,47,9,91,0,22,75,119,29,104,0,22,108,0,0,216,81,62,178,120,250,121,235,151,202,131,155,232,22,122,13,0,26,75,143,41,1,128,28,142,57,144,14,0,0,168,99,222,189,169,107,77,71,55,19,150,178,221,5,0,26,75,223,192,0,32,193,49,9,164,3,0,0,220,68,190,212,218,166,179,205,31,127,57,6,58,103,184,50,51,92,233,48,238,169,118,79,229,202,222,249,250,222,240,226,254,74,243,151,175,239,13,47,46,196,60,171,209,117,109,22,71,91,255,254,196,194,130,223,115,248,61,23,128,27,2,123,231,42,12,1,86,128,189,199,63,97,180,152,200,37,43,67,80,64,72,46,64,119,67,0,98,109,160,65,161,185,34,212,184,122,166,169,245,89,69,211,92,234,111,84,255,114,177,111,239,94,92,212,241,24,125,38,205,191,121,197,47,169,151,85,77,124,141,86,199,108,119,145,213,37,137,31,177,1,252,230,193,205,69,231,21,104,69,162,95,42,246,144,15,246,80,18,253,160,10,58,67,88,232,225,116,170,25,244,132,108,156,169,230,245,167,122,100,238,194,145,155,143,205,211,200,54,47,26,90,132,25,109,218,46,158,249,222,9,111,94,193,165,93,192,111,23,224,169,178,71,224,84,77,30,176,11,207,80,192,148,64,7,54,75,229,189,16,135,177,1,28,19,36,3,3,0,64,242,58,178,254,122,127,182,255,177,246,185,45,90,13,34,75,227,73,13,219,6,192,49,105,88,26,3,0,128,227,241,228,217,49,75,165,189,251,244,113,11,0,18,75,155,181,137,7,0,56,102,6,137,0,0,0,207,238,105,167,218,62,221,99,175,108,75,3,14,75,247,169,10,0,192,137,0,106,71,0,0,96,30,135,182,158,81,221,243,236,155,17,1,0,30,75,191,224,4,128,4,199,0,154,0,0,0,208,222,91,97,241,159,173,218,197,3,34,75,191,16,1,192,67,3,0,64,237,9,127,107,38,0,34,73,159,11,254,0,224,97,14,0,0,128,46,139,4,34,73,159,11,254,26,0,15,21,0,0,96,135,9,70,93,171,10,24,90,4,13,213,83,213,226,183,99,227,47,174,231,47,113,251,227,224,222,211,181,88,121,223,87,55,146,155,106,30,209,12,150,182,246,15,151,126,12,176,108,191,96,31,66,82,145,87,217,239,192,66,144,12,74,149,33,184,141,52,161,171,124,103,226,60,87,65,19,105,2,46,87,219,137,24,154,83,38,44,118,249,157,65,24,137,75,77,253,53,239,204,126,164,183,182,229,158,142,242,86,77,114,37,82,39,89,103,75,253,5,7,184,52,46,24,38,54,0,196,111,172,129,86,27,94,227,122,217,6,187,163,232,240,134,42,58,64,130,203,245,37,0,42,65,253,171,26,139,61,2,48,58,147,68,12,36,169,36,153,84,190,60,183,102,217,217,223,222,148,40,49,232,69,77,111,27,138,235,155,36,160,131,49,48,108,199,37,96,12,216,35,48,20,236,17,0,158,119,57,85,148,238,135,2,0,42,71,249,73,233,211,9,128,39,92,46,3,36,29,0,192,92,170,219,42,203,39,77,222,101,89,124,235,94,67,78,17,38,168,22,18,133,4,30,75,241,115,197,184,172,55,200,163,90,238,44,193,48,0,128,227,28,203,53,231,114,124,235,188,121,117,209,43,137,109,239,2,0,30,75,252,43,196,219,184,1,156,72,23,210,49,0,0,72,165,236,199,185,31,221,222,172,30,44,188,183,35,15,26,75,236,41,198,225,94,0,54,0,0,236,37,124,84,141,247,72,197,211,119,149,67,225,241,82,115,93,42,2,14,75,230,86,140,143,19,0,11,0,0,167,223,125,28,158,185,55,58,171,42,199,182,208,106,83,3,18,75,201,149,138,143,13,128,99,146,228,156,3,0,64,106,45,217,54,253,161,206,245,136,94,169,2,14,75,195,94,12,31,0,224,152,32,17,200,3,0,192,220,53,221,62,95,45,91,159,29,118,234,0,14,61,9,2,0,64,227,51,39,17,6,197,146,22,117,115,100,53,181,149,181,159,212,244,120,168,78,53,143,168,7,83,91,209,193,212,86,116,48,181,21,170,128,239,139,219,70,224,203,226,133,159,216,176,75,1,68,235,169,13,96,224,66,181,148,218,234,9,0,243,251,9,137,80,79,109,69,93,202,84,93,202,224,0,70,117,58,187,129,146,25,52,62,215,145,96,118,40,153,220,242,179,29,221,241,122,182,95,219,47,214,67,139,186,13,16,221,35,93,194,100,23,202,226,98,108,90,178,112,124,155,225,145,211,237,27,134,225,82,40,129,31,208,28,43,133,215,65,193,80,5,148,174,14,236,141,242,96,197,129,21,3,191,156,3,70,113,212,59,49,58,94,65,115,170,109,0,54,80,138,202,143,229,234,83,187,92,219,55,169,230,56,188,37,187,72,169,86,179,85,100,47,25,69,22,245,5,131,176,168,39,130,135,138,137,188,161,96,14,111,9,18,199,6,2,99,83,62,35,18,109,100,87,18,132,179,71,209,187,141,236,66,2,0,38,103,80,217,64,244,1,26,87,47,170,30,122,93,24,190,170,79,223,24,170,6,103,195,1,111,92,188,179,108,245,57,233,34,156,19,243,210,238,9,108,183,2,239,161,238,96,211,242,8,40,117,13,108,160,24,251,26,93,194,25,80,235,208,79,46,145,88,60,117,0,30,91,161,118,119,163,194,12,26,206,41,17,59,160,202,86,86,41,211,102,249,156,187,38,213,100,190,71,163,142,212,134,161,84,59,80,73,157,44,245,165,51,49,54,54,89,42,20,85,234,69,131,7,52,120,171,86,146,171,135,242,192,80,55,86,0,119,58,26,34,73,173,118,119,97,170,179,164,187,236,124,171,58,236,147,28,181,223,63,251,166,222,124,23,116,39,129,181,23,61,18,156,64,206,38,41,254,101,3,9,71,127,96,128,53,22,23,211,226,196,88,21,199,240,118,162,0,148,26,88,214,26,0,30,61,11,56,167,2,132,37,221,9,75,83,58,22,125,215,109,169,234,113,39,30,103,59,125,216,69,233,161,112,117,128,85,7,5,112,201,7,192,251,187,0,38,48,49,86,90,149,203,0,40,230,125,229,38,0,30,75,251,181,187,158,92,96,94,30,179,13,6,0,161,236,61,86,249,56,44,93,135,194,193,148,163,141,53,91,11,5,42,2,30,6,198,0,38,75,111,231,137,3,32,193,49,115,36,7,6,0,48,47,205,115,116,91,29,77,28,249,178,85,213,129,58,0,26,75,143,169,167,2,224,96,3,0,128,187,251,71,85,95,220,152,206,138,143,92,89,111,4,30,75,31,137,55,0,68,88,0,0,112,232,157,5,231,15,135,135,209,207,182,150,27,0,22,57,135,103,10,0,128,234,133,167,162,114,111,199,251,197,133,235,215,247,78,247,95,216,47,227,47,181,118,206,184,99,72,251,249,147,85,121,180,254,116,66,185,173,227,0,113,87,30,173,63,127,74,254,59,238,252,209,218,207,21,11,104,66,10,186,169,104,226,157,169,107,138,4,62,57,135,102,0,0,240,48,78,77,144,20,37,101,243,70,253,143,101,75,233,221,151,127,151,46,230,116,19,61,48,133,97,176,222,162,190,183,253,200,152,6,240,218,126,188,69,125,151,229,75,106,251,145,89,223,40,224,176,79,102,61,214,186,162,73,33,153,186,34,228,59,29,38,73,189,59,33,14,15,27,80,45,65,228,9,12,0,0,140,212,111,145,242,255,179,100,123,90,78,85,237,226,111,73,54,26,75,252,43,134,109,223,0,78,36,225,24,0,0,160,94,235,122,120,219,244,86,115,223,150,118,87,90,231,179,0,14,75,234,86,143,219,26,0,230,1,0,112,125,233,93,58,248,123,185,186,206,202,157,15,66,124,43,1,0,79,103,103,83,0,0,0,154,2,0,0,0,0,0,81,164,57,46,5,0,0,0,155,246,74,152,82,27,75,73,49,29,25,80,78,74,30,30,26,25,23,22,21,19,77,66,60,34,28,73,73,69,22,17,101,86,72,70,69,64,80,75,37,36,34,88,74,64,37,36,34,80,39,32,35,34,87,77,66,37,35,33,32,32,30,28,29,76,70,63,36,32,32,31,27,25,27,24,78,77,75,69,67,78,73,40,36,35,74,18,75,237,36,198,219,0,192,49,225,16,206,1,0,192,56,98,127,50,83,205,126,100,123,181,90,3,30,103,166,150,40,149,11,19,203,249,194,213,116,124,56,253,27,171,154,142,143,24,27,175,186,170,215,165,190,100,165,148,250,233,223,176,216,16,187,161,64,180,74,29,13,19,177,248,98,7,95,215,19,206,129,133,10,40,200,65,168,115,23,166,184,138,138,57,54,126,236,83,45,29,0,30,89,243,10,247,72,209,57,168,150,57,198,96,200,44,185,204,95,165,205,242,111,237,237,146,135,218,178,46,87,109,189,142,175,220,172,19,174,46,187,253,174,51,251,112,137,35,0,236,177,168,10,15,125,87,67,63,80,240,24,152,225,17,222,50,2,174,79,138,188,160,38,1,22,67,151,152,206,73,18,56,99,243,137,0,18,216,152,50,176,122,219,228,72,233,190,117,77,14,114,65,95,76,0,216,86,150,104,2,196,221,184,64,97,12,96,55,20,0,108,80,5,30,73,239,192,10,96,82,193,137,3,233,130,10,0,64,221,45,121,121,174,100,203,143,4,39,7,179,10,0,30,75,223,160,1,64,14,199,12,124,64,5,0,96,254,228,97,62,191,126,41,160,6,185,0,58,103,61,46,149,115,53,89,167,19,87,47,89,82,118,103,124,111,191,254,250,222,157,60,119,238,197,133,74,243,127,79,166,133,124,114,150,152,138,187,127,198,41,254,148,56,254,233,41,62,31,3,216,31,223,148,220,191,2,48,202,253,211,83,226,24,227,4,23,180,227,181,85,248,58,5,186,61,23,76,94,107,216,3,167,125,130,81,71,119,245,228,114,179,62,95,209,241,248,240,241,114,236,242,249,115,135,47,70,94,37,97,19,150,7,190,148,170,26,222,132,203,141,193,165,175,105,192,126,3,101,230,53,119,59,26,84,141,177,168,59,6,108,192,59,191,72,163,193,175,61,20,185,214,14,238,112,0,58,75,132,232,245,36,30,96,208,35,238,124,38,93,114,247,250,189,191,23,15,62,30,243,240,57,86,245,179,106,157,44,245,136,231,72,72,17,104,1,123,108,0,102,101,86,30,84,97,141,183,171,44,47,3,9,211,107,108,82,152,236,128,67,38,188,73,18,7,243,183,43,28,0,50,75,233,189,174,151,177,1,84,75,24,164,51,0,0,36,143,167,93,159,51,230,246,212,23,69,197,53,160,0,34,75,227,73,215,167,5,128,106,73,131,52,33,0,0,112,141,79,251,44,71,122,247,60,229,115,98,151,0,0,22,75,187,181,160,223,0,192,2,0,192,62,27,98,236,250,251,153,151,113,112,29,235,11,133,0,30,75,143,169,0,0,38,28,19,224,225,28,0,0,172,33,75,211,148,171,91,206,152,7,0,26,75,127,142,6,128,4,199,36,16,0,0,0,234,103,178,178,108,241,182,105,232,0,30,75,191,160,0,64,14,71,12,172,1,0,0,48,127,79,22,230,112,180,73,2,30,75,191,224,4,0,15,199,0,75,0,0,0,54,19,212,155,46,9,19,0,30,73,159,11,30,0,136,112,4,160,8,0,0,192,106,112,53,105,2,42,87,7,6,20,158,19,104,186,167,170,195,185,205,95,141,125,253,120,213,103,249,197,216,189,97,250,186,88,95,199,235,200,142,185,235,85,151,182,134,255,98,131,63,129,222,104,223,109,116,209,125,162,177,96,21,159,240,84,40,22,10,86,162,146,28,148,58,131,30,248,171,104,58,84,10,60,34,87,219,78,224,182,173,131,134,51,9,66,224,98,154,186,212,111,214,172,31,191,245,141,167,134,81,169,242,200,226,141,176,22,174,66,193,177,173,8,69,162,169,66,21,172,129,82,5,140,57,233,89,69,210,36,172,171,243,18,110,2,132,13,210,3,26,69,245,134,14,111,39,0,206,204,35,4,64,89,54,51,127,199,154,234,112,175,148,222,253,2,51,166,246,69,67,39,169,1,214,96,92,208,124,240,128,49,176,184,248,226,65,143,11,137,32,189,44,248,215,87,151,0,208,0,22,75,234,78,237,77,59,1,84,75,56,34,13,73,24,0,136,81,221,115,244,139,20,247,35,51,91,239,166,1,118,96,12,0,14,75,238,82,143,219,6,192,6,0,128,190,164,63,81,117,154,70,207,183,151,251,123,113,123,76,107,0,30,93,178,146,136,16,102,208,33,243,37,85,239,57,221,126,118,245,233,230,251,133,203,83,156,252,255,255,43,83,83,22,223,255,127,153,158,154,18,248,243,129,17,62,253,195,74,224,235,48,4,111,63,49,4,102,162,92,133,105,158,194,130,5,138,194,52,93,172,4,251,9,0,70,109,52,187,17,161,94,33,210,105,171,23,149,249,237,200,229,56,187,56,117,241,252,101,95,213,197,203,98,89,239,73,179,29,179,73,130,89,51,60,151,242,50,116,212,50,78,53,250,135,179,228,146,154,225])
.concat([84,214,192,37,235,225,132,42,167,109,82,34,75,100,96,173,28,30,30,81,101,149,1,137,179,171,211,17,167,3,52,64,225,169,30,170,109,45,203,175,130,180,132,198,231,117,237,92,120,171,44,219,112,149,34,219,6,48,46,118,110,25,28,44,2,240,46,44,142,171,3,189,176,129,215,177,1,13,93,120,205,48,148,181,14,26,26,38,75,151,115,21,177,129,131,85,1,0,84,1,30,71,1,219,243,5,167,20,0,42,75,207,161,100,0,68,216,0,0,0,80,17,48,138,82,0,34,73,233,186,74,4,34,97,174,94,138,188,36,234,219,211,77,213,221,138,23,238,60,93,207,38,31,200,163,68,178,142,121,107,100,19,47,58,116,125,105,234,103,107,19,47,58,88,47,165,182,54,177,232,96,61,167,182,54,33,58,88,207,2,203,70,54,110,25,72,0,211,19,162,213,186,75,173,54,38,58,92,207,169,173,77,44,58,116,61,121,106,107,19,139,214,235,89,174,72,0,62,103,91,26,40,226,19,146,29,125,231,92,32,134,16,148,34,207,124,126,253,241,187,231,239,114,219,251,54,191,182,77,31,50,155,147,201,98,163,232,218,254,101,165,42,142,168,154,44,37,9,1,253,98,180,21,224,214,62,208,76,180,115,161,33,245,186,251,87,228,208,211,17,49,85,30,180,149,78,153,207,129,170,20,179,5,78,109,21,7,166,132,43,104,182,218,112,50,9,4,169,234,19,183,229,236,182,227,205,155,243,252,63,191,95,67,146,22,137,26,13,29,47,244,58,1,95,107,148,72,244,97,211,164,168,17,43,29,105,13,204,97,59,78,12,155,14,156,171,38,26,31,158,164,246,99,20,0,70,105,89,128,83,137,7,232,106,206,164,217,132,4,237,212,53,149,103,255,63,242,250,157,251,44,171,45,255,30,152,174,106,114,254,77,66,125,44,45,96,213,11,52,163,24,35,177,169,116,0,150,160,17,219,17,149,134,4,199,102,163,76,64,143,42,69,159,26,0,66,91,28,16,134,173,15,152,28,233,157,8,19,27,36,195,138,154,207,221,152,231,191,60,111,27,223,58,27,105,158,77,220,119,194,188,161,148,241,206,205,183,111,30,134,166,243,1,15,72,31,33,76,146,62,86,133,135,208,231,182,172,2,111,227,196,233,153,0,50,73,146,137,234,246,232,14,122,37,207,167,45,51,79,191,245,189,15,79,231,15,93,152,139,55,227,149,249,98,44,219,39,43,155,153,16,172,167,245,244,1,16,0,172,7,96,57,49,13,184,180,168,113,134,130,175,125,253,187,237,128,181,4,62,59,91,9,0,104,192,124,41,105,178,57,71,215,79,211,248,248,97,213,241,241,142,103,79,253,13,198,253,249,83,95,117,234,207,159,250,41,79,86,126,236,83,235,107,41,53,254,136,198,14,201,45,254,120,26,251,176,190,139,118,146,244,194,105,229,21,74,70,52,172,92,109,102,113,209,200,250,169,52,86,57,213,76,208,72,96,71,245,44,69,153,105,84,63,143,229,251,118,24,142,78,197,155,33,197,235,151,10,52,21,244,149,21,251,241,236,199,3,12,207,120,139,39,133,7,59,209,234,45,158,20,61,109,191,205,154,52,159,87,56,49,59,217,78,120,133,108,180,41,188,116,26,81,0,62,65,253,91,32,246,2,112,182,19,113,1,67,7,0,240,132,107,205,235,109,223,103,188,109,200,212,109,61,12,113,244,176,23,205,194,3,70,73,246,18,164,155,27,112,38,9,23,130,161,3,0,88,47,169,125,142,46,154,118,79,43,124,74,75,0,83,39,95,32,241,120,0,70,71,244,9,134,7,0,103,130,96,97,12,3,0,152,195,151,247,207,246,175,117,169,167,17,54,111,182,193,193,176,72,155,0,66,69,84,129,91,207,25,112,230,4,21,25,65,41,105,201,168,242,238,139,252,255,69,158,183,241,225,64,229,70,221,17,41,206,23,74,177,191,241,107,241,77,169,79,173,60,158,90,165,17,44,63,124,13,225,171,174,20,224,164,73,51,87,8,247,105,229,241,171,90,229,201,87,149,114,236,170,86,121,242,135,85,142,125,23,117,21,0,90,103,85,0,141,149,25,176,103,106,201,189,25,25,190,92,238,231,131,241,115,233,58,20,238,133,122,213,73,61,207,65,148,254,97,211,10,143,2,108,95,1,169,210,9,150,125,117,24,220,67,57,100,223,140,137,6,178,20,72,109,7,67,111,159,9,80,209,40,90,215,110,224,1,62,69,43,51,21,182,118,207,72,231,206,132,139,97,144,50,213,155,150,70,110,105,247,95,90,215,237,146,229,182,61,44,136,72,132,156,112,60,0,7,99,191,104,192,58,97,93,5,137,80,208,199,246,8,0,108,144,2,29,161,161,173,61,0,42,73,189,75,177,46,39,27,80,45,119,6,28,29,0,192,113,106,250,221,19,205,177,52,215,86,32,90,180,199,174,62,210,87,35,41,0,42,75,242,81,141,219,2,64,181,36,105,72,113,12,0,64,121,183,251,236,217,146,101,253,57,223,18,74,241,116,85,75,223,185,217,0,34,75,242,79,8,219,122,0,84,103,0,0,123,9,81,177,244,125,100,236,236,93,239,216,120,131,53,137,106,51,4,218,18,0,38,71,118,3,0,3,80,125,86,74,50,56,125,168,71,207,167,75,247,93,234,195,227,226,167,233,83,177,179,185,73,215,33,205,139,215,110,141,168,171,245,188,50,161,93,62,19,109,82,27,162,117,82,27,19,173,151,82,155,88,180,158,127,54,161,90,207,43,19,173,214,243,202,132,110,94,215,188,14,0,38,77,244,143,105,77,54,64,118,181,164,37,153,48,116,12,0,40,147,181,117,110,71,77,191,90,152,110,146,25,11,93,237,11,11,246,118,6,16,30,75,226,30,104,231,3,96,158,1,0,236,37,250,123,78,91,46,27,191,233,33,18,118,218,144,123,122,209,174,149,9,22,75,230,142,233,225,3,128,106,105,12,201,129,1,0,28,61,210,179,245,235,249,52,79,246,20,127,129,197,189,197,211,136,42,0,26,75,229,85,134,229,1,64,181,164,113,16,199,0,0,82,178,102,117,124,221,182,173,233,136,213,238,119,9,60,150,211,88,3,42,99,171,24,52,151,50,99,179,242,206,109,11,78,219,38,74,201,212,186,249,254,255,255,253,255,191,221,126,255,255,255,166,231,147,207,231,179,132,169,169,169,169,169,169,169,169,184,49,14,254,244,255,191,12,16,152,178,0,62,255,239,95,1,122,85,42,224,255,249,83,33,134,11,152,201,188,10,197,177,159,180,196,173,138,206,3,66,117,83,12,144,57,195,226,10,175,122,209,212,11,35,71,167,227,219,145,24,31,159,30,215,114,229,120,191,160,200,94,171,22,218,111,171,164,93,210,155,192,34,166,104,46,130,238,107,31,184,44,138,159,195,30,142,42,77,162,240,206,33,113,26,122,217,5,133,34,103,32,20,181,60,198,20,70,79,69,9,148,123,117,164,59,114,245,230,36,101,187,23,124,159,71,57,58,226,248,166,126,246,133,223,59,160,183,196,253,104,157,112,113,47,118,107,194,7,9,96,214,153,69,105,40,32,4,206,179,251,215,137,206,184,156,103,157,92,242,140,105,0,58,73,213,21,52,227,126,0,103,110,174,229,64,7,0,72,71,199,113,60,183,146,222,172,178,254,69,198,67,214,34,179,20,217,120,94,6,62,73,252,150,82,205,155,5,56,147,38,9,132,96,0,0,169,245,44,231,179,182,97,207,143,189,205,140,65,3,115,69,5,99,7,50,71,244,86,12,219,0,192,198,0,0,174,175,114,118,48,234,218,71,252,232,210,92,24,159,120,114,185,53,215,157,4,0,46,75,228,43,168,109,159,0,54,6,0,112,250,173,97,212,251,250,227,178,225,197,245,79,24,159,40,23,22,23,19,0,46,75,234,85,195,114,111,0,39,146,72,75,151,0,0,32,229,214,188,155,119,211,55,203,147,94,139,123,114,167,54,1,42,75,225,94,87,219,94,0,142,169,136,32,145,0,0,224,249,123,246,126,66,218,246,102,114,139,55,213,20,0,38,75,233,157,174,183,27,0,27,0,0,78,223,240,174,188,238,199,104,63,110,79,117,209,98,174,57,15,38,75,237,82,13,219,13,128,99,210,165,67,12,0,0,82,238,208,233,110,117,255,181,111,250,234,166,26,0,38,91,220,3,69,91,7,163,87,45,149,11,15,135,212,52,211,252,231,74,189,179,105,142,137,51,74,113,229,169,210,212,95,236,63,86,142,251,139,149,104,131,10,117,95,199,126,90,65,87,24,223,69,126,29,186,65,224,244,252,211,175,78,215,81,124,29,21,18,232,184,140,158,143,0,0,46,99,20,43,24,227,138,136,229,153,198,33,128,84,205,104,174,57,251,247,72,139,81,107,214,234,19,23,23,65,16,220,85,116,182,27,118,53,108,64,13,186,50,10,174,170,86,72,176,222,4,172,19,130,9,139,147,182,139,90,80,245,145,212,246,162,13,231,31,0,34,61,144,2,243,86,19,152,196,153,36,211,0,169,166,218,221,146,69,125,139,203,60,75,159,238,182,192,58,161,178,41,36,156,157,0,67,89,51,46,96,23,0,182,139,42,106,38,48,20,205,118,1,50,48,47,219,108,23,152,18,208,1,30,75,236,9,85,156,27,235,80,157,14,0,224,250,173,250,240,92,191,60,234,20,197,107,198,160,124,180,87,24,68,27,179,104,123,1,34,75,201,29,212,242,1,64,181,52,64,2,12,0,160,14,71,255,234,83,122,150,122,82,245,138,210,237,150,119,244,14,38,75,195,149,169,211,6,152,169,150,52,233,9,48,0,128,26,79,158,185,31,102,178,200,123,111,151,137,5,39,219,1,22,75,243,158,82,31,0,224,204,12,7,48,0,128,39,106,166,155,116,115,214,118,228,104,149,115,97,161,98,59,0,26,75,187,13,45,111,0,224,68,24,4,0,0,128,122,60,177,204,211,69,53,233,96,247,199,211,69,26,75,167,133,230,1,0,142,73,32,0,0,0,212,234,136,124,142,45,190,200,175,248,140,14,14,75,215,65,96,1,0,199,12,236,32,0,0,240,208,110,205,212,205,178,230,109,190,49,22,117,0,26,75,247,29,24,0,192,137,0,75,0,0,0,245,144,45,227,159,206,213,147,157,133,0,62,109,184,175,161,76,50,131,14,207,57,171,131,228,25,164,242,212,255,190,155,107,219,142,91,27,247,120,212,157,185,122,82,71,173,172,135,221,4,254,135,13,98,133,133,82,135,230,246,4,131,154,98,240,22,192,2,92,144,150,38,157,99,148,57,206,255,98,208,222,244,62,17,27,147,174,60,0,42,111,182,6,34,198,11,232,96,206,133,102,16,0,169,154,207,245,29,109,172,251,231,217,94,203,175,184,5,203,80,199,110,31,97,149,124,183,50,105,54,249,157,166,76,104,161,5,60,92,221,72,57,103,155,152,124,210,229,226,226,148,67,193,175,101,225,218,34,206,226,146,60,25,163,126,4,42,107,164,231,71,32,122,6,205,108,181,92,253,59,118,249,242,148,95,77,55,23,199,162,108,99,36,226,194,237,12,193,220,86,143,157,115,205,166,189,233,12,162,55,0,147,228,198,36,101,220,29,104,219,78,64,79,253,186,98,195,146,227,153,57,54,75,1,188,177,225,134,185,115,26,30,95,161,239,65,9,97,182,68,71,173,54,37,16,64,204,84,171,221,76,90,235,233,84,219,182,107,177,101,219,212,237,48,61,191,1,82,48,190,33,237,162,222,238,40,13,32,232,123,22,85,224,204,42,93,91,79,190,116,60,208,213,22,31,64,84,81,4,9,34,81,187,190,109,160,31,158,42,48,122,39,6,4,80,84,237,231,243,164,166,142,95,180,218,154,122,168,222,151,54,188,71,45,160,179,210,253,182,5,51,116,138,177,226,0,19,171,106,3,214,160,193,254,82,1,116,237,150,2,8,221,14,214,213,59,0,50,67,149,146,84,0,160,122,225,105,50,117,229,185,223,248,141,87,157,59,55,205,121,124,238,220,185,214,110,18,202,231,92,200,166,96,50,197,247,175,163,69,153,9,239,66,157,65,62,70,185,50,113,252,97,56,21,154,130,30,223,174,255,54,103,155,14,215,230,118,212,202,187,162,57,51,59,0,66,59,147,129,160,73,1,112,38,136,118,25,64,150,84,38,170,250,251,237,217,210,114,157,83,215,198,247,227,216,57,161,141,55,114,81,82,241,42,96,216,6,250,120,93,196,59,139,60,50,219,151,196,50,111,204,122,161,170,225,73,161,232,206,135,212,20,221,17,82,51,117,0,58,69,147,75,80,236,157,176,49,61,115,162,150,92,14,29,0,192,113,247,237,191,227,220,100,21,79,203,155,146,98,143,250,56,219,47,217,147,74,2,66,73,254,22,152,55,39,224,68,122,132,26,114,232,0,0,230,230,200,213,187,122,254,103,30,243,217,226,148,205,198,106,47,218,142,0,58,73,250,78,96,120,179,0,213,18,142,76,19,48,0,128,165,81,205,127,186,224,187,167,152,94,39,137,84,37,90,167,44,246,0,54,65,25,128,129,25,52,156,185,75,18,65,154,170,163,213,204,109,118,237,185,173,75,150,102,151,111,162,224,230,82,183,134,127,198,82,204,183,234,54,46,126,160,32,22,227,102,159,197,225,182,170,43,160,211,138,32,255,246,251,66,161,73,156,155,131,208,130,219,239,141,222,36,0,79,103,103,83,0,0,0,62,3,0,0,0,0,0,81,164,57,46,6,0,0,0,107,19,36,88,82,79,82,77,72,69,72,72,67,67,57,78,75,67,31,28,63,83,35,30,29,26,76,69,69,36,29,59,57,35,29,27,23,75,76,72,73,63,58,36,29,28,29,91,79,62,49,30,32,30,30,27,26,27,79,80,71,32,29,28,26,24,16,14,14,77,66,64,37,34,31,31,29,26,26,26,81,79,76,67,71,62,34,74,115,19,14,4,114,1,29,207,185,6,144,71,164,106,89,127,237,241,61,103,155,101,217,125,169,246,255,122,122,103,202,104,197,162,149,40,138,172,43,107,194,53,93,236,183,148,126,210,153,241,117,176,169,40,112,212,145,237,100,255,233,197,23,58,250,171,128,198,69,199,17,29,49,113,127,190,115,0,74,115,133,6,131,142,23,208,241,57,135,112,68,56,162,164,105,118,207,190,156,79,102,221,151,35,197,251,247,65,19,159,13,164,147,137,75,189,94,214,162,10,206,177,4,105,50,226,138,46,40,143,177,86,79,36,202,225,82,113,84,243,76,174,77,111,170,23,144,155,4,223,50,5,222,208,188,226,70,139,208,38,62,111,182,0,70,197,3,116,120,230,139,114,115,58,251,186,242,58,252,49,106,114,86,117,249,61,153,26,94,242,181,154,104,130,37,23,225,66,197,44,85,8,229,214,98,118,178,137,57,147,162,30,124,108,106,147,210,163,81,34,54,129,22,33,89,52,152,2,39,154,84,222,200,107,130,38,18,42,117,180,2,138,174,7,232,212,231,60,16,140,43,170,30,183,182,159,124,213,172,181,220,151,147,103,139,115,136,119,176,97,211,241,113,46,184,202,108,9,47,233,212,164,227,119,73,236,64,174,42,128,49,112,26,54,136,201,44,240,106,41,32,137,172,43,26,195,214,102,13,34,105,168,146,18,104,117,1,29,249,148,2,72,160,85,109,210,74,223,232,236,223,153,230,222,35,22,15,138,234,69,186,217,228,118,65,94,40,195,216,54,218,92,167,223,211,97,54,45,33,137,167,111,149,66,206,6,135,247,230,21,168,233,150,34,97,90,51,1,30,103,164,150,104,90,77,160,195,86,79,59,232,217,112,175,79,227,183,199,151,47,45,124,244,48,140,123,41,127,112,79,178,182,94,126,19,137,79,192,71,115,140,140,97,184,144,156,142,16,214,93,4,162,0,77,215,148,164,62,121,96,93,191,4,44,198,111,121,169,147,19,34,93,220,90,12,74,77,76,26,159,169,205,118,64,81,53,230,87,214,103,61,186,180,246,187,98,246,61,4,101,186,67,146,168,51,163,232,198,46,114,24,204,196,101,222,26,82,96,108,245,139,129,237,52,46,109,140,214,148,42,126,17,252,247,47,5,129,220,35,208,5,36,22,91,216,107,20,66,7,29,48,95,90,53,84,112,170,199,30,227,165,233,120,188,226,191,232,183,138,155,211,205,248,218,22,237,89,94,165,94,160,233,238,8,98,101,146,14,154,69,192,175,0,163,53,218,108,136,14,252,72,43,96,16,171,10,28,197,1,30,87,206,107,53,89,60,88,8,87,203,137,92,226,174,40,49,163,46,87,238,233,166,110,71,157,58,45,91,97,249,13,239,188,134,132,108,114,196,240,8,19,52,18,64,101,47,64,111,124,13,26,152,119,67,23,96,40,223,126,241,50,226,42,189,56,0,30,73,193,106,97,89,125,98,242,144,219,180,101,114,81,30,156,235,145,226,80,188,92,33,114,198,241,229,138,69,209,174,138,197,185,179,85,124,152,0,73,7,188,71,208,84,225,14,198,5,1,100,237,72,136,130,2,74,97,44,131,192,153,64,222,94,178,112,243,206,56,245,139,87,93,216,249,203,255,238,205,125,124,238,254,115,117,96,158,237,60,207,179,207,56,53,53,69,128,191,255,127,128,73,92,199,49,222,248,246,19,166,152,8,0,231,131,197,36,32,77,5,166,104,11,109,223,132,43,60,87,166,12,1,1,102,113,88,2,103,250,0,13,103,18,132,64,45,83,205,166,221,234,126,206,243,228,255,227,72,191,109,234,5,71,1,67,82,193,226,34,144,180,174,245,230,210,41,244,227,120,135,121,121,148,218,48,88,91,83,13,93,140,188,194,109,38,116,186,198,193,135,97,219,17,197,150,237,107,0,54,89,20,76,225,228,170,34,210,9,213,139,170,251,254,33,75,35,251,141,62,63,215,85,243,65,179,227,182,40,76,76,128,86,120,42,54,51,84,236,243,88,59,236,1,192,80,0,106,151,235,68,21,253,172,171,136,54,198,215,116,26,216,213,168,154,0,58,75,201,171,198,165,220,0,170,37,8,154,112,14,0,128,228,137,103,239,220,211,210,76,127,108,178,168,24,85,0,38,75,227,217,164,183,13,128,99,210,33,224,0,0,112,173,142,108,169,109,153,110,143,102,169,175,182,9,30,75,229,30,0,0,84,203,28,107,76,80,10,3,16,207,56,162,175,229,104,218,53,255,229,63,103,162,195,245,82,106,107,19,29,174,151,82,91,155,232,112,61,255,108,66,180,238,82,27,19,173,186,212,202,68,171,245,212,198,173,158,0,82,57,85,7,0,0,246,82,138,50,47,110,227,146,133,241,235,215,151,108,215,241,255,170,234,11,115,100,244,182,200,105,136,78,68,95,53,169,133,1,23,93,155,92,113,65,13,82,15,209,13,169,186,139,110,10,169,1,23,221,54,169,138,139,174,77,174,184,128,153,90,79,162,73,162,73,226,36,113,146,56,9,0,82,71,116,47,132,225,228,4,84,75,58,50,29,232,0,0,218,210,44,135,172,121,155,55,222,252,118,206,160,54,111,158,9,1,0,54,75,236,171,134,165,157,0,230,1,0,112,125,149,191,14,110,238,156,207,203,115,169,30,153,158,45,99,240,0,42,75,237,210,20,154,177,1,108,0,0,232,255,115,83,85,188,126,142,138,239,85,133,239,35,202,53,8,0,30,75,227,73,215,167,1,128,19,9,4,12,0,0,218,62,77,94,51,155,251,105,245,160,206,3,38,87,55,205,192,40,159,65,203,106,245,164,235,76,43,35,190,140,159,238,175,188,253,186,248,226,254,248,114,239,229,90,59,103,109,119,97,247,227,254,170,86,121,188,44,147,58,251,224,79,164,81,60,151,229,11,95,7,166,100,98,57,24,43,19,1,192,84,220,196,2,58,5,201,1,0,58,93,91,37,24,100,119,208,184,90,56,35,62,164,202,178,218,125,206,54,210,183,174,199,219,55,255,87,212,94,77,40,46,157,168,216,222,188,22,118,212,236,0,219,133,77,148,2,209,7,2,123,68,127,76,31,195,198,72,0,124,12,69,14,28,115,209,4,0,30,65,189,89,141,183,143,2,72,85,39,114,94,101,238,179,155,145,242,207,59,67,241,163,71,190,103,197,198,116,221,13,118,202,122,204,165,49,48,148,53,128,98,187,0,244,178,82,80,198,37,173,139,64,233,34,32,160,220,252,34,49,148,218,105,80,76,80,0,30,75,240,40,134,83,158,0,170,37,72,203,48,134,48,0,96,196,118,204,47,111,158,53,95,99,254,115,9,103,3,187,233,210,4,0,18,75,234,78,140,219,13,128,106,73,146,12,16,0,0,168,87,101,219,145,89,174,159,148,15,181,200,0,0,18,75,226,4,0,0,206,48,212,225,136,82,24,0,115,165,167,207,219,223,191,241,198,147,191,73,137,187,176,135,184,255,201,202,143,251,27,87,126,236,195,42,141,248,177,83,171,212,226,79,78,227,254,218,26,127,69,22,0,26,73,122,15,0,11,176,39,79,1,215,10,125,126,170,172,15,203,215,207,219,126,154,186,212,57,79,50,77,122,176,109,39,153,171,216,137,181,0,128,222,234,205,39,69,79,107,98,70,10,39,129,208,165,19,94,2,18,75,230,142,10,205,7,232,48,79,7,0,224,136,207,234,233,116,244,252,249,105,188,112,54,246,83,115,120,182,131,196,27,189,12,18,75,243,158,196,55,128,9,243,0,0,232,67,127,10,85,253,117,117,124,47,30,108,137,132,157,85,138,3,30,75,247,29,143,13,32,135,99,230,16,112,0,0,152,79,179,101,210,226,222,44,71,166,214,198,0,30,75,223,96,0,64,14,27,0,0,140,249,176,158,239,139,63,117,241,195,131,20,0,86,109,89,90,226,176,195,42,29,78,245,212,212,75,158,42,243,248,125,201,222,121,190,189,211,211,157,92,249,145,109,73,199,125,210,76,50,27,69,165,12,106,103,31,137,10,95,135,253,65,130,253,207,85,192,253,107,67,255,138,168,195,227,42,171,24,132,118,190,238,117,212,85,210,1,74,113,149,4,46,245,21,52,123,14,8,146,9,138,42,127,227,85,255,219,113,230,245,211,207,174,171,185,58,26,176,163,171,251,36,49,219,118,166,95,98,226,80,186,102,4,75,88,204,64,97,212,184,59,52,22,34,250,114,186,231,6,56,18,154,93,8,80,100,118,53,230,130,106,35,14,62,105,5,165,194,208,66,7,45,112,206,36,65,38,130,180,213,111,74,219,191,34,218,181,219,151,60,174,87,228,177,90,198,170,119,208,42,114,54,126,183,93,40,216,8,212,204,226,167,103,66,222,163,48,227,46,54,184,244,2,168,223,96,22,96,189,169,30,77,19,210,1,58,97,26,83,250,148,116,88,119,73,245,162,169,35,123,9,115,105,244,222,171,218,255,30,135,167,98,172,180,220,101,211,39,18,93,45,157,4,13,115,64,118,21,74,211,170,189,57,252,14,106,187,27,64,209,3,73,84,0,22,6,64,224,50,99,102,13,96,94,130,50,166,3,50,73,18,209,250,180,244,4,26,87,203,61,2,66,142,170,182,199,205,177,223,159,127,23,121,94,31,209,72,137,133,226,118,83,165,219,200,144,205,174,73,173,198,218,48,120,176,90,2,53,240,245,186,175,5,0,205,101,61,192,24,128,2,54,63,168,164,212,233,23,43,136,158,72,119,194,64,165,83,202,209,157,15,245,62,247,182,171,159,132,174,185,95,113,162,47,232,248,154,53,13,208,1,248,161,0,123,4,160,239,30,4,92,254,118,9,76,60,160,224,1,42,77,234,67,212,203,118,0,39,42,151,22,242,132,0,128,120,31,165,121,222,85,118,235,42,191,201,130,229,47,212,161,94,12,192,4,42,75,238,94,208,203,185,0,156,184,11,227,2,0,0,28,221,212,218,63,241,140,39,61,217,9,107,1,7,42,75,233,157,170,183,55,0,78,36,144,66,28,0,0,82,235,233,223,57,71,222,239,103,156,68,67,13,34,75,237,106,210,203,13,128,99,42,50,73,27,0,0,240,124,150,172,179,164,228,121,223,212,55,142,22,0,34,67,54,0,193,0,80,189,164,165,232,248,183,226,240,220,254,61,155,171,42,239,181,199,58,142,228,166,110,105,82,147,111,13,151,182,162,110,21,220,42,212,127,98,131,63,177,193,159,216,224,79,168,3,135,89,22,79,48,153,101,48,155,225,108,85,75,166,90,50,213,146,85,45,153,225,210,214,112,105,107,216,173,130,91,5,66,163,133,6,0,58,95,135,28,72,94,102,48,122,103,184,124,138,36,21,83,61,190,246,58,218,44,186,154,219,219,101,239,141,220,125,37,95,33,46,218,7,94,54,11,137,237,133,196,58,39,214,153,117,182,73,123,13,72,13,120,53,94,29,16,24,176,108,30,43,117,0,248,191,86,160,209,115,57,68,119,237,97,2,46,69,189,32,244,229,173,15,24,117,52,213,131,41,115,227,8,21,47,94,47,53,126,51,85,190,167,10,182,138,199,104,203,137,170,147,136,15,55,216,3,244,7,212,224,77,102,27,216,225,131,142,88,39,58,192,170,43,93,20,64,3,34,73,250,67,12,167,51,0,68,54,101,50,232,75,170,203,165,143,139,135,49,102,122,157,171,190,146,172,179,34,198,190,128,31,10,134,193,176,171,2,184,93,128,70,119,32,129,171,6,18,75,226,78,15,219,88,0,54,0,0,92,159,251,49,114,251,145,163,243,185,167,40,15,93,168,168,131,244,0,22,75,201,37,21,31,27,0,213,18,38,127,176,100,0,0,198,228,221,113,92,149,119,233,201,10,217,4,146,208,2,0,26,75,203,94,8,31,0,19,230,25,0,64,223,243,115,11,215,155,234,233,175,170,231,108,35,129,232,83,43,0,22,75,199,69,224,6,176,160,90,106,131,0,0,0,48,191,250,154,229,137,165,217,246,182,245,68,34,81,44,3,22,75,215,145,176,1,44,56,17,96,141,1,0,0,36,109,150,207,114,103,239,26,22,111,77,116,7,26,75,119,3,99,1,228,176,0,0,208,159,110,15,234,125,92,210,203,202,131,147,245,82,251,4,26,75,143,41,7,0,15,199,164,67,2,0,0,208,57,98,27,125,122,110,207,145,173,220,234,39,0,38,91,94,130,34,195,12,203,198,213,179,148,212,59,119,242,233,55,46,196,237,157,123,227,142,95,156,139,255,122,145,175,221,221,40,88,255,190,140,55,10,55,132,189,137,227,32,142,63,166,36,3,113,159,50,197,7,19,113,32,252,49,10,127,48,62,71,115,97,239,67,83,60,199,158,11,218,1,0,86,109,146,131,132,190,130,78,103,207,76,229,199,91,174,26,47,148,62,46,89,56,255,56,190,29,63,216,234,174,26,136,105,59,181,76,92,174,131,185,173,50,105,28,164,88,91,114,44,90,158,222,99,62,92,84,75,172,33,20,150,115,170,49,3,179,105,122,26,57,104,186,181,238,139,89,240,130,210,0,54,91,8,244,184,104,175,72,244,195,59,159,202,205,189,254,240,167,250,122,51,126,228,114,177,114,252,207,216,202,36,130,186,36,146,10,69,60,243,178,237,198,197,6,248,48,204,58,1,236,162,6,124,128,224,107,204,203,48,221,134,99,168,55,1,4,225,29,146,64,2,50,77,233,83,213,195,88,0,170,165,113,8,231,0,0,72,117,204,17,253,115,173,98,235,155,73,37,10,9,209,233,0,42,75,203,137,214,203,9,128,106,73,199,128,4,0,64,141,115,178,215,211,252,190,90,178,165,123,72,2,0,34,75,251,141,168,222,0,22,156,152,99,105,0,0,128,103,156,253,204,51,105,214,236,204,135,186,60,0,34,75,207,78,160,1,88,112,76,0,9,3,0,0,159,37,111,71,159,250,108,123,242,177,14,0,26,75,223,96,1,128,135,5,0,128,62,159,93,156,110,10,207,229,175,238,182,42,59,0,34,75,191,16,1,192,67,3,0,64,234,9,119,121,38,0,34,75,191,16,1,192,195,28,0,0,0,202,22,0,34,73,159,11,254,26,0,15,12,0,0,216,16,0,66,93,253,20,108,177,28,216,108,147,234,197,180,228,185,115,113,251,229,235,175,239,228,241,175,94,85,25,123,123,211,44,159,59,74,5,238,207,159,178,238,159,41,249,252,81,62,38,21,96,37,62,1,255,61,37,0,2,40,246,78,32,21,4,254,149,240,249,220,191,66,11,142,41,11,112,1,62,89,219,9,88,104,7,178,59,162,90,192,57,163,85,189,223,243,246,248,98,219,218,107,234,187,94,249,6,12,102,201,249,132,253,124,176,215,21,67,197,68,195,170,235,224,30,214,214,0,53,188,173,26,235,15,28,192,184,2,248,154,4,170,19,0,46,69,171,71,58,52,247,174,128,51,105,226,1,72,85,58,115,214,164,61,246,56,47,181,110,62,72,227,160,105,27,18,161,225,237,61,37,49,232,5,198,64,3,59,160,108,23,96,15,56,135,106,130,113,97,12,67,1,227,34,191,193,108,3,42,73,249,44,198,225,230,4,84,167,3,0,216,81,190,247,248,159,131,210,244,168,175,127,199,218,88,85,66,76,131,149,218,85,45,20,12,26,75,246,79,143,203,190,1,204,51,0,128,211,167,159,99,195,117,212,193,112,91,184,243,215,79,82,242,132,73,230,171,3,0,26,75,252,171,134,211,190,1,108,0,0,216,75,157,149,14,246,194,116,243,231,102,184,230,51,107,218,107,105,86,10,22,75,228,73,199,225,25,0,78,4,65,36,72,0,0,76,105,251,221,181,221,179,239,214,116,15,22,149,180,76,0,30,75,238,14,245,103,1,19,170,229,4,145,38,6,0,0,71,249,230,170,221,188,242,39,45,171,113,2,0,18,75,233,149,214,143,5,128,13,0,0,123,169,107,233,160,95,95,204,195,202,233,65,73,18,0,14,75,195,94,8,63,0,224,152,112,156,3,0,0,166,117,196,90,77,23,106,109,99,101,172,1,26,75,235,61,9,63,0,19,142,185,67,144,0,0,64,157,99,218,122,66,215,229,107,124,41,0,66,111,92,91,8,29,175,36,122,137,57,183,0,97,21,74,38,55,43,63,206,37,117,75,219,175,243,125,251,212,179,173,225,217,221,179,130,124,195,165,142,131,239,170,63,240,167,113,240,7,88,192,202,190,50,101,233,31,172,48,184,0,206,42,206,231,55,156,15,86,130,215,20,232,207,7,174,172,216,115,18,66,111,182,112,226,66,56,64,115,206,33,152,72,4,138,166,60,222,222,241,95,247,95,211,199,63,180,211,230,42,202,31,12,33,240,46,206,205,90,47,74,25,8,193,166,73,1,246,123,105,146,205,203,169,148,37,13,226,97,231,10,210,99,66,129,89,61,82,167,113,155,218,135,12,50,112,206,62,0,46,111,166,239,125,84,58,116,208,35,183,122,218,92,63,110,190,154,182,88,245,60,18,135,55,199,167,24,153,126,98,121,55,91,159,137,52,93,229,205,124,81,227,178,149,29,198,113,103,2,45,243,227,0,193,113,213,191,150,211,54,237,25,146,216,224,160,83,212,204,205,104,148,100,74,0,30,99,166,112,2,250,12,26,206,9,144,48,170,218,166,92,165,120,202,250,53,247,117,181,183,55,169,134,94,165,182,230,141,101,90,87,21,230,84,180,80,67,82,156,31,23,232,203,211,9,123,184,254,131,53,104,58,151,170,159,32,93,57,188,117,6,0,22,83,101,229,68,17,253,2,204,213,91,53,47,110,165,83,213,245,125,121,244,216,212,35,143,109,218,89,141,141,66,21,221,44,60,217,203,108,240,67,53,157,49,2,54,72,128,197,185,29,96,221,1,248,237,10,104,208,110,86,47,64,244,91,44,66,160,235,54,207,1,30,59,11,245,142,88,53,178,196,45,236,109,169,105,244,135,239,197,170,247,111,143,207,79,155,67,44,183,185,147,74,130,30,1,208,3,59,158,49,128,4,248,69,171,14,88,87,209,20,146,226,3,192,37,221,187,76,128,93,112,116,0,34,75,199,181,27,151,192,75,179,41,0,132,178,135,194,94,174,48,237,198,92,248,149,119,50,248,10,96,205,51,6,184,4,0,79,103,103,83,0,0,0,230,3,0,0,0,0,0,81,164,57,46,7,0,0,0,154,47,147,174,84,30,27,26,64,84,39,32,29,28,73,71,59,27,27,78,77,68,40,28,27,26,24,24,21,20,77,71,65,32,28,88,74,70,65,20,16,79,73,68,70,69,70,86,38,36,34,33,76,71,51,34,33,70,57,38,36,32,78,76,72,40,36,33,30,32,30,29,28,78,67,66,40,32,35,31,29,25,27,26,79,78,80,71,69,34,75,183,179,135,1,144,224,4,131,0,42,0,0,115,171,167,153,233,166,164,120,98,251,32,82,74,113,18,0,30,75,31,137,55,0,68,88,12,0,160,47,59,43,84,249,246,114,196,16,31,218,82,154,75,8,0,30,75,223,224,3,0,30,78,36,193,18,0,0,128,76,155,103,245,78,170,74,75,26,106,22,17,30,73,199,196,147,7,112,37,204,151,194,0,208,199,159,199,99,197,202,75,30,95,207,166,98,61,88,239,250,210,212,111,155,232,96,61,181,181,63,58,184,52,181,21,27,174,167,86,38,90,207,43,19,173,231,213,38,90,47,253,108,250,9,0,62,57,43,3,72,0,224,1,35,145,74,73,101,82,119,253,238,91,183,205,219,165,231,183,63,21,100,221,145,122,205,108,60,83,233,248,47,219,133,133,122,120,217,164,6,92,116,147,43,46,186,201,21,23,221,228,74,61,186,93,168,184,232,38,87,90,127,209,250,207,104,253,133,78,52,47,116,162,121,161,19,205,11,0,46,73,43,119,180,110,126,156,192,238,76,88,230,0,232,0,0,234,243,116,89,155,246,238,73,237,179,190,141,111,4,59,229,9,30,143,69,5,0,42,71,250,78,212,15,0,176,49,0,128,62,234,251,248,217,207,241,145,60,141,31,215,163,55,103,199,189,130,83,3,0,22,75,230,86,175,205,216,0,142,153,137,181,76,44,1,0,240,60,197,254,220,170,180,249,116,173,178,164,10,22,75,233,85,140,203,13,128,19,97,16,48,0,0,168,199,87,249,241,111,151,254,54,171,7,117,30,0,26,83,162,102,0,14,208,80,45,9,132,67,41,92,93,219,77,187,28,149,79,29,205,158,199,175,50,127,227,87,181,124,235,127,188,209,242,173,255,201,170,87,255,252,65,91,76,49,57,133,41,38,159,0,148,249,227,83,236,57,87,1,130,137,253,241,241,40,14,134,208,31,26,34,85,221,54,71,11,4,38,29,157,249,97,171,177,207,195,112,112,208,191,92,158,10,85,35,197,110,102,59,113,98,95,199,239,166,122,71,139,222,219,77,143,171,24,214,52,118,120,224,63,87,61,194,3,140,94,102,54,169,13,213,193,30,53,4,116,160,129,223,124,0,26,61,207,137,64,151,90,113,226,62,160,39,2,44,141,107,58,149,241,145,37,235,219,90,219,35,171,113,89,2,103,199,96,15,81,133,2,240,246,14,176,93,65,13,88,143,171,127,13,192,30,96,87,179,78,136,78,13,10,26,75,223,64,3,64,132,99,18,72,160,1,0,234,245,100,165,205,83,191,197,11,52,72,2,116,0,30,75,191,192,0,160,132,99,230,120,58,84,0,0,230,115,100,225,184,146,37,139,4,18,39,1,0,42,83,5,6,69,81,7,104,168,158,105,170,57,95,92,184,254,127,241,87,151,120,255,127,241,197,133,13,216,77,218,146,242,247,144,246,175,106,149,199,85,85,248,197,33,227,170,242,193,87,13,236,179,127,225,194,133,11,56,203,71,202,80,234,172,208,53,90,103,229,249,36,125,122,183,177,206,3,98,113,154,131,194,194,1,58,234,153,116,70,144,151,114,181,222,172,63,222,170,54,251,110,247,172,150,215,55,152,176,83,131,179,187,226,111,232,99,195,166,49,198,152,209,115,75,97,142,4,18,221,124,178,219,24,54,5,231,39,139,44,43,65,240,116,99,97,42,19,70,70,194,108,150,91,2,66,97,156,168,225,195,233,32,53,159,169,230,94,95,248,235,224,251,217,84,245,220,227,31,251,158,88,44,34,36,45,227,18,96,191,193,14,253,236,7,18,139,192,195,90,24,182,78,88,123,151,151,96,14,87,233,128,0,125,3,78,153,183,189,185,136,130,2,62,77,233,43,50,180,27,192,60,17,50,100,127,195,77,213,252,120,121,24,239,169,56,149,37,39,108,103,79,135,29,0,199,1,28,160,4,0,215,1,46,75,227,85,15,219,2,192,49,9,36,72,0,0,82,139,188,61,250,180,46,107,29,221,28,87,17,0,18,75,203,206,164,31,0,224,216,7,164,49,0,0,56,22,149,103,245,191,106,214,110,210,90,21,0,22,75,215,81,80,27,0,56,166,1,31,2,0,0,56,28,125,178,190,238,89,126,217,13,5,0,26,75,191,32,0,128,5,199,36,120,56,0,0,160,22,71,106,29,89,84,182,136,9,0,30,75,127,142,1,64,14,199,204,160,0,0,0,96,166,158,20,252,227,109,211,132,9,0,30,75,191,96,3,64,132,35,2,172,1,0,0,224,31,7,218,214,209,38,0,30,73,159,11,110,0,72,112,4,176,4,0,0,96,87,65,251,165,22,0,30,79,43,4,0,34,104,102,190,20,51,157,231,249,206,215,95,127,253,245,248,60,103,93,159,59,55,53,197,255,255,255,63,83,83,83,22,255,255,255,244,148,5,37,232,41,184,127,165,227,224,175,12,171,18,0,227,3,51,37,183,254,199,21,26,1,254,254,161,11,112,157,241,83,56,251,18,46,91,219,6,52,38,29,52,126,210,144,17,152,98,170,213,110,158,53,223,234,223,175,181,253,183,82,121,216,97,144,45,76,98,74,114,84,151,139,184,119,129,66,230,2,227,98,24,136,235,226,173,27,128,53,216,128,175,5,5,59,112,118,235,14,196,100,242,81,30,0,26,61,245,34,214,229,209,23,116,228,174,166,90,102,66,205,17,170,106,190,154,233,231,137,181,107,39,229,67,141,190,204,117,87,4,171,7,54,88,117,0,12,171,2,88,91,143,11,236,32,104,140,25,10,31,52,216,160,75,224,221,184,224,93,2,22,75,240,40,214,173,13,0,243,4,0,192,17,63,235,235,245,149,241,62,30,25,253,175,244,236,22,138,140,13,12,3,18,75,230,86,140,31,163,1,213,229,152,52,72,227,0,0,80,139,47,235,159,203,172,211,55,94,41,0,26,63,161,166,0,76,28,121,243,165,152,153,246,57,207,142,20,174,59,122,184,189,92,143,21,167,231,213,112,105,107,240,39,54,248,19,43,109,13,151,182,170,63,177,193,159,224,182,134,75,86,53,199,6,87,193,173,2,244,44,139,117,0,186,191,10,142,106,142,45,86,60,165,154,77,53,131,116,114,74,193,253,4,7,185,44,158,0,66,113,188,54,64,176,25,116,228,234,201,85,127,86,184,61,118,117,56,106,135,207,202,241,186,224,3,247,20,35,184,168,99,244,170,113,71,20,121,203,200,145,238,146,77,231,54,160,75,133,171,179,76,115,120,44,16,44,67,118,21,206,180,96,69,192,70,133,253,98,198,150,41,76,38,97,170,231,3,96,38,34,87,109,3,8,104,66,154,106,158,81,109,122,255,93,235,237,255,49,71,97,46,90,214,197,153,219,151,84,132,218,78,187,132,203,117,213,24,118,67,193,227,9,179,13,20,236,60,125,15,113,85,114,210,64,235,160,176,193,170,3,118,1,38,71,235,214,236,31,5,130,21,149,217,180,148,100,85,9,156,14,52,120,136,19,160,86,168,85,195,30,53,48,27,99,53,5,0,219,3,246,155,225,89,76,20,121,244,75,190,5,158,76,82,145,199,121,32,84,214,98,240,20,188,225,18,29,0,38,75,167,117,181,126,0,77,69,48,24,0,32,139,11,96,12,10,72,0,42,75,119,115,85,159,128,34,4,2,0,0,99,176,33,36,66,113,61,12,160,202,140,80,51,231,22,128,132,42,158,154,109,223,172,233,22,255,221,247,171,102,77,198,100,35,210,49,215,210,198,145,208,247,185,187,130,114,27,115,1,43,140,143,247,39,87,6,64,220,55,90,176,119,130,85,134,56,104,188,130,116,1,205,36,76,223,63,127,252,51,217,207,149,0,70,115,61,9,146,200,5,116,188,231,192,229,49,72,83,179,187,158,169,230,215,60,141,55,109,77,165,241,83,20,58,71,201,222,138,179,157,109,208,74,193,105,162,140,97,34,108,8,238,61,121,13,160,219,17,184,42,30,26,93,185,183,76,83,8,7,39,225,173,118,99,158,2,62,113,145,2,49,226,1,203,134,39,221,46,96,138,170,143,82,235,255,10,154,38,190,46,123,164,46,212,155,109,215,134,237,78,246,199,117,219,25,71,145,99,203,129,157,199,244,220,118,41,64,161,209,107,252,18,249,87,5,164,171,130,103,157,206,23,242,60,58,97,22,209,106,25,245,2,6,239,156,194,5,225,136,162,106,54,135,35,173,207,109,215,55,139,188,109,106,117,89,120,108,16,237,179,160,90,8,48,19,92,101,158,176,94,118,116,28,202,104,7,77,131,57,19,123,140,224,128,249,54,9,130,143,92,70,112,124,0,50,81,28,4,150,187,78,152,167,23,51,159,166,58,156,254,186,25,185,119,189,127,221,156,191,55,151,222,122,220,176,100,218,195,201,38,1,59,63,84,211,169,66,75,219,2,32,51,61,177,12,7,224,160,166,30,209,192,102,203,0,1,231,134,193,242,148,76,0,58,65,222,0,64,4,204,207,10,51,173,93,106,47,121,222,133,178,251,135,242,237,174,187,45,206,31,181,192,46,61,44,255,241,191,167,226,238,95,123,138,239,159,49,194,159,207,68,72,171,122,38,124,189,192,46,224,28,215,79,228,125,233,40,241,141,83,5,18,1,74,59,253,18,0,0,60,65,242,4,102,165,148,194,170,154,217,182,252,56,187,116,54,241,40,79,61,62,103,79,134,73,221,6,31,193,117,193,201,47,136,189,204,227,49,43,143,176,8,239,244,50,247,206,188,204,147,196,108,243,120,204,54,111,194,178,205,187,176,108,243,14,203,202,59,189,172,188,75,47,115,239,80,228,131,4,66,69,147,19,104,198,217,96,143,234,116,0,0,167,255,28,87,172,126,252,171,251,155,245,126,78,125,33,112,22,242,89,7,157,189,2,171,2,78,73,250,18,164,197,6,156,73,131,112,121,116,0,0,115,122,250,57,254,53,71,10,148,205,42,236,221,65,221,214,155,223,140,102,0,78,73,244,30,52,111,22,224,76,24,132,0,6,0,48,101,82,95,253,44,247,127,27,121,229,215,21,1,46,123,187,221,24,0,54,75,244,43,178,45,0,156,237,134,49,1,3,0,120,18,186,218,223,218,151,254,88,239,7,179,241,8,41,42,74,73,0,82,91,147,14,192,202,5,52,84,79,59,213,157,243,243,183,27,247,186,98,245,225,216,120,161,232,191,163,163,43,153,76,38,235,117,63,126,52,26,141,14,40,207,12,26,148,149,80,32,72,159,249,57,148,66,90,58,142,252,65,61,229,48,152,108,24,35,22,64,199,158,48,85,150,6,0,70,77,253,148,170,205,206,128,141,116,116,206,4,226,242,103,82,102,234,157,106,179,92,117,117,174,249,151,234,249,194,82,29,94,29,150,188,34,109,13,5,24,43,214,198,248,184,106,183,6,96,216,24,118,53,252,189,183,139,38,204,192,179,0,24,46,118,160,123,52,0,34,69,253,171,174,139,221,10,176,62,115,194,193,134,14,202,224,184,75,237,55,155,202,254,239,90,193,144,100,86,201,43,82,91,145,144,88,4,246,168,1,5,2,220,170,195,58,129,94,173,1,38,71,241,41,234,237,4,192,147,132,7,128,1,0,204,233,219,123,123,151,29,169,187,186,122,223,97,59,51,101,146,13,189,1,42,75,252,143,10,203,122,64,134,234,0,0,216,81,222,165,10,127,42,84,168,26,239,233,90,253,122,101,166,118,214,73,0,38,73,176,0,1,11,34,60,119,68,28,87,120,145,65,93,83,205,247,28,251,237,109,159,232,84,56,179,26,81,179,243,63,76,166,228,191,60,145,63,226,78,71,11,42,111,144,223,242,71,220,167,19,202,45,31,177,211,17,135,124,6,63,87,52,65,145,167,9,0,30,71,242,14,0,0,156,73,71,0,178,36,3,204,49,148,118,174,243,154,167,29,52,216,178,42,39,67,243,0,249,146,138,235,5,0,92,235,67,209,121,139,250,222,69,111,222,242,37,205,250,70,245,129,174,8,0,26,75,248,3,152,242,1,80,45,225,8,72,42,0,0,203,169,201,151,202,147,179,178,51,159,190,100,180,68,209,245,156,229,107,202,140,175,1,22,75,228,9,154,117,2,56,115,18,144,67,7,0,112,52,222,72,199,146,82,122,206,148,178,118,165,210,153,137,65,15,243,120,4,0,30,75,225,78,209,195,7,0,213,146,164,193,193,0,0,92,34,234,121,42,82,221,174,168,86,135,99,68,117,129,97,0,30,73,94,42,56,152,65,67,245,204,76,117,173,174,235,75,246,253,159,227,167,234,235,118,229,117,133,99,225,168,113,105,190,241,47,86,222,26,92,45,254,123,68,8