/*

 The MIT License (MIT)

 Copyright (c) 2014 MARTIN Damien

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.

 */

// Keep screen "on"
navigator.requestWakeLock('screen');

// Init timer
var timer = 0;

/**
 * Display the remaining timer for the current timer.
 */
function displayCountdown(){

    var minutes = Math.floor(timer / 60);
    var seconds = timer % 60;

    if (seconds < 10){
        seconds = "0" + seconds;
    }

    $("#countdown").html("" + minutes + "'" + seconds + '"');

}

/**
 * Update timer every seconds.
 */
function tick(){

    timer -= 1;

    if (timer > 0){

        if (timer == 5 || timer == 4 || timer == 3 || timer == 2 || timer == 1){
            document.getElementById("beep").play();
        }

        setTimeout("tick()", 1000);
        displayCountdown();
    } else {
        finish();
    }

}

/**
 * Finish the timer by beeping and returning to timer selection.
 */
function finish(){

    window.navigator.vibrate([200, 200, 200, 200, 200]);
    document.getElementById("long-beep").play();

    $("#timers").removeClass("hidden");
    $("#timer").addClass("hidden");

}

$(document).ready(function(){

    /**
     * Launch timer.
     * Get value from the clicked button and launch the timer.
     */
    $('.timer-button').on('click', function(){

        // Launch timer

        $("#timer").removeClass("hidden");
        $("#timers").addClass("hidden");

        minutes = parseInt($(this).attr('data-minutes'));
        seconds = parseInt($(this).attr('data-seconds'));

        timer = minutes * 60 + seconds + 1;

        displayCountdown();
        tick();

    });

    /**
     * Cancel a running timer and display the timer selection screen.
     */
    $('.cancel-button').on('click', function(){

        timer = -1;

        $("#timers").removeClass("hidden");
        $("#timer").addClass("hidden");

    });

});