angular.module('joke', ['ngAnimate']);

angular.module('joke').factory('jokes', [
  'jokes_data',
  function(jokes_data){
    var LISTENERS = [];
    var JOKES = jokes_data;
    var NEXT = Math.round(Math.random() * JOKES.length);
    
    return {
      change: function(fn){
        LISTENERS.push(fn);
      },
      next: function(){
        angular.forEach(LISTENERS, function(fn){
          fn.call(null, JOKES[nextran()].joke);
        });
      }
    }
    
    function next(){
      var res = NEXT++;
      if(NEXT >= JOKES.length) { NEXT = 0; }      
      return res;
    }
    
    function nextran(){
      return Math.round(Math.random() * JOKES.length);
    }
  }
]);

angular.module('joke').controller('jokesCtrl', [
  '$timeout', '$document', 'jokes',
  function($timeout, $document, jokes){
    $timeout(jokes.next, 500);
    
    this.next = function(){
      jokes.next();
    }
  }
]);

angular.module('joke').directive('joke', [
  '$compile', '$animate', '$sce', '$q', '$timeout', 'jokes', 'rename',
  function($compile, $animate, $sce, $q, $timeout, jokes, rename){
    var JOKE_EL = '<div class="joke" ng-bind-html="joke"></div>';
    var CURRENT;
    
    return {
      restrict: 'E',
      link: function(scope, element, attrs){
        jokes.change(setJoke);

        var prom, prom2;
        
        function setJoke(text) {          
          if(CURRENT) CURRENT.remove();
          
          if(rename.rename === true) {
            text = text.replace(/(Chuck) (Norris)/g, '<span class="chuck">' + rename.first_name + ' ' + rename.last_name + '</span>');              
          } else {
            text = text.replace(/(Chuck) (Norris)/g, '<span class="chuck">$1 $2</span>');              
          }
          
          scope.joke = $sce.trustAsHtml(text);
          CURRENT = angular.element(JOKE_EL);
          $compile(CURRENT)(scope);
          $animate.enter(CURRENT, element).then(function(){ prom2 = false; });
        }
      }
    }
  }
]);

angular.module('joke').value('rename', { rename: false, first_name: '', last_name: '' });

angular.module('joke').value('jokes_data', [ { "id": 211, "joke": "Nothing can escape the gravity of a black hole, except for Chuck Norris. Chuck Norris eats black holes. They taste like chicken.", "categories": [] }, { "id": 193, "joke": "Most boots are made for walkin'. Chuck Norris' boots ain't that merciful.", "categories": [] }, { "id": 142, "joke": "Hellen Keller's favorite color is Chuck Norris.", "categories": [] }, { "id": 52, "joke": "When Chuck Norris sends in his taxes, he sends blank forms and includes only a picture of himself, crouched and ready to attack. Chuck Norris has not had to pay taxes, ever.", "categories": [] }, { "id": 341, "joke": "Chuck Norris sleeps with a pillow under his gun.", "categories": [] }, { "id": 456, "joke": "All browsers support the hex definitions #chuck and #norris for the colors black and blue.", "categories": ["nerdy"] }, { "id": 62, "joke": "Some people like to eat frogs' legs. Chuck Norris likes to eat lizard legs. Hence, snakes.", "categories": [] }, { "id": 339, "joke": "Think of a hot woman. Chuck Norris did her.", "categories": [] }, { "id": 267, "joke": "Ozzy Osbourne bites the heads off of bats. Chuck Norris bites the heads off of Siberian Tigers.", "categories": [] }, { "id": 51, "joke": "The quickest way to a man's heart is with Chuck Norris' fist.", "categories": [] }, { "id": 484, "joke": "Chuck Norris is actually the front man for Apple. He let's Steve Jobs run the show when he's on a mission. Chuck Norris is always on a mission.", "categories": [] }, { "id": 183, "joke": "Chuck Norris invented a language that incorporates karate and roundhouse kicks. So next time Chuck Norris is kicking your ass, don?t be offended or hurt, he may be just trying to tell you he likes your hat.", "categories": [] }, { "id": 399, "joke": "In the movie &quot;The Matrix&quot;, Chuck Norris is the Matrix. If you pay close attention in the green &quot;falling code&quot; scenes, you can make out the faint texture of his beard.", "categories": [] }, { "id": 525, "joke": "Chuck Norris can retrieve anything from /dev/null.", "categories": ["nerdy"] }, { "id": 71, "joke": "When Chuck Norris has sex with a man, it won't be because he is gay. It will be because he has run out of women.", "categories": ["explicit"] }, { "id": 370, "joke": "Godzilla is a Japanese rendition of Chuck Norris' first visit to Tokyo.", "categories": [] }, { "id": 384, "joke": "Chuck Norris was the orginal sculptor of Mount Rushmore. He completed the entire project using only a bottle opener and a drywall trowel.", "categories": [] }, { "id": 271, "joke": "Staring at Chuck Norris for extended periods of time without proper eye protection will cause blindess, and possibly foot sized brusies on the face.", "categories": [] }, { "id": 474, "joke": "To Chuck Norris, everything contains a vulnerability.", "categories": ["nerdy"] }, { "id": 489, "joke": "Chuck Norris can write multi-threaded applications with a single thread.", "categories": ["nerdy"] }, { "id": 356, "joke": "We live in an expanding universe. All of it is trying to get away from Chuck Norris.", "categories": [] }, { "id": 478, "joke": "Chuck Norris can instantiate an abstract class.", "categories": ["nerdy"] }, { "id": 186, "joke": "Fear is not the only emotion Chuck Norris can smell. He can also detect hope, as in &quot;I hope I don't get a roundhouse kick from Chuck Norris.&quot;", "categories": [] }, { "id": 250, "joke": "The truth will set you free. Unless Chuck Norris has you, in which case, forget it buddy!", "categories": [] }, { "id": 513, "joke": "Chuck Norris does not code in cycles, he codes in strikes.", "categories": ["nerdy"] }, { "id": 482, "joke": "Chuck Norris knows the last digit of PI.", "categories": ["nerdy"] }, { "id": 160, "joke": "Along with his black belt, Chuck Norris often chooses to wear brown shoes. No one has DARED call him on it. Ever.", "categories": [] }, { "id": 515, "joke": "Chuck Norris compresses his files by doing a flying round house kick to the hard drive.", "categories": ["nerdy"] }, { "id": 266, "joke": "Chuck Norris? roundhouse kick is so powerful, it can be seen from outer space by the naked eye.", "categories": [] }, { "id": 237, "joke": "Human cloning is outlawed because of Chuck Norris, because then it would be possible for a Chuck Norris roundhouse kick to meet another Chuck Norris roundhouse kick. Physicists theorize that this contact would end the universe.", "categories": [] }, { "id": 302, "joke": "Chuck Norris doesn't go on the internet, he has every internet site stored in his memory. He refreshes webpages by blinking.", "categories": [] }, { "id": 365, "joke": "Chuck Norris has never won an Academy Award for acting... because he's not acting.", "categories": [] }, { "id": 293, "joke": "70% of a human's weight is water. 70% of Chuck Norris' weight is his dick.", "categories": ["explicit"] }, { "id": 144, "joke": "If, by some incredible space-time paradox, Chuck Norris would ever fight himself, he'd win. Period.", "categories": [] }, { "id": 400, "joke": "Chuck Norris' dick is so big, it has it's own dick, and that dick is still bigger than yours.", "categories": [] }, { "id": 544, "joke": "If you try to kill -9 Chuck Norris's programs, it backfires.", "categories": ["nerdy"] }, { "id": 234, "joke": "Chuck Norris kills anyone that asks: &quot;Do you want fries with that?&quot;. Because by now everyone should know that Chuck doesn't want fries with anything. Ever.", "categories": [] }, { "id": 530, "joke": "Chuck Norris can dereference NULL.", "categories": ["nerdy"] }, { "id": 307, "joke": "Chuck Norris never has to wax his skis because they're always slick with blood.", "categories": [] }, { "id": 333, "joke": "Chuck Norris was banned from competitive bullriding after a 1992 exhibition in San Antonio, when he rode the bull 1,346 miles from Texas to Milwaukee Wisconsin to pick up his dry cleaning.", "categories": [] }, { "id": 532, "joke": "A diff between your code and Chuck Norris's is infinite.", "categories": ["nerdy"] }, { "id": 163, "joke": "Ninjas want to grow up to be just like Chuck Norris. But usually they grow up just to be killed by Chuck Norris.", "categories": [] }, { "id": 308, "joke": "When you say &quot;no one's perfect&quot;, Chuck Norris takes this as a personal insult.", "categories": [] }, { "id": 450, "joke": "Chuck Norris doesn't have disk latency because the hard drive knows to hurry the hell up.", "categories": ["nerdy"] }, { "id": 203, "joke": "Chuck Norris can lead a horse to water AND make it drink.", "categories": [] }, { "id": 318, "joke": "If you work in an office with Chuck Norris, don't ask him for his three-hole-punch.", "categories": [] }, { "id": 191, "joke": "The easiest way to determine Chuck Norris' age is to cut him in half and count the rings.", "categories": [] }, { "id": 512, "joke": "Chuck Norris does not need to type-cast. The Chuck-Norris Compiler (CNC) sees through things. All way down. Always.", "categories": ["nerdy"] }, { "id": 241, "joke": "Chuck Norris puts his pants on one leg at a time, just like the rest of us. The only difference is, then he kills people.", "categories": [] }, { "id": 533, "joke": "The Chuck Norris Eclipse plugin made alien contact.", "categories": ["nerdy"] }, { "id": 412, "joke": "Chuck Norris knows the last digit of pi.", "categories": [] }, { "id": 402, "joke": "There is no such thing as a lesbian, just a woman who has never met Chuck Norris.", "categories": [] }, { "id": 253, "joke": "Coroners refer to dead people as &quot;ABC's&quot;. Already Been Chucked.", "categories": [] }, { "id": 312, "joke": "Jesus can walk on water, but Chuck Norris can walk on Jesus.", "categories": [] }, { "id": 417, "joke": "According to the Bible, God created the universe in six days. Before that, Chuck Norris created God by snapping his fingers.", "categories": [] }, { "id": 14, "joke": "There are no steroids in baseball. Just players Chuck Norris has breathed on.", "categories": [] }, { "id": 303, "joke": "Fact: Chuck Norris doesn't consider it sex if the woman survives.", "categories": [] }, { "id": 141, "joke": "The original draft of The Lord of the Rings featured Chuck Norris instead of Frodo Baggins. It was only 5 pages long, as Chuck roundhouse-kicked Sauron's ass halfway through the first chapter.", "categories": [] }, { "id": 565, "joke": "Chuck Norris can make a class that is both abstract and final.", "categories": ["nerdy"] }, { "id": 166, "joke": "Chuck Norris doesn't play god. Playing is for children.", "categories": [] }, { "id": 518, "joke": "Chuck Norris doesn't cheat death. He wins fair and square.", "categories": [] }, { "id": 486, "joke": "Chuck Norris solved the Travelling Salesman problem in O(1) time. Here's the pseudo-code: Break salesman into N pieces. Kick each piece to a different city.", "categories": ["nerdy"] }, { "id": 466, "joke": "Chuck Norris doesn't do Burn Down charts, he does Smack Down charts.", "categories": ["nerdy"] }, { "id": 349, "joke": "A man once asked Chuck Norris if his real name is &quot;Charles&quot;. Chuck Norris did not respond, he simply stared at him until he exploded.", "categories": [] }, { "id": 60, "joke": "When Chuck Norris calls 1-900 numbers, he doesn't get charged. He holds up the phone and money falls out.", "categories": [] }, { "id": 135, "joke": "Chuck Norris roundhouse kicks don't really kill people. They wipe out their entire existence from the space-time continuum.", "categories": [] }, { "id": 494, "joke": "Chuck Norris breaks RSA 128-bit encrypted codes in milliseconds.", "categories": ["nerdy"] }, { "id": 50, "joke": "Chuck Norris invented Kentucky Fried Chicken's famous secret recipe with eleven herbs and spices. Nobody ever mentions the twelfth ingredient: Fear.", "categories": [] }, { "id": 411, "joke": "The pen is mighter than the sword, but only if the pen is held by Chuck Norris.", "categories": [] }, { "id": 314, "joke": "July 4th is Independence day. And the day Chuck Norris was born. Coincidence? I think not.", "categories": [] }, { "id": 394, "joke": "&quot;Let the Bodies Hit the Floor&quot; was originally written as Chuck Norris' theme song.", "categories": [] }, { "id": 459, "joke": "Chuck Norris can solve the Towers of Hanoi in one move.", "categories": ["nerdy"] }, { "id": 83, "joke": "While urinating, Chuck Norris is easily capable of welding titanium.", "categories": [] }, { "id": 426, "joke": "A man once taunted Chuck Norris with a bag of Lay's potato chips, saying &quot;Betcha can't eat just one!&quot; Chuck Norris proceeded to eat the chips, the bag, and the man in one deft move.", "categories": [] }, { "id": 395, "joke": "Chuck Norris will never have a heart attack. His heart isn't nearly foolish enough to attack him.", "categories": [] }, { "id": 300, "joke": "Chuck Norris eats steak for every single meal. Most times he forgets to kill the cow.", "categories": [] }, { "id": 340, "joke": "A man once claimed Chuck Norris kicked his ass twice, but it was promptly dismissed as false - no one could survive it the first time.", "categories": [] }, { "id": 86, "joke": "Wilt Chamberlain claims to have slept with more than 20,000 women in his lifetime. Chuck Norris calls this &quot;a slow Tuesday.&quot;", "categories": [] }, { "id": 414, "joke": "The air around Chuck Norris is always a balmy 78 degrees.", "categories": [] }, { "id": 201, "joke": "Chuck Norris was what Willis was talkin' about.", "categories": [] }, { "id": 502, "joke": "Chuck Norris insists on strongly-typed programming languages.", "categories": ["nerdy"] }, { "id": 347, "joke": "Some people ask for a Kleenex when they sneeze, Chuck Norris asks for a body bag.", "categories": [] }, { "id": 413, "joke": "Those aren't credits that roll after Walker Texas Ranger. It is actually a list of fatalities that occurred during the making of the episode.", "categories": [] }, { "id": 185, "joke": "If Chuck Norris were a calendar, every month would be named Chucktober, and every day he'd kick your ass.", "categories": [] }, { "id": 167, "joke": "As a teen, Chuck Norris had sex with every nun in a convent tucked away in the hills of Tuscany. Nine months later the nuns gave birth to the 1972 Miami Dolphins, the only undefeated and untied team in professional football history.", "categories": [] }, { "id": 406, "joke": "Chuck Norris doesn't say &quot;who's your daddy&quot;, because he knows the answer.", "categories": [] }, { "id": 552, "joke": "Chuck Norris knows the value of NULL, and he can sort by it too.", "categories": ["nerdy"] }, { "id": 131, "joke": "Scotty in Star Trek often says &quot;Ye cannae change the laws of physics.&quot; This is untrue. Chuck Norris can change the laws of physics. With his fists.", "categories": [] }, { "id": 235, "joke": "Chuck Norris once kicked a horse in the chin. Its decendants are known today as Giraffes.", "categories": [] }, { "id": 319, "joke": "In the Words of Julius Caesar, &quot;Veni, Vidi, Vici, Chuck Norris&quot;. Translation: I came, I saw, and I was roundhouse-kicked inthe face by Chuck Norris.", "categories": [] }, { "id": 81, "joke": "Chuck Norris invented his own type of karate. It's called Chuck-Will-Kill.", "categories": [] }, { "id": 147, "joke": "Science Fact: Roundhouse kicks are comprised primarily of an element called Chucktanium.", "categories": [] }, { "id": 485, "joke": "Chuck Norris' Internet connection is faster upstream than downstream because even data has more incentive to run from him than to him.", "categories": ["nerdy"] }, { "id": 123, "joke": "Some people wear Superman pajamas. Superman wears Chuck Norris pajamas.", "categories": [] }, { "id": 401, "joke": "They say curiosity killed the cat. This is false. Chuck Norris killed the cat. Every single one of them.", "categories": [] }, { "id": 94, "joke": "Chuck Norris has the greatest Poker-Face of all time. He won the 1983 World Series of Poker, despite holding only a Joker, a Get out of Jail Free Monopoloy card, a 2 of clubs, 7 of spades and a green #4 card from the game UNO.", "categories": [] }, { "id": 285, "joke": "With the rising cost of gasoline, Chuck Norris is beginning to worry about his drinking habit.", "categories": [] }, { "id": 313, "joke": "All roads lead to Chuck Norris. And by the transitive property, a roundhouse kick to the face.", "categories": [] }, { "id": 196, "joke": "The Bible was originally titled &quot;Chuck Norris and Friends&quot;", "categories": [] }, { "id": 67, "joke": "A Chuck Norris-delivered Roundhouse Kick is the preferred method of execution in 16 states.", "categories": [] }, { "id": 407, "joke": "Chuck Norris originally wrote the first dictionary. The definition for each word is as follows - A swift roundhouse kick to the face.", "categories": [] }, { "id": 381, "joke": "Diamonds are not, despite popular belief, carbon. They are, in fact, Chuck Norris fecal matter. This was proven a recently, when scientific analysis revealed what appeared to be Jean-Claude Van Damme bone fragments inside the Hope Diamond.", "categories": [] }, { "id": 47, "joke": "There is no theory of evolution, just a list of creatures Chuck Norris allows to live.", "categories": [] }, { "id": 122, "joke": "Chuck Norris is responsible for China's over-population. He hosted a Karate tournament in Beijing and all women within 1,000 miles became pregnant instantly.", "categories": [] }, { "id": 252, "joke": "Saddam Hussein was not found hiding in a &quot;hole.&quot; Saddam was roundhouse-kicked in the head by Chuck Norris in Kansas, which sent him through the earth, stopping just short of the surface of Iraq.", "categories": [] }, { "id": 297, "joke": "Noah was the only man notified before Chuck Norris relieved himself in the Atlantic Ocean.", "categories": [] }, { "id": 517, "joke": "Chick Norris solved the halting problem.", "categories": ["nerdy"] }, { "id": 265, "joke": "The phrase 'balls to the wall' was originally conceived to describe Chuck Norris entering any building smaller than an aircraft hangar.", "categories": [] }, { "id": 510, "joke": "Chuck Norris can compile syntax errors.", "categories": ["nerdy"] }, { "id": 495, "joke": "Chuck Norris doesn't needs try-catch, exceptions are too afraid to raise.", "categories": ["nerdy"] }, { "id": 146, "joke": "The crossing lights in Chuck Norris's home town say &quot;Die slowly&quot; and &quot;die quickly&quot;. They each have a picture of Chuck Norris punching or kicking a pedestrian.", "categories": [] }, { "id": 496, "joke": "Chuck Norris went out of an infinite loop.", "categories": ["nerdy"] }, { "id": 69, "joke": "Scientists have estimated that the energy given off during the Big Bang is roughly equal to 1CNRhK (Chuck Norris Roundhouse Kick).", "categories": ["nerdy"] }, { "id": 101, "joke": "Archeologists unearthed an old english dictionary dating back to the year 1236. It defined &quot;victim&quot; as &quot;one who has encountered Chuck Norris&quot;", "categories": [] }, { "id": 228, "joke": "Chuck Norris does not eat. Food understands that the only safe haven from Chuck Norris' fists is inside his own body.", "categories": [] }, { "id": 202, "joke": "Google won't search for Chuck Norris because it knows you don't find Chuck Norris, he finds you.", "categories": [] }, { "id": 286, "joke": "The square root of Chuck Norris is pain. Do not try to square Chuck Norris, the result is death.", "categories": [] }, { "id": 31, "joke": "Chuck Norris has two speeds: Walk and Kill.", "categories": [] }, { "id": 367, "joke": "Not everyone that Chuck Norris is mad at gets killed. Some get away. They are called astronauts.", "categories": [] }, { "id": 158, "joke": "It's widely believed that Jesus was Chuck Norris' stunt double for crucifixion due to the fact that it is impossible for nails to pierce Chuck Norris' skin.", "categories": [] }, { "id": 434, "joke": "Chuck Norris wipes his ass with chain mail and sandpaper.", "categories": [] }, { "id": 531, "joke": "Jesus can walk on water, but Chuck Norris can swim through land.", "categories": [] }, { "id": 170, "joke": "Wo hu cang long. The translation from Mandarin Chinese reads: &quot;Crouching Chuck, Hidden Norris&quot;", "categories": [] }, { "id": 269, "joke": "The best-laid plans of mice and men often go awry. Even the worst-laid plans of Chuck Norris come off without a hitch.", "categories": [] }, { "id": 164, "joke": "Chuck Norris once sued Burger King after they refused to put razor wire in his Whopper Jr, insisting that that actually is &quot;his&quot; way.", "categories": [] }, { "id": 70, "joke": "Chuck Norris' house has no doors, only walls that he walks through.", "categories": [] }, { "id": 368, "joke": "Chuck Norris has to register every part of his body as a separate lethal weapon. His spleen is considered a concealed weapon in over 50 states.", "categories": [] }, { "id": 449, "joke": "All arrays Chuck Norris declares are of infinite size, because Chuck Norris knows no bounds.", "categories": ["nerdy"] }, { "id": 93, "joke": "When you're Chuck Norris, anything + anything is equal to 1. One roundhouse kick to the face.", "categories": [] }, { "id": 65, "joke": "When Chuck Norris was denied an Egg McMuffin at McDonald's because it was 10:35, he roundhouse kicked the store so hard it became a Wendy's.", "categories": [] }, { "id": 391, "joke": "TNT was originally developed by Chuck Norris to cure indigestion.", "categories": [] }, { "id": 212, "joke": "Chuck Norris does not play the lottery. It doesn't have nearly enough balls.", "categories": [] }, { "id": 309, "joke": "Chuck Norris can win a game of Trivial Pursuit with one roll of the dice, and without answering a single question... just a nod of the head, and a stroke of the beard.", "categories": [] }, { "id": 136, "joke": "Chuck Norris does not own a stove, oven, or microwave , because revenge is a dish best served cold.", "categories": [] }, { "id": 317, "joke": "Chuck Norris was once in a knife fight, and the knife lost.", "categories": [] }, { "id": 68, "joke": "When Chuck Norris falls in water, Chuck Norris doesn't get wet. Water gets Chuck Norris.", "categories": [] }, { "id": 330, "joke": "President Roosevelt once rode his horse 100 miles. Chuck Norris carried his the same distance in half the time.", "categories": [] }, { "id": 24, "joke": "Chuck Norris can hit you so hard that he can actually alter your DNA. Decades from now your descendants will occasionally clutch their heads and yell &quot;What The Hell was That?&quot;.", "categories": [] }, { "id": 280, "joke": "When Chuck Norris works out on the Total Gym, the Total Gym feels like it's been raped.", "categories": [] }, { "id": 398, "joke": "Chuck Norris is not Irish. His hair is soaked in the blood of his victims.", "categories": [] }, { "id": 169, "joke": "Chuck Norris won super bowls VII and VIII singlehandedly before unexpectedly retiring to pursue a career in ass-kicking.", "categories": [] }, { "id": 390, "joke": "Divide Chuck Norris by zero and you will in fact get one........one bad-ass that is.", "categories": [] }, { "id": 321, "joke": "Chuck Norris is widely predicted to be first black president. If you're thinking to yourself, &quot;But Chuck Norris isn't black&quot;, then you are dead wrong. And stop being a racist.", "categories": [] }, { "id": 114, "joke": "Chuck Norris doesn't believe in Germany.", "categories": [] }, { "id": 181, "joke": "Chuck Norris recently had the idea to sell his urine as a canned beverage. We know this beverage as Red Bull.", "categories": [] }, { "id": 99, "joke": "Chuck Norris has 12 moons. One of those moons is the Earth.", "categories": [] }, { "id": 98, "joke": "In the beginning there was nothing...then Chuck Norris Roundhouse kicked that nothing in the face and said &quot;Get a job&quot;. That is the story of the universe.", "categories": [] }, { "id": 115, "joke": "When Chuck Norris is in a crowded area, he doesn't walk around people. He walks through them.", "categories": [] }, { "id": 226, "joke": "&quot;Brokeback Mountain&quot; is not just a movie. It's also what Chuck Norris calls the pile of dead ninjas in his front yard.", "categories": [] }, { "id": 295, "joke": "The pie scene in &quot;American Pie&quot; is based on a dare Chuck Norris took when he was younger. However, in Chuck Norris' case, the &quot;pie&quot; was the molten crater of an active volcano.", "categories": [] }, { "id": 432, "joke": "Chuck Norris is the only man who has, literally, beaten the odds. With his fists.", "categories": [] }, { "id": 44, "joke": "Chuck Norris is the only man to ever defeat a brick wall in a game of tennis.", "categories": [] }, { "id": 521, "joke": "Chuck Norris lost his virginity before his dad did.", "categories": ["explicit"] }, { "id": 126, "joke": "When Chuck Norris does a pushup, he isn't lifting himself up, he's pushing the Earth down.", "categories": [] }, { "id": 404, "joke": "When Chuck Norris was born, he immediately had sex with the first nurse he saw. He was her first. She was his third. That afternoon.", "categories": [] }, { "id": 138, "joke": "Chuck Norris can slam a revolving door.", "categories": [] }, { "id": 16, "joke": "Pluto is actually an orbiting group of British soldiers from the American Revolution who entered space after the Chuck gave them a roundhouse kick to the face.", "categories": [] }, { "id": 210, "joke": "Chuck Norris can judge a book by its cover.", "categories": [] }, { "id": 403, "joke": "Chuck Norris crossed the road. No one has ever dared question his motives.", "categories": [] }, { "id": 72, "joke": "How much wood would a woodchuck chuck if a woodchuck could Chuck Norris? All of it.", "categories": [] }, { "id": 260, "joke": "If you rearrange the letters in &quot;Chuck Norris&quot;, they also spell &quot;Crush Rock In&quot;. The words &quot;with his fists&quot; are understood.", "categories": [] }, { "id": 274, "joke": "One time, Chuck Norris accidentally stubbed his toe. It destroyed the entire state of Ohio.", "categories": [] }, { "id": 535, "joke": "Chuck Norris uses canvas in IE.", "categories": ["nerdy"] }, { "id": 536, "joke": "Don't worry about tests, Chuck Norris's test cases cover your code too.", "categories": ["nerdy"] }, { "id": 243, "joke": "Contrary to popular belief, the Titanic didn't hit an iceberg. The ship was off course and ran into Chuck Norris while he was doing the backstroke across the Atlantic.", "categories": [] }, { "id": 431, "joke": "Rules of fighting: 1) Don't bring a knife to a gun fight. 2) Don't bring a gun to a Chuck Norris fight.", "categories": [] }, { "id": 331, "joke": "Chuck Norris once ate four 30lb bowling balls without chewing.", "categories": [] }, { "id": 425, "joke": "Chuck Norris is the only known mammal in history to have an opposable thumb. On his penis.", "categories": [] }, { "id": 172, "joke": "Some kids play Kick the can. Chuck Norris played Kick the keg.", "categories": [] }, { "id": 385, "joke": "Chuck Norris once rode a bull, and nine months later it had a calf.", "categories": [] }, { "id": 264, "joke": "Guantuanamo Bay, Cuba, is the military code-word for &quot;Chuck Norris' basement&quot;.", "categories": [] }, { "id": 36, "joke": "Chuck Norris originally appeared in the &quot;Street Fighter II&quot; video game, but was removed by Beta Testers because every button caused him to do a roundhouse kick. When asked about this glitch, Norris replied &quot;That's no glitch.&quot;", "categories": ["nerdy"] }, { "id": 200, "joke": "On the set of Walker Texas Ranger Chuck Norris brought a dying lamb back to life by nuzzling it with his beard. As the onlookers gathered, the lamb sprang to life. Chuck Norris then roundhouse kicked it, killing it instantly. This was just to prove that the good Chuck givet", "categories": [] }, { "id": 261, "joke": "Never look a gift Chuck Norris in the mouth, because he will bite your damn eyes off.", "categories": [] }, { "id": 27, "joke": "Faster than a speeding bullet... More powerful than a locomotive... Able to leap tall buildings in a single bound... These are some of Chuck Norris's warm-up exercises.", "categories": [] }, { "id": 523, "joke": "Chuck Norris can win in a game of Russian roulette with a fully loaded gun.", "categories": [] }, { "id": 554, "joke": "Chuck Norris can install a 64 bit OS on 32 bit machines.", "categories": ["nerdy"] }, { "id": 503, "joke": "Chuck Norris protocol design method has no status, requests or responses, only commands.", "categories": ["nerdy"] }, { "id": 477, "joke": "Chuck Norris can access private methods.", "categories": ["nerdy"] }, { "id": 373, "joke": "&quot;Sweating bullets&quot; is literally what happens when Chuck Norris gets too hot.", "categories": [] }, { "id": 207, "joke": "It is believed dinosaurs are extinct due to a giant meteor. That's true if you want to call Chuck Norris a giant meteor.", "categories": [] }, { "id": 156, "joke": "There is no such thing as global warming. Chuck Norris was cold, so he turned the sun up.", "categories": [] }, { "id": 155, "joke": "Chuck Norris does not &quot;style&quot; his hair. It lays perfectly in place out of sheer terror.", "categories": [] }, { "id": 326, "joke": "As an infant, Chuck Norris' parents gave him a toy hammer. He gave the world Stonehenge.", "categories": [] }, { "id": 78, "joke": "The grass is always greener on the other side, unless Chuck Norris has been there. In that case the grass is most likely soaked in blood and tears.", "categories": [] }, { "id": 29, "joke": "Teenage Mutant Ninja Turtles is based on a true story: Chuck Norris once swallowed a turtle whole, and when he crapped it out, the turtle was six feet tall and had learned karate.", "categories": [] }, { "id": 540, "joke": "Chuck Norris finished World of Warcraft.", "categories": ["nerdy"] }, { "id": 476, "joke": "Chuck Norris doesn't need a debugger, he just stares down the bug until the code confesses.", "categories": ["nerdy"] }, { "id": 487, "joke": "No statement can catch the ChuckNorrisException.", "categories": ["nerdy"] }, { "id": 559, "joke": "Chuck Norris' unit tests don't run. They die.", "categories": ["nerdy"] }, { "id": 371, "joke": "They once made a Chuck Norris toilet paper, but there was a problem-- It wouldn't take shit from anybody.", "categories": [] }, { "id": 337, "joke": "The chemical formula for the highly toxic cyanide ion is CN-. These are also Chuck Norris' initials. This is not a coincidence.", "categories": [] }, { "id": 491, "joke": "Chuck Norris doesn't use reflection, reflection asks politely for his help.", "categories": ["nerdy"] }, { "id": 179, "joke": "Chuck Norris? favourite cut of meat is the roundhouse.", "categories": [] }, { "id": 171, "joke": "Chuck Norris can set ants on fire with a magnifying glass. At night.", "categories": [] }, { "id": 514, "joke": "Chuck Norris doesn't use a computer because a computer does everything slower than Chuck Norris.", "categories": [] }, { "id": 379, "joke": "Chuck Norris' Penis is a third degree blackbelt, and an honorable 32nd-degree mason.", "categories": [] }, { "id": 209, "joke": "That's not Chuck Norris doing push-ups -- that's Chuck Norris moving the Earth away from the path of a deadly asteroid.", "categories": [] }, { "id": 346, "joke": "Every time Chuck Norris smiles, someone dies. Unless he smiles while he?s roundhouse kicking someone in the face. Then two people die.", "categories": [] }, { "id": 279, "joke": "Chuck Norris does, in fact, live in a round house.", "categories": [] }, { "id": 288, "joke": "To be or not to be? That is the question. The answer? Chuck Norris.", "categories": [] }, { "id": 493, "joke": "Chuck Norris can binary search unsorted data.", "categories": ["nerdy"] }, { "id": 323, "joke": "Chuck Norris can be unlocked on the hardest level of Tekken. But only Chuck Norris is skilled enough to unlock himself. Then he roundhouse kicks the Playstation back to Japan.", "categories": [] }, { "id": 463, "joke": "Chuck Norris doesn't use web standards as the web will conform to him.", "categories": ["nerdy"] }, { "id": 225, "joke": "Chuck Norris is the reason why Waldo is hiding.", "categories": [] }, { "id": 165, "joke": "The last thing you hear before Chuck Norris gives you a roundhouse kick? No one knows because dead men tell no tales.", "categories": [] }, { "id": 75, "joke": "Chuck Norris can believe it's not butter.", "categories": [] }, { "id": 327, "joke": "Chuck Norris once ordered a steak in a restaurant. The steak did what it was told.", "categories": [] }, { "id": 102, "joke": "Chuck Norris ordered a Big Mac at Burger King, and got one.", "categories": [] }, { "id": 162, "joke": "Once you go Norris, you are physically unable to go back.", "categories": [] }, { "id": 348, "joke": "There?s an order to the universe: space, time, Chuck Norris.... Just kidding, Chuck Norris is first.", "categories": [] }, { "id": 28, "joke": "Chuck Norris is not hung like a horse. Horses are hung like Chuck Norris.", "categories": [] }, { "id": 4, "joke": "If you ask Chuck Norris what time it is, he always answers &quot;Two seconds till&quot;. After you ask &quot;Two seconds to what?&quot;, he roundhouse kicks you in the face.", "categories": [] }, { "id": 19, "joke": "In an average living room there are 1,242 objects Chuck Norris could use to kill you, including the room itself.", "categories": [] }, { "id": 298, "joke": "MacGyver immediately tried to make a bomb out of some Q-Tips and Gatorade, but Chuck Norris roundhouse-kicked him in the solar plexus. MacGyver promptly threw up his own heart.", "categories": [] }, { "id": 229, "joke": "One day Chuck Norris walked down the street with a massive erection. There were no survivors.", "categories": ["explicit"] }, { "id": 251, "joke": "Kryptonite has been found to contain trace elements of Chuck Norris roundhouse kicks to the face. This is why it is so deadly to Superman.", "categories": [] }, { "id": 145, "joke": "Chuck Norris is currently suing myspace for taking the name of what he calls everything around you.", "categories": [] }, { "id": 362, "joke": "Chuck Norris can do a roundhouse kick faster than the speed of light. This means that if you turn on a light switch, you will be dead before the lightbulb turns on.", "categories": [] }, { "id": 57, "joke": "Chuck Norris is ten feet tall, weighs two-tons, breathes fire, and could eat a hammer and take a shotgun blast standing.", "categories": [] }, { "id": 108, "joke": "The show Survivor had the original premise of putting people on an island with Chuck Norris. There were no survivors, and nobody is brave enough to go to the island to retrieve the footage.", "categories": [] }, { "id": 82, "joke": "When an episode of Walker Texas Ranger was aired in France, the French surrendered to Chuck Norris just to be on the safe side.", "categories": [] }, { "id": 37, "joke": "If you spell Chuck Norris in Scrabble, you win. Forever.", "categories": [] }, { "id": 454, "joke": "Chuck Norris's first program was kill -9.", "categories": ["nerdy"] }, { "id": 230, "joke": "Chuck Norris built a time machine and went back in time to stop the JFK assassination. As Oswald shot, Chuck met all three bullets with his beard, deflecting them. JFK's head exploded out of sheer amazement.", "categories": [] }, { "id": 345, "joke": "When in a bar, you can order a drink called a &quot;Chuck Norris&quot;. It is also known as a &quot;Bloody Mary&quot;, if your name happens to be Mary.", "categories": [] }, { "id": 231, "joke": "Chuck Norris doesn't read books. He stares them down until he gets the information he wants.", "categories": [] }, { "id": 501, "joke": "Chuck Norris' programs never exit, they terminate.", "categories": ["nerdy"] }, { "id": 80, "joke": "Newton's Third Law is wrong: Although it states that for each action, there is an equal and opposite reaction, there is no force equal in reaction to a Chuck Norris roundhouse kick.", "categories": [] }, { "id": 324, "joke": "Chuck Norris drinks napalm to quell his heartburn.", "categories": [] }, { "id": 497, "joke": "If Chuck Norris writes code with bugs, the bugs fix themselves.", "categories": ["nerdy"] }, { "id": 110, "joke": "You know how they say if you die in your dream then you will die in real life? In actuality, if you dream of death then Chuck Norris will find you and kill you.", "categories": [] }, { "id": 197, "joke": "Chuck Norris began selling the Total Gym as an ill-fated attempt to make his day-to-day opponents less laughably pathetic.", "categories": [] }, { "id": 227, "joke": "When God said, &quot;let there be light&quot;, Chuck Norris said, &quot;say 'please'.&quot;", "categories": [] }, { "id": 223, "joke": "Chuck Norris smells what the Rock is cooking... because the Rock is Chuck Norris' personal chef.", "categories": [] }, { "id": 168, "joke": "Chuck Norris is the only person in the world that can actually email a roundhouse kick.", "categories": [] }, { "id": 95, "joke": "On his birthday, Chuck Norris randomly selects one lucky child to be thrown into the sun.", "categories": [] }, { "id": 221, "joke": "Chuck Norris is the only person to ever win a staring contest against Ray Charles and Stevie Wonder.", "categories": [] }, { "id": 332, "joke": "What many people dont know is Chuck Norris is the founder of planned parenthood. Not even unborn children can escape his wrath.", "categories": [] }, { "id": 232, "joke": "Chuck Norris uses a night light. Not because Chuck Norris is afraid of the dark, but the dark is afraid of Chuck Norris.", "categories": [] }, { "id": 272, "joke": "Chuck Norris can taste lies.", "categories": [] }, { "id": 109, "joke": "It takes Chuck Norris 20 minutes to watch 60 Minutes.", "categories": [] }, { "id": 350, "joke": "Chuck Norris starts everyday with a protein shake made from Carnation Instant Breakfast, one dozen eggs, pure Colombian cocaine, and rattlesnake venom. He injects it directly into his neck with a syringe.", "categories": [] }, { "id": 84, "joke": "When Chuck Norris talks, everybody listens. And dies.", "categories": [] }, { "id": 154, "joke": "Movie trivia: The movie &quot;Invasion U.S.A.&quot; is, in fact, a documentary.", "categories": [] }, { "id": 25, "joke": "In the Bible, Jesus turned water into wine. But then Chuck Norris turned that wine into beer.", "categories": [] }, { "id": 18, "joke": "According to the Encyclopedia Brittanica, the Native American &quot;Trail of Tears&quot; has been redefined as anywhere that Chuck Norris walks.", "categories": [] }, { "id": 359, "joke": "Chuck Norris is his own line at the DMV.", "categories": [] }, { "id": 111, "joke": "Chuck Norris has a deep and abiding respect for human life... unless it gets in his way.", "categories": [] }, { "id": 541, "joke": "When Chuck Norris break the build, you can't fix it, because there is not a single line of code left.", "categories": ["nerdy"] }, { "id": 439, "joke": "Chuck Norris can kick through all 6 degrees of separation, hitting anyone, anywhere, in the face, at any time.", "categories": [] }, { "id": 73, "joke": "Chuck Norris doesn't actually write books, the words assemble themselves out of fear.", "categories": [] }, { "id": 564, "joke": "Chuck Norris can download emails with his pick-up.", "categories": ["nerdy"] }, { "id": 49, "joke": "CNN was originally created as the &quot;Chuck Norris Network&quot; to update Americans with on-the-spot ass kicking in real-time.", "categories": [] }, { "id": 214, "joke": "As President Roosevelt said: &quot;We have nothing to fear but fear itself. And Chuck Norris.&quot;", "categories": [] }, { "id": 198, "joke": "Do you know why Baskin Robbins only has 31 flavors? Because Chuck Norris doesn't like Fudge Ripple.", "categories": [] }, { "id": 310, "joke": "182,000 Americans die from Chuck Norris-related accidents every year.", "categories": [] }, { "id": 132, "joke": "An anagram for Walker Texas Ranger is KARATE WRANGLER SEX. I don't know what that is, but it sounds AWESOME.", "categories": [] }, { "id": 1, "joke": "Chuck Norris uses ribbed condoms inside out, so he gets the pleasure.", "categories": ["explicit"] }, { "id": 239, "joke": "Chuck Norris's version of a &quot;chocolate milkshake&quot; is a raw porterhouse wrapped around ten Hershey bars, and doused in diesel fuel.", "categories": [] }, { "id": 551, "joke": "Chuck Norris can over-write a locked variable.", "categories": ["nerdy"] }, { "id": 6, "joke": "Since 1940, the year Chuck Norris was born, roundhouse kick related deaths have increased 13,000 percent.", "categories": [] }, { "id": 408, "joke": "Love does not hurt. Chuck Norris does.", "categories": [] }, { "id": 85, "joke": "When Steven Seagal kills a ninja, he only takes its hide. When Chuck Norris kills a ninja, he uses every part.", "categories": [] }, { "id": 410, "joke": "Chuck Norris once round-house kicked a salesman. Over the phone.", "categories": [] }, { "id": 558, "joke": "Chuck Norris never has to build his program to machine code. Machines have learnt to interpret Chuck Norris code.", "categories": ["nerdy"] }, { "id": 539, "joke": "Chuck Norris's database has only one table, 'Kick', which he DROPs frequently.", "categories": ["nerdy"] }, { "id": 461, "joke": "Chuck Norris finished World of Warcraft.", "categories": ["nerdy"] }, { "id": 378, "joke": "There are no such things as tornados. Chuck Norris just hates trailer parks.", "categories": [] }, { "id": 238, "joke": "Chuck Norris once went skydiving, but promised never to do it again. One Grand Canyon is enough.", "categories": [] }, { "id": 61, "joke": "Chuck Norris once ate a whole cake before his friends could tell him there was a stripper in it.", "categories": [] }, { "id": 275, "joke": "Little Miss Muffet sat on her tuffet, until Chuck Norris roundhouse kicked her into a glacier.", "categories": [] }, { "id": 194, "joke": "The US did not boycott the 1980 Summer Olympics in Moscow due to political reasons: Chuck Norris killed the entire US team with a single round-house kick during TaeKwonDo practice.", "categories": [] }, { "id": 258, "joke": "The phrase 'break a leg' was originally coined by Chuck Norris's co-stars in Walker, Texas Ranger as a good luck charm, indicating that a broken leg might be the worst extent of their injuries. This never proved to be the case.", "categories": [] }, { "id": 547, "joke": "Product Owners never ask Chuck Norris for more features. They ask for mercy.", "categories": ["nerdy"] }, { "id": 259, "joke": "When Chuck Norris does division, there are no remainders.", "categories": [] }, { "id": 187, "joke": "# Chuck Norris's show is called Walker: Texas Ranger, because Chuck Norris doesn't run.", "categories": [] }, { "id": 291, "joke": "Chuck Norris never wet his bed as a child. The bed wet itself out of fear.", "categories": [] }, { "id": 527, "joke": "No one has ever spoken during review of Chuck Norris' code and lived to tell about it.", "categories": ["nerdy"] }, { "id": 376, "joke": "Chuck Norris doesn't daydream. He's too busy giving other people nightmares.", "categories": [] }, { "id": 441, "joke": "Chuck Norris did not &quot;lose&quot; his virginity, he stalked it and then destroyed it with extreme prejudice.", "categories": [] }, { "id": 205, "joke": "It is scientifically impossible for Chuck Norris to have had a mortal father. The most popular theory is that he went back in time and fathered himself.", "categories": [] }, { "id": 12, "joke": "Chuck Norris sheds his skin twice a year.", "categories": [] }, { "id": 189, "joke": "Behind every successful man, there is a woman. Behind every dead man, there is Chuck Norris.", "categories": [] }, { "id": 127, "joke": "Chuck Norris invented the bolt-action rifle, liquor, sexual intercourse, and football-- in that order.", "categories": [] }, { "id": 353, "joke": "Chuck Norris is the only person who can simultaneously hold and fire FIVE Uzis: One in each hand, one in each foot -- and the 5th one he roundhouse-kicks into the air, so that it sprays bullets.", "categories": [] }, { "id": 64, "joke": "There are no races, only countries of people Chuck Norris has beaten to different shades of black and blue.", "categories": [] }, { "id": 357, "joke": "The word 'Kill' was invented by Chuck Norris. Other words were 'Die', 'Beer', and 'What'.", "categories": [] }, { "id": 249, "joke": "Maslow's theory of higher needs does not apply to Chuck Norris. He only has two needs: killing people and finding people to kill.", "categories": [] }, { "id": 184, "joke": "If at first you don't succeed, you're not Chuck Norris.", "categories": [] }, { "id": 455, "joke": "Chuck Norris burst the dot com bubble.", "categories": ["nerdy"] }, { "id": 421, "joke": "Chuck Norris is not Politically Correct. He is just Correct. Always.", "categories": [] }, { "id": 504, "joke": "Chuck Norris programs occupy 150% of CPU, even when they are not executing.", "categories": ["nerdy"] }, { "id": 342, "joke": "Chuck Norris owns a chain of fast-food restaurants throughout the southwest. They serve nothing but barbecue-flavored ice cream and Hot Pockets.", "categories": [] }, { "id": 149, "joke": "Chuck Norris proved that we are alone in the universe. We weren't before his first space expedition.", "categories": [] }, { "id": 420, "joke": "The 1972 Miami Dolphins lost one game, it was a game vs. Chuck Norris and three seven year old girls. Chuck Norris won with a roundhouse-kick to the face in overtime.", "categories": [] }, { "id": 124, "joke": "Chuck Norris once worked as a weatherman for the San Diego evening news. Every night he would make the same forecast: Partly cloudy with a 75% chance of Pain.", "categories": [] }, { "id": 263, "joke": "The original title for Star Wars was &quot;Skywalker: Texas Ranger&quot;. Starring Chuck Norris.", "categories": [] }, { "id": 176, "joke": "According to Einstein's theory of relativity, Chuck Norris can actually roundhouse kick you yesterday.", "categories": [] }, { "id": 354, "joke": "For undercover police work, Chuck Norris pins his badge underneath his shirt, directly into his chest.", "categories": [] }, { "id": 351, "joke": "In a tagteam match, Chuck Norris was teamed with Hulk Hogan against King Kong Bundy and Andre The Giant. He pinned all 3 at the same time.", "categories": [] }, { "id": 294, "joke": "Jean-Claude Van Damme once kicked Chuck Norris' ass. He was then awakened from his dream by a roundhouse kick to the face.", "categories": [] }, { "id": 233, "joke": "When Bruce Banner gets mad, he turns into the Hulk. When the Hulk gets mad, he turns into Chuck Norris.", "categories": [] }, { "id": 150, "joke": "Superman once watched an episode of Walker, Texas Ranger. He then cried himself to sleep.", "categories": [] }, { "id": 328, "joke": "Most people fear the Reaper. Chuck Norris considers him &quot;a promising Rookie&quot;.", "categories": [] }, { "id": 2, "joke": "MacGyver can build an airplane out of gum and paper clips. Chuck Norris can kill him and take it.", "categories": [] }, { "id": 393, "joke": "Chuck Norris runs on batteries. Specifically, Die Hards.", "categories": [] }, { "id": 488, "joke": "Chuck Norris doesn't pair program.", "categories": ["nerdy"] }, { "id": 273, "joke": "Chuck Norris does not kick ass and take names. In fact, Chuck Norris kicks ass and assigns the corpse a number. It is currently recorded to be in the billions.", "categories": [] }, { "id": 584, "joke": "Only Chuck Norris shuts down websites without due process, not SOPA or PIPA.", "categories": [] }, { "id": 344, "joke": "Aliens DO indeed exist. They just know better than to visit a planet that Chuck Norris is on.", "categories": [] }, { "id": 386, "joke": "Chuck Norris once lost the remote, but maintained control of the TV by yelling at it in between bites of his &quot;Filet of Child&quot; sandwich.", "categories": [] }, { "id": 105, "joke": "Chuck Norris can drink an entire gallon of milk in thirty-seven seconds.", "categories": [] }, { "id": 334, "joke": "Chuck Norris qualified with a top speed of 324 mph at the Daytona 500, without a car.", "categories": [] }, { "id": 41, "joke": "Chuck Norris doesn't wash his clothes. He disembowels them.", "categories": [] }, { "id": 470, "joke": "Chuck Norris doesn't bug hunt as that signifies a probability of failure, he goes bug killing.", "categories": ["nerdy"] }, { "id": 436, "joke": "Chuck Norris describes human beings as &quot;a sociable holder for blood and guts&quot;.", "categories": [] }, { "id": 428, "joke": "In the first Jurassic Park movie, the Tyrannosaurus Rex wasn't chasing the jeep. Chuck Norris was chasing the Tyrannosaurus AND the jeep.", "categories": [] }, { "id": 91, "joke": "When taking the SAT, write &quot;Chuck Norris&quot; for every answer. You will score over 8000.", "categories": [] }, { "id": 222, "joke": "Industrial logging isn't the cause of deforestation. Chuck Norris needs toothpicks.", "categories": [] }, { "id": 100, "joke": "Chuck Norris grinds his coffee with his teeth and boils the water with his own rage.", "categories": [] }, { "id": 490, "joke": "Chuck Norris doesn't need to use AJAX because pages are too afraid to postback anyways.", "categories": ["nerdy"] }, { "id": 508, "joke": "Chuck Norris doesn't need an OS.", "categories": ["nerdy"] }, { "id": 188, "joke": "MacGyver can build an airplane out of gum and paper clips, but Chuck Norris can roundhouse-kick his head through a wall and take it.", "categories": [] }, { "id": 89, "joke": "For some, the left testicle is larger than the right one. For Chuck Norris, each testicle is larger than the other one.", "categories": ["explicit"] }, { "id": 519, "joke": "Chuck Norris once one a game of connect four in 3 moves.", "categories": [] }, { "id": 509, "joke": "Chuck Norris's OSI network model has only one layer - Physical.", "categories": ["nerdy"] }, { "id": 143, "joke": "Chuck Norris eats beef jerky and craps gunpowder. Then, he uses that gunpowder to make a bullet, which he uses to kill a cow and make more beef jerky. Some people refer to this as the &quot;Circle of Life.&quot;", "categories": [] }, { "id": 448, "joke": "When Chuck Norris throws exceptions, it's across the room.", "categories": ["nerdy"] }, { "id": 563, "joke": "Chuck Norris causes the Windows Blue Screen of Death.", "categories": ["nerdy"] }, { "id": 560, "joke": "Chuck Norris sits at the stand-up.", "categories": [] }, { "id": 338, "joke": "Chuck Norris' credit cards have no limit. Last weekend, he maxed them out.", "categories": [] }, { "id": 453, "joke": "Chuck Norris doesn't need garbage collection because he doesn't call .Dispose(), he calls .DropKick().", "categories": ["nerdy"] }, { "id": 505, "joke": "Chuck Norris can spawn threads that complete before they are started.", "categories": ["nerdy"] }, { "id": 377, "joke": "When Arnold says &quot;I'll be back&quot; in Terminator movie it is implied that he's going to ask Chuck Norris for help.", "categories": [] }, { "id": 537, "joke": "Each hair in Chuck Norris's beard contributes to make the world's largest DDOS.", "categories": ["nerdy"] }, { "id": 336, "joke": "Chuck Norris uses tabasco sauce instead of visine.", "categories": [] }, { "id": 306, "joke": "Scientifically speaking, it is impossible to charge Chuck Norris with &quot;obstruction of justice.&quot; This is because even Chuck Norris cannot be in two places at the same time.", "categories": [] }, { "id": 500, "joke": "Chuck Norris can access the DB from the UI.", "categories": ["nerdy"] }, { "id": 17, "joke": "Chuck Norris does not teabag the ladies. He potato-sacks them.", "categories": ["explicit"] }, { "id": 224, "joke": "When Chuck Norris plays Oregon Trail, his family does not die from cholera or dysentery, but rather, roundhouse kicks to the face. He also requires no wagon, since he carries the oxen, axels, and buffalo meat on his back. He always makes it to Oregon before you.", "categories": [] }, { "id": 534, "joke": "Chuck Norris is the ultimate mutex, all threads fear him.", "categories": ["nerdy"] }, { "id": 278, "joke": "They had to edit the first ending of 'Lone Wolf McQuade' after Chuck Norris kicked David Carradine's ass, then proceeded to barbecue and eat him.", "categories": [] }, { "id": 529, "joke": "Chuck Norris doesn't use Oracle, he is the Oracle.", "categories": ["nerdy"] }, { "id": 215, "joke": "Chuck Norris just says &quot;no&quot; to drugs. If he said &quot;yes&quot;, it would collapse Colombia's infrastructure.", "categories": [] }, { "id": 236, "joke": "Sticks and stones may break your bones, but a Chuck Norris glare will liquefy your kidneys.", "categories": [] }, { "id": 283, "joke": "The only sure things are Death and Taxes?and when Chuck Norris goes to work for the IRS, they'll be the same thing.", "categories": [] }, { "id": 440, "joke": "Most tough men eat nails for breakfast. Chuck Norris does all of his grocery shopping at Home Depot.", "categories": [] }, { "id": 213, "joke": "How many Chuck Norris' does it take to change a light bulb? None, Chuck Norris prefers to kill in the dark.", "categories": [] }, { "id": 96, "joke": "Nobody doesn't like Sara Lee. Except Chuck Norris.", "categories": [] }, { "id": 366, "joke": "If Chuck Norris wants your opinion, he'll beat it into you.", "categories": [] }, { "id": 506, "joke": "Chuck Norris programs do not accept input.", "categories": ["nerdy"] }, { "id": 382, "joke": "Chuck Norris once participated in the running of the bulls. He walked.", "categories": [] }, { "id": 59, "joke": "Chuck Norris once roundhouse kicked someone so hard that his foot broke the speed of light, went back in time, and killed Amelia Earhart while she was flying over the Pacific Ocean.", "categories": [] }, { "id": 33, "joke": "Chuck Norris once shot down a German fighter plane with his finger. By yelling &quot;Bang!&quot;", "categories": [] }, { "id": 30, "joke": "Someone once tried to tell Chuck Norris that roundhouse kicks aren't the best way to kick someone. This has been recorded by historians as the worst mistake anyone has ever made.", "categories": [] }, { "id": 556, "joke": "Chuck Norris can write to an output stream.", "categories": ["nerdy"] }, { "id": 106, "joke": "Little known medical fact: Chuck Norris invented the Caesarean section when he roundhouse-kicked his way out of his monther's womb.", "categories": [] }, { "id": 103, "joke": "Chuck Norris and Mr. T walked into a bar. The bar was instantly destroyed, as that level of awesome cannot be contained in one building.", "categories": [] }, { "id": 480, "joke": "The class object inherits from Chuck Norris", "categories": ["nerdy"] }, { "id": 206, "joke": "Chuck Norris destroyed the periodic table, because Chuck Norris only recognizes the element of surprise.", "categories": [] }, { "id": 121, "joke": "It takes 14 puppeteers to make Chuck Norris smile, but only 2 to make him destroy an orphanage.", "categories": [] }, { "id": 335, "joke": "Chuck Norris likes his coffee half and half: half coffee grounds, half wood-grain alcohol.", "categories": [] }, { "id": 117, "joke": "James Cameron wanted Chuck Norris to play the Terminator. However, upon reflection, he realized that would have turned his movie into a documentary, so he went with Arnold Schwarzenegger.", "categories": [] }, { "id": 46, "joke": "Chuck Norris once ate three 72 oz. steaks in one hour. He spent the first 45 minutes having sex with his waitress.", "categories": ["explicit"] }, { "id": 292, "joke": "If you were somehow able to land a punch on Chuck Norris your entire arm would shatter upon impact. This is only in theory, since, come on, who in their right mind would try this?", "categories": [] }, { "id": 159, "joke": "Chuck Norris did in fact, build Rome in a day.", "categories": [] }, { "id": 460, "joke": "The only pattern Chuck Norris knows is God Object.", "categories": ["nerdy"] }, { "id": 430, "joke": "Chuck Norris does not wear a condom. Because there is no such thing as protection from Chuck Norris.", "categories": [] }, { "id": 363, "joke": "When Chuck Norris goes to out to eat, he orders a whole chicken, but he only eats its soul.", "categories": [] }, { "id": 245, "joke": "The original title for Alien vs. Predator was Alien and Predator vs Chuck Norris. The film was cancelled shortly after going into preproduction. No one would pay nine dollars to see a movie fourteen seconds long.", "categories": [] }, { "id": 561, "joke": "Chuck Norris doesn't need an account. He just logs in.", "categories": [] }, { "id": 473, "joke": "Chuck Norris can overflow your stack just by looking at it.", "categories": ["nerdy"] }, { "id": 119, "joke": "Thousands of years ago Chuck Norris came across a bear. It was so terrified that it fled north into the arctic. It was also so terrified that all of its decendents now have white hair.", "categories": [] }, { "id": 296, "joke": "Chuck Norris uses 8'x10' sheets of plywood as toilet paper.", "categories": [] }, { "id": 507, "joke": "Chuck Norris can install iTunes without installing Quicktime.", "categories": ["nerdy"] }, { "id": 442, "joke": "Everything King Midas touches turnes to gold. Everything Chuck Norris touches turns up dead.", "categories": [] }, { "id": 208, "joke": "Chuck Norris shot the sheriff, but he round house kicked the deputy.", "categories": [] }, { "id": 248, "joke": "Chuck Norris once shat blood - the blood of 11,940 natives he had killed and eaten.", "categories": [] }, { "id": 48, "joke": "Chuck Norris can win a game of Connect Four in only three moves.", "categories": [] }, { "id": 383, "joke": "The Drummer for Def Leppard's only got one arm. Chuck Norris needed a back scratcher.", "categories": [] }, { "id": 358, "joke": "The 11th commandment is ?Thou shalt not piss off Chuck Norris? This commandment is rarely enforced, as it is impossible to accomplish.", "categories": [] }, { "id": 387, "joke": "For Spring Break '05, Chuck Norris drove to Madagascar, riding a chariot pulled by two electric eels.", "categories": [] }, { "id": 43, "joke": "Police label anyone attacking Chuck Norris as a Code 45-11.... A suicide.", "categories": [] }, { "id": 53, "joke": "Chuck Norris drives an ice cream truck covered in human skulls.", "categories": [] }, { "id": 543, "joke": "Chuck Norris's programs can pass the Turing Test by staring at the interrogator.", "categories": ["nerdy"] }, { "id": 550, "joke": "Chuck Norris can speak Braille.", "categories": [] }, { "id": 26, "joke": "Chuck Norris is the only human being to display the Heisenberg uncertainty principle - you can never know both exactly where and how quickly he will roundhouse-kick you in the face.", "categories": ["nerdy"] }, { "id": 549, "joke": "Chuck Norris killed two stones with one bird.", "categories": [] }, { "id": 199, "joke": "When Chuck Norris says &quot;More cowbell&quot;, he MEANS it.", "categories": [] }, { "id": 277, "joke": "Chuck Norris can blow bubbles with beef jerky.", "categories": [] }, { "id": 153, "joke": "The movie &quot;Delta Force&quot; was extremely hard to make because Chuck had to downplay his abilities. The first few cuts were completely unbelievable.", "categories": [] }, { "id": 270, "joke": "The phrase 'dead ringer' refers to someone who sits behind Chuck Norris in a movie theater and forgets to turn their cell phone off.", "categories": [] }, { "id": 157, "joke": "A study showed the leading causes of death in the United States are: 1. Heart disease, 2. Chuck Norris, 3. Cancer", "categories": [] }, { "id": 151, "joke": "Chuck Norris doesn't step on toes. Chuck Norris steps on necks.", "categories": [] }, { "id": 129, "joke": "Chuck Norris keeps his friends close and his enemies closer. Close enough to drop them with one round house kick to the face.", "categories": [] }, { "id": 218, "joke": "Chuck Norris invented the internet? just so he had a place to store his porn.", "categories": [] }, { "id": 419, "joke": "Count from one to ten. That's how long it would take Chuck Norris to kill you...Fourty seven times.", "categories": [] }, { "id": 255, "joke": "Chuck Norris does not have to answer the phone. His beard picks up the incoming electrical impulses and translates them into audible sound.", "categories": [] }, { "id": 409, "joke": "The term &quot;Cleveland Steamer&quot; got its name from Chuck Norris, when he took a dump while visiting the Rock and Roll Hall of fame and buried northern Ohio under a glacier of fecal matter.", "categories": [] }, { "id": 562, "joke": "How many Chuck Norris require to screw a light bulb? None, he will screw it all.", "categories": [] }, { "id": 54, "joke": "If you ask Chuck Norris what time it is, he always says, &quot;Two seconds 'til.&quot; After you ask, &quot;Two seconds 'til what?&quot; he roundhouse kicks you in the face.", "categories": [] }, { "id": 542, "joke": "Chuck Norris types with one finger. He points it at the keyboard and the keyboard does the rest.", "categories": ["nerdy"] }, { "id": 468, "joke": "Chuck Norris's beard can type 140 wpm.", "categories": ["nerdy"] }, { "id": 58, "joke": "Crop circles are Chuck Norris' way of telling the world that sometimes corn needs to lie down.", "categories": [] }, { "id": 180, "joke": "When J. Robert Oppenheimer said &quot;I am become death, the destroyer Of worlds&quot;, He was not referring to the atomic bomb. He was referring to the Chuck Norris halloween costume he was wearing.", "categories": [] }, { "id": 322, "joke": "When Chuck Norris plays Monopoly, it affects the actual world economy.", "categories": [] }, { "id": 175, "joke": "When Chuck Norris was a baby, he didn't suck his mother's breast. His mother served him whiskey, straight out of the bottle.", "categories": [] }, { "id": 247, "joke": "Chuck Norris can win at solitaire with only 18 cards.", "categories": [] }, { "id": 301, "joke": "The First Law of Thermodynamics states that energy can neither be created nor destroyed... unless it meets Chuck Norris.", "categories": [] }, { "id": 88, "joke": "Chuck Norris doesnt shave; he kicks himself in the face. The only thing that can cut Chuck Norris is Chuck Norris.", "categories": [] }, { "id": 192, "joke": "There is endless debate about the existence of the human soul. Well it does exist and Chuck Norris finds it delicious.", "categories": [] }, { "id": 23, "joke": "Time waits for no man. Unless that man is Chuck Norris.", "categories": [] }, { "id": 433, "joke": "In ancient China there is a legend that one day a child will be born from a dragon, grow to be a man, and vanquish evil from the land. That man is not Chuck Norris, because Chuck Norris killed that man.", "categories": [] }, { "id": 66, "joke": "Chuck Norris can't finish a &quot;color by numbers&quot; because his markers are filled with the blood of his victims. Unfortunately, all blood is dark red.", "categories": [] }, { "id": 526, "joke": "No one has ever pair-programmed with Chuck Norris and lived to tell about it.", "categories": ["nerdy"] }, { "id": 511, "joke": "Every SQL statement that Chuck Norris codes has an implicit &quot;COMMIT&quot; in its end.", "categories": ["nerdy"] }, { "id": 133, "joke": "Chuck Norris doesn't stub his toes. He accidentally destroys chairs, bedframes, and sidewalks.", "categories": [] }, { "id": 244, "joke": "Chuck Norris got his drivers license at the age of 16. Seconds.", "categories": [] }, { "id": 92, "joke": "Chuck Norris invented black. In fact, he invented the entire spectrum of visible light. Except pink. Tom Cruise invented pink.", "categories": [] }, { "id": 39, "joke": "Chuck Norris will attain statehood in 2009. His state flower will be the Magnolia.", "categories": [] }, { "id": 282, "joke": "Chuck Norris can skeletize a cow in two minutes.", "categories": [] }, { "id": 219, "joke": "Chuck Norris does not own a house. He walks into random houses and people move.", "categories": [] }, { "id": 77, "joke": "Chuck Norris can divide by zero.", "categories": [] }, { "id": 268, "joke": "He who lives by the sword, dies by the sword. He who lives by Chuck Norris, dies by the roundhouse kick.", "categories": [] }, { "id": 240, "joke": "In a fight between Batman and Darth Vader, the winner would be Chuck Norris.", "categories": [] }, { "id": 369, "joke": "A movie scene depicting Chuck Norris losing a fight with Bruce Lee was the product of history's most expensive visual effect. When adjusted for inflation, the effect cost more than the Gross National Product of Paraguay.", "categories": [] }, { "id": 40, "joke": "A handicapped parking sign does not signify that this spot is for handicapped people. It is actually in fact a warning, that the spot belongs to Chuck Norris and that you will be handicapped if you park there.", "categories": [] }, { "id": 35, "joke": "Fool me once, shame on you. Fool Chuck Norris once and he will roundhouse kick you in the face.", "categories": [] }, { "id": 45, "joke": "What was going through the minds of all of Chuck Norris' victims before they died? His shoe.", "categories": [] }, { "id": 465, "joke": "Whiteboards are white because Chuck Norris scared them that way.", "categories": [] }, { "id": 522, "joke": "Chuck Norris can do a wheelie on a unicycle.", "categories": [] }, { "id": 190, "joke": "Chuck Norris brushes his teeth with a mixture of iron shavings, industrial paint remover, and wood-grain alcohol.", "categories": [] }, { "id": 299, "joke": "Jack Bauer tried to use his detailed knowledge of torture techniques, but to no avail: Chuck Norris thrives on pain. Chuck Norris then ripped off Jack Bauer's arm and beat him to death with it. Game, set, match.", "categories": [] }, { "id": 528, "joke": "Chuck Norris doesn't use GUI, he prefers COMMAND line.", "categories": ["nerdy"] }, { "id": 107, "joke": "Chuck Norris doesn't bowl strikes, he just knocks down one pin and the other nine faint.", "categories": [] }, { "id": 538, "joke": "Chuck Norris's log statements are always at the FATAL level.", "categories": ["nerdy"] }, { "id": 281, "joke": "4 out of 5 doctors fail to recommend Chuck Norris as a solution to most problems. Also, 80% of doctors die unexplained, needlessly brutal deaths.", "categories": [] }, { "id": 475, "joke": "Chuck Norris doesn't need sudo, he just types &quot;Chuck Norris&quot; before his commands.", "categories": ["nerdy"] }, { "id": 130, "joke": "There is in fact an 'I' in Norris, but there is no 'team'. Not even close.", "categories": [] }, { "id": 137, "joke": "Tom Clancy has to pay royalties to Chuck Norris because &quot;The Sum of All Fears&quot; is the name of Chuck Norris' autobiography.", "categories": [] }, { "id": 435, "joke": "When you play Monopoly with Chuck Norris, you do not pass go, and you do not collect two hundred dollars. You will be lucky if you make it out alive.", "categories": [] }, { "id": 34, "joke": "The opening scene of the movie &quot;Saving Private Ryan&quot; is loosely based on games of dodgeball Chuck Norris played in second grade.", "categories": [] }, { "id": 422, "joke": "Mr. T pities the fool. Chuck Norris rips the fool's head off.", "categories": [] }, { "id": 21, "joke": "Chuck Norris doesn't shower, he only takes blood baths.", "categories": [] }, { "id": 388, "joke": "The Manhattan Project was not intended to create nuclear weapons, it was meant to recreate the destructive power in a Chuck Norris Roundhouse Kick. They didn't even come close.", "categories": [] }, { "id": 462, "joke": "Project managers never ask Chuck Norris for estimations... ever.", "categories": ["nerdy"] }, { "id": 257, "joke": "Chuck Norris doesnt wear a watch, HE decides what time it is.", "categories": [] }, { "id": 472, "joke": "When Chuck Norris is web surfing websites get the message &quot;Warning: Internet Explorer has deemed this user to be malicious or dangerous. Proceed?&quot;.", "categories": ["nerdy"] }, { "id": 566, "joke": "Chuck Norris could use anything in java.util.* to kill you, including the javadocs.", "categories": ["nerdy"] }, { "id": 415, "joke": "When Chuck Norris wants an egg, he cracks open a chicken.", "categories": [] }, { "id": 418, "joke": "Chuck Norris doesn't believe in ravioli. He stuffs a live turtle with beef and smothers it in pig's blood.", "categories": [] }, { "id": 87, "joke": "Contrary to popular belief, there is indeed enough Chuck Norris to go around.", "categories": [] }, { "id": 134, "joke": "Using his trademark roundhouse kick, Chuck Norris once made a fieldgoal in RJ Stadium in Tampa Bay from the 50 yard line of Qualcomm stadium in San Diego.", "categories": [] }, { "id": 125, "joke": "Simply by pulling on both ends, Chuck Norris can stretch diamonds back into coal.", "categories": [] }, { "id": 405, "joke": "One time, at band camp, Chuck Norris ate a percussionist.", "categories": [] }, { "id": 256, "joke": "How many roundhouse kicks does it take to get to the center of a tootsie pop? Just one. From Chuck Norris.", "categories": [] }, { "id": 467, "joke": "Chuck Norris can delete the Recycling Bin.", "categories": ["nerdy"] }, { "id": 499, "joke": "Chuck Norris's keyboard has the Any key.", "categories": ["nerdy"] }, { "id": 5, "joke": "Chuck Norris lost his virginity before his dad did.", "categories": ["explicit"] }, { "id": 343, "joke": "Chuck Norris doesn't chew gum. Chuck Norris chews tin foil.", "categories": [] }, { "id": 329, "joke": "There are only two things that can cut diamonds: other diamonds, and Chuck Norris.", "categories": [] }, { "id": 361, "joke": "Who let the dogs out? Chuck Norris let the dogs out... and then roundhouse kicked them through an Oldsmobile.", "categories": [] }, { "id": 375, "joke": "After taking a steroids test doctors informed Chuck Norris that he had tested positive. He laughed upon receiving this information, and said &quot;of course my urine tested positive, what do you think they make steroids from?&quot;", "categories": [] }, { "id": 284, "joke": "Chuck Norris' first job was as a paperboy. There were no survivors.", "categories": [] }, { "id": 483, "joke": "Bill Gates thinks he's Chuck Norris. Chuck Norris actually laughed. Once.", "categories": [] }, { "id": 177, "joke": "Chuck Norris once pulled out a single hair from his beard and skewered three men through the heart with it.", "categories": [] }, { "id": 120, "joke": "Chuck Norris played Russian Roulette with a fully loaded gun and won.", "categories": [] }, { "id": 140, "joke": "Chuck Norris built a better mousetrap, but the world was too frightened to beat a path to his door.", "categories": [] }, { "id": 182, "joke": "In a recent survey it was discovered the 94% of American women lost their virginity to Chuck Norris. The other 6% were incredibly fat or ugly.", "categories": [] }, { "id": 116, "joke": "Chuck Norris once ate an entire bottle of sleeping pills. They made him blink.", "categories": [] }, { "id": 396, "joke": "Only Chuck Norris can prevent forest fires.", "categories": [] }, { "id": 555, "joke": "Chuck Norris doesn't have pubic hairs because hair doesn't grow on balls of steal.", "categories": ["explicit"] }, { "id": 220, "joke": "It is better to give than to receive. This is especially true of a Chuck Norris roundhouse kick.", "categories": [] }, { "id": 553, "joke": "China lets Chuck Norris search for porn on Google.", "categories": ["explicit"] }, { "id": 397, "joke": "When Chuck Norris makes a burrito, its main ingredient is real toes.", "categories": [] }, { "id": 216, "joke": "Since 1940, the year Chuck Norris was born, roundhouse-kick related deaths have increased 13,000 percent.", "categories": [] }, { "id": 173, "joke": "'Icy-Hot' is too weak for Chuck Norris. After a workout, Chuck Norris rubs his muscles down with liquid-hot MAGMA.", "categories": [] }, { "id": 355, "joke": "In the X-Men movies, none of the X-Men super-powers are done with special effects. Chuck Norris is the stuntman for every character.", "categories": [] }, { "id": 451, "joke": "Chuck Norris writes code that optimizes itself.", "categories": ["nerdy"] }, { "id": 423, "joke": "Chuck Norris had to stop washing his clothes in the ocean. The tsunamis were killing people.", "categories": [] }, { "id": 392, "joke": "After returning from World War 2 unscrathed, Bob Dole was congratulated by Chuck Norris with a handshake. The rest is history.", "categories": [] }, { "id": 557, "joke": "Chuck Norris can read from an input stream.", "categories": ["nerdy"] }, { "id": 352, "joke": "Chuck Norris doesn't see dead people. He makes people dead.", "categories": [] }, { "id": 152, "joke": "Chuck Norris doesn't step on toes. Chuck Norris steps on necks.", "categories": [] }, { "id": 524, "joke": "Chuck Norris eats lightning and shits out thunder.", "categories": [] }, { "id": 20, "joke": "The Chuck Norris military unit was not used in the game Civilization 4, because a single Chuck Norris could defeat the entire combined nations of the world in one turn.", "categories": ["nerdy"] }, { "id": 195, "joke": "Chuck Norris wears a live rattlesnake as a condom.", "categories": [] }, { "id": 325, "joke": "Every time someone uses the word &quot;intense&quot;, Chuck Norris always replies &quot;you know what else is intense?&quot; followed by a roundhouse kick to the face.", "categories": [] }, { "id": 457, "joke": "MySpace actually isn't your space, it's Chuck's (he just lets you use it).", "categories": ["nerdy"] }, { "id": 429, "joke": "Chuck Norris has never been accused of murder because his roundhouse kicks are recognized as &quot;acts of God.&quot;", "categories": [] }, { "id": 464, "joke": "&quot;It works on my machine&quot; always holds true for Chuck Norris.", "categories": ["nerdy"] }, { "id": 204, "joke": "Nagasaki never had a bomb dropped on it. Chuck Norris jumped out of a plane and punched the ground", "categories": [] }, { "id": 74, "joke": "In honor of Chuck Norris, all McDonald's in Texas have an even larger size than the super-size. When ordering, just ask to be Chucksized.", "categories": [] }, { "id": 424, "joke": "Chuck Norris has volunteered to remain on earth after the Rapture; he will spend his time fighting the Anti-Christ.", "categories": [] }, { "id": 548, "joke": "Product Owners never argue with Chuck Norris after he demonstrates the DropKick feature.", "categories": ["nerdy"] }, { "id": 290, "joke": "There are two types of people in the world... people that suck, and Chuck Norris.", "categories": [] }, { "id": 380, "joke": "Chuck Norris does not follow fashion trends, they follow him. But then he turns around and kicks their ass. Nobody follows Chuck Norris.", "categories": [] }, { "id": 316, "joke": "In the medical community, death is referred to as &quot;Chuck Norris Disease&quot;", "categories": [] }, { "id": 545, "joke": "Chuck Norris's brain waves are suspected to be harmful to cell phones.", "categories": [] }, { "id": 389, "joke": "Chuck Norris has banned rainbows from the state of North Dakota.", "categories": [] }, { "id": 287, "joke": "Chuck Norris' testicles do not produce sperm. They produce tiny white ninjas that recognize only one mission: seek and destroy.", "categories": [] }, { "id": 242, "joke": "Everybody loves Raymond. Except Chuck Norris.", "categories": [] }, { "id": 217, "joke": "Crime does not pay - unless you are an undertaker following Walker, Texas Ranger, on a routine patrol.", "categories": [] }, { "id": 427, "joke": "Chuck Norris' favorite cereal is Kellogg's Nails 'N' Gravel.", "categories": [] }, { "id": 262, "joke": "Chuck Norris used to play baseball. When Babe Ruth was hailed as the better player, Chuck Norris killed him with a baseball bat to the throat. Lou Gehrig got off easy.", "categories": [] }, { "id": 520, "joke": "With Chuck Norris P = NP. There's no nondeterminism with Chuck Norris decisions.", "categories": ["nerdy"] }, { "id": 320, "joke": "The First rule of Chuck Norris is: you do not talk about Chuck Norris.", "categories": [] }, { "id": 438, "joke": "Chuck Norris likes his ice like he likes his skulls: crushed.", "categories": [] }, { "id": 246, "joke": "Chuck Norris? sperm is so badass, he had sex with Nicole Kidman, and 7 months later she prematurely gave birth to a Ford Excursion.", "categories": [] }, { "id": 254, "joke": "Chuck Norris doesn't look both ways before he crosses the street... he just roundhouses any cars that get too close.", "categories": [] }, { "id": 174, "joke": "Chuck Norris cannot love, he can only not kill.", "categories": [] }, { "id": 55, "joke": "Most people have 23 pairs of chromosomes. Chuck Norris has 72... and they're all poisonous.", "categories": [] }, { "id": 416, "joke": "Chuck Norris plays racquetball with a waffle iron and a bowling ball.", "categories": [] }, { "id": 289, "joke": "Chuck Norris has never been in a fight, ever. Do you call one roundhouse kick to the face a fight?", "categories": [] }, { "id": 178, "joke": "In an act of great philanthropy, Chuck made a generous donation to the American Cancer Society. He donated 6,000 dead bodies for scientific research.", "categories": [] }, { "id": 97, "joke": "Chuck Norris doesn't throw up if he drinks too much. Chuck Norris throws down!", "categories": [] }, { "id": 315, "joke": "Chuck Norris never goes to the dentist because his teeth are unbreakable. His enemies never go to the dentist because they have no teeth.", "categories": [] }, { "id": 481, "joke": "For Chuck Norris, NP-Hard = O(1).", "categories": ["nerdy"] }, { "id": 90, "joke": "Chuck Norris always knows the EXACT location of Carmen SanDiego.", "categories": [] }, { "id": 15, "joke": "When Chuck Norris goes to donate blood, he declines the syringe, and instead requests a hand gun and a bucket.", "categories": [] }, { "id": 567, "joke": "Code runs faster when Chuck Norris watches it.", "categories": ["nerdy"] }, { "id": 479, "joke": "Chuck Norris does not need to know about class factory pattern. He can instantiate interfaces.", "categories": ["nerdy"] }, { "id": 112, "joke": "The Bermuda Triangle used to be the Bermuda Square, until Chuck Norris Roundhouse kicked one of the corners off.", "categories": [] }, { "id": 118, "joke": "Chuck Norris can touch MC Hammer.", "categories": [] }, { "id": 546, "joke": "Chuck Norris does infinit loops in 4 seconds.", "categories": ["nerdy"] }, { "id": 372, "joke": "Chuck Norris once rode a nine foot grizzly bear through an automatic car wash, instead of taking a shower.", "categories": [] }, { "id": 498, "joke": "Chuck Norris hosting is 101% uptime guaranteed.", "categories": ["nerdy"] }, { "id": 305, "joke": "Chuck Norris knows everything there is to know - Except for the definition of mercy.", "categories": [] }, { "id": 304, "joke": "It is said that looking into Chuck Norris' eyes will reveal your future. Unfortunately, everybody's future is always the same: death by a roundhouse-kick to the face.", "categories": [] }, { "id": 360, "joke": "Two wrongs don't make a right. Unless you're Chuck Norris. Then two wrongs make a roundhouse kick to the face.", "categories": [] }, { "id": 104, "joke": "If you Google search &quot;Chuck Norris getting his ass kicked&quot; you will generate zero results. It just doesn't happen.", "categories": [] }, { "id": 13, "joke": "Chuck Norris once challenged Lance Armstrong in a &quot;Who has more testicles?&quot; contest. Chuck Norris won by 5.", "categories": ["explicit"] }, { "id": 42, "joke": "Chuck Norris doesn't churn butter. He roundhouse kicks the cows and the butter comes straight out.", "categories": [] }, { "id": 56, "joke": "The Great Wall of China was originally created to keep Chuck Norris out. It failed miserably.", "categories": [] }, { "id": 452, "joke": "Chuck Norris can't test for equality because he has no equal.", "categories": ["nerdy"] }, { "id": 38, "joke": "Someone once videotaped Chuck Norris getting pissed off. It was called Walker: Texas Chain Saw Masacre.", "categories": [] }, { "id": 128, "joke": "A high tide means Chuck Norris is flying over your coast. The tide is caused by God pissing his pants.", "categories": [] }, { "id": 469, "joke": "Chuck Norris can unit test entire applications with a single assert.", "categories": ["nerdy"] }, { "id": 374, "joke": "Chuck Norris' sperm can be seen with the naked eye. Each one is the size of a quarter.", "categories": [] }, { "id": 311, "joke": "Paper beats rock, rock beats scissors, and scissors beats paper, but Chuck Norris beats all 3 at the same time.", "categories": [] }, { "id": 3, "joke": "Chuck Norris doesn't read books. He stares them down until he gets the information he wants.", "categories": [] }, { "id": 76, "joke": "If tapped, a Chuck Norris roundhouse kick could power the country of Australia for 44 minutes.", "categories": [] }, { "id": 458, "joke": "Chuck Norris can write infinite recursion functions and have them return.", "categories": ["nerdy"] }, { "id": 492, "joke": "There is no Esc key on Chuck Norris' keyboard, because no one escapes Chuck Norris.", "categories": ["nerdy"] }, { "id": 471, "joke": "Chuck Norris's keyboard doesn't have a Ctrl key because nothing controls Chuck Norris.", "categories": ["nerdy"] } ]);