
/* Main Functions
***************************************************************/

var fortuneTelling = false,
    shake,
    onShake = function () {
        fortuneMe();
    };

function firstUseMsg () {
    fortuneTelling = true
    $('#fortuneString').html("Welcome to ClaireBot. <br>Set your signs in the left menu shake for a new fortune from ClaireBot, or tap Get My Fortune to learn your fate.");
    $('#fortune').fadeIn(1000);
    setTimeout( function(){ $('#fortune').fadeOut(1000); resetBot(); fortuneTelling = false }, 6000 );
}

function welcomeMsg () {
    fortuneTelling = true
    $('#fortuneString').html("Welcome back "+localStorage.name);
    $('#fortune').fadeIn(1000);
    setTimeout( function(){ $('#fortune').fadeOut(1000); resetBot(); fortuneTelling = false }, 2000 );
}

function getFortune () {
    if(fortuneTelling == true) {
        shake.stopWatch();
        var number = Math.floor(Math.random()*463);

        $.ajax({
            type: "GET",
            url: "fortunes.json",
            dataType: "json",
            success: function(json) {
                $('#fortuneString').html(json.fortunes[number]);
            }
        });

        $('#fortune').fadeIn(1000);
        setTimeout( function(){ $('#fortune').fadeOut(1000); resetBot(); fortuneTelling = false; shake.startWatch(onShake); }, 5000 );
    }
}

function onDeviceReady () {
    if (parseFloat(window.device.version) === 7.0) {
          document.body.style.marginTop = "20px";
    }

    shake = new Shake({
        frequency: 300,
        waitBetweenShakes: 1500,
        threshold: 30,
        success: function(magnitude, accelerationDelta, timestamp) {
            fortuneMe();
        },
        failure: function() {
            console.log("wtf");
        },
    });

    shake.startWatch(onShake);
}

function fortuneMe () {
    if (fortuneTelling == false) {
        navigator.notification.beep(1);
        navigator.notification.vibrate(2500);
        fortuneTelling = true;
        $('#paper').animate({ height : "120px" }, 1500);
        setTimeout(function(){ $('#paper').hide(); getFortune(); }, 1500);
    }
}

function resetBot () {
    $('#paper').css('height','5px').show();
}

function getHoroscope (type, scope) {
    if (type == "chinese") {
        $.ajax({
            type: "GET",
            crossDomain: true,
            dataType: "jsonp",
            data: { "scope" : scope },
            url: "https://ottacon.co/_app_functions/clairebot/chinese_horoscopes.php"
        });
    } else {
        $.ajax({
            type: "GET",
            crossDomain: true,
            dataType: "jsonp",
            data: { "scope" : scope },
            url: "https://ottacon.co/_app_functions/clairebot/horoscopes.php"
        });
    }
}

function horoscopePopulate (data, type) {
    if (type === "chinese") {
        $("#c_horoscope_title").html(data[0].sign);
        $("#c_horoscope_description").html(data[0].description);
        $("#c_horoscope_link").attr("href", data[0].link);
    } else {
        $("#horoscope_title").html(data[0].sign);
        $("#horoscope_description").html(data[0].description);
        $("#horoscope_link").attr("href", data[0].link);
    }
}

function getDetails () {
    if (localStorage.horoscope_sign > "") {
        getHoroscope("greek", localStorage.horoscope_sign);
        $("#horoscope_link").show();
    } else {
        $("#horoscope_title").html('Please update your settings, to get your horoscope');
        $("#horoscope_link").hide();
    }

    if (localStorage.c_horoscope_sign > "") {
        getHoroscope("chinese", localStorage.c_horoscope_sign);
        $("#c_horoscope_link").show();
    } else {
        $("#c_horoscope_title").html('Please update your settings, to get your chinese horoscope');
        $("#c_horoscope_link").hide();
    }
}

/* Document load
***************************************************************/

$(document).on('pagechange', function() {
    setTimeout(function(){
        // $(".wrapper").each(function(){
        //     $(this).css({
        //         minHeight: ($(window).height()-20)+"px"
        //     });
        // });
    }, 20);
    setTimeout(function(){
        $(".claire").fadeIn();
        $(".button-holder").fadeIn();
    }, 30);
});

$("a").bind("click", function(){
    setTimeout(function(){
        // $(".wrapper").each(function(){
        //     $(this).css({
        //         minHeight: ($(window).height()-20)+"px"
        //     });
        // });
    }, 20);
    setTimeout(function(){
        $(".claire").fadeIn();
        $(".button-holder").fadeIn();
    }, 30);
});

$(function() {

    // $(".wrapper").each(function(){
    //     $(this).css({
    //         minHeight: ($(window).height()-20)+"px"
    //     });
    // });

    if ( ! localStorage.name) {
        firstUseMsg();
    }

    if (localStorage.name > ""){
        welcomeMsg();
    }

    $("#getFortuneBtn").bind("click", function(){
        fortuneMe();
    });

    $("#fortune").bind("click", function(){
        $('#fortune').fadeOut();
        resetBot();
    });

    getDetails();

    $("#saveSettings").bind("click", function(){
        localStorage.name = $("#name").val();
        localStorage.horoscope_sign = $("#horoscope_sign").val();
        localStorage.c_horoscope_sign = $("#c_horoscope_sign").val();

        $("#horoscope_link").show();
        $("#c_horoscope_link").show();

        getDetails();

        $.mobile.changePage('index.html#getFortune');
        shake.startWatch(onShake);
    });

    $("#resetBtn").bind("click", function(){
        localStorage.name = "";
        localStorage.horoscope_sign = "";
        localStorage.c_horoscope_sign = "";
        $("#name").val("");
        $("#horoscope_sign").val("").selectmenu('refresh');;
        $("#c_horoscope_sign").val("").selectmenu('refresh');;

        $("#horoscope_link").hide();
        $("#c_horoscope_link").hide();

        getDetails();

        $.mobile.changePage('index.html#settings');
        shake.startWatch(onShake);
    });

    if (localStorage.name > "") {
        $("#name").val(localStorage.name);
    }

    if (localStorage.horoscope_sign > "") {
        $('#horoscope_sign').val(localStorage.horoscope_sign);
    }

    if (localStorage.c_horoscope_sign > "") {
        $('#c_horoscope_sign').val(localStorage.c_horoscope_sign);
    }

    document.addEventListener('deviceready', onDeviceReady, false);

});
