var user;
var filtered=0;

$(document).ready(function() {
	if (window.localStorage) {
		filtered = localStorage.getItem ("filtered");
		if (filtered==1) $('.g-toolbar-note').removeClass('g-display-none');
			
		user=localStorage.getItem("user");
		if (user) {	user=JSON.parse (user); }
		else { 
		// Chage this on Prod
		window.location.href = './login.html#filter1';
		}
	}
	else {
		alert ('Your browser does not support Local Storage. This application will not work properly.');
	}
});

$(document).ready(function() {
	if (user) {
		var categories = localStorage.getItem("categories");
		var adds = localStorage.getItem("adds");
		var comments = localStorage.getItem("comments");
		var bookmarked = localStorage.getItem("bookmarked");
			
		if (!categories || !adds || !comments || !bookmarked) {
			FetchData();
		}
		else {
			FormCategories();
		}
	}
});

function FetchData () {
	var error=0;
	var completedCategories=0,completedAdds=0,completedBookmarked=0,completedComments=0;
	//Display the "Please Wait" Dialog. Required for Sync Conn
	$('#g-fetchingdata').addClass('fade-in');
	$('#g-toolbar').addClass('g-display-none');

	var SetError=function(e) { error=e; }
	var SetComplete=function(Name) {
		if (Name=="categories") completedCategories=1;
		if (Name=="adds") completedAdds=1;
		if (Name=="bookmarked") completedBookmarked=1;
		if (Name=="comments") completedComments=1;
		
		if (completedCategories==1 && completedAdds==1 && completedBookmarked==1 && completedComments==1) {
			After(error);
		}
	}
	
	//Actually Fetch the data
	var categoriesRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetCategories.php?callback=?",
      "success": function(data) {
        try {
			JSON.parse(data);
			localStorage.setItem ("categories", data);
			localStorage.setItem ("categories_full", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetCategories.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetCategories.');
		  SetError(1);
      },
	  "complete": function() { SetComplete("categories");  }
    });

	var addsRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetAdds.php?callback=?",
      "success": function(data) {
          try {
			JSON.parse(data);
			localStorage.setItem ("adds", data);
			localStorage.setItem ("adds_full", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetAdds.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetAdds.');
		  SetError(1);
      },
	  "complete": function() { SetComplete ("adds"); }
    });
	
	var commentsRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetComments.php?callback=?",
      "success": function(data) {
          try {
			JSON.parse(data);
			localStorage.setItem ("comments", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetComments.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetComments.');
		  SetError(1);
      },
	  "complete": function() { SetComplete("comments");  }
    });
	
	var bookmarkedRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetBookmarked.php?callback=?&username="+user.Username+"&pass="+user.Pass,
      "success": function(data) {
          try {
			JSON.parse(data);
			localStorage.setItem ("bookmarked", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetBookmarked.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetBookmarked.');
		  SetError(1);
      },
	  "complete": function() { SetComplete("bookmarked");  }
    });
	
	var After = function(error) {
		if (error == 1) { 
			$('#g-errorconnect').addClass('fade-in');
			
			$('#g-errorconnect>form>menu>button').click(function() {
				$('#g-errorconnect').removeClass ('fade-in');
				$('#g-errorconnect').addClass('fade-out');
				$('#g-errorconnect').removeClass ('fade-out');
			});
		}
		
		$('#g-fetchdata-cancel').click(function(){
			if (categoriesRequest) {
				categoriesRequest.abort();
			}
			if (addsRequest) {
				addsRequest.abort();
			}
			if (commentsRequest) {
				commentsRequest.abort();
			}
			if (bookmarkedRequest) {
				bookmarkedRequest.abort();
			}
			
			$('#g-fetchingdata').removeClass ('fade-in');
			$('#g-fetchingdata').addClass('fade-out');
			$('#g-fetchingdata').removeClass ('fade-out');
			$('#g-toolbar').removeClass('g-display-none');
		}) 
		
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
		
		FormCategories();
		FormCategoryLinks();
		$('.g-toolbar-note').addClass('g-display-none');
		filtered=0;
		localStorage.setItem("filtered",filtered);
		$('.g-back').trigger('click');
	}
}

function FetchComments () {
	//Ability to fetch Comments separatelly
	var error=0;
	
	//Display the "Please Wait" Dialog. Required for Sync Conn
	$('#g-fetchingdata').addClass('fade-in');
	$('#g-toolbar').addClass('g-display-none');
	
	var SetError=function(e) { error=e; }
	var SetComplete=function() {
		After(error);
	}
	
	var commentsRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetComments.php?callback=?",
      "success": function(data) {
          try {
			JSON.parse(data);
			localStorage.setItem ("comments", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetComments.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetComments.');
		  SetError(1);
      },
	  "complete": function() { SetComplete();  }
    });
	
	var After=function(error) {
		if (error == 1) { 
			$('#g-errorconnect').addClass('fade-in');
			
			$('#g-errorconnect>form>menu>button').click(function() {
				$('#g-errorconnect').removeClass ('fade-in');
				$('#g-errorconnect').addClass('fade-out');
				$('#g-errorconnect').removeClass ('fade-out');
			});
		}
		
		$('#g-fetchcomments-cancel').click(function(){
			
			if (commentsRequest) {
				commentsRequest.abort();
			}
			
			$('#g-fetchingdata').removeClass ('fade-in');
			$('#g-fetchingdata').addClass('fade-out');
			$('#g-fetchingdata').removeClass ('fade-out');
			$('#g-toolbar').removeClass('g-display-none');
		}) 
		
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
	}
}

function InsertAndFetchBookmark (userID, addID, wdswitch) {
	var error=0;

	//Display the "Please Wait" Dialog. Required for Sync Conn
	$('#g-fetchingdata').addClass('fade-in');
	$('#g-toolbar').addClass('g-display-none');

	$('#g-fetchcomments-cancel').click(function(){		
		if (bookmarkRequest) {
			commentsRequest.abort();
		}
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
	}) 
	
	var SetError=function(e) { error=e; }
	var SetComplete=function() {
		After(error);
	}
	
	if (wdswitch == 1) {	// if we're writing in.
		var bookmarkedRequest = $.jsonp({
		"url": "http://www.ennoble-studios.com/classifieds/dbInsertBookmarked.php?callback=?&username="+user.Username+"&pass="+user.Pass+"&addid="+addID ,
        "success": function(data) {
			try {
				var isOK=JSON.parse(data);
				if (isOK!='1') SetError(1);
			}
			catch (e) {
				data="";
				SetError(1);
				console.log('Error parsing result from dbInsertAdd.');
			}
		  },
		"error": function() {
			  console.log('NOT OK fetching data from dbInsertAdd.');
			  SetError(1);
		  },
		"complete": function() { SetComplete();  }
		});
		
	} else {	// Or are we deleting
		var bookmarkedRequest = $.jsonp({
		"url": "http://www.ennoble-studios.com/classifieds/dbDeleteBookmarked.php?callback=?&username="+user.Username+"&pass="+user.Pass+"&addid="+addID ,
        "success": function(data) {
			try {
				var isOK=JSON.parse(data);
				if (isOK!='1') SetError(1);
			}
			catch (e) {
				data="";
				SetError(1);
				console.log('Error parsing result from dbInsertAdd.');
			}
		  },
		"error": function() {
			  console.log('NOT OK fetching data from dbInsertAdd.');
			  SetError(1);
		  },
		"complete": function() { SetComplete();  }
		});
	}
	
	
var After=function(error) {
	if (error == 1) { 
		$('#g-errorconnect').addClass('fade-in');
		
		$('#g-errorconnect>form>menu>button').click(function() {
			$('#g-errorconnect').removeClass ('fade-in');
			$('#g-errorconnect').addClass('fade-out');
			$('#g-errorconnect').removeClass ('fade-out');
		});
	}
	
	var bookmarkedRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbGetBookmarked.php?callback=?&username="+user.Username+"&pass="+user.Pass,
      "success": function(data) {
          try {
			JSON.parse(data);
			localStorage.setItem ("bookmarked", data);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from GetBookmarked.')
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from GetBookmarked.');
		  SetError(1);
      },
	  "complete": function() { Afterall();  }
    });
	
	var Afterall=function() {
		if (error == 1) { 
			$('#g-errorconnect').addClass('fade-in');
			
			$('#g-errorconnect>form>menu>button').click(function() {
				$('#g-errorconnect').removeClass ('fade-in');
				$('#g-errorconnect').addClass('fade-out');
				$('#g-errorconnect').removeClass ('fade-out');
			});
		}
		
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
		
		if (error==0) {
			if (wdswitch==1) {
				$('#g-toolbar #btn-bookmark').removeClass('bookmark');
				$('#g-toolbar #btn-bookmark').addClass('bookmarked');
				$('#g-toolbar #btn-bookmark').attr("onclick","UnbookmarkThis("+userID+","+addID+")");
				$('#g-thisAdd').css("border-left","thick dotted #207dc8");
				$('#g-thisAdd').css("padding-left","5px");		
			} else {
				$('#g-toolbar #btn-bookmark').removeClass('bookmarked');
				$('#g-toolbar #btn-bookmark').addClass('bookmark');
				$('#g-toolbar #btn-bookmark').attr("onclick","BookmarkThis("+userID+","+addID+")");
				$('#g-thisAdd').css("border-left","none");
				$('#g-thisAdd').css("padding-left","0px");
			}		
		}
	}
  }
}

function FormCategories()	{
	if (window.localStorage) {
		var categories = localStorage.getItem("categories");
		// Categories from localStorage
		categories = JSON.parse(categories);
		var categories_html = "";
		for (i=0;i<categories.length;i++){
			categories_html += "<li class=\"g-categories\" data-categoryid=\" "+categories[i].ID+" \"><p class=\"g-add-overview\"><img src=\"icons/DownDoubleArrow.png\" style=\"margin-bottom:-5px;\" /> &nbsp;&nbsp;" + categories[i].Name + "</p></li>";
		}
		categories_html += "<li class=\"g-bigemptyspace\"></li>";
		$('.g-categories-data').html(categories_html);	
	}
	else {
		alert ('Your browser does not support Local Storage. This application will not work properly.');
	}
}

function FormAdds (categoryID)	{
	//Adds from localStorage
	if (window.localStorage) {
		var adds = localStorage.getItem("adds");
		adds = JSON.parse(adds);
		var bookmarked = localStorage.getItem("bookmarked");
		bookmarked = JSON.parse(bookmarked);
		
		var adds_html = "", empty_string = "";
		var starred=0;
		
		for (i=adds.length-1;i>=0;i--){
			starred=0;
			for (j=0; j<bookmarked.length; j++) {
				if (adds[i].ID==bookmarked[j].AddID) starred=1;
			}
			
			//console.log("Adds("+i+"):"+adds[i].CategoryID+"|"+categoryID+"|");
			if (parseInt(adds[i].CategoryID) == parseInt(categoryID)) {
			if ( (empty_string + adds[i].Price) == "null") {adds[i].Price = "Na upit</span></div></li>";}
			else { adds[i].Price += "<span class=\"g-blue\">&#128;</span></span></div></li>"; }
			
			adds_html += "<li class=\"g-adds\" data-addid=\""+adds[i].ID+"\">";
			
			if (starred) {
				adds_html += "<div style=\"margin: 10px 10px; border-left: thick dotted #207dc8; padding-left:5px;\">";
			}
			else {
				adds_html += "<div style=\"margin: 10px 10px;\">";
			}
			
			adds_html += "<span style=\"float:left\"><span class=\"g-blue\">By:</span> "+adds[i].Author+" <span class=\"g-blue\">in</span> "+adds[i].City+" </span><span style=\"float:left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span style=\"float:left\"> <span class=\"g-blue\">Date:</span> "+adds[i].Date.substring(0,10)+" </span><br style=\"clear:both\"/> <br style=\"line-height:5px;\"/><span><span class=\"g-blue\">Title:</span> "+adds[i].Title+" </span><br/><br style=\"line-height:5px;\"/><span><span class=\"g-blue\">Text: </span> "+adds[i].Text+" </span><br/><br/><span><span class=\"g-blue\">Target Price:</span> "+adds[i].Price;
			}
		}
		adds_html += "<li class=\"g-bigemptyspace\"></li>";
		$('.g-adds-data').html(adds_html);
		
		// Re-read categories for the header
		var categories = localStorage.getItem("categories");
		categories = JSON.parse(categories);
		$('.g-adds-data-header').html("&#187; "+categories[categoryID-1].Name);
		EnableClickOnAdd(categoryID);
	}
	else {
		alert ('Your browser does not support Local Storage. This application will not work properly.');
	}
}

function FormComments(addID, categoryID) {
	var bookmarked = localStorage.getItem("bookmarked");
	bookmarked = JSON.parse(bookmarked);
	starred=0;
	for (j=0; j<bookmarked.length; j++) {
		if (addID==bookmarked[j].AddID) {
		starred=1; break;
		}
	}
	
	//alert ("CategoryID:"+categoryID+"|AddID:"+addID+"|");
	addID--;
	// Re-read categories for the header
	var categories = localStorage.getItem("categories");
	categories = JSON.parse(categories);
	$('.g-comments-header').html("&#187; "+categories[categoryID-1].Name);

	// Re-fetch the add for displaying
	var adds = localStorage.getItem("adds");
	adds = JSON.parse(adds);
	var add_html = "", empty_string = "";
	
	var thisAdd;
	for (i=0; i<adds.length; i++) {
		if (adds[i].ID == addID+1) {thisAdd = adds[i]; break;}
	}
	if (!thisAdd) alert ('Bad news: addID is dead.');
	
	
	if ( (empty_string + thisAdd.Price) == "null") {thisAdd.Price = "Na upit</span></div></li>";}
	else { thisAdd.Price += "<span class=\"g-blue\">&#128;</span></span></div></li>"; }
	
	add_html += "<li class=\"g-adds\" data-addid=\""+thisAdd.ID+"\">";
	
	if (starred==1) {
		add_html += "<div id=\"g-thisAdd\" style=\"margin: 10px 10px; border-left: thick dotted #207dc8; padding-left:5px;\">";
	}
	else {
		add_html += "<div id=\"g-thisAdd\" style=\"margin: 10px 10px;\">";
	}
	
	add_html += "<span style=\"float:left\"><span class=\"g-blue\">By:</span> "+thisAdd.Author+" <span class=\"g-blue\">in</span> "+thisAdd.City+" </span><span style=\"float:left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span style=\"float:left\"> <span class=\"g-blue\">Date:</span> "+thisAdd.Date.substring(0,10)+" </span><br style=\"clear:both\"/> <br style=\"line-height:5px;\"/><span><span class=\"g-blue\">Title:</span> "+thisAdd.Title+" </span><br/><br style=\"line-height:5px;\"/><span><span class=\"g-blue\">Text: </span> "+thisAdd.Text+" </span><br/><br/><span><span class=\"g-blue\">Target Price:</span> "+thisAdd.Price;
	
	$('.g-comments-data').html(add_html);
	
	//Finally, add the comments
	if (window.localStorage) {
		var comments = localStorage.getItem("comments");
		if (!comments) {
			FetchComments();
			if (!comments) {
				alert ('Error contacting server');
			}
		}
		comments = JSON.parse(comments);
		comments_html="";
		for (i=0; i<comments.length; i++) {
			//console.log("comments[i].AddID:"+comments[i].AddID+"|addID:"+addID+"|");
			if (parseInt(comments[i].AddID)-1 == parseInt(addID)) {
				if (parseInt(comments[i].ByAuthor) == 1) {
					comments_html += "<p class=\"bubble-left\"> <span class=\"g-blue\">"+comments[i].Author+" ("+ comments[i].CreatedOn+") :</span><br/> "+comments[i].Comment+"</p>";
				}
				else {
					comments_html += "<p class=\"bubble-right\"> <span class=\"g-blue\">"+comments[i].Author+" ("+ comments[i].CreatedOn+") :</span><br/> "+comments[i].Comment+"</p>";
				}
			}
		}
		comments_html += "<textarea class=\"g-comment-textarea\" type=\"text\" placeholder=\"Comment\" required id=\"g-newcomment-text\"></textarea><button type=\"button\" id=\"g-comment-btn\" class=\"g-comment-textarea button\" style=\"cursor: pointer;\" onclick=\"SubmitComment("+thisAdd.ID+")\"><b>Add Comment:</b></button><p class=\"g-bigemptyspace\"></p>";
		$('.g-comments-bubbles').html(comments_html);
		
		//Starred Button
		if (starred==0) {
			$('#g-toolbar #btn-bookmark').removeClass('bookmarked');
			$('#g-toolbar #btn-bookmark').addClass('bookmark');
			$('#g-toolbar #btn-bookmark').attr("onclick","BookmarkThis("+user.ID+","+parseInt(addID+1)+")");
		} else {
			$('#g-toolbar #btn-bookmark').removeClass('bookmark');
			$('#g-toolbar #btn-bookmark').addClass('bookmarked');
			$('#g-toolbar #btn-bookmark').attr("onclick","UnbookmarkThis("+user.ID+","+parseInt(addID+1)+")");
		}
		$('#g-toolbar #btn-bookmark').removeClass('g-display-none');
		
		//Delete Button
		if (thisAdd.AuthorID==user.ID) {
			$('#g-toolbar #btn-delete').removeClass('g-display-none');
			$('#g-toolbar #btn-delete').attr("onclick","DeleteAdd("+thisAdd.ID+")");
		}
		else {
			$('#g-toolbar #btn-delete').addClass('g-display-none');
			$('#g-toolbar #btn-delete').attr("onclick","");
		}
	}
	else {
		alert ('Your browser does not support Local Storage. This application will not work properly.');
	}
}

function FilterAdds () {
	var author = $('#g-filter-author').val();
	var city = $('#g-filter-city').val();
	var days = $('#g-filter-indays').val();
	var pricemin = $('#g-filter-pricemin').val();
	var pricemax = $('#g-filter-pricemax').val();
	if (!author && !city && !days && !pricemin && !pricemax) return;
	
	var categories;
	categories = localStorage.getItem("categories_full");	//if there was filtering before
	if (!categories) categories = localStorage.getItem("categories");
	
	var adds;
	adds = localStorage.getItem("adds_full");
	if (!adds) adds = localStorage.getItem("adds");
	
	var comments = localStorage.getItem("comments");
	
	var categories_full = JSON.parse(categories);
	localStorage.setItem ("categories_full", categories);
	categories=[];
	
	var adds_full = JSON.parse(adds);
	localStorage.setItem ("adds_full", adds);
	adds=[];
	
	for (i=0, j=0; i<adds_full.length ; i++) {
		if (author) { 
			if (adds_full[i].Author.toUpperCase() != author.toUpperCase())	continue;
		}
		
		if (city) {
			if (adds_full[i].City.toUpperCase() != city.toUpperCase()) continue;
		}
		
		if (days) {
			var date_today = new Date();
			var date_created = new Date(adds_full[i].Date.substring(0,10));
			if(getDateDiff(date_today, date_created) > days) continue;
		}
		
		if (pricemin) {
			var empty_string="";
			if ((empty_string + adds_full[i].Price) == "null") continue;
			if (parseInt(adds_full[i].Price) < parseInt(pricemin)) continue;
		}
		
		if (pricemax) {
			var empty_string="";
			if ((empty_string + adds_full[i].Price) == "null") continue;
			if (parseInt(adds_full[i].Price) > parseInt(pricemax)) continue;
		}
		
		adds[j] = adds_full[i]; j++;
	}
	
	for (var i=0, k=0; i<categories_full.length; i++) {
		for (var j=0; j<adds.length; j++)	{
			if (adds[j].CategoryID == categories_full[i].ID) {
				categories[k++]=categories_full[i];
				break;
			}
		}
	}
	
	adds=JSON.stringify(adds);
	localStorage.setItem("adds",adds);
	categories=JSON.stringify(categories);
	localStorage.setItem("categories", categories);
	
	FormCategories();
	FormCategoryLinks();
	ShowMainMenu();
	$('.g-toolbar-note').removeClass('g-display-none');
	filtered=1;
	localStorage.setItem("filtered",filtered);
}

getDateDiff = function(date1, date2) {
    return Math.floor((date1.getTime() - date2.getTime()) / (1000 * 60 * 60 * 24));
}

$(document).ready(function() {	
	$('#g-toolbar-alladds').click(function(){	// When All Adds in Toolbar is clicked
		var categories;
		categories = localStorage.getItem("categories_full");	//if there was filtering before
		if (categories) localStorage.setItem("categories", categories);
		
		var adds;
		adds = localStorage.getItem("adds_full");
		if (adds) localStorage.setItem("adds",adds);
		
		FormCategories();
		FormCategoryLinks();
		ShowMainMenu();
		
		$('#g-toolbar').removeClass('g-display-none');
		$('.g-toolbar-note').addClass('g-display-none');
		filtered=0;
		localStorage.setItem("filtered",filtered);
	});	
});

var CreateUser = function() {
var user = $('#g-register-user').val();
var pass = $('#g-register-pass').val();
var again = $('#g-register-again').val();
var message = "";
var error = 0;
var created = 0;
	
if (pass != again) {
	message = "Passwords do not match."
	error = 1;
}
	
$('#g-usercreate').addClass ('fade-in');
	
if (error == 0) {
//Display the "Please Wait" Dialog.
$('#g-usercreate>form>menu').html('');
$('#g-usercreate>form>section>p').html('<progress></progress>');
	
	//Get the response from the server, remove this on prod
	var createUserRequest = $.jsonp({
	"url": "http://www.ennoble-studios.com/classifieds/dbCreateUser.php?callback=?&username="+user+"&pass="+CryptoJS.MD5(pass),
    "success": function(data,message,error,created) {
        message=JSON.parse(data);  
		if (message=="" || message.substring(0,5)=="Faile") 
			{ message = "Could not contact server." } 
			//if message has not been changed or error has been sent.
		if (message == "Username available.<br/>User Created Successfully.") {	created = 1;}
		$('#g-usercreate>form>menu').html('<button type=\"button\" style="cursor: pointer;"> Understood </button>');
		$('#g-usercreate>form>menu>button').click(function() {
			$('#g-usercreate').removeClass ('fade-in');
			$('#g-usercreate').addClass('fade-out');
			$('#g-usercreate').removeClass ('fade-out');
			if (created==1) {
				window.location.href = './login.html#filter1';
				LoginLogin();
			}
		});
		$('#g-usercreate>form>section>p').html(message);
	},
    "error": function(data,message,error,created) {
		$('#g-usercreate>form>menu').html('<button type="button" style="cursor: pointer;"> Understood </button>');
		$('#g-usercreate>form>menu>button').click(function() {
			$('#g-usercreate').removeClass ('fade-in');
			$('#g-usercreate').addClass('fade-out');
			$('#g-usercreate').removeClass ('fade-out');
			if (created==1) {
				window.location.href = './login.html#filter1';
				LoginLogin();
			}
		});
		$('#g-usercreate>form>section>p').html(message);
    }
    });
}
else {
	$('#g-usercreate>form>menu').html('<button type="button" style="cursor: pointer;"> Understood </button>');
	$('#g-usercreate>form>menu>button').click(function() {
		$('#g-usercreate').removeClass ('fade-in');
		$('#g-usercreate').addClass('fade-out');
		$('#g-usercreate').removeClass ('fade-out');
	});
	$('#g-usercreate>form>section>p').html(message);
}
}


var LoginUser = function() {
	var user = $('#g-login-user').val();
	var pass = $('#g-login-pass').val();
	var message = "";
	var verified = 0;
		
	$('#g-userlogin').addClass ('fade-in');
	$('#g-usercreate>form>menu').html('');
	$('#g-usercreate>form>section>p').html('<progress></progress>');
	
	var createUserRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbUserLogin.php?callback=?&username="+user+"&pass="+pass,
      "success": function(data) {
          message=JSON.parse(data);
			if (!message || message=="") {
				message = "Could Not Verify Credentials."
				verified = 0;
			}
			else {
				//localStorage stuff with Message
				var visitordata = {};
				visitordata['ID']=message;
				visitordata['Username']=user;
				visitordata['Pass']= ""+CryptoJS.MD5(pass);
				localStorage.setItem ("user", JSON.stringify(visitordata));
				verified=1;
				window.user=visitordata;
				message="User Verified Successfully."
			}
		$('#g-userlogin>form>section>p').html(message);
		$('#g-userlogin>form>menu').html('<button type="button" style="cursor: pointer;"> Understood </button>');
		$('#g-userlogin>form>menu>button').click(function() {
			$('#g-userlogin').removeClass ('fade-in');
			$('#g-userlogin').addClass('fade-out');
			$('#g-userlogin').removeClass ('fade-out');
			if (verified == 1) { window.location.href = './index.html';}
		    $('#g-userlogin>form>section>p').html('<progress></progress>');
		});
      },
      "error": function() {
		message="Error contacting server";
        console.log('NOT OK fetching data from UserLogin.');
		$('#g-userlogin>form>section>p').html(message);
		$('#g-userlogin>form>menu').html('<button type="button" style="cursor: pointer;"> Understood </button>');
		$('#g-userlogin>form>menu>button').click(function() {
			$('#g-userlogin').removeClass ('fade-in');
			$('#g-userlogin').addClass('fade-out');
			$('#g-userlogin').removeClass ('fade-out');
		});
      }
    });
}

function MyCreatedAdds () {
	if (!user) {
		user = localStorage.getItem("user");
		user=JSON.parse(user);
	}
	
	var categories;
	categories = localStorage.getItem("categories_full");	//if there was filtering before
	if (!categories) {categories = localStorage.getItem("categories");}
	categories_full = JSON.parse(categories);
	categories=[];
	
	var adds;
	adds = localStorage.getItem("adds_full");
	if (!adds) {adds= localStorage.getItem("adds");}
	adds_full = JSON.parse(adds);
	adds=[];
	
	for (i=0, j=0; i<adds_full.length ; i++) {
		if (adds_full[i].AuthorID == user.ID) {
			adds[j++] = adds_full[i];
		}
	}

	for (var i=0, k=0; i<categories_full.length; i++) {
		for (var j=0; j<adds.length; j++)	{
			if (adds[j].CategoryID == categories_full[i].ID) {
				categories[k++]=categories_full[i];
				break;
			}
		}
	}	
	
	adds=JSON.stringify(adds);
	localStorage.setItem("adds",adds);
	categories=JSON.stringify(categories);
	localStorage.setItem("categories", categories);
		
	FormCategories();
	FormCategoryLinks();
	ShowMainMenu();
	
	$('#g-toolbar').removeClass('g-display-none');
	$('.g-toolbar-note').removeClass('g-display-none');
	filtered=1;
	localStorage.setItem("filtered",filtered);
}	
	
function MyRespondedAdds () {
	if (!user) {
		user = localStorage.getItem("user");
		user=JSON.parse(user);
	}
	
	var categories;
	categories = localStorage.getItem("categories_full");	//if there was filtering before
	if (!categories) {categories = localStorage.getItem("categories");}
	categories_full = JSON.parse(categories);
	categories=[];
	
	var adds;
	adds = localStorage.getItem("adds_full");
	if (!adds) {adds= localStorage.getItem("adds");}
	adds_full = JSON.parse(adds);
	adds=[];
	
	var comments;
	comments = localStorage.getItem ("comments");
	comments = JSON.parse(comments);
	var comm_ids = [];
	
	for (i=0, j=0; i<comments.length; i++) {
		if (comments[i].AuthorID == user.ID) {
			comm_ids[j++]=comments[i].AddID;
		}
	}

	for (var i=0, k=0; i<adds_full.length; i++) {
		for (var j=0; j<comm_ids.length; j++)	{
			if (adds_full[i].ID == comm_ids[j]) {
				adds[k++]=adds_full[i];
				break;
			}
		}
	}
	
	for (var i=0, k=0; i<categories_full.length; i++) {
		for (var j=0; j<adds.length; j++)	{
			if (adds[j].CategoryID == categories_full[i].ID) {
				categories[k++]=categories_full[i];
				break;
			}
		}
	}	
	
	adds=JSON.stringify(adds);
	localStorage.setItem("adds",adds);
	categories=JSON.stringify(categories);
	localStorage.setItem("categories", categories);
		
	FormCategories();
	FormCategoryLinks();
	ShowMainMenu();
	
	$('#g-toolbar').removeClass('g-display-none');
	$('.g-toolbar-note').removeClass('g-display-none');
	filtered=1;
	localStorage.setItem("filtered",filtered);
}

function MyBookmarkedAdds () {
	if (!user) {
		user = localStorage.getItem("user");
		user=JSON.parse(user);
	}
	
	var categories;
	categories = localStorage.getItem("categories_full");	//if there was filtering before
	if (!categories) {categories = localStorage.getItem("categories");}
	categories_full = JSON.parse(categories);
	categories=[];
	
	var adds;
	adds = localStorage.getItem("adds_full");
	if (!adds) {adds= localStorage.getItem("adds");}
	adds_full = JSON.parse(adds);
	adds=[];
	
	var bookmarked;
	bookmarked = localStorage.getItem ("bookmarked");
	bookmarked = JSON.parse(bookmarked);
		
	for (var i=0, k=0; i<adds_full.length; i++) {
		for (var j=0; j<bookmarked.length; j++)	{
			if (adds_full[i].ID == bookmarked[j].AddID) {
				adds[k++]=adds_full[i];
				break;
			}
		}
	}
	
	for (var i=0, k=0; i<categories_full.length; i++) {
		for (var j=0; j<adds.length; j++)	{
			if (adds[j].CategoryID == categories_full[i].ID) {
				categories[k++]=categories_full[i];
				break;
			}
		}
	}	
	
	adds=JSON.stringify(adds);
	localStorage.setItem("adds",adds);
	categories=JSON.stringify(categories);
	localStorage.setItem("categories", categories);
		
	FormCategories();
	FormCategoryLinks();
	ShowMainMenu();
	
	$('#g-toolbar').removeClass('g-display-none');
	$('.g-toolbar-note').removeClass('g-display-none');
	filtered=1;
	localStorage.setItem("filtered",filtered);
}

var BookmarkThis = function(userID,addID)	{
	InsertAndFetchBookmark(userID,addID,1);
}

var UnbookmarkThis = function(userID,addID)	{
	InsertAndFetchBookmark(userID,addID,0);
}

var DeleteAdd = function(ID) {
$('#g-deleteadd-confirm').unbind('click');
$('#g-deleteadd-cancel').unbind('click');
$('#g-deleteadd-confirm').unbind('click');
$('#g-deleteadd-cancel').unbind('click');
	var error=0;
	$('#g-deleteadd').removeClass('g-display-none');
	$('.g-selectedadd').addClass('g-display-none');
	$('#g-toolbar').addClass('g-display-none');
	
	$('#g-deleteadd-cancel').click(function(){
		$('.g-selectedadd').removeClass('g-display-none');
		$('#g-deleteadd').addClass('g-display-none');
		$('#g-toolbar').removeClass('g-display-none');
	});
	
$('#g-deleteadd-confirm').click(function(){
	error=0;
	$('#g-toolbar').removeClass('g-display-none');
	$('.g-selectedadd').removeClass('g-display-none');
	$('#g-deleteadd').addClass('g-display-none');
	
	//Display the "Please Wait" Dialog. Required for Sync Conn
	$('#g-fetchingdata').addClass('fade-in');
	$('#g-toolbar').addClass('g-display-none');
	
	var SetError=function(e) { error=e; }
	var SetComplete=function() {
		After(error);
	}
	
	var deleteRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbDeleteAdd.php?callback=?&username="+user.Username+"&pass="+user.Pass+"&addid="+ID ,
      "success": function(data) {
        try {
			var isOK=JSON.parse(data);
			if (isOK!='1') SetError(1);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from dbDeleteAdd.');
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from dbDeleteAdd.');
		  SetError(1);
      },
	  "complete": function() { SetComplete();  }
    });
	
	var After=function(error) {
		if (error == 1) { 
			$('#g-errorconnect').addClass('fade-in');
			
			$('#g-errorconnect>form>menu>button').click(function() {
				$('#g-errorconnect').removeClass ('fade-in');
				$('#g-errorconnect').addClass('fade-out');
				$('#g-errorconnect').removeClass ('fade-out');
			});
		}
		
		$('#g-fetchcomments-cancel').click(function(){
			if (deleteRequest) {
				deleteRequest.abort();
			}
			
			$('#g-fetchingdata').removeClass ('fade-in');
			$('#g-fetchingdata').addClass('fade-out');
			$('#g-fetchingdata').removeClass ('fade-out');
			$('#g-toolbar').removeClass('g-display-none');
		}) 
		
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
		
		FetchData();
		$('.g-back').trigger('click');
	}
});
}

var NewAdd = function()	{
	var categories;
	var error = 0, message = "";
	categories = localStorage.getItem("categories_full");	//if there was filtering before
	if (!categories) categories = localStorage.getItem("categories");
	categories=JSON.parse(categories);
		
	var categoryName;
	for (i=0; i<categories.length; i++) {
		if (parseInt(categories[i].ID) == parseInt(categoryID)) {
			categoryName = categories[i].Name;
		}
	}
	
	var today = new Date();
	var dd = today.getDate();
	var mm = today.getMonth()+1; //January is 0!
	var yyyy = today.getFullYear();
	if(dd<10){dd='0'+dd} if(mm<10){mm='0'+mm} today = dd+'.'+mm+'.'+yyyy;
	
	$('#g-newadd>article>header').html("<h2>Creating in Category: "+categoryName+"</h2> <h2>Author: "+user.Username+"<br/><br/>Date: "+today+"</h2>");
	
	$('#g-newadd-create').click(function() {	// Clicked Create Button!
	error = 0; message = "";
	$(this).attr('id','');
	var city = $('#g-newadd-city').val();
	var title = $('#g-newadd-title').val();
	var text = $('#g-newadd-text').val();
	var price = $('#g-newadd-price').val();
	if (city == "" || title == "" || text == "") error=1;
	if (price == "") price='null';
	if (city == "") message+="City can not be empty. ";
	if (title == "") message+="Title can not be empty. ";
	if (text == "") message+="Add text can not be empty. ";
		
	$('#g-addcreate').addClass ('fade-in');
	
	if (error == 0) {
	//Display the "Please Wait" Dialog.
	$('#g-addcreate>form>menu').html('');
	$('#g-addcreate>form>section>p').html('<progress></progress>');
	
	var SetError=function(e) { error=e; }
	var SetComplete=function() {
		After(error);
	}
	
	//Get the response from the server, remove this on prod
	var createAddRequest = $.jsonp({
	  "url": "http://www.ennoble-studios.com/classifieds/dbInsertAdd.php?callback=?&username="+user.Username+"&pass="+user.Pass+"&categoryid="+categoryID+"&city="+city+"&title="+title+"&text="+text+"&price="+price,
      "success": function(data) {
        try {
			var isOK=JSON.parse(data);
			if (isOK!='1') SetError(1);
		}
		catch (e) {
			data="";
			SetError(1);
			console.log('Error parsing result from dbInsertAdd.');
		}
      },
      "error": function() {
          console.log('NOT OK fetching data from dbInsertAdd.');
		  SetError(1);
      },
	  "complete": function() { SetComplete();  }
    });
	
		var After=function(error) {
			if (error==0) {	message+="Add created successfully.";  }
			else { message+="Error creating add."; }
			Afterall(error);
		}
	}
	else {
		message+="Error creating add.";
		$('#g-addcreate>form>menu').html('<a class="button" style="cursor: pointer;"> Understood </a>');
		$('#g-addcreate>form>section>p').html(message);
		$('#g-addcreate>form>menu>a').unbind();
		$('#g-addcreate>form>menu>a').click(function() {
			$('#g-addcreate').removeClass ('fade-in');
			$('#g-addcreate').addClass('fade-out');
			$('#g-addcreate').removeClass ('fade-out');
		});
	}
	
	var Afterall=function(error) {
		$('#g-addcreate>form>menu').html('<a class="button" style="cursor: pointer;"> Understood </a>');
		$('#g-addcreate>form>section>p').html(message);
		$('#g-addcreate>form>menu>a').unbind();
		$('#g-addcreate>form>menu>a').click(function() {
			$('#g-addcreate').removeClass ('fade-in');
			$('#g-addcreate').addClass('fade-out');
			$('#g-addcreate').removeClass ('fade-out');
			if (error==0) {
				FetchData();
			}
		});
	}
	});
}

var SubmitComment = function(addID)	{
	var error=0;
	var comment = $.trim($('#g-newcomment-text').val());
	if (comment == "") return;

	$('#g-fetchingdata').addClass('fade-in');
	$('#g-toolbar').addClass('g-display-none');
	
	var SetError=function(e) { error=e; }
	var SetComplete=function() {
		After(error);
	}
	
	var commentsRequest = $.jsonp({
		"url": "http://www.ennoble-studios.com/classifieds/dbInsertComment.php?callback=?&username="+user.Username+"&pass="+user.Pass+"&addid="+addID+"&comment="+comment ,
        "success": function(data) {
			try {
				var isOK=JSON.parse(data);
				if (isOK!='1') SetError(1);
			}
			catch (e) {
				data="";
				SetError(1);
				console.log('Error parsing result from dbInsertComment.');
			}
		  },
		"error": function() {
			  console.log('NOT OK fetching data from dbInsertComment.');
			  SetError(1);
		  },
		"complete": function() { SetComplete();  }
	});
	
	var After=function(error) {
		if (error == 1) { 
			$('#g-errorconnect').addClass('fade-in');
			
			$('#g-errorconnect>form>menu>button').click(function() {
				$('#g-errorconnect').removeClass ('fade-in');
				$('#g-errorconnect').addClass('fade-out');
				$('#g-errorconnect').removeClass ('fade-out');
			});
		}
		
		$('#g-fetchcomments-cancel').click(function(){	
			if (commentsRequest) {
				commentsRequest.abort();
			}
			
			$('#g-fetchingdata').removeClass ('fade-in');
			$('#g-fetchingdata').addClass('fade-out');
			$('#g-fetchingdata').removeClass ('fade-out');
			$('#g-toolbar').removeClass('g-display-none');
		}) 
		
		$('#g-fetchingdata').removeClass ('fade-in');
		$('#g-fetchingdata').addClass('fade-out');
		$('#g-fetchingdata').removeClass ('fade-out');
		$('#g-toolbar').removeClass('g-display-none');
		
		FetchData();
	}
}
