var db;
var semestres = null;
var cursos = null;
var semestre = -1;
var curso = -1;
var tag_semestres = document.getElementById('semestres');
var tag_cursos = document.getElementById('cursos');
var nombreCurso = document.getElementById('nombreCurso');
var descripcionCurso = document.getElementById('descripcionCurso');
var tag_apuntes = document.getElementById('apuntes');
var tag_curso = document.getElementById('curso');
var tag_index = document.getElementById('index');
var tag_semestre = document.getElementById('semestre');
var nombreSemestre = document.getElementById('nombreSemestre');
var descripcionSemestre = document.getElementById('descripcionSemestre');
var tag_nsemestre = document.getElementById('nsemestre');
var tag_ncurso = document.getElementById('ncurso');
var tag_napunte = document.getElementById('napunte');
var nsemestreForm = document.getElementById('nsemestreForm');
var ncursoForm = document.getElementById('ncursoForm');
var napunteForm = document.getElementById('napunteForm');
napunteForm.imageData = null;
function initDb(){
	request = indexedDB.open("ClassN",1);
	request.onerror= function(){
		console.error(this.error);
	};
	request.onupgradeneeded = function(){
		db = this.result;
		if(!db.objectStoreNames.contains("semestres")){
			//creando la tabla de semestres
			objectStore = db.createObjectStore('semestres',{keyPath:'id',autoIncrement:true});
			objectStore.createIndex('nombre','nombre',{unique:false});
			objectStore.createIndex('descripcion','descripcion',{unique:false});
		}
		if(!db.objectStoreNames.contains("cursos")){
			//creando la tabla de cursos
			obj = db.createObjectStore('cursos',{keyPath:'id',autoIncrement:true});
			obj.createIndex('nombre','nombre',{unique:false});
			obj.createIndex('descripcion','descripcion',{unique:false});
			obj.createIndex('semestre','semestre',{unique:false});
		}
		if(!db.objectStoreNames.contains("apuntes")){
			//crenado la tala de apuntes
			obj = db.createObjectStore('apuntes',{keyPath:'id',autoIncrement:true});
			obj.createIndex('apunte','apunte',{unique:false});
			obj.createIndex('image','image',{unique:false});
			obj.createIndex('curso','curso',{unique:false});
		}
	};
	request.onsuccess = function(){
		db = this.result;
		tag_semestres.innerHTML = '';
		obj = db.transaction('semestres').objectStore('semestres');
		req = obj.openCursor();
		semestres = []; 
		req.onsuccess = function(){
			cursor = this.result;
			if(cursor){
				semestres.push(cursor.value);
			    tag_a = document.createElement('a');
			    tag_a.href = '#';
			    tag_a.semestre = cursor.value.id;
			    tag_p = document.createElement('p');
			    tag_p.innerHTML = cursor.value.nombre;
			    tag_a.appendChild(tag_p);
			    tag_p = document.createElement('p');
			    tag_p.innerHTML = cursor.value.descripcion;
			    tag_a.appendChild(tag_p);
			    tag_a.addEventListener('click',semestre_click);
			    tag_li = document.createElement('li');
			    tag_li.appendChild(tag_a);
			    tag_semestres.appendChild(tag_li);
				cursor.continue();
			}
		};
		req.onerror = function(){
			console.error(this.error);
		};

	};
};
function nuevoSemestre(nombre,descripcion){
	if(db){
		obj = db.transaction('semestres','readwrite').objectStore('semestres');
		req = obj.add({'nombre':nombre,'descripcion':descripcion});
		req.onsuccess = function(){
			semestres.push({'id':this.result,'nombre':nombre,'descripcion':descripcion});
			tag_a = document.createElement('a');
	    	tag_a.href = '#';
	    	tag_a.semestre = this.result;
	    	tag_p = document.createElement('p');
	    	tag_p.innerHTML = nombre;
	    	tag_a.appendChild(tag_p);
	    	tag_p = document.createElement('p');
	    	tag_p.innerHTML = descripcion;
	    	tag_a.appendChild(tag_p);
	    	tag_a.addEventListener('click',semestre_click);
	    	tag_li = document.createElement('li');
	    	tag_li.appendChild(tag_a);
	    	tag_semestres.appendChild(tag_li);
		};
		req.onerror = function(){
			console.error(this.error);
		};
	}
};
function nuevoCurso(nombre,descripcion){
	if(db){
		obj = db.transaction('cursos','readwrite').objectStore('cursos');
		req = obj.add({'nombre':nombre,'descripcion':descripcion,'semestre':semestre});
		req.onsuccess = function(){
			cursos.push({'id':this.result,'nombre':nombre,'descripcion':descripcion});
			tag_a = document.createElement('a');
	    	tag_a.href = '#';
	    	tag_a.curso = this.result;
	    	tag_p = document.createElement('p');
	    	tag_p.innerHTML = nombre;
	    	tag_a.appendChild(tag_p);
	    	tag_p = document.createElement('p');
	    	tag_p.innerHTML = descripcion;
	    	tag_a.appendChild(tag_p);
	    	tag_a.addEventListener('click',curso_click);
	    	tag_li = document.createElement('li');
	    	tag_li.appendChild(tag_a);
	    	tag_cursos.appendChild(tag_li);
		};
		req.onerror = function(){
			console.error(this.error);
		};
	}
};
function setCursos(){
	if(db){
		obj = db.transaction('cursos').objectStore('cursos');
		req = obj.openCursor();
		cursos = [];
		req.onsuccess = function(){
			cursor = this.result;
			if(cursor){
				if (cursor.value.semestre == semestre){
					cursos.push(cursor.value);
					tag_a = document.createElement('a');
			    	tag_a.href = '#';
			    	tag_a.curso = cursor.value.id;
			    	tag_p = document.createElement('p');
			    	tag_p.innerHTML = cursor.value.nombre;
			    	tag_a.appendChild(tag_p);
			    	tag_p = document.createElement('p');
			    	tag_p.innerHTML = cursor.value.descripcion;
			    	tag_a.appendChild(tag_p);
			    	tag_a.addEventListener('click',curso_click);
			    	tag_li = document.createElement('li');
			    	tag_li.appendChild(tag_a);
			    	tag_cursos.appendChild(tag_li);
				}
				cursor.continue();
			}
		};
		req.onerror = function(){
			console.error(this.error);
		};
	}
};
function nuevoApunte(apunte){
	if(db){
		obj = db.transaction('apuntes','readwrite').objectStore('apuntes');
		req = obj.add({'apunte':apunte,'image':napunteForm.imageData,'curso':curso});
		req.onsuccess = function(){
			tag_li = document.createElement('li');
			tag_div = document.createElement('div');
			tag_div.className = 'area';
			tag_p = document.createElement('p');
			tag_p.innerHTML = apunte;
			tag_div.appendChild(tag_p);
			if(napunteForm.imageData != null){
				tag_img = document.createElement('img');
				tag_img.className = 'imgResponsive';
				tag_img.src = window.URL.createObjectURL(napunteForm.imageData);
				tag_div.appendChild(tag_img);
			}
			tag_li.appendChild(tag_div);
			tag_apuntes.appendChild(tag_li);
		};
		req.onerror = function(){
			console.error(this.error);
		};
	}
};
function setApuntes(){
	if(db){
		obj = db.transaction('apuntes').objectStore('apuntes');
		req = obj.openCursor();
		req.onsuccess = function(){
			cursor = this.result;
			if(cursor){
				if (cursor.value.curso == curso){
					console.info(cursor.value);
					tag_div = document.createElement('div');
					tag_div.className = 'area';
			    	tag_p = document.createElement('p');
			    	tag_p.innerHTML = cursor.value.apunte;
			    	tag_div.appendChild(tag_p);
			    	if(cursor.value.image != null){
			    		tag_img = document.createElement('img');
			    		tag_img.src = window.URL.createObjectURL(cursor.value.image);
			    		tag_img.className = 'imgResponsive';
			    		tag_div.appendChild(tag_img);
			    	}
			    	tag_apuntes.appendChild(tag_div);
				}
				cursor.continue();
			}
		};
		req.onerror = function(){
			console.error(this.error);
		};
	}
};
/*fast click*/
window.addEventListener('load', function() {
    FastClick.attach(document.body);
    initDb();
}, false);
/*index*/
function semestre_click(){
	tag_cursos.innerHTML = '';
	semestre = this.semestre;
	nombre = '';
	descripcion = '';
	semestres.forEach(function(val,index){
		if(val.id === semestre){
			nombre = val.nombre;
			descripcion = val.descripcion;
		}
	});
	setCursos();
	nombreSemestre.innerHTML = nombre;
	descripcionSemestre.innerHTML = descripcion;
	tag_semestre.className = 'current';
	tag_index.className = 'left';
};
document.getElementById('btn-action-nsemestre').addEventListener('click',function(){
	tag_nsemestre.className = 'current';
	tag_index.className = 'left';
});
/*semestre*/
document.getElementById('btn-semestre-atras').addEventListener('click', function(){
	tag_semestre.className = 'right';
	tag_index.className = 'current';
});
function curso_click(){
	tag_apuntes.innerHTML = '';
	curso = this.curso;
	nombre = '';
	descripcion = '';
	cursos.forEach(function(val,index){
		if(val.id == curso){
			nombre = val.nombre;
			descripcion = val.descripcion;
		}
	});
	setApuntes();
	nombreCurso.innerHTML = nombre;
	descripcionCurso.innerHTML = descripcion;
	tag_curso.className = 'current';
	tag_semestre.className = 'right';
};
document.getElementById('btn-action-ncurso').addEventListener('click',function(){
	tag_semestre.className = "right";
	tag_ncurso.className = "current";
});
/*nuevo semestre*/
document.getElementById('btn-nsemestre-cancel').addEventListener('click',function(){
	nsemestreForm.reset();
	tag_nsemestre.className = 'right';
	tag_index.className = 'current';
});
document.getElementById('btn-nsemestre-crear').addEventListener('click',function(){
	if(nsemestreForm.checkValidity()){
		nuevoSemestre(nsemestreForm[0].value,nsemestreForm[2].value);
    	nsemestreForm.reset();
    	tag_nsemestre.className = 'right';
		tag_index.className = 'current';
	}else{
		console.warn('formulario invalido');
	}
});
/*curso*/
document.getElementById('btn-curso-atras').addEventListener('click',function(){
	tag_semestre.className = 'current';
	tag_curso.className = 'left';
});
/*nuevo curso*/
document.getElementById('btn-ncurso-cancel').addEventListener('click',function(){
	ncursoForm.reset();
	tag_semestre.className = 'current';
	tag_ncurso.className = 'left';
});
document.getElementById('btn-ncurso-crear').addEventListener('click',function(){	
	if(ncursoForm.checkValidity()){
		nuevoCurso(ncursoForm[0].value,ncursoForm[2].value);
    	ncursoForm.reset();
    	tag_semestre.className = 'current';
		tag_ncurso.className = 'left';
	}else{
		console.warn('formulario invalido');
	}
});
/*nueva nota de texto*/
document.getElementById('btn-action-napunte').addEventListener('click',function(){
	tag_curso.className = 'left';
	tag_napunte.className = "current";
});
document.getElementById('btn-napunte-crear').addEventListener('click',function(){
	if(napunteForm.checkValidity()){
		nuevoApunte(napunteForm[0].value);
		napunteForm.reset();
		tag_curso.className = 'current';
		tag_napunte.className = "right";
	}else{
		console.warn('formulario no aceptado');
	}
});
document.getElementById('btn-napunte-cancel').addEventListener('click',function(){
	napunteForm.reset();
	tag_curso.className = 'current';
	tag_napunte.className = "right";
});
document.getElementById('btn-napunte-img').addEventListener('click',function(){
	var getImg = new MozActivity({
		name:"record",
		data:{
			type: ['photos']
		}/*
		name: "pick",
		data: {
		  type: "image/jpeg"
		}*/
	});
	getImg.onsuccess= function(){
		if(this.result){
			if (this.result.blob) {
			napunteForm.imageData = this.result.blob;
			}else{
				napunteForm.imageData = null;
			}
		}else{
			console.log('resultado nulo');
		}
	};
	getImg.onerror = function () {
		// error!
		console.error(this.error);
		napunteForm.imageData = null;
	};
});
