// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  Web Components
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  document.webL10n.ready(function() {
    var equalizer_presets, sound_processing;
    sound_processing = cs.sound_processing;
    equalizer_presets = document.querySelector('cs-music-equalizer-presets');
    return Polymer('cs-music-equalizer', {
      gain_levels: sound_processing.get_gain_levels(),
      ready: function() {
        var gain_levels;
        gain_levels = this.gain_levels;
        return $(this.shadowRoot.querySelectorAll('input[type=range]')).ranger({
          vertical: true,
          label: false,
          min: -10,
          max: 10,
          step: .01,
          callback: function(val) {
            gain_levels[$(this).prev().data('index')] = Math.round(val * 100) / 100;
            return sound_processing.set_gain_levels(gain_levels);
          }
        });
      },
      update: function(gain_levels) {
        this.gain_levels = gain_levels;
        sound_processing.set_gain_levels(gain_levels);
        return setTimeout(((function(_this) {
          return function() {
            return $(_this.shadowRoot.querySelectorAll('input[type=range]')).ranger('reset');
          };
        })(this)), 100);
      },
      equalizer_presets: function() {
        return this.go_to_screen('equalizer-presets');
      },
      back: function() {
        return this.go_back_screen();
      }
    });
  });

}).call(this);
