// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  Web Components
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  document.webL10n.ready(function() {
    var music_playlist, player;
    music_playlist = cs.music_playlist;
    player = document.querySelector('cs-music-player');
    return Polymer('cs-music-library-rescan', {
      searching_for_music_text: _('searching-for-music'),
      files_found_text: _('files-found'),
      found: 0,
      created: function() {
        return cs.bus.on('library/rescan/found', (function(_this) {
          return function(found) {
            return _this.found = found;
          };
        })(this));
      },
      showChanged: function() {
        if (!this.found && this.show) {
          return this.rescan();
        }
      },
      rescan: function() {
        return cs.music_library.rescan((function(_this) {
          return function() {
            music_playlist.clear().refresh();
            alert(_('library-rescanned-playlist-updated'));
            $(player).one('animationend', function() {
              return player.next((function() {}), true);
            });
            _this.go_to_screen('player');
            return cs.bus.fire('library/rescan/found', 0);
          };
        })(this));
      },
      back: function() {
        return this.go_back_screen();
      }
    });
  });

}).call(this);
