// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  app
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  cs.bus = (function() {
    var subscribers;
    subscribers = {};
    return {
      state: {},
      'on': function(event_name, callback) {
        if (!subscribers[event_name]) {
          subscribers[event_name] = [];
        }
        subscribers[event_name].push(callback);
        return cs.bus;
      },
      once: function(event_name, callback) {
        var callback_;
        callback_ = (function(_this) {
          return function() {
            callback();
            return _this.off(callback_);
          };
        })(this);
        return this.on(event_name, callback_);
      },
      'off': function(event_name, callback) {
        if (!subscribers[event_name]) {
          return cs.bus;
        }
        subscribers[event_name].forEach(function(func, index) {
          if (func === callback) {
            delete subscribers[event_name][index];
            return false;
          }
        });
        return cs.bus;
      },
      fire: function(event_name, data) {
        if (subscribers[event_name]) {
          return subscribers[event_name].forEach(function(callback) {
            return requestAnimationFrame(function() {
              return callback(data);
            });
          });
        }
      }
    };
  })();

}).call(this);
