// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  app
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  var db, on_db_ready, onready, wrap;

  if (!window.indexedDB) {
    alert("Indexed DB is not supported O_o");
    return;
  }

  db = null;

  on_db_ready = [];

  (function() {
    var request;
    request = indexedDB.open('music_db', 2);
    request.onsuccess = function() {
      var callback;
      db = request.result;
      while (callback = on_db_ready.shift()) {
        callback();
      }
    };
    request.onerror = function(e) {
      console.error(e);
    };
    return request.onupgradeneeded = function() {
      var meta_store, music_store;
      db = request.result;
      if (db.objectStoreNames.contains('music')) {
        db.deleteObjectStore('music');
      }
      music_store = db.createObjectStore('music', {
        keyPath: 'id',
        autoIncrement: true
      });
      music_store.createIndex('name', 'name', {
        unique: true
      });
      meta_store = db.createObjectStore('meta', {
        keyPath: 'id'
      });
      meta_store.createIndex('title', 'title');
      meta_store.createIndex('artist', 'artist');
      meta_store.createIndex('album', 'album');
      meta_store.createIndex('genre', 'genre');
      meta_store.createIndex('year', 'year');
      db.transaction.oncomplete = function() {
        var callback, results;
        results = [];
        while (callback = on_db_ready.shift()) {
          results.push(callback());
        }
        return results;
      };
    };
  })();

  onready = function(callback) {
    callback = callback.bind(this);
    if (db) {
      callback();
    } else {
      on_db_ready.push(callback);
    }
  };

  wrap = function(request_callback) {
    return function(success_callback, error_callback) {
      return onready(function() {
        var request;
        request = request_callback();
        if (success_callback) {
          request.onsuccess = function() {
            return success_callback(this.result);
          };
        }
        if (error_callback) {
          return request.onerror = error_callback;
        }
      });
    };
  };

  cs.db = {
    read: function(store_name, value, field) {
      return wrap(function() {
        var store_object;
        store_object = db.transaction([store_name]).objectStore(store_name);
        if (field) {
          store_object = store_object.index(field);
        }
        return store_object.get(value);
      });
    },
    read_all: function(store_name, callback, filter) {
      return onready(function() {
        var all, cursor;
        all = [];
        cursor = db.transaction([store_name]).objectStore(store_name).openCursor();
        cursor.onsuccess = function() {
          var result;
          result = this.result;
          if (result) {
            if (!filter || filter(result.value)) {
              all.push(result.value);
            }
            return result["continue"]();
          } else {
            return callback(all);
          }
        };
        return cursor.onerror = function() {
          return callback(all);
        };
      });
    },
    count: function(store_name, callback, filter) {
      return onready(function() {
        var count, cursor;
        count = 0;
        cursor = db.transaction([store_name]).objectStore(store_name).openCursor();
        cursor.onsuccess = function() {
          var result;
          result = this.result;
          if (result) {
            if (!filter || filter(result.value)) {
              ++count;
            }
            return result["continue"]();
          } else {
            return callback(count);
          }
        };
        return cursor.onerror = function() {
          return callback(count);
        };
      });
    },
    insert: function(store_name, data) {
      return wrap(function() {
        return db.transaction([store_name], 'readwrite').objectStore(store_name).put(data);
      });
    },
    'delete': function(store_name, id) {
      return wrap(function() {
        return db.transaction([store_name], 'readwrite').objectStore(store_name)["delete"](id);
      });
    }
  };

}).call(this);
