// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  app
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  var music_library;

  music_library = cs.music_library;

  cs.music_playlist = {
    get_all: function(callback) {
      var playlist;
      callback = (callback || function() {}).bind(this);
      playlist = localStorage.playlist;
      if (playlist) {
        playlist = JSON.parse(playlist);
        if (playlist != null ? playlist.length : void 0) {
          callback(playlist);
          return;
        }
      }
      return this.refresh(function() {
        return this.get_all(callback);
      });
    },
    current: function(callback) {
      var playlist, position;
      callback = (callback || function() {}).bind(this);
      playlist = localStorage.playlist;
      if (playlist) {
        playlist = JSON.parse(playlist);
        if (playlist != null ? playlist.length : void 0) {
          position = localStorage.position || 0;
          if (position < playlist.length) {
            localStorage.position = position;
            callback(playlist[position]);
            return;
          }
        }
      }
      this.refresh(function() {
        return this.next(callback);
      });
    },
    set_current: function(position) {
      return localStorage.position = position;
    },
    set_current_id: function(id) {
      return this.get_all(function(all) {
        return localStorage.position = all.indexOf(id);
      });
    },
    prev: function(callback) {
      var playlist, position;
      callback = (callback || function() {}).bind(this);
      playlist = localStorage.playlist;
      if (playlist) {
        playlist = JSON.parse(playlist);
        if (playlist != null ? playlist.length : void 0) {
          position = localStorage.position || -1;
          if (position > 0) {
            --position;
          } else {
            position = 0;
          }
          localStorage.position = position;
          callback(playlist[position]);
        }
      }
    },
    next: function(callback) {
      var playlist, position;
      callback = (callback || function() {}).bind(this);
      playlist = localStorage.playlist;
      if (playlist) {
        playlist = JSON.parse(playlist);
        if (playlist != null ? playlist.length : void 0) {
          position = localStorage.position || -1;
          if (position < (playlist.length - 1)) {
            ++position;
            localStorage.position = position;
            callback(playlist[position]);
            return;
          } else if (cs.music_settings.repeat === 'none') {
            return;
          }
        }
      }
      this.refresh(function() {
        return this.next(callback);
      });
    },
    set: function(all, callback) {
      return this.sort(all, (function(_this) {
        return function(sorted) {
          localStorage.original_playlist = JSON.stringify(sorted);
          delete localStorage.playlist;
          return _this.refresh(callback);
        };
      })(this));
    },
    append: function(new_items, callback) {
      var original_playlist, playlist, save_playlist;
      original_playlist = JSON.parse(localStorage.original_playlist);
      original_playlist = original_playlist.concat(new_items).unique();
      this.sort(original_playlist, function(sorted) {
        return localStorage.original_playlist = JSON.stringify(sorted);
      });
      playlist = JSON.parse(localStorage.playlist);
      save_playlist = function(list) {
        playlist = playlist.concat(list).unique();
        localStorage.playlist = JSON.stringify(playlist);
        return callback();
      };
      if (cs.music_settings.shuffle) {
        new_items.shuffle();
        return save_playlist(new_items);
      } else {
        return this.sort(new_items, function(sorted) {
          return save_playlist(sorted);
        });
      }
    },
    clear: function() {
      delete localStorage.original_playlist;
      return this;
    },
    refresh: function(callback) {
      var playlist;
      callback = (callback || function() {}).bind(this);
      playlist = JSON.parse(localStorage.original_playlist || '[]');
      if (playlist.length) {
        if (cs.music_settings.shuffle) {
          playlist.shuffle();
        }
        localStorage.playlist = JSON.stringify(playlist);
        delete localStorage.position;
        callback(playlist);
      } else {
        music_library.get_all((function(_this) {
          return function(all) {
            var i, j, len, value;
            if (all.length) {
              for (i = j = 0, len = all.length; j < len; i = ++j) {
                value = all[i];
                all[i] = value.id;
              }
              return _this.set(all, callback);
            } else if (confirm(_('library-empty-want-to-rescan'))) {
              return $('body > [show]')[0].go_to_screen('library-rescan');
            }
          };
        })(this));
      }
    },
    sort: function(all, callback) {
      var count, get_next_item, index, list;
      index = 0;
      list = [];
      count = all.length;
      get_next_item = (function(_this) {
        return function() {
          var i, j, len, value;
          if (index < count) {
            return music_library.get_meta(all[index], function(data) {
              var artist_title;
              artist_title = [];
              if (data.artist) {
                artist_title.push(data.artist);
              }
              if (data.title) {
                artist_title.push(data.title);
              }
              artist_title = artist_title.join(' — ') || _('unknown');
              list.push({
                id: data.id,
                value: artist_title
              });
              data = null;
              artist_title = null;
              ++index;
              return get_next_item();
            });
          } else {
            list.sort(function(a, b) {
              a = a.value;
              b = b.value;
              if (a === b) {
                return 0;
              } else if (a < b) {
                return -1;
              } else {
                return 1;
              }
            });
            for (i = j = 0, len = list.length; j < len; i = ++j) {
              value = list[i];
              list[i] = value.id;
            }
            return callback(list);
          }
        };
      })(this);
      return get_next_item();
    }
  };

}).call(this);
