// Generated by CoffeeScript 1.9.3

/**
 * @package   CleverStyle Music
 * @category  app
 * @author    Nazar Mokrynskyi <nazar@mokrynskyi.com>
 * @copyright Copyright (c) 2014-2015, Nazar Mokrynskyi
 * @license   MIT License, see license.txt
 */

(function() {
  var storages;

  if (!navigator.getDeviceStorage) {
    return;
  }

  storages = navigator.getDeviceStorages('sdcard');

  cs.storage.scan = function(callback) {
    var files, scan_storages;
    files = [];
    scan_storages = (function(_this) {
      return function(storages, index) {
        var cursor, storage;
        if (!storages.length) {
          callback(files);
          return;
        }
        ++index;
        storage = storages.shift();
        cursor = storage.enumerate();
        cursor.onsuccess = function() {
          var file;
          if (cursor.result) {
            file = cursor.result;
            if (_this.known_extensions.indexOf(file.name.split('.').pop()) !== -1) {
              files.push('' + index + file.name);
            }
            return cursor["continue"]();
          } else {
            return scan_storages(storages, index);
          }
        };
        return cursor.onerror = function() {
          return scan_storages(storages, index);
        };
      };
    })(this);
    return scan_storages(storages.slice(), -1);
  };

  cs.storage.get = function(filename, success_callback, error_callback) {
    var index, result;
    if (error_callback == null) {
      error_callback = function() {};
    }
    index = filename.substr(0, 1);
    filename = filename.substr(1);
    result = storages[index].get(filename);
    result.onsuccess = function() {
      if (this.result) {
        return success_callback(this.result);
      }
    };
    return result.onerror = error_callback;
  };

}).call(this);
