
/* CloseTheBox 1.0 Web - Séraphin Hochart - 2012-2014 */

// GENERAL VARIABLES
var die1, die2;
var totaldice;
var totalgame = 0;
var canSelectTiles = false;
var selectedTiles = [0, 0];
var canRoll = true;
var activeTilesValues = new Array();
var a_possibilities = new Array();
var canPlaySound = true;

/* SOUND */

function playSound(type) {
	if (canPlaySound) {
		var sounds = {
			"newgame" : "../sounds/sound_newgame.ogg",
			"close" : "../sounds/sound_close"+(Math.floor(Math.random()*2)+1)+".ogg",
			"roll" : "../sounds/sound_roll"+(Math.floor(Math.random()*5)+1)+".ogg",
			"undo" : "../sounds/sound_undo.ogg"
		}

		console.log("Playing :" + sounds[type]);

		var audio = new Audio(sounds[type]); // buffers automatically when created
		audio.mozAudioChannelType = 'normal';
		audio.play();	
	}
}

function triggerSound() {
	canPlaySound = !canPlaySound;
	$(".sound").text((canPlaySound) ? "Sound on" : "Sound off");
	playSound("close");
}

/* GAME */

function roll() {
	// Main Roll Function of the Dice
	
	// Animate 1 - Big throw
	$(".die").addClass("animate1");
	randomizeDice();
	
	// Animate 2 - Rebound
	setTimeout(function() {
		
		$(".die").removeClass("animate1").addClass("animate2");
		randomizeDice();
		setTimeout(function() {
			
			// Animate 3 - Put dice back
			
			$(".die").removeClass("animate2");
			
			canSelectTiles = true;
			possibilities();

		}, 1200);
		
	}, 300);
}

function randomizeDice() {
	die1 = Math.floor(Math.random()*6)+1;
	die2 = Math.floor(Math.random()*6)+1;
	totaldice = die1 + die2;
	$("#die1").text(die1);
	$("#die2").text(die2);
	$("#die1").css('background-image', 'url("images/Dice'+die1+'.png")');
	$("#die2").css('background-image', 'url("images/Dice'+die2+'.png")');
}

function checkTotal(current) {
	// As soon as we click on a tile, check if we can continue.
	var currentSelection = parseFloat(selectedTiles[0]) + parseFloat(selectedTiles[1]);

	if (currentSelection == totaldice) {
		newRoll();
		$(current).removeClass("active").addClass("disabled");
		showFeedback("Good! Roll again.");
		checkClosedBox();
	} else {

		// If the first number we click is already too big, reset it
		// If we already tried two numbers and they don't match, reset these numbers.
		if ((selectedTiles[0] != 0 && selectedTiles[1] != 0) || selectedTiles[0] > totaldice) {
			// Reset
			$("#tile"+selectedTiles[0]).removeClass("disabled").addClass("active");
			$("#tile"+selectedTiles[1]).removeClass("disabled").addClass("active");
			selectedTiles[0] = 0;
			selectedTiles[1] = 0;
			playSound("undo");
			showFeedback("Not quite, try again");
		} else {
			$(current).removeClass("active").addClass("disabled");
			showFeedback("Keep going...");
		}
	}
}

function checkClosedBox() {
	totalgame = 0;
	var closed = false;
	$('.tile').each(function(index) {
		var add = ($(this).hasClass("disabled")) ? parseInt($(this).text()) : 0;
		totalgame += add;
	});
	if (totalgame == 45) {
		// Do something about it
		// OMFG YOU CLOSED THE BOX
		closed = true;
		showFeedback("");
		window.navigator.vibrate([150, 100, 150, 100, 150, 100, 150, 150, 100, 150, 500]);
		alert("OMFG YOU CLOSED THE BOX");
		finishedGame(true);
	}
  	return closed;
}

function newGame() {
	selectedTiles[0] = 0;
	selectedTiles[1] = 0;
	$("#roll").removeClass("none").addClass("block");
	canRoll = true;
	canSelectTiles = false;
	$(".tile").removeClass("disabled").addClass("active");
	$("#die1").text("");
	$("#die2").text("");
	showFeedback("New game! Good luck.");
	playSound("newgame");
	window.navigator.vibrate([150]);
}

function newRoll() {
	$("#roll").removeClass("none").addClass("block");
	canRoll = true;
	canSelectTiles = false;
	// Reset the temp values.
	selectedTiles[0] = 0;
	selectedTiles[1] = 0;

	checkClosedBox();
}

function possibilities() {
	// 1. Get the values of the tiles that are not down
	// 2. Check if one of the number is the total
	// 3. Iterate and add them 2 by 2. Multiply what we have between themselves, and get the results.
	// 4. Display the results.

	// 1. Get the values of the tiles that are not down
	// 2. Check if one of the number is the total

		activeTilesValues = new Array(); // Reset the var
		activeTilesValues.push(0);
		a_possibilities = new Array();

		var activeTiles = $(".tile.active");
		for (var i = 0 ; i < activeTiles.length; i++) {
			activeTilesValues.push(parseInt($(activeTiles[i]).text()));
		}

	// 3. Iterate and add them 2 by 2.
	// Multiply what we have between themselves, and get the results.
	// This is where the magic happends.

		//console.log("\nActive Tiles :"+activeTilesValues);

		activeTilesValues.map(function(firstTile){
			activeTilesValues.map(function(secondTile){

		 		if ((parseInt(firstTile) + parseInt(secondTile)) == totaldice) {
		 			if (parseInt(firstTile) != parseInt(secondTile)) {
		 				if (parseInt(firstTile) == 0) {
		 					a_possibilities.push(secondTile);
		 				} else if (parseInt(secondTile) == 0) {
		 					a_possibilities.push(firstTile);
		 				} else {
		 					a_possibilities.push(firstTile+" & "+secondTile);
		 				}
		 			}
		 		}
		 	});
		});

	// 4. Display the results
		console.log("Possibilities :"+a_possibilities);
		a_possibilities = a_possibilities.slice(0, a_possibilities.length/2);
		$("#possibilities").text(a_possibilities);

		if (a_possibilities.length == 0) {
			alert("No more possibilities! New Game.");
			finishedGame(false);
			newGame();
		}

		return a_possibilities;
}


/* jQUERY FUNCTIONS */
$(document).ready(function() {

	// PRELOAD IMAGES...
	// Array of images:
	var imageArray = [	'images/1closed.png', 'images/2closed.png', 'images/3closed.png',
						'images/4closed.png', 'images/5closed.png', 'images/6closed.png',
						'images/7closed.png', 'images/8closed.png', 'images/9closed.png',
						'images/Dice1.png', 'images/Dice2.png', 'images/Dice3.png',
						'images/Dice4.png', 'images/Dice5.png', 'images/Dice6.png'];
	 
	// Add hidden element
	var hidden = $('body').append('<div id="img-cache" style="display:none;" />').children('#img-cache');
	 
	// Add images to hidden element.
	$.each(imageArray, function (i, val) {
	  $('<img/>').attr('src', val).appendTo(hidden);
	});

	// HANDLE ACTIONS
	$("#roll").click(function() {
		if (canRoll) {
			playSound("roll");
			showFeedback("Select the first tile...");
			$("#roll").removeClass("block").addClass("none");
			canRoll = false;
			roll();
		}
	});

	$(".tile").click(function() {
		
		var canBeSelected = $(this).hasClass('active');
		var canBeRestored = ($(this).hasClass('disabled') && $(this).text() == selectedTiles[0]) ? true : false;

		// Put the content in the current tiles array.
		if (canBeSelected && canSelectTiles) {
			playSound("close");
			showFeedback("Keep going...");
			if (selectedTiles[0] == 0) {
				selectedTiles[0] = $(this).text();
			} else {
				selectedTiles[1] = $(this).text();
			}
			checkTotal(this);
		} else if (canBeRestored) {
			// Reset the previously clicked tiles
			playSound("undo");
			selectedTiles[0] = 0;
			selectedTiles[1] = 0;
			canSelectTiles = true;
			$(this).removeClass("disabled").addClass("active");
			showFeedback("Try again!");
		}

		// If not, do nothing.
	});
});

function scaleDivInParent(divSelector) {
	var div = $(divSelector)
	// heights need to be equal, calc the ratio to make it possible
	var scale = div.parent().height() / div.height();

	div.css('-webkit-transform', 'scale(' + scale + ')');
	div.css('-moz-transform', 'scale(' + scale + ')');
	
	// TODO : HORIZONTAL ALIGNMENT
	
}

function showFeedback(message) {

	$("#feedback").removeClass("visible").addClass("hidden");
	
	setTimeout(function() {
		$("#feedback").text(message);
		$("#feedback").removeClass("hidden").addClass("visible");
	}, 100);
}

$(window).load(function() {
	
	// ONCE EVERYTHING IS LOADED, SHOW THE BOX

	setTimeout(function() {
		$("p").removeClass("hidden").addClass("visible");
		$("h1").removeClass("hidden").addClass("visible");
		$("h2").removeClass("hidden").addClass("visible");
		$("a").removeClass("hidden").addClass("visible");

		$("#loader").removeClass("visible").addClass("hidden");
		$("#loading_text").removeClass("visible").addClass("hidden");

		setTimeout(function() {
			$("#box").removeClass("hidden").addClass("visible");
		}, 700);
	}, 1700);
	
	// Init layout
	scaleDivInParent("#box");
	scaleDivInParent("#menu_container");
	
	showFeedback("");
	playSound("newgame");
	
	//Enable swiping...
	$("#box, #roll").swipe( {
		swipe:function(event, direction, distance, duration, fingerCount) {
			if (direction == 'left') {
				console.log("Swipe!");
				$("#roll").trigger("click"); 
			}
		}
	});
});

$(window).resize(function() {
	scaleDivInParent("#box");
	scaleDivInParent("#menu_container");
});

/* Menu */
function showMenu() {
	playSound("close");
	$("body").addClass("show-menu");
}
function hideMenu() {
	playSound("undo");
	$("body").removeClass("show-menu");
}

function finishedGame(won) {
	// Create an iFrame, make it load, and close it
	// http://closetheboxapp.com/addGameWeb.php?closedBox=YES&name=Seraphin
	var url = "http://closethebox.phin.fr/addGameWeb.php?closedBox="+((won) ? "YES" : "NO") +"&name=FirefoxOS"
	console.log("Create iFrame :" + url);
	$("#iframes").append('<iframe src="'+url+'"></iframe>');
}
