var indexedDB = window.indexedDB || window.webkitIndexedDB || window.mozIndexedDB || window.msIndexedDB;
var IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction;
var db;


function initDb() {
    var request = indexedDB.open("CTWDB", 1);
    request.onsuccess = function(evt) {
        db = request.result;
    };

    request.onerror = function(evt) {
        console.log("IndexedDB error: " + evt.target.errorCode);
    };

    request.onupgradeneeded = function(evt) {
        var objectStore = evt.currentTarget.result.createObjectStore(
            "settings", {
                keyPath: "id",
                autoIncrement: true
            });

        objectStore.createIndex("sname", "sname", {
            unique: true
        });
        objectStore.createIndex("svalue", "svalue", {
            unique: false
        });

    };
}