$('#whole').split({
    orientation: 'vertical',
    limit: 300,
    refresh: true
});

$('#scriptarea').split({
    orientation: 'vertical',
    limit: 100,
    refresh: true
});

$('#hlfarea').split({
    orientation: 'horizontal',
    limit: 20,
    refresh: true
});



$(window).bind('resize', function() {
    // location.reload();
    $('#whole').split({
        orientation: 'vertical',
        limit: 300
    });

    $('#scriptarea').split({
        orientation: 'vertical',
        limit: 100
    });

    $('#hlfarea').split({
        orientation: 'horizontal',
        limit: 20
    });

});



$('.CodeMirror').each(function(i, el) {
    el.CodeMirror.refresh();
});

var e1 = CodeMirror.fromTextArea(document.getElementById("hcode"), {
    mode: "text/html",
    lineNumbers: true,
    styleActiveLine: true,
    matchBrackets: true,
    profile: 'xhtml',
    indentWithTabs: true
});

var e2 = CodeMirror.fromTextArea(document.getElementById("jcode"), {
    mode: "text/javascript",
    tabMode: "indent",
    lineNumbers: true,
    styleActiveLine: true,
    matchBrackets: true,
    tabSize: 4,
    indentUnit: 4,
    indentWithTabs: true
});

var e3 = CodeMirror.fromTextArea(document.getElementById("ccode"), {
    mode: "text/css",
    tabMode: "indent",
    lineNumbers: true,
    styleActiveLine: true,
    matchBrackets: true
});



/* AutoPreview*/

var delay;
e1.on("change", function() {
    if ($("#autoPreview").is(':checked')) {
        clearTimeout(delay);
        delay = setTimeout(convert, 300);
    }
});
setTimeout(convert, 300);




/* Execution Code*/

$('#execute').on("click", function() {
    convert()
});

function convert() {

    // console.log(e1);
    var htmlcode = e1.getValue();
    var csscode = "<style type=\"text/css\">" + e3.getValue() + "</style>";
    var jque = "<script src=\"js/jquery.js\" >";
    jque += "</" + "script" + ">";
    var jscode = "<script type=\"text/javascript\">" + e2.getValue() + "</" + "script" + ">";
    iframe1.document.close();


    if (e2.getValue() == "" && e3.getValue() == "") {
        iframe1.document.write(e1.getValue());
    } else {
        iframe1.document.write(htmlcode + jque + jscode);
        iframe1.document.getElementsByTagName("head")[0].innerHTML += csscode;
    }
}

/* AutoFormat Code*/

function autoFormatHtmlCode() {
    CodeMirror.commands["selectAll"](e1);
    var range = getSelectedRange(e1);
    e1.autoFormatRange(range.from, range.to);

}

function autoFormatCssCode() {
    CodeMirror.commands["selectAll"](e3);
    var range = getSelectedRange(e3);
    e3.autoFormatRange(range.from, range.to);

}

function autoFormatJsCode() {

    CodeMirror.commands["selectAll"](e2);
    var range = getSelectedRange(e2);
    e2.autoFormatRange(range.from, range.to);

}

function getSelectedRange(editorArea) {
    return {
        from: editorArea.getCursor(true),
        to: editorArea.getCursor(false)
    };
}


$("#autoFormatHtml").click(function() {
    autoFormatHtmlCode();
});
$("#autoFormatCss").click(function() {
    autoFormatCssCode();
});
$("#autoFormatJs").click(function() {
    autoFormatJsCode();
});


/* theming */
var input = document.getElementById("theme");

function selectTheme() {
    var theme = input.options[input.selectedIndex].innerHTML;
    e1.setOption("theme", theme);
    e2.setOption("theme", theme);
    e3.setOption("theme", theme);
}
var choice = document.location.search &&
    decodeURIComponent(document.location.search.slice(1));
if (choice) {
    input.value = choice;
    e1.setOption("theme", choice);
    e2.setOption("theme", choice);
    e3.setOption("theme", choice);
}

//Google Analytics

var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-33845418-1']);
_gaq.push(['_trackPageview']);


(function() {
    var ga = document.createElement('script');
    ga.type = 'text/javascript';
    ga.async = true;
    ga.src = 'https://ssl.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0];
    s.parentNode.insertBefore(ga, s);
})();


//social networks

$("#gplus").click(function() {
    popuper();
});
$("#fbook").click(function() {
    popuperf();
});
$("#tter").click(function() {
    popupert();
});

function popuper() {
    newwindow = window.open("https://plus.google.com/share?url=https://chrome.google.com/webstore/detail/pbinfbikhndabcdlabpcbhggkcdakgfg", 'Share in G+', 'height=640,width=480');
    if (window.focus) {
        newwindow.focus()
    }
    return false;

}

function popuperf() {
    newwindow = window.open("http://www.facebook.com/sharer.php?u=https://chrome.google.com/webstore/detail/pbinfbikhndabcdlabpcbhggkcdakgfg&t=Coding the web", 'Share in Fb+', 'height=640,width=480');
    if (window.focus) {
        newwindow.focus()
    }
    return false;

}
//http://twitter.com/home?status=https://chrome.google.com/webstore/detail/pbinfbikhndabcdlabpcbhggkcdakgfg&t=Coding the web
function popupert() {
    newwindow = window.open("http://twitter.com/home?status=https://chrome.google.com/webstore/detail/pbinfbikhndabcdlabpcbhggkcdakgfg", 'Share in twitter+', 'height=640,width=480');
    if (window.focus) {
        newwindow.focus()
    }
    return false;

}

/* Save workaround */

$('#hs').on("click", function() {
    saver()
});

function saver() {
    convert();
    console.log($('iframe').contents().html());
    console.log($('iframe').contents());
    $('#hs').attr({
        href: "data:text/plain,<html>" + $('iframe').contents().find("html").html() + "</html>"
    });
}




/**/

jQuery(document).ready(function($) {
    $('#slick').dcSlick();
});