var BACKGROUND_COLOR="#666";var MAX_STROBE_INTERVAL=1000;var MIN_STROBE_INTERVAL=50;var colorView;var switchView;var colorButton;var colorPicker;var strobeView;var strobeText;var soundSwitchView;var isLightOn=false;var lightColor;var screenWakeLock=null;var strobe=0;var strobeLightOn;var strobeTimerId;var isSoundEnabled;function onLoad(){colorView=document.querySelector("#colorView");switchView=document.querySelector("#switchView");colorButton=document.querySelector("#colorButton");strobeText=document.querySelector("#strobeText");soundSwitchView=document.querySelector("#soundSwitch");lightColor=ColorUtils.hexToRgb(Prefs.getInt(PREF_SCREEN_LIGHT_COLOR,16777215));setSoundEnabled(Prefs.getBoolean(PREF_SOUND_ON,true));Player.init();initUi();initHackyPixel();AnalyticsHelper.sendPageView(AnalyticsHelper.PAGE_HOME)}function initUi(){switchView.addEventListener("click",function(){isLightOn=!isLightOn;updateUi();Player.play(Player.CLICK)});colorPicker=new ColorPicker();colorPicker.setColor(lightColor);colorPicker.setOnColorChangedListener(onColorChanged);colorPicker.setTop(colorButton.getBoundingClientRect().bottom+8);addButtonPressedState(colorButton,function(){colorPicker.toggleVisibility();strobeView.hide()});strobeView=new StrobeView();strobeView.setOnStrobeChangedListener(function(a){strobeText.innerHTML=a;strobe=a});strobeText.addEventListener("click",function(){strobeView.toggleVisibility();colorPicker.hide()});strobeView.setTop(strobeText.getBoundingClientRect().bottom+8);if(!window.AudioContext){soundSwitchView.style.display="none"}soundSwitchView.addEventListener("click",function(){setSoundEnabled(!isSoundEnabled)});updateUi()}function updateUi(){if(isLightOn){strobeLightOn=false;colorRunnable();switchView.src="res/images/switch_on.png";switchView.classList.add("on");soundSwitchView.style.opacity=0;setButtonsScale(0.6);screenWakeLock=navigator.requestWakeLock("screen")}else{colorView.style.backgroundColor=BACKGROUND_COLOR;switchView.src="res/images/switch.png";switchView.classList.remove("on");soundSwitchView.style.opacity=1;setButtonsScale(1);if(screenWakeLock){screenWakeLock.unlock()}window.clearTimeout(strobeTimerId)}}function setButtonsScale(b){var a="scale("+b+")";colorButton.style.transform=a;strobeText.style.transform=a;colorButton.addEventListener("transitionend",function(){updateButtonPressedStatePosition(colorButton)})}function colorRunnable(){strobeLightOn=strobe>0?!strobeLightOn:true;colorView.style.backgroundColor=strobeLightOn?ColorUtils.rgbToCssRgb(lightColor):"#000";var b=MAX_STROBE_INTERVAL;if(strobe>0){var a=(MAX_STROBE_INTERVAL-MIN_STROBE_INTERVAL)/8;b=MIN_STROBE_INTERVAL+(9-strobe)*a}strobeTimerId=window.setTimeout(colorRunnable,b)}function onColorChanged(a){lightColor=a;Prefs.putValue(PREF_SCREEN_LIGHT_COLOR,ColorUtils.rgbToHex(lightColor));if(isLightOn&&strobeLightOn){colorView.style.backgroundColor=ColorUtils.rgbToCssRgb(lightColor)}}function addButtonPressedState(a,c){var b=document.createElement("span");document.body.appendChild(b);b.classList.add("pressedForeground");b.addEventListener("click",c);a.addEventListener("click",c);a.foreground=b;updateButtonPressedStatePosition(a)}function updateButtonPressedStatePosition(a){var c=a.foreground;var b=a.getBoundingClientRect();c.style.width=b.width+"px";c.style.height=b.height+"px";c.style.left=b.left+"px";c.style.top=b.top+"px"}function setSoundEnabled(a){isSoundEnabled=a;soundSwitchView.src=isSoundEnabled?"res/images/sound_on.png":"res/images/sound_off.png";Player.setSoundEnabled(isSoundEnabled);Prefs.putValue(PREF_SOUND_ON,isSoundEnabled)}function initHackyPixel(){var b=document.querySelector("#hackyPixel");var a=function(){b.style.opacity=0};document.addEventListener("visibilitychange",function(){if(!document.hidden){b.style.opacity=0.05;window.setTimeout(a,100)}})}function fixNames(){window.AudioContext=window.AudioContext||window.webkitAudioContext;if(!navigator.cancelAnimationFrame){navigator.cancelAnimationFrame=navigator.webkitCancelAnimationFrame||navigator.mozCancelAnimationFrame}if(!navigator.requestAnimationFrame){navigator.requestAnimationFrame=navigator.webkitRequestAnimationFrame||navigator.mozRequestAnimationFrame}}fixNames();window.onload=onLoad;